/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.query;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Weight;
import org.opensearch.neuralsearch.executors.HybridQueryExecutor;
import org.opensearch.neuralsearch.executors.HybridQueryExecutorCollector;
import org.opensearch.neuralsearch.executors.HybridQueryRewriteCollectorManager;
import org.opensearch.neuralsearch.query.HybridQueryContext;
import org.opensearch.neuralsearch.query.HybridQueryWeight;

public final class HybridQuery
extends Query
implements Iterable<Query> {
    private final List<Query> subQueries;
    private final HybridQueryContext queryContext;

    public HybridQuery(Collection<Query> subQueries, List<Query> filterQueries, HybridQueryContext hybridQueryContext) {
        Objects.requireNonNull(subQueries, "collection of queries must not be null");
        if (subQueries.isEmpty()) {
            throw new IllegalArgumentException("collection of queries must not be empty");
        }
        Integer paginationDepth = hybridQueryContext.getPaginationDepth();
        if (Objects.nonNull(paginationDepth) && paginationDepth == 0) {
            throw new IllegalArgumentException("pagination_depth must not be zero");
        }
        if (Objects.isNull(filterQueries) || filterQueries.isEmpty()) {
            this.subQueries = new ArrayList<Query>(subQueries);
        } else {
            ArrayList<Query> modifiedSubQueries = new ArrayList<Query>();
            for (Query subQuery : subQueries) {
                BooleanQuery.Builder builder = new BooleanQuery.Builder();
                builder.add(subQuery, BooleanClause.Occur.MUST);
                filterQueries.forEach(filterQuery -> builder.add(filterQuery, BooleanClause.Occur.FILTER));
                modifiedSubQueries.add((Query)builder.build());
            }
            this.subQueries = modifiedSubQueries;
        }
        this.queryContext = hybridQueryContext;
    }

    public HybridQuery(Collection<Query> subQueries, HybridQueryContext hybridQueryContext) {
        this(subQueries, List.of(), hybridQueryContext);
    }

    @Override
    public Iterator<Query> iterator() {
        return this.getSubQueries().iterator();
    }

    public String toString(String field) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("(");
        Iterator<Query> it = this.subQueries.iterator();
        int i = 0;
        while (it.hasNext()) {
            Query subquery = it.next();
            if (subquery instanceof BooleanQuery) {
                buffer.append("(");
                buffer.append(subquery.toString(field));
                buffer.append(")");
            } else {
                buffer.append(subquery.toString(field));
            }
            if (i != this.subQueries.size() - 1) {
                buffer.append(" | ");
            }
            ++i;
        }
        buffer.append(")");
        return buffer.toString();
    }

    public Query rewrite(IndexSearcher indexSearcher) throws IOException {
        if (this.subQueries.isEmpty()) {
            return new MatchNoDocsQuery("empty HybridQuery");
        }
        HybridQueryRewriteCollectorManager manager = new HybridQueryRewriteCollectorManager(indexSearcher);
        ArrayList<Callable<Void>> queryRewriteTasks = new ArrayList<Callable<Void>>();
        ArrayList<HybridQueryExecutorCollector<IndexSearcher, Map.Entry<Query, Boolean>>> collectors = new ArrayList<HybridQueryExecutorCollector<IndexSearcher, Map.Entry<Query, Boolean>>>();
        for (Query subQuery : this.subQueries) {
            HybridQueryExecutorCollector<IndexSearcher, Map.Entry<Query, Boolean>> collector = manager.newCollector();
            collectors.add(collector);
            queryRewriteTasks.add(() -> this.rewriteQuery(subQuery, collector));
        }
        HybridQueryExecutor.getExecutor().invokeAll(queryRewriteTasks);
        boolean isAnyQueryRewritten = manager.anyQueryRewrite(collectors);
        if (!isAnyQueryRewritten) {
            return super.rewrite(indexSearcher);
        }
        List<Query> rewrittenSubQueries = manager.getQueriesAfterRewrite(collectors);
        return new HybridQuery(rewrittenSubQueries, this.queryContext);
    }

    private Void rewriteQuery(Query query, HybridQueryExecutorCollector<IndexSearcher, Map.Entry<Query, Boolean>> collector) {
        collector.collect(indexSearcher -> {
            try {
                Query rewrittenQuery = query.rewrite(indexSearcher);
                boolean actuallyRewritten = rewrittenQuery != query;
                return new AbstractMap.SimpleEntry<Query, Boolean>(rewrittenQuery, actuallyRewritten);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        return null;
    }

    public void visit(QueryVisitor queryVisitor) {
        QueryVisitor v = queryVisitor.getSubVisitor(BooleanClause.Occur.SHOULD, (Query)this);
        for (Query q : this.subQueries) {
            q.visit(v);
        }
    }

    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((HybridQuery)this.getClass().cast(other));
    }

    private boolean equalsTo(HybridQuery other) {
        return Objects.equals(this.subQueries, other.subQueries);
    }

    public int hashCode() {
        int h = this.classHash();
        h = 31 * h + Objects.hashCode(this.subQueries);
        return h;
    }

    public Collection<Query> getSubQueries() {
        return Collections.unmodifiableCollection(this.subQueries);
    }

    public HybridQueryContext getQueryContext() {
        return this.queryContext;
    }

    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        return new HybridQueryWeight(this, searcher, scoreMode, boost);
    }
}

