/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.engine.faiss;

import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.opensearch.common.TriFunction;
import org.opensearch.knn.common.KNNConstants;
import org.opensearch.knn.index.SpaceType;
import org.opensearch.knn.index.VectorDataType;
import org.opensearch.knn.index.engine.DefaultIVFSearchContext;
import org.opensearch.knn.index.engine.Encoder;
import org.opensearch.knn.index.engine.KNNLibraryIndexingContext;
import org.opensearch.knn.index.engine.KNNMethodConfigContext;
import org.opensearch.knn.index.engine.MethodComponent;
import org.opensearch.knn.index.engine.MethodComponentContext;
import org.opensearch.knn.index.engine.Parameter;
import org.opensearch.knn.index.engine.faiss.AbstractFaissMethod;
import org.opensearch.knn.index.engine.faiss.FaissFlatEncoder;
import org.opensearch.knn.index.engine.faiss.FaissIVFPQEncoder;
import org.opensearch.knn.index.engine.faiss.FaissSQEncoder;
import org.opensearch.knn.index.engine.faiss.MethodAsMapBuilder;
import org.opensearch.knn.index.engine.faiss.QFrameBitEncoder;

public class FaissIVFMethod
extends AbstractFaissMethod {
    private static final Set<VectorDataType> SUPPORTED_DATA_TYPES = ImmutableSet.of((Object)((Object)VectorDataType.FLOAT), (Object)((Object)VectorDataType.BINARY), (Object)((Object)VectorDataType.BYTE));
    public static final List<SpaceType> SUPPORTED_SPACES = Arrays.asList(SpaceType.UNDEFINED, SpaceType.L2, SpaceType.INNER_PRODUCT, SpaceType.HAMMING, SpaceType.COSINESIMIL);
    private static final MethodComponentContext DEFAULT_ENCODER_CONTEXT = new MethodComponentContext("flat", Collections.emptyMap());
    static final Encoder FLAT_ENCODER = new FaissFlatEncoder();
    static final Encoder SQ_ENCODER = new FaissSQEncoder();
    static final Encoder IVF_PQ_ENCODER = new FaissIVFPQEncoder();
    static final Encoder QFRAME_BIT_ENCODER = new QFrameBitEncoder();
    static final Map<String, Encoder> SUPPORTED_ENCODERS = Map.of(FLAT_ENCODER.getName(), FLAT_ENCODER, SQ_ENCODER.getName(), SQ_ENCODER, IVF_PQ_ENCODER.getName(), IVF_PQ_ENCODER, QFRAME_BIT_ENCODER.getName(), QFRAME_BIT_ENCODER);
    static final MethodComponent IVF_COMPONENT = FaissIVFMethod.initMethodComponent();

    public FaissIVFMethod() {
        super(IVF_COMPONENT, Set.copyOf(SUPPORTED_SPACES), new DefaultIVFSearchContext());
    }

    private static MethodComponent initMethodComponent() {
        return MethodComponent.Builder.builder("ivf").addSupportedDataTypes(SUPPORTED_DATA_TYPES).addParameter("nprobes", new Parameter.IntegerParameter("nprobes", KNNConstants.METHOD_PARAMETER_NPROBES_DEFAULT, (v, context) -> v > 0 && v < KNNConstants.METHOD_PARAMETER_NPROBES_LIMIT)).addParameter("nlist", new Parameter.IntegerParameter("nlist", KNNConstants.METHOD_PARAMETER_NLIST_DEFAULT, (v, context) -> v > 0 && v < KNNConstants.METHOD_PARAMETER_NLIST_LIMIT)).addParameter("encoder", FaissIVFMethod.initEncoderParameter()).setRequiresTraining(true).setKnnLibraryIndexingContextGenerator((TriFunction<MethodComponent, MethodComponentContext, KNNMethodConfigContext, KNNLibraryIndexingContext>)((TriFunction)(methodComponent, methodComponentContext, knnMethodConfigContext) -> {
            MethodAsMapBuilder methodAsMapBuilder = MethodAsMapBuilder.builder("IVF", methodComponent, methodComponentContext, knnMethodConfigContext).addParameter("nlist", "", "").addParameter("encoder", ",", "");
            return FaissIVFMethod.adjustIndexDescription(methodAsMapBuilder, methodComponentContext, knnMethodConfigContext);
        })).setOverheadInKBEstimator((TriFunction<MethodComponent, MethodComponentContext, Integer, Long>)((TriFunction)(methodComponent, methodComponentContext, dimension) -> {
            Object nlistObject = methodComponentContext.getParameters().get("nlist");
            if (nlistObject == null) {
                Parameter<?> nlistParameter = methodComponent.getParameters().get("nlist");
                if (nlistParameter == null) {
                    throw new IllegalStateException(String.format("%s  is not a valid parameter. This is a bug.", "nlist"));
                }
                nlistObject = nlistParameter.getDefaultValue();
            }
            if (!(nlistObject instanceof Integer)) {
                throw new IllegalStateException(String.format("%s must be an integer.", "nlist"));
            }
            int centroids = (Integer)nlistObject;
            return 4L * (long)centroids * (long)dimension.intValue() / (long)KNNConstants.BYTES_PER_KILOBYTES.intValue() + 1L;
        })).build();
    }

    private static Parameter.MethodComponentContextParameter initEncoderParameter() {
        return new Parameter.MethodComponentContextParameter("encoder", DEFAULT_ENCODER_CONTEXT, SUPPORTED_ENCODERS.values().stream().collect(Collectors.toMap(Encoder::getName, Encoder::getMethodComponent)));
    }
}

