/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.ml;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.opensearch.ad.model.AnomalyDetector;
import org.opensearch.ad.model.AnomalyResult;
import org.opensearch.ad.model.Rule;
import org.opensearch.timeseries.ml.IntermediateResult;
import org.opensearch.timeseries.model.Config;
import org.opensearch.timeseries.model.Entity;
import org.opensearch.timeseries.model.FeatureData;

public class ThresholdingResult
extends IntermediateResult<AnomalyResult> {
    private final double grade;
    private int relativeIndex;
    private double[] relevantAttribution;
    private double[] pastValues;
    private double[][] expectedValuesList;
    private double[] likelihoodOfValues;
    private double threshold;
    private int forestSize;
    protected final double confidence;
    private double[] currentData;
    private boolean[] featureImputed;

    public ThresholdingResult(double grade, double confidence, double rcfScore) {
        this(grade, confidence, rcfScore, 0L, 0, null, null, null, null, 0.0, 0, null, null);
    }

    public ThresholdingResult(double grade, double confidence, double rcfScore, long totalUpdates, int relativeIndex, double[] relevantAttribution, double[] pastValues, double[][] expectedValuesList, double[] likelihoodOfValues, double threshold, int forestSize, double[] currentData, boolean[] featureImputed) {
        super(totalUpdates, rcfScore);
        this.confidence = confidence;
        this.grade = grade;
        this.relativeIndex = relativeIndex;
        this.relevantAttribution = relevantAttribution;
        this.pastValues = pastValues;
        this.expectedValuesList = expectedValuesList;
        this.likelihoodOfValues = likelihoodOfValues;
        this.threshold = threshold;
        this.forestSize = forestSize;
        this.currentData = currentData;
        this.featureImputed = featureImputed;
    }

    public double getConfidence() {
        return this.confidence;
    }

    public double getGrade() {
        return this.grade;
    }

    public int getRelativeIndex() {
        return this.relativeIndex;
    }

    public double[] getRelevantAttribution() {
        return this.relevantAttribution;
    }

    public double[] getPastValues() {
        return this.pastValues;
    }

    public double[][] getExpectedValuesList() {
        return this.expectedValuesList;
    }

    public double[] getLikelihoodOfValues() {
        return this.likelihoodOfValues;
    }

    public double getThreshold() {
        return this.threshold;
    }

    public int getForestSize() {
        return this.forestSize;
    }

    public double[] getCurrentData() {
        return this.currentData;
    }

    public boolean isFeatureImputed(int i) {
        return this.featureImputed[i];
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        ThresholdingResult that = (ThresholdingResult)o;
        return Double.doubleToLongBits(this.confidence) == Double.doubleToLongBits(that.confidence) && Double.doubleToLongBits(this.grade) == Double.doubleToLongBits(that.grade) && this.relativeIndex == that.relativeIndex && Arrays.equals(this.relevantAttribution, that.relevantAttribution) && Arrays.equals(this.pastValues, that.pastValues) && Arrays.deepEquals((Object[])this.expectedValuesList, (Object[])that.expectedValuesList) && Arrays.equals(this.likelihoodOfValues, that.likelihoodOfValues) && Double.doubleToLongBits(this.threshold) == Double.doubleToLongBits(that.threshold) && this.forestSize == that.forestSize && Arrays.equals(this.currentData, that.currentData) && Arrays.equals(this.featureImputed, that.featureImputed);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.confidence, this.grade, this.relativeIndex, Arrays.hashCode(this.relevantAttribution), Arrays.hashCode(this.pastValues), Arrays.deepHashCode((Object[])this.expectedValuesList), Arrays.hashCode(this.likelihoodOfValues), this.threshold, this.forestSize, Arrays.hashCode(this.currentData), Arrays.hashCode(this.featureImputed));
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).append((Object)super.toString()).append("grade", this.grade).append("confidence", this.confidence).append("relativeIndex", this.relativeIndex).append("relevantAttribution", (Object)Arrays.toString(this.relevantAttribution)).append("pastValues", (Object)Arrays.toString(this.pastValues)).append("expectedValuesList", (Object)Arrays.deepToString((Object[])this.expectedValuesList)).append("likelihoodOfValues", (Object)Arrays.toString(this.likelihoodOfValues)).append("threshold", this.threshold).append("forestSize", this.forestSize).append("currentData", (Object)Arrays.toString(this.currentData)).append("featureImputed", (Object)Arrays.toString(this.featureImputed)).toString();
    }

    @Override
    public List<AnomalyResult> toIndexableResults(Config detector, Instant dataStartInstant, Instant dataEndInstant, Instant executionStartInstant, Instant executionEndInstant, List<FeatureData> featureData, Optional<Entity> entity, Integer schemaVersion, String modelId, String taskId, String error) {
        ArrayList<Rule> rules = new ArrayList();
        if (detector instanceof AnomalyDetector) {
            AnomalyDetector detectorConfig = (AnomalyDetector)detector;
            rules = detectorConfig.getRules();
        }
        return Collections.singletonList(AnomalyResult.fromRawTRCFResult(detector.getId(), detector.getIntervalInMilliseconds(), taskId, this.rcfScore, this.grade, this.confidence, featureData, dataStartInstant, dataEndInstant, executionStartInstant, executionEndInstant, error, entity, detector.getUser(), schemaVersion, modelId, this.relevantAttribution, this.relativeIndex, this.pastValues, this.expectedValuesList, this.likelihoodOfValues, this.threshold, this.currentData, this.featureImputed, rules));
    }
}

