/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.io.File;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.Timer;
import mediathek.config.MVConfig;
import mediathek.tool.FilmListUpdateType;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuiFunktionen {
    private static final int UPDATE_FILME_AUS = 0;
    private static final int UPDATE_FILME_AUTO = 2;
    private static final Logger logger = LogManager.getLogger();
    private static final String EXTERNAL_UPDATE_PROPERTY = "externalUpdateCheck";

    public static boolean isNotUsingExternalUpdater() {
        String externalUpdateCheck = System.getProperty(EXTERNAL_UPDATE_PROPERTY);
        boolean ret = false;
        if (externalUpdateCheck != null && (externalUpdateCheck.equalsIgnoreCase("true") || externalUpdateCheck.isEmpty())) {
            ret = true;
        }
        return !ret;
    }

    public static int createDismissableMessageDialog(@Nullable Component parentComponent, @NotNull String title, @NotNull String message, int optionType, int defaultValue, int defaultDelay, @NotNull TimeUnit timeUnit, int style) {
        JOptionPane op = new JOptionPane(message, style, optionType, null, null);
        JDialog dialog = op.createDialog(parentComponent, title);
        new Timer((int)TimeUnit.MILLISECONDS.convert(defaultDelay, timeUnit), e -> op.setValue(defaultValue)).start();
        dialog.setVisible(true);
        return (Integer)op.getValue();
    }

    public static void showErrorIndication(@NotNull JComponent component, boolean hasError) {
        if (hasError) {
            component.putClientProperty("JComponent.outline", "error");
        } else {
            component.putClientProperty("JComponent.outline", "");
        }
    }

    public static boolean isUsingExternalUpdater() {
        return !GuiFunktionen.isNotUsingExternalUpdater();
    }

    public static Dimension calculateFittedDimension(Dimension imgSize, Dimension boundary) {
        int original_width = imgSize.width;
        int original_height = imgSize.height;
        int bound_width = boundary.width;
        int bound_height = boundary.height;
        int new_width = original_width;
        int new_height = original_height;
        if (original_width > bound_width) {
            new_width = bound_width;
            new_height = new_width * original_height / original_width;
        }
        if (new_height > bound_height) {
            new_height = bound_height;
            new_width = new_height * original_width / original_height;
        }
        return new Dimension(new_width, new_height);
    }

    public static void copyToClipboard(@NotNull String s) {
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(s), null);
    }

    public static void centerOnScreen(Component c, boolean absolute) {
        int width = c.getWidth();
        int height = c.getHeight();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int x = screenSize.width / 2 - width / 2;
        int y = screenSize.height / 2 - height / 2;
        if (!absolute) {
            x /= 2;
            y /= 2;
        }
        c.setLocation(x, y);
    }

    @Deprecated
    public static boolean setSize(MVConfig.Configs nr, JDialog jDialog, Frame relativFrame) {
        boolean ret = false;
        int breite = 0;
        int hoehe = 0;
        int posX = 0;
        int posY = 0;
        String[] arr = MVConfig.get(nr).split(":");
        try {
            if (arr.length == 4) {
                breite = Integer.parseInt(arr[0]);
                hoehe = Integer.parseInt(arr[1]);
                posX = Integer.parseInt(arr[2]);
                posY = Integer.parseInt(arr[3]);
            }
        }
        catch (Exception ex) {
            breite = 0;
            hoehe = 0;
            posX = 0;
            posY = 0;
        }
        if (breite > 0 && hoehe > 0) {
            jDialog.setSize(new Dimension(breite, hoehe));
            ret = true;
        }
        if (posX > 0 && posY > 0) {
            jDialog.setLocation(posX, posY);
        } else if (relativFrame != null) {
            jDialog.setLocationRelativeTo(relativFrame);
        }
        return ret;
    }

    public static String addsPfad(String pfad1, String pfad2) {
        String ret = GuiFunktionen.concatPaths(pfad1, pfad2);
        if (ret.isEmpty()) {
            logger.error("addsPfad({},{}):", (Object)pfad1, (Object)pfad2);
        }
        return ret;
    }

    public static String concatPaths(String pfad1, String pfad2) {
        if (pfad1 == null || pfad2 == null) {
            return "";
        }
        if (pfad1.isEmpty() || pfad2.isEmpty()) {
            return pfad1 + pfad2;
        }
        Object ret = pfad1.endsWith(File.separator) ? pfad1.substring(0, pfad1.length() - 1) : pfad1;
        ret = pfad2.charAt(0) == File.separatorChar ? (String)ret + pfad2 : (String)ret + File.separator + pfad2;
        return ret;
    }

    public static String cutName(String name, int length) {
        if (((String)name).length() > length) {
            name = ((String)name).substring(0, length - 4) + ((String)name).substring(((String)name).length() - 4);
        }
        return name;
    }

    public static String getDateiName(String pfad) {
        String ret = "";
        if (pfad != null && !pfad.isEmpty()) {
            ret = pfad.substring(pfad.lastIndexOf(47) + 1);
        }
        if (ret.contains("?")) {
            ret = ret.substring(0, ret.indexOf(63));
        }
        if (ret.contains("&")) {
            ret = ret.substring(0, ret.indexOf(38));
        }
        if (ret.isEmpty()) {
            logger.error("getDateiName({})", (Object)pfad);
        }
        return ret;
    }

    public static String getSuffixFromUrl(String pfad) {
        String ret = "";
        if (pfad != null && !pfad.isEmpty() && pfad.contains(".")) {
            ret = pfad.substring(pfad.lastIndexOf(46) + 1);
        }
        if (ret.isEmpty()) {
            logger.error("getSuffixFromUrl({})", (Object)pfad);
        }
        if (ret.contains("?")) {
            ret = ret.substring(0, ret.indexOf(63));
        }
        if (ret.length() > 5) {
            ret = "---";
            logger.error("getSuffixFromUrl({})", (Object)pfad);
        }
        return ret;
    }

    public static String getFileNameWithoutExtension(@NotNull String fileName) {
        return Optional.of(fileName.lastIndexOf(46)).filter(i -> i >= 0).filter(i -> i > fileName.lastIndexOf(File.separator)).map(i -> fileName.substring(0, (int)i)).orElse(fileName);
    }

    public static int getPlatformControlKey() {
        int result2 = SystemUtils.IS_OS_MAC_OSX ? 256 : 128;
        return result2;
    }

    public static FilmListUpdateType getFilmListUpdateType() {
        int ret;
        try {
            ret = Integer.parseInt(MVConfig.get(MVConfig.Configs.SYSTEM_IMPORT_ART_FILME));
        }
        catch (Exception ex) {
            MVConfig.add(MVConfig.Configs.SYSTEM_IMPORT_ART_FILME, String.valueOf(2));
            ret = 2;
        }
        FilmListUpdateType result2 = ret == 0 ? FilmListUpdateType.MANUAL : FilmListUpdateType.AUTOMATIC;
        return result2;
    }

    public static void setFilmListUpdateType(FilmListUpdateType type) {
        int value = type == FilmListUpdateType.MANUAL ? 0 : 2;
        MVConfig.add(MVConfig.Configs.SYSTEM_IMPORT_ART_FILME, String.valueOf(value));
    }

    public static void enableComponents(Container container, boolean enable) {
        Component[] components;
        for (Component component : components = container.getComponents()) {
            component.setEnabled(enable);
            if (!(component instanceof Container)) continue;
            GuiFunktionen.enableComponents((Container)component, enable);
        }
    }
}

