/*
 * Decompiled with CFR 0.152.
 */
package sun.management.jdp;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import sun.management.jdp.JdpException;
import sun.management.jdp.JdpGenericPacket;
import sun.management.jdp.JdpPacket;
import sun.management.jdp.JdpPacketReader;
import sun.management.jdp.JdpPacketWriter;

public final class JdpJmxPacket
extends JdpGenericPacket
implements JdpPacket {
    public static final String UUID_KEY = "DISCOVERABLE_SESSION_UUID";
    public static final String MAIN_CLASS_KEY = "MAIN_CLASS";
    public static final String JMX_SERVICE_URL_KEY = "JMX_SERVICE_URL";
    public static final String INSTANCE_NAME_KEY = "INSTANCE_NAME";
    private UUID id;
    private String mainClass;
    private String jmxServiceUrl;
    private String instanceName;

    public JdpJmxPacket(UUID id, String jmxServiceUrl) {
        this.id = id;
        this.jmxServiceUrl = jmxServiceUrl;
    }

    public JdpJmxPacket(byte[] data) throws JdpException {
        JdpPacketReader reader = new JdpPacketReader(data);
        Map<String, String> p = reader.getDiscoveryDataAsMap();
        String sId = p.get(UUID_KEY);
        this.id = sId == null ? null : UUID.fromString(sId);
        this.jmxServiceUrl = p.get(JMX_SERVICE_URL_KEY);
        this.mainClass = p.get(MAIN_CLASS_KEY);
        this.instanceName = p.get(INSTANCE_NAME_KEY);
    }

    public void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public UUID getId() {
        return this.id;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public String getJmxServiceUrl() {
        return this.jmxServiceUrl;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    @Override
    public byte[] getPacketData() throws IOException {
        JdpPacketWriter writer = new JdpPacketWriter();
        writer.addEntry(UUID_KEY, this.id == null ? null : this.id.toString());
        writer.addEntry(MAIN_CLASS_KEY, this.mainClass);
        writer.addEntry(JMX_SERVICE_URL_KEY, this.jmxServiceUrl);
        writer.addEntry(INSTANCE_NAME_KEY, this.instanceName);
        return writer.getPacketBytes();
    }

    public int hashCode() {
        int hash = 1;
        hash = hash * 31 + this.id.hashCode();
        hash = hash * 31 + this.jmxServiceUrl.hashCode();
        return hash;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof JdpJmxPacket)) {
            return false;
        }
        JdpJmxPacket p = (JdpJmxPacket)o;
        return Objects.equals(this.id, p.getId()) && Objects.equals(this.jmxServiceUrl, p.getJmxServiceUrl());
    }
}

