/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml.refs;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

final class JavaFxLocationReferenceProvider
extends PsiReferenceProvider {
    private final boolean mySupportCommaInValue;
    private final Set<String> myAcceptedFileTypes;

    JavaFxLocationReferenceProvider() {
        this(false, new String[0]);
    }

    JavaFxLocationReferenceProvider(boolean supportCommaInValue, String ... acceptedFileExtensions) {
        this.mySupportCommaInValue = supportCommaInValue;
        this.myAcceptedFileTypes = ContainerUtil.newHashSet((Object[])acceptedFileExtensions);
    }

    public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            JavaFxLocationReferenceProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            JavaFxLocationReferenceProvider.$$$reportNull$$$0(1);
        }
        String value = ((XmlAttributeValue)element).getValue();
        if (this.mySupportCommaInValue && value.contains(",")) {
            int startIdx = 0;
            ArrayList refs = new ArrayList();
            while (true) {
                int endIdx;
                String item = (endIdx = value.indexOf(44, startIdx)) >= 0 ? value.substring(startIdx, endIdx) : value.substring(startIdx);
                Collections.addAll(refs, this.collectRefs(element, item, startIdx + 1));
                if (endIdx < 0) break;
                startIdx = endIdx + 1;
            }
            PsiReference[] psiReferenceArray = refs.toArray(PsiReference.EMPTY_ARRAY);
            if (psiReferenceArray == null) {
                JavaFxLocationReferenceProvider.$$$reportNull$$$0(2);
            }
            return psiReferenceArray;
        }
        PsiReference[] psiReferenceArray = this.collectRefs(element, value, 1);
        if (psiReferenceArray == null) {
            JavaFxLocationReferenceProvider.$$$reportNull$$$0(3);
        }
        return psiReferenceArray;
    }

    private PsiReference[] collectRefs(@NotNull PsiElement element, String value, int startInElement) {
        int atSignIndex;
        if (element == null) {
            JavaFxLocationReferenceProvider.$$$reportNull$$$0(4);
        }
        if ((atSignIndex = value.indexOf(64)) >= 0 && (atSignIndex == 0 || StringUtil.trimLeading((String)value).startsWith("@"))) {
            value = value.substring(atSignIndex + 1);
            startInElement += atSignIndex + 1;
        }
        FileReferenceSet set = new FileReferenceSet(value, element, startInElement, null, true){

            protected Condition<PsiFileSystemItem> getReferenceCompletionFilter() {
                return item -> {
                    if (item instanceof PsiDirectory) {
                        return true;
                    }
                    VirtualFile virtualFile = item.getVirtualFile();
                    if (virtualFile == null) {
                        return false;
                    }
                    return JavaFxLocationReferenceProvider.this.myAcceptedFileTypes.contains(virtualFile.getExtension());
                };
            }
        };
        if (value.startsWith("/")) {
            set.addCustomization(FileReferenceSet.DEFAULT_PATH_EVALUATOR_OPTION, (Object)FileReferenceSet.ABSOLUTE_TOP_LEVEL);
        }
        return set.getAllReferences();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxLocationReferenceProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxLocationReferenceProvider";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectRefs";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

