/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.util.progress.RawProgressReporter;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.extension.kotlin.ContextExtensionsKt;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.EmptyCoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectChangesBuilder;
import org.jetbrains.idea.maven.project.MavenProjectReader;
import org.jetbrains.idea.maven.project.MavenProjectReaderResult;
import org.jetbrains.idea.maven.project.MavenProjectTimestamp;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.project.MavenProjectsTreeUpdateContext;
import org.jetbrains.idea.maven.project.MavenProjectsTreeUpdater;
import org.jetbrains.idea.maven.project.MavenSettingsCache;
import org.jetbrains.idea.maven.telemetry.TelemetryKt;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenUtil;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0010\u001e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\b\u0001\u0018\u00002\u00020\u0001:\u00018B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0018\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u000bH\u0002J\u001e\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u000bH\u0082@\u00a2\u0006\u0002\u0010\u001bJ\u0016\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u0012H\u0082@\u00a2\u0006\u0002\u0010\u001eJ,\u0010\u001f\u001a\u00020 2\u0006\u0010\u001a\u001a\u00020\u00122\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00120\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00100\"H\u0002J\u001e\u0010$\u001a\u00020 2\u0006\u0010\u001a\u001a\u00020\u00122\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00100\"H\u0002J$\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00100\"2\u0006\u0010\u001a\u001a\u00020\u00122\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00100\"H\u0002J$\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00100\"2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00100\"2\u0006\u0010)\u001a\u00020\u000bH\u0002J$\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00100\"2\u0006\u0010\u001a\u001a\u00020\u00122\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00120,H\u0002J\u0010\u0010-\u001a\u00020\u00122\u0006\u0010.\u001a\u00020\u0010H\u0002J\u001e\u0010/\u001a\u00020 2\u0006\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u000bH\u0082@\u00a2\u0006\u0002\u00100J\u001c\u00101\u001a\u00020 2\f\u00102\u001a\b\u0012\u0004\u0012\u0002030\"H\u0086@\u00a2\u0006\u0002\u00104J\u0012\u00105\u001a\u0002062\b\u00107\u001a\u0004\u0018\u00010\u0010H\u0002J\u0012\u00105\u001a\u0002062\b\u00107\u001a\u0004\u0018\u00010\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u000b0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00120\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lorg/jetbrains/idea/maven/project/MavenProjectsTreeUpdater;", "", "tree", "Lorg/jetbrains/idea/maven/project/MavenProjectsTree;", "updateContext", "Lorg/jetbrains/idea/maven/project/MavenProjectsTreeUpdateContext;", "reader", "Lorg/jetbrains/idea/maven/project/MavenProjectReader;", "process", "Lcom/intellij/platform/util/progress/RawProgressReporter;", "updateModules", "", "<init>", "(Lorg/jetbrains/idea/maven/project/MavenProjectsTree;Lorg/jetbrains/idea/maven/project/MavenProjectsTreeUpdateContext;Lorg/jetbrains/idea/maven/project/MavenProjectReader;Lcom/intellij/platform/util/progress/RawProgressReporter;Z)V", "updated", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/openapi/vfs/VirtualFile;", "createdMavenProjects", "Lorg/jetbrains/idea/maven/project/MavenProject;", "userSettingsFile", "Ljava/nio/file/Path;", "globalSettingsFile", "startUpdate", "mavenProjectFile", "forceRead", "readPomIfNeeded", "mavenProject", "(Lorg/jetbrains/idea/maven/project/MavenProject;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "calculateTimestamp", "Lorg/jetbrains/idea/maven/project/MavenProjectTimestamp;", "(Lorg/jetbrains/idea/maven/project/MavenProject;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "handleRemovedModules", "", "prevModules", "", "existingModuleFiles", "reconnectModuleFiles", "modulesFilesToReconnect", "collectModuleFilesToReconnect", "collectModuleFilesToUpdate", "moduleFilesToReconnect", "updateExistingModules", "collectChildFilesToUpdate", "prevChildren", "", "findOrCreateProject", "f", "update", "(Lcom/intellij/openapi/vfs/VirtualFile;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateProjects", "specs", "Lorg/jetbrains/idea/maven/project/MavenProjectsTreeUpdater$UpdateSpec;", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getFileTimestamp", "", "file", "UpdateSpec", "intellij.maven"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nMavenProjectsTreeUpdater.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenProjectsTreeUpdater.kt\norg/jetbrains/idea/maven/project/MavenProjectsTreeUpdater\n+ 2 trace.kt\ncom/intellij/platform/diagnostic/telemetry/helpers/TraceKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,277:1\n49#2,6:278\n87#2,2:284\n56#2,3:286\n98#2:289\n90#2,6:290\n774#3:296\n865#3,2:297\n774#3:299\n865#3,2:300\n1563#3:302\n1634#3,3:303\n1563#3:306\n1634#3,3:307\n1563#3:310\n1634#3,3:311\n*S KotlinDebug\n*F\n+ 1 MavenProjectsTreeUpdater.kt\norg/jetbrains/idea/maven/project/MavenProjectsTreeUpdater\n*L\n70#1:278,6\n70#1:284,2\n70#1:286,3\n70#1:289\n70#1:290,6\n121#1:296\n121#1:297,2\n171#1:299\n171#1:300,2\n178#1:302\n178#1:303,3\n226#1:306\n226#1:307,3\n237#1:310\n237#1:311,3\n*E\n"})
public final class MavenProjectsTreeUpdater {
    @NotNull
    private final MavenProjectsTree tree;
    @NotNull
    private final MavenProjectsTreeUpdateContext updateContext;
    @NotNull
    private final MavenProjectReader reader;
    @Nullable
    private final RawProgressReporter process;
    private final boolean updateModules;
    @NotNull
    private final ConcurrentHashMap<VirtualFile, Boolean> updated;
    @NotNull
    private final ConcurrentHashMap<VirtualFile, MavenProject> createdMavenProjects;
    @NotNull
    private final Path userSettingsFile;
    @Nullable
    private final Path globalSettingsFile;

    public MavenProjectsTreeUpdater(@NotNull MavenProjectsTree tree, @NotNull MavenProjectsTreeUpdateContext updateContext, @NotNull MavenProjectReader reader, @Nullable RawProgressReporter process2, boolean updateModules) {
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        Intrinsics.checkNotNullParameter((Object)updateContext, (String)"updateContext");
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        this.tree = tree;
        this.updateContext = updateContext;
        this.reader = reader;
        this.process = process2;
        this.updateModules = updateModules;
        this.updated = new ConcurrentHashMap();
        this.createdMavenProjects = new ConcurrentHashMap();
        this.userSettingsFile = MavenSettingsCache.Companion.getInstance(this.tree.getProject()).getEffectiveUserSettingsFile();
        this.globalSettingsFile = MavenSettingsCache.Companion.getInstance(this.tree.getProject()).getEffectiveGlobalSettingsFile();
    }

    private final boolean startUpdate(VirtualFile mavenProjectFile, boolean forceRead) {
        block2: {
            String string = mavenProjectFile.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            String projectPath = string;
            if (this.tree.isIgnored(projectPath)) {
                MavenLog.LOG.trace("Won't update ignored file " + mavenProjectFile);
                return false;
            }
            Ref previousUpdateRef = new Ref();
            this.updated.compute(mavenProjectFile, (arg_0, arg_1) -> MavenProjectsTreeUpdater.startUpdate$lambda$1((arg_0, arg_1) -> MavenProjectsTreeUpdater.startUpdate$lambda$0(previousUpdateRef, forceRead, arg_0, arg_1), arg_0, arg_1));
            Boolean previousUpdate = (Boolean)previousUpdateRef.get();
            if (previousUpdate != null && !forceRead || Intrinsics.areEqual((Object)true, (Object)previousUpdate)) {
                MavenLog.LOG.trace("Has already been updated (" + previousUpdate + "): " + mavenProjectFile + "; forceRead: " + forceRead);
                return false;
            }
            RawProgressReporter rawProgressReporter = this.process;
            if (rawProgressReporter == null) break block2;
            Object[] objectArray = new Object[]{projectPath};
            rawProgressReporter.text(MavenProjectBundle.message("maven.reading.pom", objectArray));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final Object readPomIfNeeded(MavenProject mavenProject, boolean forceRead, Continuation<? super Boolean> $completion) {
        if (!($completion instanceof readPomIfNeeded.1)) ** GOTO lbl-1000
        var20_4 = $completion;
        if ((var20_4.label & -2147483648) != 0) {
            var20_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                Object L$7;
                boolean Z$0;
                int I$0;
                int I$1;
                int I$2;
                int I$3;
                int I$4;
                /* synthetic */ Object result;
                final /* synthetic */ MavenProjectsTreeUpdater this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return MavenProjectsTreeUpdater.access$readPomIfNeeded(this.this$0, null, false, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var21_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = mavenProject;
                $continuation.Z$0 = forceRead;
                $continuation.label = 1;
                v0 = this.calculateTimestamp(mavenProject, (Continuation<? super MavenProjectTimestamp>)$continuation);
                if (v0 == var21_6) {
                    return var21_6;
                }
                ** GOTO lbl24
            }
            case 1: {
                forceRead = $continuation.Z$0;
                mavenProject = (MavenProject)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl24:
                // 2 sources

                timeStampChanged = Intrinsics.areEqual((Object)(timestamp = (MavenProjectTimestamp)v0), (Object)this.tree.getTimeStamp$intellij_maven(mavenProject)) == false ? 1 : 0;
                v1 = readPom = forceRead != false || timeStampChanged != 0 ? 1 : 0;
                if (readPom == 0) ** GOTO lbl136
                oldProjectId = mavenProject.isNew() != false ? null : mavenProject.getMavenId();
                oldParentId = mavenProject.getParentId();
                v2 = TelemetryKt.getTracer().spanBuilder("readPom");
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"spanBuilder(...)");
                $this$useWithScope_u24default$iv = v2;
                context$iv = (CoroutineContext)EmptyCoroutineContext.INSTANCE;
                $i$f$useWithScope = 0;
                v3 = $this$useWithScope_u24default$iv.startSpan();
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"startSpan(...)");
                $this$useWithoutActiveScope$iv$iv = v3;
                $i$f$useWithoutActiveScope = 0;
                span$iv = $this$useWithoutActiveScope$iv$iv;
                $i$a$-useWithoutActiveScope-TraceKt$useWithScope$2$iv = 0;
                v4 = Context.current().with((ImplicitContextKeyed)span$iv);
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"with(...)");
                $continuation.L$0 = mavenProject;
                $continuation.L$1 = timestamp;
                $continuation.L$2 = oldProjectId;
                $continuation.L$3 = oldParentId;
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)$this$useWithScope_u24default$iv);
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)context$iv);
                $continuation.L$6 = $this$useWithoutActiveScope$iv$iv;
                $continuation.L$7 = SpillingKt.nullOutSpilledVariable((Object)span$iv);
                $continuation.Z$0 = forceRead;
                $continuation.I$0 = timeStampChanged;
                $continuation.I$1 = readPom;
                $continuation.I$2 = $i$f$useWithScope;
                $continuation.I$3 = $i$f$useWithoutActiveScope;
                $continuation.I$4 = $i$a$-useWithoutActiveScope-TraceKt$useWithScope$2$iv;
                $continuation.label = 2;
                v5 = BuildersKt.withContext((CoroutineContext)context$iv.plus(ContextExtensionsKt.asContextElement((Context)v4)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super MavenProjectReaderResult>, Object>(span$iv, null, this, mavenProject){
                    int label;
                    private /* synthetic */ Object L$0;
                    final /* synthetic */ Span $span;
                    final /* synthetic */ MavenProjectsTreeUpdater this$0;
                    final /* synthetic */ MavenProject $mavenProject$inlined;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    int I$0;
                    {
                        this.$span = $span;
                        this.this$0 = mavenProjectsTreeUpdater;
                        this.$mavenProject$inlined = mavenProject;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                void it;
                                void $completion;
                                void $this$withContext;
                                ResultKt.throwOnFailure((Object)$result);
                                Continuation continuation = (Continuation)this;
                                Span span = this.$span;
                                void $this$readPomIfNeeded_u24lambda_u242 = $this$withContext;
                                int n = 0;
                                this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$withContext);
                                this.L$1 = SpillingKt.nullOutSpilledVariable((Object)$completion);
                                this.L$2 = SpillingKt.nullOutSpilledVariable((Object)it);
                                this.L$3 = SpillingKt.nullOutSpilledVariable((Object)$this$readPomIfNeeded_u24lambda_u242);
                                this.I$0 = n;
                                this.label = 1;
                                Object object2 = MavenProjectsTreeUpdater.access$getReader$p(this.this$0).readProjectAsync(this.$mavenProject$inlined.getFile(), (Continuation<? super MavenProjectReaderResult>)this);
                                if (object2 != object) return object2;
                                return object;
                            }
                            case 1: {
                                int n = this.I$0;
                                CoroutineScope $this$readPomIfNeeded_u24lambda_u242 = (CoroutineScope)this.L$3;
                                Span it = (Span)this.L$2;
                                Continuation $completion = (Continuation)this.L$1;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return object2;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        var var3_3 = new /* invalid duplicate definition of identical inner class */;
                        var3_3.L$0 = value;
                        return (Continuation)var3_3;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super MavenProjectReaderResult> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                ** if (v5 != var21_6) goto lbl62
lbl61:
                // 1 sources

                return var21_6;
lbl62:
                // 1 sources

                ** GOTO lbl83
            }
            case 2: {
                $i$a$-useWithoutActiveScope-TraceKt$useWithScope$2$iv = $continuation.I$4;
                $i$f$useWithoutActiveScope = $continuation.I$3;
                $i$f$useWithScope = $continuation.I$2;
                readPom = $continuation.I$1;
                timeStampChanged = $continuation.I$0;
                forceRead = $continuation.Z$0;
                span$iv = (Span)$continuation.L$7;
                $this$useWithoutActiveScope$iv$iv = (Span)$continuation.L$6;
                context$iv = (CoroutineContext)$continuation.L$5;
                $this$useWithScope_u24default$iv = (SpanBuilder)$continuation.L$4;
                oldParentId = (MavenId)$continuation.L$3;
                oldProjectId = (MavenId)$continuation.L$2;
                timestamp = (MavenProjectTimestamp)$continuation.L$1;
                mavenProject = (MavenProject)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v5 = $result;
lbl83:
                    // 2 sources

                    var17_27 = v5;
                    ** GOTO lbl96
                }
                catch (CancellationException e$iv$iv) {
                    throw e$iv$iv;
                }
                catch (Throwable e$iv$iv) {
                    $this$useWithoutActiveScope$iv$iv.setStatus(StatusCode.ERROR);
                    throw e$iv$iv;
                }
            }
            catch (Throwable var18_30) {
                throw var18_30;
            }
            {
                finally {
                    $this$useWithoutActiveScope$iv$iv.end();
                }
lbl96:
                // 1 sources

                readerResult = (MavenProjectReaderResult)var17_27;
                readChanges = mavenProject.updateFromReaderResult(readerResult, MavenSettingsCache.Companion.getInstance(this.tree.getProject()).getEffectiveUserLocalRepo(), true);
                this.tree.putVirtualFileToProjectMapping(mavenProject, oldProjectId);
                if (!Comparing.equal((Object)oldParentId, (Object)mavenProject.getParentId())) ** GOTO lbl102
                this.tree.putTimestamp$intellij_maven(mavenProject, timestamp);
                ** GOTO lbl132
lbl102:
                // 1 sources

                $continuation.L$0 = mavenProject;
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)timestamp);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)oldProjectId);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)oldParentId);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)readerResult);
                $continuation.L$5 = readChanges;
                $continuation.L$6 = null;
                $continuation.L$7 = null;
                $continuation.Z$0 = forceRead;
                $continuation.I$0 = timeStampChanged;
                $continuation.I$1 = readPom;
                $continuation.label = 3;
                v6 = this.calculateTimestamp(mavenProject, (Continuation<? super MavenProjectTimestamp>)$continuation);
                if (v6 == var21_6) {
                    return var21_6;
                }
                ** GOTO lbl130
            }
            case 3: {
                readPom = $continuation.I$1;
                timeStampChanged = $continuation.I$0;
                forceRead = $continuation.Z$0;
                readChanges = (MavenProjectChanges)$continuation.L$5;
                readerResult = (MavenProjectReaderResult)$continuation.L$4;
                oldParentId = (MavenId)$continuation.L$3;
                oldProjectId = (MavenId)$continuation.L$2;
                timestamp = (MavenProjectTimestamp)$continuation.L$1;
                mavenProject = (MavenProject)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v6 = $result;
lbl130:
                // 2 sources

                newTimestamp = (MavenProjectTimestamp)v6;
                this.tree.putTimestamp$intellij_maven(mavenProject, newTimestamp);
lbl132:
                // 2 sources

                forcedChanges = forceRead != false ? MavenProjectChanges.ALL : MavenProjectChanges.NONE;
                Intrinsics.checkNotNull((Object)forcedChanges);
                changes = MavenProjectChangesBuilder.Companion.merged(forcedChanges, readChanges);
                this.updateContext.updated(mavenProject, changes);
lbl136:
                // 2 sources

                return Boxing.boxBoolean((boolean)(readPom != 0));
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Object calculateTimestamp(MavenProject mavenProject, Continuation<? super MavenProjectTimestamp> $completion) {
        return CoroutinesKt.readAction(() -> MavenProjectsTreeUpdater.calculateTimestamp$lambda$3(this, mavenProject), $completion);
    }

    /*
     * WARNING - void declaration
     */
    private final void handleRemovedModules(MavenProject mavenProject, List<MavenProject> prevModules, List<? extends VirtualFile> existingModuleFiles) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = prevModules;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            MavenProject it = (MavenProject)element$iv$iv;
            boolean bl = false;
            if (!(!existingModuleFiles.contains(it.getFile()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List removedModules = (List)destination$iv$iv;
        for (MavenProject module : removedModules) {
            VirtualFile moduleFile = module.getFile();
            if (this.tree.isManagedFile(moduleFile)) {
                if (!this.tree.reconnectRoot(module)) continue;
                this.updateContext.updated(module, MavenProjectChanges.NONE);
                continue;
            }
            this.tree.removeModule(mavenProject, module);
            this.tree.doDelete$intellij_maven(mavenProject, module, this.updateContext);
        }
    }

    private final void reconnectModuleFiles(MavenProject mavenProject, List<? extends VirtualFile> modulesFilesToReconnect) {
        for (VirtualFile virtualFile : modulesFilesToReconnect) {
            MavenProject module = this.tree.findProject(virtualFile);
            if (module == null || !this.tree.reconnect(mavenProject, module)) continue;
            this.updateContext.updated(module, MavenProjectChanges.NONE);
        }
    }

    private final List<VirtualFile> collectModuleFilesToReconnect(MavenProject mavenProject, List<? extends VirtualFile> existingModuleFiles) {
        ArrayList<VirtualFile> modulesFilesToReconnect = new ArrayList<VirtualFile>();
        for (VirtualFile virtualFile : existingModuleFiles) {
            boolean isNewModule;
            MavenProject foundModule = this.tree.findProject(virtualFile);
            boolean bl = isNewModule = foundModule == null;
            if (!isNewModule) {
                MavenProject mavenProject2 = foundModule;
                Intrinsics.checkNotNull((Object)mavenProject2);
                MavenProject currentAggregator = this.tree.findAggregator(mavenProject2);
                if (currentAggregator != null && currentAggregator != mavenProject) {
                    MavenLog.LOG.info("Module " + virtualFile + " is already included into " + mavenProject.getFile());
                    continue;
                }
            }
            modulesFilesToReconnect.add(virtualFile);
        }
        return modulesFilesToReconnect;
    }

    /*
     * WARNING - void declaration
     */
    private final List<VirtualFile> collectModuleFilesToUpdate(List<? extends VirtualFile> moduleFilesToReconnect, boolean updateExistingModules) {
        void $this$filterTo$iv$iv;
        if (updateExistingModules) {
            return moduleFilesToReconnect;
        }
        Iterable $this$filter$iv = moduleFilesToReconnect;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl = false;
            if (!(this.tree.findProject(it) == null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<VirtualFile> collectChildFilesToUpdate(MavenProject mavenProject, Collection<MavenProject> prevChildren) {
        void $this$mapTo$iv$iv;
        HashSet<MavenProject> children = new HashSet<MavenProject>(prevChildren);
        Collection<MavenProject> collection = this.updateContext.getDeletedProjects();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getDeletedProjects(...)");
        children.removeAll(CollectionsKt.toSet((Iterable)collection));
        children.addAll(this.tree.findInheritors(mavenProject));
        Iterable $this$map$iv = children;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            MavenProject mavenProject2 = (MavenProject)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.getFile());
        }
        return (List)destination$iv$iv;
    }

    private final MavenProject findOrCreateProject(VirtualFile f) {
        MavenProject mavenProject = this.tree.findProject(f);
        if (mavenProject != null) {
            return mavenProject;
        }
        MavenProject mavenProject2 = this.createdMavenProjects.compute(f, (arg_0, arg_1) -> MavenProjectsTreeUpdater.findOrCreateProject$lambda$8((arg_0, arg_1) -> MavenProjectsTreeUpdater.findOrCreateProject$lambda$7(f, arg_0, arg_1), arg_0, arg_1));
        Intrinsics.checkNotNull((Object)mavenProject2);
        MavenProject createdMavenProject = mavenProject2;
        return createdMavenProject;
    }

    /*
     * Unable to fully structure code
     */
    private final Object update(VirtualFile mavenProjectFile, boolean forceRead, Continuation<? super Unit> $completion) {
        if (!($completion instanceof update.1)) ** GOTO lbl-1000
        var27_4 = $completion;
        if ((var27_4.label & -2147483648) != 0) {
            var27_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                Object L$7;
                Object L$8;
                Object L$9;
                boolean Z$0;
                boolean Z$1;
                int I$0;
                int I$1;
                /* synthetic */ Object result;
                final /* synthetic */ MavenProjectsTreeUpdater this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return MavenProjectsTreeUpdater.access$update(this.this$0, null, false, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var28_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (!this.startUpdate(mavenProjectFile, forceRead != false)) {
                    return Unit.INSTANCE;
                }
                MavenLog.LOG.trace("Maven tree updater: start update " + mavenProjectFile + ", forceRead=" + (forceRead != false));
                mavenProject = this.findOrCreateProject(mavenProjectFile);
                prevModules = this.tree.getModules(mavenProject);
                prevChildren = this.tree.findInheritors(mavenProject);
                $continuation.L$0 = mavenProjectFile;
                $continuation.L$1 = mavenProject;
                $continuation.L$2 = prevModules;
                $continuation.L$3 = prevChildren;
                $continuation.Z$0 = forceRead;
                $continuation.label = 1;
                v0 = this.readPomIfNeeded(mavenProject, forceRead != false, (Continuation<? super Boolean>)$continuation);
                if (v0 == var28_6) {
                    return var28_6;
                }
                ** GOTO lbl36
            }
            case 1: {
                forceRead = $continuation.Z$0;
                prevChildren = (Collection)$continuation.L$3;
                prevModules = (List)$continuation.L$2;
                mavenProject = (MavenProject)$continuation.L$1;
                mavenProjectFile = (VirtualFile)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl36:
                // 2 sources

                readPom = (Boolean)v0;
                existingModuleFiles = mavenProject.getExistingModuleFiles();
                this.handleRemovedModules(mavenProject, prevModules, existingModuleFiles);
                modulesFilesToReconnect = this.collectModuleFilesToReconnect(mavenProject, existingModuleFiles);
                updateExistingModules = readPom != false || this.updateModules != false ? 1 : 0;
                modulesFilesToUpdate = this.collectModuleFilesToUpdate(modulesFilesToReconnect, updateExistingModules != 0);
                forceReadModules = this.updateModules != false && forceRead != false ? 1 : 0;
                $this$map$iv = modulesFilesToUpdate;
                $i$f$map = false;
                var16_30 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var21_38 = (VirtualFile)item$iv$iv;
                    var25_41 = destination$iv$iv;
                    $i$a$-map-MavenProjectsTreeUpdater$update$moduleUpdates$1 = false;
                    var25_41.add(new UpdateSpec((VirtualFile)it, forceReadModules != 0));
                }
                moduleUpdates = (List)destination$iv$iv;
                $continuation.L$0 = mavenProjectFile;
                $continuation.L$1 = mavenProject;
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)prevModules);
                $continuation.L$3 = prevChildren;
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)existingModuleFiles);
                $continuation.L$5 = modulesFilesToReconnect;
                $continuation.L$6 = SpillingKt.nullOutSpilledVariable(modulesFilesToUpdate);
                $continuation.L$7 = SpillingKt.nullOutSpilledVariable((Object)moduleUpdates);
                $continuation.Z$0 = forceRead;
                $continuation.Z$1 = readPom;
                $continuation.I$0 = updateExistingModules;
                $continuation.I$1 = forceReadModules;
                $continuation.label = 2;
                v1 = this.updateProjects(moduleUpdates, (Continuation<? super Unit>)$continuation);
                if (v1 == var28_6) {
                    return var28_6;
                }
                ** GOTO lbl89
            }
            case 2: {
                forceReadModules = $continuation.I$1;
                updateExistingModules = $continuation.I$0;
                readPom = $continuation.Z$1;
                forceRead = $continuation.Z$0;
                moduleUpdates = (List)$continuation.L$7;
                modulesFilesToUpdate = (List<VirtualFile>)$continuation.L$6;
                modulesFilesToReconnect = (List<VirtualFile>)$continuation.L$5;
                existingModuleFiles = (List)$continuation.L$4;
                prevChildren = (Collection)$continuation.L$3;
                prevModules = (List)$continuation.L$2;
                mavenProject = (MavenProject)$continuation.L$1;
                mavenProjectFile = (VirtualFile)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl89:
                // 2 sources

                this.reconnectModuleFiles(mavenProject, modulesFilesToReconnect);
                childFilesToUpdate = this.collectChildFilesToUpdate(mavenProject, prevChildren);
                $this$map$iv = childFilesToUpdate;
                $i$f$map = false;
                $i$f$mapTo = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var23_44 = (VirtualFile)item$iv$iv;
                    var25_41 = destination$iv$iv;
                    $i$a$-map-MavenProjectsTreeUpdater$update$childUpdates$1 = false;
                    var25_41.add(new UpdateSpec((VirtualFile)it, readPom != false));
                }
                childUpdates = (List)destination$iv$iv;
                $continuation.L$0 = mavenProjectFile;
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)mavenProject);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)prevModules);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)prevChildren);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)existingModuleFiles);
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable(modulesFilesToReconnect);
                $continuation.L$6 = SpillingKt.nullOutSpilledVariable(modulesFilesToUpdate);
                $continuation.L$7 = SpillingKt.nullOutSpilledVariable((Object)moduleUpdates);
                $continuation.L$8 = SpillingKt.nullOutSpilledVariable(childFilesToUpdate);
                $continuation.L$9 = SpillingKt.nullOutSpilledVariable((Object)childUpdates);
                $continuation.Z$0 = forceRead;
                $continuation.Z$1 = readPom;
                $continuation.I$0 = updateExistingModules;
                $continuation.I$1 = forceReadModules;
                $continuation.label = 3;
                v2 = this.updateProjects(childUpdates, (Continuation<? super Unit>)$continuation);
                if (v2 == var28_6) {
                    return var28_6;
                }
                ** GOTO lbl141
            }
            case 3: {
                forceReadModules = $continuation.I$1;
                updateExistingModules = $continuation.I$0;
                readPom = $continuation.Z$1;
                forceRead = $continuation.Z$0;
                childUpdates = (List)$continuation.L$9;
                childFilesToUpdate = (List)$continuation.L$8;
                moduleUpdates = (List)$continuation.L$7;
                modulesFilesToUpdate = (List)$continuation.L$6;
                modulesFilesToReconnect = (List)$continuation.L$5;
                existingModuleFiles = (List)$continuation.L$4;
                prevChildren = (Collection)$continuation.L$3;
                prevModules = (List)$continuation.L$2;
                mavenProject = (MavenProject)$continuation.L$1;
                mavenProjectFile = (VirtualFile)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl141:
                // 2 sources

                MavenLog.LOG.trace("Maven tree updater: finish update " + mavenProjectFile + ", forceRead=" + (forceRead != false));
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public final Object updateProjects(@NotNull List<UpdateSpec> specs, @NotNull Continuation<? super Unit> $completion) {
        if (specs.isEmpty()) {
            return Unit.INSTANCE;
        }
        Object object = CoroutineScopeKt.coroutineScope((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(specs, this, null){
            int label;
            final /* synthetic */ List<UpdateSpec> $specs;
            final /* synthetic */ MavenProjectsTreeUpdater this$0;
            {
                this.$specs = $specs;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$specs, this.this$0, null){
                            int label;
                            private /* synthetic */ Object L$0;
                            final /* synthetic */ List<UpdateSpec> $specs;
                            final /* synthetic */ MavenProjectsTreeUpdater this$0;
                            {
                                this.$specs = $specs;
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final Object invokeSuspend(Object $result) {
                                CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        void $this$forEach$iv;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Iterable iterable = this.$specs;
                                        MavenProjectsTreeUpdater mavenProjectsTreeUpdater = this.this$0;
                                        boolean $i$f$forEach = false;
                                        for (T element$iv : $this$forEach$iv) {
                                            void $this$withContext;
                                            UpdateSpec spec = (UpdateSpec)element$iv;
                                            boolean bl = false;
                                            BuildersKt.launch$default((CoroutineScope)$this$withContext, (CoroutineContext)((CoroutineContext)new CoroutineName("reading " + spec.mavenProjectFile())), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(mavenProjectsTreeUpdater, spec, null){
                                                Object L$0;
                                                Object L$1;
                                                Object L$2;
                                                Object L$3;
                                                int I$0;
                                                int I$1;
                                                int I$2;
                                                int label;
                                                final /* synthetic */ MavenProjectsTreeUpdater this$0;
                                                final /* synthetic */ UpdateSpec $spec;
                                                {
                                                    this.this$0 = $receiver;
                                                    this.$spec = $spec;
                                                    super(2, $completion);
                                                }

                                                /*
                                                 * WARNING - Removed try catching itself - possible behaviour change.
                                                 * Unable to fully structure code
                                                 */
                                                public final Object invokeSuspend(Object $result) {
                                                    var13_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                    switch (this.label) {
                                                        case 0: {
                                                            ResultKt.throwOnFailure((Object)$result);
                                                            v0 = TelemetryKt.getTracer().spanBuilder("updateProjectSpec");
                                                            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"spanBuilder(...)");
                                                            var2_3 = v0;
                                                            var4_5 = this.this$0;
                                                            var5_6 = this.$spec;
                                                            context$iv = (CoroutineContext)EmptyCoroutineContext.INSTANCE;
                                                            $i$f$useWithScope = 0;
                                                            v1 = $this$useWithScope_u24default$iv.startSpan();
                                                            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"startSpan(...)");
                                                            $this$useWithoutActiveScope$iv$iv = v1;
                                                            $i$f$useWithoutActiveScope = 0;
                                                            span$iv = $this$useWithoutActiveScope$iv$iv;
                                                            $i$a$-useWithoutActiveScope-TraceKt$useWithScope$2$iv = 0;
                                                            v2 = Context.current().with((ImplicitContextKeyed)span$iv);
                                                            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"with(...)");
                                                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$useWithScope_u24default$iv);
                                                            this.L$1 = SpillingKt.nullOutSpilledVariable((Object)context$iv);
                                                            this.L$2 = $this$useWithoutActiveScope$iv$iv;
                                                            this.L$3 = SpillingKt.nullOutSpilledVariable((Object)span$iv);
                                                            this.I$0 = $i$f$useWithScope;
                                                            this.I$1 = $i$f$useWithoutActiveScope;
                                                            this.I$2 = $i$a$-useWithoutActiveScope-TraceKt$useWithScope$2$iv;
                                                            this.label = 1;
                                                            v3 = BuildersKt.withContext((CoroutineContext)context$iv.plus(ContextExtensionsKt.asContextElement((Context)v2)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(span$iv, null, var4_5, var5_6){
                                                                int label;
                                                                private /* synthetic */ Object L$0;
                                                                final /* synthetic */ Span $span;
                                                                final /* synthetic */ MavenProjectsTreeUpdater this$0;
                                                                final /* synthetic */ UpdateSpec $spec$inlined;
                                                                Object L$1;
                                                                Object L$2;
                                                                Object L$3;
                                                                int I$0;
                                                                {
                                                                    this.$span = $span;
                                                                    this.this$0 = mavenProjectsTreeUpdater;
                                                                    this.$spec$inlined = updateSpec;
                                                                    super(2, $completion);
                                                                }

                                                                /*
                                                                 * WARNING - void declaration
                                                                 * Enabled force condition propagation
                                                                 * Lifted jumps to return sites
                                                                 */
                                                                public final Object invokeSuspend(Object $result) {
                                                                    CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                                                                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                                    switch (this.label) {
                                                                        case 0: {
                                                                            void it;
                                                                            void $completion;
                                                                            void $this$withContext;
                                                                            ResultKt.throwOnFailure((Object)$result);
                                                                            Continuation continuation = (Continuation)this;
                                                                            Span span = this.$span;
                                                                            void $this$invokeSuspend_u24lambda_u240 = $this$withContext;
                                                                            int n = 0;
                                                                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$withContext);
                                                                            this.L$1 = SpillingKt.nullOutSpilledVariable((Object)$completion);
                                                                            this.L$2 = SpillingKt.nullOutSpilledVariable((Object)it);
                                                                            this.L$3 = SpillingKt.nullOutSpilledVariable((Object)$this$invokeSuspend_u24lambda_u240);
                                                                            this.I$0 = n;
                                                                            this.label = 1;
                                                                            Object object2 = MavenProjectsTreeUpdater.access$update(this.this$0, this.$spec$inlined.mavenProjectFile(), this.$spec$inlined.forceRead(), (Continuation)this);
                                                                            if (object2 != object) return Unit.INSTANCE;
                                                                            return object;
                                                                        }
                                                                        case 1: {
                                                                            int n = this.I$0;
                                                                            CoroutineScope $this$invokeSuspend_u24lambda_u240 = (CoroutineScope)this.L$3;
                                                                            Span it = (Span)this.L$2;
                                                                            Continuation $completion = (Continuation)this.L$1;
                                                                            ResultKt.throwOnFailure((Object)$result);
                                                                            Object object2 = $result;
                                                                            return Unit.INSTANCE;
                                                                        }
                                                                    }
                                                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                                }

                                                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                                                    var3_3.L$0 = value;
                                                                    return (Continuation)var3_3;
                                                                }

                                                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                                                }
                                                            }), (Continuation)this);
                                                            ** if (v3 != var13_2) goto lbl33
lbl32:
                                                            // 1 sources

                                                            return var13_2;
lbl33:
                                                            // 1 sources

                                                            ** GOTO lbl47
                                                        }
                                                        case 1: {
                                                            $i$a$-useWithoutActiveScope-TraceKt$useWithScope$2$iv = this.I$2;
                                                            $i$f$useWithoutActiveScope = this.I$1;
                                                            $i$f$useWithScope = this.I$0;
                                                            span$iv = (Span)this.L$3;
                                                            $this$useWithoutActiveScope$iv$iv = (Span)this.L$2;
                                                            context$iv = (CoroutineContext)this.L$1;
                                                            $this$useWithScope_u24default$iv = (SpanBuilder)this.L$0;
                                                            try {
                                                                ResultKt.throwOnFailure((Object)$result);
                                                                v3 = $result;
lbl47:
                                                                // 2 sources

                                                                var11_18 = v3;
                                                                ** GOTO lbl60
                                                            }
                                                            catch (CancellationException e$iv$iv) {
                                                                throw e$iv$iv;
                                                            }
                                                            catch (Throwable e$iv$iv) {
                                                                $this$useWithoutActiveScope$iv$iv.setStatus(StatusCode.ERROR);
                                                                throw e$iv$iv;
                                                            }
                                                        }
                                                        catch (Throwable var12_21) {
                                                            throw var12_21;
                                                        }
                                                        {
                                                            finally {
                                                                $this$useWithoutActiveScope$iv$iv.end();
                                                            }
lbl60:
                                                            // 1 sources

                                                            return Unit.INSTANCE;
                                                        }
                                                    }
                                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                }

                                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                                }

                                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                                }
                                            }), (int)2, null);
                                        }
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value;
                                return (Continuation)var3_3;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final long getFileTimestamp(VirtualFile file2) {
        if (file2 == null || !file2.isValid()) {
            return -1L;
        }
        return file2.getTimeStamp();
    }

    private final long getFileTimestamp(Path file2) {
        return this.getFileTimestamp(file2 == null ? null : LocalFileSystem.getInstance().findFileByNioFile(file2));
    }

    private static final Boolean startUpdate$lambda$0(Ref $previousUpdateRef, boolean $forceRead, VirtualFile virtualFile, Boolean value) {
        $previousUpdateRef.set((Object)value);
        return Intrinsics.areEqual((Object)true, (Object)value) || $forceRead;
    }

    private static final Boolean startUpdate$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        return (Boolean)$tmp0.invoke(p0, p1);
    }

    private static final MavenProjectTimestamp calculateTimestamp$lambda$3(MavenProjectsTreeUpdater this$0, MavenProject $mavenProject) {
        MavenProject parent;
        long pomTimestamp = this$0.getFileTimestamp($mavenProject.getFile());
        MavenProject mavenProject = parent = this$0.tree.findParent($mavenProject);
        long parentTimestamp = this$0.getFileTimestamp((VirtualFile)(mavenProject != null ? mavenProject.getFile() : null));
        VirtualFile profilesXmlFile = $mavenProject.getProfilesXmlFile();
        long profilesTimestamp = this$0.getFileTimestamp(profilesXmlFile);
        VirtualFile jvmConfigFile = MavenUtil.INSTANCE.getConfigFile($mavenProject, ".mvn/jvm.config");
        long jvmConfigTimestamp = this$0.getFileTimestamp(jvmConfigFile);
        VirtualFile mavenConfigFile = MavenUtil.INSTANCE.getConfigFile($mavenProject, ".mvn/maven.config");
        long mavenConfigTimestamp = this$0.getFileTimestamp(mavenConfigFile);
        long userSettingsTimestamp = this$0.getFileTimestamp(this$0.userSettingsFile);
        long globalSettingsTimestamp = this$0.getFileTimestamp(this$0.globalSettingsFile);
        int profilesHashCode = this$0.reader.getExplicitProfiles().hashCode();
        return new MavenProjectTimestamp(pomTimestamp, parentTimestamp, profilesTimestamp, userSettingsTimestamp, globalSettingsTimestamp, profilesHashCode, jvmConfigTimestamp, mavenConfigTimestamp);
    }

    private static final MavenProject findOrCreateProject$lambda$7(VirtualFile $f, VirtualFile file2, MavenProject value) {
        if (value != null) {
            return value;
        }
        MavenLog.LOG.debug("Maven tree updater: created new maven project " + file2);
        return new MavenProject($f);
    }

    private static final MavenProject findOrCreateProject$lambda$8(Function2 $tmp0, Object p0, Object p1) {
        return (MavenProject)$tmp0.invoke(p0, p1);
    }

    public static final /* synthetic */ Object access$readPomIfNeeded(MavenProjectsTreeUpdater $this, MavenProject mavenProject, boolean forceRead, Continuation $completion) {
        return $this.readPomIfNeeded(mavenProject, forceRead, (Continuation<? super Boolean>)$completion);
    }

    public static final /* synthetic */ Object access$calculateTimestamp(MavenProjectsTreeUpdater $this, MavenProject mavenProject, Continuation $completion) {
        return $this.calculateTimestamp(mavenProject, (Continuation<? super MavenProjectTimestamp>)$completion);
    }

    public static final /* synthetic */ Object access$update(MavenProjectsTreeUpdater $this, VirtualFile mavenProjectFile, boolean forceRead, Continuation $completion) {
        return $this.update(mavenProjectFile, forceRead, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ MavenProjectReader access$getReader$p(MavenProjectsTreeUpdater $this) {
        return $this.reader;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0081\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\t\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/idea/maven/project/MavenProjectsTreeUpdater$UpdateSpec;", "Ljava/lang/Record;", "mavenProjectFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "forceRead", "", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;Z)V", "()Lcom/intellij/openapi/vfs/VirtualFile;", "()Z", "component1", "component2", "copy", "equals", "other", "", "hashCode", "", "toString", "", "intellij.maven"})
    @ApiStatus.Internal
    public static final class UpdateSpec
    extends Record {
        @NotNull
        private final VirtualFile mavenProjectFile;
        private final boolean forceRead;

        public UpdateSpec(@NotNull VirtualFile mavenProjectFile, boolean forceRead) {
            Intrinsics.checkNotNullParameter((Object)mavenProjectFile, (String)"mavenProjectFile");
            this.mavenProjectFile = mavenProjectFile;
            this.forceRead = forceRead;
        }

        @NotNull
        public final VirtualFile mavenProjectFile() {
            return this.mavenProjectFile;
        }

        public final boolean forceRead() {
            return this.forceRead;
        }

        @NotNull
        public final VirtualFile component1() {
            return this.mavenProjectFile;
        }

        public final boolean component2() {
            return this.forceRead;
        }

        @NotNull
        public final UpdateSpec copy(@NotNull VirtualFile mavenProjectFile, boolean forceRead) {
            Intrinsics.checkNotNullParameter((Object)mavenProjectFile, (String)"mavenProjectFile");
            return new UpdateSpec(mavenProjectFile, forceRead);
        }

        public static /* synthetic */ UpdateSpec copy$default(UpdateSpec updateSpec, VirtualFile virtualFile, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                virtualFile = updateSpec.mavenProjectFile;
            }
            if ((n & 2) != 0) {
                bl = updateSpec.forceRead;
            }
            return updateSpec.copy(virtualFile, bl);
        }

        @Override
        @NotNull
        public String toString() {
            return "UpdateSpec(mavenProjectFile=" + this.mavenProjectFile + ", forceRead=" + this.forceRead + ")";
        }

        @Override
        public int hashCode() {
            int result2 = this.mavenProjectFile.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.forceRead);
            return result2;
        }

        @Override
        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof UpdateSpec)) {
                return false;
            }
            UpdateSpec updateSpec = (UpdateSpec)other;
            if (!Intrinsics.areEqual((Object)this.mavenProjectFile, (Object)updateSpec.mavenProjectFile)) {
                return false;
            }
            return this.forceRead == updateSpec.forceRead;
        }
    }
}

