/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.refactorings.extract;

import com.intellij.DynamicBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Pair;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Function;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomBundle;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.utils.ComboBoxUtil;

public class SelectMavenProjectDialog
extends DialogWrapper {
    private final Set<? extends MavenDomProjectModel> myMavenDomProjectModels;
    private final boolean myHasExclusions;
    private JComboBox myMavenProjectsComboBox;
    private JPanel myMainPanel;
    private JCheckBox myReplaceAllCheckBox;
    private JCheckBox myExtractExclusions;
    private boolean myHasUsagesInProjects;
    private ItemListener myReplaceAllListener;
    private final Function<? super MavenDomProjectModel, ? extends Set<MavenDomDependency>> myOccurrencesCountFunction;

    public SelectMavenProjectDialog(@NotNull Project project, @NotNull Set<? extends MavenDomProjectModel> mavenDomProjectModels, @NotNull Function<? super MavenDomProjectModel, ? extends Set<MavenDomDependency>> funOccurrences, boolean hasExclusions) {
        if (project == null) {
            SelectMavenProjectDialog.$$$reportNull$$$0(0);
        }
        if (mavenDomProjectModels == null) {
            SelectMavenProjectDialog.$$$reportNull$$$0(1);
        }
        if (funOccurrences == null) {
            SelectMavenProjectDialog.$$$reportNull$$$0(2);
        }
        super(project, true);
        this.myHasUsagesInProjects = false;
        this.myMavenDomProjectModels = mavenDomProjectModels;
        this.myHasExclusions = hasExclusions;
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        this.setTitle(MavenDomBundle.message("choose.project", objectArray));
        this.myOccurrencesCountFunction = funOccurrences;
        for (MavenDomProjectModel mavenDomProjectModel : this.myMavenDomProjectModels) {
            if (((Set)this.myOccurrencesCountFunction.fun((Object)mavenDomProjectModel)).size() <= 0) continue;
            this.myHasUsagesInProjects = true;
            break;
        }
        this.init();
    }

    protected Action @NotNull [] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction()};
        if (actionArray == null) {
            SelectMavenProjectDialog.$$$reportNull$$$0(3);
        }
        return actionArray;
    }

    protected void init() {
        super.init();
        this.updateOkStatus();
    }

    protected void dispose() {
        super.dispose();
        if (this.myReplaceAllCheckBox != null) {
            this.myReplaceAllCheckBox.removeItemListener(this.myReplaceAllListener);
        }
    }

    @Nullable
    public MavenDomProjectModel getSelectedProject() {
        return (MavenDomProjectModel)ComboBoxUtil.getSelectedValue((DefaultComboBoxModel)this.myMavenProjectsComboBox.getModel());
    }

    public boolean isReplaceAllOccurrences() {
        return this.myReplaceAllCheckBox.isSelected();
    }

    public boolean isExtractExclusions() {
        return this.myExtractExclusions.isSelected();
    }

    protected JComponent createCenterPanel() {
        ComboBoxUtil.setModel(this.myMavenProjectsComboBox, new DefaultComboBoxModel(), this.myMavenDomProjectModels, model -> Pair.create((Object)MavenDomUtil.getProjectName(model), (Object)model));
        this.myReplaceAllListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SelectMavenProjectDialog.this.updateControls();
            }
        };
        this.myMavenProjectsComboBox.addItemListener(this.myReplaceAllListener);
        this.myMavenProjectsComboBox.setSelectedItem(0);
        this.myReplaceAllCheckBox.setVisible(this.myHasUsagesInProjects);
        this.myExtractExclusions.setVisible(this.myHasExclusions);
        this.updateControls();
        return this.myMainPanel;
    }

    private void updateControls() {
        MavenDomProjectModel project = this.getSelectedProject();
        int count = ((Set)this.myOccurrencesCountFunction.fun((Object)project)).size();
        this.myReplaceAllCheckBox.setText(RefactoringBundle.message((String)"replace.all.occurences", (Object[])new Object[]{count}));
        this.myReplaceAllCheckBox.setEnabled(count != 0);
    }

    private void updateOkStatus() {
        this.setOKActionEnabled(this.getSelectedProject() != null);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myMavenProjectsComboBox;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JComboBox jComboBox;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/MavenDomBundle", SelectMavenProjectDialog.class).getString("property.introduce.project"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myMavenProjectsComboBox = jComboBox = new JComboBox();
        jPanel.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myReplaceAllCheckBox = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, DynamicBundle.getBundle((String)"messages/MavenDomBundle", SelectMavenProjectDialog.class).getString("property.replace.all"));
        jPanel.add((Component)jCheckBox2, new GridConstraints(1, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myExtractExclusions = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/MavenDomBundle", SelectMavenProjectDialog.class).getString("property.extract.exclusions"));
        jPanel.add((Component)jCheckBox, new GridConstraints(2, 0, 1, 2, 8, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenDomProjectModels";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "funOccurrences";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/dom/refactorings/extract/SelectMavenProjectDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/dom/refactorings/extract/SelectMavenProjectDialog";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

