/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.chars;

import it.unimi.dsi.fastutil.SafeMath;
import it.unimi.dsi.fastutil.Size64;
import it.unimi.dsi.fastutil.chars.CharIterable;
import it.unimi.dsi.fastutil.chars.CharIterator;
import it.unimi.dsi.fastutil.chars.CharPredicate;
import it.unimi.dsi.fastutil.chars.CharSpliterator;
import it.unimi.dsi.fastutil.chars.CharSpliterators;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;

public interface CharCollection
extends CharIterable,
Collection<Character> {
    @Override
    public CharIterator iterator();

    @Override
    default public CharSpliterator spliterator() {
        return CharSpliterators.asSpliterator(this.iterator(), Size64.sizeOf(this), 320);
    }

    @Override
    public boolean add(char var1);

    public boolean contains(char var1);

    public boolean rem(char var1);

    @Override
    @Deprecated
    default public boolean add(Character key) {
        return this.add(key.charValue());
    }

    @Override
    @Deprecated
    default public boolean contains(Object key) {
        if (key == null) {
            return false;
        }
        return this.contains(((Character)key).charValue());
    }

    @Override
    @Deprecated
    default public boolean remove(Object key) {
        if (key == null) {
            return false;
        }
        return this.rem(((Character)key).charValue());
    }

    public char[] toCharArray();

    @Override
    @Deprecated
    default public boolean removeIf(Predicate<? super Character> filter2) {
        return this.removeIf(filter2 instanceof CharPredicate ? (CharPredicate)filter2 : key -> filter2.test(Character.valueOf(SafeMath.safeIntToChar(key))));
    }

    default public boolean removeIf(CharPredicate filter2) {
        Objects.requireNonNull(filter2);
        boolean removed = false;
        CharIterator each = this.iterator();
        while (each.hasNext()) {
            if (!filter2.test(each.nextChar())) continue;
            each.remove();
            removed = true;
        }
        return removed;
    }

    @Override
    @Deprecated
    default public Stream<Character> stream() {
        return Collection.super.stream();
    }

    @Override
    @Deprecated
    default public Stream<Character> parallelStream() {
        return Collection.super.parallelStream();
    }
}

