/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch;

import com.intellij.dvcs.branch.DvcsSyncSettings;
import com.intellij.dvcs.repo.Repository;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.ui.LayeredIcon;
import git4idea.branch.GitBranchIncomingOutgoingManager;
import git4idea.config.GitVcsSettings;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import icons.DvcsImplIcons;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lgit4idea/ui/branch/BranchIconUtil;", "", "<init>", "()V", "Companion", "intellij.vcs.git"})
public final class BranchIconUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final LayeredIcon INCOMING_LAYERED = LayeredIcon.Companion.layeredIcon(BranchIconUtil::INCOMING_LAYERED$lambda$0);
    @NotNull
    private static final LayeredIcon INCOMING_OUTGOING_LAYERED = LayeredIcon.Companion.layeredIcon(BranchIconUtil::INCOMING_OUTGOING_LAYERED$lambda$1);
    @NotNull
    private static final LayeredIcon OUTGOING_LAYERED = LayeredIcon.Companion.layeredIcon(BranchIconUtil::OUTGOING_LAYERED$lambda$2);

    private static final Icon[] INCOMING_LAYERED$lambda$0() {
        Icon[] iconArray = new Icon[2];
        Intrinsics.checkNotNullExpressionValue((Object)AllIcons.Vcs.Branch, (String)"Branch");
        Intrinsics.checkNotNullExpressionValue((Object)DvcsImplIcons.IncomingLayer, (String)"IncomingLayer");
        return iconArray;
    }

    private static final Icon[] INCOMING_OUTGOING_LAYERED$lambda$1() {
        Icon[] iconArray = new Icon[2];
        Intrinsics.checkNotNullExpressionValue((Object)AllIcons.Vcs.Branch, (String)"Branch");
        Intrinsics.checkNotNullExpressionValue((Object)DvcsImplIcons.IncomingOutgoingLayer, (String)"IncomingOutgoingLayer");
        return iconArray;
    }

    private static final Icon[] OUTGOING_LAYERED$lambda$2() {
        Icon[] iconArray = new Icon[2];
        Intrinsics.checkNotNullExpressionValue((Object)AllIcons.Vcs.Branch, (String)"Branch");
        Intrinsics.checkNotNullExpressionValue((Object)DvcsImplIcons.OutgoingLayer, (String)"OutgoingLayer");
        return iconArray;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lgit4idea/ui/branch/BranchIconUtil$Companion;", "", "<init>", "()V", "INCOMING_LAYERED", "Lcom/intellij/ui/LayeredIcon;", "INCOMING_OUTGOING_LAYERED", "OUTGOING_LAYERED", "getBranchIcon", "Ljavax/swing/Icon;", "repository", "Lgit4idea/repo/GitRepository;", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Icon getBranchIcon(@NotNull GitRepository repository2) {
            Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
            if (repository2.getState() != Repository.State.NORMAL) {
                Icon icon = AllIcons.General.Warning;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Warning");
                return icon;
            }
            Project project = repository2.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Project project2 = project;
            String currentBranchName = repository2.getCurrentBranchName();
            if (repository2.getState() == Repository.State.NORMAL && currentBranchName != null) {
                boolean moreThanOneRoot = GitRepositoryManager.getInstance(project2).moreThanOneRoot();
                boolean doNotSyncRepos = GitVcsSettings.getInstance(project2).getSyncSetting() == DvcsSyncSettings.Value.DONT_SYNC;
                GitRepository indicatorRepo = moreThanOneRoot && doNotSyncRepos ? repository2 : null;
                GitBranchIncomingOutgoingManager gitBranchIncomingOutgoingManager = GitBranchIncomingOutgoingManager.getInstance(project2);
                Intrinsics.checkNotNullExpressionValue((Object)gitBranchIncomingOutgoingManager, (String)"getInstance(...)");
                GitBranchIncomingOutgoingManager incomingOutgoingManager = gitBranchIncomingOutgoingManager;
                boolean hasIncoming = incomingOutgoingManager.hasIncomingFor(indicatorRepo, currentBranchName);
                boolean hasOutgoing = incomingOutgoingManager.hasOutgoingFor(indicatorRepo, currentBranchName);
                if (hasIncoming && hasOutgoing) {
                    return (Icon)INCOMING_OUTGOING_LAYERED;
                }
                if (hasIncoming) {
                    return (Icon)INCOMING_LAYERED;
                }
                if (hasOutgoing) {
                    return (Icon)OUTGOING_LAYERED;
                }
            }
            Icon icon = AllIcons.Vcs.Branch;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Branch");
            return icon;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

