/*
 * Decompiled with CFR 0.152.
 */
package git4idea.status;

import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManagerGate;
import com.intellij.openapi.vcs.changes.ChangeProvider;
import com.intellij.openapi.vcs.changes.ChangelistBuilder;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.VcsDirtyScope;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.util.paths.RootDirtySet;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitContentRevision;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.GitVcsDirtyScope;
import git4idea.index.GitFileStatus;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.repo.GitSubmodule;
import git4idea.repo.GitSubmoduleKt;
import git4idea.status.GitChangesCollector;
import git4idea.status.GitRefreshListener;
import git4idea.status.GitStagingAreaHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
public final class GitChangeProvider
implements ChangeProvider {
    static final Logger LOG = Logger.getInstance((String)"#GitStatus");
    private volatile boolean isRefreshInProgress;
    @NotNull
    private final Project project;

    public GitChangeProvider(@NotNull Project project) {
        if (project == null) {
            GitChangeProvider.$$$reportNull$$$0(0);
        }
        this.isRefreshInProgress = false;
        this.project = project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getChanges(@NotNull VcsDirtyScope dirtyScope, @NotNull ChangelistBuilder builder, @NotNull ProgressIndicator progress, @NotNull ChangeListManagerGate addGate) throws VcsException {
        if (dirtyScope == null) {
            GitChangeProvider.$$$reportNull$$$0(1);
        }
        if (builder == null) {
            GitChangeProvider.$$$reportNull$$$0(2);
        }
        if (progress == null) {
            GitChangeProvider.$$$reportNull$$$0(3);
        }
        if (addGate == null) {
            GitChangeProvider.$$$reportNull$$$0(4);
        }
        ((GitRefreshListener)BackgroundTaskUtil.syncPublisher((Project)this.project, GitRefreshListener.TOPIC)).progressStarted();
        this.isRefreshInProgress = true;
        try {
            LOG.debug("initial dirty scope: ", new Object[]{dirtyScope});
            GitRepositoryManager repositoryManager = GitUtil.getRepositoryManager(this.project);
            HashMap<GitRepository, GitSubmodule> knownSubmodules = new HashMap<GitRepository, GitSubmodule>();
            for (GitRepository repository2 : GitRepositoryManager.getInstance(this.project).getRepositories()) {
                Collection<GitRepository> submodules = GitSubmoduleKt.getDirectSubmodules(repository2);
                for (GitRepository gitRepository : submodules) {
                    knownSubmodules.put(gitRepository, new GitSubmodule(gitRepository, repository2));
                }
            }
            ArrayList<FilePath> newDirtyPaths = new ArrayList<FilePath>();
            NonChangedHolder holder = new NonChangedHolder(this.project, addGate);
            Map<VirtualFile, RootDirtySet> dirtyPaths = GitStagingAreaHolder.collectDirtyPathsPerRoot((GitVcsDirtyScope)dirtyScope, knownSubmodules);
            LOG.debug("after adding nested vcs roots to dirt: ", new Object[]{dirtyPaths});
            for (Map.Entry entry : dirtyPaths.entrySet()) {
                VirtualFile root = (VirtualFile)entry.getKey();
                RootDirtySet rootDirtyPaths = (RootDirtySet)entry.getValue();
                LOG.debug("checking root: ", new Object[]{root});
                GitRepository repo2 = (GitRepository)repositoryManager.getRepositoryForRoot(root);
                if (repo2 == null) continue;
                GitStagingAreaHolder stageAreaHolder = repo2.getStagingAreaHolder();
                boolean wasEmptyStaging = stageAreaHolder.isEmpty();
                List<GitFileStatus> newChanges = stageAreaHolder.refresh(rootDirtyPaths);
                GitChangesCollector collector = GitChangesCollector.collect(this.project, repo2, newChanges);
                holder.markHeadRevision(root, collector.getHead());
                Collection<Change> changes = collector.getChanges();
                for (Change change : changes) {
                    LOG.debug("process change: ", new Object[]{change});
                    builder.processChange(change, GitVcs.getKey());
                    FilePath beforePath = ChangesUtil.getBeforePath((Change)change);
                    FilePath afterPath = ChangesUtil.getAfterPath((Change)change);
                    if (beforePath != null) {
                        holder.markPathProcessed(beforePath);
                    }
                    if (afterPath != null) {
                        holder.markPathProcessed(afterPath);
                    }
                    if (!change.isMoved() && !change.isRenamed() || dirtyScope.belongsTo(beforePath) == dirtyScope.belongsTo(afterPath)) continue;
                    LOG.debug("schedule rename check for: ", new Object[]{change});
                    newDirtyPaths.add(beforePath);
                    newDirtyPaths.add(afterPath);
                }
                GitSubmodule asSubmodule = (GitSubmodule)knownSubmodules.get(repo2);
                if (asSubmodule != null) {
                    GitChangeProvider.updateDirtyPathsForSubmodule(asSubmodule, wasEmptyStaging, dirtyPaths, newDirtyPaths);
                }
                ((GitRefreshListener)BackgroundTaskUtil.syncPublisher((Project)this.project, GitRefreshListener.TOPIC)).repositoryUpdated(repo2);
            }
            holder.feedBuilder(dirtyScope, builder);
            VcsDirtyScopeManager.getInstance((Project)this.project).filePathsDirty(newDirtyPaths, null);
        }
        finally {
            this.isRefreshInProgress = false;
            ((GitRefreshListener)BackgroundTaskUtil.syncPublisher((Project)this.project, GitRefreshListener.TOPIC)).progressStopped();
        }
    }

    private static void updateDirtyPathsForSubmodule(@NotNull GitSubmodule submodule, boolean wasEmptyStaging, @NotNull Map<VirtualFile, RootDirtySet> dirtyPaths, @NotNull List<FilePath> newDirtyPaths) {
        boolean parentThinksSubmoduleUnchanged;
        if (submodule == null) {
            GitChangeProvider.$$$reportNull$$$0(5);
        }
        if (dirtyPaths == null) {
            GitChangeProvider.$$$reportNull$$$0(6);
        }
        if (newDirtyPaths == null) {
            GitChangeProvider.$$$reportNull$$$0(7);
        }
        GitRepository submoduleRepo = submodule.getRepository();
        GitRepository parentRepo = submodule.getParent();
        VirtualFile submoduleRoot = submoduleRepo.getRoot();
        VirtualFile parentRoot = parentRepo.getRoot();
        boolean isEmptyStaging = submoduleRepo.getStagingAreaHolder().isEmpty();
        if (isEmptyStaging == wasEmptyStaging) {
            return;
        }
        FilePath submoduleRootPath = VcsUtil.getFilePath((VirtualFile)submoduleRoot);
        RootDirtySet parentDirtySet = dirtyPaths.get(parentRoot);
        if (parentDirtySet != null && parentDirtySet.belongsTo(submoduleRootPath)) {
            return;
        }
        FilePath submoduleRootPathAsFile = VcsUtil.getFilePath((String)submoduleRootPath.getPath(), (boolean)false);
        GitFileStatus record = parentRepo.getStagingAreaHolder().findRecord(submoduleRootPathAsFile);
        if (record != null && record.getStagedStatus() != null) {
            return;
        }
        boolean bl = parentThinksSubmoduleUnchanged = record == null;
        if (parentThinksSubmoduleUnchanged == isEmptyStaging) {
            return;
        }
        newDirtyPaths.add(submoduleRootPath);
    }

    public boolean isModifiedDocumentTrackingRequired() {
        return true;
    }

    public boolean isRefreshInProgress() {
        return this.isRefreshInProgress;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirtyScope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "addGate";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "submodule";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirtyPaths";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newDirtyPaths";
                break;
            }
        }
        objectArray2[1] = "git4idea/status/GitChangeProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getChanges";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "updateDirtyPathsForSubmodule";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class NonChangedHolder {
        private final Project myProject;
        private final ChangeListManagerGate myAddGate;
        private final Set<FilePath> myProcessedPaths = new HashSet<FilePath>();
        private final Map<VirtualFile, VcsRevisionNumber> myHeadRevisions = new HashMap<VirtualFile, VcsRevisionNumber>();

        private NonChangedHolder(Project project, ChangeListManagerGate addGate) {
            this.myProject = project;
            this.myAddGate = addGate;
        }

        public void markPathProcessed(@NotNull FilePath path) {
            if (path == null) {
                NonChangedHolder.$$$reportNull$$$0(0);
            }
            this.myProcessedPaths.add(path);
        }

        public void markHeadRevision(@NotNull VirtualFile root, @NotNull VcsRevisionNumber revision) {
            if (root == null) {
                NonChangedHolder.$$$reportNull$$$0(1);
            }
            if (revision == null) {
                NonChangedHolder.$$$reportNull$$$0(2);
            }
            this.myHeadRevisions.put(root, revision);
        }

        public void feedBuilder(@NotNull VcsDirtyScope dirtyScope, @NotNull ChangelistBuilder builder) throws VcsException {
            if (dirtyScope == null) {
                NonChangedHolder.$$$reportNull$$$0(3);
            }
            if (builder == null) {
                NonChangedHolder.$$$reportNull$$$0(4);
            }
            VcsKey gitKey = GitVcs.getKey();
            FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
            for (Document document : fileDocumentManager.getUnsavedDocuments()) {
                GitRepository repository2;
                VirtualFile vcsFile;
                FilePath filePath;
                VirtualFile vf = fileDocumentManager.getFile(document);
                if (vf == null || !vf.isValid() || !fileDocumentManager.isFileModified(vf) || this.myAddGate.getStatus(vf) != null || this.myProcessedPaths.contains(filePath = VcsUtil.getFilePath((VirtualFile)(vcsFile = VcsUtil.resolveSymlinkIfNeeded((Project)this.myProject, (VirtualFile)vf)))) || !dirtyScope.belongsTo(filePath) || (repository2 = (GitRepository)GitRepositoryManager.getInstance(this.myProject).getRepositoryForFile(vcsFile)) == null || repository2.getUntrackedFilesHolder().containsUntrackedFile(filePath) || repository2.getIgnoredFilesHolder().containsFile(filePath)) continue;
                VirtualFile root = repository2.getRoot();
                VcsRevisionNumber beforeRevisionNumber = this.myHeadRevisions.get(root);
                if (beforeRevisionNumber == null) {
                    beforeRevisionNumber = GitChangesCollector.getHead(repository2);
                    this.myHeadRevisions.put(root, beforeRevisionNumber);
                }
                Change change = new Change(GitContentRevision.createRevision(filePath, beforeRevisionNumber, this.myProject), GitContentRevision.createRevision(filePath, null, this.myProject), FileStatus.MODIFIED);
                LOG.debug("process in-memory change ", new Object[]{change});
                builder.processChange(change, gitKey);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "revision";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dirtyScope";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
            }
            objectArray2[1] = "git4idea/status/GitChangeProvider$NonChangedHolder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "markPathProcessed";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "markHeadRevision";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "feedBuilder";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

