/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.branch.DvcsBranchManager;
import com.intellij.dvcs.repo.RepoStateException;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.platform.util.coroutines.sync.OverflowSemaphore;
import com.intellij.platform.util.coroutines.sync.OverflowSemaphoreKt;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.impl.HashImpl;
import git4idea.GitTag;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerListener;
import git4idea.config.GitVcsSettings;
import git4idea.remoteApi.GitRepositoryFrontendSynchronizer;
import git4idea.repo.GitRefUtil;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryFiles;
import git4idea.repo.GitTagLoaderListener;
import git4idea.util.StringScanner;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.TimeoutKt;
import kotlinx.coroutines.channels.BufferOverflow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 +2\u00020\u0001:\u0001+B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001a\u001a\u00020\u0012J\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eJ\u000e\u0010\u001c\u001a\u00020\u0018H\u0082@\u00a2\u0006\u0002\u0010\u001dJ,\u0010\u001e\u001a&\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100 \u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000f0\u000e0\u001fH\u0002J8\u0010!\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020#2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100 2\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000f0 H\u0002J0\u0010&\u001a\u00020\u00182\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100 2\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000f0 H\u0002J@\u0010'\u001a\u00020\u00182\u0006\u0010(\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u00122\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100 2\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000f0 H\u0002J\r\u0010)\u001a\u00020\u0018H\u0001\u00a2\u0006\u0002\b*R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lgit4idea/repo/GitTagHolder;", "", "repository", "Lgit4idea/repo/GitRepository;", "<init>", "(Lgit4idea/repo/GitRepository;)V", "getRepository", "()Lgit4idea/repo/GitRepository;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "repositoryFiles", "Lgit4idea/repo/GitRepositoryFiles;", "Lorg/jetbrains/annotations/NotNull;", "tagsWithHashes", "", "Lgit4idea/GitTag;", "Lcom/intellij/vcs/log/Hash;", "hashToTagCache", "", "updateSemaphore", "Lcom/intellij/platform/util/coroutines/sync/OverflowSemaphore;", "isEnabled", "", "reload", "", "getTag", "hash", "getTags", "updateState", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "loadTagsForRepo", "Lkotlin/Pair;", "", "readPackedTags", "myPackedRefsFile", "Ljava/io/File;", "tags", "cache", "readTagsFromGit", "putValue", "tagName", "ensureUpToDateForTests", "ensureUpToDateForTests$intellij_vcs_git", "Companion", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitTagHolder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitTagHolder.kt\ngit4idea/repo/GitTagHolder\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,209:1\n14#2:210\n*S KotlinDebug\n*F\n+ 1 GitTagHolder.kt\ngit4idea/repo/GitTagHolder\n*L\n202#1:210\n*E\n"})
public final class GitTagHolder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GitRepository repository;
    @NotNull
    private final CoroutineScope cs;
    @NotNull
    private final GitRepositoryFiles repositoryFiles;
    @NotNull
    private Map<GitTag, ? extends Hash> tagsWithHashes;
    @NotNull
    private Map<String, GitTag> hashToTagCache;
    @NotNull
    private final OverflowSemaphore updateSemaphore;
    private boolean isEnabled;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final Topic<GitTagLoaderListener> GIT_TAGS_LOADED;

    public GitTagHolder(@NotNull GitRepository repository2) {
        Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
        this.repository = repository2;
        CoroutineScope coroutineScope = this.repository.getCoroutineScope();
        Intrinsics.checkNotNullExpressionValue((Object)coroutineScope, (String)"getCoroutineScope(...)");
        this.cs = CoroutineScopeKt.childScope$default((CoroutineScope)coroutineScope, (String)"GitTagHolder", null, (boolean)false, (int)6, null);
        GitRepositoryFiles gitRepositoryFiles = this.repository.getRepositoryFiles();
        Intrinsics.checkNotNullExpressionValue((Object)gitRepositoryFiles, (String)"getRepositoryFiles(...)");
        this.repositoryFiles = gitRepositoryFiles;
        this.tagsWithHashes = MapsKt.emptyMap();
        this.hashToTagCache = MapsKt.emptyMap();
        this.updateSemaphore = OverflowSemaphoreKt.OverflowSemaphore$default((int)0, (BufferOverflow)BufferOverflow.DROP_OLDEST, (int)1, null);
        this.isEnabled = GitVcsSettings.getInstance(this.repository.getProject()).showTags();
        SimpleMessageBusConnection simpleMessageBusConnection = this.repository.getProject().getMessageBus().connect(this.cs);
        Topic topic = DvcsBranchManager.DVCS_BRANCH_SETTINGS_CHANGED;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"DVCS_BRANCH_SETTINGS_CHANGED");
        simpleMessageBusConnection.subscribe(topic, (Object)new DvcsBranchManager.DvcsBranchManagerListener(){

            public void showTagsSettingsChanged(boolean state2) {
                isEnabled = state2;
                this.reload();
            }
        });
    }

    @NotNull
    public final GitRepository getRepository() {
        return this.repository;
    }

    public final void reload() {
        BuildersKt.launch$default((CoroutineScope)this.cs, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ GitTagHolder this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = GitTagHolder.access$getUpdateSemaphore$p(this.this$0).withPermit((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            final /* synthetic */ GitTagHolder this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object $result) {
                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.label = 1;
                                        Object object2 = GitTagHolder.access$updateState(this.this$0, (Continuation)this);
                                        if (object2 != object) return Unit.INSTANCE;
                                        return object;
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object2 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }, (Continuation)this);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    @Nullable
    public final GitTag getTag(@NotNull String hash) {
        Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
        return this.hashToTagCache.get(hash);
    }

    @NotNull
    public final Map<GitTag, Hash> getTags() {
        return this.tagsWithHashes;
    }

    private final Object updateState(Continuation<? super Unit> $completion) {
        if (this.isEnabled) {
            Pair<Map<GitTag, Hash>, Map<String, GitTag>> tags2 = this.loadTagsForRepo();
            this.tagsWithHashes = (Map)tags2.getFirst();
            this.hashToTagCache = (Map)tags2.getSecond();
            ((GitRepositoryFrontendSynchronizer)BackgroundTaskUtil.syncPublisher((Project)this.repository.getProject(), GitRepositoryFrontendSynchronizer.TOPIC)).tagsLoaded(this.repository);
            ((GitTagLoaderListener)BackgroundTaskUtil.syncPublisher((Project)this.repository.getProject(), GIT_TAGS_LOADED)).tagsLoaded(this.repository);
        } else {
            this.tagsWithHashes = MapsKt.emptyMap();
            this.hashToTagCache = MapsKt.emptyMap();
        }
        return Unit.INSTANCE;
    }

    private final Pair<Map<GitTag, Hash>, Map<String, GitTag>> loadTagsForRepo() {
        Map tags2 = new LinkedHashMap();
        Map cache2 = new LinkedHashMap();
        if (Registry.Companion.is("git.read.branches.from.disk")) {
            File file = this.repositoryFiles.getPackedRefsPath();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getPackedRefsPath(...)");
            this.readPackedTags(file, tags2, cache2);
            GitRefUtil.readFromRefsFiles(this.repositoryFiles.getRefsTagsFile(), "refs/tags/", this.repositoryFiles, (arg_0, arg_1) -> GitTagHolder.loadTagsForRepo$lambda$0(this, tags2, cache2, arg_0, arg_1));
        } else {
            this.readTagsFromGit(tags2, cache2);
        }
        return TuplesKt.to((Object)tags2, (Object)cache2);
    }

    private final void readPackedTags(File myPackedRefsFile, Map<GitTag, Hash> tags2, Map<String, GitTag> cache2) {
        if (!myPackedRefsFile.exists()) {
            return;
        }
        try {
            String string = DvcsUtil.tryLoadFile((File)myPackedRefsFile, (String)"UTF-8");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"tryLoadFile(...)");
            String content = string;
            StringScanner scanner = new StringScanner(content);
            while (scanner.hasMoreData()) {
                char c = scanner.peek();
                if (c == '#') {
                    scanner.nextLine();
                    continue;
                }
                if (c == '^') {
                    scanner.nextLine();
                    continue;
                }
                String hash = scanner.spaceToken();
                String reference = scanner.line();
                Intrinsics.checkNotNull((Object)reference);
                if (StringsKt.isBlank((CharSequence)reference) || !StringsKt.startsWith$default((String)reference, (String)"refs/tags/", (boolean)false, (int)2, null)) continue;
                if (scanner.hasMoreData() && scanner.peek() == '^') {
                    scanner.skipChars(1);
                    String realHash = scanner.line();
                    Intrinsics.checkNotNull((Object)realHash);
                    this.putValue(reference, realHash, tags2, cache2);
                    continue;
                }
                Intrinsics.checkNotNull((Object)hash);
                this.putValue(reference, hash, tags2, cache2);
            }
        }
        catch (RepoStateException e) {
            LOG.info((Throwable)e);
        }
    }

    private final void readTagsFromGit(Map<GitTag, Hash> tags2, Map<String, GitTag> cache2) {
        try {
            GitLineHandler handler = new GitLineHandler(this.repository.getProject(), this.repository.getRoot(), GitCommand.FOR_EACH_REF);
            String[] stringArray = new String[]{"refs/tags/**"};
            handler.addParameters(stringArray);
            stringArray = new String[]{"--no-color"};
            handler.addParameters(stringArray);
            stringArray = new String[]{"--format=%(refname)\t%(objectname)"};
            handler.addParameters(stringArray);
            handler.addLineListener(new GitLineHandlerListener(this, tags2, cache2){
                private int badLineReported;
                final /* synthetic */ GitTagHolder this$0;
                final /* synthetic */ Map<GitTag, Hash> $tags;
                final /* synthetic */ Map<String, GitTag> $cache;
                {
                    this.this$0 = $receiver;
                    this.$tags = $tags;
                    this.$cache = $cache;
                }

                public void onLineAvailable(String line, Key<?> outputType) {
                    block5: {
                        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
                        Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
                        try {
                            if (Intrinsics.areEqual(outputType, (Object)ProcessOutputType.STDOUT)) {
                                StringScanner scanner = new StringScanner(line);
                                String string = scanner.tabToken();
                                if (string == null) {
                                    return;
                                }
                                String tagName = string;
                                String string2 = scanner.line();
                                if (string2 == null) {
                                    return;
                                }
                                String tagHash = string2;
                                GitTagHolder.access$putValue(this.this$0, tagName, tagHash, this.$tags, this.$cache);
                            }
                        }
                        catch (VcsException e) {
                            int n = this.badLineReported;
                            this.badLineReported = n + 1;
                            if (this.badLineReported >= 5) break block5;
                            GitTagHolder.access$getLOG$cp().warn("Unexpected branch output: " + line, (Throwable)e);
                        }
                    }
                }
            });
            Git.getInstance().runCommand(handler).throwOnError(new int[0]);
        }
        catch (VcsException e) {
            LOG.info((Throwable)e);
        }
    }

    private final void putValue(String tagName, String hash, Map<GitTag, Hash> tags2, Map<String, GitTag> cache2) {
        GitTag gitTag = new GitTag(tagName);
        cache2.put(hash, gitTag);
        tags2.put(gitTag, HashImpl.build((String)hash));
    }

    @TestOnly
    public final void ensureUpToDateForTests$intellij_vcs_git() {
        CoroutinesKt.runBlockingMaybeCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ GitTagHolder this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            final /* synthetic */ GitTagHolder this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object $result) {
                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.label = 1;
                                        Object object2 = TimeoutKt.withTimeout-KLykuaI((long)DurationKt.toDuration((int)3, (DurationUnit)DurationUnit.MINUTES), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                                            int label;
                                            final /* synthetic */ GitTagHolder this$0;
                                            {
                                                this.this$0 = $receiver;
                                                super(2, $completion);
                                            }

                                            /*
                                             * Enabled force condition propagation
                                             * Lifted jumps to return sites
                                             */
                                            public final Object invokeSuspend(Object $result) {
                                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                switch (this.label) {
                                                    case 0: {
                                                        ResultKt.throwOnFailure((Object)$result);
                                                        this.label = 1;
                                                        Object object2 = GitTagHolder.access$getUpdateSemaphore$p(this.this$0).withPermit((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                                                            int label;
                                                            final /* synthetic */ GitTagHolder this$0;
                                                            {
                                                                this.this$0 = $receiver;
                                                                super(2, $completion);
                                                            }

                                                            /*
                                                             * Enabled force condition propagation
                                                             * Lifted jumps to return sites
                                                             */
                                                            public final Object invokeSuspend(Object $result) {
                                                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                                switch (this.label) {
                                                                    case 0: {
                                                                        ResultKt.throwOnFailure((Object)$result);
                                                                        this.label = 1;
                                                                        Object object2 = GitTagHolder.access$updateState(this.this$0, (Continuation)this);
                                                                        if (object2 != object) return Unit.INSTANCE;
                                                                        return object;
                                                                    }
                                                                    case 1: {
                                                                        ResultKt.throwOnFailure((Object)$result);
                                                                        Object object2 = $result;
                                                                        return Unit.INSTANCE;
                                                                    }
                                                                }
                                                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                            }

                                                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                                            }

                                                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                                            }
                                                        }, (Continuation)this);
                                                        if (object2 != object) return Unit.INSTANCE;
                                                        return object;
                                                    }
                                                    case 1: {
                                                        ResultKt.throwOnFailure((Object)$result);
                                                        Object object2 = $result;
                                                        return Unit.INSTANCE;
                                                    }
                                                }
                                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                            }

                                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                            }

                                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                            }
                                        }), (Continuation)((Continuation)this));
                                        if (object2 != object) return Unit.INSTANCE;
                                        return object;
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object2 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    private static final void loadTagsForRepo$lambda$0(GitTagHolder this$0, Map $tags, Map $cache, String tag, String hash) {
        Intrinsics.checkNotNull((Object)tag);
        Intrinsics.checkNotNull((Object)hash);
        this$0.putValue(tag, hash, $tags, $cache);
    }

    public static final /* synthetic */ OverflowSemaphore access$getUpdateSemaphore$p(GitTagHolder $this) {
        return $this.updateSemaphore;
    }

    public static final /* synthetic */ Object access$updateState(GitTagHolder $this, Continuation $completion) {
        return $this.updateState((Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ void access$putValue(GitTagHolder $this, String tagName, String hash, Map tags2, Map cache2) {
        $this.putValue(tagName, hash, tags2, cache2);
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GitTagHolder.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        Topic topic = Topic.create((String)"GitTags loaded", GitTagLoaderListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"create(...)");
        GIT_TAGS_LOADED = topic;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lgit4idea/repo/GitTagHolder$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "GIT_TAGS_LOADED", "Lcom/intellij/util/messages/Topic;", "Lgit4idea/repo/GitTagLoaderListener;", "getGIT_TAGS_LOADED", "()Lcom/intellij/util/messages/Topic;", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Topic<GitTagLoaderListener> getGIT_TAGS_LOADED() {
            return GIT_TAGS_LOADED;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

