/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.java.i18n.JavaI18nBundle;
import com.intellij.lang.properties.PropertiesFileType;
import com.intellij.lang.properties.PropertiesInspectionBase;
import com.intellij.lang.properties.charset.Native2AsciiCharset;
import com.intellij.lang.properties.psi.Property;
import com.intellij.lang.properties.references.PropertyReference;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.fileTypes.CharsetUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingRegistry;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiUtil;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnsupportedCharacterInspection
extends PropertiesInspectionBase {
    private static final Charset OLD_JAVA_DEFAULT_CHARSET = StandardCharsets.ISO_8859_1;
    private static final Charset NEW_JAVA_DEFAULT_CHARSET = StandardCharsets.UTF_8;

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            UnsupportedCharacterInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            UnsupportedCharacterInspection.$$$reportNull$$$0(1);
        }
        return new PsiElementVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                PsiReference[] references;
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitElement(element);
                if (PsiUtil.isAvailable((JavaFeature)JavaFeature.UTF8_PROPERTY_FILES, (PsiElement)element)) {
                    return;
                }
                for (PsiReference reference : references = element.getReferences()) {
                    Property property;
                    PropertyReference propertyReference;
                    PsiElement psiElement;
                    if (!(reference instanceof PropertyReference) || !((psiElement = (propertyReference = (PropertyReference)reference).resolve()) instanceof Property) || !this.elementHasError(element, property = (Property)psiElement)) continue;
                    return;
                }
            }

            private boolean elementHasError(@NotNull PsiElement element, @Nullable Property property) {
                if (element == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (property == null) {
                    return false;
                }
                PsiFile psiFile = property.getContainingFile();
                if (psiFile.getFileType() != PropertiesFileType.INSTANCE) {
                    return false;
                }
                VirtualFile file = psiFile.getVirtualFile();
                if (file == null) {
                    return false;
                }
                EncodingRegistry encoding = EncodingRegistry.getInstance();
                boolean isCustomized = encoding.isNative2Ascii(file) || encoding.getDefaultCharsetForPropertiesFiles(file) != null || encoding.getEncoding(file, true) != NEW_JAVA_DEFAULT_CHARSET;
                return !isCustomized && this.hasErrorCharacter(element, property.getValue());
            }

            private boolean hasErrorCharacter(@NotNull PsiElement element, @Nullable String value) {
                if (element == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (value == null) {
                    return false;
                }
                TextRange error = CharsetUtil.findUnmappableCharacters((CharSequence)value, (Charset)OLD_JAVA_DEFAULT_CHARSET);
                if (error == null) {
                    return false;
                }
                holder.registerProblem(element, JavaI18nBundle.message("unsupported.character.problem.descriptor", OLD_JAVA_DEFAULT_CHARSET.displayName()), ProblemHighlightType.WEAK_WARNING, new LocalQuickFix[]{new EncodePropertyFix()});
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "element";
                objectArray2[1] = "com/intellij/lang/properties/UnsupportedCharacterInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitElement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "elementHasError";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "hasErrorCharacter";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/properties/UnsupportedCharacterInspection";
        objectArray[2] = "buildVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class EncodePropertyFix
    extends PsiUpdateModCommandQuickFix {
        private EncodePropertyFix() {
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiReference[] references;
            if (project == null) {
                EncodePropertyFix.$$$reportNull$$$0(0);
            }
            if (element == null) {
                EncodePropertyFix.$$$reportNull$$$0(1);
            }
            if (updater == null) {
                EncodePropertyFix.$$$reportNull$$$0(2);
            }
            if (PsiUtil.isAvailable((JavaFeature)JavaFeature.UTF8_PROPERTY_FILES, (PsiElement)element)) {
                return;
            }
            for (PsiReference reference : references = element.getReferences()) {
                Property property;
                String propertyValue;
                TextRange errorValue;
                PropertyReference propertyReference;
                PsiElement psiElement;
                if (!(reference instanceof PropertyReference) || !((psiElement = (propertyReference = (PropertyReference)reference).resolve()) instanceof Property) || (errorValue = CharsetUtil.findUnmappableCharacters((CharSequence)(propertyValue = (property = (Property)psiElement).getValue()), (Charset)OLD_JAVA_DEFAULT_CHARSET)) == null) continue;
                ByteBuffer encoded = Native2AsciiCharset.wrap((Charset)OLD_JAVA_DEFAULT_CHARSET).encode(propertyValue);
                String newValue = OLD_JAVA_DEFAULT_CHARSET.decode(encoded).toString();
                ((Property)updater.getWritable((PsiElement)property)).setValue(newValue);
                break;
            }
        }

        @NotNull
        public String getFamilyName() {
            String string = JavaI18nBundle.message("unsupported.character.inspection.fix.description", new Object[0]);
            if (string == null) {
                EncodePropertyFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/properties/UnsupportedCharacterInspection$EncodePropertyFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/properties/UnsupportedCharacterInspection$EncodePropertyFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }
}

