/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang.java6;

import com.intellij.openapi.diagnostic.LoggerRt;
import com.intellij.util.lang.java6.ClasspathCache;
import com.intellij.util.lang.java6.FileLoader;
import com.intellij.util.lang.java6.JarLoader;
import com.intellij.util.lang.java6.Loader;
import com.intellij.util.lang.java6.Resource;
import com.intellij.util.lang.java6.SecureJarLoader;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClassPath {
    private static final ResourceStringLoaderIterator ourResourceIterator = new ResourceStringLoaderIterator();
    private static final LoaderCollector ourLoaderCollector = new LoaderCollector();
    public static final String CLASSPATH_JAR_FILE_NAME_PREFIX = "classpath";
    static final boolean recordLoadingInfo = Boolean.getBoolean("idea.log.classpath.info");
    static final boolean recordLoadingStats = recordLoadingInfo || Boolean.getBoolean("idea.record.classloading.stats");
    private static final Set<String> loadedClassNames;
    private static final AtomicLong ourTotalTime;
    private static final AtomicInteger ourTotalRequests;
    private static final ThreadLocal<Boolean> doingTiming;
    private final List<URL> myUrls;
    private final List<Loader> myLoaders;
    private volatile boolean myAllUrlsWereProcessed;
    private final AtomicInteger myLastLoaderProcessed;
    private final Map<URL, Loader> myLoadersMap;
    private final ClasspathCache myCache;
    private final Set<URL> myURLsWithProtectionDomain;
    final boolean myCanLockJars;
    private final boolean myCanUseCache;
    private final boolean myAcceptUnescapedUrls;
    final boolean myCanHavePersistentIndex;
    final boolean myLazyClassloadingCaches;
    final boolean myLogErrorOnMissingJar;

    public ClassPath(List<URL> urls, boolean canLockJars, boolean canUseCache, boolean canHavePersistentIndex, boolean logErrorOnMissingJar, boolean lazyClassloadingCaches, @NotNull Set<URL> urlsWithProtectionDomain) {
        if (urlsWithProtectionDomain == null) {
            ClassPath.$$$reportNull$$$0(0);
        }
        this.myUrls = new ArrayList<URL>();
        this.myLoaders = new ArrayList<Loader>();
        this.myLastLoaderProcessed = new AtomicInteger();
        this.myLoadersMap = new HashMap<URL, Loader>();
        this.myCache = new ClasspathCache();
        this.myLazyClassloadingCaches = lazyClassloadingCaches;
        this.myCanLockJars = canLockJars;
        this.myCanUseCache = canUseCache && !this.myLazyClassloadingCaches;
        this.myAcceptUnescapedUrls = false;
        this.myCanHavePersistentIndex = canHavePersistentIndex;
        this.myLogErrorOnMissingJar = logErrorOnMissingJar;
        this.myURLsWithProtectionDomain = urlsWithProtectionDomain;
        this.push(urls);
    }

    public static long getTotalTime() {
        return ourTotalTime.get();
    }

    public static long getTotalRequests() {
        return ourTotalRequests.get();
    }

    @Deprecated
    void addURL(URL url) {
        this.push(Collections.singletonList(url));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void push(List<URL> urls) {
        if (!urls.isEmpty()) {
            List<URL> list = this.myUrls;
            synchronized (list) {
                for (int i = urls.size() - 1; i >= 0; --i) {
                    this.myUrls.add(urls.get(i));
                }
                this.myAllUrlsWereProcessed = false;
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Nullable
    public Resource getResource(@NotNull String s) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 3[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Enumeration<URL> getResources(String name) {
        return new MyEnumeration(name);
    }

    @Nullable
    private Loader getLoader(int i) {
        if (i < this.myLastLoaderProcessed.get()) {
            return this.myLoaders.get(i);
        }
        return this.getLoaderSlowPath(i);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private synchronized Loader getLoaderSlowPath(int i) {
        while (this.myLoaders.size() < i + 1) {
            URL url;
            List<URL> list = this.myUrls;
            synchronized (list) {
                int size = this.myUrls.size();
                if (size == 0) {
                    if (this.myCanUseCache) {
                        this.myAllUrlsWereProcessed = true;
                    }
                    return null;
                }
                url = this.myUrls.remove(size - 1);
            }
            if (this.myLoadersMap.containsKey(url)) continue;
            try {
                this.initLoaders(url);
            }
            catch (IOException e) {
                LoggerRt.getInstance(ClassPath.class).info("url: " + url, (Throwable)e);
            }
        }
        return this.myLoaders.get(i);
    }

    private void initLoaders(@NotNull URL url) throws IOException {
        File file;
        Loader loader;
        String path;
        if (url == null) {
            ClassPath.$$$reportNull$$$0(2);
        }
        if (this.myAcceptUnescapedUrls) {
            path = url.getFile();
        } else {
            try {
                path = url.toURI().getSchemeSpecificPart();
            }
            catch (URISyntaxException e) {
                LoggerRt.getInstance(ClassPath.class).error("url: " + url, (Throwable)e);
                path = url.getFile();
            }
        }
        if (path != null && "file".equals(url.getProtocol()) && (loader = this.createLoader(url, file = new File(path), file.getName().startsWith(CLASSPATH_JAR_FILE_NAME_PREFIX))) != null) {
            this.initLoader(url, loader);
        }
    }

    private Loader createLoader(@NotNull URL url, @NotNull File file, boolean processRecursively) throws IOException {
        String[] referencedJars;
        JarLoader loader;
        if (url == null) {
            ClassPath.$$$reportNull$$$0(3);
        }
        if (file == null) {
            ClassPath.$$$reportNull$$$0(4);
        }
        if (file.isDirectory()) {
            return new FileLoader(url, this);
        }
        if (!file.isFile()) {
            return null;
        }
        boolean isSigned = this.myURLsWithProtectionDomain.contains(url);
        JarLoader jarLoader = loader = isSigned ? new SecureJarLoader(url, file.getPath(), this) : new JarLoader(url, file.getPath(), this);
        if (processRecursively && (referencedJars = ClassPath.loadManifestClasspath(loader)) != null) {
            long s2 = recordLoadingInfo ? System.nanoTime() : 0L;
            ArrayList<URL> urls = new ArrayList<URL>(referencedJars.length);
            for (String referencedJar : referencedJars) {
                try {
                    urls.add(new URI(referencedJar).toURL());
                }
                catch (Exception e) {
                    LoggerRt.getInstance(ClassPath.class).warn("url: " + url + " / " + referencedJar, (Throwable)e);
                }
            }
            this.push(urls);
            if (recordLoadingInfo) {
                System.out.println("Loaded all " + referencedJars.length + " urls " + (System.nanoTime() - s2) / 1000000L + "ms");
            }
        }
        return loader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initLoader(@NotNull URL url, @NotNull Loader loader) throws IOException {
        if (url == null) {
            ClassPath.$$$reportNull$$$0(5);
        }
        if (loader == null) {
            ClassPath.$$$reportNull$$$0(6);
        }
        if (this.myCanUseCache) {
            boolean lastOne;
            ClasspathCache.LoaderData data = loader.buildData();
            this.myCache.applyLoaderData(data, loader);
            List<URL> list = this.myUrls;
            synchronized (list) {
                lastOne = this.myUrls.isEmpty();
            }
            if (lastOne) {
                this.myAllUrlsWereProcessed = true;
            }
        }
        this.myLoaders.add(loader);
        this.myLoadersMap.put(url, loader);
        this.myLastLoaderProcessed.incrementAndGet();
    }

    private static long startTiming() {
        if (!recordLoadingStats || doingTiming.get() != null) {
            return 0L;
        }
        doingTiming.set(Boolean.TRUE);
        return System.nanoTime();
    }

    private static void logInfo(ClassPath path, long started, String resourceName, Resource resource) {
        if (resource != null && recordLoadingInfo) {
            loadedClassNames.add(resource.getURL().getPath());
        }
        if (started == 0L || !recordLoadingStats) {
            return;
        }
        doingTiming.remove();
        long time = System.nanoTime() - started;
        long totalTime = ourTotalTime.addAndGet(time);
        int totalRequests = ourTotalRequests.incrementAndGet();
        if (recordLoadingInfo) {
            if (time > 3000000L) {
                System.out.println(time / 1000000L + " ms for " + resourceName);
            }
            if (totalRequests % 10000 == 0) {
                System.out.println(path.getClass().getClassLoader() + ", requests:" + ourTotalRequests + ", time:" + totalTime / 1000000L + "ms");
            }
        }
    }

    private static String[] loadManifestClasspath(JarLoader loader) {
        try {
            String[] urls;
            String classPath = loader.getClassPathManifestAttribute();
            if (classPath != null && (urls = classPath.split(" ")).length > 0 && urls[0].startsWith("file:")) {
                return urls;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    static {
        ourTotalTime = new AtomicLong();
        ourTotalRequests = new AtomicInteger();
        doingTiming = new ThreadLocal();
        Set<Object> set = loadedClassNames = recordLoadingInfo ? Collections.newSetFromMap(new ConcurrentHashMap()) : null;
        if (recordLoadingInfo) {
            Runtime.getRuntime().addShutdownHook(new Thread("Shutdown hook for tracing classloading information"){

                @Override
                public void run() {
                    System.out.println("Classloading requests: " + ClassPath.class.getClassLoader() + "," + ourTotalRequests + ", time:" + ourTotalTime.get() / 1000000L + "ms");
                }
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urlsWithProtectionDomain";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loader";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/lang/java6/ClassPath";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getResource";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "initLoaders";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createLoader";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "initLoader";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class LoaderCollector
    extends ClasspathCache.LoaderIterator<Object, Collection<Loader>, Object> {
        private LoaderCollector() {
        }

        @Override
        Object process(@NotNull Loader loader, @NotNull Collection<Loader> parameter, @NotNull Object parameter2, @NotNull String shortName) {
            if (loader == null) {
                LoaderCollector.$$$reportNull$$$0(0);
            }
            if (parameter == null) {
                LoaderCollector.$$$reportNull$$$0(1);
            }
            if (parameter2 == null) {
                LoaderCollector.$$$reportNull$$$0(2);
            }
            if (shortName == null) {
                LoaderCollector.$$$reportNull$$$0(3);
            }
            parameter.add(loader);
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "loader";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameter";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameter2";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "shortName";
                    break;
                }
            }
            objectArray[1] = "com/intellij/util/lang/java6/ClassPath$LoaderCollector";
            objectArray[2] = "process";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class ResourceStringLoaderIterator
    extends ClasspathCache.LoaderIterator<Resource, String, ClassPath> {
        private ResourceStringLoaderIterator() {
        }

        @Override
        Resource process(@NotNull Loader loader, @NotNull String s, @NotNull ClassPath classPath, @NotNull String shortName) {
            if (loader == null) {
                ResourceStringLoaderIterator.$$$reportNull$$$0(0);
            }
            if (s == null) {
                ResourceStringLoaderIterator.$$$reportNull$$$0(1);
            }
            if (classPath == null) {
                ResourceStringLoaderIterator.$$$reportNull$$$0(2);
            }
            if (shortName == null) {
                ResourceStringLoaderIterator.$$$reportNull$$$0(3);
            }
            return loader.containsName(s, shortName) ? ResourceStringLoaderIterator.findInLoader(loader, s) : null;
        }

        @Nullable
        private static Resource findInLoader(@NotNull Loader loader, @NotNull String s) {
            if (loader == null) {
                ResourceStringLoaderIterator.$$$reportNull$$$0(4);
            }
            if (s == null) {
                ResourceStringLoaderIterator.$$$reportNull$$$0(5);
            }
            return loader.getResource(s);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "loader";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "s";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classPath";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "shortName";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/util/lang/java6/ClassPath$ResourceStringLoaderIterator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "process";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findInLoader";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class MyEnumeration
    implements Enumeration<URL> {
        private int myIndex;
        private Resource myRes;
        @NotNull
        private final String myName;
        private final String myShortName;
        private final List<Loader> myLoaders;

        MyEnumeration(String name) {
            if (name == null) {
                MyEnumeration.$$$reportNull$$$0(0);
            }
            this.myName = name;
            this.myShortName = ClasspathCache.transformName(name);
            ArrayList loaders = null;
            if (ClassPath.this.myCanUseCache && ClassPath.this.myAllUrlsWereProcessed) {
                LinkedHashSet loadersSet = new LinkedHashSet();
                ClassPath.this.myCache.iterateLoaders(name, ourLoaderCollector, loadersSet, this, this.myShortName);
                if (name.endsWith("/")) {
                    ClassPath.this.myCache.iterateLoaders(name.substring(0, name.length() - 1), ourLoaderCollector, loadersSet, this, this.myShortName);
                } else {
                    ClassPath.this.myCache.iterateLoaders(name + "/", ourLoaderCollector, loadersSet, this, this.myShortName);
                }
                loaders = new ArrayList(loadersSet);
            }
            this.myLoaders = loaders;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean next() {
            if (this.myRes != null) {
                return true;
            }
            long started = ClassPath.startTiming();
            try {
                if (this.myLoaders != null) {
                    while (this.myIndex < this.myLoaders.size()) {
                        Loader loader;
                        if (!(loader = this.myLoaders.get(this.myIndex++)).containsName(this.myName, this.myShortName)) {
                            this.myRes = null;
                            continue;
                        }
                        this.myRes = loader.getResource(this.myName);
                        if (this.myRes == null) continue;
                        boolean bl = true;
                        return bl;
                    }
                } else {
                    Loader loader;
                    while ((loader = ClassPath.this.getLoader(this.myIndex++)) != null) {
                        if (ClassPath.this.myCanUseCache && !loader.containsName(this.myName, this.myShortName)) continue;
                        this.myRes = loader.getResource(this.myName);
                        if (this.myRes == null) continue;
                        boolean bl = true;
                        return bl;
                    }
                }
            }
            finally {
                ClassPath.logInfo(ClassPath.this, started, this.myName, null);
            }
            return false;
        }

        @Override
        public boolean hasMoreElements() {
            return this.next();
        }

        @Override
        public URL nextElement() {
            if (!this.next()) {
                throw new NoSuchElementException();
            }
            Resource resource = this.myRes;
            this.myRes = null;
            return resource.getURL();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/util/lang/java6/ClassPath$MyEnumeration", "<init>"));
        }
    }
}

