/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.ide.trustedProjects.TrustedProjectsListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.CheckoutProvider;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsConsoleLine;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.VcsRootChecker;
import com.intellij.openapi.vcs.VcsRootSettings;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.VcsShowSettingOption;
import com.intellij.openapi.vcs.VirtualFileFilter;
import com.intellij.openapi.vcs.changes.VcsAnnotationLocalChangesListener;
import com.intellij.openapi.vcs.checkout.CompositeCheckoutListener;
import com.intellij.openapi.vcs.ex.ProjectLevelVcsManagerEx;
import com.intellij.openapi.vcs.history.VcsHistoryCache;
import com.intellij.openapi.vcs.impl.ContentRevisionCache;
import com.intellij.openapi.vcs.impl.DefaultVcsRootChecker;
import com.intellij.openapi.vcs.impl.OptionsAndConfirmationsHolder;
import com.intellij.openapi.vcs.impl.VcsCacheManager;
import com.intellij.openapi.vcs.impl.VcsDescriptor;
import com.intellij.openapi.vcs.impl.VcsInitObject;
import com.intellij.openapi.vcs.impl.VcsInitialization;
import com.intellij.openapi.vcs.impl.VcsRootIterator;
import com.intellij.openapi.vcs.impl.VcsStartupActivity;
import com.intellij.openapi.vcs.impl.projectlevelman.AllVcses;
import com.intellij.openapi.vcs.impl.projectlevelman.MappingsToRoots;
import com.intellij.openapi.vcs.impl.projectlevelman.NewMappings;
import com.intellij.openapi.vcs.impl.projectlevelman.OptionsAndConfirmations;
import com.intellij.openapi.vcs.impl.projectlevelman.PersistentVcsShowConfirmationOption;
import com.intellij.openapi.vcs.impl.projectlevelman.PersistentVcsShowSettingOption;
import com.intellij.openapi.vcs.update.ActionInfo;
import com.intellij.openapi.vcs.update.UpdateInfoTree;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.project.ProjectKt;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.ContentUtilEx;
import com.intellij.util.Processor;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.vcs.ViewUpdateInfoNotification;
import com.intellij.vcs.console.VcsConsoleTabService;
import com.intellij.vcsUtil.VcsImplUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import kotlin.Pair;
import kotlinx.coroutines.CoroutineScope;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@State(name="VcsDirectoryMappings", storages={@Storage(value="vcs.xml")})
public final class ProjectLevelVcsManagerImpl
extends ProjectLevelVcsManagerEx
implements PersistentStateComponent<Element>,
Disposable {
    private static final Logger LOG = Logger.getInstance(ProjectLevelVcsManagerImpl.class);
    private final NewMappings myMappings;
    private final Project myProject;
    @NonNls
    private static final String ELEMENT_MAPPING = "mapping";
    @NonNls
    private static final String ATTRIBUTE_DIRECTORY = "directory";
    @NonNls
    private static final String ATTRIBUTE_VCS = "vcs";
    @NonNls
    private static final String ELEMENT_ROOT_SETTINGS = "rootSettings";
    @NonNls
    private static final String ATTRIBUTE_CLASS = "class";
    private boolean myMappingsLoaded;
    @NotNull
    private final AtomicInteger myBackgroundOperationCounter;
    private final Set<ActionKey> myBackgroundRunningTasks;

    public ProjectLevelVcsManagerImpl(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        if (project == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(0);
        }
        if (coroutineScope == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(1);
        }
        this.myBackgroundOperationCounter = new AtomicInteger();
        this.myBackgroundRunningTasks = ConcurrentCollectionFactory.createConcurrentSet();
        this.myProject = project;
        this.myMappings = new NewMappings(this.myProject, this, coroutineScope);
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myMappings);
    }

    public static ProjectLevelVcsManagerImpl getInstanceImpl(@NotNull Project project) {
        if (project == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(2);
        }
        return (ProjectLevelVcsManagerImpl)ProjectLevelVcsManagerImpl.getInstance((Project)project);
    }

    @TestOnly
    public void registerVcs(AbstractVcs vcs) {
        AllVcses.getInstance(this.myProject).registerManually(vcs);
    }

    @Nullable
    public AbstractVcs findVcsByName(@Nullable String name) {
        if (name == null) {
            return null;
        }
        AbstractVcs vcs = AllVcses.getInstance(this.myProject).getByName(name);
        if (vcs == null && this.myProject.isDisposed()) {
            ReadAction.run(ProgressManager::checkCanceled);
        }
        return vcs;
    }

    @Nullable
    public VcsDescriptor getDescriptor(String name) {
        if (name == null) {
            return null;
        }
        if (this.myProject.isDisposed()) {
            return null;
        }
        return AllVcses.getInstance(this.myProject).getDescriptor(name);
    }

    public void iterateVfUnderVcsRoot(VirtualFile file, Processor<? super VirtualFile> processor2) {
        VcsRootIterator.iterateVfUnderVcsRoot(this.myProject, file, processor2);
    }

    public VcsDescriptor[] getAllVcss() {
        return AllVcses.getInstance(this.myProject).getAll();
    }

    public AbstractVcs @NotNull [] getAllSupportedVcss() {
        AbstractVcs[] abstractVcsArray = AllVcses.getInstance(this.myProject).getSupportedVcses();
        if (abstractVcsArray == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(3);
        }
        return abstractVcsArray;
    }

    public boolean haveVcses() {
        return !AllVcses.getInstance(this.myProject).isEmpty();
    }

    @NotNull
    public VcsAnnotationLocalChangesListener getAnnotationLocalChangesListener() {
        VcsAnnotationLocalChangesListener vcsAnnotationLocalChangesListener = (VcsAnnotationLocalChangesListener)this.myProject.getService(VcsAnnotationLocalChangesListener.class);
        if (vcsAnnotationLocalChangesListener == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(4);
        }
        return vcsAnnotationLocalChangesListener;
    }

    public boolean checkAllFilesAreUnder(AbstractVcs abstractVcs, VirtualFile[] files) {
        if (files == null) {
            return false;
        }
        for (VirtualFile file : files) {
            if (this.getVcsFor(file) == abstractVcs) continue;
            return false;
        }
        return true;
    }

    @NotNull
    @NlsSafe
    public String getShortNameForVcsRoot(@NotNull VirtualFile root) {
        String relativePath;
        String shortName;
        if (root == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(5);
        }
        if ((shortName = this.myMappings.getShortNameFor(root)) != null) {
            String string = shortName;
            if (string == null) {
                ProjectLevelVcsManagerImpl.$$$reportNull$$$0(6);
            }
            return string;
        }
        VirtualFile projectDir = this.myProject.getBaseDir();
        String string = relativePath = projectDir != null ? VfsUtilCore.getRelativePath((VirtualFile)root, (VirtualFile)projectDir, (char)File.separatorChar) : null;
        if (relativePath != null) {
            String string2 = relativePath.isEmpty() ? root.getName() : relativePath;
            if (string2 == null) {
                ProjectLevelVcsManagerImpl.$$$reportNull$$$0(7);
            }
            return string2;
        }
        String string3 = root.getPresentableUrl();
        if (string3 == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(8);
        }
        return string3;
    }

    @Nullable
    public AbstractVcs getVcsFor(@Nullable VirtualFile file) {
        if (this.myProject.isDisposed()) {
            return null;
        }
        NewMappings.MappedRoot root = this.myMappings.getMappedRootFor(file);
        return root != null ? root.vcs : null;
    }

    @Nullable
    public AbstractVcs getVcsFor(@Nullable FilePath file) {
        if (this.myProject.isDisposed()) {
            return null;
        }
        NewMappings.MappedRoot root = this.myMappings.getMappedRootFor(file);
        return root != null ? root.vcs : null;
    }

    @Nullable
    public VirtualFile getVcsRootFor(@Nullable VirtualFile file) {
        if (file == null || this.myProject.isDisposed()) {
            return null;
        }
        NewMappings.MappedRoot root = this.myMappings.getMappedRootFor(file);
        return root != null ? root.root : null;
    }

    @Nullable
    public VcsRoot getVcsRootObjectFor(@Nullable VirtualFile file) {
        if (file == null || this.myProject.isDisposed()) {
            return null;
        }
        NewMappings.MappedRoot root = this.myMappings.getMappedRootFor(file);
        return root != null ? new VcsRoot(root.vcs, root.root) : null;
    }

    @Nullable
    public VirtualFile getVcsRootFor(@Nullable FilePath file) {
        if (file == null || this.myProject.isDisposed()) {
            return null;
        }
        NewMappings.MappedRoot root = this.myMappings.getMappedRootFor(file);
        return root != null ? root.root : null;
    }

    public VcsRoot getVcsRootObjectFor(@Nullable FilePath file) {
        if (file == null || this.myProject.isDisposed()) {
            return null;
        }
        NewMappings.MappedRoot root = this.myMappings.getMappedRootFor(file);
        return root != null ? new VcsRoot(root.vcs, root.root) : null;
    }

    @ApiStatus.Internal
    @NotNull
    public List<VcsRoot> getVcsRootObjectsForDefaultMapping() {
        List detectedRoots = ContainerUtil.filter(this.myMappings.getAllMappedRoots(), root -> {
            AbstractVcs vcs = root.vcs;
            return root.mapping.isDefaultMapping() && vcs != null && vcs.getCustomConvertor() == null;
        });
        List list = ContainerUtil.map((Collection)detectedRoots, root -> new VcsRoot(root.vcs, root.root));
        if (list == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(9);
        }
        return list;
    }

    @TestOnly
    public void unregisterVcs(@NotNull AbstractVcs vcs) {
        if (vcs == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(10);
        }
        if (!ApplicationManager.getApplication().isUnitTestMode() && this.myMappings.haveActiveVcs(vcs.getName())) {
            LOG.warn("Active vcs '" + vcs.getName() + "' is being unregistered. Remove from mappings first.");
        }
        this.myMappings.beingUnregistered(vcs.getName());
        AllVcses.getInstance(this.myProject).unregisterManually(vcs);
    }

    @Override
    @Nullable
    public ContentManager getContentManager() {
        ToolWindow changes = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow("Version Control");
        return changes == null ? null : changes.getContentManager();
    }

    public boolean checkVcsIsActive(@NotNull AbstractVcs vcs) {
        if (vcs == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(11);
        }
        return this.checkVcsIsActive(vcs.getName());
    }

    public boolean checkVcsIsActive(String vcsName) {
        return this.myMappings.haveActiveVcs(vcsName);
    }

    public AbstractVcs @NotNull [] getAllActiveVcss() {
        AbstractVcs[] abstractVcsArray = this.myMappings.getActiveVcses();
        if (abstractVcsArray == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(12);
        }
        return abstractVcsArray;
    }

    @Nullable
    public AbstractVcs getSingleVCS() {
        AbstractVcs[] vcses = this.getAllActiveVcss();
        return vcses.length == 1 ? vcses[0] : null;
    }

    public boolean hasActiveVcss() {
        return this.myMappings.hasActiveVcss();
    }

    public boolean areVcsesActivated() {
        return this.myMappings.isActivated();
    }

    public boolean hasAnyMappings() {
        return !this.myMappings.isEmpty();
    }

    @Deprecated
    public void addMessageToConsoleWindow(String message, TextAttributes attributes) {
        this.addMessageToConsoleWindow(message, new ConsoleViewContentType("", attributes));
    }

    public void addMessageToConsoleWindow(@Nullable String message, @NotNull ConsoleViewContentType contentType) {
        if (contentType == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(13);
        }
        VcsConsoleTabService.getInstance(this.myProject).addMessage(message, contentType);
    }

    public void addMessageToConsoleWindow(@Nullable VcsConsoleLine line) {
        VcsConsoleTabService.getInstance(this.myProject).addMessage(line);
    }

    @RequiresEdt
    public void showProjectOperationInfo(UpdatedFiles updatedFiles, String displayActionName) {
        UpdateInfoTree tree = this.showUpdateProjectInfo(updatedFiles, displayActionName, ActionInfo.STATUS, false);
        if (tree != null) {
            ViewUpdateInfoNotification.focusUpdateInfoTree(this.myProject, tree);
        }
    }

    @Override
    @RequiresEdt
    @Nullable
    public UpdateInfoTree showUpdateProjectInfo(UpdatedFiles updatedFiles, String displayActionName, ActionInfo actionInfo, boolean canceled) {
        if (!this.myProject.isOpen() || this.myProject.isDisposed()) {
            return null;
        }
        ContentManager contentManager = this.getContentManager();
        if (contentManager == null) {
            return null;
        }
        UpdateInfoTree updateInfoTree = new UpdateInfoTree(contentManager, this.myProject, updatedFiles, displayActionName, actionInfo);
        String tabName = DateFormatUtil.formatDateTime((long)System.currentTimeMillis());
        ContentUtilEx.addTabbedContent((ContentManager)contentManager, (JComponent)((Object)updateInfoTree), (String)"Update Info", (Supplier)VcsBundle.messagePointer((String)"vcs.update.tab.name", (Object[])new Object[0]), () -> tabName, (boolean)false, (Disposable)updateInfoTree);
        updateInfoTree.expandRootChildren();
        return updateInfoTree;
    }

    public List<VcsDirectoryMapping> getDirectoryMappings() {
        return this.myMappings.getDirectoryMappings();
    }

    public List<VcsDirectoryMapping> getDirectoryMappings(AbstractVcs vcs) {
        return this.myMappings.getDirectoryMappings(vcs.getName());
    }

    @Nullable
    public VcsDirectoryMapping getDirectoryMappingFor(@Nullable FilePath file) {
        if (file == null || this.myProject.isDisposed()) {
            return null;
        }
        NewMappings.MappedRoot root = this.myMappings.getMappedRootFor(file);
        return root != null ? root.mapping : null;
    }

    @Nullable
    private VcsDirectoryMapping getDirectoryMappingFor(@Nullable VirtualFile file) {
        if (file == null || this.myProject.isDisposed()) {
            return null;
        }
        NewMappings.MappedRoot root = this.myMappings.getMappedRootFor(file);
        return root != null ? root.mapping : null;
    }

    public void setDirectoryMapping(@NotNull String path, @Nullable String activeVcsName) {
        if (path == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(14);
        }
        if (this.myMappingsLoaded) {
            return;
        }
        this.myMappings.setMapping(FileUtil.toSystemIndependentName((String)path), activeVcsName);
    }

    public void registerNewDirectMappings(Collection<Pair<VirtualFile, AbstractVcs>> detectedRoots) {
        ArrayList<VcsDirectoryMapping> mappings = new ArrayList<VcsDirectoryMapping>(this.myMappings.getDirectoryMappings());
        Set knownMappedRoots = mappings.stream().map(VcsDirectoryMapping::getDirectory).collect(Collectors.toSet());
        List<VcsDirectoryMapping> newMappings = detectedRoots.stream().map(pair -> new VcsDirectoryMapping(((VirtualFile)pair.component1()).getPath(), ((AbstractVcs)pair.component2()).getName())).filter(it -> !knownMappedRoots.contains(it.getDirectory())).toList();
        mappings.addAll(newMappings);
        this.setAutoDirectoryMappings(mappings);
    }

    public void setAutoDirectoryMappings(@NotNull List<VcsDirectoryMapping> mappings) {
        if (mappings == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(15);
        }
        this.myMappings.setDirectoryMappings(mappings);
        this.myMappings.cleanupMappings();
    }

    public void removeDirectoryMapping(@NotNull VcsDirectoryMapping mapping) {
        if (mapping == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(16);
        }
        this.myMappings.removeDirectoryMapping(mapping);
    }

    public void setDirectoryMappings(@NotNull List<VcsDirectoryMapping> items) {
        if (items == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(17);
        }
        this.myMappings.setDirectoryMappings(items);
    }

    @Override
    public void scheduleMappedRootsUpdate() {
        this.myMappings.scheduleMappedRootsUpdate();
    }

    public void updateMappedVcsesImmediately() {
        this.myMappings.updateMappedVcsesImmediately();
    }

    public void iterateVcsRoot(VirtualFile root, Processor<? super FilePath> iterator) {
        VcsRootIterator.iterateVcsRoot(this.myProject, root, iterator);
    }

    public void iterateVcsRoot(VirtualFile root, Processor<? super FilePath> iterator, @Nullable VirtualFileFilter directoryFilter) {
        VcsRootIterator.iterateVcsRoot(this.myProject, root, iterator, directoryFilter);
    }

    @NotNull
    public VcsShowSettingOption getStandardOption(@NotNull VcsConfiguration.StandardOption option, @NotNull AbstractVcs vcs) {
        if (option == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(18);
        }
        if (vcs == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(19);
        }
        PersistentVcsShowSettingOption options = this.getOptions(option);
        options.addApplicableVcs(vcs);
        PersistentVcsShowSettingOption persistentVcsShowSettingOption = options;
        if (persistentVcsShowSettingOption == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(20);
        }
        return persistentVcsShowSettingOption;
    }

    @NotNull
    public VcsShowConfirmationOption getStandardConfirmation(@NotNull VcsConfiguration.StandardConfirmation option, AbstractVcs vcs) {
        if (option == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(21);
        }
        PersistentVcsShowConfirmationOption result2 = this.getConfirmation(option);
        if (vcs != null) {
            result2.addApplicableVcs(vcs);
        }
        PersistentVcsShowConfirmationOption persistentVcsShowConfirmationOption = result2;
        if (persistentVcsShowConfirmationOption == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(22);
        }
        return persistentVcsShowConfirmationOption;
    }

    @Override
    @NotNull
    public List<PersistentVcsShowConfirmationOption> getAllConfirmations() {
        List<PersistentVcsShowConfirmationOption> list = this.getOptionsAndConfirmations().getAllConfirmations();
        if (list == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(23);
        }
        return list;
    }

    @Override
    @NotNull
    public PersistentVcsShowConfirmationOption getConfirmation(VcsConfiguration.StandardConfirmation option) {
        PersistentVcsShowConfirmationOption persistentVcsShowConfirmationOption = this.getOptionsAndConfirmations().getConfirmation(option);
        if (persistentVcsShowConfirmationOption == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(24);
        }
        return persistentVcsShowConfirmationOption;
    }

    @Override
    @NotNull
    public PersistentVcsShowSettingOption getOptions(VcsConfiguration.StandardOption option) {
        PersistentVcsShowSettingOption persistentVcsShowSettingOption = this.getOptionsAndConfirmations().getOption(option);
        if (persistentVcsShowSettingOption == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(25);
        }
        return persistentVcsShowSettingOption;
    }

    @Override
    @NotNull
    public List<PersistentVcsShowSettingOption> getAllOptions() {
        List<PersistentVcsShowSettingOption> list = this.getOptionsAndConfirmations().getAllOptions();
        if (list == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(26);
        }
        return list;
    }

    @NotNull
    private OptionsAndConfirmations getOptionsAndConfirmations() {
        OptionsAndConfirmations optionsAndConfirmations = OptionsAndConfirmationsHolder.getInstance(this.myProject).getOptionsAndConfirmations();
        if (optionsAndConfirmations == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(27);
        }
        return optionsAndConfirmations;
    }

    public void startBackgroundVcsOperation() {
        this.myBackgroundOperationCounter.incrementAndGet();
    }

    public void stopBackgroundVcsOperation() {
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        int counter = this.myBackgroundOperationCounter.getAndDecrement();
        LOG.assertTrue(counter > 0, (Object)("myBackgroundOperationCounter was " + counter + " while should have been > 0"));
    }

    public boolean isBackgroundVcsOperationRunning() {
        return this.myBackgroundOperationCounter.get() > 0;
    }

    public List<VirtualFile> getRootsUnderVcsWithoutFiltering(@NotNull AbstractVcs vcs) {
        if (vcs == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(28);
        }
        return this.myMappings.getMappingsAsFilesUnderVcs(vcs);
    }

    public VirtualFile @NotNull [] getRootsUnderVcs(@NotNull AbstractVcs vcs) {
        if (vcs == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(29);
        }
        VirtualFile[] virtualFileArray = MappingsToRoots.getRootsUnderVcs(this.myProject, this.myMappings, vcs);
        if (virtualFileArray == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(30);
        }
        return virtualFileArray;
    }

    public VirtualFile[] getAllVersionedRoots() {
        AbstractVcs[] vcses;
        ArrayList vFiles = new ArrayList();
        for (AbstractVcs vcs : vcses = this.myMappings.getActiveVcses()) {
            Collections.addAll(vFiles, this.getRootsUnderVcs(vcs));
        }
        return VfsUtilCore.toVirtualFileArray(vFiles);
    }

    public VcsRoot @NotNull [] getAllVcsRoots() {
        AbstractVcs[] vcses;
        ArrayList<VcsRoot> vcsRoots = new ArrayList<VcsRoot>();
        for (AbstractVcs vcs : vcses = this.myMappings.getActiveVcses()) {
            VirtualFile[] roots;
            for (VirtualFile root : roots = this.getRootsUnderVcs(vcs)) {
                vcsRoots.add(new VcsRoot(vcs, root));
            }
        }
        VcsRoot[] vcsRootArray = vcsRoots.toArray(new VcsRoot[0]);
        if (vcsRootArray == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(31);
        }
        return vcsRootArray;
    }

    public String getConsolidatedVcsName() {
        AbstractVcs singleVcs = this.getSingleVCS();
        return singleVcs != null ? singleVcs.getShortNameWithMnemonic() : VcsBundle.message((String)"vcs.generic.name.with.mnemonic", (Object[])new Object[0]);
    }

    @Override
    public void notifyDirectoryMappingChanged() {
        this.fireDirectoryMappingsChanged();
    }

    public void loadState(@NotNull Element element) {
        if (element == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(32);
        }
        ArrayList<VcsDirectoryMapping> mappingsList = new ArrayList<VcsDirectoryMapping>();
        for (Element child : element.getChildren(ELEMENT_MAPPING)) {
            String vcsName = child.getAttributeValue(ATTRIBUTE_VCS);
            String directory = child.getAttributeValue(ATTRIBUTE_DIRECTORY);
            if (directory == null) continue;
            VcsRootSettings rootSettings = null;
            Element rootSettingsElement = child.getChild(ELEMENT_ROOT_SETTINGS);
            if (rootSettingsElement != null) {
                AbstractVcs vcsInstance;
                String className = rootSettingsElement.getAttributeValue(ATTRIBUTE_CLASS);
                AbstractVcs abstractVcs = vcsInstance = vcsName == null ? null : AllVcses.getInstance(this.myProject).getByName(vcsName);
                if (vcsInstance != null && className != null && (rootSettings = vcsInstance.createEmptyVcsRootSettings()) != null) {
                    try {
                        rootSettings.readExternal(rootSettingsElement);
                    }
                    catch (InvalidDataException e) {
                        LOG.error("Failed to load VCS root settings class " + className + " for VCS " + vcsInstance.getClass().getName(), (Throwable)e);
                    }
                }
            }
            VcsDirectoryMapping mapping = new VcsDirectoryMapping(directory, vcsName, rootSettings);
            mappingsList.add(mapping);
            this.myMappingsLoaded |= !mapping.isDefaultMapping();
        }
        this.myMappings.setDirectoryMappingsFromConfig(mappingsList);
    }

    @NotNull
    public Element getState() {
        Element element = new Element("state");
        for (VcsDirectoryMapping mapping : this.getDirectoryMappings()) {
            VcsRootSettings rootSettings = mapping.getRootSettings();
            if (rootSettings == null && mapping.isDefaultMapping() && mapping.isNoneMapping()) continue;
            Element child = new Element(ELEMENT_MAPPING);
            child.setAttribute(ATTRIBUTE_DIRECTORY, mapping.getDirectory());
            child.setAttribute(ATTRIBUTE_VCS, mapping.getVcs());
            if (rootSettings != null) {
                Element rootSettingsElement = new Element(ELEMENT_ROOT_SETTINGS);
                rootSettingsElement.setAttribute(ATTRIBUTE_CLASS, rootSettings.getClass().getName());
                try {
                    rootSettings.writeExternal(rootSettingsElement);
                    child.addContent(rootSettingsElement);
                }
                catch (WriteExternalException writeExternalException) {
                    // empty catch block
                }
            }
            element.addContent(child);
        }
        Element element2 = element;
        if (element2 == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(33);
        }
        return element2;
    }

    @Nullable
    public AbstractVcs findVersioningVcs(@NotNull VirtualFile file) {
        if (file == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(34);
        }
        HashSet<String> checkedVcses = new HashSet<String>();
        for (VcsRootChecker checker : VcsRootChecker.EXTENSION_POINT_NAME.getExtensionList()) {
            String vcsName = checker.getSupportedVcs().getName();
            checkedVcses.add(vcsName);
            if (!checker.isRoot(file)) continue;
            return this.findVcsByName(vcsName);
        }
        String foundVcs = null;
        for (VcsDescriptor vcsDescriptor : this.getAllVcss()) {
            String vcsName = vcsDescriptor.getName();
            if (checkedVcses.contains(vcsName) || !vcsDescriptor.probablyUnderVcs(file)) continue;
            if (foundVcs != null) {
                return null;
            }
            foundVcs = vcsName;
        }
        return this.findVcsByName(foundVcs);
    }

    @NotNull
    public VcsRootChecker getRootChecker(@NotNull AbstractVcs vcs) {
        if (vcs == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(35);
        }
        for (VcsRootChecker checker : VcsRootChecker.EXTENSION_POINT_NAME.getIterable()) {
            if (!checker.getSupportedVcs().equals((Object)vcs.getKeyInstanceMethod())) continue;
            VcsRootChecker vcsRootChecker = checker;
            if (vcsRootChecker == null) {
                ProjectLevelVcsManagerImpl.$$$reportNull$$$0(36);
            }
            return vcsRootChecker;
        }
        return new DefaultVcsRootChecker(vcs, this.getDescriptor(vcs.getName()));
    }

    public CheckoutProvider.Listener getCompositeCheckoutListener() {
        return new CompositeCheckoutListener(this.myProject);
    }

    @Override
    public void fireDirectoryMappingsChanged() {
        if (this.myProject.isOpen() && !this.myProject.isDisposed()) {
            this.myMappings.notifyMappingsChanged();
        }
    }

    @Override
    @Nullable
    public String haveDefaultMapping() {
        return this.myMappings.haveDefaultMapping();
    }

    boolean isBackgroundTaskRunning(Object ... keys) {
        if (keys == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(37);
        }
        return this.myBackgroundRunningTasks.contains(new ActionKey(keys));
    }

    @RequiresEdt
    void startBackgroundTask(Object ... keys) {
        if (keys == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(38);
        }
        ThreadingAssertions.assertEventDispatchThread();
        LOG.assertTrue(this.myBackgroundRunningTasks.add(new ActionKey(keys)));
    }

    @RequiresEdt
    void stopBackgroundTask(Object ... keys) {
        if (keys == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(39);
        }
        ThreadingAssertions.assertEventDispatchThread();
        LOG.assertTrue(this.myBackgroundRunningTasks.remove(new ActionKey(keys)));
    }

    public void addInitializationRequest(@NotNull VcsInitObject vcsInitObject, @NotNull Runnable runnable) {
        if (vcsInitObject == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(40);
        }
        if (runnable == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(41);
        }
        VcsInitialization.Companion.getInstance(this.myProject).add(vcsInitObject, runnable);
    }

    public void runAfterInitialization(@NotNull Runnable runnable) {
        if (runnable == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(42);
        }
        this.addInitializationRequest(VcsInitObject.AFTER_COMMON, runnable);
    }

    public boolean isFileInContent(@Nullable VirtualFile vf) {
        if (vf == null) {
            return false;
        }
        return (Boolean)ReadAction.compute(() -> {
            if (!vf.isValid()) {
                return false;
            }
            FileIndexFacade fileIndex = FileIndexFacade.getInstance((Project)this.myProject);
            boolean isUnderProject = this.isFileInBaseDir(vf) || this.isInDirectoryBasedRoot(vf) || this.hasExplicitMapping(vf) || fileIndex.isInContent(vf) || !Registry.is((String)"ide.hide.excluded.files") && fileIndex.isExcludedFile(vf);
            return isUnderProject && !this.isIgnored(vf);
        });
    }

    public boolean isIgnored(@NotNull VirtualFile vf) {
        if (vf == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(43);
        }
        return (Boolean)ReadAction.compute(() -> {
            if (this.myProject.isDisposed() || this.myProject.isDefault()) {
                return false;
            }
            if (!vf.isValid()) {
                return false;
            }
            if (Registry.is((String)"ide.hide.excluded.files")) {
                return FileIndexFacade.getInstance((Project)this.myProject).isExcludedFile(vf);
            }
            return FileIndexFacade.getInstance((Project)this.myProject).isUnderIgnored(vf);
        });
    }

    public boolean isIgnored(@NotNull FilePath filePath) {
        if (filePath == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(44);
        }
        return (Boolean)ReadAction.compute(() -> {
            if (this.myProject.isDisposed() || this.myProject.isDefault()) {
                return false;
            }
            if (Registry.is((String)"ide.hide.excluded.files")) {
                VirtualFile vf = VcsImplUtil.findValidParentAccurately(filePath);
                return vf != null && FileIndexFacade.getInstance((Project)this.myProject).isExcludedFile(vf);
            }
            FileTypeManager fileTypeManager = FileTypeManager.getInstance();
            for (String name : StringUtil.tokenize((String)filePath.getPath(), (String)"/")) {
                if (!fileTypeManager.isFileIgnored(name)) continue;
                return true;
            }
            return false;
        });
    }

    private boolean isInDirectoryBasedRoot(@NotNull VirtualFile file) {
        if (file == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(45);
        }
        if (ProjectKt.isDirectoryBased((Project)this.myProject)) {
            return ProjectKt.getStateStore((Project)this.myProject).isProjectFile(file);
        }
        return false;
    }

    private boolean isFileInBaseDir(@NotNull VirtualFile file) {
        VirtualFile baseDir;
        if (file == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(46);
        }
        if ((baseDir = this.myProject.getBaseDir()) == null) {
            return false;
        }
        if (file.isDirectory()) {
            return baseDir.equals(file);
        }
        return baseDir.equals(file.getParent());
    }

    private boolean hasExplicitMapping(@NotNull VirtualFile vFile) {
        VcsDirectoryMapping mapping;
        if (vFile == null) {
            ProjectLevelVcsManagerImpl.$$$reportNull$$$0(47);
        }
        return (mapping = this.getDirectoryMappingFor(vFile)) != null && !mapping.isDefaultMapping();
    }

    public VcsHistoryCache getVcsHistoryCache() {
        return VcsCacheManager.getInstance(this.myProject).getVcsHistoryCache();
    }

    public ContentRevisionCache getContentRevisionCache() {
        return VcsCacheManager.getInstance(this.myProject).getContentRevisionCache();
    }

    @TestOnly
    public void waitForInitialized() {
        VcsInitialization.Companion.getInstance(this.myProject).waitFinished();
    }

    public void showConsole(@Nullable Runnable then) {
        VcsConsoleTabService.getInstance(this.myProject).showConsoleTab(true, null);
    }

    public void scrollConsoleToTheEnd() {
        VcsConsoleTabService.getInstance(this.myProject).showConsoleTabAndScrollToTheEnd();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 6, 7, 8, 9, 12, 20, 22, 23, 24, 25, 26, 27, 30, 31, 33, 36 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coroutineScope";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/impl/ProjectLevelVcsManagerImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 10: 
            case 11: 
            case 19: 
            case 28: 
            case 29: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = ATTRIBUTE_VCS;
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentType";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappings";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = ELEMENT_MAPPING;
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 34: 
            case 45: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keys";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsInitObject";
                break;
            }
            case 41: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vf";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/impl/ProjectLevelVcsManagerImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllSupportedVcss";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotationLocalChangesListener";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortNameForVcsRoot";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getVcsRootObjectsForDefaultMapping";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllActiveVcss";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getStandardOption";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getStandardConfirmation";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllConfirmations";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfirmation";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptions";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllOptions";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsAndConfirmations";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootsUnderVcs";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllVcsRoots";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootChecker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getInstanceImpl";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 33: 
            case 36: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getShortNameForVcsRoot";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "unregisterVcs";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "checkVcsIsActive";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addMessageToConsoleWindow";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setDirectoryMapping";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setAutoDirectoryMappings";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "removeDirectoryMapping";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setDirectoryMappings";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getStandardOption";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getStandardConfirmation";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getRootsUnderVcsWithoutFiltering";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getRootsUnderVcs";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "findVersioningVcs";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getRootChecker";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "isBackgroundTaskRunning";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "startBackgroundTask";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "stopBackgroundTask";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "addInitializationRequest";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "runAfterInitialization";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "isIgnored";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "isInDirectoryBasedRoot";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "isFileInBaseDir";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "hasExplicitMapping";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 6, 7, 8, 9, 12, 20, 22, 23, 24, 25, 26, 27, 30, 31, 33, 36 -> new IllegalStateException(string);
        };
    }

    private static class ActionKey {
        private final Object[] myObjects;

        ActionKey(Object ... objects) {
            if (objects == null) {
                ActionKey.$$$reportNull$$$0(0);
            }
            this.myObjects = objects;
        }

        public final boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return Arrays.equals(this.myObjects, ((ActionKey)o).myObjects);
        }

        public final int hashCode() {
            return Arrays.hashCode(this.myObjects);
        }

        public String toString() {
            return String.valueOf(this.getClass()) + " - " + Arrays.toString(this.myObjects);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objects", "com/intellij/openapi/vcs/impl/ProjectLevelVcsManagerImpl$ActionKey", "<init>"));
        }
    }

    static final class TrustListener
    implements TrustedProjectsListener {
        TrustListener() {
        }

        public void onProjectTrusted(@NotNull Project project) {
            if (project == null) {
                TrustListener.$$$reportNull$$$0(0);
            }
            ProjectLevelVcsManagerImpl.getInstanceImpl(project).updateMappedVcsesImmediately();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/impl/ProjectLevelVcsManagerImpl$TrustListener", "onProjectTrusted"));
        }
    }

    static final class ActivateVcsesStartupActivity
    implements VcsStartupActivity {
        ActivateVcsesStartupActivity() {
        }

        @Override
        public void runActivity(@NotNull Project project) {
            if (project == null) {
                ActivateVcsesStartupActivity.$$$reportNull$$$0(0);
            }
            ProjectLevelVcsManagerImpl.getInstanceImpl((Project)project).myMappings.activateActiveVcses();
        }

        @Override
        public int getOrder() {
            return VcsInitObject.MAPPINGS.getOrder();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/impl/ProjectLevelVcsManagerImpl$ActivateVcsesStartupActivity", "runActivity"));
        }
    }
}

