/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.data;

import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;
import javax.swing.ImageIcon;
import org.fibs.geotag.data.UpdateGPSDateTime;
import org.fibs.geotag.geonames.Location;

public class ImageInfo
implements Comparable<ImageInfo> {
    private static HashMap<String, ImageInfo> values = new HashMap();
    private static final String DATE_FORMAT_PATTERN = "yyyy:MM:dd HH:mm:ss";
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy:MM:dd HH:mm:ss");
    private static int instancesCreated = 0;
    private int sequenceNumber;
    private String path;
    private String name;
    private ImageIcon thumbnail;
    private THUMBNAIL_STATUS thumbNailStatus;
    private int width;
    private int height;
    private String cameraDate;
    private String gpsLatitude;
    private String gpsLongitude;
    private String gpsAltitude;
    private String gpsImgDirection;
    private String gpsDateTime;
    private List<Location> nearbyLocations;
    private String locationName;
    private String cityName;
    private String countryName;
    private String provinceName;
    private String userComment;
    private String orientation;
    private DATA_SOURCE source;
    private Calendar exactTimeGMT;
    private static List<ImageInfo> instances = new ArrayList<ImageInfo>();

    public ImageInfo(File file) {
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.thumbNailStatus = THUMBNAIL_STATUS.UNKNOWN;
        this.source = DATA_SOURCE.NONE;
        this.exactTimeGMT = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        this.sequenceNumber = ++instancesCreated;
        instances.add(this);
        this.name = file.getName();
        this.path = file.getPath();
        values.put(this.path, this);
    }

    public int calculateOffset(String gmtDateString, String localDateString) {
        int offset = 0;
        if (gmtDateString != null && localDateString != null) {
            try {
                Date gmtDate = this.dateFormat.parse(gmtDateString);
                Date localDate = this.dateFormat.parse(localDateString);
                offset = (int)((double)(localDate.getTime() - gmtDate.getTime()) / 1000.0);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return offset;
    }

    public String subtractOffset(String localDateString, int offset) {
        try {
            Date date = this.dateFormat.parse(localDateString);
            date.setTime(date.getTime() - (long)offset * 1000L);
            return this.dateFormat.format(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return "";
        }
    }

    @Override
    public int compareTo(ImageInfo imageInfo) {
        if (this.getGpsDateTime() != null && imageInfo.getGpsDateTime() != null) {
            return this.getGpsDateTime().compareTo(imageInfo.getGpsDateTime());
        }
        return this.getName().compareTo(imageInfo.getName());
    }

    public int getSequenceNumber() {
        return this.sequenceNumber;
    }

    public static ImageInfo getImageInfo(int sequenceNumer) {
        return instances.get(sequenceNumer - 1);
    }

    public static List<ImageInfo> getImagesInfos(Filter filter) {
        ArrayList<ImageInfo> result = new ArrayList<ImageInfo>();
        for (ImageInfo imageInfo : instances) {
            if (!filter.accept(imageInfo)) continue;
            result.add(imageInfo);
        }
        return result;
    }

    public static ImageInfo getImageInfo(String filePath) {
        return values.get(filePath);
    }

    public boolean hasLocation() {
        return this.source != DATA_SOURCE.NONE;
    }

    public boolean hasNewLocation() {
        return this.source != DATA_SOURCE.NONE && this.source != DATA_SOURCE.IMAGE;
    }

    public boolean hasLocationName() {
        if (this.locationName != null && this.locationName.length() > 0) {
            return true;
        }
        if (this.provinceName != null && this.provinceName.length() > 0) {
            return true;
        }
        return this.countryName != null && this.countryName.length() > 0;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public THUMBNAIL_STATUS getThumbNailStatus() {
        return this.thumbNailStatus;
    }

    public void setThumbNailStatus(THUMBNAIL_STATUS thumbNailStatus) {
        this.thumbNailStatus = thumbNailStatus;
    }

    public ImageIcon getThumbnail() {
        return this.thumbnail;
    }

    public void setThumbnail(ImageIcon thumbnail) {
        this.thumbnail = thumbnail;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getOffset() {
        return this.calculateOffset(this.getGpsDateTime(), this.getCameraDate());
    }

    public String getOffsetString() {
        return ImageInfo.getOffsetString(this.getOffset());
    }

    public static String getOffsetString(int offset) {
        boolean negative = (double)offset < 0.0;
        int absOffset = Math.abs(offset);
        int hours = absOffset / 3600;
        int minutes = (absOffset -= hours * 3600) / 60;
        int seconds = absOffset - minutes * 60;
        return String.format("%+d:%02d:%02d", hours *= negative ? -1 : 1, minutes, seconds);
    }

    public String getCameraDate() {
        return this.cameraDate;
    }

    void setCameraDate(String cameraDate) {
        this.cameraDate = cameraDate;
    }

    public String getGpsLatitude() {
        return this.gpsLatitude;
    }

    void setGpsLatitude(String latitude, DATA_SOURCE source) {
        this.gpsLatitude = latitude;
        this.source = source;
    }

    public String getGpsLongitude() {
        return this.gpsLongitude;
    }

    void setGpsLongitude(String longitude, DATA_SOURCE source) {
        this.gpsLongitude = longitude;
        this.source = source;
    }

    public String getGpsAltitude() {
        return this.gpsAltitude;
    }

    void setGpsAltitudeInMetres(String altitude, DATA_SOURCE source) {
        this.gpsAltitude = altitude;
        this.source = source;
    }

    public String getGpsImgDirection() {
        if (this.gpsImgDirection != null && "NaN".equals(this.gpsImgDirection)) {
            return null;
        }
        return this.gpsImgDirection;
    }

    void setGpsImgDirection(String direction) {
        this.gpsImgDirection = direction;
    }

    public String getGpsDateTime() {
        return this.gpsDateTime;
    }

    void setGpsDateTime(String dateTime) {
        if (dateTime != null) {
            try {
                Date parsedDate = this.dateFormat.parse(dateTime);
                this.exactTimeGMT.setTime(parsedDate);
                this.gpsDateTime = dateTime;
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        } else {
            this.gpsDateTime = null;
        }
    }

    public void setGpsDateTime() {
        if (this.gpsDateTime == null && this.cameraDate != null) {
            SimpleDateFormat format = new SimpleDateFormat(ImageInfo.getDateFormatPattern());
            try {
                Date date = format.parse(this.cameraDate);
                format.setTimeZone(TimeZone.getTimeZone("GMT"));
                String gmtTime = format.format(date);
                new UpdateGPSDateTime(this, gmtTime);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
    }

    public Calendar getTimeGMT() {
        return this.exactTimeGMT;
    }

    public String getOrientation() {
        return this.orientation;
    }

    public void setOrientation(String orientation) {
        this.orientation = orientation;
    }

    public String getLocationName() {
        return this.locationName;
    }

    void setLocationName(String locationName, DATA_SOURCE source) {
        this.locationName = locationName;
        this.source = source;
    }

    public String getCityName() {
        return this.cityName;
    }

    void setCityName(String cityName, DATA_SOURCE source) {
        this.cityName = cityName;
        this.source = source;
    }

    public String getProvinceName() {
        return this.provinceName;
    }

    void setProvinceName(String provinceName, DATA_SOURCE source) {
        this.provinceName = provinceName;
        this.source = source;
    }

    public String getCountryName() {
        return this.countryName;
    }

    void setCountryName(String countryName, DATA_SOURCE source) {
        this.countryName = countryName;
        this.source = source;
    }

    public String getUserComment() {
        return this.userComment;
    }

    void setUserComment(String userComment, DATA_SOURCE source) {
        this.userComment = userComment;
        this.source = source;
    }

    public List<Location> getNearbyLocations() {
        return this.nearbyLocations;
    }

    public void setNearbyLocations(List<Location> nearbyLocations) {
        this.nearbyLocations = nearbyLocations;
    }

    public DATA_SOURCE getSource() {
        return this.source;
    }

    public void setSource(DATA_SOURCE source) {
        this.source = source;
    }

    public static String getDateFormatPattern() {
        return DATE_FORMAT_PATTERN;
    }

    public SimpleDateFormat getDateFormat() {
        return this.dateFormat;
    }

    public static enum DATA_SOURCE {
        NONE,
        IMAGE,
        MANUAL,
        MAP,
        INTERPOLATED,
        TRACK,
        COPIED,
        GEONAMES,
        CLIPBOARD;

    }

    public static abstract class Filter {
        public abstract boolean accept(ImageInfo var1);
    }

    public static enum THUMBNAIL_STATUS {
        UNKNOWN,
        LOADING,
        FAI1LED,
        AVAILABLE;

    }
}

