/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.jpeg.test;

import com.drew.metadata.jpeg.JpegComponent;
import com.drew.metadata.jpeg.JpegDirectory;
import junit.framework.TestCase;

public class JpegDirectoryTest
extends TestCase {
    private JpegDirectory _directory;

    public JpegDirectoryTest(String s) {
        super(s);
    }

    public void setUp() {
        this._directory = new JpegDirectory();
    }

    public void testSetAndGetValue() throws Exception {
        this._directory.setInt(123, 8);
        JpegDirectoryTest.assertEquals((int)8, (int)this._directory.getInt(123));
    }

    public void testGetComponent_NotAdded() {
        JpegDirectoryTest.assertNull((Object)this._directory.getComponent(1));
    }

    public void testGetImageWidth() throws Exception {
        this._directory.setInt(3, 123);
        JpegDirectoryTest.assertEquals((int)123, (int)this._directory.getImageWidth());
    }

    public void testGetImageHeight() throws Exception {
        this._directory.setInt(1, 123);
        JpegDirectoryTest.assertEquals((int)123, (int)this._directory.getImageHeight());
    }

    public void testGetNumberOfComponents() throws Exception {
        this._directory.setInt(5, 3);
        JpegDirectoryTest.assertEquals((int)3, (int)this._directory.getNumberOfComponents());
        JpegDirectoryTest.assertEquals((String)"3", (String)this._directory.getDescription(5));
    }

    public void testGetComponent() throws Exception {
        JpegComponent component1 = new JpegComponent(1, 2, 3);
        JpegComponent component2 = new JpegComponent(1, 2, 3);
        JpegComponent component3 = new JpegComponent(1, 2, 3);
        JpegComponent component4 = new JpegComponent(1, 2, 3);
        this._directory.setObject(6, component1);
        this._directory.setObject(7, component2);
        this._directory.setObject(8, component3);
        this._directory.setObject(9, component4);
        JpegDirectoryTest.assertSame((Object)component1, (Object)this._directory.getComponent(0));
        JpegDirectoryTest.assertSame((Object)component2, (Object)this._directory.getComponent(1));
        JpegDirectoryTest.assertSame((Object)component3, (Object)this._directory.getComponent(2));
        JpegDirectoryTest.assertSame((Object)component4, (Object)this._directory.getComponent(3));
    }
}

