#############################################################################
##
#W  subgroups.g                GAP4 Package `RCWA'                Stefan Kohl
##
##  Data library of groups generated by 3 class transpositions which inter-
##  change residue classes with moduli <= 6: part containing lists of
##  subgroups.
##
##  For all i in [1..52394], subgroups[i] is a list of indices j such that
##  grps[j] is a subgroup of grps[i].
##
#############################################################################

return 
[[2279],[2279],
 [23,31,44,202,218,464,1296,1309,1625,2429,2437,2675,2683,
   3507,3520,3836,8916,9748,9761,10077,17192,17205,17521,38497],
 [268,2479],
 [3,4,7,10,23,26,31,32,41,42,44,199,200,202,203,205,218,
   221,226,227,236,237,239,263,265,266,268,281,284,289,290,
   299,300,302,327,328,330,343,346,351,352,361,362,364,449,
   451,464,467,472,473,482,483,485,510,523,526,531,532,541,
   542,544,638,641,646,647,656,657,659,1291,1296,1297,1306,
   1307,1309,1422,1423,1432,1433,1435,1613,1622,1623,1625,1657,
   1658,1660,1928,1930,1955,2410,2411,2413,2414,2416,2429,2432,
   2437,2438,2447,2448,2450,2474,2476,2477,2479,2492,2495,2500,
   2501,2510,2511,2513,2538,2541,2554,2557,2562,2563,2572,2573,
   2575,2660,2662,2675,2678,2683,2684,2693,2694,2696,2721,2734,
   2737,2742,2743,2752,2753,2755,2849,2852,2857,2858,2867,2868,
   2870,3502,3507,3508,3517,3518,3520,3633,3634,3643,3644,3646,
   3824,3833,3834,3836,3868,3869,3871,4139,4141,4166,8715,8717,
   8718,8720,8733,8736,8741,8742,8751,8752,8754,8779,8780,8782,
   8795,8798,8803,8804,8813,8814,8816,8901,8903,8916,8919,8924,
   8925,8934,8935,8937,8962,8975,8978,8983,8984,8993,8994,8996,
   9090,9093,9098,9099,9108,9109,9111,9743,9748,9749,9758,9759,
   9761,9874,9875,9884,9885,9887,10065,10074,10075,10077,10109,
   10110,10112,10380,10382,10407,10732,10733,10735,10748,10751,
   10756,10757,10766,10767,10769,10854,10856,10869,10872,10877,
   10878,10887,10888,10890,10915,10928,10931,10936,10937,10946,
   10947,10949,11043,11046,11051,11052,11061,11062,11064,11696,
   11701,11702,11711,11712,11714,11827,11828,11837,11838,11840,
   12018,12027,12028,12030,12062,12063,12065,12333,12335,12360,
   12745,12747,12760,12763,12768,12769,12778,12779,12781,12806,
   12819,12822,12827,12828,12837,12838,12840,12934,12937,12942,
   12943,12952,12953,12955,13587,13592,13593,13602,13603,13605,
   13718,13719,13728,13729,13731,13909,13918,13919,13921,13953,
   13954,13956,14224,14226,14251,16406,16419,16422,16427,16428,
   16437,16438,16440,16534,16537,16542,16543,16552,16553,16555,
   17187,17192,17193,17202,17203,17205,17318,17319,17328,17329,
   17331,17509,17518,17519,17521,17553,17554,17556,17824,17826,
   17851,18245,18248,18253,18254,18263,18264,18266,18898,18903,
   18904,18913,18914,18916,19029,19030,19039,19040,19042,19220,
   19229,19230,19232,19264,19265,19267,19535,19537,19562,22147,
   22152,22153,22162,22163,22165,22278,22279,22288,22289,22291,
   22469,22478,22479,22481,22513,22514,22516,22784,22786,22811,
   38294,38295,38304,38305,38307,38485,38494,38495,38497,38529,
   38530,38532,38800,38802,38827,41069,41078,41079,41081,41113,
   41114,41116,41384,41386,41411,44633,44634,44636,44904,44906,
   44931,45499,45501,45526,49471],[393,2604],
 [23,31,44,202,218,464,1296,1309,1625,2429,2437,2675,2683,
   3507,3520,3836,8916,9748,9761,10077,17192,17205,17521,38497],
 [3,4,7,10,23,26,31,32,41,42,44,199,200,202,203,205,218,
   221,226,227,236,237,239,263,265,266,268,281,284,289,290,
   299,300,302,327,328,330,343,346,351,352,361,362,364,449,
   451,464,467,472,473,482,483,485,510,523,526,531,532,541,
   542,544,638,641,646,647,656,657,659,1291,1296,1297,1306,
   1307,1309,1422,1423,1432,1433,1435,1613,1622,1623,1625,1657,
   1658,1660,1928,1930,1955,2410,2411,2413,2414,2416,2429,2432,
   2437,2438,2447,2448,2450,2474,2476,2477,2479,2492,2495,2500,
   2501,2510,2511,2513,2538,2541,2554,2557,2562,2563,2572,2573,
   2575,2660,2662,2675,2678,2683,2684,2693,2694,2696,2721,2734,
   2737,2742,2743,2752,2753,2755,2849,2852,2857,2858,2867,2868,
   2870,3502,3507,3508,3517,3518,3520,3633,3634,3643,3644,3646,
   3824,3833,3834,3836,3868,3869,3871,4139,4141,4166,8715,8717,
   8718,8720,8733,8736,8741,8742,8751,8752,8754,8779,8780,8782,
   8795,8798,8803,8804,8813,8814,8816,8901,8903,8916,8919,8924,
   8925,8934,8935,8937,8962,8975,8978,8983,8984,8993,8994,8996,
   9090,9093,9098,9099,9108,9109,9111,9743,9748,9749,9758,9759,
   9761,9874,9875,9884,9885,9887,10065,10074,10075,10077,10109,
   10110,10112,10380,10382,10407,10732,10733,10735,10748,10751,
   10756,10757,10766,10767,10769,10854,10856,10869,10872,10877,
   10878,10887,10888,10890,10915,10928,10931,10936,10937,10946,
   10947,10949,11043,11046,11051,11052,11061,11062,11064,11696,
   11701,11702,11711,11712,11714,11827,11828,11837,11838,11840,
   12018,12027,12028,12030,12062,12063,12065,12333,12335,12360,
   12745,12747,12760,12763,12768,12769,12778,12779,12781,12806,
   12819,12822,12827,12828,12837,12838,12840,12934,12937,12942,
   12943,12952,12953,12955,13587,13592,13593,13602,13603,13605,
   13718,13719,13728,13729,13731,13909,13918,13919,13921,13953,
   13954,13956,14224,14226,14251,16406,16419,16422,16427,16428,
   16437,16438,16440,16534,16537,16542,16543,16552,16553,16555,
   17187,17192,17193,17202,17203,17205,17318,17319,17328,17329,
   17331,17509,17518,17519,17521,17553,17554,17556,17824,17826,
   17851,18245,18248,18253,18254,18263,18264,18266,18898,18903,
   18904,18913,18914,18916,19029,19030,19039,19040,19042,19220,
   19229,19230,19232,19264,19265,19267,19535,19537,19562,22147,
   22152,22153,22162,22163,22165,22278,22279,22288,22289,22291,
   22469,22478,22479,22481,22513,22514,22516,22784,22786,22811,
   38294,38295,38304,38305,38307,38485,38494,38495,38497,38529,
   38530,38532,38800,38802,38827,41069,41078,41079,41081,41113,
   41114,41116,41384,41386,41411,44633,44634,44636,44904,44906,
   44931,45499,45501,45526,49471],[569,2780],[268,2479],
 [569,2780],[393,2604],[],[],[],[],[],[],[],
 [],[],[],[1625,3507,3520,3836,38497],
 [1,2,23,26,31,32,41,42,44,68,89,90,91,92,93,94,107,156,
   157,158,163,164,166,173,177,179,1289,1290,1291,1292,1293,
   1296,1297,1298,1300,1306,1307,1309,1311,1313,1333,1334,1335,
   1336,1339,1340,1341,1343,1349,1350,1352,1354,1356,1376,1377,
   1378,1381,1382,1383,1385,1391,1392,1394,1396,1398,1418,1419,
   1422,1423,1424,1426,1432,1433,1435,1437,1439,1459,1462,1463,
   1464,1466,1472,1473,1475,1477,1479,1501,1502,1503,1505,1511,
   1512,1514,1516,1518,1613,1614,1616,1622,1623,1625,1627,1629,
   1649,1651,1657,1658,1660,1662,1664,1685,1691,1692,1694,1696,
   1698,1756,1757,1759,1761,1763,1928,1930,1932,1934,1955,1957,
   1959,2004,2006,2049,2279,2300,2301,2302,2305,2308,2310,2318,
   2319,2321,2365,2366,2367,2370,2373,2375,2383,2384,2386,3500,
   3501,3502,3503,3504,3507,3508,3509,3511,3517,3518,3520,3522,
   3524,3544,3545,3546,3547,3550,3551,3552,3554,3560,3561,3563,
   3565,3567,3587,3588,3589,3592,3593,3594,3596,3602,3603,3605,
   3607,3609,3629,3630,3633,3634,3635,3637,3643,3644,3646,3648,
   3650,3670,3673,3674,3675,3677,3683,3684,3686,3688,3690,3712,
   3713,3714,3716,3722,3723,3725,3727,3729,3824,3825,3827,3833,
   3834,3836,3838,3840,3860,3862,3868,3869,3871,3873,3875,3896,
   3902,3903,3905,3907,3909,3967,3968,3970,3972,3974,4139,4141,
   4143,4145,4166,4168,4170,4215,4217,4260,4510,4511,4512,4515,
   4518,4520,4528,4529,4531,5645,5646,5647,5648,5649,5652,5653,
   5654,5656,5662,5663,5665,5667,5669,5689,5690,5691,5692,5695,
   5696,5697,5699,5705,5706,5708,5710,5712,5732,5733,5734,5737,
   5738,5739,5741,5747,5748,5750,5752,5754,5774,5775,5778,5779,
   5780,5782,5788,5789,5791,5793,5795,5815,5818,5819,5820,5822,
   5828,5829,5831,5833,5835,5857,5858,5859,5861,5867,5868,5870,
   5872,5874,5969,5970,5972,5978,5979,5981,5983,5985,6005,6007,
   6013,6014,6016,6018,6020,6041,6047,6048,6050,6052,6054,6112,
   6113,6115,6117,6119,6284,6286,6288,6290,6311,6313,6315,6360,
   6362,6405,7725,7726,7727,7728,7729,7732,7733,7734,7736,7742,
   7743,7745,7747,7749,7769,7770,7771,7772,7775,7776,7777,7779,
   7785,7786,7788,7790,7792,7812,7813,7814,7817,7818,7819,7821,
   7827,7828,7830,7832,7834,7854,7855,7858,7859,7860,7862,7868,
   7869,7871,7873,7875,7895,7898,7899,7900,7902,7908,7909,7911,
   7913,7915,7937,7938,7939,7941,7947,7948,7950,7952,7954,8049,
   8050,8052,8058,8059,8061,8063,8065,8085,8087,8093,8094,8096,
   8098,8100,8121,8127,8128,8130,8132,8134,8192,8193,8195,8197,
   8199,8364,8366,8368,8370,8391,8393,8395,8440,8442,8485,
   38205,38206,38207,38208,38211,38212,38213,38215,38221,38222,
   38224,38226,38228,38248,38249,38250,38253,38254,38255,38257,
   38263,38264,38266,38268,38270,38290,38291,38294,38295,38296,
   38298,38304,38305,38307,38309,38311,38331,38334,38335,38336,
   38338,38344,38345,38347,38349,38351,38373,38374,38375,38377,
   38383,38384,38386,38388,38390,38485,38486,38488,38494,38495,
   38497,38499,38501,38521,38523,38529,38530,38532,38534,38536,
   38557,38563,38564,38566,38568,38570,38628,38629,38631,38633,
   38635,38800,38802,38804,38806,38827,38829,38831,38876,38878,
   38921,39151,39152,39153,39156,39157,39158,39160,39166,39167,
   39169,39171,39173,39193,39194,39197,39198,39199,39201,39207,
   39208,39210,39212,39214,39234,39237,39238,39239,39241,39247,
   39248,39250,39252,39254,39276,39277,39278,39280,39286,39287,
   39289,39291,39293,39388,39389,39391,39397,39398,39400,39402,
   39404,39424,39426,39432,39433,39435,39437,39439,39460,39466,
   39467,39469,39471,39473,39531,39532,39534,39536,39538,39703,
   39705,39707,39709,39730,39732,39734,39779,39781,39824,40054,
   40055,40058,40059,40060,40062,40068,40069,40071,40073,40075,
   40095,40098,40099,40100,40102,40108,40109,40111,40113,40115,
   40137,40138,40139,40141,40147,40148,40150,40152,40154,40249,
   40250,40252,40258,40259,40261,40263,40265,40285,40287,40293,
   40294,40296,40298,40300,40321,40327,40328,40330,40332,40334,
   40392,40393,40395,40397,40399,40564,40566,40568,40570,40591,
   40593,40595,40640,40642,40685,40915,40918,40919,40920,40922,
   40928,40929,40931,40933,40935,40957,40958,40959,40961,40967,
   40968,40970,40972,40974,41069,41070,41072,41078,41079,41081,
   41083,41085,41105,41107,41113,41114,41116,41118,41120,41141,
   41147,41148,41150,41152,41154,41212,41213,41215,41217,41219,
   41384,41386,41388,41390,41411,41413,41415,41460,41462,41505,
   41737,41738,41739,41741,41747,41748,41750,41752,41754,41849,
   41850,41852,41858,41859,41861,41863,41865,41885,41887,41893,
   41894,41896,41898,41900,41921,41927,41928,41930,41932,41934,
   41992,41993,41995,41997,41999,42164,42166,42168,42170,42191,
   42193,42195,42240,42242,42285,42590,42591,42593,42599,42600,
   42602,42604,42606,42626,42628,42634,42635,42637,42639,42641,
   42662,42668,42669,42671,42673,42675,42733,42734,42736,42738,
   42740,42905,42907,42909,42911,42932,42934,42936,42981,42983,
   43026,44625,44627,44633,44634,44636,44638,44640,44661,44667,
   44668,44670,44672,44674,44732,44733,44735,44737,44739,44904,
   44906,44908,44910,44931,44933,44935,44980,44982,45025,45256,
   45262,45263,45265,45267,45269,45327,45328,45330,45332,45334,
   45499,45501,45503,45505,45526,45528,45530,45575,45577,45620,
   45888,45889,45891,45893,45895,46060,46062,46064,46066,46087,
   46089,46091,46136,46138,46181,47084,47086,47088,47090,47111,
   47113,47115,47160,47162,47205,49471,49473,49475,49520,49522,
   49565,49820,49822,49865,50394],
 [1,2,23,26,31,32,41,42,44,68,89,90,91,92,93,94,107,156,
   157,158,163,164,166,173,177,179,1289,1290,1291,1292,1293,
   1296,1297,1298,1300,1306,1307,1309,1311,1313,1333,1334,1335,
   1336,1339,1340,1341,1343,1349,1350,1352,1354,1356,1376,1377,
   1378,1381,1382,1383,1385,1391,1392,1394,1396,1398,1418,1419,
   1422,1423,1424,1426,1432,1433,1435,1437,1439,1459,1462,1463,
   1464,1466,1472,1473,1475,1477,1479,1501,1502,1503,1505,1511,
   1512,1514,1516,1518,1613,1614,1616,1622,1623,1625,1627,1629,
   1649,1651,1657,1658,1660,1662,1664,1685,1691,1692,1694,1696,
   1698,1756,1757,1759,1761,1763,1928,1930,1932,1934,1955,1957,
   1959,2004,2006,2049,2279,2300,2301,2302,2305,2308,2310,2318,
   2319,2321,2365,2366,2367,2370,2373,2375,2383,2384,2386,3500,
   3501,3502,3503,3504,3507,3508,3509,3511,3517,3518,3520,3522,
   3524,3544,3545,3546,3547,3550,3551,3552,3554,3560,3561,3563,
   3565,3567,3587,3588,3589,3592,3593,3594,3596,3602,3603,3605,
   3607,3609,3629,3630,3633,3634,3635,3637,3643,3644,3646,3648,
   3650,3670,3673,3674,3675,3677,3683,3684,3686,3688,3690,3712,
   3713,3714,3716,3722,3723,3725,3727,3729,3824,3825,3827,3833,
   3834,3836,3838,3840,3860,3862,3868,3869,3871,3873,3875,3896,
   3902,3903,3905,3907,3909,3967,3968,3970,3972,3974,4139,4141,
   4143,4145,4166,4168,4170,4215,4217,4260,4510,4511,4512,4515,
   4518,4520,4528,4529,4531,5645,5646,5647,5648,5649,5652,5653,
   5654,5656,5662,5663,5665,5667,5669,5689,5690,5691,5692,5695,
   5696,5697,5699,5705,5706,5708,5710,5712,5732,5733,5734,5737,
   5738,5739,5741,5747,5748,5750,5752,5754,5774,5775,5778,5779,
   5780,5782,5788,5789,5791,5793,5795,5815,5818,5819,5820,5822,
   5828,5829,5831,5833,5835,5857,5858,5859,5861,5867,5868,5870,
   5872,5874,5969,5970,5972,5978,5979,5981,5983,5985,6005,6007,
   6013,6014,6016,6018,6020,6041,6047,6048,6050,6052,6054,6112,
   6113,6115,6117,6119,6284,6286,6288,6290,6311,6313,6315,6360,
   6362,6405,7725,7726,7727,7728,7729,7732,7733,7734,7736,7742,
   7743,7745,7747,7749,7769,7770,7771,7772,7775,7776,7777,7779,
   7785,7786,7788,7790,7792,7812,7813,7814,7817,7818,7819,7821,
   7827,7828,7830,7832,7834,7854,7855,7858,7859,7860,7862,7868,
   7869,7871,7873,7875,7895,7898,7899,7900,7902,7908,7909,7911,
   7913,7915,7937,7938,7939,7941,7947,7948,7950,7952,7954,8049,
   8050,8052,8058,8059,8061,8063,8065,8085,8087,8093,8094,8096,
   8098,8100,8121,8127,8128,8130,8132,8134,8192,8193,8195,8197,
   8199,8364,8366,8368,8370,8391,8393,8395,8440,8442,8485,
   38205,38206,38207,38208,38211,38212,38213,38215,38221,38222,
   38224,38226,38228,38248,38249,38250,38253,38254,38255,38257,
   38263,38264,38266,38268,38270,38290,38291,38294,38295,38296,
   38298,38304,38305,38307,38309,38311,38331,38334,38335,38336,
   38338,38344,38345,38347,38349,38351,38373,38374,38375,38377,
   38383,38384,38386,38388,38390,38485,38486,38488,38494,38495,
   38497,38499,38501,38521,38523,38529,38530,38532,38534,38536,
   38557,38563,38564,38566,38568,38570,38628,38629,38631,38633,
   38635,38800,38802,38804,38806,38827,38829,38831,38876,38878,
   38921,39151,39152,39153,39156,39157,39158,39160,39166,39167,
   39169,39171,39173,39193,39194,39197,39198,39199,39201,39207,
   39208,39210,39212,39214,39234,39237,39238,39239,39241,39247,
   39248,39250,39252,39254,39276,39277,39278,39280,39286,39287,
   39289,39291,39293,39388,39389,39391,39397,39398,39400,39402,
   39404,39424,39426,39432,39433,39435,39437,39439,39460,39466,
   39467,39469,39471,39473,39531,39532,39534,39536,39538,39703,
   39705,39707,39709,39730,39732,39734,39779,39781,39824,40054,
   40055,40058,40059,40060,40062,40068,40069,40071,40073,40075,
   40095,40098,40099,40100,40102,40108,40109,40111,40113,40115,
   40137,40138,40139,40141,40147,40148,40150,40152,40154,40249,
   40250,40252,40258,40259,40261,40263,40265,40285,40287,40293,
   40294,40296,40298,40300,40321,40327,40328,40330,40332,40334,
   40392,40393,40395,40397,40399,40564,40566,40568,40570,40591,
   40593,40595,40640,40642,40685,40915,40918,40919,40920,40922,
   40928,40929,40931,40933,40935,40957,40958,40959,40961,40967,
   40968,40970,40972,40974,41069,41070,41072,41078,41079,41081,
   41083,41085,41105,41107,41113,41114,41116,41118,41120,41141,
   41147,41148,41150,41152,41154,41212,41213,41215,41217,41219,
   41384,41386,41388,41390,41411,41413,41415,41460,41462,41505,
   41737,41738,41739,41741,41747,41748,41750,41752,41754,41849,
   41850,41852,41858,41859,41861,41863,41865,41885,41887,41893,
   41894,41896,41898,41900,41921,41927,41928,41930,41932,41934,
   41992,41993,41995,41997,41999,42164,42166,42168,42170,42191,
   42193,42195,42240,42242,42285,42590,42591,42593,42599,42600,
   42602,42604,42606,42626,42628,42634,42635,42637,42639,42641,
   42662,42668,42669,42671,42673,42675,42733,42734,42736,42738,
   42740,42905,42907,42909,42911,42932,42934,42936,42981,42983,
   43026,44625,44627,44633,44634,44636,44638,44640,44661,44667,
   44668,44670,44672,44674,44732,44733,44735,44737,44739,44904,
   44906,44908,44910,44931,44933,44935,44980,44982,45025,45256,
   45262,45263,45265,45267,45269,45327,45328,45330,45332,45334,
   45499,45501,45503,45505,45526,45528,45530,45575,45577,45620,
   45888,45889,45891,45893,45895,46060,46062,46064,46066,46087,
   46089,46091,46136,46138,46181,47084,47086,47088,47090,47111,
   47113,47115,47160,47162,47205,49471,49473,49475,49520,49522,
   49565,49820,49822,49865,50394],
 [23,31,44,1291,1296,1297,1306,1307,1309,1432,1625,1658,3502,
   3507,3508,3517,3518,3520,3633,3634,3824,3833,3834,3836,4139,
   38294,38295,38304,38305,38307,38485,38494,38495,38497,38529,
   38530,38532,38800,38802,38827,41069,41078,41079,41081,41113,
   41114,41116,41384,41386,41411,44633,44634,44636,44904,44906,
   44931,45499,45501,45526,49471],
 [1,2,23,26,31,32,41,42,44,68,89,90,91,92,93,94,107,156,
   157,158,163,164,166,173,177,179,1289,1290,1291,1292,1293,
   1296,1297,1298,1300,1306,1307,1309,1311,1313,1333,1334,1335,
   1336,1339,1340,1341,1343,1349,1350,1352,1354,1356,1376,1377,
   1378,1381,1382,1383,1385,1391,1392,1394,1396,1398,1418,1419,
   1422,1423,1424,1426,1432,1433,1435,1437,1439,1459,1462,1463,
   1464,1466,1472,1473,1475,1477,1479,1501,1502,1503,1505,1511,
   1512,1514,1516,1518,1613,1614,1616,1622,1623,1625,1627,1629,
   1649,1651,1657,1658,1660,1662,1664,1685,1691,1692,1694,1696,
   1698,1756,1757,1759,1761,1763,1928,1930,1932,1934,1955,1957,
   1959,2004,2006,2049,2279,2300,2301,2302,2305,2308,2310,2318,
   2319,2321,2365,2366,2367,2370,2373,2375,2383,2384,2386,3500,
   3501,3502,3503,3504,3507,3508,3509,3511,3517,3518,3520,3522,
   3524,3544,3545,3546,3547,3550,3551,3552,3554,3560,3561,3563,
   3565,3567,3587,3588,3589,3592,3593,3594,3596,3602,3603,3605,
   3607,3609,3629,3630,3633,3634,3635,3637,3643,3644,3646,3648,
   3650,3670,3673,3674,3675,3677,3683,3684,3686,3688,3690,3712,
   3713,3714,3716,3722,3723,3725,3727,3729,3824,3825,3827,3833,
   3834,3836,3838,3840,3860,3862,3868,3869,3871,3873,3875,3896,
   3902,3903,3905,3907,3909,3967,3968,3970,3972,3974,4139,4141,
   4143,4145,4166,4168,4170,4215,4217,4260,4510,4511,4512,4515,
   4518,4520,4528,4529,4531,5645,5646,5647,5648,5649,5652,5653,
   5654,5656,5662,5663,5665,5667,5669,5689,5690,5691,5692,5695,
   5696,5697,5699,5705,5706,5708,5710,5712,5732,5733,5734,5737,
   5738,5739,5741,5747,5748,5750,5752,5754,5774,5775,5778,5779,
   5780,5782,5788,5789,5791,5793,5795,5815,5818,5819,5820,5822,
   5828,5829,5831,5833,5835,5857,5858,5859,5861,5867,5868,5870,
   5872,5874,5969,5970,5972,5978,5979,5981,5983,5985,6005,6007,
   6013,6014,6016,6018,6020,6041,6047,6048,6050,6052,6054,6112,
   6113,6115,6117,6119,6284,6286,6288,6290,6311,6313,6315,6360,
   6362,6405,7725,7726,7727,7728,7729,7732,7733,7734,7736,7742,
   7743,7745,7747,7749,7769,7770,7771,7772,7775,7776,7777,7779,
   7785,7786,7788,7790,7792,7812,7813,7814,7817,7818,7819,7821,
   7827,7828,7830,7832,7834,7854,7855,7858,7859,7860,7862,7868,
   7869,7871,7873,7875,7895,7898,7899,7900,7902,7908,7909,7911,
   7913,7915,7937,7938,7939,7941,7947,7948,7950,7952,7954,8049,
   8050,8052,8058,8059,8061,8063,8065,8085,8087,8093,8094,8096,
   8098,8100,8121,8127,8128,8130,8132,8134,8192,8193,8195,8197,
   8199,8364,8366,8368,8370,8391,8393,8395,8440,8442,8485,
   38205,38206,38207,38208,38211,38212,38213,38215,38221,38222,
   38224,38226,38228,38248,38249,38250,38253,38254,38255,38257,
   38263,38264,38266,38268,38270,38290,38291,38294,38295,38296,
   38298,38304,38305,38307,38309,38311,38331,38334,38335,38336,
   38338,38344,38345,38347,38349,38351,38373,38374,38375,38377,
   38383,38384,38386,38388,38390,38485,38486,38488,38494,38495,
   38497,38499,38501,38521,38523,38529,38530,38532,38534,38536,
   38557,38563,38564,38566,38568,38570,38628,38629,38631,38633,
   38635,38800,38802,38804,38806,38827,38829,38831,38876,38878,
   38921,39151,39152,39153,39156,39157,39158,39160,39166,39167,
   39169,39171,39173,39193,39194,39197,39198,39199,39201,39207,
   39208,39210,39212,39214,39234,39237,39238,39239,39241,39247,
   39248,39250,39252,39254,39276,39277,39278,39280,39286,39287,
   39289,39291,39293,39388,39389,39391,39397,39398,39400,39402,
   39404,39424,39426,39432,39433,39435,39437,39439,39460,39466,
   39467,39469,39471,39473,39531,39532,39534,39536,39538,39703,
   39705,39707,39709,39730,39732,39734,39779,39781,39824,40054,
   40055,40058,40059,40060,40062,40068,40069,40071,40073,40075,
   40095,40098,40099,40100,40102,40108,40109,40111,40113,40115,
   40137,40138,40139,40141,40147,40148,40150,40152,40154,40249,
   40250,40252,40258,40259,40261,40263,40265,40285,40287,40293,
   40294,40296,40298,40300,40321,40327,40328,40330,40332,40334,
   40392,40393,40395,40397,40399,40564,40566,40568,40570,40591,
   40593,40595,40640,40642,40685,40915,40918,40919,40920,40922,
   40928,40929,40931,40933,40935,40957,40958,40959,40961,40967,
   40968,40970,40972,40974,41069,41070,41072,41078,41079,41081,
   41083,41085,41105,41107,41113,41114,41116,41118,41120,41141,
   41147,41148,41150,41152,41154,41212,41213,41215,41217,41219,
   41384,41386,41388,41390,41411,41413,41415,41460,41462,41505,
   41737,41738,41739,41741,41747,41748,41750,41752,41754,41849,
   41850,41852,41858,41859,41861,41863,41865,41885,41887,41893,
   41894,41896,41898,41900,41921,41927,41928,41930,41932,41934,
   41992,41993,41995,41997,41999,42164,42166,42168,42170,42191,
   42193,42195,42240,42242,42285,42590,42591,42593,42599,42600,
   42602,42604,42606,42626,42628,42634,42635,42637,42639,42641,
   42662,42668,42669,42671,42673,42675,42733,42734,42736,42738,
   42740,42905,42907,42909,42911,42932,42934,42936,42981,42983,
   43026,44625,44627,44633,44634,44636,44638,44640,44661,44667,
   44668,44670,44672,44674,44732,44733,44735,44737,44739,44904,
   44906,44908,44910,44931,44933,44935,44980,44982,45025,45256,
   45262,45263,45265,45267,45269,45327,45328,45330,45332,45334,
   45499,45501,45503,45505,45526,45528,45530,45575,45577,45620,
   45888,45889,45891,45893,45895,46060,46062,46064,46066,46087,
   46089,46091,46136,46138,46181,47084,47086,47088,47090,47111,
   47113,47115,47160,47162,47205,49471,49473,49475,49520,49522,
   49565,49820,49822,49865,50394],
 [1,2,23,26,31,32,41,42,44,68,89,90,91,92,93,94,107,156,
   157,158,163,164,166,173,177,179,1289,1290,1291,1292,1293,
   1296,1297,1298,1300,1306,1307,1309,1311,1313,1333,1334,1335,
   1336,1339,1340,1341,1343,1349,1350,1352,1354,1356,1376,1377,
   1378,1381,1382,1383,1385,1391,1392,1394,1396,1398,1418,1419,
   1422,1423,1424,1426,1432,1433,1435,1437,1439,1459,1462,1463,
   1464,1466,1472,1473,1475,1477,1479,1501,1502,1503,1505,1511,
   1512,1514,1516,1518,1613,1614,1616,1622,1623,1625,1627,1629,
   1649,1651,1657,1658,1660,1662,1664,1685,1691,1692,1694,1696,
   1698,1756,1757,1759,1761,1763,1928,1930,1932,1934,1955,1957,
   1959,2004,2006,2049,2279,2300,2301,2302,2305,2308,2310,2318,
   2319,2321,2365,2366,2367,2370,2373,2375,2383,2384,2386,3500,
   3501,3502,3503,3504,3507,3508,3509,3511,3517,3518,3520,3522,
   3524,3544,3545,3546,3547,3550,3551,3552,3554,3560,3561,3563,
   3565,3567,3587,3588,3589,3592,3593,3594,3596,3602,3603,3605,
   3607,3609,3629,3630,3633,3634,3635,3637,3643,3644,3646,3648,
   3650,3670,3673,3674,3675,3677,3683,3684,3686,3688,3690,3712,
   3713,3714,3716,3722,3723,3725,3727,3729,3824,3825,3827,3833,
   3834,3836,3838,3840,3860,3862,3868,3869,3871,3873,3875,3896,
   3902,3903,3905,3907,3909,3967,3968,3970,3972,3974,4139,4141,
   4143,4145,4166,4168,4170,4215,4217,4260,4510,4511,4512,4515,
   4518,4520,4528,4529,4531,5645,5646,5647,5648,5649,5652,5653,
   5654,5656,5662,5663,5665,5667,5669,5689,5690,5691,5692,5695,
   5696,5697,5699,5705,5706,5708,5710,5712,5732,5733,5734,5737,
   5738,5739,5741,5747,5748,5750,5752,5754,5774,5775,5778,5779,
   5780,5782,5788,5789,5791,5793,5795,5815,5818,5819,5820,5822,
   5828,5829,5831,5833,5835,5857,5858,5859,5861,5867,5868,5870,
   5872,5874,5969,5970,5972,5978,5979,5981,5983,5985,6005,6007,
   6013,6014,6016,6018,6020,6041,6047,6048,6050,6052,6054,6112,
   6113,6115,6117,6119,6284,6286,6288,6290,6311,6313,6315,6360,
   6362,6405,7725,7726,7727,7728,7729,7732,7733,7734,7736,7742,
   7743,7745,7747,7749,7769,7770,7771,7772,7775,7776,7777,7779,
   7785,7786,7788,7790,7792,7812,7813,7814,7817,7818,7819,7821,
   7827,7828,7830,7832,7834,7854,7855,7858,7859,7860,7862,7868,
   7869,7871,7873,7875,7895,7898,7899,7900,7902,7908,7909,7911,
   7913,7915,7937,7938,7939,7941,7947,7948,7950,7952,7954,8049,
   8050,8052,8058,8059,8061,8063,8065,8085,8087,8093,8094,8096,
   8098,8100,8121,8127,8128,8130,8132,8134,8192,8193,8195,8197,
   8199,8364,8366,8368,8370,8391,8393,8395,8440,8442,8485,
   38205,38206,38207,38208,38211,38212,38213,38215,38221,38222,
   38224,38226,38228,38248,38249,38250,38253,38254,38255,38257,
   38263,38264,38266,38268,38270,38290,38291,38294,38295,38296,
   38298,38304,38305,38307,38309,38311,38331,38334,38335,38336,
   38338,38344,38345,38347,38349,38351,38373,38374,38375,38377,
   38383,38384,38386,38388,38390,38485,38486,38488,38494,38495,
   38497,38499,38501,38521,38523,38529,38530,38532,38534,38536,
   38557,38563,38564,38566,38568,38570,38628,38629,38631,38633,
   38635,38800,38802,38804,38806,38827,38829,38831,38876,38878,
   38921,39151,39152,39153,39156,39157,39158,39160,39166,39167,
   39169,39171,39173,39193,39194,39197,39198,39199,39201,39207,
   39208,39210,39212,39214,39234,39237,39238,39239,39241,39247,
   39248,39250,39252,39254,39276,39277,39278,39280,39286,39287,
   39289,39291,39293,39388,39389,39391,39397,39398,39400,39402,
   39404,39424,39426,39432,39433,39435,39437,39439,39460,39466,
   39467,39469,39471,39473,39531,39532,39534,39536,39538,39703,
   39705,39707,39709,39730,39732,39734,39779,39781,39824,40054,
   40055,40058,40059,40060,40062,40068,40069,40071,40073,40075,
   40095,40098,40099,40100,40102,40108,40109,40111,40113,40115,
   40137,40138,40139,40141,40147,40148,40150,40152,40154,40249,
   40250,40252,40258,40259,40261,40263,40265,40285,40287,40293,
   40294,40296,40298,40300,40321,40327,40328,40330,40332,40334,
   40392,40393,40395,40397,40399,40564,40566,40568,40570,40591,
   40593,40595,40640,40642,40685,40915,40918,40919,40920,40922,
   40928,40929,40931,40933,40935,40957,40958,40959,40961,40967,
   40968,40970,40972,40974,41069,41070,41072,41078,41079,41081,
   41083,41085,41105,41107,41113,41114,41116,41118,41120,41141,
   41147,41148,41150,41152,41154,41212,41213,41215,41217,41219,
   41384,41386,41388,41390,41411,41413,41415,41460,41462,41505,
   41737,41738,41739,41741,41747,41748,41750,41752,41754,41849,
   41850,41852,41858,41859,41861,41863,41865,41885,41887,41893,
   41894,41896,41898,41900,41921,41927,41928,41930,41932,41934,
   41992,41993,41995,41997,41999,42164,42166,42168,42170,42191,
   42193,42195,42240,42242,42285,42590,42591,42593,42599,42600,
   42602,42604,42606,42626,42628,42634,42635,42637,42639,42641,
   42662,42668,42669,42671,42673,42675,42733,42734,42736,42738,
   42740,42905,42907,42909,42911,42932,42934,42936,42981,42983,
   43026,44625,44627,44633,44634,44636,44638,44640,44661,44667,
   44668,44670,44672,44674,44732,44733,44735,44737,44739,44904,
   44906,44908,44910,44931,44933,44935,44980,44982,45025,45256,
   45262,45263,45265,45267,45269,45327,45328,45330,45332,45334,
   45499,45501,45503,45505,45526,45528,45530,45575,45577,45620,
   45888,45889,45891,45893,45895,46060,46062,46064,46066,46087,
   46089,46091,46136,46138,46181,47084,47086,47088,47090,47111,
   47113,47115,47160,47162,47205,49471,49473,49475,49520,49522,
   49565,49820,49822,49865,50394],[3756],
 [23,26,31,32,41,42,44,1291,1295,1296,1297,1303,1306,1307,
   1309,1421,1422,1423,1429,1432,1433,1435,1576,1577,1583,1586,
   1587,1589,1613,1619,1622,1623,1625,1654,1657,1658,1660,1846,
   1847,1849,1928,1930,1955,3502,3506,3507,3508,3514,3517,3518,
   3520,3632,3633,3634,3640,3643,3644,3646,3787,3788,3794,3797,
   3798,3800,3824,3830,3833,3834,3836,3865,3868,3869,3871,4057,
   4058,4060,4139,4141,4166,38293,38294,38295,38301,38304,38305,
   38307,38448,38449,38455,38458,38459,38461,38485,38491,38494,
   38495,38497,38526,38529,38530,38532,38718,38719,38721,38800,
   38802,38827,41032,41033,41039,41042,41043,41045,41069,41075,
   41078,41079,41081,41110,41113,41114,41116,41302,41303,41305,
   41384,41386,41411,43959,43965,43968,43969,43971,44000,44003,
   44004,44006,44192,44193,44195,44274,44276,44301,44630,44633,
   44634,44636,44822,44823,44825,44904,44906,44931,45417,45418,
   45420,45499,45501,45526,48390,48392,48417,49471],
 [1625,3507,3520,3836,38497],
 [23,31,44,1291,1296,1297,1306,1307,1309,1432,1625,1658,3502,
   3507,3508,3517,3518,3520,3633,3634,3824,3833,3834,3836,4139,
   38294,38295,38304,38305,38307,38485,38494,38495,38497,38529,
   38530,38532,38800,38802,38827,41069,41078,41079,41081,41113,
   41114,41116,41384,41386,41411,44633,44634,44636,44904,44906,
   44931,45499,45501,45526,49471],
 [1,2,23,26,31,32,41,42,44,68,89,90,91,92,93,94,107,156,
   157,158,163,164,166,173,177,179,1289,1290,1291,1292,1293,
   1296,1297,1298,1300,1306,1307,1309,1311,1313,1333,1334,1335,
   1336,1339,1340,1341,1343,1349,1350,1352,1354,1356,1376,1377,
   1378,1381,1382,1383,1385,1391,1392,1394,1396,1398,1418,1419,
   1422,1423,1424,1426,1432,1433,1435,1437,1439,1459,1462,1463,
   1464,1466,1472,1473,1475,1477,1479,1501,1502,1503,1505,1511,
   1512,1514,1516,1518,1613,1614,1616,1622,1623,1625,1627,1629,
   1649,1651,1657,1658,1660,1662,1664,1685,1691,1692,1694,1696,
   1698,1756,1757,1759,1761,1763,1928,1930,1932,1934,1955,1957,
   1959,2004,2006,2049,2279,2300,2301,2302,2305,2308,2310,2318,
   2319,2321,2365,2366,2367,2370,2373,2375,2383,2384,2386,3500,
   3501,3502,3503,3504,3507,3508,3509,3511,3517,3518,3520,3522,
   3524,3544,3545,3546,3547,3550,3551,3552,3554,3560,3561,3563,
   3565,3567,3587,3588,3589,3592,3593,3594,3596,3602,3603,3605,
   3607,3609,3629,3630,3633,3634,3635,3637,3643,3644,3646,3648,
   3650,3670,3673,3674,3675,3677,3683,3684,3686,3688,3690,3712,
   3713,3714,3716,3722,3723,3725,3727,3729,3824,3825,3827,3833,
   3834,3836,3838,3840,3860,3862,3868,3869,3871,3873,3875,3896,
   3902,3903,3905,3907,3909,3967,3968,3970,3972,3974,4139,4141,
   4143,4145,4166,4168,4170,4215,4217,4260,4510,4511,4512,4515,
   4518,4520,4528,4529,4531,5645,5646,5647,5648,5649,5652,5653,
   5654,5656,5662,5663,5665,5667,5669,5689,5690,5691,5692,5695,
   5696,5697,5699,5705,5706,5708,5710,5712,5732,5733,5734,5737,
   5738,5739,5741,5747,5748,5750,5752,5754,5774,5775,5778,5779,
   5780,5782,5788,5789,5791,5793,5795,5815,5818,5819,5820,5822,
   5828,5829,5831,5833,5835,5857,5858,5859,5861,5867,5868,5870,
   5872,5874,5969,5970,5972,5978,5979,5981,5983,5985,6005,6007,
   6013,6014,6016,6018,6020,6041,6047,6048,6050,6052,6054,6112,
   6113,6115,6117,6119,6284,6286,6288,6290,6311,6313,6315,6360,
   6362,6405,7725,7726,7727,7728,7729,7732,7733,7734,7736,7742,
   7743,7745,7747,7749,7769,7770,7771,7772,7775,7776,7777,7779,
   7785,7786,7788,7790,7792,7812,7813,7814,7817,7818,7819,7821,
   7827,7828,7830,7832,7834,7854,7855,7858,7859,7860,7862,7868,
   7869,7871,7873,7875,7895,7898,7899,7900,7902,7908,7909,7911,
   7913,7915,7937,7938,7939,7941,7947,7948,7950,7952,7954,8049,
   8050,8052,8058,8059,8061,8063,8065,8085,8087,8093,8094,8096,
   8098,8100,8121,8127,8128,8130,8132,8134,8192,8193,8195,8197,
   8199,8364,8366,8368,8370,8391,8393,8395,8440,8442,8485,
   38205,38206,38207,38208,38211,38212,38213,38215,38221,38222,
   38224,38226,38228,38248,38249,38250,38253,38254,38255,38257,
   38263,38264,38266,38268,38270,38290,38291,38294,38295,38296,
   38298,38304,38305,38307,38309,38311,38331,38334,38335,38336,
   38338,38344,38345,38347,38349,38351,38373,38374,38375,38377,
   38383,38384,38386,38388,38390,38485,38486,38488,38494,38495,
   38497,38499,38501,38521,38523,38529,38530,38532,38534,38536,
   38557,38563,38564,38566,38568,38570,38628,38629,38631,38633,
   38635,38800,38802,38804,38806,38827,38829,38831,38876,38878,
   38921,39151,39152,39153,39156,39157,39158,39160,39166,39167,
   39169,39171,39173,39193,39194,39197,39198,39199,39201,39207,
   39208,39210,39212,39214,39234,39237,39238,39239,39241,39247,
   39248,39250,39252,39254,39276,39277,39278,39280,39286,39287,
   39289,39291,39293,39388,39389,39391,39397,39398,39400,39402,
   39404,39424,39426,39432,39433,39435,39437,39439,39460,39466,
   39467,39469,39471,39473,39531,39532,39534,39536,39538,39703,
   39705,39707,39709,39730,39732,39734,39779,39781,39824,40054,
   40055,40058,40059,40060,40062,40068,40069,40071,40073,40075,
   40095,40098,40099,40100,40102,40108,40109,40111,40113,40115,
   40137,40138,40139,40141,40147,40148,40150,40152,40154,40249,
   40250,40252,40258,40259,40261,40263,40265,40285,40287,40293,
   40294,40296,40298,40300,40321,40327,40328,40330,40332,40334,
   40392,40393,40395,40397,40399,40564,40566,40568,40570,40591,
   40593,40595,40640,40642,40685,40915,40918,40919,40920,40922,
   40928,40929,40931,40933,40935,40957,40958,40959,40961,40967,
   40968,40970,40972,40974,41069,41070,41072,41078,41079,41081,
   41083,41085,41105,41107,41113,41114,41116,41118,41120,41141,
   41147,41148,41150,41152,41154,41212,41213,41215,41217,41219,
   41384,41386,41388,41390,41411,41413,41415,41460,41462,41505,
   41737,41738,41739,41741,41747,41748,41750,41752,41754,41849,
   41850,41852,41858,41859,41861,41863,41865,41885,41887,41893,
   41894,41896,41898,41900,41921,41927,41928,41930,41932,41934,
   41992,41993,41995,41997,41999,42164,42166,42168,42170,42191,
   42193,42195,42240,42242,42285,42590,42591,42593,42599,42600,
   42602,42604,42606,42626,42628,42634,42635,42637,42639,42641,
   42662,42668,42669,42671,42673,42675,42733,42734,42736,42738,
   42740,42905,42907,42909,42911,42932,42934,42936,42981,42983,
   43026,44625,44627,44633,44634,44636,44638,44640,44661,44667,
   44668,44670,44672,44674,44732,44733,44735,44737,44739,44904,
   44906,44908,44910,44931,44933,44935,44980,44982,45025,45256,
   45262,45263,45265,45267,45269,45327,45328,45330,45332,45334,
   45499,45501,45503,45505,45526,45528,45530,45575,45577,45620,
   45888,45889,45891,45893,45895,46060,46062,46064,46066,46087,
   46089,46091,46136,46138,46181,47084,47086,47088,47090,47111,
   47113,47115,47160,47162,47205,49471,49473,49475,49520,49522,
   49565,49820,49822,49865,50394],[1719,3930],
 [1,2,23,26,31,32,41,42,44,68,89,90,91,92,93,94,107,156,
   157,158,163,164,166,173,177,179,1289,1290,1291,1292,1293,
   1296,1297,1298,1300,1306,1307,1309,1311,1313,1333,1334,1335,
   1336,1339,1340,1341,1343,1349,1350,1352,1354,1356,1376,1377,
   1378,1381,1382,1383,1385,1391,1392,1394,1396,1398,1418,1419,
   1422,1423,1424,1426,1432,1433,1435,1437,1439,1459,1462,1463,
   1464,1466,1472,1473,1475,1477,1479,1501,1502,1503,1505,1511,
   1512,1514,1516,1518,1613,1614,1616,1622,1623,1625,1627,1629,
   1649,1651,1657,1658,1660,1662,1664,1685,1691,1692,1694,1696,
   1698,1756,1757,1759,1761,1763,1928,1930,1932,1934,1955,1957,
   1959,2004,2006,2049,2279,2300,2301,2302,2305,2308,2310,2318,
   2319,2321,2365,2366,2367,2370,2373,2375,2383,2384,2386,3500,
   3501,3502,3503,3504,3507,3508,3509,3511,3517,3518,3520,3522,
   3524,3544,3545,3546,3547,3550,3551,3552,3554,3560,3561,3563,
   3565,3567,3587,3588,3589,3592,3593,3594,3596,3602,3603,3605,
   3607,3609,3629,3630,3633,3634,3635,3637,3643,3644,3646,3648,
   3650,3670,3673,3674,3675,3677,3683,3684,3686,3688,3690,3712,
   3713,3714,3716,3722,3723,3725,3727,3729,3824,3825,3827,3833,
   3834,3836,3838,3840,3860,3862,3868,3869,3871,3873,3875,3896,
   3902,3903,3905,3907,3909,3967,3968,3970,3972,3974,4139,4141,
   4143,4145,4166,4168,4170,4215,4217,4260,4510,4511,4512,4515,
   4518,4520,4528,4529,4531,5645,5646,5647,5648,5649,5652,5653,
   5654,5656,5662,5663,5665,5667,5669,5689,5690,5691,5692,5695,
   5696,5697,5699,5705,5706,5708,5710,5712,5732,5733,5734,5737,
   5738,5739,5741,5747,5748,5750,5752,5754,5774,5775,5778,5779,
   5780,5782,5788,5789,5791,5793,5795,5815,5818,5819,5820,5822,
   5828,5829,5831,5833,5835,5857,5858,5859,5861,5867,5868,5870,
   5872,5874,5969,5970,5972,5978,5979,5981,5983,5985,6005,6007,
   6013,6014,6016,6018,6020,6041,6047,6048,6050,6052,6054,6112,
   6113,6115,6117,6119,6284,6286,6288,6290,6311,6313,6315,6360,
   6362,6405,7725,7726,7727,7728,7729,7732,7733,7734,7736,7742,
   7743,7745,7747,7749,7769,7770,7771,7772,7775,7776,7777,7779,
   7785,7786,7788,7790,7792,7812,7813,7814,7817,7818,7819,7821,
   7827,7828,7830,7832,7834,7854,7855,7858,7859,7860,7862,7868,
   7869,7871,7873,7875,7895,7898,7899,7900,7902,7908,7909,7911,
   7913,7915,7937,7938,7939,7941,7947,7948,7950,7952,7954,8049,
   8050,8052,8058,8059,8061,8063,8065,8085,8087,8093,8094,8096,
   8098,8100,8121,8127,8128,8130,8132,8134,8192,8193,8195,8197,
   8199,8364,8366,8368,8370,8391,8393,8395,8440,8442,8485,
   38205,38206,38207,38208,38211,38212,38213,38215,38221,38222,
   38224,38226,38228,38248,38249,38250,38253,38254,38255,38257,
   38263,38264,38266,38268,38270,38290,38291,38294,38295,38296,
   38298,38304,38305,38307,38309,38311,38331,38334,38335,38336,
   38338,38344,38345,38347,38349,38351,38373,38374,38375,38377,
   38383,38384,38386,38388,38390,38485,38486,38488,38494,38495,
   38497,38499,38501,38521,38523,38529,38530,38532,38534,38536,
   38557,38563,38564,38566,38568,38570,38628,38629,38631,38633,
   38635,38800,38802,38804,38806,38827,38829,38831,38876,38878,
   38921,39151,39152,39153,39156,39157,39158,39160,39166,39167,
   39169,39171,39173,39193,39194,39197,39198,39199,39201,39207,
   39208,39210,39212,39214,39234,39237,39238,39239,39241,39247,
   39248,39250,39252,39254,39276,39277,39278,39280,39286,39287,
   39289,39291,39293,39388,39389,39391,39397,39398,39400,39402,
   39404,39424,39426,39432,39433,39435,39437,39439,39460,39466,
   39467,39469,39471,39473,39531,39532,39534,39536,39538,39703,
   39705,39707,39709,39730,39732,39734,39779,39781,39824,40054,
   40055,40058,40059,40060,40062,40068,40069,40071,40073,40075,
   40095,40098,40099,40100,40102,40108,40109,40111,40113,40115,
   40137,40138,40139,40141,40147,40148,40150,40152,40154,40249,
   40250,40252,40258,40259,40261,40263,40265,40285,40287,40293,
   40294,40296,40298,40300,40321,40327,40328,40330,40332,40334,
   40392,40393,40395,40397,40399,40564,40566,40568,40570,40591,
   40593,40595,40640,40642,40685,40915,40918,40919,40920,40922,
   40928,40929,40931,40933,40935,40957,40958,40959,40961,40967,
   40968,40970,40972,40974,41069,41070,41072,41078,41079,41081,
   41083,41085,41105,41107,41113,41114,41116,41118,41120,41141,
   41147,41148,41150,41152,41154,41212,41213,41215,41217,41219,
   41384,41386,41388,41390,41411,41413,41415,41460,41462,41505,
   41737,41738,41739,41741,41747,41748,41750,41752,41754,41849,
   41850,41852,41858,41859,41861,41863,41865,41885,41887,41893,
   41894,41896,41898,41900,41921,41927,41928,41930,41932,41934,
   41992,41993,41995,41997,41999,42164,42166,42168,42170,42191,
   42193,42195,42240,42242,42285,42590,42591,42593,42599,42600,
   42602,42604,42606,42626,42628,42634,42635,42637,42639,42641,
   42662,42668,42669,42671,42673,42675,42733,42734,42736,42738,
   42740,42905,42907,42909,42911,42932,42934,42936,42981,42983,
   43026,44625,44627,44633,44634,44636,44638,44640,44661,44667,
   44668,44670,44672,44674,44732,44733,44735,44737,44739,44904,
   44906,44908,44910,44931,44933,44935,44980,44982,45025,45256,
   45262,45263,45265,45267,45269,45327,45328,45330,45332,45334,
   45499,45501,45503,45505,45526,45528,45530,45575,45577,45620,
   45888,45889,45891,45893,45895,46060,46062,46064,46066,46087,
   46089,46091,46136,46138,46181,47084,47086,47088,47090,47111,
   47113,47115,47160,47162,47205,49471,49473,49475,49520,49522,
   49565,49820,49822,49865,50394],[1719,3930],[3756],
 [23,26,31,32,41,42,44,1291,1295,1296,1297,1303,1306,1307,
   1309,1421,1422,1423,1429,1432,1433,1435,1576,1577,1583,1586,
   1587,1589,1613,1619,1622,1623,1625,1654,1657,1658,1660,1846,
   1847,1849,1928,1930,1955,3502,3506,3507,3508,3514,3517,3518,
   3520,3632,3633,3634,3640,3643,3644,3646,3787,3788,3794,3797,
   3798,3800,3824,3830,3833,3834,3836,3865,3868,3869,3871,4057,
   4058,4060,4139,4141,4166,38293,38294,38295,38301,38304,38305,
   38307,38448,38449,38455,38458,38459,38461,38485,38491,38494,
   38495,38497,38526,38529,38530,38532,38718,38719,38721,38800,
   38802,38827,41032,41033,41039,41042,41043,41045,41069,41075,
   41078,41079,41081,41110,41113,41114,41116,41302,41303,41305,
   41384,41386,41411,43959,43965,43968,43969,43971,44000,44003,
   44004,44006,44192,44193,44195,44274,44276,44301,44630,44633,
   44634,44636,44822,44823,44825,44904,44906,44931,45417,45418,
   45420,45499,45501,45526,48390,48392,48417,49471],
 [1887,4098],[1915,4126],
 [23,31,44,1291,1296,1297,1306,1307,1309,1432,1625,1658,3502,
   3507,3508,3517,3518,3520,3633,3634,3824,3833,3834,3836,4139,
   38294,38295,38304,38305,38307,38485,38494,38495,38497,38529,
   38530,38532,38800,38802,38827,41069,41078,41079,41081,41113,
   41114,41116,41384,41386,41411,44633,44634,44636,44904,44906,
   44931,45499,45501,45526,49471],
 [23,31,44,1291,1296,1297,1306,1307,1309,1432,1625,1658,3502,
   3507,3508,3517,3518,3520,3633,3634,3824,3833,3834,3836,4139,
   38294,38295,38304,38305,38307,38485,38494,38495,38497,38529,
   38530,38532,38800,38802,38827,41069,41078,41079,41081,41113,
   41114,41116,41384,41386,41411,44633,44634,44636,44904,44906,
   44931,45499,45501,45526,49471],[4193],
 [1625,3507,3520,3836,38497],[2033,4244],
 [1,2,23,26,31,32,41,42,44,68,89,90,91,92,93,94,107,156,
   157,158,163,164,166,173,177,179,1289,1290,1291,1292,1293,
   1296,1297,1298,1300,1306,1307,1309,1311,1313,1333,1334,1335,
   1336,1339,1340,1341,1343,1349,1350,1352,1354,1356,1376,1377,
   1378,1381,1382,1383,1385,1391,1392,1394,1396,1398,1418,1419,
   1422,1423,1424,1426,1432,1433,1435,1437,1439,1459,1462,1463,
   1464,1466,1472,1473,1475,1477,1479,1501,1502,1503,1505,1511,
   1512,1514,1516,1518,1613,1614,1616,1622,1623,1625,1627,1629,
   1649,1651,1657,1658,1660,1662,1664,1685,1691,1692,1694,1696,
   1698,1756,1757,1759,1761,1763,1928,1930,1932,1934,1955,1957,
   1959,2004,2006,2049,2279,2300,2301,2302,2305,2308,2310,2318,
   2319,2321,2365,2366,2367,2370,2373,2375,2383,2384,2386,3500,
   3501,3502,3503,3504,3507,3508,3509,3511,3517,3518,3520,3522,
   3524,3544,3545,3546,3547,3550,3551,3552,3554,3560,3561,3563,
   3565,3567,3587,3588,3589,3592,3593,3594,3596,3602,3603,3605,
   3607,3609,3629,3630,3633,3634,3635,3637,3643,3644,3646,3648,
   3650,3670,3673,3674,3675,3677,3683,3684,3686,3688,3690,3712,
   3713,3714,3716,3722,3723,3725,3727,3729,3824,3825,3827,3833,
   3834,3836,3838,3840,3860,3862,3868,3869,3871,3873,3875,3896,
   3902,3903,3905,3907,3909,3967,3968,3970,3972,3974,4139,4141,
   4143,4145,4166,4168,4170,4215,4217,4260,4510,4511,4512,4515,
   4518,4520,4528,4529,4531,5645,5646,5647,5648,5649,5652,5653,
   5654,5656,5662,5663,5665,5667,5669,5689,5690,5691,5692,5695,
   5696,5697,5699,5705,5706,5708,5710,5712,5732,5733,5734,5737,
   5738,5739,5741,5747,5748,5750,5752,5754,5774,5775,5778,5779,
   5780,5782,5788,5789,5791,5793,5795,5815,5818,5819,5820,5822,
   5828,5829,5831,5833,5835,5857,5858,5859,5861,5867,5868,5870,
   5872,5874,5969,5970,5972,5978,5979,5981,5983,5985,6005,6007,
   6013,6014,6016,6018,6020,6041,6047,6048,6050,6052,6054,6112,
   6113,6115,6117,6119,6284,6286,6288,6290,6311,6313,6315,6360,
   6362,6405,7725,7726,7727,7728,7729,7732,7733,7734,7736,7742,
   7743,7745,7747,7749,7769,7770,7771,7772,7775,7776,7777,7779,
   7785,7786,7788,7790,7792,7812,7813,7814,7817,7818,7819,7821,
   7827,7828,7830,7832,7834,7854,7855,7858,7859,7860,7862,7868,
   7869,7871,7873,7875,7895,7898,7899,7900,7902,7908,7909,7911,
   7913,7915,7937,7938,7939,7941,7947,7948,7950,7952,7954,8049,
   8050,8052,8058,8059,8061,8063,8065,8085,8087,8093,8094,8096,
   8098,8100,8121,8127,8128,8130,8132,8134,8192,8193,8195,8197,
   8199,8364,8366,8368,8370,8391,8393,8395,8440,8442,8485,
   38205,38206,38207,38208,38211,38212,38213,38215,38221,38222,
   38224,38226,38228,38248,38249,38250,38253,38254,38255,38257,
   38263,38264,38266,38268,38270,38290,38291,38294,38295,38296,
   38298,38304,38305,38307,38309,38311,38331,38334,38335,38336,
   38338,38344,38345,38347,38349,38351,38373,38374,38375,38377,
   38383,38384,38386,38388,38390,38485,38486,38488,38494,38495,
   38497,38499,38501,38521,38523,38529,38530,38532,38534,38536,
   38557,38563,38564,38566,38568,38570,38628,38629,38631,38633,
   38635,38800,38802,38804,38806,38827,38829,38831,38876,38878,
   38921,39151,39152,39153,39156,39157,39158,39160,39166,39167,
   39169,39171,39173,39193,39194,39197,39198,39199,39201,39207,
   39208,39210,39212,39214,39234,39237,39238,39239,39241,39247,
   39248,39250,39252,39254,39276,39277,39278,39280,39286,39287,
   39289,39291,39293,39388,39389,39391,39397,39398,39400,39402,
   39404,39424,39426,39432,39433,39435,39437,39439,39460,39466,
   39467,39469,39471,39473,39531,39532,39534,39536,39538,39703,
   39705,39707,39709,39730,39732,39734,39779,39781,39824,40054,
   40055,40058,40059,40060,40062,40068,40069,40071,40073,40075,
   40095,40098,40099,40100,40102,40108,40109,40111,40113,40115,
   40137,40138,40139,40141,40147,40148,40150,40152,40154,40249,
   40250,40252,40258,40259,40261,40263,40265,40285,40287,40293,
   40294,40296,40298,40300,40321,40327,40328,40330,40332,40334,
   40392,40393,40395,40397,40399,40564,40566,40568,40570,40591,
   40593,40595,40640,40642,40685,40915,40918,40919,40920,40922,
   40928,40929,40931,40933,40935,40957,40958,40959,40961,40967,
   40968,40970,40972,40974,41069,41070,41072,41078,41079,41081,
   41083,41085,41105,41107,41113,41114,41116,41118,41120,41141,
   41147,41148,41150,41152,41154,41212,41213,41215,41217,41219,
   41384,41386,41388,41390,41411,41413,41415,41460,41462,41505,
   41737,41738,41739,41741,41747,41748,41750,41752,41754,41849,
   41850,41852,41858,41859,41861,41863,41865,41885,41887,41893,
   41894,41896,41898,41900,41921,41927,41928,41930,41932,41934,
   41992,41993,41995,41997,41999,42164,42166,42168,42170,42191,
   42193,42195,42240,42242,42285,42590,42591,42593,42599,42600,
   42602,42604,42606,42626,42628,42634,42635,42637,42639,42641,
   42662,42668,42669,42671,42673,42675,42733,42734,42736,42738,
   42740,42905,42907,42909,42911,42932,42934,42936,42981,42983,
   43026,44625,44627,44633,44634,44636,44638,44640,44661,44667,
   44668,44670,44672,44674,44732,44733,44735,44737,44739,44904,
   44906,44908,44910,44931,44933,44935,44980,44982,45025,45256,
   45262,45263,45265,45267,45269,45327,45328,45330,45332,45334,
   45499,45501,45503,45505,45526,45528,45530,45575,45577,45620,
   45888,45889,45891,45893,45895,46060,46062,46064,46066,46087,
   46089,46091,46136,46138,46181,47084,47086,47088,47090,47111,
   47113,47115,47160,47162,47205,49471,49473,49475,49520,49522,
   49565,49820,49822,49865,50394],[4193],
 [1,2,23,26,31,32,41,42,44,68,89,90,91,92,93,94,107,156,
   157,158,163,164,166,173,177,179,1289,1290,1291,1292,1293,
   1296,1297,1298,1300,1306,1307,1309,1311,1313,1333,1334,1335,
   1336,1339,1340,1341,1343,1349,1350,1352,1354,1356,1376,1377,
   1378,1381,1382,1383,1385,1391,1392,1394,1396,1398,1418,1419,
   1422,1423,1424,1426,1432,1433,1435,1437,1439,1459,1462,1463,
   1464,1466,1472,1473,1475,1477,1479,1501,1502,1503,1505,1511,
   1512,1514,1516,1518,1613,1614,1616,1622,1623,1625,1627,1629,
   1649,1651,1657,1658,1660,1662,1664,1685,1691,1692,1694,1696,
   1698,1756,1757,1759,1761,1763,1928,1930,1932,1934,1955,1957,
   1959,2004,2006,2049,2279,2300,2301,2302,2305,2308,2310,2318,
   2319,2321,2365,2366,2367,2370,2373,2375,2383,2384,2386,3500,
   3501,3502,3503,3504,3507,3508,3509,3511,3517,3518,3520,3522,
   3524,3544,3545,3546,3547,3550,3551,3552,3554,3560,3561,3563,
   3565,3567,3587,3588,3589,3592,3593,3594,3596,3602,3603,3605,
   3607,3609,3629,3630,3633,3634,3635,3637,3643,3644,3646,3648,
   3650,3670,3673,3674,3675,3677,3683,3684,3686,3688,3690,3712,
   3713,3714,3716,3722,3723,3725,3727,3729,3824,3825,3827,3833,
   3834,3836,3838,3840,3860,3862,3868,3869,3871,3873,3875,3896,
   3902,3903,3905,3907,3909,3967,3968,3970,3972,3974,4139,4141,
   4143,4145,4166,4168,4170,4215,4217,4260,4510,4511,4512,4515,
   4518,4520,4528,4529,4531,5645,5646,5647,5648,5649,5652,5653,
   5654,5656,5662,5663,5665,5667,5669,5689,5690,5691,5692,5695,
   5696,5697,5699,5705,5706,5708,5710,5712,5732,5733,5734,5737,
   5738,5739,5741,5747,5748,5750,5752,5754,5774,5775,5778,5779,
   5780,5782,5788,5789,5791,5793,5795,5815,5818,5819,5820,5822,
   5828,5829,5831,5833,5835,5857,5858,5859,5861,5867,5868,5870,
   5872,5874,5969,5970,5972,5978,5979,5981,5983,5985,6005,6007,
   6013,6014,6016,6018,6020,6041,6047,6048,6050,6052,6054,6112,
   6113,6115,6117,6119,6284,6286,6288,6290,6311,6313,6315,6360,
   6362,6405,7725,7726,7727,7728,7729,7732,7733,7734,7736,7742,
   7743,7745,7747,7749,7769,7770,7771,7772,7775,7776,7777,7779,
   7785,7786,7788,7790,7792,7812,7813,7814,7817,7818,7819,7821,
   7827,7828,7830,7832,7834,7854,7855,7858,7859,7860,7862,7868,
   7869,7871,7873,7875,7895,7898,7899,7900,7902,7908,7909,7911,
   7913,7915,7937,7938,7939,7941,7947,7948,7950,7952,7954,8049,
   8050,8052,8058,8059,8061,8063,8065,8085,8087,8093,8094,8096,
   8098,8100,8121,8127,8128,8130,8132,8134,8192,8193,8195,8197,
   8199,8364,8366,8368,8370,8391,8393,8395,8440,8442,8485,
   38205,38206,38207,38208,38211,38212,38213,38215,38221,38222,
   38224,38226,38228,38248,38249,38250,38253,38254,38255,38257,
   38263,38264,38266,38268,38270,38290,38291,38294,38295,38296,
   38298,38304,38305,38307,38309,38311,38331,38334,38335,38336,
   38338,38344,38345,38347,38349,38351,38373,38374,38375,38377,
   38383,38384,38386,38388,38390,38485,38486,38488,38494,38495,
   38497,38499,38501,38521,38523,38529,38530,38532,38534,38536,
   38557,38563,38564,38566,38568,38570,38628,38629,38631,38633,
   38635,38800,38802,38804,38806,38827,38829,38831,38876,38878,
   38921,39151,39152,39153,39156,39157,39158,39160,39166,39167,
   39169,39171,39173,39193,39194,39197,39198,39199,39201,39207,
   39208,39210,39212,39214,39234,39237,39238,39239,39241,39247,
   39248,39250,39252,39254,39276,39277,39278,39280,39286,39287,
   39289,39291,39293,39388,39389,39391,39397,39398,39400,39402,
   39404,39424,39426,39432,39433,39435,39437,39439,39460,39466,
   39467,39469,39471,39473,39531,39532,39534,39536,39538,39703,
   39705,39707,39709,39730,39732,39734,39779,39781,39824,40054,
   40055,40058,40059,40060,40062,40068,40069,40071,40073,40075,
   40095,40098,40099,40100,40102,40108,40109,40111,40113,40115,
   40137,40138,40139,40141,40147,40148,40150,40152,40154,40249,
   40250,40252,40258,40259,40261,40263,40265,40285,40287,40293,
   40294,40296,40298,40300,40321,40327,40328,40330,40332,40334,
   40392,40393,40395,40397,40399,40564,40566,40568,40570,40591,
   40593,40595,40640,40642,40685,40915,40918,40919,40920,40922,
   40928,40929,40931,40933,40935,40957,40958,40959,40961,40967,
   40968,40970,40972,40974,41069,41070,41072,41078,41079,41081,
   41083,41085,41105,41107,41113,41114,41116,41118,41120,41141,
   41147,41148,41150,41152,41154,41212,41213,41215,41217,41219,
   41384,41386,41388,41390,41411,41413,41415,41460,41462,41505,
   41737,41738,41739,41741,41747,41748,41750,41752,41754,41849,
   41850,41852,41858,41859,41861,41863,41865,41885,41887,41893,
   41894,41896,41898,41900,41921,41927,41928,41930,41932,41934,
   41992,41993,41995,41997,41999,42164,42166,42168,42170,42191,
   42193,42195,42240,42242,42285,42590,42591,42593,42599,42600,
   42602,42604,42606,42626,42628,42634,42635,42637,42639,42641,
   42662,42668,42669,42671,42673,42675,42733,42734,42736,42738,
   42740,42905,42907,42909,42911,42932,42934,42936,42981,42983,
   43026,44625,44627,44633,44634,44636,44638,44640,44661,44667,
   44668,44670,44672,44674,44732,44733,44735,44737,44739,44904,
   44906,44908,44910,44931,44933,44935,44980,44982,45025,45256,
   45262,45263,45265,45267,45269,45327,45328,45330,45332,45334,
   45499,45501,45503,45505,45526,45528,45530,45575,45577,45620,
   45888,45889,45891,45893,45895,46060,46062,46064,46066,46087,
   46089,46091,46136,46138,46181,47084,47086,47088,47090,47111,
   47113,47115,47160,47162,47205,49471,49473,49475,49520,49522,
   49565,49820,49822,49865,50394],
 [23,31,44,1296,1309,1314,1315,1625,1630,1631,2007,2008,2108,
   3507,3520,3525,3526,3836,3841,3842,4218,4219,4319,38497,
   38502,38503,38879,38880,38980,44983,44984,45084,50453],
 [23,31,44,1296,1309,1314,1315,1625,1630,1631,2007,2008,2108,
   3507,3520,3525,3526,3836,3841,3842,4218,4219,4319,38497,
   38502,38503,38879,38880,38980,44983,44984,45084,50453],
 [23,31,44,1296,1309,1316,1317,1625,1632,1633,2009,2010,2143,
   3507,3520,3527,3528,3836,3843,3844,4220,4221,4354,38497,
   38504,38505,38881,38882,39015,44985,44986,45119,50488],
 [23,31,44,1296,1309,1316,1317,1625,1632,1633,2009,2010,2143,
   3507,3520,3527,3528,3836,3843,3844,4220,4221,4354,38497,
   38504,38505,38881,38882,39015,44985,44986,45119,50488],
 [2033,4244],[1887,4098],[1915,4126],[2215,4426],
 [2224,4435],[2224,4435],[2215,4426],[2254,4465],
 [2262,4473],[2268,4479],[2270,4481],[2254,4465],
 [2270,4481],[2262,4473],[2268,4479],[2279],
 [90,94,107,202,236,482,1336,1349,1511,4575,4592,4821,4838,
   5692,5705,5867,8934,9788,9801,9963,17232,17245,17407,39286],
 [268,4624],
 [69,70,73,76,89,90,91,92,93,94,107,199,200,202,203,205,
   218,219,220,221,222,223,236,263,265,266,268,281,282,283,
   284,285,286,299,327,328,330,343,344,345,346,347,348,361,
   449,451,464,465,466,467,468,469,482,510,523,524,525,526,
   527,528,541,638,639,640,641,642,643,656,1289,1290,1291,
   1292,1293,1306,1333,1334,1335,1336,1349,1376,1377,1378,1391,
   1418,1419,1432,1459,1472,1511,4555,4556,4558,4559,4561,4574,
   4575,4576,4577,4578,4579,4592,4619,4621,4622,4624,4637,4638,
   4639,4640,4641,4642,4655,4683,4686,4699,4700,4701,4702,4703,
   4704,4717,4805,4807,4820,4821,4822,4823,4824,4825,4838,4866,
   4879,4880,4881,4882,4883,4884,4897,4994,4995,4996,4997,4998,
   4999,5012,5645,5646,5647,5648,5649,5662,5689,5690,5691,5692,
   5705,5732,5733,5734,5747,5774,5775,5788,5815,5828,5867,8715,
   8717,8718,8720,8733,8734,8735,8736,8737,8738,8751,8779,8780,
   8782,8795,8796,8797,8798,8799,8800,8813,8901,8903,8916,8917,
   8918,8919,8920,8921,8934,8962,8975,8976,8977,8978,8979,8980,
   8993,9090,9091,9092,9093,9094,9095,9108,9741,9742,9743,9744,
   9745,9758,9785,9786,9787,9788,9801,9828,9829,9830,9843,9870,
   9871,9884,9911,9924,9963,10732,10733,10735,10748,10749,10750,
   10751,10752,10753,10766,10854,10856,10869,10870,10871,10872,
   10873,10874,10887,10915,10928,10929,10930,10931,10932,10933,
   10946,11043,11044,11045,11046,11047,11048,11061,11694,11695,
   11696,11697,11698,11711,11738,11739,11740,11741,11754,11781,
   11782,11783,11796,11823,11824,11837,11864,11877,11916,12745,
   12747,12760,12761,12762,12763,12764,12765,12778,12806,12819,
   12820,12821,12822,12823,12824,12837,12934,12935,12936,12937,
   12938,12939,12952,13585,13586,13587,13588,13589,13602,13629,
   13630,13631,13632,13645,13672,13673,13674,13687,13714,13715,
   13728,13755,13768,13807,16406,16419,16420,16421,16422,16423,
   16424,16437,16534,16535,16536,16537,16538,16539,16552,17185,
   17186,17187,17188,17189,17202,17229,17230,17231,17232,17245,
   17272,17273,17274,17287,17314,17315,17328,17355,17368,17407,
   18245,18246,18247,18248,18249,18250,18263,18896,18897,18898,
   18899,18900,18913,18940,18941,18942,18943,18956,18983,18984,
   18985,18998,19025,19026,19039,19066,19079,19118,22145,22146,
   22147,22148,22149,22162,22189,22190,22191,22192,22205,22232,
   22233,22234,22247,22274,22275,22288,22315,22328,22367,38205,
   38206,38207,38208,38221,38248,38249,38250,38263,38290,38291,
   38304,38331,38344,38383,39151,39152,39153,39166,39193,39194,
   39207,39234,39247,39286,40054,40055,40068,40095,40108,40147,
   40915,40928,40967,41747],[393,4749],
 [90,94,107,202,236,482,1336,1349,1511,4575,4592,4821,4838,
   5692,5705,5867,8934,9788,9801,9963,17232,17245,17407,39286],
 [69,70,73,76,89,90,91,92,93,94,107,199,200,202,203,205,
   218,219,220,221,222,223,236,263,265,266,268,281,282,283,
   284,285,286,299,327,328,330,343,344,345,346,347,348,361,
   449,451,464,465,466,467,468,469,482,510,523,524,525,526,
   527,528,541,638,639,640,641,642,643,656,1289,1290,1291,
   1292,1293,1306,1333,1334,1335,1336,1349,1376,1377,1378,1391,
   1418,1419,1432,1459,1472,1511,4555,4556,4558,4559,4561,4574,
   4575,4576,4577,4578,4579,4592,4619,4621,4622,4624,4637,4638,
   4639,4640,4641,4642,4655,4683,4686,4699,4700,4701,4702,4703,
   4704,4717,4805,4807,4820,4821,4822,4823,4824,4825,4838,4866,
   4879,4880,4881,4882,4883,4884,4897,4994,4995,4996,4997,4998,
   4999,5012,5645,5646,5647,5648,5649,5662,5689,5690,5691,5692,
   5705,5732,5733,5734,5747,5774,5775,5788,5815,5828,5867,8715,
   8717,8718,8720,8733,8734,8735,8736,8737,8738,8751,8779,8780,
   8782,8795,8796,8797,8798,8799,8800,8813,8901,8903,8916,8917,
   8918,8919,8920,8921,8934,8962,8975,8976,8977,8978,8979,8980,
   8993,9090,9091,9092,9093,9094,9095,9108,9741,9742,9743,9744,
   9745,9758,9785,9786,9787,9788,9801,9828,9829,9830,9843,9870,
   9871,9884,9911,9924,9963,10732,10733,10735,10748,10749,10750,
   10751,10752,10753,10766,10854,10856,10869,10870,10871,10872,
   10873,10874,10887,10915,10928,10929,10930,10931,10932,10933,
   10946,11043,11044,11045,11046,11047,11048,11061,11694,11695,
   11696,11697,11698,11711,11738,11739,11740,11741,11754,11781,
   11782,11783,11796,11823,11824,11837,11864,11877,11916,12745,
   12747,12760,12761,12762,12763,12764,12765,12778,12806,12819,
   12820,12821,12822,12823,12824,12837,12934,12935,12936,12937,
   12938,12939,12952,13585,13586,13587,13588,13589,13602,13629,
   13630,13631,13632,13645,13672,13673,13674,13687,13714,13715,
   13728,13755,13768,13807,16406,16419,16420,16421,16422,16423,
   16424,16437,16534,16535,16536,16537,16538,16539,16552,17185,
   17186,17187,17188,17189,17202,17229,17230,17231,17232,17245,
   17272,17273,17274,17287,17314,17315,17328,17355,17368,17407,
   18245,18246,18247,18248,18249,18250,18263,18896,18897,18898,
   18899,18900,18913,18940,18941,18942,18943,18956,18983,18984,
   18985,18998,19025,19026,19039,19066,19079,19118,22145,22146,
   22147,22148,22149,22162,22189,22190,22191,22192,22205,22232,
   22233,22234,22247,22274,22275,22288,22315,22328,22367,38205,
   38206,38207,38208,38221,38248,38249,38250,38263,38290,38291,
   38304,38331,38344,38383,39151,39152,39153,39166,39193,39194,
   39207,39234,39247,39286,40054,40055,40068,40095,40108,40147,
   40915,40928,40967,41747],[569,4925],[268,4624],
 [569,4925],[393,4749],[],[],[],[],[],[],[],
 [],[],[],
 [90,94,107,1291,1306,1336,1349,1377,1391,1432,1472,1511,5645,
   5646,5662,5689,5690,5691,5692,5705,5747,5774,5788,5828,5867,
   38205,38206,38207,38208,38221,38248,38249,38250,38263,38290,
   38291,38304,38331,38344,38383,39151,39152,39153,39166,39193,
   39194,39207,39234,39247,39286,40054,40055,40068,40095,40108,
   40147,40915,40928,40967,41747],[1336,5692,5705,5867,39286],
 [90,94,107,1291,1306,1336,1349,1377,1391,1432,1472,1511,5645,
   5646,5662,5689,5690,5691,5692,5705,5747,5774,5788,5828,5867,
   38205,38206,38207,38208,38221,38248,38249,38250,38263,38290,
   38291,38304,38331,38344,38383,39151,39152,39153,39166,39193,
   39194,39207,39234,39247,39286,40054,40055,40068,40095,40108,
   40147,40915,40928,40967,41747],
 [90,94,107,1291,1306,1336,1349,1377,1391,1432,1472,1511,5645,
   5646,5662,5689,5690,5691,5692,5705,5747,5774,5788,5828,5867,
   38205,38206,38207,38208,38221,38248,38249,38250,38263,38290,
   38291,38304,38331,38344,38383,39151,39152,39153,39166,39193,
   39194,39207,39234,39247,39286,40054,40055,40068,40095,40108,
   40147,40915,40928,40967,41747],
 [90,94,107,1291,1306,1336,1349,1377,1391,1432,1472,1511,5645,
   5646,5662,5689,5690,5691,5692,5705,5747,5774,5788,5828,5867,
   38205,38206,38207,38208,38221,38248,38249,38250,38263,38290,
   38291,38304,38331,38344,38383,39151,39152,39153,39166,39193,
   39194,39207,39234,39247,39286,40054,40055,40068,40095,40108,
   40147,40915,40928,40967,41747],[1336,5692,5705,5867,39286],
 [90,94,107,1336,1337,1338,1349,1499,1500,1511,1538,1549,1586,
   5692,5693,5694,5705,5855,5856,5867,5894,5905,5942,39274,
   39275,39286,39313,39324,39361,42515,42526,42563,43266],
 [90,94,107,1336,1337,1338,1349,1499,1500,1511,1538,1549,1586,
   5692,5693,5694,5705,5855,5856,5867,5894,5905,5942,39274,
   39275,39286,39313,39324,39361,42515,42526,42563,43266],
 [1,2,23,26,31,32,41,42,44,68,89,90,91,92,93,94,107,156,
   157,158,163,164,166,173,177,179,1289,1290,1291,1292,1293,
   1296,1297,1298,1300,1306,1307,1309,1311,1313,1333,1334,1335,
   1336,1339,1340,1341,1343,1349,1350,1352,1354,1356,1376,1377,
   1378,1381,1382,1383,1385,1391,1392,1394,1396,1398,1418,1419,
   1422,1423,1424,1426,1432,1433,1435,1437,1439,1459,1462,1463,
   1464,1466,1472,1473,1475,1477,1479,1501,1502,1503,1505,1511,
   1512,1514,1516,1518,1613,1614,1616,1622,1623,1625,1627,1629,
   1649,1651,1657,1658,1660,1662,1664,1685,1691,1692,1694,1696,
   1698,1756,1757,1759,1761,1763,1928,1930,1932,1934,1955,1957,
   1959,2004,2006,2049,2279,2300,2301,2302,2305,2308,2310,2318,
   2319,2321,2365,2366,2367,2370,2373,2375,2383,2384,2386,3500,
   3501,3502,3503,3504,3507,3508,3509,3511,3517,3518,3520,3522,
   3524,3544,3545,3546,3547,3550,3551,3552,3554,3560,3561,3563,
   3565,3567,3587,3588,3589,3592,3593,3594,3596,3602,3603,3605,
   3607,3609,3629,3630,3633,3634,3635,3637,3643,3644,3646,3648,
   3650,3670,3673,3674,3675,3677,3683,3684,3686,3688,3690,3712,
   3713,3714,3716,3722,3723,3725,3727,3729,3824,3825,3827,3833,
   3834,3836,3838,3840,3860,3862,3868,3869,3871,3873,3875,3896,
   3902,3903,3905,3907,3909,3967,3968,3970,3972,3974,4139,4141,
   4143,4145,4166,4168,4170,4215,4217,4260,4510,4511,4512,4515,
   4518,4520,4528,4529,4531,5645,5646,5647,5648,5649,5652,5653,
   5654,5656,5662,5663,5665,5667,5669,5689,5690,5691,5692,5695,
   5696,5697,5699,5705,5706,5708,5710,5712,5732,5733,5734,5737,
   5738,5739,5741,5747,5748,5750,5752,5754,5774,5775,5778,5779,
   5780,5782,5788,5789,5791,5793,5795,5815,5818,5819,5820,5822,
   5828,5829,5831,5833,5835,5857,5858,5859,5861,5867,5868,5870,
   5872,5874,5969,5970,5972,5978,5979,5981,5983,5985,6005,6007,
   6013,6014,6016,6018,6020,6041,6047,6048,6050,6052,6054,6112,
   6113,6115,6117,6119,6284,6286,6288,6290,6311,6313,6315,6360,
   6362,6405,7725,7726,7727,7728,7729,7732,7733,7734,7736,7742,
   7743,7745,7747,7749,7769,7770,7771,7772,7775,7776,7777,7779,
   7785,7786,7788,7790,7792,7812,7813,7814,7817,7818,7819,7821,
   7827,7828,7830,7832,7834,7854,7855,7858,7859,7860,7862,7868,
   7869,7871,7873,7875,7895,7898,7899,7900,7902,7908,7909,7911,
   7913,7915,7937,7938,7939,7941,7947,7948,7950,7952,7954,8049,
   8050,8052,8058,8059,8061,8063,8065,8085,8087,8093,8094,8096,
   8098,8100,8121,8127,8128,8130,8132,8134,8192,8193,8195,8197,
   8199,8364,8366,8368,8370,8391,8393,8395,8440,8442,8485,
   38205,38206,38207,38208,38211,38212,38213,38215,38221,38222,
   38224,38226,38228,38248,38249,38250,38253,38254,38255,38257,
   38263,38264,38266,38268,38270,38290,38291,38294,38295,38296,
   38298,38304,38305,38307,38309,38311,38331,38334,38335,38336,
   38338,38344,38345,38347,38349,38351,38373,38374,38375,38377,
   38383,38384,38386,38388,38390,38485,38486,38488,38494,38495,
   38497,38499,38501,38521,38523,38529,38530,38532,38534,38536,
   38557,38563,38564,38566,38568,38570,38628,38629,38631,38633,
   38635,38800,38802,38804,38806,38827,38829,38831,38876,38878,
   38921,39151,39152,39153,39156,39157,39158,39160,39166,39167,
   39169,39171,39173,39193,39194,39197,39198,39199,39201,39207,
   39208,39210,39212,39214,39234,39237,39238,39239,39241,39247,
   39248,39250,39252,39254,39276,39277,39278,39280,39286,39287,
   39289,39291,39293,39388,39389,39391,39397,39398,39400,39402,
   39404,39424,39426,39432,39433,39435,39437,39439,39460,39466,
   39467,39469,39471,39473,39531,39532,39534,39536,39538,39703,
   39705,39707,39709,39730,39732,39734,39779,39781,39824,40054,
   40055,40058,40059,40060,40062,40068,40069,40071,40073,40075,
   40095,40098,40099,40100,40102,40108,40109,40111,40113,40115,
   40137,40138,40139,40141,40147,40148,40150,40152,40154,40249,
   40250,40252,40258,40259,40261,40263,40265,40285,40287,40293,
   40294,40296,40298,40300,40321,40327,40328,40330,40332,40334,
   40392,40393,40395,40397,40399,40564,40566,40568,40570,40591,
   40593,40595,40640,40642,40685,40915,40918,40919,40920,40922,
   40928,40929,40931,40933,40935,40957,40958,40959,40961,40967,
   40968,40970,40972,40974,41069,41070,41072,41078,41079,41081,
   41083,41085,41105,41107,41113,41114,41116,41118,41120,41141,
   41147,41148,41150,41152,41154,41212,41213,41215,41217,41219,
   41384,41386,41388,41390,41411,41413,41415,41460,41462,41505,
   41737,41738,41739,41741,41747,41748,41750,41752,41754,41849,
   41850,41852,41858,41859,41861,41863,41865,41885,41887,41893,
   41894,41896,41898,41900,41921,41927,41928,41930,41932,41934,
   41992,41993,41995,41997,41999,42164,42166,42168,42170,42191,
   42193,42195,42240,42242,42285,42590,42591,42593,42599,42600,
   42602,42604,42606,42626,42628,42634,42635,42637,42639,42641,
   42662,42668,42669,42671,42673,42675,42733,42734,42736,42738,
   42740,42905,42907,42909,42911,42932,42934,42936,42981,42983,
   43026,44625,44627,44633,44634,44636,44638,44640,44661,44667,
   44668,44670,44672,44674,44732,44733,44735,44737,44739,44904,
   44906,44908,44910,44931,44933,44935,44980,44982,45025,45256,
   45262,45263,45265,45267,45269,45327,45328,45330,45332,45334,
   45499,45501,45503,45505,45526,45528,45530,45575,45577,45620,
   45888,45889,45891,45893,45895,46060,46062,46064,46066,46087,
   46089,46091,46136,46138,46181,47084,47086,47088,47090,47111,
   47113,47115,47160,47162,47205,49471,49473,49475,49520,49522,
   49565,49820,49822,49865,50394],
 [1,2,23,26,31,32,41,42,44,68,89,90,91,92,93,94,107,156,
   157,158,163,164,166,173,177,179,1289,1290,1291,1292,1293,
   1296,1297,1298,1300,1306,1307,1309,1311,1313,1333,1334,1335,
   1336,1339,1340,1341,1343,1349,1350,1352,1354,1356,1376,1377,
   1378,1381,1382,1383,1385,1391,1392,1394,1396,1398,1418,1419,
   1422,1423,1424,1426,1432,1433,1435,1437,1439,1459,1462,1463,
   1464,1466,1472,1473,1475,1477,1479,1501,1502,1503,1505,1511,
   1512,1514,1516,1518,1613,1614,1616,1622,1623,1625,1627,1629,
   1649,1651,1657,1658,1660,1662,1664,1685,1691,1692,1694,1696,
   1698,1756,1757,1759,1761,1763,1928,1930,1932,1934,1955,1957,
   1959,2004,2006,2049,2279,2300,2301,2302,2305,2308,2310,2318,
   2319,2321,2365,2366,2367,2370,2373,2375,2383,2384,2386,3500,
   3501,3502,3503,3504,3507,3508,3509,3511,3517,3518,3520,3522,
   3524,3544,3545,3546,3547,3550,3551,3552,3554,3560,3561,3563,
   3565,3567,3587,3588,3589,3592,3593,3594,3596,3602,3603,3605,
   3607,3609,3629,3630,3633,3634,3635,3637,3643,3644,3646,3648,
   3650,3670,3673,3674,3675,3677,3683,3684,3686,3688,3690,3712,
   3713,3714,3716,3722,3723,3725,3727,3729,3824,3825,3827,3833,
   3834,3836,3838,3840,3860,3862,3868,3869,3871,3873,3875,3896,
   3902,3903,3905,3907,3909,3967,3968,3970,3972,3974,4139,4141,
   4143,4145,4166,4168,4170,4215,4217,4260,4510,4511,4512,4515,
   4518,4520,4528,4529,4531,5645,5646,5647,5648,5649,5652,5653,
   5654,5656,5662,5663,5665,5667,5669,5689,5690,5691,5692,5695,
   5696,5697,5699,5705,5706,5708,5710,5712,5732,5733,5734,5737,
   5738,5739,5741,5747,5748,5750,5752,5754,5774,5775,5778,5779,
   5780,5782,5788,5789,5791,5793,5795,5815,5818,5819,5820,5822,
   5828,5829,5831,5833,5835,5857,5858,5859,5861,5867,5868,5870,
   5872,5874,5969,5970,5972,5978,5979,5981,5983,5985,6005,6007,
   6013,6014,6016,6018,6020,6041,6047,6048,6050,6052,6054,6112,
   6113,6115,6117,6119,6284,6286,6288,6290,6311,6313,6315,6360,
   6362,6405,7725,7726,7727,7728,7729,7732,7733,7734,7736,7742,
   7743,7745,7747,7749,7769,7770,7771,7772,7775,7776,7777,7779,
   7785,7786,7788,7790,7792,7812,7813,7814,7817,7818,7819,7821,
   7827,7828,7830,7832,7834,7854,7855,7858,7859,7860,7862,7868,
   7869,7871,7873,7875,7895,7898,7899,7900,7902,7908,7909,7911,
   7913,7915,7937,7938,7939,7941,7947,7948,7950,7952,7954,8049,
   8050,8052,8058,8059,8061,8063,8065,8085,8087,8093,8094,8096,
   8098,8100,8121,8127,8128,8130,8132,8134,8192,8193,8195,8197,
   8199,8364,8366,8368,8370,8391,8393,8395,8440,8442,8485,
   38205,38206,38207,38208,38211,38212,38213,38215,38221,38222,
   38224,38226,38228,38248,38249,38250,38253,38254,38255,38257,
   38263,38264,38266,38268,38270,38290,38291,38294,38295,38296,
   38298,38304,38305,38307,38309,38311,38331,38334,38335,38336,
   38338,38344,38345,38347,38349,38351,38373,38374,38375,38377,
   38383,38384,38386,38388,38390,38485,38486,38488,38494,38495,
   38497,38499,38501,38521,38523,38529,38530,38532,38534,38536,
   38557,38563,38564,38566,38568,38570,38628,38629,38631,38633,
   38635,38800,38802,38804,38806,38827,38829,38831,38876,38878,
   38921,39151,39152,39153,39156,39157,39158,39160,39166,39167,
   39169,39171,39173,39193,39194,39197,39198,39199,39201,39207,
   39208,39210,39212,39214,39234,39237,39238,39239,39241,39247,
   39248,39250,39252,39254,39276,39277,39278,39280,39286,39287,
   39289,39291,39293,39388,39389,39391,39397,39398,39400,39402,
   39404,39424,39426,39432,39433,39435,39437,39439,39460,39466,
   39467,39469,39471,39473,39531,39532,39534,39536,39538,39703,
   39705,39707,39709,39730,39732,39734,39779,39781,39824,40054,
   40055,40058,40059,40060,40062,40068,40069,40071,40073,40075,
   40095,40098,40099,40100,40102,40108,40109,40111,40113,40115,
   40137,40138,40139,40141,40147,40148,40150,40152,40154,40249,
   40250,40252,40258,40259,40261,40263,40265,40285,40287,40293,
   40294,40296,40298,40300,40321,40327,40328,40330,40332,40334,
   40392,40393,40395,40397,40399,40564,40566,40568,40570,40591,
   40593,40595,40640,40642,40685,40915,40918,40919,40920,40922,
   40928,40929,40931,40933,40935,40957,40958,40959,40961,40967,
   40968,40970,40972,40974,41069,41070,41072,41078,41079,41081,
   41083,41085,41105,41107,41113,41114,41116,41118,41120,41141,
   41147,41148,41150,41152,41154,41212,41213,41215,41217,41219,
   41384,41386,41388,41390,41411,41413,41415,41460,41462,41505,
   41737,41738,41739,41741,41747,41748,41750,41752,41754,41849,
   41850,41852,41858,41859,41861,41863,41865,41885,41887,41893,
   41894,41896,41898,41900,41921,41927,41928,41930,41932,41934,
   41992,41993,41995,41997,41999,42164,42166,42168,42170,42191,
   42193,42195,42240,42242,42285,42590,42591,42593,42599,42600,
   42602,42604,42606,42626,42628,42634,42635,42637,42639,42641,
   42662,42668,42669,42671,42673,42675,42733,42734,42736,42738,
   42740,42905,42907,42909,42911,42932,42934,42936,42981,42983,
   43026,44625,44627,44633,44634,44636,44638,44640,44661,44667,
   44668,44670,44672,44674,44732,44733,44735,44737,44739,44904,
   44906,44908,44910,44931,44933,44935,44980,44982,45025,45256,
   45262,45263,45265,45267,45269,45327,45328,45330,45332,45334,
   45499,45501,45503,45505,45526,45528,45530,45575,45577,45620,
   45888,45889,45891,45893,45895,46060,46062,46064,46066,46087,
   46089,46091,46136,46138,46181,47084,47086,47088,47090,47111,
   47113,47115,47160,47162,47205,49471,49473,49475,49520,49522,
   49565,49820,49822,49865,50394],
 [1,2,23,26,31,32,41,42,44,68,89,90,91,92,93,94,107,156,
   157,158,163,164,166,173,177,179,1289,1290,1291,1292,1293,
   1296,1297,1298,1300,1306,1307,1309,1311,1313,1333,1334,1335,
   1336,1339,1340,1341,1343,1349,1350,1352,1354,1356,1376,1377,
   1378,1381,1382,1383,1385,1391,1392,1394,1396,1398,1418,1419,
   1422,1423,1424,1426,1432,1433,1435,1437,1439,1459,1462,1463,
   1464,1466,1472,1473,1475,1477,1479,1501,1502,1503,1505,1511,
   1512,1514,1516,1518,1613,1614,1616,1622,1623,1625,1627,1629,
   1649,1651,1657,1658,1660,1662,1664,1685,1691,1692,1694,1696,
   1698,1756,1757,1759,1761,1763,1928,1930,1932,1934,1955,1957,
   1959,2004,2006,2049,2279,2300,2301,2302,2305,2308,2310,2318,
   2319,2321,2365,2366,2367,2370,2373,2375,2383,2384,2386,3500,
   3501,3502,3503,3504,3507,3508,3509,3511,3517,3518,3520,3522,
   3524,3544,3545,3546,3547,3550,3551,3552,3554,3560,3561,3563,
   3565,3567,3587,3588,3589,3592,3593,3594,3596,3602,3603,3605,
   3607,3609,3629,3630,3633,3634,3635,3637,3643,3644,3646,3648,
   3650,3670,3673,3674,3675,3677,3683,3684,3686,3688,3690,3712,
   3713,3714,3716,3722,3723,3725,3727,3729,3824,3825,3827,3833,
   3834,3836,3838,3840,3860,3862,3868,3869,3871,3873,3875,3896,
   3902,3903,3905,3907,3909,3967,3968,3970,3972,3974,4139,4141,
   4143,4145,4166,4168,4170,4215,4217,4260,4510,4511,4512,4515,
   4518,4520,4528,4529,4531,5645,5646,5647,5648,5649,5652,5653,
   5654,5656,5662,5663,5665,5667,5669,5689,5690,5691,5692,5695,
   5696,5697,5699,5705,5706,5708,5710,5712,5732,5733,5734,5737,
   5738,5739,5741,5747,5748,5750,5752,5754,5774,5775,5778,5779,
   5780,5782,5788,5789,5791,5793,5795,5815,5818,5819,5820,5822,
   5828,5829,5831,5833,5835,5857,5858,5859,5861,5867,5868,5870,
   5872,5874,5969,5970,5972,5978,5979,5981,5983,5985,6005,6007,
   6013,6014,6016,6018,6020,6041,6047,6048,6050,6052,6054,6112,
   6113,6115,6117,6119,6284,6286,6288,6290,6311,6313,6315,6360,
   6362,6405,7725,7726,7727,7728,7729,7732,7733,7734,7736,7742,
   7743,7745,7747,7749,7769,7770,7771,7772,7775,7776,7777,7779,
   7785,7786,7788,7790,7792,7812,7813,7814,7817,7818,7819,7821,
   7827,7828,7830,7832,7834,7854,7855,7858,7859,7860,7862,7868,
   7869,7871,7873,7875,7895,7898,7899,7900,7902,7908,7909,7911,
   7913,7915,7937,7938,7939,7941,7947,7948,7950,7952,7954,8049,
   8050,8052,8058,8059,8061,8063,8065,8085,8087,8093,8094,8096,
   8098,8100,8121,8127,8128,8130,8132,8134,8192,8193,8195,8197,
   8199,8364,8366,8368,8370,8391,8393,8395,8440,8442,8485,
   38205,38206,38207,38208,38211,38212,38213,38215,38221,38222,
   38224,38226,38228,38248,38249,38250,38253,38254,38255,38257,
   38263,38264,38266,38268,38270,38290,38291,38294,38295,38296,
   38298,38304,38305,38307,38309,38311,38331,38334,38335,38336,
   38338,38344,38345,38347,38349,38351,38373,38374,38375,38377,
   38383,38384,38386,38388,38390,38485,38486,38488,38494,38495,
   38497,38499,38501,38521,38523,38529,38530,38532,38534,38536,
   38557,38563,38564,38566,38568,38570,38628,38629,38631,38633,
   38635,38800,38802,38804,38806,38827,38829,38831,38876,38878,
   38921,39151,39152,39153,39156,39157,39158,39160,39166,39167,
   39169,39171,39173,39193,39194,39197,39198,39199,39201,39207,
   39208,39210,39212,39214,39234,39237,39238,39239,39241,39247,
   39248,39250,39252,39254,39276,39277,39278,39280,39286,39287,
   39289,39291,39293,39388,39389,39391,39397,39398,39400,39402,
   39404,39424,39426,39432,39433,39435,39437,39439,39460,39466,
   39467,39469,39471,39473,39531,39532,39534,39536,39538,39703,
   39705,39707,39709,39730,39732,39734,39779,39781,39824,40054,
   40055,40058,40059,40060,40062,40068,40069,40071,40073,40075,
   40095,40098,40099,40100,40102,40108,40109,40111,40113,40115,
   40137,40138,40139,40141,40147,40148,40150,40152,40154,40249,
   40250,40252,40258,40259,40261,40263,40265,40285,40287,40293,
   40294,40296,40298,40300,40321,40327,40328,40330,40332,40334,
   40392,40393,40395,40397,40399,40564,40566,40568,40570,40591,
   40593,40595,40640,40642,40685,40915,40918,40919,40920,40922,
   40928,40929,40931,40933,40935,40957,40958,40959,40961,40967,
   40968,40970,40972,40974,41069,41070,41072,41078,41079,41081,
   41083,41085,41105,41107,41113,41114,41116,41118,41120,41141,
   41147,41148,41150,41152,41154,41212,41213,41215,41217,41219,
   41384,41386,41388,41390,41411,41413,41415,41460,41462,41505,
   41737,41738,41739,41741,41747,41748,41750,41752,41754,41849,
   41850,41852,41858,41859,41861,41863,41865,41885,41887,41893,
   41894,41896,41898,41900,41921,41927,41928,41930,41932,41934,
   41992,41993,41995,41997,41999,42164,42166,42168,42170,42191,
   42193,42195,42240,42242,42285,42590,42591,42593,42599,42600,
   42602,42604,42606,42626,42628,42634,42635,42637,42639,42641,
   42662,42668,42669,42671,42673,42675,42733,42734,42736,42738,
   42740,42905,42907,42909,42911,42932,42934,42936,42981,42983,
   43026,44625,44627,44633,44634,44636,44638,44640,44661,44667,
   44668,44670,44672,44674,44732,44733,44735,44737,44739,44904,
   44906,44908,44910,44931,44933,44935,44980,44982,45025,45256,
   45262,45263,45265,45267,45269,45327,45328,45330,45332,45334,
   45499,45501,45503,45505,45526,45528,45530,45575,45577,45620,
   45888,45889,45891,45893,45895,46060,46062,46064,46066,46087,
   46089,46091,46136,46138,46181,47084,47086,47088,47090,47111,
   47113,47115,47160,47162,47205,49471,49473,49475,49520,49522,
   49565,49820,49822,49865,50394],
 [90,94,107,1336,1342,1349,1355,1504,1511,1517,1724,1730,1933,
   5692,5698,5705,5711,5860,5867,5873,6080,6086,6289,39279,
   39286,39292,39499,39505,39708,42701,42707,42910,46593],
 [1,2,23,26,31,32,41,42,44,68,89,90,91,92,93,94,107,156,
   157,158,163,164,166,173,177,179,1289,1290,1291,1292,1293,
   1296,1297,1298,1300,1306,1307,1309,1311,1313,1333,1334,1335,
   1336,1339,1340,1341,1343,1349,1350,1352,1354,1356,1376,1377,
   1378,1381,1382,1383,1385,1391,1392,1394,1396,1398,1418,1419,
   1422,1423,1424,1426,1432,1433,1435,1437,1439,1459,1462,1463,
   1464,1466,1472,1473,1475,1477,1479,1501,1502,1503,1505,1511,
   1512,1514,1516,1518,1613,1614,1616,1622,1623,1625,1627,1629,
   1649,1651,1657,1658,1660,1662,1664,1685,1691,1692,1694,1696,
   1698,1756,1757,1759,1761,1763,1928,1930,1932,1934,1955,1957,
   1959,2004,2006,2049,2279,2300,2301,2302,2305,2308,2310,2318,
   2319,2321,2365,2366,2367,2370,2373,2375,2383,2384,2386,3500,
   3501,3502,3503,3504,3507,3508,3509,3511,3517,3518,3520,3522,
   3524,3544,3545,3546,3547,3550,3551,3552,3554,3560,3561,3563,
   3565,3567,3587,3588,3589,3592,3593,3594,3596,3602,3603,3605,
   3607,3609,3629,3630,3633,3634,3635,3637,3643,3644,3646,3648,
   3650,3670,3673,3674,3675,3677,3683,3684,3686,3688,3690,3712,
   3713,3714,3716,3722,3723,3725,3727,3729,3824,3825,3827,3833,
   3834,3836,3838,3840,3860,3862,3868,3869,3871,3873,3875,3896,
   3902,3903,3905,3907,3909,3967,3968,3970,3972,3974,4139,4141,
   4143,4145,4166,4168,4170,4215,4217,4260,4510,4511,4512,4515,
   4518,4520,4528,4529,4531,5645,5646,5647,5648,5649,5652,5653,
   5654,5656,5662,5663,5665,5667,5669,5689,5690,5691,5692,5695,
   5696,5697,5699,5705,5706,5708,5710,5712,5732,5733,5734,5737,
   5738,5739,5741,5747,5748,5750,5752,5754,5774,5775,5778,5779,
   5780,5782,5788,5789,5791,5793,5795,5815,5818,5819,5820,5822,
   5828,5829,5831,5833,5835,5857,5858,5859,5861,5867,5868,5870,
   5872,5874,5969,5970,5972,5978,5979,5981,5983,5985,6005,6007,
   6013,6014,6016,6018,6020,6041,6047,6048,6050,6052,6054,6112,
   6113,6115,6117,6119,6284,6286,6288,6290,6311,6313,6315,6360,
   6362,6405,7725,7726,7727,7728,7729,7732,7733,7734,7736,7742,
   7743,7745,7747,7749,7769,7770,7771,7772,7775,7776,7777,7779,
   7785,7786,7788,7790,7792,7812,7813,7814,7817,7818,7819,7821,
   7827,7828,7830,7832,7834,7854,7855,7858,7859,7860,7862,7868,
   7869,7871,7873,7875,7895,7898,7899,7900,7902,7908,7909,7911,
   7913,7915,7937,7938,7939,7941,7947,7948,7950,7952,7954,8049,
   8050,8052,8058,8059,8061,8063,8065,8085,8087,8093,8094,8096,
   8098,8100,8121,8127,8128,8130,8132,8134,8192,8193,8195,8197,
   8199,8364,8366,8368,8370,8391,8393,8395,8440,8442,8485,
   38205,38206,38207,38208,38211,38212,38213,38215,38221,38222,
   38224,38226,38228,38248,38249,38250,38253,38254,38255,38257,
   38263,38264,38266,38268,38270,38290,38291,38294,38295,38296,
   38298,38304,38305,38307,38309,38311,38331,38334,38335,38336,
   38338,38344,38345,38347,38349,38351,38373,38374,38375,38377,
   38383,38384,38386,38388,38390,38485,38486,38488,38494,38495,
   38497,38499,38501,38521,38523,38529,38530,38532,38534,38536,
   38557,38563,38564,38566,38568,38570,38628,38629,38631,38633,
   38635,38800,38802,38804,38806,38827,38829,38831,38876,38878,
   38921,39151,39152,39153,39156,39157,39158,39160,39166,39167,
   39169,39171,39173,39193,39194,39197,39198,39199,39201,39207,
   39208,39210,39212,39214,39234,39237,39238,39239,39241,39247,
   39248,39250,39252,39254,39276,39277,39278,39280,39286,39287,
   39289,39291,39293,39388,39389,39391,39397,39398,39400,39402,
   39404,39424,39426,39432,39433,39435,39437,39439,39460,39466,
   39467,39469,39471,39473,39531,39532,39534,39536,39538,39703,
   39705,39707,39709,39730,39732,39734,39779,39781,39824,40054,
   40055,40058,40059,40060,40062,40068,40069,40071,40073,40075,
   40095,40098,40099,40100,40102,40108,40109,40111,40113,40115,
   40137,40138,40139,40141,40147,40148,40150,40152,40154,40249,
   40250,40252,40258,40259,40261,40263,40265,40285,40287,40293,
   40294,40296,40298,40300,40321,40327,40328,40330,40332,40334,
   40392,40393,40395,40397,40399,40564,40566,40568,40570,40591,
   40593,40595,40640,40642,40685,40915,40918,40919,40920,40922,
   40928,40929,40931,40933,40935,40957,40958,40959,40961,40967,
   40968,40970,40972,40974,41069,41070,41072,41078,41079,41081,
   41083,41085,41105,41107,41113,41114,41116,41118,41120,41141,
   41147,41148,41150,41152,41154,41212,41213,41215,41217,41219,
   41384,41386,41388,41390,41411,41413,41415,41460,41462,41505,
   41737,41738,41739,41741,41747,41748,41750,41752,41754,41849,
   41850,41852,41858,41859,41861,41863,41865,41885,41887,41893,
   41894,41896,41898,41900,41921,41927,41928,41930,41932,41934,
   41992,41993,41995,41997,41999,42164,42166,42168,42170,42191,
   42193,42195,42240,42242,42285,42590,42591,42593,42599,42600,
   42602,42604,42606,42626,42628,42634,42635,42637,42639,42641,
   42662,42668,42669,42671,42673,42675,42733,42734,42736,42738,
   42740,42905,42907,42909,42911,42932,42934,42936,42981,42983,
   43026,44625,44627,44633,44634,44636,44638,44640,44661,44667,
   44668,44670,44672,44674,44732,44733,44735,44737,44739,44904,
   44906,44908,44910,44931,44933,44935,44980,44982,45025,45256,
   45262,45263,45265,45267,45269,45327,45328,45330,45332,45334,
   45499,45501,45503,45505,45526,45528,45530,45575,45577,45620,
   45888,45889,45891,45893,45895,46060,46062,46064,46066,46087,
   46089,46091,46136,46138,46181,47084,47086,47088,47090,47111,
   47113,47115,47160,47162,47205,49471,49473,49475,49520,49522,
   49565,49820,49822,49865,50394],[6152],[1827,6183],
 [6213],[1887,6243],[1915,6271],[1336,5692,5705,5867,39286],
 [1,2,23,26,31,32,41,42,44,68,89,90,91,92,93,94,107,156,
   157,158,163,164,166,173,177,179,1289,1290,1291,1292,1293,
   1296,1297,1298,1300,1306,1307,1309,1311,1313,1333,1334,1335,
   1336,1339,1340,1341,1343,1349,1350,1352,1354,1356,1376,1377,
   1378,1381,1382,1383,1385,1391,1392,1394,1396,1398,1418,1419,
   1422,1423,1424,1426,1432,1433,1435,1437,1439,1459,1462,1463,
   1464,1466,1472,1473,1475,1477,1479,1501,1502,1503,1505,1511,
   1512,1514,1516,1518,1613,1614,1616,1622,1623,1625,1627,1629,
   1649,1651,1657,1658,1660,1662,1664,1685,1691,1692,1694,1696,
   1698,1756,1757,1759,1761,1763,1928,1930,1932,1934,1955,1957,
   1959,2004,2006,2049,2279,2300,2301,2302,2305,2308,2310,2318,
   2319,2321,2365,2366,2367,2370,2373,2375,2383,2384,2386,3500,
   3501,3502,3503,3504,3507,3508,3509,3511,3517,3518,3520,3522,
   3524,3544,3545,3546,3547,3550,3551,3552,3554,3560,3561,3563,
   3565,3567,3587,3588,3589,3592,3593,3594,3596,3602,3603,3605,
   3607,3609,3629,3630,3633,3634,3635,3637,3643,3644,3646,3648,
   3650,3670,3673,3674,3675,3677,3683,3684,3686,3688,3690,3712,
   3713,3714,3716,3722,3723,3725,3727,3729,3824,3825,3827,3833,
   3834,3836,3838,3840,3860,3862,3868,3869,3871,3873,3875,3896,
   3902,3903,3905,3907,3909,3967,3968,3970,3972,3974,4139,4141,
   4143,4145,4166,4168,4170,4215,4217,4260,4510,4511,4512,4515,
   4518,4520,4528,4529,4531,5645,5646,5647,5648,5649,5652,5653,
   5654,5656,5662,5663,5665,5667,5669,5689,5690,5691,5692,5695,
   5696,5697,5699,5705,5706,5708,5710,5712,5732,5733,5734,5737,
   5738,5739,5741,5747,5748,5750,5752,5754,5774,5775,5778,5779,
   5780,5782,5788,5789,5791,5793,5795,5815,5818,5819,5820,5822,
   5828,5829,5831,5833,5835,5857,5858,5859,5861,5867,5868,5870,
   5872,5874,5969,5970,5972,5978,5979,5981,5983,5985,6005,6007,
   6013,6014,6016,6018,6020,6041,6047,6048,6050,6052,6054,6112,
   6113,6115,6117,6119,6284,6286,6288,6290,6311,6313,6315,6360,
   6362,6405,7725,7726,7727,7728,7729,7732,7733,7734,7736,7742,
   7743,7745,7747,7749,7769,7770,7771,7772,7775,7776,7777,7779,
   7785,7786,7788,7790,7792,7812,7813,7814,7817,7818,7819,7821,
   7827,7828,7830,7832,7834,7854,7855,7858,7859,7860,7862,7868,
   7869,7871,7873,7875,7895,7898,7899,7900,7902,7908,7909,7911,
   7913,7915,7937,7938,7939,7941,7947,7948,7950,7952,7954,8049,
   8050,8052,8058,8059,8061,8063,8065,8085,8087,8093,8094,8096,
   8098,8100,8121,8127,8128,8130,8132,8134,8192,8193,8195,8197,
   8199,8364,8366,8368,8370,8391,8393,8395,8440,8442,8485,
   38205,38206,38207,38208,38211,38212,38213,38215,38221,38222,
   38224,38226,38228,38248,38249,38250,38253,38254,38255,38257,
   38263,38264,38266,38268,38270,38290,38291,38294,38295,38296,
   38298,38304,38305,38307,38309,38311,38331,38334,38335,38336,
   38338,38344,38345,38347,38349,38351,38373,38374,38375,38377,
   38383,38384,38386,38388,38390,38485,38486,38488,38494,38495,
   38497,38499,38501,38521,38523,38529,38530,38532,38534,38536,
   38557,38563,38564,38566,38568,38570,38628,38629,38631,38633,
   38635,38800,38802,38804,38806,38827,38829,38831,38876,38878,
   38921,39151,39152,39153,39156,39157,39158,39160,39166,39167,
   39169,39171,39173,39193,39194,39197,39198,39199,39201,39207,
   39208,39210,39212,39214,39234,39237,39238,39239,39241,39247,
   39248,39250,39252,39254,39276,39277,39278,39280,39286,39287,
   39289,39291,39293,39388,39389,39391,39397,39398,39400,39402,
   39404,39424,39426,39432,39433,39435,39437,39439,39460,39466,
   39467,39469,39471,39473,39531,39532,39534,39536,39538,39703,
   39705,39707,39709,39730,39732,39734,39779,39781,39824,40054,
   40055,40058,40059,40060,40062,40068,40069,40071,40073,40075,
   40095,40098,40099,40100,40102,40108,40109,40111,40113,40115,
   40137,40138,40139,40141,40147,40148,40150,40152,40154,40249,
   40250,40252,40258,40259,40261,40263,40265,40285,40287,40293,
   40294,40296,40298,40300,40321,40327,40328,40330,40332,40334,
   40392,40393,40395,40397,40399,40564,40566,40568,40570,40591,
   40593,40595,40640,40642,40685,40915,40918,40919,40920,40922,
   40928,40929,40931,40933,40935,40957,40958,40959,40961,40967,
   40968,40970,40972,40974,41069,41070,41072,41078,41079,41081,
   41083,41085,41105,41107,41113,41114,41116,41118,41120,41141,
   41147,41148,41150,41152,41154,41212,41213,41215,41217,41219,
   41384,41386,41388,41390,41411,41413,41415,41460,41462,41505,
   41737,41738,41739,41741,41747,41748,41750,41752,41754,41849,
   41850,41852,41858,41859,41861,41863,41865,41885,41887,41893,
   41894,41896,41898,41900,41921,41927,41928,41930,41932,41934,
   41992,41993,41995,41997,41999,42164,42166,42168,42170,42191,
   42193,42195,42240,42242,42285,42590,42591,42593,42599,42600,
   42602,42604,42606,42626,42628,42634,42635,42637,42639,42641,
   42662,42668,42669,42671,42673,42675,42733,42734,42736,42738,
   42740,42905,42907,42909,42911,42932,42934,42936,42981,42983,
   43026,44625,44627,44633,44634,44636,44638,44640,44661,44667,
   44668,44670,44672,44674,44732,44733,44735,44737,44739,44904,
   44906,44908,44910,44931,44933,44935,44980,44982,45025,45256,
   45262,45263,45265,45267,45269,45327,45328,45330,45332,45334,
   45499,45501,45503,45505,45526,45528,45530,45575,45577,45620,
   45888,45889,45891,45893,45895,46060,46062,46064,46066,46087,
   46089,46091,46136,46138,46181,47084,47086,47088,47090,47111,
   47113,47115,47160,47162,47205,49471,49473,49475,49520,49522,
   49565,49820,49822,49865,50394],
 [89,90,91,92,93,94,107,1289,1290,1291,1292,1293,1306,1308,
   1314,1333,1334,1335,1336,1349,1351,1357,1376,1377,1378,1391,
   1393,1399,1418,1419,1432,1434,1440,1459,1472,1474,1480,1511,
   1513,1519,1929,1935,1984,5645,5646,5647,5648,5649,5662,5664,
   5670,5689,5690,5691,5692,5705,5707,5713,5732,5733,5734,5747,
   5749,5755,5774,5775,5788,5790,5796,5815,5828,5830,5836,5867,
   5869,5875,6285,6291,6340,38205,38206,38207,38208,38221,38223,
   38229,38248,38249,38250,38263,38265,38271,38290,38291,38304,
   38306,38312,38331,38344,38346,38352,38383,38385,38391,38801,
   38807,38856,39151,39152,39153,39166,39168,39174,39193,39194,
   39207,39209,39215,39234,39247,39249,39255,39286,39288,39294,
   39704,39710,39759,40054,40055,40068,40070,40076,40095,40108,
   40110,40116,40147,40149,40155,40565,40571,40620,40915,40928,
   40930,40936,40967,40969,40975,41385,41391,41440,41747,41749,
   41755,42165,42171,42220,42906,42912,42961,49500],
 [1,2,23,26,31,32,41,42,44,68,89,90,91,92,93,94,107,156,
   157,158,163,164,166,173,177,179,1289,1290,1291,1292,1293,
   1296,1297,1298,1300,1306,1307,1309,1311,1313,1333,1334,1335,
   1336,1339,1340,1341,1343,1349,1350,1352,1354,1356,1376,1377,
   1378,1381,1382,1383,1385,1391,1392,1394,1396,1398,1418,1419,
   1422,1423,1424,1426,1432,1433,1435,1437,1439,1459,1462,1463,
   1464,1466,1472,1473,1475,1477,1479,1501,1502,1503,1505,1511,
   1512,1514,1516,1518,1613,1614,1616,1622,1623,1625,1627,1629,
   1649,1651,1657,1658,1660,1662,1664,1685,1691,1692,1694,1696,
   1698,1756,1757,1759,1761,1763,1928,1930,1932,1934,1955,1957,
   1959,2004,2006,2049,2279,2300,2301,2302,2305,2308,2310,2318,
   2319,2321,2365,2366,2367,2370,2373,2375,2383,2384,2386,3500,
   3501,3502,3503,3504,3507,3508,3509,3511,3517,3518,3520,3522,
   3524,3544,3545,3546,3547,3550,3551,3552,3554,3560,3561,3563,
   3565,3567,3587,3588,3589,3592,3593,3594,3596,3602,3603,3605,
   3607,3609,3629,3630,3633,3634,3635,3637,3643,3644,3646,3648,
   3650,3670,3673,3674,3675,3677,3683,3684,3686,3688,3690,3712,
   3713,3714,3716,3722,3723,3725,3727,3729,3824,3825,3827,3833,
   3834,3836,3838,3840,3860,3862,3868,3869,3871,3873,3875,3896,
   3902,3903,3905,3907,3909,3967,3968,3970,3972,3974,4139,4141,
   4143,4145,4166,4168,4170,4215,4217,4260,4510,4511,4512,4515,
   4518,4520,4528,4529,4531,5645,5646,5647,5648,5649,5652,5653,
   5654,5656,5662,5663,5665,5667,5669,5689,5690,5691,5692,5695,
   5696,5697,5699,5705,5706,5708,5710,5712,5732,5733,5734,5737,
   5738,5739,5741,5747,5748,5750,5752,5754,5774,5775,5778,5779,
   5780,5782,5788,5789,5791,5793,5795,5815,5818,5819,5820,5822,
   5828,5829,5831,5833,5835,5857,5858,5859,5861,5867,5868,5870,
   5872,5874,5969,5970,5972,5978,5979,5981,5983,5985,6005,6007,
   6013,6014,6016,6018,6020,6041,6047,6048,6050,6052,6054,6112,
   6113,6115,6117,6119,6284,6286,6288,6290,6311,6313,6315,6360,
   6362,6405,7725,7726,7727,7728,7729,7732,7733,7734,7736,7742,
   7743,7745,7747,7749,7769,7770,7771,7772,7775,7776,7777,7779,
   7785,7786,7788,7790,7792,7812,7813,7814,7817,7818,7819,7821,
   7827,7828,7830,7832,7834,7854,7855,7858,7859,7860,7862,7868,
   7869,7871,7873,7875,7895,7898,7899,7900,7902,7908,7909,7911,
   7913,7915,7937,7938,7939,7941,7947,7948,7950,7952,7954,8049,
   8050,8052,8058,8059,8061,8063,8065,8085,8087,8093,8094,8096,
   8098,8100,8121,8127,8128,8130,8132,8134,8192,8193,8195,8197,
   8199,8364,8366,8368,8370,8391,8393,8395,8440,8442,8485,
   38205,38206,38207,38208,38211,38212,38213,38215,38221,38222,
   38224,38226,38228,38248,38249,38250,38253,38254,38255,38257,
   38263,38264,38266,38268,38270,38290,38291,38294,38295,38296,
   38298,38304,38305,38307,38309,38311,38331,38334,38335,38336,
   38338,38344,38345,38347,38349,38351,38373,38374,38375,38377,
   38383,38384,38386,38388,38390,38485,38486,38488,38494,38495,
   38497,38499,38501,38521,38523,38529,38530,38532,38534,38536,
   38557,38563,38564,38566,38568,38570,38628,38629,38631,38633,
   38635,38800,38802,38804,38806,38827,38829,38831,38876,38878,
   38921,39151,39152,39153,39156,39157,39158,39160,39166,39167,
   39169,39171,39173,39193,39194,39197,39198,39199,39201,39207,
   39208,39210,39212,39214,39234,39237,39238,39239,39241,39247,
   39248,39250,39252,39254,39276,39277,39278,39280,39286,39287,
   39289,39291,39293,39388,39389,39391,39397,39398,39400,39402,
   39404,39424,39426,39432,39433,39435,39437,39439,39460,39466,
   39467,39469,39471,39473,39531,39532,39534,39536,39538,39703,
   39705,39707,39709,39730,39732,39734,39779,39781,39824,40054,
   40055,40058,40059,40060,40062,40068,40069,40071,40073,40075,
   40095,40098,40099,40100,40102,40108,40109,40111,40113,40115,
   40137,40138,40139,40141,40147,40148,40150,40152,40154,40249,
   40250,40252,40258,40259,40261,40263,40265,40285,40287,40293,
   40294,40296,40298,40300,40321,40327,40328,40330,40332,40334,
   40392,40393,40395,40397,40399,40564,40566,40568,40570,40591,
   40593,40595,40640,40642,40685,40915,40918,40919,40920,40922,
   40928,40929,40931,40933,40935,40957,40958,40959,40961,40967,
   40968,40970,40972,40974,41069,41070,41072,41078,41079,41081,
   41083,41085,41105,41107,41113,41114,41116,41118,41120,41141,
   41147,41148,41150,41152,41154,41212,41213,41215,41217,41219,
   41384,41386,41388,41390,41411,41413,41415,41460,41462,41505,
   41737,41738,41739,41741,41747,41748,41750,41752,41754,41849,
   41850,41852,41858,41859,41861,41863,41865,41885,41887,41893,
   41894,41896,41898,41900,41921,41927,41928,41930,41932,41934,
   41992,41993,41995,41997,41999,42164,42166,42168,42170,42191,
   42193,42195,42240,42242,42285,42590,42591,42593,42599,42600,
   42602,42604,42606,42626,42628,42634,42635,42637,42639,42641,
   42662,42668,42669,42671,42673,42675,42733,42734,42736,42738,
   42740,42905,42907,42909,42911,42932,42934,42936,42981,42983,
   43026,44625,44627,44633,44634,44636,44638,44640,44661,44667,
   44668,44670,44672,44674,44732,44733,44735,44737,44739,44904,
   44906,44908,44910,44931,44933,44935,44980,44982,45025,45256,
   45262,45263,45265,45267,45269,45327,45328,45330,45332,45334,
   45499,45501,45503,45505,45526,45528,45530,45575,45577,45620,
   45888,45889,45891,45893,45895,46060,46062,46064,46066,46087,
   46089,46091,46136,46138,46181,47084,47086,47088,47090,47111,
   47113,47115,47160,47162,47205,49471,49473,49475,49520,49522,
   49565,49820,49822,49865,50394],[2033,6389],
 [1,2,23,26,31,32,41,42,44,68,89,90,91,92,93,94,107,156,
   157,158,163,164,166,173,177,179,1289,1290,1291,1292,1293,
   1296,1297,1298,1300,1306,1307,1309,1311,1313,1333,1334,1335,
   1336,1339,1340,1341,1343,1349,1350,1352,1354,1356,1376,1377,
   1378,1381,1382,1383,1385,1391,1392,1394,1396,1398,1418,1419,
   1422,1423,1424,1426,1432,1433,1435,1437,1439,1459,1462,1463,
   1464,1466,1472,1473,1475,1477,1479,1501,1502,1503,1505,1511,
   1512,1514,1516,1518,1613,1614,1616,1622,1623,1625,1627,1629,
   1649,1651,1657,1658,1660,1662,1664,1685,1691,1692,1694,1696,
   1698,1756,1757,1759,1761,1763,1928,1930,1932,1934,1955,1957,
   1959,2004,2006,2049,2279,2300,2301,2302,2305,2308,2310,2318,
   2319,2321,2365,2366,2367,2370,2373,2375,2383,2384,2386,3500,
   3501,3502,3503,3504,3507,3508,3509,3511,3517,3518,3520,3522,
   3524,3544,3545,3546,3547,3550,3551,3552,3554,3560,3561,3563,
   3565,3567,3587,3588,3589,3592,3593,3594,3596,3602,3603,3605,
   3607,3609,3629,3630,3633,3634,3635,3637,3643,3644,3646,3648,
   3650,3670,3673,3674,3675,3677,3683,3684,3686,3688,3690,3712,
   3713,3714,3716,3722,3723,3725,3727,3729,3824,3825,3827,3833,
   3834,3836,3838,3840,3860,3862,3868,3869,3871,3873,3875,3896,
   3902,3903,3905,3907,3909,3967,3968,3970,3972,3974,4139,4141,
   4143,4145,4166,4168,4170,4215,4217,4260,4510,4511,4512,4515,
   4518,4520,4528,4529,4531,5645,5646,5647,5648,5649,5652,5653,
   5654,5656,5662,5663,5665,5667,5669,5689,5690,5691,5692,5695,
   5696,5697,5699,5705,5706,5708,5710,5712,5732,5733,5734,5737,
   5738,5739,5741,5747,5748,5750,5752,5754,5774,5775,5778,5779,
   5780,5782,5788,5789,5791,5793,5795,5815,5818,5819,5820,5822,
   5828,5829,5831,5833,5835,5857,5858,5859,5861,5867,5868,5870,
   5872,5874,5969,5970,5972,5978,5979,5981,5983,5985,6005,6007,
   6013,6014,6016,6018,6020,6041,6047,6048,6050,6052,6054,6112,
   6113,6115,6117,6119,6284,6286,6288,6290,6311,6313,6315,6360,
   6362,6405,7725,7726,7727,7728,7729,7732,7733,7734,7736,7742,
   7743,7745,7747,7749,7769,7770,7771,7772,7775,7776,7777,7779,
   7785,7786,7788,7790,7792,7812,7813,7814,7817,7818,7819,7821,
   7827,7828,7830,7832,7834,7854,7855,7858,7859,7860,7862,7868,
   7869,7871,7873,7875,7895,7898,7899,7900,7902,7908,7909,7911,
   7913,7915,7937,7938,7939,7941,7947,7948,7950,7952,7954,8049,
   8050,8052,8058,8059,8061,8063,8065,8085,8087,8093,8094,8096,
   8098,8100,8121,8127,8128,8130,8132,8134,8192,8193,8195,8197,
   8199,8364,8366,8368,8370,8391,8393,8395,8440,8442,8485,
   38205,38206,38207,38208,38211,38212,38213,38215,38221,38222,
   38224,38226,38228,38248,38249,38250,38253,38254,38255,38257,
   38263,38264,38266,38268,38270,38290,38291,38294,38295,38296,
   38298,38304,38305,38307,38309,38311,38331,38334,38335,38336,
   38338,38344,38345,38347,38349,38351,38373,38374,38375,38377,
   38383,38384,38386,38388,38390,38485,38486,38488,38494,38495,
   38497,38499,38501,38521,38523,38529,38530,38532,38534,38536,
   38557,38563,38564,38566,38568,38570,38628,38629,38631,38633,
   38635,38800,38802,38804,38806,38827,38829,38831,38876,38878,
   38921,39151,39152,39153,39156,39157,39158,39160,39166,39167,
   39169,39171,39173,39193,39194,39197,39198,39199,39201,39207,
   39208,39210,39212,39214,39234,39237,39238,39239,39241,39247,
   39248,39250,39252,39254,39276,39277,39278,39280,39286,39287,
   39289,39291,39293,39388,39389,39391,39397,39398,39400,39402,
   39404,39424,39426,39432,39433,39435,39437,39439,39460,39466,
   39467,39469,39471,39473,39531,39532,39534,39536,39538,39703,
   39705,39707,39709,39730,39732,39734,39779,39781,39824,40054,
   40055,40058,40059,40060,40062,40068,40069,40071,40073,40075,
   40095,40098,40099,40100,40102,40108,40109,40111,40113,40115,
   40137,40138,40139,40141,40147,40148,40150,40152,40154,40249,
   40250,40252,40258,40259,40261,40263,40265,40285,40287,40293,
   40294,40296,40298,40300,40321,40327,40328,40330,40332,40334,
   40392,40393,40395,40397,40399,40564,40566,40568,40570,40591,
   40593,40595,40640,40642,40685,40915,40918,40919,40920,40922,
   40928,40929,40931,40933,40935,40957,40958,40959,40961,40967,
   40968,40970,40972,40974,41069,41070,41072,41078,41079,41081,
   41083,41085,41105,41107,41113,41114,41116,41118,41120,41141,
   41147,41148,41150,41152,41154,41212,41213,41215,41217,41219,
   41384,41386,41388,41390,41411,41413,41415,41460,41462,41505,
   41737,41738,41739,41741,41747,41748,41750,41752,41754,41849,
   41850,41852,41858,41859,41861,41863,41865,41885,41887,41893,
   41894,41896,41898,41900,41921,41927,41928,41930,41932,41934,
   41992,41993,41995,41997,41999,42164,42166,42168,42170,42191,
   42193,42195,42240,42242,42285,42590,42591,42593,42599,42600,
   42602,42604,42606,42626,42628,42634,42635,42637,42639,42641,
   42662,42668,42669,42671,42673,42675,42733,42734,42736,42738,
   42740,42905,42907,42909,42911,42932,42934,42936,42981,42983,
   43026,44625,44627,44633,44634,44636,44638,44640,44661,44667,
   44668,44670,44672,44674,44732,44733,44735,44737,44739,44904,
   44906,44908,44910,44931,44933,44935,44980,44982,45025,45256,
   45262,45263,45265,45267,45269,45327,45328,45330,45332,45334,
   45499,45501,45503,45505,45526,45528,45530,45575,45577,45620,
   45888,45889,45891,45893,45895,46060,46062,46064,46066,46087,
   46089,46091,46136,46138,46181,47084,47086,47088,47090,47111,
   47113,47115,47160,47162,47205,49471,49473,49475,49520,49522,
   49565,49820,49822,49865,50394],
 [90,94,107,1336,1342,1349,1355,1504,1511,1517,1724,1730,1933,
   5692,5698,5705,5711,5860,5867,5873,6080,6086,6289,39279,
   39286,39292,39499,39505,39708,42701,42707,42910,46593],
 [1,2,23,26,31,32,41,42,44,68,89,90,91,92,93,94,107,156,
   157,158,163,164,166,173,177,179,1289,1290,1291,1292,1293,
   1296,1297,1298,1300,1306,1307,1309,1311,1313,1333,1334,1335,
   1336,1339,1340,1341,1343,1349,1350,1352,1354,1356,1376,1377,
   1378,1381,1382,1383,1385,1391,1392,1394,1396,1398,1418,1419,
   1422,1423,1424,1426,1432,1433,1435,1437,1439,1459,1462,1463,
   1464,1466,1472,1473,1475,1477,1479,1501,1502,1503,1505,1511,
   1512,1514,1516,1518,1613,1614,1616,1622,1623,1625,1627,1629,
   1649,1651,1657,1658,1660,1662,1664,1685,1691,1692,1694,1696,
   1698,1756,1757,1759,1761,1763,1928,1930,1932,1934,1955,1957,
   1959,2004,2006,2049,2279,2300,2301,2302,2305,2308,2310,2318,
   2319,2321,2365,2366,2367,2370,2373,2375,2383,2384,2386,3500,
   3501,3502,3503,3504,3507,3508,3509,3511,3517,3518,3520,3522,
   3524,3544,3545,3546,3547,3550,3551,3552,3554,3560,3561,3563,
   3565,3567,3587,3588,3589,3592,3593,3594,3596,3602,3603,3605,
   3607,3609,3629,3630,3633,3634,3635,3637,3643,3644,3646,3648,
   3650,3670,3673,3674,3675,3677,3683,3684,3686,3688,3690,3712,
   3713,3714,3716,3722,3723,3725,3727,3729,3824,3825,3827,3833,
   3834,3836,3838,3840,3860,3862,3868,3869,3871,3873,3875,3896,
   3902,3903,3905,3907,3909,3967,3968,3970,3972,3974,4139,4141,
   4143,4145,4166,4168,4170,4215,4217,4260,4510,4511,4512,4515,
   4518,4520,4528,4529,4531,5645,5646,5647,5648,5649,5652,5653,
   5654,5656,5662,5663,5665,5667,5669,5689,5690,5691,5692,5695,
   5696,5697,5699,5705,5706,5708,5710,5712,5732,5733,5734,5737,
   5738,5739,5741,5747,5748,5750,5752,5754,5774,5775,5778,5779,
   5780,5782,5788,5789,5791,5793,5795,5815,5818,5819,5820,5822,
   5828,5829,5831,5833,5835,5857,5858,5859,5861,5867,5868,5870,
   5872,5874,5969,5970,5972,5978,5979,5981,5983,5985,6005,6007,
   6013,6014,6016,6018,6020,6041,6047,6048,6050,6052,6054,6112,
   6113,6115,6117,6119,6284,6286,6288,6290,6311,6313,6315,6360,
   6362,6405,7725,7726,7727,7728,7729,7732,7733,7734,7736,7742,
   7743,7745,7747,7749,7769,7770,7771,7772,7775,7776,7777,7779,
   7785,7786,7788,7790,7792,7812,7813,7814,7817,7818,7819,7821,
   7827,7828,7830,7832,7834,7854,7855,7858,7859,7860,7862,7868,
   7869,7871,7873,7875,7895,7898,7899,7900,7902,7908,7909,7911,
   7913,7915,7937,7938,7939,7941,7947,7948,7950,7952,7954,8049,
   8050,8052,8058,8059,8061,8063,8065,8085,8087,8093,8094,8096,
   8098,8100,8121,8127,8128,8130,8132,8134,8192,8193,8195,8197,
   8199,8364,8366,8368,8370,8391,8393,8395,8440,8442,8485,
   38205,38206,38207,38208,38211,38212,38213,38215,38221,38222,
   38224,38226,38228,38248,38249,38250,38253,38254,38255,38257,
   38263,38264,38266,38268,38270,38290,38291,38294,38295,38296,
   38298,38304,38305,38307,38309,38311,38331,38334,38335,38336,
   38338,38344,38345,38347,38349,38351,38373,38374,38375,38377,
   38383,38384,38386,38388,38390,38485,38486,38488,38494,38495,
   38497,38499,38501,38521,38523,38529,38530,38532,38534,38536,
   38557,38563,38564,38566,38568,38570,38628,38629,38631,38633,
   38635,38800,38802,38804,38806,38827,38829,38831,38876,38878,
   38921,39151,39152,39153,39156,39157,39158,39160,39166,39167,
   39169,39171,39173,39193,39194,39197,39198,39199,39201,39207,
   39208,39210,39212,39214,39234,39237,39238,39239,39241,39247,
   39248,39250,39252,39254,39276,39277,39278,39280,39286,39287,
   39289,39291,39293,39388,39389,39391,39397,39398,39400,39402,
   39404,39424,39426,39432,39433,39435,39437,39439,39460,39466,
   39467,39469,39471,39473,39531,39532,39534,39536,39538,39703,
   39705,39707,39709,39730,39732,39734,39779,39781,39824,40054,
   40055,40058,40059,40060,40062,40068,40069,40071,40073,40075,
   40095,40098,40099,40100,40102,40108,40109,40111,40113,40115,
   40137,40138,40139,40141,40147,40148,40150,40152,40154,40249,
   40250,40252,40258,40259,40261,40263,40265,40285,40287,40293,
   40294,40296,40298,40300,40321,40327,40328,40330,40332,40334,
   40392,40393,40395,40397,40399,40564,40566,40568,40570,40591,
   40593,40595,40640,40642,40685,40915,40918,40919,40920,40922,
   40928,40929,40931,40933,40935,40957,40958,40959,40961,40967,
   40968,40970,40972,40974,41069,41070,41072,41078,41079,41081,
   41083,41085,41105,41107,41113,41114,41116,41118,41120,41141,
   41147,41148,41150,41152,41154,41212,41213,41215,41217,41219,
   41384,41386,41388,41390,41411,41413,41415,41460,41462,41505,
   41737,41738,41739,41741,41747,41748,41750,41752,41754,41849,
   41850,41852,41858,41859,41861,41863,41865,41885,41887,41893,
   41894,41896,41898,41900,41921,41927,41928,41930,41932,41934,
   41992,41993,41995,41997,41999,42164,42166,42168,42170,42191,
   42193,42195,42240,42242,42285,42590,42591,42593,42599,42600,
   42602,42604,42606,42626,42628,42634,42635,42637,42639,42641,
   42662,42668,42669,42671,42673,42675,42733,42734,42736,42738,
   42740,42905,42907,42909,42911,42932,42934,42936,42981,42983,
   43026,44625,44627,44633,44634,44636,44638,44640,44661,44667,
   44668,44670,44672,44674,44732,44733,44735,44737,44739,44904,
   44906,44908,44910,44931,44933,44935,44980,44982,45025,45256,
   45262,45263,45265,45267,45269,45327,45328,45330,45332,45334,
   45499,45501,45503,45505,45526,45528,45530,45575,45577,45620,
   45888,45889,45891,45893,45895,46060,46062,46064,46066,46087,
   46089,46091,46136,46138,46181,47084,47086,47088,47090,47111,
   47113,47115,47160,47162,47205,49471,49473,49475,49520,49522,
   49565,49820,49822,49865,50394],
 [89,90,91,92,93,94,107,1289,1290,1291,1292,1293,1306,1308,
   1314,1333,1334,1335,1336,1349,1351,1357,1376,1377,1378,1391,
   1393,1399,1418,1419,1432,1434,1440,1459,1472,1474,1480,1511,
   1513,1519,1929,1935,1984,5645,5646,5647,5648,5649,5662,5664,
   5670,5689,5690,5691,5692,5705,5707,5713,5732,5733,5734,5747,
   5749,5755,5774,5775,5788,5790,5796,5815,5828,5830,5836,5867,
   5869,5875,6285,6291,6340,38205,38206,38207,38208,38221,38223,
   38229,38248,38249,38250,38263,38265,38271,38290,38291,38304,
   38306,38312,38331,38344,38346,38352,38383,38385,38391,38801,
   38807,38856,39151,39152,39153,39166,39168,39174,39193,39194,
   39207,39209,39215,39234,39247,39249,39255,39286,39288,39294,
   39704,39710,39759,40054,40055,40068,40070,40076,40095,40108,
   40110,40116,40147,40149,40155,40565,40571,40620,40915,40928,
   40930,40936,40967,40969,40975,41385,41391,41440,41747,41749,
   41755,42165,42171,42220,42906,42912,42961,49500],[6152],
 [1827,6183],[6213],[2033,6389],[1887,6243],[1915,6271],
 [2215,6571],[2224,6580],[2224,6580],[2215,6571],
 [2254,6610],[2262,6618],[2268,6624],[2270,6626],
 [2254,6610],[2270,6626],[2262,6618],[2268,6624],
 [157,164,179,202,221,228,243,467,474,489,1424,1439,1698,6657,
   6664,6679,6903,6910,6925,7860,7875,8134,8919,8926,8941,9876,
   9891,10150,17320,17335,17594,41154],
 [157,164,179,268,284,291,306,641,648,663,1424,1439,1698,6704,
   6720,6727,6742,7077,7084,7099,7860,7875,8134,11046,11053,
   11068,11829,11844,12103,22280,22295,22554,41154],
 [156,158,163,166,173,177,328,345,347,352,355,362,366,525,
   527,532,535,542,546,1377,1382,1385,1392,1396,1463,1466,
   1473,1477,1651,1658,1662,1757,1761,1957,6764,6781,6783,6788,
   6791,6798,6802,6961,6963,6968,6971,6978,6982,7813,7818,7821,
   7828,7832,7899,7902,7909,7913,8087,8094,8098,8193,8197,8393,
   12821,12823,12828,12831,12838,12842,13673,13678,13681,13688,
   13692,13759,13762,13769,13773,13947,13954,13958,14053,14057,
   14253,18984,18989,18992,18999,19003,19070,19073,19080,19084,
   19258,19265,19269,19364,19368,19564,40099,40102,40109,40113,
   40287,40294,40298,40393,40397,40593,41887,41894,41898,41993,
   41997,42193,45328,45332,45528,47113],[393,6829],
 [157,164,179,202,221,228,243,467,474,489,1424,1439,1698,6657,
   6664,6679,6903,6910,6925,7860,7875,8134,8919,8926,8941,9876,
   9891,10150,17320,17335,17594,41154],
 [156,158,163,166,173,177,328,345,347,352,355,362,366,525,
   527,532,535,542,546,1377,1382,1385,1392,1396,1463,1466,
   1473,1477,1651,1658,1662,1757,1761,1957,6764,6781,6783,6788,
   6791,6798,6802,6961,6963,6968,6971,6978,6982,7813,7818,7821,
   7828,7832,7899,7902,7909,7913,8087,8094,8098,8193,8197,8393,
   12821,12823,12828,12831,12838,12842,13673,13678,13681,13688,
   13692,13759,13762,13769,13773,13947,13954,13958,14053,14057,
   14253,18984,18989,18992,18999,19003,19070,19073,19080,19084,
   19258,19265,19269,19364,19368,19564,40099,40102,40109,40113,
   40287,40294,40298,40393,40397,40593,41887,41894,41898,41993,
   41997,42193,45328,45332,45528,47113],[569,7005],
 [157,164,179,268,284,291,306,641,648,663,1424,1439,1698,6704,
   6720,6727,6742,7077,7084,7099,7860,7875,8134,11046,11053,
   11068,11829,11844,12103,22280,22295,22554,41154],
 [569,7005],[393,6829],
 [157,164,179,806,813,828,1424,1439,1698,7242,7249,7264,7860,
   7875,8134,26736,26751,27010,41154],
 [157,164,179,859,866,881,1424,1439,1698,7295,7302,7317,7860,
   7875,8134,28114,28129,28388,41154],[],
 [157,164,179,962,969,984,1424,1439,1698,7398,7405,7420,7860,
   7875,8134,30715,30730,30989,41154],[],
 [145,157,164,179,851,859,866,881,1061,1068,1083,1424,1439,
   1698,7287,7295,7302,7317,7497,7504,7519,7860,7875,8134,
   27751,27758,27773,28114,28129,28388,33116,33131,33390,41154],
 [157,164,179,1109,1116,1131,1424,1439,1698,7545,7552,7567,
   7860,7875,8134,34244,34259,34518,41154],[],
 [147,157,164,179,957,962,969,984,1202,1209,1224,1424,1439,
   1698,7393,7398,7405,7420,7638,7645,7660,7860,7875,8134,
   30493,30500,30515,30715,30730,30989,36360,36375,36634,41154],
 [148,1008,7444],
 [1,2,23,26,31,32,41,42,44,68,89,90,91,92,93,94,107,156,
   157,158,163,164,166,173,177,179,1289,1290,1291,1292,1293,
   1296,1297,1298,1300,1306,1307,1309,1311,1313,1333,1334,1335,
   1336,1339,1340,1341,1343,1349,1350,1352,1354,1356,1376,1377,
   1378,1381,1382,1383,1385,1391,1392,1394,1396,1398,1418,1419,
   1422,1423,1424,1426,1432,1433,1435,1437,1439,1459,1462,1463,
   1464,1466,1472,1473,1475,1477,1479,1501,1502,1503,1505,1511,
   1512,1514,1516,1518,1613,1614,1616,1622,1623,1625,1627,1629,
   1649,1651,1657,1658,1660,1662,1664,1685,1691,1692,1694,1696,
   1698,1756,1757,1759,1761,1763,1928,1930,1932,1934,1955,1957,
   1959,2004,2006,2049,2279,2300,2301,2302,2305,2308,2310,2318,
   2319,2321,2365,2366,2367,2370,2373,2375,2383,2384,2386,3500,
   3501,3502,3503,3504,3507,3508,3509,3511,3517,3518,3520,3522,
   3524,3544,3545,3546,3547,3550,3551,3552,3554,3560,3561,3563,
   3565,3567,3587,3588,3589,3592,3593,3594,3596,3602,3603,3605,
   3607,3609,3629,3630,3633,3634,3635,3637,3643,3644,3646,3648,
   3650,3670,3673,3674,3675,3677,3683,3684,3686,3688,3690,3712,
   3713,3714,3716,3722,3723,3725,3727,3729,3824,3825,3827,3833,
   3834,3836,3838,3840,3860,3862,3868,3869,3871,3873,3875,3896,
   3902,3903,3905,3907,3909,3967,3968,3970,3972,3974,4139,4141,
   4143,4145,4166,4168,4170,4215,4217,4260,4510,4511,4512,4515,
   4518,4520,4528,4529,4531,5645,5646,5647,5648,5649,5652,5653,
   5654,5656,5662,5663,5665,5667,5669,5689,5690,5691,5692,5695,
   5696,5697,5699,5705,5706,5708,5710,5712,5732,5733,5734,5737,
   5738,5739,5741,5747,5748,5750,5752,5754,5774,5775,5778,5779,
   5780,5782,5788,5789,5791,5793,5795,5815,5818,5819,5820,5822,
   5828,5829,5831,5833,5835,5857,5858,5859,5861,5867,5868,5870,
   5872,5874,5969,5970,5972,5978,5979,5981,5983,5985,6005,6007,
   6013,6014,6016,6018,6020,6041,6047,6048,6050,6052,6054,6112,
   6113,6115,6117,6119,6284,6286,6288,6290,6311,6313,6315,6360,
   6362,6405,7725,7726,7727,7728,7729,7732,7733,7734,7736,7742,
   7743,7745,7747,7749,7769,7770,7771,7772,7775,7776,7777,7779,
   7785,7786,7788,7790,7792,7812,7813,7814,7817,7818,7819,7821,
   7827,7828,7830,7832,7834,7854,7855,7858,7859,7860,7862,7868,
   7869,7871,7873,7875,7895,7898,7899,7900,7902,7908,7909,7911,
   7913,7915,7937,7938,7939,7941,7947,7948,7950,7952,7954,8049,
   8050,8052,8058,8059,8061,8063,8065,8085,8087,8093,8094,8096,
   8098,8100,8121,8127,8128,8130,8132,8134,8192,8193,8195,8197,
   8199,8364,8366,8368,8370,8391,8393,8395,8440,8442,8485,
   38205,38206,38207,38208,38211,38212,38213,38215,38221,38222,
   38224,38226,38228,38248,38249,38250,38253,38254,38255,38257,
   38263,38264,38266,38268,38270,38290,38291,38294,38295,38296,
   38298,38304,38305,38307,38309,38311,38331,38334,38335,38336,
   38338,38344,38345,38347,38349,38351,38373,38374,38375,38377,
   38383,38384,38386,38388,38390,38485,38486,38488,38494,38495,
   38497,38499,38501,38521,38523,38529,38530,38532,38534,38536,
   38557,38563,38564,38566,38568,38570,38628,38629,38631,38633,
   38635,38800,38802,38804,38806,38827,38829,38831,38876,38878,
   38921,39151,39152,39153,39156,39157,39158,39160,39166,39167,
   39169,39171,39173,39193,39194,39197,39198,39199,39201,39207,
   39208,39210,39212,39214,39234,39237,39238,39239,39241,39247,
   39248,39250,39252,39254,39276,39277,39278,39280,39286,39287,
   39289,39291,39293,39388,39389,39391,39397,39398,39400,39402,
   39404,39424,39426,39432,39433,39435,39437,39439,39460,39466,
   39467,39469,39471,39473,39531,39532,39534,39536,39538,39703,
   39705,39707,39709,39730,39732,39734,39779,39781,39824,40054,
   40055,40058,40059,40060,40062,40068,40069,40071,40073,40075,
   40095,40098,40099,40100,40102,40108,40109,40111,40113,40115,
   40137,40138,40139,40141,40147,40148,40150,40152,40154,40249,
   40250,40252,40258,40259,40261,40263,40265,40285,40287,40293,
   40294,40296,40298,40300,40321,40327,40328,40330,40332,40334,
   40392,40393,40395,40397,40399,40564,40566,40568,40570,40591,
   40593,40595,40640,40642,40685,40915,40918,40919,40920,40922,
   40928,40929,40931,40933,40935,40957,40958,40959,40961,40967,
   40968,40970,40972,40974,41069,41070,41072,41078,41079,41081,
   41083,41085,41105,41107,41113,41114,41116,41118,41120,41141,
   41147,41148,41150,41152,41154,41212,41213,41215,41217,41219,
   41384,41386,41388,41390,41411,41413,41415,41460,41462,41505,
   41737,41738,41739,41741,41747,41748,41750,41752,41754,41849,
   41850,41852,41858,41859,41861,41863,41865,41885,41887,41893,
   41894,41896,41898,41900,41921,41927,41928,41930,41932,41934,
   41992,41993,41995,41997,41999,42164,42166,42168,42170,42191,
   42193,42195,42240,42242,42285,42590,42591,42593,42599,42600,
   42602,42604,42606,42626,42628,42634,42635,42637,42639,42641,
   42662,42668,42669,42671,42673,42675,42733,42734,42736,42738,
   42740,42905,42907,42909,42911,42932,42934,42936,42981,42983,
   43026,44625,44627,44633,44634,44636,44638,44640,44661,44667,
   44668,44670,44672,44674,44732,44733,44735,44737,44739,44904,
   44906,44908,44910,44931,44933,44935,44980,44982,45025,45256,
   45262,45263,45265,45267,45269,45327,45328,45330,45332,45334,
   45499,45501,45503,45505,45526,45528,45530,45575,45577,45620,
   45888,45889,45891,45893,45895,46060,46062,46064,46066,46087,
   46089,46091,46136,46138,46181,47084,47086,47088,47090,47111,
   47113,47115,47160,47162,47205,49471,49473,49475,49520,49522,
   49565,49820,49822,49865,50394],
 [1,2,23,26,31,32,41,42,44,68,89,90,91,92,93,94,107,156,
   157,158,163,164,166,173,177,179,1289,1290,1291,1292,1293,
   1296,1297,1298,1300,1306,1307,1309,1311,1313,1333,1334,1335,
   1336,1339,1340,1341,1343,1349,1350,1352,1354,1356,1376,1377,
   1378,1381,1382,1383,1385,1391,1392,1394,1396,1398,1418,1419,
   1422,1423,1424,1426,1432,1433,1435,1437,1439,1459,1462,1463,
   1464,1466,1472,1473,1475,1477,1479,1501,1502,1503,1505,1511,
   1512,1514,1516,1518,1613,1614,1616,1622,1623,1625,1627,1629,
   1649,1651,1657,1658,1660,1662,1664,1685,1691,1692,1694,1696,
   1698,1756,1757,1759,1761,1763,1928,1930,1932,1934,1955,1957,
   1959,2004,2006,2049,2279,2300,2301,2302,2305,2308,2310,2318,
   2319,2321,2365,2366,2367,2370,2373,2375,2383,2384,2386,3500,
   3501,3502,3503,3504,3507,3508,3509,3511,3517,3518,3520,3522,
   3524,3544,3545,3546,3547,3550,3551,3552,3554,3560,3561,3563,
   3565,3567,3587,3588,3589,3592,3593,3594,3596,3602,3603,3605,
   3607,3609,3629,3630,3633,3634,3635,3637,3643,3644,3646,3648,
   3650,3670,3673,3674,3675,3677,3683,3684,3686,3688,3690,3712,
   3713,3714,3716,3722,3723,3725,3727,3729,3824,3825,3827,3833,
   3834,3836,3838,3840,3860,3862,3868,3869,3871,3873,3875,3896,
   3902,3903,3905,3907,3909,3967,3968,3970,3972,3974,4139,4141,
   4143,4145,4166,4168,4170,4215,4217,4260,4510,4511,4512,4515,
   4518,4520,4528,4529,4531,5645,5646,5647,5648,5649,5652,5653,
   5654,5656,5662,5663,5665,5667,5669,5689,5690,5691,5692,5695,
   5696,5697,5699,5705,5706,5708,5710,5712,5732,5733,5734,5737,
   5738,5739,5741,5747,5748,5750,5752,5754,5774,5775,5778,5779,
   5780,5782,5788,5789,5791,5793,5795,5815,5818,5819,5820,5822,
   5828,5829,5831,5833,5835,5857,5858,5859,5861,5867,5868,5870,
   5872,5874,5969,5970,5972,5978,5979,5981,5983,5985,6005,6007,
   6013,6014,6016,6018,6020,6041,6047,6048,6050,6052,6054,6112,
   6113,6115,6117,6119,6284,6286,6288,6290,6311,6313,6315,6360,
   6362,6405,7725,7726,7727,7728,7729,7732,7733,7734,7736,7742,
   7743,7745,7747,7749,7769,7770,7771,7772,7775,7776,7777,7779,
   7785,7786,7788,7790,7792,7812,7813,7814,7817,7818,7819,7821,
   7827,7828,7830,7832,7834,7854,7855,7858,7859,7860,7862,7868,
   7869,7871,7873,7875,7895,7898,7899,7900,7902,7908,7909,7911,
   7913,7915,7937,7938,7939,7941,7947,7948,7950,7952,7954,8049,
   8050,8052,8058,8059,8061,8063,8065,8085,8087,8093,8094,8096,
   8098,8100,8121,8127,8128,8130,8132,8134,8192,8193,8195,8197,
   8199,8364,8366,8368,8370,8391,8393,8395,8440,8442,8485,
   38205,38206,38207,38208,38211,38212,38213,38215,38221,38222,
   38224,38226,38228,38248,38249,38250,38253,38254,38255,38257,
   38263,38264,38266,38268,38270,38290,38291,38294,38295,38296,
   38298,38304,38305,38307,38309,38311,38331,38334,38335,38336,
   38338,38344,38345,38347,38349,38351,38373,38374,38375,38377,
   38383,38384,38386,38388,38390,38485,38486,38488,38494,38495,
   38497,38499,38501,38521,38523,38529,38530,38532,38534,38536,
   38557,38563,38564,38566,38568,38570,38628,38629,38631,38633,
   38635,38800,38802,38804,38806,38827,38829,38831,38876,38878,
   38921,39151,39152,39153,39156,39157,39158,39160,39166,39167,
   39169,39171,39173,39193,39194,39197,39198,39199,39201,39207,
   39208,39210,39212,39214,39234,39237,39238,39239,39241,39247,
   39248,39250,39252,39254,39276,39277,39278,39280,39286,39287,
   39289,39291,39293,39388,39389,39391,39397,39398,39400,39402,
   39404,39424,39426,39432,39433,39435,39437,39439,39460,39466,
   39467,39469,39471,39473,39531,39532,39534,39536,39538,39703,
   39705,39707,39709,39730,39732,39734,39779,39781,39824,40054,
   40055,40058,40059,40060,40062,40068,40069,40071,40073,40075,
   40095,40098,40099,40100,40102,40108,40109,40111,40113,40115,
   40137,40138,40139,40141,40147,40148,40150,40152,40154,40249,
   40250,40252,40258,40259,40261,40263,40265,40285,40287,40293,
   40294,40296,40298,40300,40321,40327,40328,40330,40332,40334,
   40392,40393,40395,40397,40399,40564,40566,40568,40570,40591,
   40593,40595,40640,40642,40685,40915,40918,40919,40920,40922,
   40928,40929,40931,40933,40935,40957,40958,40959,40961,40967,
   40968,40970,40972,40974,41069,41070,41072,41078,41079,41081,
   41083,41085,41105,41107,41113,41114,41116,41118,41120,41141,
   41147,41148,41150,41152,41154,41212,41213,41215,41217,41219,
   41384,41386,41388,41390,41411,41413,41415,41460,41462,41505,
   41737,41738,41739,41741,41747,41748,41750,41752,41754,41849,
   41850,41852,41858,41859,41861,41863,41865,41885,41887,41893,
   41894,41896,41898,41900,41921,41927,41928,41930,41932,41934,
   41992,41993,41995,41997,41999,42164,42166,42168,42170,42191,
   42193,42195,42240,42242,42285,42590,42591,42593,42599,42600,
   42602,42604,42606,42626,42628,42634,42635,42637,42639,42641,
   42662,42668,42669,42671,42673,42675,42733,42734,42736,42738,
   42740,42905,42907,42909,42911,42932,42934,42936,42981,42983,
   43026,44625,44627,44633,44634,44636,44638,44640,44661,44667,
   44668,44670,44672,44674,44732,44733,44735,44737,44739,44904,
   44906,44908,44910,44931,44933,44935,44980,44982,45025,45256,
   45262,45263,45265,45267,45269,45327,45328,45330,45332,45334,
   45499,45501,45503,45505,45526,45528,45530,45575,45577,45620,
   45888,45889,45891,45893,45895,46060,46062,46064,46066,46087,
   46089,46091,46136,46138,46181,47084,47086,47088,47090,47111,
   47113,47115,47160,47162,47205,49471,49473,49475,49520,49522,
   49565,49820,49822,49865,50394],
 [1377,1658,1761,7813,7818,7821,7828,7832,7899,7902,7909,7913,
   8087,8094,8098,8193,8197,8393,40099,40102,40109,40113,40287,
   40294,40298,40393,40397,40593,41887,41894,41898,41993,41997,
   42193,45328,45332,45528,47113],
 [1424,1439,1698,7860,7875,8134,41154],
 [1377,1658,1761,7813,7818,7821,7828,7832,7899,7902,7909,7913,
   8087,8094,8098,8193,8197,8393,40099,40102,40109,40113,40287,
   40294,40298,40393,40397,40593,41887,41894,41898,41993,41997,
   42193,45328,45332,45528,47113],
 [1,2,23,26,31,32,41,42,44,68,89,90,91,92,93,94,107,156,
   157,158,163,164,166,173,177,179,1289,1290,1291,1292,1293,
   1296,1297,1298,1300,1306,1307,1309,1311,1313,1333,1334,1335,
   1336,1339,1340,1341,1343,1349,1350,1352,1354,1356,1376,1377,
   1378,1381,1382,1383,1385,1391,1392,1394,1396,1398,1418,1419,
   1422,1423,1424,1426,1432,1433,1435,1437,1439,1459,1462,1463,
   1464,1466,1472,1473,1475,1477,1479,1501,1502,1503,1505,1511,
   1512,1514,1516,1518,1613,1614,1616,1622,1623,1625,1627,1629,
   1649,1651,1657,1658,1660,1662,1664,1685,1691,1692,1694,1696,
   1698,1756,1757,1759,1761,1763,1928,1930,1932,1934,1955,1957,
   1959,2004,2006,2049,2279,2300,2301,2302,2305,2308,2310,2318,
   2319,2321,2365,2366,2367,2370,2373,2375,2383,2384,2386,3500,
   3501,3502,3503,3504,3507,3508,3509,3511,3517,3518,3520,3522,
   3524,3544,3545,3546,3547,3550,3551,3552,3554,3560,3561,3563,
   3565,3567,3587,3588,3589,3592,3593,3594,3596,3602,3603,3605,
   3607,3609,3629,3630,3633,3634,3635,3637,3643,3644,3646,3648,
   3650,3670,3673,3674,3675,3677,3683,3684,3686,3688,3690,3712,
   3713,3714,3716,3722,3723,3725,3727,3729,3824,3825,3827,3833,
   3834,3836,3838,3840,3860,3862,3868,3869,3871,3873,3875,3896,
   3902,3903,3905,3907,3909,3967,3968,3970,3972,3974,4139,4141,
   4143,4145,4166,4168,4170,4215,4217,4260,4510,4511,4512,4515,
   4518,4520,4528,4529,4531,5645,5646,5647,5648,5649,5652,5653,
   5654,5656,5662,5663,5665,5667,5669,5689,5690,5691,5692,5695,
   5696,5697,5699,5705,5706,5708,5710,5712,5732,5733,5734,5737,
   5738,5739,5741,5747,5748,5750,5752,5754,5774,5775,5778,5779,
   5780,5782,5788,5789,5791,5793,5795,5815,5818,5819,5820,5822,
   5828,5829,5831,5833,5835,5857,5858,5859,5861,5867,5868,5870,
   5872,5874,5969,5970,5972,5978,5979,5981,5983,5985,6005,6007,
   6013,6014,6016,6018,6020,6041,6047,6048,6050,6052,6054,6112,
   6113,6115,6117,6119,6284,6286,6288,6290,6311,6313,6315,6360,
   6362,6405,7725,7726,7727,7728,7729,7732,7733,7734,7736,7742,
   7743,7745,7747,7749,7769,7770,7771,7772,7775,7776,7777,7779,
   7785,7786,7788,7790,7792,7812,7813,7814,7817,7818,7819,7821,
   7827,7828,7830,7832,7834,7854,7855,7858,7859,7860,7862,7868,
   7869,7871,7873,7875,7895,7898,7899,7900,7902,7908,7909,7911,
   7913,7915,7937,7938,7939,7941,7947,7948,7950,7952,7954,8049,
   8050,8052,8058,8059,8061,8063,8065,8085,8087,8093,8094,8096,
   8098,8100,8121,8127,8128,8130,8132,8134,8192,8193,8195,8197,
   8199,8364,8366,8368,8370,8391,8393,8395,8440,8442,8485,
   38205,38206,38207,38208,38211,38212,38213,38215,38221,38222,
   38224,38226,38228,38248,38249,38250,38253,38254,38255,38257,
   38263,38264,38266,38268,38270,38290,38291,38294,38295,38296,
   38298,38304,38305,38307,38309,38311,38331,38334,38335,38336,
   38338,38344,38345,38347,38349,38351,38373,38374,38375,38377,
   38383,38384,38386,38388,38390,38485,38486,38488,38494,38495,
   38497,38499,38501,38521,38523,38529,38530,38532,38534,38536,
   38557,38563,38564,38566,38568,38570,38628,38629,38631,38633,
   38635,38800,38802,38804,38806,38827,38829,38831,38876,38878,
   38921,39151,39152,39153,39156,39157,39158,39160,39166,39167,
   39169,39171,39173,39193,39194,39197,39198,39199,39201,39207,
   39208,39210,39212,39214,39234,39237,39238,39239,39241,39247,
   39248,39250,39252,39254,39276,39277,39278,39280,39286,39287,
   39289,39291,39293,39388,39389,39391,39397,39398,39400,39402,
   39404,39424,39426,39432,39433,39435,39437,39439,39460,39466,
   39467,39469,39471,39473,39531,39532,39534,39536,39538,39703,
   39705,39707,39709,39730,39732,39734,39779,39781,39824,40054,
   40055,40058,40059,40060,40062,40068,40069,40071,40073,40075,
   40095,40098,40099,40100,40102,40108,40109,40111,40113,40115,
   40137,40138,40139,40141,40147,40148,40150,40152,40154,40249,
   40250,40252,40258,40259,40261,40263,40265,40285,40287,40293,
   40294,40296,40298,40300,40321,40327,40328,40330,40332,40334,
   40392,40393,40395,40397,40399,40564,40566,40568,40570,40591,
   40593,40595,40640,40642,40685,40915,40918,40919,40920,40922,
   40928,40929,40931,40933,40935,40957,40958,40959,40961,40967,
   40968,40970,40972,40974,41069,41070,41072,41078,41079,41081,
   41083,41085,41105,41107,41113,41114,41116,41118,41120,41141,
   41147,41148,41150,41152,41154,41212,41213,41215,41217,41219,
   41384,41386,41388,41390,41411,41413,41415,41460,41462,41505,
   41737,41738,41739,41741,41747,41748,41750,41752,41754,41849,
   41850,41852,41858,41859,41861,41863,41865,41885,41887,41893,
   41894,41896,41898,41900,41921,41927,41928,41930,41932,41934,
   41992,41993,41995,41997,41999,42164,42166,42168,42170,42191,
   42193,42195,42240,42242,42285,42590,42591,42593,42599,42600,
   42602,42604,42606,42626,42628,42634,42635,42637,42639,42641,
   42662,42668,42669,42671,42673,42675,42733,42734,42736,42738,
   42740,42905,42907,42909,42911,42932,42934,42936,42981,42983,
   43026,44625,44627,44633,44634,44636,44638,44640,44661,44667,
   44668,44670,44672,44674,44732,44733,44735,44737,44739,44904,
   44906,44908,44910,44931,44933,44935,44980,44982,45025,45256,
   45262,45263,45265,45267,45269,45327,45328,45330,45332,45334,
   45499,45501,45503,45505,45526,45528,45530,45575,45577,45620,
   45888,45889,45891,45893,45895,46060,46062,46064,46066,46087,
   46089,46091,46136,46138,46181,47084,47086,47088,47090,47111,
   47113,47115,47160,47162,47205,49471,49473,49475,49520,49522,
   49565,49820,49822,49865,50394],[1560,7996],[8032],
 [1,2,23,26,31,32,41,42,44,68,89,90,91,92,93,94,107,156,
   157,158,163,164,166,173,177,179,1289,1290,1291,1292,1293,
   1296,1297,1298,1300,1306,1307,1309,1311,1313,1333,1334,1335,
   1336,1339,1340,1341,1343,1349,1350,1352,1354,1356,1376,1377,
   1378,1381,1382,1383,1385,1391,1392,1394,1396,1398,1418,1419,
   1422,1423,1424,1426,1432,1433,1435,1437,1439,1459,1462,1463,
   1464,1466,1472,1473,1475,1477,1479,1501,1502,1503,1505,1511,
   1512,1514,1516,1518,1613,1614,1616,1622,1623,1625,1627,1629,
   1649,1651,1657,1658,1660,1662,1664,1685,1691,1692,1694,1696,
   1698,1756,1757,1759,1761,1763,1928,1930,1932,1934,1955,1957,
   1959,2004,2006,2049,2279,2300,2301,2302,2305,2308,2310,2318,
   2319,2321,2365,2366,2367,2370,2373,2375,2383,2384,2386,3500,
   3501,3502,3503,3504,3507,3508,3509,3511,3517,3518,3520,3522,
   3524,3544,3545,3546,3547,3550,3551,3552,3554,3560,3561,3563,
   3565,3567,3587,3588,3589,3592,3593,3594,3596,3602,3603,3605,
   3607,3609,3629,3630,3633,3634,3635,3637,3643,3644,3646,3648,
   3650,3670,3673,3674,3675,3677,3683,3684,3686,3688,3690,3712,
   3713,3714,3716,3722,3723,3725,3727,3729,3824,3825,3827,3833,
   3834,3836,3838,3840,3860,3862,3868,3869,3871,3873,3875,3896,
   3902,3903,3905,3907,3909,3967,3968,3970,3972,3974,4139,4141,
   4143,4145,4166,4168,4170,4215,4217,4260,4510,4511,4512,4515,
   4518,4520,4528,4529,4531,5645,5646,5647,5648,5649,5652,5653,
   5654,5656,5662,5663,5665,5667,5669,5689,5690,5691,5692,5695,
   5696,5697,5699,5705,5706,5708,5710,5712,5732,5733,5734,5737,
   5738,5739,5741,5747,5748,5750,5752,5754,5774,5775,5778,5779,
   5780,5782,5788,5789,5791,5793,5795,5815,5818,5819,5820,5822,
   5828,5829,5831,5833,5835,5857,5858,5859,5861,5867,5868,5870,
   5872,5874,5969,5970,5972,5978,5979,5981,5983,5985,6005,6007,
   6013,6014,6016,6018,6020,6041,6047,6048,6050,6052,6054,6112,
   6113,6115,6117,6119,6284,6286,6288,6290,6311,6313,6315,6360,
   6362,6405,7725,7726,7727,7728,7729,7732,7733,7734,7736,7742,
   7743,7745,7747,7749,7769,7770,7771,7772,7775,7776,7777,7779,
   7785,7786,7788,7790,7792,7812,7813,7814,7817,7818,7819,7821,
   7827,7828,7830,7832,7834,7854,7855,7858,7859,7860,7862,7868,
   7869,7871,7873,7875,7895,7898,7899,7900,7902,7908,7909,7911,
   7913,7915,7937,7938,7939,7941,7947,7948,7950,7952,7954,8049,
   8050,8052,8058,8059,8061,8063,8065,8085,8087,8093,8094,8096,
   8098,8100,8121,8127,8128,8130,8132,8134,8192,8193,8195,8197,
   8199,8364,8366,8368,8370,8391,8393,8395,8440,8442,8485,
   38205,38206,38207,38208,38211,38212,38213,38215,38221,38222,
   38224,38226,38228,38248,38249,38250,38253,38254,38255,38257,
   38263,38264,38266,38268,38270,38290,38291,38294,38295,38296,
   38298,38304,38305,38307,38309,38311,38331,38334,38335,38336,
   38338,38344,38345,38347,38349,38351,38373,38374,38375,38377,
   38383,38384,38386,38388,38390,38485,38486,38488,38494,38495,
   38497,38499,38501,38521,38523,38529,38530,38532,38534,38536,
   38557,38563,38564,38566,38568,38570,38628,38629,38631,38633,
   38635,38800,38802,38804,38806,38827,38829,38831,38876,38878,
   38921,39151,39152,39153,39156,39157,39158,39160,39166,39167,
   39169,39171,39173,39193,39194,39197,39198,39199,39201,39207,
   39208,39210,39212,39214,39234,39237,39238,39239,39241,39247,
   39248,39250,39252,39254,39276,39277,39278,39280,39286,39287,
   39289,39291,39293,39388,39389,39391,39397,39398,39400,39402,
   39404,39424,39426,39432,39433,39435,39437,39439,39460,39466,
   39467,39469,39471,39473,39531,39532,39534,39536,39538,39703,
   39705,39707,39709,39730,39732,39734,39779,39781,39824,40054,
   40055,40058,40059,40060,40062,40068,40069,40071,40073,40075,
   40095,40098,40099,40100,40102,40108,40109,40111,40113,40115,
   40137,40138,40139,40141,40147,40148,40150,40152,40154,40249,
   40250,40252,40258,40259,40261,40263,40265,40285,40287,40293,
   40294,40296,40298,40300,40321,40327,40328,40330,40332,40334,
   40392,40393,40395,40397,40399,40564,40566,40568,40570,40591,
   40593,40595,40640,40642,40685,40915,40918,40919,40920,40922,
   40928,40929,40931,40933,40935,40957,40958,40959,40961,40967,
   40968,40970,40972,40974,41069,41070,41072,41078,41079,41081,
   41083,41085,41105,41107,41113,41114,41116,41118,41120,41141,
   41147,41148,41150,41152,41154,41212,41213,41215,41217,41219,
   41384,41386,41388,41390,41411,41413,41415,41460,41462,41505,
   41737,41738,41739,41741,41747,41748,41750,41752,41754,41849,
   41850,41852,41858,41859,41861,41863,41865,41885,41887,41893,
   41894,41896,41898,41900,41921,41927,41928,41930,41932,41934,
   41992,41993,41995,41997,41999,42164,42166,42168,42170,42191,
   42193,42195,42240,42242,42285,42590,42591,42593,42599,42600,
   42602,42604,42606,42626,42628,42634,42635,42637,42639,42641,
   42662,42668,42669,42671,42673,42675,42733,42734,42736,42738,
   42740,42905,42907,42909,42911,42932,42934,42936,42981,42983,
   43026,44625,44627,44633,44634,44636,44638,44640,44661,44667,
   44668,44670,44672,44674,44732,44733,44735,44737,44739,44904,
   44906,44908,44910,44931,44933,44935,44980,44982,45025,45256,
   45262,45263,45265,45267,45269,45327,45328,45330,45332,45334,
   45499,45501,45503,45505,45526,45528,45530,45575,45577,45620,
   45888,45889,45891,45893,45895,46060,46062,46064,46066,46087,
   46089,46091,46136,46138,46181,47084,47086,47088,47090,47111,
   47113,47115,47160,47162,47205,49471,49473,49475,49520,49522,
   49565,49820,49822,49865,50394],
 [1377,1658,1761,7813,7818,7821,7828,7832,7899,7902,7909,7913,
   8087,8094,8098,8193,8197,8393,40099,40102,40109,40113,40287,
   40294,40298,40393,40397,40593,41887,41894,41898,41993,41997,
   42193,45328,45332,45528,47113],
 [1424,1439,1698,7860,7875,8134,41154],[8168],
 [1377,1658,1761,7813,7818,7821,7828,7832,7899,7902,7909,7913,
   8087,8094,8098,8193,8197,8393,40099,40102,40109,40113,40287,
   40294,40298,40393,40397,40593,41887,41894,41898,41993,41997,
   42193,45328,45332,45528,47113],
 [156,158,160,163,165,166,173,177,1377,1379,1382,1384,1385,
   1386,1392,1393,1396,1460,1463,1465,1466,1467,1473,1474,1477,
   1540,1542,1543,1544,1550,1551,1554,1650,1651,1652,1658,1659,
   1662,1718,1719,1725,1726,1729,1751,1757,1758,1761,1788,1789,
   1792,1954,1957,1981,7813,7815,7818,7820,7821,7822,7828,7829,
   7832,7896,7899,7901,7902,7903,7909,7910,7913,7976,7978,7979,
   7980,7986,7987,7990,8086,8087,8088,8094,8095,8098,8154,8155,
   8161,8162,8165,8187,8193,8194,8197,8224,8225,8228,8390,8393,
   8417,40096,40099,40101,40102,40103,40109,40110,40113,40176,
   40178,40179,40180,40186,40187,40190,40286,40287,40288,40294,
   40295,40298,40354,40355,40361,40362,40365,40387,40393,40394,
   40397,40424,40425,40428,40590,40593,40617,41776,41778,41779,
   41780,41786,41787,41790,41886,41887,41888,41894,41895,41898,
   41954,41955,41961,41962,41965,41987,41993,41994,41997,42024,
   42025,42028,42190,42193,42217,43330,43331,43332,43338,43339,
   43342,43398,43399,43405,43406,43409,43431,43437,43438,43441,
   43468,43469,43472,43634,43637,43661,45289,45290,45296,45297,
   45300,45322,45328,45329,45332,45359,45360,45363,45525,45528,
   45552,46411,46417,46418,46421,46448,46449,46452,46614,46617,
   46641,46944,46945,46948,47110,47113,47137,47575,47578,47602,
   49797],
 [156,158,163,166,173,177,178,181,182,1377,1382,1385,1387,
   1388,1392,1396,1397,1400,1401,1463,1466,1468,1469,1473,1477,
   1478,1481,1482,1651,1653,1654,1658,1662,1663,1666,1667,1752,
   1753,1757,1761,1762,1765,1766,1814,1818,1822,1823,1826,1827,
   1847,1851,1852,1855,1856,1957,1958,1961,1962,2048,2051,2052,
   2071,2072,2126,7813,7818,7821,7823,7824,7828,7832,7833,7836,
   7837,7899,7902,7904,7905,7909,7913,7914,7917,7918,8087,8089,
   8090,8094,8098,8099,8102,8103,8188,8189,8193,8197,8198,8201,
   8202,8250,8254,8258,8259,8262,8263,8283,8287,8288,8291,8292,
   8393,8394,8397,8398,8484,8487,8488,8507,8508,8562,40099,
   40102,40104,40105,40109,40113,40114,40117,40118,40287,40289,
   40290,40294,40298,40299,40302,40303,40388,40389,40393,40397,
   40398,40401,40402,40450,40454,40458,40459,40462,40463,40483,
   40487,40488,40491,40492,40593,40594,40597,40598,40684,40687,
   40688,40707,40708,40762,41887,41889,41890,41894,41898,41899,
   41902,41903,41988,41989,41993,41997,41998,42001,42002,42050,
   42054,42058,42059,42062,42063,42083,42087,42088,42091,42092,
   42193,42194,42197,42198,42284,42287,42288,42307,42308,42362,
   45323,45324,45328,45332,45333,45336,45337,45385,45389,45393,
   45394,45397,45398,45418,45422,45423,45426,45427,45528,45529,
   45532,45533,45619,45622,45623,45642,45643,45697,46970,46974,
   46978,46979,46982,46983,47003,47007,47008,47011,47012,47113,
   47114,47117,47118,47204,47207,47208,47227,47228,47282,47903,
   47907,47908,47911,47912,48013,48014,48017,48018,48104,48107,
   48108,48127,48128,48182,48419,48420,48423,48424,48510,48513,
   48514,48533,48534,48588,49864,49867,49868,49887,49888,49942,
   50857,50858,50912,51102],
 [156,158,163,166,173,177,178,181,182,1377,1382,1385,1387,
   1388,1392,1396,1397,1400,1401,1463,1466,1468,1469,1473,1477,
   1478,1481,1482,1651,1653,1654,1658,1662,1663,1666,1667,1752,
   1753,1757,1761,1762,1765,1766,1814,1818,1822,1823,1826,1827,
   1847,1851,1852,1855,1856,1957,1958,1961,1962,2048,2051,2052,
   2071,2072,2126,7813,7818,7821,7823,7824,7828,7832,7833,7836,
   7837,7899,7902,7904,7905,7909,7913,7914,7917,7918,8087,8089,
   8090,8094,8098,8099,8102,8103,8188,8189,8193,8197,8198,8201,
   8202,8250,8254,8258,8259,8262,8263,8283,8287,8288,8291,8292,
   8393,8394,8397,8398,8484,8487,8488,8507,8508,8562,40099,
   40102,40104,40105,40109,40113,40114,40117,40118,40287,40289,
   40290,40294,40298,40299,40302,40303,40388,40389,40393,40397,
   40398,40401,40402,40450,40454,40458,40459,40462,40463,40483,
   40487,40488,40491,40492,40593,40594,40597,40598,40684,40687,
   40688,40707,40708,40762,41887,41889,41890,41894,41898,41899,
   41902,41903,41988,41989,41993,41997,41998,42001,42002,42050,
   42054,42058,42059,42062,42063,42083,42087,42088,42091,42092,
   42193,42194,42197,42198,42284,42287,42288,42307,42308,42362,
   45323,45324,45328,45332,45333,45336,45337,45385,45389,45393,
   45394,45397,45398,45418,45422,45423,45426,45427,45528,45529,
   45532,45533,45619,45622,45623,45642,45643,45697,46970,46974,
   46978,46979,46982,46983,47003,47007,47008,47011,47012,47113,
   47114,47117,47118,47204,47207,47208,47227,47228,47282,47903,
   47907,47908,47911,47912,48013,48014,48017,48018,48104,48107,
   48108,48127,48128,48182,48419,48420,48423,48424,48510,48513,
   48514,48533,48534,48588,49864,49867,49868,49887,49888,49942,
   50857,50858,50912,51102],[1887,8323],[1915,8351],
 [1,2,23,26,31,32,41,42,44,68,89,90,91,92,93,94,107,156,
   157,158,163,164,166,173,177,179,1289,1290,1291,1292,1293,
   1296,1297,1298,1300,1306,1307,1309,1311,1313,1333,1334,1335,
   1336,1339,1340,1341,1343,1349,1350,1352,1354,1356,1376,1377,
   1378,1381,1382,1383,1385,1391,1392,1394,1396,1398,1418,1419,
   1422,1423,1424,1426,1432,1433,1435,1437,1439,1459,1462,1463,
   1464,1466,1472,1473,1475,1477,1479,1501,1502,1503,1505,1511,
   1512,1514,1516,1518,1613,1614,1616,1622,1623,1625,1627,1629,
   1649,1651,1657,1658,1660,1662,1664,1685,1691,1692,1694,1696,
   1698,1756,1757,1759,1761,1763,1928,1930,1932,1934,1955,1957,
   1959,2004,2006,2049,2279,2300,2301,2302,2305,2308,2310,2318,
   2319,2321,2365,2366,2367,2370,2373,2375,2383,2384,2386,3500,
   3501,3502,3503,3504,3507,3508,3509,3511,3517,3518,3520,3522,
   3524,3544,3545,3546,3547,3550,3551,3552,3554,3560,3561,3563,
   3565,3567,3587,3588,3589,3592,3593,3594,3596,3602,3603,3605,
   3607,3609,3629,3630,3633,3634,3635,3637,3643,3644,3646,3648,
   3650,3670,3673,3674,3675,3677,3683,3684,3686,3688,3690,3712,
   3713,3714,3716,3722,3723,3725,3727,3729,3824,3825,3827,3833,
   3834,3836,3838,3840,3860,3862,3868,3869,3871,3873,3875,3896,
   3902,3903,3905,3907,3909,3967,3968,3970,3972,3974,4139,4141,
   4143,4145,4166,4168,4170,4215,4217,4260,4510,4511,4512,4515,
   4518,4520,4528,4529,4531,5645,5646,5647,5648,5649,5652,5653,
   5654,5656,5662,5663,5665,5667,5669,5689,5690,5691,5692,5695,
   5696,5697,5699,5705,5706,5708,5710,5712,5732,5733,5734,5737,
   5738,5739,5741,5747,5748,5750,5752,5754,5774,5775,5778,5779,
   5780,5782,5788,5789,5791,5793,5795,5815,5818,5819,5820,5822,
   5828,5829,5831,5833,5835,5857,5858,5859,5861,5867,5868,5870,
   5872,5874,5969,5970,5972,5978,5979,5981,5983,5985,6005,6007,
   6013,6014,6016,6018,6020,6041,6047,6048,6050,6052,6054,6112,
   6113,6115,6117,6119,6284,6286,6288,6290,6311,6313,6315,6360,
   6362,6405,7725,7726,7727,7728,7729,7732,7733,7734,7736,7742,
   7743,7745,7747,7749,7769,7770,7771,7772,7775,7776,7777,7779,
   7785,7786,7788,7790,7792,7812,7813,7814,7817,7818,7819,7821,
   7827,7828,7830,7832,7834,7854,7855,7858,7859,7860,7862,7868,
   7869,7871,7873,7875,7895,7898,7899,7900,7902,7908,7909,7911,
   7913,7915,7937,7938,7939,7941,7947,7948,7950,7952,7954,8049,
   8050,8052,8058,8059,8061,8063,8065,8085,8087,8093,8094,8096,
   8098,8100,8121,8127,8128,8130,8132,8134,8192,8193,8195,8197,
   8199,8364,8366,8368,8370,8391,8393,8395,8440,8442,8485,
   38205,38206,38207,38208,38211,38212,38213,38215,38221,38222,
   38224,38226,38228,38248,38249,38250,38253,38254,38255,38257,
   38263,38264,38266,38268,38270,38290,38291,38294,38295,38296,
   38298,38304,38305,38307,38309,38311,38331,38334,38335,38336,
   38338,38344,38345,38347,38349,38351,38373,38374,38375,38377,
   38383,38384,38386,38388,38390,38485,38486,38488,38494,38495,
   38497,38499,38501,38521,38523,38529,38530,38532,38534,38536,
   38557,38563,38564,38566,38568,38570,38628,38629,38631,38633,
   38635,38800,38802,38804,38806,38827,38829,38831,38876,38878,
   38921,39151,39152,39153,39156,39157,39158,39160,39166,39167,
   39169,39171,39173,39193,39194,39197,39198,39199,39201,39207,
   39208,39210,39212,39214,39234,39237,39238,39239,39241,39247,
   39248,39250,39252,39254,39276,39277,39278,39280,39286,39287,
   39289,39291,39293,39388,39389,39391,39397,39398,39400,39402,
   39404,39424,39426,39432,39433,39435,39437,39439,39460,39466,
   39467,39469,39471,39473,39531,39532,39534,39536,39538,39703,
   39705,39707,39709,39730,39732,39734,39779,39781,39824,40054,
   40055,40058,40059,40060,40062,40068,40069,40071,40073,40075,
   40095,40098,40099,40100,40102,40108,40109,40111,40113,40115,
   40137,40138,40139,40141,40147,40148,40150,40152,40154,40249,
   40250,40252,40258,40259,40261,40263,40265,40285,40287,40293,
   40294,40296,40298,40300,40321,40327,40328,40330,40332,40334,
   40392,40393,40395,40397,40399,40564,40566,40568,40570,40591,
   40593,40595,40640,40642,40685,40915,40918,40919,40920,40922,
   40928,40929,40931,40933,40935,40957,40958,40959,40961,40967,
   40968,40970,40972,40974,41069,41070,41072,41078,41079,41081,
   41083,41085,41105,41107,41113,41114,41116,41118,41120,41141,
   41147,41148,41150,41152,41154,41212,41213,41215,41217,41219,
   41384,41386,41388,41390,41411,41413,41415,41460,41462,41505,
   41737,41738,41739,41741,41747,41748,41750,41752,41754,41849,
   41850,41852,41858,41859,41861,41863,41865,41885,41887,41893,
   41894,41896,41898,41900,41921,41927,41928,41930,41932,41934,
   41992,41993,41995,41997,41999,42164,42166,42168,42170,42191,
   42193,42195,42240,42242,42285,42590,42591,42593,42599,42600,
   42602,42604,42606,42626,42628,42634,42635,42637,42639,42641,
   42662,42668,42669,42671,42673,42675,42733,42734,42736,42738,
   42740,42905,42907,42909,42911,42932,42934,42936,42981,42983,
   43026,44625,44627,44633,44634,44636,44638,44640,44661,44667,
   44668,44670,44672,44674,44732,44733,44735,44737,44739,44904,
   44906,44908,44910,44931,44933,44935,44980,44982,45025,45256,
   45262,45263,45265,45267,45269,45327,45328,45330,45332,45334,
   45499,45501,45503,45505,45526,45528,45530,45575,45577,45620,
   45888,45889,45891,45893,45895,46060,46062,46064,46066,46087,
   46089,46091,46136,46138,46181,47084,47086,47088,47090,47111,
   47113,47115,47160,47162,47205,49471,49473,49475,49520,49522,
   49565,49820,49822,49865,50394],
 [1377,1658,1761,7813,7818,7821,7828,7832,7899,7902,7909,7913,
   8087,8094,8098,8193,8197,8393,40099,40102,40109,40113,40287,
   40294,40298,40393,40397,40593,41887,41894,41898,41993,41997,
   42193,45328,45332,45528,47113],
 [156,158,160,163,165,166,173,177,1377,1379,1382,1384,1385,
   1386,1392,1393,1396,1460,1463,1465,1466,1467,1473,1474,1477,
   1540,1542,1543,1544,1550,1551,1554,1650,1651,1652,1658,1659,
   1662,1718,1719,1725,1726,1729,1751,1757,1758,1761,1788,1789,
   1792,1954,1957,1981,7813,7815,7818,7820,7821,7822,7828,7829,
   7832,7896,7899,7901,7902,7903,7909,7910,7913,7976,7978,7979,
   7980,7986,7987,7990,8086,8087,8088,8094,8095,8098,8154,8155,
   8161,8162,8165,8187,8193,8194,8197,8224,8225,8228,8390,8393,
   8417,40096,40099,40101,40102,40103,40109,40110,40113,40176,
   40178,40179,40180,40186,40187,40190,40286,40287,40288,40294,
   40295,40298,40354,40355,40361,40362,40365,40387,40393,40394,
   40397,40424,40425,40428,40590,40593,40617,41776,41778,41779,
   41780,41786,41787,41790,41886,41887,41888,41894,41895,41898,
   41954,41955,41961,41962,41965,41987,41993,41994,41997,42024,
   42025,42028,42190,42193,42217,43330,43331,43332,43338,43339,
   43342,43398,43399,43405,43406,43409,43431,43437,43438,43441,
   43468,43469,43472,43634,43637,43661,45289,45290,45296,45297,
   45300,45322,45328,45329,45332,45359,45360,45363,45525,45528,
   45552,46411,46417,46418,46421,46448,46449,46452,46614,46617,
   46641,46944,46945,46948,47110,47113,47137,47575,47578,47602,
   49797],
 [1,2,23,26,31,32,41,42,44,68,89,90,91,92,93,94,107,156,
   157,158,163,164,166,173,177,179,1289,1290,1291,1292,1293,
   1296,1297,1298,1300,1306,1307,1309,1311,1313,1333,1334,1335,
   1336,1339,1340,1341,1343,1349,1350,1352,1354,1356,1376,1377,
   1378,1381,1382,1383,1385,1391,1392,1394,1396,1398,1418,1419,
   1422,1423,1424,1426,1432,1433,1435,1437,1439,1459,1462,1463,
   1464,1466,1472,1473,1475,1477,1479,1501,1502,1503,1505,1511,
   1512,1514,1516,1518,1613,1614,1616,1622,1623,1625,1627,1629,
   1649,1651,1657,1658,1660,1662,1664,1685,1691,1692,1694,1696,
   1698,1756,1757,1759,1761,1763,1928,1930,1932,1934,1955,1957,
   1959,2004,2006,2049,2279,2300,2301,2302,2305,2308,2310,2318,
   2319,2321,2365,2366,2367,2370,2373,2375,2383,2384,2386,3500,
   3501,3502,3503,3504,3507,3508,3509,3511,3517,3518,3520,3522,
   3524,3544,3545,3546,3547,3550,3551,3552,3554,3560,3561,3563,
   3565,3567,3587,3588,3589,3592,3593,3594,3596,3602,3603,3605,
   3607,3609,3629,3630,3633,3634,3635,3637,3643,3644,3646,3648,
   3650,3670,3673,3674,3675,3677,3683,3684,3686,3688,3690,3712,
   3713,3714,3716,3722,3723,3725,3727,3729,3824,3825,3827,3833,
   3834,3836,3838,3840,3860,3862,3868,3869,3871,3873,3875,3896,
   3902,3903,3905,3907,3909,3967,3968,3970,3972,3974,4139,4141,
   4143,4145,4166,4168,4170,4215,4217,4260,4510,4511,4512,4515,
   4518,4520,4528,4529,4531,5645,5646,5647,5648,5649,5652,5653,
   5654,5656,5662,5663,5665,5667,5669,5689,5690,5691,5692,5695,
   5696,5697,5699,5705,5706,5708,5710,5712,5732,5733,5734,5737,
   5738,5739,5741,5747,5748,5750,5752,5754,5774,5775,5778,5779,
   5780,5782,5788,5789,5791,5793,5795,5815,5818,5819,5820,5822,
   5828,5829,5831,5833,5835,5857,5858,5859,5861,5867,5868,5870,
   5872,5874,5969,5970,5972,5978,5979,5981,5983,5985,6005,6007,
   6013,6014,6016,6018,6020,6041,6047,6048,6050,6052,6054,6112,
   6113,6115,6117,6119,6284,6286,6288,6290,6311,6313,6315,6360,
   6362,6405,7725,7726,7727,7728,7729,7732,7733,7734,7736,7742,
   7743,7745,7747,7749,7769,7770,7771,7772,7775,7776,7777,7779,
   7785,7786,7788,7790,7792,7812,7813,7814,7817,7818,7819,7821,
   7827,7828,7830,7832,7834,7854,7855,7858,7859,7860,7862,7868,
   7869,7871,7873,7875,7895,7898,7899,7900,7902,7908,7909,7911,
   7913,7915,7937,7938,7939,7941,7947,7948,7950,7952,7954,8049,
   8050,8052,8058,8059,8061,8063,8065,8085,8087,8093,8094,8096,
   8098,8100,8121,8127,8128,8130,8132,8134,8192,8193,8195,8197,
   8199,8364,8366,8368,8370,8391,8393,8395,8440,8442,8485,
   38205,38206,38207,38208,38211,38212,38213,38215,38221,38222,
   38224,38226,38228,38248,38249,38250,38253,38254,38255,38257,
   38263,38264,38266,38268,38270,38290,38291,38294,38295,38296,
   38298,38304,38305,38307,38309,38311,38331,38334,38335,38336,
   38338,38344,38345,38347,38349,38351,38373,38374,38375,38377,
   38383,38384,38386,38388,38390,38485,38486,38488,38494,38495,
   38497,38499,38501,38521,38523,38529,38530,38532,38534,38536,
   38557,38563,38564,38566,38568,38570,38628,38629,38631,38633,
   38635,38800,38802,38804,38806,38827,38829,38831,38876,38878,
   38921,39151,39152,39153,39156,39157,39158,39160,39166,39167,
   39169,39171,39173,39193,39194,39197,39198,39199,39201,39207,
   39208,39210,39212,39214,39234,39237,39238,39239,39241,39247,
   39248,39250,39252,39254,39276,39277,39278,39280,39286,39287,
   39289,39291,39293,39388,39389,39391,39397,39398,39400,39402,
   39404,39424,39426,39432,39433,39435,39437,39439,39460,39466,
   39467,39469,39471,39473,39531,39532,39534,39536,39538,39703,
   39705,39707,39709,39730,39732,39734,39779,39781,39824,40054,
   40055,40058,40059,40060,40062,40068,40069,40071,40073,40075,
   40095,40098,40099,40100,40102,40108,40109,40111,40113,40115,
   40137,40138,40139,40141,40147,40148,40150,40152,40154,40249,
   40250,40252,40258,40259,40261,40263,40265,40285,40287,40293,
   40294,40296,40298,40300,40321,40327,40328,40330,40332,40334,
   40392,40393,40395,40397,40399,40564,40566,40568,40570,40591,
   40593,40595,40640,40642,40685,40915,40918,40919,40920,40922,
   40928,40929,40931,40933,40935,40957,40958,40959,40961,40967,
   40968,40970,40972,40974,41069,41070,41072,41078,41079,41081,
   41083,41085,41105,41107,41113,41114,41116,41118,41120,41141,
   41147,41148,41150,41152,41154,41212,41213,41215,41217,41219,
   41384,41386,41388,41390,41411,41413,41415,41460,41462,41505,
   41737,41738,41739,41741,41747,41748,41750,41752,41754,41849,
   41850,41852,41858,41859,41861,41863,41865,41885,41887,41893,
   41894,41896,41898,41900,41921,41927,41928,41930,41932,41934,
   41992,41993,41995,41997,41999,42164,42166,42168,42170,42191,
   42193,42195,42240,42242,42285,42590,42591,42593,42599,42600,
   42602,42604,42606,42626,42628,42634,42635,42637,42639,42641,
   42662,42668,42669,42671,42673,42675,42733,42734,42736,42738,
   42740,42905,42907,42909,42911,42932,42934,42936,42981,42983,
   43026,44625,44627,44633,44634,44636,44638,44640,44661,44667,
   44668,44670,44672,44674,44732,44733,44735,44737,44739,44904,
   44906,44908,44910,44931,44933,44935,44980,44982,45025,45256,
   45262,45263,45265,45267,45269,45327,45328,45330,45332,45334,
   45499,45501,45503,45505,45526,45528,45530,45575,45577,45620,
   45888,45889,45891,45893,45895,46060,46062,46064,46066,46087,
   46089,46091,46136,46138,46181,47084,47086,47088,47090,47111,
   47113,47115,47160,47162,47205,49471,49473,49475,49520,49522,
   49565,49820,49822,49865,50394],[2033,8469],
 [1377,1658,1761,7813,7818,7821,7828,7832,7899,7902,7909,7913,
   8087,8094,8098,8193,8197,8393,40099,40102,40109,40113,40287,
   40294,40298,40393,40397,40593,41887,41894,41898,41993,41997,
   42193,45328,45332,45528,47113],[2071,8507],
 [1424,1439,1698,7860,7875,8134,41154],[8168],[2071,8507],
 [8032],[1560,7996],[2033,8469],[1887,8323],[1915,8351],
 [2215,8651],[2224,8660],[2224,8660],[2215,8651],
 [2254,8690],[2262,8698],[2268,8704],[2270,8706],
 [2254,8690],[2270,8706],[2262,8698],[2268,8704],
 [202,268,328,8715,8962,10854,12747],
 [202,268,328,8715,8962,10854,12747],[202,393,8845,14579],
 [],[202,268,328,8715,8962,10854,12747],
 [202,569,9021,16465],[202,268,328,8715,8962,10854,12747],
 [202,569,9021,16465],[202,393,8845,14579],[202],[202],
 [202],[202],[202],[202],[202],[202],[202],[202],
 [202],[90,94,107,202,236,482,1336,1349,1511,4575,4592,4821,
   4838,5692,5705,5867,8934,9788,9801,9963,17232,17245,17407,
   39286],
 [202,236,482,1377,1391,1472,8934,9829,9843,9924,17273,17287,
   17368,40108],[202],
 [202,236,482,1377,1391,1472,8934,9829,9843,9924,17273,17287,
   17368,40108],
 [90,94,107,202,236,482,1336,1349,1511,4575,4592,4821,4838,
   5692,5705,5867,8934,9788,9801,9963,17232,17245,17407,39286],
 [202],[202],
 [23,31,44,202,218,464,1296,1309,1625,2429,2437,2675,2683,
   3507,3520,3836,8916,9748,9761,10077,17192,17205,17521,38497],
 [202,218,464,1297,1307,1658,8916,9749,9759,10110,17193,17203,
   17554,38530],[202,1698,10150,17594],[202],
 [202,1761,10213,17657],[202],[202],[202],
 [202,1887,10339,17783],[202,1915,10367,17811],[202],
 [202,218,464,1297,1307,1658,8916,9749,9759,10110,17193,17203,
   17554,38530],[202],
 [23,31,44,202,218,464,1296,1309,1625,2429,2437,2675,2683,
   3507,3520,3836,8916,9748,9761,10077,17192,17205,17521,38497],
 [202,2033,10485,17929],[202,1761,10213,17657],[202],
 [202,1698,10150,17594],[202],[202],[202],[202],
 [202,2033,10485,17929],[202,1887,10339,17783],
 [202,1915,10367,17811],[202,2215,10667,18111],
 [202,2224,10676,18120],[202,2224,10676,18120],
 [202,2215,10667,18111],[202,2254,10706,18150],
 [202,2262,10714,18158],[202,2268,10720,18164],
 [202,2270,10722,18166],[202,2254,10706,18150],
 [202,2270,10722,18166],[202,2262,10714,18158],
 [202,2268,10720,18164],[202,268,328,8715,8962,10854,12747],
 [268,393,10796,10798,11032,14753],
 [202,268,328,8715,8962,10854,12747],
 [202,268,328,8715,8962,10854,12747],
 [268,569,10973,10974,11031,19886],[],
 [268,569,10973,10974,11031,19886],
 [268,393,10796,10798,11032,14753],[268,11033],[268,11034],
 [268,11035],[268,11036],[268,11037],[268,11038],
 [268,11039],[268,11040],[268,11041],[268,11042],
 [268,11043],[268,1336,11044,11048,11741,22192],
 [268,1377,11045,11047,11782,22233],[268,11046],
 [268,1377,11045,11047,11782,22233],
 [268,1336,11044,11048,11741,22192],[268,11049],[268,11050],
 [268,1625,11051,11064,12030,22481],
 [268,1658,11052,11062,12063,22514],
 [268,1698,11053,11068,12103,22554],[268,11054],
 [268,1761,11055,11066,12166,22617],[268,11056],[268,11057],
 [268,11058],[268,1887,11059,11074,12292,22743],
 [268,1915,11060,11075,12320,22771],[268,11061],
 [268,1658,11052,11062,12063,22514],[268,11063],
 [268,1625,11051,11064,12030,22481],
 [268,2033,11065,11073,12438,22889],
 [268,1761,11055,11066,12166,22617],[268,11067],
 [268,1698,11053,11068,12103,22554],[268,11069],[268,11070],
 [268,11071],[268,11072],[268,2033,11065,11073,12438,22889],
 [268,1887,11059,11074,12292,22743],
 [268,1915,11060,11075,12320,22771],
 [268,2215,11076,11079,12620,23071],
 [268,2224,11077,11078,12629,23080],
 [268,2224,11077,11078,12629,23080],
 [268,2215,11076,11079,12620,23071],
 [268,2254,11080,11084,12659,23110],
 [268,2262,11081,11086,12667,23118],
 [268,2268,11082,11087,12673,23124],
 [268,2270,11083,11085,12675,23126],
 [268,2254,11080,11084,12659,23110],
 [268,2270,11083,11085,12675,23126],
 [268,2262,11081,11086,12667,23118],
 [268,2268,11082,11087,12673,23124],
 [328,393,569,12685,12686,12688,12689,12805,12807,12808,12865,
   12866,12979,14635,14637,14638,14695,14696,14809,18176,18177,
   18290,19943],[202,268,328,8715,8962,10854,12747],[],
 [328,393,569,12685,12686,12688,12689,12805,12807,12808,12865,
   12866,12979,14635,14637,14638,14695,14696,14809,18176,18177,
   18290,19943],[202,268,328,8715,8962,10854,12747],
 [328,393,569,12685,12686,12688,12689,12805,12807,12808,12865,
   12866,12979,14635,14637,14638,14695,14696,14809,18176,18177,
   18290,19943],
 [328,393,569,12685,12686,12688,12689,12805,12807,12808,12865,
   12866,12979,14635,14637,14638,14695,14696,14809,18176,18177,
   18290,19943],[328,12809],[328,12810],[328,12811],
 [328,12812],[328,12813],[328,12814],[328,12815],
 [328,12816],[328,12817],[328,12818],[328,12819],
 [328,1336,12820,12824,13632,18943],
 [328,1377,12821,12823,13673,18984],[328,12822],
 [328,1377,12821,12823,13673,18984],
 [328,1336,12820,12824,13632,18943],[328,12825],[328,12826],
 [328,1625,12827,12840,13921,19232],
 [328,1658,12828,12838,13954,19265],
 [328,1698,12829,12844,13994,19305],[328,12830],
 [328,1761,12831,12842,14057,19368],[328,12832],[328,12833],
 [328,12834],[328,1887,12835,12850,14183,19494],
 [328,352,362,532,542,1656,1658,1671,1902,1915,1966,12828,
   12836,12838,12851,13952,13954,13967,14198,14211,14262,19263,
   19265,19278,19509,19522,19573,45473,45486,45537,49157],
 [328,12837],[328,1658,12828,12838,13954,19265],[328,12839],
 [328,1625,12827,12840,13921,19232],
 [328,345,347,525,527,1377,1395,1403,1476,1484,2033,12821,
   12823,12841,12849,13673,13691,13699,13772,13780,14329,18984,
   19002,19010,19083,19091,19640,40112,40120,40669,42269],
 [328,1761,12831,12842,14057,19368],[328,12843],
 [328,1698,12829,12844,13994,19305],[328,12845],[328,12846],
 [328,12847],[328,12848],
 [328,345,347,525,527,1377,1395,1403,1476,1484,2033,12821,
   12823,12841,12849,13673,13691,13699,13772,13780,14329,18984,
   19002,19010,19083,19091,19640,40112,40120,40669,42269],
 [328,1887,12835,12850,14183,19494],
 [328,352,362,532,542,1656,1658,1671,1902,1915,1966,12828,
   12836,12838,12851,13952,13954,13967,14198,14211,14262,19263,
   19265,19278,19509,19522,19573,45473,45486,45537,49157],
 [328,2215,2268,12852,12855,12858,12863,14511,14514,14519,14541,
   14546,14564,19822,19825,19830,19852,19857,19875,52196,52201,
   52219,52328],
 [328,2224,2262,12853,12854,12857,12862,14520,14523,14528,14532,
   14537,14558,19831,19834,19839,19843,19848,19869,52232,52237,
   52258,52294],
 [328,2224,2262,12853,12854,12857,12862,14520,14523,14528,14532,
   14537,14558,19831,19834,19839,19843,19848,19869,52232,52237,
   52258,52294],
 [328,2215,2268,12852,12855,12858,12863,14511,14514,14519,14541,
   14546,14564,19822,19825,19830,19852,19857,19875,52196,52201,
   52219,52328],
 [328,2254,2270,12856,12859,12860,12861,14549,14550,14551,14565,
   14566,14569,19860,19861,19862,19876,19877,19880,52350,52351,
   52354,52385],
 [328,2224,2262,12853,12854,12857,12862,14520,14523,14528,14532,
   14537,14558,19831,19834,19839,19843,19848,19869,52232,52237,
   52258,52294],
 [328,2215,2268,12852,12855,12858,12863,14511,14514,14519,14541,
   14546,14564,19822,19825,19830,19852,19857,19875,52196,52201,
   52219,52328],
 [328,2254,2270,12856,12859,12860,12861,14549,14550,14551,14565,
   14566,14569,19860,19861,19862,19876,19877,19880,52350,52351,
   52354,52385],
 [328,2254,2270,12856,12859,12860,12861,14549,14550,14551,14565,
   14566,14569,19860,19861,19862,19876,19877,19880,52350,52351,
   52354,52385],
 [328,2254,2270,12856,12859,12860,12861,14549,14550,14551,14565,
   14566,14569,19860,19861,19862,19876,19877,19880,52350,52351,
   52354,52385],
 [328,2224,2262,12853,12854,12857,12862,14520,14523,14528,14532,
   14537,14558,19831,19834,19839,19843,19848,19869,52232,52237,
   52258,52294],
 [328,2215,2268,12852,12855,12858,12863,14511,14514,14519,14541,
   14546,14564,19822,19825,19830,19852,19857,19875,52196,52201,
   52219,52328],[202,393,8845,14579],
 [328,393,569,12685,12686,12688,12689,12805,12807,12808,12865,
   12866,12979,14635,14637,14638,14695,14696,14809,18176,18177,
   18290,19943],
 [328,393,569,12685,12686,12688,12689,12805,12807,12808,12865,
   12866,12979,14635,14637,14638,14695,14696,14809,18176,18177,
   18290,19943],[268,393,10796,10798,11032,14753],
 [328,393,569,12685,12686,12688,12689,12805,12807,12808,12865,
   12866,12979,14635,14637,14638,14695,14696,14809,18176,18177,
   18290,19943],[],[393,14865],[393,14866],[393,14867],
 [393,14868],[393,14869],[393,14870],[393,14871],
 [393,14872],[393,14873],[393,14874],[393,14875],
 [393,1336,14876,14880,15462,25217],
 [393,1377,14877,14879,15503,25258],[393,14878],
 [393,1377,14877,14879,15503,25258],
 [393,1336,14876,14880,15462,25217],[393,14881],[393,14882],
 [393,1625,14883,14896,15751,25506],
 [393,1658,14884,14894,15784,25539],
 [393,1698,14885,14900,15824,25579],[393,14886],
 [393,406,408,413,423,751,753,758,768,1377,1382,1385,1392,
   1396,1463,1466,1473,1477,1651,1658,1662,1757,1761,1957,
   14877,14879,14884,14887,14894,14898,15503,15508,15511,15518,
   15522,15589,15592,15599,15603,15777,15784,15788,15883,15887,
   16083,25258,25263,25266,25273,25277,25344,25347,25354,25358,
   25532,25539,25543,25638,25642,25838,40099,40102,40109,40113,
   40287,40294,40298,40393,40397,40593,41887,41894,41898,41993,
   41997,42193,45328,45332,45528,47113],[393,14888],
 [393,14889],[393,14890],[393,1887,14891,14906,16013,25768],
 [393,1915,14892,14907,16041,25796],[393,14893],
 [393,1658,14884,14894,15784,25539],[393,14895],
 [393,1625,14883,14896,15751,25506],
 [393,2033,14897,14905,16159,25914],
 [393,406,408,413,423,751,753,758,768,1377,1382,1385,1392,
   1396,1463,1466,1473,1477,1651,1658,1662,1757,1761,1957,
   14877,14879,14884,14887,14894,14898,15503,15508,15511,15518,
   15522,15589,15592,15599,15603,15777,15784,15788,15883,15887,
   16083,25258,25263,25266,25273,25277,25344,25347,25354,25358,
   25532,25539,25543,25638,25642,25838,40099,40102,40109,40113,
   40287,40294,40298,40393,40397,40593,41887,41894,41898,41993,
   41997,42193,45328,45332,45528,47113],[393,14899],
 [393,1698,14885,14900,15824,25579],[393,14901],[393,14902],
 [393,14903],[393,14904],[393,2033,14897,14905,16159,25914],
 [393,1887,14891,14906,16013,25768],
 [393,1915,14892,14907,16041,25796],
 [393,2215,14908,14911,16341,26096],
 [393,2224,14909,14910,16350,26105],
 [393,2224,14909,14910,16350,26105],
 [393,2215,14908,14911,16341,26096],
 [393,2254,14912,14916,16380,26135],
 [393,2262,14913,14918,16388,26143],
 [393,2268,14914,14919,16394,26149],
 [393,2270,14915,14917,16396,26151],
 [393,2254,14912,14916,16380,26135],
 [393,2270,14915,14917,16396,26151],
 [393,2262,14913,14918,16388,26143],
 [393,2268,14914,14919,16394,26149],
 [202,268,328,8715,8962,10854,12747],[202,569,9021,16465],
 [202,268,328,8715,8962,10854,12747],[202,569,9021,16465],
 [202,393,8845,14579],[202],[202],[202],[202],[202],
 [202],[202],[202],[202],[202],[202],
 [90,94,107,202,236,482,1336,1349,1511,4575,4592,4821,4838,
   5692,5705,5867,8934,9788,9801,9963,17232,17245,17407,39286],
 [202,236,482,1377,1391,1472,8934,9829,9843,9924,17273,17287,
   17368,40108],[202],
 [202,236,482,1377,1391,1472,8934,9829,9843,9924,17273,17287,
   17368,40108],
 [90,94,107,202,236,482,1336,1349,1511,4575,4592,4821,4838,
   5692,5705,5867,8934,9788,9801,9963,17232,17245,17407,39286],
 [202],[202],
 [23,31,44,202,218,464,1296,1309,1625,2429,2437,2675,2683,
   3507,3520,3836,8916,9748,9761,10077,17192,17205,17521,38497],
 [202,218,464,1297,1307,1658,8916,9749,9759,10110,17193,17203,
   17554,38530],[202,1698,10150,17594],[202],
 [202,1761,10213,17657],[202],[202],[202],
 [202,1887,10339,17783],[202,1915,10367,17811],[202],
 [202,218,464,1297,1307,1658,8916,9749,9759,10110,17193,17203,
   17554,38530],[202],
 [23,31,44,202,218,464,1296,1309,1625,2429,2437,2675,2683,
   3507,3520,3836,8916,9748,9761,10077,17192,17205,17521,38497],
 [202,2033,10485,17929],[202,1761,10213,17657],[202],
 [202,1698,10150,17594],[202],[202],[202],[202],
 [202,2033,10485,17929],[202,1887,10339,17783],
 [202,1915,10367,17811],[202,2215,10667,18111],
 [202,2224,10676,18120],[202,2224,10676,18120],
 [202,2215,10667,18111],[202,2254,10706,18150],
 [202,2262,10714,18158],[202,2268,10720,18164],
 [202,2270,10722,18166],[202,2254,10706,18150],
 [202,2270,10722,18166],[202,2262,10714,18158],
 [202,2268,10720,18164],
 [328,393,569,12685,12686,12688,12689,12805,12807,12808,12865,
   12866,12979,14635,14637,14638,14695,14696,14809,18176,18177,
   18290,19943],[202,268,328,8715,8962,10854,12747],
 [328,393,569,12685,12686,12688,12689,12805,12807,12808,12865,
   12866,12979,14635,14637,14638,14695,14696,14809,18176,18177,
   18290,19943],
 [328,393,569,12685,12686,12688,12689,12805,12807,12808,12865,
   12866,12979,14635,14637,14638,14695,14696,14809,18176,18177,
   18290,19943],[328,12809],[328,12810],[328,12811],
 [328,12812],[328,12813],[328,12814],[328,12815],
 [328,12816],[328,12817],[328,12818],[328,12819],
 [328,1336,12820,12824,13632,18943],
 [328,1377,12821,12823,13673,18984],[328,12822],
 [328,1377,12821,12823,13673,18984],
 [328,1336,12820,12824,13632,18943],[328,12825],[328,12826],
 [328,1625,12827,12840,13921,19232],
 [328,1658,12828,12838,13954,19265],
 [328,1698,12829,12844,13994,19305],[328,12830],
 [328,1761,12831,12842,14057,19368],[328,12832],[328,12833],
 [328,12834],[328,1887,12835,12850,14183,19494],
 [328,352,362,532,542,1656,1658,1671,1902,1915,1966,12828,
   12836,12838,12851,13952,13954,13967,14198,14211,14262,19263,
   19265,19278,19509,19522,19573,45473,45486,45537,49157],
 [328,12837],[328,1658,12828,12838,13954,19265],[328,12839],
 [328,1625,12827,12840,13921,19232],
 [328,345,347,525,527,1377,1395,1403,1476,1484,2033,12821,
   12823,12841,12849,13673,13691,13699,13772,13780,14329,18984,
   19002,19010,19083,19091,19640,40112,40120,40669,42269],
 [328,1761,12831,12842,14057,19368],[328,12843],
 [328,1698,12829,12844,13994,19305],[328,12845],[328,12846],
 [328,12847],[328,12848],
 [328,345,347,525,527,1377,1395,1403,1476,1484,2033,12821,
   12823,12841,12849,13673,13691,13699,13772,13780,14329,18984,
   19002,19010,19083,19091,19640,40112,40120,40669,42269],
 [328,1887,12835,12850,14183,19494],
 [328,352,362,532,542,1656,1658,1671,1902,1915,1966,12828,
   12836,12838,12851,13952,13954,13967,14198,14211,14262,19263,
   19265,19278,19509,19522,19573,45473,45486,45537,49157],
 [328,2215,2268,12852,12855,12858,12863,14511,14514,14519,14541,
   14546,14564,19822,19825,19830,19852,19857,19875,52196,52201,
   52219,52328],
 [328,2224,2262,12853,12854,12857,12862,14520,14523,14528,14532,
   14537,14558,19831,19834,19839,19843,19848,19869,52232,52237,
   52258,52294],
 [328,2224,2262,12853,12854,12857,12862,14520,14523,14528,14532,
   14537,14558,19831,19834,19839,19843,19848,19869,52232,52237,
   52258,52294],
 [328,2215,2268,12852,12855,12858,12863,14511,14514,14519,14541,
   14546,14564,19822,19825,19830,19852,19857,19875,52196,52201,
   52219,52328],
 [328,2254,2270,12856,12859,12860,12861,14549,14550,14551,14565,
   14566,14569,19860,19861,19862,19876,19877,19880,52350,52351,
   52354,52385],
 [328,2224,2262,12853,12854,12857,12862,14520,14523,14528,14532,
   14537,14558,19831,19834,19839,19843,19848,19869,52232,52237,
   52258,52294],
 [328,2215,2268,12852,12855,12858,12863,14511,14514,14519,14541,
   14546,14564,19822,19825,19830,19852,19857,19875,52196,52201,
   52219,52328],
 [328,2254,2270,12856,12859,12860,12861,14549,14550,14551,14565,
   14566,14569,19860,19861,19862,19876,19877,19880,52350,52351,
   52354,52385],
 [328,2254,2270,12856,12859,12860,12861,14549,14550,14551,14565,
   14566,14569,19860,19861,19862,19876,19877,19880,52350,52351,
   52354,52385],
 [328,2254,2270,12856,12859,12860,12861,14549,14550,14551,14565,
   14566,14569,19860,19861,19862,19876,19877,19880,52350,52351,
   52354,52385],
 [328,2224,2262,12853,12854,12857,12862,14520,14523,14528,14532,
   14537,14558,19831,19834,19839,19843,19848,19869,52232,52237,
   52258,52294],
 [328,2215,2268,12852,12855,12858,12863,14511,14514,14519,14541,
   14546,14564,19822,19825,19830,19852,19857,19875,52196,52201,
   52219,52328],[268,569,10973,10974,11031,19886],[],
 [328,393,569,12685,12686,12688,12689,12805,12807,12808,12865,
   12866,12979,14635,14637,14638,14695,14696,14809,18176,18177,
   18290,19943],[569,19944],[569,19945],[569,19946],
 [569,19947],[569,19948],[569,19949],[569,19950],
 [569,19951],[569,19952],[569,19953],[569,19954],
 [569,1336,19955,19959,20596,23732],
 [569,1377,19956,19958,20637,23773],[569,19957],
 [569,1377,19956,19958,20637,23773],
 [569,1336,19955,19959,20596,23732],[569,19960],[569,19961],
 [569,1625,19962,19975,20885,24021],
 [569,1658,19963,19973,20918,24054],
 [569,1698,19964,19979,20958,24094],[569,19965],
 [569,583,585,590,600,696,698,703,713,1377,1382,1385,1392,
   1396,1463,1466,1473,1477,1651,1658,1662,1757,1761,1957,
   19956,19958,19963,19966,19973,19977,20637,20642,20645,20652,
   20656,20723,20726,20733,20737,20911,20918,20922,21017,21021,
   21217,23773,23778,23781,23788,23792,23859,23862,23869,23873,
   24047,24054,24058,24153,24157,24353,40099,40102,40109,40113,
   40287,40294,40298,40393,40397,40593,41887,41894,41898,41993,
   41997,42193,45328,45332,45528,47113],[569,19967],
 [569,19968],[569,19969],[569,1887,19970,19985,21147,24283],
 [569,1915,19971,19986,21175,24311],[569,19972],
 [569,1658,19963,19973,20918,24054],[569,19974],
 [569,1625,19962,19975,20885,24021],
 [569,2033,19976,19984,21293,24429],
 [569,583,585,590,600,696,698,703,713,1377,1382,1385,1392,
   1396,1463,1466,1473,1477,1651,1658,1662,1757,1761,1957,
   19956,19958,19963,19966,19973,19977,20637,20642,20645,20652,
   20656,20723,20726,20733,20737,20911,20918,20922,21017,21021,
   21217,23773,23778,23781,23788,23792,23859,23862,23869,23873,
   24047,24054,24058,24153,24157,24353,40099,40102,40109,40113,
   40287,40294,40298,40393,40397,40593,41887,41894,41898,41993,
   41997,42193,45328,45332,45528,47113],[569,19978],
 [569,1698,19964,19979,20958,24094],[569,19980],[569,19981],
 [569,19982],[569,19983],[569,2033,19976,19984,21293,24429],
 [569,1887,19970,19985,21147,24283],
 [569,1915,19971,19986,21175,24311],
 [569,2215,19987,19990,21475,24611],
 [569,2224,19988,19989,21484,24620],
 [569,2224,19988,19989,21484,24620],
 [569,2215,19987,19990,21475,24611],
 [569,2254,19991,19995,21514,24650],
 [569,2262,19992,19997,21522,24658],
 [569,2268,19993,19998,21528,24664],
 [569,2270,19994,19996,21530,24666],
 [569,2254,19991,19995,21514,24650],
 [569,2270,19994,19996,21530,24666],
 [569,2262,19992,19997,21522,24658],
 [569,2268,19993,19998,21528,24664],
 [268,569,10973,10974,11031,19886],
 [268,393,10796,10798,11032,14753],[268,11033],[268,11034],
 [268,11035],[268,11036],[268,11037],[268,11038],
 [268,11039],[268,11040],[268,11041],[268,11042],
 [268,11043],[268,1336,11044,11048,11741,22192],
 [268,1377,11045,11047,11782,22233],[268,11046],
 [268,1377,11045,11047,11782,22233],
 [268,1336,11044,11048,11741,22192],[268,11049],[268,11050],
 [268,1625,11051,11064,12030,22481],
 [268,1658,11052,11062,12063,22514],
 [268,1698,11053,11068,12103,22554],[268,11054],
 [268,1761,11055,11066,12166,22617],[268,11056],[268,11057],
 [268,11058],[268,1887,11059,11074,12292,22743],
 [268,1915,11060,11075,12320,22771],[268,11061],
 [268,1658,11052,11062,12063,22514],[268,11063],
 [268,1625,11051,11064,12030,22481],
 [268,2033,11065,11073,12438,22889],
 [268,1761,11055,11066,12166,22617],[268,11067],
 [268,1698,11053,11068,12103,22554],[268,11069],[268,11070],
 [268,11071],[268,11072],[268,2033,11065,11073,12438,22889],
 [268,1887,11059,11074,12292,22743],
 [268,1915,11060,11075,12320,22771],
 [268,2215,11076,11079,12620,23071],
 [268,2224,11077,11078,12629,23080],
 [268,2224,11077,11078,12629,23080],
 [268,2215,11076,11079,12620,23071],
 [268,2254,11080,11084,12659,23110],
 [268,2262,11081,11086,12667,23118],
 [268,2268,11082,11087,12673,23124],
 [268,2270,11083,11085,12675,23126],
 [268,2254,11080,11084,12659,23110],
 [268,2270,11083,11085,12675,23126],
 [268,2262,11081,11086,12667,23118],
 [268,2268,11082,11087,12673,23124],
 [328,393,569,12685,12686,12688,12689,12805,12807,12808,12865,
   12866,12979,14635,14637,14638,14695,14696,14809,18176,18177,
   18290,19943],[569,19944],[569,19945],[569,19946],
 [569,19947],[569,19948],[569,19949],[569,19950],
 [569,19951],[569,19952],[569,19953],[569,19954],
 [569,1336,19955,19959,20596,23732],
 [569,1377,19956,19958,20637,23773],[569,19957],
 [569,1377,19956,19958,20637,23773],
 [569,1336,19955,19959,20596,23732],[569,19960],[569,19961],
 [569,1625,19962,19975,20885,24021],
 [569,1658,19963,19973,20918,24054],
 [569,1698,19964,19979,20958,24094],[569,19965],
 [569,583,585,590,600,696,698,703,713,1377,1382,1385,1392,
   1396,1463,1466,1473,1477,1651,1658,1662,1757,1761,1957,
   19956,19958,19963,19966,19973,19977,20637,20642,20645,20652,
   20656,20723,20726,20733,20737,20911,20918,20922,21017,21021,
   21217,23773,23778,23781,23788,23792,23859,23862,23869,23873,
   24047,24054,24058,24153,24157,24353,40099,40102,40109,40113,
   40287,40294,40298,40393,40397,40593,41887,41894,41898,41993,
   41997,42193,45328,45332,45528,47113],[569,19967],
 [569,19968],[569,19969],[569,1887,19970,19985,21147,24283],
 [569,1915,19971,19986,21175,24311],[569,19972],
 [569,1658,19963,19973,20918,24054],[569,19974],
 [569,1625,19962,19975,20885,24021],
 [569,2033,19976,19984,21293,24429],
 [569,583,585,590,600,696,698,703,713,1377,1382,1385,1392,
   1396,1463,1466,1473,1477,1651,1658,1662,1757,1761,1957,
   19956,19958,19963,19966,19973,19977,20637,20642,20645,20652,
   20656,20723,20726,20733,20737,20911,20918,20922,21017,21021,
   21217,23773,23778,23781,23788,23792,23859,23862,23869,23873,
   24047,24054,24058,24153,24157,24353,40099,40102,40109,40113,
   40287,40294,40298,40393,40397,40593,41887,41894,41898,41993,
   41997,42193,45328,45332,45528,47113],[569,19978],
 [569,1698,19964,19979,20958,24094],[569,19980],[569,19981],
 [569,19982],[569,19983],[569,2033,19976,19984,21293,24429],
 [569,1887,19970,19985,21147,24283],
 [569,1915,19971,19986,21175,24311],
 [569,2215,19987,19990,21475,24611],
 [569,2224,19988,19989,21484,24620],
 [569,2224,19988,19989,21484,24620],
 [569,2215,19987,19990,21475,24611],
 [569,2254,19991,19995,21514,24650],
 [569,2262,19992,19997,21522,24658],
 [569,2268,19993,19998,21528,24664],
 [569,2270,19994,19996,21530,24666],
 [569,2254,19991,19995,21514,24650],
 [569,2270,19994,19996,21530,24666],
 [569,2262,19992,19997,21522,24658],
 [569,2268,19993,19998,21528,24664],[393,14865],[393,14866],
 [393,14867],[393,14868],[393,14869],[393,14870],
 [393,14871],[393,14872],[393,14873],[393,14874],
 [393,14875],[393,1336,14876,14880,15462,25217],
 [393,1377,14877,14879,15503,25258],[393,14878],
 [393,1377,14877,14879,15503,25258],
 [393,1336,14876,14880,15462,25217],[393,14881],[393,14882],
 [393,1625,14883,14896,15751,25506],
 [393,1658,14884,14894,15784,25539],
 [393,1698,14885,14900,15824,25579],[393,14886],
 [393,406,408,413,423,751,753,758,768,1377,1382,1385,1392,
   1396,1463,1466,1473,1477,1651,1658,1662,1757,1761,1957,
   14877,14879,14884,14887,14894,14898,15503,15508,15511,15518,
   15522,15589,15592,15599,15603,15777,15784,15788,15883,15887,
   16083,25258,25263,25266,25273,25277,25344,25347,25354,25358,
   25532,25539,25543,25638,25642,25838,40099,40102,40109,40113,
   40287,40294,40298,40393,40397,40593,41887,41894,41898,41993,
   41997,42193,45328,45332,45528,47113],[393,14888],
 [393,14889],[393,14890],[393,1887,14891,14906,16013,25768],
 [393,1915,14892,14907,16041,25796],[393,14893],
 [393,1658,14884,14894,15784,25539],[393,14895],
 [393,1625,14883,14896,15751,25506],
 [393,2033,14897,14905,16159,25914],
 [393,406,408,413,423,751,753,758,768,1377,1382,1385,1392,
   1396,1463,1466,1473,1477,1651,1658,1662,1757,1761,1957,
   14877,14879,14884,14887,14894,14898,15503,15508,15511,15518,
   15522,15589,15592,15599,15603,15777,15784,15788,15883,15887,
   16083,25258,25263,25266,25273,25277,25344,25347,25354,25358,
   25532,25539,25543,25638,25642,25838,40099,40102,40109,40113,
   40287,40294,40298,40393,40397,40593,41887,41894,41898,41993,
   41997,42193,45328,45332,45528,47113],[393,14899],
 [393,1698,14885,14900,15824,25579],[393,14901],[393,14902],
 [393,14903],[393,14904],[393,2033,14897,14905,16159,25914],
 [393,1887,14891,14906,16013,25768],
 [393,1915,14892,14907,16041,25796],
 [393,2215,14908,14911,16341,26096],
 [393,2224,14909,14910,16350,26105],
 [393,2224,14909,14910,16350,26105],
 [393,2215,14908,14911,16341,26096],
 [393,2254,14912,14916,16380,26135],
 [393,2262,14913,14918,16388,26143],
 [393,2268,14914,14919,16394,26149],
 [393,2270,14915,14917,16396,26151],
 [393,2254,14912,14916,16380,26135],
 [393,2270,14915,14917,16396,26151],
 [393,2262,14913,14918,16388,26143],
 [393,2268,14914,14919,16394,26149],[26160],[26160],[],
 [26316],[26316],[],[],[26510],[26510],[],
 [1336,26648],[1377,26689],[],[1377,26689],[1336,26648],
 [],[],[1625,26937],[1658,26970],[1698,27010],[],
 [1761,27073],[],[],[],[1887,27199],[1915,27227],[],
 [1658,26970],[],[1625,26937],[2033,27345],[1761,27073],
 [],[1698,27010],[],[],[],[],[2033,27345],
 [1887,27199],[1915,27227],[2215,27527],[2224,27536],
 [2224,27536],[2215,27527],[2254,27566],[2262,27574],
 [2268,27580],[2270,27582],[2254,27566],[2270,27582],
 [2262,27574],[2268,27580],[26160],[27643],[27643],[],
 [],[27841],[27841],[],[],[1336,28026],[1377,28067],
 [],[1377,28067],[1336,28026],[],[],[1625,28315],
 [1658,28348],[1698,28388],[],[1761,28451],[],[],[],
 [1887,28577],[1915,28605],[],[1658,28348],[],
 [1625,28315],[2033,28723],[1761,28451],[],[1698,28388],
 [],[],[],[],[2033,28723],[1887,28577],[1915,28605],
 [2215,28905],[2224,28914],[2224,28914],[2215,28905],
 [2254,28944],[2262,28952],[2268,28958],[2270,28960],
 [2254,28944],[2270,28960],[2262,28952],[2268,28958],
 [28970],[],[28970],[],
 [902,1006,1008,29022,29024,29168,31668],[],
 [902,1006,1008,29022,29024,29168,31668],[],[1336,29352],
 [1377,29393],[],[1377,29393],[1336,29352],[],[],
 [1625,29641],[1658,29674],[1698,29714],[],[1761,29777],
 [],[],[],[1887,29903],[1915,29931],[],[1658,29674],
 [],[1625,29641],[2033,30049],[1761,29777],[],
 [1698,29714],[],[],[],[],[2033,30049],[1887,29903],
 [1915,29931],[2215,30231],[2224,30240],[2224,30240],
 [2215,30231],[2254,30270],[2262,30278],[2268,30284],
 [2270,30286],[2254,30270],[2270,30286],[2262,30278],
 [2268,30284],[27643],[28970],[30394],[30394],[],[],
 [],[1336,30627],[1377,30668],[],[1377,30668],
 [1336,30627],[],[],[1625,30916],[1658,30949],
 [1698,30989],[],[1761,31052],[],[],[],[1887,31178],
 [1915,31206],[],[1658,30949],[],[1625,30916],
 [2033,31324],[1761,31052],[],[1698,30989],[],[],[],
 [],[2033,31324],[1887,31178],[1915,31206],[2215,31506],
 [2224,31515],[2224,31515],[2215,31506],[2254,31545],
 [2262,31553],[2268,31559],[2270,31561],[2254,31545],
 [2270,31561],[2262,31553],[2268,31559],[26316],[31620],
 [],[31620],[],[],[1336,31852],[1377,31893],[],
 [1377,31893],[1336,31852],[],[],[1625,32141],
 [1658,32174],[1698,32214],[],[1761,32277],[],[],[],
 [1887,32403],[1915,32431],[],[1658,32174],[],
 [1625,32141],[2033,32549],[1761,32277],[],[1698,32214],
 [],[],[],[],[2033,32549],[1887,32403],[1915,32431],
 [2215,32731],[2224,32740],[2224,32740],[2215,32731],
 [2254,32770],[2262,32778],[2268,32784],[2270,32786],
 [2254,32770],[2270,32786],[2262,32778],[2268,32784],
 [32797],[],[],[32797],[],[1336,33028],[1377,33069],
 [],[1377,33069],[1336,33028],[],[],[1625,33317],
 [1658,33350],[1698,33390],[],[1761,33453],[],[],[],
 [1887,33579],[1915,33607],[],[1658,33350],[],
 [1625,33317],[2033,33725],[1761,33453],[],[1698,33390],
 [],[],[],[],[2033,33725],[1887,33579],[1915,33607],
 [2215,33907],[2224,33916],[2224,33916],[2215,33907],
 [2254,33946],[2262,33954],[2268,33960],[2270,33962],
 [2254,33946],[2270,33962],[2262,33954],[2268,33960],
 [30394],[31620],[32797],[],[1336,34156],[1377,34197],
 [],[1377,34197],[1336,34156],[],[],[1625,34445],
 [1658,34478],[1698,34518],[],[1761,34581],[],[],[],
 [1887,34707],[1915,34735],[],[1658,34478],[],
 [1625,34445],[2033,34853],[1761,34581],[],[1698,34518],
 [],[],[],[],[2033,34853],[1887,34707],[1915,34735],
 [2215,35035],[2224,35044],[2224,35044],[2215,35035],
 [2254,35074],[2262,35082],[2268,35088],[2270,35090],
 [2254,35074],[2270,35090],[2262,35082],[2268,35088],
 [27841],[902,1006,1008,29022,29024,29168,31668],[],
 [1336,35237],[1377,35278],[],[1377,35278],[1336,35237],
 [],[],[1625,35526],[1658,35559],[1698,35599],[],
 [1761,35662],[],[],[],[1887,35788],[1915,35816],[],
 [1658,35559],[],[1625,35526],[2033,35934],[1761,35662],
 [],[1698,35599],[],[],[],[],[2033,35934],
 [1887,35788],[1915,35816],[2215,36116],[2224,36125],
 [2224,36125],[2215,36116],[2254,36155],[2262,36163],
 [2268,36169],[2270,36171],[2254,36155],[2270,36171],
 [2262,36163],[2268,36169],[26510],[],[1336,36272],
 [1377,36313],[],[1377,36313],[1336,36272],[],[],
 [1625,36561],[1658,36594],[1698,36634],[],[1761,36697],
 [],[],[],[1887,36823],[1915,36851],[],[1658,36594],
 [],[1625,36561],[2033,36969],[1761,36697],[],
 [1698,36634],[],[],[],[],[2033,36969],[1887,36823],
 [1915,36851],[2215,37151],[2224,37160],[2224,37160],
 [2215,37151],[2254,37190],[2262,37198],[2268,37204],
 [2270,37206],[2254,37190],[2270,37206],[2262,37198],
 [2268,37204],[],[1336,37262],[1377,37303],[],
 [1377,37303],[1336,37262],[],[],[1625,37551],
 [1658,37584],[1698,37624],[],[1761,37687],[],[],[],
 [1887,37813],[1915,37841],[],[1658,37584],[],
 [1625,37551],[2033,37959],[1761,37687],[],[1698,37624],
 [],[],[],[],[2033,37959],[1887,37813],[1915,37841],
 [2215,38141],[2224,38150],[2224,38150],[2215,38141],
 [2254,38180],[2262,38188],[2268,38194],[2270,38196],
 [2254,38180],[2270,38196],[2262,38188],[2268,38194],
 [90,94,107,1291,1306,1336,1349,1377,1391,1432,1472,1511,5645,
   5646,5662,5689,5690,5691,5692,5705,5747,5774,5788,5828,5867,
   38205,38206,38207,38208,38221,38248,38249,38250,38263,38290,
   38291,38304,38331,38344,38383,39151,39152,39153,39166,39193,
   39194,39207,39234,39247,39286,40054,40055,40068,40095,40108,
   40147,40915,40928,40967,41747],
 [90,94,107,1291,1306,1336,1349,1377,1391,1432,1472,1511,5645,
   5646,5662,5689,5690,5691,5692,5705,5747,5774,5788,5828,5867,
   38205,38206,38207,38208,38221,38248,38249,38250,38263,38290,
   38291,38304,38331,38344,38383,39151,39152,39153,39166,39193,
   39194,39207,39234,39247,39286,40054,40055,40068,40095,40108,
   40147,40915,40928,40967,41747],[],
 [90,94,107,1291,1306,1336,1349,1377,1391,1432,1472,1511,5645,
   5646,5662,5689,5690,5691,5692,5705,5747,5774,5788,5828,5867,
   38205,38206,38207,38208,38221,38248,38249,38250,38263,38290,
   38291,38304,38331,38344,38383,39151,39152,39153,39166,39193,
   39194,39207,39234,39247,39286,40054,40055,40068,40095,40108,
   40147,40915,40928,40967,41747],
 [90,94,107,1291,1306,1336,1349,1377,1391,1432,1472,1511,5645,
   5646,5662,5689,5690,5691,5692,5705,5747,5774,5788,5828,5867,
   38205,38206,38207,38208,38221,38248,38249,38250,38263,38290,
   38291,38304,38331,38344,38383,39151,39152,39153,39166,39193,
   39194,39207,39234,39247,39286,40054,40055,40068,40095,40108,
   40147,40915,40928,40967,41747],[],[],
 [1625,3507,3520,3836,38497],[1658,38530],
 [1291,1306,1424,1426,1432,1437,1439,1698,1761,38296,38298,
   38304,38309,38311,38557,38563,38568,38570,38628,38633,38635,
   38804,38806,38921,41141,41147,41152,41154,41212,41217,41219,
   41388,41390,41505,45888,45893,45895,46064,46066,46181,47088,
   47090,47205,49565],[],
 [1291,1306,1424,1426,1432,1437,1439,1698,1761,38296,38298,
   38304,38309,38311,38557,38563,38568,38570,38628,38633,38635,
   38804,38806,38921,41141,41147,41152,41154,41212,41217,41219,
   41388,41390,41505,45888,45893,45895,46064,46066,46181,47088,
   47090,47205,49565],[],[],[],[1887,38759],
 [1915,38787],[],[1658,38530],[],
 [1625,3507,3520,3836,38497],[2033,38905],
 [1291,1306,1424,1426,1432,1437,1439,1698,1761,38296,38298,
   38304,38309,38311,38557,38563,38568,38570,38628,38633,38635,
   38804,38806,38921,41141,41147,41152,41154,41212,41217,41219,
   41388,41390,41505,45888,45893,45895,46064,46066,46181,47088,
   47090,47205,49565],[],
 [1291,1306,1424,1426,1432,1437,1439,1698,1761,38296,38298,
   38304,38309,38311,38557,38563,38568,38570,38628,38633,38635,
   38804,38806,38921,41141,41147,41152,41154,41212,41217,41219,
   41388,41390,41505,45888,45893,45895,46064,46066,46181,47088,
   47090,47205,49565],[],[],[39015],[39015],
 [2033,38905],[1887,38759],[1915,38787],[2215,39087],
 [2224,39096],[2224,39096],[2215,39087],[2254,39126],
 [2262,39134],[2268,39140],[2270,39142],[2254,39126],
 [2270,39142],[2262,39134],[2268,39140],
 [90,94,107,1291,1306,1336,1349,1377,1391,1432,1472,1511,5645,
   5646,5662,5689,5690,5691,5692,5705,5747,5774,5788,5828,5867,
   38205,38206,38207,38208,38221,38248,38249,38250,38263,38290,
   38291,38304,38331,38344,38383,39151,39152,39153,39166,39193,
   39194,39207,39234,39247,39286,40054,40055,40068,40095,40108,
   40147,40915,40928,40967,41747],
 [90,94,107,1291,1306,1336,1349,1377,1391,1432,1472,1511,5645,
   5646,5662,5689,5690,5691,5692,5705,5747,5774,5788,5828,5867,
   38205,38206,38207,38208,38221,38248,38249,38250,38263,38290,
   38291,38304,38331,38344,38383,39151,39152,39153,39166,39193,
   39194,39207,39234,39247,39286,40054,40055,40068,40095,40108,
   40147,40915,40928,40967,41747],
 [90,94,107,1291,1306,1336,1349,1377,1391,1432,1472,1511,5645,
   5646,5662,5689,5690,5691,5692,5705,5747,5774,5788,5828,5867,
   38205,38206,38207,38208,38221,38248,38249,38250,38263,38290,
   38291,38304,38331,38344,38383,39151,39152,39153,39166,39193,
   39194,39207,39234,39247,39286,40054,40055,40068,40095,40108,
   40147,40915,40928,40967,41747],[],
 [1336,39274,39275,39313,42515],[1336,39274,39275,39313,42515],
 [1336,1625,1761,39276,39280,39289,39291,39391,39400,39402,39534,
   39536,39779,42593,42602,42604,42736,42738,42981,44735,44737,
   44980,47160],
 [1336,1658,1698,39277,39278,39287,39293,39424,39433,39439,39467,
   39473,39734,42626,42635,42641,42669,42675,42936,45263,45269,
   45530,46091],
 [1336,1658,1698,39277,39278,39287,39293,39424,39433,39439,39467,
   39473,39734,42626,42635,42641,42669,42675,42936,45263,45269,
   45530,46091],[1336,39279],
 [1336,1625,1761,39276,39280,39289,39291,39391,39400,39402,39534,
   39536,39779,42593,42602,42604,42736,42738,42981,44735,44737,
   44980,47160],[1336,39281,39283,39559,42761],[1336,39282],
 [1336,39281,39283,39559,42761],
 [1336,1887,39284,39299,39662,42864],
 [1336,1915,39285,39300,39690,42892],
 [1336,5692,5705,5867,39286],
 [1336,1658,1698,39277,39278,39287,39293,39424,39433,39439,39467,
   39473,39734,42626,42635,42641,42669,42675,42936,45263,45269,
   45530,46091],[1336,39288],
 [1336,1625,1761,39276,39280,39289,39291,39391,39400,39402,39534,
   39536,39779,42593,42602,42604,42736,42738,42981,44735,44737,
   44980,47160],[1336,2033,39290,39298,39808,43010],
 [1336,1625,1761,39276,39280,39289,39291,39391,39400,39402,39534,
   39536,39779,42593,42602,42604,42736,42738,42981,44735,44737,
   44980,47160],[1336,39292],
 [1336,1658,1698,39277,39278,39287,39293,39424,39433,39439,39467,
   39473,39734,42626,42635,42641,42669,42675,42936,45263,45269,
   45530,46091],[1336,39294],[1336,39295,39297,39902,43104],
 [1336,39296],[1336,39295,39297,39902,43104],
 [1336,2033,39290,39298,39808,43010],
 [1336,1887,39284,39299,39662,42864],
 [1336,1915,39285,39300,39690,42892],
 [1336,2215,39301,39304,39990,43192],
 [1336,2224,39302,39303,39999,43201],
 [1336,2224,39302,39303,39999,43201],
 [1336,2215,39301,39304,39990,43192],
 [1336,2254,39305,39309,40029,43231],
 [1336,2262,39306,39311,40037,43239],
 [1336,2268,39307,39312,40043,43245],
 [1336,2270,39308,39310,40045,43247],
 [1336,2254,39305,39309,40029,43231],
 [1336,2270,39308,39310,40045,43247],
 [1336,2262,39306,39311,40037,43239],
 [1336,2268,39307,39312,40043,43245],
 [90,94,107,1291,1306,1336,1349,1377,1391,1432,1472,1511,5645,
   5646,5662,5689,5690,5691,5692,5705,5747,5774,5788,5828,5867,
   38205,38206,38207,38208,38221,38248,38249,38250,38263,38290,
   38291,38304,38331,38344,38383,39151,39152,39153,39166,39193,
   39194,39207,39234,39247,39286,40054,40055,40068,40095,40108,
   40147,40915,40928,40967,41747],[],
 [90,94,107,1291,1306,1336,1349,1377,1391,1432,1472,1511,5645,
   5646,5662,5689,5690,5691,5692,5705,5747,5774,5788,5828,5867,
   38205,38206,38207,38208,38221,38248,38249,38250,38263,38290,
   38291,38304,38331,38344,38383,39151,39152,39153,39166,39193,
   39194,39207,39234,39247,39286,40054,40055,40068,40095,40108,
   40147,40915,40928,40967,41747],[1377,40096],[1377,40097],
 [1377,1625,1698,40098,40100,40111,40115,40250,40261,40265,40330,
   40334,40642,41850,41861,41865,41930,41934,42242,44670,44674,
   44982,46138],
 [1377,1658,1761,7813,7818,7821,7828,7832,7899,7902,7909,7913,
   8087,8094,8098,8193,8197,8393,40099,40102,40109,40113,40287,
   40294,40298,40393,40397,40593,41887,41894,41898,41993,41997,
   42193,45328,45332,45528,47113],
 [1377,1625,1698,40098,40100,40111,40115,40250,40261,40265,40330,
   40334,40642,41850,41861,41865,41930,41934,42242,44670,44674,
   44982,46138],[1377,40101],
 [1377,1658,1761,7813,7818,7821,7828,7832,7899,7902,7909,7913,
   8087,8094,8098,8193,8197,8393,40099,40102,40109,40113,40287,
   40294,40298,40393,40397,40593,41887,41894,41898,41993,41997,
   42193,45328,45332,45528,47113],
 [1377,1798,40103,40119,40434,42034],
 [1377,1827,1855,40104,40105,40117,40118,40450,40462,40463,40491,
   40492,40762,42050,42062,42063,42091,42092,42362,47911,47912,
   48182,48588],
 [1377,1827,1855,40104,40105,40117,40118,40450,40462,40463,40491,
   40492,40762,42050,42062,42063,42091,42092,42362,47911,47912,
   48182,48588],
 [1377,1887,1915,40106,40107,40121,40122,40509,40523,40524,40550,
   40551,40824,42109,42123,42124,42150,42151,42424,48754,48755,
   49028,49379],
 [1377,1887,1915,40106,40107,40121,40122,40509,40523,40524,40550,
   40551,40824,42109,42123,42124,42150,42151,42424,48754,48755,
   49028,49379],[1377,40108],
 [1377,1658,1761,7813,7818,7821,7828,7832,7899,7902,7909,7913,
   8087,8094,8098,8193,8197,8393,40099,40102,40109,40113,40287,
   40294,40298,40393,40397,40593,41887,41894,41898,41993,41997,
   42193,45328,45332,45528,47113],
 [1377,1984,40110,40116,40620,42220],
 [1377,1625,1698,40098,40100,40111,40115,40250,40261,40265,40330,
   40334,40642,41850,41861,41865,41930,41934,42242,44670,44674,
   44982,46138],[1377,2033,40112,40120,40669,42269],
 [1377,1658,1761,7813,7818,7821,7828,7832,7899,7902,7909,7913,
   8087,8094,8098,8193,8197,8393,40099,40102,40109,40113,40287,
   40294,40298,40393,40397,40593,41887,41894,41898,41993,41997,
   42193,45328,45332,45528,47113],[1377,40114],
 [1377,1625,1698,40098,40100,40111,40115,40250,40261,40265,40330,
   40334,40642,41850,41861,41865,41930,41934,42242,44670,44674,
   44982,46138],[1377,1984,40110,40116,40620,42220],
 [1377,1827,1855,40104,40105,40117,40118,40450,40462,40463,40491,
   40492,40762,42050,42062,42063,42091,42092,42362,47911,47912,
   48182,48588],
 [1377,1827,1855,40104,40105,40117,40118,40450,40462,40463,40491,
   40492,40762,42050,42062,42063,42091,42092,42362,47911,47912,
   48182,48588],[1377,1798,40103,40119,40434,42034],
 [1377,2033,40112,40120,40669,42269],
 [1377,1887,1915,40106,40107,40121,40122,40509,40523,40524,40550,
   40551,40824,42109,42123,42124,42150,42151,42424,48754,48755,
   49028,49379],
 [1377,1887,1915,40106,40107,40121,40122,40509,40523,40524,40550,
   40551,40824,42109,42123,42124,42150,42151,42424,48754,48755,
   49028,49379],
 [1377,2215,2224,40123,40124,40125,40126,40849,40850,40851,40860,
   40861,40870,42449,42450,42451,42460,42461,42470,52175,52176,
   52185,52230],
 [1377,2215,2224,40123,40124,40125,40126,40849,40850,40851,40860,
   40861,40870,42449,42450,42451,42460,42461,42470,52175,52176,
   52185,52230],
 [1377,2215,2224,40123,40124,40125,40126,40849,40850,40851,40860,
   40861,40870,42449,42450,42451,42460,42461,42470,52175,52176,
   52185,52230],
 [1377,2215,2224,40123,40124,40125,40126,40849,40850,40851,40860,
   40861,40870,42449,42450,42451,42460,42461,42470,52175,52176,
   52185,52230],[1377,2254,40127,40131,40890,42490],
 [1377,2262,2268,40128,40129,40133,40134,40894,40898,40899,40903,
   40904,40914,42494,42498,42499,42503,42504,42514,52363,52364,
   52374,52384],
 [1377,2262,2268,40128,40129,40133,40134,40894,40898,40899,40903,
   40904,40914,42494,42498,42499,42503,42504,42514,52363,52364,
   52374,52384],[1377,2270,40130,40132,40906,42506],
 [1377,2254,40127,40131,40890,42490],
 [1377,2270,40130,40132,40906,42506],
 [1377,2262,2268,40128,40129,40133,40134,40894,40898,40899,40903,
   40904,40914,42494,42498,42499,42503,42504,42514,52363,52364,
   52374,52384],
 [1377,2262,2268,40128,40129,40133,40134,40894,40898,40899,40903,
   40904,40914,42494,42498,42499,42503,42504,42514,52363,52364,
   52374,52384],
 [90,94,107,1291,1306,1336,1349,1377,1391,1432,1472,1511,5645,
   5646,5662,5689,5690,5691,5692,5705,5747,5774,5788,5828,5867,
   38205,38206,38207,38208,38221,38248,38249,38250,38263,38290,
   38291,38304,38331,38344,38383,39151,39152,39153,39166,39193,
   39194,39207,39234,39247,39286,40054,40055,40068,40095,40108,
   40147,40915,40928,40967,41747],
 [90,94,107,1291,1306,1336,1349,1377,1391,1432,1472,1511,5645,
   5646,5662,5689,5690,5691,5692,5705,5747,5774,5788,5828,5867,
   38205,38206,38207,38208,38221,38248,38249,38250,38263,38290,
   38291,38304,38331,38344,38383,39151,39152,39153,39166,39193,
   39194,39207,39234,39247,39286,40054,40055,40068,40095,40108,
   40147,40915,40928,40967,41747],[],[],
 [23,31,44,1291,1296,1297,1306,1307,1309,1432,1625,1658,3502,
   3507,3508,3517,3518,3520,3633,3634,3824,3833,3834,3836,4139,
   38294,38295,38304,38305,38307,38485,38494,38495,38497,38529,
   38530,38532,38800,38802,38827,41069,41078,41079,41081,41113,
   41114,41116,41384,41386,41411,44633,44634,44636,44904,44906,
   44931,45499,45501,45526,49471],
 [23,31,44,1291,1296,1297,1306,1307,1309,1432,1625,1658,3502,
   3507,3508,3517,3518,3520,3633,3634,3824,3833,3834,3836,4139,
   38294,38295,38304,38305,38307,38485,38494,38495,38497,38529,
   38530,38532,38800,38802,38827,41069,41078,41079,41081,41113,
   41114,41116,41384,41386,41411,44633,44634,44636,44904,44906,
   44931,45499,45501,45526,49471],[1698,41154],[],
 [1761,41217],[41239],[41239],[],[1887,41343],
 [1915,41371],[],
 [23,31,44,1291,1296,1297,1306,1307,1309,1432,1625,1658,3502,
   3507,3508,3517,3518,3520,3633,3634,3824,3833,3834,3836,4139,
   38294,38295,38304,38305,38307,38485,38494,38495,38497,38529,
   38530,38532,38800,38802,38827,41069,41078,41079,41081,41113,
   41114,41116,41384,41386,41411,44633,44634,44636,44904,44906,
   44931,45499,45501,45526,49471],[],
 [23,31,44,1291,1296,1297,1306,1307,1309,1432,1625,1658,3502,
   3507,3508,3517,3518,3520,3633,3634,3824,3833,3834,3836,4139,
   38294,38295,38304,38305,38307,38485,38494,38495,38497,38529,
   38530,38532,38800,38802,38827,41069,41078,41079,41081,41113,
   41114,41116,41384,41386,41411,44633,44634,44636,44904,44906,
   44931,45499,45501,45526,49471],[2033,41489],[1761,41217],
 [],[1698,41154],[],[],[],[],[2033,41489],
 [1887,41343],[1915,41371],[2215,41671],[2224,41680],
 [2224,41680],[2215,41671],[2254,41710],[2262,41718],
 [2268,41724],[2270,41726],[2254,41710],[2270,41726],
 [2262,41718],[2268,41724],
 [90,94,107,1291,1306,1336,1349,1377,1391,1432,1472,1511,5645,
   5646,5662,5689,5690,5691,5692,5705,5747,5774,5788,5828,5867,
   38205,38206,38207,38208,38221,38248,38249,38250,38263,38290,
   38291,38304,38331,38344,38383,39151,39152,39153,39166,39193,
   39194,39207,39234,39247,39286,40054,40055,40068,40095,40108,
   40147,40915,40928,40967,41747],[1377,40096],[1377,40097],
 [1377,1625,1698,40098,40100,40111,40115,40250,40261,40265,40330,
   40334,40642,41850,41861,41865,41930,41934,42242,44670,44674,
   44982,46138],
 [1377,1658,1761,7813,7818,7821,7828,7832,7899,7902,7909,7913,
   8087,8094,8098,8193,8197,8393,40099,40102,40109,40113,40287,
   40294,40298,40393,40397,40593,41887,41894,41898,41993,41997,
   42193,45328,45332,45528,47113],
 [1377,1625,1698,40098,40100,40111,40115,40250,40261,40265,40330,
   40334,40642,41850,41861,41865,41930,41934,42242,44670,44674,
   44982,46138],[1377,40101],
 [1377,1658,1761,7813,7818,7821,7828,7832,7899,7902,7909,7913,
   8087,8094,8098,8193,8197,8393,40099,40102,40109,40113,40287,
   40294,40298,40393,40397,40593,41887,41894,41898,41993,41997,
   42193,45328,45332,45528,47113],
 [1377,1798,40103,40119,40434,42034],
 [1377,1827,1855,40104,40105,40117,40118,40450,40462,40463,40491,
   40492,40762,42050,42062,42063,42091,42092,42362,47911,47912,
   48182,48588],
 [1377,1827,1855,40104,40105,40117,40118,40450,40462,40463,40491,
   40492,40762,42050,42062,42063,42091,42092,42362,47911,47912,
   48182,48588],
 [1377,1887,1915,40106,40107,40121,40122,40509,40523,40524,40550,
   40551,40824,42109,42123,42124,42150,42151,42424,48754,48755,
   49028,49379],
 [1377,1887,1915,40106,40107,40121,40122,40509,40523,40524,40550,
   40551,40824,42109,42123,42124,42150,42151,42424,48754,48755,
   49028,49379],[1377,40108],
 [1377,1658,1761,7813,7818,7821,7828,7832,7899,7902,7909,7913,
   8087,8094,8098,8193,8197,8393,40099,40102,40109,40113,40287,
   40294,40298,40393,40397,40593,41887,41894,41898,41993,41997,
   42193,45328,45332,45528,47113],
 [1377,1984,40110,40116,40620,42220],
 [1377,1625,1698,40098,40100,40111,40115,40250,40261,40265,40330,
   40334,40642,41850,41861,41865,41930,41934,42242,44670,44674,
   44982,46138],[1377,2033,40112,40120,40669,42269],
 [1377,1658,1761,7813,7818,7821,7828,7832,7899,7902,7909,7913,
   8087,8094,8098,8193,8197,8393,40099,40102,40109,40113,40287,
   40294,40298,40393,40397,40593,41887,41894,41898,41993,41997,
   42193,45328,45332,45528,47113],[1377,40114],
 [1377,1625,1698,40098,40100,40111,40115,40250,40261,40265,40330,
   40334,40642,41850,41861,41865,41930,41934,42242,44670,44674,
   44982,46138],[1377,1984,40110,40116,40620,42220],
 [1377,1827,1855,40104,40105,40117,40118,40450,40462,40463,40491,
   40492,40762,42050,42062,42063,42091,42092,42362,47911,47912,
   48182,48588],
 [1377,1827,1855,40104,40105,40117,40118,40450,40462,40463,40491,
   40492,40762,42050,42062,42063,42091,42092,42362,47911,47912,
   48182,48588],[1377,1798,40103,40119,40434,42034],
 [1377,2033,40112,40120,40669,42269],
 [1377,1887,1915,40106,40107,40121,40122,40509,40523,40524,40550,
   40551,40824,42109,42123,42124,42150,42151,42424,48754,48755,
   49028,49379],
 [1377,1887,1915,40106,40107,40121,40122,40509,40523,40524,40550,
   40551,40824,42109,42123,42124,42150,42151,42424,48754,48755,
   49028,49379],
 [1377,2215,2224,40123,40124,40125,40126,40849,40850,40851,40860,
   40861,40870,42449,42450,42451,42460,42461,42470,52175,52176,
   52185,52230],
 [1377,2215,2224,40123,40124,40125,40126,40849,40850,40851,40860,
   40861,40870,42449,42450,42451,42460,42461,42470,52175,52176,
   52185,52230],
 [1377,2215,2224,40123,40124,40125,40126,40849,40850,40851,40860,
   40861,40870,42449,42450,42451,42460,42461,42470,52175,52176,
   52185,52230],
 [1377,2215,2224,40123,40124,40125,40126,40849,40850,40851,40860,
   40861,40870,42449,42450,42451,42460,42461,42470,52175,52176,
   52185,52230],[1377,2254,40127,40131,40890,42490],
 [1377,2262,2268,40128,40129,40133,40134,40894,40898,40899,40903,
   40904,40914,42494,42498,42499,42503,42504,42514,52363,52364,
   52374,52384],
 [1377,2262,2268,40128,40129,40133,40134,40894,40898,40899,40903,
   40904,40914,42494,42498,42499,42503,42504,42514,52363,52364,
   52374,52384],[1377,2270,40130,40132,40906,42506],
 [1377,2254,40127,40131,40890,42490],
 [1377,2270,40130,40132,40906,42506],
 [1377,2262,2268,40128,40129,40133,40134,40894,40898,40899,40903,
   40904,40914,42494,42498,42499,42503,42504,42514,52363,52364,
   52374,52384],
 [1377,2262,2268,40128,40129,40133,40134,40894,40898,40899,40903,
   40904,40914,42494,42498,42499,42503,42504,42514,52363,52364,
   52374,52384],[1336,39274,39275,39313,42515],
 [1336,39274,39275,39313,42515],
 [1336,1625,1761,39276,39280,39289,39291,39391,39400,39402,39534,
   39536,39779,42593,42602,42604,42736,42738,42981,44735,44737,
   44980,47160],
 [1336,1658,1698,39277,39278,39287,39293,39424,39433,39439,39467,
   39473,39734,42626,42635,42641,42669,42675,42936,45263,45269,
   45530,46091],
 [1336,1658,1698,39277,39278,39287,39293,39424,39433,39439,39467,
   39473,39734,42626,42635,42641,42669,42675,42936,45263,45269,
   45530,46091],[1336,39279],
 [1336,1625,1761,39276,39280,39289,39291,39391,39400,39402,39534,
   39536,39779,42593,42602,42604,42736,42738,42981,44735,44737,
   44980,47160],[1336,39281,39283,39559,42761],[1336,39282],
 [1336,39281,39283,39559,42761],
 [1336,1887,39284,39299,39662,42864],
 [1336,1915,39285,39300,39690,42892],
 [1336,5692,5705,5867,39286],
 [1336,1658,1698,39277,39278,39287,39293,39424,39433,39439,39467,
   39473,39734,42626,42635,42641,42669,42675,42936,45263,45269,
   45530,46091],[1336,39288],
 [1336,1625,1761,39276,39280,39289,39291,39391,39400,39402,39534,
   39536,39779,42593,42602,42604,42736,42738,42981,44735,44737,
   44980,47160],[1336,2033,39290,39298,39808,43010],
 [1336,1625,1761,39276,39280,39289,39291,39391,39400,39402,39534,
   39536,39779,42593,42602,42604,42736,42738,42981,44735,44737,
   44980,47160],[1336,39292],
 [1336,1658,1698,39277,39278,39287,39293,39424,39433,39439,39467,
   39473,39734,42626,42635,42641,42669,42675,42936,45263,45269,
   45530,46091],[1336,39294],[1336,39295,39297,39902,43104],
 [1336,39296],[1336,39295,39297,39902,43104],
 [1336,2033,39290,39298,39808,43010],
 [1336,1887,39284,39299,39662,42864],
 [1336,1915,39285,39300,39690,42892],
 [1336,2215,39301,39304,39990,43192],
 [1336,2224,39302,39303,39999,43201],
 [1336,2224,39302,39303,39999,43201],
 [1336,2215,39301,39304,39990,43192],
 [1336,2254,39305,39309,40029,43231],
 [1336,2262,39306,39311,40037,43239],
 [1336,2268,39307,39312,40043,43245],
 [1336,2270,39308,39310,40045,43247],
 [1336,2254,39305,39309,40029,43231],
 [1336,2270,39308,39310,40045,43247],
 [1336,2262,39306,39311,40037,43239],
 [1336,2268,39307,39312,40043,43245],
 [1336,39274,39275,39313,42515],[1625,43305,43308,43685,44981],
 [1551,1658,1719,43330,43332,43338,43339,43399,43405,43406,43468,
   43469,43634,45290,45296,45297,45359,45360,45525,46448,46449,
   46614,47575],[1698,43378],
 [1551,1658,1719,43330,43332,43338,43339,43399,43405,43406,43468,
   43469,43634,45290,45296,45297,45359,45360,45525,46448,46449,
   46614,47575],[1761,43441],
 [1551,1658,1719,43330,43332,43338,43339,43399,43405,43406,43468,
   43469,43634,45290,45296,45297,45359,45360,45525,46448,46449,
   46614,47575],[3756],[],[1887,43567],[1915,43595],[],
 [1551,1658,1719,43330,43332,43338,43339,43399,43405,43406,43468,
   43469,43634,45290,45296,45297,45359,45360,45525,46448,46449,
   46614,47575],[],[1625,43305,43308,43685,44981],
 [2033,43713],[1761,43441],[1625,43305,43308,43685,44981],
 [1698,43378],[],[],[],[],[2033,43713],[1887,43567],
 [1915,43595],[2215,43895],[2224,43904],[2224,43904],
 [2215,43895],[2254,43934],[2262,43942],[2268,43948],
 [2270,43950],[2254,43934],[2270,43950],[2262,43942],
 [2268,43948],[1625,43971],[1583,1658,44000,44004,44193,45418]
  ,[1698,44030,44044,44077,45863],
 [1698,44030,44044,44077,45863],[1761,44107,44108,44394,47204],
 [],[],[],[1887,44233],[1915,44261],[],
 [1583,1658,44000,44004,44193,45418],[],[1625,43971],
 [2033,44379],[1761,44107,44108,44394,47204],
 [1761,44107,44108,44394,47204],[1698,44030,44044,44077,45863],
 [],[],[8032],
 [1336,1337,1338,1343,1358,1360,1499,1500,1505,1520,1522,1538,
   1543,1558,1560,1580,1595,1765,1767,2127,39274,39275,39280,
   39295,39297,39313,39318,39333,39335,39355,39370,39372,39540,
   39542,39902,42515,42520,42535,42537,42557,42572,42574,42742,
   42744,43104,43260,43275,43277,43445,43447,43807,44111,44113,
   44473,47283],[2033,44379],[1887,44233],[1915,44261],
 [2215,44561],[2224,44570],[2224,44570],[2215,44561],
 [2254,44600],[2262,44608],[2268,44614],[2270,44616],
 [2254,44600],[2270,44616],[2262,44608],[2268,44614],
 [23,31,44,1291,1296,1297,1306,1307,1309,1432,1625,1658,3502,
   3507,3508,3517,3518,3520,3633,3634,3824,3833,3834,3836,4139,
   38294,38295,38304,38305,38307,38485,38494,38495,38497,38529,
   38530,38532,38800,38802,38827,41069,41078,41079,41081,41113,
   41114,41116,41384,41386,41411,44633,44634,44636,44904,44906,
   44931,45499,45501,45526,49471],
 [1377,1625,1698,40098,40100,40111,40115,40250,40261,40265,40330,
   40334,40642,41850,41861,41865,41930,41934,42242,44670,44674,
   44982,46138],[1625,44703],
 [1336,1625,1761,39276,39280,39289,39291,39391,39400,39402,39534,
   39536,39779,42593,42602,42604,42736,42738,42981,44735,44737,
   44980,47160],[1625,44766],[1625,44795,44796,44955,48035],
 [1625,44825],[1625,1887,44853,44863,44988,48852],
 [1625,1915,44880,44891,44989,49204],
 [23,31,44,1291,1296,1297,1306,1307,1309,1432,1625,1658,3502,
   3507,3508,3517,3518,3520,3633,3634,3824,3833,3834,3836,4139,
   38294,38295,38304,38305,38307,38485,38494,38495,38497,38529,
   38530,38532,38800,38802,38827,41069,41078,41079,41081,41113,
   41114,41116,41384,41386,41411,44633,44634,44636,44904,44906,
   44931,45499,45501,45526,49471],
 [23,31,44,1291,1296,1297,1306,1307,1309,1432,1625,1658,3502,
   3507,3508,3517,3518,3520,3633,3634,3824,3833,3834,3836,4139,
   38294,38295,38304,38305,38307,38485,38494,38495,38497,38529,
   38530,38532,38800,38802,38827,41069,41078,41079,41081,41113,
   41114,41116,41384,41386,41411,44633,44634,44636,44904,44906,
   44931,45499,45501,45526,49471],
 [1625,44795,44796,44955,48035],[],
 [1625,2033,44979,44987,45009,50378],
 [1336,1625,1761,39276,39280,39289,39291,39391,39400,39402,39534,
   39536,39779,42593,42602,42604,42736,42738,42981,44735,44737,
   44980,47160],[1625,43305,43308,43685,44981],
 [1377,1625,1698,40098,40100,40111,40115,40250,40261,40265,40330,
   40334,40642,41850,41861,41865,41930,41934,42242,44670,44674,
   44982,46138],[1625,44983,44984,45084,50453],
 [1625,44983,44984,45084,50453],[1625,44985],[1625,44986],
 [1625,2033,44979,44987,45009,50378],
 [1625,1887,44853,44863,44988,48852],
 [1625,1915,44880,44891,44989,49204],
 [1625,2215,44990,44993,45191,50560],
 [1625,2224,44991,44992,45200,50569],
 [1625,2224,44991,44992,45200,50569],
 [1625,2215,44990,44993,45191,50560],
 [1625,2254,44994,44998,45230,50599],
 [1625,2262,44995,45000,45238,50607],
 [1625,2268,44996,45001,45244,50613],
 [1625,2270,44997,44999,45246,50615],
 [1625,2254,44994,44998,45230,50599],
 [1625,2270,44997,44999,45246,50615],
 [1625,2262,44995,45000,45238,50607],
 [1625,2268,44996,45001,45244,50613],
 [1336,1658,1698,39277,39278,39287,39293,39424,39433,39439,39467,
   39473,39734,42626,42635,42641,42669,42675,42936,45263,45269,
   45530,46091],
 [1551,1658,1719,43330,43332,43338,43339,43399,43405,43406,43468,
   43469,43634,45290,45296,45297,45359,45360,45525,46448,46449,
   46614,47575],
 [1377,1658,1761,7813,7818,7821,7828,7832,7899,7902,7909,7913,
   8087,8094,8098,8193,8197,8393,40099,40102,40109,40113,40287,
   40294,40298,40393,40397,40593,41887,41894,41898,41993,41997,
   42193,45328,45332,45528,47113],
 [1551,1658,1719,43330,43332,43338,43339,43399,43405,43406,43468,
   43469,43634,45290,45296,45297,45359,45360,45525,46448,46449,
   46614,47575],[1658,1823,45389,45394,45529,48014],
 [1583,1658,44000,44004,44193,45418],
 [1658,1887,2033,45446,45449,45457,45458,45527,45535,45536,45604,
   45605,45745,48796,48804,48805,48873,48874,49014,49849,49850,
   49990,50750],[1658,1915,45473,45486,45537,49157],
 [23,31,44,1291,1296,1297,1306,1307,1309,1432,1625,1658,3502,
   3507,3508,3517,3518,3520,3633,3634,3824,3833,3834,3836,4139,
   38294,38295,38304,38305,38307,38485,38494,38495,38497,38529,
   38530,38532,38800,38802,38827,41069,41078,41079,41081,41113,
   41114,41116,41384,41386,41411,44633,44634,44636,44904,44906,
   44931,45499,45501,45526,49471],[],
 [1551,1658,1719,43330,43332,43338,43339,43399,43405,43406,43468,
   43469,43634,45290,45296,45297,45359,45360,45525,46448,46449,
   46614,47575],
 [23,31,44,1291,1296,1297,1306,1307,1309,1432,1625,1658,3502,
   3507,3508,3517,3518,3520,3633,3634,3824,3833,3834,3836,4139,
   38294,38295,38304,38305,38307,38485,38494,38495,38497,38529,
   38530,38532,38800,38802,38827,41069,41078,41079,41081,41113,
   41114,41116,41384,41386,41411,44633,44634,44636,44904,44906,
   44931,45499,45501,45526,49471],
 [1658,1887,2033,45446,45449,45457,45458,45527,45535,45536,45604,
   45605,45745,48796,48804,48805,48873,48874,49014,49849,49850,
   49990,50750],
 [1377,1658,1761,7813,7818,7821,7828,7832,7899,7902,7909,7913,
   8087,8094,8098,8193,8197,8393,40099,40102,40109,40113,40287,
   40294,40298,40393,40397,40593,41887,41894,41898,41993,41997,
   42193,45328,45332,45528,47113],
 [1658,1823,45389,45394,45529,48014],
 [1336,1658,1698,39277,39278,39287,39293,39424,39433,39439,39467,
   39473,39734,42626,42635,42641,42669,42675,42936,45263,45269,
   45530,46091],[1658,45531],[1658,45532],[1658,45533],
 [1658,45534],
 [1658,1887,2033,45446,45449,45457,45458,45527,45535,45536,45604,
   45605,45745,48796,48804,48805,48873,48874,49014,49849,49850,
   49990,50750],
 [1658,1887,2033,45446,45449,45457,45458,45527,45535,45536,45604,
   45605,45745,48796,48804,48805,48873,48874,49014,49849,49850,
   49990,50750],[1658,1915,45473,45486,45537,49157],
 [1658,2215,45538,45541,45786,50031],
 [1658,2224,2254,45539,45540,45542,45546,45795,45797,45801,45806,
   45810,45825,50040,50042,50046,50051,50055,50070,52231,52235,
   52250,52286],
 [1658,2224,2254,45539,45540,45542,45546,45795,45797,45801,45806,
   45810,45825,50040,50042,50046,50051,50055,50070,52231,52235,
   52250,52286],[1658,2215,45538,45541,45786,50031],
 [1658,2224,2254,45539,45540,45542,45546,45795,45797,45801,45806,
   45810,45825,50040,50042,50046,50051,50055,50070,52231,52235,
   52250,52286],
 [1658,2262,2270,45543,45545,45547,45548,45830,45832,45833,45841,
   45842,45847,50075,50077,50078,50086,50087,50092,52366,52367,
   52372,52388],[1658,2268,45544,45549,45839,50084],
 [1658,2262,2270,45543,45545,45547,45548,45830,45832,45833,45841,
   45842,45847,50075,50077,50078,50086,50087,50092,52366,52367,
   52372,52388],
 [1658,2224,2254,45539,45540,45542,45546,45795,45797,45801,45806,
   45810,45825,50040,50042,50046,50051,50055,50070,52231,52235,
   52250,52286],
 [1658,2262,2270,45543,45545,45547,45548,45830,45832,45833,45841,
   45842,45847,50075,50077,50078,50086,50087,50092,52366,52367,
   52372,52388],
 [1658,2262,2270,45543,45545,45547,45548,45830,45832,45833,45841,
   45842,45847,50075,50077,50078,50086,50087,50092,52366,52367,
   52372,52388],[1658,2268,45544,45549,45839,50084],
 [1698,44030,44044,44077,45863],
 [1291,1306,1424,1426,1432,1437,1439,1698,1761,38296,38298,
   38304,38309,38311,38557,38563,38568,38570,38628,38633,38635,
   38804,38806,38921,41141,41147,41152,41154,41212,41217,41219,
   41388,41390,41505,45888,45893,45895,46064,46066,46181,47088,
   47090,47205,49565],[1698,45926],[1698,45956],
 [1698,45980,45985,46115,48445],
 [1698,1887,46013,46019,46226,48934],
 [1698,1915,46040,46047,46227,49286],
 [1291,1306,1424,1426,1432,1437,1439,1698,1761,38296,38298,
   38304,38309,38311,38557,38563,38568,38570,38628,38633,38635,
   38804,38806,38921,41141,41147,41152,41154,41212,41217,41219,
   41388,41390,41505,45888,45893,45895,46064,46066,46181,47088,
   47090,47205,49565],
 [1336,1658,1698,39277,39278,39287,39293,39424,39433,39439,39467,
   39473,39734,42626,42635,42641,42669,42675,42936,45263,45269,
   45530,46091],[1698,45980,45985,46115,48445],
 [1377,1625,1698,40098,40100,40111,40115,40250,40261,40265,40330,
   40334,40642,41850,41861,41865,41930,41934,42242,44670,44674,
   44982,46138],[1698,2033,46160,46165,46225,50669],
 [1291,1306,1424,1426,1432,1437,1439,1698,1761,38296,38298,
   38304,38309,38311,38557,38563,38568,38570,38628,38633,38635,
   38804,38806,38921,41141,41147,41152,41154,41212,41217,41219,
   41388,41390,41505,45888,45893,45895,46064,46066,46181,47088,
   47090,47205,49565],[1698,46201],[],
 [1698,46221,46223,46241,51256],[1698,46222],
 [1698,46221,46223,46241,51256],[1698,46224],
 [1698,2033,46160,46165,46225,50669],
 [1698,1887,46013,46019,46226,48934],
 [1698,1915,46040,46047,46227,49286],
 [1698,2215,46228,46231,46347,51362],
 [1698,2224,46229,46230,46356,51371],
 [1698,2224,46229,46230,46356,51371],
 [1698,2215,46228,46231,46347,51362],
 [1698,2254,46232,46236,46386,51401],
 [1698,2262,46233,46238,46394,51409],
 [1698,2268,46234,46239,46400,51415],
 [1698,2270,46235,46237,46402,51417],
 [1698,2254,46232,46236,46386,51401],
 [1698,2270,46235,46237,46402,51417],
 [1698,2262,46233,46238,46394,51409],
 [1698,2268,46234,46239,46400,51415],[1761,46421],[],[],
 [],[1887,46547],[1915,46575],[46593],
 [1551,1658,1719,43330,43332,43338,43339,43399,43405,43406,43468,
   43469,43634,45290,45296,45297,45359,45360,45525,46448,46449,
   46614,47575],
 [1551,1658,1719,43330,43332,43338,43339,43399,43405,43406,43468,
   43469,43634,45290,45296,45297,45359,45360,45525,46448,46449,
   46614,47575],[1625,44703],[2033,46693],[1761,46421],
 [46593],[1698,44030,44044,44077,45863],[8168],[],[],
 [],[2033,46693],[1887,46547],[1915,46575],[2215,46875],
 [2224,46884],[2224,46884],[2215,46875],[2254,46914],
 [2262,46922],[2268,46928],[2270,46930],[2254,46914],
 [2270,46930],[2262,46922],[2268,46928],[1761,46948],
 [1761,46978],[1761,47007],[1761,1887,47035,47043,47211,48895]
  ,[1761,1915,2033,47061,47062,47069,47071,47182,47189,47191,
   47210,47212,47331,49217,49224,49226,49245,49247,49366,50630,
   50632,50751,50961],
 [1291,1306,1424,1426,1432,1437,1439,1698,1761,38296,38298,
   38304,38309,38311,38557,38563,38568,38570,38628,38633,38635,
   38804,38806,38921,41141,41147,41152,41154,41212,41217,41219,
   41388,41390,41505,45888,45893,45895,46064,46066,46181,47088,
   47090,47205,49565],
 [1377,1658,1761,7813,7818,7821,7828,7832,7899,7902,7909,7913,
   8087,8094,8098,8193,8197,8393,40099,40102,40109,40113,40287,
   40294,40298,40393,40397,40593,41887,41894,41898,41993,41997,
   42193,45328,45332,45528,47113],[1761,47137],
 [1336,1625,1761,39276,39280,39289,39291,39391,39400,39402,39534,
   39536,39779,42593,42602,42604,42736,42738,42981,44735,44737,
   44980,47160],
 [1761,1915,2033,47061,47062,47069,47071,47182,47189,47191,47210,
   47212,47331,49217,49224,49226,49245,49247,49366,50630,50632,
   50751,50961],[],[1761,44107,44108,44394,47204],
 [1291,1306,1424,1426,1432,1437,1439,1698,1761,38296,38298,
   38304,38309,38311,38557,38563,38568,38570,38628,38633,38635,
   38804,38806,38921,41141,41147,41152,41154,41212,41217,41219,
   41388,41390,41505,45888,45893,45895,46064,46066,46181,47088,
   47090,47205,49565],[1761,47206,47209,47266,50896],
 [1761,47207],[1761,47208],[1761,47206,47209,47266,50896],
 [1761,1915,2033,47061,47062,47069,47071,47182,47189,47191,47210,
   47212,47331,49217,49224,49226,49245,49247,49366,50630,50632,
   50751,50961],[1761,1887,47035,47043,47211,48895],
 [1761,1915,2033,47061,47062,47069,47071,47182,47189,47191,47210,
   47212,47331,49217,49224,49226,49245,49247,49366,50630,50632,
   50751,50961],
 [1761,2215,2254,47213,47216,47217,47221,47371,47372,47376,47399,
   47403,47410,51001,51002,51006,51029,51033,51040,52194,52198,
   52205,52314],[1761,2224,47214,47215,47380,51010],
 [1761,2224,47214,47215,47380,51010],
 [1761,2215,2254,47213,47216,47217,47221,47371,47372,47376,47399,
   47403,47410,51001,51002,51006,51029,51033,51040,52194,52198,
   52205,52314],
 [1761,2215,2254,47213,47216,47217,47221,47371,47372,47376,47399,
   47403,47410,51001,51002,51006,51029,51033,51040,52194,52198,
   52205,52314],[1761,2262,47218,47223,47418,51048],
 [1761,2268,2270,47219,47220,47222,47224,47420,47422,47424,47426,
   47428,47433,51050,51052,51054,51056,51058,51063,52376,52378,
   52383,52389],
 [1761,2268,2270,47219,47220,47222,47224,47420,47422,47424,47426,
   47428,47433,51050,51052,51054,51056,51058,51063,52376,52378,
   52383,52389],
 [1761,2215,2254,47213,47216,47217,47221,47371,47372,47376,47399,
   47403,47410,51001,51002,51006,51029,51033,51040,52194,52198,
   52205,52314],
 [1761,2268,2270,47219,47220,47222,47224,47420,47422,47424,47426,
   47428,47433,51050,51052,51054,51056,51058,51063,52376,52378,
   52383,52389],[1761,2262,47218,47223,47418,51048],
 [1761,2268,2270,47219,47220,47222,47224,47420,47422,47424,47426,
   47428,47433,51050,51052,51054,51056,51058,51063,52376,52378,
   52383,52389],[41239],[1336,39281,39283,39559,42761],
 [1887,47508],[1915,47536],[],
 [1551,1658,1719,43330,43332,43338,43339,43399,43405,43406,43468,
   43469,43634,45290,45296,45297,45359,45360,45525,46448,46449,
   46614,47575],
 [1551,1658,1719,43330,43332,43338,43339,43399,43405,43406,43468,
   43469,43634,45290,45296,45297,45359,45360,45525,46448,46449,
   46614,47575],[1625,44766],[2033,47654],[1761,46948],
 [],[1698,45926],[],[6152],[],[],[2033,47654],
 [1887,47508],[1915,47536],[2215,47836],[2224,47845],
 [2224,47845],[2215,47836],[2254,47875],[2262,47883],
 [2268,47889],[2270,47891],[2254,47875],[2270,47891],
 [2262,47883],[2268,47889],
 [1377,1827,1855,40104,40105,40117,40118,40450,40462,40463,40491,
   40492,40762,42050,42062,42063,42091,42092,42362,47911,47912,
   48182,48588],[1887,47943],[1915,47971],[],
 [1658,1823,45389,45394,45529,48014],
 [1625,44795,44796,44955,48035],[1625,44795,44796,44955,48035],
 [2033,48089],[1761,46978],[],[1698,45956],[],
 [1377,1827,1855,40104,40105,40117,40118,40450,40462,40463,40491,
   40492,40762,42050,42062,42063,42091,42092,42362,47911,47912,
   48182,48588],[],[],[2033,48089],[1887,47943],
 [1915,47971],[2215,48271],[2224,48280],[2224,48280],
 [2215,48271],[2254,48310],[2262,48318],[2268,48324],
 [2270,48326],[2254,48310],[2270,48326],[2262,48318],
 [2268,48324],[1887,48349],[1915,48377],[],
 [1583,1658,44000,44004,44193,45418],
 [1698,45980,45985,46115,48445],[1625,44825],[2033,48495],
 [1761,47007],[],[1698,45980,45985,46115,48445],[],[],
 [1377,1827,1855,40104,40105,40117,40118,40450,40462,40463,40491,
   40492,40762,42050,42062,42063,42091,42092,42362,47911,47912,
   48182,48588],[6213],[2033,48495],[1887,48349],
 [1915,48377],[2215,48677],[2224,48686],[2224,48686],
 [2215,48677],[2254,48716],[2262,48724],[2268,48730],
 [2270,48732],[2254,48716],[2270,48732],[2262,48724],
 [2268,48730],
 [1377,1887,1915,40106,40107,40121,40122,40509,40523,40524,40550,
   40551,40824,42109,42123,42124,42150,42151,42424,48754,48755,
   49028,49379],[1887,48780],
 [1658,1887,2033,45446,45449,45457,45458,45527,45535,45536,45604,
   45605,45745,48796,48804,48805,48873,48874,49014,49849,49850,
   49990,50750],[1887,48829],
 [1625,1887,44853,44863,44988,48852],
 [1658,1887,2033,45446,45449,45457,45458,45527,45535,45536,45604,
   45605,45745,48796,48804,48805,48873,48874,49014,49849,49850,
   49990,50750],[1761,1887,47035,47043,47211,48895],
 [1887,48915],[1698,1887,46013,46019,46226,48934],
 [1887,48952],[1887,48969],[1887,48985],[1887,49000],
 [1658,1887,2033,45446,45449,45457,45458,45527,45535,45536,45604,
   45605,45745,48796,48804,48805,48873,48874,49014,49849,49850,
   49990,50750],[],
 [1377,1887,1915,40106,40107,40121,40122,40509,40523,40524,40550,
   40551,40824,42109,42123,42124,42150,42151,42424,48754,48755,
   49028,49379],[1887,2215,49029,49032,49055,52045],
 [1887,2224,49030,49031,49064,52054],
 [1887,2224,49030,49031,49064,52054],
 [1887,2215,49029,49032,49055,52045],
 [1887,2254,49033,49037,49094,52084],
 [1887,2262,49034,49039,49102,52092],
 [1887,2268,49035,49040,49108,52098],
 [1887,2270,49036,49038,49110,52100],
 [1887,2254,49033,49037,49094,52084],
 [1887,2270,49036,49038,49110,52100],
 [1887,2262,49034,49039,49102,52092],
 [1887,2268,49035,49040,49108,52098],[1915,49132],
 [1658,1915,45473,45486,45537,49157],[1915,49181],
 [1625,1915,44880,44891,44989,49204],
 [1761,1915,2033,47061,47062,47069,47071,47182,47189,47191,47210,
   47212,47331,49217,49224,49226,49245,49247,49366,50630,50632,
   50751,50961],
 [1761,1915,2033,47061,47062,47069,47071,47182,47189,47191,47210,
   47212,47331,49217,49224,49226,49245,49247,49366,50630,50632,
   50751,50961],[1915,49267],
 [1698,1915,46040,46047,46227,49286],[1915,49304],
 [1915,49321],[1915,49337],[1915,49352],
 [1761,1915,2033,47061,47062,47069,47071,47182,47189,47191,47210,
   47212,47331,49217,49224,49226,49245,49247,49366,50630,50632,
   50751,50961],
 [1377,1887,1915,40106,40107,40121,40122,40509,40523,40524,40550,
   40551,40824,42109,42123,42124,42150,42151,42424,48754,48755,
   49028,49379],[],[1915,2215,49392,49395,49406,52111],
 [1915,2224,49393,49394,49415,52120],
 [1915,2224,49393,49394,49415,52120],
 [1915,2215,49392,49395,49406,52111],
 [1915,2254,49396,49400,49445,52150],
 [1915,2262,49397,49402,49453,52158],
 [1915,2268,49398,49403,49459,52164],
 [1915,2270,49399,49401,49461,52166],
 [1915,2254,49396,49400,49445,52150],
 [1915,2270,49399,49401,49461,52166],
 [1915,2262,49397,49402,49453,52158],
 [1915,2268,49398,49403,49459,52164],
 [23,31,44,1291,1296,1297,1306,1307,1309,1432,1625,1658,3502,
   3507,3508,3517,3518,3520,3633,3634,3824,3833,3834,3836,4139,
   38294,38295,38304,38305,38307,38485,38494,38495,38497,38529,
   38530,38532,38800,38802,38827,41069,41078,41079,41081,41113,
   41114,41116,41384,41386,41411,44633,44634,44636,44904,44906,
   44931,45499,45501,45526,49471],[],
 [23,31,44,1291,1296,1297,1306,1307,1309,1432,1625,1658,3502,
   3507,3508,3517,3518,3520,3633,3634,3824,3833,3834,3836,4139,
   38294,38295,38304,38305,38307,38485,38494,38495,38497,38529,
   38530,38532,38800,38802,38827,41069,41078,41079,41081,41113,
   41114,41116,41384,41386,41411,44633,44634,44636,44904,44906,
   44931,45499,45501,45526,49471],[2033,49549],
 [1291,1306,1424,1426,1432,1437,1439,1698,1761,38296,38298,
   38304,38309,38311,38557,38563,38568,38570,38628,38633,38635,
   38804,38806,38921,41141,41147,41152,41154,41212,41217,41219,
   41388,41390,41505,45888,45893,45895,46064,46066,46181,47088,
   47090,47205,49565],[46593],
 [1291,1306,1424,1426,1432,1437,1439,1698,1761,38296,38298,
   38304,38309,38311,38557,38563,38568,38570,38628,38633,38635,
   38804,38806,38921,41141,41147,41152,41154,41212,41217,41219,
   41388,41390,41505,45888,45893,45895,46064,46066,46181,47088,
   47090,47205,49565],[],[],[],[],[2033,49549],
 [1887,48780],[1915,49132],[2215,49731],[2224,49740],
 [2224,49740],[2215,49731],[2254,49770],[2262,49778],
 [2268,49784],[2270,49786],[2254,49770],[2270,49786],
 [2262,49778],[2268,49784],
 [1551,1658,1719,43330,43332,43338,43339,43399,43405,43406,43468,
   43469,43634,45290,45296,45297,45359,45360,45525,46448,46449,
   46614,47575],
 [23,31,44,1291,1296,1297,1306,1307,1309,1432,1625,1658,3502,
   3507,3508,3517,3518,3520,3633,3634,3824,3833,3834,3836,4139,
   38294,38295,38304,38305,38307,38485,38494,38495,38497,38529,
   38530,38532,38800,38802,38827,41069,41078,41079,41081,41113,
   41114,41116,41384,41386,41411,44633,44634,44636,44904,44906,
   44931,45499,45501,45526,49471],
 [1658,1887,2033,45446,45449,45457,45458,45527,45535,45536,45604,
   45605,45745,48796,48804,48805,48873,48874,49014,49849,49850,
   49990,50750],
 [1377,1658,1761,7813,7818,7821,7828,7832,7899,7902,7909,7913,
   8087,8094,8098,8193,8197,8393,40099,40102,40109,40113,40287,
   40294,40298,40393,40397,40593,41887,41894,41898,41993,41997,
   42193,45328,45332,45528,47113],
 [1658,1823,45389,45394,45529,48014],
 [1336,1658,1698,39277,39278,39287,39293,39424,39433,39439,39467,
   39473,39734,42626,42635,42641,42669,42675,42936,45263,45269,
   45530,46091],[1658,45531],[1658,45532],[1658,45533],
 [1658,45534],
 [1658,1887,2033,45446,45449,45457,45458,45527,45535,45536,45604,
   45605,45745,48796,48804,48805,48873,48874,49014,49849,49850,
   49990,50750],
 [1658,1887,2033,45446,45449,45457,45458,45527,45535,45536,45604,
   45605,45745,48796,48804,48805,48873,48874,49014,49849,49850,
   49990,50750],[1658,1915,45473,45486,45537,49157],
 [1658,2215,45538,45541,45786,50031],
 [1658,2224,2254,45539,45540,45542,45546,45795,45797,45801,45806,
   45810,45825,50040,50042,50046,50051,50055,50070,52231,52235,
   52250,52286],
 [1658,2224,2254,45539,45540,45542,45546,45795,45797,45801,45806,
   45810,45825,50040,50042,50046,50051,50055,50070,52231,52235,
   52250,52286],[1658,2215,45538,45541,45786,50031],
 [1658,2224,2254,45539,45540,45542,45546,45795,45797,45801,45806,
   45810,45825,50040,50042,50046,50051,50055,50070,52231,52235,
   52250,52286],
 [1658,2262,2270,45543,45545,45547,45548,45830,45832,45833,45841,
   45842,45847,50075,50077,50078,50086,50087,50092,52366,52367,
   52372,52388],[1658,2268,45544,45549,45839,50084],
 [1658,2262,2270,45543,45545,45547,45548,45830,45832,45833,45841,
   45842,45847,50075,50077,50078,50086,50087,50092,52366,52367,
   52372,52388],
 [1658,2224,2254,45539,45540,45542,45546,45795,45797,45801,45806,
   45810,45825,50040,50042,50046,50051,50055,50070,52231,52235,
   52250,52286],
 [1658,2262,2270,45543,45545,45547,45548,45830,45832,45833,45841,
   45842,45847,50075,50077,50078,50086,50087,50092,52366,52367,
   52372,52388],
 [1658,2262,2270,45543,45545,45547,45548,45830,45832,45833,45841,
   45842,45847,50075,50077,50078,50086,50087,50092,52366,52367,
   52372,52388],[1658,2268,45544,45549,45839,50084],
 [1625,44795,44796,44955,48035],[2033,50125],[1761,47137],
 [4193],[1698,45980,45985,46115,48445],[],[],[],[],
 [2033,50125],[1887,48829],[1915,49181],[2215,50307],
 [2224,50316],[2224,50316],[2215,50307],[2254,50346],
 [2262,50354],[2268,50360],[2270,50362],[2254,50346],
 [2270,50362],[2262,50354],[2268,50360],
 [1625,2033,44979,44987,45009,50378],
 [1336,1625,1761,39276,39280,39289,39291,39391,39400,39402,39534,
   39536,39779,42593,42602,42604,42736,42738,42981,44735,44737,
   44980,47160],[1625,43305,43308,43685,44981],
 [1377,1625,1698,40098,40100,40111,40115,40250,40261,40265,40330,
   40334,40642,41850,41861,41865,41930,41934,42242,44670,44674,
   44982,46138],[1625,44983,44984,45084,50453],
 [1625,44983,44984,45084,50453],[1625,44985],[1625,44986],
 [1625,2033,44979,44987,45009,50378],
 [1625,1887,44853,44863,44988,48852],
 [1625,1915,44880,44891,44989,49204],
 [1625,2215,44990,44993,45191,50560],
 [1625,2224,44991,44992,45200,50569],
 [1625,2224,44991,44992,45200,50569],
 [1625,2215,44990,44993,45191,50560],
 [1625,2254,44994,44998,45230,50599],
 [1625,2262,44995,45000,45238,50607],
 [1625,2268,44996,45001,45244,50613],
 [1625,2270,44997,44999,45246,50615],
 [1625,2254,44994,44998,45230,50599],
 [1625,2270,44997,44999,45246,50615],
 [1625,2262,44995,45000,45238,50607],
 [1625,2268,44996,45001,45244,50613],
 [1761,1915,2033,47061,47062,47069,47071,47182,47189,47191,47210,
   47212,47331,49217,49224,49226,49245,49247,49366,50630,50632,
   50751,50961],[2033,50650],
 [1698,2033,46160,46165,46225,50669],[2033,50687],
 [2033,50704],[2033,50720],[2033,50735],[],
 [1658,1887,2033,45446,45449,45457,45458,45527,45535,45536,45604,
   45605,45745,48796,48804,48805,48873,48874,49014,49849,49850,
   49990,50750],
 [1761,1915,2033,47061,47062,47069,47071,47182,47189,47191,47210,
   47212,47331,49217,49224,49226,49245,49247,49366,50630,50632,
   50751,50961],[2033,2215,50752,50755,50791,51967],
 [2033,2224,50753,50754,50800,51976],
 [2033,2224,50753,50754,50800,51976],
 [2033,2215,50752,50755,50791,51967],
 [2033,2254,50756,50760,50830,52006],
 [2033,2262,50757,50762,50838,52014],
 [2033,2268,50758,50763,50844,52020],
 [2033,2270,50759,50761,50846,52022],
 [2033,2254,50756,50760,50830,52006],
 [2033,2270,50759,50761,50846,52022],
 [2033,2262,50757,50762,50838,52014],
 [2033,2268,50758,50763,50844,52020],
 [1761,44107,44108,44394,47204],
 [1291,1306,1424,1426,1432,1437,1439,1698,1761,38296,38298,
   38304,38309,38311,38557,38563,38568,38570,38628,38633,38635,
   38804,38806,38921,41141,41147,41152,41154,41212,41217,41219,
   41388,41390,41505,45888,45893,45895,46064,46066,46181,47088,
   47090,47205,49565],[1761,47206,47209,47266,50896],
 [1761,47207],[1761,47208],[1761,47206,47209,47266,50896],
 [1761,1915,2033,47061,47062,47069,47071,47182,47189,47191,47210,
   47212,47331,49217,49224,49226,49245,49247,49366,50630,50632,
   50751,50961],[1761,1887,47035,47043,47211,48895],
 [1761,1915,2033,47061,47062,47069,47071,47182,47189,47191,47210,
   47212,47331,49217,49224,49226,49245,49247,49366,50630,50632,
   50751,50961],
 [1761,2215,2254,47213,47216,47217,47221,47371,47372,47376,47399,
   47403,47410,51001,51002,51006,51029,51033,51040,52194,52198,
   52205,52314],[1761,2224,47214,47215,47380,51010],
 [1761,2224,47214,47215,47380,51010],
 [1761,2215,2254,47213,47216,47217,47221,47371,47372,47376,47399,
   47403,47410,51001,51002,51006,51029,51033,51040,52194,52198,
   52205,52314],
 [1761,2215,2254,47213,47216,47217,47221,47371,47372,47376,47399,
   47403,47410,51001,51002,51006,51029,51033,51040,52194,52198,
   52205,52314],[1761,2262,47218,47223,47418,51048],
 [1761,2268,2270,47219,47220,47222,47224,47420,47422,47424,47426,
   47428,47433,51050,51052,51054,51056,51058,51063,52376,52378,
   52383,52389],
 [1761,2268,2270,47219,47220,47222,47224,47420,47422,47424,47426,
   47428,47433,51050,51052,51054,51056,51058,51063,52376,52378,
   52383,52389],
 [1761,2215,2254,47213,47216,47217,47221,47371,47372,47376,47399,
   47403,47410,51001,51002,51006,51029,51033,51040,52194,52198,
   52205,52314],
 [1761,2268,2270,47219,47220,47222,47224,47420,47422,47424,47426,
   47428,47433,51050,51052,51054,51056,51058,51063,52376,52378,
   52383,52389],[1761,2262,47218,47223,47418,51048],
 [1761,2268,2270,47219,47220,47222,47224,47420,47422,47424,47426,
   47428,47433,51050,51052,51054,51056,51058,51063,52376,52378,
   52383,52389],[1698,46201],
 [1539,1552,1555,1557,1558,1625,1628,1630,1631,2005,2007,2008,
   2071,2108,43305,43308,43310,43311,43685,43687,43688,43750,
   43751,43788,44981,44983,44984,45046,45047,45084,50415,50416,
   50453,51084],[],[],[],[2033,50650],[1887,48915],
 [1915,49267],[2215,51191],[2224,51200],[2224,51200],
 [2215,51191],[2254,51230],[2262,51238],[2268,51244],
 [2270,51246],[2254,51230],[2270,51246],[2262,51238],
 [2268,51244],[1698,46221,46223,46241,51256],[1698,46222],
 [1698,46221,46223,46241,51256],[1698,46224],
 [1698,2033,46160,46165,46225,50669],
 [1698,1887,46013,46019,46226,48934],
 [1698,1915,46040,46047,46227,49286],
 [1698,2215,46228,46231,46347,51362],
 [1698,2224,46229,46230,46356,51371],
 [1698,2224,46229,46230,46356,51371],
 [1698,2215,46228,46231,46347,51362],
 [1698,2254,46232,46236,46386,51401],
 [1698,2262,46233,46238,46394,51409],
 [1698,2268,46234,46239,46400,51415],
 [1698,2270,46235,46237,46402,51417],
 [1698,2254,46232,46236,46386,51401],
 [1698,2270,46235,46237,46402,51417],
 [1698,2262,46233,46238,46394,51409],
 [1698,2268,46234,46239,46400,51415],
 [1625,44983,44984,45084,50453],[1698,46221,46223,46241,51256],
 [1761,47206,47209,47266,50896],[2033,50687],[1887,48952],
 [1915,49304],[2215,51515],[2224,51524],[2224,51524],
 [2215,51515],[2254,51554],[2262,51562],[2268,51568],
 [2270,51570],[2254,51554],[2270,51570],[2262,51562],
 [2268,51568],
 [1377,1827,1855,40104,40105,40117,40118,40450,40462,40463,40491,
   40492,40762,42050,42062,42063,42091,42092,42362,47911,47912,
   48182,48588],[1336,39295,39297,39902,43104],[2033,50704],
 [1887,48969],[1915,49321],[2215,51651],[2224,51660],
 [2224,51660],[2215,51651],[2254,51690],[2262,51698],
 [2268,51704],[2270,51706],[2254,51690],[2270,51706],
 [2262,51698],[2268,51704],[39015],[2033,50720],
 [1887,48985],[1915,49337],[2215,51771],[2224,51780],
 [2224,51780],[2215,51771],[2254,51810],[2262,51818],
 [2268,51824],[2270,51826],[2254,51810],[2270,51826],
 [2262,51818],[2268,51824],[2033,50735],[1887,49000],
 [1915,49352],[2215,51876],[2224,51885],[2224,51885],
 [2215,51876],[2254,51915],[2262,51923],[2268,51929],
 [2270,51931],[2254,51915],[2270,51931],[2262,51923],
 [2268,51929],
 [1658,1887,2033,45446,45449,45457,45458,45527,45535,45536,45604,
   45605,45745,48796,48804,48805,48873,48874,49014,49849,49850,
   49990,50750],
 [1761,1915,2033,47061,47062,47069,47071,47182,47189,47191,47210,
   47212,47331,49217,49224,49226,49245,49247,49366,50630,50632,
   50751,50961],[2033,2215,50752,50755,50791,51967],
 [2033,2224,50753,50754,50800,51976],
 [2033,2224,50753,50754,50800,51976],
 [2033,2215,50752,50755,50791,51967],
 [2033,2254,50756,50760,50830,52006],
 [2033,2262,50757,50762,50838,52014],
 [2033,2268,50758,50763,50844,52020],
 [2033,2270,50759,50761,50846,52022],
 [2033,2254,50756,50760,50830,52006],
 [2033,2270,50759,50761,50846,52022],
 [2033,2262,50757,50762,50838,52014],
 [2033,2268,50758,50763,50844,52020],
 [1377,1887,1915,40106,40107,40121,40122,40509,40523,40524,40550,
   40551,40824,42109,42123,42124,42150,42151,42424,48754,48755,
   49028,49379],[1887,2215,49029,49032,49055,52045],
 [1887,2224,49030,49031,49064,52054],
 [1887,2224,49030,49031,49064,52054],
 [1887,2215,49029,49032,49055,52045],
 [1887,2254,49033,49037,49094,52084],
 [1887,2262,49034,49039,49102,52092],
 [1887,2268,49035,49040,49108,52098],
 [1887,2270,49036,49038,49110,52100],
 [1887,2254,49033,49037,49094,52084],
 [1887,2270,49036,49038,49110,52100],
 [1887,2262,49034,49039,49102,52092],
 [1887,2268,49035,49040,49108,52098],
 [1915,2215,49392,49395,49406,52111],
 [1915,2224,49393,49394,49415,52120],
 [1915,2224,49393,49394,49415,52120],
 [1915,2215,49392,49395,49406,52111],
 [1915,2254,49396,49400,49445,52150],
 [1915,2262,49397,49402,49453,52158],
 [1915,2268,49398,49403,49459,52164],
 [1915,2270,49399,49401,49461,52166],
 [1915,2254,49396,49400,49445,52150],
 [1915,2270,49399,49401,49461,52166],
 [1915,2262,49397,49402,49453,52158],
 [1915,2268,49398,49403,49459,52164],
 [1377,2215,2224,40123,40124,40125,40126,40849,40850,40851,40860,
   40861,40870,42449,42450,42451,42460,42461,42470,52175,52176,
   52185,52230],
 [1377,2215,2224,40123,40124,40125,40126,40849,40850,40851,40860,
   40861,40870,42449,42450,42451,42460,42461,42470,52175,52176,
   52185,52230],[],
 [1761,2215,2254,47213,47216,47217,47221,47371,47372,47376,47399,
   47403,47410,51001,51002,51006,51029,51033,51040,52194,52198,
   52205,52314],[2215,2262,52195,52200,52213,52322],
 [328,2215,2268,12852,12855,12858,12863,14511,14514,14519,14541,
   14546,14564,19822,19825,19830,19852,19857,19875,52196,52201,
   52219,52328],[2215,2270,52197,52199,52221,52330],
 [1761,2215,2254,47213,47216,47217,47221,47371,47372,47376,47399,
   47403,47410,51001,51002,51006,51029,51033,51040,52194,52198,
   52205,52314],[2215,2270,52197,52199,52221,52330],
 [2215,2262,52195,52200,52213,52322],
 [328,2215,2268,12852,12855,12858,12863,14511,14514,14519,14541,
   14546,14564,19822,19825,19830,19852,19857,19875,52196,52201,
   52219,52328],[],
 [1377,2215,2224,40123,40124,40125,40126,40849,40850,40851,40860,
   40861,40870,42449,42450,42451,42460,42461,42470,52175,52176,
   52185,52230],
 [1658,2224,2254,45539,45540,45542,45546,45795,45797,45801,45806,
   45810,45825,50040,50042,50046,50051,50055,50070,52231,52235,
   52250,52286],
 [328,2224,2262,12853,12854,12857,12862,14520,14523,14528,14532,
   14537,14558,19831,19834,19839,19843,19848,19869,52232,52237,
   52258,52294],[2224,2268,52233,52238,52264,52300],
 [2224,2270,52234,52236,52266,52302],
 [1658,2224,2254,45539,45540,45542,45546,45795,45797,45801,45806,
   45810,45825,50040,50042,50046,50051,50055,50070,52231,52235,
   52250,52286],[2224,2270,52234,52236,52266,52302],
 [328,2224,2262,12853,12854,12857,12862,14520,14523,14528,14532,
   14537,14558,19831,19834,19839,19843,19848,19869,52232,52237,
   52258,52294],[2224,2268,52233,52238,52264,52300],
 [1377,2215,2224,40123,40124,40125,40126,40849,40850,40851,40860,
   40861,40870,42449,42450,42451,42460,42461,42470,52175,52176,
   52185,52230],
 [1658,2224,2254,45539,45540,45542,45546,45795,45797,45801,45806,
   45810,45825,50040,50042,50046,50051,50055,50070,52231,52235,
   52250,52286],
 [328,2224,2262,12853,12854,12857,12862,14520,14523,14528,14532,
   14537,14558,19831,19834,19839,19843,19848,19869,52232,52237,
   52258,52294],[2224,2268,52233,52238,52264,52300],
 [2224,2270,52234,52236,52266,52302],
 [1658,2224,2254,45539,45540,45542,45546,45795,45797,45801,45806,
   45810,45825,50040,50042,50046,50051,50055,50070,52231,52235,
   52250,52286],[2224,2270,52234,52236,52266,52302],
 [328,2224,2262,12853,12854,12857,12862,14520,14523,14528,14532,
   14537,14558,19831,19834,19839,19843,19848,19869,52232,52237,
   52258,52294],[2224,2268,52233,52238,52264,52300],
 [1761,2215,2254,47213,47216,47217,47221,47371,47372,47376,47399,
   47403,47410,51001,51002,51006,51029,51033,51040,52194,52198,
   52205,52314],[2215,2262,52195,52200,52213,52322],
 [328,2215,2268,12852,12855,12858,12863,14511,14514,14519,14541,
   14546,14564,19822,19825,19830,19852,19857,19875,52196,52201,
   52219,52328],[2215,2270,52197,52199,52221,52330],
 [1761,2215,2254,47213,47216,47217,47221,47371,47372,47376,47399,
   47403,47410,51001,51002,51006,51029,51033,51040,52194,52198,
   52205,52314],[2215,2270,52197,52199,52221,52330],
 [2215,2262,52195,52200,52213,52322],
 [328,2215,2268,12852,12855,12858,12863,14511,14514,14519,14541,
   14546,14564,19822,19825,19830,19852,19857,19875,52196,52201,
   52219,52328],[2254,2262,52341,52343,52355,52370],
 [2254,2268,52346,52349,52356,52381],
 [328,2254,2270,12856,12859,12860,12861,14549,14550,14551,14565,
   14566,14569,19860,19861,19862,19876,19877,19880,52350,52351,
   52354,52385],[],
 [328,2254,2270,12856,12859,12860,12861,14549,14550,14551,14565,
   14566,14569,19860,19861,19862,19876,19877,19880,52350,52351,
   52354,52385],[2254,2262,52341,52343,52355,52370],
 [2254,2268,52346,52349,52356,52381],
 [1377,2262,2268,40128,40129,40133,40134,40894,40898,40899,40903,
   40904,40914,42494,42498,42499,42503,42504,42514,52363,52364,
   52374,52384],
 [1658,2262,2270,45543,45545,45547,45548,45830,45832,45833,45841,
   45842,45847,50075,50077,50078,50086,50087,50092,52366,52367,
   52372,52388],[2254,2262,52341,52343,52355,52370],
 [1658,2262,2270,45543,45545,45547,45548,45830,45832,45833,45841,
   45842,45847,50075,50077,50078,50086,50087,50092,52366,52367,
   52372,52388],[],
 [1377,2262,2268,40128,40129,40133,40134,40894,40898,40899,40903,
   40904,40914,42494,42498,42499,42503,42504,42514,52363,52364,
   52374,52384],
 [1761,2268,2270,47219,47220,47222,47224,47420,47422,47424,47426,
   47428,47433,51050,51052,51054,51056,51058,51063,52376,52378,
   52383,52389],[2254,2268,52346,52349,52356,52381],
 [1761,2268,2270,47219,47220,47222,47224,47420,47422,47424,47426,
   47428,47433,51050,51052,51054,51056,51058,51063,52376,52378,
   52383,52389],
 [1377,2262,2268,40128,40129,40133,40134,40894,40898,40899,40903,
   40904,40914,42494,42498,42499,42503,42504,42514,52363,52364,
   52374,52384],[],
 [328,2254,2270,12856,12859,12860,12861,14549,14550,14551,14565,
   14566,14569,19860,19861,19862,19876,19877,19880,52350,52351,
   52354,52385],[],
 [1658,2262,2270,45543,45545,45547,45548,45830,45832,45833,45841,
   45842,45847,50075,50077,50078,50086,50087,50092,52366,52367,
   52372,52388],
 [1761,2268,2270,47219,47220,47222,47224,47420,47422,47424,47426,
   47428,47433,51050,51052,51054,51056,51058,51063,52376,52378,
   52383,52389],
 [328,2254,2270,12856,12859,12860,12861,14549,14550,14551,14565,
   14566,14569,19860,19861,19862,19876,19877,19880,52350,52351,
   52354,52385],[2254,2262,52341,52343,52355,52370],
 [2254,2268,52346,52349,52356,52381],
 [1658,2262,2270,45543,45545,45547,45548,45830,45832,45833,45841,
   45842,45847,50075,50077,50078,50086,50087,50092,52366,52367,
   52372,52388],
 [1761,2268,2270,47219,47220,47222,47224,47420,47422,47424,47426,
   47428,47433,51050,51052,51054,51056,51058,51063,52376,52378,
   52383,52389],
 [1377,2262,2268,40128,40129,40133,40134,40894,40898,40899,40903,
   40904,40914,42494,42498,42499,42503,42504,42514,52363,52364,
   52374,52384],[],[2279],[2279],
 [2279,2280,2281,2300,2301,2302,2308,2318,2319,2345,2346,2365,
   2366,2367,2373,2383,2384,2410,2411,2429,2430,2431,2437,2447,
   2448,2474,2492,2493,2494,2500,2510,2511,2554,2555,2556,2562,
   2572,2573,3500,3501,3507,3517,3518,3544,3550,3560,3561,3592,
   3602,3603,3833,3834,4139,4490,4491,4510,4511,4512,4518,4528,
   4529,4555,4556,4574,4575,4576,4582,4592,4593,4619,4637,4638,
   4639,4645,4655,4656,4699,4700,4701,4707,4717,4718,5645,5646,
   5652,5662,5663,5689,5695,5705,5706,5737,5747,5748,5978,5979,
   6284,6635,6636,6654,6655,6656,6662,6672,6673,6699,6717,6718,
   6719,6725,6735,6736,6779,6780,6781,6787,6797,6798,7725,7726,
   7732,7742,7743,7769,7775,7785,7786,7817,7827,7828,8058,8059,
   8364,8715,8733,8734,8735,8741,8751,8752,8795,8796,8797,8803,
   8813,8814,9741,9742,9748,9758,9759,9785,9791,9801,9802,9833,
   9843,9844,10074,10075,10380,10748,10749,10750,10756,10766,
   10767,11694,11695,11701,11711,11712,11738,11744,11754,11755,
   11786,11796,11797,12027,12028,12333,13585,13586,13592,13602,
   13603,13629,13635,13645,13646,13677,13687,13688,13918,13919,
   14224,38205,38211,38221,38222,38253,38263,38264,38494,38495,
   38800,39156,39166,39167,39397,39398,39703,40258,40259,40564,
   44904],[2279],[2279],
 [2279,2281,2284,2300,2301,2302,2308,2318,2319,2346,2349,2365,
   2366,2367,2373,2383,2384,2476,2477,2492,2493,2494,2500,2510,
   2511,2660,2675,2676,2677,2683,2693,2694,2734,2735,2736,2742,
   2752,2753,3500,3501,3507,3517,3518,3544,3550,3560,3561,3592,
   3602,3603,3833,3834,4139,4491,4494,4510,4511,4512,4518,4528,
   4529,4621,4622,4637,4638,4639,4645,4655,4656,4805,4820,4821,
   4822,4828,4838,4839,4879,4880,4881,4887,4897,4898,5645,5646,
   5652,5662,5663,5689,5695,5705,5706,5737,5747,5748,5978,5979,
   6284,6701,6702,6717,6718,6719,6725,6735,6736,6885,6900,6901,
   6902,6908,6918,6919,6959,6960,6961,6967,6977,6978,7725,7726,
   7732,7742,7743,7769,7775,7785,7786,7817,7827,7828,8058,8059,
   8364,10854,10869,10870,10871,10877,10887,10888,10928,10929,
   10930,10936,10946,10947,11694,11695,11701,11711,11712,11738,
   11744,11754,11755,11786,11796,11797,12027,12028,12333,16419,
   16420,16421,16427,16437,16438,17185,17186,17192,17202,17203,
   17229,17235,17245,17246,17277,17287,17288,17518,17519,17824,
   18896,18897,18903,18913,18914,18940,18946,18956,18957,18988,
   18998,18999,19229,19230,19535,38205,38211,38221,38222,38253,
   38263,38264,38494,38495,38800,39156,39166,39167,39397,39398,
   39703,40258,40259,40564,44904],[2279],
 [2279,2305,2310,2321,2370,2375,2386,2854,2859,2870,3714,3725,
   3905,4515,4520,4531,4999,5004,5015,5859,5870,6050,7079,7084,
   7095,7939,7950,8130,22359,22370,22550,42671],[2279],
 [2279],[2279],[2279],
 [2279,2290,2291,2355,2356,3005,3006,3059,4500,4501,5150,5151,
   5204,7230,7231,7284,26160],[2279],
 [2279,2291,2293,2356,2358,3060,3061,3164,4501,4503,5205,5206,
   5309,7285,7286,7389,27643],[2279],[2279],
 [2279,2293,2296,2358,2361,3166,3167,3314,4503,4506,5311,5312,
   5459,7391,7392,7539,30394],[2279],
 [2279,2291,2293,2294,2356,2358,2359,3060,3061,3066,3164,3169,
   3219,4501,4503,4504,5205,5206,5211,5309,5314,5364,7285,7286,
   7291,7389,7394,7444,27643,27648,27698,30299],
 [2279,3500,3501,3507,3517,3518,3544,3550,3592,3833,3834,4139,
   5645,5646,5662,5689,5695,5705,5706,5747,5978,5979,6284,7725,
   7726,7743,7769,7786,7817,7827,7828,8058,8059,8364,38205,
   38211,38221,38222,38253,38263,38264,38494,38495,38800,39156,
   39166,39167,39397,39398,39703,40258,40259,40564,44904],
 [2279,3500,3501,3507,3517,3518,3544,3550,3592,3833,3834,4139,
   5645,5646,5662,5689,5695,5705,5706,5747,5978,5979,6284,7725,
   7726,7743,7769,7786,7817,7827,7828,8058,8059,8364,38205,
   38211,38221,38222,38253,38263,38264,38494,38495,38800,39156,
   39166,39167,39397,39398,39703,40258,40259,40564,44904],
 [2279,3500,3501,3507,3517,3518,3544,3550,3592,3833,3834,4139,
   5645,5646,5662,5689,5695,5705,5706,5747,5978,5979,6284,7725,
   7726,7743,7769,7786,7817,7827,7828,8058,8059,8364,38205,
   38211,38221,38222,38253,38263,38264,38494,38495,38800,39156,
   39166,39167,39397,39398,39703,40258,40259,40564,44904],
 [1,2,23,26,31,32,41,42,44,68,89,90,91,92,93,94,107,156,
   157,158,163,164,166,173,177,179,1289,1290,1291,1292,1293,
   1296,1297,1298,1300,1306,1307,1309,1311,1313,1333,1334,1335,
   1336,1339,1340,1341,1343,1349,1350,1352,1354,1356,1376,1377,
   1378,1381,1382,1383,1385,1391,1392,1394,1396,1398,1418,1419,
   1422,1423,1424,1426,1432,1433,1435,1437,1439,1459,1462,1463,
   1464,1466,1472,1473,1475,1477,1479,1501,1502,1503,1505,1511,
   1512,1514,1516,1518,1613,1614,1616,1622,1623,1625,1627,1629,
   1649,1651,1657,1658,1660,1662,1664,1685,1691,1692,1694,1696,
   1698,1756,1757,1759,1761,1763,1928,1930,1932,1934,1955,1957,
   1959,2004,2006,2049,2279,2300,2301,2302,2305,2308,2310,2318,
   2319,2321,2365,2366,2367,2370,2373,2375,2383,2384,2386,3500,
   3501,3502,3503,3504,3507,3508,3509,3511,3517,3518,3520,3522,
   3524,3544,3545,3546,3547,3550,3551,3552,3554,3560,3561,3563,
   3565,3567,3587,3588,3589,3592,3593,3594,3596,3602,3603,3605,
   3607,3609,3629,3630,3633,3634,3635,3637,3643,3644,3646,3648,
   3650,3670,3673,3674,3675,3677,3683,3684,3686,3688,3690,3712,
   3713,3714,3716,3722,3723,3725,3727,3729,3824,3825,3827,3833,
   3834,3836,3838,3840,3860,3862,3868,3869,3871,3873,3875,3896,
   3902,3903,3905,3907,3909,3967,3968,3970,3972,3974,4139,4141,
   4143,4145,4166,4168,4170,4215,4217,4260,4510,4511,4512,4515,
   4518,4520,4528,4529,4531,5645,5646,5647,5648,5649,5652,5653,
   5654,5656,5662,5663,5665,5667,5669,5689,5690,5691,5692,5695,
   5696,5697,5699,5705,5706,5708,5710,5712,5732,5733,5734,5737,
   5738,5739,5741,5747,5748,5750,5752,5754,5774,5775,5778,5779,
   5780,5782,5788,5789,5791,5793,5795,5815,5818,5819,5820,5822,
   5828,5829,5831,5833,5835,5857,5858,5859,5861,5867,5868,5870,
   5872,5874,5969,5970,5972,5978,5979,5981,5983,5985,6005,6007,
   6013,6014,6016,6018,6020,6041,6047,6048,6050,6052,6054,6112,
   6113,6115,6117,6119,6284,6286,6288,6290,6311,6313,6315,6360,
   6362,6405,7725,7726,7727,7728,7729,7732,7733,7734,7736,7742,
   7743,7745,7747,7749,7769,7770,7771,7772,7775,7776,7777,7779,
   7785,7786,7788,7790,7792,7812,7813,7814,7817,7818,7819,7821,
   7827,7828,7830,7832,7834,7854,7855,7858,7859,7860,7862,7868,
   7869,7871,7873,7875,7895,7898,7899,7900,7902,7908,7909,7911,
   7913,7915,7937,7938,7939,7941,7947,7948,7950,7952,7954,8049,
   8050,8052,8058,8059,8061,8063,8065,8085,8087,8093,8094,8096,
   8098,8100,8121,8127,8128,8130,8132,8134,8192,8193,8195,8197,
   8199,8364,8366,8368,8370,8391,8393,8395,8440,8442,8485,
   38205,38206,38207,38208,38211,38212,38213,38215,38221,38222,
   38224,38226,38228,38248,38249,38250,38253,38254,38255,38257,
   38263,38264,38266,38268,38270,38290,38291,38294,38295,38296,
   38298,38304,38305,38307,38309,38311,38331,38334,38335,38336,
   38338,38344,38345,38347,38349,38351,38373,38374,38375,38377,
   38383,38384,38386,38388,38390,38485,38486,38488,38494,38495,
   38497,38499,38501,38521,38523,38529,38530,38532,38534,38536,
   38557,38563,38564,38566,38568,38570,38628,38629,38631,38633,
   38635,38800,38802,38804,38806,38827,38829,38831,38876,38878,
   38921,39151,39152,39153,39156,39157,39158,39160,39166,39167,
   39169,39171,39173,39193,39194,39197,39198,39199,39201,39207,
   39208,39210,39212,39214,39234,39237,39238,39239,39241,39247,
   39248,39250,39252,39254,39276,39277,39278,39280,39286,39287,
   39289,39291,39293,39388,39389,39391,39397,39398,39400,39402,
   39404,39424,39426,39432,39433,39435,39437,39439,39460,39466,
   39467,39469,39471,39473,39531,39532,39534,39536,39538,39703,
   39705,39707,39709,39730,39732,39734,39779,39781,39824,40054,
   40055,40058,40059,40060,40062,40068,40069,40071,40073,40075,
   40095,40098,40099,40100,40102,40108,40109,40111,40113,40115,
   40137,40138,40139,40141,40147,40148,40150,40152,40154,40249,
   40250,40252,40258,40259,40261,40263,40265,40285,40287,40293,
   40294,40296,40298,40300,40321,40327,40328,40330,40332,40334,
   40392,40393,40395,40397,40399,40564,40566,40568,40570,40591,
   40593,40595,40640,40642,40685,40915,40918,40919,40920,40922,
   40928,40929,40931,40933,40935,40957,40958,40959,40961,40967,
   40968,40970,40972,40974,41069,41070,41072,41078,41079,41081,
   41083,41085,41105,41107,41113,41114,41116,41118,41120,41141,
   41147,41148,41150,41152,41154,41212,41213,41215,41217,41219,
   41384,41386,41388,41390,41411,41413,41415,41460,41462,41505,
   41737,41738,41739,41741,41747,41748,41750,41752,41754,41849,
   41850,41852,41858,41859,41861,41863,41865,41885,41887,41893,
   41894,41896,41898,41900,41921,41927,41928,41930,41932,41934,
   41992,41993,41995,41997,41999,42164,42166,42168,42170,42191,
   42193,42195,42240,42242,42285,42590,42591,42593,42599,42600,
   42602,42604,42606,42626,42628,42634,42635,42637,42639,42641,
   42662,42668,42669,42671,42673,42675,42733,42734,42736,42738,
   42740,42905,42907,42909,42911,42932,42934,42936,42981,42983,
   43026,44625,44627,44633,44634,44636,44638,44640,44661,44667,
   44668,44670,44672,44674,44732,44733,44735,44737,44739,44904,
   44906,44908,44910,44931,44933,44935,44980,44982,45025,45256,
   45262,45263,45265,45267,45269,45327,45328,45330,45332,45334,
   45499,45501,45503,45505,45526,45528,45530,45575,45577,45620,
   45888,45889,45891,45893,45895,46060,46062,46064,46066,46087,
   46089,46091,46136,46138,46181,47084,47086,47088,47090,47111,
   47113,47115,47160,47162,47205,49471,49473,49475,49520,49522,
   49565,49820,49822,49865,50394],
 [1,2,23,26,31,32,41,42,44,68,89,90,91,92,93,94,107,156,
   157,158,163,164,166,173,177,179,1289,1290,1291,1292,1293,
   1296,1297,1298,1300,1306,1307,1309,1311,1313,1333,1334,1335,
   1336,1339,1340,1341,1343,1349,1350,1352,1354,1356,1376,1377,
   1378,1381,1382,1383,1385,1391,1392,1394,1396,1398,1418,1419,
   1422,1423,1424,1426,1432,1433,1435,1437,1439,1459,1462,1463,
   1464,1466,1472,1473,1475,1477,1479,1501,1502,1503,1505,1511,
   1512,1514,1516,1518,1613,1614,1616,1622,1623,1625,1627,1629,
   1649,1651,1657,1658,1660,1662,1664,1685,1691,1692,1694,1696,
   1698,1756,1757,1759,1761,1763,1928,1930,1932,1934,1955,1957,
   1959,2004,2006,2049,2279,2300,2301,2302,2305,2308,2310,2318,
   2319,2321,2365,2366,2367,2370,2373,2375,2383,2384,2386,3500,
   3501,3502,3503,3504,3507,3508,3509,3511,3517,3518,3520,3522,
   3524,3544,3545,3546,3547,3550,3551,3552,3554,3560,3561,3563,
   3565,3567,3587,3588,3589,3592,3593,3594,3596,3602,3603,3605,
   3607,3609,3629,3630,3633,3634,3635,3637,3643,3644,3646,3648,
   3650,3670,3673,3674,3675,3677,3683,3684,3686,3688,3690,3712,
   3713,3714,3716,3722,3723,3725,3727,3729,3824,3825,3827,3833,
   3834,3836,3838,3840,3860,3862,3868,3869,3871,3873,3875,3896,
   3902,3903,3905,3907,3909,3967,3968,3970,3972,3974,4139,4141,
   4143,4145,4166,4168,4170,4215,4217,4260,4510,4511,4512,4515,
   4518,4520,4528,4529,4531,5645,5646,5647,5648,5649,5652,5653,
   5654,5656,5662,5663,5665,5667,5669,5689,5690,5691,5692,5695,
   5696,5697,5699,5705,5706,5708,5710,5712,5732,5733,5734,5737,
   5738,5739,5741,5747,5748,5750,5752,5754,5774,5775,5778,5779,
   5780,5782,5788,5789,5791,5793,5795,5815,5818,5819,5820,5822,
   5828,5829,5831,5833,5835,5857,5858,5859,5861,5867,5868,5870,
   5872,5874,5969,5970,5972,5978,5979,5981,5983,5985,6005,6007,
   6013,6014,6016,6018,6020,6041,6047,6048,6050,6052,6054,6112,
   6113,6115,6117,6119,6284,6286,6288,6290,6311,6313,6315,6360,
   6362,6405,7725,7726,7727,7728,7729,7732,7733,7734,7736,7742,
   7743,7745,7747,7749,7769,7770,7771,7772,7775,7776,7777,7779,
   7785,7786,7788,7790,7792,7812,7813,7814,7817,7818,7819,7821,
   7827,7828,7830,7832,7834,7854,7855,7858,7859,7860,7862,7868,
   7869,7871,7873,7875,7895,7898,7899,7900,7902,7908,7909,7911,
   7913,7915,7937,7938,7939,7941,7947,7948,7950,7952,7954,8049,
   8050,8052,8058,8059,8061,8063,8065,8085,8087,8093,8094,8096,
   8098,8100,8121,8127,8128,8130,8132,8134,8192,8193,8195,8197,
   8199,8364,8366,8368,8370,8391,8393,8395,8440,8442,8485,
   38205,38206,38207,38208,38211,38212,38213,38215,38221,38222,
   38224,38226,38228,38248,38249,38250,38253,38254,38255,38257,
   38263,38264,38266,38268,38270,38290,38291,38294,38295,38296,
   38298,38304,38305,38307,38309,38311,38331,38334,38335,38336,
   38338,38344,38345,38347,38349,38351,38373,38374,38375,38377,
   38383,38384,38386,38388,38390,38485,38486,38488,38494,38495,
   38497,38499,38501,38521,38523,38529,38530,38532,38534,38536,
   38557,38563,38564,38566,38568,38570,38628,38629,38631,38633,
   38635,38800,38802,38804,38806,38827,38829,38831,38876,38878,
   38921,39151,39152,39153,39156,39157,39158,39160,39166,39167,
   39169,39171,39173,39193,39194,39197,39198,39199,39201,39207,
   39208,39210,39212,39214,39234,39237,39238,39239,39241,39247,
   39248,39250,39252,39254,39276,39277,39278,39280,39286,39287,
   39289,39291,39293,39388,39389,39391,39397,39398,39400,39402,
   39404,39424,39426,39432,39433,39435,39437,39439,39460,39466,
   39467,39469,39471,39473,39531,39532,39534,39536,39538,39703,
   39705,39707,39709,39730,39732,39734,39779,39781,39824,40054,
   40055,40058,40059,40060,40062,40068,40069,40071,40073,40075,
   40095,40098,40099,40100,40102,40108,40109,40111,40113,40115,
   40137,40138,40139,40141,40147,40148,40150,40152,40154,40249,
   40250,40252,40258,40259,40261,40263,40265,40285,40287,40293,
   40294,40296,40298,40300,40321,40327,40328,40330,40332,40334,
   40392,40393,40395,40397,40399,40564,40566,40568,40570,40591,
   40593,40595,40640,40642,40685,40915,40918,40919,40920,40922,
   40928,40929,40931,40933,40935,40957,40958,40959,40961,40967,
   40968,40970,40972,40974,41069,41070,41072,41078,41079,41081,
   41083,41085,41105,41107,41113,41114,41116,41118,41120,41141,
   41147,41148,41150,41152,41154,41212,41213,41215,41217,41219,
   41384,41386,41388,41390,41411,41413,41415,41460,41462,41505,
   41737,41738,41739,41741,41747,41748,41750,41752,41754,41849,
   41850,41852,41858,41859,41861,41863,41865,41885,41887,41893,
   41894,41896,41898,41900,41921,41927,41928,41930,41932,41934,
   41992,41993,41995,41997,41999,42164,42166,42168,42170,42191,
   42193,42195,42240,42242,42285,42590,42591,42593,42599,42600,
   42602,42604,42606,42626,42628,42634,42635,42637,42639,42641,
   42662,42668,42669,42671,42673,42675,42733,42734,42736,42738,
   42740,42905,42907,42909,42911,42932,42934,42936,42981,42983,
   43026,44625,44627,44633,44634,44636,44638,44640,44661,44667,
   44668,44670,44672,44674,44732,44733,44735,44737,44739,44904,
   44906,44908,44910,44931,44933,44935,44980,44982,45025,45256,
   45262,45263,45265,45267,45269,45327,45328,45330,45332,45334,
   45499,45501,45503,45505,45526,45528,45530,45575,45577,45620,
   45888,45889,45891,45893,45895,46060,46062,46064,46066,46087,
   46089,46091,46136,46138,46181,47084,47086,47088,47090,47111,
   47113,47115,47160,47162,47205,49471,49473,49475,49520,49522,
   49565,49820,49822,49865,50394],
 [2279,3714,3725,3905,5859,5870,6050,7939,7950,8130,42671],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,
   2384,3500,3501,3505,3506,3507,3513,3514,3517,3518,3527,3528,
   3544,3548,3549,3550,3556,3557,3560,3561,3570,3571,3590,3591,
   3592,3598,3599,3602,3603,3612,3613,3749,3750,3756,3757,3760,
   3761,3770,3771,3787,3793,3794,3797,3798,3829,3830,3833,3834,
   3843,3844,4025,4028,4029,4038,4039,4057,4058,4139,4148,4149,
   4173,4174,4354,4510,4511,4512,4518,4528,4529,5645,5646,5650,
   5651,5652,5658,5659,5662,5663,5672,5673,5689,5693,5694,5695,
   5701,5702,5705,5706,5715,5716,5735,5736,5737,5743,5744,5747,
   5748,5757,5758,5894,5895,5902,5905,5906,5916,5932,5939,5942,
   5943,5953,5974,5975,5978,5979,5988,5989,6170,6173,6174,6183,
   6184,6202,6203,6212,6213,6284,6293,6294,6318,6319,6499,7725,
   7726,7730,7731,7732,7738,7739,7742,7743,7752,7753,7769,7773,
   7774,7775,7781,7782,7785,7786,7795,7796,7815,7816,7817,7823,
   7824,7827,7828,7837,7838,7974,7975,7985,7986,7995,7996,8012,
   8018,8019,8022,8023,8032,8033,8054,8055,8058,8059,8068,8069,
   8250,8253,8254,8263,8282,8283,8292,8364,8373,8374,8398,8399,
   8579,38205,38209,38210,38211,38217,38218,38221,38222,38231,
   38232,38251,38252,38253,38259,38260,38263,38264,38273,38274,
   38410,38411,38417,38418,38421,38422,38431,38432,38448,38454,
   38455,38458,38459,38468,38469,38490,38491,38494,38495,38504,
   38505,38686,38689,38690,38699,38700,38718,38719,38728,38729,
   38800,38809,38810,38834,38835,39015,39154,39155,39156,39162,
   39163,39166,39167,39176,39177,39313,39314,39320,39321,39324,
   39325,39334,39335,39351,39357,39358,39361,39362,39371,39372,
   39393,39394,39397,39398,39407,39408,39589,39592,39593,39602,
   39603,39621,39622,39631,39632,39703,39712,39713,39737,39738,
   39918,40174,40175,40181,40182,40185,40186,40195,40196,40212,
   40218,40219,40222,40223,40232,40233,40254,40255,40258,40259,
   40268,40269,40450,40453,40454,40463,40464,40482,40483,40492,
   40493,40564,40573,40574,40598,40599,40779,43256,43262,43263,
   43266,43267,43276,43277,43298,43299,43302,43303,43312,43313,
   43494,43497,43498,43507,43508,43526,43527,43536,43537,43608,
   43617,43618,43642,43643,43823,43964,43965,43968,43969,43978,
   43979,44160,44163,44164,44173,44174,44192,44193,44202,44203,
   44274,44283,44284,44308,44309,44489,44790,44793,44794,44803,
   44804,44822,44823,44832,44833,44904,44913,44914,44938,44939,
   45119,47902,47903,47912,47913,47984,47993,47994,48018,48019,
   48199,48390,48399,48400,48424,48425,48605,49478,49479,49659,
   49959],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,
   2384,3500,3501,3505,3506,3507,3513,3514,3517,3518,3527,3528,
   3544,3548,3549,3550,3556,3557,3560,3561,3570,3571,3590,3591,
   3592,3598,3599,3602,3603,3612,3613,3749,3750,3756,3757,3760,
   3761,3770,3771,3787,3793,3794,3797,3798,3829,3830,3833,3834,
   3843,3844,4025,4028,4029,4038,4039,4057,4058,4139,4148,4149,
   4173,4174,4354,4510,4511,4512,4518,4528,4529,5645,5646,5650,
   5651,5652,5658,5659,5662,5663,5672,5673,5689,5693,5694,5695,
   5701,5702,5705,5706,5715,5716,5735,5736,5737,5743,5744,5747,
   5748,5757,5758,5894,5895,5902,5905,5906,5916,5932,5939,5942,
   5943,5953,5974,5975,5978,5979,5988,5989,6170,6173,6174,6183,
   6184,6202,6203,6212,6213,6284,6293,6294,6318,6319,6499,7725,
   7726,7730,7731,7732,7738,7739,7742,7743,7752,7753,7769,7773,
   7774,7775,7781,7782,7785,7786,7795,7796,7815,7816,7817,7823,
   7824,7827,7828,7837,7838,7974,7975,7985,7986,7995,7996,8012,
   8018,8019,8022,8023,8032,8033,8054,8055,8058,8059,8068,8069,
   8250,8253,8254,8263,8282,8283,8292,8364,8373,8374,8398,8399,
   8579,38205,38209,38210,38211,38217,38218,38221,38222,38231,
   38232,38251,38252,38253,38259,38260,38263,38264,38273,38274,
   38410,38411,38417,38418,38421,38422,38431,38432,38448,38454,
   38455,38458,38459,38468,38469,38490,38491,38494,38495,38504,
   38505,38686,38689,38690,38699,38700,38718,38719,38728,38729,
   38800,38809,38810,38834,38835,39015,39154,39155,39156,39162,
   39163,39166,39167,39176,39177,39313,39314,39320,39321,39324,
   39325,39334,39335,39351,39357,39358,39361,39362,39371,39372,
   39393,39394,39397,39398,39407,39408,39589,39592,39593,39602,
   39603,39621,39622,39631,39632,39703,39712,39713,39737,39738,
   39918,40174,40175,40181,40182,40185,40186,40195,40196,40212,
   40218,40219,40222,40223,40232,40233,40254,40255,40258,40259,
   40268,40269,40450,40453,40454,40463,40464,40482,40483,40492,
   40493,40564,40573,40574,40598,40599,40779,43256,43262,43263,
   43266,43267,43276,43277,43298,43299,43302,43303,43312,43313,
   43494,43497,43498,43507,43508,43526,43527,43536,43537,43608,
   43617,43618,43642,43643,43823,43964,43965,43968,43969,43978,
   43979,44160,44163,44164,44173,44174,44192,44193,44202,44203,
   44274,44283,44284,44308,44309,44489,44790,44793,44794,44803,
   44804,44822,44823,44832,44833,44904,44913,44914,44938,44939,
   45119,47902,47903,47912,47913,47984,47993,47994,48018,48019,
   48199,48390,48399,48400,48424,48425,48605,49478,49479,49659,
   49959],
 [2279,3500,3501,3507,3517,3518,3544,3550,3592,3833,3834,4139,
   5645,5646,5662,5689,5695,5705,5706,5747,5978,5979,6284,7725,
   7726,7743,7769,7786,7817,7827,7828,8058,8059,8364,38205,
   38211,38221,38222,38253,38263,38264,38494,38495,38800,39156,
   39166,39167,39397,39398,39703,40258,40259,40564,44904],
 [1,2,23,26,31,32,41,42,44,68,89,90,91,92,93,94,107,156,
   157,158,163,164,166,173,177,179,1289,1290,1291,1292,1293,
   1296,1297,1298,1300,1306,1307,1309,1311,1313,1333,1334,1335,
   1336,1339,1340,1341,1343,1349,1350,1352,1354,1356,1376,1377,
   1378,1381,1382,1383,1385,1391,1392,1394,1396,1398,1418,1419,
   1422,1423,1424,1426,1432,1433,1435,1437,1439,1459,1462,1463,
   1464,1466,1472,1473,1475,1477,1479,1501,1502,1503,1505,1511,
   1512,1514,1516,1518,1613,1614,1616,1622,1623,1625,1627,1629,
   1649,1651,1657,1658,1660,1662,1664,1685,1691,1692,1694,1696,
   1698,1756,1757,1759,1761,1763,1928,1930,1932,1934,1955,1957,
   1959,2004,2006,2049,2279,2300,2301,2302,2305,2308,2310,2318,
   2319,2321,2365,2366,2367,2370,2373,2375,2383,2384,2386,3500,
   3501,3502,3503,3504,3507,3508,3509,3511,3517,3518,3520,3522,
   3524,3544,3545,3546,3547,3550,3551,3552,3554,3560,3561,3563,
   3565,3567,3587,3588,3589,3592,3593,3594,3596,3602,3603,3605,
   3607,3609,3629,3630,3633,3634,3635,3637,3643,3644,3646,3648,
   3650,3670,3673,3674,3675,3677,3683,3684,3686,3688,3690,3712,
   3713,3714,3716,3722,3723,3725,3727,3729,3824,3825,3827,3833,
   3834,3836,3838,3840,3860,3862,3868,3869,3871,3873,3875,3896,
   3902,3903,3905,3907,3909,3967,3968,3970,3972,3974,4139,4141,
   4143,4145,4166,4168,4170,4215,4217,4260,4510,4511,4512,4515,
   4518,4520,4528,4529,4531,5645,5646,5647,5648,5649,5652,5653,
   5654,5656,5662,5663,5665,5667,5669,5689,5690,5691,5692,5695,
   5696,5697,5699,5705,5706,5708,5710,5712,5732,5733,5734,5737,
   5738,5739,5741,5747,5748,5750,5752,5754,5774,5775,5778,5779,
   5780,5782,5788,5789,5791,5793,5795,5815,5818,5819,5820,5822,
   5828,5829,5831,5833,5835,5857,5858,5859,5861,5867,5868,5870,
   5872,5874,5969,5970,5972,5978,5979,5981,5983,5985,6005,6007,
   6013,6014,6016,6018,6020,6041,6047,6048,6050,6052,6054,6112,
   6113,6115,6117,6119,6284,6286,6288,6290,6311,6313,6315,6360,
   6362,6405,7725,7726,7727,7728,7729,7732,7733,7734,7736,7742,
   7743,7745,7747,7749,7769,7770,7771,7772,7775,7776,7777,7779,
   7785,7786,7788,7790,7792,7812,7813,7814,7817,7818,7819,7821,
   7827,7828,7830,7832,7834,7854,7855,7858,7859,7860,7862,7868,
   7869,7871,7873,7875,7895,7898,7899,7900,7902,7908,7909,7911,
   7913,7915,7937,7938,7939,7941,7947,7948,7950,7952,7954,8049,
   8050,8052,8058,8059,8061,8063,8065,8085,8087,8093,8094,8096,
   8098,8100,8121,8127,8128,8130,8132,8134,8192,8193,8195,8197,
   8199,8364,8366,8368,8370,8391,8393,8395,8440,8442,8485,
   38205,38206,38207,38208,38211,38212,38213,38215,38221,38222,
   38224,38226,38228,38248,38249,38250,38253,38254,38255,38257,
   38263,38264,38266,38268,38270,38290,38291,38294,38295,38296,
   38298,38304,38305,38307,38309,38311,38331,38334,38335,38336,
   38338,38344,38345,38347,38349,38351,38373,38374,38375,38377,
   38383,38384,38386,38388,38390,38485,38486,38488,38494,38495,
   38497,38499,38501,38521,38523,38529,38530,38532,38534,38536,
   38557,38563,38564,38566,38568,38570,38628,38629,38631,38633,
   38635,38800,38802,38804,38806,38827,38829,38831,38876,38878,
   38921,39151,39152,39153,39156,39157,39158,39160,39166,39167,
   39169,39171,39173,39193,39194,39197,39198,39199,39201,39207,
   39208,39210,39212,39214,39234,39237,39238,39239,39241,39247,
   39248,39250,39252,39254,39276,39277,39278,39280,39286,39287,
   39289,39291,39293,39388,39389,39391,39397,39398,39400,39402,
   39404,39424,39426,39432,39433,39435,39437,39439,39460,39466,
   39467,39469,39471,39473,39531,39532,39534,39536,39538,39703,
   39705,39707,39709,39730,39732,39734,39779,39781,39824,40054,
   40055,40058,40059,40060,40062,40068,40069,40071,40073,40075,
   40095,40098,40099,40100,40102,40108,40109,40111,40113,40115,
   40137,40138,40139,40141,40147,40148,40150,40152,40154,40249,
   40250,40252,40258,40259,40261,40263,40265,40285,40287,40293,
   40294,40296,40298,40300,40321,40327,40328,40330,40332,40334,
   40392,40393,40395,40397,40399,40564,40566,40568,40570,40591,
   40593,40595,40640,40642,40685,40915,40918,40919,40920,40922,
   40928,40929,40931,40933,40935,40957,40958,40959,40961,40967,
   40968,40970,40972,40974,41069,41070,41072,41078,41079,41081,
   41083,41085,41105,41107,41113,41114,41116,41118,41120,41141,
   41147,41148,41150,41152,41154,41212,41213,41215,41217,41219,
   41384,41386,41388,41390,41411,41413,41415,41460,41462,41505,
   41737,41738,41739,41741,41747,41748,41750,41752,41754,41849,
   41850,41852,41858,41859,41861,41863,41865,41885,41887,41893,
   41894,41896,41898,41900,41921,41927,41928,41930,41932,41934,
   41992,41993,41995,41997,41999,42164,42166,42168,42170,42191,
   42193,42195,42240,42242,42285,42590,42591,42593,42599,42600,
   42602,42604,42606,42626,42628,42634,42635,42637,42639,42641,
   42662,42668,42669,42671,42673,42675,42733,42734,42736,42738,
   42740,42905,42907,42909,42911,42932,42934,42936,42981,42983,
   43026,44625,44627,44633,44634,44636,44638,44640,44661,44667,
   44668,44670,44672,44674,44732,44733,44735,44737,44739,44904,
   44906,44908,44910,44931,44933,44935,44980,44982,45025,45256,
   45262,45263,45265,45267,45269,45327,45328,45330,45332,45334,
   45499,45501,45503,45505,45526,45528,45530,45575,45577,45620,
   45888,45889,45891,45893,45895,46060,46062,46064,46066,46087,
   46089,46091,46136,46138,46181,47084,47086,47088,47090,47111,
   47113,47115,47160,47162,47205,49471,49473,49475,49520,49522,
   49565,49820,49822,49865,50394],
 [2279,3714,3725,3905,5859,5870,6050,7939,7950,8130,42671],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,
   2384,3500,3501,3507,3510,3512,3517,3518,3519,3523,3525,3526,
   3544,3550,3553,3555,3560,3561,3562,3566,3568,3569,3592,3595,
   3597,3602,3603,3604,3608,3610,3611,3826,3828,3833,3834,3835,
   3839,3841,3842,3930,3935,3936,3937,3941,3998,3999,4000,4004,
   4139,4140,4144,4146,4147,4165,4169,4171,4172,4193,4195,4196,
   4281,4282,4319,4510,4511,4512,4518,4528,4529,5645,5646,5652,
   5655,5657,5662,5663,5664,5668,5670,5671,5689,5695,5698,5700,
   5705,5706,5707,5711,5713,5714,5737,5740,5742,5747,5748,5749,
   5753,5755,5756,5971,5973,5978,5979,5980,5984,5986,5987,6075,
   6080,6081,6086,6089,6143,6144,6145,6149,6151,6152,6284,6285,
   6289,6291,6292,6310,6314,6316,6317,6340,6341,6427,6464,7725,
   7726,7732,7735,7737,7742,7743,7744,7748,7750,7751,7769,7775,
   7778,7780,7785,7786,7787,7791,7793,7794,7817,7820,7822,7827,
   7828,7829,7833,7835,7836,8051,8053,8058,8059,8060,8064,8066,
   8067,8155,8160,8161,8162,8166,8168,8169,8223,8224,8225,8231,
   8364,8365,8369,8371,8372,8390,8394,8396,8397,8420,8506,8507,
   8544,38205,38211,38214,38216,38221,38222,38223,38227,38229,
   38230,38253,38256,38258,38263,38264,38265,38269,38271,38272,
   38487,38489,38494,38495,38496,38500,38502,38503,38591,38596,
   38597,38598,38602,38604,38605,38659,38660,38661,38665,38667,
   38668,38800,38801,38805,38807,38808,38826,38830,38832,38833,
   38854,38856,38857,38942,38943,38980,39156,39159,39161,39166,
   39167,39168,39172,39174,39175,39390,39392,39397,39398,39399,
   39403,39405,39406,39494,39499,39500,39501,39505,39507,39508,
   39562,39563,39564,39568,39570,39571,39703,39704,39708,39710,
   39711,39729,39733,39735,39736,39757,39759,39760,39845,39846,
   39883,40251,40253,40258,40259,40260,40264,40266,40267,40355,
   40360,40361,40362,40366,40368,40369,40423,40424,40425,40429,
   40431,40432,40564,40565,40569,40571,40572,40590,40594,40596,
   40597,40618,40620,40621,40706,40707,40744,44695,44700,44701,
   44702,44706,44708,44709,44763,44764,44765,44769,44771,44772,
   44904,44905,44909,44911,44912,44930,44934,44936,44937,44958,
   44960,44961,45046,45047,45084,46447,46448,46449,46453,46455,
   46456,46588,46589,46593,46595,46596,46614,46618,46620,46621,
   46642,46644,46645,46730,46731,46768,47549,47550,47554,47556,
   47557,47575,47579,47581,47582,47603,47605,47606,47691,47692,
   47729,49470,49474,49476,49477,49498,49500,49501,49586,49587,
   49624,49798,49800,49801,49886,49887,49924,50162,50163,50200,
   51084],
 [1,2,23,26,31,32,41,42,44,68,89,90,91,92,93,94,107,156,
   157,158,163,164,166,173,177,179,1289,1290,1291,1292,1293,
   1296,1297,1298,1300,1306,1307,1309,1311,1313,1333,1334,1335,
   1336,1339,1340,1341,1343,1349,1350,1352,1354,1356,1376,1377,
   1378,1381,1382,1383,1385,1391,1392,1394,1396,1398,1418,1419,
   1422,1423,1424,1426,1432,1433,1435,1437,1439,1459,1462,1463,
   1464,1466,1472,1473,1475,1477,1479,1501,1502,1503,1505,1511,
   1512,1514,1516,1518,1613,1614,1616,1622,1623,1625,1627,1629,
   1649,1651,1657,1658,1660,1662,1664,1685,1691,1692,1694,1696,
   1698,1756,1757,1759,1761,1763,1928,1930,1932,1934,1955,1957,
   1959,2004,2006,2049,2279,2300,2301,2302,2305,2308,2310,2318,
   2319,2321,2365,2366,2367,2370,2373,2375,2383,2384,2386,3500,
   3501,3502,3503,3504,3507,3508,3509,3511,3517,3518,3520,3522,
   3524,3544,3545,3546,3547,3550,3551,3552,3554,3560,3561,3563,
   3565,3567,3587,3588,3589,3592,3593,3594,3596,3602,3603,3605,
   3607,3609,3629,3630,3633,3634,3635,3637,3643,3644,3646,3648,
   3650,3670,3673,3674,3675,3677,3683,3684,3686,3688,3690,3712,
   3713,3714,3716,3722,3723,3725,3727,3729,3824,3825,3827,3833,
   3834,3836,3838,3840,3860,3862,3868,3869,3871,3873,3875,3896,
   3902,3903,3905,3907,3909,3967,3968,3970,3972,3974,4139,4141,
   4143,4145,4166,4168,4170,4215,4217,4260,4510,4511,4512,4515,
   4518,4520,4528,4529,4531,5645,5646,5647,5648,5649,5652,5653,
   5654,5656,5662,5663,5665,5667,5669,5689,5690,5691,5692,5695,
   5696,5697,5699,5705,5706,5708,5710,5712,5732,5733,5734,5737,
   5738,5739,5741,5747,5748,5750,5752,5754,5774,5775,5778,5779,
   5780,5782,5788,5789,5791,5793,5795,5815,5818,5819,5820,5822,
   5828,5829,5831,5833,5835,5857,5858,5859,5861,5867,5868,5870,
   5872,5874,5969,5970,5972,5978,5979,5981,5983,5985,6005,6007,
   6013,6014,6016,6018,6020,6041,6047,6048,6050,6052,6054,6112,
   6113,6115,6117,6119,6284,6286,6288,6290,6311,6313,6315,6360,
   6362,6405,7725,7726,7727,7728,7729,7732,7733,7734,7736,7742,
   7743,7745,7747,7749,7769,7770,7771,7772,7775,7776,7777,7779,
   7785,7786,7788,7790,7792,7812,7813,7814,7817,7818,7819,7821,
   7827,7828,7830,7832,7834,7854,7855,7858,7859,7860,7862,7868,
   7869,7871,7873,7875,7895,7898,7899,7900,7902,7908,7909,7911,
   7913,7915,7937,7938,7939,7941,7947,7948,7950,7952,7954,8049,
   8050,8052,8058,8059,8061,8063,8065,8085,8087,8093,8094,8096,
   8098,8100,8121,8127,8128,8130,8132,8134,8192,8193,8195,8197,
   8199,8364,8366,8368,8370,8391,8393,8395,8440,8442,8485,
   38205,38206,38207,38208,38211,38212,38213,38215,38221,38222,
   38224,38226,38228,38248,38249,38250,38253,38254,38255,38257,
   38263,38264,38266,38268,38270,38290,38291,38294,38295,38296,
   38298,38304,38305,38307,38309,38311,38331,38334,38335,38336,
   38338,38344,38345,38347,38349,38351,38373,38374,38375,38377,
   38383,38384,38386,38388,38390,38485,38486,38488,38494,38495,
   38497,38499,38501,38521,38523,38529,38530,38532,38534,38536,
   38557,38563,38564,38566,38568,38570,38628,38629,38631,38633,
   38635,38800,38802,38804,38806,38827,38829,38831,38876,38878,
   38921,39151,39152,39153,39156,39157,39158,39160,39166,39167,
   39169,39171,39173,39193,39194,39197,39198,39199,39201,39207,
   39208,39210,39212,39214,39234,39237,39238,39239,39241,39247,
   39248,39250,39252,39254,39276,39277,39278,39280,39286,39287,
   39289,39291,39293,39388,39389,39391,39397,39398,39400,39402,
   39404,39424,39426,39432,39433,39435,39437,39439,39460,39466,
   39467,39469,39471,39473,39531,39532,39534,39536,39538,39703,
   39705,39707,39709,39730,39732,39734,39779,39781,39824,40054,
   40055,40058,40059,40060,40062,40068,40069,40071,40073,40075,
   40095,40098,40099,40100,40102,40108,40109,40111,40113,40115,
   40137,40138,40139,40141,40147,40148,40150,40152,40154,40249,
   40250,40252,40258,40259,40261,40263,40265,40285,40287,40293,
   40294,40296,40298,40300,40321,40327,40328,40330,40332,40334,
   40392,40393,40395,40397,40399,40564,40566,40568,40570,40591,
   40593,40595,40640,40642,40685,40915,40918,40919,40920,40922,
   40928,40929,40931,40933,40935,40957,40958,40959,40961,40967,
   40968,40970,40972,40974,41069,41070,41072,41078,41079,41081,
   41083,41085,41105,41107,41113,41114,41116,41118,41120,41141,
   41147,41148,41150,41152,41154,41212,41213,41215,41217,41219,
   41384,41386,41388,41390,41411,41413,41415,41460,41462,41505,
   41737,41738,41739,41741,41747,41748,41750,41752,41754,41849,
   41850,41852,41858,41859,41861,41863,41865,41885,41887,41893,
   41894,41896,41898,41900,41921,41927,41928,41930,41932,41934,
   41992,41993,41995,41997,41999,42164,42166,42168,42170,42191,
   42193,42195,42240,42242,42285,42590,42591,42593,42599,42600,
   42602,42604,42606,42626,42628,42634,42635,42637,42639,42641,
   42662,42668,42669,42671,42673,42675,42733,42734,42736,42738,
   42740,42905,42907,42909,42911,42932,42934,42936,42981,42983,
   43026,44625,44627,44633,44634,44636,44638,44640,44661,44667,
   44668,44670,44672,44674,44732,44733,44735,44737,44739,44904,
   44906,44908,44910,44931,44933,44935,44980,44982,45025,45256,
   45262,45263,45265,45267,45269,45327,45328,45330,45332,45334,
   45499,45501,45503,45505,45526,45528,45530,45575,45577,45620,
   45888,45889,45891,45893,45895,46060,46062,46064,46066,46087,
   46089,46091,46136,46138,46181,47084,47086,47088,47090,47111,
   47113,47115,47160,47162,47205,49471,49473,49475,49520,49522,
   49565,49820,49822,49865,50394],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,
   2384,3500,3501,3507,3510,3512,3517,3518,3519,3523,3525,3526,
   3544,3550,3553,3555,3560,3561,3562,3566,3568,3569,3592,3595,
   3597,3602,3603,3604,3608,3610,3611,3826,3828,3833,3834,3835,
   3839,3841,3842,3930,3935,3936,3937,3941,3998,3999,4000,4004,
   4139,4140,4144,4146,4147,4165,4169,4171,4172,4193,4195,4196,
   4281,4282,4319,4510,4511,4512,4518,4528,4529,5645,5646,5652,
   5655,5657,5662,5663,5664,5668,5670,5671,5689,5695,5698,5700,
   5705,5706,5707,5711,5713,5714,5737,5740,5742,5747,5748,5749,
   5753,5755,5756,5971,5973,5978,5979,5980,5984,5986,5987,6075,
   6080,6081,6086,6089,6143,6144,6145,6149,6151,6152,6284,6285,
   6289,6291,6292,6310,6314,6316,6317,6340,6341,6427,6464,7725,
   7726,7732,7735,7737,7742,7743,7744,7748,7750,7751,7769,7775,
   7778,7780,7785,7786,7787,7791,7793,7794,7817,7820,7822,7827,
   7828,7829,7833,7835,7836,8051,8053,8058,8059,8060,8064,8066,
   8067,8155,8160,8161,8162,8166,8168,8169,8223,8224,8225,8231,
   8364,8365,8369,8371,8372,8390,8394,8396,8397,8420,8506,8507,
   8544,38205,38211,38214,38216,38221,38222,38223,38227,38229,
   38230,38253,38256,38258,38263,38264,38265,38269,38271,38272,
   38487,38489,38494,38495,38496,38500,38502,38503,38591,38596,
   38597,38598,38602,38604,38605,38659,38660,38661,38665,38667,
   38668,38800,38801,38805,38807,38808,38826,38830,38832,38833,
   38854,38856,38857,38942,38943,38980,39156,39159,39161,39166,
   39167,39168,39172,39174,39175,39390,39392,39397,39398,39399,
   39403,39405,39406,39494,39499,39500,39501,39505,39507,39508,
   39562,39563,39564,39568,39570,39571,39703,39704,39708,39710,
   39711,39729,39733,39735,39736,39757,39759,39760,39845,39846,
   39883,40251,40253,40258,40259,40260,40264,40266,40267,40355,
   40360,40361,40362,40366,40368,40369,40423,40424,40425,40429,
   40431,40432,40564,40565,40569,40571,40572,40590,40594,40596,
   40597,40618,40620,40621,40706,40707,40744,44695,44700,44701,
   44702,44706,44708,44709,44763,44764,44765,44769,44771,44772,
   44904,44905,44909,44911,44912,44930,44934,44936,44937,44958,
   44960,44961,45046,45047,45084,46447,46448,46449,46453,46455,
   46456,46588,46589,46593,46595,46596,46614,46618,46620,46621,
   46642,46644,46645,46730,46731,46768,47549,47550,47554,47556,
   47557,47575,47579,47581,47582,47603,47605,47606,47691,47692,
   47729,49470,49474,49476,49477,49498,49500,49501,49586,49587,
   49624,49798,49800,49801,49886,49887,49924,50162,50163,50200,
   51084],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,
   2384,3500,3501,3505,3506,3507,3513,3514,3517,3518,3527,3528,
   3544,3548,3549,3550,3556,3557,3560,3561,3570,3571,3590,3591,
   3592,3598,3599,3602,3603,3612,3613,3749,3750,3756,3757,3760,
   3761,3770,3771,3787,3793,3794,3797,3798,3829,3830,3833,3834,
   3843,3844,4025,4028,4029,4038,4039,4057,4058,4139,4148,4149,
   4173,4174,4354,4510,4511,4512,4518,4528,4529,5645,5646,5650,
   5651,5652,5658,5659,5662,5663,5672,5673,5689,5693,5694,5695,
   5701,5702,5705,5706,5715,5716,5735,5736,5737,5743,5744,5747,
   5748,5757,5758,5894,5895,5902,5905,5906,5916,5932,5939,5942,
   5943,5953,5974,5975,5978,5979,5988,5989,6170,6173,6174,6183,
   6184,6202,6203,6212,6213,6284,6293,6294,6318,6319,6499,7725,
   7726,7730,7731,7732,7738,7739,7742,7743,7752,7753,7769,7773,
   7774,7775,7781,7782,7785,7786,7795,7796,7815,7816,7817,7823,
   7824,7827,7828,7837,7838,7974,7975,7985,7986,7995,7996,8012,
   8018,8019,8022,8023,8032,8033,8054,8055,8058,8059,8068,8069,
   8250,8253,8254,8263,8282,8283,8292,8364,8373,8374,8398,8399,
   8579,38205,38209,38210,38211,38217,38218,38221,38222,38231,
   38232,38251,38252,38253,38259,38260,38263,38264,38273,38274,
   38410,38411,38417,38418,38421,38422,38431,38432,38448,38454,
   38455,38458,38459,38468,38469,38490,38491,38494,38495,38504,
   38505,38686,38689,38690,38699,38700,38718,38719,38728,38729,
   38800,38809,38810,38834,38835,39015,39154,39155,39156,39162,
   39163,39166,39167,39176,39177,39313,39314,39320,39321,39324,
   39325,39334,39335,39351,39357,39358,39361,39362,39371,39372,
   39393,39394,39397,39398,39407,39408,39589,39592,39593,39602,
   39603,39621,39622,39631,39632,39703,39712,39713,39737,39738,
   39918,40174,40175,40181,40182,40185,40186,40195,40196,40212,
   40218,40219,40222,40223,40232,40233,40254,40255,40258,40259,
   40268,40269,40450,40453,40454,40463,40464,40482,40483,40492,
   40493,40564,40573,40574,40598,40599,40779,43256,43262,43263,
   43266,43267,43276,43277,43298,43299,43302,43303,43312,43313,
   43494,43497,43498,43507,43508,43526,43527,43536,43537,43608,
   43617,43618,43642,43643,43823,43964,43965,43968,43969,43978,
   43979,44160,44163,44164,44173,44174,44192,44193,44202,44203,
   44274,44283,44284,44308,44309,44489,44790,44793,44794,44803,
   44804,44822,44823,44832,44833,44904,44913,44914,44938,44939,
   45119,47902,47903,47912,47913,47984,47993,47994,48018,48019,
   48199,48390,48399,48400,48424,48425,48605,49478,49479,49659,
   49959],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,
   2384,3500,3501,3505,3506,3507,3513,3514,3517,3518,3527,3528,
   3544,3548,3549,3550,3556,3557,3560,3561,3570,3571,3590,3591,
   3592,3598,3599,3602,3603,3612,3613,3749,3750,3756,3757,3760,
   3761,3770,3771,3787,3793,3794,3797,3798,3829,3830,3833,3834,
   3843,3844,4025,4028,4029,4038,4039,4057,4058,4139,4148,4149,
   4173,4174,4354,4510,4511,4512,4518,4528,4529,5645,5646,5650,
   5651,5652,5658,5659,5662,5663,5672,5673,5689,5693,5694,5695,
   5701,5702,5705,5706,5715,5716,5735,5736,5737,5743,5744,5747,
   5748,5757,5758,5894,5895,5902,5905,5906,5916,5932,5939,5942,
   5943,5953,5974,5975,5978,5979,5988,5989,6170,6173,6174,6183,
   6184,6202,6203,6212,6213,6284,6293,6294,6318,6319,6499,7725,
   7726,7730,7731,7732,7738,7739,7742,7743,7752,7753,7769,7773,
   7774,7775,7781,7782,7785,7786,7795,7796,7815,7816,7817,7823,
   7824,7827,7828,7837,7838,7974,7975,7985,7986,7995,7996,8012,
   8018,8019,8022,8023,8032,8033,8054,8055,8058,8059,8068,8069,
   8250,8253,8254,8263,8282,8283,8292,8364,8373,8374,8398,8399,
   8579,38205,38209,38210,38211,38217,38218,38221,38222,38231,
   38232,38251,38252,38253,38259,38260,38263,38264,38273,38274,
   38410,38411,38417,38418,38421,38422,38431,38432,38448,38454,
   38455,38458,38459,38468,38469,38490,38491,38494,38495,38504,
   38505,38686,38689,38690,38699,38700,38718,38719,38728,38729,
   38800,38809,38810,38834,38835,39015,39154,39155,39156,39162,
   39163,39166,39167,39176,39177,39313,39314,39320,39321,39324,
   39325,39334,39335,39351,39357,39358,39361,39362,39371,39372,
   39393,39394,39397,39398,39407,39408,39589,39592,39593,39602,
   39603,39621,39622,39631,39632,39703,39712,39713,39737,39738,
   39918,40174,40175,40181,40182,40185,40186,40195,40196,40212,
   40218,40219,40222,40223,40232,40233,40254,40255,40258,40259,
   40268,40269,40450,40453,40454,40463,40464,40482,40483,40492,
   40493,40564,40573,40574,40598,40599,40779,43256,43262,43263,
   43266,43267,43276,43277,43298,43299,43302,43303,43312,43313,
   43494,43497,43498,43507,43508,43526,43527,43536,43537,43608,
   43617,43618,43642,43643,43823,43964,43965,43968,43969,43978,
   43979,44160,44163,44164,44173,44174,44192,44193,44202,44203,
   44274,44283,44284,44308,44309,44489,44790,44793,44794,44803,
   44804,44822,44823,44832,44833,44904,44913,44914,44938,44939,
   45119,47902,47903,47912,47913,47984,47993,47994,48018,48019,
   48199,48390,48399,48400,48424,48425,48605,49478,49479,49659,
   49959],[2279],[2279],
 [2279,3500,3501,3507,3517,3518,3544,3550,3592,3833,3834,4139,
   5645,5646,5662,5689,5695,5705,5706,5747,5978,5979,6284,7725,
   7726,7743,7769,7786,7817,7827,7828,8058,8059,8364,38205,
   38211,38221,38222,38253,38263,38264,38494,38495,38800,39156,
   39166,39167,39397,39398,39703,40258,40259,40564,44904],
 [2279,3500,3501,3507,3517,3518,3544,3550,3592,3833,3834,4139,
   5645,5646,5662,5689,5695,5705,5706,5747,5978,5979,6284,7725,
   7726,7743,7769,7786,7817,7827,7828,8058,8059,8364,38205,
   38211,38221,38222,38253,38263,38264,38494,38495,38800,39156,
   39166,39167,39397,39398,39703,40258,40259,40564,44904],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,
   2384,3500,3501,3507,3510,3512,3517,3518,3519,3523,3525,3526,
   3544,3550,3553,3555,3560,3561,3562,3566,3568,3569,3592,3595,
   3597,3602,3603,3604,3608,3610,3611,3826,3828,3833,3834,3835,
   3839,3841,3842,3930,3935,3936,3937,3941,3998,3999,4000,4004,
   4139,4140,4144,4146,4147,4165,4169,4171,4172,4193,4195,4196,
   4281,4282,4319,4510,4511,4512,4518,4528,4529,5645,5646,5652,
   5655,5657,5662,5663,5664,5668,5670,5671,5689,5695,5698,5700,
   5705,5706,5707,5711,5713,5714,5737,5740,5742,5747,5748,5749,
   5753,5755,5756,5971,5973,5978,5979,5980,5984,5986,5987,6075,
   6080,6081,6086,6089,6143,6144,6145,6149,6151,6152,6284,6285,
   6289,6291,6292,6310,6314,6316,6317,6340,6341,6427,6464,7725,
   7726,7732,7735,7737,7742,7743,7744,7748,7750,7751,7769,7775,
   7778,7780,7785,7786,7787,7791,7793,7794,7817,7820,7822,7827,
   7828,7829,7833,7835,7836,8051,8053,8058,8059,8060,8064,8066,
   8067,8155,8160,8161,8162,8166,8168,8169,8223,8224,8225,8231,
   8364,8365,8369,8371,8372,8390,8394,8396,8397,8420,8506,8507,
   8544,38205,38211,38214,38216,38221,38222,38223,38227,38229,
   38230,38253,38256,38258,38263,38264,38265,38269,38271,38272,
   38487,38489,38494,38495,38496,38500,38502,38503,38591,38596,
   38597,38598,38602,38604,38605,38659,38660,38661,38665,38667,
   38668,38800,38801,38805,38807,38808,38826,38830,38832,38833,
   38854,38856,38857,38942,38943,38980,39156,39159,39161,39166,
   39167,39168,39172,39174,39175,39390,39392,39397,39398,39399,
   39403,39405,39406,39494,39499,39500,39501,39505,39507,39508,
   39562,39563,39564,39568,39570,39571,39703,39704,39708,39710,
   39711,39729,39733,39735,39736,39757,39759,39760,39845,39846,
   39883,40251,40253,40258,40259,40260,40264,40266,40267,40355,
   40360,40361,40362,40366,40368,40369,40423,40424,40425,40429,
   40431,40432,40564,40565,40569,40571,40572,40590,40594,40596,
   40597,40618,40620,40621,40706,40707,40744,44695,44700,44701,
   44702,44706,44708,44709,44763,44764,44765,44769,44771,44772,
   44904,44905,44909,44911,44912,44930,44934,44936,44937,44958,
   44960,44961,45046,45047,45084,46447,46448,46449,46453,46455,
   46456,46588,46589,46593,46595,46596,46614,46618,46620,46621,
   46642,46644,46645,46730,46731,46768,47549,47550,47554,47556,
   47557,47575,47579,47581,47582,47603,47605,47606,47691,47692,
   47729,49470,49474,49476,49477,49498,49500,49501,49586,49587,
   49624,49798,49800,49801,49886,49887,49924,50162,50163,50200,
   51084],
 [2279,3714,3725,3905,5859,5870,6050,7939,7950,8130,42671],
 [2279],[1,2,23,26,31,32,41,42,44,68,89,90,91,92,93,94,
   107,156,157,158,163,164,166,173,177,179,1289,1290,1291,
   1292,1293,1296,1297,1298,1300,1306,1307,1309,1311,1313,1333,
   1334,1335,1336,1339,1340,1341,1343,1349,1350,1352,1354,1356,
   1376,1377,1378,1381,1382,1383,1385,1391,1392,1394,1396,1398,
   1418,1419,1422,1423,1424,1426,1432,1433,1435,1437,1439,1459,
   1462,1463,1464,1466,1472,1473,1475,1477,1479,1501,1502,1503,
   1505,1511,1512,1514,1516,1518,1613,1614,1616,1622,1623,1625,
   1627,1629,1649,1651,1657,1658,1660,1662,1664,1685,1691,1692,
   1694,1696,1698,1756,1757,1759,1761,1763,1928,1930,1932,1934,
   1955,1957,1959,2004,2006,2049,2279,2300,2301,2302,2305,2308,
   2310,2318,2319,2321,2365,2366,2367,2370,2373,2375,2383,2384,
   2386,3500,3501,3502,3503,3504,3507,3508,3509,3511,3517,3518,
   3520,3522,3524,3544,3545,3546,3547,3550,3551,3552,3554,3560,
   3561,3563,3565,3567,3587,3588,3589,3592,3593,3594,3596,3602,
   3603,3605,3607,3609,3629,3630,3633,3634,3635,3637,3643,3644,
   3646,3648,3650,3670,3673,3674,3675,3677,3683,3684,3686,3688,
   3690,3712,3713,3714,3716,3722,3723,3725,3727,3729,3824,3825,
   3827,3833,3834,3836,3838,3840,3860,3862,3868,3869,3871,3873,
   3875,3896,3902,3903,3905,3907,3909,3967,3968,3970,3972,3974,
   4139,4141,4143,4145,4166,4168,4170,4215,4217,4260,4510,4511,
   4512,4515,4518,4520,4528,4529,4531,5645,5646,5647,5648,5649,
   5652,5653,5654,5656,5662,5663,5665,5667,5669,5689,5690,5691,
   5692,5695,5696,5697,5699,5705,5706,5708,5710,5712,5732,5733,
   5734,5737,5738,5739,5741,5747,5748,5750,5752,5754,5774,5775,
   5778,5779,5780,5782,5788,5789,5791,5793,5795,5815,5818,5819,
   5820,5822,5828,5829,5831,5833,5835,5857,5858,5859,5861,5867,
   5868,5870,5872,5874,5969,5970,5972,5978,5979,5981,5983,5985,
   6005,6007,6013,6014,6016,6018,6020,6041,6047,6048,6050,6052,
   6054,6112,6113,6115,6117,6119,6284,6286,6288,6290,6311,6313,
   6315,6360,6362,6405,7725,7726,7727,7728,7729,7732,7733,7734,
   7736,7742,7743,7745,7747,7749,7769,7770,7771,7772,7775,7776,
   7777,7779,7785,7786,7788,7790,7792,7812,7813,7814,7817,7818,
   7819,7821,7827,7828,7830,7832,7834,7854,7855,7858,7859,7860,
   7862,7868,7869,7871,7873,7875,7895,7898,7899,7900,7902,7908,
   7909,7911,7913,7915,7937,7938,7939,7941,7947,7948,7950,7952,
   7954,8049,8050,8052,8058,8059,8061,8063,8065,8085,8087,8093,
   8094,8096,8098,8100,8121,8127,8128,8130,8132,8134,8192,8193,
   8195,8197,8199,8364,8366,8368,8370,8391,8393,8395,8440,8442,
   8485,38205,38206,38207,38208,38211,38212,38213,38215,38221,
   38222,38224,38226,38228,38248,38249,38250,38253,38254,38255,
   38257,38263,38264,38266,38268,38270,38290,38291,38294,38295,
   38296,38298,38304,38305,38307,38309,38311,38331,38334,38335,
   38336,38338,38344,38345,38347,38349,38351,38373,38374,38375,
   38377,38383,38384,38386,38388,38390,38485,38486,38488,38494,
   38495,38497,38499,38501,38521,38523,38529,38530,38532,38534,
   38536,38557,38563,38564,38566,38568,38570,38628,38629,38631,
   38633,38635,38800,38802,38804,38806,38827,38829,38831,38876,
   38878,38921,39151,39152,39153,39156,39157,39158,39160,39166,
   39167,39169,39171,39173,39193,39194,39197,39198,39199,39201,
   39207,39208,39210,39212,39214,39234,39237,39238,39239,39241,
   39247,39248,39250,39252,39254,39276,39277,39278,39280,39286,
   39287,39289,39291,39293,39388,39389,39391,39397,39398,39400,
   39402,39404,39424,39426,39432,39433,39435,39437,39439,39460,
   39466,39467,39469,39471,39473,39531,39532,39534,39536,39538,
   39703,39705,39707,39709,39730,39732,39734,39779,39781,39824,
   40054,40055,40058,40059,40060,40062,40068,40069,40071,40073,
   40075,40095,40098,40099,40100,40102,40108,40109,40111,40113,
   40115,40137,40138,40139,40141,40147,40148,40150,40152,40154,
   40249,40250,40252,40258,40259,40261,40263,40265,40285,40287,
   40293,40294,40296,40298,40300,40321,40327,40328,40330,40332,
   40334,40392,40393,40395,40397,40399,40564,40566,40568,40570,
   40591,40593,40595,40640,40642,40685,40915,40918,40919,40920,
   40922,40928,40929,40931,40933,40935,40957,40958,40959,40961,
   40967,40968,40970,40972,40974,41069,41070,41072,41078,41079,
   41081,41083,41085,41105,41107,41113,41114,41116,41118,41120,
   41141,41147,41148,41150,41152,41154,41212,41213,41215,41217,
   41219,41384,41386,41388,41390,41411,41413,41415,41460,41462,
   41505,41737,41738,41739,41741,41747,41748,41750,41752,41754,
   41849,41850,41852,41858,41859,41861,41863,41865,41885,41887,
   41893,41894,41896,41898,41900,41921,41927,41928,41930,41932,
   41934,41992,41993,41995,41997,41999,42164,42166,42168,42170,
   42191,42193,42195,42240,42242,42285,42590,42591,42593,42599,
   42600,42602,42604,42606,42626,42628,42634,42635,42637,42639,
   42641,42662,42668,42669,42671,42673,42675,42733,42734,42736,
   42738,42740,42905,42907,42909,42911,42932,42934,42936,42981,
   42983,43026,44625,44627,44633,44634,44636,44638,44640,44661,
   44667,44668,44670,44672,44674,44732,44733,44735,44737,44739,
   44904,44906,44908,44910,44931,44933,44935,44980,44982,45025,
   45256,45262,45263,45265,45267,45269,45327,45328,45330,45332,
   45334,45499,45501,45503,45505,45526,45528,45530,45575,45577,
   45620,45888,45889,45891,45893,45895,46060,46062,46064,46066,
   46087,46089,46091,46136,46138,46181,47084,47086,47088,47090,
   47111,47113,47115,47160,47162,47205,49471,49473,49475,49520,
   49522,49565,49820,49822,49865,50394],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,
   2384,3500,3501,3507,3510,3512,3517,3518,3519,3523,3525,3526,
   3544,3550,3553,3555,3560,3561,3562,3566,3568,3569,3592,3595,
   3597,3602,3603,3604,3608,3610,3611,3826,3828,3833,3834,3835,
   3839,3841,3842,3930,3935,3936,3937,3941,3998,3999,4000,4004,
   4139,4140,4144,4146,4147,4165,4169,4171,4172,4193,4195,4196,
   4281,4282,4319,4510,4511,4512,4518,4528,4529,5645,5646,5652,
   5655,5657,5662,5663,5664,5668,5670,5671,5689,5695,5698,5700,
   5705,5706,5707,5711,5713,5714,5737,5740,5742,5747,5748,5749,
   5753,5755,5756,5971,5973,5978,5979,5980,5984,5986,5987,6075,
   6080,6081,6086,6089,6143,6144,6145,6149,6151,6152,6284,6285,
   6289,6291,6292,6310,6314,6316,6317,6340,6341,6427,6464,7725,
   7726,7732,7735,7737,7742,7743,7744,7748,7750,7751,7769,7775,
   7778,7780,7785,7786,7787,7791,7793,7794,7817,7820,7822,7827,
   7828,7829,7833,7835,7836,8051,8053,8058,8059,8060,8064,8066,
   8067,8155,8160,8161,8162,8166,8168,8169,8223,8224,8225,8231,
   8364,8365,8369,8371,8372,8390,8394,8396,8397,8420,8506,8507,
   8544,38205,38211,38214,38216,38221,38222,38223,38227,38229,
   38230,38253,38256,38258,38263,38264,38265,38269,38271,38272,
   38487,38489,38494,38495,38496,38500,38502,38503,38591,38596,
   38597,38598,38602,38604,38605,38659,38660,38661,38665,38667,
   38668,38800,38801,38805,38807,38808,38826,38830,38832,38833,
   38854,38856,38857,38942,38943,38980,39156,39159,39161,39166,
   39167,39168,39172,39174,39175,39390,39392,39397,39398,39399,
   39403,39405,39406,39494,39499,39500,39501,39505,39507,39508,
   39562,39563,39564,39568,39570,39571,39703,39704,39708,39710,
   39711,39729,39733,39735,39736,39757,39759,39760,39845,39846,
   39883,40251,40253,40258,40259,40260,40264,40266,40267,40355,
   40360,40361,40362,40366,40368,40369,40423,40424,40425,40429,
   40431,40432,40564,40565,40569,40571,40572,40590,40594,40596,
   40597,40618,40620,40621,40706,40707,40744,44695,44700,44701,
   44702,44706,44708,44709,44763,44764,44765,44769,44771,44772,
   44904,44905,44909,44911,44912,44930,44934,44936,44937,44958,
   44960,44961,45046,45047,45084,46447,46448,46449,46453,46455,
   46456,46588,46589,46593,46595,46596,46614,46618,46620,46621,
   46642,46644,46645,46730,46731,46768,47549,47550,47554,47556,
   47557,47575,47579,47581,47582,47603,47605,47606,47691,47692,
   47729,49470,49474,49476,49477,49498,49500,49501,49586,49587,
   49624,49798,49800,49801,49886,49887,49924,50162,50163,50200,
   51084],
 [1,2,23,26,31,32,41,42,44,68,89,90,91,92,93,94,107,156,
   157,158,163,164,166,173,177,179,1289,1290,1291,1292,1293,
   1296,1297,1298,1300,1306,1307,1309,1311,1313,1333,1334,1335,
   1336,1339,1340,1341,1343,1349,1350,1352,1354,1356,1376,1377,
   1378,1381,1382,1383,1385,1391,1392,1394,1396,1398,1418,1419,
   1422,1423,1424,1426,1432,1433,1435,1437,1439,1459,1462,1463,
   1464,1466,1472,1473,1475,1477,1479,1501,1502,1503,1505,1511,
   1512,1514,1516,1518,1613,1614,1616,1622,1623,1625,1627,1629,
   1649,1651,1657,1658,1660,1662,1664,1685,1691,1692,1694,1696,
   1698,1756,1757,1759,1761,1763,1928,1930,1932,1934,1955,1957,
   1959,2004,2006,2049,2279,2300,2301,2302,2305,2308,2310,2318,
   2319,2321,2365,2366,2367,2370,2373,2375,2383,2384,2386,3500,
   3501,3502,3503,3504,3507,3508,3509,3511,3517,3518,3520,3522,
   3524,3544,3545,3546,3547,3550,3551,3552,3554,3560,3561,3563,
   3565,3567,3587,3588,3589,3592,3593,3594,3596,3602,3603,3605,
   3607,3609,3629,3630,3633,3634,3635,3637,3643,3644,3646,3648,
   3650,3670,3673,3674,3675,3677,3683,3684,3686,3688,3690,3712,
   3713,3714,3716,3722,3723,3725,3727,3729,3824,3825,3827,3833,
   3834,3836,3838,3840,3860,3862,3868,3869,3871,3873,3875,3896,
   3902,3903,3905,3907,3909,3967,3968,3970,3972,3974,4139,4141,
   4143,4145,4166,4168,4170,4215,4217,4260,4510,4511,4512,4515,
   4518,4520,4528,4529,4531,5645,5646,5647,5648,5649,5652,5653,
   5654,5656,5662,5663,5665,5667,5669,5689,5690,5691,5692,5695,
   5696,5697,5699,5705,5706,5708,5710,5712,5732,5733,5734,5737,
   5738,5739,5741,5747,5748,5750,5752,5754,5774,5775,5778,5779,
   5780,5782,5788,5789,5791,5793,5795,5815,5818,5819,5820,5822,
   5828,5829,5831,5833,5835,5857,5858,5859,5861,5867,5868,5870,
   5872,5874,5969,5970,5972,5978,5979,5981,5983,5985,6005,6007,
   6013,6014,6016,6018,6020,6041,6047,6048,6050,6052,6054,6112,
   6113,6115,6117,6119,6284,6286,6288,6290,6311,6313,6315,6360,
   6362,6405,7725,7726,7727,7728,7729,7732,7733,7734,7736,7742,
   7743,7745,7747,7749,7769,7770,7771,7772,7775,7776,7777,7779,
   7785,7786,7788,7790,7792,7812,7813,7814,7817,7818,7819,7821,
   7827,7828,7830,7832,7834,7854,7855,7858,7859,7860,7862,7868,
   7869,7871,7873,7875,7895,7898,7899,7900,7902,7908,7909,7911,
   7913,7915,7937,7938,7939,7941,7947,7948,7950,7952,7954,8049,
   8050,8052,8058,8059,8061,8063,8065,8085,8087,8093,8094,8096,
   8098,8100,8121,8127,8128,8130,8132,8134,8192,8193,8195,8197,
   8199,8364,8366,8368,8370,8391,8393,8395,8440,8442,8485,
   38205,38206,38207,38208,38211,38212,38213,38215,38221,38222,
   38224,38226,38228,38248,38249,38250,38253,38254,38255,38257,
   38263,38264,38266,38268,38270,38290,38291,38294,38295,38296,
   38298,38304,38305,38307,38309,38311,38331,38334,38335,38336,
   38338,38344,38345,38347,38349,38351,38373,38374,38375,38377,
   38383,38384,38386,38388,38390,38485,38486,38488,38494,38495,
   38497,38499,38501,38521,38523,38529,38530,38532,38534,38536,
   38557,38563,38564,38566,38568,38570,38628,38629,38631,38633,
   38635,38800,38802,38804,38806,38827,38829,38831,38876,38878,
   38921,39151,39152,39153,39156,39157,39158,39160,39166,39167,
   39169,39171,39173,39193,39194,39197,39198,39199,39201,39207,
   39208,39210,39212,39214,39234,39237,39238,39239,39241,39247,
   39248,39250,39252,39254,39276,39277,39278,39280,39286,39287,
   39289,39291,39293,39388,39389,39391,39397,39398,39400,39402,
   39404,39424,39426,39432,39433,39435,39437,39439,39460,39466,
   39467,39469,39471,39473,39531,39532,39534,39536,39538,39703,
   39705,39707,39709,39730,39732,39734,39779,39781,39824,40054,
   40055,40058,40059,40060,40062,40068,40069,40071,40073,40075,
   40095,40098,40099,40100,40102,40108,40109,40111,40113,40115,
   40137,40138,40139,40141,40147,40148,40150,40152,40154,40249,
   40250,40252,40258,40259,40261,40263,40265,40285,40287,40293,
   40294,40296,40298,40300,40321,40327,40328,40330,40332,40334,
   40392,40393,40395,40397,40399,40564,40566,40568,40570,40591,
   40593,40595,40640,40642,40685,40915,40918,40919,40920,40922,
   40928,40929,40931,40933,40935,40957,40958,40959,40961,40967,
   40968,40970,40972,40974,41069,41070,41072,41078,41079,41081,
   41083,41085,41105,41107,41113,41114,41116,41118,41120,41141,
   41147,41148,41150,41152,41154,41212,41213,41215,41217,41219,
   41384,41386,41388,41390,41411,41413,41415,41460,41462,41505,
   41737,41738,41739,41741,41747,41748,41750,41752,41754,41849,
   41850,41852,41858,41859,41861,41863,41865,41885,41887,41893,
   41894,41896,41898,41900,41921,41927,41928,41930,41932,41934,
   41992,41993,41995,41997,41999,42164,42166,42168,42170,42191,
   42193,42195,42240,42242,42285,42590,42591,42593,42599,42600,
   42602,42604,42606,42626,42628,42634,42635,42637,42639,42641,
   42662,42668,42669,42671,42673,42675,42733,42734,42736,42738,
   42740,42905,42907,42909,42911,42932,42934,42936,42981,42983,
   43026,44625,44627,44633,44634,44636,44638,44640,44661,44667,
   44668,44670,44672,44674,44732,44733,44735,44737,44739,44904,
   44906,44908,44910,44931,44933,44935,44980,44982,45025,45256,
   45262,45263,45265,45267,45269,45327,45328,45330,45332,45334,
   45499,45501,45503,45505,45526,45528,45530,45575,45577,45620,
   45888,45889,45891,45893,45895,46060,46062,46064,46066,46087,
   46089,46091,46136,46138,46181,47084,47086,47088,47090,47111,
   47113,47115,47160,47162,47205,49471,49473,49475,49520,49522,
   49565,49820,49822,49865,50394],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,
   2384,3500,3501,3507,3510,3512,3517,3518,3519,3523,3525,3526,
   3544,3550,3553,3555,3560,3561,3562,3566,3568,3569,3592,3595,
   3597,3602,3603,3604,3608,3610,3611,3826,3828,3833,3834,3835,
   3839,3841,3842,3930,3935,3936,3937,3941,3998,3999,4000,4004,
   4139,4140,4144,4146,4147,4165,4169,4171,4172,4193,4195,4196,
   4281,4282,4319,4510,4511,4512,4518,4528,4529,5645,5646,5652,
   5655,5657,5662,5663,5664,5668,5670,5671,5689,5695,5698,5700,
   5705,5706,5707,5711,5713,5714,5737,5740,5742,5747,5748,5749,
   5753,5755,5756,5971,5973,5978,5979,5980,5984,5986,5987,6075,
   6080,6081,6086,6089,6143,6144,6145,6149,6151,6152,6284,6285,
   6289,6291,6292,6310,6314,6316,6317,6340,6341,6427,6464,7725,
   7726,7732,7735,7737,7742,7743,7744,7748,7750,7751,7769,7775,
   7778,7780,7785,7786,7787,7791,7793,7794,7817,7820,7822,7827,
   7828,7829,7833,7835,7836,8051,8053,8058,8059,8060,8064,8066,
   8067,8155,8160,8161,8162,8166,8168,8169,8223,8224,8225,8231,
   8364,8365,8369,8371,8372,8390,8394,8396,8397,8420,8506,8507,
   8544,38205,38211,38214,38216,38221,38222,38223,38227,38229,
   38230,38253,38256,38258,38263,38264,38265,38269,38271,38272,
   38487,38489,38494,38495,38496,38500,38502,38503,38591,38596,
   38597,38598,38602,38604,38605,38659,38660,38661,38665,38667,
   38668,38800,38801,38805,38807,38808,38826,38830,38832,38833,
   38854,38856,38857,38942,38943,38980,39156,39159,39161,39166,
   39167,39168,39172,39174,39175,39390,39392,39397,39398,39399,
   39403,39405,39406,39494,39499,39500,39501,39505,39507,39508,
   39562,39563,39564,39568,39570,39571,39703,39704,39708,39710,
   39711,39729,39733,39735,39736,39757,39759,39760,39845,39846,
   39883,40251,40253,40258,40259,40260,40264,40266,40267,40355,
   40360,40361,40362,40366,40368,40369,40423,40424,40425,40429,
   40431,40432,40564,40565,40569,40571,40572,40590,40594,40596,
   40597,40618,40620,40621,40706,40707,40744,44695,44700,44701,
   44702,44706,44708,44709,44763,44764,44765,44769,44771,44772,
   44904,44905,44909,44911,44912,44930,44934,44936,44937,44958,
   44960,44961,45046,45047,45084,46447,46448,46449,46453,46455,
   46456,46588,46589,46593,46595,46596,46614,46618,46620,46621,
   46642,46644,46645,46730,46731,46768,47549,47550,47554,47556,
   47557,47575,47579,47581,47582,47603,47605,47606,47691,47692,
   47729,49470,49474,49476,49477,49498,49500,49501,49586,49587,
   49624,49798,49800,49801,49886,49887,49924,50162,50163,50200,
   51084],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,
   2384,3500,3501,3507,3510,3512,3517,3518,3519,3523,3525,3526,
   3544,3550,3553,3555,3560,3561,3562,3566,3568,3569,3592,3595,
   3597,3602,3603,3604,3608,3610,3611,3826,3828,3833,3834,3835,
   3839,3841,3842,3930,3935,3936,3937,3941,3998,3999,4000,4004,
   4139,4140,4144,4146,4147,4165,4169,4171,4172,4193,4195,4196,
   4281,4282,4319,4510,4511,4512,4518,4528,4529,5645,5646,5652,
   5655,5657,5662,5663,5664,5668,5670,5671,5689,5695,5698,5700,
   5705,5706,5707,5711,5713,5714,5737,5740,5742,5747,5748,5749,
   5753,5755,5756,5971,5973,5978,5979,5980,5984,5986,5987,6075,
   6080,6081,6086,6089,6143,6144,6145,6149,6151,6152,6284,6285,
   6289,6291,6292,6310,6314,6316,6317,6340,6341,6427,6464,7725,
   7726,7732,7735,7737,7742,7743,7744,7748,7750,7751,7769,7775,
   7778,7780,7785,7786,7787,7791,7793,7794,7817,7820,7822,7827,
   7828,7829,7833,7835,7836,8051,8053,8058,8059,8060,8064,8066,
   8067,8155,8160,8161,8162,8166,8168,8169,8223,8224,8225,8231,
   8364,8365,8369,8371,8372,8390,8394,8396,8397,8420,8506,8507,
   8544,38205,38211,38214,38216,38221,38222,38223,38227,38229,
   38230,38253,38256,38258,38263,38264,38265,38269,38271,38272,
   38487,38489,38494,38495,38496,38500,38502,38503,38591,38596,
   38597,38598,38602,38604,38605,38659,38660,38661,38665,38667,
   38668,38800,38801,38805,38807,38808,38826,38830,38832,38833,
   38854,38856,38857,38942,38943,38980,39156,39159,39161,39166,
   39167,39168,39172,39174,39175,39390,39392,39397,39398,39399,
   39403,39405,39406,39494,39499,39500,39501,39505,39507,39508,
   39562,39563,39564,39568,39570,39571,39703,39704,39708,39710,
   39711,39729,39733,39735,39736,39757,39759,39760,39845,39846,
   39883,40251,40253,40258,40259,40260,40264,40266,40267,40355,
   40360,40361,40362,40366,40368,40369,40423,40424,40425,40429,
   40431,40432,40564,40565,40569,40571,40572,40590,40594,40596,
   40597,40618,40620,40621,40706,40707,40744,44695,44700,44701,
   44702,44706,44708,44709,44763,44764,44765,44769,44771,44772,
   44904,44905,44909,44911,44912,44930,44934,44936,44937,44958,
   44960,44961,45046,45047,45084,46447,46448,46449,46453,46455,
   46456,46588,46589,46593,46595,46596,46614,46618,46620,46621,
   46642,46644,46645,46730,46731,46768,47549,47550,47554,47556,
   47557,47575,47579,47581,47582,47603,47605,47606,47691,47692,
   47729,49470,49474,49476,49477,49498,49500,49501,49586,49587,
   49624,49798,49800,49801,49886,49887,49924,50162,50163,50200,
   51084],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,
   2384,3500,3501,3505,3506,3507,3513,3514,3517,3518,3527,3528,
   3544,3548,3549,3550,3556,3557,3560,3561,3570,3571,3590,3591,
   3592,3598,3599,3602,3603,3612,3613,3749,3750,3756,3757,3760,
   3761,3770,3771,3787,3793,3794,3797,3798,3829,3830,3833,3834,
   3843,3844,4025,4028,4029,4038,4039,4057,4058,4139,4148,4149,
   4173,4174,4354,4510,4511,4512,4518,4528,4529,5645,5646,5650,
   5651,5652,5658,5659,5662,5663,5672,5673,5689,5693,5694,5695,
   5701,5702,5705,5706,5715,5716,5735,5736,5737,5743,5744,5747,
   5748,5757,5758,5894,5895,5902,5905,5906,5916,5932,5939,5942,
   5943,5953,5974,5975,5978,5979,5988,5989,6170,6173,6174,6183,
   6184,6202,6203,6212,6213,6284,6293,6294,6318,6319,6499,7725,
   7726,7730,7731,7732,7738,7739,7742,7743,7752,7753,7769,7773,
   7774,7775,7781,7782,7785,7786,7795,7796,7815,7816,7817,7823,
   7824,7827,7828,7837,7838,7974,7975,7985,7986,7995,7996,8012,
   8018,8019,8022,8023,8032,8033,8054,8055,8058,8059,8068,8069,
   8250,8253,8254,8263,8282,8283,8292,8364,8373,8374,8398,8399,
   8579,38205,38209,38210,38211,38217,38218,38221,38222,38231,
   38232,38251,38252,38253,38259,38260,38263,38264,38273,38274,
   38410,38411,38417,38418,38421,38422,38431,38432,38448,38454,
   38455,38458,38459,38468,38469,38490,38491,38494,38495,38504,
   38505,38686,38689,38690,38699,38700,38718,38719,38728,38729,
   38800,38809,38810,38834,38835,39015,39154,39155,39156,39162,
   39163,39166,39167,39176,39177,39313,39314,39320,39321,39324,
   39325,39334,39335,39351,39357,39358,39361,39362,39371,39372,
   39393,39394,39397,39398,39407,39408,39589,39592,39593,39602,
   39603,39621,39622,39631,39632,39703,39712,39713,39737,39738,
   39918,40174,40175,40181,40182,40185,40186,40195,40196,40212,
   40218,40219,40222,40223,40232,40233,40254,40255,40258,40259,
   40268,40269,40450,40453,40454,40463,40464,40482,40483,40492,
   40493,40564,40573,40574,40598,40599,40779,43256,43262,43263,
   43266,43267,43276,43277,43298,43299,43302,43303,43312,43313,
   43494,43497,43498,43507,43508,43526,43527,43536,43537,43608,
   43617,43618,43642,43643,43823,43964,43965,43968,43969,43978,
   43979,44160,44163,44164,44173,44174,44192,44193,44202,44203,
   44274,44283,44284,44308,44309,44489,44790,44793,44794,44803,
   44804,44822,44823,44832,44833,44904,44913,44914,44938,44939,
   45119,47902,47903,47912,47913,47984,47993,47994,48018,48019,
   48199,48390,48399,48400,48424,48425,48605,49478,49479,49659,
   49959],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,
   2384,3500,3501,3505,3506,3507,3513,3514,3517,3518,3527,3528,
   3544,3548,3549,3550,3556,3557,3560,3561,3570,3571,3590,3591,
   3592,3598,3599,3602,3603,3612,3613,3749,3750,3756,3757,3760,
   3761,3770,3771,3787,3793,3794,3797,3798,3829,3830,3833,3834,
   3843,3844,4025,4028,4029,4038,4039,4057,4058,4139,4148,4149,
   4173,4174,4354,4510,4511,4512,4518,4528,4529,5645,5646,5650,
   5651,5652,5658,5659,5662,5663,5672,5673,5689,5693,5694,5695,
   5701,5702,5705,5706,5715,5716,5735,5736,5737,5743,5744,5747,
   5748,5757,5758,5894,5895,5902,5905,5906,5916,5932,5939,5942,
   5943,5953,5974,5975,5978,5979,5988,5989,6170,6173,6174,6183,
   6184,6202,6203,6212,6213,6284,6293,6294,6318,6319,6499,7725,
   7726,7730,7731,7732,7738,7739,7742,7743,7752,7753,7769,7773,
   7774,7775,7781,7782,7785,7786,7795,7796,7815,7816,7817,7823,
   7824,7827,7828,7837,7838,7974,7975,7985,7986,7995,7996,8012,
   8018,8019,8022,8023,8032,8033,8054,8055,8058,8059,8068,8069,
   8250,8253,8254,8263,8282,8283,8292,8364,8373,8374,8398,8399,
   8579,38205,38209,38210,38211,38217,38218,38221,38222,38231,
   38232,38251,38252,38253,38259,38260,38263,38264,38273,38274,
   38410,38411,38417,38418,38421,38422,38431,38432,38448,38454,
   38455,38458,38459,38468,38469,38490,38491,38494,38495,38504,
   38505,38686,38689,38690,38699,38700,38718,38719,38728,38729,
   38800,38809,38810,38834,38835,39015,39154,39155,39156,39162,
   39163,39166,39167,39176,39177,39313,39314,39320,39321,39324,
   39325,39334,39335,39351,39357,39358,39361,39362,39371,39372,
   39393,39394,39397,39398,39407,39408,39589,39592,39593,39602,
   39603,39621,39622,39631,39632,39703,39712,39713,39737,39738,
   39918,40174,40175,40181,40182,40185,40186,40195,40196,40212,
   40218,40219,40222,40223,40232,40233,40254,40255,40258,40259,
   40268,40269,40450,40453,40454,40463,40464,40482,40483,40492,
   40493,40564,40573,40574,40598,40599,40779,43256,43262,43263,
   43266,43267,43276,43277,43298,43299,43302,43303,43312,43313,
   43494,43497,43498,43507,43508,43526,43527,43536,43537,43608,
   43617,43618,43642,43643,43823,43964,43965,43968,43969,43978,
   43979,44160,44163,44164,44173,44174,44192,44193,44202,44203,
   44274,44283,44284,44308,44309,44489,44790,44793,44794,44803,
   44804,44822,44823,44832,44833,44904,44913,44914,44938,44939,
   45119,47902,47903,47912,47913,47984,47993,47994,48018,48019,
   48199,48390,48399,48400,48424,48425,48605,49478,49479,49659,
   49959],[2279],[2279],[2279],[2279],[2279],[2279],
 [2279],[2279],[2279],[2279],[2279],[2279],[2279],
 [2279],[2279],[2279],[2279],
 [2279,2280,2281,2300,2301,2302,2308,2318,2319,2345,2346,2365,
   2366,2367,2373,2383,2384,2410,2411,2429,2430,2431,2437,2447,
   2448,2474,2492,2493,2494,2500,2510,2511,2554,2555,2556,2562,
   2572,2573,3500,3501,3507,3517,3518,3544,3550,3560,3561,3592,
   3602,3603,3833,3834,4139,4490,4491,4510,4511,4512,4518,4528,
   4529,4555,4556,4574,4575,4576,4582,4592,4593,4619,4637,4638,
   4639,4645,4655,4656,4699,4700,4701,4707,4717,4718,5645,5646,
   5652,5662,5663,5689,5695,5705,5706,5737,5747,5748,5978,5979,
   6284,6635,6636,6654,6655,6656,6662,6672,6673,6699,6717,6718,
   6719,6725,6735,6736,6779,6780,6781,6787,6797,6798,7725,7726,
   7732,7742,7743,7769,7775,7785,7786,7817,7827,7828,8058,8059,
   8364,8715,8733,8734,8735,8741,8751,8752,8795,8796,8797,8803,
   8813,8814,9741,9742,9748,9758,9759,9785,9791,9801,9802,9833,
   9843,9844,10074,10075,10380,10748,10749,10750,10756,10766,
   10767,11694,11695,11701,11711,11712,11738,11744,11754,11755,
   11786,11796,11797,12027,12028,12333,13585,13586,13592,13602,
   13603,13629,13635,13645,13646,13677,13687,13688,13918,13919,
   14224,38205,38211,38221,38222,38253,38263,38264,38494,38495,
   38800,39156,39166,39167,39397,39398,39703,40258,40259,40564,
   44904],[2279],[2279],
 [2279,2281,2284,2300,2301,2302,2308,2318,2319,2346,2349,2365,
   2366,2367,2373,2383,2384,2476,2477,2492,2493,2494,2500,2510,
   2511,2660,2675,2676,2677,2683,2693,2694,2734,2735,2736,2742,
   2752,2753,3500,3501,3507,3517,3518,3544,3550,3560,3561,3592,
   3602,3603,3833,3834,4139,4491,4494,4510,4511,4512,4518,4528,
   4529,4621,4622,4637,4638,4639,4645,4655,4656,4805,4820,4821,
   4822,4828,4838,4839,4879,4880,4881,4887,4897,4898,5645,5646,
   5652,5662,5663,5689,5695,5705,5706,5737,5747,5748,5978,5979,
   6284,6701,6702,6717,6718,6719,6725,6735,6736,6885,6900,6901,
   6902,6908,6918,6919,6959,6960,6961,6967,6977,6978,7725,7726,
   7732,7742,7743,7769,7775,7785,7786,7817,7827,7828,8058,8059,
   8364,10854,10869,10870,10871,10877,10887,10888,10928,10929,
   10930,10936,10946,10947,11694,11695,11701,11711,11712,11738,
   11744,11754,11755,11786,11796,11797,12027,12028,12333,16419,
   16420,16421,16427,16437,16438,17185,17186,17192,17202,17203,
   17229,17235,17245,17246,17277,17287,17288,17518,17519,17824,
   18896,18897,18903,18913,18914,18940,18946,18956,18957,18988,
   18998,18999,19229,19230,19535,38205,38211,38221,38222,38253,
   38263,38264,38494,38495,38800,39156,39166,39167,39397,39398,
   39703,40258,40259,40564,44904],[2279],
 [2279,2305,2310,2321,2370,2375,2386,2854,2859,2870,3714,3725,
   3905,4515,4520,4531,4999,5004,5015,5859,5870,6050,7079,7084,
   7095,7939,7950,8130,22359,22370,22550,42671],[2279],
 [2279],[2279],[2279],
 [2279,2290,2291,2355,2356,3005,3006,3059,4500,4501,5150,5151,
   5204,7230,7231,7284,26160],[2279],
 [2279,2291,2293,2356,2358,3060,3061,3164,4501,4503,5205,5206,
   5309,7285,7286,7389,27643],[2279],[2279],
 [2279,2293,2296,2358,2361,3166,3167,3314,4503,4506,5311,5312,
   5459,7391,7392,7539,30394],[2279],
 [2279,2291,2293,2294,2356,2358,2359,3060,3061,3066,3164,3169,
   3219,4501,4503,4504,5205,5206,5211,5309,5314,5364,7285,7286,
   7291,7389,7394,7444,27643,27648,27698,30299],
 [2279,3500,3501,3507,3517,3518,3544,3550,3592,3833,3834,4139,
   5645,5646,5662,5689,5695,5705,5706,5747,5978,5979,6284,7725,
   7726,7743,7769,7786,7817,7827,7828,8058,8059,8364,38205,
   38211,38221,38222,38253,38263,38264,38494,38495,38800,39156,
   39166,39167,39397,39398,39703,40258,40259,40564,44904],
 [2279,3500,3501,3507,3517,3518,3544,3550,3592,3833,3834,4139,
   5645,5646,5662,5689,5695,5705,5706,5747,5978,5979,6284,7725,
   7726,7743,7769,7786,7817,7827,7828,8058,8059,8364,38205,
   38211,38221,38222,38253,38263,38264,38494,38495,38800,39156,
   39166,39167,39397,39398,39703,40258,40259,40564,44904],
 [2279,3500,3501,3507,3517,3518,3544,3550,3592,3833,3834,4139,
   5645,5646,5662,5689,5695,5705,5706,5747,5978,5979,6284,7725,
   7726,7743,7769,7786,7817,7827,7828,8058,8059,8364,38205,
   38211,38221,38222,38253,38263,38264,38494,38495,38800,39156,
   39166,39167,39397,39398,39703,40258,40259,40564,44904],
 [1,2,23,26,31,32,41,42,44,68,89,90,91,92,93,94,107,156,
   157,158,163,164,166,173,177,179,1289,1290,1291,1292,1293,
   1296,1297,1298,1300,1306,1307,1309,1311,1313,1333,1334,1335,
   1336,1339,1340,1341,1343,1349,1350,1352,1354,1356,1376,1377,
   1378,1381,1382,1383,1385,1391,1392,1394,1396,1398,1418,1419,
   1422,1423,1424,1426,1432,1433,1435,1437,1439,1459,1462,1463,
   1464,1466,1472,1473,1475,1477,1479,1501,1502,1503,1505,1511,
   1512,1514,1516,1518,1613,1614,1616,1622,1623,1625,1627,1629,
   1649,1651,1657,1658,1660,1662,1664,1685,1691,1692,1694,1696,
   1698,1756,1757,1759,1761,1763,1928,1930,1932,1934,1955,1957,
   1959,2004,2006,2049,2279,2300,2301,2302,2305,2308,2310,2318,
   2319,2321,2365,2366,2367,2370,2373,2375,2383,2384,2386,3500,
   3501,3502,3503,3504,3507,3508,3509,3511,3517,3518,3520,3522,
   3524,3544,3545,3546,3547,3550,3551,3552,3554,3560,3561,3563,
   3565,3567,3587,3588,3589,3592,3593,3594,3596,3602,3603,3605,
   3607,3609,3629,3630,3633,3634,3635,3637,3643,3644,3646,3648,
   3650,3670,3673,3674,3675,3677,3683,3684,3686,3688,3690,3712,
   3713,3714,3716,3722,3723,3725,3727,3729,3824,3825,3827,3833,
   3834,3836,3838,3840,3860,3862,3868,3869,3871,3873,3875,3896,
   3902,3903,3905,3907,3909,3967,3968,3970,3972,3974,4139,4141,
   4143,4145,4166,4168,4170,4215,4217,4260,4510,4511,4512,4515,
   4518,4520,4528,4529,4531,5645,5646,5647,5648,5649,5652,5653,
   5654,5656,5662,5663,5665,5667,5669,5689,5690,5691,5692,5695,
   5696,5697,5699,5705,5706,5708,5710,5712,5732,5733,5734,5737,
   5738,5739,5741,5747,5748,5750,5752,5754,5774,5775,5778,5779,
   5780,5782,5788,5789,5791,5793,5795,5815,5818,5819,5820,5822,
   5828,5829,5831,5833,5835,5857,5858,5859,5861,5867,5868,5870,
   5872,5874,5969,5970,5972,5978,5979,5981,5983,5985,6005,6007,
   6013,6014,6016,6018,6020,6041,6047,6048,6050,6052,6054,6112,
   6113,6115,6117,6119,6284,6286,6288,6290,6311,6313,6315,6360,
   6362,6405,7725,7726,7727,7728,7729,7732,7733,7734,7736,7742,
   7743,7745,7747,7749,7769,7770,7771,7772,7775,7776,7777,7779,
   7785,7786,7788,7790,7792,7812,7813,7814,7817,7818,7819,7821,
   7827,7828,7830,7832,7834,7854,7855,7858,7859,7860,7862,7868,
   7869,7871,7873,7875,7895,7898,7899,7900,7902,7908,7909,7911,
   7913,7915,7937,7938,7939,7941,7947,7948,7950,7952,7954,8049,
   8050,8052,8058,8059,8061,8063,8065,8085,8087,8093,8094,8096,
   8098,8100,8121,8127,8128,8130,8132,8134,8192,8193,8195,8197,
   8199,8364,8366,8368,8370,8391,8393,8395,8440,8442,8485,
   38205,38206,38207,38208,38211,38212,38213,38215,38221,38222,
   38224,38226,38228,38248,38249,38250,38253,38254,38255,38257,
   38263,38264,38266,38268,38270,38290,38291,38294,38295,38296,
   38298,38304,38305,38307,38309,38311,38331,38334,38335,38336,
   38338,38344,38345,38347,38349,38351,38373,38374,38375,38377,
   38383,38384,38386,38388,38390,38485,38486,38488,38494,38495,
   38497,38499,38501,38521,38523,38529,38530,38532,38534,38536,
   38557,38563,38564,38566,38568,38570,38628,38629,38631,38633,
   38635,38800,38802,38804,38806,38827,38829,38831,38876,38878,
   38921,39151,39152,39153,39156,39157,39158,39160,39166,39167,
   39169,39171,39173,39193,39194,39197,39198,39199,39201,39207,
   39208,39210,39212,39214,39234,39237,39238,39239,39241,39247,
   39248,39250,39252,39254,39276,39277,39278,39280,39286,39287,
   39289,39291,39293,39388,39389,39391,39397,39398,39400,39402,
   39404,39424,39426,39432,39433,39435,39437,39439,39460,39466,
   39467,39469,39471,39473,39531,39532,39534,39536,39538,39703,
   39705,39707,39709,39730,39732,39734,39779,39781,39824,40054,
   40055,40058,40059,40060,40062,40068,40069,40071,40073,40075,
   40095,40098,40099,40100,40102,40108,40109,40111,40113,40115,
   40137,40138,40139,40141,40147,40148,40150,40152,40154,40249,
   40250,40252,40258,40259,40261,40263,40265,40285,40287,40293,
   40294,40296,40298,40300,40321,40327,40328,40330,40332,40334,
   40392,40393,40395,40397,40399,40564,40566,40568,40570,40591,
   40593,40595,40640,40642,40685,40915,40918,40919,40920,40922,
   40928,40929,40931,40933,40935,40957,40958,40959,40961,40967,
   40968,40970,40972,40974,41069,41070,41072,41078,41079,41081,
   41083,41085,41105,41107,41113,41114,41116,41118,41120,41141,
   41147,41148,41150,41152,41154,41212,41213,41215,41217,41219,
   41384,41386,41388,41390,41411,41413,41415,41460,41462,41505,
   41737,41738,41739,41741,41747,41748,41750,41752,41754,41849,
   41850,41852,41858,41859,41861,41863,41865,41885,41887,41893,
   41894,41896,41898,41900,41921,41927,41928,41930,41932,41934,
   41992,41993,41995,41997,41999,42164,42166,42168,42170,42191,
   42193,42195,42240,42242,42285,42590,42591,42593,42599,42600,
   42602,42604,42606,42626,42628,42634,42635,42637,42639,42641,
   42662,42668,42669,42671,42673,42675,42733,42734,42736,42738,
   42740,42905,42907,42909,42911,42932,42934,42936,42981,42983,
   43026,44625,44627,44633,44634,44636,44638,44640,44661,44667,
   44668,44670,44672,44674,44732,44733,44735,44737,44739,44904,
   44906,44908,44910,44931,44933,44935,44980,44982,45025,45256,
   45262,45263,45265,45267,45269,45327,45328,45330,45332,45334,
   45499,45501,45503,45505,45526,45528,45530,45575,45577,45620,
   45888,45889,45891,45893,45895,46060,46062,46064,46066,46087,
   46089,46091,46136,46138,46181,47084,47086,47088,47090,47111,
   47113,47115,47160,47162,47205,49471,49473,49475,49520,49522,
   49565,49820,49822,49865,50394],
 [1,2,23,26,31,32,41,42,44,68,89,90,91,92,93,94,107,156,
   157,158,163,164,166,173,177,179,1289,1290,1291,1292,1293,
   1296,1297,1298,1300,1306,1307,1309,1311,1313,1333,1334,1335,
   1336,1339,1340,1341,1343,1349,1350,1352,1354,1356,1376,1377,
   1378,1381,1382,1383,1385,1391,1392,1394,1396,1398,1418,1419,
   1422,1423,1424,1426,1432,1433,1435,1437,1439,1459,1462,1463,
   1464,1466,1472,1473,1475,1477,1479,1501,1502,1503,1505,1511,
   1512,1514,1516,1518,1613,1614,1616,1622,1623,1625,1627,1629,
   1649,1651,1657,1658,1660,1662,1664,1685,1691,1692,1694,1696,
   1698,1756,1757,1759,1761,1763,1928,1930,1932,1934,1955,1957,
   1959,2004,2006,2049,2279,2300,2301,2302,2305,2308,2310,2318,
   2319,2321,2365,2366,2367,2370,2373,2375,2383,2384,2386,3500,
   3501,3502,3503,3504,3507,3508,3509,3511,3517,3518,3520,3522,
   3524,3544,3545,3546,3547,3550,3551,3552,3554,3560,3561,3563,
   3565,3567,3587,3588,3589,3592,3593,3594,3596,3602,3603,3605,
   3607,3609,3629,3630,3633,3634,3635,3637,3643,3644,3646,3648,
   3650,3670,3673,3674,3675,3677,3683,3684,3686,3688,3690,3712,
   3713,3714,3716,3722,3723,3725,3727,3729,3824,3825,3827,3833,
   3834,3836,3838,3840,3860,3862,3868,3869,3871,3873,3875,3896,
   3902,3903,3905,3907,3909,3967,3968,3970,3972,3974,4139,4141,
   4143,4145,4166,4168,4170,4215,4217,4260,4510,4511,4512,4515,
   4518,4520,4528,4529,4531,5645,5646,5647,5648,5649,5652,5653,
   5654,5656,5662,5663,5665,5667,5669,5689,5690,5691,5692,5695,
   5696,5697,5699,5705,5706,5708,5710,5712,5732,5733,5734,5737,
   5738,5739,5741,5747,5748,5750,5752,5754,5774,5775,5778,5779,
   5780,5782,5788,5789,5791,5793,5795,5815,5818,5819,5820,5822,
   5828,5829,5831,5833,5835,5857,5858,5859,5861,5867,5868,5870,
   5872,5874,5969,5970,5972,5978,5979,5981,5983,5985,6005,6007,
   6013,6014,6016,6018,6020,6041,6047,6048,6050,6052,6054,6112,
   6113,6115,6117,6119,6284,6286,6288,6290,6311,6313,6315,6360,
   6362,6405,7725,7726,7727,7728,7729,7732,7733,7734,7736,7742,
   7743,7745,7747,7749,7769,7770,7771,7772,7775,7776,7777,7779,
   7785,7786,7788,7790,7792,7812,7813,7814,7817,7818,7819,7821,
   7827,7828,7830,7832,7834,7854,7855,7858,7859,7860,7862,7868,
   7869,7871,7873,7875,7895,7898,7899,7900,7902,7908,7909,7911,
   7913,7915,7937,7938,7939,7941,7947,7948,7950,7952,7954,8049,
   8050,8052,8058,8059,8061,8063,8065,8085,8087,8093,8094,8096,
   8098,8100,8121,8127,8128,8130,8132,8134,8192,8193,8195,8197,
   8199,8364,8366,8368,8370,8391,8393,8395,8440,8442,8485,
   38205,38206,38207,38208,38211,38212,38213,38215,38221,38222,
   38224,38226,38228,38248,38249,38250,38253,38254,38255,38257,
   38263,38264,38266,38268,38270,38290,38291,38294,38295,38296,
   38298,38304,38305,38307,38309,38311,38331,38334,38335,38336,
   38338,38344,38345,38347,38349,38351,38373,38374,38375,38377,
   38383,38384,38386,38388,38390,38485,38486,38488,38494,38495,
   38497,38499,38501,38521,38523,38529,38530,38532,38534,38536,
   38557,38563,38564,38566,38568,38570,38628,38629,38631,38633,
   38635,38800,38802,38804,38806,38827,38829,38831,38876,38878,
   38921,39151,39152,39153,39156,39157,39158,39160,39166,39167,
   39169,39171,39173,39193,39194,39197,39198,39199,39201,39207,
   39208,39210,39212,39214,39234,39237,39238,39239,39241,39247,
   39248,39250,39252,39254,39276,39277,39278,39280,39286,39287,
   39289,39291,39293,39388,39389,39391,39397,39398,39400,39402,
   39404,39424,39426,39432,39433,39435,39437,39439,39460,39466,
   39467,39469,39471,39473,39531,39532,39534,39536,39538,39703,
   39705,39707,39709,39730,39732,39734,39779,39781,39824,40054,
   40055,40058,40059,40060,40062,40068,40069,40071,40073,40075,
   40095,40098,40099,40100,40102,40108,40109,40111,40113,40115,
   40137,40138,40139,40141,40147,40148,40150,40152,40154,40249,
   40250,40252,40258,40259,40261,40263,40265,40285,40287,40293,
   40294,40296,40298,40300,40321,40327,40328,40330,40332,40334,
   40392,40393,40395,40397,40399,40564,40566,40568,40570,40591,
   40593,40595,40640,40642,40685,40915,40918,40919,40920,40922,
   40928,40929,40931,40933,40935,40957,40958,40959,40961,40967,
   40968,40970,40972,40974,41069,41070,41072,41078,41079,41081,
   41083,41085,41105,41107,41113,41114,41116,41118,41120,41141,
   41147,41148,41150,41152,41154,41212,41213,41215,41217,41219,
   41384,41386,41388,41390,41411,41413,41415,41460,41462,41505,
   41737,41738,41739,41741,41747,41748,41750,41752,41754,41849,
   41850,41852,41858,41859,41861,41863,41865,41885,41887,41893,
   41894,41896,41898,41900,41921,41927,41928,41930,41932,41934,
   41992,41993,41995,41997,41999,42164,42166,42168,42170,42191,
   42193,42195,42240,42242,42285,42590,42591,42593,42599,42600,
   42602,42604,42606,42626,42628,42634,42635,42637,42639,42641,
   42662,42668,42669,42671,42673,42675,42733,42734,42736,42738,
   42740,42905,42907,42909,42911,42932,42934,42936,42981,42983,
   43026,44625,44627,44633,44634,44636,44638,44640,44661,44667,
   44668,44670,44672,44674,44732,44733,44735,44737,44739,44904,
   44906,44908,44910,44931,44933,44935,44980,44982,45025,45256,
   45262,45263,45265,45267,45269,45327,45328,45330,45332,45334,
   45499,45501,45503,45505,45526,45528,45530,45575,45577,45620,
   45888,45889,45891,45893,45895,46060,46062,46064,46066,46087,
   46089,46091,46136,46138,46181,47084,47086,47088,47090,47111,
   47113,47115,47160,47162,47205,49471,49473,49475,49520,49522,
   49565,49820,49822,49865,50394],
 [2279,3714,3725,3905,5859,5870,6050,7939,7950,8130,42671],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,
   2384,3500,3501,3505,3506,3507,3513,3514,3517,3518,3527,3528,
   3544,3548,3549,3550,3556,3557,3560,3561,3570,3571,3590,3591,
   3592,3598,3599,3602,3603,3612,3613,3749,3750,3756,3757,3760,
   3761,3770,3771,3787,3793,3794,3797,3798,3829,3830,3833,3834,
   3843,3844,4025,4028,4029,4038,4039,4057,4058,4139,4148,4149,
   4173,4174,4354,4510,4511,4512,4518,4528,4529,5645,5646,5650,
   5651,5652,5658,5659,5662,5663,5672,5673,5689,5693,5694,5695,
   5701,5702,5705,5706,5715,5716,5735,5736,5737,5743,5744,5747,
   5748,5757,5758,5894,5895,5902,5905,5906,5916,5932,5939,5942,
   5943,5953,5974,5975,5978,5979,5988,5989,6170,6173,6174,6183,
   6184,6202,6203,6212,6213,6284,6293,6294,6318,6319,6499,7725,
   7726,7730,7731,7732,7738,7739,7742,7743,7752,7753,7769,7773,
   7774,7775,7781,7782,7785,7786,7795,7796,7815,7816,7817,7823,
   7824,7827,7828,7837,7838,7974,7975,7985,7986,7995,7996,8012,
   8018,8019,8022,8023,8032,8033,8054,8055,8058,8059,8068,8069,
   8250,8253,8254,8263,8282,8283,8292,8364,8373,8374,8398,8399,
   8579,38205,38209,38210,38211,38217,38218,38221,38222,38231,
   38232,38251,38252,38253,38259,38260,38263,38264,38273,38274,
   38410,38411,38417,38418,38421,38422,38431,38432,38448,38454,
   38455,38458,38459,38468,38469,38490,38491,38494,38495,38504,
   38505,38686,38689,38690,38699,38700,38718,38719,38728,38729,
   38800,38809,38810,38834,38835,39015,39154,39155,39156,39162,
   39163,39166,39167,39176,39177,39313,39314,39320,39321,39324,
   39325,39334,39335,39351,39357,39358,39361,39362,39371,39372,
   39393,39394,39397,39398,39407,39408,39589,39592,39593,39602,
   39603,39621,39622,39631,39632,39703,39712,39713,39737,39738,
   39918,40174,40175,40181,40182,40185,40186,40195,40196,40212,
   40218,40219,40222,40223,40232,40233,40254,40255,40258,40259,
   40268,40269,40450,40453,40454,40463,40464,40482,40483,40492,
   40493,40564,40573,40574,40598,40599,40779,43256,43262,43263,
   43266,43267,43276,43277,43298,43299,43302,43303,43312,43313,
   43494,43497,43498,43507,43508,43526,43527,43536,43537,43608,
   43617,43618,43642,43643,43823,43964,43965,43968,43969,43978,
   43979,44160,44163,44164,44173,44174,44192,44193,44202,44203,
   44274,44283,44284,44308,44309,44489,44790,44793,44794,44803,
   44804,44822,44823,44832,44833,44904,44913,44914,44938,44939,
   45119,47902,47903,47912,47913,47984,47993,47994,48018,48019,
   48199,48390,48399,48400,48424,48425,48605,49478,49479,49659,
   49959],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,
   2384,3500,3501,3505,3506,3507,3513,3514,3517,3518,3527,3528,
   3544,3548,3549,3550,3556,3557,3560,3561,3570,3571,3590,3591,
   3592,3598,3599,3602,3603,3612,3613,3749,3750,3756,3757,3760,
   3761,3770,3771,3787,3793,3794,3797,3798,3829,3830,3833,3834,
   3843,3844,4025,4028,4029,4038,4039,4057,4058,4139,4148,4149,
   4173,4174,4354,4510,4511,4512,4518,4528,4529,5645,5646,5650,
   5651,5652,5658,5659,5662,5663,5672,5673,5689,5693,5694,5695,
   5701,5702,5705,5706,5715,5716,5735,5736,5737,5743,5744,5747,
   5748,5757,5758,5894,5895,5902,5905,5906,5916,5932,5939,5942,
   5943,5953,5974,5975,5978,5979,5988,5989,6170,6173,6174,6183,
   6184,6202,6203,6212,6213,6284,6293,6294,6318,6319,6499,7725,
   7726,7730,7731,7732,7738,7739,7742,7743,7752,7753,7769,7773,
   7774,7775,7781,7782,7785,7786,7795,7796,7815,7816,7817,7823,
   7824,7827,7828,7837,7838,7974,7975,7985,7986,7995,7996,8012,
   8018,8019,8022,8023,8032,8033,8054,8055,8058,8059,8068,8069,
   8250,8253,8254,8263,8282,8283,8292,8364,8373,8374,8398,8399,
   8579,38205,38209,38210,38211,38217,38218,38221,38222,38231,
   38232,38251,38252,38253,38259,38260,38263,38264,38273,38274,
   38410,38411,38417,38418,38421,38422,38431,38432,38448,38454,
   38455,38458,38459,38468,38469,38490,38491,38494,38495,38504,
   38505,38686,38689,38690,38699,38700,38718,38719,38728,38729,
   38800,38809,38810,38834,38835,39015,39154,39155,39156,39162,
   39163,39166,39167,39176,39177,39313,39314,39320,39321,39324,
   39325,39334,39335,39351,39357,39358,39361,39362,39371,39372,
   39393,39394,39397,39398,39407,39408,39589,39592,39593,39602,
   39603,39621,39622,39631,39632,39703,39712,39713,39737,39738,
   39918,40174,40175,40181,40182,40185,40186,40195,40196,40212,
   40218,40219,40222,40223,40232,40233,40254,40255,40258,40259,
   40268,40269,40450,40453,40454,40463,40464,40482,40483,40492,
   40493,40564,40573,40574,40598,40599,40779,43256,43262,43263,
   43266,43267,43276,43277,43298,43299,43302,43303,43312,43313,
   43494,43497,43498,43507,43508,43526,43527,43536,43537,43608,
   43617,43618,43642,43643,43823,43964,43965,43968,43969,43978,
   43979,44160,44163,44164,44173,44174,44192,44193,44202,44203,
   44274,44283,44284,44308,44309,44489,44790,44793,44794,44803,
   44804,44822,44823,44832,44833,44904,44913,44914,44938,44939,
   45119,47902,47903,47912,47913,47984,47993,47994,48018,48019,
   48199,48390,48399,48400,48424,48425,48605,49478,49479,49659,
   49959],
 [2279,3500,3501,3507,3517,3518,3544,3550,3592,3833,3834,4139,
   5645,5646,5662,5689,5695,5705,5706,5747,5978,5979,6284,7725,
   7726,7743,7769,7786,7817,7827,7828,8058,8059,8364,38205,
   38211,38221,38222,38253,38263,38264,38494,38495,38800,39156,
   39166,39167,39397,39398,39703,40258,40259,40564,44904],
 [1,2,23,26,31,32,41,42,44,68,89,90,91,92,93,94,107,156,
   157,158,163,164,166,173,177,179,1289,1290,1291,1292,1293,
   1296,1297,1298,1300,1306,1307,1309,1311,1313,1333,1334,1335,
   1336,1339,1340,1341,1343,1349,1350,1352,1354,1356,1376,1377,
   1378,1381,1382,1383,1385,1391,1392,1394,1396,1398,1418,1419,
   1422,1423,1424,1426,1432,1433,1435,1437,1439,1459,1462,1463,
   1464,1466,1472,1473,1475,1477,1479,1501,1502,1503,1505,1511,
   1512,1514,1516,1518,1613,1614,1616,1622,1623,1625,1627,1629,
   1649,1651,1657,1658,1660,1662,1664,1685,1691,1692,1694,1696,
   1698,1756,1757,1759,1761,1763,1928,1930,1932,1934,1955,1957,
   1959,2004,2006,2049,2279,2300,2301,2302,2305,2308,2310,2318,
   2319,2321,2365,2366,2367,2370,2373,2375,2383,2384,2386,3500,
   3501,3502,3503,3504,3507,3508,3509,3511,3517,3518,3520,3522,
   3524,3544,3545,3546,3547,3550,3551,3552,3554,3560,3561,3563,
   3565,3567,3587,3588,3589,3592,3593,3594,3596,3602,3603,3605,
   3607,3609,3629,3630,3633,3634,3635,3637,3643,3644,3646,3648,
   3650,3670,3673,3674,3675,3677,3683,3684,3686,3688,3690,3712,
   3713,3714,3716,3722,3723,3725,3727,3729,3824,3825,3827,3833,
   3834,3836,3838,3840,3860,3862,3868,3869,3871,3873,3875,3896,
   3902,3903,3905,3907,3909,3967,3968,3970,3972,3974,4139,4141,
   4143,4145,4166,4168,4170,4215,4217,4260,4510,4511,4512,4515,
   4518,4520,4528,4529,4531,5645,5646,5647,5648,5649,5652,5653,
   5654,5656,5662,5663,5665,5667,5669,5689,5690,5691,5692,5695,
   5696,5697,5699,5705,5706,5708,5710,5712,5732,5733,5734,5737,
   5738,5739,5741,5747,5748,5750,5752,5754,5774,5775,5778,5779,
   5780,5782,5788,5789,5791,5793,5795,5815,5818,5819,5820,5822,
   5828,5829,5831,5833,5835,5857,5858,5859,5861,5867,5868,5870,
   5872,5874,5969,5970,5972,5978,5979,5981,5983,5985,6005,6007,
   6013,6014,6016,6018,6020,6041,6047,6048,6050,6052,6054,6112,
   6113,6115,6117,6119,6284,6286,6288,6290,6311,6313,6315,6360,
   6362,6405,7725,7726,7727,7728,7729,7732,7733,7734,7736,7742,
   7743,7745,7747,7749,7769,7770,7771,7772,7775,7776,7777,7779,
   7785,7786,7788,7790,7792,7812,7813,7814,7817,7818,7819,7821,
   7827,7828,7830,7832,7834,7854,7855,7858,7859,7860,7862,7868,
   7869,7871,7873,7875,7895,7898,7899,7900,7902,7908,7909,7911,
   7913,7915,7937,7938,7939,7941,7947,7948,7950,7952,7954,8049,
   8050,8052,8058,8059,8061,8063,8065,8085,8087,8093,8094,8096,
   8098,8100,8121,8127,8128,8130,8132,8134,8192,8193,8195,8197,
   8199,8364,8366,8368,8370,8391,8393,8395,8440,8442,8485,
   38205,38206,38207,38208,38211,38212,38213,38215,38221,38222,
   38224,38226,38228,38248,38249,38250,38253,38254,38255,38257,
   38263,38264,38266,38268,38270,38290,38291,38294,38295,38296,
   38298,38304,38305,38307,38309,38311,38331,38334,38335,38336,
   38338,38344,38345,38347,38349,38351,38373,38374,38375,38377,
   38383,38384,38386,38388,38390,38485,38486,38488,38494,38495,
   38497,38499,38501,38521,38523,38529,38530,38532,38534,38536,
   38557,38563,38564,38566,38568,38570,38628,38629,38631,38633,
   38635,38800,38802,38804,38806,38827,38829,38831,38876,38878,
   38921,39151,39152,39153,39156,39157,39158,39160,39166,39167,
   39169,39171,39173,39193,39194,39197,39198,39199,39201,39207,
   39208,39210,39212,39214,39234,39237,39238,39239,39241,39247,
   39248,39250,39252,39254,39276,39277,39278,39280,39286,39287,
   39289,39291,39293,39388,39389,39391,39397,39398,39400,39402,
   39404,39424,39426,39432,39433,39435,39437,39439,39460,39466,
   39467,39469,39471,39473,39531,39532,39534,39536,39538,39703,
   39705,39707,39709,39730,39732,39734,39779,39781,39824,40054,
   40055,40058,40059,40060,40062,40068,40069,40071,40073,40075,
   40095,40098,40099,40100,40102,40108,40109,40111,40113,40115,
   40137,40138,40139,40141,40147,40148,40150,40152,40154,40249,
   40250,40252,40258,40259,40261,40263,40265,40285,40287,40293,
   40294,40296,40298,40300,40321,40327,40328,40330,40332,40334,
   40392,40393,40395,40397,40399,40564,40566,40568,40570,40591,
   40593,40595,40640,40642,40685,40915,40918,40919,40920,40922,
   40928,40929,40931,40933,40935,40957,40958,40959,40961,40967,
   40968,40970,40972,40974,41069,41070,41072,41078,41079,41081,
   41083,41085,41105,41107,41113,41114,41116,41118,41120,41141,
   41147,41148,41150,41152,41154,41212,41213,41215,41217,41219,
   41384,41386,41388,41390,41411,41413,41415,41460,41462,41505,
   41737,41738,41739,41741,41747,41748,41750,41752,41754,41849,
   41850,41852,41858,41859,41861,41863,41865,41885,41887,41893,
   41894,41896,41898,41900,41921,41927,41928,41930,41932,41934,
   41992,41993,41995,41997,41999,42164,42166,42168,42170,42191,
   42193,42195,42240,42242,42285,42590,42591,42593,42599,42600,
   42602,42604,42606,42626,42628,42634,42635,42637,42639,42641,
   42662,42668,42669,42671,42673,42675,42733,42734,42736,42738,
   42740,42905,42907,42909,42911,42932,42934,42936,42981,42983,
   43026,44625,44627,44633,44634,44636,44638,44640,44661,44667,
   44668,44670,44672,44674,44732,44733,44735,44737,44739,44904,
   44906,44908,44910,44931,44933,44935,44980,44982,45025,45256,
   45262,45263,45265,45267,45269,45327,45328,45330,45332,45334,
   45499,45501,45503,45505,45526,45528,45530,45575,45577,45620,
   45888,45889,45891,45893,45895,46060,46062,46064,46066,46087,
   46089,46091,46136,46138,46181,47084,47086,47088,47090,47111,
   47113,47115,47160,47162,47205,49471,49473,49475,49520,49522,
   49565,49820,49822,49865,50394],
 [2279,3714,3725,3905,5859,5870,6050,7939,7950,8130,42671],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,
   2384,3500,3501,3507,3510,3512,3517,3518,3519,3523,3525,3526,
   3544,3550,3553,3555,3560,3561,3562,3566,3568,3569,3592,3595,
   3597,3602,3603,3604,3608,3610,3611,3826,3828,3833,3834,3835,
   3839,3841,3842,3930,3935,3936,3937,3941,3998,3999,4000,4004,
   4139,4140,4144,4146,4147,4165,4169,4171,4172,4193,4195,4196,
   4281,4282,4319,4510,4511,4512,4518,4528,4529,5645,5646,5652,
   5655,5657,5662,5663,5664,5668,5670,5671,5689,5695,5698,5700,
   5705,5706,5707,5711,5713,5714,5737,5740,5742,5747,5748,5749,
   5753,5755,5756,5971,5973,5978,5979,5980,5984,5986,5987,6075,
   6080,6081,6086,6089,6143,6144,6145,6149,6151,6152,6284,6285,
   6289,6291,6292,6310,6314,6316,6317,6340,6341,6427,6464,7725,
   7726,7732,7735,7737,7742,7743,7744,7748,7750,7751,7769,7775,
   7778,7780,7785,7786,7787,7791,7793,7794,7817,7820,7822,7827,
   7828,7829,7833,7835,7836,8051,8053,8058,8059,8060,8064,8066,
   8067,8155,8160,8161,8162,8166,8168,8169,8223,8224,8225,8231,
   8364,8365,8369,8371,8372,8390,8394,8396,8397,8420,8506,8507,
   8544,38205,38211,38214,38216,38221,38222,38223,38227,38229,
   38230,38253,38256,38258,38263,38264,38265,38269,38271,38272,
   38487,38489,38494,38495,38496,38500,38502,38503,38591,38596,
   38597,38598,38602,38604,38605,38659,38660,38661,38665,38667,
   38668,38800,38801,38805,38807,38808,38826,38830,38832,38833,
   38854,38856,38857,38942,38943,38980,39156,39159,39161,39166,
   39167,39168,39172,39174,39175,39390,39392,39397,39398,39399,
   39403,39405,39406,39494,39499,39500,39501,39505,39507,39508,
   39562,39563,39564,39568,39570,39571,39703,39704,39708,39710,
   39711,39729,39733,39735,39736,39757,39759,39760,39845,39846,
   39883,40251,40253,40258,40259,40260,40264,40266,40267,40355,
   40360,40361,40362,40366,40368,40369,40423,40424,40425,40429,
   40431,40432,40564,40565,40569,40571,40572,40590,40594,40596,
   40597,40618,40620,40621,40706,40707,40744,44695,44700,44701,
   44702,44706,44708,44709,44763,44764,44765,44769,44771,44772,
   44904,44905,44909,44911,44912,44930,44934,44936,44937,44958,
   44960,44961,45046,45047,45084,46447,46448,46449,46453,46455,
   46456,46588,46589,46593,46595,46596,46614,46618,46620,46621,
   46642,46644,46645,46730,46731,46768,47549,47550,47554,47556,
   47557,47575,47579,47581,47582,47603,47605,47606,47691,47692,
   47729,49470,49474,49476,49477,49498,49500,49501,49586,49587,
   49624,49798,49800,49801,49886,49887,49924,50162,50163,50200,
   51084],
 [1,2,23,26,31,32,41,42,44,68,89,90,91,92,93,94,107,156,
   157,158,163,164,166,173,177,179,1289,1290,1291,1292,1293,
   1296,1297,1298,1300,1306,1307,1309,1311,1313,1333,1334,1335,
   1336,1339,1340,1341,1343,1349,1350,1352,1354,1356,1376,1377,
   1378,1381,1382,1383,1385,1391,1392,1394,1396,1398,1418,1419,
   1422,1423,1424,1426,1432,1433,1435,1437,1439,1459,1462,1463,
   1464,1466,1472,1473,1475,1477,1479,1501,1502,1503,1505,1511,
   1512,1514,1516,1518,1613,1614,1616,1622,1623,1625,1627,1629,
   1649,1651,1657,1658,1660,1662,1664,1685,1691,1692,1694,1696,
   1698,1756,1757,1759,1761,1763,1928,1930,1932,1934,1955,1957,
   1959,2004,2006,2049,2279,2300,2301,2302,2305,2308,2310,2318,
   2319,2321,2365,2366,2367,2370,2373,2375,2383,2384,2386,3500,
   3501,3502,3503,3504,3507,3508,3509,3511,3517,3518,3520,3522,
   3524,3544,3545,3546,3547,3550,3551,3552,3554,3560,3561,3563,
   3565,3567,3587,3588,3589,3592,3593,3594,3596,3602,3603,3605,
   3607,3609,3629,3630,3633,3634,3635,3637,3643,3644,3646,3648,
   3650,3670,3673,3674,3675,3677,3683,3684,3686,3688,3690,3712,
   3713,3714,3716,3722,3723,3725,3727,3729,3824,3825,3827,3833,
   3834,3836,3838,3840,3860,3862,3868,3869,3871,3873,3875,3896,
   3902,3903,3905,3907,3909,3967,3968,3970,3972,3974,4139,4141,
   4143,4145,4166,4168,4170,4215,4217,4260,4510,4511,4512,4515,
   4518,4520,4528,4529,4531,5645,5646,5647,5648,5649,5652,5653,
   5654,5656,5662,5663,5665,5667,5669,5689,5690,5691,5692,5695,
   5696,5697,5699,5705,5706,5708,5710,5712,5732,5733,5734,5737,
   5738,5739,5741,5747,5748,5750,5752,5754,5774,5775,5778,5779,
   5780,5782,5788,5789,5791,5793,5795,5815,5818,5819,5820,5822,
   5828,5829,5831,5833,5835,5857,5858,5859,5861,5867,5868,5870,
   5872,5874,5969,5970,5972,5978,5979,5981,5983,5985,6005,6007,
   6013,6014,6016,6018,6020,6041,6047,6048,6050,6052,6054,6112,
   6113,6115,6117,6119,6284,6286,6288,6290,6311,6313,6315,6360,
   6362,6405,7725,7726,7727,7728,7729,7732,7733,7734,7736,7742,
   7743,7745,7747,7749,7769,7770,7771,7772,7775,7776,7777,7779,
   7785,7786,7788,7790,7792,7812,7813,7814,7817,7818,7819,7821,
   7827,7828,7830,7832,7834,7854,7855,7858,7859,7860,7862,7868,
   7869,7871,7873,7875,7895,7898,7899,7900,7902,7908,7909,7911,
   7913,7915,7937,7938,7939,7941,7947,7948,7950,7952,7954,8049,
   8050,8052,8058,8059,8061,8063,8065,8085,8087,8093,8094,8096,
   8098,8100,8121,8127,8128,8130,8132,8134,8192,8193,8195,8197,
   8199,8364,8366,8368,8370,8391,8393,8395,8440,8442,8485,
   38205,38206,38207,38208,38211,38212,38213,38215,38221,38222,
   38224,38226,38228,38248,38249,38250,38253,38254,38255,38257,
   38263,38264,38266,38268,38270,38290,38291,38294,38295,38296,
   38298,38304,38305,38307,38309,38311,38331,38334,38335,38336,
   38338,38344,38345,38347,38349,38351,38373,38374,38375,38377,
   38383,38384,38386,38388,38390,38485,38486,38488,38494,38495,
   38497,38499,38501,38521,38523,38529,38530,38532,38534,38536,
   38557,38563,38564,38566,38568,38570,38628,38629,38631,38633,
   38635,38800,38802,38804,38806,38827,38829,38831,38876,38878,
   38921,39151,39152,39153,39156,39157,39158,39160,39166,39167,
   39169,39171,39173,39193,39194,39197,39198,39199,39201,39207,
   39208,39210,39212,39214,39234,39237,39238,39239,39241,39247,
   39248,39250,39252,39254,39276,39277,39278,39280,39286,39287,
   39289,39291,39293,39388,39389,39391,39397,39398,39400,39402,
   39404,39424,39426,39432,39433,39435,39437,39439,39460,39466,
   39467,39469,39471,39473,39531,39532,39534,39536,39538,39703,
   39705,39707,39709,39730,39732,39734,39779,39781,39824,40054,
   40055,40058,40059,40060,40062,40068,40069,40071,40073,40075,
   40095,40098,40099,40100,40102,40108,40109,40111,40113,40115,
   40137,40138,40139,40141,40147,40148,40150,40152,40154,40249,
   40250,40252,40258,40259,40261,40263,40265,40285,40287,40293,
   40294,40296,40298,40300,40321,40327,40328,40330,40332,40334,
   40392,40393,40395,40397,40399,40564,40566,40568,40570,40591,
   40593,40595,40640,40642,40685,40915,40918,40919,40920,40922,
   40928,40929,40931,40933,40935,40957,40958,40959,40961,40967,
   40968,40970,40972,40974,41069,41070,41072,41078,41079,41081,
   41083,41085,41105,41107,41113,41114,41116,41118,41120,41141,
   41147,41148,41150,41152,41154,41212,41213,41215,41217,41219,
   41384,41386,41388,41390,41411,41413,41415,41460,41462,41505,
   41737,41738,41739,41741,41747,41748,41750,41752,41754,41849,
   41850,41852,41858,41859,41861,41863,41865,41885,41887,41893,
   41894,41896,41898,41900,41921,41927,41928,41930,41932,41934,
   41992,41993,41995,41997,41999,42164,42166,42168,42170,42191,
   42193,42195,42240,42242,42285,42590,42591,42593,42599,42600,
   42602,42604,42606,42626,42628,42634,42635,42637,42639,42641,
   42662,42668,42669,42671,42673,42675,42733,42734,42736,42738,
   42740,42905,42907,42909,42911,42932,42934,42936,42981,42983,
   43026,44625,44627,44633,44634,44636,44638,44640,44661,44667,
   44668,44670,44672,44674,44732,44733,44735,44737,44739,44904,
   44906,44908,44910,44931,44933,44935,44980,44982,45025,45256,
   45262,45263,45265,45267,45269,45327,45328,45330,45332,45334,
   45499,45501,45503,45505,45526,45528,45530,45575,45577,45620,
   45888,45889,45891,45893,45895,46060,46062,46064,46066,46087,
   46089,46091,46136,46138,46181,47084,47086,47088,47090,47111,
   47113,47115,47160,47162,47205,49471,49473,49475,49520,49522,
   49565,49820,49822,49865,50394],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,
   2384,3500,3501,3507,3510,3512,3517,3518,3519,3523,3525,3526,
   3544,3550,3553,3555,3560,3561,3562,3566,3568,3569,3592,3595,
   3597,3602,3603,3604,3608,3610,3611,3826,3828,3833,3834,3835,
   3839,3841,3842,3930,3935,3936,3937,3941,3998,3999,4000,4004,
   4139,4140,4144,4146,4147,4165,4169,4171,4172,4193,4195,4196,
   4281,4282,4319,4510,4511,4512,4518,4528,4529,5645,5646,5652,
   5655,5657,5662,5663,5664,5668,5670,5671,5689,5695,5698,5700,
   5705,5706,5707,5711,5713,5714,5737,5740,5742,5747,5748,5749,
   5753,5755,5756,5971,5973,5978,5979,5980,5984,5986,5987,6075,
   6080,6081,6086,6089,6143,6144,6145,6149,6151,6152,6284,6285,
   6289,6291,6292,6310,6314,6316,6317,6340,6341,6427,6464,7725,
   7726,7732,7735,7737,7742,7743,7744,7748,7750,7751,7769,7775,
   7778,7780,7785,7786,7787,7791,7793,7794,7817,7820,7822,7827,
   7828,7829,7833,7835,7836,8051,8053,8058,8059,8060,8064,8066,
   8067,8155,8160,8161,8162,8166,8168,8169,8223,8224,8225,8231,
   8364,8365,8369,8371,8372,8390,8394,8396,8397,8420,8506,8507,
   8544,38205,38211,38214,38216,38221,38222,38223,38227,38229,
   38230,38253,38256,38258,38263,38264,38265,38269,38271,38272,
   38487,38489,38494,38495,38496,38500,38502,38503,38591,38596,
   38597,38598,38602,38604,38605,38659,38660,38661,38665,38667,
   38668,38800,38801,38805,38807,38808,38826,38830,38832,38833,
   38854,38856,38857,38942,38943,38980,39156,39159,39161,39166,
   39167,39168,39172,39174,39175,39390,39392,39397,39398,39399,
   39403,39405,39406,39494,39499,39500,39501,39505,39507,39508,
   39562,39563,39564,39568,39570,39571,39703,39704,39708,39710,
   39711,39729,39733,39735,39736,39757,39759,39760,39845,39846,
   39883,40251,40253,40258,40259,40260,40264,40266,40267,40355,
   40360,40361,40362,40366,40368,40369,40423,40424,40425,40429,
   40431,40432,40564,40565,40569,40571,40572,40590,40594,40596,
   40597,40618,40620,40621,40706,40707,40744,44695,44700,44701,
   44702,44706,44708,44709,44763,44764,44765,44769,44771,44772,
   44904,44905,44909,44911,44912,44930,44934,44936,44937,44958,
   44960,44961,45046,45047,45084,46447,46448,46449,46453,46455,
   46456,46588,46589,46593,46595,46596,46614,46618,46620,46621,
   46642,46644,46645,46730,46731,46768,47549,47550,47554,47556,
   47557,47575,47579,47581,47582,47603,47605,47606,47691,47692,
   47729,49470,49474,49476,49477,49498,49500,49501,49586,49587,
   49624,49798,49800,49801,49886,49887,49924,50162,50163,50200,
   51084],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,
   2384,3500,3501,3505,3506,3507,3513,3514,3517,3518,3527,3528,
   3544,3548,3549,3550,3556,3557,3560,3561,3570,3571,3590,3591,
   3592,3598,3599,3602,3603,3612,3613,3749,3750,3756,3757,3760,
   3761,3770,3771,3787,3793,3794,3797,3798,3829,3830,3833,3834,
   3843,3844,4025,4028,4029,4038,4039,4057,4058,4139,4148,4149,
   4173,4174,4354,4510,4511,4512,4518,4528,4529,5645,5646,5650,
   5651,5652,5658,5659,5662,5663,5672,5673,5689,5693,5694,5695,
   5701,5702,5705,5706,5715,5716,5735,5736,5737,5743,5744,5747,
   5748,5757,5758,5894,5895,5902,5905,5906,5916,5932,5939,5942,
   5943,5953,5974,5975,5978,5979,5988,5989,6170,6173,6174,6183,
   6184,6202,6203,6212,6213,6284,6293,6294,6318,6319,6499,7725,
   7726,7730,7731,7732,7738,7739,7742,7743,7752,7753,7769,7773,
   7774,7775,7781,7782,7785,7786,7795,7796,7815,7816,7817,7823,
   7824,7827,7828,7837,7838,7974,7975,7985,7986,7995,7996,8012,
   8018,8019,8022,8023,8032,8033,8054,8055,8058,8059,8068,8069,
   8250,8253,8254,8263,8282,8283,8292,8364,8373,8374,8398,8399,
   8579,38205,38209,38210,38211,38217,38218,38221,38222,38231,
   38232,38251,38252,38253,38259,38260,38263,38264,38273,38274,
   38410,38411,38417,38418,38421,38422,38431,38432,38448,38454,
   38455,38458,38459,38468,38469,38490,38491,38494,38495,38504,
   38505,38686,38689,38690,38699,38700,38718,38719,38728,38729,
   38800,38809,38810,38834,38835,39015,39154,39155,39156,39162,
   39163,39166,39167,39176,39177,39313,39314,39320,39321,39324,
   39325,39334,39335,39351,39357,39358,39361,39362,39371,39372,
   39393,39394,39397,39398,39407,39408,39589,39592,39593,39602,
   39603,39621,39622,39631,39632,39703,39712,39713,39737,39738,
   39918,40174,40175,40181,40182,40185,40186,40195,40196,40212,
   40218,40219,40222,40223,40232,40233,40254,40255,40258,40259,
   40268,40269,40450,40453,40454,40463,40464,40482,40483,40492,
   40493,40564,40573,40574,40598,40599,40779,43256,43262,43263,
   43266,43267,43276,43277,43298,43299,43302,43303,43312,43313,
   43494,43497,43498,43507,43508,43526,43527,43536,43537,43608,
   43617,43618,43642,43643,43823,43964,43965,43968,43969,43978,
   43979,44160,44163,44164,44173,44174,44192,44193,44202,44203,
   44274,44283,44284,44308,44309,44489,44790,44793,44794,44803,
   44804,44822,44823,44832,44833,44904,44913,44914,44938,44939,
   45119,47902,47903,47912,47913,47984,47993,47994,48018,48019,
   48199,48390,48399,48400,48424,48425,48605,49478,49479,49659,
   49959],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,
   2384,3500,3501,3505,3506,3507,3513,3514,3517,3518,3527,3528,
   3544,3548,3549,3550,3556,3557,3560,3561,3570,3571,3590,3591,
   3592,3598,3599,3602,3603,3612,3613,3749,3750,3756,3757,3760,
   3761,3770,3771,3787,3793,3794,3797,3798,3829,3830,3833,3834,
   3843,3844,4025,4028,4029,4038,4039,4057,4058,4139,4148,4149,
   4173,4174,4354,4510,4511,4512,4518,4528,4529,5645,5646,5650,
   5651,5652,5658,5659,5662,5663,5672,5673,5689,5693,5694,5695,
   5701,5702,5705,5706,5715,5716,5735,5736,5737,5743,5744,5747,
   5748,5757,5758,5894,5895,5902,5905,5906,5916,5932,5939,5942,
   5943,5953,5974,5975,5978,5979,5988,5989,6170,6173,6174,6183,
   6184,6202,6203,6212,6213,6284,6293,6294,6318,6319,6499,7725,
   7726,7730,7731,7732,7738,7739,7742,7743,7752,7753,7769,7773,
   7774,7775,7781,7782,7785,7786,7795,7796,7815,7816,7817,7823,
   7824,7827,7828,7837,7838,7974,7975,7985,7986,7995,7996,8012,
   8018,8019,8022,8023,8032,8033,8054,8055,8058,8059,8068,8069,
   8250,8253,8254,8263,8282,8283,8292,8364,8373,8374,8398,8399,
   8579,38205,38209,38210,38211,38217,38218,38221,38222,38231,
   38232,38251,38252,38253,38259,38260,38263,38264,38273,38274,
   38410,38411,38417,38418,38421,38422,38431,38432,38448,38454,
   38455,38458,38459,38468,38469,38490,38491,38494,38495,38504,
   38505,38686,38689,38690,38699,38700,38718,38719,38728,38729,
   38800,38809,38810,38834,38835,39015,39154,39155,39156,39162,
   39163,39166,39167,39176,39177,39313,39314,39320,39321,39324,
   39325,39334,39335,39351,39357,39358,39361,39362,39371,39372,
   39393,39394,39397,39398,39407,39408,39589,39592,39593,39602,
   39603,39621,39622,39631,39632,39703,39712,39713,39737,39738,
   39918,40174,40175,40181,40182,40185,40186,40195,40196,40212,
   40218,40219,40222,40223,40232,40233,40254,40255,40258,40259,
   40268,40269,40450,40453,40454,40463,40464,40482,40483,40492,
   40493,40564,40573,40574,40598,40599,40779,43256,43262,43263,
   43266,43267,43276,43277,43298,43299,43302,43303,43312,43313,
   43494,43497,43498,43507,43508,43526,43527,43536,43537,43608,
   43617,43618,43642,43643,43823,43964,43965,43968,43969,43978,
   43979,44160,44163,44164,44173,44174,44192,44193,44202,44203,
   44274,44283,44284,44308,44309,44489,44790,44793,44794,44803,
   44804,44822,44823,44832,44833,44904,44913,44914,44938,44939,
   45119,47902,47903,47912,47913,47984,47993,47994,48018,48019,
   48199,48390,48399,48400,48424,48425,48605,49478,49479,49659,
   49959],[2279],[2279],
 [2279,3500,3501,3507,3517,3518,3544,3550,3592,3833,3834,4139,
   5645,5646,5662,5689,5695,5705,5706,5747,5978,5979,6284,7725,
   7726,7743,7769,7786,7817,7827,7828,8058,8059,8364,38205,
   38211,38221,38222,38253,38263,38264,38494,38495,38800,39156,
   39166,39167,39397,39398,39703,40258,40259,40564,44904],
 [2279,3500,3501,3507,3517,3518,3544,3550,3592,3833,3834,4139,
   5645,5646,5662,5689,5695,5705,5706,5747,5978,5979,6284,7725,
   7726,7743,7769,7786,7817,7827,7828,8058,8059,8364,38205,
   38211,38221,38222,38253,38263,38264,38494,38495,38800,39156,
   39166,39167,39397,39398,39703,40258,40259,40564,44904],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,
   2384,3500,3501,3507,3510,3512,3517,3518,3519,3523,3525,3526,
   3544,3550,3553,3555,3560,3561,3562,3566,3568,3569,3592,3595,
   3597,3602,3603,3604,3608,3610,3611,3826,3828,3833,3834,3835,
   3839,3841,3842,3930,3935,3936,3937,3941,3998,3999,4000,4004,
   4139,4140,4144,4146,4147,4165,4169,4171,4172,4193,4195,4196,
   4281,4282,4319,4510,4511,4512,4518,4528,4529,5645,5646,5652,
   5655,5657,5662,5663,5664,5668,5670,5671,5689,5695,5698,5700,
   5705,5706,5707,5711,5713,5714,5737,5740,5742,5747,5748,5749,
   5753,5755,5756,5971,5973,5978,5979,5980,5984,5986,5987,6075,
   6080,6081,6086,6089,6143,6144,6145,6149,6151,6152,6284,6285,
   6289,6291,6292,6310,6314,6316,6317,6340,6341,6427,6464,7725,
   7726,7732,7735,7737,7742,7743,7744,7748,7750,7751,7769,7775,
   7778,7780,7785,7786,7787,7791,7793,7794,7817,7820,7822,7827,
   7828,7829,7833,7835,7836,8051,8053,8058,8059,8060,8064,8066,
   8067,8155,8160,8161,8162,8166,8168,8169,8223,8224,8225,8231,
   8364,8365,8369,8371,8372,8390,8394,8396,8397,8420,8506,8507,
   8544,38205,38211,38214,38216,38221,38222,38223,38227,38229,
   38230,38253,38256,38258,38263,38264,38265,38269,38271,38272,
   38487,38489,38494,38495,38496,38500,38502,38503,38591,38596,
   38597,38598,38602,38604,38605,38659,38660,38661,38665,38667,
   38668,38800,38801,38805,38807,38808,38826,38830,38832,38833,
   38854,38856,38857,38942,38943,38980,39156,39159,39161,39166,
   39167,39168,39172,39174,39175,39390,39392,39397,39398,39399,
   39403,39405,39406,39494,39499,39500,39501,39505,39507,39508,
   39562,39563,39564,39568,39570,39571,39703,39704,39708,39710,
   39711,39729,39733,39735,39736,39757,39759,39760,39845,39846,
   39883,40251,40253,40258,40259,40260,40264,40266,40267,40355,
   40360,40361,40362,40366,40368,40369,40423,40424,40425,40429,
   40431,40432,40564,40565,40569,40571,40572,40590,40594,40596,
   40597,40618,40620,40621,40706,40707,40744,44695,44700,44701,
   44702,44706,44708,44709,44763,44764,44765,44769,44771,44772,
   44904,44905,44909,44911,44912,44930,44934,44936,44937,44958,
   44960,44961,45046,45047,45084,46447,46448,46449,46453,46455,
   46456,46588,46589,46593,46595,46596,46614,46618,46620,46621,
   46642,46644,46645,46730,46731,46768,47549,47550,47554,47556,
   47557,47575,47579,47581,47582,47603,47605,47606,47691,47692,
   47729,49470,49474,49476,49477,49498,49500,49501,49586,49587,
   49624,49798,49800,49801,49886,49887,49924,50162,50163,50200,
   51084],
 [2279,3714,3725,3905,5859,5870,6050,7939,7950,8130,42671],
 [2279],[1,2,23,26,31,32,41,42,44,68,89,90,91,92,93,94,
   107,156,157,158,163,164,166,173,177,179,1289,1290,1291,
   1292,1293,1296,1297,1298,1300,1306,1307,1309,1311,1313,1333,
   1334,1335,1336,1339,1340,1341,1343,1349,1350,1352,1354,1356,
   1376,1377,1378,1381,1382,1383,1385,1391,1392,1394,1396,1398,
   1418,1419,1422,1423,1424,1426,1432,1433,1435,1437,1439,1459,
   1462,1463,1464,1466,1472,1473,1475,1477,1479,1501,1502,1503,
   1505,1511,1512,1514,1516,1518,1613,1614,1616,1622,1623,1625,
   1627,1629,1649,1651,1657,1658,1660,1662,1664,1685,1691,1692,
   1694,1696,1698,1756,1757,1759,1761,1763,1928,1930,1932,1934,
   1955,1957,1959,2004,2006,2049,2279,2300,2301,2302,2305,2308,
   2310,2318,2319,2321,2365,2366,2367,2370,2373,2375,2383,2384,
   2386,3500,3501,3502,3503,3504,3507,3508,3509,3511,3517,3518,
   3520,3522,3524,3544,3545,3546,3547,3550,3551,3552,3554,3560,
   3561,3563,3565,3567,3587,3588,3589,3592,3593,3594,3596,3602,
   3603,3605,3607,3609,3629,3630,3633,3634,3635,3637,3643,3644,
   3646,3648,3650,3670,3673,3674,3675,3677,3683,3684,3686,3688,
   3690,3712,3713,3714,3716,3722,3723,3725,3727,3729,3824,3825,
   3827,3833,3834,3836,3838,3840,3860,3862,3868,3869,3871,3873,
   3875,3896,3902,3903,3905,3907,3909,3967,3968,3970,3972,3974,
   4139,4141,4143,4145,4166,4168,4170,4215,4217,4260,4510,4511,
   4512,4515,4518,4520,4528,4529,4531,5645,5646,5647,5648,5649,
   5652,5653,5654,5656,5662,5663,5665,5667,5669,5689,5690,5691,
   5692,5695,5696,5697,5699,5705,5706,5708,5710,5712,5732,5733,
   5734,5737,5738,5739,5741,5747,5748,5750,5752,5754,5774,5775,
   5778,5779,5780,5782,5788,5789,5791,5793,5795,5815,5818,5819,
   5820,5822,5828,5829,5831,5833,5835,5857,5858,5859,5861,5867,
   5868,5870,5872,5874,5969,5970,5972,5978,5979,5981,5983,5985,
   6005,6007,6013,6014,6016,6018,6020,6041,6047,6048,6050,6052,
   6054,6112,6113,6115,6117,6119,6284,6286,6288,6290,6311,6313,
   6315,6360,6362,6405,7725,7726,7727,7728,7729,7732,7733,7734,
   7736,7742,7743,7745,7747,7749,7769,7770,7771,7772,7775,7776,
   7777,7779,7785,7786,7788,7790,7792,7812,7813,7814,7817,7818,
   7819,7821,7827,7828,7830,7832,7834,7854,7855,7858,7859,7860,
   7862,7868,7869,7871,7873,7875,7895,7898,7899,7900,7902,7908,
   7909,7911,7913,7915,7937,7938,7939,7941,7947,7948,7950,7952,
   7954,8049,8050,8052,8058,8059,8061,8063,8065,8085,8087,8093,
   8094,8096,8098,8100,8121,8127,8128,8130,8132,8134,8192,8193,
   8195,8197,8199,8364,8366,8368,8370,8391,8393,8395,8440,8442,
   8485,38205,38206,38207,38208,38211,38212,38213,38215,38221,
   38222,38224,38226,38228,38248,38249,38250,38253,38254,38255,
   38257,38263,38264,38266,38268,38270,38290,38291,38294,38295,
   38296,38298,38304,38305,38307,38309,38311,38331,38334,38335,
   38336,38338,38344,38345,38347,38349,38351,38373,38374,38375,
   38377,38383,38384,38386,38388,38390,38485,38486,38488,38494,
   38495,38497,38499,38501,38521,38523,38529,38530,38532,38534,
   38536,38557,38563,38564,38566,38568,38570,38628,38629,38631,
   38633,38635,38800,38802,38804,38806,38827,38829,38831,38876,
   38878,38921,39151,39152,39153,39156,39157,39158,39160,39166,
   39167,39169,39171,39173,39193,39194,39197,39198,39199,39201,
   39207,39208,39210,39212,39214,39234,39237,39238,39239,39241,
   39247,39248,39250,39252,39254,39276,39277,39278,39280,39286,
   39287,39289,39291,39293,39388,39389,39391,39397,39398,39400,
   39402,39404,39424,39426,39432,39433,39435,39437,39439,39460,
   39466,39467,39469,39471,39473,39531,39532,39534,39536,39538,
   39703,39705,39707,39709,39730,39732,39734,39779,39781,39824,
   40054,40055,40058,40059,40060,40062,40068,40069,40071,40073,
   40075,40095,40098,40099,40100,40102,40108,40109,40111,40113,
   40115,40137,40138,40139,40141,40147,40148,40150,40152,40154,
   40249,40250,40252,40258,40259,40261,40263,40265,40285,40287,
   40293,40294,40296,40298,40300,40321,40327,40328,40330,40332,
   40334,40392,40393,40395,40397,40399,40564,40566,40568,40570,
   40591,40593,40595,40640,40642,40685,40915,40918,40919,40920,
   40922,40928,40929,40931,40933,40935,40957,40958,40959,40961,
   40967,40968,40970,40972,40974,41069,41070,41072,41078,41079,
   41081,41083,41085,41105,41107,41113,41114,41116,41118,41120,
   41141,41147,41148,41150,41152,41154,41212,41213,41215,41217,
   41219,41384,41386,41388,41390,41411,41413,41415,41460,41462,
   41505,41737,41738,41739,41741,41747,41748,41750,41752,41754,
   41849,41850,41852,41858,41859,41861,41863,41865,41885,41887,
   41893,41894,41896,41898,41900,41921,41927,41928,41930,41932,
   41934,41992,41993,41995,41997,41999,42164,42166,42168,42170,
   42191,42193,42195,42240,42242,42285,42590,42591,42593,42599,
   42600,42602,42604,42606,42626,42628,42634,42635,42637,42639,
   42641,42662,42668,42669,42671,42673,42675,42733,42734,42736,
   42738,42740,42905,42907,42909,42911,42932,42934,42936,42981,
   42983,43026,44625,44627,44633,44634,44636,44638,44640,44661,
   44667,44668,44670,44672,44674,44732,44733,44735,44737,44739,
   44904,44906,44908,44910,44931,44933,44935,44980,44982,45025,
   45256,45262,45263,45265,45267,45269,45327,45328,45330,45332,
   45334,45499,45501,45503,45505,45526,45528,45530,45575,45577,
   45620,45888,45889,45891,45893,45895,46060,46062,46064,46066,
   46087,46089,46091,46136,46138,46181,47084,47086,47088,47090,
   47111,47113,47115,47160,47162,47205,49471,49473,49475,49520,
   49522,49565,49820,49822,49865,50394],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,
   2384,3500,3501,3507,3510,3512,3517,3518,3519,3523,3525,3526,
   3544,3550,3553,3555,3560,3561,3562,3566,3568,3569,3592,3595,
   3597,3602,3603,3604,3608,3610,3611,3826,3828,3833,3834,3835,
   3839,3841,3842,3930,3935,3936,3937,3941,3998,3999,4000,4004,
   4139,4140,4144,4146,4147,4165,4169,4171,4172,4193,4195,4196,
   4281,4282,4319,4510,4511,4512,4518,4528,4529,5645,5646,5652,
   5655,5657,5662,5663,5664,5668,5670,5671,5689,5695,5698,5700,
   5705,5706,5707,5711,5713,5714,5737,5740,5742,5747,5748,5749,
   5753,5755,5756,5971,5973,5978,5979,5980,5984,5986,5987,6075,
   6080,6081,6086,6089,6143,6144,6145,6149,6151,6152,6284,6285,
   6289,6291,6292,6310,6314,6316,6317,6340,6341,6427,6464,7725,
   7726,7732,7735,7737,7742,7743,7744,7748,7750,7751,7769,7775,
   7778,7780,7785,7786,7787,7791,7793,7794,7817,7820,7822,7827,
   7828,7829,7833,7835,7836,8051,8053,8058,8059,8060,8064,8066,
   8067,8155,8160,8161,8162,8166,8168,8169,8223,8224,8225,8231,
   8364,8365,8369,8371,8372,8390,8394,8396,8397,8420,8506,8507,
   8544,38205,38211,38214,38216,38221,38222,38223,38227,38229,
   38230,38253,38256,38258,38263,38264,38265,38269,38271,38272,
   38487,38489,38494,38495,38496,38500,38502,38503,38591,38596,
   38597,38598,38602,38604,38605,38659,38660,38661,38665,38667,
   38668,38800,38801,38805,38807,38808,38826,38830,38832,38833,
   38854,38856,38857,38942,38943,38980,39156,39159,39161,39166,
   39167,39168,39172,39174,39175,39390,39392,39397,39398,39399,
   39403,39405,39406,39494,39499,39500,39501,39505,39507,39508,
   39562,39563,39564,39568,39570,39571,39703,39704,39708,39710,
   39711,39729,39733,39735,39736,39757,39759,39760,39845,39846,
   39883,40251,40253,40258,40259,40260,40264,40266,40267,40355,
   40360,40361,40362,40366,40368,40369,40423,40424,40425,40429,
   40431,40432,40564,40565,40569,40571,40572,40590,40594,40596,
   40597,40618,40620,40621,40706,40707,40744,44695,44700,44701,
   44702,44706,44708,44709,44763,44764,44765,44769,44771,44772,
   44904,44905,44909,44911,44912,44930,44934,44936,44937,44958,
   44960,44961,45046,45047,45084,46447,46448,46449,46453,46455,
   46456,46588,46589,46593,46595,46596,46614,46618,46620,46621,
   46642,46644,46645,46730,46731,46768,47549,47550,47554,47556,
   47557,47575,47579,47581,47582,47603,47605,47606,47691,47692,
   47729,49470,49474,49476,49477,49498,49500,49501,49586,49587,
   49624,49798,49800,49801,49886,49887,49924,50162,50163,50200,
   51084],
 [1,2,23,26,31,32,41,42,44,68,89,90,91,92,93,94,107,156,
   157,158,163,164,166,173,177,179,1289,1290,1291,1292,1293,
   1296,1297,1298,1300,1306,1307,1309,1311,1313,1333,1334,1335,
   1336,1339,1340,1341,1343,1349,1350,1352,1354,1356,1376,1377,
   1378,1381,1382,1383,1385,1391,1392,1394,1396,1398,1418,1419,
   1422,1423,1424,1426,1432,1433,1435,1437,1439,1459,1462,1463,
   1464,1466,1472,1473,1475,1477,1479,1501,1502,1503,1505,1511,
   1512,1514,1516,1518,1613,1614,1616,1622,1623,1625,1627,1629,
   1649,1651,1657,1658,1660,1662,1664,1685,1691,1692,1694,1696,
   1698,1756,1757,1759,1761,1763,1928,1930,1932,1934,1955,1957,
   1959,2004,2006,2049,2279,2300,2301,2302,2305,2308,2310,2318,
   2319,2321,2365,2366,2367,2370,2373,2375,2383,2384,2386,3500,
   3501,3502,3503,3504,3507,3508,3509,3511,3517,3518,3520,3522,
   3524,3544,3545,3546,3547,3550,3551,3552,3554,3560,3561,3563,
   3565,3567,3587,3588,3589,3592,3593,3594,3596,3602,3603,3605,
   3607,3609,3629,3630,3633,3634,3635,3637,3643,3644,3646,3648,
   3650,3670,3673,3674,3675,3677,3683,3684,3686,3688,3690,3712,
   3713,3714,3716,3722,3723,3725,3727,3729,3824,3825,3827,3833,
   3834,3836,3838,3840,3860,3862,3868,3869,3871,3873,3875,3896,
   3902,3903,3905,3907,3909,3967,3968,3970,3972,3974,4139,4141,
   4143,4145,4166,4168,4170,4215,4217,4260,4510,4511,4512,4515,
   4518,4520,4528,4529,4531,5645,5646,5647,5648,5649,5652,5653,
   5654,5656,5662,5663,5665,5667,5669,5689,5690,5691,5692,5695,
   5696,5697,5699,5705,5706,5708,5710,5712,5732,5733,5734,5737,
   5738,5739,5741,5747,5748,5750,5752,5754,5774,5775,5778,5779,
   5780,5782,5788,5789,5791,5793,5795,5815,5818,5819,5820,5822,
   5828,5829,5831,5833,5835,5857,5858,5859,5861,5867,5868,5870,
   5872,5874,5969,5970,5972,5978,5979,5981,5983,5985,6005,6007,
   6013,6014,6016,6018,6020,6041,6047,6048,6050,6052,6054,6112,
   6113,6115,6117,6119,6284,6286,6288,6290,6311,6313,6315,6360,
   6362,6405,7725,7726,7727,7728,7729,7732,7733,7734,7736,7742,
   7743,7745,7747,7749,7769,7770,7771,7772,7775,7776,7777,7779,
   7785,7786,7788,7790,7792,7812,7813,7814,7817,7818,7819,7821,
   7827,7828,7830,7832,7834,7854,7855,7858,7859,7860,7862,7868,
   7869,7871,7873,7875,7895,7898,7899,7900,7902,7908,7909,7911,
   7913,7915,7937,7938,7939,7941,7947,7948,7950,7952,7954,8049,
   8050,8052,8058,8059,8061,8063,8065,8085,8087,8093,8094,8096,
   8098,8100,8121,8127,8128,8130,8132,8134,8192,8193,8195,8197,
   8199,8364,8366,8368,8370,8391,8393,8395,8440,8442,8485,
   38205,38206,38207,38208,38211,38212,38213,38215,38221,38222,
   38224,38226,38228,38248,38249,38250,38253,38254,38255,38257,
   38263,38264,38266,38268,38270,38290,38291,38294,38295,38296,
   38298,38304,38305,38307,38309,38311,38331,38334,38335,38336,
   38338,38344,38345,38347,38349,38351,38373,38374,38375,38377,
   38383,38384,38386,38388,38390,38485,38486,38488,38494,38495,
   38497,38499,38501,38521,38523,38529,38530,38532,38534,38536,
   38557,38563,38564,38566,38568,38570,38628,38629,38631,38633,
   38635,38800,38802,38804,38806,38827,38829,38831,38876,38878,
   38921,39151,39152,39153,39156,39157,39158,39160,39166,39167,
   39169,39171,39173,39193,39194,39197,39198,39199,39201,39207,
   39208,39210,39212,39214,39234,39237,39238,39239,39241,39247,
   39248,39250,39252,39254,39276,39277,39278,39280,39286,39287,
   39289,39291,39293,39388,39389,39391,39397,39398,39400,39402,
   39404,39424,39426,39432,39433,39435,39437,39439,39460,39466,
   39467,39469,39471,39473,39531,39532,39534,39536,39538,39703,
   39705,39707,39709,39730,39732,39734,39779,39781,39824,40054,
   40055,40058,40059,40060,40062,40068,40069,40071,40073,40075,
   40095,40098,40099,40100,40102,40108,40109,40111,40113,40115,
   40137,40138,40139,40141,40147,40148,40150,40152,40154,40249,
   40250,40252,40258,40259,40261,40263,40265,40285,40287,40293,
   40294,40296,40298,40300,40321,40327,40328,40330,40332,40334,
   40392,40393,40395,40397,40399,40564,40566,40568,40570,40591,
   40593,40595,40640,40642,40685,40915,40918,40919,40920,40922,
   40928,40929,40931,40933,40935,40957,40958,40959,40961,40967,
   40968,40970,40972,40974,41069,41070,41072,41078,41079,41081,
   41083,41085,41105,41107,41113,41114,41116,41118,41120,41141,
   41147,41148,41150,41152,41154,41212,41213,41215,41217,41219,
   41384,41386,41388,41390,41411,41413,41415,41460,41462,41505,
   41737,41738,41739,41741,41747,41748,41750,41752,41754,41849,
   41850,41852,41858,41859,41861,41863,41865,41885,41887,41893,
   41894,41896,41898,41900,41921,41927,41928,41930,41932,41934,
   41992,41993,41995,41997,41999,42164,42166,42168,42170,42191,
   42193,42195,42240,42242,42285,42590,42591,42593,42599,42600,
   42602,42604,42606,42626,42628,42634,42635,42637,42639,42641,
   42662,42668,42669,42671,42673,42675,42733,42734,42736,42738,
   42740,42905,42907,42909,42911,42932,42934,42936,42981,42983,
   43026,44625,44627,44633,44634,44636,44638,44640,44661,44667,
   44668,44670,44672,44674,44732,44733,44735,44737,44739,44904,
   44906,44908,44910,44931,44933,44935,44980,44982,45025,45256,
   45262,45263,45265,45267,45269,45327,45328,45330,45332,45334,
   45499,45501,45503,45505,45526,45528,45530,45575,45577,45620,
   45888,45889,45891,45893,45895,46060,46062,46064,46066,46087,
   46089,46091,46136,46138,46181,47084,47086,47088,47090,47111,
   47113,47115,47160,47162,47205,49471,49473,49475,49520,49522,
   49565,49820,49822,49865,50394],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,
   2384,3500,3501,3507,3510,3512,3517,3518,3519,3523,3525,3526,
   3544,3550,3553,3555,3560,3561,3562,3566,3568,3569,3592,3595,
   3597,3602,3603,3604,3608,3610,3611,3826,3828,3833,3834,3835,
   3839,3841,3842,3930,3935,3936,3937,3941,3998,3999,4000,4004,
   4139,4140,4144,4146,4147,4165,4169,4171,4172,4193,4195,4196,
   4281,4282,4319,4510,4511,4512,4518,4528,4529,5645,5646,5652,
   5655,5657,5662,5663,5664,5668,5670,5671,5689,5695,5698,5700,
   5705,5706,5707,5711,5713,5714,5737,5740,5742,5747,5748,5749,
   5753,5755,5756,5971,5973,5978,5979,5980,5984,5986,5987,6075,
   6080,6081,6086,6089,6143,6144,6145,6149,6151,6152,6284,6285,
   6289,6291,6292,6310,6314,6316,6317,6340,6341,6427,6464,7725,
   7726,7732,7735,7737,7742,7743,7744,7748,7750,7751,7769,7775,
   7778,7780,7785,7786,7787,7791,7793,7794,7817,7820,7822,7827,
   7828,7829,7833,7835,7836,8051,8053,8058,8059,8060,8064,8066,
   8067,8155,8160,8161,8162,8166,8168,8169,8223,8224,8225,8231,
   8364,8365,8369,8371,8372,8390,8394,8396,8397,8420,8506,8507,
   8544,38205,38211,38214,38216,38221,38222,38223,38227,38229,
   38230,38253,38256,38258,38263,38264,38265,38269,38271,38272,
   38487,38489,38494,38495,38496,38500,38502,38503,38591,38596,
   38597,38598,38602,38604,38605,38659,38660,38661,38665,38667,
   38668,38800,38801,38805,38807,38808,38826,38830,38832,38833,
   38854,38856,38857,38942,38943,38980,39156,39159,39161,39166,
   39167,39168,39172,39174,39175,39390,39392,39397,39398,39399,
   39403,39405,39406,39494,39499,39500,39501,39505,39507,39508,
   39562,39563,39564,39568,39570,39571,39703,39704,39708,39710,
   39711,39729,39733,39735,39736,39757,39759,39760,39845,39846,
   39883,40251,40253,40258,40259,40260,40264,40266,40267,40355,
   40360,40361,40362,40366,40368,40369,40423,40424,40425,40429,
   40431,40432,40564,40565,40569,40571,40572,40590,40594,40596,
   40597,40618,40620,40621,40706,40707,40744,44695,44700,44701,
   44702,44706,44708,44709,44763,44764,44765,44769,44771,44772,
   44904,44905,44909,44911,44912,44930,44934,44936,44937,44958,
   44960,44961,45046,45047,45084,46447,46448,46449,46453,46455,
   46456,46588,46589,46593,46595,46596,46614,46618,46620,46621,
   46642,46644,46645,46730,46731,46768,47549,47550,47554,47556,
   47557,47575,47579,47581,47582,47603,47605,47606,47691,47692,
   47729,49470,49474,49476,49477,49498,49500,49501,49586,49587,
   49624,49798,49800,49801,49886,49887,49924,50162,50163,50200,
   51084],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,
   2384,3500,3501,3507,3510,3512,3517,3518,3519,3523,3525,3526,
   3544,3550,3553,3555,3560,3561,3562,3566,3568,3569,3592,3595,
   3597,3602,3603,3604,3608,3610,3611,3826,3828,3833,3834,3835,
   3839,3841,3842,3930,3935,3936,3937,3941,3998,3999,4000,4004,
   4139,4140,4144,4146,4147,4165,4169,4171,4172,4193,4195,4196,
   4281,4282,4319,4510,4511,4512,4518,4528,4529,5645,5646,5652,
   5655,5657,5662,5663,5664,5668,5670,5671,5689,5695,5698,5700,
   5705,5706,5707,5711,5713,5714,5737,5740,5742,5747,5748,5749,
   5753,5755,5756,5971,5973,5978,5979,5980,5984,5986,5987,6075,
   6080,6081,6086,6089,6143,6144,6145,6149,6151,6152,6284,6285,
   6289,6291,6292,6310,6314,6316,6317,6340,6341,6427,6464,7725,
   7726,7732,7735,7737,7742,7743,7744,7748,7750,7751,7769,7775,
   7778,7780,7785,7786,7787,7791,7793,7794,7817,7820,7822,7827,
   7828,7829,7833,7835,7836,8051,8053,8058,8059,8060,8064,8066,
   8067,8155,8160,8161,8162,8166,8168,8169,8223,8224,8225,8231,
   8364,8365,8369,8371,8372,8390,8394,8396,8397,8420,8506,8507,
   8544,38205,38211,38214,38216,38221,38222,38223,38227,38229,
   38230,38253,38256,38258,38263,38264,38265,38269,38271,38272,
   38487,38489,38494,38495,38496,38500,38502,38503,38591,38596,
   38597,38598,38602,38604,38605,38659,38660,38661,38665,38667,
   38668,38800,38801,38805,38807,38808,38826,38830,38832,38833,
   38854,38856,38857,38942,38943,38980,39156,39159,39161,39166,
   39167,39168,39172,39174,39175,39390,39392,39397,39398,39399,
   39403,39405,39406,39494,39499,39500,39501,39505,39507,39508,
   39562,39563,39564,39568,39570,39571,39703,39704,39708,39710,
   39711,39729,39733,39735,39736,39757,39759,39760,39845,39846,
   39883,40251,40253,40258,40259,40260,40264,40266,40267,40355,
   40360,40361,40362,40366,40368,40369,40423,40424,40425,40429,
   40431,40432,40564,40565,40569,40571,40572,40590,40594,40596,
   40597,40618,40620,40621,40706,40707,40744,44695,44700,44701,
   44702,44706,44708,44709,44763,44764,44765,44769,44771,44772,
   44904,44905,44909,44911,44912,44930,44934,44936,44937,44958,
   44960,44961,45046,45047,45084,46447,46448,46449,46453,46455,
   46456,46588,46589,46593,46595,46596,46614,46618,46620,46621,
   46642,46644,46645,46730,46731,46768,47549,47550,47554,47556,
   47557,47575,47579,47581,47582,47603,47605,47606,47691,47692,
   47729,49470,49474,49476,49477,49498,49500,49501,49586,49587,
   49624,49798,49800,49801,49886,49887,49924,50162,50163,50200,
   51084],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,
   2384,3500,3501,3505,3506,3507,3513,3514,3517,3518,3527,3528,
   3544,3548,3549,3550,3556,3557,3560,3561,3570,3571,3590,3591,
   3592,3598,3599,3602,3603,3612,3613,3749,3750,3756,3757,3760,
   3761,3770,3771,3787,3793,3794,3797,3798,3829,3830,3833,3834,
   3843,3844,4025,4028,4029,4038,4039,4057,4058,4139,4148,4149,
   4173,4174,4354,4510,4511,4512,4518,4528,4529,5645,5646,5650,
   5651,5652,5658,5659,5662,5663,5672,5673,5689,5693,5694,5695,
   5701,5702,5705,5706,5715,5716,5735,5736,5737,5743,5744,5747,
   5748,5757,5758,5894,5895,5902,5905,5906,5916,5932,5939,5942,
   5943,5953,5974,5975,5978,5979,5988,5989,6170,6173,6174,6183,
   6184,6202,6203,6212,6213,6284,6293,6294,6318,6319,6499,7725,
   7726,7730,7731,7732,7738,7739,7742,7743,7752,7753,7769,7773,
   7774,7775,7781,7782,7785,7786,7795,7796,7815,7816,7817,7823,
   7824,7827,7828,7837,7838,7974,7975,7985,7986,7995,7996,8012,
   8018,8019,8022,8023,8032,8033,8054,8055,8058,8059,8068,8069,
   8250,8253,8254,8263,8282,8283,8292,8364,8373,8374,8398,8399,
   8579,38205,38209,38210,38211,38217,38218,38221,38222,38231,
   38232,38251,38252,38253,38259,38260,38263,38264,38273,38274,
   38410,38411,38417,38418,38421,38422,38431,38432,38448,38454,
   38455,38458,38459,38468,38469,38490,38491,38494,38495,38504,
   38505,38686,38689,38690,38699,38700,38718,38719,38728,38729,
   38800,38809,38810,38834,38835,39015,39154,39155,39156,39162,
   39163,39166,39167,39176,39177,39313,39314,39320,39321,39324,
   39325,39334,39335,39351,39357,39358,39361,39362,39371,39372,
   39393,39394,39397,39398,39407,39408,39589,39592,39593,39602,
   39603,39621,39622,39631,39632,39703,39712,39713,39737,39738,
   39918,40174,40175,40181,40182,40185,40186,40195,40196,40212,
   40218,40219,40222,40223,40232,40233,40254,40255,40258,40259,
   40268,40269,40450,40453,40454,40463,40464,40482,40483,40492,
   40493,40564,40573,40574,40598,40599,40779,43256,43262,43263,
   43266,43267,43276,43277,43298,43299,43302,43303,43312,43313,
   43494,43497,43498,43507,43508,43526,43527,43536,43537,43608,
   43617,43618,43642,43643,43823,43964,43965,43968,43969,43978,
   43979,44160,44163,44164,44173,44174,44192,44193,44202,44203,
   44274,44283,44284,44308,44309,44489,44790,44793,44794,44803,
   44804,44822,44823,44832,44833,44904,44913,44914,44938,44939,
   45119,47902,47903,47912,47913,47984,47993,47994,48018,48019,
   48199,48390,48399,48400,48424,48425,48605,49478,49479,49659,
   49959],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,
   2384,3500,3501,3505,3506,3507,3513,3514,3517,3518,3527,3528,
   3544,3548,3549,3550,3556,3557,3560,3561,3570,3571,3590,3591,
   3592,3598,3599,3602,3603,3612,3613,3749,3750,3756,3757,3760,
   3761,3770,3771,3787,3793,3794,3797,3798,3829,3830,3833,3834,
   3843,3844,4025,4028,4029,4038,4039,4057,4058,4139,4148,4149,
   4173,4174,4354,4510,4511,4512,4518,4528,4529,5645,5646,5650,
   5651,5652,5658,5659,5662,5663,5672,5673,5689,5693,5694,5695,
   5701,5702,5705,5706,5715,5716,5735,5736,5737,5743,5744,5747,
   5748,5757,5758,5894,5895,5902,5905,5906,5916,5932,5939,5942,
   5943,5953,5974,5975,5978,5979,5988,5989,6170,6173,6174,6183,
   6184,6202,6203,6212,6213,6284,6293,6294,6318,6319,6499,7725,
   7726,7730,7731,7732,7738,7739,7742,7743,7752,7753,7769,7773,
   7774,7775,7781,7782,7785,7786,7795,7796,7815,7816,7817,7823,
   7824,7827,7828,7837,7838,7974,7975,7985,7986,7995,7996,8012,
   8018,8019,8022,8023,8032,8033,8054,8055,8058,8059,8068,8069,
   8250,8253,8254,8263,8282,8283,8292,8364,8373,8374,8398,8399,
   8579,38205,38209,38210,38211,38217,38218,38221,38222,38231,
   38232,38251,38252,38253,38259,38260,38263,38264,38273,38274,
   38410,38411,38417,38418,38421,38422,38431,38432,38448,38454,
   38455,38458,38459,38468,38469,38490,38491,38494,38495,38504,
   38505,38686,38689,38690,38699,38700,38718,38719,38728,38729,
   38800,38809,38810,38834,38835,39015,39154,39155,39156,39162,
   39163,39166,39167,39176,39177,39313,39314,39320,39321,39324,
   39325,39334,39335,39351,39357,39358,39361,39362,39371,39372,
   39393,39394,39397,39398,39407,39408,39589,39592,39593,39602,
   39603,39621,39622,39631,39632,39703,39712,39713,39737,39738,
   39918,40174,40175,40181,40182,40185,40186,40195,40196,40212,
   40218,40219,40222,40223,40232,40233,40254,40255,40258,40259,
   40268,40269,40450,40453,40454,40463,40464,40482,40483,40492,
   40493,40564,40573,40574,40598,40599,40779,43256,43262,43263,
   43266,43267,43276,43277,43298,43299,43302,43303,43312,43313,
   43494,43497,43498,43507,43508,43526,43527,43536,43537,43608,
   43617,43618,43642,43643,43823,43964,43965,43968,43969,43978,
   43979,44160,44163,44164,44173,44174,44192,44193,44202,44203,
   44274,44283,44284,44308,44309,44489,44790,44793,44794,44803,
   44804,44822,44823,44832,44833,44904,44913,44914,44938,44939,
   45119,47902,47903,47912,47913,47984,47993,47994,48018,48019,
   48199,48390,48399,48400,48424,48425,48605,49478,49479,49659,
   49959],[2279],[2279],[2279],[2279],[2279],[2279],
 [2279],[2279],[2279],[2279],[2279],[2279],[2279],
 [2279],[2279],[8715],[8715],[],
 [23,31,44,202,218,464,1296,1309,1625,2429,2437,2675,2683,
   3507,3520,3836,8916,9748,9761,10077,17192,17205,17521,38497],
 [2429,2437,2447,2448,2734,2742,2752,2753,2849,2857,3507,3517,
   3518,3833,3834,4139,8962,8975,8983,8993,8994,9090,9098,9108,
   9109,9748,9758,9759,10074,10075,10380,18245,18253,18263,
   18264,18903,18913,18914,19229,19230,19535,22152,22162,22163,
   22478,22479,22784,38494,38495,38800,44904],
 [2449,2453,2812,2816,4193,9053,9057,10434,21242],
 [2429,2437,2447,2448,2734,2742,2752,2753,2849,2857,3507,3517,
   3518,3833,3834,4139,8962,8975,8983,8993,8994,9090,9098,9108,
   9109,9748,9758,9759,10074,10075,10380,18245,18253,18263,
   18264,18903,18913,18914,19229,19230,19535,22152,22162,22163,
   22478,22479,22784,38494,38495,38800,44904],
 [2429,2437,2905,2913,3507,9146,9154,9748,23692],[],[],
 [],[],[],[],[],[],[],[],[],[3507],
 [2429,2437,3500,3501,3507,3544,3550,3592,9741,9742,9748,9785,
   9791,9833,38205,38211,38253,39156],
 [2429,2437,3500,3501,3507,3544,3550,3592,9741,9742,9748,9785,
   9791,9833,38205,38211,38253,39156],
 [2429,2437,3502,3507,3508,3633,3634,3824,9743,9748,9749,9874,
   9875,10065,38294,38295,38485,41069],
 [2429,2437,3503,3504,3507,3509,3511,3670,3673,3675,3677,3712,
   3714,3716,3825,3827,3896,9744,9745,9748,9750,9752,9911,9914,
   9916,9918,9953,9955,9957,10066,10068,10137,38331,38334,38336,
   38338,38373,38375,38377,38486,38488,38557,41737,41739,41741,
   41850,41852,41921,42591,42593,42662,44661],
 [2429,2437,3503,3504,3507,3509,3511,3670,3673,3675,3677,3712,
   3714,3716,3825,3827,3896,9744,9745,9748,9750,9752,9911,9914,
   9916,9918,9953,9955,9957,10066,10068,10137,38331,38334,38336,
   38338,38373,38375,38377,38486,38488,38557,41737,41739,41741,
   41850,41852,41921,42591,42593,42662,44661],[3756],
 [2429,2437,3506,3507,3514,3787,3794,3830,9747,9748,9755,10028,
   10035,10071,38448,38455,38491,43965],[3507],
 [2429,2437,3502,3507,3508,3633,3634,3824,9743,9748,9749,9874,
   9875,10065,38294,38295,38485,41069],
 [2429,2437,3503,3504,3507,3509,3511,3670,3673,3675,3677,3712,
   3714,3716,3825,3827,3896,9744,9745,9748,9750,9752,9911,9914,
   9916,9918,9953,9955,9957,10066,10068,10137,38331,38334,38336,
   38338,38373,38375,38377,38486,38488,38557,41737,41739,41741,
   41850,41852,41921,42591,42593,42662,44661],[3930,10171],
 [2429,2437,3503,3504,3507,3509,3511,3670,3673,3675,3677,3712,
   3714,3716,3825,3827,3896,9744,9745,9748,9750,9752,9911,9914,
   9916,9918,9953,9955,9957,10066,10068,10137,38331,38334,38336,
   38338,38373,38375,38377,38486,38488,38557,41737,41739,41741,
   41850,41852,41921,42591,42593,42662,44661],[3930,10171],
 [3756],
 [2429,2437,3506,3507,3514,3787,3794,3830,9747,9748,9755,10028,
   10035,10071,38448,38455,38491,43965],[],[],
 [2429,2437,3507,3517,3518,3833,3834,4139,9748,9758,9759,10074,
   10075,10380,38494,38495,38800,44904],
 [2429,2437,3507,3517,3518,3833,3834,4139,9748,9758,9759,10074,
   10075,10380,38494,38495,38800,44904],[4193],
 [23,31,44,202,218,464,1296,1309,1625,2429,2437,2675,2683,
   3507,3520,3836,8916,9748,9761,10077,17192,17205,17521,38497],
 [],[2429,2437,3507,3522,3524,3838,3840,4260,9748,9763,9765,
   10079,10081,10501,38499,38501,38921,45025],[4193],
 [2429,2437,3507,3522,3524,3838,3840,4260,9748,9763,9765,10079,
   10081,10501,38499,38501,38921,45025],
 [2429,2437,3507,3525,3526,3841,3842,4319,9748,9766,9767,10082,
   10083,10560,38502,38503,38980,45084],
 [2429,2437,3507,3525,3526,3841,3842,4319,9748,9766,9767,10082,
   10083,10560,38502,38503,38980,45084],
 [2429,2437,3507,3527,3528,3843,3844,4354,9748,9768,9769,10084,
   10085,10595,38504,38505,39015,45119],
 [2429,2437,3507,3527,3528,3843,3844,4354,9748,9768,9769,10084,
   10085,10595,38504,38505,39015,45119],[],[],[],
 [4426,10667],[],[],[4426,10667],[],[],[],[],[],
 [],[],[],[8715],[],[10854],[10854],
 [2492,2500,2792,2800,3507,10986,10994,11701,20556],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[3507],
 [2492,2500,3500,3501,3507,3544,3550,3592,11694,11695,11701,
   11738,11744,11786,38205,38211,38253,39156],
 [2492,2500,3500,3501,3507,3544,3550,3592,11694,11695,11701,
   11738,11744,11786,38205,38211,38253,39156],
 [2492,2500,3502,3507,3508,3633,3634,3824,11696,11701,11702,
   11827,11828,12018,38294,38295,38485,41069],
 [2492,2500,3503,3504,3507,3509,3511,3670,3673,3675,3677,3712,
   3714,3716,3825,3827,3896,11697,11698,11701,11703,11705,11864,
   11867,11869,11871,11906,11908,11910,12019,12021,12090,38331,
   38334,38336,38338,38373,38375,38377,38486,38488,38557,41737,
   41739,41741,41850,41852,41921,42591,42593,42662,44661],
 [2492,2500,3503,3504,3507,3509,3511,3670,3673,3675,3677,3712,
   3714,3716,3825,3827,3896,11697,11698,11701,11703,11705,11864,
   11867,11869,11871,11906,11908,11910,12019,12021,12090,38331,
   38334,38336,38338,38373,38375,38377,38486,38488,38557,41737,
   41739,41741,41850,41852,41921,42591,42593,42662,44661],
 [3756],[3794,11988],[3507],
 [2492,2500,3502,3507,3508,3633,3634,3824,11696,11701,11702,
   11827,11828,12018,38294,38295,38485,41069],
 [2492,2500,3503,3504,3507,3509,3511,3670,3673,3675,3677,3712,
   3714,3716,3825,3827,3896,11697,11698,11701,11703,11705,11864,
   11867,11869,11871,11906,11908,11910,12019,12021,12090,38331,
   38334,38336,38338,38373,38375,38377,38486,38488,38557,41737,
   41739,41741,41850,41852,41921,42591,42593,42662,44661],
 [2492,3510,3512,3930,11704,11706,12124,38591],
 [2492,2500,3503,3504,3507,3509,3511,3670,3673,3675,3677,3712,
   3714,3716,3825,3827,3896,11697,11698,11701,11703,11705,11864,
   11867,11869,11871,11906,11908,11910,12019,12021,12090,38331,
   38334,38336,38338,38373,38375,38377,38486,38488,38557,41737,
   41739,41741,41850,41852,41921,42591,42593,42662,44661],
 [2492,3510,3512,3930,11704,11706,12124,38591],[3756],
 [3794,11988],[],[],
 [2492,2500,3507,3517,3518,3833,3834,4139,11701,11711,11712,
   12027,12028,12333,38494,38495,38800,44904],
 [2492,2500,3507,3517,3518,3833,3834,4139,11701,11711,11712,
   12027,12028,12333,38494,38495,38800,44904],[4193],[],
 [],[2492,2500,3507,3522,3524,3838,3840,4260,11701,11716,
   11718,12032,12034,12454,38499,38501,38921,45025],[4193],
 [2492,2500,3507,3522,3524,3838,3840,4260,11701,11716,11718,
   12032,12034,12454,38499,38501,38921,45025],
 [2492,2500,3507,3525,3526,3841,3842,4319,11701,11719,11720,
   12035,12036,12513,38502,38503,38980,45084],
 [2492,2500,3507,3525,3526,3841,3842,4319,11701,11719,11720,
   12035,12036,12513,38502,38503,38980,45084],
 [2492,2500,3507,3527,3528,3843,3844,4354,11701,11721,11722,
   12037,12038,12548,38504,38505,39015,45119],
 [2492,2500,3507,3527,3528,3843,3844,4354,11701,11721,11722,
   12037,12038,12548,38504,38505,39015,45119],[],[],[],
 [],[],[],[],[4462,12656],[4462,12656],[],[],[],
 [],[],[],[],
 [2554,2557,2562,2563,2675,2678,2683,2684,2849,2857,3502,3507,
   3508,3633,3634,3824,12747,12760,12763,12768,12769,12934,
   12937,12942,12943,13587,13592,13593,13718,13719,13909,16534,
   16537,16542,16543,17187,17192,17193,17318,17319,17509,22147,
   22152,22153,22278,22279,22469,38294,38295,38485,41069],
 [3,4,7,10,23,26,31,32,41,42,44,199,200,202,203,205,218,
   221,226,227,236,237,239,263,265,266,268,281,284,289,290,
   299,300,302,327,328,330,343,346,351,352,361,362,364,449,
   451,464,467,472,473,482,483,485,510,523,526,531,532,541,
   542,544,638,641,646,647,656,657,659,1291,1296,1297,1306,
   1307,1309,1422,1423,1432,1433,1435,1613,1622,1623,1625,1657,
   1658,1660,1928,1930,1955,2410,2411,2413,2414,2416,2429,2432,
   2437,2438,2447,2448,2450,2474,2476,2477,2479,2492,2495,2500,
   2501,2510,2511,2513,2538,2541,2554,2557,2562,2563,2572,2573,
   2575,2660,2662,2675,2678,2683,2684,2693,2694,2696,2721,2734,
   2737,2742,2743,2752,2753,2755,2849,2852,2857,2858,2867,2868,
   2870,3502,3507,3508,3517,3518,3520,3633,3634,3643,3644,3646,
   3824,3833,3834,3836,3868,3869,3871,4139,4141,4166,8715,8717,
   8718,8720,8733,8736,8741,8742,8751,8752,8754,8779,8780,8782,
   8795,8798,8803,8804,8813,8814,8816,8901,8903,8916,8919,8924,
   8925,8934,8935,8937,8962,8975,8978,8983,8984,8993,8994,8996,
   9090,9093,9098,9099,9108,9109,9111,9743,9748,9749,9758,9759,
   9761,9874,9875,9884,9885,9887,10065,10074,10075,10077,10109,
   10110,10112,10380,10382,10407,10732,10733,10735,10748,10751,
   10756,10757,10766,10767,10769,10854,10856,10869,10872,10877,
   10878,10887,10888,10890,10915,10928,10931,10936,10937,10946,
   10947,10949,11043,11046,11051,11052,11061,11062,11064,11696,
   11701,11702,11711,11712,11714,11827,11828,11837,11838,11840,
   12018,12027,12028,12030,12062,12063,12065,12333,12335,12360,
   12745,12747,12760,12763,12768,12769,12778,12779,12781,12806,
   12819,12822,12827,12828,12837,12838,12840,12934,12937,12942,
   12943,12952,12953,12955,13587,13592,13593,13602,13603,13605,
   13718,13719,13728,13729,13731,13909,13918,13919,13921,13953,
   13954,13956,14224,14226,14251,16406,16419,16422,16427,16428,
   16437,16438,16440,16534,16537,16542,16543,16552,16553,16555,
   17187,17192,17193,17202,17203,17205,17318,17319,17328,17329,
   17331,17509,17518,17519,17521,17553,17554,17556,17824,17826,
   17851,18245,18248,18253,18254,18263,18264,18266,18898,18903,
   18904,18913,18914,18916,19029,19030,19039,19040,19042,19220,
   19229,19230,19232,19264,19265,19267,19535,19537,19562,22147,
   22152,22153,22162,22163,22165,22278,22279,22288,22289,22291,
   22469,22478,22479,22481,22513,22514,22516,22784,22786,22811,
   38294,38295,38304,38305,38307,38485,38494,38495,38497,38529,
   38530,38532,38800,38802,38827,41069,41078,41079,41081,41113,
   41114,41116,41384,41386,41411,44633,44634,44636,44904,44906,
   44931,45499,45501,45526,49471],[],
 [2554,2557,2562,2563,2675,2678,2683,2684,2849,2857,3502,3507,
   3508,3633,3634,3824,12747,12760,12763,12768,12769,12934,
   12937,12942,12943,13587,13592,13593,13718,13719,13909,16534,
   16537,16542,16543,17187,17192,17193,17318,17319,17509,22147,
   22152,22153,22278,22279,22469,38294,38295,38485,41069],
 [12979],[12979],[],[],[],[],[],[],[],[],[],
 [],[3507],
 [2554,2562,3500,3501,3507,3544,3550,3592,13585,13586,13592,
   13629,13635,13677,38205,38211,38253,39156],
 [2554,2562,3500,3501,3507,3544,3550,3592,13585,13586,13592,
   13629,13635,13677,38205,38211,38253,39156],
 [2554,2562,3502,3507,3508,3633,3634,3824,13587,13592,13593,
   13718,13719,13909,38294,38295,38485,41069],[3677,13762],
 [2554,2555,2556,2557,2558,2562,2563,2566,3500,3501,3502,3503,
   3504,3507,3508,3509,3511,3544,3545,3546,3547,3550,3551,3552,
   3554,3587,3588,3589,3592,3593,3594,3596,3629,3630,3633,3634,
   3635,3637,3670,3673,3674,3675,3677,3712,3713,3714,3716,3824,
   3825,3827,3860,3862,3896,13585,13586,13587,13588,13589,13592,
   13593,13594,13596,13629,13630,13631,13632,13635,13636,13637,
   13639,13672,13673,13674,13677,13678,13679,13681,13714,13715,
   13718,13719,13720,13722,13755,13758,13759,13760,13762,13797,
   13798,13799,13801,13909,13910,13912,13945,13947,13981,38205,
   38206,38207,38208,38211,38212,38213,38215,38248,38249,38250,
   38253,38254,38255,38257,38290,38291,38294,38295,38296,38298,
   38331,38334,38335,38336,38338,38373,38374,38375,38377,38485,
   38486,38488,38521,38523,38557,39151,39152,39153,39156,39157,
   39158,39160,39193,39194,39197,39198,39199,39201,39234,39237,
   39238,39239,39241,39276,39277,39278,39280,39388,39389,39391,
   39424,39426,39460,40054,40055,40058,40059,40060,40062,40095,
   40098,40099,40100,40102,40137,40138,40139,40141,40249,40250,
   40252,40285,40287,40321,40915,40918,40919,40920,40922,40957,
   40958,40959,40961,41069,41070,41072,41105,41107,41141,41737,
   41738,41739,41741,41849,41850,41852,41885,41887,41921,42590,
   42591,42593,42626,42628,42662,44625,44627,44661,45256],
 [3756],[3794,13879],[3507],
 [2554,2562,3502,3507,3508,3633,3634,3824,13587,13592,13593,
   13718,13719,13909,38294,38295,38485,41069],
 [2554,2555,2556,2557,2558,2562,2563,2566,3500,3501,3502,3503,
   3504,3507,3508,3509,3511,3544,3545,3546,3547,3550,3551,3552,
   3554,3587,3588,3589,3592,3593,3594,3596,3629,3630,3633,3634,
   3635,3637,3670,3673,3674,3675,3677,3712,3713,3714,3716,3824,
   3825,3827,3860,3862,3896,13585,13586,13587,13588,13589,13592,
   13593,13594,13596,13629,13630,13631,13632,13635,13636,13637,
   13639,13672,13673,13674,13677,13678,13679,13681,13714,13715,
   13718,13719,13720,13722,13755,13758,13759,13760,13762,13797,
   13798,13799,13801,13909,13910,13912,13945,13947,13981,38205,
   38206,38207,38208,38211,38212,38213,38215,38248,38249,38250,
   38253,38254,38255,38257,38290,38291,38294,38295,38296,38298,
   38331,38334,38335,38336,38338,38373,38374,38375,38377,38485,
   38486,38488,38521,38523,38557,39151,39152,39153,39156,39157,
   39158,39160,39193,39194,39197,39198,39199,39201,39234,39237,
   39238,39239,39241,39276,39277,39278,39280,39388,39389,39391,
   39424,39426,39460,40054,40055,40058,40059,40060,40062,40095,
   40098,40099,40100,40102,40137,40138,40139,40141,40249,40250,
   40252,40285,40287,40321,40915,40918,40919,40920,40922,40957,
   40958,40959,40961,41069,41070,41072,41105,41107,41141,41737,
   41738,41739,41741,41849,41850,41852,41885,41887,41921,42590,
   42591,42593,42626,42628,42662,44625,44627,44661,45256],
 [3930,14015],[3677,13762],[3930,14015],[3756],
 [3794,13879],[],[],
 [2410,2411,2429,2437,2447,2448,2474,2492,2500,2510,2511,2554,
   2562,3507,3517,3518,3833,3834,4139,8715,8733,8741,8751,8752,
   8795,8803,8813,8814,9748,9758,9759,10074,10075,10380,10748,
   10756,10766,10767,11701,11711,11712,12027,12028,12333,13592,
   13602,13603,13918,13919,14224,38494,38495,38800,44904],
 [2410,2411,2429,2437,2447,2448,2474,2492,2500,2510,2511,2554,
   2562,3507,3517,3518,3833,3834,4139,8715,8733,8741,8751,8752,
   8795,8803,8813,8814,9748,9758,9759,10074,10075,10380,10748,
   10756,10766,10767,11701,11711,11712,12027,12028,12333,13592,
   13602,13603,13918,13919,14224,38494,38495,38800,44904],
 [4193],[],[],
 [2554,2562,3507,3522,3524,3838,3840,4260,13592,13607,13609,
   13923,13925,14345,38499,38501,38921,45025],[4193],
 [2554,2562,3507,3522,3524,3838,3840,4260,13592,13607,13609,
   13923,13925,14345,38499,38501,38921,45025],
 [2554,2562,3507,3525,3526,3841,3842,4319,13592,13610,13611,
   13926,13927,14404,38502,38503,38980,45084],
 [2554,2562,3507,3525,3526,3841,3842,4319,13592,13610,13611,
   13926,13927,14404,38502,38503,38980,45084],
 [2554,2562,3507,3527,3528,3843,3844,4354,13592,13612,13613,
   13928,13929,14439,38504,38505,39015,45119],
 [2554,2562,3507,3527,3528,3843,3844,4354,13592,13612,13613,
   13928,13929,14439,38504,38505,39015,45119],[],[],[],
 [14514],[14523],[],
 [2554,2562,3507,3535,3851,13592,13620,13936,38512],
 [2554,2562,3507,3536,3852,13592,13621,13937,38513],[14523],
 [14514],[14565],[14565],[],[],[],[],[14635],
 [14635],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[3507],
 [2615,2623,3500,3501,3507,3544,3550,3592,15415,15416,15422,
   15459,15465,15507,38205,38211,38253,39156],
 [2615,2623,3500,3501,3507,3544,3550,3592,15415,15416,15422,
   15459,15465,15507,38205,38211,38253,39156],
 [2615,2623,3502,3507,3508,3633,3634,3824,15417,15422,15423,
   15548,15549,15739,38294,38295,38485,41069],[3677,15592],
 [3714,15629],[3756],[3794,15709],[3507],
 [2615,2623,3502,3507,3508,3633,3634,3824,15417,15422,15423,
   15548,15549,15739,38294,38295,38485,41069],[3714,15629],
 [3930,15845],[3677,15592],[3930,15845],[3756],
 [3794,15709],[],[],
 [2615,2623,3507,3517,3518,3833,3834,4139,15422,15432,15433,
   15748,15749,16054,38494,38495,38800,44904],
 [2615,2623,3507,3517,3518,3833,3834,4139,15422,15432,15433,
   15748,15749,16054,38494,38495,38800,44904],[4193],[],
 [],[2615,2616,2617,2623,2636,3500,3501,3507,3520,3522,3524,
   3544,3550,3563,3565,3567,3592,3605,3607,3609,3836,3838,3840,
   4215,4217,4260,15415,15416,15422,15435,15437,15439,15459,
   15465,15478,15480,15482,15507,15520,15522,15524,15751,15753,
   15755,16130,16132,16175,38205,38211,38224,38226,38228,38253,
   38266,38268,38270,38497,38499,38501,38876,38878,38921,39156,
   39169,39171,39173,39400,39402,39404,39779,39781,39824,40261,
   40263,40265,40640,40642,40685,44980,44982,45025,50394],
 [4193],
 [2615,2616,2617,2623,2636,3500,3501,3507,3520,3522,3524,3544,
   3550,3563,3565,3567,3592,3605,3607,3609,3836,3838,3840,4215,
   4217,4260,15415,15416,15422,15435,15437,15439,15459,15465,
   15478,15480,15482,15507,15520,15522,15524,15751,15753,15755,
   16130,16132,16175,38205,38211,38224,38226,38228,38253,38266,
   38268,38270,38497,38499,38501,38876,38878,38921,39156,39169,
   39171,39173,39400,39402,39404,39779,39781,39824,40261,40263,
   40265,40640,40642,40685,44980,44982,45025,50394],
 [2615,2623,2633,2634,3507,3517,3518,3525,3526,3833,3834,3841,
   3842,4139,4146,4147,4171,4172,4319,15422,15432,15433,15440,
   15441,15748,15749,15756,15757,16054,16061,16062,16086,16087,
   16234,38494,38495,38502,38503,38800,38807,38808,38832,38833,
   38980,44904,44911,44912,44936,44937,45084,49476,49477,49624,
   49924],
 [2615,2623,2633,2634,3507,3517,3518,3525,3526,3833,3834,3841,
   3842,4139,4146,4147,4171,4172,4319,15422,15432,15433,15440,
   15441,15748,15749,15756,15757,16054,16061,16062,16086,16087,
   16234,38494,38495,38502,38503,38800,38807,38808,38832,38833,
   38980,44904,44911,44912,44936,44937,45084,49476,49477,49624,
   49924],
 [2615,2623,3507,3527,3528,3843,3844,4354,15422,15442,15443,
   15758,15759,16269,38504,38505,39015,45119],
 [2615,2623,3507,3527,3528,3843,3844,4354,15422,15442,15443,
   15758,15759,16269,38504,38505,39015,45119],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],
 [10854],[],
 [2554,2557,2562,2563,2675,2678,2683,2684,2849,2857,3502,3507,
   3508,3633,3634,3824,12747,12760,12763,12768,12769,12934,
   12937,12942,12943,13587,13592,13593,13718,13719,13909,16534,
   16537,16542,16543,17187,17192,17193,17318,17319,17509,22147,
   22152,22153,22278,22279,22469,38294,38295,38485,41069],[],
 [],[],[],[],[],[],[],[],[],[],[],[3507],
 [2675,2683,3500,3501,3507,3544,3550,3592,17185,17186,17192,
   17229,17235,17277,38205,38211,38253,39156],
 [2675,2683,3500,3501,3507,3544,3550,3592,17185,17186,17192,
   17229,17235,17277,38205,38211,38253,39156],
 [2675,2683,3502,3507,3508,3633,3634,3824,17187,17192,17193,
   17318,17319,17509,38294,38295,38485,41069],
 [2675,2683,3503,3504,3507,3509,3511,3670,3673,3675,3677,3712,
   3714,3716,3825,3827,3896,17188,17189,17192,17194,17196,17355,
   17358,17360,17362,17397,17399,17401,17510,17512,17581,38331,
   38334,38336,38338,38373,38375,38377,38486,38488,38557,41737,
   41739,41741,41850,41852,41921,42591,42593,42662,44661],
 [2675,2683,3503,3504,3507,3509,3511,3670,3673,3675,3677,3712,
   3714,3716,3825,3827,3896,17188,17189,17192,17194,17196,17355,
   17358,17360,17362,17397,17399,17401,17510,17512,17581,38331,
   38334,38336,38338,38373,38375,38377,38486,38488,38557,41737,
   41739,41741,41850,41852,41921,42591,42593,42662,44661],
 [3756],[3794,17479],[3507],
 [2675,2683,3502,3507,3508,3633,3634,3824,17187,17192,17193,
   17318,17319,17509,38294,38295,38485,41069],
 [2675,2683,3503,3504,3507,3509,3511,3670,3673,3675,3677,3712,
   3714,3716,3825,3827,3896,17188,17189,17192,17194,17196,17355,
   17358,17360,17362,17397,17399,17401,17510,17512,17581,38331,
   38334,38336,38338,38373,38375,38377,38486,38488,38557,41737,
   41739,41741,41850,41852,41921,42591,42593,42662,44661],
 [3930,17615],
 [2675,2683,3503,3504,3507,3509,3511,3670,3673,3675,3677,3712,
   3714,3716,3825,3827,3896,17188,17189,17192,17194,17196,17355,
   17358,17360,17362,17397,17399,17401,17510,17512,17581,38331,
   38334,38336,38338,38373,38375,38377,38486,38488,38557,41737,
   41739,41741,41850,41852,41921,42591,42593,42662,44661],
 [3930,17615],[3756],[3794,17479],[],[],
 [2675,2683,3507,3517,3518,3833,3834,4139,17192,17202,17203,
   17518,17519,17824,38494,38495,38800,44904],
 [2675,2683,3507,3517,3518,3833,3834,4139,17192,17202,17203,
   17518,17519,17824,38494,38495,38800,44904],[4193],
 [23,31,44,202,218,464,1296,1309,1625,2429,2437,2675,2683,
   3507,3520,3836,8916,9748,9761,10077,17192,17205,17521,38497],
 [],[2675,2683,3507,3522,3524,3838,3840,4260,17192,17207,
   17209,17523,17525,17945,38499,38501,38921,45025],[4193],
 [2675,2683,3507,3522,3524,3838,3840,4260,17192,17207,17209,
   17523,17525,17945,38499,38501,38921,45025],
 [2675,2683,3507,3525,3526,3841,3842,4319,17192,17210,17211,
   17526,17527,18004,38502,38503,38980,45084],
 [2675,2683,3507,3525,3526,3841,3842,4319,17192,17210,17211,
   17526,17527,18004,38502,38503,38980,45084],
 [2675,2683,3507,3527,3528,3843,3844,4354,17192,17212,17213,
   17528,17529,18039,38504,38505,39015,45119],
 [2675,2683,3507,3527,3528,3843,3844,4354,17192,17212,17213,
   17528,17529,18039,38504,38505,39015,45119],[],[],[],
 [],[],[],[],[],[],[4479,18164],[],[],[],
 [],[4479,18164],[14635],
 [2429,2437,2447,2448,2734,2742,2752,2753,2849,2857,3507,3517,
   3518,3833,3834,4139,8962,8975,8983,8993,8994,9090,9098,9108,
   9109,9748,9758,9759,10074,10075,10380,18245,18253,18263,
   18264,18903,18913,18914,19229,19230,19535,22152,22162,22163,
   22478,22479,22784,38494,38495,38800,44904],[],[],[],
 [],[],[],[],[],[],[],[],[],[3507],
 [2476,2477,2492,2493,2494,2500,2660,2675,2676,2677,2683,2734,
   2742,3500,3501,3507,3544,3550,3592,10854,10869,10870,10871,
   10877,10928,10929,10930,10936,11694,11695,11701,11738,11744,
   11786,16419,16420,16421,16427,17185,17186,17192,17229,17235,
   17277,18896,18897,18903,18940,18946,18988,38205,38211,38253,
   39156],
 [2476,2477,2492,2493,2494,2500,2660,2675,2676,2677,2683,2734,
   2742,3500,3501,3507,3544,3550,3592,10854,10869,10870,10871,
   10877,10928,10929,10930,10936,11694,11695,11701,11738,11744,
   11786,16419,16420,16421,16427,17185,17186,17192,17229,17235,
   17277,18896,18897,18903,18940,18946,18988,38205,38211,38253,
   39156],
 [2476,2477,2492,2495,2500,2501,2660,2675,2678,2683,2684,2734,
   2742,3502,3507,3508,3633,3634,3824,10854,10869,10872,10877,
   10878,10928,10931,10936,10937,11696,11701,11702,11827,11828,
   12018,16419,16422,16427,16428,17187,17192,17193,17318,17319,
   17509,18898,18903,18904,19029,19030,19220,38294,38295,38485,
   41069],[3677,19073],
 [2734,2738,2742,2746,3503,3504,3507,3509,3511,3670,3673,3675,
   3677,3712,3714,3716,3825,3827,3896,18899,18900,18903,18905,
   18907,19066,19069,19071,19073,19108,19110,19112,19221,19223,
   19292,38331,38334,38336,38338,38373,38375,38377,38486,38488,
   38557,41737,41739,41741,41850,41852,41921,42591,42593,42662,
   44661],[3756],[3794,19190],[3507],
 [2476,2477,2492,2495,2500,2501,2660,2675,2678,2683,2684,2734,
   2742,3502,3507,3508,3633,3634,3824,10854,10869,10872,10877,
   10878,10928,10931,10936,10937,11696,11701,11702,11827,11828,
   12018,16419,16422,16427,16428,17187,17192,17193,17318,17319,
   17509,18898,18903,18904,19029,19030,19220,38294,38295,38485,
   41069],
 [2734,2738,2742,2746,3503,3504,3507,3509,3511,3670,3673,3675,
   3677,3712,3714,3716,3825,3827,3896,18899,18900,18903,18905,
   18907,19066,19069,19071,19073,19108,19110,19112,19221,19223,
   19292,38331,38334,38336,38338,38373,38375,38377,38486,38488,
   38557,41737,41739,41741,41850,41852,41921,42591,42593,42662,
   44661],[3930,19326],[3677,19073],[3930,19326],[3756],
 [3794,19190],[],[],
 [2734,2742,3507,3517,3518,3833,3834,4139,18903,18913,18914,
   19229,19230,19535,38494,38495,38800,44904],
 [2734,2742,3507,3517,3518,3833,3834,4139,18903,18913,18914,
   19229,19230,19535,38494,38495,38800,44904],[4193],[],
 [],[2734,2738,2739,2742,2744,2746,2752,2753,3503,3504,3507,
   3509,3511,3517,3518,3522,3524,3670,3673,3675,3677,3683,3684,
   3688,3690,3712,3714,3716,3722,3723,3727,3729,3825,3827,3833,
   3834,3838,3840,3896,3902,3903,3907,3909,3967,3968,3972,3974,
   4139,4143,4145,4168,4170,4260,18899,18900,18903,18905,18907,
   18913,18914,18918,18920,19066,19069,19071,19073,19079,19080,
   19084,19086,19108,19110,19112,19118,19119,19123,19125,19221,
   19223,19229,19230,19234,19236,19292,19298,19299,19303,19305,
   19363,19364,19368,19370,19535,19539,19541,19564,19566,19656,
   38331,38334,38336,38338,38344,38345,38349,38351,38373,38375,
   38377,38383,38384,38388,38390,38486,38488,38494,38495,38499,
   38501,38557,38563,38564,38568,38570,38628,38629,38633,38635,
   38800,38804,38806,38829,38831,38921,41737,41739,41741,41747,
   41748,41752,41754,41850,41852,41858,41859,41863,41865,41921,
   41927,41928,41932,41934,41992,41993,41997,41999,42164,42168,
   42170,42193,42195,42285,42591,42593,42599,42600,42604,42606,
   42662,42668,42669,42673,42675,42733,42734,42738,42740,42905,
   42909,42911,42934,42936,43026,44661,44667,44668,44672,44674,
   44732,44733,44737,44739,44904,44908,44910,44933,44935,45025,
   45888,45889,45893,45895,46060,46064,46066,46089,46091,46181,
   47084,47088,47090,47113,47115,47205,49473,49475,49565,49865],
 [4193],
 [2734,2738,2739,2742,2744,2746,2752,2753,3503,3504,3507,3509,
   3511,3517,3518,3522,3524,3670,3673,3675,3677,3683,3684,3688,
   3690,3712,3714,3716,3722,3723,3727,3729,3825,3827,3833,3834,
   3838,3840,3896,3902,3903,3907,3909,3967,3968,3972,3974,4139,
   4143,4145,4168,4170,4260,18899,18900,18903,18905,18907,18913,
   18914,18918,18920,19066,19069,19071,19073,19079,19080,19084,
   19086,19108,19110,19112,19118,19119,19123,19125,19221,19223,
   19229,19230,19234,19236,19292,19298,19299,19303,19305,19363,
   19364,19368,19370,19535,19539,19541,19564,19566,19656,38331,
   38334,38336,38338,38344,38345,38349,38351,38373,38375,38377,
   38383,38384,38388,38390,38486,38488,38494,38495,38499,38501,
   38557,38563,38564,38568,38570,38628,38629,38633,38635,38800,
   38804,38806,38829,38831,38921,41737,41739,41741,41747,41748,
   41752,41754,41850,41852,41858,41859,41863,41865,41921,41927,
   41928,41932,41934,41992,41993,41997,41999,42164,42168,42170,
   42193,42195,42285,42591,42593,42599,42600,42604,42606,42662,
   42668,42669,42673,42675,42733,42734,42738,42740,42905,42909,
   42911,42934,42936,43026,44661,44667,44668,44672,44674,44732,
   44733,44737,44739,44904,44908,44910,44933,44935,45025,45888,
   45889,45893,45895,46060,46064,46066,46089,46091,46181,47084,
   47088,47090,47113,47115,47205,49473,49475,49565,49865],
 [2734,2742,3507,3525,3526,3841,3842,4319,18903,18921,18922,
   19237,19238,19715,38502,38503,38980,45084],
 [2734,2742,3507,3525,3526,3841,3842,4319,18903,18921,18922,
   19237,19238,19715,38502,38503,38980,45084],
 [2734,2742,3507,3527,3528,3843,3844,4354,18903,18923,18924,
   19239,19240,19750,38504,38505,39015,45119],
 [2734,2742,3507,3527,3528,3843,3844,4354,18903,18923,18924,
   19239,19240,19750,38504,38505,39015,45119],[],[],[],
 [],[],[19848],[19857],[19862],
 [2734,2742,3507,3537,3853,18903,18933,19249,38514],
 [2734,2742,3507,3538,3854,18903,18934,19250,38515],[],[],
 [19862],[19848],[19857],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[3507],
 [2792,2800,3500,3501,3507,3544,3550,3592,20549,20550,20556,
   20593,20599,20641,38205,38211,38253,39156],
 [2792,2800,3500,3501,3507,3544,3550,3592,20549,20550,20556,
   20593,20599,20641,38205,38211,38253,39156],
 [2792,2800,3502,3507,3508,3633,3634,3824,20551,20556,20557,
   20682,20683,20873,38294,38295,38485,41069],
 [2792,2797,2800,2802,3503,3504,3507,3509,3511,3670,3673,3675,
   3677,3712,3714,3716,3825,3827,3896,20552,20553,20556,20558,
   20560,20719,20722,20724,20726,20761,20763,20765,20874,20876,
   20945,38331,38334,38336,38338,38373,38375,38377,38486,38488,
   38557,41737,41739,41741,41850,41852,41921,42591,42593,42662,
   44661],[3714,20763],[3756],[3794,20843],[3507],
 [2792,2800,3502,3507,3508,3633,3634,3824,20551,20556,20557,
   20682,20683,20873,38294,38295,38485,41069],[3714,20763],
 [2792,2800,3507,3510,3512,3826,3828,3930,20556,20559,20561,
   20875,20877,20979,38487,38489,38591,44695],
 [2792,2797,2800,2802,3503,3504,3507,3509,3511,3670,3673,3675,
   3677,3712,3714,3716,3825,3827,3896,20552,20553,20556,20558,
   20560,20719,20722,20724,20726,20761,20763,20765,20874,20876,
   20945,38331,38334,38336,38338,38373,38375,38377,38486,38488,
   38557,41737,41739,41741,41850,41852,41921,42591,42593,42662,
   44661],
 [2792,2800,3507,3510,3512,3826,3828,3930,20556,20559,20561,
   20875,20877,20979,38487,38489,38591,44695],[3756],
 [3794,20843],[],[],
 [2792,2800,3507,3517,3518,3833,3834,4139,20556,20566,20567,
   20882,20883,21188,38494,38495,38800,44904],
 [2792,2800,3507,3517,3518,3833,3834,4139,20556,20566,20567,
   20882,20883,21188,38494,38495,38800,44904],[4193],[],
 [],[2792,2795,2800,2801,3502,3507,3508,3522,3524,3633,3634,
   3648,3650,3824,3838,3840,3873,3875,4260,20551,20556,20557,
   20571,20573,20682,20683,20697,20699,20873,20887,20889,20922,
   20924,21309,38294,38295,38309,38311,38485,38499,38501,38534,
   38536,38921,41069,41083,41085,41118,41120,41505,44638,44640,
   45025,45620],[4193],
 [2792,2795,2800,2801,3502,3507,3508,3522,3524,3633,3634,3648,
   3650,3824,3838,3840,3873,3875,4260,20551,20556,20557,20571,
   20573,20682,20683,20697,20699,20873,20887,20889,20922,20924,
   21309,38294,38295,38309,38311,38485,38499,38501,38534,38536,
   38921,41069,41083,41085,41118,41120,41505,44638,44640,45025,
   45620],
 [2792,2800,3507,3525,3526,3841,3842,4319,20556,20574,20575,
   20890,20891,21368,38502,38503,38980,45084],
 [2792,2800,3507,3525,3526,3841,3842,4319,20556,20574,20575,
   20890,20891,21368,38502,38503,38980,45084],
 [2792,2800,3507,3527,3528,3843,3844,4354,20556,20576,20577,
   20892,20893,21403,38504,38505,39015,45119],
 [2792,2800,3507,3527,3528,3843,3844,4354,20556,20576,20577,
   20892,20893,21403,38504,38505,39015,45119],[],[],[],
 [],[],[],[],
 [2792,2800,3507,3536,3852,20556,20585,20901,38513],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[3507],
 [2849,2857,3500,3501,3507,3544,3550,3592,22145,22146,22152,
   22189,22195,22237,38205,38211,38253,39156],
 [2849,2857,3500,3501,3507,3544,3550,3592,22145,22146,22152,
   22189,22195,22237,38205,38211,38253,39156],
 [2554,2557,2562,2563,2675,2678,2683,2684,2849,2857,3502,3507,
   3508,3633,3634,3824,12747,12760,12763,12768,12769,12934,
   12937,12942,12943,13587,13592,13593,13718,13719,13909,16534,
   16537,16542,16543,17187,17192,17193,17318,17319,17509,22147,
   22152,22153,22278,22279,22469,38294,38295,38485,41069],
 [2849,2854,2857,2859,3503,3504,3507,3509,3511,3670,3673,3675,
   3677,3712,3714,3716,3825,3827,3896,22148,22149,22152,22154,
   22156,22315,22318,22320,22322,22357,22359,22361,22470,22472,
   22541,38331,38334,38336,38338,38373,38375,38377,38486,38488,
   38557,41737,41739,41741,41850,41852,41921,42591,42593,42662,
   44661],[3714,22359],
 [2849,2857,3505,3507,3513,3750,3756,3829,22150,22152,22158,
   22395,22474,38411,38417,38490,43298],[3794,22439],[3507],
 [2554,2557,2562,2563,2675,2678,2683,2684,2849,2857,3502,3507,
   3508,3633,3634,3824,12747,12760,12763,12768,12769,12934,
   12937,12942,12943,13587,13592,13593,13718,13719,13909,16534,
   16537,16542,16543,17187,17192,17193,17318,17319,17509,22147,
   22152,22153,22278,22279,22469,38294,38295,38485,41069],
 [3714,22359],[3930,22575],
 [2849,2854,2857,2859,3503,3504,3507,3509,3511,3670,3673,3675,
   3677,3712,3714,3716,3825,3827,3896,22148,22149,22152,22154,
   22156,22315,22318,22320,22322,22357,22359,22361,22470,22472,
   22541,38331,38334,38336,38338,38373,38375,38377,38486,38488,
   38557,41737,41739,41741,41850,41852,41921,42591,42593,42662,
   44661],[3930,22575],
 [2849,2857,3505,3507,3513,3750,3756,3829,22150,22152,22158,
   22395,22474,38411,38417,38490,43298],[3794,22439],[],
 [],[2429,2437,2447,2448,2734,2742,2752,2753,2849,2857,3507,
   3517,3518,3833,3834,4139,8962,8975,8983,8993,8994,9090,9098,
   9108,9109,9748,9758,9759,10074,10075,10380,18245,18253,18263,
   18264,18903,18913,18914,19229,19230,19535,22152,22162,22163,
   22478,22479,22784,38494,38495,38800,44904],
 [2429,2437,2447,2448,2734,2742,2752,2753,2849,2857,3507,3517,
   3518,3833,3834,4139,8962,8975,8983,8993,8994,9090,9098,9108,
   9109,9748,9758,9759,10074,10075,10380,18245,18253,18263,
   18264,18903,18913,18914,19229,19230,19535,22152,22162,22163,
   22478,22479,22784,38494,38495,38800,44904],
 [2849,2857,3507,3519,3523,3835,3839,4193,22152,22164,22168,
   22480,22484,38496,38500,38854,44958],[],
 [2849,2857,3507,3521,3837,22152,22166,22482,38498],
 [2849,2857,3507,3522,3524,3838,3840,4260,22152,22167,22169,
   22483,22485,22905,38499,38501,38921,45025],
 [2849,2857,3507,3519,3523,3835,3839,4193,22152,22164,22168,
   22480,22484,38496,38500,38854,44958],
 [2849,2857,3507,3522,3524,3838,3840,4260,22152,22167,22169,
   22483,22485,22905,38499,38501,38921,45025],
 [2849,2857,3507,3525,3526,3841,3842,4319,22152,22170,22171,
   22486,22487,22964,38502,38503,38980,45084],
 [2849,2857,3507,3525,3526,3841,3842,4319,22152,22170,22171,
   22486,22487,22964,38502,38503,38980,45084],
 [2849,2857,3507,3527,3528,3843,3844,4354,22152,22172,22173,
   22488,22489,22999,38504,38505,39015,45119],
 [2849,2857,3507,3527,3528,3843,3844,4354,22152,22172,22173,
   22488,22489,22999,38504,38505,39015,45119],[],[],[],
 [],[],[2849,2857,3507,3534,3850,22152,22179,22495,38511],
 [],[],[],[],
 [2849,2857,3507,3539,3855,22152,22184,22500,38516],[],[],
 [],[],[12979],[],[],[],[],[],[],[],[],
 [],[],[3507],
 [2905,2913,3500,3501,3507,3544,3550,3592,23685,23686,23692,
   23729,23735,23777,38205,38211,38253,39156],
 [2905,2913,3500,3501,3507,3544,3550,3592,23685,23686,23692,
   23729,23735,23777,38205,38211,38253,39156],
 [2905,2913,3502,3507,3508,3633,3634,3824,23687,23692,23693,
   23818,23819,24009,38294,38295,38485,41069],
 [2928,2930,3677,3688,3690,3972,3974,4260,23862,23873,23875,
   24157,24159,24445,41997,41999,42285,47205],[3714,23899],
 [3756],[2905,2913,3506,3507,3514,3787,3794,3830,23691,23692,
   23699,23972,23979,24015,38448,38455,38491,43965],[3507],
 [2905,2913,3502,3507,3508,3633,3634,3824,23687,23692,23693,
   23818,23819,24009,38294,38295,38485,41069],[3714,23899],
 [3930,24115],
 [2928,2930,3677,3688,3690,3972,3974,4260,23862,23873,23875,
   24157,24159,24445,41997,41999,42285,47205],[3930,24115],
 [3756],[2905,2913,3506,3507,3514,3787,3794,3830,23691,23692,
   23699,23972,23979,24015,38448,38455,38491,43965],[],[],
 [2905,2913,3507,3517,3518,3833,3834,4139,23692,23702,23703,
   24018,24019,24324,38494,38495,38800,44904],
 [2905,2913,3507,3517,3518,3833,3834,4139,23692,23702,23703,
   24018,24019,24324,38494,38495,38800,44904],[4193],[],
 [],[2905,2913,3507,3522,3524,3838,3840,4260,23692,23707,
   23709,24023,24025,24445,38499,38501,38921,45025],[4193],
 [2905,2913,3507,3522,3524,3838,3840,4260,23692,23707,23709,
   24023,24025,24445,38499,38501,38921,45025],
 [2905,2913,3507,3525,3526,3841,3842,4319,23692,23710,23711,
   24026,24027,24504,38502,38503,38980,45084],
 [2905,2913,3507,3525,3526,3841,3842,4319,23692,23710,23711,
   24026,24027,24504,38502,38503,38980,45084],
 [2905,2913,3507,3527,3528,3843,3844,4354,23692,23712,23713,
   24028,24029,24539,38504,38505,39015,45119],
 [2905,2913,3507,3527,3528,3843,3844,4354,23692,23712,23713,
   24028,24029,24539,38504,38505,39015,45119],[],[],[],
 [2905,2913,3507,3532,3848,23692,23717,24033,38509],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[3507],
 [2960,2968,3500,3501,3507,3544,3550,3592,25170,25171,25177,
   25214,25220,25262,38205,38211,38253,39156],
 [2960,2968,3500,3501,3507,3544,3550,3592,25170,25171,25177,
   25214,25220,25262,38205,38211,38253,39156],
 [2960,2968,3502,3507,3508,3633,3634,3824,25172,25177,25178,
   25303,25304,25494,38294,38295,38485,41069],[3677,25347],
 [3714,25384],[3756],[3794,25464],[3507],
 [2960,2968,3502,3507,3508,3633,3634,3824,25172,25177,25178,
   25303,25304,25494,38294,38295,38485,41069],[3714,25384],
 [3930,25600],[3677,25347],[3930,25600],[3756],
 [3794,25464],[],[],
 [2960,2968,3507,3517,3518,3833,3834,4139,25177,25187,25188,
   25503,25504,25809,38494,38495,38800,44904],
 [2960,2968,3507,3517,3518,3833,3834,4139,25177,25187,25188,
   25503,25504,25809,38494,38495,38800,44904],[4193],[],
 [],[2960,2968,3507,3522,3524,3838,3840,4260,25177,25192,
   25194,25508,25510,25930,38499,38501,38921,45025],[4193],
 [2960,2968,3507,3522,3524,3838,3840,4260,25177,25192,25194,
   25508,25510,25930,38499,38501,38921,45025],
 [2960,2968,2969,3507,3508,3525,3526,3824,3841,3842,3876,3877,
   4319,25177,25178,25195,25196,25494,25511,25512,25546,25547,
   25989,38485,38502,38503,38537,38538,38980,44641,44642,45084,
   45679],
 [2960,2968,2969,3507,3508,3525,3526,3824,3841,3842,3876,3877,
   4319,25177,25178,25195,25196,25494,25511,25512,25546,25547,
   25989,38485,38502,38503,38537,38538,38980,44641,44642,45084,
   45679],
 [2960,2962,2968,3501,3507,3527,3528,3592,3612,3613,3843,3844,
   4354,25171,25177,25197,25198,25262,25282,25283,25513,25514,
   26024,38253,38273,38274,38504,38505,39015,40268,40269,40779,
   45119],
 [2960,2962,2968,3501,3507,3527,3528,3592,3612,3613,3843,3844,
   4354,25171,25177,25197,25198,25262,25282,25283,25513,25514,
   26024,38253,38273,38274,38504,38505,39015,40268,40269,40779,
   45119],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[26160],[26160],[],[26316],
 [26316],[],[],[26510],[26510],[3507],
 [3014,3022,3500,3501,3507,3544,3550,3592,26601,26602,26608,
   26645,26651,26693,38205,38211,38253,39156],
 [3014,3022,3500,3501,3507,3544,3550,3592,26601,26602,26608,
   26645,26651,26693,38205,38211,38253,39156],
 [3014,3022,3502,3507,3508,3633,3634,3824,26603,26608,26609,
   26734,26735,26925,38294,38295,38485,41069],[3677,26778],
 [3714,26815],[3756],[3794,26895],[3507],
 [3014,3022,3502,3507,3508,3633,3634,3824,26603,26608,26609,
   26734,26735,26925,38294,38295,38485,41069],[3714,26815],
 [3930,27031],[3677,26778],[3930,27031],[3756],
 [3794,26895],[],[],
 [3014,3022,3507,3517,3518,3833,3834,4139,26608,26618,26619,
   26934,26935,27240,38494,38495,38800,44904],
 [3014,3022,3507,3517,3518,3833,3834,4139,26608,26618,26619,
   26934,26935,27240,38494,38495,38800,44904],[4193],[],
 [],[3014,3022,3507,3522,3524,3838,3840,4260,26608,26623,
   26625,26939,26941,27361,38499,38501,38921,45025],[4193],
 [3014,3022,3507,3522,3524,3838,3840,4260,26608,26623,26625,
   26939,26941,27361,38499,38501,38921,45025],
 [3014,3022,3507,3525,3526,3841,3842,4319,26608,26626,26627,
   26942,26943,27420,38502,38503,38980,45084],
 [3014,3022,3507,3525,3526,3841,3842,4319,26608,26626,26627,
   26942,26943,27420,38502,38503,38980,45084],
 [3014,3022,3507,3527,3528,3843,3844,4354,26608,26628,26629,
   26944,26945,27455,38504,38505,39015,45119],
 [3014,3022,3507,3527,3528,3843,3844,4354,26608,26628,26629,
   26944,26945,27455,38504,38505,39015,45119],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],
 [26160],[27643],[27643],[],[],[27841],[27841],[],
 [3507],[3067,3075,3500,3501,3507,3544,3550,3592,27979,27980,
   27986,28023,28029,28071,38205,38211,38253,39156],
 [3067,3075,3500,3501,3507,3544,3550,3592,27979,27980,27986,
   28023,28029,28071,38205,38211,38253,39156],
 [3067,3075,3502,3507,3508,3633,3634,3824,27981,27986,27987,
   28112,28113,28303,38294,38295,38485,41069],[3677,28156],
 [3714,28193],[3756],[3794,28273],[3507],
 [3067,3075,3502,3507,3508,3633,3634,3824,27981,27986,27987,
   28112,28113,28303,38294,38295,38485,41069],[3714,28193],
 [3930,28409],[3677,28156],[3930,28409],[3756],
 [3794,28273],[],[],
 [3067,3075,3507,3517,3518,3833,3834,4139,27986,27996,27997,
   28312,28313,28618,38494,38495,38800,44904],
 [3067,3075,3507,3517,3518,3833,3834,4139,27986,27996,27997,
   28312,28313,28618,38494,38495,38800,44904],[4193],[],
 [],[3067,3075,3507,3522,3524,3838,3840,4260,27986,28001,
   28003,28317,28319,28739,38499,38501,38921,45025],[4193],
 [3067,3075,3507,3522,3524,3838,3840,4260,27986,28001,28003,
   28317,28319,28739,38499,38501,38921,45025],
 [3067,3075,3507,3525,3526,3841,3842,4319,27986,28004,28005,
   28320,28321,28798,38502,38503,38980,45084],
 [3067,3075,3507,3525,3526,3841,3842,4319,27986,28004,28005,
   28320,28321,28798,38502,38503,38980,45084],
 [3067,3075,3507,3527,3528,3843,3844,4354,27986,28006,28007,
   28322,28323,28833,38504,38505,39015,45119],
 [3067,3075,3507,3527,3528,3843,3844,4354,27986,28006,28007,
   28322,28323,28833,38504,38505,39015,45119],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],
 [28970],
 [3005,3006,3007,3008,3009,3059,3060,3061,3062,3112,3114,3164,
   3165,3215,26160,26161,26162,26163,26213,26214,26215,26265,
   26266,26316,27591,27592,27593,27643,27644,27694,28969,28970,
   29020,30295],[28970],[],[29168],[],[29168],[3507],
 [3119,3127,3500,3501,3507,3544,3550,3592,29305,29306,29312,
   29349,29355,29397,38205,38211,38253,39156],
 [3119,3127,3500,3501,3507,3544,3550,3592,29305,29306,29312,
   29349,29355,29397,38205,38211,38253,39156],
 [3119,3127,3502,3507,3508,3633,3634,3824,29307,29312,29313,
   29438,29439,29629,38294,38295,38485,41069],[3677,29482],
 [3119,3123,3127,3131,3503,3504,3507,3509,3511,3670,3673,3675,
   3677,3712,3714,3716,3825,3827,3896,29308,29309,29312,29314,
   29316,29475,29478,29480,29482,29517,29519,29521,29630,29632,
   29701,38331,38334,38336,38338,38373,38375,38377,38486,38488,
   38557,41737,41739,41741,41850,41852,41921,42591,42593,42662,
   44661],[3756],[3794,29599],[3507],
 [3119,3127,3502,3507,3508,3633,3634,3824,29307,29312,29313,
   29438,29439,29629,38294,38295,38485,41069],
 [3119,3123,3127,3131,3503,3504,3507,3509,3511,3670,3673,3675,
   3677,3712,3714,3716,3825,3827,3896,29308,29309,29312,29314,
   29316,29475,29478,29480,29482,29517,29519,29521,29630,29632,
   29701,38331,38334,38336,38338,38373,38375,38377,38486,38488,
   38557,41737,41739,41741,41850,41852,41921,42591,42593,42662,
   44661],[3930,29735],[3677,29482],[3930,29735],[3756],
 [3794,29599],[],[],
 [3119,3127,3507,3517,3518,3833,3834,4139,29312,29322,29323,
   29638,29639,29944,38494,38495,38800,44904],
 [3119,3127,3507,3517,3518,3833,3834,4139,29312,29322,29323,
   29638,29639,29944,38494,38495,38800,44904],[4193],[],
 [],[3119,3127,3507,3522,3524,3838,3840,4260,29312,29327,
   29329,29643,29645,30065,38499,38501,38921,45025],[4193],
 [3119,3127,3507,3522,3524,3838,3840,4260,29312,29327,29329,
   29643,29645,30065,38499,38501,38921,45025],
 [3119,3127,3507,3525,3526,3841,3842,4319,29312,29330,29331,
   29646,29647,30124,38502,38503,38980,45084],
 [3119,3127,3507,3525,3526,3841,3842,4319,29312,29330,29331,
   29646,29647,30124,38502,38503,38980,45084],
 [3119,3127,3507,3527,3528,3843,3844,4354,29312,29332,29333,
   29648,29649,30159,38504,38505,39015,45119],
 [3119,3127,3507,3527,3528,3843,3844,4354,29312,29332,29333,
   29648,29649,30159,38504,38505,39015,45119],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],
 [27643],[28970],[30394],[30394],[],[],[3507],
 [3170,3178,3500,3501,3507,3544,3550,3592,30580,30581,30587,
   30624,30630,30672,38205,38211,38253,39156],
 [3170,3178,3500,3501,3507,3544,3550,3592,30580,30581,30587,
   30624,30630,30672,38205,38211,38253,39156],
 [3170,3178,3502,3507,3508,3633,3634,3824,30582,30587,30588,
   30713,30714,30904,38294,38295,38485,41069],[3677,30757],
 [3714,30794],[3756],[3794,30874],[3507],
 [3170,3178,3502,3507,3508,3633,3634,3824,30582,30587,30588,
   30713,30714,30904,38294,38295,38485,41069],[3714,30794],
 [3930,31010],[3677,30757],[3930,31010],[3756],
 [3794,30874],[],[],
 [3170,3178,3507,3517,3518,3833,3834,4139,30587,30597,30598,
   30913,30914,31219,38494,38495,38800,44904],
 [3170,3178,3507,3517,3518,3833,3834,4139,30587,30597,30598,
   30913,30914,31219,38494,38495,38800,44904],[4193],[],
 [],[3170,3178,3507,3522,3524,3838,3840,4260,30587,30602,
   30604,30918,30920,31340,38499,38501,38921,45025],[4193],
 [3170,3178,3507,3522,3524,3838,3840,4260,30587,30602,30604,
   30918,30920,31340,38499,38501,38921,45025],
 [3170,3178,3507,3525,3526,3841,3842,4319,30587,30605,30606,
   30921,30922,31399,38502,38503,38980,45084],
 [3170,3178,3507,3525,3526,3841,3842,4319,30587,30605,30606,
   30921,30922,31399,38502,38503,38980,45084],
 [3170,3178,3507,3527,3528,3843,3844,4354,30587,30607,30608,
   30923,30924,31434,38504,38505,39015,45119],
 [3170,3178,3507,3527,3528,3843,3844,4354,30587,30607,30608,
   30923,30924,31434,38504,38505,39015,45119],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],
 [26316],[31620],
 [3060,3061,3063,3064,3065,3164,3166,3167,3168,3216,3218,3314,
   3315,3362,27643,27645,27646,27647,27695,27696,27697,27793,
   27794,27841,30296,30297,30298,30394,30395,30442,31619,31620,
   31667,33971],[31620],[],[3507],
 [3220,3228,3500,3501,3507,3544,3550,3592,31805,31806,31812,
   31849,31855,31897,38205,38211,38253,39156],
 [3220,3228,3500,3501,3507,3544,3550,3592,31805,31806,31812,
   31849,31855,31897,38205,38211,38253,39156],
 [3220,3228,3502,3507,3508,3633,3634,3824,31807,31812,31813,
   31938,31939,32129,38294,38295,38485,41069],[3677,31982],
 [3220,3224,3228,3232,3503,3504,3507,3509,3511,3670,3673,3675,
   3677,3712,3714,3716,3825,3827,3896,31808,31809,31812,31814,
   31816,31975,31978,31980,31982,32017,32019,32021,32130,32132,
   32201,38331,38334,38336,38338,38373,38375,38377,38486,38488,
   38557,41737,41739,41741,41850,41852,41921,42591,42593,42662,
   44661],[3756],[3794,32099],[3507],
 [3220,3228,3502,3507,3508,3633,3634,3824,31807,31812,31813,
   31938,31939,32129,38294,38295,38485,41069],
 [3220,3224,3228,3232,3503,3504,3507,3509,3511,3670,3673,3675,
   3677,3712,3714,3716,3825,3827,3896,31808,31809,31812,31814,
   31816,31975,31978,31980,31982,32017,32019,32021,32130,32132,
   32201,38331,38334,38336,38338,38373,38375,38377,38486,38488,
   38557,41737,41739,41741,41850,41852,41921,42591,42593,42662,
   44661],[3930,32235],[3677,31982],[3930,32235],[3756],
 [3794,32099],[],[],
 [3220,3228,3507,3517,3518,3833,3834,4139,31812,31822,31823,
   32138,32139,32444,38494,38495,38800,44904],
 [3220,3228,3507,3517,3518,3833,3834,4139,31812,31822,31823,
   32138,32139,32444,38494,38495,38800,44904],[4193],[],
 [],[3220,3228,3507,3522,3524,3838,3840,4260,31812,31827,
   31829,32143,32145,32565,38499,38501,38921,45025],[4193],
 [3220,3228,3507,3522,3524,3838,3840,4260,31812,31827,31829,
   32143,32145,32565,38499,38501,38921,45025],
 [3220,3228,3507,3525,3526,3841,3842,4319,31812,31830,31831,
   32146,32147,32624,38502,38503,38980,45084],
 [3220,3228,3507,3525,3526,3841,3842,4319,31812,31830,31831,
   32146,32147,32624,38502,38503,38980,45084],
 [3220,3228,3507,3527,3528,3843,3844,4354,31812,31832,31833,
   32148,32149,32659,38504,38505,39015,45119],
 [3220,3228,3507,3527,3528,3843,3844,4354,31812,31832,31833,
   32148,32149,32659,38504,38505,39015,45119],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],
 [32797],[],[],[32797],[3507],
 [3269,3277,3500,3501,3507,3544,3550,3592,32981,32982,32988,
   33025,33031,33073,38205,38211,38253,39156],
 [3269,3277,3500,3501,3507,3544,3550,3592,32981,32982,32988,
   33025,33031,33073,38205,38211,38253,39156],
 [3269,3277,3502,3507,3508,3633,3634,3824,32983,32988,32989,
   33114,33115,33305,38294,38295,38485,41069],[3677,33158],
 [3714,33195],[3756],[3794,33275],[3507],
 [3269,3277,3502,3507,3508,3633,3634,3824,32983,32988,32989,
   33114,33115,33305,38294,38295,38485,41069],[3714,33195],
 [3930,33411],[3677,33158],[3930,33411],[3756],
 [3794,33275],[],[],
 [3269,3277,3507,3517,3518,3833,3834,4139,32988,32998,32999,
   33314,33315,33620,38494,38495,38800,44904],
 [3269,3277,3507,3517,3518,3833,3834,4139,32988,32998,32999,
   33314,33315,33620,38494,38495,38800,44904],[4193],[],
 [],[3269,3277,3507,3522,3524,3838,3840,4260,32988,33003,
   33005,33319,33321,33741,38499,38501,38921,45025],[4193],
 [3269,3277,3507,3522,3524,3838,3840,4260,32988,33003,33005,
   33319,33321,33741,38499,38501,38921,45025],
 [3269,3277,3507,3525,3526,3841,3842,4319,32988,33006,33007,
   33322,33323,33800,38502,38503,38980,45084],
 [3269,3277,3507,3525,3526,3841,3842,4319,32988,33006,33007,
   33322,33323,33800,38502,38503,38980,45084],
 [3269,3277,3507,3527,3528,3843,3844,4354,32988,33008,33009,
   33324,33325,33835,38504,38505,39015,45119],
 [3269,3277,3507,3527,3528,3843,3844,4354,32988,33008,33009,
   33324,33325,33835,38504,38505,39015,45119],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],
 [30394],[31620],[32797],[3507],
 [3317,3325,3500,3501,3507,3544,3550,3592,34109,34110,34116,
   34153,34159,34201,38205,38211,38253,39156],
 [3317,3325,3500,3501,3507,3544,3550,3592,34109,34110,34116,
   34153,34159,34201,38205,38211,38253,39156],
 [3317,3325,3502,3507,3508,3633,3634,3824,34111,34116,34117,
   34242,34243,34433,38294,38295,38485,41069],[3677,34286],
 [3714,34323],[3756],[3794,34403],[3507],
 [3317,3325,3502,3507,3508,3633,3634,3824,34111,34116,34117,
   34242,34243,34433,38294,38295,38485,41069],[3714,34323],
 [3930,34539],[3677,34286],[3930,34539],[3756],
 [3794,34403],[],[],
 [3317,3325,3507,3517,3518,3833,3834,4139,34116,34126,34127,
   34442,34443,34748,38494,38495,38800,44904],
 [3317,3325,3507,3517,3518,3833,3834,4139,34116,34126,34127,
   34442,34443,34748,38494,38495,38800,44904],[4193],[],
 [],[3317,3325,3507,3522,3524,3838,3840,4260,34116,34131,
   34133,34447,34449,34869,38499,38501,38921,45025],[4193],
 [3317,3325,3507,3522,3524,3838,3840,4260,34116,34131,34133,
   34447,34449,34869,38499,38501,38921,45025],
 [3317,3325,3507,3525,3526,3841,3842,4319,34116,34134,34135,
   34450,34451,34928,38502,38503,38980,45084],
 [3317,3325,3507,3525,3526,3841,3842,4319,34116,34134,34135,
   34450,34451,34928,38502,38503,38980,45084],
 [3317,3325,3507,3527,3528,3843,3844,4354,34116,34136,34137,
   34452,34453,34963,38504,38505,39015,45119],
 [3317,3325,3507,3527,3528,3843,3844,4354,34116,34136,34137,
   34452,34453,34963,38504,38505,39015,45119],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],
 [27841],[29168],[3507],
 [3364,3372,3500,3501,3507,3544,3550,3592,35190,35191,35197,
   35234,35240,35282,38205,38211,38253,39156],
 [3364,3372,3500,3501,3507,3544,3550,3592,35190,35191,35197,
   35234,35240,35282,38205,38211,38253,39156],
 [3364,3372,3502,3507,3508,3633,3634,3824,35192,35197,35198,
   35323,35324,35514,38294,38295,38485,41069],[3677,35367],
 [3364,3368,3372,3376,3503,3504,3507,3509,3511,3670,3673,3675,
   3677,3712,3714,3716,3825,3827,3896,35193,35194,35197,35199,
   35201,35360,35363,35365,35367,35402,35404,35406,35515,35517,
   35586,38331,38334,38336,38338,38373,38375,38377,38486,38488,
   38557,41737,41739,41741,41850,41852,41921,42591,42593,42662,
   44661],[3756],[3794,35484],[3507],
 [3364,3372,3502,3507,3508,3633,3634,3824,35192,35197,35198,
   35323,35324,35514,38294,38295,38485,41069],
 [3364,3368,3372,3376,3503,3504,3507,3509,3511,3670,3673,3675,
   3677,3712,3714,3716,3825,3827,3896,35193,35194,35197,35199,
   35201,35360,35363,35365,35367,35402,35404,35406,35515,35517,
   35586,38331,38334,38336,38338,38373,38375,38377,38486,38488,
   38557,41737,41739,41741,41850,41852,41921,42591,42593,42662,
   44661],[3930,35620],[3677,35367],[3930,35620],[3756],
 [3794,35484],[],[],
 [3364,3372,3507,3517,3518,3833,3834,4139,35197,35207,35208,
   35523,35524,35829,38494,38495,38800,44904],
 [3364,3372,3507,3517,3518,3833,3834,4139,35197,35207,35208,
   35523,35524,35829,38494,38495,38800,44904],[4193],[],
 [],[3364,3372,3507,3522,3524,3838,3840,4260,35197,35212,
   35214,35528,35530,35950,38499,38501,38921,45025],[4193],
 [3364,3372,3507,3522,3524,3838,3840,4260,35197,35212,35214,
   35528,35530,35950,38499,38501,38921,45025],
 [3364,3372,3507,3525,3526,3841,3842,4319,35197,35215,35216,
   35531,35532,36009,38502,38503,38980,45084],
 [3364,3372,3507,3525,3526,3841,3842,4319,35197,35215,35216,
   35531,35532,36009,38502,38503,38980,45084],
 [3364,3372,3507,3527,3528,3843,3844,4354,35197,35217,35218,
   35533,35534,36044,38504,38505,39015,45119],
 [3364,3372,3507,3527,3528,3843,3844,4354,35197,35217,35218,
   35533,35534,36044,38504,38505,39015,45119],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],
 [26510],[3507],
 [3410,3418,3500,3501,3507,3544,3550,3592,36225,36226,36232,
   36269,36275,36317,38205,38211,38253,39156],
 [3410,3418,3500,3501,3507,3544,3550,3592,36225,36226,36232,
   36269,36275,36317,38205,38211,38253,39156],
 [3410,3418,3502,3507,3508,3633,3634,3824,36227,36232,36233,
   36358,36359,36549,38294,38295,38485,41069],[3677,36402],
 [3714,36439],[3756],[3794,36519],[3507],
 [3410,3418,3502,3507,3508,3633,3634,3824,36227,36232,36233,
   36358,36359,36549,38294,38295,38485,41069],[3714,36439],
 [3930,36655],[3677,36402],[3930,36655],[3756],
 [3794,36519],[],[],
 [3410,3418,3507,3517,3518,3833,3834,4139,36232,36242,36243,
   36558,36559,36864,38494,38495,38800,44904],
 [3410,3418,3507,3517,3518,3833,3834,4139,36232,36242,36243,
   36558,36559,36864,38494,38495,38800,44904],[4193],[],
 [],[3410,3418,3507,3522,3524,3838,3840,4260,36232,36247,
   36249,36563,36565,36985,38499,38501,38921,45025],[4193],
 [3410,3418,3507,3522,3524,3838,3840,4260,36232,36247,36249,
   36563,36565,36985,38499,38501,38921,45025],
 [3410,3418,3507,3525,3526,3841,3842,4319,36232,36250,36251,
   36566,36567,37044,38502,38503,38980,45084],
 [3410,3418,3507,3525,3526,3841,3842,4319,36232,36250,36251,
   36566,36567,37044,38502,38503,38980,45084],
 [3410,3418,3507,3527,3528,3843,3844,4354,36232,36252,36253,
   36568,36569,37079,38504,38505,39015,45119],
 [3410,3418,3507,3527,3528,3843,3844,4354,36232,36252,36253,
   36568,36569,37079,38504,38505,39015,45119],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],
 [3507],[3455,3463,3500,3501,3507,3544,3550,3592,37215,37216,
   37222,37259,37265,37307,38205,38211,38253,39156],
 [3455,3463,3500,3501,3507,3544,3550,3592,37215,37216,37222,
   37259,37265,37307,38205,38211,38253,39156],
 [3455,3463,3502,3507,3508,3633,3634,3824,37217,37222,37223,
   37348,37349,37539,38294,38295,38485,41069],[3677,37392],
 [3714,37429],[3756],[3794,37509],[3507],
 [3455,3463,3502,3507,3508,3633,3634,3824,37217,37222,37223,
   37348,37349,37539,38294,38295,38485,41069],[3714,37429],
 [3930,37645],[3677,37392],[3930,37645],[3756],
 [3794,37509],[],[],
 [3455,3463,3507,3517,3518,3833,3834,4139,37222,37232,37233,
   37548,37549,37854,38494,38495,38800,44904],
 [3455,3463,3507,3517,3518,3833,3834,4139,37222,37232,37233,
   37548,37549,37854,38494,38495,38800,44904],[4193],[],
 [],[3455,3463,3507,3522,3524,3838,3840,4260,37222,37237,
   37239,37553,37555,37975,38499,38501,38921,45025],[4193],
 [3455,3463,3507,3522,3524,3838,3840,4260,37222,37237,37239,
   37553,37555,37975,38499,38501,38921,45025],
 [3455,3463,3507,3525,3526,3841,3842,4319,37222,37240,37241,
   37556,37557,38034,38502,38503,38980,45084],
 [3455,3463,3507,3525,3526,3841,3842,4319,37222,37240,37241,
   37556,37557,38034,38502,38503,38980,45084],
 [3455,3463,3507,3527,3528,3843,3844,4354,37222,37242,37243,
   37558,37559,38069,38504,38505,39015,45119],
 [3455,3463,3507,3527,3528,3843,3844,4354,37222,37242,37243,
   37558,37559,38069,38504,38505,39015,45119],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],
 [3507,38205],[3507,38205],[3507,41069],
 [3507,3677,3714,38331,38557,41850,42593],
 [3507,3677,3714,38331,38557,41850,42593],[3507,3756],
 [3507,3794,38455,43965],[],[3507,41069],
 [3507,3677,3714,38331,38557,41850,42593],
 [3507,3930,38591,44695],
 [3507,3677,3714,38331,38557,41850,42593],
 [3507,3930,38591,44695],[3507,3756],[3507,3794,38455,43965],
 [3507],[3507],[3507,44904],[3507,44904],[3507,4193],
 [3507],[3507],[3507,38921],[3507,4193],[3507,38921],
 [3507,45084],[3507,45084],[3507,39015],[3507,39015],
 [3507],[3507],[3507],[3507],[3507],[3507],[3507],
 [3507],[3507],[3507],[3507],[3507],[3507],[3507],
 [3507],[3507,38205],
 [3500,3501,3502,3503,3504,3507,3508,3509,3511,3544,3550,3592,
   3633,3634,3670,3673,3675,3677,3712,3714,3716,3824,3825,3827,
   3896,38205,38206,38207,38208,38211,38212,38213,38215,38248,
   38249,38250,38253,38254,38255,38257,38290,38291,38294,38295,
   38296,38298,38331,38334,38335,38336,38338,38373,38374,38375,
   38377,38485,38486,38488,38521,38523,38557,39151,39152,39153,
   39156,39157,39158,39160,39193,39194,39197,39198,39199,39201,
   39234,39237,39238,39239,39241,39276,39277,39278,39280,39388,
   39389,39391,39424,39426,39460,40054,40055,40058,40059,40060,
   40062,40095,40098,40099,40100,40102,40137,40138,40139,40141,
   40249,40250,40252,40285,40287,40321,40915,40918,40919,40920,
   40922,40957,40958,40959,40961,41069,41070,41072,41105,41107,
   41141,41737,41738,41739,41741,41849,41850,41852,41885,41887,
   41921,42590,42591,42593,42626,42628,42662,44625,44627,44661,
   45256],
 [3500,3501,3502,3503,3504,3507,3508,3509,3511,3544,3550,3592,
   3633,3634,3670,3673,3675,3677,3712,3714,3716,3824,3825,3827,
   3896,38205,38206,38207,38208,38211,38212,38213,38215,38248,
   38249,38250,38253,38254,38255,38257,38290,38291,38294,38295,
   38296,38298,38331,38334,38335,38336,38338,38373,38374,38375,
   38377,38485,38486,38488,38521,38523,38557,39151,39152,39153,
   39156,39157,39158,39160,39193,39194,39197,39198,39199,39201,
   39234,39237,39238,39239,39241,39276,39277,39278,39280,39388,
   39389,39391,39424,39426,39460,40054,40055,40058,40059,40060,
   40062,40095,40098,40099,40100,40102,40137,40138,40139,40141,
   40249,40250,40252,40285,40287,40321,40915,40918,40919,40920,
   40922,40957,40958,40959,40961,41069,41070,41072,41105,41107,
   41141,41737,41738,41739,41741,41849,41850,41852,41885,41887,
   41921,42590,42591,42593,42626,42628,42662,44625,44627,44661,
   45256],
 [3500,3501,3502,3503,3504,3507,3508,3509,3511,3544,3550,3592,
   3633,3634,3670,3673,3675,3677,3712,3714,3716,3824,3825,3827,
   3896,38205,38206,38207,38208,38211,38212,38213,38215,38248,
   38249,38250,38253,38254,38255,38257,38290,38291,38294,38295,
   38296,38298,38331,38334,38335,38336,38338,38373,38374,38375,
   38377,38485,38486,38488,38521,38523,38557,39151,39152,39153,
   39156,39157,39158,39160,39193,39194,39197,39198,39199,39201,
   39234,39237,39238,39239,39241,39276,39277,39278,39280,39388,
   39389,39391,39424,39426,39460,40054,40055,40058,40059,40060,
   40062,40095,40098,40099,40100,40102,40137,40138,40139,40141,
   40249,40250,40252,40285,40287,40321,40915,40918,40919,40920,
   40922,40957,40958,40959,40961,41069,41070,41072,41105,41107,
   41141,41737,41738,41739,41741,41849,41850,41852,41885,41887,
   41921,42590,42591,42593,42626,42628,42662,44625,44627,44661,
   45256],
 [3500,3501,3505,3506,3507,3513,3514,3544,3550,3592,3750,3756,
   3787,3794,3829,3830,38205,38209,38210,38211,38217,38218,
   38251,38252,38253,38259,38260,38410,38411,38417,38418,38448,
   38454,38455,38490,38491,38686,39154,39155,39156,39162,39163,
   39313,39314,39321,39351,39358,39393,39394,39589,40174,40175,
   40212,40218,40219,40254,40255,40450,43256,43263,43298,43299,
   43964,43965,44160,44790],
 [3500,3501,3505,3506,3507,3513,3514,3544,3550,3592,3750,3756,
   3787,3794,3829,3830,38205,38209,38210,38211,38217,38218,
   38251,38252,38253,38259,38260,38410,38411,38417,38418,38448,
   38454,38455,38490,38491,38686,39154,39155,39156,39162,39163,
   39313,39314,39321,39351,39358,39393,39394,39589,40174,40175,
   40212,40218,40219,40254,40255,40450,43256,43263,43298,43299,
   43964,43965,44160,44790],[3507,38205],
 [3500,3501,3502,3503,3504,3507,3508,3509,3511,3544,3550,3592,
   3633,3634,3670,3673,3675,3677,3712,3714,3716,3824,3825,3827,
   3896,38205,38206,38207,38208,38211,38212,38213,38215,38248,
   38249,38250,38253,38254,38255,38257,38290,38291,38294,38295,
   38296,38298,38331,38334,38335,38336,38338,38373,38374,38375,
   38377,38485,38486,38488,38521,38523,38557,39151,39152,39153,
   39156,39157,39158,39160,39193,39194,39197,39198,39199,39201,
   39234,39237,39238,39239,39241,39276,39277,39278,39280,39388,
   39389,39391,39424,39426,39460,40054,40055,40058,40059,40060,
   40062,40095,40098,40099,40100,40102,40137,40138,40139,40141,
   40249,40250,40252,40285,40287,40321,40915,40918,40919,40920,
   40922,40957,40958,40959,40961,41069,41070,41072,41105,41107,
   41141,41737,41738,41739,41741,41849,41850,41852,41885,41887,
   41921,42590,42591,42593,42626,42628,42662,44625,44627,44661,
   45256],
 [3500,3501,3502,3503,3504,3507,3508,3509,3511,3544,3550,3592,
   3633,3634,3670,3673,3675,3677,3712,3714,3716,3824,3825,3827,
   3896,38205,38206,38207,38208,38211,38212,38213,38215,38248,
   38249,38250,38253,38254,38255,38257,38290,38291,38294,38295,
   38296,38298,38331,38334,38335,38336,38338,38373,38374,38375,
   38377,38485,38486,38488,38521,38523,38557,39151,39152,39153,
   39156,39157,39158,39160,39193,39194,39197,39198,39199,39201,
   39234,39237,39238,39239,39241,39276,39277,39278,39280,39388,
   39389,39391,39424,39426,39460,40054,40055,40058,40059,40060,
   40062,40095,40098,40099,40100,40102,40137,40138,40139,40141,
   40249,40250,40252,40285,40287,40321,40915,40918,40919,40920,
   40922,40957,40958,40959,40961,41069,41070,41072,41105,41107,
   41141,41737,41738,41739,41741,41849,41850,41852,41885,41887,
   41921,42590,42591,42593,42626,42628,42662,44625,44627,44661,
   45256],
 [3500,3501,3507,3510,3512,3544,3550,3592,3826,3828,3930,38205,
   38211,38214,38216,38253,38256,38258,38487,38489,38591,39156,
   39159,39161,39390,39392,39494,40251,40253,40355,44695],
 [3500,3501,3502,3503,3504,3507,3508,3509,3511,3544,3550,3592,
   3633,3634,3670,3673,3675,3677,3712,3714,3716,3824,3825,3827,
   3896,38205,38206,38207,38208,38211,38212,38213,38215,38248,
   38249,38250,38253,38254,38255,38257,38290,38291,38294,38295,
   38296,38298,38331,38334,38335,38336,38338,38373,38374,38375,
   38377,38485,38486,38488,38521,38523,38557,39151,39152,39153,
   39156,39157,39158,39160,39193,39194,39197,39198,39199,39201,
   39234,39237,39238,39239,39241,39276,39277,39278,39280,39388,
   39389,39391,39424,39426,39460,40054,40055,40058,40059,40060,
   40062,40095,40098,40099,40100,40102,40137,40138,40139,40141,
   40249,40250,40252,40285,40287,40321,40915,40918,40919,40920,
   40922,40957,40958,40959,40961,41069,41070,41072,41105,41107,
   41141,41737,41738,41739,41741,41849,41850,41852,41885,41887,
   41921,42590,42591,42593,42626,42628,42662,44625,44627,44661,
   45256],
 [3500,3501,3507,3510,3512,3544,3550,3592,3826,3828,3930,38205,
   38211,38214,38216,38253,38256,38258,38487,38489,38591,39156,
   39159,39161,39390,39392,39494,40251,40253,40355,44695],
 [3500,3501,3505,3506,3507,3513,3514,3544,3550,3592,3750,3756,
   3787,3794,3829,3830,38205,38209,38210,38211,38217,38218,
   38251,38252,38253,38259,38260,38410,38411,38417,38418,38448,
   38454,38455,38490,38491,38686,39154,39155,39156,39162,39163,
   39313,39314,39321,39351,39358,39393,39394,39589,40174,40175,
   40212,40218,40219,40254,40255,40450,43256,43263,43298,43299,
   43964,43965,44160,44790],
 [3500,3501,3505,3506,3507,3513,3514,3544,3550,3592,3750,3756,
   3787,3794,3829,3830,38205,38209,38210,38211,38217,38218,
   38251,38252,38253,38259,38260,38410,38411,38417,38418,38448,
   38454,38455,38490,38491,38686,39154,39155,39156,39162,39163,
   39313,39314,39321,39351,39358,39393,39394,39589,40174,40175,
   40212,40218,40219,40254,40255,40450,43256,43263,43298,43299,
   43964,43965,44160,44790],
 [3500,3501,3507,3515,3544,3550,3592,3831,38205,38211,38219,
   38253,38261,38492,39156,39164,39395,40256],
 [3500,3501,3507,3516,3544,3550,3592,3832,38205,38211,38220,
   38253,38262,38493,39156,39165,39396,40257],
 [2279,3500,3501,3507,3517,3518,3544,3550,3592,3833,3834,4139,
   5645,5646,5662,5689,5695,5705,5706,5747,5978,5979,6284,7725,
   7726,7743,7769,7786,7817,7827,7828,8058,8059,8364,38205,
   38211,38221,38222,38253,38263,38264,38494,38495,38800,39156,
   39166,39167,39397,39398,39703,40258,40259,40564,44904],
 [2279,3500,3501,3507,3517,3518,3544,3550,3592,3833,3834,4139,
   5645,5646,5662,5689,5695,5705,5706,5747,5978,5979,6284,7725,
   7726,7743,7769,7786,7817,7827,7828,8058,8059,8364,38205,
   38211,38221,38222,38253,38263,38264,38494,38495,38800,39156,
   39166,39167,39397,39398,39703,40258,40259,40564,44904],
 [3500,3501,3507,3519,3523,3544,3550,3592,3835,3839,4193,38205,
   38211,38223,38227,38253,38265,38269,38496,38500,38854,39156,
   39168,39172,39399,39403,40260,40264,44958],
 [3500,3501,3507,3520,3522,3524,3544,3550,3592,3836,3838,3840,
   4260,38205,38211,38224,38226,38228,38253,38266,38268,38270,
   38497,38499,38501,38876,38878,38921,39156,39169,39171,39173,
   39400,39402,39404,39779,39781,39824,40261,40263,40265,40640,
   40642,40685,44980,44982,45025,50394],
 [3500,3501,3507,3521,3544,3550,3592,3837,38205,38211,38225,
   38253,38267,38498,39156,39170,39401,40262],
 [3500,3501,3507,3520,3522,3524,3544,3550,3592,3836,3838,3840,
   4260,38205,38211,38224,38226,38228,38253,38266,38268,38270,
   38497,38499,38501,38876,38878,38921,39156,39169,39171,39173,
   39400,39402,39404,39779,39781,39824,40261,40263,40265,40640,
   40642,40685,44980,44982,45025,50394],
 [3500,3501,3507,3519,3523,3544,3550,3592,3835,3839,4193,38205,
   38211,38223,38227,38253,38265,38269,38496,38500,38854,39156,
   39168,39172,39399,39403,40260,40264,44958],
 [3500,3501,3507,3520,3522,3524,3544,3550,3592,3836,3838,3840,
   4260,38205,38211,38224,38226,38228,38253,38266,38268,38270,
   38497,38499,38501,38876,38878,38921,39156,39169,39171,39173,
   39400,39402,39404,39779,39781,39824,40261,40263,40265,40640,
   40642,40685,44980,44982,45025,50394],
 [3500,3501,3507,3525,3526,3544,3550,3592,3841,3842,4319,38205,
   38211,38229,38230,38253,38271,38272,38502,38503,38980,39156,
   39174,39175,39405,39406,39883,40266,40267,40744,45084],
 [3500,3501,3507,3525,3526,3544,3550,3592,3841,3842,4319,38205,
   38211,38229,38230,38253,38271,38272,38502,38503,38980,39156,
   39174,39175,39405,39406,39883,40266,40267,40744,45084],
 [3500,3501,3507,3527,3528,3544,3550,3592,3843,3844,4354,38205,
   38211,38231,38232,38253,38273,38274,38504,38505,39015,39156,
   39176,39177,39407,39408,39918,40268,40269,40779,45119],
 [3500,3501,3507,3527,3528,3544,3550,3592,3843,3844,4354,38205,
   38211,38231,38232,38253,38273,38274,38504,38505,39015,39156,
   39176,39177,39407,39408,39918,40268,40269,40779,45119],
 [3500,3501,3507,3529,3544,3550,3592,3845,38205,38211,38233,
   38253,38275,38506,39156,39178,39409,40270],
 [3500,3501,3507,3530,3531,3544,3550,3592,3846,3847,38205,38211,
   38234,38235,38253,38276,38277,38507,38508,39060,39156,39179,
   39180,39410,39411,39963,40271,40272,40824,45164],
 [3500,3501,3507,3530,3531,3544,3550,3592,3846,3847,38205,38211,
   38234,38235,38253,38276,38277,38507,38508,39060,39156,39179,
   39180,39410,39411,39963,40271,40272,40824,45164],
 [3500,3501,3507,3532,3544,3550,3592,3848,38205,38211,38236,
   38253,38278,38509,39156,39181,39412,40273],
 [3500,3501,3507,3533,3544,3550,3592,3849,38205,38211,38237,
   38253,38279,38510,39156,39182,39413,40274],
 [3500,3501,3507,3534,3535,3544,3550,3592,3850,3851,38205,38211,
   38238,38239,38253,38280,38281,38511,38512,39106,39156,39183,
   39184,39414,39415,40009,40275,40276,40870,45210],
 [3500,3501,3507,3534,3535,3544,3550,3592,3850,3851,38205,38211,
   38238,38239,38253,38280,38281,38511,38512,39106,39156,39183,
   39184,39414,39415,40009,40275,40276,40870,45210],
 [3500,3501,3507,3536,3544,3550,3592,3852,38205,38211,38240,
   38253,38282,38513,39156,39185,39416,40277],
 [3500,3501,3507,3537,3544,3550,3592,3853,38205,38211,38241,
   38253,38283,38514,39156,39186,39417,40278],
 [3500,3501,3507,3538,3544,3550,3592,3854,38205,38211,38242,
   38253,38284,38515,39156,39187,39418,40279],
 [3500,3501,3507,3539,3544,3550,3592,3855,38205,38211,38243,
   38253,38285,38516,39156,39188,39419,40280],
 [3500,3501,3507,3540,3544,3550,3592,3856,38205,38211,38244,
   38253,38286,38517,39156,39189,39420,40281],
 [3500,3501,3507,3541,3544,3550,3592,3857,38205,38211,38245,
   38253,38287,38518,39156,39190,39421,40282],
 [3500,3501,3507,3542,3543,3544,3550,3592,3858,3859,38205,38211,
   38246,38247,38253,38288,38289,38519,38520,39150,39156,39191,
   39192,39422,39423,40053,40283,40284,40914,45254],
 [3500,3501,3507,3542,3543,3544,3550,3592,3858,3859,38205,38211,
   38246,38247,38253,38288,38289,38519,38520,39150,39156,39191,
   39192,39422,39423,40053,40283,40284,40914,45254],
 [3500,3501,3502,3503,3504,3507,3508,3509,3511,3544,3550,3592,
   3633,3634,3670,3673,3675,3677,3712,3714,3716,3824,3825,3827,
   3896,38205,38206,38207,38208,38211,38212,38213,38215,38248,
   38249,38250,38253,38254,38255,38257,38290,38291,38294,38295,
   38296,38298,38331,38334,38335,38336,38338,38373,38374,38375,
   38377,38485,38486,38488,38521,38523,38557,39151,39152,39153,
   39156,39157,39158,39160,39193,39194,39197,39198,39199,39201,
   39234,39237,39238,39239,39241,39276,39277,39278,39280,39388,
   39389,39391,39424,39426,39460,40054,40055,40058,40059,40060,
   40062,40095,40098,40099,40100,40102,40137,40138,40139,40141,
   40249,40250,40252,40285,40287,40321,40915,40918,40919,40920,
   40922,40957,40958,40959,40961,41069,41070,41072,41105,41107,
   41141,41737,41738,41739,41741,41849,41850,41852,41885,41887,
   41921,42590,42591,42593,42626,42628,42662,44625,44627,44661,
   45256],
 [3500,3501,3502,3503,3504,3507,3508,3509,3511,3544,3550,3592,
   3633,3634,3670,3673,3675,3677,3712,3714,3716,3824,3825,3827,
   3896,38205,38206,38207,38208,38211,38212,38213,38215,38248,
   38249,38250,38253,38254,38255,38257,38290,38291,38294,38295,
   38296,38298,38331,38334,38335,38336,38338,38373,38374,38375,
   38377,38485,38486,38488,38521,38523,38557,39151,39152,39153,
   39156,39157,39158,39160,39193,39194,39197,39198,39199,39201,
   39234,39237,39238,39239,39241,39276,39277,39278,39280,39388,
   39389,39391,39424,39426,39460,40054,40055,40058,40059,40060,
   40062,40095,40098,40099,40100,40102,40137,40138,40139,40141,
   40249,40250,40252,40285,40287,40321,40915,40918,40919,40920,
   40922,40957,40958,40959,40961,41069,41070,41072,41105,41107,
   41141,41737,41738,41739,41741,41849,41850,41852,41885,41887,
   41921,42590,42591,42593,42626,42628,42662,44625,44627,44661,
   45256],
 [3500,3501,3502,3503,3504,3507,3508,3509,3511,3544,3550,3592,
   3633,3634,3670,3673,3675,3677,3712,3714,3716,3824,3825,3827,
   3896,38205,38206,38207,38208,38211,38212,38213,38215,38248,
   38249,38250,38253,38254,38255,38257,38290,38291,38294,38295,
   38296,38298,38331,38334,38335,38336,38338,38373,38374,38375,
   38377,38485,38486,38488,38521,38523,38557,39151,39152,39153,
   39156,39157,39158,39160,39193,39194,39197,39198,39199,39201,
   39234,39237,39238,39239,39241,39276,39277,39278,39280,39388,
   39389,39391,39424,39426,39460,40054,40055,40058,40059,40060,
   40062,40095,40098,40099,40100,40102,40137,40138,40139,40141,
   40249,40250,40252,40285,40287,40321,40915,40918,40919,40920,
   40922,40957,40958,40959,40961,41069,41070,41072,41105,41107,
   41141,41737,41738,41739,41741,41849,41850,41852,41885,41887,
   41921,42590,42591,42593,42626,42628,42662,44625,44627,44661,
   45256],
 [3500,3501,3505,3506,3507,3513,3514,3544,3550,3592,3750,3756,
   3787,3794,3829,3830,38205,38209,38210,38211,38217,38218,
   38251,38252,38253,38259,38260,38410,38411,38417,38418,38448,
   38454,38455,38490,38491,38686,39154,39155,39156,39162,39163,
   39313,39314,39321,39351,39358,39393,39394,39589,40174,40175,
   40212,40218,40219,40254,40255,40450,43256,43263,43298,43299,
   43964,43965,44160,44790],
 [3500,3501,3505,3506,3507,3513,3514,3544,3550,3592,3750,3756,
   3787,3794,3829,3830,38205,38209,38210,38211,38217,38218,
   38251,38252,38253,38259,38260,38410,38411,38417,38418,38448,
   38454,38455,38490,38491,38686,39154,39155,39156,39162,39163,
   39313,39314,39321,39351,39358,39393,39394,39589,40174,40175,
   40212,40218,40219,40254,40255,40450,43256,43263,43298,43299,
   43964,43965,44160,44790],[3507,38205],
 [3500,3501,3502,3503,3504,3507,3508,3509,3511,3544,3550,3592,
   3633,3634,3670,3673,3675,3677,3712,3714,3716,3824,3825,3827,
   3896,38205,38206,38207,38208,38211,38212,38213,38215,38248,
   38249,38250,38253,38254,38255,38257,38290,38291,38294,38295,
   38296,38298,38331,38334,38335,38336,38338,38373,38374,38375,
   38377,38485,38486,38488,38521,38523,38557,39151,39152,39153,
   39156,39157,39158,39160,39193,39194,39197,39198,39199,39201,
   39234,39237,39238,39239,39241,39276,39277,39278,39280,39388,
   39389,39391,39424,39426,39460,40054,40055,40058,40059,40060,
   40062,40095,40098,40099,40100,40102,40137,40138,40139,40141,
   40249,40250,40252,40285,40287,40321,40915,40918,40919,40920,
   40922,40957,40958,40959,40961,41069,41070,41072,41105,41107,
   41141,41737,41738,41739,41741,41849,41850,41852,41885,41887,
   41921,42590,42591,42593,42626,42628,42662,44625,44627,44661,
   45256],
 [3500,3501,3502,3503,3504,3507,3508,3509,3511,3544,3550,3592,
   3633,3634,3670,3673,3675,3677,3712,3714,3716,3824,3825,3827,
   3896,38205,38206,38207,38208,38211,38212,38213,38215,38248,
   38249,38250,38253,38254,38255,38257,38290,38291,38294,38295,
   38296,38298,38331,38334,38335,38336,38338,38373,38374,38375,
   38377,38485,38486,38488,38521,38523,38557,39151,39152,39153,
   39156,39157,39158,39160,39193,39194,39197,39198,39199,39201,
   39234,39237,39238,39239,39241,39276,39277,39278,39280,39388,
   39389,39391,39424,39426,39460,40054,40055,40058,40059,40060,
   40062,40095,40098,40099,40100,40102,40137,40138,40139,40141,
   40249,40250,40252,40285,40287,40321,40915,40918,40919,40920,
   40922,40957,40958,40959,40961,41069,41070,41072,41105,41107,
   41141,41737,41738,41739,41741,41849,41850,41852,41885,41887,
   41921,42590,42591,42593,42626,42628,42662,44625,44627,44661,
   45256],
 [3500,3501,3507,3510,3512,3544,3550,3592,3826,3828,3930,38205,
   38211,38214,38216,38253,38256,38258,38487,38489,38591,39156,
   39159,39161,39390,39392,39494,40251,40253,40355,44695],
 [3500,3501,3502,3503,3504,3507,3508,3509,3511,3544,3550,3592,
   3633,3634,3670,3673,3675,3677,3712,3714,3716,3824,3825,3827,
   3896,38205,38206,38207,38208,38211,38212,38213,38215,38248,
   38249,38250,38253,38254,38255,38257,38290,38291,38294,38295,
   38296,38298,38331,38334,38335,38336,38338,38373,38374,38375,
   38377,38485,38486,38488,38521,38523,38557,39151,39152,39153,
   39156,39157,39158,39160,39193,39194,39197,39198,39199,39201,
   39234,39237,39238,39239,39241,39276,39277,39278,39280,39388,
   39389,39391,39424,39426,39460,40054,40055,40058,40059,40060,
   40062,40095,40098,40099,40100,40102,40137,40138,40139,40141,
   40249,40250,40252,40285,40287,40321,40915,40918,40919,40920,
   40922,40957,40958,40959,40961,41069,41070,41072,41105,41107,
   41141,41737,41738,41739,41741,41849,41850,41852,41885,41887,
   41921,42590,42591,42593,42626,42628,42662,44625,44627,44661,
   45256],
 [3500,3501,3507,3510,3512,3544,3550,3592,3826,3828,3930,38205,
   38211,38214,38216,38253,38256,38258,38487,38489,38591,39156,
   39159,39161,39390,39392,39494,40251,40253,40355,44695],
 [3500,3501,3505,3506,3507,3513,3514,3544,3550,3592,3750,3756,
   3787,3794,3829,3830,38205,38209,38210,38211,38217,38218,
   38251,38252,38253,38259,38260,38410,38411,38417,38418,38448,
   38454,38455,38490,38491,38686,39154,39155,39156,39162,39163,
   39313,39314,39321,39351,39358,39393,39394,39589,40174,40175,
   40212,40218,40219,40254,40255,40450,43256,43263,43298,43299,
   43964,43965,44160,44790],
 [3500,3501,3505,3506,3507,3513,3514,3544,3550,3592,3750,3756,
   3787,3794,3829,3830,38205,38209,38210,38211,38217,38218,
   38251,38252,38253,38259,38260,38410,38411,38417,38418,38448,
   38454,38455,38490,38491,38686,39154,39155,39156,39162,39163,
   39313,39314,39321,39351,39358,39393,39394,39589,40174,40175,
   40212,40218,40219,40254,40255,40450,43256,43263,43298,43299,
   43964,43965,44160,44790],
 [3500,3501,3507,3515,3544,3550,3592,3831,38205,38211,38219,
   38253,38261,38492,39156,39164,39395,40256],
 [3500,3501,3507,3516,3544,3550,3592,3832,38205,38211,38220,
   38253,38262,38493,39156,39165,39396,40257],
 [2279,3500,3501,3507,3517,3518,3544,3550,3592,3833,3834,4139,
   5645,5646,5662,5689,5695,5705,5706,5747,5978,5979,6284,7725,
   7726,7743,7769,7786,7817,7827,7828,8058,8059,8364,38205,
   38211,38221,38222,38253,38263,38264,38494,38495,38800,39156,
   39166,39167,39397,39398,39703,40258,40259,40564,44904],
 [2279,3500,3501,3507,3517,3518,3544,3550,3592,3833,3834,4139,
   5645,5646,5662,5689,5695,5705,5706,5747,5978,5979,6284,7725,
   7726,7743,7769,7786,7817,7827,7828,8058,8059,8364,38205,
   38211,38221,38222,38253,38263,38264,38494,38495,38800,39156,
   39166,39167,39397,39398,39703,40258,40259,40564,44904],
 [3500,3501,3507,3519,3523,3544,3550,3592,3835,3839,4193,38205,
   38211,38223,38227,38253,38265,38269,38496,38500,38854,39156,
   39168,39172,39399,39403,40260,40264,44958],
 [3500,3501,3507,3520,3522,3524,3544,3550,3592,3836,3838,3840,
   4260,38205,38211,38224,38226,38228,38253,38266,38268,38270,
   38497,38499,38501,38876,38878,38921,39156,39169,39171,39173,
   39400,39402,39404,39779,39781,39824,40261,40263,40265,40640,
   40642,40685,44980,44982,45025,50394],
 [3500,3501,3507,3521,3544,3550,3592,3837,38205,38211,38225,
   38253,38267,38498,39156,39170,39401,40262],
 [3500,3501,3507,3520,3522,3524,3544,3550,3592,3836,3838,3840,
   4260,38205,38211,38224,38226,38228,38253,38266,38268,38270,
   38497,38499,38501,38876,38878,38921,39156,39169,39171,39173,
   39400,39402,39404,39779,39781,39824,40261,40263,40265,40640,
   40642,40685,44980,44982,45025,50394],
 [3500,3501,3507,3519,3523,3544,3550,3592,3835,3839,4193,38205,
   38211,38223,38227,38253,38265,38269,38496,38500,38854,39156,
   39168,39172,39399,39403,40260,40264,44958],
 [3500,3501,3507,3520,3522,3524,3544,3550,3592,3836,3838,3840,
   4260,38205,38211,38224,38226,38228,38253,38266,38268,38270,
   38497,38499,38501,38876,38878,38921,39156,39169,39171,39173,
   39400,39402,39404,39779,39781,39824,40261,40263,40265,40640,
   40642,40685,44980,44982,45025,50394],
 [3500,3501,3507,3525,3526,3544,3550,3592,3841,3842,4319,38205,
   38211,38229,38230,38253,38271,38272,38502,38503,38980,39156,
   39174,39175,39405,39406,39883,40266,40267,40744,45084],
 [3500,3501,3507,3525,3526,3544,3550,3592,3841,3842,4319,38205,
   38211,38229,38230,38253,38271,38272,38502,38503,38980,39156,
   39174,39175,39405,39406,39883,40266,40267,40744,45084],
 [3500,3501,3507,3527,3528,3544,3550,3592,3843,3844,4354,38205,
   38211,38231,38232,38253,38273,38274,38504,38505,39015,39156,
   39176,39177,39407,39408,39918,40268,40269,40779,45119],
 [3500,3501,3507,3527,3528,3544,3550,3592,3843,3844,4354,38205,
   38211,38231,38232,38253,38273,38274,38504,38505,39015,39156,
   39176,39177,39407,39408,39918,40268,40269,40779,45119],
 [3500,3501,3507,3529,3544,3550,3592,3845,38205,38211,38233,
   38253,38275,38506,39156,39178,39409,40270],
 [3500,3501,3507,3530,3531,3544,3550,3592,3846,3847,38205,38211,
   38234,38235,38253,38276,38277,38507,38508,39060,39156,39179,
   39180,39410,39411,39963,40271,40272,40824,45164],
 [3500,3501,3507,3530,3531,3544,3550,3592,3846,3847,38205,38211,
   38234,38235,38253,38276,38277,38507,38508,39060,39156,39179,
   39180,39410,39411,39963,40271,40272,40824,45164],
 [3500,3501,3507,3532,3544,3550,3592,3848,38205,38211,38236,
   38253,38278,38509,39156,39181,39412,40273],
 [3500,3501,3507,3533,3544,3550,3592,3849,38205,38211,38237,
   38253,38279,38510,39156,39182,39413,40274],
 [3500,3501,3507,3534,3535,3544,3550,3592,3850,3851,38205,38211,
   38238,38239,38253,38280,38281,38511,38512,39106,39156,39183,
   39184,39414,39415,40009,40275,40276,40870,45210],
 [3500,3501,3507,3534,3535,3544,3550,3592,3850,3851,38205,38211,
   38238,38239,38253,38280,38281,38511,38512,39106,39156,39183,
   39184,39414,39415,40009,40275,40276,40870,45210],
 [3500,3501,3507,3536,3544,3550,3592,3852,38205,38211,38240,
   38253,38282,38513,39156,39185,39416,40277],
 [3500,3501,3507,3537,3544,3550,3592,3853,38205,38211,38241,
   38253,38283,38514,39156,39186,39417,40278],
 [3500,3501,3507,3538,3544,3550,3592,3854,38205,38211,38242,
   38253,38284,38515,39156,39187,39418,40279],
 [3500,3501,3507,3539,3544,3550,3592,3855,38205,38211,38243,
   38253,38285,38516,39156,39188,39419,40280],
 [3500,3501,3507,3540,3544,3550,3592,3856,38205,38211,38244,
   38253,38286,38517,39156,39189,39420,40281],
 [3500,3501,3507,3541,3544,3550,3592,3857,38205,38211,38245,
   38253,38287,38518,39156,39190,39421,40282],
 [3500,3501,3507,3542,3543,3544,3550,3592,3858,3859,38205,38211,
   38246,38247,38253,38288,38289,38519,38520,39150,39156,39191,
   39192,39422,39423,40053,40283,40284,40914,45254],
 [3500,3501,3507,3542,3543,3544,3550,3592,3858,3859,38205,38211,
   38246,38247,38253,38288,38289,38519,38520,39150,39156,39191,
   39192,39422,39423,40053,40283,40284,40914,45254],
 [3500,3501,3502,3503,3504,3507,3508,3509,3511,3544,3550,3592,
   3633,3634,3670,3673,3675,3677,3712,3714,3716,3824,3825,3827,
   3896,38205,38206,38207,38208,38211,38212,38213,38215,38248,
   38249,38250,38253,38254,38255,38257,38290,38291,38294,38295,
   38296,38298,38331,38334,38335,38336,38338,38373,38374,38375,
   38377,38485,38486,38488,38521,38523,38557,39151,39152,39153,
   39156,39157,39158,39160,39193,39194,39197,39198,39199,39201,
   39234,39237,39238,39239,39241,39276,39277,39278,39280,39388,
   39389,39391,39424,39426,39460,40054,40055,40058,40059,40060,
   40062,40095,40098,40099,40100,40102,40137,40138,40139,40141,
   40249,40250,40252,40285,40287,40321,40915,40918,40919,40920,
   40922,40957,40958,40959,40961,41069,41070,41072,41105,41107,
   41141,41737,41738,41739,41741,41849,41850,41852,41885,41887,
   41921,42590,42591,42593,42626,42628,42662,44625,44627,44661,
   45256],
 [3500,3501,3502,3503,3504,3507,3508,3509,3511,3544,3550,3592,
   3633,3634,3670,3673,3675,3677,3712,3714,3716,3824,3825,3827,
   3896,38205,38206,38207,38208,38211,38212,38213,38215,38248,
   38249,38250,38253,38254,38255,38257,38290,38291,38294,38295,
   38296,38298,38331,38334,38335,38336,38338,38373,38374,38375,
   38377,38485,38486,38488,38521,38523,38557,39151,39152,39153,
   39156,39157,39158,39160,39193,39194,39197,39198,39199,39201,
   39234,39237,39238,39239,39241,39276,39277,39278,39280,39388,
   39389,39391,39424,39426,39460,40054,40055,40058,40059,40060,
   40062,40095,40098,40099,40100,40102,40137,40138,40139,40141,
   40249,40250,40252,40285,40287,40321,40915,40918,40919,40920,
   40922,40957,40958,40959,40961,41069,41070,41072,41105,41107,
   41141,41737,41738,41739,41741,41849,41850,41852,41885,41887,
   41921,42590,42591,42593,42626,42628,42662,44625,44627,44661,
   45256],
 [3502,3505,3507,3508,3510,3512,3513,3633,3634,3750,3756,3824,
   3826,3828,3829,3930,38292,38294,38295,38297,38299,38300,
   38411,38412,38414,38416,38417,38485,38487,38489,38490,38522,
   38524,38525,38591,38592,38655,40995,40996,40998,41069,41071,
   41073,41074,41106,41108,41109,41175,41176,41239,43293,43295,
   43297,43298,43330,43332,43399,44626,44628,44629,44695,44696,
   44759,45290,45354,46443],
 [3502,3506,3507,3508,3514,3633,3634,3787,3794,3824,3830,38293,
   38294,38295,38301,38448,38449,38455,38485,38491,38526,41032,
   41033,41039,41069,41075,41110,43959,43965,44000,44630],
 [3507,41069],[3507,41069],
 [3500,3501,3502,3503,3504,3507,3508,3509,3511,3544,3550,3592,
   3633,3634,3670,3673,3675,3677,3712,3714,3716,3824,3825,3827,
   3896,38205,38206,38207,38208,38211,38212,38213,38215,38248,
   38249,38250,38253,38254,38255,38257,38290,38291,38294,38295,
   38296,38298,38331,38334,38335,38336,38338,38373,38374,38375,
   38377,38485,38486,38488,38521,38523,38557,39151,39152,39153,
   39156,39157,39158,39160,39193,39194,39197,39198,39199,39201,
   39234,39237,39238,39239,39241,39276,39277,39278,39280,39388,
   39389,39391,39424,39426,39460,40054,40055,40058,40059,40060,
   40062,40095,40098,40099,40100,40102,40137,40138,40139,40141,
   40249,40250,40252,40285,40287,40321,40915,40918,40919,40920,
   40922,40957,40958,40959,40961,41069,41070,41072,41105,41107,
   41141,41737,41738,41739,41741,41849,41850,41852,41885,41887,
   41921,42590,42591,42593,42626,42628,42662,44625,44627,44661,
   45256],
 [3502,3505,3507,3508,3510,3512,3513,3633,3634,3750,3756,3824,
   3826,3828,3829,3930,38292,38294,38295,38297,38299,38300,
   38411,38412,38414,38416,38417,38485,38487,38489,38490,38522,
   38524,38525,38591,38592,38655,40995,40996,40998,41069,41071,
   41073,41074,41106,41108,41109,41175,41176,41239,43293,43295,
   43297,43298,43330,43332,43399,44626,44628,44629,44695,44696,
   44759,45290,45354,46443],
 [3500,3501,3502,3503,3504,3507,3508,3509,3511,3544,3550,3592,
   3633,3634,3670,3673,3675,3677,3712,3714,3716,3824,3825,3827,
   3896,38205,38206,38207,38208,38211,38212,38213,38215,38248,
   38249,38250,38253,38254,38255,38257,38290,38291,38294,38295,
   38296,38298,38331,38334,38335,38336,38338,38373,38374,38375,
   38377,38485,38486,38488,38521,38523,38557,39151,39152,39153,
   39156,39157,39158,39160,39193,39194,39197,39198,39199,39201,
   39234,39237,39238,39239,39241,39276,39277,39278,39280,39388,
   39389,39391,39424,39426,39460,40054,40055,40058,40059,40060,
   40062,40095,40098,40099,40100,40102,40137,40138,40139,40141,
   40249,40250,40252,40285,40287,40321,40915,40918,40919,40920,
   40922,40957,40958,40959,40961,41069,41070,41072,41105,41107,
   41141,41737,41738,41739,41741,41849,41850,41852,41885,41887,
   41921,42590,42591,42593,42626,42628,42662,44625,44627,44661,
   45256],
 [3502,3505,3507,3508,3510,3512,3513,3633,3634,3750,3756,3824,
   3826,3828,3829,3930,38292,38294,38295,38297,38299,38300,
   38411,38412,38414,38416,38417,38485,38487,38489,38490,38522,
   38524,38525,38591,38592,38655,40995,40996,40998,41069,41071,
   41073,41074,41106,41108,41109,41175,41176,41239,43293,43295,
   43297,43298,43330,43332,43399,44626,44628,44629,44695,44696,
   44759,45290,45354,46443],
 [3502,3505,3507,3508,3510,3512,3513,3633,3634,3750,3756,3824,
   3826,3828,3829,3930,38292,38294,38295,38297,38299,38300,
   38411,38412,38414,38416,38417,38485,38487,38489,38490,38522,
   38524,38525,38591,38592,38655,40995,40996,40998,41069,41071,
   41073,41074,41106,41108,41109,41175,41176,41239,43293,43295,
   43297,43298,43330,43332,43399,44626,44628,44629,44695,44696,
   44759,45290,45354,46443],
 [3502,3506,3507,3508,3514,3633,3634,3787,3794,3824,3830,38293,
   38294,38295,38301,38448,38449,38455,38485,38491,38526,41032,
   41033,41039,41069,41075,41110,43959,43965,44000,44630],
 [3502,3507,3508,3515,3633,3634,3824,3831,38294,38295,38302,
   38485,38492,38527,41069,41076,41111,44631],
 [3502,3507,3508,3516,3633,3634,3824,3832,38294,38295,38303,
   38485,38493,38528,41069,41077,41112,44632],
 [23,31,44,1291,1296,1297,1306,1307,1309,1432,1625,1658,3502,
   3507,3508,3517,3518,3520,3633,3634,3824,3833,3834,3836,4139,
   38294,38295,38304,38305,38307,38485,38494,38495,38497,38529,
   38530,38532,38800,38802,38827,41069,41078,41079,41081,41113,
   41114,41116,41384,41386,41411,44633,44634,44636,44904,44906,
   44931,45499,45501,45526,49471],
 [23,31,44,1291,1296,1297,1306,1307,1309,1432,1625,1658,3502,
   3507,3508,3517,3518,3520,3633,3634,3824,3833,3834,3836,4139,
   38294,38295,38304,38305,38307,38485,38494,38495,38497,38529,
   38530,38532,38800,38802,38827,41069,41078,41079,41081,41113,
   41114,41116,41384,41386,41411,44633,44634,44636,44904,44906,
   44931,45499,45501,45526,49471],
 [3502,3507,3508,3519,3523,3633,3634,3824,3835,3839,4193,38294,
   38295,38306,38310,38485,38496,38500,38531,38535,38854,41069,
   41080,41084,41115,41119,44635,44639,44958],
 [23,31,44,1291,1296,1297,1306,1307,1309,1432,1625,1658,3502,
   3507,3508,3517,3518,3520,3633,3634,3824,3833,3834,3836,4139,
   38294,38295,38304,38305,38307,38485,38494,38495,38497,38529,
   38530,38532,38800,38802,38827,41069,41078,41079,41081,41113,
   41114,41116,41384,41386,41411,44633,44634,44636,44904,44906,
   44931,45499,45501,45526,49471],
 [3502,3507,3508,3521,3633,3634,3824,3837,38294,38295,38308,
   38485,38498,38533,41069,41082,41117,44637],
 [3502,3507,3508,3522,3524,3633,3634,3824,3838,3840,4260,38294,
   38295,38309,38311,38485,38499,38501,38534,38536,38921,41069,
   41083,41085,41118,41120,41505,44638,44640,45025,45620],
 [3502,3507,3508,3519,3523,3633,3634,3824,3835,3839,4193,38294,
   38295,38306,38310,38485,38496,38500,38531,38535,38854,41069,
   41080,41084,41115,41119,44635,44639,44958],
 [3502,3507,3508,3522,3524,3633,3634,3824,3838,3840,4260,38294,
   38295,38309,38311,38485,38499,38501,38534,38536,38921,41069,
   41083,41085,41118,41120,41505,44638,44640,45025,45620],
 [3502,3507,3508,3525,3526,3633,3634,3824,3841,3842,4319,38294,
   38295,38312,38313,38485,38502,38503,38537,38538,38980,41069,
   41086,41087,41121,41122,41564,44641,44642,45084,45679],
 [3502,3507,3508,3525,3526,3633,3634,3824,3841,3842,4319,38294,
   38295,38312,38313,38485,38502,38503,38537,38538,38980,41069,
   41086,41087,41121,41122,41564,44641,44642,45084,45679],
 [3502,3507,3508,3527,3528,3633,3634,3824,3843,3844,4354,38294,
   38295,38314,38315,38485,38504,38505,38539,38540,39015,41069,
   41088,41089,41123,41124,41599,44643,44644,45119,45714],
 [3502,3507,3508,3527,3528,3633,3634,3824,3843,3844,4354,38294,
   38295,38314,38315,38485,38504,38505,38539,38540,39015,41069,
   41088,41089,41123,41124,41599,44643,44644,45119,45714],
 [3502,3507,3508,3529,3530,3633,3634,3824,3845,3846,38294,38295,
   38316,38317,38485,38506,38507,38541,38542,39046,41069,41090,
   41091,41125,41126,41630,44645,44646,45150,45745],
 [3502,3507,3508,3529,3530,3633,3634,3824,3845,3846,38294,38295,
   38316,38317,38485,38506,38507,38541,38542,39046,41069,41090,
   41091,41125,41126,41630,44645,44646,45150,45745],
 [3502,3507,3508,3531,3633,3634,3824,3847,38294,38295,38318,
   38485,38508,38543,41069,41092,41127,44647],
 [3502,3507,3508,3532,3633,3634,3824,3848,38294,38295,38319,
   38485,38509,38544,41069,41093,41128,44648],
 [3502,3507,3508,3533,3633,3634,3824,3849,38294,38295,38320,
   38485,38510,38545,41069,41094,41129,44649],
 [3502,3507,3508,3534,3536,3633,3634,3824,3850,3852,38294,38295,
   38321,38323,38485,38511,38513,38546,38548,39107,41069,41095,
   41097,41130,41132,41691,44650,44652,45211,45806],
 [3502,3507,3508,3535,3633,3634,3824,3851,38294,38295,38322,
   38485,38512,38547,41069,41096,41131,44651],
 [3502,3507,3508,3534,3536,3633,3634,3824,3850,3852,38294,38295,
   38321,38323,38485,38511,38513,38546,38548,39107,41069,41095,
   41097,41130,41132,41691,44650,44652,45211,45806],
 [3502,3507,3508,3537,3633,3634,3824,3853,38294,38295,38324,
   38485,38514,38549,41069,41098,41133,44653],
 [3502,3507,3508,3538,3633,3634,3824,3854,38294,38295,38325,
   38485,38515,38550,41069,41099,41134,44654],
 [3502,3507,3508,3539,3633,3634,3824,3855,38294,38295,38326,
   38485,38516,38551,41069,41100,41135,44655],
 [3502,3507,3508,3540,3633,3634,3824,3856,38294,38295,38327,
   38485,38517,38552,41069,41101,41136,44656],
 [3502,3507,3508,3541,3542,3633,3634,3824,3857,3858,38294,38295,
   38328,38329,38485,38518,38519,38553,38554,39148,41069,41102,
   41103,41137,41138,41732,44657,44658,45252,45847],
 [3502,3507,3508,3541,3542,3633,3634,3824,3857,3858,38294,38295,
   38328,38329,38485,38518,38519,38553,38554,39148,41069,41102,
   41103,41137,41138,41732,44657,44658,45252,45847],
 [3502,3507,3508,3543,3633,3634,3824,3859,38294,38295,38330,
   38485,38520,38555,41069,41104,41139,44659],
 [3507,3677,3714,38331,38557,41850,42593],
 [3503,3504,3505,3507,3509,3511,3513,3670,3673,3675,3677,3710,
   3712,3714,3716,3718,3750,3752,3756,3825,3827,3829,3896,3898,
   38331,38332,38334,38336,38338,38340,38371,38373,38375,38377,
   38379,38411,38413,38415,38417,38486,38488,38490,38557,38559,
   38624,41735,41737,41739,41741,41743,41775,41777,41779,41850,
   41852,41854,41921,41923,41988,42516,42518,42520,42522,42591,
   42593,42595,42662,42664,42729,43294,43296,43298,43365,43367,
   44661,44663,44728,45884],[3677,3794,41816,41819,41989,44099]
  ,[3507,3677,3714,38331,38557,41850,42593],
 [3500,3501,3502,3503,3504,3507,3508,3509,3511,3544,3550,3592,
   3633,3634,3670,3673,3675,3677,3712,3714,3716,3824,3825,3827,
   3896,38205,38206,38207,38208,38211,38212,38213,38215,38248,
   38249,38250,38253,38254,38255,38257,38290,38291,38294,38295,
   38296,38298,38331,38334,38335,38336,38338,38373,38374,38375,
   38377,38485,38486,38488,38521,38523,38557,39151,39152,39153,
   39156,39157,39158,39160,39193,39194,39197,39198,39199,39201,
   39234,39237,39238,39239,39241,39276,39277,39278,39280,39388,
   39389,39391,39424,39426,39460,40054,40055,40058,40059,40060,
   40062,40095,40098,40099,40100,40102,40137,40138,40139,40141,
   40249,40250,40252,40285,40287,40321,40915,40918,40919,40920,
   40922,40957,40958,40959,40961,41069,41070,41072,41105,41107,
   41141,41737,41738,41739,41741,41849,41850,41852,41885,41887,
   41921,42590,42591,42593,42626,42628,42662,44625,44627,44661,
   45256],[3507,3677,3714,38331,38557,41850,42593],
 [3677,3930,41954,41955,41987,46411],[],
 [3677,3930,41954,41955,41987,46411],
 [3503,3504,3505,3507,3509,3511,3513,3670,3673,3675,3677,3710,
   3712,3714,3716,3718,3750,3752,3756,3825,3827,3829,3896,3898,
   38331,38332,38334,38336,38338,38340,38371,38373,38375,38377,
   38379,38411,38413,38415,38417,38486,38488,38490,38557,38559,
   38624,41735,41737,41739,41741,41743,41775,41777,41779,41850,
   41852,41854,41921,41923,41988,42516,42518,42520,42522,42591,
   42593,42595,42662,42664,42729,43294,43296,43298,43365,43367,
   44661,44663,44728,45884],[3677,3794,41816,41819,41989,44099]
  ,[3677,41990,41991,42109,47029],
 [3677,41990,41991,42109,47029],
 [3503,3504,3507,3509,3511,3517,3518,3522,3524,3670,3673,3675,
   3677,3712,3714,3716,3825,3827,3833,3834,3838,3840,3896,4139,
   4260,38331,38334,38336,38338,38344,38345,38349,38351,38373,
   38375,38377,38383,38384,38388,38390,38486,38488,38494,38495,
   38499,38501,38557,38563,38564,38568,38570,38628,38629,38633,
   38635,38800,38804,38806,38829,38831,38921,41737,41739,41741,
   41747,41748,41752,41754,41850,41852,41858,41859,41863,41865,
   41921,41927,41928,41932,41934,41992,41993,41997,41999,42164,
   42168,42170,42193,42195,42285,42591,42593,42599,42600,42604,
   42606,42662,42668,42669,42673,42675,42733,42734,42738,42740,
   42905,42909,42911,42934,42936,43026,44661,44667,44668,44672,
   44674,44732,44733,44737,44739,44904,44908,44910,44933,44935,
   45025,45888,45889,45893,45895,46060,46064,46066,46089,46091,
   46181,47084,47088,47090,47113,47115,47205,49473,49475,49565,
   49865],
 [3503,3504,3507,3509,3511,3517,3518,3522,3524,3670,3673,3675,
   3677,3712,3714,3716,3825,3827,3833,3834,3838,3840,3896,4139,
   4260,38331,38334,38336,38338,38344,38345,38349,38351,38373,
   38375,38377,38383,38384,38388,38390,38486,38488,38494,38495,
   38499,38501,38557,38563,38564,38568,38570,38628,38629,38633,
   38635,38800,38804,38806,38829,38831,38921,41737,41739,41741,
   41747,41748,41752,41754,41850,41852,41858,41859,41863,41865,
   41921,41927,41928,41932,41934,41992,41993,41997,41999,42164,
   42168,42170,42193,42195,42285,42591,42593,42599,42600,42604,
   42606,42662,42668,42669,42673,42675,42733,42734,42738,42740,
   42905,42909,42911,42934,42936,43026,44661,44667,44668,44672,
   44674,44732,44733,44737,44739,44904,44908,44910,44933,44935,
   45025,45888,45889,45893,45895,46060,46064,46066,46089,46091,
   46181,47084,47088,47090,47113,47115,47205,49473,49475,49565,
   49865],
 [3503,3504,3507,3509,3511,3519,3523,3670,3673,3675,3677,3712,
   3714,3716,3724,3728,3825,3827,3835,3839,3896,3904,3908,4193,
   38331,38334,38336,38338,38346,38350,38373,38375,38377,38385,
   38389,38486,38488,38496,38500,38557,38565,38569,38630,38634,
   38854,41737,41739,41741,41749,41753,41850,41852,41860,41864,
   41921,41929,41933,41994,41998,42591,42593,42601,42605,42662,
   42670,42674,42735,42739,42959,44661,44669,44673,44734,44738,
   44958,45890,45894,46114],[3677,41995],[3677,41996],
 [3503,3504,3507,3509,3511,3517,3518,3522,3524,3670,3673,3675,
   3677,3712,3714,3716,3825,3827,3833,3834,3838,3840,3896,4139,
   4260,38331,38334,38336,38338,38344,38345,38349,38351,38373,
   38375,38377,38383,38384,38388,38390,38486,38488,38494,38495,
   38499,38501,38557,38563,38564,38568,38570,38628,38629,38633,
   38635,38800,38804,38806,38829,38831,38921,41737,41739,41741,
   41747,41748,41752,41754,41850,41852,41858,41859,41863,41865,
   41921,41927,41928,41932,41934,41992,41993,41997,41999,42164,
   42168,42170,42193,42195,42285,42591,42593,42599,42600,42604,
   42606,42662,42668,42669,42673,42675,42733,42734,42738,42740,
   42905,42909,42911,42934,42936,43026,44661,44667,44668,44672,
   44674,44732,44733,44737,44739,44904,44908,44910,44933,44935,
   45025,45888,45889,45893,45895,46060,46064,46066,46089,46091,
   46181,47084,47088,47090,47113,47115,47205,49473,49475,49565,
   49865],
 [3503,3504,3507,3509,3511,3519,3523,3670,3673,3675,3677,3712,
   3714,3716,3724,3728,3825,3827,3835,3839,3896,3904,3908,4193,
   38331,38334,38336,38338,38346,38350,38373,38375,38377,38385,
   38389,38486,38488,38496,38500,38557,38565,38569,38630,38634,
   38854,41737,41739,41741,41749,41753,41850,41852,41860,41864,
   41921,41929,41933,41994,41998,42591,42593,42601,42605,42662,
   42670,42674,42735,42739,42959,44661,44669,44673,44734,44738,
   44958,45890,45894,46114],
 [3503,3504,3507,3509,3511,3517,3518,3522,3524,3670,3673,3675,
   3677,3712,3714,3716,3825,3827,3833,3834,3838,3840,3896,4139,
   4260,38331,38334,38336,38338,38344,38345,38349,38351,38373,
   38375,38377,38383,38384,38388,38390,38486,38488,38494,38495,
   38499,38501,38557,38563,38564,38568,38570,38628,38629,38633,
   38635,38800,38804,38806,38829,38831,38921,41737,41739,41741,
   41747,41748,41752,41754,41850,41852,41858,41859,41863,41865,
   41921,41927,41928,41932,41934,41992,41993,41997,41999,42164,
   42168,42170,42193,42195,42285,42591,42593,42599,42600,42604,
   42606,42662,42668,42669,42673,42675,42733,42734,42738,42740,
   42905,42909,42911,42934,42936,43026,44661,44667,44668,44672,
   44674,44732,44733,44737,44739,44904,44908,44910,44933,44935,
   45025,45888,45889,45893,45895,46060,46064,46066,46089,46091,
   46181,47084,47088,47090,47113,47115,47205,49473,49475,49565,
   49865],
 [3503,3504,3507,3509,3511,3525,3526,3527,3528,3670,3673,3675,
   3677,3712,3714,3716,3825,3827,3841,3842,3843,3844,3896,4319,
   4354,38331,38334,38336,38338,38352,38353,38354,38355,38373,
   38375,38377,38391,38392,38393,38394,38486,38488,38502,38503,
   38504,38505,38557,38571,38572,38573,38574,38636,38637,38638,
   38639,38980,38981,38982,38998,38999,39015,41737,41739,41741,
   41755,41756,41757,41758,41850,41852,41866,41867,41868,41869,
   41921,41935,41936,41937,41938,42000,42001,42002,42003,42344,
   42345,42346,42362,42363,42379,42591,42593,42607,42608,42609,
   42610,42662,42676,42677,42678,42679,42741,42742,42743,42744,
   43085,43086,43087,43103,43104,43120,44661,44675,44676,44677,
   44678,44740,44741,44742,44743,45084,45085,45086,45102,45103,
   45119,45896,45897,45898,45899,46240,46241,46242,46258,46259,
   46275,47264,47265,47266,47282,47283,47299,51426,51427,51443,
   51579],
 [3503,3504,3507,3509,3511,3525,3526,3527,3528,3670,3673,3675,
   3677,3712,3714,3716,3825,3827,3841,3842,3843,3844,3896,4319,
   4354,38331,38334,38336,38338,38352,38353,38354,38355,38373,
   38375,38377,38391,38392,38393,38394,38486,38488,38502,38503,
   38504,38505,38557,38571,38572,38573,38574,38636,38637,38638,
   38639,38980,38981,38982,38998,38999,39015,41737,41739,41741,
   41755,41756,41757,41758,41850,41852,41866,41867,41868,41869,
   41921,41935,41936,41937,41938,42000,42001,42002,42003,42344,
   42345,42346,42362,42363,42379,42591,42593,42607,42608,42609,
   42610,42662,42676,42677,42678,42679,42741,42742,42743,42744,
   43085,43086,43087,43103,43104,43120,44661,44675,44676,44677,
   44678,44740,44741,44742,44743,45084,45085,45086,45102,45103,
   45119,45896,45897,45898,45899,46240,46241,46242,46258,46259,
   46275,47264,47265,47266,47282,47283,47299,51426,51427,51443,
   51579],
 [3503,3504,3507,3509,3511,3525,3526,3527,3528,3670,3673,3675,
   3677,3712,3714,3716,3825,3827,3841,3842,3843,3844,3896,4319,
   4354,38331,38334,38336,38338,38352,38353,38354,38355,38373,
   38375,38377,38391,38392,38393,38394,38486,38488,38502,38503,
   38504,38505,38557,38571,38572,38573,38574,38636,38637,38638,
   38639,38980,38981,38982,38998,38999,39015,41737,41739,41741,
   41755,41756,41757,41758,41850,41852,41866,41867,41868,41869,
   41921,41935,41936,41937,41938,42000,42001,42002,42003,42344,
   42345,42346,42362,42363,42379,42591,42593,42607,42608,42609,
   42610,42662,42676,42677,42678,42679,42741,42742,42743,42744,
   43085,43086,43087,43103,43104,43120,44661,44675,44676,44677,
   44678,44740,44741,44742,44743,45084,45085,45086,45102,45103,
   45119,45896,45897,45898,45899,46240,46241,46242,46258,46259,
   46275,47264,47265,47266,47282,47283,47299,51426,51427,51443,
   51579],
 [3503,3504,3507,3509,3511,3525,3526,3527,3528,3670,3673,3675,
   3677,3712,3714,3716,3825,3827,3841,3842,3843,3844,3896,4319,
   4354,38331,38334,38336,38338,38352,38353,38354,38355,38373,
   38375,38377,38391,38392,38393,38394,38486,38488,38502,38503,
   38504,38505,38557,38571,38572,38573,38574,38636,38637,38638,
   38639,38980,38981,38982,38998,38999,39015,41737,41739,41741,
   41755,41756,41757,41758,41850,41852,41866,41867,41868,41869,
   41921,41935,41936,41937,41938,42000,42001,42002,42003,42344,
   42345,42346,42362,42363,42379,42591,42593,42607,42608,42609,
   42610,42662,42676,42677,42678,42679,42741,42742,42743,42744,
   43085,43086,43087,43103,43104,43120,44661,44675,44676,44677,
   44678,44740,44741,44742,44743,45084,45085,45086,45102,45103,
   45119,45896,45897,45898,45899,46240,46241,46242,46258,46259,
   46275,47264,47265,47266,47282,47283,47299,51426,51427,51443,
   51579],[3677,42004,42006,42411,47331],[3677,42005],
 [3677,42004,42006,42411,47331],[3677,42007,42008,42449,47369],
 [3677,42007,42008,42449,47369],[3677,42009],
 [3677,42010,42011,42479,47399],[3677,42010,42011,42479,47399],
 [3677,42012,42013,42494,47414],[3677,42012,42013,42494,47414],
 [3677,42014],[3677,42015],[3677,42016,42018,42513,47433],
 [3677,42017],[3677,42016,42018,42513,47433],
 [3714,3756,42518,42664],
 [3714,3794,3930,42555,42556,42558,42560,42661,42663,42665,42696,
   42698,42761,44030,44032,44034,44065,44067,44130,45851,45853,
   45916,46444],[3507,3677,3714,38331,38557,41850,42593],
 [3500,3501,3502,3503,3504,3507,3508,3509,3511,3544,3550,3592,
   3633,3634,3670,3673,3675,3677,3712,3714,3716,3824,3825,3827,
   3896,38205,38206,38207,38208,38211,38212,38213,38215,38248,
   38249,38250,38253,38254,38255,38257,38290,38291,38294,38295,
   38296,38298,38331,38334,38335,38336,38338,38373,38374,38375,
   38377,38485,38486,38488,38521,38523,38557,39151,39152,39153,
   39156,39157,39158,39160,39193,39194,39197,39198,39199,39201,
   39234,39237,39238,39239,39241,39276,39277,39278,39280,39388,
   39389,39391,39424,39426,39460,40054,40055,40058,40059,40060,
   40062,40095,40098,40099,40100,40102,40137,40138,40139,40141,
   40249,40250,40252,40285,40287,40321,40915,40918,40919,40920,
   40922,40957,40958,40959,40961,41069,41070,41072,41105,41107,
   41141,41737,41738,41739,41741,41849,41850,41852,41885,41887,
   41921,42590,42591,42593,42626,42628,42662,44625,44627,44661,
   45256],[],
 [3714,3794,3930,42555,42556,42558,42560,42661,42663,42665,42696,
   42698,42761,44030,44032,44034,44065,44067,44130,45851,45853,
   45916,46444],[3507,3677,3714,38331,38557,41850,42593],
 [3714,3794,3930,42555,42556,42558,42560,42661,42663,42665,42696,
   42698,42761,44030,44032,44034,44065,44067,44130,45851,45853,
   45916,46444],[3714,3756,42518,42664],
 [3714,3794,3930,42555,42556,42558,42560,42661,42663,42665,42696,
   42698,42761,44030,44032,44034,44065,44067,44130,45851,45853,
   45916,46444],[3714,42666],[3714,42667],
 [3503,3504,3507,3509,3511,3517,3518,3522,3524,3670,3673,3675,
   3677,3712,3714,3716,3825,3827,3833,3834,3838,3840,3896,4139,
   4260,38331,38334,38336,38338,38344,38345,38349,38351,38373,
   38375,38377,38383,38384,38388,38390,38486,38488,38494,38495,
   38499,38501,38557,38563,38564,38568,38570,38628,38629,38633,
   38635,38800,38804,38806,38829,38831,38921,41737,41739,41741,
   41747,41748,41752,41754,41850,41852,41858,41859,41863,41865,
   41921,41927,41928,41932,41934,41992,41993,41997,41999,42164,
   42168,42170,42193,42195,42285,42591,42593,42599,42600,42604,
   42606,42662,42668,42669,42673,42675,42733,42734,42738,42740,
   42905,42909,42911,42934,42936,43026,44661,44667,44668,44672,
   44674,44732,44733,44737,44739,44904,44908,44910,44933,44935,
   45025,45888,45889,45893,45895,46060,46064,46066,46089,46091,
   46181,47084,47088,47090,47113,47115,47205,49473,49475,49565,
   49865],
 [3503,3504,3507,3509,3511,3517,3518,3522,3524,3670,3673,3675,
   3677,3712,3714,3716,3825,3827,3833,3834,3838,3840,3896,4139,
   4260,38331,38334,38336,38338,38344,38345,38349,38351,38373,
   38375,38377,38383,38384,38388,38390,38486,38488,38494,38495,
   38499,38501,38557,38563,38564,38568,38570,38628,38629,38633,
   38635,38800,38804,38806,38829,38831,38921,41737,41739,41741,
   41747,41748,41752,41754,41850,41852,41858,41859,41863,41865,
   41921,41927,41928,41932,41934,41992,41993,41997,41999,42164,
   42168,42170,42193,42195,42285,42591,42593,42599,42600,42604,
   42606,42662,42668,42669,42673,42675,42733,42734,42738,42740,
   42905,42909,42911,42934,42936,43026,44661,44667,44668,44672,
   44674,44732,44733,44737,44739,44904,44908,44910,44933,44935,
   45025,45888,45889,45893,45895,46060,46064,46066,46089,46091,
   46181,47084,47088,47090,47113,47115,47205,49473,49475,49565,
   49865],[3714,4193,42670,42674],[3714,42671],
 [3503,3504,3507,3509,3511,3521,3670,3673,3675,3677,3687,3712,
   3714,3716,3825,3827,3837,3896,3971,38331,38334,38336,38338,
   38348,38373,38375,38377,38387,38486,38488,38498,38557,38567,
   38632,41737,41739,41741,41751,41850,41852,41862,41921,41931,
   41996,42591,42593,42603,42662,42672,42737,44661,44671,44736,
   45892],
 [3503,3504,3507,3509,3511,3517,3518,3522,3524,3670,3673,3675,
   3677,3712,3714,3716,3825,3827,3833,3834,3838,3840,3896,4139,
   4260,38331,38334,38336,38338,38344,38345,38349,38351,38373,
   38375,38377,38383,38384,38388,38390,38486,38488,38494,38495,
   38499,38501,38557,38563,38564,38568,38570,38628,38629,38633,
   38635,38800,38804,38806,38829,38831,38921,41737,41739,41741,
   41747,41748,41752,41754,41850,41852,41858,41859,41863,41865,
   41921,41927,41928,41932,41934,41992,41993,41997,41999,42164,
   42168,42170,42193,42195,42285,42591,42593,42599,42600,42604,
   42606,42662,42668,42669,42673,42675,42733,42734,42738,42740,
   42905,42909,42911,42934,42936,43026,44661,44667,44668,44672,
   44674,44732,44733,44737,44739,44904,44908,44910,44933,44935,
   45025,45888,45889,45893,45895,46060,46064,46066,46089,46091,
   46181,47084,47088,47090,47113,47115,47205,49473,49475,49565,
   49865],[3714,4193,42670,42674],
 [3503,3504,3507,3509,3511,3517,3518,3522,3524,3670,3673,3675,
   3677,3712,3714,3716,3825,3827,3833,3834,3838,3840,3896,4139,
   4260,38331,38334,38336,38338,38344,38345,38349,38351,38373,
   38375,38377,38383,38384,38388,38390,38486,38488,38494,38495,
   38499,38501,38557,38563,38564,38568,38570,38628,38629,38633,
   38635,38800,38804,38806,38829,38831,38921,41737,41739,41741,
   41747,41748,41752,41754,41850,41852,41858,41859,41863,41865,
   41921,41927,41928,41932,41934,41992,41993,41997,41999,42164,
   42168,42170,42193,42195,42285,42591,42593,42599,42600,42604,
   42606,42662,42668,42669,42673,42675,42733,42734,42738,42740,
   42905,42909,42911,42934,42936,43026,44661,44667,44668,44672,
   44674,44732,44733,44737,44739,44904,44908,44910,44933,44935,
   45025,45888,45889,45893,45895,46060,46064,46066,46089,46091,
   46181,47084,47088,47090,47113,47115,47205,49473,49475,49565,
   49865],
 [3503,3504,3507,3509,3511,3525,3526,3527,3528,3670,3673,3675,
   3677,3712,3714,3716,3825,3827,3841,3842,3843,3844,3896,4319,
   4354,38331,38334,38336,38338,38352,38353,38354,38355,38373,
   38375,38377,38391,38392,38393,38394,38486,38488,38502,38503,
   38504,38505,38557,38571,38572,38573,38574,38636,38637,38638,
   38639,38980,38981,38982,38998,38999,39015,41737,41739,41741,
   41755,41756,41757,41758,41850,41852,41866,41867,41868,41869,
   41921,41935,41936,41937,41938,42000,42001,42002,42003,42344,
   42345,42346,42362,42363,42379,42591,42593,42607,42608,42609,
   42610,42662,42676,42677,42678,42679,42741,42742,42743,42744,
   43085,43086,43087,43103,43104,43120,44661,44675,44676,44677,
   44678,44740,44741,44742,44743,45084,45085,45086,45102,45103,
   45119,45896,45897,45898,45899,46240,46241,46242,46258,46259,
   46275,47264,47265,47266,47282,47283,47299,51426,51427,51443,
   51579],
 [3503,3504,3507,3509,3511,3525,3526,3527,3528,3670,3673,3675,
   3677,3712,3714,3716,3825,3827,3841,3842,3843,3844,3896,4319,
   4354,38331,38334,38336,38338,38352,38353,38354,38355,38373,
   38375,38377,38391,38392,38393,38394,38486,38488,38502,38503,
   38504,38505,38557,38571,38572,38573,38574,38636,38637,38638,
   38639,38980,38981,38982,38998,38999,39015,41737,41739,41741,
   41755,41756,41757,41758,41850,41852,41866,41867,41868,41869,
   41921,41935,41936,41937,41938,42000,42001,42002,42003,42344,
   42345,42346,42362,42363,42379,42591,42593,42607,42608,42609,
   42610,42662,42676,42677,42678,42679,42741,42742,42743,42744,
   43085,43086,43087,43103,43104,43120,44661,44675,44676,44677,
   44678,44740,44741,44742,44743,45084,45085,45086,45102,45103,
   45119,45896,45897,45898,45899,46240,46241,46242,46258,46259,
   46275,47264,47265,47266,47282,47283,47299,51426,51427,51443,
   51579],
 [3503,3504,3507,3509,3511,3525,3526,3527,3528,3670,3673,3675,
   3677,3712,3714,3716,3825,3827,3841,3842,3843,3844,3896,4319,
   4354,38331,38334,38336,38338,38352,38353,38354,38355,38373,
   38375,38377,38391,38392,38393,38394,38486,38488,38502,38503,
   38504,38505,38557,38571,38572,38573,38574,38636,38637,38638,
   38639,38980,38981,38982,38998,38999,39015,41737,41739,41741,
   41755,41756,41757,41758,41850,41852,41866,41867,41868,41869,
   41921,41935,41936,41937,41938,42000,42001,42002,42003,42344,
   42345,42346,42362,42363,42379,42591,42593,42607,42608,42609,
   42610,42662,42676,42677,42678,42679,42741,42742,42743,42744,
   43085,43086,43087,43103,43104,43120,44661,44675,44676,44677,
   44678,44740,44741,44742,44743,45084,45085,45086,45102,45103,
   45119,45896,45897,45898,45899,46240,46241,46242,46258,46259,
   46275,47264,47265,47266,47282,47283,47299,51426,51427,51443,
   51579],
 [3503,3504,3507,3509,3511,3525,3526,3527,3528,3670,3673,3675,
   3677,3712,3714,3716,3825,3827,3841,3842,3843,3844,3896,4319,
   4354,38331,38334,38336,38338,38352,38353,38354,38355,38373,
   38375,38377,38391,38392,38393,38394,38486,38488,38502,38503,
   38504,38505,38557,38571,38572,38573,38574,38636,38637,38638,
   38639,38980,38981,38982,38998,38999,39015,41737,41739,41741,
   41755,41756,41757,41758,41850,41852,41866,41867,41868,41869,
   41921,41935,41936,41937,41938,42000,42001,42002,42003,42344,
   42345,42346,42362,42363,42379,42591,42593,42607,42608,42609,
   42610,42662,42676,42677,42678,42679,42741,42742,42743,42744,
   43085,43086,43087,43103,43104,43120,44661,44675,44676,44677,
   44678,44740,44741,44742,44743,45084,45085,45086,45102,45103,
   45119,45896,45897,45898,45899,46240,46241,46242,46258,46259,
   46275,47264,47265,47266,47282,47283,47299,51426,51427,51443,
   51579],[3714,42680],
 [3503,3504,3507,3509,3511,3530,3670,3673,3675,3677,3696,3712,
   3714,3716,3825,3827,3846,3896,3980,38331,38334,38336,38338,
   38357,38373,38375,38377,38396,38486,38488,38507,38557,38576,
   38641,41737,41739,41741,41760,41850,41852,41871,41921,41940,
   42005,42591,42593,42612,42662,42681,42746,44661,44680,44745,
   45901],[3714,42682],[3714,42683],[3714,42684],
 [3503,3504,3507,3509,3511,3534,3670,3673,3675,3677,3700,3712,
   3714,3716,3825,3827,3850,3896,3984,38331,38334,38336,38338,
   38361,38373,38375,38377,38400,38486,38488,38511,38557,38580,
   38645,41737,41739,41741,41764,41850,41852,41875,41921,41944,
   42009,42591,42593,42616,42662,42685,42750,44661,44684,44749,
   45905],[3714,42686],[3714,42687],[3714,42688],
 [3714,42689],[3714,42690],[3714,42691],[3714,42692],
 [3503,3504,3507,3509,3511,3542,3670,3673,3675,3677,3708,3712,
   3714,3716,3825,3827,3858,3896,3992,38331,38334,38336,38338,
   38369,38373,38375,38377,38408,38486,38488,38519,38557,38588,
   38653,41737,41739,41741,41772,41850,41852,41883,41921,41952,
   42017,42591,42593,42624,42662,42693,42758,44661,44692,44757,
   45913],[3714,42694],
 [3500,3501,3505,3506,3507,3513,3514,3544,3550,3592,3750,3756,
   3787,3794,3829,3830,38205,38209,38210,38211,38217,38218,
   38251,38252,38253,38259,38260,38410,38411,38417,38418,38448,
   38454,38455,38490,38491,38686,39154,39155,39156,39162,39163,
   39313,39314,39321,39351,39358,39393,39394,39589,40174,40175,
   40212,40218,40219,40254,40255,40450,43256,43263,43298,43299,
   43964,43965,44160,44790],[3507,3756],
 [3502,3505,3507,3508,3510,3512,3513,3633,3634,3750,3756,3824,
   3826,3828,3829,3930,38292,38294,38295,38297,38299,38300,
   38411,38412,38414,38416,38417,38485,38487,38489,38490,38522,
   38524,38525,38591,38592,38655,40995,40996,40998,41069,41071,
   41073,41074,41106,41108,41109,41175,41176,41239,43293,43295,
   43297,43298,43330,43332,43399,44626,44628,44629,44695,44696,
   44759,45290,45354,46443],[3714,3756,42518,42664],
 [3502,3505,3507,3508,3510,3512,3513,3633,3634,3750,3756,3824,
   3826,3828,3829,3930,38292,38294,38295,38297,38299,38300,
   38411,38412,38414,38416,38417,38485,38487,38489,38490,38522,
   38524,38525,38591,38592,38655,40995,40996,40998,41069,41071,
   41073,41074,41106,41108,41109,41175,41176,41239,43293,43295,
   43297,43298,43330,43332,43399,44626,44628,44629,44695,44696,
   44759,45290,45354,46443],
 [3503,3504,3505,3507,3509,3511,3513,3670,3673,3675,3677,3710,
   3712,3714,3716,3718,3750,3752,3756,3825,3827,3829,3896,3898,
   38331,38332,38334,38336,38338,38340,38371,38373,38375,38377,
   38379,38411,38413,38415,38417,38486,38488,38490,38557,38559,
   38624,41735,41737,41739,41741,41743,41775,41777,41779,41850,
   41852,41854,41921,41923,41988,42516,42518,42520,42522,42591,
   42593,42595,42662,42664,42729,43294,43296,43298,43365,43367,
   44661,44663,44728,45884],
 [3502,3505,3507,3508,3510,3512,3513,3633,3634,3750,3756,3824,
   3826,3828,3829,3930,38292,38294,38295,38297,38299,38300,
   38411,38412,38414,38416,38417,38485,38487,38489,38490,38522,
   38524,38525,38591,38592,38655,40995,40996,40998,41069,41071,
   41073,41074,41106,41108,41109,41175,41176,41239,43293,43295,
   43297,43298,43330,43332,43399,44626,44628,44629,44695,44696,
   44759,45290,45354,46443],[],
 [3500,3501,3505,3506,3507,3513,3514,3544,3550,3592,3750,3756,
   3787,3794,3829,3830,38205,38209,38210,38211,38217,38218,
   38251,38252,38253,38259,38260,38410,38411,38417,38418,38448,
   38454,38455,38490,38491,38686,39154,39155,39156,39162,39163,
   39313,39314,39321,39351,39358,39393,39394,39589,40174,40175,
   40212,40218,40219,40254,40255,40450,43256,43263,43298,43299,
   43964,43965,44160,44790],[3756],[3756],
 [3505,3507,3513,3517,3518,3750,3756,3829,3833,3834,4139,38411,
   38417,38421,38422,38490,38494,38495,38689,38690,38800,43298,
   43302,43303,43608,44793,44794,44904,47984],
 [3505,3507,3513,3517,3518,3750,3756,3829,3833,3834,4139,38411,
   38417,38421,38422,38490,38494,38495,38689,38690,38800,43298,
   43302,43303,43608,44793,44794,44904,47984],
 [3756,4193,43685,48035],[3756,4193,43685,48035],[3756],
 [3505,3507,3513,3522,3524,3750,3756,3829,3838,3840,4260,38411,
   38417,38426,38428,38490,38499,38501,38694,38696,38921,43298,
   43307,43309,43729,44798,44800,45025,48105],
 [3756,4193,43685,48035],
 [3505,3507,3513,3522,3524,3750,3756,3829,3838,3840,4260,38411,
   38417,38426,38428,38490,38499,38501,38694,38696,38921,43298,
   43307,43309,43729,44798,44800,45025,48105],
 [3505,3507,3513,3525,3526,3750,3756,3829,3841,3842,4319,38411,
   38417,38429,38430,38490,38502,38503,38697,38698,38980,43298,
   43310,43311,43788,44801,44802,45084,48164],
 [3505,3507,3513,3525,3526,3750,3756,3829,3841,3842,4319,38411,
   38417,38429,38430,38490,38502,38503,38697,38698,38980,43298,
   43310,43311,43788,44801,44802,45084,48164],
 [3505,3507,3513,3527,3528,3750,3756,3829,3843,3844,4354,38411,
   38417,38431,38432,38490,38504,38505,38699,38700,39015,43298,
   43312,43313,43823,44803,44804,45119,48199],
 [3505,3507,3513,3527,3528,3750,3756,3829,3843,3844,4354,38411,
   38417,38431,38432,38490,38504,38505,38699,38700,39015,43298,
   43312,43313,43823,44803,44804,45119,48199],[3756],[3756],
 [3756],[3756],[3756],[3756],[3756],[3756],
 [3505,3507,3513,3537,3750,3756,3829,3853,38411,38417,38441,
   38490,38514,38709,43298,43322,44813],[3756],[3756],
 [3756],[3756],[3756],[3756],[3507,3794,38455,43965],
 [3502,3506,3507,3508,3514,3633,3634,3787,3794,3824,3830,38293,
   38294,38295,38301,38448,38449,38455,38485,38491,38526,41032,
   41033,41039,41069,41075,41110,43959,43965,44000,44630],
 [3714,3794,3930,42555,42556,42558,42560,42661,42663,42665,42696,
   42698,42761,44030,44032,44034,44065,44067,44130,45851,45853,
   45916,46444],
 [3714,3794,3930,42555,42556,42558,42560,42661,42663,42665,42696,
   42698,42761,44030,44032,44034,44065,44067,44130,45851,45853,
   45916,46444],[3677,3794,41816,41819,41989,44099],
 [3714,3794,3930,42555,42556,42558,42560,42661,42663,42665,42696,
   42698,42761,44030,44032,44034,44065,44067,44130,45851,45853,
   45916,46444],
 [3500,3501,3505,3506,3507,3513,3514,3544,3550,3592,3750,3756,
   3787,3794,3829,3830,38205,38209,38210,38211,38217,38218,
   38251,38252,38253,38259,38260,38410,38411,38417,38418,38448,
   38454,38455,38490,38491,38686,39154,39155,39156,39162,39163,
   39313,39314,39321,39351,39358,39393,39394,39589,40174,40175,
   40212,40218,40219,40254,40255,40450,43256,43263,43298,43299,
   43964,43965,44160,44790],[],[3794,44190],[3794,44191],
 [3506,3507,3514,3517,3518,3787,3794,3830,3833,3834,4139,38448,
   38455,38458,38459,38491,38494,38495,38718,38719,38800,43965,
   43968,43969,44192,44193,44274,44822,44823,44904,48390],
 [3506,3507,3514,3517,3518,3787,3794,3830,3833,3834,4139,38448,
   38455,38458,38459,38491,38494,38495,38718,38719,38800,43965,
   43968,43969,44192,44193,44274,44822,44823,44904,48390],
 [3506,3507,3514,3519,3522,3523,3524,3787,3794,3830,3835,3838,
   3839,3840,4193,4260,38448,38455,38460,38463,38464,38465,
   38491,38496,38499,38500,38501,38720,38723,38724,38725,38853,
   38854,38855,38920,38921,38941,43965,43970,43973,43974,43975,
   44194,44197,44198,44199,44329,44394,44395,44415,44824,44827,
   44828,44829,44957,44958,44959,45024,45025,45045,48443,48445,
   48510,48511,50141,50855],[3794,44195],
 [3506,3507,3514,3521,3787,3794,3830,3837,38448,38455,38462,
   38491,38498,38722,43965,43972,44196,44826],
 [3506,3507,3514,3519,3522,3523,3524,3787,3794,3830,3835,3838,
   3839,3840,4193,4260,38448,38455,38460,38463,38464,38465,
   38491,38496,38499,38500,38501,38720,38723,38724,38725,38853,
   38854,38855,38920,38921,38941,43965,43970,43973,43974,43975,
   44194,44197,44198,44199,44329,44394,44395,44415,44824,44827,
   44828,44829,44957,44958,44959,45024,45025,45045,48443,48445,
   48510,48511,50141,50855],
 [3506,3507,3514,3519,3522,3523,3524,3787,3794,3830,3835,3838,
   3839,3840,4193,4260,38448,38455,38460,38463,38464,38465,
   38491,38496,38499,38500,38501,38720,38723,38724,38725,38853,
   38854,38855,38920,38921,38941,43965,43970,43973,43974,43975,
   44194,44197,44198,44199,44329,44394,44395,44415,44824,44827,
   44828,44829,44957,44958,44959,45024,45025,45045,48443,48445,
   48510,48511,50141,50855],
 [3506,3507,3514,3519,3522,3523,3524,3787,3794,3830,3835,3838,
   3839,3840,4193,4260,38448,38455,38460,38463,38464,38465,
   38491,38496,38499,38500,38501,38720,38723,38724,38725,38853,
   38854,38855,38920,38921,38941,43965,43970,43973,43974,43975,
   44194,44197,44198,44199,44329,44394,44395,44415,44824,44827,
   44828,44829,44957,44958,44959,45024,45025,45045,48443,48445,
   48510,48511,50141,50855],
 [3506,3507,3514,3525,3526,3787,3794,3830,3841,3842,4319,38448,
   38455,38466,38467,38491,38502,38503,38726,38727,38980,43965,
   43976,43977,44200,44201,44454,44830,44831,45084,48570],
 [3506,3507,3514,3525,3526,3787,3794,3830,3841,3842,4319,38448,
   38455,38466,38467,38491,38502,38503,38726,38727,38980,43965,
   43976,43977,44200,44201,44454,44830,44831,45084,48570],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,
   2384,3500,3501,3505,3506,3507,3513,3514,3517,3518,3527,3528,
   3544,3548,3549,3550,3556,3557,3560,3561,3570,3571,3590,3591,
   3592,3598,3599,3602,3603,3612,3613,3749,3750,3756,3757,3760,
   3761,3770,3771,3787,3793,3794,3797,3798,3829,3830,3833,3834,
   3843,3844,4025,4028,4029,4038,4039,4057,4058,4139,4148,4149,
   4173,4174,4354,4510,4511,4512,4518,4528,4529,5645,5646,5650,
   5651,5652,5658,5659,5662,5663,5672,5673,5689,5693,5694,5695,
   5701,5702,5705,5706,5715,5716,5735,5736,5737,5743,5744,5747,
   5748,5757,5758,5894,5895,5902,5905,5906,5916,5932,5939,5942,
   5943,5953,5974,5975,5978,5979,5988,5989,6170,6173,6174,6183,
   6184,6202,6203,6212,6213,6284,6293,6294,6318,6319,6499,7725,
   7726,7730,7731,7732,7738,7739,7742,7743,7752,7753,7769,7773,
   7774,7775,7781,7782,7785,7786,7795,7796,7815,7816,7817,7823,
   7824,7827,7828,7837,7838,7974,7975,7985,7986,7995,7996,8012,
   8018,8019,8022,8023,8032,8033,8054,8055,8058,8059,8068,8069,
   8250,8253,8254,8263,8282,8283,8292,8364,8373,8374,8398,8399,
   8579,38205,38209,38210,38211,38217,38218,38221,38222,38231,
   38232,38251,38252,38253,38259,38260,38263,38264,38273,38274,
   38410,38411,38417,38418,38421,38422,38431,38432,38448,38454,
   38455,38458,38459,38468,38469,38490,38491,38494,38495,38504,
   38505,38686,38689,38690,38699,38700,38718,38719,38728,38729,
   38800,38809,38810,38834,38835,39015,39154,39155,39156,39162,
   39163,39166,39167,39176,39177,39313,39314,39320,39321,39324,
   39325,39334,39335,39351,39357,39358,39361,39362,39371,39372,
   39393,39394,39397,39398,39407,39408,39589,39592,39593,39602,
   39603,39621,39622,39631,39632,39703,39712,39713,39737,39738,
   39918,40174,40175,40181,40182,40185,40186,40195,40196,40212,
   40218,40219,40222,40223,40232,40233,40254,40255,40258,40259,
   40268,40269,40450,40453,40454,40463,40464,40482,40483,40492,
   40493,40564,40573,40574,40598,40599,40779,43256,43262,43263,
   43266,43267,43276,43277,43298,43299,43302,43303,43312,43313,
   43494,43497,43498,43507,43508,43526,43527,43536,43537,43608,
   43617,43618,43642,43643,43823,43964,43965,43968,43969,43978,
   43979,44160,44163,44164,44173,44174,44192,44193,44202,44203,
   44274,44283,44284,44308,44309,44489,44790,44793,44794,44803,
   44804,44822,44823,44832,44833,44904,44913,44914,44938,44939,
   45119,47902,47903,47912,47913,47984,47993,47994,48018,48019,
   48199,48390,48399,48400,48424,48425,48605,49478,49479,49659,
   49959],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,
   2384,3500,3501,3505,3506,3507,3513,3514,3517,3518,3527,3528,
   3544,3548,3549,3550,3556,3557,3560,3561,3570,3571,3590,3591,
   3592,3598,3599,3602,3603,3612,3613,3749,3750,3756,3757,3760,
   3761,3770,3771,3787,3793,3794,3797,3798,3829,3830,3833,3834,
   3843,3844,4025,4028,4029,4038,4039,4057,4058,4139,4148,4149,
   4173,4174,4354,4510,4511,4512,4518,4528,4529,5645,5646,5650,
   5651,5652,5658,5659,5662,5663,5672,5673,5689,5693,5694,5695,
   5701,5702,5705,5706,5715,5716,5735,5736,5737,5743,5744,5747,
   5748,5757,5758,5894,5895,5902,5905,5906,5916,5932,5939,5942,
   5943,5953,5974,5975,5978,5979,5988,5989,6170,6173,6174,6183,
   6184,6202,6203,6212,6213,6284,6293,6294,6318,6319,6499,7725,
   7726,7730,7731,7732,7738,7739,7742,7743,7752,7753,7769,7773,
   7774,7775,7781,7782,7785,7786,7795,7796,7815,7816,7817,7823,
   7824,7827,7828,7837,7838,7974,7975,7985,7986,7995,7996,8012,
   8018,8019,8022,8023,8032,8033,8054,8055,8058,8059,8068,8069,
   8250,8253,8254,8263,8282,8283,8292,8364,8373,8374,8398,8399,
   8579,38205,38209,38210,38211,38217,38218,38221,38222,38231,
   38232,38251,38252,38253,38259,38260,38263,38264,38273,38274,
   38410,38411,38417,38418,38421,38422,38431,38432,38448,38454,
   38455,38458,38459,38468,38469,38490,38491,38494,38495,38504,
   38505,38686,38689,38690,38699,38700,38718,38719,38728,38729,
   38800,38809,38810,38834,38835,39015,39154,39155,39156,39162,
   39163,39166,39167,39176,39177,39313,39314,39320,39321,39324,
   39325,39334,39335,39351,39357,39358,39361,39362,39371,39372,
   39393,39394,39397,39398,39407,39408,39589,39592,39593,39602,
   39603,39621,39622,39631,39632,39703,39712,39713,39737,39738,
   39918,40174,40175,40181,40182,40185,40186,40195,40196,40212,
   40218,40219,40222,40223,40232,40233,40254,40255,40258,40259,
   40268,40269,40450,40453,40454,40463,40464,40482,40483,40492,
   40493,40564,40573,40574,40598,40599,40779,43256,43262,43263,
   43266,43267,43276,43277,43298,43299,43302,43303,43312,43313,
   43494,43497,43498,43507,43508,43526,43527,43536,43537,43608,
   43617,43618,43642,43643,43823,43964,43965,43968,43969,43978,
   43979,44160,44163,44164,44173,44174,44192,44193,44202,44203,
   44274,44283,44284,44308,44309,44489,44790,44793,44794,44803,
   44804,44822,44823,44832,44833,44904,44913,44914,44938,44939,
   45119,47902,47903,47912,47913,47984,47993,47994,48018,48019,
   48199,48390,48399,48400,48424,48425,48605,49478,49479,49659,
   49959],[3794,44204],
 [3506,3507,3514,3530,3787,3794,3830,3846,38448,38455,38471,
   38491,38507,38731,43965,43981,44205,44835],[3794,44206],
 [3794,44207],[3794,44208],[3794,44209],[3794,44210],
 [3794,44211],[3794,44212],[3794,44213],[3794,44214],
 [3794,44215],[3794,44216],[3794,44217],[3794,44218],
 [3507,41069],[3507,3677,3714,38331,38557,41850,42593],
 [3507,3930,38591,44695],
 [3507,3677,3714,38331,38557,41850,42593],
 [3507,3930,38591,44695],[3507,3756],[3507,3794,38455,43965],
 [3507],[3507],[3507,44904],[3507,44904],[3507,4193],
 [3507],[3507],[3507,38921],[3507,4193],[3507,38921],
 [3507,45084],[3507,45084],[3507,39015],[3507,39015],
 [3507],[3507],[3507],[3507],[3507],[3507],[3507],
 [3507],[3507],[3507],[3507],[3507],[3507],[3507],
 [3507],
 [3500,3501,3502,3503,3504,3507,3508,3509,3511,3544,3550,3592,
   3633,3634,3670,3673,3675,3677,3712,3714,3716,3824,3825,3827,
   3896,38205,38206,38207,38208,38211,38212,38213,38215,38248,
   38249,38250,38253,38254,38255,38257,38290,38291,38294,38295,
   38296,38298,38331,38334,38335,38336,38338,38373,38374,38375,
   38377,38485,38486,38488,38521,38523,38557,39151,39152,39153,
   39156,39157,39158,39160,39193,39194,39197,39198,39199,39201,
   39234,39237,39238,39239,39241,39276,39277,39278,39280,39388,
   39389,39391,39424,39426,39460,40054,40055,40058,40059,40060,
   40062,40095,40098,40099,40100,40102,40137,40138,40139,40141,
   40249,40250,40252,40285,40287,40321,40915,40918,40919,40920,
   40922,40957,40958,40959,40961,41069,41070,41072,41105,41107,
   41141,41737,41738,41739,41741,41849,41850,41852,41885,41887,
   41921,42590,42591,42593,42626,42628,42662,44625,44627,44661,
   45256],
 [3502,3505,3507,3508,3510,3512,3513,3633,3634,3750,3756,3824,
   3826,3828,3829,3930,38292,38294,38295,38297,38299,38300,
   38411,38412,38414,38416,38417,38485,38487,38489,38490,38522,
   38524,38525,38591,38592,38655,40995,40996,40998,41069,41071,
   41073,41074,41106,41108,41109,41175,41176,41239,43293,43295,
   43297,43298,43330,43332,43399,44626,44628,44629,44695,44696,
   44759,45290,45354,46443],
 [3500,3501,3502,3503,3504,3507,3508,3509,3511,3544,3550,3592,
   3633,3634,3670,3673,3675,3677,3712,3714,3716,3824,3825,3827,
   3896,38205,38206,38207,38208,38211,38212,38213,38215,38248,
   38249,38250,38253,38254,38255,38257,38290,38291,38294,38295,
   38296,38298,38331,38334,38335,38336,38338,38373,38374,38375,
   38377,38485,38486,38488,38521,38523,38557,39151,39152,39153,
   39156,39157,39158,39160,39193,39194,39197,39198,39199,39201,
   39234,39237,39238,39239,39241,39276,39277,39278,39280,39388,
   39389,39391,39424,39426,39460,40054,40055,40058,40059,40060,
   40062,40095,40098,40099,40100,40102,40137,40138,40139,40141,
   40249,40250,40252,40285,40287,40321,40915,40918,40919,40920,
   40922,40957,40958,40959,40961,41069,41070,41072,41105,41107,
   41141,41737,41738,41739,41741,41849,41850,41852,41885,41887,
   41921,42590,42591,42593,42626,42628,42662,44625,44627,44661,
   45256],
 [3502,3505,3507,3508,3510,3512,3513,3633,3634,3750,3756,3824,
   3826,3828,3829,3930,38292,38294,38295,38297,38299,38300,
   38411,38412,38414,38416,38417,38485,38487,38489,38490,38522,
   38524,38525,38591,38592,38655,40995,40996,40998,41069,41071,
   41073,41074,41106,41108,41109,41175,41176,41239,43293,43295,
   43297,43298,43330,43332,43399,44626,44628,44629,44695,44696,
   44759,45290,45354,46443],
 [3502,3505,3507,3508,3510,3512,3513,3633,3634,3750,3756,3824,
   3826,3828,3829,3930,38292,38294,38295,38297,38299,38300,
   38411,38412,38414,38416,38417,38485,38487,38489,38490,38522,
   38524,38525,38591,38592,38655,40995,40996,40998,41069,41071,
   41073,41074,41106,41108,41109,41175,41176,41239,43293,43295,
   43297,43298,43330,43332,43399,44626,44628,44629,44695,44696,
   44759,45290,45354,46443],
 [3502,3506,3507,3508,3514,3633,3634,3787,3794,3824,3830,38293,
   38294,38295,38301,38448,38449,38455,38485,38491,38526,41032,
   41033,41039,41069,41075,41110,43959,43965,44000,44630],
 [3502,3507,3508,3515,3633,3634,3824,3831,38294,38295,38302,
   38485,38492,38527,41069,41076,41111,44631],
 [3502,3507,3508,3516,3633,3634,3824,3832,38294,38295,38303,
   38485,38493,38528,41069,41077,41112,44632],
 [23,31,44,1291,1296,1297,1306,1307,1309,1432,1625,1658,3502,
   3507,3508,3517,3518,3520,3633,3634,3824,3833,3834,3836,4139,
   38294,38295,38304,38305,38307,38485,38494,38495,38497,38529,
   38530,38532,38800,38802,38827,41069,41078,41079,41081,41113,
   41114,41116,41384,41386,41411,44633,44634,44636,44904,44906,
   44931,45499,45501,45526,49471],
 [23,31,44,1291,1296,1297,1306,1307,1309,1432,1625,1658,3502,
   3507,3508,3517,3518,3520,3633,3634,3824,3833,3834,3836,4139,
   38294,38295,38304,38305,38307,38485,38494,38495,38497,38529,
   38530,38532,38800,38802,38827,41069,41078,41079,41081,41113,
   41114,41116,41384,41386,41411,44633,44634,44636,44904,44906,
   44931,45499,45501,45526,49471],
 [3502,3507,3508,3519,3523,3633,3634,3824,3835,3839,4193,38294,
   38295,38306,38310,38485,38496,38500,38531,38535,38854,41069,
   41080,41084,41115,41119,44635,44639,44958],
 [23,31,44,1291,1296,1297,1306,1307,1309,1432,1625,1658,3502,
   3507,3508,3517,3518,3520,3633,3634,3824,3833,3834,3836,4139,
   38294,38295,38304,38305,38307,38485,38494,38495,38497,38529,
   38530,38532,38800,38802,38827,41069,41078,41079,41081,41113,
   41114,41116,41384,41386,41411,44633,44634,44636,44904,44906,
   44931,45499,45501,45526,49471],
 [3502,3507,3508,3521,3633,3634,3824,3837,38294,38295,38308,
   38485,38498,38533,41069,41082,41117,44637],
 [3502,3507,3508,3522,3524,3633,3634,3824,3838,3840,4260,38294,
   38295,38309,38311,38485,38499,38501,38534,38536,38921,41069,
   41083,41085,41118,41120,41505,44638,44640,45025,45620],
 [3502,3507,3508,3519,3523,3633,3634,3824,3835,3839,4193,38294,
   38295,38306,38310,38485,38496,38500,38531,38535,38854,41069,
   41080,41084,41115,41119,44635,44639,44958],
 [3502,3507,3508,3522,3524,3633,3634,3824,3838,3840,4260,38294,
   38295,38309,38311,38485,38499,38501,38534,38536,38921,41069,
   41083,41085,41118,41120,41505,44638,44640,45025,45620],
 [3502,3507,3508,3525,3526,3633,3634,3824,3841,3842,4319,38294,
   38295,38312,38313,38485,38502,38503,38537,38538,38980,41069,
   41086,41087,41121,41122,41564,44641,44642,45084,45679],
 [3502,3507,3508,3525,3526,3633,3634,3824,3841,3842,4319,38294,
   38295,38312,38313,38485,38502,38503,38537,38538,38980,41069,
   41086,41087,41121,41122,41564,44641,44642,45084,45679],
 [3502,3507,3508,3527,3528,3633,3634,3824,3843,3844,4354,38294,
   38295,38314,38315,38485,38504,38505,38539,38540,39015,41069,
   41088,41089,41123,41124,41599,44643,44644,45119,45714],
 [3502,3507,3508,3527,3528,3633,3634,3824,3843,3844,4354,38294,
   38295,38314,38315,38485,38504,38505,38539,38540,39015,41069,
   41088,41089,41123,41124,41599,44643,44644,45119,45714],
 [3502,3507,3508,3529,3530,3633,3634,3824,3845,3846,38294,38295,
   38316,38317,38485,38506,38507,38541,38542,39046,41069,41090,
   41091,41125,41126,41630,44645,44646,45150,45745],
 [3502,3507,3508,3529,3530,3633,3634,3824,3845,3846,38294,38295,
   38316,38317,38485,38506,38507,38541,38542,39046,41069,41090,
   41091,41125,41126,41630,44645,44646,45150,45745],
 [3502,3507,3508,3531,3633,3634,3824,3847,38294,38295,38318,
   38485,38508,38543,41069,41092,41127,44647],
 [3502,3507,3508,3532,3633,3634,3824,3848,38294,38295,38319,
   38485,38509,38544,41069,41093,41128,44648],
 [3502,3507,3508,3533,3633,3634,3824,3849,38294,38295,38320,
   38485,38510,38545,41069,41094,41129,44649],
 [3502,3507,3508,3534,3536,3633,3634,3824,3850,3852,38294,38295,
   38321,38323,38485,38511,38513,38546,38548,39107,41069,41095,
   41097,41130,41132,41691,44650,44652,45211,45806],
 [3502,3507,3508,3535,3633,3634,3824,3851,38294,38295,38322,
   38485,38512,38547,41069,41096,41131,44651],
 [3502,3507,3508,3534,3536,3633,3634,3824,3850,3852,38294,38295,
   38321,38323,38485,38511,38513,38546,38548,39107,41069,41095,
   41097,41130,41132,41691,44650,44652,45211,45806],
 [3502,3507,3508,3537,3633,3634,3824,3853,38294,38295,38324,
   38485,38514,38549,41069,41098,41133,44653],
 [3502,3507,3508,3538,3633,3634,3824,3854,38294,38295,38325,
   38485,38515,38550,41069,41099,41134,44654],
 [3502,3507,3508,3539,3633,3634,3824,3855,38294,38295,38326,
   38485,38516,38551,41069,41100,41135,44655],
 [3502,3507,3508,3540,3633,3634,3824,3856,38294,38295,38327,
   38485,38517,38552,41069,41101,41136,44656],
 [3502,3507,3508,3541,3542,3633,3634,3824,3857,3858,38294,38295,
   38328,38329,38485,38518,38519,38553,38554,39148,41069,41102,
   41103,41137,41138,41732,44657,44658,45252,45847],
 [3502,3507,3508,3541,3542,3633,3634,3824,3857,3858,38294,38295,
   38328,38329,38485,38518,38519,38553,38554,39148,41069,41102,
   41103,41137,41138,41732,44657,44658,45252,45847],
 [3502,3507,3508,3543,3633,3634,3824,3859,38294,38295,38330,
   38485,38520,38555,41069,41104,41139,44659],
 [3714,3794,3930,42555,42556,42558,42560,42661,42663,42665,42696,
   42698,42761,44030,44032,44034,44065,44067,44130,45851,45853,
   45916,46444],[3507,3677,3714,38331,38557,41850,42593],
 [3714,3794,3930,42555,42556,42558,42560,42661,42663,42665,42696,
   42698,42761,44030,44032,44034,44065,44067,44130,45851,45853,
   45916,46444],[3714,3756,42518,42664],
 [3714,3794,3930,42555,42556,42558,42560,42661,42663,42665,42696,
   42698,42761,44030,44032,44034,44065,44067,44130,45851,45853,
   45916,46444],[3714,42666],[3714,42667],
 [3503,3504,3507,3509,3511,3517,3518,3522,3524,3670,3673,3675,
   3677,3712,3714,3716,3825,3827,3833,3834,3838,3840,3896,4139,
   4260,38331,38334,38336,38338,38344,38345,38349,38351,38373,
   38375,38377,38383,38384,38388,38390,38486,38488,38494,38495,
   38499,38501,38557,38563,38564,38568,38570,38628,38629,38633,
   38635,38800,38804,38806,38829,38831,38921,41737,41739,41741,
   41747,41748,41752,41754,41850,41852,41858,41859,41863,41865,
   41921,41927,41928,41932,41934,41992,41993,41997,41999,42164,
   42168,42170,42193,42195,42285,42591,42593,42599,42600,42604,
   42606,42662,42668,42669,42673,42675,42733,42734,42738,42740,
   42905,42909,42911,42934,42936,43026,44661,44667,44668,44672,
   44674,44732,44733,44737,44739,44904,44908,44910,44933,44935,
   45025,45888,45889,45893,45895,46060,46064,46066,46089,46091,
   46181,47084,47088,47090,47113,47115,47205,49473,49475,49565,
   49865],
 [3503,3504,3507,3509,3511,3517,3518,3522,3524,3670,3673,3675,
   3677,3712,3714,3716,3825,3827,3833,3834,3838,3840,3896,4139,
   4260,38331,38334,38336,38338,38344,38345,38349,38351,38373,
   38375,38377,38383,38384,38388,38390,38486,38488,38494,38495,
   38499,38501,38557,38563,38564,38568,38570,38628,38629,38633,
   38635,38800,38804,38806,38829,38831,38921,41737,41739,41741,
   41747,41748,41752,41754,41850,41852,41858,41859,41863,41865,
   41921,41927,41928,41932,41934,41992,41993,41997,41999,42164,
   42168,42170,42193,42195,42285,42591,42593,42599,42600,42604,
   42606,42662,42668,42669,42673,42675,42733,42734,42738,42740,
   42905,42909,42911,42934,42936,43026,44661,44667,44668,44672,
   44674,44732,44733,44737,44739,44904,44908,44910,44933,44935,
   45025,45888,45889,45893,45895,46060,46064,46066,46089,46091,
   46181,47084,47088,47090,47113,47115,47205,49473,49475,49565,
   49865],[3714,4193,42670,42674],[3714,42671],
 [3503,3504,3507,3509,3511,3521,3670,3673,3675,3677,3687,3712,
   3714,3716,3825,3827,3837,3896,3971,38331,38334,38336,38338,
   38348,38373,38375,38377,38387,38486,38488,38498,38557,38567,
   38632,41737,41739,41741,41751,41850,41852,41862,41921,41931,
   41996,42591,42593,42603,42662,42672,42737,44661,44671,44736,
   45892],
 [3503,3504,3507,3509,3511,3517,3518,3522,3524,3670,3673,3675,
   3677,3712,3714,3716,3825,3827,3833,3834,3838,3840,3896,4139,
   4260,38331,38334,38336,38338,38344,38345,38349,38351,38373,
   38375,38377,38383,38384,38388,38390,38486,38488,38494,38495,
   38499,38501,38557,38563,38564,38568,38570,38628,38629,38633,
   38635,38800,38804,38806,38829,38831,38921,41737,41739,41741,
   41747,41748,41752,41754,41850,41852,41858,41859,41863,41865,
   41921,41927,41928,41932,41934,41992,41993,41997,41999,42164,
   42168,42170,42193,42195,42285,42591,42593,42599,42600,42604,
   42606,42662,42668,42669,42673,42675,42733,42734,42738,42740,
   42905,42909,42911,42934,42936,43026,44661,44667,44668,44672,
   44674,44732,44733,44737,44739,44904,44908,44910,44933,44935,
   45025,45888,45889,45893,45895,46060,46064,46066,46089,46091,
   46181,47084,47088,47090,47113,47115,47205,49473,49475,49565,
   49865],[3714,4193,42670,42674],
 [3503,3504,3507,3509,3511,3517,3518,3522,3524,3670,3673,3675,
   3677,3712,3714,3716,3825,3827,3833,3834,3838,3840,3896,4139,
   4260,38331,38334,38336,38338,38344,38345,38349,38351,38373,
   38375,38377,38383,38384,38388,38390,38486,38488,38494,38495,
   38499,38501,38557,38563,38564,38568,38570,38628,38629,38633,
   38635,38800,38804,38806,38829,38831,38921,41737,41739,41741,
   41747,41748,41752,41754,41850,41852,41858,41859,41863,41865,
   41921,41927,41928,41932,41934,41992,41993,41997,41999,42164,
   42168,42170,42193,42195,42285,42591,42593,42599,42600,42604,
   42606,42662,42668,42669,42673,42675,42733,42734,42738,42740,
   42905,42909,42911,42934,42936,43026,44661,44667,44668,44672,
   44674,44732,44733,44737,44739,44904,44908,44910,44933,44935,
   45025,45888,45889,45893,45895,46060,46064,46066,46089,46091,
   46181,47084,47088,47090,47113,47115,47205,49473,49475,49565,
   49865],
 [3503,3504,3507,3509,3511,3525,3526,3527,3528,3670,3673,3675,
   3677,3712,3714,3716,3825,3827,3841,3842,3843,3844,3896,4319,
   4354,38331,38334,38336,38338,38352,38353,38354,38355,38373,
   38375,38377,38391,38392,38393,38394,38486,38488,38502,38503,
   38504,38505,38557,38571,38572,38573,38574,38636,38637,38638,
   38639,38980,38981,38982,38998,38999,39015,41737,41739,41741,
   41755,41756,41757,41758,41850,41852,41866,41867,41868,41869,
   41921,41935,41936,41937,41938,42000,42001,42002,42003,42344,
   42345,42346,42362,42363,42379,42591,42593,42607,42608,42609,
   42610,42662,42676,42677,42678,42679,42741,42742,42743,42744,
   43085,43086,43087,43103,43104,43120,44661,44675,44676,44677,
   44678,44740,44741,44742,44743,45084,45085,45086,45102,45103,
   45119,45896,45897,45898,45899,46240,46241,46242,46258,46259,
   46275,47264,47265,47266,47282,47283,47299,51426,51427,51443,
   51579],
 [3503,3504,3507,3509,3511,3525,3526,3527,3528,3670,3673,3675,
   3677,3712,3714,3716,3825,3827,3841,3842,3843,3844,3896,4319,
   4354,38331,38334,38336,38338,38352,38353,38354,38355,38373,
   38375,38377,38391,38392,38393,38394,38486,38488,38502,38503,
   38504,38505,38557,38571,38572,38573,38574,38636,38637,38638,
   38639,38980,38981,38982,38998,38999,39015,41737,41739,41741,
   41755,41756,41757,41758,41850,41852,41866,41867,41868,41869,
   41921,41935,41936,41937,41938,42000,42001,42002,42003,42344,
   42345,42346,42362,42363,42379,42591,42593,42607,42608,42609,
   42610,42662,42676,42677,42678,42679,42741,42742,42743,42744,
   43085,43086,43087,43103,43104,43120,44661,44675,44676,44677,
   44678,44740,44741,44742,44743,45084,45085,45086,45102,45103,
   45119,45896,45897,45898,45899,46240,46241,46242,46258,46259,
   46275,47264,47265,47266,47282,47283,47299,51426,51427,51443,
   51579],
 [3503,3504,3507,3509,3511,3525,3526,3527,3528,3670,3673,3675,
   3677,3712,3714,3716,3825,3827,3841,3842,3843,3844,3896,4319,
   4354,38331,38334,38336,38338,38352,38353,38354,38355,38373,
   38375,38377,38391,38392,38393,38394,38486,38488,38502,38503,
   38504,38505,38557,38571,38572,38573,38574,38636,38637,38638,
   38639,38980,38981,38982,38998,38999,39015,41737,41739,41741,
   41755,41756,41757,41758,41850,41852,41866,41867,41868,41869,
   41921,41935,41936,41937,41938,42000,42001,42002,42003,42344,
   42345,42346,42362,42363,42379,42591,42593,42607,42608,42609,
   42610,42662,42676,42677,42678,42679,42741,42742,42743,42744,
   43085,43086,43087,43103,43104,43120,44661,44675,44676,44677,
   44678,44740,44741,44742,44743,45084,45085,45086,45102,45103,
   45119,45896,45897,45898,45899,46240,46241,46242,46258,46259,
   46275,47264,47265,47266,47282,47283,47299,51426,51427,51443,
   51579],
 [3503,3504,3507,3509,3511,3525,3526,3527,3528,3670,3673,3675,
   3677,3712,3714,3716,3825,3827,3841,3842,3843,3844,3896,4319,
   4354,38331,38334,38336,38338,38352,38353,38354,38355,38373,
   38375,38377,38391,38392,38393,38394,38486,38488,38502,38503,
   38504,38505,38557,38571,38572,38573,38574,38636,38637,38638,
   38639,38980,38981,38982,38998,38999,39015,41737,41739,41741,
   41755,41756,41757,41758,41850,41852,41866,41867,41868,41869,
   41921,41935,41936,41937,41938,42000,42001,42002,42003,42344,
   42345,42346,42362,42363,42379,42591,42593,42607,42608,42609,
   42610,42662,42676,42677,42678,42679,42741,42742,42743,42744,
   43085,43086,43087,43103,43104,43120,44661,44675,44676,44677,
   44678,44740,44741,44742,44743,45084,45085,45086,45102,45103,
   45119,45896,45897,45898,45899,46240,46241,46242,46258,46259,
   46275,47264,47265,47266,47282,47283,47299,51426,51427,51443,
   51579],[3714,42680],
 [3503,3504,3507,3509,3511,3530,3670,3673,3675,3677,3696,3712,
   3714,3716,3825,3827,3846,3896,3980,38331,38334,38336,38338,
   38357,38373,38375,38377,38396,38486,38488,38507,38557,38576,
   38641,41737,41739,41741,41760,41850,41852,41871,41921,41940,
   42005,42591,42593,42612,42662,42681,42746,44661,44680,44745,
   45901],[3714,42682],[3714,42683],[3714,42684],
 [3503,3504,3507,3509,3511,3534,3670,3673,3675,3677,3700,3712,
   3714,3716,3825,3827,3850,3896,3984,38331,38334,38336,38338,
   38361,38373,38375,38377,38400,38486,38488,38511,38557,38580,
   38645,41737,41739,41741,41764,41850,41852,41875,41921,41944,
   42009,42591,42593,42616,42662,42685,42750,44661,44684,44749,
   45905],[3714,42686],[3714,42687],[3714,42688],
 [3714,42689],[3714,42690],[3714,42691],[3714,42692],
 [3503,3504,3507,3509,3511,3542,3670,3673,3675,3677,3708,3712,
   3714,3716,3825,3827,3858,3896,3992,38331,38334,38336,38338,
   38369,38373,38375,38377,38408,38486,38488,38519,38557,38588,
   38653,41737,41739,41741,41772,41850,41852,41883,41921,41952,
   42017,42591,42593,42624,42662,42693,42758,44661,44692,44757,
   45913],[3714,42694],[3677,3930,41954,41955,41987,46411],
 [],[3502,3505,3507,3508,3510,3512,3513,3633,3634,3750,3756,
   3824,3826,3828,3829,3930,38292,38294,38295,38297,38299,38300,
   38411,38412,38414,38416,38417,38485,38487,38489,38490,38522,
   38524,38525,38591,38592,38655,40995,40996,40998,41069,41071,
   41073,41074,41106,41108,41109,41175,41176,41239,43293,43295,
   43297,43298,43330,43332,43399,44626,44628,44629,44695,44696,
   44759,45290,45354,46443],
 [3714,3794,3930,42555,42556,42558,42560,42661,42663,42665,42696,
   42698,42761,44030,44032,44034,44065,44067,44130,45851,45853,
   45916,46444],[3930,46445],[3930,46446],
 [3507,3510,3512,3517,3518,3519,3523,3826,3828,3833,3834,3835,
   3839,3930,4139,4193,38487,38489,38494,38495,38496,38500,
   38591,38596,38597,38598,38602,38659,38660,38661,38665,38800,
   38801,38805,38826,38830,38854,44695,44700,44701,44702,44706,
   44763,44764,44765,44769,44904,44905,44909,44930,44934,44958,
   46447,46448,46449,46453,46588,46593,46614,46618,47549,47550,
   47554,47575,49470,49474],
 [3507,3510,3512,3517,3518,3519,3523,3826,3828,3833,3834,3835,
   3839,3930,4139,4193,38487,38489,38494,38495,38496,38500,
   38591,38596,38597,38598,38602,38659,38660,38661,38665,38800,
   38801,38805,38826,38830,38854,44695,44700,44701,44702,44706,
   44763,44764,44765,44769,44904,44905,44909,44930,44934,44958,
   46447,46448,46449,46453,46588,46593,46614,46618,47549,47550,
   47554,47575,49470,49474],
 [3507,3510,3512,3517,3518,3519,3523,3826,3828,3833,3834,3835,
   3839,3930,4139,4193,38487,38489,38494,38495,38496,38500,
   38591,38596,38597,38598,38602,38659,38660,38661,38665,38800,
   38801,38805,38826,38830,38854,44695,44700,44701,44702,44706,
   44763,44764,44765,44769,44904,44905,44909,44930,44934,44958,
   46447,46448,46449,46453,46588,46593,46614,46618,47549,47550,
   47554,47575,49470,49474],[3930,46450],[3930,46451],
 [3507,3510,3512,3522,3524,3826,3828,3838,3840,3930,4260,38487,
   38489,38499,38501,38591,38601,38603,38664,38666,38921,44695,
   44705,44707,44768,44770,45025,46452,46454,46709,47670],
 [3507,3510,3512,3517,3518,3519,3523,3826,3828,3833,3834,3835,
   3839,3930,4139,4193,38487,38489,38494,38495,38496,38500,
   38591,38596,38597,38598,38602,38659,38660,38661,38665,38800,
   38801,38805,38826,38830,38854,44695,44700,44701,44702,44706,
   44763,44764,44765,44769,44904,44905,44909,44930,44934,44958,
   46447,46448,46449,46453,46588,46593,46614,46618,47549,47550,
   47554,47575,49470,49474],
 [3507,3510,3512,3522,3524,3826,3828,3838,3840,3930,4260,38487,
   38489,38499,38501,38591,38601,38603,38664,38666,38921,44695,
   44705,44707,44768,44770,45025,46452,46454,46709,47670],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,
   2384,3500,3501,3507,3510,3512,3517,3518,3519,3523,3525,3526,
   3544,3550,3553,3555,3560,3561,3562,3566,3568,3569,3592,3595,
   3597,3602,3603,3604,3608,3610,3611,3826,3828,3833,3834,3835,
   3839,3841,3842,3930,3935,3936,3937,3941,3998,3999,4000,4004,
   4139,4140,4144,4146,4147,4165,4169,4171,4172,4193,4195,4196,
   4281,4282,4319,4510,4511,4512,4518,4528,4529,5645,5646,5652,
   5655,5657,5662,5663,5664,5668,5670,5671,5689,5695,5698,5700,
   5705,5706,5707,5711,5713,5714,5737,5740,5742,5747,5748,5749,
   5753,5755,5756,5971,5973,5978,5979,5980,5984,5986,5987,6075,
   6080,6081,6086,6089,6143,6144,6145,6149,6151,6152,6284,6285,
   6289,6291,6292,6310,6314,6316,6317,6340,6341,6427,6464,7725,
   7726,7732,7735,7737,7742,7743,7744,7748,7750,7751,7769,7775,
   7778,7780,7785,7786,7787,7791,7793,7794,7817,7820,7822,7827,
   7828,7829,7833,7835,7836,8051,8053,8058,8059,8060,8064,8066,
   8067,8155,8160,8161,8162,8166,8168,8169,8223,8224,8225,8231,
   8364,8365,8369,8371,8372,8390,8394,8396,8397,8420,8506,8507,
   8544,38205,38211,38214,38216,38221,38222,38223,38227,38229,
   38230,38253,38256,38258,38263,38264,38265,38269,38271,38272,
   38487,38489,38494,38495,38496,38500,38502,38503,38591,38596,
   38597,38598,38602,38604,38605,38659,38660,38661,38665,38667,
   38668,38800,38801,38805,38807,38808,38826,38830,38832,38833,
   38854,38856,38857,38942,38943,38980,39156,39159,39161,39166,
   39167,39168,39172,39174,39175,39390,39392,39397,39398,39399,
   39403,39405,39406,39494,39499,39500,39501,39505,39507,39508,
   39562,39563,39564,39568,39570,39571,39703,39704,39708,39710,
   39711,39729,39733,39735,39736,39757,39759,39760,39845,39846,
   39883,40251,40253,40258,40259,40260,40264,40266,40267,40355,
   40360,40361,40362,40366,40368,40369,40423,40424,40425,40429,
   40431,40432,40564,40565,40569,40571,40572,40590,40594,40596,
   40597,40618,40620,40621,40706,40707,40744,44695,44700,44701,
   44702,44706,44708,44709,44763,44764,44765,44769,44771,44772,
   44904,44905,44909,44911,44912,44930,44934,44936,44937,44958,
   44960,44961,45046,45047,45084,46447,46448,46449,46453,46455,
   46456,46588,46589,46593,46595,46596,46614,46618,46620,46621,
   46642,46644,46645,46730,46731,46768,47549,47550,47554,47556,
   47557,47575,47579,47581,47582,47603,47605,47606,47691,47692,
   47729,49470,49474,49476,49477,49498,49500,49501,49586,49587,
   49624,49798,49800,49801,49886,49887,49924,50162,50163,50200,
   51084],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,
   2384,3500,3501,3507,3510,3512,3517,3518,3519,3523,3525,3526,
   3544,3550,3553,3555,3560,3561,3562,3566,3568,3569,3592,3595,
   3597,3602,3603,3604,3608,3610,3611,3826,3828,3833,3834,3835,
   3839,3841,3842,3930,3935,3936,3937,3941,3998,3999,4000,4004,
   4139,4140,4144,4146,4147,4165,4169,4171,4172,4193,4195,4196,
   4281,4282,4319,4510,4511,4512,4518,4528,4529,5645,5646,5652,
   5655,5657,5662,5663,5664,5668,5670,5671,5689,5695,5698,5700,
   5705,5706,5707,5711,5713,5714,5737,5740,5742,5747,5748,5749,
   5753,5755,5756,5971,5973,5978,5979,5980,5984,5986,5987,6075,
   6080,6081,6086,6089,6143,6144,6145,6149,6151,6152,6284,6285,
   6289,6291,6292,6310,6314,6316,6317,6340,6341,6427,6464,7725,
   7726,7732,7735,7737,7742,7743,7744,7748,7750,7751,7769,7775,
   7778,7780,7785,7786,7787,7791,7793,7794,7817,7820,7822,7827,
   7828,7829,7833,7835,7836,8051,8053,8058,8059,8060,8064,8066,
   8067,8155,8160,8161,8162,8166,8168,8169,8223,8224,8225,8231,
   8364,8365,8369,8371,8372,8390,8394,8396,8397,8420,8506,8507,
   8544,38205,38211,38214,38216,38221,38222,38223,38227,38229,
   38230,38253,38256,38258,38263,38264,38265,38269,38271,38272,
   38487,38489,38494,38495,38496,38500,38502,38503,38591,38596,
   38597,38598,38602,38604,38605,38659,38660,38661,38665,38667,
   38668,38800,38801,38805,38807,38808,38826,38830,38832,38833,
   38854,38856,38857,38942,38943,38980,39156,39159,39161,39166,
   39167,39168,39172,39174,39175,39390,39392,39397,39398,39399,
   39403,39405,39406,39494,39499,39500,39501,39505,39507,39508,
   39562,39563,39564,39568,39570,39571,39703,39704,39708,39710,
   39711,39729,39733,39735,39736,39757,39759,39760,39845,39846,
   39883,40251,40253,40258,40259,40260,40264,40266,40267,40355,
   40360,40361,40362,40366,40368,40369,40423,40424,40425,40429,
   40431,40432,40564,40565,40569,40571,40572,40590,40594,40596,
   40597,40618,40620,40621,40706,40707,40744,44695,44700,44701,
   44702,44706,44708,44709,44763,44764,44765,44769,44771,44772,
   44904,44905,44909,44911,44912,44930,44934,44936,44937,44958,
   44960,44961,45046,45047,45084,46447,46448,46449,46453,46455,
   46456,46588,46589,46593,46595,46596,46614,46618,46620,46621,
   46642,46644,46645,46730,46731,46768,47549,47550,47554,47556,
   47557,47575,47579,47581,47582,47603,47605,47606,47691,47692,
   47729,49470,49474,49476,49477,49498,49500,49501,49586,49587,
   49624,49798,49800,49801,49886,49887,49924,50162,50163,50200,
   51084],
 [3507,3510,3512,3527,3528,3826,3828,3843,3844,3930,4354,38487,
   38489,38504,38505,38591,38606,38607,38669,38670,39015,44695,
   44710,44711,44773,44774,45119,46457,46458,46803,47764],
 [3507,3510,3512,3527,3528,3826,3828,3843,3844,3930,4354,38487,
   38489,38504,38505,38591,38606,38607,38669,38670,39015,44695,
   44710,44711,44773,44774,45119,46457,46458,46803,47764],
 [3930,46459],[3930,46460],[3930,46461],[3930,46462],
 [3930,46463],[3930,46464],[3930,46465],[3930,46466],
 [3930,46467],[3930,46468],[3930,46469],[3930,46470],
 [3930,46471],[3930,46472],[3930,46473],
 [3677,3930,41954,41955,41987,46411],
 [3503,3504,3505,3507,3509,3511,3513,3670,3673,3675,3677,3710,
   3712,3714,3716,3718,3750,3752,3756,3825,3827,3829,3896,3898,
   38331,38332,38334,38336,38338,38340,38371,38373,38375,38377,
   38379,38411,38413,38415,38417,38486,38488,38490,38557,38559,
   38624,41735,41737,41739,41741,41743,41775,41777,41779,41850,
   41852,41854,41921,41923,41988,42516,42518,42520,42522,42591,
   42593,42595,42662,42664,42729,43294,43296,43298,43365,43367,
   44661,44663,44728,45884],[3677,3794,41816,41819,41989,44099]
  ,[3677,41990,41991,42109,47029],
 [3677,41990,41991,42109,47029],
 [3503,3504,3507,3509,3511,3517,3518,3522,3524,3670,3673,3675,
   3677,3712,3714,3716,3825,3827,3833,3834,3838,3840,3896,4139,
   4260,38331,38334,38336,38338,38344,38345,38349,38351,38373,
   38375,38377,38383,38384,38388,38390,38486,38488,38494,38495,
   38499,38501,38557,38563,38564,38568,38570,38628,38629,38633,
   38635,38800,38804,38806,38829,38831,38921,41737,41739,41741,
   41747,41748,41752,41754,41850,41852,41858,41859,41863,41865,
   41921,41927,41928,41932,41934,41992,41993,41997,41999,42164,
   42168,42170,42193,42195,42285,42591,42593,42599,42600,42604,
   42606,42662,42668,42669,42673,42675,42733,42734,42738,42740,
   42905,42909,42911,42934,42936,43026,44661,44667,44668,44672,
   44674,44732,44733,44737,44739,44904,44908,44910,44933,44935,
   45025,45888,45889,45893,45895,46060,46064,46066,46089,46091,
   46181,47084,47088,47090,47113,47115,47205,49473,49475,49565,
   49865],
 [3503,3504,3507,3509,3511,3517,3518,3522,3524,3670,3673,3675,
   3677,3712,3714,3716,3825,3827,3833,3834,3838,3840,3896,4139,
   4260,38331,38334,38336,38338,38344,38345,38349,38351,38373,
   38375,38377,38383,38384,38388,38390,38486,38488,38494,38495,
   38499,38501,38557,38563,38564,38568,38570,38628,38629,38633,
   38635,38800,38804,38806,38829,38831,38921,41737,41739,41741,
   41747,41748,41752,41754,41850,41852,41858,41859,41863,41865,
   41921,41927,41928,41932,41934,41992,41993,41997,41999,42164,
   42168,42170,42193,42195,42285,42591,42593,42599,42600,42604,
   42606,42662,42668,42669,42673,42675,42733,42734,42738,42740,
   42905,42909,42911,42934,42936,43026,44661,44667,44668,44672,
   44674,44732,44733,44737,44739,44904,44908,44910,44933,44935,
   45025,45888,45889,45893,45895,46060,46064,46066,46089,46091,
   46181,47084,47088,47090,47113,47115,47205,49473,49475,49565,
   49865],
 [3503,3504,3507,3509,3511,3519,3523,3670,3673,3675,3677,3712,
   3714,3716,3724,3728,3825,3827,3835,3839,3896,3904,3908,4193,
   38331,38334,38336,38338,38346,38350,38373,38375,38377,38385,
   38389,38486,38488,38496,38500,38557,38565,38569,38630,38634,
   38854,41737,41739,41741,41749,41753,41850,41852,41860,41864,
   41921,41929,41933,41994,41998,42591,42593,42601,42605,42662,
   42670,42674,42735,42739,42959,44661,44669,44673,44734,44738,
   44958,45890,45894,46114],[3677,41995],[3677,41996],
 [3503,3504,3507,3509,3511,3517,3518,3522,3524,3670,3673,3675,
   3677,3712,3714,3716,3825,3827,3833,3834,3838,3840,3896,4139,
   4260,38331,38334,38336,38338,38344,38345,38349,38351,38373,
   38375,38377,38383,38384,38388,38390,38486,38488,38494,38495,
   38499,38501,38557,38563,38564,38568,38570,38628,38629,38633,
   38635,38800,38804,38806,38829,38831,38921,41737,41739,41741,
   41747,41748,41752,41754,41850,41852,41858,41859,41863,41865,
   41921,41927,41928,41932,41934,41992,41993,41997,41999,42164,
   42168,42170,42193,42195,42285,42591,42593,42599,42600,42604,
   42606,42662,42668,42669,42673,42675,42733,42734,42738,42740,
   42905,42909,42911,42934,42936,43026,44661,44667,44668,44672,
   44674,44732,44733,44737,44739,44904,44908,44910,44933,44935,
   45025,45888,45889,45893,45895,46060,46064,46066,46089,46091,
   46181,47084,47088,47090,47113,47115,47205,49473,49475,49565,
   49865],
 [3503,3504,3507,3509,3511,3519,3523,3670,3673,3675,3677,3712,
   3714,3716,3724,3728,3825,3827,3835,3839,3896,3904,3908,4193,
   38331,38334,38336,38338,38346,38350,38373,38375,38377,38385,
   38389,38486,38488,38496,38500,38557,38565,38569,38630,38634,
   38854,41737,41739,41741,41749,41753,41850,41852,41860,41864,
   41921,41929,41933,41994,41998,42591,42593,42601,42605,42662,
   42670,42674,42735,42739,42959,44661,44669,44673,44734,44738,
   44958,45890,45894,46114],
 [3503,3504,3507,3509,3511,3517,3518,3522,3524,3670,3673,3675,
   3677,3712,3714,3716,3825,3827,3833,3834,3838,3840,3896,4139,
   4260,38331,38334,38336,38338,38344,38345,38349,38351,38373,
   38375,38377,38383,38384,38388,38390,38486,38488,38494,38495,
   38499,38501,38557,38563,38564,38568,38570,38628,38629,38633,
   38635,38800,38804,38806,38829,38831,38921,41737,41739,41741,
   41747,41748,41752,41754,41850,41852,41858,41859,41863,41865,
   41921,41927,41928,41932,41934,41992,41993,41997,41999,42164,
   42168,42170,42193,42195,42285,42591,42593,42599,42600,42604,
   42606,42662,42668,42669,42673,42675,42733,42734,42738,42740,
   42905,42909,42911,42934,42936,43026,44661,44667,44668,44672,
   44674,44732,44733,44737,44739,44904,44908,44910,44933,44935,
   45025,45888,45889,45893,45895,46060,46064,46066,46089,46091,
   46181,47084,47088,47090,47113,47115,47205,49473,49475,49565,
   49865],
 [3503,3504,3507,3509,3511,3525,3526,3527,3528,3670,3673,3675,
   3677,3712,3714,3716,3825,3827,3841,3842,3843,3844,3896,4319,
   4354,38331,38334,38336,38338,38352,38353,38354,38355,38373,
   38375,38377,38391,38392,38393,38394,38486,38488,38502,38503,
   38504,38505,38557,38571,38572,38573,38574,38636,38637,38638,
   38639,38980,38981,38982,38998,38999,39015,41737,41739,41741,
   41755,41756,41757,41758,41850,41852,41866,41867,41868,41869,
   41921,41935,41936,41937,41938,42000,42001,42002,42003,42344,
   42345,42346,42362,42363,42379,42591,42593,42607,42608,42609,
   42610,42662,42676,42677,42678,42679,42741,42742,42743,42744,
   43085,43086,43087,43103,43104,43120,44661,44675,44676,44677,
   44678,44740,44741,44742,44743,45084,45085,45086,45102,45103,
   45119,45896,45897,45898,45899,46240,46241,46242,46258,46259,
   46275,47264,47265,47266,47282,47283,47299,51426,51427,51443,
   51579],
 [3503,3504,3507,3509,3511,3525,3526,3527,3528,3670,3673,3675,
   3677,3712,3714,3716,3825,3827,3841,3842,3843,3844,3896,4319,
   4354,38331,38334,38336,38338,38352,38353,38354,38355,38373,
   38375,38377,38391,38392,38393,38394,38486,38488,38502,38503,
   38504,38505,38557,38571,38572,38573,38574,38636,38637,38638,
   38639,38980,38981,38982,38998,38999,39015,41737,41739,41741,
   41755,41756,41757,41758,41850,41852,41866,41867,41868,41869,
   41921,41935,41936,41937,41938,42000,42001,42002,42003,42344,
   42345,42346,42362,42363,42379,42591,42593,42607,42608,42609,
   42610,42662,42676,42677,42678,42679,42741,42742,42743,42744,
   43085,43086,43087,43103,43104,43120,44661,44675,44676,44677,
   44678,44740,44741,44742,44743,45084,45085,45086,45102,45103,
   45119,45896,45897,45898,45899,46240,46241,46242,46258,46259,
   46275,47264,47265,47266,47282,47283,47299,51426,51427,51443,
   51579],
 [3503,3504,3507,3509,3511,3525,3526,3527,3528,3670,3673,3675,
   3677,3712,3714,3716,3825,3827,3841,3842,3843,3844,3896,4319,
   4354,38331,38334,38336,38338,38352,38353,38354,38355,38373,
   38375,38377,38391,38392,38393,38394,38486,38488,38502,38503,
   38504,38505,38557,38571,38572,38573,38574,38636,38637,38638,
   38639,38980,38981,38982,38998,38999,39015,41737,41739,41741,
   41755,41756,41757,41758,41850,41852,41866,41867,41868,41869,
   41921,41935,41936,41937,41938,42000,42001,42002,42003,42344,
   42345,42346,42362,42363,42379,42591,42593,42607,42608,42609,
   42610,42662,42676,42677,42678,42679,42741,42742,42743,42744,
   43085,43086,43087,43103,43104,43120,44661,44675,44676,44677,
   44678,44740,44741,44742,44743,45084,45085,45086,45102,45103,
   45119,45896,45897,45898,45899,46240,46241,46242,46258,46259,
   46275,47264,47265,47266,47282,47283,47299,51426,51427,51443,
   51579],
 [3503,3504,3507,3509,3511,3525,3526,3527,3528,3670,3673,3675,
   3677,3712,3714,3716,3825,3827,3841,3842,3843,3844,3896,4319,
   4354,38331,38334,38336,38338,38352,38353,38354,38355,38373,
   38375,38377,38391,38392,38393,38394,38486,38488,38502,38503,
   38504,38505,38557,38571,38572,38573,38574,38636,38637,38638,
   38639,38980,38981,38982,38998,38999,39015,41737,41739,41741,
   41755,41756,41757,41758,41850,41852,41866,41867,41868,41869,
   41921,41935,41936,41937,41938,42000,42001,42002,42003,42344,
   42345,42346,42362,42363,42379,42591,42593,42607,42608,42609,
   42610,42662,42676,42677,42678,42679,42741,42742,42743,42744,
   43085,43086,43087,43103,43104,43120,44661,44675,44676,44677,
   44678,44740,44741,44742,44743,45084,45085,45086,45102,45103,
   45119,45896,45897,45898,45899,46240,46241,46242,46258,46259,
   46275,47264,47265,47266,47282,47283,47299,51426,51427,51443,
   51579],[3677,42004,42006,42411,47331],[3677,42005],
 [3677,42004,42006,42411,47331],[3677,42007,42008,42449,47369],
 [3677,42007,42008,42449,47369],[3677,42009],
 [3677,42010,42011,42479,47399],[3677,42010,42011,42479,47399],
 [3677,42012,42013,42494,47414],[3677,42012,42013,42494,47414],
 [3677,42014],[3677,42015],[3677,42016,42018,42513,47433],
 [3677,42017],[3677,42016,42018,42513,47433],
 [3502,3505,3507,3508,3510,3512,3513,3633,3634,3750,3756,3824,
   3826,3828,3829,3930,38292,38294,38295,38297,38299,38300,
   38411,38412,38414,38416,38417,38485,38487,38489,38490,38522,
   38524,38525,38591,38592,38655,40995,40996,40998,41069,41071,
   41073,41074,41106,41108,41109,41175,41176,41239,43293,43295,
   43297,43298,43330,43332,43399,44626,44628,44629,44695,44696,
   44759,45290,45354,46443],
 [3714,3794,3930,42555,42556,42558,42560,42661,42663,42665,42696,
   42698,42761,44030,44032,44034,44065,44067,44130,45851,45853,
   45916,46444],[3930,46445],[3930,46446],
 [3507,3510,3512,3517,3518,3519,3523,3826,3828,3833,3834,3835,
   3839,3930,4139,4193,38487,38489,38494,38495,38496,38500,
   38591,38596,38597,38598,38602,38659,38660,38661,38665,38800,
   38801,38805,38826,38830,38854,44695,44700,44701,44702,44706,
   44763,44764,44765,44769,44904,44905,44909,44930,44934,44958,
   46447,46448,46449,46453,46588,46593,46614,46618,47549,47550,
   47554,47575,49470,49474],
 [3507,3510,3512,3517,3518,3519,3523,3826,3828,3833,3834,3835,
   3839,3930,4139,4193,38487,38489,38494,38495,38496,38500,
   38591,38596,38597,38598,38602,38659,38660,38661,38665,38800,
   38801,38805,38826,38830,38854,44695,44700,44701,44702,44706,
   44763,44764,44765,44769,44904,44905,44909,44930,44934,44958,
   46447,46448,46449,46453,46588,46593,46614,46618,47549,47550,
   47554,47575,49470,49474],
 [3507,3510,3512,3517,3518,3519,3523,3826,3828,3833,3834,3835,
   3839,3930,4139,4193,38487,38489,38494,38495,38496,38500,
   38591,38596,38597,38598,38602,38659,38660,38661,38665,38800,
   38801,38805,38826,38830,38854,44695,44700,44701,44702,44706,
   44763,44764,44765,44769,44904,44905,44909,44930,44934,44958,
   46447,46448,46449,46453,46588,46593,46614,46618,47549,47550,
   47554,47575,49470,49474],[3930,46450],[3930,46451],
 [3507,3510,3512,3522,3524,3826,3828,3838,3840,3930,4260,38487,
   38489,38499,38501,38591,38601,38603,38664,38666,38921,44695,
   44705,44707,44768,44770,45025,46452,46454,46709,47670],
 [3507,3510,3512,3517,3518,3519,3523,3826,3828,3833,3834,3835,
   3839,3930,4139,4193,38487,38489,38494,38495,38496,38500,
   38591,38596,38597,38598,38602,38659,38660,38661,38665,38800,
   38801,38805,38826,38830,38854,44695,44700,44701,44702,44706,
   44763,44764,44765,44769,44904,44905,44909,44930,44934,44958,
   46447,46448,46449,46453,46588,46593,46614,46618,47549,47550,
   47554,47575,49470,49474],
 [3507,3510,3512,3522,3524,3826,3828,3838,3840,3930,4260,38487,
   38489,38499,38501,38591,38601,38603,38664,38666,38921,44695,
   44705,44707,44768,44770,45025,46452,46454,46709,47670],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,
   2384,3500,3501,3507,3510,3512,3517,3518,3519,3523,3525,3526,
   3544,3550,3553,3555,3560,3561,3562,3566,3568,3569,3592,3595,
   3597,3602,3603,3604,3608,3610,3611,3826,3828,3833,3834,3835,
   3839,3841,3842,3930,3935,3936,3937,3941,3998,3999,4000,4004,
   4139,4140,4144,4146,4147,4165,4169,4171,4172,4193,4195,4196,
   4281,4282,4319,4510,4511,4512,4518,4528,4529,5645,5646,5652,
   5655,5657,5662,5663,5664,5668,5670,5671,5689,5695,5698,5700,
   5705,5706,5707,5711,5713,5714,5737,5740,5742,5747,5748,5749,
   5753,5755,5756,5971,5973,5978,5979,5980,5984,5986,5987,6075,
   6080,6081,6086,6089,6143,6144,6145,6149,6151,6152,6284,6285,
   6289,6291,6292,6310,6314,6316,6317,6340,6341,6427,6464,7725,
   7726,7732,7735,7737,7742,7743,7744,7748,7750,7751,7769,7775,
   7778,7780,7785,7786,7787,7791,7793,7794,7817,7820,7822,7827,
   7828,7829,7833,7835,7836,8051,8053,8058,8059,8060,8064,8066,
   8067,8155,8160,8161,8162,8166,8168,8169,8223,8224,8225,8231,
   8364,8365,8369,8371,8372,8390,8394,8396,8397,8420,8506,8507,
   8544,38205,38211,38214,38216,38221,38222,38223,38227,38229,
   38230,38253,38256,38258,38263,38264,38265,38269,38271,38272,
   38487,38489,38494,38495,38496,38500,38502,38503,38591,38596,
   38597,38598,38602,38604,38605,38659,38660,38661,38665,38667,
   38668,38800,38801,38805,38807,38808,38826,38830,38832,38833,
   38854,38856,38857,38942,38943,38980,39156,39159,39161,39166,
   39167,39168,39172,39174,39175,39390,39392,39397,39398,39399,
   39403,39405,39406,39494,39499,39500,39501,39505,39507,39508,
   39562,39563,39564,39568,39570,39571,39703,39704,39708,39710,
   39711,39729,39733,39735,39736,39757,39759,39760,39845,39846,
   39883,40251,40253,40258,40259,40260,40264,40266,40267,40355,
   40360,40361,40362,40366,40368,40369,40423,40424,40425,40429,
   40431,40432,40564,40565,40569,40571,40572,40590,40594,40596,
   40597,40618,40620,40621,40706,40707,40744,44695,44700,44701,
   44702,44706,44708,44709,44763,44764,44765,44769,44771,44772,
   44904,44905,44909,44911,44912,44930,44934,44936,44937,44958,
   44960,44961,45046,45047,45084,46447,46448,46449,46453,46455,
   46456,46588,46589,46593,46595,46596,46614,46618,46620,46621,
   46642,46644,46645,46730,46731,46768,47549,47550,47554,47556,
   47557,47575,47579,47581,47582,47603,47605,47606,47691,47692,
   47729,49470,49474,49476,49477,49498,49500,49501,49586,49587,
   49624,49798,49800,49801,49886,49887,49924,50162,50163,50200,
   51084],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,
   2384,3500,3501,3507,3510,3512,3517,3518,3519,3523,3525,3526,
   3544,3550,3553,3555,3560,3561,3562,3566,3568,3569,3592,3595,
   3597,3602,3603,3604,3608,3610,3611,3826,3828,3833,3834,3835,
   3839,3841,3842,3930,3935,3936,3937,3941,3998,3999,4000,4004,
   4139,4140,4144,4146,4147,4165,4169,4171,4172,4193,4195,4196,
   4281,4282,4319,4510,4511,4512,4518,4528,4529,5645,5646,5652,
   5655,5657,5662,5663,5664,5668,5670,5671,5689,5695,5698,5700,
   5705,5706,5707,5711,5713,5714,5737,5740,5742,5747,5748,5749,
   5753,5755,5756,5971,5973,5978,5979,5980,5984,5986,5987,6075,
   6080,6081,6086,6089,6143,6144,6145,6149,6151,6152,6284,6285,
   6289,6291,6292,6310,6314,6316,6317,6340,6341,6427,6464,7725,
   7726,7732,7735,7737,7742,7743,7744,7748,7750,7751,7769,7775,
   7778,7780,7785,7786,7787,7791,7793,7794,7817,7820,7822,7827,
   7828,7829,7833,7835,7836,8051,8053,8058,8059,8060,8064,8066,
   8067,8155,8160,8161,8162,8166,8168,8169,8223,8224,8225,8231,
   8364,8365,8369,8371,8372,8390,8394,8396,8397,8420,8506,8507,
   8544,38205,38211,38214,38216,38221,38222,38223,38227,38229,
   38230,38253,38256,38258,38263,38264,38265,38269,38271,38272,
   38487,38489,38494,38495,38496,38500,38502,38503,38591,38596,
   38597,38598,38602,38604,38605,38659,38660,38661,38665,38667,
   38668,38800,38801,38805,38807,38808,38826,38830,38832,38833,
   38854,38856,38857,38942,38943,38980,39156,39159,39161,39166,
   39167,39168,39172,39174,39175,39390,39392,39397,39398,39399,
   39403,39405,39406,39494,39499,39500,39501,39505,39507,39508,
   39562,39563,39564,39568,39570,39571,39703,39704,39708,39710,
   39711,39729,39733,39735,39736,39757,39759,39760,39845,39846,
   39883,40251,40253,40258,40259,40260,40264,40266,40267,40355,
   40360,40361,40362,40366,40368,40369,40423,40424,40425,40429,
   40431,40432,40564,40565,40569,40571,40572,40590,40594,40596,
   40597,40618,40620,40621,40706,40707,40744,44695,44700,44701,
   44702,44706,44708,44709,44763,44764,44765,44769,44771,44772,
   44904,44905,44909,44911,44912,44930,44934,44936,44937,44958,
   44960,44961,45046,45047,45084,46447,46448,46449,46453,46455,
   46456,46588,46589,46593,46595,46596,46614,46618,46620,46621,
   46642,46644,46645,46730,46731,46768,47549,47550,47554,47556,
   47557,47575,47579,47581,47582,47603,47605,47606,47691,47692,
   47729,49470,49474,49476,49477,49498,49500,49501,49586,49587,
   49624,49798,49800,49801,49886,49887,49924,50162,50163,50200,
   51084],
 [3507,3510,3512,3527,3528,3826,3828,3843,3844,3930,4354,38487,
   38489,38504,38505,38591,38606,38607,38669,38670,39015,44695,
   44710,44711,44773,44774,45119,46457,46458,46803,47764],
 [3507,3510,3512,3527,3528,3826,3828,3843,3844,3930,4354,38487,
   38489,38504,38505,38591,38606,38607,38669,38670,39015,44695,
   44710,44711,44773,44774,45119,46457,46458,46803,47764],
 [3930,46459],[3930,46460],[3930,46461],[3930,46462],
 [3930,46463],[3930,46464],[3930,46465],[3930,46466],
 [3930,46467],[3930,46468],[3930,46469],[3930,46470],
 [3930,46471],[3930,46472],[3930,46473],
 [3500,3501,3505,3506,3507,3513,3514,3544,3550,3592,3750,3756,
   3787,3794,3829,3830,38205,38209,38210,38211,38217,38218,
   38251,38252,38253,38259,38260,38410,38411,38417,38418,38448,
   38454,38455,38490,38491,38686,39154,39155,39156,39162,39163,
   39313,39314,39321,39351,39358,39393,39394,39589,40174,40175,
   40212,40218,40219,40254,40255,40450,43256,43263,43298,43299,
   43964,43965,44160,44790],[3756],[3756],
 [3505,3507,3513,3517,3518,3750,3756,3829,3833,3834,4139,38411,
   38417,38421,38422,38490,38494,38495,38689,38690,38800,43298,
   43302,43303,43608,44793,44794,44904,47984],
 [3505,3507,3513,3517,3518,3750,3756,3829,3833,3834,4139,38411,
   38417,38421,38422,38490,38494,38495,38689,38690,38800,43298,
   43302,43303,43608,44793,44794,44904,47984],
 [3756,4193,43685,48035],[3756,4193,43685,48035],[3756],
 [3505,3507,3513,3522,3524,3750,3756,3829,3838,3840,4260,38411,
   38417,38426,38428,38490,38499,38501,38694,38696,38921,43298,
   43307,43309,43729,44798,44800,45025,48105],
 [3756,4193,43685,48035],
 [3505,3507,3513,3522,3524,3750,3756,3829,3838,3840,4260,38411,
   38417,38426,38428,38490,38499,38501,38694,38696,38921,43298,
   43307,43309,43729,44798,44800,45025,48105],
 [3505,3507,3513,3525,3526,3750,3756,3829,3841,3842,4319,38411,
   38417,38429,38430,38490,38502,38503,38697,38698,38980,43298,
   43310,43311,43788,44801,44802,45084,48164],
 [3505,3507,3513,3525,3526,3750,3756,3829,3841,3842,4319,38411,
   38417,38429,38430,38490,38502,38503,38697,38698,38980,43298,
   43310,43311,43788,44801,44802,45084,48164],
 [3505,3507,3513,3527,3528,3750,3756,3829,3843,3844,4354,38411,
   38417,38431,38432,38490,38504,38505,38699,38700,39015,43298,
   43312,43313,43823,44803,44804,45119,48199],
 [3505,3507,3513,3527,3528,3750,3756,3829,3843,3844,4354,38411,
   38417,38431,38432,38490,38504,38505,38699,38700,39015,43298,
   43312,43313,43823,44803,44804,45119,48199],[3756],[3756],
 [3756],[3756],[3756],[3756],[3756],[3756],
 [3505,3507,3513,3537,3750,3756,3829,3853,38411,38417,38441,
   38490,38514,38709,43298,43322,44813],[3756],[3756],
 [3756],[3756],[3756],[3756],[3794,44190],[3794,44191],
 [3506,3507,3514,3517,3518,3787,3794,3830,3833,3834,4139,38448,
   38455,38458,38459,38491,38494,38495,38718,38719,38800,43965,
   43968,43969,44192,44193,44274,44822,44823,44904,48390],
 [3506,3507,3514,3517,3518,3787,3794,3830,3833,3834,4139,38448,
   38455,38458,38459,38491,38494,38495,38718,38719,38800,43965,
   43968,43969,44192,44193,44274,44822,44823,44904,48390],
 [3506,3507,3514,3519,3522,3523,3524,3787,3794,3830,3835,3838,
   3839,3840,4193,4260,38448,38455,38460,38463,38464,38465,
   38491,38496,38499,38500,38501,38720,38723,38724,38725,38853,
   38854,38855,38920,38921,38941,43965,43970,43973,43974,43975,
   44194,44197,44198,44199,44329,44394,44395,44415,44824,44827,
   44828,44829,44957,44958,44959,45024,45025,45045,48443,48445,
   48510,48511,50141,50855],[3794,44195],
 [3506,3507,3514,3521,3787,3794,3830,3837,38448,38455,38462,
   38491,38498,38722,43965,43972,44196,44826],
 [3506,3507,3514,3519,3522,3523,3524,3787,3794,3830,3835,3838,
   3839,3840,4193,4260,38448,38455,38460,38463,38464,38465,
   38491,38496,38499,38500,38501,38720,38723,38724,38725,38853,
   38854,38855,38920,38921,38941,43965,43970,43973,43974,43975,
   44194,44197,44198,44199,44329,44394,44395,44415,44824,44827,
   44828,44829,44957,44958,44959,45024,45025,45045,48443,48445,
   48510,48511,50141,50855],
 [3506,3507,3514,3519,3522,3523,3524,3787,3794,3830,3835,3838,
   3839,3840,4193,4260,38448,38455,38460,38463,38464,38465,
   38491,38496,38499,38500,38501,38720,38723,38724,38725,38853,
   38854,38855,38920,38921,38941,43965,43970,43973,43974,43975,
   44194,44197,44198,44199,44329,44394,44395,44415,44824,44827,
   44828,44829,44957,44958,44959,45024,45025,45045,48443,48445,
   48510,48511,50141,50855],
 [3506,3507,3514,3519,3522,3523,3524,3787,3794,3830,3835,3838,
   3839,3840,4193,4260,38448,38455,38460,38463,38464,38465,
   38491,38496,38499,38500,38501,38720,38723,38724,38725,38853,
   38854,38855,38920,38921,38941,43965,43970,43973,43974,43975,
   44194,44197,44198,44199,44329,44394,44395,44415,44824,44827,
   44828,44829,44957,44958,44959,45024,45025,45045,48443,48445,
   48510,48511,50141,50855],
 [3506,3507,3514,3525,3526,3787,3794,3830,3841,3842,4319,38448,
   38455,38466,38467,38491,38502,38503,38726,38727,38980,43965,
   43976,43977,44200,44201,44454,44830,44831,45084,48570],
 [3506,3507,3514,3525,3526,3787,3794,3830,3841,3842,4319,38448,
   38455,38466,38467,38491,38502,38503,38726,38727,38980,43965,
   43976,43977,44200,44201,44454,44830,44831,45084,48570],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,
   2384,3500,3501,3505,3506,3507,3513,3514,3517,3518,3527,3528,
   3544,3548,3549,3550,3556,3557,3560,3561,3570,3571,3590,3591,
   3592,3598,3599,3602,3603,3612,3613,3749,3750,3756,3757,3760,
   3761,3770,3771,3787,3793,3794,3797,3798,3829,3830,3833,3834,
   3843,3844,4025,4028,4029,4038,4039,4057,4058,4139,4148,4149,
   4173,4174,4354,4510,4511,4512,4518,4528,4529,5645,5646,5650,
   5651,5652,5658,5659,5662,5663,5672,5673,5689,5693,5694,5695,
   5701,5702,5705,5706,5715,5716,5735,5736,5737,5743,5744,5747,
   5748,5757,5758,5894,5895,5902,5905,5906,5916,5932,5939,5942,
   5943,5953,5974,5975,5978,5979,5988,5989,6170,6173,6174,6183,
   6184,6202,6203,6212,6213,6284,6293,6294,6318,6319,6499,7725,
   7726,7730,7731,7732,7738,7739,7742,7743,7752,7753,7769,7773,
   7774,7775,7781,7782,7785,7786,7795,7796,7815,7816,7817,7823,
   7824,7827,7828,7837,7838,7974,7975,7985,7986,7995,7996,8012,
   8018,8019,8022,8023,8032,8033,8054,8055,8058,8059,8068,8069,
   8250,8253,8254,8263,8282,8283,8292,8364,8373,8374,8398,8399,
   8579,38205,38209,38210,38211,38217,38218,38221,38222,38231,
   38232,38251,38252,38253,38259,38260,38263,38264,38273,38274,
   38410,38411,38417,38418,38421,38422,38431,38432,38448,38454,
   38455,38458,38459,38468,38469,38490,38491,38494,38495,38504,
   38505,38686,38689,38690,38699,38700,38718,38719,38728,38729,
   38800,38809,38810,38834,38835,39015,39154,39155,39156,39162,
   39163,39166,39167,39176,39177,39313,39314,39320,39321,39324,
   39325,39334,39335,39351,39357,39358,39361,39362,39371,39372,
   39393,39394,39397,39398,39407,39408,39589,39592,39593,39602,
   39603,39621,39622,39631,39632,39703,39712,39713,39737,39738,
   39918,40174,40175,40181,40182,40185,40186,40195,40196,40212,
   40218,40219,40222,40223,40232,40233,40254,40255,40258,40259,
   40268,40269,40450,40453,40454,40463,40464,40482,40483,40492,
   40493,40564,40573,40574,40598,40599,40779,43256,43262,43263,
   43266,43267,43276,43277,43298,43299,43302,43303,43312,43313,
   43494,43497,43498,43507,43508,43526,43527,43536,43537,43608,
   43617,43618,43642,43643,43823,43964,43965,43968,43969,43978,
   43979,44160,44163,44164,44173,44174,44192,44193,44202,44203,
   44274,44283,44284,44308,44309,44489,44790,44793,44794,44803,
   44804,44822,44823,44832,44833,44904,44913,44914,44938,44939,
   45119,47902,47903,47912,47913,47984,47993,47994,48018,48019,
   48199,48390,48399,48400,48424,48425,48605,49478,49479,49659,
   49959],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,
   2384,3500,3501,3505,3506,3507,3513,3514,3517,3518,3527,3528,
   3544,3548,3549,3550,3556,3557,3560,3561,3570,3571,3590,3591,
   3592,3598,3599,3602,3603,3612,3613,3749,3750,3756,3757,3760,
   3761,3770,3771,3787,3793,3794,3797,3798,3829,3830,3833,3834,
   3843,3844,4025,4028,4029,4038,4039,4057,4058,4139,4148,4149,
   4173,4174,4354,4510,4511,4512,4518,4528,4529,5645,5646,5650,
   5651,5652,5658,5659,5662,5663,5672,5673,5689,5693,5694,5695,
   5701,5702,5705,5706,5715,5716,5735,5736,5737,5743,5744,5747,
   5748,5757,5758,5894,5895,5902,5905,5906,5916,5932,5939,5942,
   5943,5953,5974,5975,5978,5979,5988,5989,6170,6173,6174,6183,
   6184,6202,6203,6212,6213,6284,6293,6294,6318,6319,6499,7725,
   7726,7730,7731,7732,7738,7739,7742,7743,7752,7753,7769,7773,
   7774,7775,7781,7782,7785,7786,7795,7796,7815,7816,7817,7823,
   7824,7827,7828,7837,7838,7974,7975,7985,7986,7995,7996,8012,
   8018,8019,8022,8023,8032,8033,8054,8055,8058,8059,8068,8069,
   8250,8253,8254,8263,8282,8283,8292,8364,8373,8374,8398,8399,
   8579,38205,38209,38210,38211,38217,38218,38221,38222,38231,
   38232,38251,38252,38253,38259,38260,38263,38264,38273,38274,
   38410,38411,38417,38418,38421,38422,38431,38432,38448,38454,
   38455,38458,38459,38468,38469,38490,38491,38494,38495,38504,
   38505,38686,38689,38690,38699,38700,38718,38719,38728,38729,
   38800,38809,38810,38834,38835,39015,39154,39155,39156,39162,
   39163,39166,39167,39176,39177,39313,39314,39320,39321,39324,
   39325,39334,39335,39351,39357,39358,39361,39362,39371,39372,
   39393,39394,39397,39398,39407,39408,39589,39592,39593,39602,
   39603,39621,39622,39631,39632,39703,39712,39713,39737,39738,
   39918,40174,40175,40181,40182,40185,40186,40195,40196,40212,
   40218,40219,40222,40223,40232,40233,40254,40255,40258,40259,
   40268,40269,40450,40453,40454,40463,40464,40482,40483,40492,
   40493,40564,40573,40574,40598,40599,40779,43256,43262,43263,
   43266,43267,43276,43277,43298,43299,43302,43303,43312,43313,
   43494,43497,43498,43507,43508,43526,43527,43536,43537,43608,
   43617,43618,43642,43643,43823,43964,43965,43968,43969,43978,
   43979,44160,44163,44164,44173,44174,44192,44193,44202,44203,
   44274,44283,44284,44308,44309,44489,44790,44793,44794,44803,
   44804,44822,44823,44832,44833,44904,44913,44914,44938,44939,
   45119,47902,47903,47912,47913,47984,47993,47994,48018,48019,
   48199,48390,48399,48400,48424,48425,48605,49478,49479,49659,
   49959],[3794,44204],
 [3506,3507,3514,3530,3787,3794,3830,3846,38448,38455,38471,
   38491,38507,38731,43965,43981,44205,44835],[3794,44206],
 [3794,44207],[3794,44208],[3794,44209],[3794,44210],
 [3794,44211],[3794,44212],[3794,44213],[3794,44214],
 [3794,44215],[3794,44216],[3794,44217],[3794,44218],
 [3677,41990,41991,42109,47029],
 [3507,3515,3517,3518,3521,3831,3833,3834,3837,4139,38492,38494,
   38495,38498,38746,38747,38750,38800,38803,38828,44850,44851,
   44854,44904,44907,44932,48768,48771,48796,49472],
 [3507,3515,3517,3518,3521,3831,3833,3834,3837,4139,38492,38494,
   38495,38498,38746,38747,38750,38800,38803,38828,44850,44851,
   44854,44904,44907,44932,48768,48771,48796,49472],[4193],
 [],[3507,3515,3517,3518,3521,3831,3833,3834,3837,4139,38492,
   38494,38495,38498,38746,38747,38750,38800,38803,38828,44850,
   44851,44854,44904,44907,44932,48768,48771,48796,49472],
 [3507,3515,3522,3524,3831,3838,3840,4260,38492,38499,38501,
   38751,38753,38921,44855,44857,45025,48889],[4193],
 [3507,3515,3522,3524,3831,3838,3840,4260,38492,38499,38501,
   38751,38753,38921,44855,44857,45025,48889],
 [3507,3515,3525,3526,3831,3841,3842,4319,38492,38502,38503,
   38754,38755,38980,44858,44859,45084,48948],
 [3507,3515,3525,3526,3831,3841,3842,4319,38492,38502,38503,
   38754,38755,38980,44858,44859,45084,48948],
 [3507,3515,3527,3528,3831,3843,3844,4354,38492,38504,38505,
   38756,38757,39015,44860,44861,45119,48983],
 [3507,3515,3527,3528,3831,3843,3844,4354,38492,38504,38505,
   38756,38757,39015,44860,44861,45119,48983],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],
 [3507,3516,3517,3518,3832,3833,3834,4139,38493,38494,38495,
   38773,38774,38800,44877,44878,44904,49119],
 [3507,3516,3517,3518,3832,3833,3834,4139,38493,38494,38495,
   38773,38774,38800,44877,44878,44904,49119],[4193],[],
 [3507,3516,3521,3522,3524,3832,3837,3838,3840,4260,38493,38498,
   38499,38501,38777,38778,38780,38898,38900,38921,44881,44882,
   44884,45002,45004,45025,49217,49219,49240,50625],
 [3507,3516,3521,3522,3524,3832,3837,3838,3840,4260,38493,38498,
   38499,38501,38777,38778,38780,38898,38900,38921,44881,44882,
   44884,45002,45004,45025,49217,49219,49240,50625],[4193],
 [3507,3516,3521,3522,3524,3832,3837,3838,3840,4260,38493,38498,
   38499,38501,38777,38778,38780,38898,38900,38921,44881,44882,
   44884,45002,45004,45025,49217,49219,49240,50625],
 [3507,3516,3525,3526,3832,3841,3842,4319,38493,38502,38503,
   38781,38782,38980,44885,44886,45084,49299],
 [3507,3516,3525,3526,3832,3841,3842,4319,38493,38502,38503,
   38781,38782,38980,44885,44886,45084,49299],
 [3507,3516,3527,3528,3832,3843,3844,4354,38493,38504,38505,
   38783,38784,39015,44887,44888,45119,49334],
 [3507,3516,3527,3528,3832,3843,3844,4354,38493,38504,38505,
   38783,38784,39015,44887,44888,45119,49334],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],
 [3507,44904],
 [3507,3510,3512,3517,3518,3519,3523,3826,3828,3833,3834,3835,
   3839,3930,4139,4193,38487,38489,38494,38495,38496,38500,
   38591,38596,38597,38598,38602,38659,38660,38661,38665,38800,
   38801,38805,38826,38830,38854,44695,44700,44701,44702,44706,
   44763,44764,44765,44769,44904,44905,44909,44930,44934,44958,
   46447,46448,46449,46453,46588,46593,46614,46618,47549,47550,
   47554,47575,49470,49474],
 [23,31,44,1291,1296,1297,1306,1307,1309,1432,1625,1658,3502,
   3507,3508,3517,3518,3520,3633,3634,3824,3833,3834,3836,4139,
   38294,38295,38304,38305,38307,38485,38494,38495,38497,38529,
   38530,38532,38800,38802,38827,41069,41078,41079,41081,41113,
   41114,41116,41384,41386,41411,44633,44634,44636,44904,44906,
   44931,45499,45501,45526,49471],
 [3507,3515,3517,3518,3521,3831,3833,3834,3837,4139,38492,38494,
   38495,38498,38746,38747,38750,38800,38803,38828,44850,44851,
   44854,44904,44907,44932,48768,48771,48796,49472],
 [3503,3504,3507,3509,3511,3517,3518,3522,3524,3670,3673,3675,
   3677,3712,3714,3716,3825,3827,3833,3834,3838,3840,3896,4139,
   4260,38331,38334,38336,38338,38344,38345,38349,38351,38373,
   38375,38377,38383,38384,38388,38390,38486,38488,38494,38495,
   38499,38501,38557,38563,38564,38568,38570,38628,38629,38633,
   38635,38800,38804,38806,38829,38831,38921,41737,41739,41741,
   41747,41748,41752,41754,41850,41852,41858,41859,41863,41865,
   41921,41927,41928,41932,41934,41992,41993,41997,41999,42164,
   42168,42170,42193,42195,42285,42591,42593,42599,42600,42604,
   42606,42662,42668,42669,42673,42675,42733,42734,42738,42740,
   42905,42909,42911,42934,42936,43026,44661,44667,44668,44672,
   44674,44732,44733,44737,44739,44904,44908,44910,44933,44935,
   45025,45888,45889,45893,45895,46060,46064,46066,46089,46091,
   46181,47084,47088,47090,47113,47115,47205,49473,49475,49565,
   49865],
 [3507,3510,3512,3517,3518,3519,3523,3826,3828,3833,3834,3835,
   3839,3930,4139,4193,38487,38489,38494,38495,38496,38500,
   38591,38596,38597,38598,38602,38659,38660,38661,38665,38800,
   38801,38805,38826,38830,38854,44695,44700,44701,44702,44706,
   44763,44764,44765,44769,44904,44905,44909,44930,44934,44958,
   46447,46448,46449,46453,46588,46593,46614,46618,47549,47550,
   47554,47575,49470,49474],
 [3503,3504,3507,3509,3511,3517,3518,3522,3524,3670,3673,3675,
   3677,3712,3714,3716,3825,3827,3833,3834,3838,3840,3896,4139,
   4260,38331,38334,38336,38338,38344,38345,38349,38351,38373,
   38375,38377,38383,38384,38388,38390,38486,38488,38494,38495,
   38499,38501,38557,38563,38564,38568,38570,38628,38629,38633,
   38635,38800,38804,38806,38829,38831,38921,41737,41739,41741,
   41747,41748,41752,41754,41850,41852,41858,41859,41863,41865,
   41921,41927,41928,41932,41934,41992,41993,41997,41999,42164,
   42168,42170,42193,42195,42285,42591,42593,42599,42600,42604,
   42606,42662,42668,42669,42673,42675,42733,42734,42738,42740,
   42905,42909,42911,42934,42936,43026,44661,44667,44668,44672,
   44674,44732,44733,44737,44739,44904,44908,44910,44933,44935,
   45025,45888,45889,45893,45895,46060,46064,46066,46089,46091,
   46181,47084,47088,47090,47113,47115,47205,49473,49475,49565,
   49865],
 [3507,3517,3518,3525,3526,3833,3834,3841,3842,4139,4319,38494,
   38495,38502,38503,38800,38807,38808,38832,38833,38980,44904,
   44911,44912,44936,44937,45084,49476,49477,49624,49924],
 [3507,3517,3518,3525,3526,3833,3834,3841,3842,4139,4319,38494,
   38495,38502,38503,38800,38807,38808,38832,38833,38980,44904,
   44911,44912,44936,44937,45084,49476,49477,49624,49924],
 [3507,3517,3518,3527,3528,3833,3834,3843,3844,4139,4354,38494,
   38495,38504,38505,38800,38809,38810,38834,38835,39015,44904,
   44913,44914,44938,44939,45119,49478,49479,49659,49959],
 [3507,3517,3518,3527,3528,3833,3834,3843,3844,4139,4354,38494,
   38495,38504,38505,38800,38809,38810,38834,38835,39015,44904,
   44913,44914,44938,44939,45119,49478,49479,49659,49959],
 [3507,3517,3518,3529,3833,3834,3845,4139,38494,38495,38506,
   38800,38811,38836,44904,44915,44940,49480],
 [3507,3517,3518,3530,3833,3834,3846,4139,38494,38495,38507,
   38800,38812,38837,44904,44916,44941,49481],
 [3507,3517,3518,3531,3833,3834,3847,4139,38494,38495,38508,
   38800,38813,38838,44904,44917,44942,49482],
 [3507,3517,3518,3532,3833,3834,3848,4139,38494,38495,38509,
   38800,38814,38839,44904,44918,44943,49483],
 [3507,3517,3518,3533,3540,3833,3834,3849,3856,4139,38494,38495,
   38510,38517,38800,38815,38822,38840,38847,39102,44904,44919,
   44926,44944,44951,45206,49484,49491,49746,50046],
 [3507,3517,3518,3534,3833,3834,3850,4139,38494,38495,38511,
   38800,38816,38841,44904,44920,44945,49485],
 [3507,3517,3518,3535,3833,3834,3851,4139,38494,38495,38512,
   38800,38817,38842,44904,44921,44946,49486],
 [3507,3517,3518,3536,3833,3834,3852,4139,38494,38495,38513,
   38800,38818,38843,44904,44922,44947,49487],
 [3507,3517,3518,3537,3539,3833,3834,3853,3855,4139,38494,38495,
   38514,38516,38800,38819,38821,38844,38846,39131,44904,44923,
   44925,44948,44950,45235,49488,49490,49775,50075],
 [3507,3517,3518,3538,3833,3834,3854,4139,38494,38495,38515,
   38800,38820,38845,44904,44924,44949,49489],
 [3507,3517,3518,3537,3539,3833,3834,3853,3855,4139,38494,38495,
   38514,38516,38800,38819,38821,38844,38846,39131,44904,44923,
   44925,44948,44950,45235,49488,49490,49775,50075],
 [3507,3517,3518,3533,3540,3833,3834,3849,3856,4139,38494,38495,
   38510,38517,38800,38815,38822,38840,38847,39102,44904,44919,
   44926,44944,44951,45206,49484,49491,49746,50046],
 [3507,3517,3518,3541,3833,3834,3857,4139,38494,38495,38518,
   38800,38823,38848,44904,44927,44952,49492],
 [3507,3517,3518,3542,3833,3834,3858,4139,38494,38495,38519,
   38800,38824,38849,44904,44928,44953,49493],
 [3507,3517,3518,3543,3833,3834,3859,4139,38494,38495,38520,
   38800,38825,38850,44904,44929,44954,49494],
 [3507,3510,3512,3517,3518,3519,3523,3826,3828,3833,3834,3835,
   3839,3930,4139,4193,38487,38489,38494,38495,38496,38500,
   38591,38596,38597,38598,38602,38659,38660,38661,38665,38800,
   38801,38805,38826,38830,38854,44695,44700,44701,44702,44706,
   44763,44764,44765,44769,44904,44905,44909,44930,44934,44958,
   46447,46448,46449,46453,46588,46593,46614,46618,47549,47550,
   47554,47575,49470,49474],
 [23,31,44,1291,1296,1297,1306,1307,1309,1432,1625,1658,3502,
   3507,3508,3517,3518,3520,3633,3634,3824,3833,3834,3836,4139,
   38294,38295,38304,38305,38307,38485,38494,38495,38497,38529,
   38530,38532,38800,38802,38827,41069,41078,41079,41081,41113,
   41114,41116,41384,41386,41411,44633,44634,44636,44904,44906,
   44931,45499,45501,45526,49471],
 [3507,3515,3517,3518,3521,3831,3833,3834,3837,4139,38492,38494,
   38495,38498,38746,38747,38750,38800,38803,38828,44850,44851,
   44854,44904,44907,44932,48768,48771,48796,49472],
 [3503,3504,3507,3509,3511,3517,3518,3522,3524,3670,3673,3675,
   3677,3712,3714,3716,3825,3827,3833,3834,3838,3840,3896,4139,
   4260,38331,38334,38336,38338,38344,38345,38349,38351,38373,
   38375,38377,38383,38384,38388,38390,38486,38488,38494,38495,
   38499,38501,38557,38563,38564,38568,38570,38628,38629,38633,
   38635,38800,38804,38806,38829,38831,38921,41737,41739,41741,
   41747,41748,41752,41754,41850,41852,41858,41859,41863,41865,
   41921,41927,41928,41932,41934,41992,41993,41997,41999,42164,
   42168,42170,42193,42195,42285,42591,42593,42599,42600,42604,
   42606,42662,42668,42669,42673,42675,42733,42734,42738,42740,
   42905,42909,42911,42934,42936,43026,44661,44667,44668,44672,
   44674,44732,44733,44737,44739,44904,44908,44910,44933,44935,
   45025,45888,45889,45893,45895,46060,46064,46066,46089,46091,
   46181,47084,47088,47090,47113,47115,47205,49473,49475,49565,
   49865],
 [3507,3510,3512,3517,3518,3519,3523,3826,3828,3833,3834,3835,
   3839,3930,4139,4193,38487,38489,38494,38495,38496,38500,
   38591,38596,38597,38598,38602,38659,38660,38661,38665,38800,
   38801,38805,38826,38830,38854,44695,44700,44701,44702,44706,
   44763,44764,44765,44769,44904,44905,44909,44930,44934,44958,
   46447,46448,46449,46453,46588,46593,46614,46618,47549,47550,
   47554,47575,49470,49474],
 [3503,3504,3507,3509,3511,3517,3518,3522,3524,3670,3673,3675,
   3677,3712,3714,3716,3825,3827,3833,3834,3838,3840,3896,4139,
   4260,38331,38334,38336,38338,38344,38345,38349,38351,38373,
   38375,38377,38383,38384,38388,38390,38486,38488,38494,38495,
   38499,38501,38557,38563,38564,38568,38570,38628,38629,38633,
   38635,38800,38804,38806,38829,38831,38921,41737,41739,41741,
   41747,41748,41752,41754,41850,41852,41858,41859,41863,41865,
   41921,41927,41928,41932,41934,41992,41993,41997,41999,42164,
   42168,42170,42193,42195,42285,42591,42593,42599,42600,42604,
   42606,42662,42668,42669,42673,42675,42733,42734,42738,42740,
   42905,42909,42911,42934,42936,43026,44661,44667,44668,44672,
   44674,44732,44733,44737,44739,44904,44908,44910,44933,44935,
   45025,45888,45889,45893,45895,46060,46064,46066,46089,46091,
   46181,47084,47088,47090,47113,47115,47205,49473,49475,49565,
   49865],
 [3507,3517,3518,3525,3526,3833,3834,3841,3842,4139,4319,38494,
   38495,38502,38503,38800,38807,38808,38832,38833,38980,44904,
   44911,44912,44936,44937,45084,49476,49477,49624,49924],
 [3507,3517,3518,3525,3526,3833,3834,3841,3842,4139,4319,38494,
   38495,38502,38503,38800,38807,38808,38832,38833,38980,44904,
   44911,44912,44936,44937,45084,49476,49477,49624,49924],
 [3507,3517,3518,3527,3528,3833,3834,3843,3844,4139,4354,38494,
   38495,38504,38505,38800,38809,38810,38834,38835,39015,44904,
   44913,44914,44938,44939,45119,49478,49479,49659,49959],
 [3507,3517,3518,3527,3528,3833,3834,3843,3844,4139,4354,38494,
   38495,38504,38505,38800,38809,38810,38834,38835,39015,44904,
   44913,44914,44938,44939,45119,49478,49479,49659,49959],
 [3507,3517,3518,3529,3833,3834,3845,4139,38494,38495,38506,
   38800,38811,38836,44904,44915,44940,49480],
 [3507,3517,3518,3530,3833,3834,3846,4139,38494,38495,38507,
   38800,38812,38837,44904,44916,44941,49481],
 [3507,3517,3518,3531,3833,3834,3847,4139,38494,38495,38508,
   38800,38813,38838,44904,44917,44942,49482],
 [3507,3517,3518,3532,3833,3834,3848,4139,38494,38495,38509,
   38800,38814,38839,44904,44918,44943,49483],
 [3507,3517,3518,3533,3540,3833,3834,3849,3856,4139,38494,38495,
   38510,38517,38800,38815,38822,38840,38847,39102,44904,44919,
   44926,44944,44951,45206,49484,49491,49746,50046],
 [3507,3517,3518,3534,3833,3834,3850,4139,38494,38495,38511,
   38800,38816,38841,44904,44920,44945,49485],
 [3507,3517,3518,3535,3833,3834,3851,4139,38494,38495,38512,
   38800,38817,38842,44904,44921,44946,49486],
 [3507,3517,3518,3536,3833,3834,3852,4139,38494,38495,38513,
   38800,38818,38843,44904,44922,44947,49487],
 [3507,3517,3518,3537,3539,3833,3834,3853,3855,4139,38494,38495,
   38514,38516,38800,38819,38821,38844,38846,39131,44904,44923,
   44925,44948,44950,45235,49488,49490,49775,50075],
 [3507,3517,3518,3538,3833,3834,3854,4139,38494,38495,38515,
   38800,38820,38845,44904,44924,44949,49489],
 [3507,3517,3518,3537,3539,3833,3834,3853,3855,4139,38494,38495,
   38514,38516,38800,38819,38821,38844,38846,39131,44904,44923,
   44925,44948,44950,45235,49488,49490,49775,50075],
 [3507,3517,3518,3533,3540,3833,3834,3849,3856,4139,38494,38495,
   38510,38517,38800,38815,38822,38840,38847,39102,44904,44919,
   44926,44944,44951,45206,49484,49491,49746,50046],
 [3507,3517,3518,3541,3833,3834,3857,4139,38494,38495,38518,
   38800,38823,38848,44904,44927,44952,49492],
 [3507,3517,3518,3542,3833,3834,3858,4139,38494,38495,38519,
   38800,38824,38849,44904,44928,44953,49493],
 [3507,3517,3518,3543,3833,3834,3859,4139,38494,38495,38520,
   38800,38825,38850,44904,44929,44954,49494],
 [3756,4193,43685,48035],[4193],
 [3506,3507,3514,3519,3522,3523,3524,3787,3794,3830,3835,3838,
   3839,3840,4193,4260,38448,38455,38460,38463,38464,38465,
   38491,38496,38499,38500,38501,38720,38723,38724,38725,38853,
   38854,38855,38920,38921,38941,43965,43970,43973,43974,43975,
   44194,44197,44198,44199,44329,44394,44395,44415,44824,44827,
   44828,44829,44957,44958,44959,45024,45025,45045,48443,48445,
   48510,48511,50141,50855],[],
 [3506,3507,3514,3519,3522,3523,3524,3787,3794,3830,3835,3838,
   3839,3840,4193,4260,38448,38455,38460,38463,38464,38465,
   38491,38496,38499,38500,38501,38720,38723,38724,38725,38853,
   38854,38855,38920,38921,38941,43965,43970,43973,43974,43975,
   44194,44197,44198,44199,44329,44394,44395,44415,44824,44827,
   44828,44829,44957,44958,44959,45024,45025,45045,48443,48445,
   48510,48511,50141,50855],
 [3507,3519,3523,3525,3526,3835,3839,3841,3842,4193,4319,38496,
   38500,38502,38503,38854,38856,38857,38942,38943,38980,44958,
   44960,44961,45046,45047,45084,50200,51084],
 [3507,3519,3523,3525,3526,3835,3839,3841,3842,4193,4319,38496,
   38500,38502,38503,38854,38856,38857,38942,38943,38980,44958,
   44960,44961,45046,45047,45084,50200,51084],
 [3507,3519,3523,3527,3528,3835,3839,3843,3844,4193,4354,38496,
   38500,38504,38505,38854,38858,38859,38944,38945,39015,44958,
   44962,44963,45048,45049,45119,50235,51119],
 [3507,3519,3523,3527,3528,3835,3839,3843,3844,4193,4354,38496,
   38500,38504,38505,38854,38858,38859,38944,38945,39015,44958,
   44962,44963,45048,45049,45119,50235,51119],[4193],[4193],
 [4193],[4193],[4193],[4193],[4193],[4193],[4193],
 [4193],[4193],[4193],[4193],[4193],[4193],[],
 [3500,3501,3507,3520,3522,3524,3544,3550,3592,3836,3838,3840,
   4260,38205,38211,38224,38226,38228,38253,38266,38268,38270,
   38497,38499,38501,38876,38878,38921,39156,39169,39171,39173,
   39400,39402,39404,39779,39781,39824,40261,40263,40265,40640,
   40642,40685,44980,44982,45025,50394],
 [3756,4193,43685,48035],
 [3500,3501,3507,3520,3522,3524,3544,3550,3592,3836,3838,3840,
   4260,38205,38211,38224,38226,38228,38253,38266,38268,38270,
   38497,38499,38501,38876,38878,38921,39156,39169,39171,39173,
   39400,39402,39404,39779,39781,39824,40261,40263,40265,40640,
   40642,40685,44980,44982,45025,50394],
 [3507,3520,3525,3526,3836,3841,3842,4319,38497,38502,38503,
   38879,38880,38980,44983,44984,45084,50453],
 [3507,3520,3525,3526,3836,3841,3842,4319,38497,38502,38503,
   38879,38880,38980,44983,44984,45084,50453],
 [3507,3520,3527,3528,3836,3843,3844,4354,38497,38504,38505,
   38881,38882,39015,44985,44986,45119,50488],
 [3507,3520,3527,3528,3836,3843,3844,4354,38497,38504,38505,
   38881,38882,39015,44985,44986,45119,50488],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],
 [3507,3516,3521,3522,3524,3832,3837,3838,3840,4260,38493,38498,
   38499,38501,38777,38778,38780,38898,38900,38921,44881,44882,
   44884,45002,45004,45025,49217,49219,49240,50625],[4193],
 [3507,3516,3521,3522,3524,3832,3837,3838,3840,4260,38493,38498,
   38499,38501,38777,38778,38780,38898,38900,38921,44881,44882,
   44884,45002,45004,45025,49217,49219,49240,50625],
 [3507,3521,3525,3526,3837,3841,3842,4319,38498,38502,38503,
   38901,38902,38980,45005,45006,45084,50684],
 [3507,3521,3525,3526,3837,3841,3842,4319,38498,38502,38503,
   38901,38902,38980,45005,45006,45084,50684],
 [3507,3521,3527,3528,3837,3843,3844,4354,38498,38504,38505,
   38903,38904,39015,45007,45008,45119,50719],
 [3507,3521,3527,3528,3837,3843,3844,4354,38498,38504,38505,
   38903,38904,39015,45007,45008,45119,50719],[],[],[],
 [3507,3521,3532,3837,3848,38498,38509,38908,45012],
 [3507,3521,3533,3837,3849,38498,38510,38909,45013],[],[],
 [],[3507,3521,3537,3837,3853,38498,38514,38913,45017],
 [3507,3521,3538,3837,3854,38498,38515,38914,45018],[],[],
 [],[],[],
 [3506,3507,3514,3519,3522,3523,3524,3787,3794,3830,3835,3838,
   3839,3840,4193,4260,38448,38455,38460,38463,38464,38465,
   38491,38496,38499,38500,38501,38720,38723,38724,38725,38853,
   38854,38855,38920,38921,38941,43965,43970,43973,43974,43975,
   44194,44197,44198,44199,44329,44394,44395,44415,44824,44827,
   44828,44829,44957,44958,44959,45024,45025,45045,48443,48445,
   48510,48511,50141,50855],[3507,38921],
 [3507,3522,3524,3525,3526,3838,3840,3841,3842,4260,4319,38499,
   38501,38502,38503,38921,38922,38923,38961,38962,38980,45025,
   45026,45027,45065,45066,45084,50875,50876,50894,51255],
 [3507,3522,3524,3525,3526,3838,3840,3841,3842,4260,4319,38499,
   38501,38502,38503,38921,38922,38923,38961,38962,38980,45025,
   45026,45027,45065,45066,45084,50875,50876,50894,51255],
 [3507,3522,3524,3527,3528,3838,3840,3843,3844,4260,4354,38499,
   38501,38504,38505,38921,38924,38925,38963,38964,39015,45025,
   45028,45029,45067,45068,45119,50877,50878,50929,51290],
 [3507,3522,3524,3527,3528,3838,3840,3843,3844,4260,4354,38499,
   38501,38504,38505,38921,38924,38925,38963,38964,39015,45025,
   45028,45029,45067,45068,45119,50877,50878,50929,51290],
 [3507,3522,3524,3529,3838,3840,3845,4260,38499,38501,38506,
   38921,38926,38965,45025,45030,45069,50879],
 [3507,3522,3524,3530,3838,3840,3846,4260,38499,38501,38507,
   38921,38927,38966,45025,45031,45070,50880],
 [3507,3522,3524,3531,3838,3840,3847,4260,38499,38501,38508,
   38921,38928,38967,45025,45032,45071,50881],
 [3507,3522,3524,3532,3540,3838,3840,3848,3856,4260,38499,38501,
   38509,38517,38921,38929,38937,38968,38976,39092,45025,45033,
   45041,45072,45080,45196,50882,50890,51006,51367],
 [3507,3522,3524,3533,3838,3840,3849,4260,38499,38501,38510,
   38921,38930,38969,45025,45034,45073,50883],
 [3507,3522,3524,3534,3838,3840,3850,4260,38499,38501,38511,
   38921,38931,38970,45025,45035,45074,50884],
 [3507,3522,3524,3535,3838,3840,3851,4260,38499,38501,38512,
   38921,38932,38971,45025,45036,45075,50885],
 [3507,3522,3524,3536,3838,3840,3852,4260,38499,38501,38513,
   38921,38933,38972,45025,45037,45076,50886],
 [3507,3522,3524,3537,3838,3840,3853,4260,38499,38501,38514,
   38921,38934,38973,45025,45038,45077,50887],
 [3507,3522,3524,3538,3539,3838,3840,3854,3855,4260,38499,38501,
   38515,38516,38921,38935,38936,38974,38975,39136,45025,45039,
   45040,45078,45079,45240,50888,50889,51050,51411],
 [3507,3522,3524,3538,3539,3838,3840,3854,3855,4260,38499,38501,
   38515,38516,38921,38935,38936,38974,38975,39136,45025,45039,
   45040,45078,45079,45240,50888,50889,51050,51411],
 [3507,3522,3524,3532,3540,3838,3840,3848,3856,4260,38499,38501,
   38509,38517,38921,38929,38937,38968,38976,39092,45025,45033,
   45041,45072,45080,45196,50882,50890,51006,51367],
 [3507,3522,3524,3541,3838,3840,3857,4260,38499,38501,38518,
   38921,38938,38977,45025,45042,45081,50891],
 [3507,3522,3524,3542,3838,3840,3858,4260,38499,38501,38519,
   38921,38939,38978,45025,45043,45082,50892],
 [3507,3522,3524,3543,3838,3840,3859,4260,38499,38501,38520,
   38921,38940,38979,45025,45044,45083,50893],
 [3506,3507,3514,3519,3522,3523,3524,3787,3794,3830,3835,3838,
   3839,3840,4193,4260,38448,38455,38460,38463,38464,38465,
   38491,38496,38499,38500,38501,38720,38723,38724,38725,38853,
   38854,38855,38920,38921,38941,43965,43970,43973,43974,43975,
   44194,44197,44198,44199,44329,44394,44395,44415,44824,44827,
   44828,44829,44957,44958,44959,45024,45025,45045,48443,48445,
   48510,48511,50141,50855],
 [3507,3519,3523,3525,3526,3835,3839,3841,3842,4193,4319,38496,
   38500,38502,38503,38854,38856,38857,38942,38943,38980,44958,
   44960,44961,45046,45047,45084,50200,51084],
 [3507,3519,3523,3525,3526,3835,3839,3841,3842,4193,4319,38496,
   38500,38502,38503,38854,38856,38857,38942,38943,38980,44958,
   44960,44961,45046,45047,45084,50200,51084],
 [3507,3519,3523,3527,3528,3835,3839,3843,3844,4193,4354,38496,
   38500,38504,38505,38854,38858,38859,38944,38945,39015,44958,
   44962,44963,45048,45049,45119,50235,51119],
 [3507,3519,3523,3527,3528,3835,3839,3843,3844,4193,4354,38496,
   38500,38504,38505,38854,38858,38859,38944,38945,39015,44958,
   44962,44963,45048,45049,45119,50235,51119],[4193],[4193],
 [4193],[4193],[4193],[4193],[4193],[4193],[4193],
 [4193],[4193],[4193],[4193],[4193],[4193],
 [3507,3522,3524,3525,3526,3838,3840,3841,3842,4260,4319,38499,
   38501,38502,38503,38921,38922,38923,38961,38962,38980,45025,
   45026,45027,45065,45066,45084,50875,50876,50894,51255],
 [3507,3522,3524,3525,3526,3838,3840,3841,3842,4260,4319,38499,
   38501,38502,38503,38921,38922,38923,38961,38962,38980,45025,
   45026,45027,45065,45066,45084,50875,50876,50894,51255],
 [3507,3522,3524,3527,3528,3838,3840,3843,3844,4260,4354,38499,
   38501,38504,38505,38921,38924,38925,38963,38964,39015,45025,
   45028,45029,45067,45068,45119,50877,50878,50929,51290],
 [3507,3522,3524,3527,3528,3838,3840,3843,3844,4260,4354,38499,
   38501,38504,38505,38921,38924,38925,38963,38964,39015,45025,
   45028,45029,45067,45068,45119,50877,50878,50929,51290],
 [3507,3522,3524,3529,3838,3840,3845,4260,38499,38501,38506,
   38921,38926,38965,45025,45030,45069,50879],
 [3507,3522,3524,3530,3838,3840,3846,4260,38499,38501,38507,
   38921,38927,38966,45025,45031,45070,50880],
 [3507,3522,3524,3531,3838,3840,3847,4260,38499,38501,38508,
   38921,38928,38967,45025,45032,45071,50881],
 [3507,3522,3524,3532,3540,3838,3840,3848,3856,4260,38499,38501,
   38509,38517,38921,38929,38937,38968,38976,39092,45025,45033,
   45041,45072,45080,45196,50882,50890,51006,51367],
 [3507,3522,3524,3533,3838,3840,3849,4260,38499,38501,38510,
   38921,38930,38969,45025,45034,45073,50883],
 [3507,3522,3524,3534,3838,3840,3850,4260,38499,38501,38511,
   38921,38931,38970,45025,45035,45074,50884],
 [3507,3522,3524,3535,3838,3840,3851,4260,38499,38501,38512,
   38921,38932,38971,45025,45036,45075,50885],
 [3507,3522,3524,3536,3838,3840,3852,4260,38499,38501,38513,
   38921,38933,38972,45025,45037,45076,50886],
 [3507,3522,3524,3537,3838,3840,3853,4260,38499,38501,38514,
   38921,38934,38973,45025,45038,45077,50887],
 [3507,3522,3524,3538,3539,3838,3840,3854,3855,4260,38499,38501,
   38515,38516,38921,38935,38936,38974,38975,39136,45025,45039,
   45040,45078,45079,45240,50888,50889,51050,51411],
 [3507,3522,3524,3538,3539,3838,3840,3854,3855,4260,38499,38501,
   38515,38516,38921,38935,38936,38974,38975,39136,45025,45039,
   45040,45078,45079,45240,50888,50889,51050,51411],
 [3507,3522,3524,3532,3540,3838,3840,3848,3856,4260,38499,38501,
   38509,38517,38921,38929,38937,38968,38976,39092,45025,45033,
   45041,45072,45080,45196,50882,50890,51006,51367],
 [3507,3522,3524,3541,3838,3840,3857,4260,38499,38501,38518,
   38921,38938,38977,45025,45042,45081,50891],
 [3507,3522,3524,3542,3838,3840,3858,4260,38499,38501,38519,
   38921,38939,38978,45025,45043,45082,50892],
 [3507,3522,3524,3543,3838,3840,3859,4260,38499,38501,38520,
   38921,38940,38979,45025,45044,45083,50893],[3507,45084],
 [3503,3504,3507,3509,3511,3525,3526,3527,3528,3670,3673,3675,
   3677,3712,3714,3716,3825,3827,3841,3842,3843,3844,3896,4319,
   4354,38331,38334,38336,38338,38352,38353,38354,38355,38373,
   38375,38377,38391,38392,38393,38394,38486,38488,38502,38503,
   38504,38505,38557,38571,38572,38573,38574,38636,38637,38638,
   38639,38980,38981,38982,38998,38999,39015,41737,41739,41741,
   41755,41756,41757,41758,41850,41852,41866,41867,41868,41869,
   41921,41935,41936,41937,41938,42000,42001,42002,42003,42344,
   42345,42346,42362,42363,42379,42591,42593,42607,42608,42609,
   42610,42662,42676,42677,42678,42679,42741,42742,42743,42744,
   43085,43086,43087,43103,43104,43120,44661,44675,44676,44677,
   44678,44740,44741,44742,44743,45084,45085,45086,45102,45103,
   45119,45896,45897,45898,45899,46240,46241,46242,46258,46259,
   46275,47264,47265,47266,47282,47283,47299,51426,51427,51443,
   51579],
 [3503,3504,3507,3509,3511,3525,3526,3527,3528,3670,3673,3675,
   3677,3712,3714,3716,3825,3827,3841,3842,3843,3844,3896,4319,
   4354,38331,38334,38336,38338,38352,38353,38354,38355,38373,
   38375,38377,38391,38392,38393,38394,38486,38488,38502,38503,
   38504,38505,38557,38571,38572,38573,38574,38636,38637,38638,
   38639,38980,38981,38982,38998,38999,39015,41737,41739,41741,
   41755,41756,41757,41758,41850,41852,41866,41867,41868,41869,
   41921,41935,41936,41937,41938,42000,42001,42002,42003,42344,
   42345,42346,42362,42363,42379,42591,42593,42607,42608,42609,
   42610,42662,42676,42677,42678,42679,42741,42742,42743,42744,
   43085,43086,43087,43103,43104,43120,44661,44675,44676,44677,
   44678,44740,44741,44742,44743,45084,45085,45086,45102,45103,
   45119,45896,45897,45898,45899,46240,46241,46242,46258,46259,
   46275,47264,47265,47266,47282,47283,47299,51426,51427,51443,
   51579],
 [3507,3525,3526,3529,3841,3842,3845,4319,38502,38503,38506,
   38980,38983,39000,45084,45087,45104,51428],
 [3507,3525,3526,3530,3841,3842,3846,4319,38502,38503,38507,
   38980,38984,39001,45084,45088,45105,51429],
 [3507,3525,3526,3531,3841,3842,3847,4319,38502,38503,38508,
   38980,38985,39002,45084,45089,45106,51430],
 [3507,3525,3526,3532,3841,3842,3848,4319,38502,38503,38509,
   38980,38986,39003,45084,45090,45107,51431],
 [3507,3525,3526,3533,3841,3842,3849,4319,38502,38503,38510,
   38980,38987,39004,45084,45091,45108,51432],
 [3507,3525,3526,3534,3841,3842,3850,4319,38502,38503,38511,
   38980,38988,39005,45084,45092,45109,51433],
 [3507,3525,3526,3535,3841,3842,3851,4319,38502,38503,38512,
   38980,38989,39006,45084,45093,45110,51434],
 [3507,3525,3526,3536,3841,3842,3852,4319,38502,38503,38513,
   38980,38990,39007,45084,45094,45111,51435],
 [3507,3525,3526,3537,3841,3842,3853,4319,38502,38503,38514,
   38980,38991,39008,45084,45095,45112,51436],
 [3507,3525,3526,3538,3841,3842,3854,4319,38502,38503,38515,
   38980,38992,39009,45084,45096,45113,51437],
 [3507,3525,3526,3539,3841,3842,3855,4319,38502,38503,38516,
   38980,38993,39010,45084,45097,45114,51438],
 [3507,3525,3526,3540,3841,3842,3856,4319,38502,38503,38517,
   38980,38994,39011,45084,45098,45115,51439],
 [3507,3525,3526,3541,3841,3842,3857,4319,38502,38503,38518,
   38980,38995,39012,45084,45099,45116,51440],
 [3507,3525,3526,3542,3841,3842,3858,4319,38502,38503,38519,
   38980,38996,39013,45084,45100,45117,51441],
 [3507,3525,3526,3543,3841,3842,3859,4319,38502,38503,38520,
   38980,38997,39014,45084,45101,45118,51442],
 [3503,3504,3507,3509,3511,3525,3526,3527,3528,3670,3673,3675,
   3677,3712,3714,3716,3825,3827,3841,3842,3843,3844,3896,4319,
   4354,38331,38334,38336,38338,38352,38353,38354,38355,38373,
   38375,38377,38391,38392,38393,38394,38486,38488,38502,38503,
   38504,38505,38557,38571,38572,38573,38574,38636,38637,38638,
   38639,38980,38981,38982,38998,38999,39015,41737,41739,41741,
   41755,41756,41757,41758,41850,41852,41866,41867,41868,41869,
   41921,41935,41936,41937,41938,42000,42001,42002,42003,42344,
   42345,42346,42362,42363,42379,42591,42593,42607,42608,42609,
   42610,42662,42676,42677,42678,42679,42741,42742,42743,42744,
   43085,43086,43087,43103,43104,43120,44661,44675,44676,44677,
   44678,44740,44741,44742,44743,45084,45085,45086,45102,45103,
   45119,45896,45897,45898,45899,46240,46241,46242,46258,46259,
   46275,47264,47265,47266,47282,47283,47299,51426,51427,51443,
   51579],
 [3503,3504,3507,3509,3511,3525,3526,3527,3528,3670,3673,3675,
   3677,3712,3714,3716,3825,3827,3841,3842,3843,3844,3896,4319,
   4354,38331,38334,38336,38338,38352,38353,38354,38355,38373,
   38375,38377,38391,38392,38393,38394,38486,38488,38502,38503,
   38504,38505,38557,38571,38572,38573,38574,38636,38637,38638,
   38639,38980,38981,38982,38998,38999,39015,41737,41739,41741,
   41755,41756,41757,41758,41850,41852,41866,41867,41868,41869,
   41921,41935,41936,41937,41938,42000,42001,42002,42003,42344,
   42345,42346,42362,42363,42379,42591,42593,42607,42608,42609,
   42610,42662,42676,42677,42678,42679,42741,42742,42743,42744,
   43085,43086,43087,43103,43104,43120,44661,44675,44676,44677,
   44678,44740,44741,44742,44743,45084,45085,45086,45102,45103,
   45119,45896,45897,45898,45899,46240,46241,46242,46258,46259,
   46275,47264,47265,47266,47282,47283,47299,51426,51427,51443,
   51579],
 [3507,3525,3526,3529,3841,3842,3845,4319,38502,38503,38506,
   38980,38983,39000,45084,45087,45104,51428],
 [3507,3525,3526,3530,3841,3842,3846,4319,38502,38503,38507,
   38980,38984,39001,45084,45088,45105,51429],
 [3507,3525,3526,3531,3841,3842,3847,4319,38502,38503,38508,
   38980,38985,39002,45084,45089,45106,51430],
 [3507,3525,3526,3532,3841,3842,3848,4319,38502,38503,38509,
   38980,38986,39003,45084,45090,45107,51431],
 [3507,3525,3526,3533,3841,3842,3849,4319,38502,38503,38510,
   38980,38987,39004,45084,45091,45108,51432],
 [3507,3525,3526,3534,3841,3842,3850,4319,38502,38503,38511,
   38980,38988,39005,45084,45092,45109,51433],
 [3507,3525,3526,3535,3841,3842,3851,4319,38502,38503,38512,
   38980,38989,39006,45084,45093,45110,51434],
 [3507,3525,3526,3536,3841,3842,3852,4319,38502,38503,38513,
   38980,38990,39007,45084,45094,45111,51435],
 [3507,3525,3526,3537,3841,3842,3853,4319,38502,38503,38514,
   38980,38991,39008,45084,45095,45112,51436],
 [3507,3525,3526,3538,3841,3842,3854,4319,38502,38503,38515,
   38980,38992,39009,45084,45096,45113,51437],
 [3507,3525,3526,3539,3841,3842,3855,4319,38502,38503,38516,
   38980,38993,39010,45084,45097,45114,51438],
 [3507,3525,3526,3540,3841,3842,3856,4319,38502,38503,38517,
   38980,38994,39011,45084,45098,45115,51439],
 [3507,3525,3526,3541,3841,3842,3857,4319,38502,38503,38518,
   38980,38995,39012,45084,45099,45116,51440],
 [3507,3525,3526,3542,3841,3842,3858,4319,38502,38503,38519,
   38980,38996,39013,45084,45100,45117,51441],
 [3507,3525,3526,3543,3841,3842,3859,4319,38502,38503,38520,
   38980,38997,39014,45084,45101,45118,51442],[3507,39015],
 [3507,3527,3528,3529,3843,3844,3845,4354,38504,38505,38506,
   39015,39016,39031,45119,45120,45135,51715],
 [3507,3527,3528,3530,3843,3844,3846,4354,38504,38505,38507,
   39015,39017,39032,45119,45121,45136,51716],
 [3507,3527,3528,3531,3843,3844,3847,4354,38504,38505,38508,
   39015,39018,39033,45119,45122,45137,51717],
 [3507,3527,3528,3532,3843,3844,3848,4354,38504,38505,38509,
   39015,39019,39034,45119,45123,45138,51718],
 [3507,3527,3528,3533,3843,3844,3849,4354,38504,38505,38510,
   39015,39020,39035,45119,45124,45139,51719],
 [3507,3527,3528,3534,3843,3844,3850,4354,38504,38505,38511,
   39015,39021,39036,45119,45125,45140,51720],
 [3507,3527,3528,3535,3843,3844,3851,4354,38504,38505,38512,
   39015,39022,39037,45119,45126,45141,51721],
 [3507,3527,3528,3536,3843,3844,3852,4354,38504,38505,38513,
   39015,39023,39038,45119,45127,45142,51722],
 [3507,3527,3528,3537,3843,3844,3853,4354,38504,38505,38514,
   39015,39024,39039,45119,45128,45143,51723],
 [3507,3527,3528,3538,3843,3844,3854,4354,38504,38505,38515,
   39015,39025,39040,45119,45129,45144,51724],
 [3507,3527,3528,3539,3843,3844,3855,4354,38504,38505,38516,
   39015,39026,39041,45119,45130,45145,51725],
 [3507,3527,3528,3540,3843,3844,3856,4354,38504,38505,38517,
   39015,39027,39042,45119,45131,45146,51726],
 [3507,3527,3528,3541,3843,3844,3857,4354,38504,38505,38518,
   39015,39028,39043,45119,45132,45147,51727],
 [3507,3527,3528,3542,3843,3844,3858,4354,38504,38505,38519,
   39015,39029,39044,45119,45133,45148,51728],
 [3507,3527,3528,3543,3843,3844,3859,4354,38504,38505,38520,
   39015,39030,39045,45119,45134,45149,51729],
 [3507,3527,3528,3529,3843,3844,3845,4354,38504,38505,38506,
   39015,39016,39031,45119,45120,45135,51715],
 [3507,3527,3528,3530,3843,3844,3846,4354,38504,38505,38507,
   39015,39017,39032,45119,45121,45136,51716],
 [3507,3527,3528,3531,3843,3844,3847,4354,38504,38505,38508,
   39015,39018,39033,45119,45122,45137,51717],
 [3507,3527,3528,3532,3843,3844,3848,4354,38504,38505,38509,
   39015,39019,39034,45119,45123,45138,51718],
 [3507,3527,3528,3533,3843,3844,3849,4354,38504,38505,38510,
   39015,39020,39035,45119,45124,45139,51719],
 [3507,3527,3528,3534,3843,3844,3850,4354,38504,38505,38511,
   39015,39021,39036,45119,45125,45140,51720],
 [3507,3527,3528,3535,3843,3844,3851,4354,38504,38505,38512,
   39015,39022,39037,45119,45126,45141,51721],
 [3507,3527,3528,3536,3843,3844,3852,4354,38504,38505,38513,
   39015,39023,39038,45119,45127,45142,51722],
 [3507,3527,3528,3537,3843,3844,3853,4354,38504,38505,38514,
   39015,39024,39039,45119,45128,45143,51723],
 [3507,3527,3528,3538,3843,3844,3854,4354,38504,38505,38515,
   39015,39025,39040,45119,45129,45144,51724],
 [3507,3527,3528,3539,3843,3844,3855,4354,38504,38505,38516,
   39015,39026,39041,45119,45130,45145,51725],
 [3507,3527,3528,3540,3843,3844,3856,4354,38504,38505,38517,
   39015,39027,39042,45119,45131,45146,51726],
 [3507,3527,3528,3541,3843,3844,3857,4354,38504,38505,38518,
   39015,39028,39043,45119,45132,45147,51727],
 [3507,3527,3528,3542,3843,3844,3858,4354,38504,38505,38519,
   39015,39029,39044,45119,45133,45148,51728],
 [3507,3527,3528,3543,3843,3844,3859,4354,38504,38505,38520,
   39015,39030,39045,45119,45134,45149,51729],
 [3502,3507,3508,3529,3530,3633,3634,3824,3845,3846,38294,38295,
   38316,38317,38485,38506,38507,38541,38542,39046,41069,41090,
   41091,41125,41126,41630,44645,44646,45150,45745],
 [3677,42004,42006,42411,47331],[],[],[],[],[],[],
 [],[],[],[],[],[],
 [3500,3501,3507,3530,3531,3544,3550,3592,3846,3847,38205,38211,
   38234,38235,38253,38276,38277,38507,38508,39060,39156,39179,
   39180,39410,39411,39963,40271,40272,40824,45164],[],[],
 [],[3507,3530,3535,3846,3851,38507,38512,39064,45168],
 [3507,3530,3536,3846,3852,38507,38513,39065,45169],[],[],
 [],[],[3507,3530,3541,3846,3857,38507,38518,39070,45174],
 [],[3507,3530,3543,3846,3859,38507,38520,39072,45176],[],
 [],[],[],[],[],[],[],[],[],[],[],
 [3677,42007,42008,42449,47369],[],[],[],[],[14514],
 [],[3507,3522,3524,3532,3540,3838,3840,3848,3856,4260,38499,
   38501,38509,38517,38921,38929,38937,38968,38976,39092,45025,
   45033,45041,45072,45080,45196,50882,50890,51006,51367],[],
 [],[],[],[],[],[14523],[],[],
 [3507,3517,3518,3533,3540,3833,3834,3849,3856,4139,38494,38495,
   38510,38517,38800,38815,38822,38840,38847,39102,44904,44919,
   44926,44944,44951,45206,49484,49491,49746,50046],[],[],
 [],[3500,3501,3507,3534,3535,3544,3550,3592,3850,3851,38205,
   38211,38238,38239,38253,38280,38281,38511,38512,39106,39156,
   39183,39184,39414,39415,40009,40275,40276,40870,45210],
 [3502,3507,3508,3534,3536,3633,3634,3824,3850,3852,38294,38295,
   38321,38323,38485,38511,38513,38546,38548,39107,41069,41095,
   41097,41130,41132,41691,44650,44652,45211,45806],[],[],
 [],[],[],[19848],[],[3677,42010,42011,42479,47399],
 [],[],[],[],[],[],[19857],[],[],[],[],
 [19862],[],[],[3677,42012,42013,42494,47414],
 [3507,3517,3518,3537,3539,3833,3834,3853,3855,4139,38494,38495,
   38514,38516,38800,38819,38821,38844,38846,39131,44904,44923,
   44925,44948,44950,45235,49488,49490,49775,50075],[],[],
 [],[],
 [3507,3522,3524,3538,3539,3838,3840,3854,3855,4260,38499,38501,
   38515,38516,38921,38935,38936,38974,38975,39136,45025,45039,
   45040,45078,45079,45240,50888,50889,51050,51411],[],[],
 [],[],[14565],[],[],[],[],[],[],
 [3502,3507,3508,3541,3542,3633,3634,3824,3857,3858,38294,38295,
   38328,38329,38485,38518,38519,38553,38554,39148,41069,41102,
   41103,41137,41138,41732,44657,44658,45252,45847],
 [3677,42016,42018,42513,47433],
 [3500,3501,3507,3542,3543,3544,3550,3592,3858,3859,38205,38211,
   38246,38247,38253,38288,38289,38519,38520,39150,39156,39191,
   39192,39422,39423,40053,40283,40284,40914,45254],[2279],
 [2279],
 [2279,2280,2281,2300,2301,2302,2308,2318,2319,2345,2346,2365,
   2366,2367,2373,2383,2384,2410,2411,2429,2430,2431,2437,2447,
   2448,2474,2492,2493,2494,2500,2510,2511,2554,2555,2556,2562,
   2572,2573,3500,3501,3507,3517,3518,3544,3550,3560,3561,3592,
   3602,3603,3833,3834,4139,4490,4491,4510,4511,4512,4518,4528,
   4529,4555,4556,4574,4575,4576,4582,4592,4593,4619,4637,4638,
   4639,4645,4655,4656,4699,4700,4701,4707,4717,4718,5645,5646,
   5652,5662,5663,5689,5695,5705,5706,5737,5747,5748,5978,5979,
   6284,6635,6636,6654,6655,6656,6662,6672,6673,6699,6717,6718,
   6719,6725,6735,6736,6779,6780,6781,6787,6797,6798,7725,7726,
   7732,7742,7743,7769,7775,7785,7786,7817,7827,7828,8058,8059,
   8364,8715,8733,8734,8735,8741,8751,8752,8795,8796,8797,8803,
   8813,8814,9741,9742,9748,9758,9759,9785,9791,9801,9802,9833,
   9843,9844,10074,10075,10380,10748,10749,10750,10756,10766,
   10767,11694,11695,11701,11711,11712,11738,11744,11754,11755,
   11786,11796,11797,12027,12028,12333,13585,13586,13592,13602,
   13603,13629,13635,13645,13646,13677,13687,13688,13918,13919,
   14224,38205,38211,38221,38222,38253,38263,38264,38494,38495,
   38800,39156,39166,39167,39397,39398,39703,40258,40259,40564,
   44904],[2279],[2279],
 [2279,2281,2284,2300,2301,2302,2308,2318,2319,2346,2349,2365,
   2366,2367,2373,2383,2384,2476,2477,2492,2493,2494,2500,2510,
   2511,2660,2675,2676,2677,2683,2693,2694,2734,2735,2736,2742,
   2752,2753,3500,3501,3507,3517,3518,3544,3550,3560,3561,3592,
   3602,3603,3833,3834,4139,4491,4494,4510,4511,4512,4518,4528,
   4529,4621,4622,4637,4638,4639,4645,4655,4656,4805,4820,4821,
   4822,4828,4838,4839,4879,4880,4881,4887,4897,4898,5645,5646,
   5652,5662,5663,5689,5695,5705,5706,5737,5747,5748,5978,5979,
   6284,6701,6702,6717,6718,6719,6725,6735,6736,6885,6900,6901,
   6902,6908,6918,6919,6959,6960,6961,6967,6977,6978,7725,7726,
   7732,7742,7743,7769,7775,7785,7786,7817,7827,7828,8058,8059,
   8364,10854,10869,10870,10871,10877,10887,10888,10928,10929,
   10930,10936,10946,10947,11694,11695,11701,11711,11712,11738,
   11744,11754,11755,11786,11796,11797,12027,12028,12333,16419,
   16420,16421,16427,16437,16438,17185,17186,17192,17202,17203,
   17229,17235,17245,17246,17277,17287,17288,17518,17519,17824,
   18896,18897,18903,18913,18914,18940,18946,18956,18957,18988,
   18998,18999,19229,19230,19535,38205,38211,38221,38222,38253,
   38263,38264,38494,38495,38800,39156,39166,39167,39397,39398,
   39703,40258,40259,40564,44904],[2279],
 [2279,2305,2310,2321,2370,2375,2386,2854,2859,2870,3714,3725,
   3905,4515,4520,4531,4999,5004,5015,5859,5870,6050,7079,7084,
   7095,7939,7950,8130,22359,22370,22550,42671],[2279],
 [2279],[2279],[2279],
 [2279,2290,2291,2355,2356,3005,3006,3059,4500,4501,5150,5151,
   5204,7230,7231,7284,26160],[2279],
 [2279,2291,2293,2356,2358,3060,3061,3164,4501,4503,5205,5206,
   5309,7285,7286,7389,27643],[2279],[2279],
 [2279,2293,2296,2358,2361,3166,3167,3314,4503,4506,5311,5312,
   5459,7391,7392,7539,30394],[2279],
 [2279,2291,2293,2294,2356,2358,2359,3060,3061,3066,3164,3169,
   3219,4501,4503,4504,5205,5206,5211,5309,5314,5364,7285,7286,
   7291,7389,7394,7444,27643,27648,27698,30299],
 [2279,3500,3501,3507,3517,3518,3544,3550,3592,3833,3834,4139,
   5645,5646,5662,5689,5695,5705,5706,5747,5978,5979,6284,7725,
   7726,7743,7769,7786,7817,7827,7828,8058,8059,8364,38205,
   38211,38221,38222,38253,38263,38264,38494,38495,38800,39156,
   39166,39167,39397,39398,39703,40258,40259,40564,44904],
 [2279,3500,3501,3507,3517,3518,3544,3550,3592,3833,3834,4139,
   5645,5646,5662,5689,5695,5705,5706,5747,5978,5979,6284,7725,
   7726,7743,7769,7786,7817,7827,7828,8058,8059,8364,38205,
   38211,38221,38222,38253,38263,38264,38494,38495,38800,39156,
   39166,39167,39397,39398,39703,40258,40259,40564,44904],
 [2279,3500,3501,3507,3517,3518,3544,3550,3592,3833,3834,4139,
   5645,5646,5662,5689,5695,5705,5706,5747,5978,5979,6284,7725,
   7726,7743,7769,7786,7817,7827,7828,8058,8059,8364,38205,
   38211,38221,38222,38253,38263,38264,38494,38495,38800,39156,
   39166,39167,39397,39398,39703,40258,40259,40564,44904],
 [1,2,23,26,31,32,41,42,44,68,89,90,91,92,93,94,107,156,
   157,158,163,164,166,173,177,179,1289,1290,1291,1292,1293,
   1296,1297,1298,1300,1306,1307,1309,1311,1313,1333,1334,1335,
   1336,1339,1340,1341,1343,1349,1350,1352,1354,1356,1376,1377,
   1378,1381,1382,1383,1385,1391,1392,1394,1396,1398,1418,1419,
   1422,1423,1424,1426,1432,1433,1435,1437,1439,1459,1462,1463,
   1464,1466,1472,1473,1475,1477,1479,1501,1502,1503,1505,1511,
   1512,1514,1516,1518,1613,1614,1616,1622,1623,1625,1627,1629,
   1649,1651,1657,1658,1660,1662,1664,1685,1691,1692,1694,1696,
   1698,1756,1757,1759,1761,1763,1928,1930,1932,1934,1955,1957,
   1959,2004,2006,2049,2279,2300,2301,2302,2305,2308,2310,2318,
   2319,2321,2365,2366,2367,2370,2373,2375,2383,2384,2386,3500,
   3501,3502,3503,3504,3507,3508,3509,3511,3517,3518,3520,3522,
   3524,3544,3545,3546,3547,3550,3551,3552,3554,3560,3561,3563,
   3565,3567,3587,3588,3589,3592,3593,3594,3596,3602,3603,3605,
   3607,3609,3629,3630,3633,3634,3635,3637,3643,3644,3646,3648,
   3650,3670,3673,3674,3675,3677,3683,3684,3686,3688,3690,3712,
   3713,3714,3716,3722,3723,3725,3727,3729,3824,3825,3827,3833,
   3834,3836,3838,3840,3860,3862,3868,3869,3871,3873,3875,3896,
   3902,3903,3905,3907,3909,3967,3968,3970,3972,3974,4139,4141,
   4143,4145,4166,4168,4170,4215,4217,4260,4510,4511,4512,4515,
   4518,4520,4528,4529,4531,5645,5646,5647,5648,5649,5652,5653,
   5654,5656,5662,5663,5665,5667,5669,5689,5690,5691,5692,5695,
   5696,5697,5699,5705,5706,5708,5710,5712,5732,5733,5734,5737,
   5738,5739,5741,5747,5748,5750,5752,5754,5774,5775,5778,5779,
   5780,5782,5788,5789,5791,5793,5795,5815,5818,5819,5820,5822,
   5828,5829,5831,5833,5835,5857,5858,5859,5861,5867,5868,5870,
   5872,5874,5969,5970,5972,5978,5979,5981,5983,5985,6005,6007,
   6013,6014,6016,6018,6020,6041,6047,6048,6050,6052,6054,6112,
   6113,6115,6117,6119,6284,6286,6288,6290,6311,6313,6315,6360,
   6362,6405,7725,7726,7727,7728,7729,7732,7733,7734,7736,7742,
   7743,7745,7747,7749,7769,7770,7771,7772,7775,7776,7777,7779,
   7785,7786,7788,7790,7792,7812,7813,7814,7817,7818,7819,7821,
   7827,7828,7830,7832,7834,7854,7855,7858,7859,7860,7862,7868,
   7869,7871,7873,7875,7895,7898,7899,7900,7902,7908,7909,7911,
   7913,7915,7937,7938,7939,7941,7947,7948,7950,7952,7954,8049,
   8050,8052,8058,8059,8061,8063,8065,8085,8087,8093,8094,8096,
   8098,8100,8121,8127,8128,8130,8132,8134,8192,8193,8195,8197,
   8199,8364,8366,8368,8370,8391,8393,8395,8440,8442,8485,
   38205,38206,38207,38208,38211,38212,38213,38215,38221,38222,
   38224,38226,38228,38248,38249,38250,38253,38254,38255,38257,
   38263,38264,38266,38268,38270,38290,38291,38294,38295,38296,
   38298,38304,38305,38307,38309,38311,38331,38334,38335,38336,
   38338,38344,38345,38347,38349,38351,38373,38374,38375,38377,
   38383,38384,38386,38388,38390,38485,38486,38488,38494,38495,
   38497,38499,38501,38521,38523,38529,38530,38532,38534,38536,
   38557,38563,38564,38566,38568,38570,38628,38629,38631,38633,
   38635,38800,38802,38804,38806,38827,38829,38831,38876,38878,
   38921,39151,39152,39153,39156,39157,39158,39160,39166,39167,
   39169,39171,39173,39193,39194,39197,39198,39199,39201,39207,
   39208,39210,39212,39214,39234,39237,39238,39239,39241,39247,
   39248,39250,39252,39254,39276,39277,39278,39280,39286,39287,
   39289,39291,39293,39388,39389,39391,39397,39398,39400,39402,
   39404,39424,39426,39432,39433,39435,39437,39439,39460,39466,
   39467,39469,39471,39473,39531,39532,39534,39536,39538,39703,
   39705,39707,39709,39730,39732,39734,39779,39781,39824,40054,
   40055,40058,40059,40060,40062,40068,40069,40071,40073,40075,
   40095,40098,40099,40100,40102,40108,40109,40111,40113,40115,
   40137,40138,40139,40141,40147,40148,40150,40152,40154,40249,
   40250,40252,40258,40259,40261,40263,40265,40285,40287,40293,
   40294,40296,40298,40300,40321,40327,40328,40330,40332,40334,
   40392,40393,40395,40397,40399,40564,40566,40568,40570,40591,
   40593,40595,40640,40642,40685,40915,40918,40919,40920,40922,
   40928,40929,40931,40933,40935,40957,40958,40959,40961,40967,
   40968,40970,40972,40974,41069,41070,41072,41078,41079,41081,
   41083,41085,41105,41107,41113,41114,41116,41118,41120,41141,
   41147,41148,41150,41152,41154,41212,41213,41215,41217,41219,
   41384,41386,41388,41390,41411,41413,41415,41460,41462,41505,
   41737,41738,41739,41741,41747,41748,41750,41752,41754,41849,
   41850,41852,41858,41859,41861,41863,41865,41885,41887,41893,
   41894,41896,41898,41900,41921,41927,41928,41930,41932,41934,
   41992,41993,41995,41997,41999,42164,42166,42168,42170,42191,
   42193,42195,42240,42242,42285,42590,42591,42593,42599,42600,
   42602,42604,42606,42626,42628,42634,42635,42637,42639,42641,
   42662,42668,42669,42671,42673,42675,42733,42734,42736,42738,
   42740,42905,42907,42909,42911,42932,42934,42936,42981,42983,
   43026,44625,44627,44633,44634,44636,44638,44640,44661,44667,
   44668,44670,44672,44674,44732,44733,44735,44737,44739,44904,
   44906,44908,44910,44931,44933,44935,44980,44982,45025,45256,
   45262,45263,45265,45267,45269,45327,45328,45330,45332,45334,
   45499,45501,45503,45505,45526,45528,45530,45575,45577,45620,
   45888,45889,45891,45893,45895,46060,46062,46064,46066,46087,
   46089,46091,46136,46138,46181,47084,47086,47088,47090,47111,
   47113,47115,47160,47162,47205,49471,49473,49475,49520,49522,
   49565,49820,49822,49865,50394],
 [1,2,23,26,31,32,41,42,44,68,89,90,91,92,93,94,107,156,
   157,158,163,164,166,173,177,179,1289,1290,1291,1292,1293,
   1296,1297,1298,1300,1306,1307,1309,1311,1313,1333,1334,1335,
   1336,1339,1340,1341,1343,1349,1350,1352,1354,1356,1376,1377,
   1378,1381,1382,1383,1385,1391,1392,1394,1396,1398,1418,1419,
   1422,1423,1424,1426,1432,1433,1435,1437,1439,1459,1462,1463,
   1464,1466,1472,1473,1475,1477,1479,1501,1502,1503,1505,1511,
   1512,1514,1516,1518,1613,1614,1616,1622,1623,1625,1627,1629,
   1649,1651,1657,1658,1660,1662,1664,1685,1691,1692,1694,1696,
   1698,1756,1757,1759,1761,1763,1928,1930,1932,1934,1955,1957,
   1959,2004,2006,2049,2279,2300,2301,2302,2305,2308,2310,2318,
   2319,2321,2365,2366,2367,2370,2373,2375,2383,2384,2386,3500,
   3501,3502,3503,3504,3507,3508,3509,3511,3517,3518,3520,3522,
   3524,3544,3545,3546,3547,3550,3551,3552,3554,3560,3561,3563,
   3565,3567,3587,3588,3589,3592,3593,3594,3596,3602,3603,3605,
   3607,3609,3629,3630,3633,3634,3635,3637,3643,3644,3646,3648,
   3650,3670,3673,3674,3675,3677,3683,3684,3686,3688,3690,3712,
   3713,3714,3716,3722,3723,3725,3727,3729,3824,3825,3827,3833,
   3834,3836,3838,3840,3860,3862,3868,3869,3871,3873,3875,3896,
   3902,3903,3905,3907,3909,3967,3968,3970,3972,3974,4139,4141,
   4143,4145,4166,4168,4170,4215,4217,4260,4510,4511,4512,4515,
   4518,4520,4528,4529,4531,5645,5646,5647,5648,5649,5652,5653,
   5654,5656,5662,5663,5665,5667,5669,5689,5690,5691,5692,5695,
   5696,5697,5699,5705,5706,5708,5710,5712,5732,5733,5734,5737,
   5738,5739,5741,5747,5748,5750,5752,5754,5774,5775,5778,5779,
   5780,5782,5788,5789,5791,5793,5795,5815,5818,5819,5820,5822,
   5828,5829,5831,5833,5835,5857,5858,5859,5861,5867,5868,5870,
   5872,5874,5969,5970,5972,5978,5979,5981,5983,5985,6005,6007,
   6013,6014,6016,6018,6020,6041,6047,6048,6050,6052,6054,6112,
   6113,6115,6117,6119,6284,6286,6288,6290,6311,6313,6315,6360,
   6362,6405,7725,7726,7727,7728,7729,7732,7733,7734,7736,7742,
   7743,7745,7747,7749,7769,7770,7771,7772,7775,7776,7777,7779,
   7785,7786,7788,7790,7792,7812,7813,7814,7817,7818,7819,7821,
   7827,7828,7830,7832,7834,7854,7855,7858,7859,7860,7862,7868,
   7869,7871,7873,7875,7895,7898,7899,7900,7902,7908,7909,7911,
   7913,7915,7937,7938,7939,7941,7947,7948,7950,7952,7954,8049,
   8050,8052,8058,8059,8061,8063,8065,8085,8087,8093,8094,8096,
   8098,8100,8121,8127,8128,8130,8132,8134,8192,8193,8195,8197,
   8199,8364,8366,8368,8370,8391,8393,8395,8440,8442,8485,
   38205,38206,38207,38208,38211,38212,38213,38215,38221,38222,
   38224,38226,38228,38248,38249,38250,38253,38254,38255,38257,
   38263,38264,38266,38268,38270,38290,38291,38294,38295,38296,
   38298,38304,38305,38307,38309,38311,38331,38334,38335,38336,
   38338,38344,38345,38347,38349,38351,38373,38374,38375,38377,
   38383,38384,38386,38388,38390,38485,38486,38488,38494,38495,
   38497,38499,38501,38521,38523,38529,38530,38532,38534,38536,
   38557,38563,38564,38566,38568,38570,38628,38629,38631,38633,
   38635,38800,38802,38804,38806,38827,38829,38831,38876,38878,
   38921,39151,39152,39153,39156,39157,39158,39160,39166,39167,
   39169,39171,39173,39193,39194,39197,39198,39199,39201,39207,
   39208,39210,39212,39214,39234,39237,39238,39239,39241,39247,
   39248,39250,39252,39254,39276,39277,39278,39280,39286,39287,
   39289,39291,39293,39388,39389,39391,39397,39398,39400,39402,
   39404,39424,39426,39432,39433,39435,39437,39439,39460,39466,
   39467,39469,39471,39473,39531,39532,39534,39536,39538,39703,
   39705,39707,39709,39730,39732,39734,39779,39781,39824,40054,
   40055,40058,40059,40060,40062,40068,40069,40071,40073,40075,
   40095,40098,40099,40100,40102,40108,40109,40111,40113,40115,
   40137,40138,40139,40141,40147,40148,40150,40152,40154,40249,
   40250,40252,40258,40259,40261,40263,40265,40285,40287,40293,
   40294,40296,40298,40300,40321,40327,40328,40330,40332,40334,
   40392,40393,40395,40397,40399,40564,40566,40568,40570,40591,
   40593,40595,40640,40642,40685,40915,40918,40919,40920,40922,
   40928,40929,40931,40933,40935,40957,40958,40959,40961,40967,
   40968,40970,40972,40974,41069,41070,41072,41078,41079,41081,
   41083,41085,41105,41107,41113,41114,41116,41118,41120,41141,
   41147,41148,41150,41152,41154,41212,41213,41215,41217,41219,
   41384,41386,41388,41390,41411,41413,41415,41460,41462,41505,
   41737,41738,41739,41741,41747,41748,41750,41752,41754,41849,
   41850,41852,41858,41859,41861,41863,41865,41885,41887,41893,
   41894,41896,41898,41900,41921,41927,41928,41930,41932,41934,
   41992,41993,41995,41997,41999,42164,42166,42168,42170,42191,
   42193,42195,42240,42242,42285,42590,42591,42593,42599,42600,
   42602,42604,42606,42626,42628,42634,42635,42637,42639,42641,
   42662,42668,42669,42671,42673,42675,42733,42734,42736,42738,
   42740,42905,42907,42909,42911,42932,42934,42936,42981,42983,
   43026,44625,44627,44633,44634,44636,44638,44640,44661,44667,
   44668,44670,44672,44674,44732,44733,44735,44737,44739,44904,
   44906,44908,44910,44931,44933,44935,44980,44982,45025,45256,
   45262,45263,45265,45267,45269,45327,45328,45330,45332,45334,
   45499,45501,45503,45505,45526,45528,45530,45575,45577,45620,
   45888,45889,45891,45893,45895,46060,46062,46064,46066,46087,
   46089,46091,46136,46138,46181,47084,47086,47088,47090,47111,
   47113,47115,47160,47162,47205,49471,49473,49475,49520,49522,
   49565,49820,49822,49865,50394],
 [2279,3714,3725,3905,5859,5870,6050,7939,7950,8130,42671],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,
   2384,3500,3501,3505,3506,3507,3513,3514,3517,3518,3527,3528,
   3544,3548,3549,3550,3556,3557,3560,3561,3570,3571,3590,3591,
   3592,3598,3599,3602,3603,3612,3613,3749,3750,3756,3757,3760,
   3761,3770,3771,3787,3793,3794,3797,3798,3829,3830,3833,3834,
   3843,3844,4025,4028,4029,4038,4039,4057,4058,4139,4148,4149,
   4173,4174,4354,4510,4511,4512,4518,4528,4529,5645,5646,5650,
   5651,5652,5658,5659,5662,5663,5672,5673,5689,5693,5694,5695,
   5701,5702,5705,5706,5715,5716,5735,5736,5737,5743,5744,5747,
   5748,5757,5758,5894,5895,5902,5905,5906,5916,5932,5939,5942,
   5943,5953,5974,5975,5978,5979,5988,5989,6170,6173,6174,6183,
   6184,6202,6203,6212,6213,6284,6293,6294,6318,6319,6499,7725,
   7726,7730,7731,7732,7738,7739,7742,7743,7752,7753,7769,7773,
   7774,7775,7781,7782,7785,7786,7795,7796,7815,7816,7817,7823,
   7824,7827,7828,7837,7838,7974,7975,7985,7986,7995,7996,8012,
   8018,8019,8022,8023,8032,8033,8054,8055,8058,8059,8068,8069,
   8250,8253,8254,8263,8282,8283,8292,8364,8373,8374,8398,8399,
   8579,38205,38209,38210,38211,38217,38218,38221,38222,38231,
   38232,38251,38252,38253,38259,38260,38263,38264,38273,38274,
   38410,38411,38417,38418,38421,38422,38431,38432,38448,38454,
   38455,38458,38459,38468,38469,38490,38491,38494,38495,38504,
   38505,38686,38689,38690,38699,38700,38718,38719,38728,38729,
   38800,38809,38810,38834,38835,39015,39154,39155,39156,39162,
   39163,39166,39167,39176,39177,39313,39314,39320,39321,39324,
   39325,39334,39335,39351,39357,39358,39361,39362,39371,39372,
   39393,39394,39397,39398,39407,39408,39589,39592,39593,39602,
   39603,39621,39622,39631,39632,39703,39712,39713,39737,39738,
   39918,40174,40175,40181,40182,40185,40186,40195,40196,40212,
   40218,40219,40222,40223,40232,40233,40254,40255,40258,40259,
   40268,40269,40450,40453,40454,40463,40464,40482,40483,40492,
   40493,40564,40573,40574,40598,40599,40779,43256,43262,43263,
   43266,43267,43276,43277,43298,43299,43302,43303,43312,43313,
   43494,43497,43498,43507,43508,43526,43527,43536,43537,43608,
   43617,43618,43642,43643,43823,43964,43965,43968,43969,43978,
   43979,44160,44163,44164,44173,44174,44192,44193,44202,44203,
   44274,44283,44284,44308,44309,44489,44790,44793,44794,44803,
   44804,44822,44823,44832,44833,44904,44913,44914,44938,44939,
   45119,47902,47903,47912,47913,47984,47993,47994,48018,48019,
   48199,48390,48399,48400,48424,48425,48605,49478,49479,49659,
   49959],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,
   2384,3500,3501,3505,3506,3507,3513,3514,3517,3518,3527,3528,
   3544,3548,3549,3550,3556,3557,3560,3561,3570,3571,3590,3591,
   3592,3598,3599,3602,3603,3612,3613,3749,3750,3756,3757,3760,
   3761,3770,3771,3787,3793,3794,3797,3798,3829,3830,3833,3834,
   3843,3844,4025,4028,4029,4038,4039,4057,4058,4139,4148,4149,
   4173,4174,4354,4510,4511,4512,4518,4528,4529,5645,5646,5650,
   5651,5652,5658,5659,5662,5663,5672,5673,5689,5693,5694,5695,
   5701,5702,5705,5706,5715,5716,5735,5736,5737,5743,5744,5747,
   5748,5757,5758,5894,5895,5902,5905,5906,5916,5932,5939,5942,
   5943,5953,5974,5975,5978,5979,5988,5989,6170,6173,6174,6183,
   6184,6202,6203,6212,6213,6284,6293,6294,6318,6319,6499,7725,
   7726,7730,7731,7732,7738,7739,7742,7743,7752,7753,7769,7773,
   7774,7775,7781,7782,7785,7786,7795,7796,7815,7816,7817,7823,
   7824,7827,7828,7837,7838,7974,7975,7985,7986,7995,7996,8012,
   8018,8019,8022,8023,8032,8033,8054,8055,8058,8059,8068,8069,
   8250,8253,8254,8263,8282,8283,8292,8364,8373,8374,8398,8399,
   8579,38205,38209,38210,38211,38217,38218,38221,38222,38231,
   38232,38251,38252,38253,38259,38260,38263,38264,38273,38274,
   38410,38411,38417,38418,38421,38422,38431,38432,38448,38454,
   38455,38458,38459,38468,38469,38490,38491,38494,38495,38504,
   38505,38686,38689,38690,38699,38700,38718,38719,38728,38729,
   38800,38809,38810,38834,38835,39015,39154,39155,39156,39162,
   39163,39166,39167,39176,39177,39313,39314,39320,39321,39324,
   39325,39334,39335,39351,39357,39358,39361,39362,39371,39372,
   39393,39394,39397,39398,39407,39408,39589,39592,39593,39602,
   39603,39621,39622,39631,39632,39703,39712,39713,39737,39738,
   39918,40174,40175,40181,40182,40185,40186,40195,40196,40212,
   40218,40219,40222,40223,40232,40233,40254,40255,40258,40259,
   40268,40269,40450,40453,40454,40463,40464,40482,40483,40492,
   40493,40564,40573,40574,40598,40599,40779,43256,43262,43263,
   43266,43267,43276,43277,43298,43299,43302,43303,43312,43313,
   43494,43497,43498,43507,43508,43526,43527,43536,43537,43608,
   43617,43618,43642,43643,43823,43964,43965,43968,43969,43978,
   43979,44160,44163,44164,44173,44174,44192,44193,44202,44203,
   44274,44283,44284,44308,44309,44489,44790,44793,44794,44803,
   44804,44822,44823,44832,44833,44904,44913,44914,44938,44939,
   45119,47902,47903,47912,47913,47984,47993,47994,48018,48019,
   48199,48390,48399,48400,48424,48425,48605,49478,49479,49659,
   49959],
 [2279,3500,3501,3507,3517,3518,3544,3550,3592,3833,3834,4139,
   5645,5646,5662,5689,5695,5705,5706,5747,5978,5979,6284,7725,
   7726,7743,7769,7786,7817,7827,7828,8058,8059,8364,38205,
   38211,38221,38222,38253,38263,38264,38494,38495,38800,39156,
   39166,39167,39397,39398,39703,40258,40259,40564,44904],
 [1,2,23,26,31,32,41,42,44,68,89,90,91,92,93,94,107,156,
   157,158,163,164,166,173,177,179,1289,1290,1291,1292,1293,
   1296,1297,1298,1300,1306,1307,1309,1311,1313,1333,1334,1335,
   1336,1339,1340,1341,1343,1349,1350,1352,1354,1356,1376,1377,
   1378,1381,1382,1383,1385,1391,1392,1394,1396,1398,1418,1419,
   1422,1423,1424,1426,1432,1433,1435,1437,1439,1459,1462,1463,
   1464,1466,1472,1473,1475,1477,1479,1501,1502,1503,1505,1511,
   1512,1514,1516,1518,1613,1614,1616,1622,1623,1625,1627,1629,
   1649,1651,1657,1658,1660,1662,1664,1685,1691,1692,1694,1696,
   1698,1756,1757,1759,1761,1763,1928,1930,1932,1934,1955,1957,
   1959,2004,2006,2049,2279,2300,2301,2302,2305,2308,2310,2318,
   2319,2321,2365,2366,2367,2370,2373,2375,2383,2384,2386,3500,
   3501,3502,3503,3504,3507,3508,3509,3511,3517,3518,3520,3522,
   3524,3544,3545,3546,3547,3550,3551,3552,3554,3560,3561,3563,
   3565,3567,3587,3588,3589,3592,3593,3594,3596,3602,3603,3605,
   3607,3609,3629,3630,3633,3634,3635,3637,3643,3644,3646,3648,
   3650,3670,3673,3674,3675,3677,3683,3684,3686,3688,3690,3712,
   3713,3714,3716,3722,3723,3725,3727,3729,3824,3825,3827,3833,
   3834,3836,3838,3840,3860,3862,3868,3869,3871,3873,3875,3896,
   3902,3903,3905,3907,3909,3967,3968,3970,3972,3974,4139,4141,
   4143,4145,4166,4168,4170,4215,4217,4260,4510,4511,4512,4515,
   4518,4520,4528,4529,4531,5645,5646,5647,5648,5649,5652,5653,
   5654,5656,5662,5663,5665,5667,5669,5689,5690,5691,5692,5695,
   5696,5697,5699,5705,5706,5708,5710,5712,5732,5733,5734,5737,
   5738,5739,5741,5747,5748,5750,5752,5754,5774,5775,5778,5779,
   5780,5782,5788,5789,5791,5793,5795,5815,5818,5819,5820,5822,
   5828,5829,5831,5833,5835,5857,5858,5859,5861,5867,5868,5870,
   5872,5874,5969,5970,5972,5978,5979,5981,5983,5985,6005,6007,
   6013,6014,6016,6018,6020,6041,6047,6048,6050,6052,6054,6112,
   6113,6115,6117,6119,6284,6286,6288,6290,6311,6313,6315,6360,
   6362,6405,7725,7726,7727,7728,7729,7732,7733,7734,7736,7742,
   7743,7745,7747,7749,7769,7770,7771,7772,7775,7776,7777,7779,
   7785,7786,7788,7790,7792,7812,7813,7814,7817,7818,7819,7821,
   7827,7828,7830,7832,7834,7854,7855,7858,7859,7860,7862,7868,
   7869,7871,7873,7875,7895,7898,7899,7900,7902,7908,7909,7911,
   7913,7915,7937,7938,7939,7941,7947,7948,7950,7952,7954,8049,
   8050,8052,8058,8059,8061,8063,8065,8085,8087,8093,8094,8096,
   8098,8100,8121,8127,8128,8130,8132,8134,8192,8193,8195,8197,
   8199,8364,8366,8368,8370,8391,8393,8395,8440,8442,8485,
   38205,38206,38207,38208,38211,38212,38213,38215,38221,38222,
   38224,38226,38228,38248,38249,38250,38253,38254,38255,38257,
   38263,38264,38266,38268,38270,38290,38291,38294,38295,38296,
   38298,38304,38305,38307,38309,38311,38331,38334,38335,38336,
   38338,38344,38345,38347,38349,38351,38373,38374,38375,38377,
   38383,38384,38386,38388,38390,38485,38486,38488,38494,38495,
   38497,38499,38501,38521,38523,38529,38530,38532,38534,38536,
   38557,38563,38564,38566,38568,38570,38628,38629,38631,38633,
   38635,38800,38802,38804,38806,38827,38829,38831,38876,38878,
   38921,39151,39152,39153,39156,39157,39158,39160,39166,39167,
   39169,39171,39173,39193,39194,39197,39198,39199,39201,39207,
   39208,39210,39212,39214,39234,39237,39238,39239,39241,39247,
   39248,39250,39252,39254,39276,39277,39278,39280,39286,39287,
   39289,39291,39293,39388,39389,39391,39397,39398,39400,39402,
   39404,39424,39426,39432,39433,39435,39437,39439,39460,39466,
   39467,39469,39471,39473,39531,39532,39534,39536,39538,39703,
   39705,39707,39709,39730,39732,39734,39779,39781,39824,40054,
   40055,40058,40059,40060,40062,40068,40069,40071,40073,40075,
   40095,40098,40099,40100,40102,40108,40109,40111,40113,40115,
   40137,40138,40139,40141,40147,40148,40150,40152,40154,40249,
   40250,40252,40258,40259,40261,40263,40265,40285,40287,40293,
   40294,40296,40298,40300,40321,40327,40328,40330,40332,40334,
   40392,40393,40395,40397,40399,40564,40566,40568,40570,40591,
   40593,40595,40640,40642,40685,40915,40918,40919,40920,40922,
   40928,40929,40931,40933,40935,40957,40958,40959,40961,40967,
   40968,40970,40972,40974,41069,41070,41072,41078,41079,41081,
   41083,41085,41105,41107,41113,41114,41116,41118,41120,41141,
   41147,41148,41150,41152,41154,41212,41213,41215,41217,41219,
   41384,41386,41388,41390,41411,41413,41415,41460,41462,41505,
   41737,41738,41739,41741,41747,41748,41750,41752,41754,41849,
   41850,41852,41858,41859,41861,41863,41865,41885,41887,41893,
   41894,41896,41898,41900,41921,41927,41928,41930,41932,41934,
   41992,41993,41995,41997,41999,42164,42166,42168,42170,42191,
   42193,42195,42240,42242,42285,42590,42591,42593,42599,42600,
   42602,42604,42606,42626,42628,42634,42635,42637,42639,42641,
   42662,42668,42669,42671,42673,42675,42733,42734,42736,42738,
   42740,42905,42907,42909,42911,42932,42934,42936,42981,42983,
   43026,44625,44627,44633,44634,44636,44638,44640,44661,44667,
   44668,44670,44672,44674,44732,44733,44735,44737,44739,44904,
   44906,44908,44910,44931,44933,44935,44980,44982,45025,45256,
   45262,45263,45265,45267,45269,45327,45328,45330,45332,45334,
   45499,45501,45503,45505,45526,45528,45530,45575,45577,45620,
   45888,45889,45891,45893,45895,46060,46062,46064,46066,46087,
   46089,46091,46136,46138,46181,47084,47086,47088,47090,47111,
   47113,47115,47160,47162,47205,49471,49473,49475,49520,49522,
   49565,49820,49822,49865,50394],
 [2279,3714,3725,3905,5859,5870,6050,7939,7950,8130,42671],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,
   2384,3500,3501,3507,3510,3512,3517,3518,3519,3523,3525,3526,
   3544,3550,3553,3555,3560,3561,3562,3566,3568,3569,3592,3595,
   3597,3602,3603,3604,3608,3610,3611,3826,3828,3833,3834,3835,
   3839,3841,3842,3930,3935,3936,3937,3941,3998,3999,4000,4004,
   4139,4140,4144,4146,4147,4165,4169,4171,4172,4193,4195,4196,
   4281,4282,4319,4510,4511,4512,4518,4528,4529,5645,5646,5652,
   5655,5657,5662,5663,5664,5668,5670,5671,5689,5695,5698,5700,
   5705,5706,5707,5711,5713,5714,5737,5740,5742,5747,5748,5749,
   5753,5755,5756,5971,5973,5978,5979,5980,5984,5986,5987,6075,
   6080,6081,6086,6089,6143,6144,6145,6149,6151,6152,6284,6285,
   6289,6291,6292,6310,6314,6316,6317,6340,6341,6427,6464,7725,
   7726,7732,7735,7737,7742,7743,7744,7748,7750,7751,7769,7775,
   7778,7780,7785,7786,7787,7791,7793,7794,7817,7820,7822,7827,
   7828,7829,7833,7835,7836,8051,8053,8058,8059,8060,8064,8066,
   8067,8155,8160,8161,8162,8166,8168,8169,8223,8224,8225,8231,
   8364,8365,8369,8371,8372,8390,8394,8396,8397,8420,8506,8507,
   8544,38205,38211,38214,38216,38221,38222,38223,38227,38229,
   38230,38253,38256,38258,38263,38264,38265,38269,38271,38272,
   38487,38489,38494,38495,38496,38500,38502,38503,38591,38596,
   38597,38598,38602,38604,38605,38659,38660,38661,38665,38667,
   38668,38800,38801,38805,38807,38808,38826,38830,38832,38833,
   38854,38856,38857,38942,38943,38980,39156,39159,39161,39166,
   39167,39168,39172,39174,39175,39390,39392,39397,39398,39399,
   39403,39405,39406,39494,39499,39500,39501,39505,39507,39508,
   39562,39563,39564,39568,39570,39571,39703,39704,39708,39710,
   39711,39729,39733,39735,39736,39757,39759,39760,39845,39846,
   39883,40251,40253,40258,40259,40260,40264,40266,40267,40355,
   40360,40361,40362,40366,40368,40369,40423,40424,40425,40429,
   40431,40432,40564,40565,40569,40571,40572,40590,40594,40596,
   40597,40618,40620,40621,40706,40707,40744,44695,44700,44701,
   44702,44706,44708,44709,44763,44764,44765,44769,44771,44772,
   44904,44905,44909,44911,44912,44930,44934,44936,44937,44958,
   44960,44961,45046,45047,45084,46447,46448,46449,46453,46455,
   46456,46588,46589,46593,46595,46596,46614,46618,46620,46621,
   46642,46644,46645,46730,46731,46768,47549,47550,47554,47556,
   47557,47575,47579,47581,47582,47603,47605,47606,47691,47692,
   47729,49470,49474,49476,49477,49498,49500,49501,49586,49587,
   49624,49798,49800,49801,49886,49887,49924,50162,50163,50200,
   51084],
 [1,2,23,26,31,32,41,42,44,68,89,90,91,92,93,94,107,156,
   157,158,163,164,166,173,177,179,1289,1290,1291,1292,1293,
   1296,1297,1298,1300,1306,1307,1309,1311,1313,1333,1334,1335,
   1336,1339,1340,1341,1343,1349,1350,1352,1354,1356,1376,1377,
   1378,1381,1382,1383,1385,1391,1392,1394,1396,1398,1418,1419,
   1422,1423,1424,1426,1432,1433,1435,1437,1439,1459,1462,1463,
   1464,1466,1472,1473,1475,1477,1479,1501,1502,1503,1505,1511,
   1512,1514,1516,1518,1613,1614,1616,1622,1623,1625,1627,1629,
   1649,1651,1657,1658,1660,1662,1664,1685,1691,1692,1694,1696,
   1698,1756,1757,1759,1761,1763,1928,1930,1932,1934,1955,1957,
   1959,2004,2006,2049,2279,2300,2301,2302,2305,2308,2310,2318,
   2319,2321,2365,2366,2367,2370,2373,2375,2383,2384,2386,3500,
   3501,3502,3503,3504,3507,3508,3509,3511,3517,3518,3520,3522,
   3524,3544,3545,3546,3547,3550,3551,3552,3554,3560,3561,3563,
   3565,3567,3587,3588,3589,3592,3593,3594,3596,3602,3603,3605,
   3607,3609,3629,3630,3633,3634,3635,3637,3643,3644,3646,3648,
   3650,3670,3673,3674,3675,3677,3683,3684,3686,3688,3690,3712,
   3713,3714,3716,3722,3723,3725,3727,3729,3824,3825,3827,3833,
   3834,3836,3838,3840,3860,3862,3868,3869,3871,3873,3875,3896,
   3902,3903,3905,3907,3909,3967,3968,3970,3972,3974,4139,4141,
   4143,4145,4166,4168,4170,4215,4217,4260,4510,4511,4512,4515,
   4518,4520,4528,4529,4531,5645,5646,5647,5648,5649,5652,5653,
   5654,5656,5662,5663,5665,5667,5669,5689,5690,5691,5692,5695,
   5696,5697,5699,5705,5706,5708,5710,5712,5732,5733,5734,5737,
   5738,5739,5741,5747,5748,5750,5752,5754,5774,5775,5778,5779,
   5780,5782,5788,5789,5791,5793,5795,5815,5818,5819,5820,5822,
   5828,5829,5831,5833,5835,5857,5858,5859,5861,5867,5868,5870,
   5872,5874,5969,5970,5972,5978,5979,5981,5983,5985,6005,6007,
   6013,6014,6016,6018,6020,6041,6047,6048,6050,6052,6054,6112,
   6113,6115,6117,6119,6284,6286,6288,6290,6311,6313,6315,6360,
   6362,6405,7725,7726,7727,7728,7729,7732,7733,7734,7736,7742,
   7743,7745,7747,7749,7769,7770,7771,7772,7775,7776,7777,7779,
   7785,7786,7788,7790,7792,7812,7813,7814,7817,7818,7819,7821,
   7827,7828,7830,7832,7834,7854,7855,7858,7859,7860,7862,7868,
   7869,7871,7873,7875,7895,7898,7899,7900,7902,7908,7909,7911,
   7913,7915,7937,7938,7939,7941,7947,7948,7950,7952,7954,8049,
   8050,8052,8058,8059,8061,8063,8065,8085,8087,8093,8094,8096,
   8098,8100,8121,8127,8128,8130,8132,8134,8192,8193,8195,8197,
   8199,8364,8366,8368,8370,8391,8393,8395,8440,8442,8485,
   38205,38206,38207,38208,38211,38212,38213,38215,38221,38222,
   38224,38226,38228,38248,38249,38250,38253,38254,38255,38257,
   38263,38264,38266,38268,38270,38290,38291,38294,38295,38296,
   38298,38304,38305,38307,38309,38311,38331,38334,38335,38336,
   38338,38344,38345,38347,38349,38351,38373,38374,38375,38377,
   38383,38384,38386,38388,38390,38485,38486,38488,38494,38495,
   38497,38499,38501,38521,38523,38529,38530,38532,38534,38536,
   38557,38563,38564,38566,38568,38570,38628,38629,38631,38633,
   38635,38800,38802,38804,38806,38827,38829,38831,38876,38878,
   38921,39151,39152,39153,39156,39157,39158,39160,39166,39167,
   39169,39171,39173,39193,39194,39197,39198,39199,39201,39207,
   39208,39210,39212,39214,39234,39237,39238,39239,39241,39247,
   39248,39250,39252,39254,39276,39277,39278,39280,39286,39287,
   39289,39291,39293,39388,39389,39391,39397,39398,39400,39402,
   39404,39424,39426,39432,39433,39435,39437,39439,39460,39466,
   39467,39469,39471,39473,39531,39532,39534,39536,39538,39703,
   39705,39707,39709,39730,39732,39734,39779,39781,39824,40054,
   40055,40058,40059,40060,40062,40068,40069,40071,40073,40075,
   40095,40098,40099,40100,40102,40108,40109,40111,40113,40115,
   40137,40138,40139,40141,40147,40148,40150,40152,40154,40249,
   40250,40252,40258,40259,40261,40263,40265,40285,40287,40293,
   40294,40296,40298,40300,40321,40327,40328,40330,40332,40334,
   40392,40393,40395,40397,40399,40564,40566,40568,40570,40591,
   40593,40595,40640,40642,40685,40915,40918,40919,40920,40922,
   40928,40929,40931,40933,40935,40957,40958,40959,40961,40967,
   40968,40970,40972,40974,41069,41070,41072,41078,41079,41081,
   41083,41085,41105,41107,41113,41114,41116,41118,41120,41141,
   41147,41148,41150,41152,41154,41212,41213,41215,41217,41219,
   41384,41386,41388,41390,41411,41413,41415,41460,41462,41505,
   41737,41738,41739,41741,41747,41748,41750,41752,41754,41849,
   41850,41852,41858,41859,41861,41863,41865,41885,41887,41893,
   41894,41896,41898,41900,41921,41927,41928,41930,41932,41934,
   41992,41993,41995,41997,41999,42164,42166,42168,42170,42191,
   42193,42195,42240,42242,42285,42590,42591,42593,42599,42600,
   42602,42604,42606,42626,42628,42634,42635,42637,42639,42641,
   42662,42668,42669,42671,42673,42675,42733,42734,42736,42738,
   42740,42905,42907,42909,42911,42932,42934,42936,42981,42983,
   43026,44625,44627,44633,44634,44636,44638,44640,44661,44667,
   44668,44670,44672,44674,44732,44733,44735,44737,44739,44904,
   44906,44908,44910,44931,44933,44935,44980,44982,45025,45256,
   45262,45263,45265,45267,45269,45327,45328,45330,45332,45334,
   45499,45501,45503,45505,45526,45528,45530,45575,45577,45620,
   45888,45889,45891,45893,45895,46060,46062,46064,46066,46087,
   46089,46091,46136,46138,46181,47084,47086,47088,47090,47111,
   47113,47115,47160,47162,47205,49471,49473,49475,49520,49522,
   49565,49820,49822,49865,50394],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,
   2384,3500,3501,3507,3510,3512,3517,3518,3519,3523,3525,3526,
   3544,3550,3553,3555,3560,3561,3562,3566,3568,3569,3592,3595,
   3597,3602,3603,3604,3608,3610,3611,3826,3828,3833,3834,3835,
   3839,3841,3842,3930,3935,3936,3937,3941,3998,3999,4000,4004,
   4139,4140,4144,4146,4147,4165,4169,4171,4172,4193,4195,4196,
   4281,4282,4319,4510,4511,4512,4518,4528,4529,5645,5646,5652,
   5655,5657,5662,5663,5664,5668,5670,5671,5689,5695,5698,5700,
   5705,5706,5707,5711,5713,5714,5737,5740,5742,5747,5748,5749,
   5753,5755,5756,5971,5973,5978,5979,5980,5984,5986,5987,6075,
   6080,6081,6086,6089,6143,6144,6145,6149,6151,6152,6284,6285,
   6289,6291,6292,6310,6314,6316,6317,6340,6341,6427,6464,7725,
   7726,7732,7735,7737,7742,7743,7744,7748,7750,7751,7769,7775,
   7778,7780,7785,7786,7787,7791,7793,7794,7817,7820,7822,7827,
   7828,7829,7833,7835,7836,8051,8053,8058,8059,8060,8064,8066,
   8067,8155,8160,8161,8162,8166,8168,8169,8223,8224,8225,8231,
   8364,8365,8369,8371,8372,8390,8394,8396,8397,8420,8506,8507,
   8544,38205,38211,38214,38216,38221,38222,38223,38227,38229,
   38230,38253,38256,38258,38263,38264,38265,38269,38271,38272,
   38487,38489,38494,38495,38496,38500,38502,38503,38591,38596,
   38597,38598,38602,38604,38605,38659,38660,38661,38665,38667,
   38668,38800,38801,38805,38807,38808,38826,38830,38832,38833,
   38854,38856,38857,38942,38943,38980,39156,39159,39161,39166,
   39167,39168,39172,39174,39175,39390,39392,39397,39398,39399,
   39403,39405,39406,39494,39499,39500,39501,39505,39507,39508,
   39562,39563,39564,39568,39570,39571,39703,39704,39708,39710,
   39711,39729,39733,39735,39736,39757,39759,39760,39845,39846,
   39883,40251,40253,40258,40259,40260,40264,40266,40267,40355,
   40360,40361,40362,40366,40368,40369,40423,40424,40425,40429,
   40431,40432,40564,40565,40569,40571,40572,40590,40594,40596,
   40597,40618,40620,40621,40706,40707,40744,44695,44700,44701,
   44702,44706,44708,44709,44763,44764,44765,44769,44771,44772,
   44904,44905,44909,44911,44912,44930,44934,44936,44937,44958,
   44960,44961,45046,45047,45084,46447,46448,46449,46453,46455,
   46456,46588,46589,46593,46595,46596,46614,46618,46620,46621,
   46642,46644,46645,46730,46731,46768,47549,47550,47554,47556,
   47557,47575,47579,47581,47582,47603,47605,47606,47691,47692,
   47729,49470,49474,49476,49477,49498,49500,49501,49586,49587,
   49624,49798,49800,49801,49886,49887,49924,50162,50163,50200,
   51084],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,
   2384,3500,3501,3505,3506,3507,3513,3514,3517,3518,3527,3528,
   3544,3548,3549,3550,3556,3557,3560,3561,3570,3571,3590,3591,
   3592,3598,3599,3602,3603,3612,3613,3749,3750,3756,3757,3760,
   3761,3770,3771,3787,3793,3794,3797,3798,3829,3830,3833,3834,
   3843,3844,4025,4028,4029,4038,4039,4057,4058,4139,4148,4149,
   4173,4174,4354,4510,4511,4512,4518,4528,4529,5645,5646,5650,
   5651,5652,5658,5659,5662,5663,5672,5673,5689,5693,5694,5695,
   5701,5702,5705,5706,5715,5716,5735,5736,5737,5743,5744,5747,
   5748,5757,5758,5894,5895,5902,5905,5906,5916,5932,5939,5942,
   5943,5953,5974,5975,5978,5979,5988,5989,6170,6173,6174,6183,
   6184,6202,6203,6212,6213,6284,6293,6294,6318,6319,6499,7725,
   7726,7730,7731,7732,7738,7739,7742,7743,7752,7753,7769,7773,
   7774,7775,7781,7782,7785,7786,7795,7796,7815,7816,7817,7823,
   7824,7827,7828,7837,7838,7974,7975,7985,7986,7995,7996,8012,
   8018,8019,8022,8023,8032,8033,8054,8055,8058,8059,8068,8069,
   8250,8253,8254,8263,8282,8283,8292,8364,8373,8374,8398,8399,
   8579,38205,38209,38210,38211,38217,38218,38221,38222,38231,
   38232,38251,38252,38253,38259,38260,38263,38264,38273,38274,
   38410,38411,38417,38418,38421,38422,38431,38432,38448,38454,
   38455,38458,38459,38468,38469,38490,38491,38494,38495,38504,
   38505,38686,38689,38690,38699,38700,38718,38719,38728,38729,
   38800,38809,38810,38834,38835,39015,39154,39155,39156,39162,
   39163,39166,39167,39176,39177,39313,39314,39320,39321,39324,
   39325,39334,39335,39351,39357,39358,39361,39362,39371,39372,
   39393,39394,39397,39398,39407,39408,39589,39592,39593,39602,
   39603,39621,39622,39631,39632,39703,39712,39713,39737,39738,
   39918,40174,40175,40181,40182,40185,40186,40195,40196,40212,
   40218,40219,40222,40223,40232,40233,40254,40255,40258,40259,
   40268,40269,40450,40453,40454,40463,40464,40482,40483,40492,
   40493,40564,40573,40574,40598,40599,40779,43256,43262,43263,
   43266,43267,43276,43277,43298,43299,43302,43303,43312,43313,
   43494,43497,43498,43507,43508,43526,43527,43536,43537,43608,
   43617,43618,43642,43643,43823,43964,43965,43968,43969,43978,
   43979,44160,44163,44164,44173,44174,44192,44193,44202,44203,
   44274,44283,44284,44308,44309,44489,44790,44793,44794,44803,
   44804,44822,44823,44832,44833,44904,44913,44914,44938,44939,
   45119,47902,47903,47912,47913,47984,47993,47994,48018,48019,
   48199,48390,48399,48400,48424,48425,48605,49478,49479,49659,
   49959],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,
   2384,3500,3501,3505,3506,3507,3513,3514,3517,3518,3527,3528,
   3544,3548,3549,3550,3556,3557,3560,3561,3570,3571,3590,3591,
   3592,3598,3599,3602,3603,3612,3613,3749,3750,3756,3757,3760,
   3761,3770,3771,3787,3793,3794,3797,3798,3829,3830,3833,3834,
   3843,3844,4025,4028,4029,4038,4039,4057,4058,4139,4148,4149,
   4173,4174,4354,4510,4511,4512,4518,4528,4529,5645,5646,5650,
   5651,5652,5658,5659,5662,5663,5672,5673,5689,5693,5694,5695,
   5701,5702,5705,5706,5715,5716,5735,5736,5737,5743,5744,5747,
   5748,5757,5758,5894,5895,5902,5905,5906,5916,5932,5939,5942,
   5943,5953,5974,5975,5978,5979,5988,5989,6170,6173,6174,6183,
   6184,6202,6203,6212,6213,6284,6293,6294,6318,6319,6499,7725,
   7726,7730,7731,7732,7738,7739,7742,7743,7752,7753,7769,7773,
   7774,7775,7781,7782,7785,7786,7795,7796,7815,7816,7817,7823,
   7824,7827,7828,7837,7838,7974,7975,7985,7986,7995,7996,8012,
   8018,8019,8022,8023,8032,8033,8054,8055,8058,8059,8068,8069,
   8250,8253,8254,8263,8282,8283,8292,8364,8373,8374,8398,8399,
   8579,38205,38209,38210,38211,38217,38218,38221,38222,38231,
   38232,38251,38252,38253,38259,38260,38263,38264,38273,38274,
   38410,38411,38417,38418,38421,38422,38431,38432,38448,38454,
   38455,38458,38459,38468,38469,38490,38491,38494,38495,38504,
   38505,38686,38689,38690,38699,38700,38718,38719,38728,38729,
   38800,38809,38810,38834,38835,39015,39154,39155,39156,39162,
   39163,39166,39167,39176,39177,39313,39314,39320,39321,39324,
   39325,39334,39335,39351,39357,39358,39361,39362,39371,39372,
   39393,39394,39397,39398,39407,39408,39589,39592,39593,39602,
   39603,39621,39622,39631,39632,39703,39712,39713,39737,39738,
   39918,40174,40175,40181,40182,40185,40186,40195,40196,40212,
   40218,40219,40222,40223,40232,40233,40254,40255,40258,40259,
   40268,40269,40450,40453,40454,40463,40464,40482,40483,40492,
   40493,40564,40573,40574,40598,40599,40779,43256,43262,43263,
   43266,43267,43276,43277,43298,43299,43302,43303,43312,43313,
   43494,43497,43498,43507,43508,43526,43527,43536,43537,43608,
   43617,43618,43642,43643,43823,43964,43965,43968,43969,43978,
   43979,44160,44163,44164,44173,44174,44192,44193,44202,44203,
   44274,44283,44284,44308,44309,44489,44790,44793,44794,44803,
   44804,44822,44823,44832,44833,44904,44913,44914,44938,44939,
   45119,47902,47903,47912,47913,47984,47993,47994,48018,48019,
   48199,48390,48399,48400,48424,48425,48605,49478,49479,49659,
   49959],[2279],[2279],
 [2279,3500,3501,3507,3517,3518,3544,3550,3592,3833,3834,4139,
   5645,5646,5662,5689,5695,5705,5706,5747,5978,5979,6284,7725,
   7726,7743,7769,7786,7817,7827,7828,8058,8059,8364,38205,
   38211,38221,38222,38253,38263,38264,38494,38495,38800,39156,
   39166,39167,39397,39398,39703,40258,40259,40564,44904],
 [2279,3500,3501,3507,3517,3518,3544,3550,3592,3833,3834,4139,
   5645,5646,5662,5689,5695,5705,5706,5747,5978,5979,6284,7725,
   7726,7743,7769,7786,7817,7827,7828,8058,8059,8364,38205,
   38211,38221,38222,38253,38263,38264,38494,38495,38800,39156,
   39166,39167,39397,39398,39703,40258,40259,40564,44904],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,
   2384,3500,3501,3507,3510,3512,3517,3518,3519,3523,3525,3526,
   3544,3550,3553,3555,3560,3561,3562,3566,3568,3569,3592,3595,
   3597,3602,3603,3604,3608,3610,3611,3826,3828,3833,3834,3835,
   3839,3841,3842,3930,3935,3936,3937,3941,3998,3999,4000,4004,
   4139,4140,4144,4146,4147,4165,4169,4171,4172,4193,4195,4196,
   4281,4282,4319,4510,4511,4512,4518,4528,4529,5645,5646,5652,
   5655,5657,5662,5663,5664,5668,5670,5671,5689,5695,5698,5700,
   5705,5706,5707,5711,5713,5714,5737,5740,5742,5747,5748,5749,
   5753,5755,5756,5971,5973,5978,5979,5980,5984,5986,5987,6075,
   6080,6081,6086,6089,6143,6144,6145,6149,6151,6152,6284,6285,
   6289,6291,6292,6310,6314,6316,6317,6340,6341,6427,6464,7725,
   7726,7732,7735,7737,7742,7743,7744,7748,7750,7751,7769,7775,
   7778,7780,7785,7786,7787,7791,7793,7794,7817,7820,7822,7827,
   7828,7829,7833,7835,7836,8051,8053,8058,8059,8060,8064,8066,
   8067,8155,8160,8161,8162,8166,8168,8169,8223,8224,8225,8231,
   8364,8365,8369,8371,8372,8390,8394,8396,8397,8420,8506,8507,
   8544,38205,38211,38214,38216,38221,38222,38223,38227,38229,
   38230,38253,38256,38258,38263,38264,38265,38269,38271,38272,
   38487,38489,38494,38495,38496,38500,38502,38503,38591,38596,
   38597,38598,38602,38604,38605,38659,38660,38661,38665,38667,
   38668,38800,38801,38805,38807,38808,38826,38830,38832,38833,
   38854,38856,38857,38942,38943,38980,39156,39159,39161,39166,
   39167,39168,39172,39174,39175,39390,39392,39397,39398,39399,
   39403,39405,39406,39494,39499,39500,39501,39505,39507,39508,
   39562,39563,39564,39568,39570,39571,39703,39704,39708,39710,
   39711,39729,39733,39735,39736,39757,39759,39760,39845,39846,
   39883,40251,40253,40258,40259,40260,40264,40266,40267,40355,
   40360,40361,40362,40366,40368,40369,40423,40424,40425,40429,
   40431,40432,40564,40565,40569,40571,40572,40590,40594,40596,
   40597,40618,40620,40621,40706,40707,40744,44695,44700,44701,
   44702,44706,44708,44709,44763,44764,44765,44769,44771,44772,
   44904,44905,44909,44911,44912,44930,44934,44936,44937,44958,
   44960,44961,45046,45047,45084,46447,46448,46449,46453,46455,
   46456,46588,46589,46593,46595,46596,46614,46618,46620,46621,
   46642,46644,46645,46730,46731,46768,47549,47550,47554,47556,
   47557,47575,47579,47581,47582,47603,47605,47606,47691,47692,
   47729,49470,49474,49476,49477,49498,49500,49501,49586,49587,
   49624,49798,49800,49801,49886,49887,49924,50162,50163,50200,
   51084],
 [2279,3714,3725,3905,5859,5870,6050,7939,7950,8130,42671],
 [2279],[1,2,23,26,31,32,41,42,44,68,89,90,91,92,93,94,
   107,156,157,158,163,164,166,173,177,179,1289,1290,1291,
   1292,1293,1296,1297,1298,1300,1306,1307,1309,1311,1313,1333,
   1334,1335,1336,1339,1340,1341,1343,1349,1350,1352,1354,1356,
   1376,1377,1378,1381,1382,1383,1385,1391,1392,1394,1396,1398,
   1418,1419,1422,1423,1424,1426,1432,1433,1435,1437,1439,1459,
   1462,1463,1464,1466,1472,1473,1475,1477,1479,1501,1502,1503,
   1505,1511,1512,1514,1516,1518,1613,1614,1616,1622,1623,1625,
   1627,1629,1649,1651,1657,1658,1660,1662,1664,1685,1691,1692,
   1694,1696,1698,1756,1757,1759,1761,1763,1928,1930,1932,1934,
   1955,1957,1959,2004,2006,2049,2279,2300,2301,2302,2305,2308,
   2310,2318,2319,2321,2365,2366,2367,2370,2373,2375,2383,2384,
   2386,3500,3501,3502,3503,3504,3507,3508,3509,3511,3517,3518,
   3520,3522,3524,3544,3545,3546,3547,3550,3551,3552,3554,3560,
   3561,3563,3565,3567,3587,3588,3589,3592,3593,3594,3596,3602,
   3603,3605,3607,3609,3629,3630,3633,3634,3635,3637,3643,3644,
   3646,3648,3650,3670,3673,3674,3675,3677,3683,3684,3686,3688,
   3690,3712,3713,3714,3716,3722,3723,3725,3727,3729,3824,3825,
   3827,3833,3834,3836,3838,3840,3860,3862,3868,3869,3871,3873,
   3875,3896,3902,3903,3905,3907,3909,3967,3968,3970,3972,3974,
   4139,4141,4143,4145,4166,4168,4170,4215,4217,4260,4510,4511,
   4512,4515,4518,4520,4528,4529,4531,5645,5646,5647,5648,5649,
   5652,5653,5654,5656,5662,5663,5665,5667,5669,5689,5690,5691,
   5692,5695,5696,5697,5699,5705,5706,5708,5710,5712,5732,5733,
   5734,5737,5738,5739,5741,5747,5748,5750,5752,5754,5774,5775,
   5778,5779,5780,5782,5788,5789,5791,5793,5795,5815,5818,5819,
   5820,5822,5828,5829,5831,5833,5835,5857,5858,5859,5861,5867,
   5868,5870,5872,5874,5969,5970,5972,5978,5979,5981,5983,5985,
   6005,6007,6013,6014,6016,6018,6020,6041,6047,6048,6050,6052,
   6054,6112,6113,6115,6117,6119,6284,6286,6288,6290,6311,6313,
   6315,6360,6362,6405,7725,7726,7727,7728,7729,7732,7733,7734,
   7736,7742,7743,7745,7747,7749,7769,7770,7771,7772,7775,7776,
   7777,7779,7785,7786,7788,7790,7792,7812,7813,7814,7817,7818,
   7819,7821,7827,7828,7830,7832,7834,7854,7855,7858,7859,7860,
   7862,7868,7869,7871,7873,7875,7895,7898,7899,7900,7902,7908,
   7909,7911,7913,7915,7937,7938,7939,7941,7947,7948,7950,7952,
   7954,8049,8050,8052,8058,8059,8061,8063,8065,8085,8087,8093,
   8094,8096,8098,8100,8121,8127,8128,8130,8132,8134,8192,8193,
   8195,8197,8199,8364,8366,8368,8370,8391,8393,8395,8440,8442,
   8485,38205,38206,38207,38208,38211,38212,38213,38215,38221,
   38222,38224,38226,38228,38248,38249,38250,38253,38254,38255,
   38257,38263,38264,38266,38268,38270,38290,38291,38294,38295,
   38296,38298,38304,38305,38307,38309,38311,38331,38334,38335,
   38336,38338,38344,38345,38347,38349,38351,38373,38374,38375,
   38377,38383,38384,38386,38388,38390,38485,38486,38488,38494,
   38495,38497,38499,38501,38521,38523,38529,38530,38532,38534,
   38536,38557,38563,38564,38566,38568,38570,38628,38629,38631,
   38633,38635,38800,38802,38804,38806,38827,38829,38831,38876,
   38878,38921,39151,39152,39153,39156,39157,39158,39160,39166,
   39167,39169,39171,39173,39193,39194,39197,39198,39199,39201,
   39207,39208,39210,39212,39214,39234,39237,39238,39239,39241,
   39247,39248,39250,39252,39254,39276,39277,39278,39280,39286,
   39287,39289,39291,39293,39388,39389,39391,39397,39398,39400,
   39402,39404,39424,39426,39432,39433,39435,39437,39439,39460,
   39466,39467,39469,39471,39473,39531,39532,39534,39536,39538,
   39703,39705,39707,39709,39730,39732,39734,39779,39781,39824,
   40054,40055,40058,40059,40060,40062,40068,40069,40071,40073,
   40075,40095,40098,40099,40100,40102,40108,40109,40111,40113,
   40115,40137,40138,40139,40141,40147,40148,40150,40152,40154,
   40249,40250,40252,40258,40259,40261,40263,40265,40285,40287,
   40293,40294,40296,40298,40300,40321,40327,40328,40330,40332,
   40334,40392,40393,40395,40397,40399,40564,40566,40568,40570,
   40591,40593,40595,40640,40642,40685,40915,40918,40919,40920,
   40922,40928,40929,40931,40933,40935,40957,40958,40959,40961,
   40967,40968,40970,40972,40974,41069,41070,41072,41078,41079,
   41081,41083,41085,41105,41107,41113,41114,41116,41118,41120,
   41141,41147,41148,41150,41152,41154,41212,41213,41215,41217,
   41219,41384,41386,41388,41390,41411,41413,41415,41460,41462,
   41505,41737,41738,41739,41741,41747,41748,41750,41752,41754,
   41849,41850,41852,41858,41859,41861,41863,41865,41885,41887,
   41893,41894,41896,41898,41900,41921,41927,41928,41930,41932,
   41934,41992,41993,41995,41997,41999,42164,42166,42168,42170,
   42191,42193,42195,42240,42242,42285,42590,42591,42593,42599,
   42600,42602,42604,42606,42626,42628,42634,42635,42637,42639,
   42641,42662,42668,42669,42671,42673,42675,42733,42734,42736,
   42738,42740,42905,42907,42909,42911,42932,42934,42936,42981,
   42983,43026,44625,44627,44633,44634,44636,44638,44640,44661,
   44667,44668,44670,44672,44674,44732,44733,44735,44737,44739,
   44904,44906,44908,44910,44931,44933,44935,44980,44982,45025,
   45256,45262,45263,45265,45267,45269,45327,45328,45330,45332,
   45334,45499,45501,45503,45505,45526,45528,45530,45575,45577,
   45620,45888,45889,45891,45893,45895,46060,46062,46064,46066,
   46087,46089,46091,46136,46138,46181,47084,47086,47088,47090,
   47111,47113,47115,47160,47162,47205,49471,49473,49475,49520,
   49522,49565,49820,49822,49865,50394],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,
   2384,3500,3501,3507,3510,3512,3517,3518,3519,3523,3525,3526,
   3544,3550,3553,3555,3560,3561,3562,3566,3568,3569,3592,3595,
   3597,3602,3603,3604,3608,3610,3611,3826,3828,3833,3834,3835,
   3839,3841,3842,3930,3935,3936,3937,3941,3998,3999,4000,4004,
   4139,4140,4144,4146,4147,4165,4169,4171,4172,4193,4195,4196,
   4281,4282,4319,4510,4511,4512,4518,4528,4529,5645,5646,5652,
   5655,5657,5662,5663,5664,5668,5670,5671,5689,5695,5698,5700,
   5705,5706,5707,5711,5713,5714,5737,5740,5742,5747,5748,5749,
   5753,5755,5756,5971,5973,5978,5979,5980,5984,5986,5987,6075,
   6080,6081,6086,6089,6143,6144,6145,6149,6151,6152,6284,6285,
   6289,6291,6292,6310,6314,6316,6317,6340,6341,6427,6464,7725,
   7726,7732,7735,7737,7742,7743,7744,7748,7750,7751,7769,7775,
   7778,7780,7785,7786,7787,7791,7793,7794,7817,7820,7822,7827,
   7828,7829,7833,7835,7836,8051,8053,8058,8059,8060,8064,8066,
   8067,8155,8160,8161,8162,8166,8168,8169,8223,8224,8225,8231,
   8364,8365,8369,8371,8372,8390,8394,8396,8397,8420,8506,8507,
   8544,38205,38211,38214,38216,38221,38222,38223,38227,38229,
   38230,38253,38256,38258,38263,38264,38265,38269,38271,38272,
   38487,38489,38494,38495,38496,38500,38502,38503,38591,38596,
   38597,38598,38602,38604,38605,38659,38660,38661,38665,38667,
   38668,38800,38801,38805,38807,38808,38826,38830,38832,38833,
   38854,38856,38857,38942,38943,38980,39156,39159,39161,39166,
   39167,39168,39172,39174,39175,39390,39392,39397,39398,39399,
   39403,39405,39406,39494,39499,39500,39501,39505,39507,39508,
   39562,39563,39564,39568,39570,39571,39703,39704,39708,39710,
   39711,39729,39733,39735,39736,39757,39759,39760,39845,39846,
   39883,40251,40253,40258,40259,40260,40264,40266,40267,40355,
   40360,40361,40362,40366,40368,40369,40423,40424,40425,40429,
   40431,40432,40564,40565,40569,40571,40572,40590,40594,40596,
   40597,40618,40620,40621,40706,40707,40744,44695,44700,44701,
   44702,44706,44708,44709,44763,44764,44765,44769,44771,44772,
   44904,44905,44909,44911,44912,44930,44934,44936,44937,44958,
   44960,44961,45046,45047,45084,46447,46448,46449,46453,46455,
   46456,46588,46589,46593,46595,46596,46614,46618,46620,46621,
   46642,46644,46645,46730,46731,46768,47549,47550,47554,47556,
   47557,47575,47579,47581,47582,47603,47605,47606,47691,47692,
   47729,49470,49474,49476,49477,49498,49500,49501,49586,49587,
   49624,49798,49800,49801,49886,49887,49924,50162,50163,50200,
   51084],
 [1,2,23,26,31,32,41,42,44,68,89,90,91,92,93,94,107,156,
   157,158,163,164,166,173,177,179,1289,1290,1291,1292,1293,
   1296,1297,1298,1300,1306,1307,1309,1311,1313,1333,1334,1335,
   1336,1339,1340,1341,1343,1349,1350,1352,1354,1356,1376,1377,
   1378,1381,1382,1383,1385,1391,1392,1394,1396,1398,1418,1419,
   1422,1423,1424,1426,1432,1433,1435,1437,1439,1459,1462,1463,
   1464,1466,1472,1473,1475,1477,1479,1501,1502,1503,1505,1511,
   1512,1514,1516,1518,1613,1614,1616,1622,1623,1625,1627,1629,
   1649,1651,1657,1658,1660,1662,1664,1685,1691,1692,1694,1696,
   1698,1756,1757,1759,1761,1763,1928,1930,1932,1934,1955,1957,
   1959,2004,2006,2049,2279,2300,2301,2302,2305,2308,2310,2318,
   2319,2321,2365,2366,2367,2370,2373,2375,2383,2384,2386,3500,
   3501,3502,3503,3504,3507,3508,3509,3511,3517,3518,3520,3522,
   3524,3544,3545,3546,3547,3550,3551,3552,3554,3560,3561,3563,
   3565,3567,3587,3588,3589,3592,3593,3594,3596,3602,3603,3605,
   3607,3609,3629,3630,3633,3634,3635,3637,3643,3644,3646,3648,
   3650,3670,3673,3674,3675,3677,3683,3684,3686,3688,3690,3712,
   3713,3714,3716,3722,3723,3725,3727,3729,3824,3825,3827,3833,
   3834,3836,3838,3840,3860,3862,3868,3869,3871,3873,3875,3896,
   3902,3903,3905,3907,3909,3967,3968,3970,3972,3974,4139,4141,
   4143,4145,4166,4168,4170,4215,4217,4260,4510,4511,4512,4515,
   4518,4520,4528,4529,4531,5645,5646,5647,5648,5649,5652,5653,
   5654,5656,5662,5663,5665,5667,5669,5689,5690,5691,5692,5695,
   5696,5697,5699,5705,5706,5708,5710,5712,5732,5733,5734,5737,
   5738,5739,5741,5747,5748,5750,5752,5754,5774,5775,5778,5779,
   5780,5782,5788,5789,5791,5793,5795,5815,5818,5819,5820,5822,
   5828,5829,5831,5833,5835,5857,5858,5859,5861,5867,5868,5870,
   5872,5874,5969,5970,5972,5978,5979,5981,5983,5985,6005,6007,
   6013,6014,6016,6018,6020,6041,6047,6048,6050,6052,6054,6112,
   6113,6115,6117,6119,6284,6286,6288,6290,6311,6313,6315,6360,
   6362,6405,7725,7726,7727,7728,7729,7732,7733,7734,7736,7742,
   7743,7745,7747,7749,7769,7770,7771,7772,7775,7776,7777,7779,
   7785,7786,7788,7790,7792,7812,7813,7814,7817,7818,7819,7821,
   7827,7828,7830,7832,7834,7854,7855,7858,7859,7860,7862,7868,
   7869,7871,7873,7875,7895,7898,7899,7900,7902,7908,7909,7911,
   7913,7915,7937,7938,7939,7941,7947,7948,7950,7952,7954,8049,
   8050,8052,8058,8059,8061,8063,8065,8085,8087,8093,8094,8096,
   8098,8100,8121,8127,8128,8130,8132,8134,8192,8193,8195,8197,
   8199,8364,8366,8368,8370,8391,8393,8395,8440,8442,8485,
   38205,38206,38207,38208,38211,38212,38213,38215,38221,38222,
   38224,38226,38228,38248,38249,38250,38253,38254,38255,38257,
   38263,38264,38266,38268,38270,38290,38291,38294,38295,38296,
   38298,38304,38305,38307,38309,38311,38331,38334,38335,38336,
   38338,38344,38345,38347,38349,38351,38373,38374,38375,38377,
   38383,38384,38386,38388,38390,38485,38486,38488,38494,38495,
   38497,38499,38501,38521,38523,38529,38530,38532,38534,38536,
   38557,38563,38564,38566,38568,38570,38628,38629,38631,38633,
   38635,38800,38802,38804,38806,38827,38829,38831,38876,38878,
   38921,39151,39152,39153,39156,39157,39158,39160,39166,39167,
   39169,39171,39173,39193,39194,39197,39198,39199,39201,39207,
   39208,39210,39212,39214,39234,39237,39238,39239,39241,39247,
   39248,39250,39252,39254,39276,39277,39278,39280,39286,39287,
   39289,39291,39293,39388,39389,39391,39397,39398,39400,39402,
   39404,39424,39426,39432,39433,39435,39437,39439,39460,39466,
   39467,39469,39471,39473,39531,39532,39534,39536,39538,39703,
   39705,39707,39709,39730,39732,39734,39779,39781,39824,40054,
   40055,40058,40059,40060,40062,40068,40069,40071,40073,40075,
   40095,40098,40099,40100,40102,40108,40109,40111,40113,40115,
   40137,40138,40139,40141,40147,40148,40150,40152,40154,40249,
   40250,40252,40258,40259,40261,40263,40265,40285,40287,40293,
   40294,40296,40298,40300,40321,40327,40328,40330,40332,40334,
   40392,40393,40395,40397,40399,40564,40566,40568,40570,40591,
   40593,40595,40640,40642,40685,40915,40918,40919,40920,40922,
   40928,40929,40931,40933,40935,40957,40958,40959,40961,40967,
   40968,40970,40972,40974,41069,41070,41072,41078,41079,41081,
   41083,41085,41105,41107,41113,41114,41116,41118,41120,41141,
   41147,41148,41150,41152,41154,41212,41213,41215,41217,41219,
   41384,41386,41388,41390,41411,41413,41415,41460,41462,41505,
   41737,41738,41739,41741,41747,41748,41750,41752,41754,41849,
   41850,41852,41858,41859,41861,41863,41865,41885,41887,41893,
   41894,41896,41898,41900,41921,41927,41928,41930,41932,41934,
   41992,41993,41995,41997,41999,42164,42166,42168,42170,42191,
   42193,42195,42240,42242,42285,42590,42591,42593,42599,42600,
   42602,42604,42606,42626,42628,42634,42635,42637,42639,42641,
   42662,42668,42669,42671,42673,42675,42733,42734,42736,42738,
   42740,42905,42907,42909,42911,42932,42934,42936,42981,42983,
   43026,44625,44627,44633,44634,44636,44638,44640,44661,44667,
   44668,44670,44672,44674,44732,44733,44735,44737,44739,44904,
   44906,44908,44910,44931,44933,44935,44980,44982,45025,45256,
   45262,45263,45265,45267,45269,45327,45328,45330,45332,45334,
   45499,45501,45503,45505,45526,45528,45530,45575,45577,45620,
   45888,45889,45891,45893,45895,46060,46062,46064,46066,46087,
   46089,46091,46136,46138,46181,47084,47086,47088,47090,47111,
   47113,47115,47160,47162,47205,49471,49473,49475,49520,49522,
   49565,49820,49822,49865,50394],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,
   2384,3500,3501,3507,3510,3512,3517,3518,3519,3523,3525,3526,
   3544,3550,3553,3555,3560,3561,3562,3566,3568,3569,3592,3595,
   3597,3602,3603,3604,3608,3610,3611,3826,3828,3833,3834,3835,
   3839,3841,3842,3930,3935,3936,3937,3941,3998,3999,4000,4004,
   4139,4140,4144,4146,4147,4165,4169,4171,4172,4193,4195,4196,
   4281,4282,4319,4510,4511,4512,4518,4528,4529,5645,5646,5652,
   5655,5657,5662,5663,5664,5668,5670,5671,5689,5695,5698,5700,
   5705,5706,5707,5711,5713,5714,5737,5740,5742,5747,5748,5749,
   5753,5755,5756,5971,5973,5978,5979,5980,5984,5986,5987,6075,
   6080,6081,6086,6089,6143,6144,6145,6149,6151,6152,6284,6285,
   6289,6291,6292,6310,6314,6316,6317,6340,6341,6427,6464,7725,
   7726,7732,7735,7737,7742,7743,7744,7748,7750,7751,7769,7775,
   7778,7780,7785,7786,7787,7791,7793,7794,7817,7820,7822,7827,
   7828,7829,7833,7835,7836,8051,8053,8058,8059,8060,8064,8066,
   8067,8155,8160,8161,8162,8166,8168,8169,8223,8224,8225,8231,
   8364,8365,8369,8371,8372,8390,8394,8396,8397,8420,8506,8507,
   8544,38205,38211,38214,38216,38221,38222,38223,38227,38229,
   38230,38253,38256,38258,38263,38264,38265,38269,38271,38272,
   38487,38489,38494,38495,38496,38500,38502,38503,38591,38596,
   38597,38598,38602,38604,38605,38659,38660,38661,38665,38667,
   38668,38800,38801,38805,38807,38808,38826,38830,38832,38833,
   38854,38856,38857,38942,38943,38980,39156,39159,39161,39166,
   39167,39168,39172,39174,39175,39390,39392,39397,39398,39399,
   39403,39405,39406,39494,39499,39500,39501,39505,39507,39508,
   39562,39563,39564,39568,39570,39571,39703,39704,39708,39710,
   39711,39729,39733,39735,39736,39757,39759,39760,39845,39846,
   39883,40251,40253,40258,40259,40260,40264,40266,40267,40355,
   40360,40361,40362,40366,40368,40369,40423,40424,40425,40429,
   40431,40432,40564,40565,40569,40571,40572,40590,40594,40596,
   40597,40618,40620,40621,40706,40707,40744,44695,44700,44701,
   44702,44706,44708,44709,44763,44764,44765,44769,44771,44772,
   44904,44905,44909,44911,44912,44930,44934,44936,44937,44958,
   44960,44961,45046,45047,45084,46447,46448,46449,46453,46455,
   46456,46588,46589,46593,46595,46596,46614,46618,46620,46621,
   46642,46644,46645,46730,46731,46768,47549,47550,47554,47556,
   47557,47575,47579,47581,47582,47603,47605,47606,47691,47692,
   47729,49470,49474,49476,49477,49498,49500,49501,49586,49587,
   49624,49798,49800,49801,49886,49887,49924,50162,50163,50200,
   51084],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,
   2384,3500,3501,3507,3510,3512,3517,3518,3519,3523,3525,3526,
   3544,3550,3553,3555,3560,3561,3562,3566,3568,3569,3592,3595,
   3597,3602,3603,3604,3608,3610,3611,3826,3828,3833,3834,3835,
   3839,3841,3842,3930,3935,3936,3937,3941,3998,3999,4000,4004,
   4139,4140,4144,4146,4147,4165,4169,4171,4172,4193,4195,4196,
   4281,4282,4319,4510,4511,4512,4518,4528,4529,5645,5646,5652,
   5655,5657,5662,5663,5664,5668,5670,5671,5689,5695,5698,5700,
   5705,5706,5707,5711,5713,5714,5737,5740,5742,5747,5748,5749,
   5753,5755,5756,5971,5973,5978,5979,5980,5984,5986,5987,6075,
   6080,6081,6086,6089,6143,6144,6145,6149,6151,6152,6284,6285,
   6289,6291,6292,6310,6314,6316,6317,6340,6341,6427,6464,7725,
   7726,7732,7735,7737,7742,7743,7744,7748,7750,7751,7769,7775,
   7778,7780,7785,7786,7787,7791,7793,7794,7817,7820,7822,7827,
   7828,7829,7833,7835,7836,8051,8053,8058,8059,8060,8064,8066,
   8067,8155,8160,8161,8162,8166,8168,8169,8223,8224,8225,8231,
   8364,8365,8369,8371,8372,8390,8394,8396,8397,8420,8506,8507,
   8544,38205,38211,38214,38216,38221,38222,38223,38227,38229,
   38230,38253,38256,38258,38263,38264,38265,38269,38271,38272,
   38487,38489,38494,38495,38496,38500,38502,38503,38591,38596,
   38597,38598,38602,38604,38605,38659,38660,38661,38665,38667,
   38668,38800,38801,38805,38807,38808,38826,38830,38832,38833,
   38854,38856,38857,38942,38943,38980,39156,39159,39161,39166,
   39167,39168,39172,39174,39175,39390,39392,39397,39398,39399,
   39403,39405,39406,39494,39499,39500,39501,39505,39507,39508,
   39562,39563,39564,39568,39570,39571,39703,39704,39708,39710,
   39711,39729,39733,39735,39736,39757,39759,39760,39845,39846,
   39883,40251,40253,40258,40259,40260,40264,40266,40267,40355,
   40360,40361,40362,40366,40368,40369,40423,40424,40425,40429,
   40431,40432,40564,40565,40569,40571,40572,40590,40594,40596,
   40597,40618,40620,40621,40706,40707,40744,44695,44700,44701,
   44702,44706,44708,44709,44763,44764,44765,44769,44771,44772,
   44904,44905,44909,44911,44912,44930,44934,44936,44937,44958,
   44960,44961,45046,45047,45084,46447,46448,46449,46453,46455,
   46456,46588,46589,46593,46595,46596,46614,46618,46620,46621,
   46642,46644,46645,46730,46731,46768,47549,47550,47554,47556,
   47557,47575,47579,47581,47582,47603,47605,47606,47691,47692,
   47729,49470,49474,49476,49477,49498,49500,49501,49586,49587,
   49624,49798,49800,49801,49886,49887,49924,50162,50163,50200,
   51084],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,
   2384,3500,3501,3505,3506,3507,3513,3514,3517,3518,3527,3528,
   3544,3548,3549,3550,3556,3557,3560,3561,3570,3571,3590,3591,
   3592,3598,3599,3602,3603,3612,3613,3749,3750,3756,3757,3760,
   3761,3770,3771,3787,3793,3794,3797,3798,3829,3830,3833,3834,
   3843,3844,4025,4028,4029,4038,4039,4057,4058,4139,4148,4149,
   4173,4174,4354,4510,4511,4512,4518,4528,4529,5645,5646,5650,
   5651,5652,5658,5659,5662,5663,5672,5673,5689,5693,5694,5695,
   5701,5702,5705,5706,5715,5716,5735,5736,5737,5743,5744,5747,
   5748,5757,5758,5894,5895,5902,5905,5906,5916,5932,5939,5942,
   5943,5953,5974,5975,5978,5979,5988,5989,6170,6173,6174,6183,
   6184,6202,6203,6212,6213,6284,6293,6294,6318,6319,6499,7725,
   7726,7730,7731,7732,7738,7739,7742,7743,7752,7753,7769,7773,
   7774,7775,7781,7782,7785,7786,7795,7796,7815,7816,7817,7823,
   7824,7827,7828,7837,7838,7974,7975,7985,7986,7995,7996,8012,
   8018,8019,8022,8023,8032,8033,8054,8055,8058,8059,8068,8069,
   8250,8253,8254,8263,8282,8283,8292,8364,8373,8374,8398,8399,
   8579,38205,38209,38210,38211,38217,38218,38221,38222,38231,
   38232,38251,38252,38253,38259,38260,38263,38264,38273,38274,
   38410,38411,38417,38418,38421,38422,38431,38432,38448,38454,
   38455,38458,38459,38468,38469,38490,38491,38494,38495,38504,
   38505,38686,38689,38690,38699,38700,38718,38719,38728,38729,
   38800,38809,38810,38834,38835,39015,39154,39155,39156,39162,
   39163,39166,39167,39176,39177,39313,39314,39320,39321,39324,
   39325,39334,39335,39351,39357,39358,39361,39362,39371,39372,
   39393,39394,39397,39398,39407,39408,39589,39592,39593,39602,
   39603,39621,39622,39631,39632,39703,39712,39713,39737,39738,
   39918,40174,40175,40181,40182,40185,40186,40195,40196,40212,
   40218,40219,40222,40223,40232,40233,40254,40255,40258,40259,
   40268,40269,40450,40453,40454,40463,40464,40482,40483,40492,
   40493,40564,40573,40574,40598,40599,40779,43256,43262,43263,
   43266,43267,43276,43277,43298,43299,43302,43303,43312,43313,
   43494,43497,43498,43507,43508,43526,43527,43536,43537,43608,
   43617,43618,43642,43643,43823,43964,43965,43968,43969,43978,
   43979,44160,44163,44164,44173,44174,44192,44193,44202,44203,
   44274,44283,44284,44308,44309,44489,44790,44793,44794,44803,
   44804,44822,44823,44832,44833,44904,44913,44914,44938,44939,
   45119,47902,47903,47912,47913,47984,47993,47994,48018,48019,
   48199,48390,48399,48400,48424,48425,48605,49478,49479,49659,
   49959],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,
   2384,3500,3501,3505,3506,3507,3513,3514,3517,3518,3527,3528,
   3544,3548,3549,3550,3556,3557,3560,3561,3570,3571,3590,3591,
   3592,3598,3599,3602,3603,3612,3613,3749,3750,3756,3757,3760,
   3761,3770,3771,3787,3793,3794,3797,3798,3829,3830,3833,3834,
   3843,3844,4025,4028,4029,4038,4039,4057,4058,4139,4148,4149,
   4173,4174,4354,4510,4511,4512,4518,4528,4529,5645,5646,5650,
   5651,5652,5658,5659,5662,5663,5672,5673,5689,5693,5694,5695,
   5701,5702,5705,5706,5715,5716,5735,5736,5737,5743,5744,5747,
   5748,5757,5758,5894,5895,5902,5905,5906,5916,5932,5939,5942,
   5943,5953,5974,5975,5978,5979,5988,5989,6170,6173,6174,6183,
   6184,6202,6203,6212,6213,6284,6293,6294,6318,6319,6499,7725,
   7726,7730,7731,7732,7738,7739,7742,7743,7752,7753,7769,7773,
   7774,7775,7781,7782,7785,7786,7795,7796,7815,7816,7817,7823,
   7824,7827,7828,7837,7838,7974,7975,7985,7986,7995,7996,8012,
   8018,8019,8022,8023,8032,8033,8054,8055,8058,8059,8068,8069,
   8250,8253,8254,8263,8282,8283,8292,8364,8373,8374,8398,8399,
   8579,38205,38209,38210,38211,38217,38218,38221,38222,38231,
   38232,38251,38252,38253,38259,38260,38263,38264,38273,38274,
   38410,38411,38417,38418,38421,38422,38431,38432,38448,38454,
   38455,38458,38459,38468,38469,38490,38491,38494,38495,38504,
   38505,38686,38689,38690,38699,38700,38718,38719,38728,38729,
   38800,38809,38810,38834,38835,39015,39154,39155,39156,39162,
   39163,39166,39167,39176,39177,39313,39314,39320,39321,39324,
   39325,39334,39335,39351,39357,39358,39361,39362,39371,39372,
   39393,39394,39397,39398,39407,39408,39589,39592,39593,39602,
   39603,39621,39622,39631,39632,39703,39712,39713,39737,39738,
   39918,40174,40175,40181,40182,40185,40186,40195,40196,40212,
   40218,40219,40222,40223,40232,40233,40254,40255,40258,40259,
   40268,40269,40450,40453,40454,40463,40464,40482,40483,40492,
   40493,40564,40573,40574,40598,40599,40779,43256,43262,43263,
   43266,43267,43276,43277,43298,43299,43302,43303,43312,43313,
   43494,43497,43498,43507,43508,43526,43527,43536,43537,43608,
   43617,43618,43642,43643,43823,43964,43965,43968,43969,43978,
   43979,44160,44163,44164,44173,44174,44192,44193,44202,44203,
   44274,44283,44284,44308,44309,44489,44790,44793,44794,44803,
   44804,44822,44823,44832,44833,44904,44913,44914,44938,44939,
   45119,47902,47903,47912,47913,47984,47993,47994,48018,48019,
   48199,48390,48399,48400,48424,48425,48605,49478,49479,49659,
   49959],[2279],[2279],[2279],[2279],[2279],[2279],
 [2279],[2279],[2279],[2279],[2279],[2279],[2279],
 [2279],[2279],[8715],[8715],[],
 [90,94,107,202,236,482,1336,1349,1511,4575,4592,4821,4838,
   5692,5705,5867,8934,9788,9801,9963,17232,17245,17407,39286],
 [4575,4577,4578,4592,4880,4882,4883,4897,4995,5012,5690,5691,
   5705,5774,5788,5828,8962,8976,8978,8979,8993,9091,9093,9094,
   9108,9786,9787,9801,9870,9884,9924,18246,18248,18249,18263,
   18941,18942,18956,19025,19039,19079,22190,22191,22205,22274,
   22288,22328,39193,39207,39247,40928],[],
 [4575,4577,4578,4592,4880,4882,4883,4897,4995,5012,5690,5691,
   5705,5774,5788,5828,8962,8976,8978,8979,8993,9091,9093,9094,
   9108,9786,9787,9801,9870,9884,9924,18246,18248,18249,18263,
   18941,18942,18956,19025,19039,19079,22190,22191,22205,22274,
   22288,22328,39193,39207,39247,40928],[],[],[],[],
 [],[],[],[],[],[],[],[],
 [4575,4592,5645,5646,5662,5689,5705,5747,9741,9742,9758,9785,
   9801,9843,38205,38221,38263,39166],[5705],
 [4575,4592,5645,5646,5662,5689,5705,5747,9741,9742,9758,9785,
   9801,9843,38205,38221,38263,39166],
 [4575,4592,5690,5691,5705,5774,5788,5828,9786,9787,9801,9870,
   9884,9924,39193,39207,39247,40928],
 [4575,4592,5690,5691,5705,5774,5788,5828,9786,9787,9801,9870,
   9884,9924,39193,39207,39247,40928],
 [90,94,107,202,236,482,1336,1349,1511,4575,4592,4821,4838,
   5692,5705,5867,8934,9788,9801,9963,17232,17245,17407,39286],
 [4575,4592,5693,5694,5705,5894,5905,5942,9789,9790,9801,9990,
   10001,10038,39313,39324,39361,43266],
 [4575,4592,5693,5694,5705,5894,5905,5942,9789,9790,9801,9990,
   10001,10038,39313,39324,39361,43266],
 [4575,4592,5695,5705,5706,5978,5979,6284,9791,9801,9802,10074,
   10075,10380,39397,39398,39703,44904],
 [4575,4592,5696,5697,5705,5708,5710,6005,6013,6016,6018,6047,
   6050,6052,6286,6288,6360,9792,9793,9801,9804,9806,10101,
   10109,10112,10114,10143,10146,10148,10382,10384,10456,39424,
   39432,39435,39437,39466,39469,39471,39705,39707,39779,45262,
   45265,45267,45501,45503,45575,46062,46064,46136,49520],
 [4575,4592,5696,5697,5705,5708,5710,6005,6013,6016,6018,6047,
   6050,6052,6286,6288,6360,9792,9793,9801,9804,9806,10101,
   10109,10112,10114,10143,10146,10148,10382,10384,10456,39424,
   39432,39435,39437,39466,39469,39471,39705,39707,39779,45262,
   45265,45267,45501,45503,45575,46062,46064,46136,49520],
 [4575,4592,5698,5705,5711,6080,6086,6289,9794,9801,9807,10176,
   10182,10385,39499,39505,39708,46593],
 [4575,4592,5699,5705,5712,6112,6119,6290,9795,9801,9808,10208,
   10215,10386,39531,39538,39709,47090],[6152],[6183,10279],
 [6213],[],[],[5705],
 [4575,4592,5695,5705,5706,5978,5979,6284,9791,9801,9802,10074,
   10075,10380,39397,39398,39703,44904],[6340,10436],
 [4575,4592,5696,5697,5705,5708,5710,6005,6013,6016,6018,6047,
   6050,6052,6286,6288,6360,9792,9793,9801,9804,9806,10101,
   10109,10112,10114,10143,10146,10148,10382,10384,10456,39424,
   39432,39435,39437,39466,39469,39471,39705,39707,39779,45262,
   45265,45267,45501,45503,45575,46062,46064,46136,49520],[],
 [4575,4592,5696,5697,5705,5708,5710,6005,6013,6016,6018,6047,
   6050,6052,6286,6288,6360,9792,9793,9801,9804,9806,10101,
   10109,10112,10114,10143,10146,10148,10382,10384,10456,39424,
   39432,39435,39437,39466,39469,39471,39705,39707,39779,45262,
   45265,45267,45501,45503,45575,46062,46064,46136,49520],
 [4575,4592,5698,5705,5711,6080,6086,6289,9794,9801,9807,10176,
   10182,10385,39499,39505,39708,46593],
 [4575,4592,5699,5705,5712,6112,6119,6290,9795,9801,9808,10208,
   10215,10386,39531,39538,39709,47090],[6340,10436],[6152],
 [6183,10279],[6213],[],[],[],[],[],[],[],
 [6610,10706],[],[],[],[6610,10706],[],[],[],
 [8715],[],[10854],[10854],[],[],[],
 [4638,4655,5106,5123,5705,11155,11172,11754,25230],[],[],
 [],[],[],[],[],[],[],[],
 [4638,4655,5645,5646,5662,5689,5705,5747,11694,11695,11711,
   11738,11754,11796,38205,38221,38263,39166],[5705],
 [4638,4655,5645,5646,5662,5689,5705,5747,11694,11695,11711,
   11738,11754,11796,38205,38221,38263,39166],
 [4638,4655,5690,5691,5705,5774,5788,5828,11739,11740,11754,
   11823,11837,11877,39193,39207,39247,40928],
 [4638,4655,5690,5691,5705,5774,5788,5828,11739,11740,11754,
   11823,11837,11877,39193,39207,39247,40928],[],
 [4638,4655,5693,5694,5705,5894,5905,5942,11742,11743,11754,
   11943,11954,11991,39313,39324,39361,43266],
 [4638,4655,5693,5694,5705,5894,5905,5942,11742,11743,11754,
   11943,11954,11991,39313,39324,39361,43266],
 [4638,4655,5695,5705,5706,5978,5979,6284,11744,11754,11755,
   12027,12028,12333,39397,39398,39703,44904],
 [4638,4655,5696,5697,5705,5708,5710,6005,6013,6016,6018,6047,
   6050,6052,6286,6288,6360,11745,11746,11754,11757,11759,12054,
   12062,12065,12067,12096,12099,12101,12335,12337,12409,39424,
   39432,39435,39437,39466,39469,39471,39705,39707,39779,45262,
   45265,45267,45501,45503,45575,46062,46064,46136,49520],
 [4638,4655,5696,5697,5705,5708,5710,6005,6013,6016,6018,6047,
   6050,6052,6286,6288,6360,11745,11746,11754,11757,11759,12054,
   12062,12065,12067,12096,12099,12101,12335,12337,12409,39424,
   39432,39435,39437,39466,39469,39471,39705,39707,39779,45262,
   45265,45267,45501,45503,45575,46062,46064,46136,49520],
 [4638,4655,5698,5705,5711,6080,6086,6289,11747,11754,11760,
   12129,12135,12338,39499,39505,39708,46593],
 [4638,4655,5699,5705,5712,6112,6119,6290,11748,11754,11761,
   12161,12168,12339,39531,39538,39709,47090],[6152],
 [6183,12232],[6213],[],[],[5705],
 [4638,4655,5695,5705,5706,5978,5979,6284,11744,11754,11755,
   12027,12028,12333,39397,39398,39703,44904],[6340,12389],
 [4638,4655,5696,5697,5705,5708,5710,6005,6013,6016,6018,6047,
   6050,6052,6286,6288,6360,11745,11746,11754,11757,11759,12054,
   12062,12065,12067,12096,12099,12101,12335,12337,12409,39424,
   39432,39435,39437,39466,39469,39471,39705,39707,39779,45262,
   45265,45267,45501,45503,45575,46062,46064,46136,49520],[],
 [4638,4655,5696,5697,5705,5708,5710,6005,6013,6016,6018,6047,
   6050,6052,6286,6288,6360,11745,11746,11754,11757,11759,12054,
   12062,12065,12067,12096,12099,12101,12335,12337,12409,39424,
   39432,39435,39437,39466,39469,39471,39705,39707,39779,45262,
   45265,45267,45501,45503,45575,46062,46064,46136,49520],
 [4638,4655,5698,5705,5711,6080,6086,6289,11747,11754,11760,
   12129,12135,12338,39499,39505,39708,46593],
 [4638,4655,5699,5705,5712,6112,6119,6290,11748,11754,11761,
   12161,12168,12339,39531,39538,39709,47090],[6340,12389],
 [6152],[6183,12232],[6213],[],[],[],[],[],
 [6593,12642],[],[],[],[6593,12642],[],[],[],[],
 [],[],
 [4699,4700,4701,4717,4820,4821,4822,4838,4995,5012,5645,5646,
   5662,5689,5705,5747,12747,12760,12761,12762,12778,12934,
   12935,12936,12952,13585,13586,13602,13629,13645,13687,16534,
   16535,16536,16552,17185,17186,17202,17229,17245,17287,22145,
   22146,22162,22189,22205,22247,38205,38221,38263,39166],
 [69,70,73,76,89,90,91,92,93,94,107,199,200,202,203,205,
   218,219,220,221,222,223,236,263,265,266,268,281,282,283,
   284,285,286,299,327,328,330,343,344,345,346,347,348,361,
   449,451,464,465,466,467,468,469,482,510,523,524,525,526,
   527,528,541,638,639,640,641,642,643,656,1289,1290,1291,
   1292,1293,1306,1333,1334,1335,1336,1349,1376,1377,1378,1391,
   1418,1419,1432,1459,1472,1511,4555,4556,4558,4559,4561,4574,
   4575,4576,4577,4578,4579,4592,4619,4621,4622,4624,4637,4638,
   4639,4640,4641,4642,4655,4683,4686,4699,4700,4701,4702,4703,
   4704,4717,4805,4807,4820,4821,4822,4823,4824,4825,4838,4866,
   4879,4880,4881,4882,4883,4884,4897,4994,4995,4996,4997,4998,
   4999,5012,5645,5646,5647,5648,5649,5662,5689,5690,5691,5692,
   5705,5732,5733,5734,5747,5774,5775,5788,5815,5828,5867,8715,
   8717,8718,8720,8733,8734,8735,8736,8737,8738,8751,8779,8780,
   8782,8795,8796,8797,8798,8799,8800,8813,8901,8903,8916,8917,
   8918,8919,8920,8921,8934,8962,8975,8976,8977,8978,8979,8980,
   8993,9090,9091,9092,9093,9094,9095,9108,9741,9742,9743,9744,
   9745,9758,9785,9786,9787,9788,9801,9828,9829,9830,9843,9870,
   9871,9884,9911,9924,9963,10732,10733,10735,10748,10749,10750,
   10751,10752,10753,10766,10854,10856,10869,10870,10871,10872,
   10873,10874,10887,10915,10928,10929,10930,10931,10932,10933,
   10946,11043,11044,11045,11046,11047,11048,11061,11694,11695,
   11696,11697,11698,11711,11738,11739,11740,11741,11754,11781,
   11782,11783,11796,11823,11824,11837,11864,11877,11916,12745,
   12747,12760,12761,12762,12763,12764,12765,12778,12806,12819,
   12820,12821,12822,12823,12824,12837,12934,12935,12936,12937,
   12938,12939,12952,13585,13586,13587,13588,13589,13602,13629,
   13630,13631,13632,13645,13672,13673,13674,13687,13714,13715,
   13728,13755,13768,13807,16406,16419,16420,16421,16422,16423,
   16424,16437,16534,16535,16536,16537,16538,16539,16552,17185,
   17186,17187,17188,17189,17202,17229,17230,17231,17232,17245,
   17272,17273,17274,17287,17314,17315,17328,17355,17368,17407,
   18245,18246,18247,18248,18249,18250,18263,18896,18897,18898,
   18899,18900,18913,18940,18941,18942,18943,18956,18983,18984,
   18985,18998,19025,19026,19039,19066,19079,19118,22145,22146,
   22147,22148,22149,22162,22189,22190,22191,22192,22205,22232,
   22233,22234,22247,22274,22275,22288,22315,22328,22367,38205,
   38206,38207,38208,38221,38248,38249,38250,38263,38290,38291,
   38304,38331,38344,38383,39151,39152,39153,39166,39193,39194,
   39207,39234,39247,39286,40054,40055,40068,40095,40108,40147,
   40915,40928,40967,41747],[],
 [4699,4700,4701,4717,4820,4821,4822,4838,4995,5012,5645,5646,
   5662,5689,5705,5747,12747,12760,12761,12762,12778,12934,
   12935,12936,12952,13585,13586,13602,13629,13645,13687,16534,
   16535,16536,16552,17185,17186,17202,17229,17245,17287,22145,
   22146,22162,22189,22205,22247,38205,38221,38263,39166],
 [12979],[12979],[],[],[],[],[],[],[],[],[],
 [],[4700,4717,5645,5646,5662,5689,5705,5747,13585,13586,
   13602,13629,13645,13687,38205,38221,38263,39166],[5705],
 [4700,4717,5645,5646,5662,5689,5705,5747,13585,13586,13602,
   13629,13645,13687,38205,38221,38263,39166],
 [4555,4556,4575,4577,4578,4592,4619,4638,4640,4641,4655,4700,
   4717,5690,5691,5705,5774,5788,5828,8715,8734,8736,8737,8751,
   8796,8798,8799,8813,9786,9787,9801,9870,9884,9924,10749,
   10751,10752,10766,11739,11740,11754,11823,11837,11877,13630,
   13631,13645,13714,13728,13768,39193,39207,39247,40928],
 [4555,4556,4575,4577,4578,4592,4619,4638,4640,4641,4655,4700,
   4717,5690,5691,5705,5774,5788,5828,8715,8734,8736,8737,8751,
   8796,8798,8799,8813,9786,9787,9801,9870,9884,9924,10749,
   10751,10752,10766,11739,11740,11754,11823,11837,11877,13630,
   13631,13645,13714,13728,13768,39193,39207,39247,40928],[],
 [4700,4717,5693,5694,5705,5894,5905,5942,13633,13634,13645,
   13834,13845,13882,39313,39324,39361,43266],
 [4700,4717,5693,5694,5705,5894,5905,5942,13633,13634,13645,
   13834,13845,13882,39313,39324,39361,43266],
 [4555,4556,4575,4582,4592,4593,4619,4638,4645,4655,4656,4700,
   4717,5695,5705,5706,5978,5979,6284,8715,8734,8741,8751,8752,
   8796,8803,8813,8814,9791,9801,9802,10074,10075,10380,10749,
   10756,10766,10767,11744,11754,11755,12027,12028,12333,13635,
   13645,13646,13918,13919,14224,39397,39398,39703,44904],
 [6018,13958],
 [4700,4708,4717,4722,5696,5697,5705,5708,5710,6005,6013,6016,
   6018,6047,6050,6052,6286,6288,6360,13636,13637,13645,13648,
   13650,13945,13953,13956,13958,13987,13990,13992,14226,14228,
   14300,39424,39432,39435,39437,39466,39469,39471,39705,39707,
   39779,45262,45265,45267,45501,45503,45575,46062,46064,46136,
   49520],
 [4700,4717,5698,5705,5711,6080,6086,6289,13638,13645,13651,
   14020,14026,14229,39499,39505,39708,46593],
 [4699,4700,4701,4708,4709,4717,4720,4722,5645,5646,5653,5654,
   5656,5662,5665,5667,5669,5689,5696,5697,5699,5705,5708,5710,
   5712,5738,5739,5741,5747,5750,5752,5754,6005,6007,6013,6016,
   6018,6020,6041,6047,6050,6052,6054,6112,6115,6117,6119,6286,
   6288,6290,6360,6362,6405,13585,13586,13593,13594,13596,13602,
   13605,13607,13609,13629,13636,13637,13639,13645,13648,13650,
   13652,13678,13679,13681,13687,13690,13692,13694,13945,13947,
   13953,13956,13958,13960,13981,13987,13990,13992,13994,14052,
   14055,14057,14059,14226,14228,14230,14300,14302,14345,38205,
   38212,38213,38215,38221,38224,38226,38228,38254,38255,38257,
   38263,38266,38268,38270,38521,38523,38529,38532,38534,38536,
   38557,38563,38566,38568,38570,38628,38631,38633,38635,38802,
   38804,38806,38876,38878,38921,39157,39158,39160,39166,39169,
   39171,39173,39424,39426,39432,39435,39437,39439,39460,39466,
   39469,39471,39473,39531,39534,39536,39538,39705,39707,39709,
   39779,39781,39824,40285,40287,40293,40296,40298,40300,40321,
   40327,40330,40332,40334,40392,40395,40397,40399,40566,40568,
   40570,40640,40642,40685,45256,45262,45265,45267,45269,45327,
   45330,45332,45334,45501,45503,45505,45575,45577,45620,45888,
   45891,45893,45895,46062,46064,46066,46136,46138,46181,47086,
   47088,47090,47160,47162,47205,49520,49522,49565,50394],
 [6152],[6183,14123],[6213],[],[],[5705],
 [4555,4556,4575,4582,4592,4593,4619,4638,4645,4655,4656,4700,
   4717,5695,5705,5706,5978,5979,6284,8715,8734,8741,8751,8752,
   8796,8803,8813,8814,9791,9801,9802,10074,10075,10380,10749,
   10756,10766,10767,11744,11754,11755,12027,12028,12333,13635,
   13645,13646,13918,13919,14224,39397,39398,39703,44904],
 [6340,14280],
 [4700,4708,4717,4722,5696,5697,5705,5708,5710,6005,6013,6016,
   6018,6047,6050,6052,6286,6288,6360,13636,13637,13645,13648,
   13650,13945,13953,13956,13958,13987,13990,13992,14226,14228,
   14300,39424,39432,39435,39437,39466,39469,39471,39705,39707,
   39779,45262,45265,45267,45501,45503,45575,46062,46064,46136,
   49520],[],[6018,13958],
 [4700,4717,5698,5705,5711,6080,6086,6289,13638,13645,13651,
   14020,14026,14229,39499,39505,39708,46593],
 [4699,4700,4701,4708,4709,4717,4720,4722,5645,5646,5653,5654,
   5656,5662,5665,5667,5669,5689,5696,5697,5699,5705,5708,5710,
   5712,5738,5739,5741,5747,5750,5752,5754,6005,6007,6013,6016,
   6018,6020,6041,6047,6050,6052,6054,6112,6115,6117,6119,6286,
   6288,6290,6360,6362,6405,13585,13586,13593,13594,13596,13602,
   13605,13607,13609,13629,13636,13637,13639,13645,13648,13650,
   13652,13678,13679,13681,13687,13690,13692,13694,13945,13947,
   13953,13956,13958,13960,13981,13987,13990,13992,13994,14052,
   14055,14057,14059,14226,14228,14230,14300,14302,14345,38205,
   38212,38213,38215,38221,38224,38226,38228,38254,38255,38257,
   38263,38266,38268,38270,38521,38523,38529,38532,38534,38536,
   38557,38563,38566,38568,38570,38628,38631,38633,38635,38802,
   38804,38806,38876,38878,38921,39157,39158,39160,39166,39169,
   39171,39173,39424,39426,39432,39435,39437,39439,39460,39466,
   39469,39471,39473,39531,39534,39536,39538,39705,39707,39709,
   39779,39781,39824,40285,40287,40293,40296,40298,40300,40321,
   40327,40330,40332,40334,40392,40395,40397,40399,40566,40568,
   40570,40640,40642,40685,45256,45262,45265,45267,45269,45327,
   45330,45332,45334,45501,45503,45505,45575,45577,45620,45888,
   45891,45893,45895,46062,46064,46066,46136,46138,46181,47086,
   47088,47090,47160,47162,47205,49520,49522,49565,50394],
 [6340,14280],[6152],[6183,14123],[6213],[],[],[],
 [14514],[14523],[],[],[],[14523],[14514],[14565],
 [14565],[],[],[],
 [4761,4778,4821,4838,5705,14591,14608,15475,17245],[14635],
 [14635],[],[],[],[],[],[],[],[],[],[],
 [],[],[],
 [4761,4778,5645,5646,5662,5689,5705,5747,15415,15416,15432,
   15459,15475,15517,38205,38221,38263,39166],[5705],
 [4761,4778,5645,5646,5662,5689,5705,5747,15415,15416,15432,
   15459,15475,15517,38205,38221,38263,39166],
 [4761,4778,5690,5691,5705,5774,5788,5828,15460,15461,15475,
   15544,15558,15598,39193,39207,39247,40928],
 [4761,4778,5690,5691,5705,5774,5788,5828,15460,15461,15475,
   15544,15558,15598,39193,39207,39247,40928],[],
 [4761,4778,5693,5694,5705,5894,5905,5942,15463,15464,15475,
   15664,15675,15712,39313,39324,39361,43266],
 [4761,4778,5693,5694,5705,5894,5905,5942,15463,15464,15475,
   15664,15675,15712,39313,39324,39361,43266],
 [4761,4778,5695,5705,5706,5978,5979,6284,15465,15475,15476,
   15748,15749,16054,39397,39398,39703,44904],
 [4760,4762,4772,4785,5646,5653,5656,5667,5669,5738,5741,5752,
   5754,6007,6018,6020,6117,6119,6405,15416,15423,15426,15437,
   15439,15508,15511,15522,15524,15777,15788,15790,15887,15889,
   16175,38254,38257,38268,38270,38523,38534,38536,38633,38635,
   38921,40287,40298,40300,40397,40399,40685,45332,45334,45620,
   47205],[6050,15820],
 [4761,4778,5698,5705,5711,6080,6086,6289,15468,15475,15481,
   15850,15856,16059,39499,39505,39708,46593],
 [4761,4778,5699,5705,5712,6112,6119,6290,15469,15475,15482,
   15882,15889,16060,39531,39538,39709,47090],[6152],
 [6183,15953],[6213],[],[],[5705],
 [4761,4778,5695,5705,5706,5978,5979,6284,15465,15475,15476,
   15748,15749,16054,39397,39398,39703,44904],[6340,16110],
 [6050,15820],[],
 [4760,4762,4772,4785,5646,5653,5656,5667,5669,5738,5741,5752,
   5754,6007,6018,6020,6117,6119,6405,15416,15423,15426,15437,
   15439,15508,15511,15522,15524,15777,15788,15790,15887,15889,
   16175,38254,38257,38268,38270,38523,38534,38536,38633,38635,
   38921,40287,40298,40300,40397,40399,40685,45332,45334,45620,
   47205],
 [4761,4778,5698,5705,5711,6080,6086,6289,15468,15475,15481,
   15850,15856,16059,39499,39505,39708,46593],
 [4761,4778,5699,5705,5712,6112,6119,6290,15469,15475,15482,
   15882,15889,16060,39531,39538,39709,47090],[6340,16110],
 [6152],[6183,15953],[6213],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[10854],[],
 [4699,4700,4701,4717,4820,4821,4822,4838,4995,5012,5645,5646,
   5662,5689,5705,5747,12747,12760,12761,12762,12778,12934,
   12935,12936,12952,13585,13586,13602,13629,13645,13687,16534,
   16535,16536,16552,17185,17186,17202,17229,17245,17287,22145,
   22146,22162,22189,22205,22247,38205,38221,38263,39166],[],
 [4835,4849,5120,5134,6213,16660,16674,17753,25738],[],[],
 [],[],[],[],[],[],[],[],
 [4821,4838,5645,5646,5662,5689,5705,5747,17185,17186,17202,
   17229,17245,17287,38205,38221,38263,39166],[5705],
 [4821,4838,5645,5646,5662,5689,5705,5747,17185,17186,17202,
   17229,17245,17287,38205,38221,38263,39166],
 [4821,4838,5690,5691,5705,5774,5788,5828,17230,17231,17245,
   17314,17328,17368,39193,39207,39247,40928],
 [4821,4838,5690,5691,5705,5774,5788,5828,17230,17231,17245,
   17314,17328,17368,39193,39207,39247,40928],
 [90,94,107,202,236,482,1336,1349,1511,4575,4592,4821,4838,
   5692,5705,5867,8934,9788,9801,9963,17232,17245,17407,39286],
 [4821,4838,5693,5694,5705,5894,5905,5942,17233,17234,17245,
   17434,17445,17482,39313,39324,39361,43266],
 [4821,4838,5693,5694,5705,5894,5905,5942,17233,17234,17245,
   17434,17445,17482,39313,39324,39361,43266],
 [4821,4838,5695,5705,5706,5978,5979,6284,17235,17245,17246,
   17518,17519,17824,39397,39398,39703,44904],
 [4821,4838,5696,5697,5705,5708,5710,6005,6013,6016,6018,6047,
   6050,6052,6286,6288,6360,17236,17237,17245,17248,17250,17545,
   17553,17556,17558,17587,17590,17592,17826,17828,17900,39424,
   39432,39435,39437,39466,39469,39471,39705,39707,39779,45262,
   45265,45267,45501,45503,45575,46062,46064,46136,49520],
 [4821,4838,5696,5697,5705,5708,5710,6005,6013,6016,6018,6047,
   6050,6052,6286,6288,6360,17236,17237,17245,17248,17250,17545,
   17553,17556,17558,17587,17590,17592,17826,17828,17900,39424,
   39432,39435,39437,39466,39469,39471,39705,39707,39779,45262,
   45265,45267,45501,45503,45575,46062,46064,46136,49520],
 [4821,4838,5698,5705,5711,6080,6086,6289,17238,17245,17251,
   17620,17626,17829,39499,39505,39708,46593],
 [4821,4838,5699,5705,5712,6112,6119,6290,17239,17245,17252,
   17652,17659,17830,39531,39538,39709,47090],[6152],
 [6183,17723],[6213],[],[],[5705],
 [4821,4838,5695,5705,5706,5978,5979,6284,17235,17245,17246,
   17518,17519,17824,39397,39398,39703,44904],[6340,17880],
 [4821,4838,5696,5697,5705,5708,5710,6005,6013,6016,6018,6047,
   6050,6052,6286,6288,6360,17236,17237,17245,17248,17250,17545,
   17553,17556,17558,17587,17590,17592,17826,17828,17900,39424,
   39432,39435,39437,39466,39469,39471,39705,39707,39779,45262,
   45265,45267,45501,45503,45575,46062,46064,46136,49520],[],
 [4821,4838,5696,5697,5705,5708,5710,6005,6013,6016,6018,6047,
   6050,6052,6286,6288,6360,17236,17237,17245,17248,17250,17545,
   17553,17556,17558,17587,17590,17592,17826,17828,17900,39424,
   39432,39435,39437,39466,39469,39471,39705,39707,39779,45262,
   45265,45267,45501,45503,45575,46062,46064,46136,49520],
 [4821,4838,5698,5705,5711,6080,6086,6289,17238,17245,17251,
   17620,17626,17829,39499,39505,39708,46593],
 [4821,4838,5699,5705,5712,6112,6119,6290,17239,17245,17252,
   17652,17659,17830,39531,39538,39709,47090],[6340,17880],
 [6152],[6183,17723],[6213],[],[],[],[],[],[],
 [],[],[],[],[6626,18166],[],[6626,18166],[],[],
 [14635],
 [4575,4577,4578,4592,4880,4882,4883,4897,4995,5012,5690,5691,
   5705,5774,5788,5828,8962,8976,8978,8979,8993,9091,9093,9094,
   9108,9786,9787,9801,9870,9884,9924,18246,18248,18249,18263,
   18941,18942,18956,19025,19039,19079,22190,22191,22205,22274,
   22288,22328,39193,39207,39247,40928],[],[],[],[],
 [],[],[],[],[],[],[],[],
 [4621,4622,4637,4638,4639,4655,4805,4820,4821,4822,4838,4880,
   4897,5645,5646,5662,5689,5705,5747,10854,10869,10870,10871,
   10887,10928,10929,10930,10946,11694,11695,11711,11738,11754,
   11796,16419,16420,16421,16437,17185,17186,17202,17229,17245,
   17287,18896,18897,18913,18940,18956,18998,38205,38221,38263,
   39166],[5705],
 [4621,4622,4637,4638,4639,4655,4805,4820,4821,4822,4838,4880,
   4897,5645,5646,5662,5689,5705,5747,10854,10869,10870,10871,
   10887,10928,10929,10930,10946,11694,11695,11711,11738,11754,
   11796,16419,16420,16421,16437,17185,17186,17202,17229,17245,
   17287,18896,18897,18913,18940,18956,18998,38205,38221,38263,
   39166],
 [4880,4897,5690,5691,5705,5774,5788,5828,18941,18942,18956,
   19025,19039,19079,39193,39207,39247,40928],
 [4880,4897,5690,5691,5705,5774,5788,5828,18941,18942,18956,
   19025,19039,19079,39193,39207,39247,40928],[],
 [4880,4897,5693,5694,5705,5894,5905,5942,18944,18945,18956,
   19145,19156,19193,39313,39324,39361,43266],
 [4880,4897,5693,5694,5705,5894,5905,5942,18944,18945,18956,
   19145,19156,19193,39313,39324,39361,43266],
 [4880,4897,5695,5705,5706,5978,5979,6284,18946,18956,18957,
   19229,19230,19535,39397,39398,39703,44904],[6018,19269],
 [4880,4882,4883,4887,4888,4897,4898,4902,5690,5691,5695,5696,
   5697,5705,5706,5708,5710,5774,5778,5779,5780,5788,5789,5791,
   5793,5818,5819,5820,5828,5829,5831,5833,5969,5970,5978,5979,
   5981,5983,6005,6013,6014,6016,6018,6047,6048,6050,6052,6284,
   6286,6288,6311,6313,6360,18941,18942,18946,18947,18948,18956,
   18957,18959,18961,19025,19029,19030,19031,19039,19040,19042,
   19044,19069,19070,19071,19079,19080,19082,19084,19220,19221,
   19229,19230,19232,19234,19256,19264,19265,19267,19269,19298,
   19299,19301,19303,19535,19537,19539,19562,19564,19611,39193,
   39197,39198,39199,39207,39208,39210,39212,39237,39238,39239,
   39247,39248,39250,39252,39388,39389,39397,39398,39400,39402,
   39424,39432,39433,39435,39437,39466,39467,39469,39471,39703,
   39705,39707,39730,39732,39779,40918,40919,40920,40928,40929,
   40931,40933,41069,41070,41078,41079,41081,41083,41105,41113,
   41114,41116,41118,41147,41148,41150,41152,41384,41386,41388,
   41411,41413,41460,41849,41850,41858,41859,41861,41863,41885,
   41893,41894,41896,41898,41927,41928,41930,41932,42164,42166,
   42168,42191,42193,42240,44625,44633,44634,44636,44638,44667,
   44668,44670,44672,44904,44906,44908,44931,44933,44980,45262,
   45263,45265,45267,45499,45501,45503,45526,45528,45575,46060,
   46062,46064,46087,46089,46136,49471,49473,49520,49820],
 [4880,4897,5698,5705,5711,6080,6086,6289,18949,18956,18962,
   19331,19337,19540,39499,39505,39708,46593],
 [4880,4897,5699,5705,5712,6112,6119,6290,18950,18956,18963,
   19363,19370,19541,39531,39538,39709,47090],[6152],
 [6183,19434],[6213],[],[],[5705],
 [4880,4897,5695,5705,5706,5978,5979,6284,18946,18956,18957,
   19229,19230,19535,39397,39398,39703,44904],[6340,19591],
 [4880,4882,4883,4887,4888,4897,4898,4902,5690,5691,5695,5696,
   5697,5705,5706,5708,5710,5774,5778,5779,5780,5788,5789,5791,
   5793,5818,5819,5820,5828,5829,5831,5833,5969,5970,5978,5979,
   5981,5983,6005,6013,6014,6016,6018,6047,6048,6050,6052,6284,
   6286,6288,6311,6313,6360,18941,18942,18946,18947,18948,18956,
   18957,18959,18961,19025,19029,19030,19031,19039,19040,19042,
   19044,19069,19070,19071,19079,19080,19082,19084,19220,19221,
   19229,19230,19232,19234,19256,19264,19265,19267,19269,19298,
   19299,19301,19303,19535,19537,19539,19562,19564,19611,39193,
   39197,39198,39199,39207,39208,39210,39212,39237,39238,39239,
   39247,39248,39250,39252,39388,39389,39397,39398,39400,39402,
   39424,39432,39433,39435,39437,39466,39467,39469,39471,39703,
   39705,39707,39730,39732,39779,40918,40919,40920,40928,40929,
   40931,40933,41069,41070,41078,41079,41081,41083,41105,41113,
   41114,41116,41118,41147,41148,41150,41152,41384,41386,41388,
   41411,41413,41460,41849,41850,41858,41859,41861,41863,41885,
   41893,41894,41896,41898,41927,41928,41930,41932,42164,42166,
   42168,42191,42193,42240,44625,44633,44634,44636,44638,44667,
   44668,44670,44672,44904,44906,44908,44931,44933,44980,45262,
   45263,45265,45267,45499,45501,45503,45526,45528,45575,46060,
   46062,46064,46087,46089,46136,49471,49473,49520,49820],[],
 [6018,19269],
 [4880,4897,5698,5705,5711,6080,6086,6289,18949,18956,18962,
   19331,19337,19540,39499,39505,39708,46593],
 [4880,4897,5699,5705,5712,6112,6119,6290,18950,18956,18963,
   19363,19370,19541,39531,39538,39709,47090],[6340,19591],
 [6152],[6183,19434],[6213],[],[],[],[],[],
 [19848],[19857],[19862],[],[],[],[],[19862],
 [19848],[19857],[],[],[],[],[],[],[],[],[],
 [],[],[],[],
 [4938,4955,5645,5646,5662,5689,5705,5747,20549,20550,20566,
   20593,20609,20651,38205,38221,38263,39166],[5705],
 [4938,4955,5645,5646,5662,5689,5705,5747,20549,20550,20566,
   20593,20609,20651,38205,38221,38263,39166],
 [4938,4955,5690,5691,5705,5774,5788,5828,20594,20595,20609,
   20678,20692,20732,39193,39207,39247,40928],
 [4938,4955,5690,5691,5705,5774,5788,5828,20594,20595,20609,
   20678,20692,20732,39193,39207,39247,40928],[],
 [4938,4955,5693,5694,5705,5894,5905,5942,20597,20598,20609,
   20798,20809,20846,39313,39324,39361,43266],
 [4938,4955,5693,5694,5705,5894,5905,5942,20597,20598,20609,
   20798,20809,20846,39313,39324,39361,43266],
 [4938,4955,5695,5705,5706,5978,5979,6284,20599,20609,20610,
   20882,20883,21188,39397,39398,39703,44904],[6018,20922],
 [6050,20954],
 [4938,4955,5698,5705,5711,6080,6086,6289,20602,20609,20615,
   20984,20990,21193,39499,39505,39708,46593],
 [4938,4955,5699,5705,5712,6112,6119,6290,20603,20609,20616,
   21016,21023,21194,39531,39538,39709,47090],[6152],
 [6183,21087],[6213],[],[],[5705],
 [4938,4955,5695,5705,5706,5978,5979,6284,20599,20609,20610,
   20882,20883,21188,39397,39398,39703,44904],[6340,21244],
 [6050,20954],[],[6018,20922],
 [4938,4955,5698,5705,5711,6080,6086,6289,20602,20609,20615,
   20984,20990,21193,39499,39505,39708,46593],
 [4938,4955,5699,5705,5712,6112,6119,6290,20603,20609,20616,
   21016,21023,21194,39531,39538,39709,47090],[6340,21244],
 [6152],[6183,21087],[6213],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],
 [4699,4700,4701,4717,4820,4821,4822,4838,4995,5012,5645,5646,
   5662,5689,5705,5747,12747,12760,12761,12762,12778,12934,
   12935,12936,12952,13585,13586,13602,13629,13645,13687,16534,
   16535,16536,16552,17185,17186,17202,17229,17245,17287,22145,
   22146,22162,22189,22205,22247,38205,38221,38263,39166],
 [5705],
 [4699,4700,4701,4717,4820,4821,4822,4838,4995,5012,5645,5646,
   5662,5689,5705,5747,12747,12760,12761,12762,12778,12934,
   12935,12936,12952,13585,13586,13602,13629,13645,13687,16534,
   16535,16536,16552,17185,17186,17202,17229,17245,17287,22145,
   22146,22162,22189,22205,22247,38205,38221,38263,39166],
 [4575,4577,4578,4592,4880,4882,4883,4897,4995,5012,5690,5691,
   5705,5774,5788,5828,8962,8976,8978,8979,8993,9091,9093,9094,
   9108,9786,9787,9801,9870,9884,9924,18246,18248,18249,18263,
   18941,18942,18956,19025,19039,19079,22190,22191,22205,22274,
   22288,22328,39193,39207,39247,40928],
 [4575,4577,4578,4592,4880,4882,4883,4897,4995,5012,5690,5691,
   5705,5774,5788,5828,8962,8976,8978,8979,8993,9091,9093,9094,
   9108,9786,9787,9801,9870,9884,9924,18246,18248,18249,18263,
   18941,18942,18956,19025,19039,19079,22190,22191,22205,22274,
   22288,22328,39193,39207,39247,40928],[],
 [4995,5012,5693,5694,5705,5894,5905,5942,22193,22194,22205,
   22394,22405,22442,39313,39324,39361,43266],
 [4995,5012,5693,5694,5705,5894,5905,5942,22193,22194,22205,
   22394,22405,22442,39313,39324,39361,43266],
 [4995,5012,5695,5705,5706,5978,5979,6284,22195,22205,22206,
   22478,22479,22784,39397,39398,39703,44904],
 [4995,5004,5012,5015,5696,5697,5705,5708,5710,6005,6013,6016,
   6018,6047,6050,6052,6286,6288,6360,22196,22197,22205,22208,
   22210,22505,22513,22516,22518,22547,22550,22552,22786,22788,
   22860,39424,39432,39435,39437,39466,39469,39471,39705,39707,
   39779,45262,45265,45267,45501,45503,45575,46062,46064,46136,
   49520],[6050,22550],
 [4995,5012,5698,5705,5711,6080,6086,6289,22198,22205,22211,
   22580,22586,22789,39499,39505,39708,46593],
 [4995,5012,5699,5705,5712,6112,6119,6290,22199,22205,22212,
   22612,22619,22790,39531,39538,39709,47090],
 [4995,5012,5700,5705,5714,6143,6152,6292,22200,22205,22214,
   22643,22792,39562,39571,39711,47557],[6183,22683],
 [4995,5012,5702,5705,5716,6202,6213,6294,22202,22205,22216,
   22702,22794,39621,39632,39713,48400],[],[],[5705],
 [4995,5012,5695,5705,5706,5978,5979,6284,22195,22205,22206,
   22478,22479,22784,39397,39398,39703,44904],[6340,22840],
 [6050,22550],[],
 [4995,5004,5012,5015,5696,5697,5705,5708,5710,6005,6013,6016,
   6018,6047,6050,6052,6286,6288,6360,22196,22197,22205,22208,
   22210,22505,22513,22516,22518,22547,22550,22552,22786,22788,
   22860,39424,39432,39435,39437,39466,39469,39471,39705,39707,
   39779,45262,45265,45267,45501,45503,45575,46062,46064,46136,
   49520],
 [4995,5012,5698,5705,5711,6080,6086,6289,22198,22205,22211,
   22580,22586,22789,39499,39505,39708,46593],
 [4995,5012,5699,5705,5712,6112,6119,6290,22199,22205,22212,
   22612,22619,22790,39531,39538,39709,47090],[6340,22840],
 [4995,5012,5700,5705,5714,6143,6152,6292,22200,22205,22214,
   22643,22792,39562,39571,39711,47557],[6183,22683],
 [4995,5012,5702,5705,5716,6202,6213,6294,22202,22205,22216,
   22702,22794,39621,39632,39713,48400],[],[],
 [4995,5012,5705,5719,6297,22205,22219,22797,39716],[],[],
 [],[4995,5012,5705,5723,6301,22205,22223,22801,39720],[],
 [4995,5012,5705,5725,6303,22205,22225,22803,39722],[],[],
 [],[],[],[],[12979],[],[],[],[],[],[],
 [],[],[],[],
 [5051,5068,5645,5646,5662,5689,5705,5747,23685,23686,23702,
   23729,23745,23787,38205,38221,38263,39166],[5705],
 [5051,5068,5645,5646,5662,5689,5705,5747,23685,23686,23702,
   23729,23745,23787,38205,38221,38263,39166],
 [5051,5068,5690,5691,5705,5774,5788,5828,23730,23731,23745,
   23814,23828,23868,39193,39207,39247,40928],
 [5051,5068,5690,5691,5705,5774,5788,5828,23730,23731,23745,
   23814,23828,23868,39193,39207,39247,40928],[],
 [5051,5068,5693,5694,5705,5894,5905,5942,23733,23734,23745,
   23934,23945,23982,39313,39324,39361,43266],
 [5051,5068,5693,5694,5705,5894,5905,5942,23733,23734,23745,
   23934,23945,23982,39313,39324,39361,43266],
 [5051,5068,5695,5705,5706,5978,5979,6284,23735,23745,23746,
   24018,24019,24324,39397,39398,39703,44904],[6018,24058],
 [6050,24090],
 [5051,5068,5698,5705,5711,6080,6086,6289,23738,23745,23751,
   24120,24126,24329,39499,39505,39708,46593],
 [5051,5068,5069,5699,5705,5706,5712,6112,6113,6119,6284,6290,
   6315,23739,23745,23746,23752,24152,24153,24159,24324,24330,
   24355,39531,39532,39538,39703,39709,39734,47084,47090,47115,
   49475],[6152],[6183,24223],[6213],[],[],[5705],
 [5051,5068,5695,5705,5706,5978,5979,6284,23735,23745,23746,
   24018,24019,24324,39397,39398,39703,44904],[6340,24380],
 [6050,24090],[],[6018,24058],
 [5051,5068,5698,5705,5711,6080,6086,6289,23738,23745,23751,
   24120,24126,24329,39499,39505,39708,46593],
 [5051,5068,5069,5699,5705,5706,5712,6112,6113,6119,6284,6290,
   6315,23739,23745,23746,23752,24152,24153,24159,24324,24330,
   24355,39531,39532,39538,39703,39709,39734,47084,47090,47115,
   49475],[6340,24380],[6152],[6183,24223],[6213],[],
 [],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],
 [5106,5123,5645,5646,5662,5689,5705,5747,25170,25171,25187,
   25214,25230,25272,38205,38221,38263,39166],[5705],
 [5106,5123,5645,5646,5662,5689,5705,5747,25170,25171,25187,
   25214,25230,25272,38205,38221,38263,39166],
 [5106,5123,5690,5691,5705,5774,5788,5828,25215,25216,25230,
   25299,25313,25353,39193,39207,39247,40928],
 [5106,5123,5690,5691,5705,5774,5788,5828,25215,25216,25230,
   25299,25313,25353,39193,39207,39247,40928],[],
 [5106,5123,5693,5694,5705,5894,5905,5942,25218,25219,25230,
   25419,25430,25467,39313,39324,39361,43266],
 [5106,5123,5693,5694,5705,5894,5905,5942,25218,25219,25230,
   25419,25430,25467,39313,39324,39361,43266],
 [5106,5123,5695,5705,5706,5978,5979,6284,25220,25230,25231,
   25503,25504,25809,39397,39398,39703,44904],
 [5115,6005,6018,6052,25530,25543,25577,45267],[6050,25575],
 [5106,5123,5698,5705,5711,6080,6086,6289,25223,25230,25236,
   25605,25611,25814,39499,39505,39708,46593],
 [5106,5108,5109,5123,5690,5691,5699,5705,5712,5774,5782,5788,
   5795,5822,5828,5835,6112,6119,6290,25215,25216,25224,25230,
   25237,25299,25307,25313,25320,25347,25353,25360,25637,25644,
   25815,39193,39201,39207,39214,39241,39247,39254,39531,39538,
   39709,40922,40928,40935,41212,41219,41390,41992,41999,42170,
   47090],[6152],[6183,25708],[6213],[],[],[5705],
 [5106,5123,5695,5705,5706,5978,5979,6284,25220,25230,25231,
   25503,25504,25809,39397,39398,39703,44904],[6340,25865],
 [6050,25575],[],[5115,6005,6018,6052,25530,25543,25577,45267 
  ],[5106,5123,5698,5705,5711,6080,6086,6289,25223,25230,
   25236,25605,25611,25814,39499,39505,39708,46593],
 [5106,5108,5109,5123,5690,5691,5699,5705,5712,5774,5782,5788,
   5795,5822,5828,5835,6112,6119,6290,25215,25216,25224,25230,
   25237,25299,25307,25313,25320,25347,25353,25360,25637,25644,
   25815,39193,39201,39207,39214,39241,39247,39254,39531,39538,
   39709,40922,40928,40935,41212,41219,41390,41992,41999,42170,
   47090],[6340,25865],[6152],[6183,25708],[6213],[],
 [],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[26160],[26160],[],[26316],[26316],[],[],
 [26510],[26510],
 [5160,5177,5645,5646,5662,5689,5705,5747,26601,26602,26618,
   26645,26661,26703,38205,38221,38263,39166],[5705],
 [5160,5177,5645,5646,5662,5689,5705,5747,26601,26602,26618,
   26645,26661,26703,38205,38221,38263,39166],
 [5160,5177,5690,5691,5705,5774,5788,5828,26646,26647,26661,
   26730,26744,26784,39193,39207,39247,40928],
 [5160,5177,5690,5691,5705,5774,5788,5828,26646,26647,26661,
   26730,26744,26784,39193,39207,39247,40928],[],
 [5160,5177,5693,5694,5705,5894,5905,5942,26649,26650,26661,
   26850,26861,26898,39313,39324,39361,43266],
 [5160,5177,5693,5694,5705,5894,5905,5942,26649,26650,26661,
   26850,26861,26898,39313,39324,39361,43266],
 [5160,5177,5695,5705,5706,5978,5979,6284,26651,26661,26662,
   26934,26935,27240,39397,39398,39703,44904],[6018,26974],
 [6050,27006],
 [5160,5177,5698,5705,5711,6080,6086,6289,26654,26661,26667,
   27036,27042,27245,39499,39505,39708,46593],
 [5160,5177,5699,5705,5712,6112,6119,6290,26655,26661,26668,
   27068,27075,27246,39531,39538,39709,47090],[6152],
 [6183,27139],[6213],[],[],[5705],
 [5160,5177,5695,5705,5706,5978,5979,6284,26651,26661,26662,
   26934,26935,27240,39397,39398,39703,44904],[6340,27296],
 [6050,27006],[],[6018,26974],
 [5160,5177,5698,5705,5711,6080,6086,6289,26654,26661,26667,
   27036,27042,27245,39499,39505,39708,46593],
 [5160,5177,5699,5705,5712,6112,6119,6290,26655,26661,26668,
   27068,27075,27246,39531,39538,39709,47090],[6340,27296],
 [6152],[6183,27139],[6213],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[26160],[27643],
 [27643],[],[],[27841],[27841],[],
 [5213,5230,5645,5646,5662,5689,5705,5747,27979,27980,27996,
   28023,28039,28081,38205,38221,38263,39166],[5705],
 [5213,5230,5645,5646,5662,5689,5705,5747,27979,27980,27996,
   28023,28039,28081,38205,38221,38263,39166],
 [5213,5230,5690,5691,5705,5774,5788,5828,28024,28025,28039,
   28108,28122,28162,39193,39207,39247,40928],
 [5213,5230,5690,5691,5705,5774,5788,5828,28024,28025,28039,
   28108,28122,28162,39193,39207,39247,40928],[],
 [5213,5230,5693,5694,5705,5894,5905,5942,28027,28028,28039,
   28228,28239,28276,39313,39324,39361,43266],
 [5213,5230,5693,5694,5705,5894,5905,5942,28027,28028,28039,
   28228,28239,28276,39313,39324,39361,43266],
 [5213,5230,5695,5705,5706,5978,5979,6284,28029,28039,28040,
   28312,28313,28618,39397,39398,39703,44904],[6018,28352],
 [6050,28384],
 [5213,5230,5698,5705,5711,6080,6086,6289,28032,28039,28045,
   28414,28420,28623,39499,39505,39708,46593],
 [5213,5230,5699,5705,5712,6112,6119,6290,28033,28039,28046,
   28446,28453,28624,39531,39538,39709,47090],[6152],
 [6183,28517],[6213],[],[],[5705],
 [5213,5230,5695,5705,5706,5978,5979,6284,28029,28039,28040,
   28312,28313,28618,39397,39398,39703,44904],[6340,28674],
 [6050,28384],[],[6018,28352],
 [5213,5230,5698,5705,5711,6080,6086,6289,28032,28039,28045,
   28414,28420,28623,39499,39505,39708,46593],
 [5213,5230,5699,5705,5712,6112,6119,6290,28033,28039,28046,
   28446,28453,28624,39531,39538,39709,47090],[6340,28674],
 [6152],[6183,28517],[6213],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[28970],
 [5150,5151,5152,5153,5154,5204,5205,5206,5207,5257,5259,5309,
   5310,5360,26160,26161,26162,26163,26213,26214,26215,26265,
   26266,26316,27591,27592,27593,27643,27644,27694,28969,28970,
   29020,30295],[28970],[],[29168],[],[29168],
 [5265,5282,5645,5646,5662,5689,5705,5747,29305,29306,29322,
   29349,29365,29407,38205,38221,38263,39166],[5705],
 [5265,5282,5645,5646,5662,5689,5705,5747,29305,29306,29322,
   29349,29365,29407,38205,38221,38263,39166],
 [5265,5282,5690,5691,5705,5774,5788,5828,29350,29351,29365,
   29434,29448,29488,39193,39207,39247,40928],
 [5265,5282,5690,5691,5705,5774,5788,5828,29350,29351,29365,
   29434,29448,29488,39193,39207,39247,40928],[],
 [5265,5282,5693,5694,5705,5894,5905,5942,29353,29354,29365,
   29554,29565,29602,39313,39324,39361,43266],
 [5265,5282,5693,5694,5705,5894,5905,5942,29353,29354,29365,
   29554,29565,29602,39313,39324,39361,43266],
 [5265,5282,5695,5705,5706,5978,5979,6284,29355,29365,29366,
   29638,29639,29944,39397,39398,39703,44904],[6018,29678],
 [5265,5273,5282,5287,5696,5697,5705,5708,5710,6005,6013,6016,
   6018,6047,6050,6052,6286,6288,6360,29356,29357,29365,29368,
   29370,29665,29673,29676,29678,29707,29710,29712,29946,29948,
   30020,39424,39432,39435,39437,39466,39469,39471,39705,39707,
   39779,45262,45265,45267,45501,45503,45575,46062,46064,46136,
   49520],
 [5265,5282,5698,5705,5711,6080,6086,6289,29358,29365,29371,
   29740,29746,29949,39499,39505,39708,46593],
 [5265,5282,5699,5705,5712,6112,6119,6290,29359,29365,29372,
   29772,29779,29950,39531,39538,39709,47090],[6152],
 [6183,29843],[6213],[],[],[5705],
 [5265,5282,5695,5705,5706,5978,5979,6284,29355,29365,29366,
   29638,29639,29944,39397,39398,39703,44904],[6340,30000],
 [5265,5273,5282,5287,5696,5697,5705,5708,5710,6005,6013,6016,
   6018,6047,6050,6052,6286,6288,6360,29356,29357,29365,29368,
   29370,29665,29673,29676,29678,29707,29710,29712,29946,29948,
   30020,39424,39432,39435,39437,39466,39469,39471,39705,39707,
   39779,45262,45265,45267,45501,45503,45575,46062,46064,46136,
   49520],[],[6018,29678],
 [5265,5282,5698,5705,5711,6080,6086,6289,29358,29365,29371,
   29740,29746,29949,39499,39505,39708,46593],
 [5265,5282,5699,5705,5712,6112,6119,6290,29359,29365,29372,
   29772,29779,29950,39531,39538,39709,47090],[6340,30000],
 [6152],[6183,29843],[6213],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[27643],[28970],
 [30394],[30394],[],[],
 [5316,5333,5645,5646,5662,5689,5705,5747,30580,30581,30597,
   30624,30640,30682,38205,38221,38263,39166],[5705],
 [5316,5333,5645,5646,5662,5689,5705,5747,30580,30581,30597,
   30624,30640,30682,38205,38221,38263,39166],
 [5316,5333,5690,5691,5705,5774,5788,5828,30625,30626,30640,
   30709,30723,30763,39193,39207,39247,40928],
 [5316,5333,5690,5691,5705,5774,5788,5828,30625,30626,30640,
   30709,30723,30763,39193,39207,39247,40928],[],
 [5316,5333,5693,5694,5705,5894,5905,5942,30628,30629,30640,
   30829,30840,30877,39313,39324,39361,43266],
 [5316,5333,5693,5694,5705,5894,5905,5942,30628,30629,30640,
   30829,30840,30877,39313,39324,39361,43266],
 [5316,5333,5695,5705,5706,5978,5979,6284,30630,30640,30641,
   30913,30914,31219,39397,39398,39703,44904],[6018,30953],
 [6050,30985],
 [5316,5333,5698,5705,5711,6080,6086,6289,30633,30640,30646,
   31015,31021,31224,39499,39505,39708,46593],
 [5316,5333,5699,5705,5712,6112,6119,6290,30634,30640,30647,
   31047,31054,31225,39531,39538,39709,47090],[6152],
 [6183,31118],[6213],[],[],[5705],
 [5316,5333,5695,5705,5706,5978,5979,6284,30630,30640,30641,
   30913,30914,31219,39397,39398,39703,44904],[6340,31275],
 [6050,30985],[],[6018,30953],
 [5316,5333,5698,5705,5711,6080,6086,6289,30633,30640,30646,
   31015,31021,31224,39499,39505,39708,46593],
 [5316,5333,5699,5705,5712,6112,6119,6290,30634,30640,30647,
   31047,31054,31225,39531,39538,39709,47090],[6340,31275],
 [6152],[6183,31118],[6213],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[26316],[31620],
 [5205,5206,5208,5209,5210,5309,5311,5312,5313,5361,5363,5459,
   5460,5507,27643,27645,27646,27647,27695,27696,27697,27793,
   27794,27841,30296,30297,30298,30394,30395,30442,31619,31620,
   31667,33971],[31620],[],
 [5366,5383,5645,5646,5662,5689,5705,5747,31805,31806,31822,
   31849,31865,31907,38205,38221,38263,39166],[5705],
 [5366,5383,5645,5646,5662,5689,5705,5747,31805,31806,31822,
   31849,31865,31907,38205,38221,38263,39166],
 [5366,5383,5690,5691,5705,5774,5788,5828,31850,31851,31865,
   31934,31948,31988,39193,39207,39247,40928],
 [5366,5383,5690,5691,5705,5774,5788,5828,31850,31851,31865,
   31934,31948,31988,39193,39207,39247,40928],[],
 [5366,5383,5693,5694,5705,5894,5905,5942,31853,31854,31865,
   32054,32065,32102,39313,39324,39361,43266],
 [5366,5383,5693,5694,5705,5894,5905,5942,31853,31854,31865,
   32054,32065,32102,39313,39324,39361,43266],
 [5366,5383,5695,5705,5706,5978,5979,6284,31855,31865,31866,
   32138,32139,32444,39397,39398,39703,44904],[6018,32178],
 [5366,5374,5383,5388,5696,5697,5705,5708,5710,6005,6013,6016,
   6018,6047,6050,6052,6286,6288,6360,31856,31857,31865,31868,
   31870,32165,32173,32176,32178,32207,32210,32212,32446,32448,
   32520,39424,39432,39435,39437,39466,39469,39471,39705,39707,
   39779,45262,45265,45267,45501,45503,45575,46062,46064,46136,
   49520],
 [5366,5383,5698,5705,5711,6080,6086,6289,31858,31865,31871,
   32240,32246,32449,39499,39505,39708,46593],
 [5366,5383,5699,5705,5712,6112,6119,6290,31859,31865,31872,
   32272,32279,32450,39531,39538,39709,47090],[6152],
 [6183,32343],[6213],[],[],[5705],
 [5366,5383,5695,5705,5706,5978,5979,6284,31855,31865,31866,
   32138,32139,32444,39397,39398,39703,44904],[6340,32500],
 [5366,5374,5383,5388,5696,5697,5705,5708,5710,6005,6013,6016,
   6018,6047,6050,6052,6286,6288,6360,31856,31857,31865,31868,
   31870,32165,32173,32176,32178,32207,32210,32212,32446,32448,
   32520,39424,39432,39435,39437,39466,39469,39471,39705,39707,
   39779,45262,45265,45267,45501,45503,45575,46062,46064,46136,
   49520],[],[6018,32178],
 [5366,5383,5698,5705,5711,6080,6086,6289,31858,31865,31871,
   32240,32246,32449,39499,39505,39708,46593],
 [5366,5383,5699,5705,5712,6112,6119,6290,31859,31865,31872,
   32272,32279,32450,39531,39538,39709,47090],[6340,32500],
 [6152],[6183,32343],[6213],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[32797],[],
 [],[32797],
 [5415,5432,5645,5646,5662,5689,5705,5747,32981,32982,32998,
   33025,33041,33083,38205,38221,38263,39166],[5705],
 [5415,5432,5645,5646,5662,5689,5705,5747,32981,32982,32998,
   33025,33041,33083,38205,38221,38263,39166],
 [5415,5432,5690,5691,5705,5774,5788,5828,33026,33027,33041,
   33110,33124,33164,39193,39207,39247,40928],
 [5415,5432,5690,5691,5705,5774,5788,5828,33026,33027,33041,
   33110,33124,33164,39193,39207,39247,40928],[],
 [5415,5432,5693,5694,5705,5894,5905,5942,33029,33030,33041,
   33230,33241,33278,39313,39324,39361,43266],
 [5415,5432,5693,5694,5705,5894,5905,5942,33029,33030,33041,
   33230,33241,33278,39313,39324,39361,43266],
 [5415,5432,5695,5705,5706,5978,5979,6284,33031,33041,33042,
   33314,33315,33620,39397,39398,39703,44904],[6018,33354],
 [6050,33386],
 [5415,5432,5698,5705,5711,6080,6086,6289,33034,33041,33047,
   33416,33422,33625,39499,39505,39708,46593],
 [5415,5432,5699,5705,5712,6112,6119,6290,33035,33041,33048,
   33448,33455,33626,39531,39538,39709,47090],[6152],
 [6183,33519],[6213],[],[],[5705],
 [5415,5432,5695,5705,5706,5978,5979,6284,33031,33041,33042,
   33314,33315,33620,39397,39398,39703,44904],[6340,33676],
 [6050,33386],[],[6018,33354],
 [5415,5432,5698,5705,5711,6080,6086,6289,33034,33041,33047,
   33416,33422,33625,39499,39505,39708,46593],
 [5415,5432,5699,5705,5712,6112,6119,6290,33035,33041,33048,
   33448,33455,33626,39531,39538,39709,47090],[6340,33676],
 [6152],[6183,33519],[6213],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[30394],[31620],
 [32797],[5463,5480,5645,5646,5662,5689,5705,5747,34109,34110,
   34126,34153,34169,34211,38205,38221,38263,39166],[5705],
 [5463,5480,5645,5646,5662,5689,5705,5747,34109,34110,34126,
   34153,34169,34211,38205,38221,38263,39166],
 [5463,5480,5690,5691,5705,5774,5788,5828,34154,34155,34169,
   34238,34252,34292,39193,39207,39247,40928],
 [5463,5480,5690,5691,5705,5774,5788,5828,34154,34155,34169,
   34238,34252,34292,39193,39207,39247,40928],[],
 [5463,5480,5693,5694,5705,5894,5905,5942,34157,34158,34169,
   34358,34369,34406,39313,39324,39361,43266],
 [5463,5480,5693,5694,5705,5894,5905,5942,34157,34158,34169,
   34358,34369,34406,39313,39324,39361,43266],
 [5463,5480,5695,5705,5706,5978,5979,6284,34159,34169,34170,
   34442,34443,34748,39397,39398,39703,44904],[6018,34482],
 [6050,34514],
 [5463,5480,5698,5705,5711,6080,6086,6289,34162,34169,34175,
   34544,34550,34753,39499,39505,39708,46593],
 [5463,5480,5699,5705,5712,6112,6119,6290,34163,34169,34176,
   34576,34583,34754,39531,39538,39709,47090],[6152],
 [6183,34647],[6213],[],[],[5705],
 [5463,5480,5695,5705,5706,5978,5979,6284,34159,34169,34170,
   34442,34443,34748,39397,39398,39703,44904],[6340,34804],
 [6050,34514],[],[6018,34482],
 [5463,5480,5698,5705,5711,6080,6086,6289,34162,34169,34175,
   34544,34550,34753,39499,39505,39708,46593],
 [5463,5480,5699,5705,5712,6112,6119,6290,34163,34169,34176,
   34576,34583,34754,39531,39538,39709,47090],[6340,34804],
 [6152],[6183,34647],[6213],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[27841],[29168],
 [5510,5527,5645,5646,5662,5689,5705,5747,35190,35191,35207,
   35234,35250,35292,38205,38221,38263,39166],[5705],
 [5510,5527,5645,5646,5662,5689,5705,5747,35190,35191,35207,
   35234,35250,35292,38205,38221,38263,39166],
 [5510,5527,5690,5691,5705,5774,5788,5828,35235,35236,35250,
   35319,35333,35373,39193,39207,39247,40928],
 [5510,5527,5690,5691,5705,5774,5788,5828,35235,35236,35250,
   35319,35333,35373,39193,39207,39247,40928],[],
 [5510,5527,5693,5694,5705,5894,5905,5942,35238,35239,35250,
   35439,35450,35487,39313,39324,39361,43266],
 [5510,5527,5693,5694,5705,5894,5905,5942,35238,35239,35250,
   35439,35450,35487,39313,39324,39361,43266],
 [5510,5527,5695,5705,5706,5978,5979,6284,35240,35250,35251,
   35523,35524,35829,39397,39398,39703,44904],[6018,35563],
 [5510,5518,5527,5532,5696,5697,5705,5708,5710,6005,6013,6016,
   6018,6047,6050,6052,6286,6288,6360,35241,35242,35250,35253,
   35255,35550,35558,35561,35563,35592,35595,35597,35831,35833,
   35905,39424,39432,39435,39437,39466,39469,39471,39705,39707,
   39779,45262,45265,45267,45501,45503,45575,46062,46064,46136,
   49520],
 [5510,5527,5698,5705,5711,6080,6086,6289,35243,35250,35256,
   35625,35631,35834,39499,39505,39708,46593],
 [5510,5527,5699,5705,5712,6112,6119,6290,35244,35250,35257,
   35657,35664,35835,39531,39538,39709,47090],[6152],
 [6183,35728],[6213],[],[],[5705],
 [5510,5527,5695,5705,5706,5978,5979,6284,35240,35250,35251,
   35523,35524,35829,39397,39398,39703,44904],[6340,35885],
 [5510,5518,5527,5532,5696,5697,5705,5708,5710,6005,6013,6016,
   6018,6047,6050,6052,6286,6288,6360,35241,35242,35250,35253,
   35255,35550,35558,35561,35563,35592,35595,35597,35831,35833,
   35905,39424,39432,39435,39437,39466,39469,39471,39705,39707,
   39779,45262,45265,45267,45501,45503,45575,46062,46064,46136,
   49520],[],[6018,35563],
 [5510,5527,5698,5705,5711,6080,6086,6289,35243,35250,35256,
   35625,35631,35834,39499,39505,39708,46593],
 [5510,5527,5699,5705,5712,6112,6119,6290,35244,35250,35257,
   35657,35664,35835,39531,39538,39709,47090],[6340,35885],
 [6152],[6183,35728],[6213],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[26510],
 [5556,5573,5645,5646,5662,5689,5705,5747,36225,36226,36242,
   36269,36285,36327,38205,38221,38263,39166],[5705],
 [5556,5573,5645,5646,5662,5689,5705,5747,36225,36226,36242,
   36269,36285,36327,38205,38221,38263,39166],
 [5556,5573,5690,5691,5705,5774,5788,5828,36270,36271,36285,
   36354,36368,36408,39193,39207,39247,40928],
 [5556,5573,5690,5691,5705,5774,5788,5828,36270,36271,36285,
   36354,36368,36408,39193,39207,39247,40928],[],
 [5556,5573,5693,5694,5705,5894,5905,5942,36273,36274,36285,
   36474,36485,36522,39313,39324,39361,43266],
 [5556,5573,5693,5694,5705,5894,5905,5942,36273,36274,36285,
   36474,36485,36522,39313,39324,39361,43266],
 [5556,5573,5695,5705,5706,5978,5979,6284,36275,36285,36286,
   36558,36559,36864,39397,39398,39703,44904],[6018,36598],
 [6050,36630],
 [5556,5573,5698,5705,5711,6080,6086,6289,36278,36285,36291,
   36660,36666,36869,39499,39505,39708,46593],
 [5556,5573,5699,5705,5712,6112,6119,6290,36279,36285,36292,
   36692,36699,36870,39531,39538,39709,47090],[6152],
 [6183,36763],[6213],[],[],[5705],
 [5556,5573,5695,5705,5706,5978,5979,6284,36275,36285,36286,
   36558,36559,36864,39397,39398,39703,44904],[6340,36920],
 [6050,36630],[],[6018,36598],
 [5556,5573,5698,5705,5711,6080,6086,6289,36278,36285,36291,
   36660,36666,36869,39499,39505,39708,46593],
 [5556,5573,5699,5705,5712,6112,6119,6290,36279,36285,36292,
   36692,36699,36870,39531,39538,39709,47090],[6340,36920],
 [6152],[6183,36763],[6213],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],
 [5601,5618,5645,5646,5662,5689,5705,5747,37215,37216,37232,
   37259,37275,37317,38205,38221,38263,39166],[5705],
 [5601,5618,5645,5646,5662,5689,5705,5747,37215,37216,37232,
   37259,37275,37317,38205,38221,38263,39166],
 [5601,5618,5690,5691,5705,5774,5788,5828,37260,37261,37275,
   37344,37358,37398,39193,39207,39247,40928],
 [5601,5618,5690,5691,5705,5774,5788,5828,37260,37261,37275,
   37344,37358,37398,39193,39207,39247,40928],[],
 [5601,5618,5693,5694,5705,5894,5905,5942,37263,37264,37275,
   37464,37475,37512,39313,39324,39361,43266],
 [5601,5618,5693,5694,5705,5894,5905,5942,37263,37264,37275,
   37464,37475,37512,39313,39324,39361,43266],
 [5601,5618,5695,5705,5706,5978,5979,6284,37265,37275,37276,
   37548,37549,37854,39397,39398,39703,44904],[6018,37588],
 [6050,37620],
 [5601,5618,5698,5705,5711,6080,6086,6289,37268,37275,37281,
   37650,37656,37859,39499,39505,39708,46593],
 [5601,5618,5699,5705,5712,6112,6119,6290,37269,37275,37282,
   37682,37689,37860,39531,39538,39709,47090],[6152],
 [6183,37753],[6213],[],[],[5705],
 [5601,5618,5695,5705,5706,5978,5979,6284,37265,37275,37276,
   37548,37549,37854,39397,39398,39703,44904],[6340,37910],
 [6050,37620],[],[6018,37588],
 [5601,5618,5698,5705,5711,6080,6086,6289,37268,37275,37281,
   37650,37656,37859,39499,39505,39708,46593],
 [5601,5618,5699,5705,5712,6112,6119,6290,37269,37275,37282,
   37682,37689,37860,39531,39538,39709,47090],[6340,37910],
 [6152],[6183,37753],[6213],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[5705,38205],
 [5705,38205],
 [90,94,107,1291,1306,1336,1349,1377,1391,1432,1472,1511,5645,
   5646,5662,5689,5690,5691,5692,5705,5747,5774,5788,5828,5867,
   38205,38206,38207,38208,38221,38248,38249,38250,38263,38290,
   38291,38304,38331,38344,38383,39151,39152,39153,39166,39193,
   39194,39207,39234,39247,39286,40054,40055,40068,40095,40108,
   40147,40915,40928,40967,41747],
 [90,94,107,1291,1306,1336,1349,1377,1391,1432,1472,1511,5645,
   5646,5662,5689,5690,5691,5692,5705,5747,5774,5788,5828,5867,
   38205,38206,38207,38208,38221,38248,38249,38250,38263,38290,
   38291,38304,38331,38344,38383,39151,39152,39153,39166,39193,
   39194,39207,39234,39247,39286,40054,40055,40068,40095,40108,
   40147,40915,40928,40967,41747],
 [90,94,107,1291,1306,1336,1349,1377,1391,1432,1472,1511,5645,
   5646,5662,5689,5690,5691,5692,5705,5747,5774,5788,5828,5867,
   38205,38206,38207,38208,38221,38248,38249,38250,38263,38290,
   38291,38304,38331,38344,38383,39151,39152,39153,39166,39193,
   39194,39207,39234,39247,39286,40054,40055,40068,40095,40108,
   40147,40915,40928,40967,41747],
 [5645,5646,5662,5689,5693,5694,5705,5747,5894,5905,5942,38205,
   38209,38210,38221,38251,38252,38263,38410,38421,38458,39154,
   39155,39166,39313,39324,39361,40174,40185,40222,43266],
 [5645,5646,5662,5689,5693,5694,5705,5747,5894,5905,5942,38205,
   38209,38210,38221,38251,38252,38263,38410,38421,38458,39154,
   39155,39166,39313,39324,39361,40174,40185,40222,43266],
 [2279,3500,3501,3507,3517,3518,3544,3550,3592,3833,3834,4139,
   5645,5646,5662,5689,5695,5705,5706,5747,5978,5979,6284,7725,
   7726,7743,7769,7786,7817,7827,7828,8058,8059,8364,38205,
   38211,38221,38222,38253,38263,38264,38494,38495,38800,39156,
   39166,39167,39397,39398,39703,40258,40259,40564,44904],
 [5645,5646,5662,5689,5696,5697,5699,5705,5708,5710,5712,5747,
   6005,6013,6016,6018,6047,6050,6052,6112,6119,6286,6288,6290,
   6360,38205,38212,38213,38215,38221,38224,38226,38228,38254,
   38255,38257,38263,38266,38268,38270,38521,38523,38529,38532,
   38534,38536,38557,38563,38566,38568,38570,38628,38631,38633,
   38635,38802,38804,38806,38876,38878,38921,39157,39158,39160,
   39166,39169,39171,39173,39424,39426,39432,39435,39437,39439,
   39460,39466,39469,39471,39473,39531,39534,39536,39538,39705,
   39707,39709,39779,39781,39824,40285,40287,40293,40296,40298,
   40300,40321,40327,40330,40332,40334,40392,40395,40397,40399,
   40566,40568,40570,40640,40642,40685,45256,45262,45265,45267,
   45269,45327,45330,45332,45334,45501,45503,45505,45575,45577,
   45620,45888,45891,45893,45895,46062,46064,46066,46136,46138,
   46181,47086,47088,47090,47160,47162,47205,49520,49522,49565,
   50394],
 [5645,5646,5662,5689,5696,5697,5699,5705,5708,5710,5712,5747,
   6005,6013,6016,6018,6047,6050,6052,6112,6119,6286,6288,6290,
   6360,38205,38212,38213,38215,38221,38224,38226,38228,38254,
   38255,38257,38263,38266,38268,38270,38521,38523,38529,38532,
   38534,38536,38557,38563,38566,38568,38570,38628,38631,38633,
   38635,38802,38804,38806,38876,38878,38921,39157,39158,39160,
   39166,39169,39171,39173,39424,39426,39432,39435,39437,39439,
   39460,39466,39469,39471,39473,39531,39534,39536,39538,39705,
   39707,39709,39779,39781,39824,40285,40287,40293,40296,40298,
   40300,40321,40327,40330,40332,40334,40392,40395,40397,40399,
   40566,40568,40570,40640,40642,40685,45256,45262,45265,45267,
   45269,45327,45330,45332,45334,45501,45503,45505,45575,45577,
   45620,45888,45891,45893,45895,46062,46064,46066,46136,46138,
   46181,47086,47088,47090,47160,47162,47205,49520,49522,49565,
   50394],
 [5645,5646,5662,5689,5698,5705,5711,5747,6080,6086,6289,38205,
   38214,38221,38227,38256,38263,38269,38596,38602,38805,39159,
   39166,39172,39499,39505,39708,40360,40366,40569,46593],
 [5645,5646,5662,5689,5696,5697,5699,5705,5708,5710,5712,5747,
   6005,6013,6016,6018,6047,6050,6052,6112,6119,6286,6288,6290,
   6360,38205,38212,38213,38215,38221,38224,38226,38228,38254,
   38255,38257,38263,38266,38268,38270,38521,38523,38529,38532,
   38534,38536,38557,38563,38566,38568,38570,38628,38631,38633,
   38635,38802,38804,38806,38876,38878,38921,39157,39158,39160,
   39166,39169,39171,39173,39424,39426,39432,39435,39437,39439,
   39460,39466,39469,39471,39473,39531,39534,39536,39538,39705,
   39707,39709,39779,39781,39824,40285,40287,40293,40296,40298,
   40300,40321,40327,40330,40332,40334,40392,40395,40397,40399,
   40566,40568,40570,40640,40642,40685,45256,45262,45265,45267,
   45269,45327,45330,45332,45334,45501,45503,45505,45575,45577,
   45620,45888,45891,45893,45895,46062,46064,46066,46136,46138,
   46181,47086,47088,47090,47160,47162,47205,49520,49522,49565,
   50394],
 [5645,5646,5662,5689,5700,5705,5714,5747,6143,6152,6292,38205,
   38216,38221,38230,38258,38263,38272,38659,38808,39161,39166,
   39175,39562,39571,39711,40423,40572,47557],
 [5645,5646,5662,5689,5701,5702,5705,5715,5716,5747,6173,6183,
   6202,6213,6293,6294,38205,38217,38218,38221,38231,38232,
   38259,38260,38263,38273,38274,38686,38689,38699,38700,38718,
   38809,38810,39015,39162,39163,39166,39176,39177,39589,39592,
   39602,39603,39621,39631,39632,39712,39713,39918,40450,40453,
   40463,40482,40492,40573,40574,40779,47902,47912,47993,47994,
   48199,48399,48400,49659],
 [5645,5646,5662,5689,5701,5702,5705,5715,5716,5747,6173,6183,
   6202,6213,6293,6294,38205,38217,38218,38221,38231,38232,
   38259,38260,38263,38273,38274,38686,38689,38699,38700,38718,
   38809,38810,39015,39162,39163,39166,39176,39177,39589,39592,
   39602,39603,39621,39631,39632,39712,39713,39918,40450,40453,
   40463,40482,40492,40573,40574,40779,47902,47912,47993,47994,
   48199,48399,48400,49659],
 [5645,5646,5662,5689,5703,5705,5747,6230,38205,38219,38221,
   38261,38263,38746,39164,39166,39649,40510],
 [5645,5646,5662,5689,5704,5705,5747,6257,38205,38220,38221,
   38262,38263,38773,39165,39166,39676,40537],[5705,38205],
 [2279,3500,3501,3507,3517,3518,3544,3550,3592,3833,3834,4139,
   5645,5646,5662,5689,5695,5705,5706,5747,5978,5979,6284,7725,
   7726,7743,7769,7786,7817,7827,7828,8058,8059,8364,38205,
   38211,38221,38222,38253,38263,38264,38494,38495,38800,39156,
   39166,39167,39397,39398,39703,40258,40259,40564,44904],
 [5645,5646,5662,5689,5705,5707,5713,5747,6285,6291,6340,38205,
   38221,38223,38229,38263,38265,38271,38801,38807,38856,39166,
   39168,39174,39704,39710,39759,40565,40571,40620,49500],
 [5645,5646,5662,5689,5696,5697,5699,5705,5708,5710,5712,5747,
   6005,6013,6016,6018,6047,6050,6052,6112,6119,6286,6288,6290,
   6360,38205,38212,38213,38215,38221,38224,38226,38228,38254,
   38255,38257,38263,38266,38268,38270,38521,38523,38529,38532,
   38534,38536,38557,38563,38566,38568,38570,38628,38631,38633,
   38635,38802,38804,38806,38876,38878,38921,39157,39158,39160,
   39166,39169,39171,39173,39424,39426,39432,39435,39437,39439,
   39460,39466,39469,39471,39473,39531,39534,39536,39538,39705,
   39707,39709,39779,39781,39824,40285,40287,40293,40296,40298,
   40300,40321,40327,40330,40332,40334,40392,40395,40397,40399,
   40566,40568,40570,40640,40642,40685,45256,45262,45265,45267,
   45269,45327,45330,45332,45334,45501,45503,45505,45575,45577,
   45620,45888,45891,45893,45895,46062,46064,46066,46136,46138,
   46181,47086,47088,47090,47160,47162,47205,49520,49522,49565,
   50394],
 [5645,5646,5662,5689,5705,5709,5747,6287,38205,38221,38225,
   38263,38267,38803,39166,39170,39706,40567],
 [5645,5646,5662,5689,5696,5697,5699,5705,5708,5710,5712,5747,
   6005,6013,6016,6018,6047,6050,6052,6112,6119,6286,6288,6290,
   6360,38205,38212,38213,38215,38221,38224,38226,38228,38254,
   38255,38257,38263,38266,38268,38270,38521,38523,38529,38532,
   38534,38536,38557,38563,38566,38568,38570,38628,38631,38633,
   38635,38802,38804,38806,38876,38878,38921,39157,39158,39160,
   39166,39169,39171,39173,39424,39426,39432,39435,39437,39439,
   39460,39466,39469,39471,39473,39531,39534,39536,39538,39705,
   39707,39709,39779,39781,39824,40285,40287,40293,40296,40298,
   40300,40321,40327,40330,40332,40334,40392,40395,40397,40399,
   40566,40568,40570,40640,40642,40685,45256,45262,45265,45267,
   45269,45327,45330,45332,45334,45501,45503,45505,45575,45577,
   45620,45888,45891,45893,45895,46062,46064,46066,46136,46138,
   46181,47086,47088,47090,47160,47162,47205,49520,49522,49565,
   50394],
 [5645,5646,5662,5689,5698,5705,5711,5747,6080,6086,6289,38205,
   38214,38221,38227,38256,38263,38269,38596,38602,38805,39159,
   39166,39172,39499,39505,39708,40360,40366,40569,46593],
 [5645,5646,5662,5689,5696,5697,5699,5705,5708,5710,5712,5747,
   6005,6013,6016,6018,6047,6050,6052,6112,6119,6286,6288,6290,
   6360,38205,38212,38213,38215,38221,38224,38226,38228,38254,
   38255,38257,38263,38266,38268,38270,38521,38523,38529,38532,
   38534,38536,38557,38563,38566,38568,38570,38628,38631,38633,
   38635,38802,38804,38806,38876,38878,38921,39157,39158,39160,
   39166,39169,39171,39173,39424,39426,39432,39435,39437,39439,
   39460,39466,39469,39471,39473,39531,39534,39536,39538,39705,
   39707,39709,39779,39781,39824,40285,40287,40293,40296,40298,
   40300,40321,40327,40330,40332,40334,40392,40395,40397,40399,
   40566,40568,40570,40640,40642,40685,45256,45262,45265,45267,
   45269,45327,45330,45332,45334,45501,45503,45505,45575,45577,
   45620,45888,45891,45893,45895,46062,46064,46066,46136,46138,
   46181,47086,47088,47090,47160,47162,47205,49520,49522,49565,
   50394],
 [5645,5646,5662,5689,5705,5707,5713,5747,6285,6291,6340,38205,
   38221,38223,38229,38263,38265,38271,38801,38807,38856,39166,
   39168,39174,39704,39710,39759,40565,40571,40620,49500],
 [5645,5646,5662,5689,5700,5705,5714,5747,6143,6152,6292,38205,
   38216,38221,38230,38258,38263,38272,38659,38808,39161,39166,
   39175,39562,39571,39711,40423,40572,47557],
 [5645,5646,5662,5689,5701,5702,5705,5715,5716,5747,6173,6183,
   6202,6213,6293,6294,38205,38217,38218,38221,38231,38232,
   38259,38260,38263,38273,38274,38686,38689,38699,38700,38718,
   38809,38810,39015,39162,39163,39166,39176,39177,39589,39592,
   39602,39603,39621,39631,39632,39712,39713,39918,40450,40453,
   40463,40482,40492,40573,40574,40779,47902,47912,47993,47994,
   48199,48399,48400,49659],
 [5645,5646,5662,5689,5701,5702,5705,5715,5716,5747,6173,6183,
   6202,6213,6293,6294,38205,38217,38218,38221,38231,38232,
   38259,38260,38263,38273,38274,38686,38689,38699,38700,38718,
   38809,38810,39015,39162,39163,39166,39176,39177,39589,39592,
   39602,39603,39621,39631,39632,39712,39713,39918,40450,40453,
   40463,40482,40492,40573,40574,40779,47902,47912,47993,47994,
   48199,48399,48400,49659],
 [5645,5646,5662,5689,5705,5717,5747,6295,38205,38221,38233,
   38263,38275,38811,39166,39178,39714,40575],
 [5645,5646,5662,5689,5705,5718,5719,5747,6296,6297,38205,38221,
   38234,38235,38263,38276,38277,38812,38813,39060,39166,39179,
   39180,39715,39716,39963,40576,40577,40824,49704],
 [5645,5646,5662,5689,5705,5718,5719,5747,6296,6297,38205,38221,
   38234,38235,38263,38276,38277,38812,38813,39060,39166,39179,
   39180,39715,39716,39963,40576,40577,40824,49704],
 [5645,5646,5662,5689,5705,5720,5747,6298,38205,38221,38236,
   38263,38278,38814,39166,39181,39717,40578],
 [5645,5646,5662,5689,5705,5721,5747,6299,38205,38221,38237,
   38263,38279,38815,39166,39182,39718,40579],
 [5645,5646,5662,5689,5705,5722,5723,5747,6300,6301,38205,38221,
   38238,38239,38263,38280,38281,38816,38817,39106,39166,39183,
   39184,39719,39720,40009,40580,40581,40870,49750],
 [5645,5646,5662,5689,5705,5722,5723,5747,6300,6301,38205,38221,
   38238,38239,38263,38280,38281,38816,38817,39106,39166,39183,
   39184,39719,39720,40009,40580,40581,40870,49750],
 [5645,5646,5662,5689,5705,5724,5747,6302,38205,38221,38240,
   38263,38282,38818,39166,39185,39721,40582],
 [5645,5646,5662,5689,5705,5725,5747,6303,38205,38221,38241,
   38263,38283,38819,39166,39186,39722,40583],
 [5645,5646,5662,5689,5705,5726,5747,6304,38205,38221,38242,
   38263,38284,38820,39166,39187,39723,40584],
 [5645,5646,5662,5689,5705,5727,5747,6305,38205,38221,38243,
   38263,38285,38821,39166,39188,39724,40585],
 [5645,5646,5662,5689,5705,5728,5747,6306,38205,38221,38244,
   38263,38286,38822,39166,39189,39725,40586],
 [5645,5646,5662,5689,5705,5729,5747,6307,38205,38221,38245,
   38263,38287,38823,39166,39190,39726,40587],
 [5645,5646,5662,5689,5705,5730,5731,5747,6308,6309,38205,38221,
   38246,38247,38263,38288,38289,38824,38825,39150,39166,39191,
   39192,39727,39728,40053,40588,40589,40914,49794],
 [5645,5646,5662,5689,5705,5730,5731,5747,6308,6309,38205,38221,
   38246,38247,38263,38288,38289,38824,38825,39150,39166,39191,
   39192,39727,39728,40053,40588,40589,40914,49794],
 [5705,38205],[5705,39193],[5705,39193],[5705],
 [5705,39313],[5705,39313],[5705,44904],
 [5705,6018,6050,39424,39779,45501,46064],
 [5705,6018,6050,39424,39779,45501,46064],[5705,46593],
 [5705,47090],[5705,6152],[5705,6183,39602,47993],
 [5705,6213],[5705],[5705],[],[5705,44904],
 [5705,6340,39759,49500],
 [5705,6018,6050,39424,39779,45501,46064],[5705],
 [5705,6018,6050,39424,39779,45501,46064],[5705,46593],
 [5705,47090],[5705,6340,39759,49500],[5705,6152],
 [5705,6183,39602,47993],[5705,6213],[5705],[5705],[5705],
 [5705],[5705],[5705],[5705],[5705],[5705],[5705],
 [5705],[5705],[5705],[5705],[5705],
 [90,94,107,1291,1306,1336,1349,1377,1391,1432,1472,1511,5645,
   5646,5662,5689,5690,5691,5692,5705,5747,5774,5788,5828,5867,
   38205,38206,38207,38208,38221,38248,38249,38250,38263,38290,
   38291,38304,38331,38344,38383,39151,39152,39153,39166,39193,
   39194,39207,39234,39247,39286,40054,40055,40068,40095,40108,
   40147,40915,40928,40967,41747],
 [90,94,107,1291,1306,1336,1349,1377,1391,1432,1472,1511,5645,
   5646,5662,5689,5690,5691,5692,5705,5747,5774,5788,5828,5867,
   38205,38206,38207,38208,38221,38248,38249,38250,38263,38290,
   38291,38304,38331,38344,38383,39151,39152,39153,39166,39193,
   39194,39207,39234,39247,39286,40054,40055,40068,40095,40108,
   40147,40915,40928,40967,41747],
 [90,94,107,1291,1306,1336,1349,1377,1391,1432,1472,1511,5645,
   5646,5662,5689,5690,5691,5692,5705,5747,5774,5788,5828,5867,
   38205,38206,38207,38208,38221,38248,38249,38250,38263,38290,
   38291,38304,38331,38344,38383,39151,39152,39153,39166,39193,
   39194,39207,39234,39247,39286,40054,40055,40068,40095,40108,
   40147,40915,40928,40967,41747],
 [5645,5646,5662,5689,5693,5694,5705,5747,5894,5905,5942,38205,
   38209,38210,38221,38251,38252,38263,38410,38421,38458,39154,
   39155,39166,39313,39324,39361,40174,40185,40222,43266],
 [5645,5646,5662,5689,5693,5694,5705,5747,5894,5905,5942,38205,
   38209,38210,38221,38251,38252,38263,38410,38421,38458,39154,
   39155,39166,39313,39324,39361,40174,40185,40222,43266],
 [2279,3500,3501,3507,3517,3518,3544,3550,3592,3833,3834,4139,
   5645,5646,5662,5689,5695,5705,5706,5747,5978,5979,6284,7725,
   7726,7743,7769,7786,7817,7827,7828,8058,8059,8364,38205,
   38211,38221,38222,38253,38263,38264,38494,38495,38800,39156,
   39166,39167,39397,39398,39703,40258,40259,40564,44904],
 [5645,5646,5662,5689,5696,5697,5699,5705,5708,5710,5712,5747,
   6005,6013,6016,6018,6047,6050,6052,6112,6119,6286,6288,6290,
   6360,38205,38212,38213,38215,38221,38224,38226,38228,38254,
   38255,38257,38263,38266,38268,38270,38521,38523,38529,38532,
   38534,38536,38557,38563,38566,38568,38570,38628,38631,38633,
   38635,38802,38804,38806,38876,38878,38921,39157,39158,39160,
   39166,39169,39171,39173,39424,39426,39432,39435,39437,39439,
   39460,39466,39469,39471,39473,39531,39534,39536,39538,39705,
   39707,39709,39779,39781,39824,40285,40287,40293,40296,40298,
   40300,40321,40327,40330,40332,40334,40392,40395,40397,40399,
   40566,40568,40570,40640,40642,40685,45256,45262,45265,45267,
   45269,45327,45330,45332,45334,45501,45503,45505,45575,45577,
   45620,45888,45891,45893,45895,46062,46064,46066,46136,46138,
   46181,47086,47088,47090,47160,47162,47205,49520,49522,49565,
   50394],
 [5645,5646,5662,5689,5696,5697,5699,5705,5708,5710,5712,5747,
   6005,6013,6016,6018,6047,6050,6052,6112,6119,6286,6288,6290,
   6360,38205,38212,38213,38215,38221,38224,38226,38228,38254,
   38255,38257,38263,38266,38268,38270,38521,38523,38529,38532,
   38534,38536,38557,38563,38566,38568,38570,38628,38631,38633,
   38635,38802,38804,38806,38876,38878,38921,39157,39158,39160,
   39166,39169,39171,39173,39424,39426,39432,39435,39437,39439,
   39460,39466,39469,39471,39473,39531,39534,39536,39538,39705,
   39707,39709,39779,39781,39824,40285,40287,40293,40296,40298,
   40300,40321,40327,40330,40332,40334,40392,40395,40397,40399,
   40566,40568,40570,40640,40642,40685,45256,45262,45265,45267,
   45269,45327,45330,45332,45334,45501,45503,45505,45575,45577,
   45620,45888,45891,45893,45895,46062,46064,46066,46136,46138,
   46181,47086,47088,47090,47160,47162,47205,49520,49522,49565,
   50394],
 [5645,5646,5662,5689,5698,5705,5711,5747,6080,6086,6289,38205,
   38214,38221,38227,38256,38263,38269,38596,38602,38805,39159,
   39166,39172,39499,39505,39708,40360,40366,40569,46593],
 [5645,5646,5662,5689,5696,5697,5699,5705,5708,5710,5712,5747,
   6005,6013,6016,6018,6047,6050,6052,6112,6119,6286,6288,6290,
   6360,38205,38212,38213,38215,38221,38224,38226,38228,38254,
   38255,38257,38263,38266,38268,38270,38521,38523,38529,38532,
   38534,38536,38557,38563,38566,38568,38570,38628,38631,38633,
   38635,38802,38804,38806,38876,38878,38921,39157,39158,39160,
   39166,39169,39171,39173,39424,39426,39432,39435,39437,39439,
   39460,39466,39469,39471,39473,39531,39534,39536,39538,39705,
   39707,39709,39779,39781,39824,40285,40287,40293,40296,40298,
   40300,40321,40327,40330,40332,40334,40392,40395,40397,40399,
   40566,40568,40570,40640,40642,40685,45256,45262,45265,45267,
   45269,45327,45330,45332,45334,45501,45503,45505,45575,45577,
   45620,45888,45891,45893,45895,46062,46064,46066,46136,46138,
   46181,47086,47088,47090,47160,47162,47205,49520,49522,49565,
   50394],
 [5645,5646,5662,5689,5700,5705,5714,5747,6143,6152,6292,38205,
   38216,38221,38230,38258,38263,38272,38659,38808,39161,39166,
   39175,39562,39571,39711,40423,40572,47557],
 [5645,5646,5662,5689,5701,5702,5705,5715,5716,5747,6173,6183,
   6202,6213,6293,6294,38205,38217,38218,38221,38231,38232,
   38259,38260,38263,38273,38274,38686,38689,38699,38700,38718,
   38809,38810,39015,39162,39163,39166,39176,39177,39589,39592,
   39602,39603,39621,39631,39632,39712,39713,39918,40450,40453,
   40463,40482,40492,40573,40574,40779,47902,47912,47993,47994,
   48199,48399,48400,49659],
 [5645,5646,5662,5689,5701,5702,5705,5715,5716,5747,6173,6183,
   6202,6213,6293,6294,38205,38217,38218,38221,38231,38232,
   38259,38260,38263,38273,38274,38686,38689,38699,38700,38718,
   38809,38810,39015,39162,39163,39166,39176,39177,39589,39592,
   39602,39603,39621,39631,39632,39712,39713,39918,40450,40453,
   40463,40482,40492,40573,40574,40779,47902,47912,47993,47994,
   48199,48399,48400,49659],
 [5645,5646,5662,5689,5703,5705,5747,6230,38205,38219,38221,
   38261,38263,38746,39164,39166,39649,40510],
 [5645,5646,5662,5689,5704,5705,5747,6257,38205,38220,38221,
   38262,38263,38773,39165,39166,39676,40537],[5705,38205],
 [2279,3500,3501,3507,3517,3518,3544,3550,3592,3833,3834,4139,
   5645,5646,5662,5689,5695,5705,5706,5747,5978,5979,6284,7725,
   7726,7743,7769,7786,7817,7827,7828,8058,8059,8364,38205,
   38211,38221,38222,38253,38263,38264,38494,38495,38800,39156,
   39166,39167,39397,39398,39703,40258,40259,40564,44904],
 [5645,5646,5662,5689,5705,5707,5713,5747,6285,6291,6340,38205,
   38221,38223,38229,38263,38265,38271,38801,38807,38856,39166,
   39168,39174,39704,39710,39759,40565,40571,40620,49500],
 [5645,5646,5662,5689,5696,5697,5699,5705,5708,5710,5712,5747,
   6005,6013,6016,6018,6047,6050,6052,6112,6119,6286,6288,6290,
   6360,38205,38212,38213,38215,38221,38224,38226,38228,38254,
   38255,38257,38263,38266,38268,38270,38521,38523,38529,38532,
   38534,38536,38557,38563,38566,38568,38570,38628,38631,38633,
   38635,38802,38804,38806,38876,38878,38921,39157,39158,39160,
   39166,39169,39171,39173,39424,39426,39432,39435,39437,39439,
   39460,39466,39469,39471,39473,39531,39534,39536,39538,39705,
   39707,39709,39779,39781,39824,40285,40287,40293,40296,40298,
   40300,40321,40327,40330,40332,40334,40392,40395,40397,40399,
   40566,40568,40570,40640,40642,40685,45256,45262,45265,45267,
   45269,45327,45330,45332,45334,45501,45503,45505,45575,45577,
   45620,45888,45891,45893,45895,46062,46064,46066,46136,46138,
   46181,47086,47088,47090,47160,47162,47205,49520,49522,49565,
   50394],
 [5645,5646,5662,5689,5705,5709,5747,6287,38205,38221,38225,
   38263,38267,38803,39166,39170,39706,40567],
 [5645,5646,5662,5689,5696,5697,5699,5705,5708,5710,5712,5747,
   6005,6013,6016,6018,6047,6050,6052,6112,6119,6286,6288,6290,
   6360,38205,38212,38213,38215,38221,38224,38226,38228,38254,
   38255,38257,38263,38266,38268,38270,38521,38523,38529,38532,
   38534,38536,38557,38563,38566,38568,38570,38628,38631,38633,
   38635,38802,38804,38806,38876,38878,38921,39157,39158,39160,
   39166,39169,39171,39173,39424,39426,39432,39435,39437,39439,
   39460,39466,39469,39471,39473,39531,39534,39536,39538,39705,
   39707,39709,39779,39781,39824,40285,40287,40293,40296,40298,
   40300,40321,40327,40330,40332,40334,40392,40395,40397,40399,
   40566,40568,40570,40640,40642,40685,45256,45262,45265,45267,
   45269,45327,45330,45332,45334,45501,45503,45505,45575,45577,
   45620,45888,45891,45893,45895,46062,46064,46066,46136,46138,
   46181,47086,47088,47090,47160,47162,47205,49520,49522,49565,
   50394],
 [5645,5646,5662,5689,5698,5705,5711,5747,6080,6086,6289,38205,
   38214,38221,38227,38256,38263,38269,38596,38602,38805,39159,
   39166,39172,39499,39505,39708,40360,40366,40569,46593],
 [5645,5646,5662,5689,5696,5697,5699,5705,5708,5710,5712,5747,
   6005,6013,6016,6018,6047,6050,6052,6112,6119,6286,6288,6290,
   6360,38205,38212,38213,38215,38221,38224,38226,38228,38254,
   38255,38257,38263,38266,38268,38270,38521,38523,38529,38532,
   38534,38536,38557,38563,38566,38568,38570,38628,38631,38633,
   38635,38802,38804,38806,38876,38878,38921,39157,39158,39160,
   39166,39169,39171,39173,39424,39426,39432,39435,39437,39439,
   39460,39466,39469,39471,39473,39531,39534,39536,39538,39705,
   39707,39709,39779,39781,39824,40285,40287,40293,40296,40298,
   40300,40321,40327,40330,40332,40334,40392,40395,40397,40399,
   40566,40568,40570,40640,40642,40685,45256,45262,45265,45267,
   45269,45327,45330,45332,45334,45501,45503,45505,45575,45577,
   45620,45888,45891,45893,45895,46062,46064,46066,46136,46138,
   46181,47086,47088,47090,47160,47162,47205,49520,49522,49565,
   50394],
 [5645,5646,5662,5689,5705,5707,5713,5747,6285,6291,6340,38205,
   38221,38223,38229,38263,38265,38271,38801,38807,38856,39166,
   39168,39174,39704,39710,39759,40565,40571,40620,49500],
 [5645,5646,5662,5689,5700,5705,5714,5747,6143,6152,6292,38205,
   38216,38221,38230,38258,38263,38272,38659,38808,39161,39166,
   39175,39562,39571,39711,40423,40572,47557],
 [5645,5646,5662,5689,5701,5702,5705,5715,5716,5747,6173,6183,
   6202,6213,6293,6294,38205,38217,38218,38221,38231,38232,
   38259,38260,38263,38273,38274,38686,38689,38699,38700,38718,
   38809,38810,39015,39162,39163,39166,39176,39177,39589,39592,
   39602,39603,39621,39631,39632,39712,39713,39918,40450,40453,
   40463,40482,40492,40573,40574,40779,47902,47912,47993,47994,
   48199,48399,48400,49659],
 [5645,5646,5662,5689,5701,5702,5705,5715,5716,5747,6173,6183,
   6202,6213,6293,6294,38205,38217,38218,38221,38231,38232,
   38259,38260,38263,38273,38274,38686,38689,38699,38700,38718,
   38809,38810,39015,39162,39163,39166,39176,39177,39589,39592,
   39602,39603,39621,39631,39632,39712,39713,39918,40450,40453,
   40463,40482,40492,40573,40574,40779,47902,47912,47993,47994,
   48199,48399,48400,49659],
 [5645,5646,5662,5689,5705,5717,5747,6295,38205,38221,38233,
   38263,38275,38811,39166,39178,39714,40575],
 [5645,5646,5662,5689,5705,5718,5719,5747,6296,6297,38205,38221,
   38234,38235,38263,38276,38277,38812,38813,39060,39166,39179,
   39180,39715,39716,39963,40576,40577,40824,49704],
 [5645,5646,5662,5689,5705,5718,5719,5747,6296,6297,38205,38221,
   38234,38235,38263,38276,38277,38812,38813,39060,39166,39179,
   39180,39715,39716,39963,40576,40577,40824,49704],
 [5645,5646,5662,5689,5705,5720,5747,6298,38205,38221,38236,
   38263,38278,38814,39166,39181,39717,40578],
 [5645,5646,5662,5689,5705,5721,5747,6299,38205,38221,38237,
   38263,38279,38815,39166,39182,39718,40579],
 [5645,5646,5662,5689,5705,5722,5723,5747,6300,6301,38205,38221,
   38238,38239,38263,38280,38281,38816,38817,39106,39166,39183,
   39184,39719,39720,40009,40580,40581,40870,49750],
 [5645,5646,5662,5689,5705,5722,5723,5747,6300,6301,38205,38221,
   38238,38239,38263,38280,38281,38816,38817,39106,39166,39183,
   39184,39719,39720,40009,40580,40581,40870,49750],
 [5645,5646,5662,5689,5705,5724,5747,6302,38205,38221,38240,
   38263,38282,38818,39166,39185,39721,40582],
 [5645,5646,5662,5689,5705,5725,5747,6303,38205,38221,38241,
   38263,38283,38819,39166,39186,39722,40583],
 [5645,5646,5662,5689,5705,5726,5747,6304,38205,38221,38242,
   38263,38284,38820,39166,39187,39723,40584],
 [5645,5646,5662,5689,5705,5727,5747,6305,38205,38221,38243,
   38263,38285,38821,39166,39188,39724,40585],
 [5645,5646,5662,5689,5705,5728,5747,6306,38205,38221,38244,
   38263,38286,38822,39166,39189,39725,40586],
 [5645,5646,5662,5689,5705,5729,5747,6307,38205,38221,38245,
   38263,38287,38823,39166,39190,39726,40587],
 [5645,5646,5662,5689,5705,5730,5731,5747,6308,6309,38205,38221,
   38246,38247,38263,38288,38289,38824,38825,39150,39166,39191,
   39192,39727,39728,40053,40588,40589,40914,49794],
 [5645,5646,5662,5689,5705,5730,5731,5747,6308,6309,38205,38221,
   38246,38247,38263,38288,38289,38824,38825,39150,39166,39191,
   39192,39727,39728,40053,40588,40589,40914,49794],
 [5705,39193],
 [90,94,107,1291,1306,1336,1349,1377,1391,1432,1472,1511,5645,
   5646,5662,5689,5690,5691,5692,5705,5747,5774,5788,5828,5867,
   38205,38206,38207,38208,38221,38248,38249,38250,38263,38290,
   38291,38304,38331,38344,38383,39151,39152,39153,39166,39193,
   39194,39207,39234,39247,39286,40054,40055,40068,40095,40108,
   40147,40915,40928,40967,41747],
 [5690,5691,5693,5694,5705,5774,5788,5828,5894,5905,5942,39193,
   39195,39196,39207,39235,39236,39247,39313,39324,39361,40916,
   40917,40928,40994,41005,41042,41774,41785,41822,43266],
 [5690,5691,5693,5694,5705,5774,5788,5828,5894,5905,5942,39193,
   39195,39196,39207,39235,39236,39247,39313,39324,39361,40916,
   40917,40928,40994,41005,41042,41774,41785,41822,43266],
 [5690,5691,5695,5696,5697,5705,5706,5708,5710,5774,5788,5828,
   5978,5979,6005,6013,6016,6018,6047,6050,6052,6284,6286,6288,
   6360,39193,39197,39198,39199,39207,39208,39210,39212,39237,
   39238,39239,39247,39248,39250,39252,39388,39389,39397,39398,
   39400,39402,39424,39432,39433,39435,39437,39466,39467,39469,
   39471,39703,39705,39707,39730,39732,39779,40918,40919,40920,
   40928,40929,40931,40933,41069,41070,41078,41079,41081,41083,
   41105,41113,41114,41116,41118,41147,41148,41150,41152,41384,
   41386,41388,41411,41413,41460,41849,41850,41858,41859,41861,
   41863,41885,41893,41894,41896,41898,41927,41928,41930,41932,
   42164,42166,42168,42191,42193,42240,44625,44633,44634,44636,
   44638,44667,44668,44670,44672,44904,44906,44908,44931,44933,
   44980,45262,45263,45265,45267,45499,45501,45503,45526,45528,
   45575,46060,46062,46064,46087,46089,46136,49471,49473,49520,
   49820],
 [5690,5691,5695,5696,5697,5705,5706,5708,5710,5774,5788,5828,
   5978,5979,6005,6013,6016,6018,6047,6050,6052,6284,6286,6288,
   6360,39193,39197,39198,39199,39207,39208,39210,39212,39237,
   39238,39239,39247,39248,39250,39252,39388,39389,39397,39398,
   39400,39402,39424,39432,39433,39435,39437,39466,39467,39469,
   39471,39703,39705,39707,39730,39732,39779,40918,40919,40920,
   40928,40929,40931,40933,41069,41070,41078,41079,41081,41083,
   41105,41113,41114,41116,41118,41147,41148,41150,41152,41384,
   41386,41388,41411,41413,41460,41849,41850,41858,41859,41861,
   41863,41885,41893,41894,41896,41898,41927,41928,41930,41932,
   42164,42166,42168,42191,42193,42240,44625,44633,44634,44636,
   44638,44667,44668,44670,44672,44904,44906,44908,44931,44933,
   44980,45262,45263,45265,45267,45499,45501,45503,45526,45528,
   45575,46060,46062,46064,46087,46089,46136,49471,49473,49520,
   49820],
 [5690,5691,5695,5696,5697,5705,5706,5708,5710,5774,5788,5828,
   5978,5979,6005,6013,6016,6018,6047,6050,6052,6284,6286,6288,
   6360,39193,39197,39198,39199,39207,39208,39210,39212,39237,
   39238,39239,39247,39248,39250,39252,39388,39389,39397,39398,
   39400,39402,39424,39432,39433,39435,39437,39466,39467,39469,
   39471,39703,39705,39707,39730,39732,39779,40918,40919,40920,
   40928,40929,40931,40933,41069,41070,41078,41079,41081,41083,
   41105,41113,41114,41116,41118,41147,41148,41150,41152,41384,
   41386,41388,41411,41413,41460,41849,41850,41858,41859,41861,
   41863,41885,41893,41894,41896,41898,41927,41928,41930,41932,
   42164,42166,42168,42191,42193,42240,44625,44633,44634,44636,
   44638,44667,44668,44670,44672,44904,44906,44908,44931,44933,
   44980,45262,45263,45265,45267,45499,45501,45503,45526,45528,
   45575,46060,46062,46064,46087,46089,46136,49471,49473,49520,
   49820],
 [5690,5691,5698,5705,5711,5774,5788,5828,6080,6086,6289,39193,
   39200,39207,39213,39240,39247,39253,39499,39505,39708,40921,
   40928,40934,41180,41186,41389,41960,41966,42169,46593],
 [5690,5691,5699,5705,5712,5774,5788,5828,6112,6119,6290,39193,
   39201,39207,39214,39241,39247,39254,39531,39538,39709,40922,
   40928,40935,41212,41219,41390,41992,41999,42170,47090],
 [5690,5691,5700,5701,5705,5714,5715,5774,5788,5828,6143,6152,
   6173,6183,6292,6293,39193,39202,39203,39207,39216,39217,
   39242,39243,39247,39256,39257,39558,39562,39571,39572,39592,
   39601,39602,39711,39712,39901,40923,40924,40928,40937,40938,
   41239,41243,41253,41273,41283,41392,41393,41582,42019,42023,
   42053,42062,42063,42172,42173,42362,47438,47448,47557,47558,
   47992,47993,48182,49642],
 [5690,5691,5700,5701,5705,5714,5715,5774,5788,5828,6143,6152,
   6173,6183,6292,6293,39193,39202,39203,39207,39216,39217,
   39242,39243,39247,39256,39257,39558,39562,39571,39572,39592,
   39601,39602,39711,39712,39901,40923,40924,40928,40937,40938,
   41239,41243,41253,41273,41283,41392,41393,41582,42019,42023,
   42053,42062,42063,42172,42173,42362,47438,47448,47557,47558,
   47992,47993,48182,49642],
 [5690,5691,5702,5705,5716,5774,5788,5828,6202,6213,6294,39193,
   39204,39207,39218,39244,39247,39258,39621,39632,39713,40925,
   40928,40939,41302,41394,42082,42174,48400],
 [5690,5691,5703,5704,5705,5774,5788,5828,6230,6257,39193,39205,
   39206,39207,39245,39246,39247,39648,39649,39676,40926,40927,
   40928,41329,41330,41357,42109,42110,42137,48741],
 [5690,5691,5703,5704,5705,5774,5788,5828,6230,6257,39193,39205,
   39206,39207,39245,39246,39247,39648,39649,39676,40926,40927,
   40928,41329,41330,41357,42109,42110,42137,48741],
 [5705,39193],
 [5690,5691,5695,5696,5697,5705,5706,5708,5710,5774,5788,5828,
   5978,5979,6005,6013,6016,6018,6047,6050,6052,6284,6286,6288,
   6360,39193,39197,39198,39199,39207,39208,39210,39212,39237,
   39238,39239,39247,39248,39250,39252,39388,39389,39397,39398,
   39400,39402,39424,39432,39433,39435,39437,39466,39467,39469,
   39471,39703,39705,39707,39730,39732,39779,40918,40919,40920,
   40928,40929,40931,40933,41069,41070,41078,41079,41081,41083,
   41105,41113,41114,41116,41118,41147,41148,41150,41152,41384,
   41386,41388,41411,41413,41460,41849,41850,41858,41859,41861,
   41863,41885,41893,41894,41896,41898,41927,41928,41930,41932,
   42164,42166,42168,42191,42193,42240,44625,44633,44634,44636,
   44638,44667,44668,44670,44672,44904,44906,44908,44931,44933,
   44980,45262,45263,45265,45267,45499,45501,45503,45526,45528,
   45575,46060,46062,46064,46087,46089,46136,49471,49473,49520,
   49820],
 [5690,5691,5705,5707,5713,5774,5788,5828,6285,6291,6340,39193,
   39207,39209,39215,39247,39249,39255,39704,39710,39759,40928,
   40930,40936,41385,41391,41440,42165,42171,42220,49500],
 [5690,5691,5695,5696,5697,5705,5706,5708,5710,5774,5788,5828,
   5978,5979,6005,6013,6016,6018,6047,6050,6052,6284,6286,6288,
   6360,39193,39197,39198,39199,39207,39208,39210,39212,39237,
   39238,39239,39247,39248,39250,39252,39388,39389,39397,39398,
   39400,39402,39424,39432,39433,39435,39437,39466,39467,39469,
   39471,39703,39705,39707,39730,39732,39779,40918,40919,40920,
   40928,40929,40931,40933,41069,41070,41078,41079,41081,41083,
   41105,41113,41114,41116,41118,41147,41148,41150,41152,41384,
   41386,41388,41411,41413,41460,41849,41850,41858,41859,41861,
   41863,41885,41893,41894,41896,41898,41927,41928,41930,41932,
   42164,42166,42168,42191,42193,42240,44625,44633,44634,44636,
   44638,44667,44668,44670,44672,44904,44906,44908,44931,44933,
   44980,45262,45263,45265,45267,45499,45501,45503,45526,45528,
   45575,46060,46062,46064,46087,46089,46136,49471,49473,49520,
   49820],
 [5690,5691,5705,5709,5774,5788,5828,6287,39193,39207,39211,
   39247,39251,39706,40928,40932,41387,42167],
 [5690,5691,5695,5696,5697,5705,5706,5708,5710,5774,5788,5828,
   5978,5979,6005,6013,6016,6018,6047,6050,6052,6284,6286,6288,
   6360,39193,39197,39198,39199,39207,39208,39210,39212,39237,
   39238,39239,39247,39248,39250,39252,39388,39389,39397,39398,
   39400,39402,39424,39432,39433,39435,39437,39466,39467,39469,
   39471,39703,39705,39707,39730,39732,39779,40918,40919,40920,
   40928,40929,40931,40933,41069,41070,41078,41079,41081,41083,
   41105,41113,41114,41116,41118,41147,41148,41150,41152,41384,
   41386,41388,41411,41413,41460,41849,41850,41858,41859,41861,
   41863,41885,41893,41894,41896,41898,41927,41928,41930,41932,
   42164,42166,42168,42191,42193,42240,44625,44633,44634,44636,
   44638,44667,44668,44670,44672,44904,44906,44908,44931,44933,
   44980,45262,45263,45265,45267,45499,45501,45503,45526,45528,
   45575,46060,46062,46064,46087,46089,46136,49471,49473,49520,
   49820],
 [5690,5691,5698,5705,5711,5774,5788,5828,6080,6086,6289,39193,
   39200,39207,39213,39240,39247,39253,39499,39505,39708,40921,
   40928,40934,41180,41186,41389,41960,41966,42169,46593],
 [5690,5691,5699,5705,5712,5774,5788,5828,6112,6119,6290,39193,
   39201,39207,39214,39241,39247,39254,39531,39538,39709,40922,
   40928,40935,41212,41219,41390,41992,41999,42170,47090],
 [5690,5691,5705,5707,5713,5774,5788,5828,6285,6291,6340,39193,
   39207,39209,39215,39247,39249,39255,39704,39710,39759,40928,
   40930,40936,41385,41391,41440,42165,42171,42220,49500],
 [5690,5691,5700,5701,5705,5714,5715,5774,5788,5828,6143,6152,
   6173,6183,6292,6293,39193,39202,39203,39207,39216,39217,
   39242,39243,39247,39256,39257,39558,39562,39571,39572,39592,
   39601,39602,39711,39712,39901,40923,40924,40928,40937,40938,
   41239,41243,41253,41273,41283,41392,41393,41582,42019,42023,
   42053,42062,42063,42172,42173,42362,47438,47448,47557,47558,
   47992,47993,48182,49642],
 [5690,5691,5700,5701,5705,5714,5715,5774,5788,5828,6143,6152,
   6173,6183,6292,6293,39193,39202,39203,39207,39216,39217,
   39242,39243,39247,39256,39257,39558,39562,39571,39572,39592,
   39601,39602,39711,39712,39901,40923,40924,40928,40937,40938,
   41239,41243,41253,41273,41283,41392,41393,41582,42019,42023,
   42053,42062,42063,42172,42173,42362,47438,47448,47557,47558,
   47992,47993,48182,49642],
 [5690,5691,5702,5705,5716,5774,5788,5828,6202,6213,6294,39193,
   39204,39207,39218,39244,39247,39258,39621,39632,39713,40925,
   40928,40939,41302,41394,42082,42174,48400],
 [5690,5691,5705,5717,5774,5788,5828,6295,39193,39207,39219,
   39247,39259,39714,40928,40940,41395,42175],
 [5690,5691,5705,5718,5774,5788,5828,6296,39193,39207,39220,
   39247,39260,39715,40928,40941,41396,42176],
 [5690,5691,5705,5719,5774,5788,5828,6297,39193,39207,39221,
   39247,39261,39716,40928,40942,41397,42177],
 [5690,5691,5705,5720,5721,5774,5788,5828,6298,6299,39193,39207,
   39222,39223,39247,39262,39263,39717,39718,39988,40928,40943,
   40944,41398,41399,41669,42178,42179,42449,49729],
 [5690,5691,5705,5720,5721,5774,5788,5828,6298,6299,39193,39207,
   39222,39223,39247,39262,39263,39717,39718,39988,40928,40943,
   40944,41398,41399,41669,42178,42179,42449,49729],
 [5690,5691,5705,5722,5774,5788,5828,6300,39193,39207,39224,
   39247,39264,39719,40928,40945,41400,42180],
 [5690,5691,5705,5723,5774,5788,5828,6301,39193,39207,39225,
   39247,39265,39720,40928,40946,41401,42181],
 [5690,5691,5705,5724,5774,5788,5828,6302,39193,39207,39226,
   39247,39266,39721,40928,40947,41402,42182],
 [5690,5691,5705,5725,5726,5774,5788,5828,6303,6304,39193,39207,
   39227,39228,39247,39267,39268,39722,39723,40033,40928,40948,
   40949,41403,41404,41714,42183,42184,42494,49774],
 [5690,5691,5705,5725,5726,5774,5788,5828,6303,6304,39193,39207,
   39227,39228,39247,39267,39268,39722,39723,40033,40928,40948,
   40949,41403,41404,41714,42183,42184,42494,49774],
 [5690,5691,5705,5727,5774,5788,5828,6305,39193,39207,39229,
   39247,39269,39724,40928,40950,41405,42185],
 [5690,5691,5705,5728,5774,5788,5828,6306,39193,39207,39230,
   39247,39270,39725,40928,40951,41406,42186],
 [5690,5691,5705,5729,5774,5788,5828,6307,39193,39207,39231,
   39247,39271,39726,40928,40952,41407,42187],
 [5690,5691,5705,5730,5774,5788,5828,6308,39193,39207,39232,
   39247,39272,39727,40928,40953,41408,42188],
 [5690,5691,5705,5731,5774,5788,5828,6309,39193,39207,39233,
   39247,39273,39728,40928,40954,41409,42189],
 [90,94,107,1291,1306,1336,1349,1377,1391,1432,1472,1511,5645,
   5646,5662,5689,5690,5691,5692,5705,5747,5774,5788,5828,5867,
   38205,38206,38207,38208,38221,38248,38249,38250,38263,38290,
   38291,38304,38331,38344,38383,39151,39152,39153,39166,39193,
   39194,39207,39234,39247,39286,40054,40055,40068,40095,40108,
   40147,40915,40928,40967,41747],
 [5690,5691,5693,5694,5705,5774,5788,5828,5894,5905,5942,39193,
   39195,39196,39207,39235,39236,39247,39313,39324,39361,40916,
   40917,40928,40994,41005,41042,41774,41785,41822,43266],
 [5690,5691,5693,5694,5705,5774,5788,5828,5894,5905,5942,39193,
   39195,39196,39207,39235,39236,39247,39313,39324,39361,40916,
   40917,40928,40994,41005,41042,41774,41785,41822,43266],
 [5690,5691,5695,5696,5697,5705,5706,5708,5710,5774,5788,5828,
   5978,5979,6005,6013,6016,6018,6047,6050,6052,6284,6286,6288,
   6360,39193,39197,39198,39199,39207,39208,39210,39212,39237,
   39238,39239,39247,39248,39250,39252,39388,39389,39397,39398,
   39400,39402,39424,39432,39433,39435,39437,39466,39467,39469,
   39471,39703,39705,39707,39730,39732,39779,40918,40919,40920,
   40928,40929,40931,40933,41069,41070,41078,41079,41081,41083,
   41105,41113,41114,41116,41118,41147,41148,41150,41152,41384,
   41386,41388,41411,41413,41460,41849,41850,41858,41859,41861,
   41863,41885,41893,41894,41896,41898,41927,41928,41930,41932,
   42164,42166,42168,42191,42193,42240,44625,44633,44634,44636,
   44638,44667,44668,44670,44672,44904,44906,44908,44931,44933,
   44980,45262,45263,45265,45267,45499,45501,45503,45526,45528,
   45575,46060,46062,46064,46087,46089,46136,49471,49473,49520,
   49820],
 [5690,5691,5695,5696,5697,5705,5706,5708,5710,5774,5788,5828,
   5978,5979,6005,6013,6016,6018,6047,6050,6052,6284,6286,6288,
   6360,39193,39197,39198,39199,39207,39208,39210,39212,39237,
   39238,39239,39247,39248,39250,39252,39388,39389,39397,39398,
   39400,39402,39424,39432,39433,39435,39437,39466,39467,39469,
   39471,39703,39705,39707,39730,39732,39779,40918,40919,40920,
   40928,40929,40931,40933,41069,41070,41078,41079,41081,41083,
   41105,41113,41114,41116,41118,41147,41148,41150,41152,41384,
   41386,41388,41411,41413,41460,41849,41850,41858,41859,41861,
   41863,41885,41893,41894,41896,41898,41927,41928,41930,41932,
   42164,42166,42168,42191,42193,42240,44625,44633,44634,44636,
   44638,44667,44668,44670,44672,44904,44906,44908,44931,44933,
   44980,45262,45263,45265,45267,45499,45501,45503,45526,45528,
   45575,46060,46062,46064,46087,46089,46136,49471,49473,49520,
   49820],
 [5690,5691,5695,5696,5697,5705,5706,5708,5710,5774,5788,5828,
   5978,5979,6005,6013,6016,6018,6047,6050,6052,6284,6286,6288,
   6360,39193,39197,39198,39199,39207,39208,39210,39212,39237,
   39238,39239,39247,39248,39250,39252,39388,39389,39397,39398,
   39400,39402,39424,39432,39433,39435,39437,39466,39467,39469,
   39471,39703,39705,39707,39730,39732,39779,40918,40919,40920,
   40928,40929,40931,40933,41069,41070,41078,41079,41081,41083,
   41105,41113,41114,41116,41118,41147,41148,41150,41152,41384,
   41386,41388,41411,41413,41460,41849,41850,41858,41859,41861,
   41863,41885,41893,41894,41896,41898,41927,41928,41930,41932,
   42164,42166,42168,42191,42193,42240,44625,44633,44634,44636,
   44638,44667,44668,44670,44672,44904,44906,44908,44931,44933,
   44980,45262,45263,45265,45267,45499,45501,45503,45526,45528,
   45575,46060,46062,46064,46087,46089,46136,49471,49473,49520,
   49820],
 [5690,5691,5698,5705,5711,5774,5788,5828,6080,6086,6289,39193,
   39200,39207,39213,39240,39247,39253,39499,39505,39708,40921,
   40928,40934,41180,41186,41389,41960,41966,42169,46593],
 [5690,5691,5699,5705,5712,5774,5788,5828,6112,6119,6290,39193,
   39201,39207,39214,39241,39247,39254,39531,39538,39709,40922,
   40928,40935,41212,41219,41390,41992,41999,42170,47090],
 [5690,5691,5700,5701,5705,5714,5715,5774,5788,5828,6143,6152,
   6173,6183,6292,6293,39193,39202,39203,39207,39216,39217,
   39242,39243,39247,39256,39257,39558,39562,39571,39572,39592,
   39601,39602,39711,39712,39901,40923,40924,40928,40937,40938,
   41239,41243,41253,41273,41283,41392,41393,41582,42019,42023,
   42053,42062,42063,42172,42173,42362,47438,47448,47557,47558,
   47992,47993,48182,49642],
 [5690,5691,5700,5701,5705,5714,5715,5774,5788,5828,6143,6152,
   6173,6183,6292,6293,39193,39202,39203,39207,39216,39217,
   39242,39243,39247,39256,39257,39558,39562,39571,39572,39592,
   39601,39602,39711,39712,39901,40923,40924,40928,40937,40938,
   41239,41243,41253,41273,41283,41392,41393,41582,42019,42023,
   42053,42062,42063,42172,42173,42362,47438,47448,47557,47558,
   47992,47993,48182,49642],
 [5690,5691,5702,5705,5716,5774,5788,5828,6202,6213,6294,39193,
   39204,39207,39218,39244,39247,39258,39621,39632,39713,40925,
   40928,40939,41302,41394,42082,42174,48400],
 [5690,5691,5703,5704,5705,5774,5788,5828,6230,6257,39193,39205,
   39206,39207,39245,39246,39247,39648,39649,39676,40926,40927,
   40928,41329,41330,41357,42109,42110,42137,48741],
 [5690,5691,5703,5704,5705,5774,5788,5828,6230,6257,39193,39205,
   39206,39207,39245,39246,39247,39648,39649,39676,40926,40927,
   40928,41329,41330,41357,42109,42110,42137,48741],
 [5705,39193],
 [5690,5691,5695,5696,5697,5705,5706,5708,5710,5774,5788,5828,
   5978,5979,6005,6013,6016,6018,6047,6050,6052,6284,6286,6288,
   6360,39193,39197,39198,39199,39207,39208,39210,39212,39237,
   39238,39239,39247,39248,39250,39252,39388,39389,39397,39398,
   39400,39402,39424,39432,39433,39435,39437,39466,39467,39469,
   39471,39703,39705,39707,39730,39732,39779,40918,40919,40920,
   40928,40929,40931,40933,41069,41070,41078,41079,41081,41083,
   41105,41113,41114,41116,41118,41147,41148,41150,41152,41384,
   41386,41388,41411,41413,41460,41849,41850,41858,41859,41861,
   41863,41885,41893,41894,41896,41898,41927,41928,41930,41932,
   42164,42166,42168,42191,42193,42240,44625,44633,44634,44636,
   44638,44667,44668,44670,44672,44904,44906,44908,44931,44933,
   44980,45262,45263,45265,45267,45499,45501,45503,45526,45528,
   45575,46060,46062,46064,46087,46089,46136,49471,49473,49520,
   49820],
 [5690,5691,5705,5707,5713,5774,5788,5828,6285,6291,6340,39193,
   39207,39209,39215,39247,39249,39255,39704,39710,39759,40928,
   40930,40936,41385,41391,41440,42165,42171,42220,49500],
 [5690,5691,5695,5696,5697,5705,5706,5708,5710,5774,5788,5828,
   5978,5979,6005,6013,6016,6018,6047,6050,6052,6284,6286,6288,
   6360,39193,39197,39198,39199,39207,39208,39210,39212,39237,
   39238,39239,39247,39248,39250,39252,39388,39389,39397,39398,
   39400,39402,39424,39432,39433,39435,39437,39466,39467,39469,
   39471,39703,39705,39707,39730,39732,39779,40918,40919,40920,
   40928,40929,40931,40933,41069,41070,41078,41079,41081,41083,
   41105,41113,41114,41116,41118,41147,41148,41150,41152,41384,
   41386,41388,41411,41413,41460,41849,41850,41858,41859,41861,
   41863,41885,41893,41894,41896,41898,41927,41928,41930,41932,
   42164,42166,42168,42191,42193,42240,44625,44633,44634,44636,
   44638,44667,44668,44670,44672,44904,44906,44908,44931,44933,
   44980,45262,45263,45265,45267,45499,45501,45503,45526,45528,
   45575,46060,46062,46064,46087,46089,46136,49471,49473,49520,
   49820],
 [5690,5691,5705,5709,5774,5788,5828,6287,39193,39207,39211,
   39247,39251,39706,40928,40932,41387,42167],
 [5690,5691,5695,5696,5697,5705,5706,5708,5710,5774,5788,5828,
   5978,5979,6005,6013,6016,6018,6047,6050,6052,6284,6286,6288,
   6360,39193,39197,39198,39199,39207,39208,39210,39212,39237,
   39238,39239,39247,39248,39250,39252,39388,39389,39397,39398,
   39400,39402,39424,39432,39433,39435,39437,39466,39467,39469,
   39471,39703,39705,39707,39730,39732,39779,40918,40919,40920,
   40928,40929,40931,40933,41069,41070,41078,41079,41081,41083,
   41105,41113,41114,41116,41118,41147,41148,41150,41152,41384,
   41386,41388,41411,41413,41460,41849,41850,41858,41859,41861,
   41863,41885,41893,41894,41896,41898,41927,41928,41930,41932,
   42164,42166,42168,42191,42193,42240,44625,44633,44634,44636,
   44638,44667,44668,44670,44672,44904,44906,44908,44931,44933,
   44980,45262,45263,45265,45267,45499,45501,45503,45526,45528,
   45575,46060,46062,46064,46087,46089,46136,49471,49473,49520,
   49820],
 [5690,5691,5698,5705,5711,5774,5788,5828,6080,6086,6289,39193,
   39200,39207,39213,39240,39247,39253,39499,39505,39708,40921,
   40928,40934,41180,41186,41389,41960,41966,42169,46593],
 [5690,5691,5699,5705,5712,5774,5788,5828,6112,6119,6290,39193,
   39201,39207,39214,39241,39247,39254,39531,39538,39709,40922,
   40928,40935,41212,41219,41390,41992,41999,42170,47090],
 [5690,5691,5705,5707,5713,5774,5788,5828,6285,6291,6340,39193,
   39207,39209,39215,39247,39249,39255,39704,39710,39759,40928,
   40930,40936,41385,41391,41440,42165,42171,42220,49500],
 [5690,5691,5700,5701,5705,5714,5715,5774,5788,5828,6143,6152,
   6173,6183,6292,6293,39193,39202,39203,39207,39216,39217,
   39242,39243,39247,39256,39257,39558,39562,39571,39572,39592,
   39601,39602,39711,39712,39901,40923,40924,40928,40937,40938,
   41239,41243,41253,41273,41283,41392,41393,41582,42019,42023,
   42053,42062,42063,42172,42173,42362,47438,47448,47557,47558,
   47992,47993,48182,49642],
 [5690,5691,5700,5701,5705,5714,5715,5774,5788,5828,6143,6152,
   6173,6183,6292,6293,39193,39202,39203,39207,39216,39217,
   39242,39243,39247,39256,39257,39558,39562,39571,39572,39592,
   39601,39602,39711,39712,39901,40923,40924,40928,40937,40938,
   41239,41243,41253,41273,41283,41392,41393,41582,42019,42023,
   42053,42062,42063,42172,42173,42362,47438,47448,47557,47558,
   47992,47993,48182,49642],
 [5690,5691,5702,5705,5716,5774,5788,5828,6202,6213,6294,39193,
   39204,39207,39218,39244,39247,39258,39621,39632,39713,40925,
   40928,40939,41302,41394,42082,42174,48400],
 [5690,5691,5705,5717,5774,5788,5828,6295,39193,39207,39219,
   39247,39259,39714,40928,40940,41395,42175],
 [5690,5691,5705,5718,5774,5788,5828,6296,39193,39207,39220,
   39247,39260,39715,40928,40941,41396,42176],
 [5690,5691,5705,5719,5774,5788,5828,6297,39193,39207,39221,
   39247,39261,39716,40928,40942,41397,42177],
 [5690,5691,5705,5720,5721,5774,5788,5828,6298,6299,39193,39207,
   39222,39223,39247,39262,39263,39717,39718,39988,40928,40943,
   40944,41398,41399,41669,42178,42179,42449,49729],
 [5690,5691,5705,5720,5721,5774,5788,5828,6298,6299,39193,39207,
   39222,39223,39247,39262,39263,39717,39718,39988,40928,40943,
   40944,41398,41399,41669,42178,42179,42449,49729],
 [5690,5691,5705,5722,5774,5788,5828,6300,39193,39207,39224,
   39247,39264,39719,40928,40945,41400,42180],
 [5690,5691,5705,5723,5774,5788,5828,6301,39193,39207,39225,
   39247,39265,39720,40928,40946,41401,42181],
 [5690,5691,5705,5724,5774,5788,5828,6302,39193,39207,39226,
   39247,39266,39721,40928,40947,41402,42182],
 [5690,5691,5705,5725,5726,5774,5788,5828,6303,6304,39193,39207,
   39227,39228,39247,39267,39268,39722,39723,40033,40928,40948,
   40949,41403,41404,41714,42183,42184,42494,49774],
 [5690,5691,5705,5725,5726,5774,5788,5828,6303,6304,39193,39207,
   39227,39228,39247,39267,39268,39722,39723,40033,40928,40948,
   40949,41403,41404,41714,42183,42184,42494,49774],
 [5690,5691,5705,5727,5774,5788,5828,6305,39193,39207,39229,
   39247,39269,39724,40928,40950,41405,42185],
 [5690,5691,5705,5728,5774,5788,5828,6306,39193,39207,39230,
   39247,39270,39725,40928,40951,41406,42186],
 [5690,5691,5705,5729,5774,5788,5828,6307,39193,39207,39231,
   39247,39271,39726,40928,40952,41407,42187],
 [5690,5691,5705,5730,5774,5788,5828,6308,39193,39207,39232,
   39247,39272,39727,40928,40953,41408,42188],
 [5690,5691,5705,5731,5774,5788,5828,6309,39193,39207,39233,
   39247,39273,39728,40928,40954,41409,42189],
 [5692,5693,5694,5705,5867,5894,5905,5942,39274,39275,39286,
   39313,39324,39361,42515,42526,42563,43266],
 [5692,5693,5694,5705,5867,5894,5905,5942,39274,39275,39286,
   39313,39324,39361,42515,42526,42563,43266],
 [5692,5695,5699,5705,5706,5712,5867,5978,5979,6112,6119,6284,
   6290,39276,39280,39286,39287,39293,39391,39397,39398,39404,
   39531,39532,39538,39703,39709,39734,42593,42599,42600,42606,
   42733,42734,42740,42905,42911,42936,44732,44733,44739,44904,
   44910,44935,47084,47090,47115,49475],[6018,42639],
 [6050,42671],
 [5692,5698,5705,5711,5867,6080,6086,6289,39279,39286,39292,
   39499,39505,39708,42701,42707,42910,46593],
 [5692,5695,5699,5705,5706,5712,5867,5978,5979,6112,6119,6284,
   6290,39276,39280,39286,39287,39293,39391,39397,39398,39404,
   39531,39532,39538,39703,39709,39734,42593,42599,42600,42606,
   42733,42734,42740,42905,42911,42936,44732,44733,44739,44904,
   44910,44935,47084,47090,47115,49475],
 [6152,6213,42761,43104],[6183,42804],[6152,6213,42761,43104],
 [],[],[5705],
 [5692,5695,5699,5705,5706,5712,5867,5978,5979,6112,6119,6284,
   6290,39276,39280,39286,39287,39293,39391,39397,39398,39404,
   39531,39532,39538,39703,39709,39734,42593,42599,42600,42606,
   42733,42734,42740,42905,42911,42936,44732,44733,44739,44904,
   44910,44935,47084,47090,47115,49475],[6340,42961],
 [6050,42671],[],[6018,42639],
 [5692,5698,5705,5711,5867,6080,6086,6289,39279,39286,39292,
   39499,39505,39708,42701,42707,42910,46593],
 [5692,5695,5699,5705,5706,5712,5867,5978,5979,6112,6119,6284,
   6290,39276,39280,39286,39287,39293,39391,39397,39398,39404,
   39531,39532,39538,39703,39709,39734,42593,42599,42600,42606,
   42733,42734,42740,42905,42911,42936,44732,44733,44739,44904,
   44910,44935,47084,47090,47115,49475],[6340,42961],
 [6152,6213,42761,43104],[6183,42804],[6152,6213,42761,43104],
 [],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[5705,39313],
 [5693,5694,5695,5705,5706,5894,5905,5942,5978,5979,6284,39313,
   39314,39324,39325,39351,39361,39362,39397,39398,39703,43256,
   43266,43267,43302,43303,43608,43968,43969,44274,44904],
 [5693,5694,5696,5697,5698,5705,5708,5710,5711,5894,5905,5942,
   6005,6013,6016,6018,6047,6050,6052,6080,6086,6286,6288,6289,
   6360,39313,39315,39316,39317,39324,39327,39329,39330,39352,
   39353,39354,39361,39364,39366,39367,39424,39425,39432,39435,
   39437,39438,39459,39466,39469,39471,39472,39499,39502,39504,
   39505,39705,39707,39708,39779,39780,39823,43257,43258,43259,
   43266,43269,43271,43272,43329,43330,43337,43340,43342,43343,
   43364,43371,43374,43376,43377,43404,43407,43409,43410,43610,
   43612,43613,43684,43685,43728,43995,43996,44003,44006,44008,
   44009,44030,44037,44040,44042,44043,44070,44073,44075,44076,
   44276,44278,44279,44350,44351,44394,45255,45262,45265,45267,
   45268,45295,45298,45300,45301,45501,45503,45504,45575,45576,
   45619,45856,45859,45861,45862,46062,46064,46065,46136,46137,
   46180,46590,46592,46593,46664,46665,46708,49520,49521,49564,
   50393],
 [5693,5694,5696,5697,5698,5705,5708,5710,5711,5894,5905,5942,
   6005,6013,6016,6018,6047,6050,6052,6080,6086,6286,6288,6289,
   6360,39313,39315,39316,39317,39324,39327,39329,39330,39352,
   39353,39354,39361,39364,39366,39367,39424,39425,39432,39435,
   39437,39438,39459,39466,39469,39471,39472,39499,39502,39504,
   39505,39705,39707,39708,39779,39780,39823,43257,43258,43259,
   43266,43269,43271,43272,43329,43330,43337,43340,43342,43343,
   43364,43371,43374,43376,43377,43404,43407,43409,43410,43610,
   43612,43613,43684,43685,43728,43995,43996,44003,44006,44008,
   44009,44030,44037,44040,44042,44043,44070,44073,44075,44076,
   44276,44278,44279,44350,44351,44394,45255,45262,45265,45267,
   45268,45295,45298,45300,45301,45501,45503,45504,45575,45576,
   45619,45856,45859,45861,45862,46062,46064,46065,46136,46137,
   46180,46590,46592,46593,46664,46665,46708,49520,49521,49564,
   50393],
 [5693,5694,5696,5697,5698,5705,5708,5710,5711,5894,5905,5942,
   6005,6013,6016,6018,6047,6050,6052,6080,6086,6286,6288,6289,
   6360,39313,39315,39316,39317,39324,39327,39329,39330,39352,
   39353,39354,39361,39364,39366,39367,39424,39425,39432,39435,
   39437,39438,39459,39466,39469,39471,39472,39499,39502,39504,
   39505,39705,39707,39708,39779,39780,39823,43257,43258,43259,
   43266,43269,43271,43272,43329,43330,43337,43340,43342,43343,
   43364,43371,43374,43376,43377,43404,43407,43409,43410,43610,
   43612,43613,43684,43685,43728,43995,43996,44003,44006,44008,
   44009,44030,44037,44040,44042,44043,44070,44073,44075,44076,
   44276,44278,44279,44350,44351,44394,45255,45262,45265,45267,
   45268,45295,45298,45300,45301,45501,45503,45504,45575,45576,
   45619,45856,45859,45861,45862,46062,46064,46065,46136,46137,
   46180,46590,46592,46593,46664,46665,46708,49520,49521,49564,
   50393],
 [5693,5694,5699,5705,5712,5894,5905,5942,6112,6119,6290,39313,
   39318,39324,39331,39355,39361,39368,39531,39538,39709,43260,
   43266,43273,43436,43443,43614,44102,44109,44280,47090],
 [5693,5694,5700,5705,5714,5894,5905,5942,6143,6152,6292,39313,
   39319,39324,39333,39356,39361,39370,39562,39571,39711,43261,
   43266,43275,43467,43616,44133,44282,47557],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,
   2384,3500,3501,3505,3506,3507,3513,3514,3517,3518,3527,3528,
   3544,3548,3549,3550,3556,3557,3560,3561,3570,3571,3590,3591,
   3592,3598,3599,3602,3603,3612,3613,3749,3750,3756,3757,3760,
   3761,3770,3771,3787,3793,3794,3797,3798,3829,3830,3833,3834,
   3843,3844,4025,4028,4029,4038,4039,4057,4058,4139,4148,4149,
   4173,4174,4354,4510,4511,4512,4518,4528,4529,5645,5646,5650,
   5651,5652,5658,5659,5662,5663,5672,5673,5689,5693,5694,5695,
   5701,5702,5705,5706,5715,5716,5735,5736,5737,5743,5744,5747,
   5748,5757,5758,5894,5895,5902,5905,5906,5916,5932,5939,5942,
   5943,5953,5974,5975,5978,5979,5988,5989,6170,6173,6174,6183,
   6184,6202,6203,6212,6213,6284,6293,6294,6318,6319,6499,7725,
   7726,7730,7731,7732,7738,7739,7742,7743,7752,7753,7769,7773,
   7774,7775,7781,7782,7785,7786,7795,7796,7815,7816,7817,7823,
   7824,7827,7828,7837,7838,7974,7975,7985,7986,7995,7996,8012,
   8018,8019,8022,8023,8032,8033,8054,8055,8058,8059,8068,8069,
   8250,8253,8254,8263,8282,8283,8292,8364,8373,8374,8398,8399,
   8579,38205,38209,38210,38211,38217,38218,38221,38222,38231,
   38232,38251,38252,38253,38259,38260,38263,38264,38273,38274,
   38410,38411,38417,38418,38421,38422,38431,38432,38448,38454,
   38455,38458,38459,38468,38469,38490,38491,38494,38495,38504,
   38505,38686,38689,38690,38699,38700,38718,38719,38728,38729,
   38800,38809,38810,38834,38835,39015,39154,39155,39156,39162,
   39163,39166,39167,39176,39177,39313,39314,39320,39321,39324,
   39325,39334,39335,39351,39357,39358,39361,39362,39371,39372,
   39393,39394,39397,39398,39407,39408,39589,39592,39593,39602,
   39603,39621,39622,39631,39632,39703,39712,39713,39737,39738,
   39918,40174,40175,40181,40182,40185,40186,40195,40196,40212,
   40218,40219,40222,40223,40232,40233,40254,40255,40258,40259,
   40268,40269,40450,40453,40454,40463,40464,40482,40483,40492,
   40493,40564,40573,40574,40598,40599,40779,43256,43262,43263,
   43266,43267,43276,43277,43298,43299,43302,43303,43312,43313,
   43494,43497,43498,43507,43508,43526,43527,43536,43537,43608,
   43617,43618,43642,43643,43823,43964,43965,43968,43969,43978,
   43979,44160,44163,44164,44173,44174,44192,44193,44202,44203,
   44274,44283,44284,44308,44309,44489,44790,44793,44794,44803,
   44804,44822,44823,44832,44833,44904,44913,44914,44938,44939,
   45119,47902,47903,47912,47913,47984,47993,47994,48018,48019,
   48199,48390,48399,48400,48424,48425,48605,49478,49479,49659,
   49959],
 [5693,5694,5702,5705,5716,5894,5905,5942,6202,6213,6294,39313,
   39321,39324,39335,39358,39361,39372,39621,39632,39713,43263,
   43266,43277,43526,43618,44192,44284,48400],
 [5693,5694,5703,5705,5894,5905,5942,6230,39313,39322,39324,
   39359,39361,39649,43264,43266,43554,44220],
 [5693,5694,5704,5705,5894,5905,5942,6257,39313,39323,39324,
   39360,39361,39676,43265,43266,43581,44247],[5705,39313],
 [5693,5694,5695,5705,5706,5894,5905,5942,5978,5979,6284,39313,
   39314,39324,39325,39351,39361,39362,39397,39398,39703,43256,
   43266,43267,43302,43303,43608,43968,43969,44274,44904],
 [5693,5694,5705,5707,5713,5894,5905,5942,6285,6291,6340,39313,
   39324,39326,39332,39361,39363,39369,39704,39710,39759,43266,
   43268,43274,43609,43615,43664,44275,44281,44330,49500],
 [5693,5694,5696,5697,5698,5705,5708,5710,5711,5894,5905,5942,
   6005,6013,6016,6018,6047,6050,6052,6080,6086,6286,6288,6289,
   6360,39313,39315,39316,39317,39324,39327,39329,39330,39352,
   39353,39354,39361,39364,39366,39367,39424,39425,39432,39435,
   39437,39438,39459,39466,39469,39471,39472,39499,39502,39504,
   39505,39705,39707,39708,39779,39780,39823,43257,43258,43259,
   43266,43269,43271,43272,43329,43330,43337,43340,43342,43343,
   43364,43371,43374,43376,43377,43404,43407,43409,43410,43610,
   43612,43613,43684,43685,43728,43995,43996,44003,44006,44008,
   44009,44030,44037,44040,44042,44043,44070,44073,44075,44076,
   44276,44278,44279,44350,44351,44394,45255,45262,45265,45267,
   45268,45295,45298,45300,45301,45501,45503,45504,45575,45576,
   45619,45856,45859,45861,45862,46062,46064,46065,46136,46137,
   46180,46590,46592,46593,46664,46665,46708,49520,49521,49564,
   50393],
 [5693,5694,5705,5709,5894,5905,5942,6287,39313,39324,39328,
   39361,39365,39706,43266,43270,43611,44277],
 [5693,5694,5696,5697,5698,5705,5708,5710,5711,5894,5905,5942,
   6005,6013,6016,6018,6047,6050,6052,6080,6086,6286,6288,6289,
   6360,39313,39315,39316,39317,39324,39327,39329,39330,39352,
   39353,39354,39361,39364,39366,39367,39424,39425,39432,39435,
   39437,39438,39459,39466,39469,39471,39472,39499,39502,39504,
   39505,39705,39707,39708,39779,39780,39823,43257,43258,43259,
   43266,43269,43271,43272,43329,43330,43337,43340,43342,43343,
   43364,43371,43374,43376,43377,43404,43407,43409,43410,43610,
   43612,43613,43684,43685,43728,43995,43996,44003,44006,44008,
   44009,44030,44037,44040,44042,44043,44070,44073,44075,44076,
   44276,44278,44279,44350,44351,44394,45255,45262,45265,45267,
   45268,45295,45298,45300,45301,45501,45503,45504,45575,45576,
   45619,45856,45859,45861,45862,46062,46064,46065,46136,46137,
   46180,46590,46592,46593,46664,46665,46708,49520,49521,49564,
   50393],
 [5693,5694,5696,5697,5698,5705,5708,5710,5711,5894,5905,5942,
   6005,6013,6016,6018,6047,6050,6052,6080,6086,6286,6288,6289,
   6360,39313,39315,39316,39317,39324,39327,39329,39330,39352,
   39353,39354,39361,39364,39366,39367,39424,39425,39432,39435,
   39437,39438,39459,39466,39469,39471,39472,39499,39502,39504,
   39505,39705,39707,39708,39779,39780,39823,43257,43258,43259,
   43266,43269,43271,43272,43329,43330,43337,43340,43342,43343,
   43364,43371,43374,43376,43377,43404,43407,43409,43410,43610,
   43612,43613,43684,43685,43728,43995,43996,44003,44006,44008,
   44009,44030,44037,44040,44042,44043,44070,44073,44075,44076,
   44276,44278,44279,44350,44351,44394,45255,45262,45265,45267,
   45268,45295,45298,45300,45301,45501,45503,45504,45575,45576,
   45619,45856,45859,45861,45862,46062,46064,46065,46136,46137,
   46180,46590,46592,46593,46664,46665,46708,49520,49521,49564,
   50393],
 [5693,5694,5699,5705,5712,5894,5905,5942,6112,6119,6290,39313,
   39318,39324,39331,39355,39361,39368,39531,39538,39709,43260,
   43266,43273,43436,43443,43614,44102,44109,44280,47090],
 [5693,5694,5705,5707,5713,5894,5905,5942,6285,6291,6340,39313,
   39324,39326,39332,39361,39363,39369,39704,39710,39759,43266,
   43268,43274,43609,43615,43664,44275,44281,44330,49500],
 [5693,5694,5700,5705,5714,5894,5905,5942,6143,6152,6292,39313,
   39319,39324,39333,39356,39361,39370,39562,39571,39711,43261,
   43266,43275,43467,43616,44133,44282,47557],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,
   2384,3500,3501,3505,3506,3507,3513,3514,3517,3518,3527,3528,
   3544,3548,3549,3550,3556,3557,3560,3561,3570,3571,3590,3591,
   3592,3598,3599,3602,3603,3612,3613,3749,3750,3756,3757,3760,
   3761,3770,3771,3787,3793,3794,3797,3798,3829,3830,3833,3834,
   3843,3844,4025,4028,4029,4038,4039,4057,4058,4139,4148,4149,
   4173,4174,4354,4510,4511,4512,4518,4528,4529,5645,5646,5650,
   5651,5652,5658,5659,5662,5663,5672,5673,5689,5693,5694,5695,
   5701,5702,5705,5706,5715,5716,5735,5736,5737,5743,5744,5747,
   5748,5757,5758,5894,5895,5902,5905,5906,5916,5932,5939,5942,
   5943,5953,5974,5975,5978,5979,5988,5989,6170,6173,6174,6183,
   6184,6202,6203,6212,6213,6284,6293,6294,6318,6319,6499,7725,
   7726,7730,7731,7732,7738,7739,7742,7743,7752,7753,7769,7773,
   7774,7775,7781,7782,7785,7786,7795,7796,7815,7816,7817,7823,
   7824,7827,7828,7837,7838,7974,7975,7985,7986,7995,7996,8012,
   8018,8019,8022,8023,8032,8033,8054,8055,8058,8059,8068,8069,
   8250,8253,8254,8263,8282,8283,8292,8364,8373,8374,8398,8399,
   8579,38205,38209,38210,38211,38217,38218,38221,38222,38231,
   38232,38251,38252,38253,38259,38260,38263,38264,38273,38274,
   38410,38411,38417,38418,38421,38422,38431,38432,38448,38454,
   38455,38458,38459,38468,38469,38490,38491,38494,38495,38504,
   38505,38686,38689,38690,38699,38700,38718,38719,38728,38729,
   38800,38809,38810,38834,38835,39015,39154,39155,39156,39162,
   39163,39166,39167,39176,39177,39313,39314,39320,39321,39324,
   39325,39334,39335,39351,39357,39358,39361,39362,39371,39372,
   39393,39394,39397,39398,39407,39408,39589,39592,39593,39602,
   39603,39621,39622,39631,39632,39703,39712,39713,39737,39738,
   39918,40174,40175,40181,40182,40185,40186,40195,40196,40212,
   40218,40219,40222,40223,40232,40233,40254,40255,40258,40259,
   40268,40269,40450,40453,40454,40463,40464,40482,40483,40492,
   40493,40564,40573,40574,40598,40599,40779,43256,43262,43263,
   43266,43267,43276,43277,43298,43299,43302,43303,43312,43313,
   43494,43497,43498,43507,43508,43526,43527,43536,43537,43608,
   43617,43618,43642,43643,43823,43964,43965,43968,43969,43978,
   43979,44160,44163,44164,44173,44174,44192,44193,44202,44203,
   44274,44283,44284,44308,44309,44489,44790,44793,44794,44803,
   44804,44822,44823,44832,44833,44904,44913,44914,44938,44939,
   45119,47902,47903,47912,47913,47984,47993,47994,48018,48019,
   48199,48390,48399,48400,48424,48425,48605,49478,49479,49659,
   49959],
 [5693,5694,5702,5705,5716,5894,5905,5942,6202,6213,6294,39313,
   39321,39324,39335,39358,39361,39372,39621,39632,39713,43263,
   43266,43277,43526,43618,44192,44284,48400],
 [5693,5694,5705,5717,5894,5905,5942,6295,39313,39324,39336,
   39361,39373,39714,43266,43278,43619,44285],
 [5693,5694,5705,5718,5894,5905,5942,6296,39313,39324,39337,
   39361,39374,39715,43266,43279,43620,44286],
 [5693,5694,5705,5719,5894,5905,5942,6297,39313,39324,39338,
   39361,39375,39716,43266,43280,43621,44287],
 [5693,5694,5705,5720,5894,5905,5942,6298,39313,39324,39339,
   39361,39376,39717,43266,43281,43622,44288],
 [5693,5694,5705,5721,5894,5905,5942,6299,39313,39324,39340,
   39361,39377,39718,43266,43282,43623,44289],
 [5693,5694,5705,5722,5894,5905,5942,6300,39313,39324,39341,
   39361,39378,39719,43266,43283,43624,44290],
 [5693,5694,5705,5723,5894,5905,5942,6301,39313,39324,39342,
   39361,39379,39720,43266,43284,43625,44291],
 [5693,5694,5705,5724,5894,5905,5942,6302,39313,39324,39343,
   39361,39380,39721,43266,43285,43626,44292],
 [5693,5694,5705,5725,5894,5905,5942,6303,39313,39324,39344,
   39361,39381,39722,43266,43286,43627,44293],
 [5693,5694,5705,5726,5894,5905,5942,6304,39313,39324,39345,
   39361,39382,39723,43266,43287,43628,44294],
 [5693,5694,5705,5727,5894,5905,5942,6305,39313,39324,39346,
   39361,39383,39724,43266,43288,43629,44295],
 [5693,5694,5705,5728,5894,5905,5942,6306,39313,39324,39347,
   39361,39384,39725,43266,43289,43630,44296],
 [5693,5694,5705,5729,5894,5905,5942,6307,39313,39324,39348,
   39361,39385,39726,43266,43290,43631,44297],
 [5693,5694,5705,5730,5894,5905,5942,6308,39313,39324,39349,
   39361,39386,39727,43266,43291,43632,44298],
 [5693,5694,5705,5731,5894,5905,5942,6309,39313,39324,39350,
   39361,39387,39728,43266,43292,43633,44299],
 [5693,5694,5695,5705,5706,5894,5905,5942,5978,5979,6284,39313,
   39314,39324,39325,39351,39361,39362,39397,39398,39703,43256,
   43266,43267,43302,43303,43608,43968,43969,44274,44904],
 [5693,5694,5696,5697,5698,5705,5708,5710,5711,5894,5905,5942,
   6005,6013,6016,6018,6047,6050,6052,6080,6086,6286,6288,6289,
   6360,39313,39315,39316,39317,39324,39327,39329,39330,39352,
   39353,39354,39361,39364,39366,39367,39424,39425,39432,39435,
   39437,39438,39459,39466,39469,39471,39472,39499,39502,39504,
   39505,39705,39707,39708,39779,39780,39823,43257,43258,43259,
   43266,43269,43271,43272,43329,43330,43337,43340,43342,43343,
   43364,43371,43374,43376,43377,43404,43407,43409,43410,43610,
   43612,43613,43684,43685,43728,43995,43996,44003,44006,44008,
   44009,44030,44037,44040,44042,44043,44070,44073,44075,44076,
   44276,44278,44279,44350,44351,44394,45255,45262,45265,45267,
   45268,45295,45298,45300,45301,45501,45503,45504,45575,45576,
   45619,45856,45859,45861,45862,46062,46064,46065,46136,46137,
   46180,46590,46592,46593,46664,46665,46708,49520,49521,49564,
   50393],
 [5693,5694,5696,5697,5698,5705,5708,5710,5711,5894,5905,5942,
   6005,6013,6016,6018,6047,6050,6052,6080,6086,6286,6288,6289,
   6360,39313,39315,39316,39317,39324,39327,39329,39330,39352,
   39353,39354,39361,39364,39366,39367,39424,39425,39432,39435,
   39437,39438,39459,39466,39469,39471,39472,39499,39502,39504,
   39505,39705,39707,39708,39779,39780,39823,43257,43258,43259,
   43266,43269,43271,43272,43329,43330,43337,43340,43342,43343,
   43364,43371,43374,43376,43377,43404,43407,43409,43410,43610,
   43612,43613,43684,43685,43728,43995,43996,44003,44006,44008,
   44009,44030,44037,44040,44042,44043,44070,44073,44075,44076,
   44276,44278,44279,44350,44351,44394,45255,45262,45265,45267,
   45268,45295,45298,45300,45301,45501,45503,45504,45575,45576,
   45619,45856,45859,45861,45862,46062,46064,46065,46136,46137,
   46180,46590,46592,46593,46664,46665,46708,49520,49521,49564,
   50393],
 [5693,5694,5696,5697,5698,5705,5708,5710,5711,5894,5905,5942,
   6005,6013,6016,6018,6047,6050,6052,6080,6086,6286,6288,6289,
   6360,39313,39315,39316,39317,39324,39327,39329,39330,39352,
   39353,39354,39361,39364,39366,39367,39424,39425,39432,39435,
   39437,39438,39459,39466,39469,39471,39472,39499,39502,39504,
   39505,39705,39707,39708,39779,39780,39823,43257,43258,43259,
   43266,43269,43271,43272,43329,43330,43337,43340,43342,43343,
   43364,43371,43374,43376,43377,43404,43407,43409,43410,43610,
   43612,43613,43684,43685,43728,43995,43996,44003,44006,44008,
   44009,44030,44037,44040,44042,44043,44070,44073,44075,44076,
   44276,44278,44279,44350,44351,44394,45255,45262,45265,45267,
   45268,45295,45298,45300,45301,45501,45503,45504,45575,45576,
   45619,45856,45859,45861,45862,46062,46064,46065,46136,46137,
   46180,46590,46592,46593,46664,46665,46708,49520,49521,49564,
   50393],
 [5693,5694,5699,5705,5712,5894,5905,5942,6112,6119,6290,39313,
   39318,39324,39331,39355,39361,39368,39531,39538,39709,43260,
   43266,43273,43436,43443,43614,44102,44109,44280,47090],
 [5693,5694,5700,5705,5714,5894,5905,5942,6143,6152,6292,39313,
   39319,39324,39333,39356,39361,39370,39562,39571,39711,43261,
   43266,43275,43467,43616,44133,44282,47557],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,
   2384,3500,3501,3505,3506,3507,3513,3514,3517,3518,3527,3528,
   3544,3548,3549,3550,3556,3557,3560,3561,3570,3571,3590,3591,
   3592,3598,3599,3602,3603,3612,3613,3749,3750,3756,3757,3760,
   3761,3770,3771,3787,3793,3794,3797,3798,3829,3830,3833,3834,
   3843,3844,4025,4028,4029,4038,4039,4057,4058,4139,4148,4149,
   4173,4174,4354,4510,4511,4512,4518,4528,4529,5645,5646,5650,
   5651,5652,5658,5659,5662,5663,5672,5673,5689,5693,5694,5695,
   5701,5702,5705,5706,5715,5716,5735,5736,5737,5743,5744,5747,
   5748,5757,5758,5894,5895,5902,5905,5906,5916,5932,5939,5942,
   5943,5953,5974,5975,5978,5979,5988,5989,6170,6173,6174,6183,
   6184,6202,6203,6212,6213,6284,6293,6294,6318,6319,6499,7725,
   7726,7730,7731,7732,7738,7739,7742,7743,7752,7753,7769,7773,
   7774,7775,7781,7782,7785,7786,7795,7796,7815,7816,7817,7823,
   7824,7827,7828,7837,7838,7974,7975,7985,7986,7995,7996,8012,
   8018,8019,8022,8023,8032,8033,8054,8055,8058,8059,8068,8069,
   8250,8253,8254,8263,8282,8283,8292,8364,8373,8374,8398,8399,
   8579,38205,38209,38210,38211,38217,38218,38221,38222,38231,
   38232,38251,38252,38253,38259,38260,38263,38264,38273,38274,
   38410,38411,38417,38418,38421,38422,38431,38432,38448,38454,
   38455,38458,38459,38468,38469,38490,38491,38494,38495,38504,
   38505,38686,38689,38690,38699,38700,38718,38719,38728,38729,
   38800,38809,38810,38834,38835,39015,39154,39155,39156,39162,
   39163,39166,39167,39176,39177,39313,39314,39320,39321,39324,
   39325,39334,39335,39351,39357,39358,39361,39362,39371,39372,
   39393,39394,39397,39398,39407,39408,39589,39592,39593,39602,
   39603,39621,39622,39631,39632,39703,39712,39713,39737,39738,
   39918,40174,40175,40181,40182,40185,40186,40195,40196,40212,
   40218,40219,40222,40223,40232,40233,40254,40255,40258,40259,
   40268,40269,40450,40453,40454,40463,40464,40482,40483,40492,
   40493,40564,40573,40574,40598,40599,40779,43256,43262,43263,
   43266,43267,43276,43277,43298,43299,43302,43303,43312,43313,
   43494,43497,43498,43507,43508,43526,43527,43536,43537,43608,
   43617,43618,43642,43643,43823,43964,43965,43968,43969,43978,
   43979,44160,44163,44164,44173,44174,44192,44193,44202,44203,
   44274,44283,44284,44308,44309,44489,44790,44793,44794,44803,
   44804,44822,44823,44832,44833,44904,44913,44914,44938,44939,
   45119,47902,47903,47912,47913,47984,47993,47994,48018,48019,
   48199,48390,48399,48400,48424,48425,48605,49478,49479,49659,
   49959],
 [5693,5694,5702,5705,5716,5894,5905,5942,6202,6213,6294,39313,
   39321,39324,39335,39358,39361,39372,39621,39632,39713,43263,
   43266,43277,43526,43618,44192,44284,48400],
 [5693,5694,5703,5705,5894,5905,5942,6230,39313,39322,39324,
   39359,39361,39649,43264,43266,43554,44220],
 [5693,5694,5704,5705,5894,5905,5942,6257,39313,39323,39324,
   39360,39361,39676,43265,43266,43581,44247],[5705,39313],
 [5693,5694,5695,5705,5706,5894,5905,5942,5978,5979,6284,39313,
   39314,39324,39325,39351,39361,39362,39397,39398,39703,43256,
   43266,43267,43302,43303,43608,43968,43969,44274,44904],
 [5693,5694,5705,5707,5713,5894,5905,5942,6285,6291,6340,39313,
   39324,39326,39332,39361,39363,39369,39704,39710,39759,43266,
   43268,43274,43609,43615,43664,44275,44281,44330,49500],
 [5693,5694,5696,5697,5698,5705,5708,5710,5711,5894,5905,5942,
   6005,6013,6016,6018,6047,6050,6052,6080,6086,6286,6288,6289,
   6360,39313,39315,39316,39317,39324,39327,39329,39330,39352,
   39353,39354,39361,39364,39366,39367,39424,39425,39432,39435,
   39437,39438,39459,39466,39469,39471,39472,39499,39502,39504,
   39505,39705,39707,39708,39779,39780,39823,43257,43258,43259,
   43266,43269,43271,43272,43329,43330,43337,43340,43342,43343,
   43364,43371,43374,43376,43377,43404,43407,43409,43410,43610,
   43612,43613,43684,43685,43728,43995,43996,44003,44006,44008,
   44009,44030,44037,44040,44042,44043,44070,44073,44075,44076,
   44276,44278,44279,44350,44351,44394,45255,45262,45265,45267,
   45268,45295,45298,45300,45301,45501,45503,45504,45575,45576,
   45619,45856,45859,45861,45862,46062,46064,46065,46136,46137,
   46180,46590,46592,46593,46664,46665,46708,49520,49521,49564,
   50393],
 [5693,5694,5705,5709,5894,5905,5942,6287,39313,39324,39328,
   39361,39365,39706,43266,43270,43611,44277],
 [5693,5694,5696,5697,5698,5705,5708,5710,5711,5894,5905,5942,
   6005,6013,6016,6018,6047,6050,6052,6080,6086,6286,6288,6289,
   6360,39313,39315,39316,39317,39324,39327,39329,39330,39352,
   39353,39354,39361,39364,39366,39367,39424,39425,39432,39435,
   39437,39438,39459,39466,39469,39471,39472,39499,39502,39504,
   39505,39705,39707,39708,39779,39780,39823,43257,43258,43259,
   43266,43269,43271,43272,43329,43330,43337,43340,43342,43343,
   43364,43371,43374,43376,43377,43404,43407,43409,43410,43610,
   43612,43613,43684,43685,43728,43995,43996,44003,44006,44008,
   44009,44030,44037,44040,44042,44043,44070,44073,44075,44076,
   44276,44278,44279,44350,44351,44394,45255,45262,45265,45267,
   45268,45295,45298,45300,45301,45501,45503,45504,45575,45576,
   45619,45856,45859,45861,45862,46062,46064,46065,46136,46137,
   46180,46590,46592,46593,46664,46665,46708,49520,49521,49564,
   50393],
 [5693,5694,5696,5697,5698,5705,5708,5710,5711,5894,5905,5942,
   6005,6013,6016,6018,6047,6050,6052,6080,6086,6286,6288,6289,
   6360,39313,39315,39316,39317,39324,39327,39329,39330,39352,
   39353,39354,39361,39364,39366,39367,39424,39425,39432,39435,
   39437,39438,39459,39466,39469,39471,39472,39499,39502,39504,
   39505,39705,39707,39708,39779,39780,39823,43257,43258,43259,
   43266,43269,43271,43272,43329,43330,43337,43340,43342,43343,
   43364,43371,43374,43376,43377,43404,43407,43409,43410,43610,
   43612,43613,43684,43685,43728,43995,43996,44003,44006,44008,
   44009,44030,44037,44040,44042,44043,44070,44073,44075,44076,
   44276,44278,44279,44350,44351,44394,45255,45262,45265,45267,
   45268,45295,45298,45300,45301,45501,45503,45504,45575,45576,
   45619,45856,45859,45861,45862,46062,46064,46065,46136,46137,
   46180,46590,46592,46593,46664,46665,46708,49520,49521,49564,
   50393],
 [5693,5694,5699,5705,5712,5894,5905,5942,6112,6119,6290,39313,
   39318,39324,39331,39355,39361,39368,39531,39538,39709,43260,
   43266,43273,43436,43443,43614,44102,44109,44280,47090],
 [5693,5694,5705,5707,5713,5894,5905,5942,6285,6291,6340,39313,
   39324,39326,39332,39361,39363,39369,39704,39710,39759,43266,
   43268,43274,43609,43615,43664,44275,44281,44330,49500],
 [5693,5694,5700,5705,5714,5894,5905,5942,6143,6152,6292,39313,
   39319,39324,39333,39356,39361,39370,39562,39571,39711,43261,
   43266,43275,43467,43616,44133,44282,47557],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,
   2384,3500,3501,3505,3506,3507,3513,3514,3517,3518,3527,3528,
   3544,3548,3549,3550,3556,3557,3560,3561,3570,3571,3590,3591,
   3592,3598,3599,3602,3603,3612,3613,3749,3750,3756,3757,3760,
   3761,3770,3771,3787,3793,3794,3797,3798,3829,3830,3833,3834,
   3843,3844,4025,4028,4029,4038,4039,4057,4058,4139,4148,4149,
   4173,4174,4354,4510,4511,4512,4518,4528,4529,5645,5646,5650,
   5651,5652,5658,5659,5662,5663,5672,5673,5689,5693,5694,5695,
   5701,5702,5705,5706,5715,5716,5735,5736,5737,5743,5744,5747,
   5748,5757,5758,5894,5895,5902,5905,5906,5916,5932,5939,5942,
   5943,5953,5974,5975,5978,5979,5988,5989,6170,6173,6174,6183,
   6184,6202,6203,6212,6213,6284,6293,6294,6318,6319,6499,7725,
   7726,7730,7731,7732,7738,7739,7742,7743,7752,7753,7769,7773,
   7774,7775,7781,7782,7785,7786,7795,7796,7815,7816,7817,7823,
   7824,7827,7828,7837,7838,7974,7975,7985,7986,7995,7996,8012,
   8018,8019,8022,8023,8032,8033,8054,8055,8058,8059,8068,8069,
   8250,8253,8254,8263,8282,8283,8292,8364,8373,8374,8398,8399,
   8579,38205,38209,38210,38211,38217,38218,38221,38222,38231,
   38232,38251,38252,38253,38259,38260,38263,38264,38273,38274,
   38410,38411,38417,38418,38421,38422,38431,38432,38448,38454,
   38455,38458,38459,38468,38469,38490,38491,38494,38495,38504,
   38505,38686,38689,38690,38699,38700,38718,38719,38728,38729,
   38800,38809,38810,38834,38835,39015,39154,39155,39156,39162,
   39163,39166,39167,39176,39177,39313,39314,39320,39321,39324,
   39325,39334,39335,39351,39357,39358,39361,39362,39371,39372,
   39393,39394,39397,39398,39407,39408,39589,39592,39593,39602,
   39603,39621,39622,39631,39632,39703,39712,39713,39737,39738,
   39918,40174,40175,40181,40182,40185,40186,40195,40196,40212,
   40218,40219,40222,40223,40232,40233,40254,40255,40258,40259,
   40268,40269,40450,40453,40454,40463,40464,40482,40483,40492,
   40493,40564,40573,40574,40598,40599,40779,43256,43262,43263,
   43266,43267,43276,43277,43298,43299,43302,43303,43312,43313,
   43494,43497,43498,43507,43508,43526,43527,43536,43537,43608,
   43617,43618,43642,43643,43823,43964,43965,43968,43969,43978,
   43979,44160,44163,44164,44173,44174,44192,44193,44202,44203,
   44274,44283,44284,44308,44309,44489,44790,44793,44794,44803,
   44804,44822,44823,44832,44833,44904,44913,44914,44938,44939,
   45119,47902,47903,47912,47913,47984,47993,47994,48018,48019,
   48199,48390,48399,48400,48424,48425,48605,49478,49479,49659,
   49959],
 [5693,5694,5702,5705,5716,5894,5905,5942,6202,6213,6294,39313,
   39321,39324,39335,39358,39361,39372,39621,39632,39713,43263,
   43266,43277,43526,43618,44192,44284,48400],
 [5693,5694,5705,5717,5894,5905,5942,6295,39313,39324,39336,
   39361,39373,39714,43266,43278,43619,44285],
 [5693,5694,5705,5718,5894,5905,5942,6296,39313,39324,39337,
   39361,39374,39715,43266,43279,43620,44286],
 [5693,5694,5705,5719,5894,5905,5942,6297,39313,39324,39338,
   39361,39375,39716,43266,43280,43621,44287],
 [5693,5694,5705,5720,5894,5905,5942,6298,39313,39324,39339,
   39361,39376,39717,43266,43281,43622,44288],
 [5693,5694,5705,5721,5894,5905,5942,6299,39313,39324,39340,
   39361,39377,39718,43266,43282,43623,44289],
 [5693,5694,5705,5722,5894,5905,5942,6300,39313,39324,39341,
   39361,39378,39719,43266,43283,43624,44290],
 [5693,5694,5705,5723,5894,5905,5942,6301,39313,39324,39342,
   39361,39379,39720,43266,43284,43625,44291],
 [5693,5694,5705,5724,5894,5905,5942,6302,39313,39324,39343,
   39361,39380,39721,43266,43285,43626,44292],
 [5693,5694,5705,5725,5894,5905,5942,6303,39313,39324,39344,
   39361,39381,39722,43266,43286,43627,44293],
 [5693,5694,5705,5726,5894,5905,5942,6304,39313,39324,39345,
   39361,39382,39723,43266,43287,43628,44294],
 [5693,5694,5705,5727,5894,5905,5942,6305,39313,39324,39346,
   39361,39383,39724,43266,43288,43629,44295],
 [5693,5694,5705,5728,5894,5905,5942,6306,39313,39324,39347,
   39361,39384,39725,43266,43289,43630,44296],
 [5693,5694,5705,5729,5894,5905,5942,6307,39313,39324,39348,
   39361,39385,39726,43266,43290,43631,44297],
 [5693,5694,5705,5730,5894,5905,5942,6308,39313,39324,39349,
   39361,39386,39727,43266,43291,43632,44298],
 [5693,5694,5705,5731,5894,5905,5942,6309,39313,39324,39350,
   39361,39387,39728,43266,43292,43633,44299],
 [5690,5691,5695,5696,5697,5705,5706,5708,5710,5774,5788,5828,
   5978,5979,6005,6013,6016,6018,6047,6050,6052,6284,6286,6288,
   6360,39193,39197,39198,39199,39207,39208,39210,39212,39237,
   39238,39239,39247,39248,39250,39252,39388,39389,39397,39398,
   39400,39402,39424,39432,39433,39435,39437,39466,39467,39469,
   39471,39703,39705,39707,39730,39732,39779,40918,40919,40920,
   40928,40929,40931,40933,41069,41070,41078,41079,41081,41083,
   41105,41113,41114,41116,41118,41147,41148,41150,41152,41384,
   41386,41388,41411,41413,41460,41849,41850,41858,41859,41861,
   41863,41885,41893,41894,41896,41898,41927,41928,41930,41932,
   42164,42166,42168,42191,42193,42240,44625,44633,44634,44636,
   44638,44667,44668,44670,44672,44904,44906,44908,44931,44933,
   44980,45262,45263,45265,45267,45499,45501,45503,45526,45528,
   45575,46060,46062,46064,46087,46089,46136,49471,49473,49520,
   49820],
 [5690,5691,5695,5696,5697,5705,5706,5708,5710,5774,5788,5828,
   5978,5979,6005,6013,6016,6018,6047,6050,6052,6284,6286,6288,
   6360,39193,39197,39198,39199,39207,39208,39210,39212,39237,
   39238,39239,39247,39248,39250,39252,39388,39389,39397,39398,
   39400,39402,39424,39432,39433,39435,39437,39466,39467,39469,
   39471,39703,39705,39707,39730,39732,39779,40918,40919,40920,
   40928,40929,40931,40933,41069,41070,41078,41079,41081,41083,
   41105,41113,41114,41116,41118,41147,41148,41150,41152,41384,
   41386,41388,41411,41413,41460,41849,41850,41858,41859,41861,
   41863,41885,41893,41894,41896,41898,41927,41928,41930,41932,
   42164,42166,42168,42191,42193,42240,44625,44633,44634,44636,
   44638,44667,44668,44670,44672,44904,44906,44908,44931,44933,
   44980,45262,45263,45265,45267,45499,45501,45503,45526,45528,
   45575,46060,46062,46064,46087,46089,46136,49471,49473,49520,
   49820],
 [5695,5698,5705,5706,5711,5978,5979,6080,6086,6284,6289,39390,
   39397,39398,39403,39499,39500,39505,39703,39708,39733,44700,
   44701,44706,44904,44909,44934,46588,46593,46618,49474],
 [5692,5695,5699,5705,5706,5712,5867,5978,5979,6112,6119,6284,
   6290,39276,39280,39286,39287,39293,39391,39397,39398,39404,
   39531,39532,39538,39703,39709,39734,42593,42599,42600,42606,
   42733,42734,42740,42905,42911,42936,44732,44733,44739,44904,
   44910,44935,47084,47090,47115,49475],
 [5695,5700,5705,5706,5707,5713,5714,5978,5979,6143,6152,6284,
   6285,6291,6292,6340,39392,39397,39398,39399,39405,39406,
   39562,39563,39564,39570,39571,39703,39704,39710,39711,39729,
   39735,39736,39759,39760,39883,44763,44764,44765,44904,44905,
   44911,44912,44930,44936,44937,44960,44961,45084,47549,47550,
   47556,47557,47575,47581,47605,49470,49476,49477,49500,49501,
   49624,49800,49924,50200],
 [5695,5701,5705,5706,5715,5978,5979,6173,6183,6284,6293,39393,
   39397,39398,39407,39592,39593,39602,39703,39712,39737,44793,
   44794,44803,44904,44913,44938,47984,47993,48018,49478],
 [5695,5702,5705,5706,5716,5978,5979,6202,6213,6284,6294,39394,
   39397,39398,39408,39621,39622,39632,39703,39713,39738,44822,
   44823,44904,44914,44939,48390,48400,49479],
 [5695,5703,5705,5706,5709,5978,5979,6230,6284,6287,39395,39397,
   39398,39401,39649,39650,39653,39703,39706,39731,44850,44851,
   44854,44904,44907,44932,48768,48771,48796,49472],
 [5695,5704,5705,5706,5978,5979,6257,6284,39396,39397,39398,
   39676,39677,39703,44877,44878,44904,49119],[5705,44904],
 [5705,44904],
 [5695,5700,5705,5706,5707,5713,5714,5978,5979,6143,6152,6284,
   6285,6291,6292,6340,39392,39397,39398,39399,39405,39406,
   39562,39563,39564,39570,39571,39703,39704,39710,39711,39729,
   39735,39736,39759,39760,39883,44763,44764,44765,44904,44905,
   44911,44912,44930,44936,44937,44960,44961,45084,47549,47550,
   47556,47557,47575,47581,47605,49470,49476,49477,49500,49501,
   49624,49800,49924,50200],
 [5690,5691,5695,5696,5697,5705,5706,5708,5710,5774,5788,5828,
   5978,5979,6005,6013,6016,6018,6047,6050,6052,6284,6286,6288,
   6360,39193,39197,39198,39199,39207,39208,39210,39212,39237,
   39238,39239,39247,39248,39250,39252,39388,39389,39397,39398,
   39400,39402,39424,39432,39433,39435,39437,39466,39467,39469,
   39471,39703,39705,39707,39730,39732,39779,40918,40919,40920,
   40928,40929,40931,40933,41069,41070,41078,41079,41081,41083,
   41105,41113,41114,41116,41118,41147,41148,41150,41152,41384,
   41386,41388,41411,41413,41460,41849,41850,41858,41859,41861,
   41863,41885,41893,41894,41896,41898,41927,41928,41930,41932,
   42164,42166,42168,42191,42193,42240,44625,44633,44634,44636,
   44638,44667,44668,44670,44672,44904,44906,44908,44931,44933,
   44980,45262,45263,45265,45267,45499,45501,45503,45526,45528,
   45575,46060,46062,46064,46087,46089,46136,49471,49473,49520,
   49820],
 [5695,5703,5705,5706,5709,5978,5979,6230,6284,6287,39395,39397,
   39398,39401,39649,39650,39653,39703,39706,39731,44850,44851,
   44854,44904,44907,44932,48768,48771,48796,49472],
 [5690,5691,5695,5696,5697,5705,5706,5708,5710,5774,5788,5828,
   5978,5979,6005,6013,6016,6018,6047,6050,6052,6284,6286,6288,
   6360,39193,39197,39198,39199,39207,39208,39210,39212,39237,
   39238,39239,39247,39248,39250,39252,39388,39389,39397,39398,
   39400,39402,39424,39432,39433,39435,39437,39466,39467,39469,
   39471,39703,39705,39707,39730,39732,39779,40918,40919,40920,
   40928,40929,40931,40933,41069,41070,41078,41079,41081,41083,
   41105,41113,41114,41116,41118,41147,41148,41150,41152,41384,
   41386,41388,41411,41413,41460,41849,41850,41858,41859,41861,
   41863,41885,41893,41894,41896,41898,41927,41928,41930,41932,
   42164,42166,42168,42191,42193,42240,44625,44633,44634,44636,
   44638,44667,44668,44670,44672,44904,44906,44908,44931,44933,
   44980,45262,45263,45265,45267,45499,45501,45503,45526,45528,
   45575,46060,46062,46064,46087,46089,46136,49471,49473,49520,
   49820],
 [5695,5698,5705,5706,5711,5978,5979,6080,6086,6284,6289,39390,
   39397,39398,39403,39499,39500,39505,39703,39708,39733,44700,
   44701,44706,44904,44909,44934,46588,46593,46618,49474],
 [5692,5695,5699,5705,5706,5712,5867,5978,5979,6112,6119,6284,
   6290,39276,39280,39286,39287,39293,39391,39397,39398,39404,
   39531,39532,39538,39703,39709,39734,42593,42599,42600,42606,
   42733,42734,42740,42905,42911,42936,44732,44733,44739,44904,
   44910,44935,47084,47090,47115,49475],
 [5695,5700,5705,5706,5707,5713,5714,5978,5979,6143,6152,6284,
   6285,6291,6292,6340,39392,39397,39398,39399,39405,39406,
   39562,39563,39564,39570,39571,39703,39704,39710,39711,39729,
   39735,39736,39759,39760,39883,44763,44764,44765,44904,44905,
   44911,44912,44930,44936,44937,44960,44961,45084,47549,47550,
   47556,47557,47575,47581,47605,49470,49476,49477,49500,49501,
   49624,49800,49924,50200],
 [5695,5700,5705,5706,5707,5713,5714,5978,5979,6143,6152,6284,
   6285,6291,6292,6340,39392,39397,39398,39399,39405,39406,
   39562,39563,39564,39570,39571,39703,39704,39710,39711,39729,
   39735,39736,39759,39760,39883,44763,44764,44765,44904,44905,
   44911,44912,44930,44936,44937,44960,44961,45084,47549,47550,
   47556,47557,47575,47581,47605,49470,49476,49477,49500,49501,
   49624,49800,49924,50200],
 [5695,5701,5705,5706,5715,5978,5979,6173,6183,6284,6293,39393,
   39397,39398,39407,39592,39593,39602,39703,39712,39737,44793,
   44794,44803,44904,44913,44938,47984,47993,48018,49478],
 [5695,5702,5705,5706,5716,5978,5979,6202,6213,6284,6294,39394,
   39397,39398,39408,39621,39622,39632,39703,39713,39738,44822,
   44823,44904,44914,44939,48390,48400,49479],
 [5695,5705,5706,5717,5978,5979,6284,6295,39397,39398,39409,
   39703,39714,39739,44904,44915,44940,49480],
 [5695,5705,5706,5718,5978,5979,6284,6296,39397,39398,39410,
   39703,39715,39740,44904,44916,44941,49481],
 [5695,5705,5706,5719,5978,5979,6284,6297,39397,39398,39411,
   39703,39716,39741,44904,44917,44942,49482],
 [5695,5705,5706,5720,5978,5979,6284,6298,39397,39398,39412,
   39703,39717,39742,44904,44918,44943,49483],
 [5695,5705,5706,5721,5728,5978,5979,6284,6299,6306,39397,39398,
   39413,39420,39703,39718,39725,39743,39750,40005,44904,44919,
   44926,44944,44951,45206,49484,49491,49746,50046],
 [5695,5705,5706,5722,5978,5979,6284,6300,39397,39398,39414,
   39703,39719,39744,44904,44920,44945,49485],
 [5695,5705,5706,5723,5978,5979,6284,6301,39397,39398,39415,
   39703,39720,39745,44904,44921,44946,49486],
 [5695,5705,5706,5724,5978,5979,6284,6302,39397,39398,39416,
   39703,39721,39746,44904,44922,44947,49487],
 [5695,5705,5706,5725,5727,5978,5979,6284,6303,6305,39397,39398,
   39417,39419,39703,39722,39724,39747,39749,40034,44904,44923,
   44925,44948,44950,45235,49488,49490,49775,50075],
 [5695,5705,5706,5726,5978,5979,6284,6304,39397,39398,39418,
   39703,39723,39748,44904,44924,44949,49489],
 [5695,5705,5706,5725,5727,5978,5979,6284,6303,6305,39397,39398,
   39417,39419,39703,39722,39724,39747,39749,40034,44904,44923,
   44925,44948,44950,45235,49488,49490,49775,50075],
 [5695,5705,5706,5721,5728,5978,5979,6284,6299,6306,39397,39398,
   39413,39420,39703,39718,39725,39743,39750,40005,44904,44919,
   44926,44944,44951,45206,49484,49491,49746,50046],
 [5695,5705,5706,5729,5978,5979,6284,6307,39397,39398,39421,
   39703,39726,39751,44904,44927,44952,49492],
 [5695,5705,5706,5730,5978,5979,6284,6308,39397,39398,39422,
   39703,39727,39752,44904,44928,44953,49493],
 [5695,5705,5706,5731,5978,5979,6284,6309,39397,39398,39423,
   39703,39728,39753,44904,44929,44954,49494],
 [5705,6018,6050,39424,39779,45501,46064],
 [5693,5694,5696,5697,5698,5705,5708,5710,5711,5894,5905,5942,
   6005,6013,6016,6018,6047,6050,6052,6080,6086,6286,6288,6289,
   6360,39313,39315,39316,39317,39324,39327,39329,39330,39352,
   39353,39354,39361,39364,39366,39367,39424,39425,39432,39435,
   39437,39438,39459,39466,39469,39471,39472,39499,39502,39504,
   39505,39705,39707,39708,39779,39780,39823,43257,43258,43259,
   43266,43269,43271,43272,43329,43330,43337,43340,43342,43343,
   43364,43371,43374,43376,43377,43404,43407,43409,43410,43610,
   43612,43613,43684,43685,43728,43995,43996,44003,44006,44008,
   44009,44030,44037,44040,44042,44043,44070,44073,44075,44076,
   44276,44278,44279,44350,44351,44394,45255,45262,45265,45267,
   45268,45295,45298,45300,45301,45501,45503,45504,45575,45576,
   45619,45856,45859,45861,45862,46062,46064,46065,46136,46137,
   46180,46590,46592,46593,46664,46665,46708,49520,49521,49564,
   50393],
 [5645,5646,5662,5689,5696,5697,5699,5705,5708,5710,5712,5747,
   6005,6013,6016,6018,6047,6050,6052,6112,6119,6286,6288,6290,
   6360,38205,38212,38213,38215,38221,38224,38226,38228,38254,
   38255,38257,38263,38266,38268,38270,38521,38523,38529,38532,
   38534,38536,38557,38563,38566,38568,38570,38628,38631,38633,
   38635,38802,38804,38806,38876,38878,38921,39157,39158,39160,
   39166,39169,39171,39173,39424,39426,39432,39435,39437,39439,
   39460,39466,39469,39471,39473,39531,39534,39536,39538,39705,
   39707,39709,39779,39781,39824,40285,40287,40293,40296,40298,
   40300,40321,40327,40330,40332,40334,40392,40395,40397,40399,
   40566,40568,40570,40640,40642,40685,45256,45262,45265,45267,
   45269,45327,45330,45332,45334,45501,45503,45505,45575,45577,
   45620,45888,45891,45893,45895,46062,46064,46066,46136,46138,
   46181,47086,47088,47090,47160,47162,47205,49520,49522,49565,
   50394],
 [5696,5697,5700,5705,5708,5710,5714,6005,6013,6016,6018,6042,
   6047,6050,6052,6056,6143,6146,6152,6286,6288,6292,6360,6364,
   39424,39427,39432,39435,39437,39441,39461,39466,39469,39471,
   39475,39562,39565,39567,39571,39705,39707,39711,39779,39783,
   39826,45257,45262,45265,45267,45271,45358,45361,45363,45501,
   45503,45507,45575,45579,45622,45919,45922,45924,45928,46062,
   46064,46068,46136,46140,46183,47551,47553,47557,47625,47629,
   49520,49524,49567,50396],[6018,6183,45393,45398,45623,48108]
  ,[5696,5697,5702,5705,5708,5710,5716,6005,6013,6016,6018,
   6044,6047,6050,6052,6058,6202,6205,6213,6286,6288,6294,6360,
   6366,39424,39429,39432,39435,39437,39443,39463,39466,39469,
   39471,39477,39621,39624,39626,39632,39705,39707,39713,39779,
   39785,39828,45259,45262,45265,45267,45273,45417,45420,45422,
   45501,45503,45509,45575,45581,45624,45978,45981,45983,45989,
   46062,46064,46070,46136,46142,46185,48392,48394,48400,48466,
   48472,49520,49526,49569,50398],[6018,45450],
 [6018,45476,45477,45597,49217],
 [5705,6018,6050,39424,39779,45501,46064],
 [5690,5691,5695,5696,5697,5705,5706,5708,5710,5774,5788,5828,
   5978,5979,6005,6013,6016,6018,6047,6050,6052,6284,6286,6288,
   6360,39193,39197,39198,39199,39207,39208,39210,39212,39237,
   39238,39239,39247,39248,39250,39252,39388,39389,39397,39398,
   39400,39402,39424,39432,39433,39435,39437,39466,39467,39469,
   39471,39703,39705,39707,39730,39732,39779,40918,40919,40920,
   40928,40929,40931,40933,41069,41070,41078,41079,41081,41083,
   41105,41113,41114,41116,41118,41147,41148,41150,41152,41384,
   41386,41388,41411,41413,41460,41849,41850,41858,41859,41861,
   41863,41885,41893,41894,41896,41898,41927,41928,41930,41932,
   42164,42166,42168,42191,42193,42240,44625,44633,44634,44636,
   44638,44667,44668,44670,44672,44904,44906,44908,44931,44933,
   44980,45262,45263,45265,45267,45499,45501,45503,45526,45528,
   45575,46060,46062,46064,46087,46089,46136,49471,49473,49520,
   49820],[6018,6340,45552,45555,45621,50142],
 [5705,6018,6050,39424,39779,45501,46064],
 [6018,45476,45477,45597,49217],[],
 [5693,5694,5696,5697,5698,5705,5708,5710,5711,5894,5905,5942,
   6005,6013,6016,6018,6047,6050,6052,6080,6086,6286,6288,6289,
   6360,39313,39315,39316,39317,39324,39327,39329,39330,39352,
   39353,39354,39361,39364,39366,39367,39424,39425,39432,39435,
   39437,39438,39459,39466,39469,39471,39472,39499,39502,39504,
   39505,39705,39707,39708,39779,39780,39823,43257,43258,43259,
   43266,43269,43271,43272,43329,43330,43337,43340,43342,43343,
   43364,43371,43374,43376,43377,43404,43407,43409,43410,43610,
   43612,43613,43684,43685,43728,43995,43996,44003,44006,44008,
   44009,44030,44037,44040,44042,44043,44070,44073,44075,44076,
   44276,44278,44279,44350,44351,44394,45255,45262,45265,45267,
   45268,45295,45298,45300,45301,45501,45503,45504,45575,45576,
   45619,45856,45859,45861,45862,46062,46064,46065,46136,46137,
   46180,46590,46592,46593,46664,46665,46708,49520,49521,49564,
   50393],
 [5645,5646,5662,5689,5696,5697,5699,5705,5708,5710,5712,5747,
   6005,6013,6016,6018,6047,6050,6052,6112,6119,6286,6288,6290,
   6360,38205,38212,38213,38215,38221,38224,38226,38228,38254,
   38255,38257,38263,38266,38268,38270,38521,38523,38529,38532,
   38534,38536,38557,38563,38566,38568,38570,38628,38631,38633,
   38635,38802,38804,38806,38876,38878,38921,39157,39158,39160,
   39166,39169,39171,39173,39424,39426,39432,39435,39437,39439,
   39460,39466,39469,39471,39473,39531,39534,39536,39538,39705,
   39707,39709,39779,39781,39824,40285,40287,40293,40296,40298,
   40300,40321,40327,40330,40332,40334,40392,40395,40397,40399,
   40566,40568,40570,40640,40642,40685,45256,45262,45265,45267,
   45269,45327,45330,45332,45334,45501,45503,45505,45575,45577,
   45620,45888,45891,45893,45895,46062,46064,46066,46136,46138,
   46181,47086,47088,47090,47160,47162,47205,49520,49522,49565,
   50394],[6018,6340,45552,45555,45621,50142],
 [5696,5697,5700,5705,5708,5710,5714,6005,6013,6016,6018,6042,
   6047,6050,6052,6056,6143,6146,6152,6286,6288,6292,6360,6364,
   39424,39427,39432,39435,39437,39441,39461,39466,39469,39471,
   39475,39562,39565,39567,39571,39705,39707,39711,39779,39783,
   39826,45257,45262,45265,45267,45271,45358,45361,45363,45501,
   45503,45507,45575,45579,45622,45919,45922,45924,45928,46062,
   46064,46068,46136,46140,46183,47551,47553,47557,47625,47629,
   49520,49524,49567,50396],[6018,6183,45393,45398,45623,48108]
  ,[5696,5697,5702,5705,5708,5710,5716,6005,6013,6016,6018,
   6044,6047,6050,6052,6058,6202,6205,6213,6286,6288,6294,6360,
   6366,39424,39429,39432,39435,39437,39443,39463,39466,39469,
   39471,39477,39621,39624,39626,39632,39705,39707,39713,39779,
   39785,39828,45259,45262,45265,45267,45273,45417,45420,45422,
   45501,45503,45509,45575,45581,45624,45978,45981,45983,45989,
   46062,46064,46070,46136,46142,46185,48392,48394,48400,48466,
   48472,49520,49526,49569,50398],
 [6018,45625,45626,45745,50960],[6018,45625,45626,45745,50960],
 [6018,45627],[6018,45628,45636,45791,51006],[6018,45629],
 [6018,45630,45632,45806,51021],[6018,45631],
 [6018,45630,45632,45806,51021],[6018,45633],
 [6018,45634,45635,45835,51050],[6018,45634,45635,45835,51050],
 [6018,45628,45636,45791,51006],[6018,45637,45638,45847,51062],
 [6018,45637,45638,45847,51062],[6018,45639],
 [5693,5694,5696,5697,5698,5705,5708,5710,5711,5894,5905,5942,
   6005,6013,6016,6018,6047,6050,6052,6080,6086,6286,6288,6289,
   6360,39313,39315,39316,39317,39324,39327,39329,39330,39352,
   39353,39354,39361,39364,39366,39367,39424,39425,39432,39435,
   39437,39438,39459,39466,39469,39471,39472,39499,39502,39504,
   39505,39705,39707,39708,39779,39780,39823,43257,43258,43259,
   43266,43269,43271,43272,43329,43330,43337,43340,43342,43343,
   43364,43371,43374,43376,43377,43404,43407,43409,43410,43610,
   43612,43613,43684,43685,43728,43995,43996,44003,44006,44008,
   44009,44030,44037,44040,44042,44043,44070,44073,44075,44076,
   44276,44278,44279,44350,44351,44394,45255,45262,45265,45267,
   45268,45295,45298,45300,45301,45501,45503,45504,45575,45576,
   45619,45856,45859,45861,45862,46062,46064,46065,46136,46137,
   46180,46590,46592,46593,46664,46665,46708,49520,49521,49564,
   50393],
 [5645,5646,5662,5689,5696,5697,5699,5705,5708,5710,5712,5747,
   6005,6013,6016,6018,6047,6050,6052,6112,6119,6286,6288,6290,
   6360,38205,38212,38213,38215,38221,38224,38226,38228,38254,
   38255,38257,38263,38266,38268,38270,38521,38523,38529,38532,
   38534,38536,38557,38563,38566,38568,38570,38628,38631,38633,
   38635,38802,38804,38806,38876,38878,38921,39157,39158,39160,
   39166,39169,39171,39173,39424,39426,39432,39435,39437,39439,
   39460,39466,39469,39471,39473,39531,39534,39536,39538,39705,
   39707,39709,39779,39781,39824,40285,40287,40293,40296,40298,
   40300,40321,40327,40330,40332,40334,40392,40395,40397,40399,
   40566,40568,40570,40640,40642,40685,45256,45262,45265,45267,
   45269,45327,45330,45332,45334,45501,45503,45505,45575,45577,
   45620,45888,45891,45893,45895,46062,46064,46066,46136,46138,
   46181,47086,47088,47090,47160,47162,47205,49520,49522,49565,
   50394],[6050,6152,45922,46140],
 [6050,6183,6340,45951,45952,45957,45959,46111,46116,46118,46139,
   46141,46241,48035,48040,48042,48063,48065,48165,50099,50101,
   50201,50454],[6050,6213,45981,46142],
 [5696,5697,5703,5705,5708,5710,6005,6011,6013,6016,6018,6047,
   6050,6052,6230,6235,6286,6288,6360,39424,39430,39432,39435,
   39437,39464,39466,39469,39471,39649,39652,39654,39705,39707,
   39779,45260,45262,45265,45267,45445,45448,45450,45501,45503,
   45575,46006,46009,46011,46062,46064,46136,48770,48772,48844,
   49520],[6050,46036],
 [5705,6018,6050,39424,39779,45501,46064],
 [5690,5691,5695,5696,5697,5705,5706,5708,5710,5774,5788,5828,
   5978,5979,6005,6013,6016,6018,6047,6050,6052,6284,6286,6288,
   6360,39193,39197,39198,39199,39207,39208,39210,39212,39237,
   39238,39239,39247,39248,39250,39252,39388,39389,39397,39398,
   39400,39402,39424,39432,39433,39435,39437,39466,39467,39469,
   39471,39703,39705,39707,39730,39732,39779,40918,40919,40920,
   40928,40929,40931,40933,41069,41070,41078,41079,41081,41083,
   41105,41113,41114,41116,41118,41147,41148,41150,41152,41384,
   41386,41388,41411,41413,41460,41849,41850,41858,41859,41861,
   41863,41885,41893,41894,41896,41898,41927,41928,41930,41932,
   42164,42166,42168,42191,42193,42240,44625,44633,44634,44636,
   44638,44667,44668,44670,44672,44904,44906,44908,44931,44933,
   44980,45262,45263,45265,45267,45499,45501,45503,45526,45528,
   45575,46060,46062,46064,46087,46089,46136,49471,49473,49520,
   49820],
 [6050,6183,6340,45951,45952,45957,45959,46111,46116,46118,46139,
   46141,46241,48035,48040,48042,48063,48065,48165,50099,50101,
   50201,50454],[],[6050,46135],
 [5705,6018,6050,39424,39779,45501,46064],
 [5693,5694,5696,5697,5698,5705,5708,5710,5711,5894,5905,5942,
   6005,6013,6016,6018,6047,6050,6052,6080,6086,6286,6288,6289,
   6360,39313,39315,39316,39317,39324,39327,39329,39330,39352,
   39353,39354,39361,39364,39366,39367,39424,39425,39432,39435,
   39437,39438,39459,39466,39469,39471,39472,39499,39502,39504,
   39505,39705,39707,39708,39779,39780,39823,43257,43258,43259,
   43266,43269,43271,43272,43329,43330,43337,43340,43342,43343,
   43364,43371,43374,43376,43377,43404,43407,43409,43410,43610,
   43612,43613,43684,43685,43728,43995,43996,44003,44006,44008,
   44009,44030,44037,44040,44042,44043,44070,44073,44075,44076,
   44276,44278,44279,44350,44351,44394,45255,45262,45265,45267,
   45268,45295,45298,45300,45301,45501,45503,45504,45575,45576,
   45619,45856,45859,45861,45862,46062,46064,46065,46136,46137,
   46180,46590,46592,46593,46664,46665,46708,49520,49521,49564,
   50393],
 [5645,5646,5662,5689,5696,5697,5699,5705,5708,5710,5712,5747,
   6005,6013,6016,6018,6047,6050,6052,6112,6119,6286,6288,6290,
   6360,38205,38212,38213,38215,38221,38224,38226,38228,38254,
   38255,38257,38263,38266,38268,38270,38521,38523,38529,38532,
   38534,38536,38557,38563,38566,38568,38570,38628,38631,38633,
   38635,38802,38804,38806,38876,38878,38921,39157,39158,39160,
   39166,39169,39171,39173,39424,39426,39432,39435,39437,39439,
   39460,39466,39469,39471,39473,39531,39534,39536,39538,39705,
   39707,39709,39779,39781,39824,40285,40287,40293,40296,40298,
   40300,40321,40327,40330,40332,40334,40392,40395,40397,40399,
   40566,40568,40570,40640,40642,40685,45256,45262,45265,45267,
   45269,45327,45330,45332,45334,45501,45503,45505,45575,45577,
   45620,45888,45891,45893,45895,46062,46064,46066,46136,46138,
   46181,47086,47088,47090,47160,47162,47205,49520,49522,49565,
   50394],
 [6050,6183,6340,45951,45952,45957,45959,46111,46116,46118,46139,
   46141,46241,48035,48040,48042,48063,48065,48165,50099,50101,
   50201,50454],[6050,6152,45922,46140],
 [6050,6183,6340,45951,45952,45957,45959,46111,46116,46118,46139,
   46141,46241,48035,48040,48042,48063,48065,48165,50099,50101,
   50201,50454],[6050,6213,45981,46142],[6050,46143],
 [6050,46144],
 [5696,5697,5705,5708,5710,5719,6005,6013,6016,6018,6027,6047,
   6050,6052,6286,6288,6297,6360,6412,39424,39432,39435,39437,
   39446,39466,39469,39471,39480,39705,39707,39716,39779,39788,
   39831,45262,45265,45267,45276,45501,45503,45512,45575,45584,
   45627,46062,46064,46073,46136,46145,46188,49520,49529,49572,
   50401],[6050,46146],
 [5696,5697,5705,5708,5710,5721,6005,6013,6016,6018,6029,6047,
   6050,6052,6286,6288,6299,6360,6414,39424,39432,39435,39437,
   39448,39466,39469,39471,39482,39705,39707,39718,39779,39790,
   39833,45262,45265,45267,45278,45501,45503,45514,45575,45586,
   45629,46062,46064,46075,46136,46147,46190,49520,49531,49574,
   50403],[6050,46148],[6050,46149],[6050,46150],
 [5696,5697,5705,5708,5710,5725,6005,6013,6016,6018,6033,6047,
   6050,6052,6286,6288,6303,6360,6418,39424,39432,39435,39437,
   39452,39466,39469,39471,39486,39705,39707,39722,39779,39794,
   39837,45262,45265,45267,45282,45501,45503,45518,45575,45590,
   45633,46062,46064,46079,46136,46151,46194,49520,49535,49578,
   50407],[6050,46152],[6050,46153],[6050,46154],
 [6050,46155],[6050,46156],[6050,46157],
 [5698,5699,5705,5711,5712,6080,6086,6112,6119,6289,6290,39493,
   39499,39505,39506,39531,39537,39538,39708,39709,39844,46416,
   46422,46423,46593,46594,46729,47089,47090,47225,49585],
 [5698,5700,5705,5711,5714,6080,6086,6143,6152,6289,6292,39494,
   39499,39505,39508,39562,39568,39571,39708,39711,39846,46447,
   46453,46593,46596,46731,47554,47557,49587],
 [5698,5701,5705,5711,5715,6080,6086,6173,6183,6289,6293,39495,
   39499,39505,39509,39592,39598,39602,39708,39712,39847,46477,
   46483,46487,46593,46597,46732,47989,47993,48128,49588],
 [5698,5702,5705,5711,5716,6080,6086,6202,6213,6289,6294,39496,
   39499,39505,39510,39621,39627,39632,39708,39713,39848,46506,
   46512,46593,46598,46733,48395,48400,49589],
 [5698,5703,5705,5711,6080,6086,6230,6289,39497,39499,39505,
   39649,39655,39708,46534,46540,46593,48773],
 [5698,5704,5705,5711,6080,6086,6257,6289,39498,39499,39505,
   39676,39682,39708,46561,46567,46593,49124],[5705,46593],
 [5695,5698,5705,5706,5711,5978,5979,6080,6086,6284,6289,39390,
   39397,39398,39403,39499,39500,39505,39703,39708,39733,44700,
   44701,44706,44904,44909,44934,46588,46593,46618,49474],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,
   2384,3500,3501,3507,3510,3512,3517,3518,3519,3523,3525,3526,
   3544,3550,3553,3555,3560,3561,3562,3566,3568,3569,3592,3595,
   3597,3602,3603,3604,3608,3610,3611,3826,3828,3833,3834,3835,
   3839,3841,3842,3930,3935,3936,3937,3941,3998,3999,4000,4004,
   4139,4140,4144,4146,4147,4165,4169,4171,4172,4193,4195,4196,
   4281,4282,4319,4510,4511,4512,4518,4528,4529,5645,5646,5652,
   5655,5657,5662,5663,5664,5668,5670,5671,5689,5695,5698,5700,
   5705,5706,5707,5711,5713,5714,5737,5740,5742,5747,5748,5749,
   5753,5755,5756,5971,5973,5978,5979,5980,5984,5986,5987,6075,
   6080,6081,6086,6089,6143,6144,6145,6149,6151,6152,6284,6285,
   6289,6291,6292,6310,6314,6316,6317,6340,6341,6427,6464,7725,
   7726,7732,7735,7737,7742,7743,7744,7748,7750,7751,7769,7775,
   7778,7780,7785,7786,7787,7791,7793,7794,7817,7820,7822,7827,
   7828,7829,7833,7835,7836,8051,8053,8058,8059,8060,8064,8066,
   8067,8155,8160,8161,8162,8166,8168,8169,8223,8224,8225,8231,
   8364,8365,8369,8371,8372,8390,8394,8396,8397,8420,8506,8507,
   8544,38205,38211,38214,38216,38221,38222,38223,38227,38229,
   38230,38253,38256,38258,38263,38264,38265,38269,38271,38272,
   38487,38489,38494,38495,38496,38500,38502,38503,38591,38596,
   38597,38598,38602,38604,38605,38659,38660,38661,38665,38667,
   38668,38800,38801,38805,38807,38808,38826,38830,38832,38833,
   38854,38856,38857,38942,38943,38980,39156,39159,39161,39166,
   39167,39168,39172,39174,39175,39390,39392,39397,39398,39399,
   39403,39405,39406,39494,39499,39500,39501,39505,39507,39508,
   39562,39563,39564,39568,39570,39571,39703,39704,39708,39710,
   39711,39729,39733,39735,39736,39757,39759,39760,39845,39846,
   39883,40251,40253,40258,40259,40260,40264,40266,40267,40355,
   40360,40361,40362,40366,40368,40369,40423,40424,40425,40429,
   40431,40432,40564,40565,40569,40571,40572,40590,40594,40596,
   40597,40618,40620,40621,40706,40707,40744,44695,44700,44701,
   44702,44706,44708,44709,44763,44764,44765,44769,44771,44772,
   44904,44905,44909,44911,44912,44930,44934,44936,44937,44958,
   44960,44961,45046,45047,45084,46447,46448,46449,46453,46455,
   46456,46588,46589,46593,46595,46596,46614,46618,46620,46621,
   46642,46644,46645,46730,46731,46768,47549,47550,47554,47556,
   47557,47575,47579,47581,47582,47603,47605,47606,47691,47692,
   47729,49470,49474,49476,49477,49498,49500,49501,49586,49587,
   49624,49798,49800,49801,49886,49887,49924,50162,50163,50200,
   51084],
 [5693,5694,5696,5697,5698,5705,5708,5710,5711,5894,5905,5942,
   6005,6013,6016,6018,6047,6050,6052,6080,6086,6286,6288,6289,
   6360,39313,39315,39316,39317,39324,39327,39329,39330,39352,
   39353,39354,39361,39364,39366,39367,39424,39425,39432,39435,
   39437,39438,39459,39466,39469,39471,39472,39499,39502,39504,
   39505,39705,39707,39708,39779,39780,39823,43257,43258,43259,
   43266,43269,43271,43272,43329,43330,43337,43340,43342,43343,
   43364,43371,43374,43376,43377,43404,43407,43409,43410,43610,
   43612,43613,43684,43685,43728,43995,43996,44003,44006,44008,
   44009,44030,44037,44040,44042,44043,44070,44073,44075,44076,
   44276,44278,44279,44350,44351,44394,45255,45262,45265,45267,
   45268,45295,45298,45300,45301,45501,45503,45504,45575,45576,
   45619,45856,45859,45861,45862,46062,46064,46065,46136,46137,
   46180,46590,46592,46593,46664,46665,46708,49520,49521,49564,
   50393],
 [5698,5705,5709,5711,6080,6086,6287,6289,39499,39503,39505,
   39706,39708,39802,46591,46593,46687,49543],
 [5693,5694,5696,5697,5698,5705,5708,5710,5711,5894,5905,5942,
   6005,6013,6016,6018,6047,6050,6052,6080,6086,6286,6288,6289,
   6360,39313,39315,39316,39317,39324,39327,39329,39330,39352,
   39353,39354,39361,39364,39366,39367,39424,39425,39432,39435,
   39437,39438,39459,39466,39469,39471,39472,39499,39502,39504,
   39505,39705,39707,39708,39779,39780,39823,43257,43258,43259,
   43266,43269,43271,43272,43329,43330,43337,43340,43342,43343,
   43364,43371,43374,43376,43377,43404,43407,43409,43410,43610,
   43612,43613,43684,43685,43728,43995,43996,44003,44006,44008,
   44009,44030,44037,44040,44042,44043,44070,44073,44075,44076,
   44276,44278,44279,44350,44351,44394,45255,45262,45265,45267,
   45268,45295,45298,45300,45301,45501,45503,45504,45575,45576,
   45619,45856,45859,45861,45862,46062,46064,46065,46136,46137,
   46180,46590,46592,46593,46664,46665,46708,49520,49521,49564,
   50393],[5705,46593],
 [5698,5699,5705,5711,5712,6080,6086,6112,6119,6289,6290,39493,
   39499,39505,39506,39531,39537,39538,39708,39709,39844,46416,
   46422,46423,46593,46594,46729,47089,47090,47225,49585],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,
   2384,3500,3501,3507,3510,3512,3517,3518,3519,3523,3525,3526,
   3544,3550,3553,3555,3560,3561,3562,3566,3568,3569,3592,3595,
   3597,3602,3603,3604,3608,3610,3611,3826,3828,3833,3834,3835,
   3839,3841,3842,3930,3935,3936,3937,3941,3998,3999,4000,4004,
   4139,4140,4144,4146,4147,4165,4169,4171,4172,4193,4195,4196,
   4281,4282,4319,4510,4511,4512,4518,4528,4529,5645,5646,5652,
   5655,5657,5662,5663,5664,5668,5670,5671,5689,5695,5698,5700,
   5705,5706,5707,5711,5713,5714,5737,5740,5742,5747,5748,5749,
   5753,5755,5756,5971,5973,5978,5979,5980,5984,5986,5987,6075,
   6080,6081,6086,6089,6143,6144,6145,6149,6151,6152,6284,6285,
   6289,6291,6292,6310,6314,6316,6317,6340,6341,6427,6464,7725,
   7726,7732,7735,7737,7742,7743,7744,7748,7750,7751,7769,7775,
   7778,7780,7785,7786,7787,7791,7793,7794,7817,7820,7822,7827,
   7828,7829,7833,7835,7836,8051,8053,8058,8059,8060,8064,8066,
   8067,8155,8160,8161,8162,8166,8168,8169,8223,8224,8225,8231,
   8364,8365,8369,8371,8372,8390,8394,8396,8397,8420,8506,8507,
   8544,38205,38211,38214,38216,38221,38222,38223,38227,38229,
   38230,38253,38256,38258,38263,38264,38265,38269,38271,38272,
   38487,38489,38494,38495,38496,38500,38502,38503,38591,38596,
   38597,38598,38602,38604,38605,38659,38660,38661,38665,38667,
   38668,38800,38801,38805,38807,38808,38826,38830,38832,38833,
   38854,38856,38857,38942,38943,38980,39156,39159,39161,39166,
   39167,39168,39172,39174,39175,39390,39392,39397,39398,39399,
   39403,39405,39406,39494,39499,39500,39501,39505,39507,39508,
   39562,39563,39564,39568,39570,39571,39703,39704,39708,39710,
   39711,39729,39733,39735,39736,39757,39759,39760,39845,39846,
   39883,40251,40253,40258,40259,40260,40264,40266,40267,40355,
   40360,40361,40362,40366,40368,40369,40423,40424,40425,40429,
   40431,40432,40564,40565,40569,40571,40572,40590,40594,40596,
   40597,40618,40620,40621,40706,40707,40744,44695,44700,44701,
   44702,44706,44708,44709,44763,44764,44765,44769,44771,44772,
   44904,44905,44909,44911,44912,44930,44934,44936,44937,44958,
   44960,44961,45046,45047,45084,46447,46448,46449,46453,46455,
   46456,46588,46589,46593,46595,46596,46614,46618,46620,46621,
   46642,46644,46645,46730,46731,46768,47549,47550,47554,47556,
   47557,47575,47579,47581,47582,47603,47605,47606,47691,47692,
   47729,49470,49474,49476,49477,49498,49500,49501,49586,49587,
   49624,49798,49800,49801,49886,49887,49924,50162,50163,50200,
   51084],
 [5698,5700,5705,5711,5714,6080,6086,6143,6152,6289,6292,39494,
   39499,39505,39508,39562,39568,39571,39708,39711,39846,46447,
   46453,46593,46596,46731,47554,47557,49587],
 [5698,5701,5705,5711,5715,6080,6086,6173,6183,6289,6293,39495,
   39499,39505,39509,39592,39598,39602,39708,39712,39847,46477,
   46483,46487,46593,46597,46732,47989,47993,48128,49588],
 [5698,5702,5705,5711,5716,6080,6086,6202,6213,6289,6294,39496,
   39499,39505,39510,39621,39627,39632,39708,39713,39848,46506,
   46512,46593,46598,46733,48395,48400,49589],
 [5698,5705,5711,5717,6080,6086,6289,6295,39499,39505,39511,
   39708,39714,39849,46593,46599,46734,49590],
 [5698,5705,5711,5718,6080,6086,6289,6296,39499,39505,39512,
   39708,39715,39850,46593,46600,46735,49591],
 [5698,5705,5711,5719,6080,6086,6289,6297,39499,39505,39513,
   39708,39716,39851,46593,46601,46736,49592],
 [5698,5705,5711,5720,6080,6086,6289,6298,39499,39505,39514,
   39708,39717,39852,46593,46602,46737,49593],
 [5698,5705,5711,5721,6080,6086,6289,6299,39499,39505,39515,
   39708,39718,39853,46593,46603,46738,49594],
 [5698,5705,5711,5722,6080,6086,6289,6300,39499,39505,39516,
   39708,39719,39854,46593,46604,46739,49595],
 [5698,5705,5711,5723,6080,6086,6289,6301,39499,39505,39517,
   39708,39720,39855,46593,46605,46740,49596],
 [5698,5705,5711,5724,6080,6086,6289,6302,39499,39505,39518,
   39708,39721,39856,46593,46606,46741,49597],
 [5698,5705,5711,5725,6080,6086,6289,6303,39499,39505,39519,
   39708,39722,39857,46593,46607,46742,49598],
 [5698,5705,5711,5726,6080,6086,6289,6304,39499,39505,39520,
   39708,39723,39858,46593,46608,46743,49599],
 [5698,5705,5711,5727,6080,6086,6289,6305,39499,39505,39521,
   39708,39724,39859,46593,46609,46744,49600],
 [5698,5705,5711,5728,6080,6086,6289,6306,39499,39505,39522,
   39708,39725,39860,46593,46610,46745,49601],
 [5698,5705,5711,5729,6080,6086,6289,6307,39499,39505,39523,
   39708,39726,39861,46593,46611,46746,49602],
 [5698,5705,5711,5730,6080,6086,6289,6308,39499,39505,39524,
   39708,39727,39862,46593,46612,46747,49603],
 [5698,5705,5711,5731,6080,6086,6289,6309,39499,39505,39525,
   39708,39728,39863,46593,46613,46748,49604],
 [5699,5700,5705,5712,5714,6112,6119,6143,6152,6290,6292,39526,
   39531,39538,39540,39562,39569,39571,39709,39711,39865,46943,
   46950,47090,47092,47246,47555,47557,49606],
 [5699,5701,5705,5712,5715,6112,6119,6173,6183,6290,6293,39527,
   39531,39538,39541,39592,39599,39602,39709,39712,39866,46973,
   46980,46983,47090,47093,47247,47990,47993,48147,49607],
 [5699,5702,5705,5707,5712,5713,5716,6112,6119,6202,6213,6285,
   6290,6291,6294,6340,39528,39531,39533,39538,39539,39542,
   39621,39623,39628,39629,39632,39704,39709,39710,39713,39758,
   39759,39762,39864,39867,39885,47002,47004,47009,47085,47090,
   47091,47094,47139,47140,47143,47245,47248,47266,48391,48396,
   48397,48400,48445,48446,48551,49499,49500,49503,49605,49608,
   49626,50181,50202,51257],
 [5699,5703,5705,5712,6112,6119,6230,6290,39529,39531,39538,
   39649,39656,39709,47030,47037,47090,48774],
 [5699,5704,5705,5712,6112,6119,6257,6290,39530,39531,39538,
   39676,39683,39709,47057,47064,47090,49125],[5705,47090],
 [5692,5695,5699,5705,5706,5712,5867,5978,5979,6112,6119,6284,
   6290,39276,39280,39286,39287,39293,39391,39397,39398,39404,
   39531,39532,39538,39703,39709,39734,42593,42599,42600,42606,
   42733,42734,42740,42905,42911,42936,44732,44733,44739,44904,
   44910,44935,47084,47090,47115,49475],
 [5699,5702,5705,5707,5712,5713,5716,6112,6119,6202,6213,6285,
   6290,6291,6294,6340,39528,39531,39533,39538,39539,39542,
   39621,39623,39628,39629,39632,39704,39709,39710,39713,39758,
   39759,39762,39864,39867,39885,47002,47004,47009,47085,47090,
   47091,47094,47139,47140,47143,47245,47248,47266,48391,48396,
   48397,48400,48445,48446,48551,49499,49500,49503,49605,49608,
   49626,50181,50202,51257],
 [5645,5646,5662,5689,5696,5697,5699,5705,5708,5710,5712,5747,
   6005,6013,6016,6018,6047,6050,6052,6112,6119,6286,6288,6290,
   6360,38205,38212,38213,38215,38221,38224,38226,38228,38254,
   38255,38257,38263,38266,38268,38270,38521,38523,38529,38532,
   38534,38536,38557,38563,38566,38568,38570,38628,38631,38633,
   38635,38802,38804,38806,38876,38878,38921,39157,39158,39160,
   39166,39169,39171,39173,39424,39426,39432,39435,39437,39439,
   39460,39466,39469,39471,39473,39531,39534,39536,39538,39705,
   39707,39709,39779,39781,39824,40285,40287,40293,40296,40298,
   40300,40321,40327,40330,40332,40334,40392,40395,40397,40399,
   40566,40568,40570,40640,40642,40685,45256,45262,45265,45267,
   45269,45327,45330,45332,45334,45501,45503,45505,45575,45577,
   45620,45888,45891,45893,45895,46062,46064,46066,46136,46138,
   46181,47086,47088,47090,47160,47162,47205,49520,49522,49565,
   50394],
 [5699,5705,5709,5712,6112,6119,6287,6290,39531,39535,39538,
   39706,39709,39803,47087,47090,47184,49544],
 [5645,5646,5662,5689,5696,5697,5699,5705,5708,5710,5712,5747,
   6005,6013,6016,6018,6047,6050,6052,6112,6119,6286,6288,6290,
   6360,38205,38212,38213,38215,38221,38224,38226,38228,38254,
   38255,38257,38263,38266,38268,38270,38521,38523,38529,38532,
   38534,38536,38557,38563,38566,38568,38570,38628,38631,38633,
   38635,38802,38804,38806,38876,38878,38921,39157,39158,39160,
   39166,39169,39171,39173,39424,39426,39432,39435,39437,39439,
   39460,39466,39469,39471,39473,39531,39534,39536,39538,39705,
   39707,39709,39779,39781,39824,40285,40287,40293,40296,40298,
   40300,40321,40327,40330,40332,40334,40392,40395,40397,40399,
   40566,40568,40570,40640,40642,40685,45256,45262,45265,45267,
   45269,45327,45330,45332,45334,45501,45503,45505,45575,45577,
   45620,45888,45891,45893,45895,46062,46064,46066,46136,46138,
   46181,47086,47088,47090,47160,47162,47205,49520,49522,49565,
   50394],
 [5698,5699,5705,5711,5712,6080,6086,6112,6119,6289,6290,39493,
   39499,39505,39506,39531,39537,39538,39708,39709,39844,46416,
   46422,46423,46593,46594,46729,47089,47090,47225,49585],
 [5705,47090],
 [5699,5702,5705,5707,5712,5713,5716,6112,6119,6202,6213,6285,
   6290,6291,6294,6340,39528,39531,39533,39538,39539,39542,
   39621,39623,39628,39629,39632,39704,39709,39710,39713,39758,
   39759,39762,39864,39867,39885,47002,47004,47009,47085,47090,
   47091,47094,47139,47140,47143,47245,47248,47266,48391,48396,
   48397,48400,48445,48446,48551,49499,49500,49503,49605,49608,
   49626,50181,50202,51257],
 [5699,5700,5705,5712,5714,6112,6119,6143,6152,6290,6292,39526,
   39531,39538,39540,39562,39569,39571,39709,39711,39865,46943,
   46950,47090,47092,47246,47555,47557,49606],
 [5699,5701,5705,5712,5715,6112,6119,6173,6183,6290,6293,39527,
   39531,39538,39541,39592,39599,39602,39709,39712,39866,46973,
   46980,46983,47090,47093,47247,47990,47993,48147,49607],
 [5699,5702,5705,5707,5712,5713,5716,6112,6119,6202,6213,6285,
   6290,6291,6294,6340,39528,39531,39533,39538,39539,39542,
   39621,39623,39628,39629,39632,39704,39709,39710,39713,39758,
   39759,39762,39864,39867,39885,47002,47004,47009,47085,47090,
   47091,47094,47139,47140,47143,47245,47248,47266,48391,48396,
   48397,48400,48445,48446,48551,49499,49500,49503,49605,49608,
   49626,50181,50202,51257],
 [5699,5705,5712,5717,5719,6112,6119,6290,6295,6297,39531,39538,
   39543,39545,39709,39714,39716,39868,39870,39950,47090,47095,
   47097,47249,47251,47331,49609,49611,49691,51322],
 [5699,5705,5712,5718,6112,6119,6290,6296,39531,39538,39544,
   39709,39715,39869,47090,47096,47250,49610],
 [5699,5705,5712,5717,5719,6112,6119,6290,6295,6297,39531,39538,
   39543,39545,39709,39714,39716,39868,39870,39950,47090,47095,
   47097,47249,47251,47331,49609,49611,49691,51322],
 [5699,5705,5712,5720,6112,6119,6290,6298,39531,39538,39546,
   39709,39717,39871,47090,47098,47252,49612],
 [5699,5705,5712,5721,6112,6119,6290,6299,39531,39538,39547,
   39709,39718,39872,47090,47099,47253,49613],
 [5699,5705,5712,5722,6112,6119,6290,6300,39531,39538,39548,
   39709,39719,39873,47090,47100,47254,49614],
 [5699,5705,5712,5723,5724,6112,6119,6290,6301,6302,39531,39538,
   39549,39550,39709,39720,39721,39874,39875,40018,47090,47101,
   47102,47255,47256,47399,49615,49616,49759,51390],
 [5699,5705,5712,5723,5724,6112,6119,6290,6301,6302,39531,39538,
   39549,39550,39709,39720,39721,39874,39875,40018,47090,47101,
   47102,47255,47256,47399,49615,49616,49759,51390],
 [5699,5705,5712,5725,6112,6119,6290,6303,39531,39538,39551,
   39709,39722,39876,47090,47103,47257,49617],
 [5699,5705,5712,5726,6112,6119,6290,6304,39531,39538,39552,
   39709,39723,39877,47090,47104,47258,49618],
 [5699,5705,5712,5727,6112,6119,6290,6305,39531,39538,39553,
   39709,39724,39878,47090,47105,47259,49619],
 [5699,5705,5712,5728,6112,6119,6290,6306,39531,39538,39554,
   39709,39725,39879,47090,47106,47260,49620],
 [5699,5705,5712,5729,5731,6112,6119,6290,6307,6309,39531,39538,
   39555,39557,39709,39726,39728,39880,39882,40052,47090,47107,
   47109,47261,47263,47433,49621,49623,49793,51424],
 [5699,5705,5712,5730,6112,6119,6290,6308,39531,39538,39556,
   39709,39727,39881,47090,47108,47262,49622],
 [5699,5705,5712,5729,5731,6112,6119,6290,6307,6309,39531,39538,
   39555,39557,39709,39726,39728,39880,39882,40052,47090,47107,
   47109,47261,47263,47433,49621,49623,49793,51424],
 [5690,5691,5700,5701,5705,5714,5715,5774,5788,5828,6143,6152,
   6173,6183,6292,6293,39193,39202,39203,39207,39216,39217,
   39242,39243,39247,39256,39257,39558,39562,39571,39572,39592,
   39601,39602,39711,39712,39901,40923,40924,40928,40937,40938,
   41239,41243,41253,41273,41283,41392,41393,41582,42019,42023,
   42053,42062,42063,42172,42173,42362,47438,47448,47557,47558,
   47992,47993,48182,49642],[6152,6213,42761,43104],[6152],
 [6152],[5705,6152],
 [5695,5700,5705,5706,5707,5713,5714,5978,5979,6143,6152,6284,
   6285,6291,6292,6340,39392,39397,39398,39399,39405,39406,
   39562,39563,39564,39570,39571,39703,39704,39710,39711,39729,
   39735,39736,39759,39760,39883,44763,44764,44765,44904,44905,
   44911,44912,44930,44936,44937,44960,44961,45084,47549,47550,
   47556,47557,47575,47581,47605,49470,49476,49477,49500,49501,
   49624,49800,49924,50200],
 [5695,5700,5705,5706,5707,5713,5714,5978,5979,6143,6152,6284,
   6285,6291,6292,6340,39392,39397,39398,39399,39405,39406,
   39562,39563,39564,39570,39571,39703,39704,39710,39711,39729,
   39735,39736,39759,39760,39883,44763,44764,44765,44904,44905,
   44911,44912,44930,44936,44937,44960,44961,45084,47549,47550,
   47556,47557,47575,47581,47605,49470,49476,49477,49500,49501,
   49624,49800,49924,50200],[6050,6152,45922,46140],[6152],
 [5696,5697,5700,5705,5708,5710,5714,6005,6013,6016,6018,6042,
   6047,6050,6052,6056,6143,6146,6152,6286,6288,6292,6360,6364,
   39424,39427,39432,39435,39437,39441,39461,39466,39469,39471,
   39475,39562,39565,39567,39571,39705,39707,39711,39779,39783,
   39826,45257,45262,45265,45267,45271,45358,45361,45363,45501,
   45503,45507,45575,45579,45622,45919,45922,45924,45928,46062,
   46064,46068,46136,46140,46183,47551,47553,47557,47625,47629,
   49520,49524,49567,50396],
 [5698,5700,5705,5711,5714,6080,6086,6143,6152,6289,6292,39494,
   39499,39505,39508,39562,39568,39571,39708,39711,39846,46447,
   46453,46593,46596,46731,47554,47557,49587],
 [5699,5700,5705,5712,5714,6112,6119,6143,6152,6290,6292,39526,
   39531,39538,39540,39562,39569,39571,39709,39711,39865,46943,
   46950,47090,47092,47246,47555,47557,49606],
 [5695,5700,5705,5706,5707,5713,5714,5978,5979,6143,6152,6284,
   6285,6291,6292,6340,39392,39397,39398,39399,39405,39406,
   39562,39563,39564,39570,39571,39703,39704,39710,39711,39729,
   39735,39736,39759,39760,39883,44763,44764,44765,44904,44905,
   44911,44912,44930,44936,44937,44960,44961,45084,47549,47550,
   47556,47557,47575,47581,47605,49470,49476,49477,49500,49501,
   49624,49800,49924,50200],[],
 [5690,5691,5700,5701,5705,5714,5715,5774,5788,5828,6143,6152,
   6173,6183,6292,6293,39193,39202,39203,39207,39216,39217,
   39242,39243,39247,39256,39257,39558,39562,39571,39572,39592,
   39601,39602,39711,39712,39901,40923,40924,40928,40937,40938,
   41239,41243,41253,41273,41283,41392,41393,41582,42019,42023,
   42053,42062,42063,42172,42173,42362,47438,47448,47557,47558,
   47992,47993,48182,49642],[6152,6213,42761,43104],[6152],
 [6152],[6152],[6152],[6152],[6152],[6152],[6152],
 [6152],[6152],[6152],[6152],[6152],[6152],[6152],
 [5645,5646,5662,5689,5701,5702,5705,5715,5716,5747,6173,6183,
   6202,6213,6293,6294,38205,38217,38218,38221,38231,38232,
   38259,38260,38263,38273,38274,38686,38689,38699,38700,38718,
   38809,38810,39015,39162,39163,39166,39176,39177,39589,39592,
   39602,39603,39621,39631,39632,39712,39713,39918,40450,40453,
   40463,40482,40492,40573,40574,40779,47902,47912,47993,47994,
   48199,48399,48400,49659],[6183,47940],[6183,47967],
 [5705,6183,39602,47993],
 [5695,5701,5705,5706,5715,5978,5979,6173,6183,6284,6293,39393,
   39397,39398,39407,39592,39593,39602,39703,39712,39737,44793,
   44794,44803,44904,44913,44938,47984,47993,48018,49478],
 [6050,6183,6340,45951,45952,45957,45959,46111,46116,46118,46139,
   46141,46241,48035,48040,48042,48063,48065,48165,50099,50101,
   50201,50454],
 [6050,6183,6340,45951,45952,45957,45959,46111,46116,46118,46139,
   46141,46241,48035,48040,48042,48063,48065,48165,50099,50101,
   50201,50454],[6183,48087],
 [6018,6183,45393,45398,45623,48108],
 [5698,5701,5705,5711,5715,6080,6086,6173,6183,6289,6293,39495,
   39499,39505,39509,39592,39598,39602,39708,39712,39847,46477,
   46483,46487,46593,46597,46732,47989,47993,48128,49588],
 [5699,5701,5705,5712,5715,6112,6119,6173,6183,6290,6293,39527,
   39531,39538,39541,39592,39599,39602,39709,39712,39866,46973,
   46980,46983,47090,47093,47247,47990,47993,48147,49607],
 [6050,6183,6340,45951,45952,45957,45959,46111,46116,46118,46139,
   46141,46241,48035,48040,48042,48063,48065,48165,50099,50101,
   50201,50454],
 [5690,5691,5700,5701,5705,5714,5715,5774,5788,5828,6143,6152,
   6173,6183,6292,6293,39193,39202,39203,39207,39216,39217,
   39242,39243,39247,39256,39257,39558,39562,39571,39572,39592,
   39601,39602,39711,39712,39901,40923,40924,40928,40937,40938,
   41239,41243,41253,41273,41283,41392,41393,41582,42019,42023,
   42053,42062,42063,42172,42173,42362,47438,47448,47557,47558,
   47992,47993,48182,49642],[],
 [5645,5646,5662,5689,5701,5702,5705,5715,5716,5747,6173,6183,
   6202,6213,6293,6294,38205,38217,38218,38221,38231,38232,
   38259,38260,38263,38273,38274,38686,38689,38699,38700,38718,
   38809,38810,39015,39162,39163,39166,39176,39177,39589,39592,
   39602,39603,39621,39631,39632,39712,39713,39918,40450,40453,
   40463,40482,40492,40573,40574,40779,47902,47912,47993,47994,
   48199,48399,48400,49659],[6183,48200],[6183,48201],
 [6183,48202],[6183,48203],[6183,48204],[6183,48205],
 [6183,48206],[6183,48207],[6183,48208],[6183,48209],
 [6183,48210],[6183,48211],[6183,48212],[6183,48213],
 [6183,48214],[6213],[6213],[5705,6213],
 [5695,5702,5705,5706,5716,5978,5979,6202,6213,6284,6294,39394,
   39397,39398,39408,39621,39622,39632,39703,39713,39738,44822,
   44823,44904,44914,44939,48390,48400,49479],
 [5699,5702,5705,5707,5712,5713,5716,6112,6119,6202,6213,6285,
   6290,6291,6294,6340,39528,39531,39533,39538,39539,39542,
   39621,39623,39628,39629,39632,39704,39709,39710,39713,39758,
   39759,39762,39864,39867,39885,47002,47004,47009,47085,47090,
   47091,47094,47139,47140,47143,47245,47248,47266,48391,48396,
   48397,48400,48445,48446,48551,49499,49500,49503,49605,49608,
   49626,50181,50202,51257],[6050,6213,45981,46142],[6213],
 [5696,5697,5702,5705,5708,5710,5716,6005,6013,6016,6018,6044,
   6047,6050,6052,6058,6202,6205,6213,6286,6288,6294,6360,6366,
   39424,39429,39432,39435,39437,39443,39463,39466,39469,39471,
   39477,39621,39624,39626,39632,39705,39707,39713,39779,39785,
   39828,45259,45262,45265,45267,45273,45417,45420,45422,45501,
   45503,45509,45575,45581,45624,45978,45981,45983,45989,46062,
   46064,46070,46136,46142,46185,48392,48394,48400,48466,48472,
   49520,49526,49569,50398],
 [5698,5702,5705,5711,5716,6080,6086,6202,6213,6289,6294,39496,
   39499,39505,39510,39621,39627,39632,39708,39713,39848,46506,
   46512,46593,46598,46733,48395,48400,49589],
 [5699,5702,5705,5707,5712,5713,5716,6112,6119,6202,6213,6285,
   6290,6291,6294,6340,39528,39531,39533,39538,39539,39542,
   39621,39623,39628,39629,39632,39704,39709,39710,39713,39758,
   39759,39762,39864,39867,39885,47002,47004,47009,47085,47090,
   47091,47094,47139,47140,47143,47245,47248,47266,48391,48396,
   48397,48400,48445,48446,48551,49499,49500,49503,49605,49608,
   49626,50181,50202,51257],
 [5699,5702,5705,5707,5712,5713,5716,6112,6119,6202,6213,6285,
   6290,6291,6294,6340,39528,39531,39533,39538,39539,39542,
   39621,39623,39628,39629,39632,39704,39709,39710,39713,39758,
   39759,39762,39864,39867,39885,47002,47004,47009,47085,47090,
   47091,47094,47139,47140,47143,47245,47248,47266,48391,48396,
   48397,48400,48445,48446,48551,49499,49500,49503,49605,49608,
   49626,50181,50202,51257],[6152,6213,42761,43104],
 [5645,5646,5662,5689,5701,5702,5705,5715,5716,5747,6173,6183,
   6202,6213,6293,6294,38205,38217,38218,38221,38231,38232,
   38259,38260,38263,38273,38274,38686,38689,38699,38700,38718,
   38809,38810,39015,39162,39163,39166,39176,39177,39589,39592,
   39602,39603,39621,39631,39632,39712,39713,39918,40450,40453,
   40463,40482,40492,40573,40574,40779,47902,47912,47993,47994,
   48199,48399,48400,49659],[],[6213],[6213],[6213],
 [6213],[6213],[6213],[6213],[6213],[6213],[6213],
 [6213],[6213],[6213],[6213],[6213],
 [5690,5691,5703,5704,5705,5774,5788,5828,6230,6257,39193,39205,
   39206,39207,39245,39246,39247,39648,39649,39676,40926,40927,
   40928,41329,41330,41357,42109,42110,42137,48741],[5705],
 [5695,5703,5705,5706,5709,5978,5979,6230,6284,6287,39395,39397,
   39398,39401,39649,39650,39653,39703,39706,39731,44850,44851,
   44854,44904,44907,44932,48768,48771,48796,49472],
 [6340,48824],
 [5696,5697,5703,5705,5708,5710,6005,6011,6013,6016,6018,6047,
   6050,6052,6230,6235,6286,6288,6360,39424,39430,39432,39435,
   39437,39464,39466,39469,39471,39649,39652,39654,39705,39707,
   39779,45260,45262,45265,45267,45445,45448,45450,45501,45503,
   45575,46006,46009,46011,46062,46064,46136,48770,48772,48844,
   49520],
 [5695,5703,5705,5706,5709,5978,5979,6230,6284,6287,39395,39397,
   39398,39401,39649,39650,39653,39703,39706,39731,44850,44851,
   44854,44904,44907,44932,48768,48771,48796,49472],
 [6018,45450],
 [5698,5703,5705,5711,6080,6086,6230,6289,39497,39499,39505,
   39649,39655,39708,46534,46540,46593,48773],
 [5699,5703,5705,5712,6112,6119,6230,6290,39529,39531,39538,
   39649,39656,39709,47030,47037,47090,48774],[6340,48824],
 [6152],[6183,47940],[6213],[],[],[],
 [5703,5705,5720,6230,6298,39649,39664,39717,48782],[],[],
 [],[],[],
 [5703,5705,5726,6230,6304,39649,39670,39723,48788],
 [5703,5705,5727,6230,6305,39649,39671,39724,48789],
 [5703,5705,5728,6230,6306,39649,39672,39725,48790],[],[],
 [],[5705],
 [5695,5704,5705,5706,5978,5979,6257,6284,39396,39397,39398,
   39676,39677,39703,44877,44878,44904,49119],[6340,49175],
 [6050,46036],[6018,45476,45477,45597,49217],
 [6018,45476,45477,45597,49217],
 [5698,5704,5705,5711,6080,6086,6257,6289,39498,39499,39505,
   39676,39682,39708,46561,46567,46593,49124],
 [5699,5704,5705,5712,6112,6119,6257,6290,39530,39531,39538,
   39676,39683,39709,47057,47064,47090,49125],[6340,49175],
 [6152],[6183,47967],[6213],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[5705,44904],
 [5705,6340,39759,49500],
 [5705,6018,6050,39424,39779,45501,46064],[5705],
 [5705,6018,6050,39424,39779,45501,46064],[5705,46593],
 [5705,47090],[5705,6340,39759,49500],[5705,6152],
 [5705,6183,39602,47993],[5705,6213],[5705],[5705],[5705],
 [5705],[5705],[5705],[5705],[5705],[5705],[5705],
 [5705],[5705],[5705],[5705],[5705],
 [5695,5700,5705,5706,5707,5713,5714,5978,5979,6143,6152,6284,
   6285,6291,6292,6340,39392,39397,39398,39399,39405,39406,
   39562,39563,39564,39570,39571,39703,39704,39710,39711,39729,
   39735,39736,39759,39760,39883,44763,44764,44765,44904,44905,
   44911,44912,44930,44936,44937,44960,44961,45084,47549,47550,
   47556,47557,47575,47581,47605,49470,49476,49477,49500,49501,
   49624,49800,49924,50200],
 [5690,5691,5695,5696,5697,5705,5706,5708,5710,5774,5788,5828,
   5978,5979,6005,6013,6016,6018,6047,6050,6052,6284,6286,6288,
   6360,39193,39197,39198,39199,39207,39208,39210,39212,39237,
   39238,39239,39247,39248,39250,39252,39388,39389,39397,39398,
   39400,39402,39424,39432,39433,39435,39437,39466,39467,39469,
   39471,39703,39705,39707,39730,39732,39779,40918,40919,40920,
   40928,40929,40931,40933,41069,41070,41078,41079,41081,41083,
   41105,41113,41114,41116,41118,41147,41148,41150,41152,41384,
   41386,41388,41411,41413,41460,41849,41850,41858,41859,41861,
   41863,41885,41893,41894,41896,41898,41927,41928,41930,41932,
   42164,42166,42168,42191,42193,42240,44625,44633,44634,44636,
   44638,44667,44668,44670,44672,44904,44906,44908,44931,44933,
   44980,45262,45263,45265,45267,45499,45501,45503,45526,45528,
   45575,46060,46062,46064,46087,46089,46136,49471,49473,49520,
   49820],
 [5695,5703,5705,5706,5709,5978,5979,6230,6284,6287,39395,39397,
   39398,39401,39649,39650,39653,39703,39706,39731,44850,44851,
   44854,44904,44907,44932,48768,48771,48796,49472],
 [5690,5691,5695,5696,5697,5705,5706,5708,5710,5774,5788,5828,
   5978,5979,6005,6013,6016,6018,6047,6050,6052,6284,6286,6288,
   6360,39193,39197,39198,39199,39207,39208,39210,39212,39237,
   39238,39239,39247,39248,39250,39252,39388,39389,39397,39398,
   39400,39402,39424,39432,39433,39435,39437,39466,39467,39469,
   39471,39703,39705,39707,39730,39732,39779,40918,40919,40920,
   40928,40929,40931,40933,41069,41070,41078,41079,41081,41083,
   41105,41113,41114,41116,41118,41147,41148,41150,41152,41384,
   41386,41388,41411,41413,41460,41849,41850,41858,41859,41861,
   41863,41885,41893,41894,41896,41898,41927,41928,41930,41932,
   42164,42166,42168,42191,42193,42240,44625,44633,44634,44636,
   44638,44667,44668,44670,44672,44904,44906,44908,44931,44933,
   44980,45262,45263,45265,45267,45499,45501,45503,45526,45528,
   45575,46060,46062,46064,46087,46089,46136,49471,49473,49520,
   49820],
 [5695,5698,5705,5706,5711,5978,5979,6080,6086,6284,6289,39390,
   39397,39398,39403,39499,39500,39505,39703,39708,39733,44700,
   44701,44706,44904,44909,44934,46588,46593,46618,49474],
 [5692,5695,5699,5705,5706,5712,5867,5978,5979,6112,6119,6284,
   6290,39276,39280,39286,39287,39293,39391,39397,39398,39404,
   39531,39532,39538,39703,39709,39734,42593,42599,42600,42606,
   42733,42734,42740,42905,42911,42936,44732,44733,44739,44904,
   44910,44935,47084,47090,47115,49475],
 [5695,5700,5705,5706,5707,5713,5714,5978,5979,6143,6152,6284,
   6285,6291,6292,6340,39392,39397,39398,39399,39405,39406,
   39562,39563,39564,39570,39571,39703,39704,39710,39711,39729,
   39735,39736,39759,39760,39883,44763,44764,44765,44904,44905,
   44911,44912,44930,44936,44937,44960,44961,45084,47549,47550,
   47556,47557,47575,47581,47605,49470,49476,49477,49500,49501,
   49624,49800,49924,50200],
 [5695,5700,5705,5706,5707,5713,5714,5978,5979,6143,6152,6284,
   6285,6291,6292,6340,39392,39397,39398,39399,39405,39406,
   39562,39563,39564,39570,39571,39703,39704,39710,39711,39729,
   39735,39736,39759,39760,39883,44763,44764,44765,44904,44905,
   44911,44912,44930,44936,44937,44960,44961,45084,47549,47550,
   47556,47557,47575,47581,47605,49470,49476,49477,49500,49501,
   49624,49800,49924,50200],
 [5695,5701,5705,5706,5715,5978,5979,6173,6183,6284,6293,39393,
   39397,39398,39407,39592,39593,39602,39703,39712,39737,44793,
   44794,44803,44904,44913,44938,47984,47993,48018,49478],
 [5695,5702,5705,5706,5716,5978,5979,6202,6213,6284,6294,39394,
   39397,39398,39408,39621,39622,39632,39703,39713,39738,44822,
   44823,44904,44914,44939,48390,48400,49479],
 [5695,5705,5706,5717,5978,5979,6284,6295,39397,39398,39409,
   39703,39714,39739,44904,44915,44940,49480],
 [5695,5705,5706,5718,5978,5979,6284,6296,39397,39398,39410,
   39703,39715,39740,44904,44916,44941,49481],
 [5695,5705,5706,5719,5978,5979,6284,6297,39397,39398,39411,
   39703,39716,39741,44904,44917,44942,49482],
 [5695,5705,5706,5720,5978,5979,6284,6298,39397,39398,39412,
   39703,39717,39742,44904,44918,44943,49483],
 [5695,5705,5706,5721,5728,5978,5979,6284,6299,6306,39397,39398,
   39413,39420,39703,39718,39725,39743,39750,40005,44904,44919,
   44926,44944,44951,45206,49484,49491,49746,50046],
 [5695,5705,5706,5722,5978,5979,6284,6300,39397,39398,39414,
   39703,39719,39744,44904,44920,44945,49485],
 [5695,5705,5706,5723,5978,5979,6284,6301,39397,39398,39415,
   39703,39720,39745,44904,44921,44946,49486],
 [5695,5705,5706,5724,5978,5979,6284,6302,39397,39398,39416,
   39703,39721,39746,44904,44922,44947,49487],
 [5695,5705,5706,5725,5727,5978,5979,6284,6303,6305,39397,39398,
   39417,39419,39703,39722,39724,39747,39749,40034,44904,44923,
   44925,44948,44950,45235,49488,49490,49775,50075],
 [5695,5705,5706,5726,5978,5979,6284,6304,39397,39398,39418,
   39703,39723,39748,44904,44924,44949,49489],
 [5695,5705,5706,5725,5727,5978,5979,6284,6303,6305,39397,39398,
   39417,39419,39703,39722,39724,39747,39749,40034,44904,44923,
   44925,44948,44950,45235,49488,49490,49775,50075],
 [5695,5705,5706,5721,5728,5978,5979,6284,6299,6306,39397,39398,
   39413,39420,39703,39718,39725,39743,39750,40005,44904,44919,
   44926,44944,44951,45206,49484,49491,49746,50046],
 [5695,5705,5706,5729,5978,5979,6284,6307,39397,39398,39421,
   39703,39726,39751,44904,44927,44952,49492],
 [5695,5705,5706,5730,5978,5979,6284,6308,39397,39398,39422,
   39703,39727,39752,44904,44928,44953,49493],
 [5695,5705,5706,5731,5978,5979,6284,6309,39397,39398,39423,
   39703,39728,39753,44904,44929,44954,49494],
 [6050,6183,6340,45951,45952,45957,45959,46111,46116,46118,46139,
   46141,46241,48035,48040,48042,48063,48065,48165,50099,50101,
   50201,50454],[6340,50121],
 [6018,6340,45552,45555,45621,50142],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,
   2384,3500,3501,3507,3510,3512,3517,3518,3519,3523,3525,3526,
   3544,3550,3553,3555,3560,3561,3562,3566,3568,3569,3592,3595,
   3597,3602,3603,3604,3608,3610,3611,3826,3828,3833,3834,3835,
   3839,3841,3842,3930,3935,3936,3937,3941,3998,3999,4000,4004,
   4139,4140,4144,4146,4147,4165,4169,4171,4172,4193,4195,4196,
   4281,4282,4319,4510,4511,4512,4518,4528,4529,5645,5646,5652,
   5655,5657,5662,5663,5664,5668,5670,5671,5689,5695,5698,5700,
   5705,5706,5707,5711,5713,5714,5737,5740,5742,5747,5748,5749,
   5753,5755,5756,5971,5973,5978,5979,5980,5984,5986,5987,6075,
   6080,6081,6086,6089,6143,6144,6145,6149,6151,6152,6284,6285,
   6289,6291,6292,6310,6314,6316,6317,6340,6341,6427,6464,7725,
   7726,7732,7735,7737,7742,7743,7744,7748,7750,7751,7769,7775,
   7778,7780,7785,7786,7787,7791,7793,7794,7817,7820,7822,7827,
   7828,7829,7833,7835,7836,8051,8053,8058,8059,8060,8064,8066,
   8067,8155,8160,8161,8162,8166,8168,8169,8223,8224,8225,8231,
   8364,8365,8369,8371,8372,8390,8394,8396,8397,8420,8506,8507,
   8544,38205,38211,38214,38216,38221,38222,38223,38227,38229,
   38230,38253,38256,38258,38263,38264,38265,38269,38271,38272,
   38487,38489,38494,38495,38496,38500,38502,38503,38591,38596,
   38597,38598,38602,38604,38605,38659,38660,38661,38665,38667,
   38668,38800,38801,38805,38807,38808,38826,38830,38832,38833,
   38854,38856,38857,38942,38943,38980,39156,39159,39161,39166,
   39167,39168,39172,39174,39175,39390,39392,39397,39398,39399,
   39403,39405,39406,39494,39499,39500,39501,39505,39507,39508,
   39562,39563,39564,39568,39570,39571,39703,39704,39708,39710,
   39711,39729,39733,39735,39736,39757,39759,39760,39845,39846,
   39883,40251,40253,40258,40259,40260,40264,40266,40267,40355,
   40360,40361,40362,40366,40368,40369,40423,40424,40425,40429,
   40431,40432,40564,40565,40569,40571,40572,40590,40594,40596,
   40597,40618,40620,40621,40706,40707,40744,44695,44700,44701,
   44702,44706,44708,44709,44763,44764,44765,44769,44771,44772,
   44904,44905,44909,44911,44912,44930,44934,44936,44937,44958,
   44960,44961,45046,45047,45084,46447,46448,46449,46453,46455,
   46456,46588,46589,46593,46595,46596,46614,46618,46620,46621,
   46642,46644,46645,46730,46731,46768,47549,47550,47554,47556,
   47557,47575,47579,47581,47582,47603,47605,47606,47691,47692,
   47729,49470,49474,49476,49477,49498,49500,49501,49586,49587,
   49624,49798,49800,49801,49886,49887,49924,50162,50163,50200,
   51084],
 [5699,5702,5705,5707,5712,5713,5716,6112,6119,6202,6213,6285,
   6290,6291,6294,6340,39528,39531,39533,39538,39539,39542,
   39621,39623,39628,39629,39632,39704,39709,39710,39713,39758,
   39759,39762,39864,39867,39885,47002,47004,47009,47085,47090,
   47091,47094,47139,47140,47143,47245,47248,47266,48391,48396,
   48397,48400,48445,48446,48551,49499,49500,49503,49605,49608,
   49626,50181,50202,51257],[],
 [5695,5700,5705,5706,5707,5713,5714,5978,5979,6143,6152,6284,
   6285,6291,6292,6340,39392,39397,39398,39399,39405,39406,
   39562,39563,39564,39570,39571,39703,39704,39710,39711,39729,
   39735,39736,39759,39760,39883,44763,44764,44765,44904,44905,
   44911,44912,44930,44936,44937,44960,44961,45084,47549,47550,
   47556,47557,47575,47581,47605,49470,49476,49477,49500,49501,
   49624,49800,49924,50200],
 [6050,6183,6340,45951,45952,45957,45959,46111,46116,46118,46139,
   46141,46241,48035,48040,48042,48063,48065,48165,50099,50101,
   50201,50454],
 [5699,5702,5705,5707,5712,5713,5716,6112,6119,6202,6213,6285,
   6290,6291,6294,6340,39528,39531,39533,39538,39539,39542,
   39621,39623,39628,39629,39632,39704,39709,39710,39713,39758,
   39759,39762,39864,39867,39885,47002,47004,47009,47085,47090,
   47091,47094,47139,47140,47143,47245,47248,47266,48391,48396,
   48397,48400,48445,48446,48551,49499,49500,49503,49605,49608,
   49626,50181,50202,51257],[6340,50203],[6340,50204],
 [6340,50205],[6340,50206],[6340,50207],[6340,50208],
 [6340,50209],[6340,50210],[6340,50211],[6340,50212],
 [6340,50213],[6340,50214],[6340,50215],[6340,50216],
 [6340,50217],[6050,46135],
 [5705,6018,6050,39424,39779,45501,46064],
 [5693,5694,5696,5697,5698,5705,5708,5710,5711,5894,5905,5942,
   6005,6013,6016,6018,6047,6050,6052,6080,6086,6286,6288,6289,
   6360,39313,39315,39316,39317,39324,39327,39329,39330,39352,
   39353,39354,39361,39364,39366,39367,39424,39425,39432,39435,
   39437,39438,39459,39466,39469,39471,39472,39499,39502,39504,
   39505,39705,39707,39708,39779,39780,39823,43257,43258,43259,
   43266,43269,43271,43272,43329,43330,43337,43340,43342,43343,
   43364,43371,43374,43376,43377,43404,43407,43409,43410,43610,
   43612,43613,43684,43685,43728,43995,43996,44003,44006,44008,
   44009,44030,44037,44040,44042,44043,44070,44073,44075,44076,
   44276,44278,44279,44350,44351,44394,45255,45262,45265,45267,
   45268,45295,45298,45300,45301,45501,45503,45504,45575,45576,
   45619,45856,45859,45861,45862,46062,46064,46065,46136,46137,
   46180,46590,46592,46593,46664,46665,46708,49520,49521,49564,
   50393],
 [5645,5646,5662,5689,5696,5697,5699,5705,5708,5710,5712,5747,
   6005,6013,6016,6018,6047,6050,6052,6112,6119,6286,6288,6290,
   6360,38205,38212,38213,38215,38221,38224,38226,38228,38254,
   38255,38257,38263,38266,38268,38270,38521,38523,38529,38532,
   38534,38536,38557,38563,38566,38568,38570,38628,38631,38633,
   38635,38802,38804,38806,38876,38878,38921,39157,39158,39160,
   39166,39169,39171,39173,39424,39426,39432,39435,39437,39439,
   39460,39466,39469,39471,39473,39531,39534,39536,39538,39705,
   39707,39709,39779,39781,39824,40285,40287,40293,40296,40298,
   40300,40321,40327,40330,40332,40334,40392,40395,40397,40399,
   40566,40568,40570,40640,40642,40685,45256,45262,45265,45267,
   45269,45327,45330,45332,45334,45501,45503,45505,45575,45577,
   45620,45888,45891,45893,45895,46062,46064,46066,46136,46138,
   46181,47086,47088,47090,47160,47162,47205,49520,49522,49565,
   50394],
 [6050,6183,6340,45951,45952,45957,45959,46111,46116,46118,46139,
   46141,46241,48035,48040,48042,48063,48065,48165,50099,50101,
   50201,50454],[6050,6152,45922,46140],
 [6050,6183,6340,45951,45952,45957,45959,46111,46116,46118,46139,
   46141,46241,48035,48040,48042,48063,48065,48165,50099,50101,
   50201,50454],[6050,6213,45981,46142],[6050,46143],
 [6050,46144],
 [5696,5697,5705,5708,5710,5719,6005,6013,6016,6018,6027,6047,
   6050,6052,6286,6288,6297,6360,6412,39424,39432,39435,39437,
   39446,39466,39469,39471,39480,39705,39707,39716,39779,39788,
   39831,45262,45265,45267,45276,45501,45503,45512,45575,45584,
   45627,46062,46064,46073,46136,46145,46188,49520,49529,49572,
   50401],[6050,46146],
 [5696,5697,5705,5708,5710,5721,6005,6013,6016,6018,6029,6047,
   6050,6052,6286,6288,6299,6360,6414,39424,39432,39435,39437,
   39448,39466,39469,39471,39482,39705,39707,39718,39779,39790,
   39833,45262,45265,45267,45278,45501,45503,45514,45575,45586,
   45629,46062,46064,46075,46136,46147,46190,49520,49531,49574,
   50403],[6050,46148],[6050,46149],[6050,46150],
 [5696,5697,5705,5708,5710,5725,6005,6013,6016,6018,6033,6047,
   6050,6052,6286,6288,6303,6360,6418,39424,39432,39435,39437,
   39452,39466,39469,39471,39486,39705,39707,39722,39779,39794,
   39837,45262,45265,45267,45282,45501,45503,45518,45575,45590,
   45633,46062,46064,46079,46136,46151,46194,49520,49535,49578,
   50407],[6050,46152],[6050,46153],[6050,46154],
 [6050,46155],[6050,46156],[6050,46157],
 [6018,45476,45477,45597,49217],
 [5698,5705,5709,5711,6080,6086,6287,6289,39499,39503,39505,
   39706,39708,39802,46591,46593,46687,49543],
 [5699,5705,5709,5712,6112,6119,6287,6290,39531,39535,39538,
   39706,39709,39803,47087,47090,47184,49544],[6340,50121],
 [6152],[6183,48087],[6213],[],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],
 [5693,5694,5696,5697,5698,5705,5708,5710,5711,5894,5905,5942,
   6005,6013,6016,6018,6047,6050,6052,6080,6086,6286,6288,6289,
   6360,39313,39315,39316,39317,39324,39327,39329,39330,39352,
   39353,39354,39361,39364,39366,39367,39424,39425,39432,39435,
   39437,39438,39459,39466,39469,39471,39472,39499,39502,39504,
   39505,39705,39707,39708,39779,39780,39823,43257,43258,43259,
   43266,43269,43271,43272,43329,43330,43337,43340,43342,43343,
   43364,43371,43374,43376,43377,43404,43407,43409,43410,43610,
   43612,43613,43684,43685,43728,43995,43996,44003,44006,44008,
   44009,44030,44037,44040,44042,44043,44070,44073,44075,44076,
   44276,44278,44279,44350,44351,44394,45255,45262,45265,45267,
   45268,45295,45298,45300,45301,45501,45503,45504,45575,45576,
   45619,45856,45859,45861,45862,46062,46064,46065,46136,46137,
   46180,46590,46592,46593,46664,46665,46708,49520,49521,49564,
   50393],
 [5645,5646,5662,5689,5696,5697,5699,5705,5708,5710,5712,5747,
   6005,6013,6016,6018,6047,6050,6052,6112,6119,6286,6288,6290,
   6360,38205,38212,38213,38215,38221,38224,38226,38228,38254,
   38255,38257,38263,38266,38268,38270,38521,38523,38529,38532,
   38534,38536,38557,38563,38566,38568,38570,38628,38631,38633,
   38635,38802,38804,38806,38876,38878,38921,39157,39158,39160,
   39166,39169,39171,39173,39424,39426,39432,39435,39437,39439,
   39460,39466,39469,39471,39473,39531,39534,39536,39538,39705,
   39707,39709,39779,39781,39824,40285,40287,40293,40296,40298,
   40300,40321,40327,40330,40332,40334,40392,40395,40397,40399,
   40566,40568,40570,40640,40642,40685,45256,45262,45265,45267,
   45269,45327,45330,45332,45334,45501,45503,45505,45575,45577,
   45620,45888,45891,45893,45895,46062,46064,46066,46136,46138,
   46181,47086,47088,47090,47160,47162,47205,49520,49522,49565,
   50394],[6018,6340,45552,45555,45621,50142],
 [5696,5697,5700,5705,5708,5710,5714,6005,6013,6016,6018,6042,
   6047,6050,6052,6056,6143,6146,6152,6286,6288,6292,6360,6364,
   39424,39427,39432,39435,39437,39441,39461,39466,39469,39471,
   39475,39562,39565,39567,39571,39705,39707,39711,39779,39783,
   39826,45257,45262,45265,45267,45271,45358,45361,45363,45501,
   45503,45507,45575,45579,45622,45919,45922,45924,45928,46062,
   46064,46068,46136,46140,46183,47551,47553,47557,47625,47629,
   49520,49524,49567,50396],[6018,6183,45393,45398,45623,48108]
  ,[5696,5697,5702,5705,5708,5710,5716,6005,6013,6016,6018,
   6044,6047,6050,6052,6058,6202,6205,6213,6286,6288,6294,6360,
   6366,39424,39429,39432,39435,39437,39443,39463,39466,39469,
   39471,39477,39621,39624,39626,39632,39705,39707,39713,39779,
   39785,39828,45259,45262,45265,45267,45273,45417,45420,45422,
   45501,45503,45509,45575,45581,45624,45978,45981,45983,45989,
   46062,46064,46070,46136,46142,46185,48392,48394,48400,48466,
   48472,49520,49526,49569,50398],
 [6018,45625,45626,45745,50960],[6018,45625,45626,45745,50960],
 [6018,45627],[6018,45628,45636,45791,51006],[6018,45629],
 [6018,45630,45632,45806,51021],[6018,45631],
 [6018,45630,45632,45806,51021],[6018,45633],
 [6018,45634,45635,45835,51050],[6018,45634,45635,45835,51050],
 [6018,45628,45636,45791,51006],[6018,45637,45638,45847,51062],
 [6018,45637,45638,45847,51062],[6018,45639],
 [5698,5699,5705,5711,5712,6080,6086,6112,6119,6289,6290,39493,
   39499,39505,39506,39531,39537,39538,39708,39709,39844,46416,
   46422,46423,46593,46594,46729,47089,47090,47225,49585],
 [2279,2300,2301,2302,2308,2318,2319,2365,2366,2367,2373,2383,
   2384,3500,3501,3507,3510,3512,3517,3518,3519,3523,3525,3526,
   3544,3550,3553,3555,3560,3561,3562,3566,3568,3569,3592,3595,
   3597,3602,3603,3604,3608,3610,3611,3826,3828,3833,3834,3835,
   3839,3841,3842,3930,3935,3936,3937,3941,3998,3999,4000,4004,
   4139,4140,4144,4146,4147,4165,4169,4171,4172,4193,4195,4196,
   4281,4282,4319,4510,4511,4512,4518,4528,4529,5645,5646,5652,
   5655,5657,5662,5663,5664,5668,5670,5671,5689,5695,5698,5700,
   5705,5706,5707,5711,5713,5714,5737,5740,5742,5747,5748,5749,
   5753,5755,5756,5971,5973,5978,5979,5980,5984,5986,5987,6075,
   6080,6081,6086,6089,6143,6144,6145,6149,6151,6152,6284,6285,
   6289,6291,6292,6310,6314,6316,6317,6340,6341,6427,6464,7725,
   7726,7732,7735,7737,7742,7743,7744,7748,7750,7751,7769,7775,
   7778,7780,7785,7786,7787,7791,7793,7794,7817,7820,7822,7827,
   7828,7829,7833,7835,7836,8051,8053,8058,8059,8060,8064,8066,
   8067,8155,8160,8161,8162,8166,8168,8169,8223,8224,8225,8231,
   8364,8365,8369,8371,8372,8390,8394,8396,8397,8420,8506,8507,
   8544,38205,38211,38214,38216,38221,38222,38223,38227,38229,
   38230,38253,38256,38258,38263,38264,38265,38269,38271,38272,
   38487,38489,38494,38495,38496,38500,38502,38503,38591,38596,
   38597,38598,38602,38604,38605,38659,38660,38661,38665,38667,
   38668,38800,38801,38805,38807,38808,38826,38830,38832,38833,
   38854,38856,38857,38942,38943,38980,39156,39159,39161,39166,
   39167,39168,39172,39174,39175,39390,39392,39397,39398,39399,
   39403,39405,39406,39494,39499,39500,39501,39505,39507,39508,
   39562,39563,39564,39568,39570,39571,39703,39704,39708,39710,
   39711,39729,39733,39735,39736,39757,39759,39760,39845,39846,
   39883,40251,40253,40258,40259,40260,40264,40266,40267,40355,
   40360,40361,40362,40366,40368,40369,40423,40424,40425,40429,
   40431,40432,40564,40565,40569,40571,40572,40590,40594,40596,
   40597,40618,40620,40621,40706,40707,40744,44695,44700,44701,
   44702,44706,44708,44709,44763,44764,44765,44769,44771,44772,
   44904,44905,44909,44911,44912,44930,44934,44936,44937,44958,
   44960,44961,45046,45047,45084,46447,46448,46449,46453,46455,
   46456,46588,46589,46593,46595,46596,46614,46618,46620,46621,
   46642,46644,46645,46730,46731,46768,47549,47550,47554,47556,
   47557,47575,47579,47581,47582,47603,47605,47606,47691,47692,
   47729,49470,49474,49476,49477,49498,49500,49501,49586,49587,
   49624,49798,49800,49801,49886,49887,49924,50162,50163,50200,
   51084],
 [5698,5700,5705,5711,5714,6080,6086,6143,6152,6289,6292,39494,
   39499,39505,39508,39562,39568,39571,39708,39711,39846,46447,
   46453,46593,46596,46731,47554,47557,49587],
 [5698,5701,5705,5711,5715,6080,6086,6173,6183,6289,6293,39495,
   39499,39505,39509,39592,39598,39602,39708,39712,39847,46477,
   46483,46487,46593,46597,46732,47989,47993,48128,49588],
 [5698,5702,5705,5711,5716,6080,6086,6202,6213,6289,6294,39496,
   39499,39505,39510,39621,39627,39632,39708,39713,39848,46506,
   46512,46593,46598,46733,48395,48400,49589],
 [5698,5705,5711,5717,6080,6086,6289,6295,39499,39505,39511,
   39708,39714,39849,46593,46599,46734,49590],
 [5698,5705,5711,5718,6080,6086,6289,6296,39499,39505,39512,
   39708,39715,39850,46593,46600,46735,49591],
 [5698,5705,5711,5719,6080,6086,6289,6297,39499,39505,39513,
   39708,39716,39851,46593,46601,46736,49592],
 [5698,5705,5711,5720,6080,6086,6289,6298,39499,39505,39514,
   39708,39717,39852,46593,46602,46737,49593],
 [5698,5705,5711,5721,6080,6086,6289,6299,39499,39505,39515,
   39708,39718,39853,46593,46603,46738,49594],
 [5698,5705,5711,5722,6080,6086,6289,6300,39499,39505,39516,
   39708,39719,39854,46593,46604,46739,49595],
 [5698,5705,5711,5723,6080,6086,6289,6301,39499,39505,39517,
   39708,39720,39855,46593,46605,46740,49596],
 [5698,5705,5711,5724,6080,6086,6289,6302,39499,39505,39518,
   39708,39721,39856,46593,46606,46741,49597],
 [5698,5705,5711,5725,6080,6086,6289,6303,39499,39505,39519,
   39708,39722,39857,46593,46607,46742,49598],
 [5698,5705,5711,5726,6080,6086,6289,6304,39499,39505,39520,
   39708,39723,39858,46593,46608,46743,49599],
 [5698,5705,5711,5727,6080,6086,6289,6305,39499,39505,39521,
   39708,39724,39859,46593,46609,46744,49600],
 [5698,5705,5711,5728,6080,6086,6289,6306,39499,39505,39522,
   39708,39725,39860,46593,46610,46745,49601],
 [5698,5705,5711,5729,6080,6086,6289,6307,39499,39505,39523,
   39708,39726,39861,46593,46611,46746,49602],
 [5698,5705,5711,5730,6080,6086,6289,6308,39499,39505,39524,
   39708,39727,39862,46593,46612,46747,49603],
 [5698,5705,5711,5731,6080,6086,6289,6309,39499,39505,39525,
   39708,39728,39863,46593,46613,46748,49604],
 [5699,5702,5705,5707,5712,5713,5716,6112,6119,6202,6213,6285,
   6290,6291,6294,6340,39528,39531,39533,39538,39539,39542,
   39621,39623,39628,39629,39632,39704,39709,39710,39713,39758,
   39759,39762,39864,39867,39885,47002,47004,47009,47085,47090,
   47091,47094,47139,47140,47143,47245,47248,47266,48391,48396,
   48397,48400,48445,48446,48551,49499,49500,49503,49605,49608,
   49626,50181,50202,51257],
 [5699,5700,5705,5712,5714,6112,6119,6143,6152,6290,6292,39526,
   39531,39538,39540,39562,39569,39571,39709,39711,39865,46943,
   46950,47090,47092,47246,47555,47557,49606],
 [5699,5701,5705,5712,5715,6112,6119,6173,6183,6290,6293,39527,
   39531,39538,39541,39592,39599,39602,39709,39712,39866,46973,
   46980,46983,47090,47093,47247,47990,47993,48147,49607],
 [5699,5702,5705,5707,5712,5713,5716,6112,6119,6202,6213,6285,
   6290,6291,6294,6340,39528,39531,39533,39538,39539,39542,
   39621,39623,39628,39629,39632,39704,39709,39710,39713,39758,
   39759,39762,39864,39867,39885,47002,47004,47009,47085,47090,
   47091,47094,47139,47140,47143,47245,47248,47266,48391,48396,
   48397,48400,48445,48446,48551,49499,49500,49503,49605,49608,
   49626,50181,50202,51257],
 [5699,5705,5712,5717,5719,6112,6119,6290,6295,6297,39531,39538,
   39543,39545,39709,39714,39716,39868,39870,39950,47090,47095,
   47097,47249,47251,47331,49609,49611,49691,51322],
 [5699,5705,5712,5718,6112,6119,6290,6296,39531,39538,39544,
   39709,39715,39869,47090,47096,47250,49610],
 [5699,5705,5712,5717,5719,6112,6119,6290,6295,6297,39531,39538,
   39543,39545,39709,39714,39716,39868,39870,39950,47090,47095,
   47097,47249,47251,47331,49609,49611,49691,51322],
 [5699,5705,5712,5720,6112,6119,6290,6298,39531,39538,39546,
   39709,39717,39871,47090,47098,47252,49612],
 [5699,5705,5712,5721,6112,6119,6290,6299,39531,39538,39547,
   39709,39718,39872,47090,47099,47253,49613],
 [5699,5705,5712,5722,6112,6119,6290,6300,39531,39538,39548,
   39709,39719,39873,47090,47100,47254,49614],
 [5699,5705,5712,5723,5724,6112,6119,6290,6301,6302,39531,39538,
   39549,39550,39709,39720,39721,39874,39875,40018,47090,47101,
   47102,47255,47256,47399,49615,49616,49759,51390],
 [5699,5705,5712,5723,5724,6112,6119,6290,6301,6302,39531,39538,
   39549,39550,39709,39720,39721,39874,39875,40018,47090,47101,
   47102,47255,47256,47399,49615,49616,49759,51390],
 [5699,5705,5712,5725,6112,6119,6290,6303,39531,39538,39551,
   39709,39722,39876,47090,47103,47257,49617],
 [5699,5705,5712,5726,6112,6119,6290,6304,39531,39538,39552,
   39709,39723,39877,47090,47104,47258,49618],
 [5699,5705,5712,5727,6112,6119,6290,6305,39531,39538,39553,
   39709,39724,39878,47090,47105,47259,49619],
 [5699,5705,5712,5728,6112,6119,6290,6306,39531,39538,39554,
   39709,39725,39879,47090,47106,47260,49620],
 [5699,5705,5712,5729,5731,6112,6119,6290,6307,6309,39531,39538,
   39555,39557,39709,39726,39728,39880,39882,40052,47090,47107,
   47109,47261,47263,47433,49621,49623,49793,51424],
 [5699,5705,5712,5730,6112,6119,6290,6308,39531,39538,39556,
   39709,39727,39881,47090,47108,47262,49622],
 [5699,5705,5712,5729,5731,6112,6119,6290,6307,6309,39531,39538,
   39555,39557,39709,39726,39728,39880,39882,40052,47090,47107,
   47109,47261,47263,47433,49621,49623,49793,51424],
 [5695,5700,5705,5706,5707,5713,5714,5978,5979,6143,6152,6284,
   6285,6291,6292,6340,39392,39397,39398,39399,39405,39406,
   39562,39563,39564,39570,39571,39703,39704,39710,39711,39729,
   39735,39736,39759,39760,39883,44763,44764,44765,44904,44905,
   44911,44912,44930,44936,44937,44960,44961,45084,47549,47550,
   47556,47557,47575,47581,47605,49470,49476,49477,49500,49501,
   49624,49800,49924,50200],
 [6050,6183,6340,45951,45952,45957,45959,46111,46116,46118,46139,
   46141,46241,48035,48040,48042,48063,48065,48165,50099,50101,
   50201,50454],
 [5699,5702,5705,5707,5712,5713,5716,6112,6119,6202,6213,6285,
   6290,6291,6294,6340,39528,39531,39533,39538,39539,39542,
   39621,39623,39628,39629,39632,39704,39709,39710,39713,39758,
   39759,39762,39864,39867,39885,47002,47004,47009,47085,47090,
   47091,47094,47139,47140,47143,47245,47248,47266,48391,48396,
   48397,48400,48445,48446,48551,49499,49500,49503,49605,49608,
   49626,50181,50202,51257],[6340,50203],[6340,50204],
 [6340,50205],[6340,50206],[6340,50207],[6340,50208],
 [6340,50209],[6340,50210],[6340,50211],[6340,50212],
 [6340,50213],[6340,50214],[6340,50215],[6340,50216],
 [6340,50217],
 [5690,5691,5700,5701,5705,5714,5715,5774,5788,5828,6143,6152,
   6173,6183,6292,6293,39193,39202,39203,39207,39216,39217,
   39242,39243,39247,39256,39257,39558,39562,39571,39572,39592,
   39601,39602,39711,39712,39901,40923,40924,40928,40937,40938,
   41239,41243,41253,41273,41283,41392,41393,41582,42019,42023,
   42053,42062,42063,42172,42173,42362,47438,47448,47557,47558,
   47992,47993,48182,49642],[6152,6213,42761,43104],[6152],
 [6152],[6152],[6152],[6152],[6152],[6152],[6152],
 [6152],[6152],[6152],[6152],[6152],[6152],[6152],
 [5645,5646,5662,5689,5701,5702,5705,5715,5716,5747,6173,6183,
   6202,6213,6293,6294,38205,38217,38218,38221,38231,38232,
   38259,38260,38263,38273,38274,38686,38689,38699,38700,38718,
   38809,38810,39015,39162,39163,39166,39176,39177,39589,39592,
   39602,39603,39621,39631,39632,39712,39713,39918,40450,40453,
   40463,40482,40492,40573,40574,40779,47902,47912,47993,47994,
   48199,48399,48400,49659],[6183,48200],[6183,48201],
 [6183,48202],[6183,48203],[6183,48204],[6183,48205],
 [6183,48206],[6183,48207],[6183,48208],[6183,48209],
 [6183,48210],[6183,48211],[6183,48212],[6183,48213],
 [6183,48214],[6213],[6213],[6213],[6213],[6213],
 [6213],[6213],[6213],[6213],[6213],[6213],[6213],
 [6213],[6213],[6213],[6018,45625,45626,45745,50960],
 [5699,5705,5712,5717,5719,6112,6119,6290,6295,6297,39531,39538,
   39543,39545,39709,39714,39716,39868,39870,39950,47090,47095,
   47097,47249,47251,47331,49609,49611,49691,51322],[],[],
 [],[],[],[],[],[],[],[],[],[],
 [5645,5646,5662,5689,5705,5718,5719,5747,6296,6297,38205,38221,
   38234,38235,38263,38276,38277,38812,38813,39060,39166,39179,
   39180,39715,39716,39963,40576,40577,40824,49704],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],
 [5705,5719,5722,6297,6300,39716,39719,39978,49719],[],
 [5705,5719,5724,6297,6302,39716,39721,39980,49721],[],[],
 [],[],[5705,5719,5729,6297,6307,39716,39726,39985,49726],
 [5705,5719,5730,6297,6308,39716,39727,39986,49727],[],
 [5690,5691,5705,5720,5721,5774,5788,5828,6298,6299,39193,39207,
   39222,39223,39247,39262,39263,39717,39718,39988,40928,40943,
   40944,41398,41399,41669,42178,42179,42449,49729],[],[],
 [],[],[14514],[],[6018,45628,45636,45791,51006],[],
 [],[],[],[],[],[14523],[],[],
 [5695,5705,5706,5721,5728,5978,5979,6284,6299,6306,39397,39398,
   39413,39420,39703,39718,39725,39743,39750,40005,44904,44919,
   44926,44944,44951,45206,49484,49491,49746,50046],[],[],
 [],[5645,5646,5662,5689,5705,5722,5723,5747,6300,6301,38205,
   38221,38238,38239,38263,38280,38281,38816,38817,39106,39166,
   39183,39184,39719,39720,40009,40580,40581,40870,49750],
 [6018,45630,45632,45806,51021],[],[],[],[],[],
 [19848],[],
 [5699,5705,5712,5723,5724,6112,6119,6290,6301,6302,39531,39538,
   39549,39550,39709,39720,39721,39874,39875,40018,47090,47101,
   47102,47255,47256,47399,49615,49616,49759,51390],[],[],
 [],[],[],[],[19857],[],[],[],[],[19862],[],
 [],[5690,5691,5705,5725,5726,5774,5788,5828,6303,6304,39193,
   39207,39227,39228,39247,39267,39268,39722,39723,40033,40928,
   40948,40949,41403,41404,41714,42183,42184,42494,49774],
 [5695,5705,5706,5725,5727,5978,5979,6284,6303,6305,39397,39398,
   39417,39419,39703,39722,39724,39747,39749,40034,44904,44923,
   44925,44948,44950,45235,49488,49490,49775,50075],[],[],
 [],[],[6018,45634,45635,45835,51050],[],[],[],[],
 [14565],[],[],[],[],[],[],
 [6018,45637,45638,45847,51062],
 [5699,5705,5712,5729,5731,6112,6119,6290,6307,6309,39531,39538,
   39555,39557,39709,39726,39728,39880,39882,40052,47090,47107,
   47109,47261,47263,47433,49621,49623,49793,51424],
 [5645,5646,5662,5689,5705,5730,5731,5747,6308,6309,38205,38221,
   38246,38247,38263,38288,38289,38824,38825,39150,39166,39191,
   39192,39727,39728,40053,40588,40589,40914,49794],
 [6656,6662,6672,6673,6719,6725,6735,6736,6781,6787,6797,6798,
   7817,7827,7828,8058,8059,8364,8715,8735,8741,8751,8752,8797,
   8803,8813,8814,9833,9843,9844,10074,10075,10380,10750,10756,
   10766,10767,11786,11796,11797,12027,12028,12333,13677,13687,
   13688,13918,13919,14224,40258,40259,40564,44904],
 [6656,6662,6672,6673,6719,6725,6735,6736,6781,6787,6797,6798,
   7817,7827,7828,8058,8059,8364,8715,8735,8741,8751,8752,8797,
   8803,8813,8814,9833,9843,9844,10074,10075,10380,10750,10756,
   10766,10767,11786,11796,11797,12027,12028,12333,13677,13687,
   13688,13918,13919,14224,40258,40259,40564,44904],[],
 [157,164,179,202,221,228,243,467,474,489,1424,1439,1698,6657,
   6664,6679,6903,6910,6925,7860,7875,8134,8919,8926,8941,9876,
   9891,10150,17320,17335,17594,41154],[8962],[],[8962],
 [],[],[],[],[],[],[],[],[],[],[],[],
 [6656,6673,7725,7726,7743,7769,7786,7828,9741,9742,9759,9785,
   9802,9844,38205,38222,38264,39167],
 [6656,6673,7725,7726,7743,7769,7786,7828,9741,9742,9759,9785,
   9802,9844,38205,38222,38264,39167],[7828],[7875,9891],
 [6654,6655,6656,6657,6659,6673,6675,6679,7725,7726,7727,7728,
   7729,7743,7745,7747,7749,7769,7770,7771,7772,7786,7788,7790,
   7792,7812,7813,7814,7828,7830,7832,7834,7854,7855,7869,7871,
   7873,7875,7895,7909,7911,7913,7915,7948,7950,7952,7954,8391,
   8393,8395,8440,8442,8485,9741,9742,9743,9744,9745,9759,9761,
   9763,9765,9785,9786,9787,9788,9802,9804,9806,9808,9828,9829,
   9830,9844,9846,9848,9850,9870,9871,9885,9887,9889,9891,9911,
   9925,9927,9929,9931,9964,9966,9968,9970,10407,10409,10411,
   10456,10458,10501,38205,38206,38207,38208,38222,38224,38226,
   38228,38248,38249,38250,38264,38266,38268,38270,38290,38291,
   38305,38307,38309,38311,38331,38345,38347,38349,38351,38384,
   38386,38388,38390,38827,38829,38831,38876,38878,38921,39151,
   39152,39153,39167,39169,39171,39173,39193,39194,39208,39210,
   39212,39214,39234,39248,39250,39252,39254,39287,39289,39291,
   39293,39730,39732,39734,39779,39781,39824,40054,40055,40069,
   40071,40073,40075,40095,40109,40111,40113,40115,40148,40150,
   40152,40154,40591,40593,40595,40640,40642,40685,40915,40929,
   40931,40933,40935,40968,40970,40972,40974,41411,41413,41415,
   41460,41462,41505,41748,41750,41752,41754,42191,42193,42195,
   42240,42242,42285,42932,42934,42936,42981,42983,43026,49820,
   49822,49865,50394],
 [6656,6657,6673,6679,7812,7814,7828,7830,7834,7855,7869,7871,
   7875,7948,7950,7954,8391,8395,8442,9828,9830,9844,9846,9850,
   9871,9885,9887,9891,9964,9966,9970,10407,10411,10458,40055,
   40069,40071,40075,40148,40150,40154,40591,40595,40642,40968,
   40970,40974,41411,41415,41462,42932,42936,42983,49822],
 [7996,10012],[8032],
 [6656,6673,7817,7827,7828,8058,8059,8364,9833,9843,9844,10074,
   10075,10380,40258,40259,40564,44904],
 [6656,6657,6659,6662,6672,6673,6675,6679,7812,7814,7817,7818,
   7821,7827,7828,7830,7834,7855,7858,7859,7862,7868,7869,7871,
   7875,7937,7938,7941,7947,7948,7950,7954,8049,8052,8058,8059,
   8061,8065,8087,8093,8094,8096,8100,8192,8193,8195,8199,8364,
   8366,8370,8391,8395,8442,9828,9830,9833,9834,9837,9843,9844,
   9846,9850,9871,9874,9875,9878,9884,9885,9887,9891,9953,9954,
   9957,9963,9964,9966,9970,10065,10068,10074,10075,10077,10081,
   10103,10109,10110,10112,10116,10208,10209,10211,10215,10380,
   10382,10386,10407,10411,10458,40055,40058,40059,40062,40068,
   40069,40071,40075,40137,40138,40141,40147,40148,40150,40154,
   40249,40252,40258,40259,40261,40265,40287,40293,40294,40296,
   40300,40392,40393,40395,40399,40564,40566,40570,40591,40595,
   40642,40957,40958,40961,40967,40968,40970,40974,41069,41072,
   41078,41079,41081,41085,41107,41113,41114,41116,41120,41212,
   41213,41215,41219,41384,41386,41390,41411,41415,41462,42590,
   42593,42599,42600,42602,42606,42628,42634,42635,42637,42641,
   42733,42734,42736,42740,42905,42907,42911,42932,42936,42983,
   44627,44633,44634,44636,44640,44732,44733,44735,44739,44904,
   44906,44910,44931,44935,44982,45327,45328,45330,45334,45499,
   45501,45505,45526,45530,45577,47084,47086,47090,47111,47115,
   47162,49471,49475,49522,49822],[],[8168],
 [6656,6657,6659,6662,6672,6673,6675,6679,7812,7814,7817,7818,
   7821,7827,7828,7830,7834,7855,7858,7859,7862,7868,7869,7871,
   7875,7937,7938,7941,7947,7948,7950,7954,8049,8052,8058,8059,
   8061,8065,8087,8093,8094,8096,8100,8192,8193,8195,8199,8364,
   8366,8370,8391,8395,8442,9828,9830,9833,9834,9837,9843,9844,
   9846,9850,9871,9874,9875,9878,9884,9885,9887,9891,9953,9954,
   9957,9963,9964,9966,9970,10065,10068,10074,10075,10077,10081,
   10103,10109,10110,10112,10116,10208,10209,10211,10215,10380,
   10382,10386,10407,10411,10458,40055,40058,40059,40062,40068,
   40069,40071,40075,40137,40138,40141,40147,40148,40150,40154,
   40249,40252,40258,40259,40261,40265,40287,40293,40294,40296,
   40300,40392,40393,40395,40399,40564,40566,40570,40591,40595,
   40642,40957,40958,40961,40967,40968,40970,40974,41069,41072,
   41078,41079,41081,41085,41107,41113,41114,41116,41120,41212,
   41213,41215,41219,41384,41386,41390,41411,41415,41462,42590,
   42593,42599,42600,42602,42606,42628,42634,42635,42637,42641,
   42733,42734,42736,42740,42905,42907,42911,42932,42936,42983,
   44627,44633,44634,44636,44640,44732,44733,44735,44739,44904,
   44906,44910,44931,44935,44982,45327,45328,45330,45334,45499,
   45501,45505,45526,45530,45577,47084,47086,47090,47111,47115,
   47162,49471,49475,49522,49822],
 [6656,6673,7822,7828,7829,8224,8225,8390,9838,9844,9845,10240,
   10241,10406,40424,40425,40590,47575],
 [6656,6673,7823,7824,7828,8250,8254,8283,9839,9840,9844,10266,
   10270,10299,40450,40454,40483,47903],
 [6656,6673,7823,7824,7828,8250,8254,8283,9839,9840,9844,10266,
   10270,10299,40450,40454,40483,47903],[],[],
 [6656,6673,7817,7827,7828,8058,8059,8364,9833,9843,9844,10074,
   10075,10380,40258,40259,40564,44904],[7828],
 [6656,6673,7822,7828,7829,8224,8225,8390,9838,9844,9845,10240,
   10241,10406,40424,40425,40590,47575],
 [6656,6657,6673,6679,7812,7814,7828,7830,7834,7855,7869,7871,
   7875,7948,7950,7954,8391,8395,8442,9828,9830,9844,9846,9850,
   9871,9885,9887,9891,9964,9966,9970,10407,10411,10458,40055,
   40069,40071,40075,40148,40150,40154,40591,40595,40642,40968,
   40970,40974,41411,41415,41462,42932,42936,42983,49822],[],
 [6654,6655,6656,6657,6659,6673,6675,6679,7725,7726,7727,7728,
   7729,7743,7745,7747,7749,7769,7770,7771,7772,7786,7788,7790,
   7792,7812,7813,7814,7828,7830,7832,7834,7854,7855,7869,7871,
   7873,7875,7895,7909,7911,7913,7915,7948,7950,7952,7954,8391,
   8393,8395,8440,8442,8485,9741,9742,9743,9744,9745,9759,9761,
   9763,9765,9785,9786,9787,9788,9802,9804,9806,9808,9828,9829,
   9830,9844,9846,9848,9850,9870,9871,9885,9887,9889,9891,9911,
   9925,9927,9929,9931,9964,9966,9968,9970,10407,10409,10411,
   10456,10458,10501,38205,38206,38207,38208,38222,38224,38226,
   38228,38248,38249,38250,38264,38266,38268,38270,38290,38291,
   38305,38307,38309,38311,38331,38345,38347,38349,38351,38384,
   38386,38388,38390,38827,38829,38831,38876,38878,38921,39151,
   39152,39153,39167,39169,39171,39173,39193,39194,39208,39210,
   39212,39214,39234,39248,39250,39252,39254,39287,39289,39291,
   39293,39730,39732,39734,39779,39781,39824,40054,40055,40069,
   40071,40073,40075,40095,40109,40111,40113,40115,40148,40150,
   40152,40154,40591,40593,40595,40640,40642,40685,40915,40929,
   40931,40933,40935,40968,40970,40972,40974,41411,41413,41415,
   41460,41462,41505,41748,41750,41752,41754,42191,42193,42195,
   42240,42242,42285,42932,42934,42936,42981,42983,43026,49820,
   49822,49865,50394],[8507,10523],[7875,9891],[8168],
 [8507,10523],[8032],[7996,10012],[],[],[],[],[],
 [],[],[],[],[],[],[],[],[],[],
 [6656,6662,6672,6673,6719,6725,6735,6736,6781,6787,6797,6798,
   7817,7827,7828,8058,8059,8364,8715,8735,8741,8751,8752,8797,
   8803,8813,8814,9833,9843,9844,10074,10075,10380,10750,10756,
   10766,10767,11786,11796,11797,12027,12028,12333,13677,13687,
   13688,13918,13919,14224,40258,40259,40564,44904],[],
 [6717,6718,6719,6736,6900,6901,6902,6919,6959,6960,6961,6978,
   7725,7726,7743,7769,7786,7828,10854,10869,10870,10871,10888,
   10928,10929,10930,10947,11694,11695,11712,11738,11755,11797,
   16419,16420,16421,16438,17185,17186,17203,17229,17246,17288,
   18896,18897,18914,18940,18957,18999,38205,38222,38264,39167],
 [6717,6718,6719,6736,6900,6901,6902,6919,6959,6960,6961,6978,
   7725,7726,7743,7769,7786,7828,10854,10869,10870,10871,10888,
   10928,10929,10930,10947,11694,11695,11712,11738,11755,11797,
   16419,16420,16421,16438,17185,17186,17203,17229,17246,17288,
   18896,18897,18914,18940,18957,18999,38205,38222,38264,39167],
 [],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[6719,6736,7725,7726,7743,7769,7786,7828,11694,11695,
   11712,11738,11755,11797,38205,38222,38264,39167],
 [6719,6736,7725,7726,7743,7769,7786,7828,11694,11695,11712,
   11738,11755,11797,38205,38222,38264,39167],[7828],
 [7875,11844],
 [6719,6736,7813,7828,7832,7909,7913,8393,11782,11797,11801,
   11878,11882,12362,40109,40113,40593,42193],
 [6719,6720,6736,6742,7812,7814,7828,7830,7834,7855,7869,7871,
   7875,7948,7950,7954,8391,8395,8442,11781,11783,11797,11799,
   11803,11824,11838,11840,11844,11917,11919,11923,12360,12364,
   12411,40055,40069,40071,40075,40148,40150,40154,40591,40595,
   40642,40968,40970,40974,41411,41415,41462,42932,42936,42983,
   49822],[7996,11965],[8032],
 [6719,6736,7817,7827,7828,8058,8059,8364,11786,11796,11797,
   12027,12028,12333,40258,40259,40564,44904],
 [6719,6736,7818,7821,7828,8087,8094,8193,11787,11790,11797,
   12056,12063,12162,40287,40294,40393,45328],[],[8168],
 [6719,6736,7818,7821,7828,8087,8094,8193,11787,11790,11797,
   12056,12063,12162,40287,40294,40393,45328],
 [6719,6736,7822,7828,7829,8224,8225,8390,11791,11797,11798,
   12193,12194,12359,40424,40425,40590,47575],
 [6719,6736,7823,7824,7828,8250,8254,8283,11792,11793,11797,
   12219,12223,12252,40450,40454,40483,47903],
 [6719,6736,7823,7824,7828,8250,8254,8283,11792,11793,11797,
   12219,12223,12252,40450,40454,40483,47903],[],[],
 [6719,6736,7817,7827,7828,8058,8059,8364,11786,11796,11797,
   12027,12028,12333,40258,40259,40564,44904],[7828],
 [6719,6736,7822,7828,7829,8224,8225,8390,11791,11797,11798,
   12193,12194,12359,40424,40425,40590,47575],
 [6719,6720,6736,6742,7812,7814,7828,7830,7834,7855,7869,7871,
   7875,7948,7950,7954,8391,8395,8442,11781,11783,11797,11799,
   11803,11824,11838,11840,11844,11917,11919,11923,12360,12364,
   12411,40055,40069,40071,40075,40148,40150,40154,40591,40595,
   40642,40968,40970,40974,41411,41415,41462,42932,42936,42983,
   49822],[],
 [6719,6736,7813,7828,7832,7909,7913,8393,11782,11797,11801,
   11878,11882,12362,40109,40113,40593,42193],[8507,12476],
 [7875,11844],[8168],[8507,12476],[8032],[7996,11965],
 [],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[12747],[],[],[12747],[12979],
 [12979],[],[],[],[],[],[],[],[],[],[],
 [6781,6798,7725,7726,7743,7769,7786,7828,13585,13586,13603,
   13629,13646,13688,38205,38222,38264,39167],
 [6781,6798,7725,7726,7743,7769,7786,7828,13585,13586,13603,
   13629,13646,13688,38205,38222,38264,39167],[7828],
 [6781,6798,7812,7814,7828,7830,7834,7855,7869,7871,7875,7948,
   7950,7954,8391,8395,8442,13672,13674,13688,13690,13694,13715,
   13729,13731,13735,13808,13810,13814,14251,14255,14302,40055,
   40069,40071,40075,40148,40150,40154,40591,40595,40642,40968,
   40970,40974,41411,41415,41462,42932,42936,42983,49822],
 [6781,6798,7813,7828,7832,7909,7913,8393,13673,13688,13692,
   13769,13773,14253,40109,40113,40593,42193],
 [6781,6798,7812,7814,7828,7830,7834,7855,7869,7871,7875,7948,
   7950,7954,8391,8395,8442,13672,13674,13688,13690,13694,13715,
   13729,13731,13735,13808,13810,13814,14251,14255,14302,40055,
   40069,40071,40075,40148,40150,40154,40591,40595,40642,40968,
   40970,40974,41411,41415,41462,42932,42936,42983,49822],
 [7996,13856],[8032],
 [6781,6798,7817,7827,7828,8058,8059,8364,13677,13687,13688,
   13918,13919,14224,40258,40259,40564,44904],
 [6781,6798,7818,7821,7828,8087,8094,8193,13678,13681,13688,
   13947,13954,14053,40287,40294,40393,45328],[],[8168],
 [6781,6798,7818,7821,7828,8087,8094,8193,13678,13681,13688,
   13947,13954,14053,40287,40294,40393,45328],
 [6781,6798,7822,7828,7829,8224,8225,8390,13682,13688,13689,
   14084,14085,14250,40424,40425,40590,47575],
 [6781,6798,7823,7824,7828,8250,8254,8283,13683,13684,13688,
   14110,14114,14143,40450,40454,40483,47903],
 [6781,6798,7823,7824,7828,8250,8254,8283,13683,13684,13688,
   14110,14114,14143,40450,40454,40483,47903],[],[],
 [6781,6798,7817,7827,7828,8058,8059,8364,13677,13687,13688,
   13918,13919,14224,40258,40259,40564,44904],[7828],
 [6781,6798,7822,7828,7829,8224,8225,8390,13682,13688,13689,
   14084,14085,14250,40424,40425,40590,47575],
 [6781,6798,7812,7814,7828,7830,7834,7855,7869,7871,7875,7948,
   7950,7954,8391,8395,8442,13672,13674,13688,13690,13694,13715,
   13729,13731,13735,13808,13810,13814,14251,14255,14302,40055,
   40069,40071,40075,40148,40150,40154,40591,40595,40642,40968,
   40970,40974,41411,41415,41462,42932,42936,42983,49822],[],
 [6781,6798,7813,7828,7832,7909,7913,8393,13673,13688,13692,
   13769,13773,14253,40109,40113,40593,42193],[8507,14367],
 [6781,6798,7812,7814,7828,7830,7834,7855,7869,7871,7875,7948,
   7950,7954,8391,8395,8442,13672,13674,13688,13690,13694,13715,
   13729,13731,13735,13808,13810,13814,14251,14255,14302,40055,
   40069,40071,40075,40148,40150,40154,40591,40595,40642,40968,
   40970,40974,41411,41415,41462,42932,42936,42983,49822],
 [8168],[8507,14367],[8032],[7996,13856],[],
 [6781,6798,7828,7840,7841,8401,8402,8624,13688,13700,13701,
   14261,14262,14484,40601,40602,40824,50004],
 [6781,6798,7828,7840,7841,8401,8402,8624,13688,13700,13701,
   14261,14262,14484,40601,40602,40824,50004],[14514],
 [6781,6798,7828,7843,7847,7849,7850,8404,8408,8410,8411,8665,
   8666,8695,8696,13688,13703,13707,13709,13710,14264,14268,
   14270,14271,14523,14525,14526,14555,14556,14565,40604,40608,
   40610,40611,40863,40865,40866,40895,40896,40905,50043,50045,
   50046,50075,50076,50085,52255,52256,52265,52365],
 [6781,6798,7828,7844,7845,8405,8406,8670,13688,13704,13705,
   14265,14266,14530,40605,40606,40870,50050],
 [6781,6798,7828,7844,7845,8405,8406,8670,13688,13704,13705,
   14265,14266,14530,40605,40606,40870,50050],[],
 [6781,6798,7828,7843,7847,7849,7850,8404,8408,8410,8411,8665,
   8666,8695,8696,13688,13703,13707,13709,13710,14264,14268,
   14270,14271,14523,14525,14526,14555,14556,14565,40604,40608,
   40610,40611,40863,40865,40866,40895,40896,40905,50043,50045,
   50046,50075,50076,50085,52255,52256,52265,52365],[14514],
 [6781,6798,7828,7843,7847,7849,7850,8404,8408,8410,8411,8665,
   8666,8695,8696,13688,13703,13707,13709,13710,14264,14268,
   14270,14271,14523,14525,14526,14555,14556,14565,40604,40608,
   40610,40611,40863,40865,40866,40895,40896,40905,50043,50045,
   50046,50075,50076,50085,52255,52256,52265,52365],
 [6781,6798,7828,7843,7847,7849,7850,8404,8408,8410,8411,8665,
   8666,8695,8696,13688,13703,13707,13709,13710,14264,14268,
   14270,14271,14523,14525,14526,14555,14556,14565,40604,40608,
   40610,40611,40863,40865,40866,40895,40896,40905,50043,50045,
   50046,50075,50076,50085,52255,52256,52265,52365],[],
 [6781,6798,7828,7852,7853,8413,8414,8714,13688,13712,13713,
   14273,14274,14574,40613,40614,40914,50094],
 [6781,6798,7828,7852,7853,8413,8414,8714,13688,13712,13713,
   14273,14274,14574,40613,40614,40914,50094],[],[14635],
 [14635],[],[],[],[],[],[],[],[],[],[],
 [],[],[],
 [6842,6859,7725,7726,7743,7769,7786,7828,15415,15416,15433,
   15459,15476,15518,38205,38222,38264,39167],
 [6842,6859,7725,7726,7743,7769,7786,7828,15415,15416,15433,
   15459,15476,15518,38205,38222,38264,39167],[7828],
 [7875,15565],
 [6842,6859,7813,7828,7832,7909,7913,8393,15503,15518,15522,
   40109,40113,40593,42193],[7950,15640],[7996,15686],
 [8032],[6842,6859,7817,7827,7828,8058,8059,8364,15507,15517,
   15518,15748,15749,16054,40258,40259,40564,44904],
 [6842,6859,7818,7821,7828,8087,8094,8193,15508,15511,15518,
   15777,15784,15883,40287,40294,40393,45328],[],[8168],
 [6842,6859,7818,7821,7828,8087,8094,8193,15508,15511,15518,
   15777,15784,15883,40287,40294,40393,45328],
 [6840,6841,6842,6859,7725,7726,7737,7743,7744,7769,7780,7786,
   7787,7822,7828,7829,8224,8225,8390,15415,15416,15427,15433,
   15434,15459,15470,15476,15477,15512,15518,15519,15914,15915,
   16080,38205,38216,38222,38223,38258,38264,38265,38660,38661,
   38826,39161,39167,39168,39563,39564,39729,40424,40425,40590,
   47575],
 [6842,6859,7823,7824,7828,8250,8254,8283,15513,15514,15518,
   15940,15944,15973,40450,40454,40483,47903],
 [6842,6859,7823,7824,7828,8250,8254,8283,15513,15514,15518,
   15940,15944,15973,40450,40454,40483,47903],[],[],
 [6842,6859,7817,7827,7828,8058,8059,8364,15507,15517,15518,
   15748,15749,16054,40258,40259,40564,44904],[7828],
 [6840,6841,6842,6859,7725,7726,7737,7743,7744,7769,7780,7786,
   7787,7822,7828,7829,8224,8225,8390,15415,15416,15427,15433,
   15434,15459,15470,15476,15477,15512,15518,15519,15914,15915,
   16080,38205,38216,38222,38223,38258,38264,38265,38660,38661,
   38826,39161,39167,39168,39563,39564,39729,40424,40425,40590,
   47575],[7950,15640],[],
 [6842,6859,7813,7828,7832,7909,7913,8393,15503,15518,15522,
   40109,40113,40593,42193],[8507,16197],[7875,15565],
 [8168],[8507,16197],[8032],[7996,15686],[],[],[],
 [],[],[],[],[],[],[],[],[],[],
 [6842,6859,7828,7852,7853,8413,8414,8714,15518,15542,15543,
   16103,16104,16404,40613,40614,40914,50094],
 [6842,6859,7828,7852,7853,8413,8414,8714,15518,15542,15543,
   16103,16104,16404,40613,40614,40914,50094],
 [6717,6718,6719,6736,6900,6901,6902,6919,6959,6960,6961,6978,
   7725,7726,7743,7769,7786,7828,10854,10869,10870,10871,10888,
   10928,10929,10930,10947,11694,11695,11712,11738,11755,11797,
   16419,16420,16421,16438,17185,17186,17203,17229,17246,17288,
   18896,18897,18914,18940,18957,18999,38205,38222,38264,39167],
 [],[12747],[],[],[],[],[],[],[],[],[],
 [],[],[],
 [6902,6919,7725,7726,7743,7769,7786,7828,17185,17186,17203,
   17229,17246,17288,38205,38222,38264,39167],
 [6902,6919,7725,7726,7743,7769,7786,7828,17185,17186,17203,
   17229,17246,17288,38205,38222,38264,39167],[7828],
 [7875,17335],
 [6900,6901,6902,6903,6905,6919,6921,6925,7725,7726,7727,7728,
   7729,7743,7745,7747,7749,7769,7770,7771,7772,7786,7788,7790,
   7792,7812,7813,7814,7828,7830,7832,7834,7854,7855,7869,7871,
   7873,7875,7895,7909,7911,7913,7915,7948,7950,7952,7954,8391,
   8393,8395,8440,8442,8485,17185,17186,17187,17188,17189,17203,
   17205,17207,17209,17229,17230,17231,17232,17246,17248,17250,
   17252,17272,17273,17274,17288,17290,17292,17294,17314,17315,
   17329,17331,17333,17335,17355,17369,17371,17373,17375,17408,
   17410,17412,17414,17851,17853,17855,17900,17902,17945,38205,
   38206,38207,38208,38222,38224,38226,38228,38248,38249,38250,
   38264,38266,38268,38270,38290,38291,38305,38307,38309,38311,
   38331,38345,38347,38349,38351,38384,38386,38388,38390,38827,
   38829,38831,38876,38878,38921,39151,39152,39153,39167,39169,
   39171,39173,39193,39194,39208,39210,39212,39214,39234,39248,
   39250,39252,39254,39287,39289,39291,39293,39730,39732,39734,
   39779,39781,39824,40054,40055,40069,40071,40073,40075,40095,
   40109,40111,40113,40115,40148,40150,40152,40154,40591,40593,
   40595,40640,40642,40685,40915,40929,40931,40933,40935,40968,
   40970,40972,40974,41411,41413,41415,41460,41462,41505,41748,
   41750,41752,41754,42191,42193,42195,42240,42242,42285,42932,
   42934,42936,42981,42983,43026,49820,49822,49865,50394],
 [6902,6903,6919,6925,7812,7814,7828,7830,7834,7855,7869,7871,
   7875,7948,7950,7954,8391,8395,8442,17272,17274,17288,17290,
   17294,17315,17329,17331,17335,17408,17410,17414,17851,17855,
   17902,40055,40069,40071,40075,40148,40150,40154,40591,40595,
   40642,40968,40970,40974,41411,41415,41462,42932,42936,42983,
   49822],[7996,17456],[8032],
 [6902,6919,7817,7827,7828,8058,8059,8364,17277,17287,17288,
   17518,17519,17824,40258,40259,40564,44904],
 [6902,6903,6905,6908,6918,6919,6921,6925,7812,7814,7817,7818,
   7821,7827,7828,7830,7834,7855,7858,7859,7862,7868,7869,7871,
   7875,7937,7938,7941,7947,7948,7950,7954,8049,8052,8058,8059,
   8061,8065,8087,8093,8094,8096,8100,8192,8193,8195,8199,8364,
   8366,8370,8391,8395,8442,17272,17274,17277,17278,17281,17287,
   17288,17290,17294,17315,17318,17319,17322,17328,17329,17331,
   17335,17397,17398,17401,17407,17408,17410,17414,17509,17512,
   17518,17519,17521,17525,17547,17553,17554,17556,17560,17652,
   17653,17655,17659,17824,17826,17830,17851,17855,17902,40055,
   40058,40059,40062,40068,40069,40071,40075,40137,40138,40141,
   40147,40148,40150,40154,40249,40252,40258,40259,40261,40265,
   40287,40293,40294,40296,40300,40392,40393,40395,40399,40564,
   40566,40570,40591,40595,40642,40957,40958,40961,40967,40968,
   40970,40974,41069,41072,41078,41079,41081,41085,41107,41113,
   41114,41116,41120,41212,41213,41215,41219,41384,41386,41390,
   41411,41415,41462,42590,42593,42599,42600,42602,42606,42628,
   42634,42635,42637,42641,42733,42734,42736,42740,42905,42907,
   42911,42932,42936,42983,44627,44633,44634,44636,44640,44732,
   44733,44735,44739,44904,44906,44910,44931,44935,44982,45327,
   45328,45330,45334,45499,45501,45505,45526,45530,45577,47084,
   47086,47090,47111,47115,47162,49471,49475,49522,49822],[],
 [8168],
 [6902,6903,6905,6908,6918,6919,6921,6925,7812,7814,7817,7818,
   7821,7827,7828,7830,7834,7855,7858,7859,7862,7868,7869,7871,
   7875,7937,7938,7941,7947,7948,7950,7954,8049,8052,8058,8059,
   8061,8065,8087,8093,8094,8096,8100,8192,8193,8195,8199,8364,
   8366,8370,8391,8395,8442,17272,17274,17277,17278,17281,17287,
   17288,17290,17294,17315,17318,17319,17322,17328,17329,17331,
   17335,17397,17398,17401,17407,17408,17410,17414,17509,17512,
   17518,17519,17521,17525,17547,17553,17554,17556,17560,17652,
   17653,17655,17659,17824,17826,17830,17851,17855,17902,40055,
   40058,40059,40062,40068,40069,40071,40075,40137,40138,40141,
   40147,40148,40150,40154,40249,40252,40258,40259,40261,40265,
   40287,40293,40294,40296,40300,40392,40393,40395,40399,40564,
   40566,40570,40591,40595,40642,40957,40958,40961,40967,40968,
   40970,40974,41069,41072,41078,41079,41081,41085,41107,41113,
   41114,41116,41120,41212,41213,41215,41219,41384,41386,41390,
   41411,41415,41462,42590,42593,42599,42600,42602,42606,42628,
   42634,42635,42637,42641,42733,42734,42736,42740,42905,42907,
   42911,42932,42936,42983,44627,44633,44634,44636,44640,44732,
   44733,44735,44739,44904,44906,44910,44931,44935,44982,45327,
   45328,45330,45334,45499,45501,45505,45526,45530,45577,47084,
   47086,47090,47111,47115,47162,49471,49475,49522,49822],
 [6902,6919,7822,7828,7829,8224,8225,8390,17282,17288,17289,
   17684,17685,17850,40424,40425,40590,47575],
 [6902,6919,7823,7824,7828,8250,8254,8283,17283,17284,17288,
   17710,17714,17743,40450,40454,40483,47903],
 [6902,6919,7823,7824,7828,8250,8254,8283,17283,17284,17288,
   17710,17714,17743,40450,40454,40483,47903],[],[],
 [6902,6919,7817,7827,7828,8058,8059,8364,17277,17287,17288,
   17518,17519,17824,40258,40259,40564,44904],[7828],
 [6902,6919,7822,7828,7829,8224,8225,8390,17282,17288,17289,
   17684,17685,17850,40424,40425,40590,47575],
 [6902,6903,6919,6925,7812,7814,7828,7830,7834,7855,7869,7871,
   7875,7948,7950,7954,8391,8395,8442,17272,17274,17288,17290,
   17294,17315,17329,17331,17335,17408,17410,17414,17851,17855,
   17902,40055,40069,40071,40075,40148,40150,40154,40591,40595,
   40642,40968,40970,40974,41411,41415,41462,42932,42936,42983,
   49822],[],
 [6900,6901,6902,6903,6905,6919,6921,6925,7725,7726,7727,7728,
   7729,7743,7745,7747,7749,7769,7770,7771,7772,7786,7788,7790,
   7792,7812,7813,7814,7828,7830,7832,7834,7854,7855,7869,7871,
   7873,7875,7895,7909,7911,7913,7915,7948,7950,7952,7954,8391,
   8393,8395,8440,8442,8485,17185,17186,17187,17188,17189,17203,
   17205,17207,17209,17229,17230,17231,17232,17246,17248,17250,
   17252,17272,17273,17274,17288,17290,17292,17294,17314,17315,
   17329,17331,17333,17335,17355,17369,17371,17373,17375,17408,
   17410,17412,17414,17851,17853,17855,17900,17902,17945,38205,
   38206,38207,38208,38222,38224,38226,38228,38248,38249,38250,
   38264,38266,38268,38270,38290,38291,38305,38307,38309,38311,
   38331,38345,38347,38349,38351,38384,38386,38388,38390,38827,
   38829,38831,38876,38878,38921,39151,39152,39153,39167,39169,
   39171,39173,39193,39194,39208,39210,39212,39214,39234,39248,
   39250,39252,39254,39287,39289,39291,39293,39730,39732,39734,
   39779,39781,39824,40054,40055,40069,40071,40073,40075,40095,
   40109,40111,40113,40115,40148,40150,40152,40154,40591,40593,
   40595,40640,40642,40685,40915,40929,40931,40933,40935,40968,
   40970,40972,40974,41411,41413,41415,41460,41462,41505,41748,
   41750,41752,41754,42191,42193,42195,42240,42242,42285,42932,
   42934,42936,42981,42983,43026,49820,49822,49865,50394],
 [8507,17967],[7875,17335],[8168],[8507,17967],[8032],
 [7996,17456],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[14635],[8962],[],[],[],
 [],[],[],[],[],[],[],[],[],
 [6961,6978,7725,7726,7743,7769,7786,7828,18896,18897,18914,
   18940,18957,18999,38205,38222,38264,39167],
 [6961,6978,7725,7726,7743,7769,7786,7828,18896,18897,18914,
   18940,18957,18999,38205,38222,38264,39167],[7828],
 [6961,6978,7812,7814,7828,7830,7834,7855,7869,7871,7875,7948,
   7950,7954,8391,8395,8442,18983,18985,18999,19001,19005,19026,
   19040,19042,19046,19119,19121,19125,19562,19566,19613,40055,
   40069,40071,40075,40148,40150,40154,40591,40595,40642,40968,
   40970,40974,41411,41415,41462,42932,42936,42983,49822],
 [6961,6978,7813,7828,7832,7909,7913,8393,18984,18999,19003,
   19080,19084,19564,40109,40113,40593,42193],
 [6961,6978,7812,7814,7828,7830,7834,7855,7869,7871,7875,7948,
   7950,7954,8391,8395,8442,18983,18985,18999,19001,19005,19026,
   19040,19042,19046,19119,19121,19125,19562,19566,19613,40055,
   40069,40071,40075,40148,40150,40154,40591,40595,40642,40968,
   40970,40974,41411,41415,41462,42932,42936,42983,49822],
 [7996,19167],[8032],
 [6961,6978,7817,7827,7828,8058,8059,8364,18988,18998,18999,
   19229,19230,19535,40258,40259,40564,44904],
 [6961,6978,7818,7821,7828,8087,8094,8193,18989,18992,18999,
   19258,19265,19364,40287,40294,40393,45328],[],[8168],
 [6961,6978,7818,7821,7828,8087,8094,8193,18989,18992,18999,
   19258,19265,19364,40287,40294,40393,45328],
 [6961,6978,7822,7828,7829,8224,8225,8390,18993,18999,19000,
   19395,19396,19561,40424,40425,40590,47575],
 [6961,6978,7823,7824,7828,8250,8254,8283,18994,18995,18999,
   19421,19425,19454,40450,40454,40483,47903],
 [6961,6978,7823,7824,7828,8250,8254,8283,18994,18995,18999,
   19421,19425,19454,40450,40454,40483,47903],
 [6961,6978,7825,7828,7831,8311,8314,8392,18996,18999,19002,
   19482,19485,19563,40511,40514,40592,48796],[],
 [6961,6978,7817,7827,7828,8058,8059,8364,18988,18998,18999,
   19229,19230,19535,40258,40259,40564,44904],[7828],
 [6961,6978,7822,7828,7829,8224,8225,8390,18993,18999,19000,
   19395,19396,19561,40424,40425,40590,47575],
 [6961,6978,7812,7814,7828,7830,7834,7855,7869,7871,7875,7948,
   7950,7954,8391,8395,8442,18983,18985,18999,19001,19005,19026,
   19040,19042,19046,19119,19121,19125,19562,19566,19613,40055,
   40069,40071,40075,40148,40150,40154,40591,40595,40642,40968,
   40970,40974,41411,41415,41462,42932,42936,42983,49822],
 [6961,6978,7825,7828,7831,8311,8314,8392,18996,18999,19002,
   19482,19485,19563,40511,40514,40592,48796],
 [6961,6978,7813,7828,7832,7909,7913,8393,18984,18999,19003,
   19080,19084,19564,40109,40113,40593,42193],[8507,19678],
 [6961,6978,7812,7814,7828,7830,7834,7855,7869,7871,7875,7948,
   7950,7954,8391,8395,8442,18983,18985,18999,19001,19005,19026,
   19040,19042,19046,19119,19121,19125,19562,19566,19613,40055,
   40069,40071,40075,40148,40150,40154,40591,40595,40642,40968,
   40970,40974,41411,41415,41462,42932,42936,42983,49822],
 [8168],[8507,19678],[8032],[7996,19167],[],[],[],
 [],[6961,6978,7828,7843,7850,8404,8411,8666,18999,19014,
   19021,19575,19582,19837,40604,40611,40866,50046],
 [6961,6978,7828,7844,7845,7852,7853,8405,8406,8413,8414,8670,
   8678,8685,8714,18999,19015,19016,19023,19024,19576,19577,
   19584,19585,19841,19848,19849,19856,19857,19885,40605,40606,
   40613,40614,40870,40877,40878,40885,40886,40914,50050,50057,
   50058,50065,50066,50094,52281,52282,52310,52338],
 [6961,6978,7828,7844,7845,7852,7853,8405,8406,8413,8414,8670,
   8678,8685,8714,18999,19015,19016,19023,19024,19576,19577,
   19584,19585,19841,19848,19849,19856,19857,19885,40605,40606,
   40613,40614,40870,40877,40878,40885,40886,40914,50050,50057,
   50058,50065,50066,50094,52281,52282,52310,52338],[19862],
 [6961,6978,7828,7847,7849,8408,8410,8695,18999,19018,19020,
   19579,19581,19866,40608,40610,40895,50075],[],
 [6961,6978,7828,7847,7849,8408,8410,8695,18999,19018,19020,
   19579,19581,19866,40608,40610,40895,50075],
 [6961,6978,7828,7843,7850,8404,8411,8666,18999,19014,19021,
   19575,19582,19837,40604,40611,40866,50046],[19862],
 [6961,6978,7828,7844,7845,7852,7853,8405,8406,8413,8414,8670,
   8678,8685,8714,18999,19015,19016,19023,19024,19576,19577,
   19584,19585,19841,19848,19849,19856,19857,19885,40605,40606,
   40613,40614,40870,40877,40878,40885,40886,40914,50050,50057,
   50058,50065,50066,50094,52281,52282,52310,52338],
 [6961,6978,7828,7844,7845,7852,7853,8405,8406,8413,8414,8670,
   8678,8685,8714,18999,19015,19016,19023,19024,19576,19577,
   19584,19585,19841,19848,19849,19856,19857,19885,40605,40606,
   40613,40614,40870,40877,40878,40885,40886,40914,50050,50057,
   50058,50065,50066,50094,52281,52282,52310,52338],[],[],
 [],[],[],[],[],[],[],[],[],[],[],
 [7019,7036,7725,7726,7743,7769,7786,7828,20549,20550,20567,
   20593,20610,20652,38205,38222,38264,39167],
 [7019,7036,7725,7726,7743,7769,7786,7828,20549,20550,20567,
   20593,20610,20652,38205,38222,38264,39167],[7828],
 [7875,20699],
 [6825,6826,6842,6844,6849,6852,6859,6863,6945,6961,6963,6968,
   6971,6978,6982,7019,7026,7029,7036,7813,7818,7821,7828,7832,
   7899,7902,7909,7913,8087,8094,8098,8193,8197,8393,14635,
   14651,14653,14658,14661,14668,14672,14709,14711,14716,14719,
   14726,14730,15503,15508,15511,15518,15522,15589,15592,15599,
   15603,15777,15784,15788,15883,15887,16083,18190,18192,18197,
   18200,18207,18211,18984,18989,18992,18999,19003,19070,19073,
   19080,19084,19258,19265,19269,19364,19368,19564,20637,20642,
   20645,20652,20656,20723,20726,20733,20737,20911,20918,20922,
   21017,21021,21217,40099,40102,40109,40113,40287,40294,40298,
   40393,40397,40593,41887,41894,41898,41993,41997,42193,45328,
   45332,45528,47113],[7950,20774],[7996,20820],[8032],
 [7019,7036,7817,7827,7828,8058,8059,8364,20641,20651,20652,
   20882,20883,21188,40258,40259,40564,44904],
 [7019,7036,7818,7821,7828,8087,8094,8193,20642,20645,20652,
   20911,20918,21017,40287,40294,40393,45328],[],[8168],
 [7019,7036,7818,7821,7828,8087,8094,8193,20642,20645,20652,
   20911,20918,21017,40287,40294,40393,45328],
 [7018,7019,7036,7769,7780,7786,7787,7822,7828,7829,8224,8225,
   8390,20593,20604,20610,20611,20646,20652,20653,21048,21049,
   21214,39161,39167,39168,39563,39564,39729,40424,40425,40590,
   47575],
 [7019,7036,7823,7824,7828,8250,8254,8283,20647,20648,20652,
   21074,21078,21107,40450,40454,40483,47903],
 [7019,7036,7823,7824,7828,8250,8254,8283,20647,20648,20652,
   21074,21078,21107,40450,40454,40483,47903],[],[],
 [7019,7036,7817,7827,7828,8058,8059,8364,20641,20651,20652,
   20882,20883,21188,40258,40259,40564,44904],[7828],
 [7018,7019,7036,7769,7780,7786,7787,7822,7828,7829,8224,8225,
   8390,20593,20604,20610,20611,20646,20652,20653,21048,21049,
   21214,39161,39167,39168,39563,39564,39729,40424,40425,40590,
   47575],[7950,20774],[],
 [6825,6826,6842,6844,6849,6852,6859,6863,6945,6961,6963,6968,
   6971,6978,6982,7019,7026,7029,7036,7813,7818,7821,7828,7832,
   7899,7902,7909,7913,8087,8094,8098,8193,8197,8393,14635,
   14651,14653,14658,14661,14668,14672,14709,14711,14716,14719,
   14726,14730,15503,15508,15511,15518,15522,15589,15592,15599,
   15603,15777,15784,15788,15883,15887,16083,18190,18192,18197,
   18200,18207,18211,18984,18989,18992,18999,19003,19070,19073,
   19080,19084,19258,19265,19269,19364,19368,19564,20637,20642,
   20645,20652,20656,20723,20726,20733,20737,20911,20918,20922,
   21017,21021,21217,40099,40102,40109,40113,40287,40294,40298,
   40393,40397,40593,41887,41894,41898,41993,41997,42193,45328,
   45332,45528,47113],[8507,21331],[7875,20699],[8168],
 [8507,21331],[8032],[7996,20820],[],[],[],[],[],
 [7019,7036,7828,7844,7845,8405,8406,8670,20652,20668,20669,
   21229,21230,21494,40605,40606,40870,50050],
 [7019,7036,7828,7844,7845,8405,8406,8670,20652,20668,20669,
   21229,21230,21494,40605,40606,40870,50050],[],[],[],
 [],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],
 [7076,7077,7079,7093,7095,7099,7725,7726,7727,7728,7729,7743,
   7745,7747,7749,7769,7770,7771,7772,7786,7788,7790,7792,7812,
   7813,7814,7828,7830,7832,7834,7854,7855,7869,7871,7873,7875,
   7895,7909,7911,7913,7915,7948,7950,7952,7954,8391,8393,8395,
   8440,8442,8485,22145,22146,22147,22148,22149,22163,22165,
   22167,22169,22189,22190,22191,22192,22206,22208,22210,22212,
   22232,22233,22234,22248,22250,22252,22254,22274,22275,22289,
   22291,22293,22295,22315,22329,22331,22333,22335,22368,22370,
   22372,22374,22811,22813,22815,22860,22862,22905,38205,38206,
   38207,38208,38222,38224,38226,38228,38248,38249,38250,38264,
   38266,38268,38270,38290,38291,38305,38307,38309,38311,38331,
   38345,38347,38349,38351,38384,38386,38388,38390,38827,38829,
   38831,38876,38878,38921,39151,39152,39153,39167,39169,39171,
   39173,39193,39194,39208,39210,39212,39214,39234,39248,39250,
   39252,39254,39287,39289,39291,39293,39730,39732,39734,39779,
   39781,39824,40054,40055,40069,40071,40073,40075,40095,40109,
   40111,40113,40115,40148,40150,40152,40154,40591,40593,40595,
   40640,40642,40685,40915,40929,40931,40933,40935,40968,40970,
   40972,40974,41411,41413,41415,41460,41462,41505,41748,41750,
   41752,41754,42191,42193,42195,42240,42242,42285,42932,42934,
   42936,42981,42983,43026,49820,49822,49865,50394],
 [7076,7077,7079,7093,7095,7099,7725,7726,7727,7728,7729,7743,
   7745,7747,7749,7769,7770,7771,7772,7786,7788,7790,7792,7812,
   7813,7814,7828,7830,7832,7834,7854,7855,7869,7871,7873,7875,
   7895,7909,7911,7913,7915,7948,7950,7952,7954,8391,8393,8395,
   8440,8442,8485,22145,22146,22147,22148,22149,22163,22165,
   22167,22169,22189,22190,22191,22192,22206,22208,22210,22212,
   22232,22233,22234,22248,22250,22252,22254,22274,22275,22289,
   22291,22293,22295,22315,22329,22331,22333,22335,22368,22370,
   22372,22374,22811,22813,22815,22860,22862,22905,38205,38206,
   38207,38208,38222,38224,38226,38228,38248,38249,38250,38264,
   38266,38268,38270,38290,38291,38305,38307,38309,38311,38331,
   38345,38347,38349,38351,38384,38386,38388,38390,38827,38829,
   38831,38876,38878,38921,39151,39152,39153,39167,39169,39171,
   39173,39193,39194,39208,39210,39212,39214,39234,39248,39250,
   39252,39254,39287,39289,39291,39293,39730,39732,39734,39779,
   39781,39824,40054,40055,40069,40071,40073,40075,40095,40109,
   40111,40113,40115,40148,40150,40152,40154,40591,40593,40595,
   40640,40642,40685,40915,40929,40931,40933,40935,40968,40970,
   40972,40974,41411,41413,41415,41460,41462,41505,41748,41750,
   41752,41754,42191,42193,42195,42240,42242,42285,42932,42934,
   42936,42981,42983,43026,49820,49822,49865,50394],[7828],
 [7875],
 [7076,7077,7079,7093,7095,7099,7725,7726,7727,7728,7729,7743,
   7745,7747,7749,7769,7770,7771,7772,7786,7788,7790,7792,7812,
   7813,7814,7828,7830,7832,7834,7854,7855,7869,7871,7873,7875,
   7895,7909,7911,7913,7915,7948,7950,7952,7954,8391,8393,8395,
   8440,8442,8485,22145,22146,22147,22148,22149,22163,22165,
   22167,22169,22189,22190,22191,22192,22206,22208,22210,22212,
   22232,22233,22234,22248,22250,22252,22254,22274,22275,22289,
   22291,22293,22295,22315,22329,22331,22333,22335,22368,22370,
   22372,22374,22811,22813,22815,22860,22862,22905,38205,38206,
   38207,38208,38222,38224,38226,38228,38248,38249,38250,38264,
   38266,38268,38270,38290,38291,38305,38307,38309,38311,38331,
   38345,38347,38349,38351,38384,38386,38388,38390,38827,38829,
   38831,38876,38878,38921,39151,39152,39153,39167,39169,39171,
   39173,39193,39194,39208,39210,39212,39214,39234,39248,39250,
   39252,39254,39287,39289,39291,39293,39730,39732,39734,39779,
   39781,39824,40054,40055,40069,40071,40073,40075,40095,40109,
   40111,40113,40115,40148,40150,40152,40154,40591,40593,40595,
   40640,40642,40685,40915,40929,40931,40933,40935,40968,40970,
   40972,40974,41411,41413,41415,41460,41462,41505,41748,41750,
   41752,41754,42191,42193,42195,42240,42242,42285,42932,42934,
   42936,42981,42983,43026,49820,49822,49865,50394],
 [7950,22370],[7996,22416],[8032],
 [7076,7077,7079,7093,7095,7099,7812,7814,7817,7818,7821,7827,
   7828,7830,7834,7855,7858,7859,7862,7868,7869,7871,7875,7937,
   7938,7941,7947,7948,7950,7954,8049,8052,8058,8059,8061,8065,
   8087,8093,8094,8096,8100,8192,8193,8195,8199,8364,8366,8370,
   8391,8395,8442,22232,22234,22237,22238,22241,22247,22248,
   22250,22254,22275,22278,22279,22282,22288,22289,22291,22295,
   22357,22358,22361,22367,22368,22370,22374,22469,22472,22478,
   22479,22481,22485,22507,22513,22514,22516,22520,22612,22613,
   22615,22619,22784,22786,22790,22811,22815,22862,40055,40058,
   40059,40062,40068,40069,40071,40075,40137,40138,40141,40147,
   40148,40150,40154,40249,40252,40258,40259,40261,40265,40287,
   40293,40294,40296,40300,40392,40393,40395,40399,40564,40566,
   40570,40591,40595,40642,40957,40958,40961,40967,40968,40970,
   40974,41069,41072,41078,41079,41081,41085,41107,41113,41114,
   41116,41120,41212,41213,41215,41219,41384,41386,41390,41411,
   41415,41462,42590,42593,42599,42600,42602,42606,42628,42634,
   42635,42637,42641,42733,42734,42736,42740,42905,42907,42911,
   42932,42936,42983,44627,44633,44634,44636,44640,44732,44733,
   44735,44739,44904,44906,44910,44931,44935,44982,45327,45328,
   45330,45334,45499,45501,45505,45526,45530,45577,47084,47086,
   47090,47111,47115,47162,49471,49475,49522,49822],
 [7076,7077,7079,7093,7095,7099,7812,7814,7817,7818,7821,7827,
   7828,7830,7834,7855,7858,7859,7862,7868,7869,7871,7875,7937,
   7938,7941,7947,7948,7950,7954,8049,8052,8058,8059,8061,8065,
   8087,8093,8094,8096,8100,8192,8193,8195,8199,8364,8366,8370,
   8391,8395,8442,22232,22234,22237,22238,22241,22247,22248,
   22250,22254,22275,22278,22279,22282,22288,22289,22291,22295,
   22357,22358,22361,22367,22368,22370,22374,22469,22472,22478,
   22479,22481,22485,22507,22513,22514,22516,22520,22612,22613,
   22615,22619,22784,22786,22790,22811,22815,22862,40055,40058,
   40059,40062,40068,40069,40071,40075,40137,40138,40141,40147,
   40148,40150,40154,40249,40252,40258,40259,40261,40265,40287,
   40293,40294,40296,40300,40392,40393,40395,40399,40564,40566,
   40570,40591,40595,40642,40957,40958,40961,40967,40968,40970,
   40974,41069,41072,41078,41079,41081,41085,41107,41113,41114,
   41116,41120,41212,41213,41215,41219,41384,41386,41390,41411,
   41415,41462,42590,42593,42599,42600,42602,42606,42628,42634,
   42635,42637,42641,42733,42734,42736,42740,42905,42907,42911,
   42932,42936,42983,44627,44633,44634,44636,44640,44732,44733,
   44735,44739,44904,44906,44910,44931,44935,44982,45327,45328,
   45330,45334,45499,45501,45505,45526,45530,45577,47084,47086,
   47090,47111,47115,47162,49471,49475,49522,49822],[],
 [8168],
 [7076,7077,7079,7093,7095,7099,7812,7814,7817,7818,7821,7827,
   7828,7830,7834,7855,7858,7859,7862,7868,7869,7871,7875,7937,
   7938,7941,7947,7948,7950,7954,8049,8052,8058,8059,8061,8065,
   8087,8093,8094,8096,8100,8192,8193,8195,8199,8364,8366,8370,
   8391,8395,8442,22232,22234,22237,22238,22241,22247,22248,
   22250,22254,22275,22278,22279,22282,22288,22289,22291,22295,
   22357,22358,22361,22367,22368,22370,22374,22469,22472,22478,
   22479,22481,22485,22507,22513,22514,22516,22520,22612,22613,
   22615,22619,22784,22786,22790,22811,22815,22862,40055,40058,
   40059,40062,40068,40069,40071,40075,40137,40138,40141,40147,
   40148,40150,40154,40249,40252,40258,40259,40261,40265,40287,
   40293,40294,40296,40300,40392,40393,40395,40399,40564,40566,
   40570,40591,40595,40642,40957,40958,40961,40967,40968,40970,
   40974,41069,41072,41078,41079,41081,41085,41107,41113,41114,
   41116,41120,41212,41213,41215,41219,41384,41386,41390,41411,
   41415,41462,42590,42593,42599,42600,42602,42606,42628,42634,
   42635,42637,42641,42733,42734,42736,42740,42905,42907,42911,
   42932,42936,42983,44627,44633,44634,44636,44640,44732,44733,
   44735,44739,44904,44906,44910,44931,44935,44982,45327,45328,
   45330,45334,45499,45501,45505,45526,45530,45577,47084,47086,
   47090,47111,47115,47162,49471,49475,49522,49822],
 [7076,7077,7079,7093,7095,7099,7812,7814,7822,7823,7824,7828,
   7829,7830,7834,7855,7863,7864,7865,7869,7870,7871,7875,7942,
   7943,7944,7948,7949,7950,7954,8219,8220,8224,8225,8226,8230,
   8250,8254,8255,8256,8260,8283,8284,8285,8289,8390,8391,8395,
   8415,8419,8442,22232,22234,22242,22243,22244,22248,22249,
   22250,22254,22275,22283,22284,22285,22289,22290,22291,22295,
   22362,22363,22364,22368,22369,22370,22374,22639,22640,22644,
   22645,22646,22650,22670,22674,22675,22676,22680,22703,22704,
   22705,22709,22810,22811,22815,22835,22839,22862,40055,40063,
   40064,40065,40069,40070,40071,40075,40142,40143,40144,40148,
   40149,40150,40154,40419,40420,40424,40425,40426,40430,40450,
   40454,40455,40456,40460,40483,40484,40485,40489,40590,40591,
   40595,40615,40619,40642,40962,40963,40964,40968,40969,40970,
   40974,41239,41240,41244,41245,41246,41250,41270,41274,41275,
   41276,41280,41303,41304,41305,41309,41410,41411,41415,41435,
   41439,41462,42760,42761,42765,42766,42767,42771,42791,42795,
   42796,42797,42801,42824,42825,42826,42830,42931,42932,42936,
   42956,42960,42983,47435,47439,47440,47441,47445,47468,47469,
   47470,47474,47575,47576,47580,47600,47604,47627,47903,47904,
   47905,47909,48010,48011,48015,48035,48039,48062,48416,48417,
   48421,48441,48445,48468,49795,49799,49822,50098],
 [7076,7077,7079,7093,7095,7099,7812,7814,7822,7823,7824,7828,
   7829,7830,7834,7855,7863,7864,7865,7869,7870,7871,7875,7942,
   7943,7944,7948,7949,7950,7954,8219,8220,8224,8225,8226,8230,
   8250,8254,8255,8256,8260,8283,8284,8285,8289,8390,8391,8395,
   8415,8419,8442,22232,22234,22242,22243,22244,22248,22249,
   22250,22254,22275,22283,22284,22285,22289,22290,22291,22295,
   22362,22363,22364,22368,22369,22370,22374,22639,22640,22644,
   22645,22646,22650,22670,22674,22675,22676,22680,22703,22704,
   22705,22709,22810,22811,22815,22835,22839,22862,40055,40063,
   40064,40065,40069,40070,40071,40075,40142,40143,40144,40148,
   40149,40150,40154,40419,40420,40424,40425,40426,40430,40450,
   40454,40455,40456,40460,40483,40484,40485,40489,40590,40591,
   40595,40615,40619,40642,40962,40963,40964,40968,40969,40970,
   40974,41239,41240,41244,41245,41246,41250,41270,41274,41275,
   41276,41280,41303,41304,41305,41309,41410,41411,41415,41435,
   41439,41462,42760,42761,42765,42766,42767,42771,42791,42795,
   42796,42797,42801,42824,42825,42826,42830,42931,42932,42936,
   42956,42960,42983,47435,47439,47440,47441,47445,47468,47469,
   47470,47474,47575,47576,47580,47600,47604,47627,47903,47904,
   47905,47909,48010,48011,48015,48035,48039,48062,48416,48417,
   48421,48441,48445,48468,49795,49799,49822,50098],
 [7076,7077,7079,7093,7095,7099,7812,7814,7822,7823,7824,7828,
   7829,7830,7834,7855,7863,7864,7865,7869,7870,7871,7875,7942,
   7943,7944,7948,7949,7950,7954,8219,8220,8224,8225,8226,8230,
   8250,8254,8255,8256,8260,8283,8284,8285,8289,8390,8391,8395,
   8415,8419,8442,22232,22234,22242,22243,22244,22248,22249,
   22250,22254,22275,22283,22284,22285,22289,22290,22291,22295,
   22362,22363,22364,22368,22369,22370,22374,22639,22640,22644,
   22645,22646,22650,22670,22674,22675,22676,22680,22703,22704,
   22705,22709,22810,22811,22815,22835,22839,22862,40055,40063,
   40064,40065,40069,40070,40071,40075,40142,40143,40144,40148,
   40149,40150,40154,40419,40420,40424,40425,40426,40430,40450,
   40454,40455,40456,40460,40483,40484,40485,40489,40590,40591,
   40595,40615,40619,40642,40962,40963,40964,40968,40969,40970,
   40974,41239,41240,41244,41245,41246,41250,41270,41274,41275,
   41276,41280,41303,41304,41305,41309,41410,41411,41415,41435,
   41439,41462,42760,42761,42765,42766,42767,42771,42791,42795,
   42796,42797,42801,42824,42825,42826,42830,42931,42932,42936,
   42956,42960,42983,47435,47439,47440,47441,47445,47468,47469,
   47470,47474,47575,47576,47580,47600,47604,47627,47903,47904,
   47905,47909,48010,48011,48015,48035,48039,48062,48416,48417,
   48421,48441,48445,48468,49795,49799,49822,50098],[],[],
 [7076,7077,7079,7093,7095,7099,7812,7814,7817,7818,7821,7827,
   7828,7830,7834,7855,7858,7859,7862,7868,7869,7871,7875,7937,
   7938,7941,7947,7948,7950,7954,8049,8052,8058,8059,8061,8065,
   8087,8093,8094,8096,8100,8192,8193,8195,8199,8364,8366,8370,
   8391,8395,8442,22232,22234,22237,22238,22241,22247,22248,
   22250,22254,22275,22278,22279,22282,22288,22289,22291,22295,
   22357,22358,22361,22367,22368,22370,22374,22469,22472,22478,
   22479,22481,22485,22507,22513,22514,22516,22520,22612,22613,
   22615,22619,22784,22786,22790,22811,22815,22862,40055,40058,
   40059,40062,40068,40069,40071,40075,40137,40138,40141,40147,
   40148,40150,40154,40249,40252,40258,40259,40261,40265,40287,
   40293,40294,40296,40300,40392,40393,40395,40399,40564,40566,
   40570,40591,40595,40642,40957,40958,40961,40967,40968,40970,
   40974,41069,41072,41078,41079,41081,41085,41107,41113,41114,
   41116,41120,41212,41213,41215,41219,41384,41386,41390,41411,
   41415,41462,42590,42593,42599,42600,42602,42606,42628,42634,
   42635,42637,42641,42733,42734,42736,42740,42905,42907,42911,
   42932,42936,42983,44627,44633,44634,44636,44640,44732,44733,
   44735,44739,44904,44906,44910,44931,44935,44982,45327,45328,
   45330,45334,45499,45501,45505,45526,45530,45577,47084,47086,
   47090,47111,47115,47162,49471,49475,49522,49822],[7828],
 [7076,7077,7079,7093,7095,7099,7812,7814,7822,7823,7824,7828,
   7829,7830,7834,7855,7863,7864,7865,7869,7870,7871,7875,7942,
   7943,7944,7948,7949,7950,7954,8219,8220,8224,8225,8226,8230,
   8250,8254,8255,8256,8260,8283,8284,8285,8289,8390,8391,8395,
   8415,8419,8442,22232,22234,22242,22243,22244,22248,22249,
   22250,22254,22275,22283,22284,22285,22289,22290,22291,22295,
   22362,22363,22364,22368,22369,22370,22374,22639,22640,22644,
   22645,22646,22650,22670,22674,22675,22676,22680,22703,22704,
   22705,22709,22810,22811,22815,22835,22839,22862,40055,40063,
   40064,40065,40069,40070,40071,40075,40142,40143,40144,40148,
   40149,40150,40154,40419,40420,40424,40425,40426,40430,40450,
   40454,40455,40456,40460,40483,40484,40485,40489,40590,40591,
   40595,40615,40619,40642,40962,40963,40964,40968,40969,40970,
   40974,41239,41240,41244,41245,41246,41250,41270,41274,41275,
   41276,41280,41303,41304,41305,41309,41410,41411,41415,41435,
   41439,41462,42760,42761,42765,42766,42767,42771,42791,42795,
   42796,42797,42801,42824,42825,42826,42830,42931,42932,42936,
   42956,42960,42983,47435,47439,47440,47441,47445,47468,47469,
   47470,47474,47575,47576,47580,47600,47604,47627,47903,47904,
   47905,47909,48010,48011,48015,48035,48039,48062,48416,48417,
   48421,48441,48445,48468,49795,49799,49822,50098],
 [7950,22370],[],
 [7076,7077,7079,7093,7095,7099,7725,7726,7727,7728,7729,7743,
   7745,7747,7749,7769,7770,7771,7772,7786,7788,7790,7792,7812,
   7813,7814,7828,7830,7832,7834,7854,7855,7869,7871,7873,7875,
   7895,7909,7911,7913,7915,7948,7950,7952,7954,8391,8393,8395,
   8440,8442,8485,22145,22146,22147,22148,22149,22163,22165,
   22167,22169,22189,22190,22191,22192,22206,22208,22210,22212,
   22232,22233,22234,22248,22250,22252,22254,22274,22275,22289,
   22291,22293,22295,22315,22329,22331,22333,22335,22368,22370,
   22372,22374,22811,22813,22815,22860,22862,22905,38205,38206,
   38207,38208,38222,38224,38226,38228,38248,38249,38250,38264,
   38266,38268,38270,38290,38291,38305,38307,38309,38311,38331,
   38345,38347,38349,38351,38384,38386,38388,38390,38827,38829,
   38831,38876,38878,38921,39151,39152,39153,39167,39169,39171,
   39173,39193,39194,39208,39210,39212,39214,39234,39248,39250,
   39252,39254,39287,39289,39291,39293,39730,39732,39734,39779,
   39781,39824,40054,40055,40069,40071,40073,40075,40095,40109,
   40111,40113,40115,40148,40150,40152,40154,40591,40593,40595,
   40640,40642,40685,40915,40929,40931,40933,40935,40968,40970,
   40972,40974,41411,41413,41415,41460,41462,41505,41748,41750,
   41752,41754,42191,42193,42195,42240,42242,42285,42932,42934,
   42936,42981,42983,43026,49820,49822,49865,50394],
 [8507,22927],[7875],[8168],[8507,22927],[8032],
 [7996,22416],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[12979],[],[],[],[],
 [],[],[],[],[],[],
 [7132,7149,7725,7726,7743,7769,7786,7828,23685,23686,23703,
   23729,23746,23788,38205,38222,38264,39167],
 [7132,7149,7725,7726,7743,7769,7786,7828,23685,23686,23703,
   23729,23746,23788,38205,38222,38264,39167],[7828],
 [7875,23835],
 [7132,7149,7813,7828,7832,7909,7913,8393,23773,23788,23792,
   23869,23873,24353,40109,40113,40593,42193],[7950,23910],
 [7996,23956],[8032],
 [7132,7149,7817,7827,7828,8058,8059,8364,23777,23787,23788,
   24018,24019,24324,40258,40259,40564,44904],
 [7132,7149,7818,7821,7828,8087,8094,8193,23788,24054,24153,
   40287,40294,40393,45328],[],[8168],
 [7132,7149,7818,7821,7828,8087,8094,8193,23788,24054,24153,
   40287,40294,40393,45328],
 [7132,7149,7822,7828,7829,8224,8225,8390,23782,23788,23789,
   24184,24185,24350,40424,40425,40590,47575],
 [7132,7138,7148,7149,7817,7823,7824,7827,7828,8054,8055,8058,
   8059,8250,8253,8254,8282,8283,8364,23777,23783,23784,23787,
   23788,24014,24015,24018,24019,24210,24213,24214,24242,24243,
   24324,40254,40255,40258,40259,40450,40453,40454,40482,40483,
   40564,44790,44793,44794,44822,44823,44904,47902,47903,47984,
   48390],
 [7132,7138,7148,7149,7817,7823,7824,7827,7828,8054,8055,8058,
   8059,8250,8253,8254,8282,8283,8364,23777,23783,23784,23787,
   23788,24014,24015,24018,24019,24210,24213,24214,24242,24243,
   24324,40254,40255,40258,40259,40450,40453,40454,40482,40483,
   40564,44790,44793,44794,44822,44823,44904,47902,47903,47984,
   48390],[],[],
 [7132,7149,7817,7827,7828,8058,8059,8364,23777,23787,23788,
   24018,24019,24324,40258,40259,40564,44904],[7828],
 [7132,7149,7822,7828,7829,8224,8225,8390,23782,23788,23789,
   24184,24185,24350,40424,40425,40590,47575],[7950,23910],
 [],[7132,7149,7813,7828,7832,7909,7913,8393,23773,23788,
   23792,23869,23873,24353,40109,40113,40593,42193],
 [8507,24467],[7875,23835],[8168],[8507,24467],[8032],
 [7996,23956],[],[],[],[],
 [7132,7149,7828,7843,7850,8404,8411,8666,23788,23803,23810,
   24364,24371,24626,40604,40611,40866,50046],[],[],[],
 [],[],[],
 [7132,7149,7828,7843,7850,8404,8411,8666,23788,23803,23810,
   24364,24371,24626,40604,40611,40866,50046],[],[],[],
 [],[],[],[],[],[],[],[],[],[],
 [7187,7204,7725,7726,7743,7769,7786,7828,25170,25171,25188,
   25214,25231,25273,38205,38222,38264,39167],
 [7187,7204,7725,7726,7743,7769,7786,7828,25170,25171,25188,
   25214,25231,25273,38205,38222,38264,39167],[7828],
 [7875,25320],
 [7187,7204,7813,7828,7832,7909,7913,8393,25258,25273,25277,
   25354,25358,25838,40109,40113,40593,42193],[7950,25395],
 [7996,25441],[8032],
 [7187,7204,7817,7827,7828,8058,8059,8364,25262,25272,25273,
   25503,25504,25809,40258,40259,40564,44904],
 [6767,6768,6781,6783,6788,6791,6798,6802,7119,7132,7134,7139,
   7142,7149,7153,7187,7189,7204,7208,7813,7818,7821,7828,7832,
   7899,7902,7909,7913,8087,8094,8098,8193,8197,8393,12979,
   12992,12994,12999,13002,13009,13013,13047,13049,13054,13057,
   13064,13068,13673,13678,13681,13688,13692,13759,13762,13769,
   13773,13947,13954,13958,14053,14057,14253,23147,23149,23154,
   23157,23164,23168,23773,23778,23781,23788,23792,23859,23862,
   23869,23873,24047,24054,24058,24153,24157,24353,25258,25263,
   25266,25273,25277,25344,25347,25354,25358,25532,25539,25543,
   25638,25642,25838,40099,40102,40109,40113,40287,40294,40298,
   40393,40397,40593,41887,41894,41898,41993,41997,42193,45328,
   45332,45528,47113],[],[8168],
 [6767,6768,6781,6783,6788,6791,6798,6802,7119,7132,7134,7139,
   7142,7149,7153,7187,7189,7204,7208,7813,7818,7821,7828,7832,
   7899,7902,7909,7913,8087,8094,8098,8193,8197,8393,12979,
   12992,12994,12999,13002,13009,13013,13047,13049,13054,13057,
   13064,13068,13673,13678,13681,13688,13692,13759,13762,13769,
   13773,13947,13954,13958,14053,14057,14253,23147,23149,23154,
   23157,23164,23168,23773,23778,23781,23788,23792,23859,23862,
   23869,23873,24047,24054,24058,24153,24157,24353,25258,25263,
   25266,25273,25277,25344,25347,25354,25358,25532,25539,25543,
   25638,25642,25838,40099,40102,40109,40113,40287,40294,40298,
   40393,40397,40593,41887,41894,41898,41993,41997,42193,45328,
   45332,45528,47113],
 [7187,7204,7822,7828,7829,8224,8225,8390,25267,25273,25274,
   25669,25670,25835,40424,40425,40590,47575],
 [7187,7193,7203,7204,7817,7823,7824,7827,7828,8054,8055,8058,
   8059,8250,8253,8254,8282,8283,8364,25262,25268,25269,25272,
   25273,25499,25500,25503,25504,25695,25698,25699,25727,25728,
   25809,40254,40255,40258,40259,40450,40453,40454,40482,40483,
   40564,44790,44793,44794,44822,44823,44904,47902,47903,47984,
   48390],
 [7187,7193,7203,7204,7817,7823,7824,7827,7828,8054,8055,8058,
   8059,8250,8253,8254,8282,8283,8364,25262,25268,25269,25272,
   25273,25499,25500,25503,25504,25695,25698,25699,25727,25728,
   25809,40254,40255,40258,40259,40450,40453,40454,40482,40483,
   40564,44790,44793,44794,44822,44823,44904,47902,47903,47984,
   48390],[],[],
 [7187,7204,7817,7827,7828,8058,8059,8364,25262,25272,25273,
   25503,25504,25809,40258,40259,40564,44904],[7828],
 [7187,7204,7822,7828,7829,8224,8225,8390,25267,25273,25274,
   25669,25670,25835,40424,40425,40590,47575],[7950,25395],
 [],[7187,7204,7813,7828,7832,7909,7913,8393,25258,25273,
   25277,25354,25358,25838,40109,40113,40593,42193],
 [8507,25952],[7875,25320],[8168],[8507,25952],[8032],
 [7996,25441],[],[],[],[],[],[],[],[],
 [7187,7204,7828,7847,7849,8408,8410,8695,25273,25292,25294,
   25853,25855,26140,40608,40610,40895,50075],[],
 [7187,7204,7828,7847,7849,8408,8410,8695,25273,25292,25294,
   25853,25855,26140,40608,40610,40895,50075],[],[],[],
 [],[26160],[26160],[],[26316],[26316],[],[],
 [26510],[26510],
 [7241,7258,7725,7726,7743,7769,7786,7828,26601,26602,26619,
   26645,26662,26704,38205,38222,38264,39167],
 [7241,7258,7725,7726,7743,7769,7786,7828,26601,26602,26619,
   26645,26662,26704,38205,38222,38264,39167],[7828],
 [7875,26751],
 [7241,7258,7813,7828,7832,7909,7913,8393,26689,26704,26708,
   26785,26789,27269,40109,40113,40593,42193],
 [7241,7242,7258,7264,7812,7814,7828,7830,7834,7855,7869,7871,
   7875,7948,7950,7954,8391,8395,8442,26688,26690,26704,26706,
   26710,26731,26745,26747,26751,26824,26826,26830,27267,27271,
   27318,40055,40069,40071,40075,40148,40150,40154,40591,40595,
   40642,40968,40970,40974,41411,41415,41462,42932,42936,42983,
   49822],[7996,26872],[8032],
 [7241,7258,7817,7827,7828,8058,8059,8364,26693,26703,26704,
   26934,26935,27240,40258,40259,40564,44904],
 [7241,7258,7818,7821,7828,8087,8094,8193,26694,26697,26704,
   26963,26970,27069,40287,40294,40393,45328],[],[8168],
 [7241,7258,7818,7821,7828,8087,8094,8193,26694,26697,26704,
   26963,26970,27069,40287,40294,40393,45328],
 [7241,7258,7822,7828,7829,8224,8225,8390,26698,26704,26705,
   27100,27101,27266,40424,40425,40590,47575],
 [7241,7258,7823,7824,7828,8250,8254,8283,26699,26700,26704,
   27126,27130,27159,40450,40454,40483,47903],
 [7241,7258,7823,7824,7828,8250,8254,8283,26699,26700,26704,
   27126,27130,27159,40450,40454,40483,47903],[],[],
 [7241,7258,7817,7827,7828,8058,8059,8364,26693,26703,26704,
   26934,26935,27240,40258,40259,40564,44904],[7828],
 [7241,7258,7822,7828,7829,8224,8225,8390,26698,26704,26705,
   27100,27101,27266,40424,40425,40590,47575],
 [7241,7242,7258,7264,7812,7814,7828,7830,7834,7855,7869,7871,
   7875,7948,7950,7954,8391,8395,8442,26688,26690,26704,26706,
   26710,26731,26745,26747,26751,26824,26826,26830,27267,27271,
   27318,40055,40069,40071,40075,40148,40150,40154,40591,40595,
   40642,40968,40970,40974,41411,41415,41462,42932,42936,42983,
   49822],[],
 [7241,7258,7813,7828,7832,7909,7913,8393,26689,26704,26708,
   26785,26789,27269,40109,40113,40593,42193],[8507,27383],
 [7875,26751],[8168],[8507,27383],[8032],[7996,26872],
 [],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[26160],[27643],[27643],[],[],[27841],
 [27841],[],
 [7294,7311,7725,7726,7743,7769,7786,7828,27979,27980,27997,
   28023,28040,28082,38205,38222,38264,39167],
 [7294,7311,7725,7726,7743,7769,7786,7828,27979,27980,27997,
   28023,28040,28082,38205,38222,38264,39167],[7828],
 [7875,28129],
 [7294,7311,7813,7828,7832,7909,7913,8393,28067,28082,28086,
   28163,28167,28647,40109,40113,40593,42193],
 [7294,7295,7311,7317,7812,7814,7828,7830,7834,7855,7869,7871,
   7875,7948,7950,7954,8391,8395,8442,28066,28068,28082,28084,
   28088,28109,28123,28125,28129,28202,28204,28208,28645,28649,
   28696,40055,40069,40071,40075,40148,40150,40154,40591,40595,
   40642,40968,40970,40974,41411,41415,41462,42932,42936,42983,
   49822],[7996,28250],[8032],
 [7294,7311,7817,7827,7828,8058,8059,8364,28071,28081,28082,
   28312,28313,28618,40258,40259,40564,44904],
 [7294,7311,7818,7821,7828,8087,8094,8193,28072,28075,28082,
   28341,28348,28447,40287,40294,40393,45328],[],[8168],
 [7294,7311,7818,7821,7828,8087,8094,8193,28072,28075,28082,
   28341,28348,28447,40287,40294,40393,45328],
 [7294,7311,7822,7828,7829,8224,8225,8390,28076,28082,28083,
   28478,28479,28644,40424,40425,40590,47575],
 [7294,7311,7823,7824,7828,8250,8254,8283,28077,28078,28082,
   28504,28508,28537,40450,40454,40483,47903],
 [7294,7311,7823,7824,7828,8250,8254,8283,28077,28078,28082,
   28504,28508,28537,40450,40454,40483,47903],[],[],
 [7294,7311,7817,7827,7828,8058,8059,8364,28071,28081,28082,
   28312,28313,28618,40258,40259,40564,44904],[7828],
 [7294,7311,7822,7828,7829,8224,8225,8390,28076,28082,28083,
   28478,28479,28644,40424,40425,40590,47575],
 [7294,7295,7311,7317,7812,7814,7828,7830,7834,7855,7869,7871,
   7875,7948,7950,7954,8391,8395,8442,28066,28068,28082,28084,
   28088,28109,28123,28125,28129,28202,28204,28208,28645,28649,
   28696,40055,40069,40071,40075,40148,40150,40154,40591,40595,
   40642,40968,40970,40974,41411,41415,41462,42932,42936,42983,
   49822],[],
 [7294,7311,7813,7828,7832,7909,7913,8393,28067,28082,28086,
   28163,28167,28647,40109,40113,40593,42193],[8507,28761],
 [7875,28129],[8168],[8507,28761],[8032],[7996,28250],
 [],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[28970],[],[28970],[],[29168],[],
 [29168],[7346,7363,7725,7726,7743,7769,7786,7828,29305,29306,
   29323,29349,29366,29408,38205,38222,38264,39167],
 [7346,7363,7725,7726,7743,7769,7786,7828,29305,29306,29323,
   29349,29366,29408,38205,38222,38264,39167],[7828],
 [7875,29455],
 [7346,7363,7813,7828,7832,7909,7913,8393,29393,29408,29412,
   29489,29493,29973,40109,40113,40593,42193],[7950,29530],
 [7996,29576],[8032],
 [7346,7363,7817,7827,7828,8058,8059,8364,29397,29407,29408,
   29638,29639,29944,40258,40259,40564,44904],
 [7346,7363,7818,7821,7828,8087,8094,8193,29398,29401,29408,
   29667,29674,29773,40287,40294,40393,45328],[],[8168],
 [7346,7363,7818,7821,7828,8087,8094,8193,29398,29401,29408,
   29667,29674,29773,40287,40294,40393,45328],
 [7346,7363,7822,7828,7829,8224,8225,8390,29402,29408,29409,
   29804,29805,29970,40424,40425,40590,47575],
 [7346,7363,7823,7824,7828,8250,8254,8283,29403,29404,29408,
   29830,29834,29863,40450,40454,40483,47903],
 [7346,7363,7823,7824,7828,8250,8254,8283,29403,29404,29408,
   29830,29834,29863,40450,40454,40483,47903],
 [7346,7363,7825,7828,7831,8311,8314,8392,29405,29408,29411,
   29891,29894,29972,40511,40514,40592,48796],[],
 [7346,7363,7817,7827,7828,8058,8059,8364,29397,29407,29408,
   29638,29639,29944,40258,40259,40564,44904],[7828],
 [7346,7363,7822,7828,7829,8224,8225,8390,29402,29408,29409,
   29804,29805,29970,40424,40425,40590,47575],[7950,29530],
 [7346,7363,7825,7828,7831,8311,8314,8392,29405,29408,29411,
   29891,29894,29972,40511,40514,40592,48796],
 [7346,7363,7813,7828,7832,7909,7913,8393,29393,29408,29412,
   29489,29493,29973,40109,40113,40593,42193],[8507,30087],
 [7875,29455],[8168],[8507,30087],[8032],[7996,29576],
 [],[7346,7363,7828,7840,7841,8401,8402,8624,29408,29420,
   29421,29981,29982,30204,40601,40602,40824,50004],
 [7346,7363,7828,7840,7841,8401,8402,8624,29408,29420,29421,
   29981,29982,30204,40601,40602,40824,50004],[],[],[],
 [],[],[],[],[],[],[],[],[],[27643],[28970],
 [30394],[30394],[],[],
 [7397,7414,7725,7726,7743,7769,7786,7828,30580,30581,30598,
   30624,30641,30683,38205,38222,38264,39167],
 [7397,7414,7725,7726,7743,7769,7786,7828,30580,30581,30598,
   30624,30641,30683,38205,38222,38264,39167],[7828],
 [7875,30730],
 [7397,7414,7813,7828,7832,7909,7913,8393,30668,30683,30687,
   30764,30768,31248,40109,40113,40593,42193],
 [7397,7398,7414,7420,7812,7814,7828,7830,7834,7855,7869,7871,
   7875,7948,7950,7954,8391,8395,8442,30667,30669,30683,30685,
   30689,30710,30724,30726,30730,30803,30805,30809,31246,31250,
   31297,40055,40069,40071,40075,40148,40150,40154,40591,40595,
   40642,40968,40970,40974,41411,41415,41462,42932,42936,42983,
   49822],[7996,30851],[8032],
 [7397,7414,7817,7827,7828,8058,8059,8364,30672,30682,30683,
   30913,30914,31219,40258,40259,40564,44904],
 [7397,7414,7818,7821,7828,8087,8094,8193,30673,30676,30683,
   30942,30949,31048,40287,40294,40393,45328],[],[8168],
 [7397,7414,7818,7821,7828,8087,8094,8193,30673,30676,30683,
   30942,30949,31048,40287,40294,40393,45328],
 [7397,7414,7822,7828,7829,8224,8225,8390,30677,30683,30684,
   31079,31080,31245,40424,40425,40590,47575],
 [7397,7414,7823,7824,7828,8250,8254,8283,30678,30679,30683,
   31105,31109,31138,40450,40454,40483,47903],
 [7397,7414,7823,7824,7828,8250,8254,8283,30678,30679,30683,
   31105,31109,31138,40450,40454,40483,47903],[],[],
 [7397,7414,7817,7827,7828,8058,8059,8364,30672,30682,30683,
   30913,30914,31219,40258,40259,40564,44904],[7828],
 [7397,7414,7822,7828,7829,8224,8225,8390,30677,30683,30684,
   31079,31080,31245,40424,40425,40590,47575],
 [7397,7398,7414,7420,7812,7814,7828,7830,7834,7855,7869,7871,
   7875,7948,7950,7954,8391,8395,8442,30667,30669,30683,30685,
   30689,30710,30724,30726,30730,30803,30805,30809,31246,31250,
   31297,40055,40069,40071,40075,40148,40150,40154,40591,40595,
   40642,40968,40970,40974,41411,41415,41462,42932,42936,42983,
   49822],[],
 [7397,7414,7813,7828,7832,7909,7913,8393,30668,30683,30687,
   30764,30768,31248,40109,40113,40593,42193],[8507,31362],
 [7875,30730],[8168],[8507,31362],[8032],[7996,30851],
 [],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[26316],[31620],[],[31620],[],
 [7447,7464,7725,7726,7743,7769,7786,7828,31805,31806,31823,
   31849,31866,31908,38205,38222,38264,39167],
 [7447,7464,7725,7726,7743,7769,7786,7828,31805,31806,31823,
   31849,31866,31908,38205,38222,38264,39167],[7828],
 [7875,31955],
 [7447,7464,7813,7828,7832,7909,7913,8393,31893,31908,31912,
   31989,31993,32473,40109,40113,40593,42193],[7950,32030],
 [7996,32076],[8032],
 [7447,7464,7817,7827,7828,8058,8059,8364,31897,31907,31908,
   32138,32139,32444,40258,40259,40564,44904],
 [7447,7464,7818,7821,7828,8087,8094,8193,31898,31901,31908,
   32167,32174,32273,40287,40294,40393,45328],[],[8168],
 [7447,7464,7818,7821,7828,8087,8094,8193,31898,31901,31908,
   32167,32174,32273,40287,40294,40393,45328],
 [7447,7464,7822,7828,7829,8224,8225,8390,31902,31908,31909,
   32304,32305,32470,40424,40425,40590,47575],
 [7447,7464,7823,7824,7828,8250,8254,8283,31903,31904,31908,
   32330,32334,32363,40450,40454,40483,47903],
 [7447,7464,7823,7824,7828,8250,8254,8283,31903,31904,31908,
   32330,32334,32363,40450,40454,40483,47903],
 [7447,7464,7825,7828,7831,8311,8314,8392,31905,31908,31911,
   32391,32394,32472,40511,40514,40592,48796],[],
 [7447,7464,7817,7827,7828,8058,8059,8364,31897,31907,31908,
   32138,32139,32444,40258,40259,40564,44904],[7828],
 [7447,7464,7822,7828,7829,8224,8225,8390,31902,31908,31909,
   32304,32305,32470,40424,40425,40590,47575],[7950,32030],
 [7447,7464,7825,7828,7831,8311,8314,8392,31905,31908,31911,
   32391,32394,32472,40511,40514,40592,48796],
 [7447,7464,7813,7828,7832,7909,7913,8393,31893,31908,31912,
   31989,31993,32473,40109,40113,40593,42193],[8507,32587],
 [7875,31955],[8168],[8507,32587],[8032],[7996,32076],
 [],[7447,7464,7828,7840,7841,8401,8402,8624,31908,31920,
   31921,32481,32482,32704,40601,40602,40824,50004],
 [7447,7464,7828,7840,7841,8401,8402,8624,31908,31920,31921,
   32481,32482,32704,40601,40602,40824,50004],[],[],[],
 [],[],[],[],[],[],[],[],[],[32797],[],
 [],[32797],
 [7496,7513,7725,7726,7743,7769,7786,7828,32981,32982,32999,
   33025,33042,33084,38205,38222,38264,39167],
 [7496,7513,7725,7726,7743,7769,7786,7828,32981,32982,32999,
   33025,33042,33084,38205,38222,38264,39167],[7828],
 [7875,33131],
 [7496,7513,7813,7828,7832,7909,7913,8393,33069,33084,33088,
   33165,33169,33649,40109,40113,40593,42193],[7950,33206],
 [7996,33252],[8032],
 [7496,7513,7817,7827,7828,8058,8059,8364,33073,33083,33084,
   33314,33315,33620,40258,40259,40564,44904],
 [7496,7513,7818,7821,7828,8087,8094,8193,33074,33077,33084,
   33343,33350,33449,40287,40294,40393,45328],[],[8168],
 [7496,7513,7818,7821,7828,8087,8094,8193,33074,33077,33084,
   33343,33350,33449,40287,40294,40393,45328],
 [7496,7513,7822,7828,7829,8224,8225,8390,33078,33084,33085,
   33480,33481,33646,40424,40425,40590,47575],
 [7496,7513,7823,7824,7828,8250,8254,8283,33079,33080,33084,
   33506,33510,33539,40450,40454,40483,47903],
 [7496,7513,7823,7824,7828,8250,8254,8283,33079,33080,33084,
   33506,33510,33539,40450,40454,40483,47903],[],[],
 [7496,7513,7817,7827,7828,8058,8059,8364,33073,33083,33084,
   33314,33315,33620,40258,40259,40564,44904],[7828],
 [7496,7513,7822,7828,7829,8224,8225,8390,33078,33084,33085,
   33480,33481,33646,40424,40425,40590,47575],[7950,33206],
 [],[7496,7513,7813,7828,7832,7909,7913,8393,33069,33084,
   33088,33165,33169,33649,40109,40113,40593,42193],
 [8507,33763],[7875,33131],[8168],[8507,33763],[8032],
 [7996,33252],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],[30394],[31620],[32797],
 [7544,7561,7725,7726,7743,7769,7786,7828,34109,34110,34127,
   34153,34170,34212,38205,38222,38264,39167],
 [7544,7561,7725,7726,7743,7769,7786,7828,34109,34110,34127,
   34153,34170,34212,38205,38222,38264,39167],[7828],
 [7875,34259],
 [7544,7561,7813,7828,7832,7909,7913,8393,34197,34212,34216,
   34293,34297,34777,40109,40113,40593,42193],
 [7544,7545,7561,7567,7812,7814,7828,7830,7834,7855,7869,7871,
   7875,7948,7950,7954,8391,8395,8442,34196,34198,34212,34214,
   34218,34239,34253,34255,34259,34332,34334,34338,34775,34779,
   34826,40055,40069,40071,40075,40148,40150,40154,40591,40595,
   40642,40968,40970,40974,41411,41415,41462,42932,42936,42983,
   49822],[7996,34380],[8032],
 [7544,7561,7817,7827,7828,8058,8059,8364,34201,34211,34212,
   34442,34443,34748,40258,40259,40564,44904],
 [7544,7561,7818,7821,7828,8087,8094,8193,34202,34205,34212,
   34471,34478,34577,40287,40294,40393,45328],[],[8168],
 [7544,7561,7818,7821,7828,8087,8094,8193,34202,34205,34212,
   34471,34478,34577,40287,40294,40393,45328],
 [7544,7561,7822,7828,7829,8224,8225,8390,34206,34212,34213,
   34608,34609,34774,40424,40425,40590,47575],
 [7544,7561,7823,7824,7828,8250,8254,8283,34207,34208,34212,
   34634,34638,34667,40450,40454,40483,47903],
 [7544,7561,7823,7824,7828,8250,8254,8283,34207,34208,34212,
   34634,34638,34667,40450,40454,40483,47903],[],[],
 [7544,7561,7817,7827,7828,8058,8059,8364,34201,34211,34212,
   34442,34443,34748,40258,40259,40564,44904],[7828],
 [7544,7561,7822,7828,7829,8224,8225,8390,34206,34212,34213,
   34608,34609,34774,40424,40425,40590,47575],
 [7544,7545,7561,7567,7812,7814,7828,7830,7834,7855,7869,7871,
   7875,7948,7950,7954,8391,8395,8442,34196,34198,34212,34214,
   34218,34239,34253,34255,34259,34332,34334,34338,34775,34779,
   34826,40055,40069,40071,40075,40148,40150,40154,40591,40595,
   40642,40968,40970,40974,41411,41415,41462,42932,42936,42983,
   49822],[],
 [7544,7561,7813,7828,7832,7909,7913,8393,34197,34212,34216,
   34293,34297,34777,40109,40113,40593,42193],[8507,34891],
 [7875,34259],[8168],[8507,34891],[8032],[7996,34380],
 [],[],[],[],[],[],[],[],[],[],[],[],
 [],[],[],[27841],[29168],
 [7591,7608,7725,7726,7743,7769,7786,7828,35190,35191,35208,
   35234,35251,35293,38205,38222,38264,39167],
 [7591,7608,7725,7726,7743,7769,7786,7828,35190,35191,35208,
   35234,35251,35293,38205,38222,38264,39167],[7828],
 [7875,35340],
 [7591,7608,7813,7828,7832,7909,7913,8393,35278,35293,35297,
   35374,35378,35858,40109,40113,40593,42193],[7950,35415],
 [7996,35461],[8032],
 [7591,7608,7817,7827,7828,8058,8059,8364,35282,35292,35293,
   35523,35524,35829,40258,40259,40564,44904],
 [7591,7608,7818,7821,7828,8087,8094,8193,35283,35286,35293,
   35552,35559,35658,40287,40294,40393,45328],[],[8168],
 [7591,7608,7818,7821,7828,8087,8094,8193,35283,35286,35293,
   35552,35559,35658,40287,40294,40393,45328],
 [7591,7608,7822,7828,7829,8224,8225,8390,35287,35293,35294,
   35689,35690,35855,40424,40425,40590,47575],
 [7591,7608,7823,7824,7828,8250,8254,8283,35288,35289,35293,
   35715,35719,35748,40450,40454,40483,47903],
 [7591,7608,7823,7824,7828,8250,8254,8283,35288,35289,35293,
   35715,35719,35748,40450,40454,40483,47903],
 [7591,7608,7825,7828,7831,8311,8314,8392,35290,35293,35296,
   35776,35779,35857,40511,40514,40592,48796],[],
 [7591,7608,7817,7827,7828,8058,8059,8364,35282,35292,35293,
   35523,35524,35829,40258,40259,40564,44904],[7828],
 [7591,7608,7822,7828,7829,8224,8225,8390,35287,35293,35294,
   35689,35690,35855,40424,40425,40590,47575],[7950,35415],
 [7591,7608,7825,7828,7831,8311,8314,8392,35290,35293,35296,
   35776,35779,35857,40511,40514,40592,48796],
 [7591,7608,7813,7828,7832,7909,7913,8393,35278,35293,35297,
   35374,35378,35858,40109,40113,40593,42193],[8507,35972],
 [7875,35340],[8168],[8507,35972],[8032],[7996,35461],
 [],[7591,7608,7828,7840,7841,8401,8402,8624,35293,35305,
   35306,35866,35867,36089,40601,40602,40824,50004],
 [7591,7608,7828,7840,7841,8401,8402,8624,35293,35305,35306,
   35866,35867,36089,40601,40602,40824,50004],[],[],[],
 [],[],[],[],[],[],[],[],[],[26510],
 [7637,7654,7725,7726,7743,7769,7786,7828,36225,36226,36243,
   36269,36286,36328,38205,38222,38264,39167],
 [7637,7654,7725,7726,7743,7769,7786,7828,36225,36226,36243,
   36269,36286,36328,38205,38222,38264,39167],[7828],
 [7875,36375],
 [7637,7654,7813,7828,7832,7909,7913,8393,36313,36328,36332,
   36409,36413,36893,40109,40113,40593,42193],[7950,36450],
 [7996,36496],[8032],
 [7637,7654,7817,7827,7828,8058,8059,8364,36317,36327,36328,
   36558,36559,36864,40258,40259,40564,44904],
 [7637,7654,7818,7821,7828,8087,8094,8193,36318,36321,36328,
   36587,36594,36693,40287,40294,40393,45328],[],[8168],
 [7637,7654,7818,7821,7828,8087,8094,8193,36318,36321,36328,
   36587,36594,36693,40287,40294,40393,45328],
 [7637,7654,7822,7828,7829,8224,8225,8390,36322,36328,36329,
   36724,36725,36890,40424,40425,40590,47575],
 [7637,7654,7823,7824,7828,8250,8254,8283,36323,36324,36328,
   36750,36754,36783,40450,40454,40483,47903],
 [7637,7654,7823,7824,7828,8250,8254,8283,36323,36324,36328,
   36750,36754,36783,40450,40454,40483,47903],[],[],
 [7637,7654,7817,7827,7828,8058,8059,8364,36317,36327,36328,
   36558,36559,36864,40258,40259,40564,44904],[7828],
 [7637,7654,7822,7828,7829,8224,8225,8390,36322,36328,36329,
   36724,36725,36890,40424,40425,40590,47575],[7950,36450],
 [],[7637,7654,7813,7828,7832,7909,7913,8393,36313,36328,
   36332,36409,36413,36893,40109,40113,40593,42193],
 [8507,37007],[7875,36375],[8168],[8507,37007],[8032],
 [7996,36496],[],[],[],[],[],[],[],[],[],
 [],[],[],[],[],[],
 [7682,7699,7725,7726,7743,7769,7786,7828,37215,37216,37233,
   37259,37276,37318,38205,38222,38264,39167],
 [7682,7699,7725,7726,7743,7769,7786,7828,37215,37216,37233,
   37259,37276,37318,38205,38222,38264,39167],[7828],
 [7875,37365],
 [7682,7699,7813,7828,7832,7909,7913,8393,37303,37318,37322,
   37399,37403,37883,40109,40113,40593,42193],
 [7682,7683,7699,7705,7812,7814,7828,7830,7834,7855,7869,7871,
   7875,7948,7950,7954,8391,8395,8442,37302,37304,37318,37320,
   37324,37345,37359,37361,37365,37438,37440,37444,37881,37885,
   37932,40055,40069,40071,40075,40148,40150,40154,40591,40595,
   40642,40968,40970,40974,41411,41415,41462,42932,42936,42983,
   49822],[7996,37486],[8032],
 [7682,7699,7817,7827,7828,8058,8059,8364,37307,37317,37318,
   37548,37549,37854,40258,40259,40564,44904],
 [7682,7699,7818,7821,7828,8087,8094,8193,37308,37311,37318,
   37577,37584,37683,40287,40294,40393,45328],[],[8168],
 [7682,7699,7818,7821,7828,8087,8094,8193,37308,37311,37318,
   37577,37584,37683,40287,40294,40393,45328],
 [7682,7699,7822,7828,7829,8224,8225,8390,37312,37318,37319,
   37714,37715,37880,40424,40425,40590,47575],
 [7682,7699,7823,7824,7828,8250,8254,8283,37313,37314,37318,
   37740,37744,37773,40450,40454,40483,47903],
 [7682,7699,7823,7824,7828,8250,8254,8283,37313,37314,37318,
   37740,37744,37773,40450,40454,40483,47903],
 [7682,7699,7825,7828,7831,8311,8314,8392,37315,37318,37321,
   37801,37804,37882,40511,40514,40592,48796],[],
 [7682,7699,7817,7827,7828,8058,8059,8364,37307,37317,37318,
   37548,37549,37854,40258,40259,40564,44904],[7828],
 [7682,7699,7822,7828,7829,8224,8225,8390,37312,37318,37319,
   37714,37715,37880,40424,40425,40590,47575],
 [7682,7683,7699,7705,7812,7814,7828,7830,7834,7855,7869,7871,
   7875,7948,7950,7954,8391,8395,8442,37302,37304,37318,37320,
   37324,37345,37359,37361,37365,37438,37440,37444,37881,37885,
   37932,40055,40069,40071,40075,40148,40150,40154,40591,40595,
   40642,40968,40970,40974,41411,41415,41462,42932,42936,42983,
   49822],
 [7682,7699,7825,7828,7831,8311,8314,8392,37315,37318,37321,
   37801,37804,37882,40511,40514,40592,48796],
 [7682,7699,7813,7828,7832,7909,7913,8393,37303,37318,37322,
   37399,37403,37883,40109,40113,40593,42193],[8507,37997],
 [7875,37365],[8168],[8507,37997],[8032],[7996,37486],
 [],[7682,7699,7828,7840,7841,8401,8402,8624,37318,37330,
   37331,37891,37892,38114,40601,40602,40824,50004],
 [7682,7699,7828,7840,7841,8401,8402,8624,37318,37330,37331,
   37891,37892,38114,40601,40602,40824,50004],[],[],
 [7682,7699,7828,7844,7845,8405,8406,8670,37318,37334,37335,
   37895,37896,38160,40605,40606,40870,50050],
 [7682,7699,7828,7844,7845,8405,8406,8670,37318,37334,37335,
   37895,37896,38160,40605,40606,40870,50050],[],
 [7682,7699,7828,7847,7849,8408,8410,8695,37318,37337,37339,
   37898,37900,38185,40608,40610,40895,50075],[],
 [7682,7699,7828,7847,7849,8408,8410,8695,37318,37337,37339,
   37898,37900,38185,40608,40610,40895,50075],[],[],[],
 [],[7828,38205],[7828,38205],
 [7725,7726,7743,7769,7786,7812,7813,7814,7828,7830,7832,7834,
   7855,7869,7871,7875,7909,7913,7948,7950,7954,8391,8393,8395,
   8442,38205,38206,38207,38208,38222,38224,38226,38228,38248,
   38249,38250,38264,38266,38268,38270,38290,38291,38305,38307,
   38309,38311,38331,38345,38347,38349,38351,38384,38386,38388,
   38390,38827,38829,38831,38876,38878,38921,39151,39152,39153,
   39167,39169,39171,39173,39193,39194,39208,39210,39212,39214,
   39234,39248,39250,39252,39254,39287,39289,39291,39293,39730,
   39732,39734,39779,39781,39824,40054,40055,40069,40071,40073,
   40075,40095,40109,40111,40113,40115,40148,40150,40152,40154,
   40591,40593,40595,40640,40642,40685,40915,40929,40931,40933,
   40935,40968,40970,40972,40974,41411,41413,41415,41460,41462,
   41505,41748,41750,41752,41754,42191,42193,42195,42240,42242,
   42285,42932,42934,42936,42981,42983,43026,49820,49822,49865,
   50394],
 [7725,7726,7743,7769,7786,7812,7813,7814,7828,7830,7832,7834,
   7855,7869,7871,7875,7909,7913,7948,7950,7954,8391,8393,8395,
   8442,38205,38206,38207,38208,38222,38224,38226,38228,38248,
   38249,38250,38264,38266,38268,38270,38290,38291,38305,38307,
   38309,38311,38331,38345,38347,38349,38351,38384,38386,38388,
   38390,38827,38829,38831,38876,38878,38921,39151,39152,39153,
   39167,39169,39171,39173,39193,39194,39208,39210,39212,39214,
   39234,39248,39250,39252,39254,39287,39289,39291,39293,39730,
   39732,39734,39779,39781,39824,40054,40055,40069,40071,40073,
   40075,40095,40109,40111,40113,40115,40148,40150,40152,40154,
   40591,40593,40595,40640,40642,40685,40915,40929,40931,40933,
   40935,40968,40970,40972,40974,41411,41413,41415,41460,41462,
   41505,41748,41750,41752,41754,42191,42193,42195,42240,42242,
   42285,42932,42934,42936,42981,42983,43026,49820,49822,49865,
   50394],
 [7725,7726,7743,7769,7786,7812,7813,7814,7828,7830,7832,7834,
   7855,7869,7871,7875,7909,7913,7948,7950,7954,8391,8393,8395,
   8442,38205,38206,38207,38208,38222,38224,38226,38228,38248,
   38249,38250,38264,38266,38268,38270,38290,38291,38305,38307,
   38309,38311,38331,38345,38347,38349,38351,38384,38386,38388,
   38390,38827,38829,38831,38876,38878,38921,39151,39152,39153,
   39167,39169,39171,39173,39193,39194,39208,39210,39212,39214,
   39234,39248,39250,39252,39254,39287,39289,39291,39293,39730,
   39732,39734,39779,39781,39824,40054,40055,40069,40071,40073,
   40075,40095,40109,40111,40113,40115,40148,40150,40152,40154,
   40591,40593,40595,40640,40642,40685,40915,40929,40931,40933,
   40935,40968,40970,40972,40974,41411,41413,41415,41460,41462,
   41505,41748,41750,41752,41754,42191,42193,42195,42240,42242,
   42285,42932,42934,42936,42981,42983,43026,49820,49822,49865,
   50394],
 [7725,7726,7743,7769,7786,7815,7816,7828,7837,7838,7986,7996,
   8023,8032,8398,8399,38205,38209,38210,38222,38231,38232,
   38251,38252,38264,38273,38274,38410,38422,38431,38432,38459,
   38834,38835,39015,39154,39155,39167,39176,39177,39313,39325,
   39335,39362,39372,39737,39738,39918,40174,40186,40195,40196,
   40223,40232,40233,40598,40599,40779,43267,43277,43642,43643,
   43823,44308,44309,49959],
 [7725,7726,7743,7769,7786,7815,7816,7828,7837,7838,7986,7996,
   8023,8032,8398,8399,38205,38209,38210,38222,38231,38232,
   38251,38252,38264,38273,38274,38410,38422,38431,38432,38459,
   38834,38835,39015,39154,39155,39167,39176,39177,39313,39325,
   39335,39362,39372,39737,39738,39918,40174,40186,40195,40196,
   40223,40232,40233,40598,40599,40779,43267,43277,43642,43643,
   43823,44308,44309,49959],
 [2279,3500,3501,3507,3517,3518,3544,3550,3592,3833,3834,4139,
   5645,5646,5662,5689,5695,5705,5706,5747,5978,5979,6284,7725,
   7726,7743,7769,7786,7817,7827,7828,8058,8059,8364,38205,
   38211,38221,38222,38253,38263,38264,38494,38495,38800,39156,
   39166,39167,39397,39398,39703,40258,40259,40564,44904],
 [7725,7726,7743,7769,7786,7818,7819,7821,7828,8087,8094,8128,
   8193,38205,38212,38213,38215,38222,38254,38255,38257,38264,
   38521,38523,38530,38557,38564,38629,39157,39158,39160,39167,
   39424,39426,39433,39460,39467,39532,40285,40287,40294,40321,
   40328,40393,45256,45263,45328,45889],
 [7725,7726,7743,7769,7786,7818,7819,7821,7828,8087,8094,8128,
   8193,38205,38212,38213,38215,38222,38254,38255,38257,38264,
   38521,38523,38530,38557,38564,38629,39157,39158,39160,39167,
   39424,39426,39433,39460,39467,39532,40285,40287,40294,40321,
   40328,40393,45256,45263,45328,45889],
 [7725,7726,7743,7769,7786,7820,7828,7835,8161,8168,8396,38205,
   38214,38222,38229,38256,38264,38271,38597,38832,39159,39167,
   39174,39500,39735,40361,40368,40596,46620],
 [7725,7726,7743,7769,7786,7818,7819,7821,7828,8087,8094,8128,
   8193,38205,38212,38213,38215,38222,38254,38255,38257,38264,
   38521,38523,38530,38557,38564,38629,39157,39158,39160,39167,
   39424,39426,39433,39460,39467,39532,40285,40287,40294,40321,
   40328,40393,45256,45263,45328,45889],
 [7725,7726,7743,7769,7786,7822,7828,7829,8224,8225,8390,38205,
   38216,38222,38223,38258,38264,38265,38660,38661,38826,39161,
   39167,39168,39563,39564,39729,40424,40425,40590,47575],
 [7725,7726,7743,7769,7786,7823,7824,7828,8250,8254,8283,38205,
   38217,38218,38222,38259,38260,38264,38686,38690,38719,39162,
   39163,39167,39589,39593,39622,40450,40454,40483,47903],
 [7725,7726,7743,7769,7786,7823,7824,7828,8250,8254,8283,38205,
   38217,38218,38222,38259,38260,38264,38686,38690,38719,39162,
   39163,39167,39589,39593,39622,40450,40454,40483,47903],
 [7725,7726,7743,7769,7786,7825,7828,7831,8311,8314,8392,38205,
   38219,38222,38225,38261,38264,38267,38747,38750,38828,39164,
   39167,39170,39650,39653,39731,40511,40514,40592,48796],
 [7725,7726,7743,7769,7786,7826,7828,8338,38205,38220,38222,
   38262,38264,38774,39165,39167,39677,40538],
 [2279,3500,3501,3507,3517,3518,3544,3550,3592,3833,3834,4139,
   5645,5646,5662,5689,5695,5705,5706,5747,5978,5979,6284,7725,
   7726,7743,7769,7786,7817,7827,7828,8058,8059,8364,38205,
   38211,38221,38222,38253,38263,38264,38494,38495,38800,39156,
   39166,39167,39397,39398,39703,40258,40259,40564,44904],
 [7828,38205],
 [7725,7726,7743,7769,7786,7822,7828,7829,8224,8225,8390,38205,
   38216,38222,38223,38258,38264,38265,38660,38661,38826,39161,
   39167,39168,39563,39564,39729,40424,40425,40590,47575],
 [7725,7726,7743,7769,7786,7812,7813,7814,7828,7830,7832,7834,
   7855,7869,7871,7875,7909,7913,7948,7950,7954,8391,8393,8395,
   8442,38205,38206,38207,38208,38222,38224,38226,38228,38248,
   38249,38250,38264,38266,38268,38270,38290,38291,38305,38307,
   38309,38311,38331,38345,38347,38349,38351,38384,38386,38388,
   38390,38827,38829,38831,38876,38878,38921,39151,39152,39153,
   39167,39169,39171,39173,39193,39194,39208,39210,39212,39214,
   39234,39248,39250,39252,39254,39287,39289,39291,39293,39730,
   39732,39734,39779,39781,39824,40054,40055,40069,40071,40073,
   40075,40095,40109,40111,40113,40115,40148,40150,40152,40154,
   40591,40593,40595,40640,40642,40685,40915,40929,40931,40933,
   40935,40968,40970,40972,40974,41411,41413,41415,41460,41462,
   41505,41748,41750,41752,41754,42191,42193,42195,42240,42242,
   42285,42932,42934,42936,42981,42983,43026,49820,49822,49865,
   50394],
 [7725,7726,7743,7769,7786,7825,7828,7831,8311,8314,8392,38205,
   38219,38222,38225,38261,38264,38267,38747,38750,38828,39164,
   39167,39170,39650,39653,39731,40511,40514,40592,48796],
 [7725,7726,7743,7769,7786,7812,7813,7814,7828,7830,7832,7834,
   7855,7869,7871,7875,7909,7913,7948,7950,7954,8391,8393,8395,
   8442,38205,38206,38207,38208,38222,38224,38226,38228,38248,
   38249,38250,38264,38266,38268,38270,38290,38291,38305,38307,
   38309,38311,38331,38345,38347,38349,38351,38384,38386,38388,
   38390,38827,38829,38831,38876,38878,38921,39151,39152,39153,
   39167,39169,39171,39173,39193,39194,39208,39210,39212,39214,
   39234,39248,39250,39252,39254,39287,39289,39291,39293,39730,
   39732,39734,39779,39781,39824,40054,40055,40069,40071,40073,
   40075,40095,40109,40111,40113,40115,40148,40150,40152,40154,
   40591,40593,40595,40640,40642,40685,40915,40929,40931,40933,
   40935,40968,40970,40972,40974,41411,41413,41415,41460,41462,
   41505,41748,41750,41752,41754,42191,42193,42195,42240,42242,
   42285,42932,42934,42936,42981,42983,43026,49820,49822,49865,
   50394],
 [7725,7726,7743,7769,7786,7828,7833,7836,8394,8397,8507,38205,
   38222,38227,38230,38264,38269,38272,38830,38833,38943,39167,
   39172,39175,39733,39736,39846,40594,40597,40707,49887],
 [7725,7726,7743,7769,7786,7812,7813,7814,7828,7830,7832,7834,
   7855,7869,7871,7875,7909,7913,7948,7950,7954,8391,8393,8395,
   8442,38205,38206,38207,38208,38222,38224,38226,38228,38248,
   38249,38250,38264,38266,38268,38270,38290,38291,38305,38307,
   38309,38311,38331,38345,38347,38349,38351,38384,38386,38388,
   38390,38827,38829,38831,38876,38878,38921,39151,39152,39153,
   39167,39169,39171,39173,39193,39194,39208,39210,39212,39214,
   39234,39248,39250,39252,39254,39287,39289,39291,39293,39730,
   39732,39734,39779,39781,39824,40054,40055,40069,40071,40073,
   40075,40095,40109,40111,40113,40115,40148,40150,40152,40154,
   40591,40593,40595,40640,40642,40685,40915,40929,40931,40933,
   40935,40968,40970,40972,40974,41411,41413,41415,41460,41462,
   41505,41748,41750,41752,41754,42191,42193,42195,42240,42242,
   42285,42932,42934,42936,42981,42983,43026,49820,49822,49865,
   50394],
 [7725,7726,7743,7769,7786,7820,7828,7835,8161,8168,8396,38205,
   38214,38222,38229,38256,38264,38271,38597,38832,39159,39167,
   39174,39500,39735,40361,40368,40596,46620],
 [7725,7726,7743,7769,7786,7828,7833,7836,8394,8397,8507,38205,
   38222,38227,38230,38264,38269,38272,38830,38833,38943,39167,
   39172,39175,39733,39736,39846,40594,40597,40707,49887],
 [7725,7726,7743,7769,7786,7815,7816,7828,7837,7838,7986,7996,
   8023,8032,8398,8399,38205,38209,38210,38222,38231,38232,
   38251,38252,38264,38273,38274,38410,38422,38431,38432,38459,
   38834,38835,39015,39154,39155,39167,39176,39177,39313,39325,
   39335,39362,39372,39737,39738,39918,40174,40186,40195,40196,
   40223,40232,40233,40598,40599,40779,43267,43277,43642,43643,
   43823,44308,44309,49959],
 [7725,7726,7743,7769,7786,7815,7816,7828,7837,7838,7986,7996,
   8023,8032,8398,8399,38205,38209,38210,38222,38231,38232,
   38251,38252,38264,38273,38274,38410,38422,38431,38432,38459,
   38834,38835,39015,39154,39155,39167,39176,39177,39313,39325,
   39335,39362,39372,39737,39738,39918,40174,40186,40195,40196,
   40223,40232,40233,40598,40599,40779,43267,43277,43642,43643,
   43823,44308,44309,49959],
 [7725,7726,7743,7769,7786,7828,7839,8400,38205,38222,38233,
   38264,38275,38836,39167,39178,39739,40600],
 [7725,7726,7743,7769,7786,7828,7840,7841,8401,8402,8624,38205,
   38222,38234,38235,38264,38276,38277,38837,38838,39060,39167,
   39179,39180,39740,39741,39963,40601,40602,40824,50004],
 [7725,7726,7743,7769,7786,7828,7840,7841,8401,8402,8624,38205,
   38222,38234,38235,38264,38276,38277,38837,38838,39060,39167,
   39179,39180,39740,39741,39963,40601,40602,40824,50004],
 [7725,7726,7743,7769,7786,7828,7842,8403,38205,38222,38236,
   38264,38278,38839,39167,39181,39742,40603],
 [7725,7726,7743,7769,7786,7828,7843,7850,8404,8411,8666,38205,
   38222,38237,38244,38264,38279,38286,38840,38847,39102,39167,
   39182,39189,39743,39750,40005,40604,40611,40866,50046],
 [7725,7726,7743,7769,7786,7828,7844,7845,8405,8406,8670,38205,
   38222,38238,38239,38264,38280,38281,38841,38842,39106,39167,
   39183,39184,39744,39745,40009,40605,40606,40870,50050],
 [7725,7726,7743,7769,7786,7828,7844,7845,8405,8406,8670,38205,
   38222,38238,38239,38264,38280,38281,38841,38842,39106,39167,
   39183,39184,39744,39745,40009,40605,40606,40870,50050],
 [7725,7726,7743,7769,7786,7828,7846,8407,38205,38222,38240,
   38264,38282,38843,39167,39185,39746,40607],
 [7725,7726,7743,7769,7786,7828,7847,7849,8408,8410,8695,38205,
   38222,38241,38243,38264,38283,38285,38844,38846,39131,39167,
   39186,39188,39747,39749,40034,40608,40610,40895,50075],
 [7725,7726,7743,7769,7786,7828,7848,8409,38205,38222,38242,
   38264,38284,38845,39167,39187,39748,40609],
 [7725,7726,7743,7769,7786,7828,7847,7849,8408,8410,8695,38205,
   38222,38241,38243,38264,38283,38285,38844,38846,39131,39167,
   39186,39188,39747,39749,40034,40608,40610,40895,50075],
 [7725,7726,7743,7769,7786,7828,7843,7850,8404,8411,8666,38205,
   38222,38237,38244,38264,38279,38286,38840,38847,39102,39167,
   39182,39189,39743,39750,40005,40604,40611,40866,50046],
 [7725,7726,7743,7769,7786,7828,7851,8412,38205,38222,38245,
   38264,38287,38848,39167,39190,39751,40612],
 [7725,7726,7743,7769,7786,7828,7852,7853,8413,8414,8714,38205,
   38222,38246,38247,38264,38288,38289,38849,38850,39150,39167,
   39191,39192,39752,39753,40053,40613,40614,40914,50094],
 [7725,7726,7743,7769,7786,7828,7852,7853,8413,8414,8714,38205,
   38222,38246,38247,38264,38288,38289,38849,38850,39150,39167,
   39191,39192,39752,39753,40053,40613,40614,40914,50094],
 [7828,38205],
 [7725,7726,7743,7769,7786,7812,7813,7814,7828,7830,7832,7834,
   7855,7869,7871,7875,7909,7913,7948,7950,7954,8391,8393,8395,
   8442,38205,38206,38207,38208,38222,38224,38226,38228,38248,
   38249,38250,38264,38266,38268,38270,38290,38291,38305,38307,
   38309,38311,38331,38345,38347,38349,38351,38384,38386,38388,
   38390,38827,38829,38831,38876,38878,38921,39151,39152,39153,
   39167,39169,39171,39173,39193,39194,39208,39210,39212,39214,
   39234,39248,39250,39252,39254,39287,39289,39291,39293,39730,
   39732,39734,39779,39781,39824,40054,40055,40069,40071,40073,
   40075,40095,40109,40111,40113,40115,40148,40150,40152,40154,
   40591,40593,40595,40640,40642,40685,40915,40929,40931,40933,
   40935,40968,40970,40972,40974,41411,41413,41415,41460,41462,
   41505,41748,41750,41752,41754,42191,42193,42195,42240,42242,
   42285,42932,42934,42936,42981,42983,43026,49820,49822,49865,
   50394],
 [7725,7726,7743,7769,7786,7812,7813,7814,7828,7830,7832,7834,
   7855,7869,7871,7875,7909,7913,7948,7950,7954,8391,8393,8395,
   8442,38205,38206,38207,38208,38222,38224,38226,38228,38248,
   38249,38250,38264,38266,38268,38270,38290,38291,38305,38307,
   38309,38311,38331,38345,38347,38349,38351,38384,38386,38388,
   38390,38827,38829,38831,38876,38878,38921,39151,39152,39153,
   39167,39169,39171,39173,39193,39194,39208,39210,39212,39214,
   39234,39248,39250,39252,39254,39287,39289,39291,39293,39730,
   39732,39734,39779,39781,39824,40054,40055,40069,40071,40073,
   40075,40095,40109,40111,40113,40115,40148,40150,40152,40154,
   40591,40593,40595,40640,40642,40685,40915,40929,40931,40933,
   40935,40968,40970,40972,40974,41411,41413,41415,41460,41462,
   41505,41748,41750,41752,41754,42191,42193,42195,42240,42242,
   42285,42932,42934,42936,42981,42983,43026,49820,49822,49865,
   50394],
 [7725,7726,7743,7769,7786,7812,7813,7814,7828,7830,7832,7834,
   7855,7869,7871,7875,7909,7913,7948,7950,7954,8391,8393,8395,
   8442,38205,38206,38207,38208,38222,38224,38226,38228,38248,
   38249,38250,38264,38266,38268,38270,38290,38291,38305,38307,
   38309,38311,38331,38345,38347,38349,38351,38384,38386,38388,
   38390,38827,38829,38831,38876,38878,38921,39151,39152,39153,
   39167,39169,39171,39173,39193,39194,39208,39210,39212,39214,
   39234,39248,39250,39252,39254,39287,39289,39291,39293,39730,
   39732,39734,39779,39781,39824,40054,40055,40069,40071,40073,
   40075,40095,40109,40111,40113,40115,40148,40150,40152,40154,
   40591,40593,40595,40640,40642,40685,40915,40929,40931,40933,
   40935,40968,40970,40972,40974,41411,41413,41415,41460,41462,
   41505,41748,41750,41752,41754,42191,42193,42195,42240,42242,
   42285,42932,42934,42936,42981,42983,43026,49820,49822,49865,
   50394],
 [7725,7726,7743,7769,7786,7815,7816,7828,7837,7838,7986,7996,
   8023,8032,8398,8399,38205,38209,38210,38222,38231,38232,
   38251,38252,38264,38273,38274,38410,38422,38431,38432,38459,
   38834,38835,39015,39154,39155,39167,39176,39177,39313,39325,
   39335,39362,39372,39737,39738,39918,40174,40186,40195,40196,
   40223,40232,40233,40598,40599,40779,43267,43277,43642,43643,
   43823,44308,44309,49959],
 [7725,7726,7743,7769,7786,7815,7816,7828,7837,7838,7986,7996,
   8023,8032,8398,8399,38205,38209,38210,38222,38231,38232,
   38251,38252,38264,38273,38274,38410,38422,38431,38432,38459,
   38834,38835,39015,39154,39155,39167,39176,39177,39313,39325,
   39335,39362,39372,39737,39738,39918,40174,40186,40195,40196,
   40223,40232,40233,40598,40599,40779,43267,43277,43642,43643,
   43823,44308,44309,49959],
 [2279,3500,3501,3507,3517,3518,3544,3550,3592,3833,3834,4139,
   5645,5646,5662,5689,5695,5705,5706,5747,5978,5979,6284,7725,
   7726,7743,7769,7786,7817,7827,7828,8058,8059,8364,38205,
   38211,38221,38222,38253,38263,38264,38494,38495,38800,39156,
   39166,39167,39397,39398,39703,40258,40259,40564,44904],
 [7725,7726,7743,7769,7786,7818,7819,7821,7828,8087,8094,8128,
   8193,38205,38212,38213,38215,38222,38254,38255,38257,38264,
   38521,38523,38530,38557,38564,38629,39157,39158,39160,39167,
   39424,39426,39433,39460,39467,39532,40285,40287,40294,40321,
   40328,40393,45256,45263,45328,45889],
 [7725,7726,7743,7769,7786,7818,7819,7821,7828,8087,8094,8128,
   8193,38205,38212,38213,38215,38222,38254,38255,38257,38264,
   38521,38523,38530,38557,38564,38629,39157,39158,39160,39167,
   39424,39426,39433,39460,39467,39532,40285,40287,40294,40321,
   40328,40393,45256,45263,45328,45889],
 [7725,7726,7743,7769,7786,7820,7828,7835,8161,8168,8396,38205,
   38214,38222,38229,38256,38264,38271,38597,38832,39159,39167,
   39174,39500,39735,40361,40368,40596,46620],
 [7725,7726,7743,7769,7786,7818,7819,7821,7828,8087,8094,8128,
   8193,38205,38212,38213,38215,38222,38254,38255,38257,38264,
   38521,38523,38530,38557,38564,38629,39157,39158,39160,39167,
   39424,39426,39433,39460,39467,39532,40285,40287,40294,40321,
   40328,40393,45256,45263,45328,45889],
 [7725,7726,7743,7769,7786,7822,7828,7829,8224,8225,8390,38205,
   38216,38222,38223,38258,38264,38265,38660,38661,38826,39161,
   39167,39168,39563,39564,39729,40424,40425,40590,47575],
 [7725,7726,7743,7769,7786,7823,7824,7828,8250,8254,8283,38205,
   38217,38218,38222,38259,38260,38264,38686,38690,38719,39162,
   39163,39167,39589,39593,39622,40450,40454,40483,47903],
 [7725,7726,7743,7769,7786,7823,7824,7828,8250,8254,8283,38205,
   38217,38218,38222,38259,38260,38264,38686,38690,38719,39162,
   39163,39167,39589,39593,39622,40450,40454,40483,47903],
 [7725,7726,7743,7769,7786,7825,7828,7831,8311,8314,8392,38205,
   38219,38222,38225,38261,38264,38267,38747,38750,38828,39164,
   39167,39170,39650,39653,39731,40511,40514,40592,48796],
 [7725,7726,7743,7769,7786,7826,7828,8338,38205,38220,38222,
   38262,38264,38774,39165,39167,39677,40538],
 [2279,3500,3501,3507,3517,3518,3544,3550,3592,3833,3834,4139,
   5645,5646,5662,5689,5695,5705,5706,5747,5978,5979,6284,7725,
   7726,7743,7769,7786,7817,7827,7828,8058,8059,8364,38205,
   38211,38221,38222,38253,38263,38264,38494,38495,38800,39156,
   39166,39167,39397,39398,39703,40258,40259,40564,44904],
 [7828,38205],
 [7725,7726,7743,7769,7786,7822,7828,7829,8224,8225,8390,38205,
   38216,38222,38223,38258,38264,38265,38660,38661,38826,39161,
   39167,39168,39563,39564,39729,40424,40425,40590,47575],
 [7725,7726,7743,7769,7786,7812,7813,7814,7828,7830,7832,7834,
   7855,7869,7871,7875,7909,7913,7948,7950,7954,8391,8393,8395,
   8442,38205,38206,38207,38208,38222,38224,38226,38228,38248,
   38249,38250,38264,38266,38268,38270,38290,38291,38305,38307,
   38309,38311,38331,38345,38347,38349,38351,38384,38386,38388,
   38390,38827,38829,38831,38876,38878,38921,39151,39152,39153,
   39167,39169,39171,39173,39193,39194,39208,39210,39212,39214,
   39234,39248,39250,39252,39254,39287,39289,39291,39293,39730,
   39732,39734,39779,39781,39824,40054,40055,40069,40071,40073,
   40075,40095,40109,40111,40113,40115,40148,40150,40152,40154,
   40591,40593,40595,40640,40642,40685,40915,40929,40931,40933,
   40935,40968,40970,40972,40974,41411,41413,41415,41460,41462,
   41505,41748,41750,41752,41754,42191,42193,42195,42240,42242,
   42285,42932,42934,42936,42981,42983,43026,49820,49822,49865,
   50394],
 [7725,7726,7743,7769,7786,7825,7828,7831,8311,8314,8392,38205,
   38219,38222,38225,38261,38264,38267,38747,38750,38828,39164,
   39167,39170,39650,39653,39731,40511,40514,40592,48796],
 [7725,7726,7743,7769,7786,7812,7813,7814,7828,7830,7832,7834,
   7855,7869,7871,7875,7909,7913,7948,7950,7954,8391,8393,8395,
   8442,38205,38206,38207,38208,38222,38224,38226,38228,38248,
   38249,38250,38264,38266,38268,38270,38290,38291,38305,38307,
   38309,38311,38331,38345,38347,38349,38351,38384,38386,38388,
   38390,38827,38829,38831,38876,38878,38921,39151,39152,39153,
   39167,39169,39171,39173,39193,39194,39208,39210,39212,39214,
   39234,39248,39250,39252,39254,39287,39289,39291,39293,39730,
   39732,39734,39779,39781,39824,40054,40055,40069,40071,40073,
   40075,40095,40109,40111,40113,40115,40148,40150,40152,40154,
   40591,40593,40595,40640,40642,40685,40915,40929,40931,40933,
   40935,40968,40970,40972,40974,41411,41413,41415,41460,41462,
   41505,41748,41750,41752,41754,42191,42193,42195,42240,42242,
   42285,42932,42934,42936,42981,42983,43026,49820,49822,49865,
   50394],
 [7725,7726,7743,7769,7786,7828,7833,7836,8394,8397,8507,38205,
   38222,38227,38230,38264,38269,38272,38830,38833,38943,39167,
   39172,39175,39733,39736,39846,40594,40597,40707,49887],
 [7725,7726,7743,7769,7786,7812,7813,7814,7828,7830,7832,7834,
   7855,7869,7871,7875,7909,7913,7948,7950,7954,8391,8393,8395,
   8442,38205,38206,38207,38208,38222,38224,38226,38228,38248,
   38249,38250,38264,38266,38268,38270,38290,38291,38305,38307,
   38309,38311,38331,38345,38347,38349,38351,38384,38386,38388,
   38390,38827,38829,38831,38876,38878,38921,39151,39152,39153,
   39167,39169,39171,39173,39193,39194,39208,39210,39212,39214,
   39234,39248,39250,39252,39254,39287,39289,39291,39293,39730,
   39732,39734,39779,39781,39824,40054,40055,40069,40071,40073,
   40075,40095,40109,40111,40113,40115,40148,40150,40152,40154,
   40591,40593,40595,40640,40642,40685,40915,40929,40931,40933,
   40935,40968,40970,40972,40974,41411,41413,41415,41460,41462,
   41505,41748,41750,41752,41754,42191,42193,42195,42240,42242,
   42285,42932,42934,42936,42981,42983,43026,49820,49822,49865,
   50394],
 [7725,7726,7743,7769,7786,7820,7828,7835,8161,8168,8396,38205,
   38214,38222,38229,38256,38264,38271,38597,38832,39159,39167,
   39174,39500,39735,40361,40368,40596,46620],
 [7725,7726,7743,7769,7786,7828,7833,7836,8394,8397,8507,38205,
   38222,38227,38230,38264,38269,38272,38830,38833,38943,39167,
   39172,39175,39733,39736,39846,40594,40597,40707,49887],
 [7725,7726,7743,7769,7786,7815,7816,7828,7837,7838,7986,7996,
   8023,8032,8398,8399,38205,38209,38210,38222,38231,38232,
   38251,38252,38264,38273,38274,38410,38422,38431,38432,38459,
   38834,38835,39015,39154,39155,39167,39176,39177,39313,39325,
   39335,39362,39372,39737,39738,39918,40174,40186,40195,40196,
   40223,40232,40233,40598,40599,40779,43267,43277,43642,43643,
   43823,44308,44309,49959],
 [7725,7726,7743,7769,7786,7815,7816,7828,7837,7838,7986,7996,
   8023,8032,8398,8399,38205,38209,38210,38222,38231,38232,
   38251,38252,38264,38273,38274,38410,38422,38431,38432,38459,
   38834,38835,39015,39154,39155,39167,39176,39177,39313,39325,
   39335,39362,39372,39737,39738,39918,40174,40186,40195,40196,
   40223,40232,40233,40598,40599,40779,43267,43277,43642,43643,
   43823,44308,44309,49959],
 [7725,7726,7743,7769,7786,7828,7839,8400,38205,38222,38233,
   38264,38275,38836,39167,39178,39739,40600],
 [7725,7726,7743,7769,7786,7828,7840,7841,8401,8402,8624,38205,
   38222,38234,38235,38264,38276,38277,38837,38838,39060,39167,
   39179,39180,39740,39741,39963,40601,40602,40824,50004],
 [7725,7726,7743,7769,7786,7828,7840,7841,8401,8402,8624,38205,
   38222,38234,38235,38264,38276,38277,38837,38838,39060,39167,
   39179,39180,39740,39741,39963,40601,40602,40824,50004],
 [7725,7726,7743,7769,7786,7828,7842,8403,38205,38222,38236,
   38264,38278,38839,39167,39181,39742,40603],
 [7725,7726,7743,7769,7786,7828,7843,7850,8404,8411,8666,38205,
   38222,38237,38244,38264,38279,38286,38840,38847,39102,39167,
   39182,39189,39743,39750,40005,40604,40611,40866,50046],
 [7725,7726,7743,7769,7786,7828,7844,7845,8405,8406,8670,38205,
   38222,38238,38239,38264,38280,38281,38841,38842,39106,39167,
   39183,39184,39744,39745,40009,40605,40606,40870,50050],
 [7725,7726,7743,7769,7786,7828,7844,7845,8405,8406,8670,38205,
   38222,38238,38239,38264,38280,38281,38841,38842,39106,39167,
   39183,39184,39744,39745,40009,40605,40606,40870,50050],
 [7725,7726,7743,7769,7786,7828,7846,8407,38205,38222,38240,
   38264,38282,38843,39167,39185,39746,40607],
 [7725,7726,7743,7769,7786,7828,7847,7849,8408,8410,8695,38205,
   38222,38241,38243,38264,38283,38285,38844,38846,39131,39167,
   39186,39188,39747,39749,40034,40608,40610,40895,50075],
 [7725,7726,7743,7769,7786,7828,7848,8409,38205,38222,38242,
   38264,38284,38845,39167,39187,39748,40609],
 [7725,7726,7743,7769,7786,7828,7847,7849,8408,8410,8695,38205,
   38222,38241,38243,38264,38283,38285,38844,38846,39131,39167,
   39186,39188,39747,39749,40034,40608,40610,40895,50075],
 [7725,7726,7743,7769,7786,7828,7843,7850,8404,8411,8666,38205,
   38222,38237,38244,38264,38279,38286,38840,38847,39102,39167,
   39182,39189,39743,39750,40005,40604,40611,40866,50046],
 [7725,7726,7743,7769,7786,7828,7851,8412,38205,38222,38245,
   38264,38287,38848,39167,39190,39751,40612],
 [7725,7726,7743,7769,7786,7828,7852,7853,8413,8414,8714,38205,
   38222,38246,38247,38264,38288,38289,38849,38850,39150,39167,
   39191,39192,39752,39753,40053,40613,40614,40914,50094],
 [7725,7726,7743,7769,7786,7828,7852,7853,8413,8414,8714,38205,
   38222,38246,38247,38264,38288,38289,38849,38850,39150,39167,
   39191,39192,39752,39753,40053,40613,40614,40914,50094],
 [7828,7875,7950,40055,40642,41411,42936],[7828,42193],
 [7828,7875,7950,40055,40642,41411,42936],
 [7828,7996,40196,43643],[7828,8032],[7828,44904],
 [7828,40287],[7828],[7828,8168],[7828,40287],[7828,47575],
 [7828,40450],[7828,40450],[7828,48796],[7828],
 [7828,44904],[],[7828,47575],
 [7828,7875,7950,40055,40642,41411,42936],[7828,48796],
 [7828,42193],[7828,8507,40707,49887],
 [7828,7875,7950,40055,40642,41411,42936],[7828,8168],
 [7828,8507,40707,49887],[7828,8032],[7828,7996,40196,43643],
 [7828],[7828,40824],[7828,40824],[7828],[7828,50046],
 [7828,40870],[7828,40870],[7828],[7828,50075],[7828],
 [7828,50075],[7828,50046],[7828],[7828,40914],
 [7828,40914],
 [7725,7726,7743,7769,7786,7812,7813,7814,7828,7830,7832,7834,
   7855,7869,7871,7875,7909,7913,7948,7950,7954,8391,8393,8395,
   8442,38205,38206,38207,38208,38222,38224,38226,38228,38248,
   38249,38250,38264,38266,38268,38270,38290,38291,38305,38307,
   38309,38311,38331,38345,38347,38349,38351,38384,38386,38388,
   38390,38827,38829,38831,38876,38878,38921,39151,39152,39153,
   39167,39169,39171,39173,39193,39194,39208,39210,39212,39214,
   39234,39248,39250,39252,39254,39287,39289,39291,39293,39730,
   39732,39734,39779,39781,39824,40054,40055,40069,40071,40073,
   40075,40095,40109,40111,40113,40115,40148,40150,40152,40154,
   40591,40593,40595,40640,40642,40685,40915,40929,40931,40933,
   40935,40968,40970,40972,40974,41411,41413,41415,41460,41462,
   41505,41748,41750,41752,41754,42191,42193,42195,42240,42242,
   42285,42932,42934,42936,42981,42983,43026,49820,49822,49865,
   50394],[7828,7875,7950,40055,40642,41411,42936],
 [7875,7996,41012,41016,41548,43772],
 [7812,7814,7816,7828,7830,7834,7837,7855,7869,7871,7875,7936,
   7948,7950,7954,7957,8023,8025,8032,8391,8395,8398,8442,8445,
   40055,40057,40069,40071,40075,40078,40136,40148,40150,40154,
   40157,40223,40225,40229,40232,40591,40595,40598,40642,40645,
   40727,40956,40968,40970,40974,40977,41043,41045,41049,41411,
   41415,41418,41462,41465,41547,42564,42566,42570,42573,42932,
   42936,42939,42983,42986,43068,44301,44305,44308,44352,44355,
   49822,49825,49907,50436],
 [7812,7814,7817,7818,7821,7827,7828,7830,7834,7855,7869,7871,
   7875,7948,7950,7954,8058,8059,8087,8094,8193,8364,8391,8395,
   8442,40055,40058,40059,40062,40068,40069,40071,40075,40137,
   40138,40141,40147,40148,40150,40154,40249,40252,40258,40259,
   40261,40265,40287,40293,40294,40296,40300,40392,40393,40395,
   40399,40564,40566,40570,40591,40595,40642,40957,40958,40961,
   40967,40968,40970,40974,41069,41072,41078,41079,41081,41085,
   41107,41113,41114,41116,41120,41212,41213,41215,41219,41384,
   41386,41390,41411,41415,41462,42590,42593,42599,42600,42602,
   42606,42628,42634,42635,42637,42641,42733,42734,42736,42740,
   42905,42907,42911,42932,42936,42983,44627,44633,44634,44636,
   44640,44732,44733,44735,44739,44904,44906,44910,44931,44935,
   44982,45327,45328,45330,45334,45499,45501,45505,45526,45530,
   45577,47084,47086,47090,47111,47115,47162,49471,49475,49522,
   49822],
 [7812,7814,7817,7818,7821,7827,7828,7830,7834,7855,7869,7871,
   7875,7948,7950,7954,8058,8059,8087,8094,8193,8364,8391,8395,
   8442,40055,40058,40059,40062,40068,40069,40071,40075,40137,
   40138,40141,40147,40148,40150,40154,40249,40252,40258,40259,
   40261,40265,40287,40293,40294,40296,40300,40392,40393,40395,
   40399,40564,40566,40570,40591,40595,40642,40957,40958,40961,
   40967,40968,40970,40974,41069,41072,41078,41079,41081,41085,
   41107,41113,41114,41116,41120,41212,41213,41215,41219,41384,
   41386,41390,41411,41415,41462,42590,42593,42599,42600,42602,
   42606,42628,42634,42635,42637,42641,42733,42734,42736,42740,
   42905,42907,42911,42932,42936,42983,44627,44633,44634,44636,
   44640,44732,44733,44735,44739,44904,44906,44910,44931,44935,
   44982,45327,45328,45330,45334,45499,45501,45505,45526,45530,
   45577,47084,47086,47090,47111,47115,47162,49471,49475,49522,
   49822],[7875,41154],
 [7812,7814,7820,7828,7830,7834,7835,7855,7869,7871,7875,7940,
   7948,7950,7954,7955,8161,8163,8168,8391,8395,8396,8442,8443,
   40055,40061,40069,40071,40075,40076,40140,40148,40150,40154,
   40155,40361,40363,40367,40368,40591,40595,40596,40642,40643,
   40725,40960,40968,40970,40974,40975,41181,41183,41187,41411,
   41415,41416,41462,41463,41545,42702,42704,42708,42709,42932,
   42936,42937,42983,42984,43066,46615,46619,46620,46666,46667,
   49822,49823,49905,50434],
 [7812,7814,7817,7818,7821,7827,7828,7830,7834,7855,7869,7871,
   7875,7948,7950,7954,8058,8059,8087,8094,8193,8364,8391,8395,
   8442,40055,40058,40059,40062,40068,40069,40071,40075,40137,
   40138,40141,40147,40148,40150,40154,40249,40252,40258,40259,
   40261,40265,40287,40293,40294,40296,40300,40392,40393,40395,
   40399,40564,40566,40570,40591,40595,40642,40957,40958,40961,
   40967,40968,40970,40974,41069,41072,41078,41079,41081,41085,
   41107,41113,41114,41116,41120,41212,41213,41215,41219,41384,
   41386,41390,41411,41415,41462,42590,42593,42599,42600,42602,
   42606,42628,42634,42635,42637,42641,42733,42734,42736,42740,
   42905,42907,42911,42932,42936,42983,44627,44633,44634,44636,
   44640,44732,44733,44735,44739,44904,44906,44910,44931,44935,
   44982,45327,45328,45330,45334,45499,45501,45505,45526,45530,
   45577,47084,47086,47090,47111,47115,47162,49471,49475,49522,
   49822],
 [7812,7814,7822,7823,7824,7828,7829,7830,7834,7855,7869,7871,
   7875,7948,7950,7954,8224,8225,8250,8254,8283,8390,8391,8395,
   8442,40055,40063,40064,40065,40069,40070,40071,40075,40142,
   40143,40144,40148,40149,40150,40154,40419,40420,40424,40425,
   40426,40430,40450,40454,40455,40456,40460,40483,40484,40485,
   40489,40590,40591,40595,40615,40619,40642,40962,40963,40964,
   40968,40969,40970,40974,41239,41240,41244,41245,41246,41250,
   41270,41274,41275,41276,41280,41303,41304,41305,41309,41410,
   41411,41415,41435,41439,41462,42760,42761,42765,42766,42767,
   42771,42791,42795,42796,42797,42801,42824,42825,42826,42830,
   42931,42932,42936,42956,42960,42983,47435,47439,47440,47441,
   47445,47468,47469,47470,47474,47575,47576,47580,47600,47604,
   47627,47903,47904,47905,47909,48010,48011,48015,48035,48039,
   48062,48416,48417,48421,48441,48445,48468,49795,49799,49822,
   50098],
 [7812,7814,7822,7823,7824,7828,7829,7830,7834,7855,7869,7871,
   7875,7948,7950,7954,8224,8225,8250,8254,8283,8390,8391,8395,
   8442,40055,40063,40064,40065,40069,40070,40071,40075,40142,
   40143,40144,40148,40149,40150,40154,40419,40420,40424,40425,
   40426,40430,40450,40454,40455,40456,40460,40483,40484,40485,
   40489,40590,40591,40595,40615,40619,40642,40962,40963,40964,
   40968,40969,40970,40974,41239,41240,41244,41245,41246,41250,
   41270,41274,41275,41276,41280,41303,41304,41305,41309,41410,
   41411,41415,41435,41439,41462,42760,42761,42765,42766,42767,
   42771,42791,42795,42796,42797,42801,42824,42825,42826,42830,
   42931,42932,42936,42956,42960,42983,47435,47439,47440,47441,
   47445,47468,47469,47470,47474,47575,47576,47580,47600,47604,
   47627,47903,47904,47905,47909,48010,48011,48015,48035,48039,
   48062,48416,48417,48421,48441,48445,48468,49795,49799,49822,
   50098],
 [7812,7814,7822,7823,7824,7828,7829,7830,7834,7855,7869,7871,
   7875,7948,7950,7954,8224,8225,8250,8254,8283,8390,8391,8395,
   8442,40055,40063,40064,40065,40069,40070,40071,40075,40142,
   40143,40144,40148,40149,40150,40154,40419,40420,40424,40425,
   40426,40430,40450,40454,40455,40456,40460,40483,40484,40485,
   40489,40590,40591,40595,40615,40619,40642,40962,40963,40964,
   40968,40969,40970,40974,41239,41240,41244,41245,41246,41250,
   41270,41274,41275,41276,41280,41303,41304,41305,41309,41410,
   41411,41415,41435,41439,41462,42760,42761,42765,42766,42767,
   42771,42791,42795,42796,42797,42801,42824,42825,42826,42830,
   42931,42932,42936,42956,42960,42983,47435,47439,47440,47441,
   47445,47468,47469,47470,47474,47575,47576,47580,47600,47604,
   47627,47903,47904,47905,47909,48010,48011,48015,48035,48039,
   48062,48416,48417,48421,48441,48445,48468,49795,49799,49822,
   50098],[7875,41337],
 [7812,7814,7826,7828,7830,7834,7855,7869,7871,7875,7948,7950,
   7954,8338,8391,8395,8442,40055,40067,40069,40071,40075,40146,
   40148,40150,40154,40538,40540,40544,40591,40595,40642,40966,
   40968,40970,40974,41358,41360,41364,41411,41415,41462,42879,
   42881,42885,42932,42936,42983,49146,49150,49197,49822],
 [7812,7814,7817,7818,7821,7827,7828,7830,7834,7855,7869,7871,
   7875,7948,7950,7954,8058,8059,8087,8094,8193,8364,8391,8395,
   8442,40055,40058,40059,40062,40068,40069,40071,40075,40137,
   40138,40141,40147,40148,40150,40154,40249,40252,40258,40259,
   40261,40265,40287,40293,40294,40296,40300,40392,40393,40395,
   40399,40564,40566,40570,40591,40595,40642,40957,40958,40961,
   40967,40968,40970,40974,41069,41072,41078,41079,41081,41085,
   41107,41113,41114,41116,41120,41212,41213,41215,41219,41384,
   41386,41390,41411,41415,41462,42590,42593,42599,42600,42602,
   42606,42628,42634,42635,42637,42641,42733,42734,42736,42740,
   42905,42907,42911,42932,42936,42983,44627,44633,44634,44636,
   44640,44732,44733,44735,44739,44904,44906,44910,44931,44935,
   44982,45327,45328,45330,45334,45499,45501,45505,45526,45530,
   45577,47084,47086,47090,47111,47115,47162,49471,49475,49522,
   49822],[7828,7875,7950,40055,40642,41411,42936],
 [7812,7814,7822,7823,7824,7828,7829,7830,7834,7855,7869,7871,
   7875,7948,7950,7954,8224,8225,8250,8254,8283,8390,8391,8395,
   8442,40055,40063,40064,40065,40069,40070,40071,40075,40142,
   40143,40144,40148,40149,40150,40154,40419,40420,40424,40425,
   40426,40430,40450,40454,40455,40456,40460,40483,40484,40485,
   40489,40590,40591,40595,40615,40619,40642,40962,40963,40964,
   40968,40969,40970,40974,41239,41240,41244,41245,41246,41250,
   41270,41274,41275,41276,41280,41303,41304,41305,41309,41410,
   41411,41415,41435,41439,41462,42760,42761,42765,42766,42767,
   42771,42791,42795,42796,42797,42801,42824,42825,42826,42830,
   42931,42932,42936,42956,42960,42983,47435,47439,47440,47441,
   47445,47468,47469,47470,47474,47575,47576,47580,47600,47604,
   47627,47903,47904,47905,47909,48010,48011,48015,48035,48039,
   48062,48416,48417,48421,48441,48445,48468,49795,49799,49822,
   50098],[7828,7875,7950,40055,40642,41411,42936],
 [7875,41484],
 [7725,7726,7743,7769,7786,7812,7813,7814,7828,7830,7832,7834,
   7855,7869,7871,7875,7909,7913,7948,7950,7954,8391,8393,8395,
   8442,38205,38206,38207,38208,38222,38224,38226,38228,38248,
   38249,38250,38264,38266,38268,38270,38290,38291,38305,38307,
   38309,38311,38331,38345,38347,38349,38351,38384,38386,38388,
   38390,38827,38829,38831,38876,38878,38921,39151,39152,39153,
   39167,39169,39171,39173,39193,39194,39208,39210,39212,39214,
   39234,39248,39250,39252,39254,39287,39289,39291,39293,39730,
   39732,39734,39779,39781,39824,40054,40055,40069,40071,40073,
   40075,40095,40109,40111,40113,40115,40148,40150,40152,40154,
   40591,40593,40595,40640,40642,40685,40915,40929,40931,40933,
   40935,40968,40970,40972,40974,41411,41413,41415,41460,41462,
   41505,41748,41750,41752,41754,42191,42193,42195,42240,42242,
   42285,42932,42934,42936,42981,42983,43026,49820,49822,49865,
   50394],[7875,8507,41525,41527,41546,51066],[],
 [7812,7814,7820,7828,7830,7834,7835,7855,7869,7871,7875,7940,
   7948,7950,7954,7955,8161,8163,8168,8391,8395,8396,8442,8443,
   40055,40061,40069,40071,40075,40076,40140,40148,40150,40154,
   40155,40361,40363,40367,40368,40591,40595,40596,40642,40643,
   40725,40960,40968,40970,40974,40975,41181,41183,41187,41411,
   41415,41416,41462,41463,41545,42702,42704,42708,42709,42932,
   42936,42937,42983,42984,43066,46615,46619,46620,46666,46667,
   49822,49823,49905,50434],[7875,8507,41525,41527,41546,51066]
  ,[7812,7814,7816,7828,7830,7834,7837,7855,7869,7871,7875,
   7936,7948,7950,7954,7957,8023,8025,8032,8391,8395,8398,8442,
   8445,40055,40057,40069,40071,40075,40078,40136,40148,40150,
   40154,40157,40223,40225,40229,40232,40591,40595,40598,40642,
   40645,40727,40956,40968,40970,40974,40977,41043,41045,41049,
   41411,41415,41418,41462,41465,41547,42564,42566,42570,42573,
   42932,42936,42939,42983,42986,43068,44301,44305,44308,44352,
   44355,49822,49825,49907,50436],
 [7875,7996,41012,41016,41548,43772],
 [7812,7814,7828,7830,7834,7839,7855,7869,7871,7875,7948,7950,
   7954,8391,8395,8400,8442,40055,40069,40071,40075,40080,40148,
   40150,40154,40159,40591,40595,40600,40642,40647,40729,40968,
   40970,40974,40979,41411,41415,41420,41462,41467,41549,42932,
   42936,42941,42983,42988,43070,49822,49827,49909,50438],
 [7875,41550],[7875,41551],
 [7812,7814,7828,7830,7834,7842,7855,7869,7871,7875,7948,7950,
   7954,8391,8395,8403,8442,40055,40069,40071,40075,40083,40148,
   40150,40154,40162,40591,40595,40603,40642,40650,40732,40968,
   40970,40974,40982,41411,41415,41423,41462,41470,41552,42932,
   42936,42944,42983,42991,43073,49822,49830,49912,50441],
 [7875,41553],[7875,41554],[7875,41555],
 [7812,7814,7828,7830,7834,7846,7855,7869,7871,7875,7948,7950,
   7954,8391,8395,8407,8442,40055,40069,40071,40075,40087,40148,
   40150,40154,40166,40591,40595,40607,40642,40654,40736,40968,
   40970,40974,40986,41411,41415,41427,41462,41474,41556,42932,
   42936,42948,42983,42995,43077,49822,49834,49916,50445],
 [7875,41557],
 [7812,7814,7828,7830,7834,7848,7855,7869,7871,7875,7948,7950,
   7954,8391,8395,8409,8442,40055,40069,40071,40075,40089,40148,
   40150,40154,40168,40591,40595,40609,40642,40656,40738,40968,
   40970,40974,40988,41411,41415,41429,41462,41476,41558,42932,
   42936,42950,42983,42997,43079,49822,49836,49918,50447],
 [7875,41559],[7875,41560],
 [7812,7814,7828,7830,7834,7851,7855,7869,7871,7875,7948,7950,
   7954,8391,8395,8412,8442,40055,40069,40071,40075,40092,40148,
   40150,40154,40171,40591,40595,40612,40642,40659,40741,40968,
   40970,40974,40991,41411,41415,41432,41462,41479,41561,42932,
   42936,42953,42983,43000,43082,49822,49839,49921,50450],
 [7875,41562],[7875,41563],
 [7725,7726,7743,7769,7786,7812,7813,7814,7828,7830,7832,7834,
   7855,7869,7871,7875,7909,7913,7948,7950,7954,8391,8393,8395,
   8442,38205,38206,38207,38208,38222,38224,38226,38228,38248,
   38249,38250,38264,38266,38268,38270,38290,38291,38305,38307,
   38309,38311,38331,38345,38347,38349,38351,38384,38386,38388,
   38390,38827,38829,38831,38876,38878,38921,39151,39152,39153,
   39167,39169,39171,39173,39193,39194,39208,39210,39212,39214,
   39234,39248,39250,39252,39254,39287,39289,39291,39293,39730,
   39732,39734,39779,39781,39824,40054,40055,40069,40071,40073,
   40075,40095,40109,40111,40113,40115,40148,40150,40152,40154,
   40591,40593,40595,40640,40642,40685,40915,40929,40931,40933,
   40935,40968,40970,40972,40974,41411,41413,41415,41460,41462,
   41505,41748,41750,41752,41754,42191,42193,42195,42240,42242,
   42285,42932,42934,42936,42981,42983,43026,49820,49822,49865,
   50394],
 [7813,7815,7828,7832,7838,7909,7913,7986,7996,8393,8399,40096,
   40109,40113,40119,40186,40190,40196,40593,40599,40689,41786,
   41790,41796,42193,42199,42289,43637,43643,43733,49869],
 [7813,7816,7828,7832,7833,7836,7837,7909,7913,8023,8032,8393,
   8394,8397,8398,8507,40097,40109,40113,40114,40117,40118,
   40223,40227,40228,40231,40232,40593,40594,40597,40598,40684,
   40687,40688,40707,40708,40762,41823,41827,41828,42193,42194,
   42197,42198,42284,42287,42288,42307,42308,42362,44303,44304,
   44307,44308,44394,44397,44417,49864,49867,49868,49887,49888,
   49942,50857,50912,51102],
 [7813,7817,7819,7827,7828,7832,7909,7913,8058,8059,8128,8364,
   8393,40098,40100,40108,40109,40113,40250,40258,40259,40263,
   40327,40328,40332,40564,40568,40593,41850,41858,41859,41863,
   41927,41928,41932,42164,42168,42193,44667,44668,44672,44904,
   44908,44933,46060,46064,46089,49473],
 [7813,7818,7821,7828,7832,7909,7913,8087,8094,8193,8393,40099,
   40102,40109,40113,40287,40294,40298,40393,40397,40593,41887,
   41894,41898,41993,41997,42193,45328,45332,45528,47113],
 [7813,7817,7819,7827,7828,7832,7909,7913,8058,8059,8128,8364,
   8393,40098,40100,40108,40109,40113,40250,40258,40259,40263,
   40327,40328,40332,40564,40568,40593,41850,41858,41859,41863,
   41927,41928,41932,42164,42168,42193,44667,44668,44672,44904,
   44908,44933,46060,46064,46089,49473],
 [7813,7820,7828,7832,7835,7909,7913,8161,8168,8393,8396,40101,
   40109,40113,40116,40361,40365,40368,40593,40596,40686,41961,
   41965,42193,42196,42286,46617,46620,49866],
 [7813,7818,7821,7828,7832,7909,7913,8087,8094,8193,8393,40099,
   40102,40109,40113,40287,40294,40298,40393,40397,40593,41887,
   41894,41898,41993,41997,42193,45328,45332,45528,47113],
 [7813,7822,7828,7829,7832,7909,7913,8224,8225,8390,8393,40103,
   40109,40110,40113,40424,40425,40428,40590,40593,40617,42024,
   42025,42028,42190,42193,42217,47575,47578,47602,49797],
 [7813,7823,7824,7828,7832,7909,7913,8250,8254,8283,8393,40104,
   40105,40109,40113,40450,40454,40458,40483,40487,40593,42050,
   42054,42058,42083,42087,42193,47903,47907,48013,48419],
 [7813,7823,7824,7828,7832,7909,7913,8250,8254,8283,8393,40104,
   40105,40109,40113,40450,40454,40458,40483,40487,40593,42050,
   42054,42058,42083,42087,42193,47903,47907,48013,48419],
 [7813,7825,7826,7828,7831,7832,7909,7913,8311,8314,8338,8392,
   8393,40106,40107,40109,40112,40113,40509,40511,40514,40515,
   40538,40541,40542,40592,40593,40662,42109,42111,42114,42115,
   42138,42141,42142,42192,42193,42262,48742,48745,48746,48796,
   48797,48866,49147,49148,49217,49842],
 [7813,7825,7826,7828,7831,7832,7909,7913,8311,8314,8338,8392,
   8393,40106,40107,40109,40112,40113,40509,40511,40514,40515,
   40538,40541,40542,40592,40593,40662,42109,42111,42114,42115,
   42138,42141,42142,42192,42193,42262,48742,48745,48746,48796,
   48797,48866,49147,49148,49217,49842],
 [7813,7817,7819,7827,7828,7832,7909,7913,8058,8059,8128,8364,
   8393,40098,40100,40108,40109,40113,40250,40258,40259,40263,
   40327,40328,40332,40564,40568,40593,41850,41858,41859,41863,
   41927,41928,41932,42164,42168,42193,44667,44668,44672,44904,
   44908,44933,46060,46064,46089,49473],[7828,42193],
 [7813,7822,7828,7829,7832,7909,7913,8224,8225,8390,8393,40103,
   40109,40110,40113,40424,40425,40428,40590,40593,40617,42024,
   42025,42028,42190,42193,42217,47575,47578,47602,49797],
 [7725,7726,7743,7769,7786,7812,7813,7814,7828,7830,7832,7834,
   7855,7869,7871,7875,7909,7913,7948,7950,7954,8391,8393,8395,
   8442,38205,38206,38207,38208,38222,38224,38226,38228,38248,
   38249,38250,38264,38266,38268,38270,38290,38291,38305,38307,
   38309,38311,38331,38345,38347,38349,38351,38384,38386,38388,
   38390,38827,38829,38831,38876,38878,38921,39151,39152,39153,
   39167,39169,39171,39173,39193,39194,39208,39210,39212,39214,
   39234,39248,39250,39252,39254,39287,39289,39291,39293,39730,
   39732,39734,39779,39781,39824,40054,40055,40069,40071,40073,
   40075,40095,40109,40111,40113,40115,40148,40150,40152,40154,
   40591,40593,40595,40640,40642,40685,40915,40929,40931,40933,
   40935,40968,40970,40972,40974,41411,41413,41415,41460,41462,
   41505,41748,41750,41752,41754,42191,42193,42195,42240,42242,
   42285,42932,42934,42936,42981,42983,43026,49820,49822,49865,
   50394],
 [7813,7825,7826,7828,7831,7832,7909,7913,8311,8314,8338,8392,
   8393,40106,40107,40109,40112,40113,40509,40511,40514,40515,
   40538,40541,40542,40592,40593,40662,42109,42111,42114,42115,
   42138,42141,42142,42192,42193,42262,48742,48745,48746,48796,
   48797,48866,49147,49148,49217,49842],[7828,42193],
 [7813,7816,7828,7832,7833,7836,7837,7909,7913,8023,8032,8393,
   8394,8397,8398,8507,40097,40109,40113,40114,40117,40118,
   40223,40227,40228,40231,40232,40593,40594,40597,40598,40684,
   40687,40688,40707,40708,40762,41823,41827,41828,42193,42194,
   42197,42198,42284,42287,42288,42307,42308,42362,44303,44304,
   44307,44308,44394,44397,44417,49864,49867,49868,49887,49888,
   49942,50857,50912,51102],
 [7725,7726,7743,7769,7786,7812,7813,7814,7828,7830,7832,7834,
   7855,7869,7871,7875,7909,7913,7948,7950,7954,8391,8393,8395,
   8442,38205,38206,38207,38208,38222,38224,38226,38228,38248,
   38249,38250,38264,38266,38268,38270,38290,38291,38305,38307,
   38309,38311,38331,38345,38347,38349,38351,38384,38386,38388,
   38390,38827,38829,38831,38876,38878,38921,39151,39152,39153,
   39167,39169,39171,39173,39193,39194,39208,39210,39212,39214,
   39234,39248,39250,39252,39254,39287,39289,39291,39293,39730,
   39732,39734,39779,39781,39824,40054,40055,40069,40071,40073,
   40075,40095,40109,40111,40113,40115,40148,40150,40152,40154,
   40591,40593,40595,40640,40642,40685,40915,40929,40931,40933,
   40935,40968,40970,40972,40974,41411,41413,41415,41460,41462,
   41505,41748,41750,41752,41754,42191,42193,42195,42240,42242,
   42285,42932,42934,42936,42981,42983,43026,49820,49822,49865,
   50394],
 [7813,7820,7828,7832,7835,7909,7913,8161,8168,8393,8396,40101,
   40109,40113,40116,40361,40365,40368,40593,40596,40686,41961,
   41965,42193,42196,42286,46617,46620,49866],
 [7813,7816,7828,7832,7833,7836,7837,7909,7913,8023,8032,8393,
   8394,8397,8398,8507,40097,40109,40113,40114,40117,40118,
   40223,40227,40228,40231,40232,40593,40594,40597,40598,40684,
   40687,40688,40707,40708,40762,41823,41827,41828,42193,42194,
   42197,42198,42284,42287,42288,42307,42308,42362,44303,44304,
   44307,44308,44394,44397,44417,49864,49867,49868,49887,49888,
   49942,50857,50912,51102],
 [7813,7816,7828,7832,7833,7836,7837,7909,7913,8023,8032,8393,
   8394,8397,8398,8507,40097,40109,40113,40114,40117,40118,
   40223,40227,40228,40231,40232,40593,40594,40597,40598,40684,
   40687,40688,40707,40708,40762,41823,41827,41828,42193,42194,
   42197,42198,42284,42287,42288,42307,42308,42362,44303,44304,
   44307,44308,44394,44397,44417,49864,49867,49868,49887,49888,
   49942,50857,50912,51102],
 [7813,7815,7828,7832,7838,7909,7913,7986,7996,8393,8399,40096,
   40109,40113,40119,40186,40190,40196,40593,40599,40689,41786,
   41790,41796,42193,42199,42289,43637,43643,43733,49869],
 [7813,7828,7832,7839,7909,7913,8393,8400,40109,40113,40120,
   40593,40600,40690,42193,42200,42290,49870],
 [7813,7828,7832,7840,7841,7909,7913,8393,8401,8402,8624,40109,
   40113,40121,40122,40593,40601,40602,40691,40692,40824,42193,
   42201,42202,42291,42292,42424,49871,49872,50004,50974],
 [7813,7828,7832,7840,7841,7909,7913,8393,8401,8402,8624,40109,
   40113,40121,40122,40593,40601,40602,40691,40692,40824,42193,
   42201,42202,42291,42292,42424,49871,49872,50004,50974],
 [7813,7828,7832,7842,7843,7850,7909,7913,8393,8403,8404,8411,
   8666,40109,40113,40123,40124,40131,40593,40603,40604,40611,
   40693,40694,40701,40849,40856,40866,42193,42203,42204,42211,
   42293,42294,42301,42449,42456,42466,49873,49874,49881,50029,
   50036,50046,50999,51006,51016,52181],
 [7813,7828,7832,7842,7843,7850,7909,7913,8393,8403,8404,8411,
   8666,40109,40113,40123,40124,40131,40593,40603,40604,40611,
   40693,40694,40701,40849,40856,40866,42193,42203,42204,42211,
   42293,42294,42301,42449,42456,42466,49873,49874,49881,50029,
   50036,50046,50999,51006,51016,52181],
 [7813,7828,7832,7844,7845,7909,7913,8393,8405,8406,8670,40109,
   40113,40125,40126,40593,40605,40606,40695,40696,40870,42193,
   42205,42206,42295,42296,42470,49875,49876,50050,51020],
 [7813,7828,7832,7844,7845,7909,7913,8393,8405,8406,8670,40109,
   40113,40125,40126,40593,40605,40606,40695,40696,40870,42193,
   42205,42206,42295,42296,42470,49875,49876,50050,51020],
 [7813,7828,7832,7846,7909,7913,8393,8407,40109,40113,40127,
   40593,40607,40697,42193,42207,42297,49877],
 [7813,7828,7832,7847,7848,7849,7909,7913,8393,8408,8409,8410,
   8695,40109,40113,40128,40129,40130,40593,40608,40609,40610,
   40698,40699,40700,40894,40895,40900,42193,42208,42209,42210,
   42298,42299,42300,42494,42495,42500,49878,49879,49880,50074,
   50075,50080,51044,51045,51050,52360],
 [7813,7828,7832,7847,7848,7849,7909,7913,8393,8408,8409,8410,
   8695,40109,40113,40128,40129,40130,40593,40608,40609,40610,
   40698,40699,40700,40894,40895,40900,42193,42208,42209,42210,
   42298,42299,42300,42494,42495,42500,49878,49879,49880,50074,
   50075,50080,51044,51045,51050,52360],
 [7813,7828,7832,7847,7848,7849,7909,7913,8393,8408,8409,8410,
   8695,40109,40113,40128,40129,40130,40593,40608,40609,40610,
   40698,40699,40700,40894,40895,40900,42193,42208,42209,42210,
   42298,42299,42300,42494,42495,42500,49878,49879,49880,50074,
   50075,50080,51044,51045,51050,52360],
 [7813,7828,7832,7842,7843,7850,7909,7913,8393,8403,8404,8411,
   8666,40109,40113,40123,40124,40131,40593,40603,40604,40611,
   40693,40694,40701,40849,40856,40866,42193,42203,42204,42211,
   42293,42294,42301,42449,42456,42466,49873,49874,49881,50029,
   50036,50046,50999,51006,51016,52181],
 [7813,7828,7832,7851,7909,7913,8393,8412,40109,40113,40132,
   40593,40612,40702,42193,42212,42302,49882],
 [7813,7828,7832,7852,7853,7909,7913,8393,8413,8414,8714,40109,
   40113,40133,40134,40593,40613,40614,40703,40704,40914,42193,
   42213,42214,42303,42304,42514,49883,49884,50094,51064],
 [7813,7828,7832,7852,7853,7909,7913,8393,8413,8414,8714,40109,
   40113,40133,40134,40593,40613,40614,40703,40704,40914,42193,
   42213,42214,42303,42304,42514,49883,49884,50094,51064],
 [7950,7996,8507,42529,42532,42535,42537,42982,42985,42987,43048,
   43050,43104,43685,43688,43690,43751,43753,43807,50416,50418,
   50472,51103],[7950,8032,42566,42986],
 [7812,7814,7817,7818,7821,7827,7828,7830,7834,7855,7869,7871,
   7875,7948,7950,7954,8058,8059,8087,8094,8193,8364,8391,8395,
   8442,40055,40058,40059,40062,40068,40069,40071,40075,40137,
   40138,40141,40147,40148,40150,40154,40249,40252,40258,40259,
   40261,40265,40287,40293,40294,40296,40300,40392,40393,40395,
   40399,40564,40566,40570,40591,40595,40642,40957,40958,40961,
   40967,40968,40970,40974,41069,41072,41078,41079,41081,41085,
   41107,41113,41114,41116,41120,41212,41213,41215,41219,41384,
   41386,41390,41411,41415,41462,42590,42593,42599,42600,42602,
   42606,42628,42634,42635,42637,42641,42733,42734,42736,42740,
   42905,42907,42911,42932,42936,42983,44627,44633,44634,44636,
   44640,44732,44733,44735,44739,44904,44906,44910,44931,44935,
   44982,45327,45328,45330,45334,45499,45501,45505,45526,45530,
   45577,47084,47086,47090,47111,47115,47162,49471,49475,49522,
   49822],
 [7812,7814,7817,7818,7821,7827,7828,7830,7834,7855,7869,7871,
   7875,7948,7950,7954,8058,8059,8087,8094,8193,8364,8391,8395,
   8442,40055,40058,40059,40062,40068,40069,40071,40075,40137,
   40138,40141,40147,40148,40150,40154,40249,40252,40258,40259,
   40261,40265,40287,40293,40294,40296,40300,40392,40393,40395,
   40399,40564,40566,40570,40591,40595,40642,40957,40958,40961,
   40967,40968,40970,40974,41069,41072,41078,41079,41081,41085,
   41107,41113,41114,41116,41120,41212,41213,41215,41219,41384,
   41386,41390,41411,41415,41462,42590,42593,42599,42600,42602,
   42606,42628,42634,42635,42637,42641,42733,42734,42736,42740,
   42905,42907,42911,42932,42936,42983,44627,44633,44634,44636,
   44640,44732,44733,44735,44739,44904,44906,44910,44931,44935,
   44982,45327,45328,45330,45334,45499,45501,45505,45526,45530,
   45577,47084,47086,47090,47111,47115,47162,49471,49475,49522,
   49822],[7950,42671],[7950,8168,42704,42984],
 [7812,7814,7817,7818,7821,7827,7828,7830,7834,7855,7869,7871,
   7875,7948,7950,7954,8058,8059,8087,8094,8193,8364,8391,8395,
   8442,40055,40058,40059,40062,40068,40069,40071,40075,40137,
   40138,40141,40147,40148,40150,40154,40249,40252,40258,40259,
   40261,40265,40287,40293,40294,40296,40300,40392,40393,40395,
   40399,40564,40566,40570,40591,40595,40642,40957,40958,40961,
   40967,40968,40970,40974,41069,41072,41078,41079,41081,41085,
   41107,41113,41114,41116,41120,41212,41213,41215,41219,41384,
   41386,41390,41411,41415,41462,42590,42593,42599,42600,42602,
   42606,42628,42634,42635,42637,42641,42733,42734,42736,42740,
   42905,42907,42911,42932,42936,42983,44627,44633,44634,44636,
   44640,44732,44733,44735,44739,44904,44906,44910,44931,44935,
   44982,45327,45328,45330,45334,45499,45501,45505,45526,45530,
   45577,47084,47086,47090,47111,47115,47162,49471,49475,49522,
   49822],
 [7812,7814,7822,7823,7824,7828,7829,7830,7834,7855,7869,7871,
   7875,7948,7950,7954,8224,8225,8250,8254,8283,8390,8391,8395,
   8442,40055,40063,40064,40065,40069,40070,40071,40075,40142,
   40143,40144,40148,40149,40150,40154,40419,40420,40424,40425,
   40426,40430,40450,40454,40455,40456,40460,40483,40484,40485,
   40489,40590,40591,40595,40615,40619,40642,40962,40963,40964,
   40968,40969,40970,40974,41239,41240,41244,41245,41246,41250,
   41270,41274,41275,41276,41280,41303,41304,41305,41309,41410,
   41411,41415,41435,41439,41462,42760,42761,42765,42766,42767,
   42771,42791,42795,42796,42797,42801,42824,42825,42826,42830,
   42931,42932,42936,42956,42960,42983,47435,47439,47440,47441,
   47445,47468,47469,47470,47474,47575,47576,47580,47600,47604,
   47627,47903,47904,47905,47909,48010,48011,48015,48035,48039,
   48062,48416,48417,48421,48441,48445,48468,49795,49799,49822,
   50098],
 [7812,7814,7822,7823,7824,7828,7829,7830,7834,7855,7869,7871,
   7875,7948,7950,7954,8224,8225,8250,8254,8283,8390,8391,8395,
   8442,40055,4006