/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
const CORE = '@angular/core';
export class Identifiers {
}
Identifiers.ANALYZE_FOR_ENTRY_COMPONENTS = {
    name: 'ANALYZE_FOR_ENTRY_COMPONENTS',
    moduleName: CORE,
};
Identifiers.ElementRef = { name: 'ElementRef', moduleName: CORE };
Identifiers.NgModuleRef = { name: 'NgModuleRef', moduleName: CORE };
Identifiers.ViewContainerRef = { name: 'ViewContainerRef', moduleName: CORE };
Identifiers.ChangeDetectorRef = {
    name: 'ChangeDetectorRef',
    moduleName: CORE,
};
Identifiers.QueryList = { name: 'QueryList', moduleName: CORE };
Identifiers.TemplateRef = { name: 'TemplateRef', moduleName: CORE };
Identifiers.Renderer2 = { name: 'Renderer2', moduleName: CORE };
Identifiers.CodegenComponentFactoryResolver = {
    name: 'ɵCodegenComponentFactoryResolver',
    moduleName: CORE,
};
Identifiers.ComponentFactoryResolver = {
    name: 'ComponentFactoryResolver',
    moduleName: CORE,
};
Identifiers.ComponentFactory = { name: 'ComponentFactory', moduleName: CORE };
Identifiers.ComponentRef = { name: 'ComponentRef', moduleName: CORE };
Identifiers.NgModuleFactory = { name: 'NgModuleFactory', moduleName: CORE };
Identifiers.createModuleFactory = {
    name: 'ɵcmf',
    moduleName: CORE,
};
Identifiers.moduleDef = {
    name: 'ɵmod',
    moduleName: CORE,
};
Identifiers.moduleProviderDef = {
    name: 'ɵmpd',
    moduleName: CORE,
};
Identifiers.RegisterModuleFactoryFn = {
    name: 'ɵregisterModuleFactory',
    moduleName: CORE,
};
Identifiers.inject = { name: 'ɵɵinject', moduleName: CORE };
Identifiers.INJECTOR = { name: 'INJECTOR', moduleName: CORE };
Identifiers.Injector = { name: 'Injector', moduleName: CORE };
Identifiers.ɵɵdefineInjectable = { name: 'ɵɵdefineInjectable', moduleName: CORE };
Identifiers.InjectableDef = { name: 'ɵɵInjectableDef', moduleName: CORE };
Identifiers.ViewEncapsulation = {
    name: 'ViewEncapsulation',
    moduleName: CORE,
};
Identifiers.ChangeDetectionStrategy = {
    name: 'ChangeDetectionStrategy',
    moduleName: CORE,
};
Identifiers.SecurityContext = {
    name: 'SecurityContext',
    moduleName: CORE,
};
Identifiers.LOCALE_ID = { name: 'LOCALE_ID', moduleName: CORE };
Identifiers.TRANSLATIONS_FORMAT = {
    name: 'TRANSLATIONS_FORMAT',
    moduleName: CORE,
};
Identifiers.inlineInterpolate = {
    name: 'ɵinlineInterpolate',
    moduleName: CORE,
};
Identifiers.interpolate = { name: 'ɵinterpolate', moduleName: CORE };
Identifiers.EMPTY_ARRAY = { name: 'ɵEMPTY_ARRAY', moduleName: CORE };
Identifiers.EMPTY_MAP = { name: 'ɵEMPTY_MAP', moduleName: CORE };
Identifiers.Renderer = { name: 'Renderer', moduleName: CORE };
Identifiers.viewDef = { name: 'ɵvid', moduleName: CORE };
Identifiers.elementDef = { name: 'ɵeld', moduleName: CORE };
Identifiers.anchorDef = { name: 'ɵand', moduleName: CORE };
Identifiers.textDef = { name: 'ɵted', moduleName: CORE };
Identifiers.directiveDef = { name: 'ɵdid', moduleName: CORE };
Identifiers.providerDef = { name: 'ɵprd', moduleName: CORE };
Identifiers.queryDef = { name: 'ɵqud', moduleName: CORE };
Identifiers.pureArrayDef = { name: 'ɵpad', moduleName: CORE };
Identifiers.pureObjectDef = { name: 'ɵpod', moduleName: CORE };
Identifiers.purePipeDef = { name: 'ɵppd', moduleName: CORE };
Identifiers.pipeDef = { name: 'ɵpid', moduleName: CORE };
Identifiers.nodeValue = { name: 'ɵnov', moduleName: CORE };
Identifiers.ngContentDef = { name: 'ɵncd', moduleName: CORE };
Identifiers.unwrapValue = { name: 'ɵunv', moduleName: CORE };
Identifiers.createRendererType2 = { name: 'ɵcrt', moduleName: CORE };
// type only
Identifiers.RendererType2 = {
    name: 'RendererType2',
    moduleName: CORE,
};
// type only
Identifiers.ViewDefinition = {
    name: 'ɵViewDefinition',
    moduleName: CORE,
};
Identifiers.createComponentFactory = { name: 'ɵccf', moduleName: CORE };
Identifiers.setClassMetadata = { name: 'ɵsetClassMetadata', moduleName: CORE };
export function createTokenForReference(reference) {
    return { identifier: { reference: reference } };
}
export function createTokenForExternalReference(reflector, reference) {
    return createTokenForReference(reflector.resolveExternalReference(reference));
}
//# sourceMappingURL=data:application/json;base64,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