#!/bin/bash

FIFO_FILE="/tmp/amixer_fifo"
get_HPmute=$(amixer cget name='HP Out Mute')
get_AMPmute=$(amixer cget name='ClassD AMP Mute')



producer() {
	stdbuf -oL amixer events 2>&1  > "$FIFO_FILE"
}


consumer() {
while true
do

	headset_on=$(amixer cget iface=CARD,name='Headset Jack'| grep "values=on")
	headset_off=$(amixer cget iface=CARD,name='Headset Jack'| grep "values=off")

	dptx0_on=$(amixer cget iface=CARD,name='dptx0_audio Jack'| grep "values=on")
	dptx0_off=$(amixer cget iface=CARD,name='dptx0_audio Jack'| grep "values=off")

	last_line=$(tail -n 1 "$FIFO_FILE")


	if grep -q "event value.*iface=CARD,name='Headset Jack'" "$FIFO_FILE"; then
		echo "Headset pluged/unpluged"
		if  test -n "$headset_off" ; then
			echo "headset unpluged"
			amixer cset iface=MIXER,name='ClassD AMP Mute' 0
			amixer cset iface=MIXER,name='HP Out Mute' 1
			amixer cset iface=MIXER,name='Headset Switch' 0
			amixer cset iface=MIXER,name='Headphone Switch' 0
                        amixer cset iface=MIXER,name='Stereo1 DAC MIXL DAC L1 Switch' 0
                        amixer cset iface=MIXER,name='Stereo1 DAC MIXR DAC R1 Switch' 0
			echo EoF > "$FIFO_FILE"

		elif test -n "$headset_on" ;then
			echo "headset pluged"
			amixer cset iface=MIXER,name='ClassD AMP Mute' 1
			amixer cset iface=MIXER,name='HP Out Mute' 0
			amixer cset iface=MIXER,name='Headset Switch' 1
                        amixer cset iface=MIXER,name='Headphone Switch' 1
                        amixer cset iface=MIXER,name='Stereo1 DAC MIXL DAC L1 Switch' 1
                        amixer cset iface=MIXER,name='Stereo1 DAC MIXR DAC R1 Switch' 1
			echo EoF > "$FIFO_FILE"
		fi

	elif [[ "$last_line" == *"Speaker Switch"* ]]; then
		echo "User switch to Speaker $last_line"
		amixer cset iface=MIXER,name='ClassD AMP Mute' 0
		amixer cset iface=MIXER,name='HP Out Mute' 1
		amixer cset iface=MIXER,name='Headset Switch' 0
		echo EoF > "$FIFO_FILE"

	elif [[ "$last_line" == *"Headphone Switch"* ]]; then
		echo "User switch to Headphone  $last_line"
		amixer cset iface=MIXER,name='ClassD AMP Mute' 1
		amixer cset iface=MIXER,name='HP Out Mute' 0
		amixer cset iface=MIXER,name='Headset Switch' 1
		echo EoF > "$FIFO_FILE"
	else
		echo EoF > "$FIFO_FILE"
	fi


	sleep 0.5
done
}

if [[ ! -f "$FIFO_FILE" ]]; then
	echo "amixer fifo not exit"
	touch /tmp/amixer_fifo
fi

producer &
consumer

