#ifdef BEFORE_PARSE
#undef BEFORE_PARSE
CPUGroup.add_option("-m", "--multiblock")
	.action("store_true")
	.dest("Multiblock")
	.help(
		"Controls multiblock code compilation\n"
		"Can cause long JIT compilation times and stutter\n"
	)
	.set_default(true);

CPUGroup.add_option("--no-multiblock")
	.action("store_false")
	.dest("Multiblock");

CPUGroup.add_option("-n", "--maxinst")
	.dest("MaxInst")
	.help(
		"Maximum number of instruction to store in a block"
	)
	.set_default(5000);

CPUGroup.add_option("--hostfeatures")
	.dest("HostFeatures")
	.help(
		"Allows controlling of the CPU features in the JIT.\n"
		"	off: Default CPU features queried from CPU features\n"
		"	{enable,disable}sve: Will force enable or disable sve even if the host doesn't support it\n"
		"	{enable,disable}avx: Will force enable or disable avx even if the host doesn't support it\n"
		"	{enable,disable}afp: Will force enable or disable afp even if the host doesn't support it\n"
		"	{enable,disable}lrcpc: Will force enable or disable lrcpc even if the host doesn't support it\n"
		"	{enable,disable}lrcpc2: Will force enable or disable lrcpc2 even if the host doesn't support it\n"
		"	{enable,disable}cssc: Will force enable or disable cssc even if the host doesn't support it\n"
		"	{enable,disable}pmull128: Will force enable or disable pmull128 even if the host doesn't support it\n"
		"	{enable,disable}rng: Will force enable or disable rng even if the host doesn't support it\n"
		"	{enable,disable}clzero: Will force enable or disable clzero even if the host doesn't support it\n"
		"	{enable,disable}atomics: Will force enable or disable ARMv8.1 LSE atomics even if the host doesn't support it\n"
		"	{enable,disable}fcma: Will force enable or disable fcma even if the host doesn't support it\n"
		"	{enable,disable}flagm: Will force enable or disable flagm even if the host doesn't support it\n"
		"	{enable,disable}flagm2: Will force enable or disable flagm2 even if the host doesn't support it\n"
		"	{enable,disable}crypto: Will force enable or disable crypto extensions even if the host doesn't support it\n"
		"	{enable,disable}rpres: Will force enable or disable rpres even if the host doesn't support it\n"
		"	{enable,disable}svebitperm: Will force enable or disable svebitperm even if the host doesn't support it\n"
		"	{enable,disable}preserveallabi: Will force enable or disable preserve_all abi even if the host doesn't support it\n"
		"	{enable,disable}wfxt: Will force enable or disable wfxt even if the host doesn't support it\n"
		"	{enable,disable}3dnow: Will force enable or disable 3DNow even if the host doesn't support it\n"
	)
	.set_default("FEXCore::Config::HostFeatures::OFF");

CPUGroup.add_option("--smalltscscale")
	.action("store_true")
	.dest("SmallTSCScale")
	.help(
		"Scales the cycle counter on systems that have low frequencies."
	)
	.set_default(true);

CPUGroup.add_option("--no-smalltscscale")
	.action("store_false")
	.dest("SmallTSCScale");


EmulationGroup.add_option("-R", "--rootfs")
	.dest("RootFS")
	.help(
		"Which Root filesystem prefix to use\n"
		"This can be a filesystem path\n"
		"	eg: ~/RootFS/Debian_x86_64\n"
		"Or this can be a name of a rootfs\n"
		"If the named rootfs exists in the FEX data folder then it will use that one\n"
		"	eg: $HOME/.fex-emu/RootFS/<RootFS name>/\n"
		"Or if you have XDG_DATA_HOME the config will search in that directory\n"
		"	eg: $XDG_DATA_HOME/.fex-emu/RootFS/<RootFS name>/\n"
	)
	.set_default("");

EmulationGroup.add_option("-t", "--thunkhostlibs")
	.dest("ThunkHostLibs")
	.help(
		"Folder to find the host-side thunking libraries."
	)
	.set_default("/usr/lib/fex-emu/HostThunks");

EmulationGroup.add_option("-j", "--thunkguestlibs")
	.dest("ThunkGuestLibs")
	.help(
		"Folder to find the guest-side thunking libraries."
	)
	.set_default("/usr/share/fex-emu/GuestThunks");

EmulationGroup.add_option("-k", "--thunkconfig")
	.dest("ThunkConfig")
	.help(
		"A json file specifying where to overlay the thunks.\n"
		"This can be a filesystem path\n"
		"	eg: ~/MyThunkConfig.json\n"
		"Or this can be a named of a Thunk config file\n"
		"If the named config file exists in the FEX data folder folder the it will use that one\n"
		"	eg: $HOME/.fex-emu/ThunkConfigs/<ThunkConfig name>\n"
		"Or if you have XDG_DATA_HOME the config will search in that directory\n"
		"	eg: $XDG_DATA_HOME/.fex-emu/ThunkConfigs/<ThunkConfig name>\n"
	)
	.set_default("");

EmulationGroup.add_option("-E", "--env")
	.dest("Env")
	.help(
		"Adds an environment variable to the emulated environment."
	)
	.set_default("");

EmulationGroup.add_option("-H", "--hostenv")
	.dest("HostEnv")
	.help(
		"Adds an environment variable to the host environment.\n"
		"This can be useful for setting environment variables that thunks can pick up.\n"
		"Typically isn't necessary since the guest libc isn't thunked. But is possible.\n"
	)
	.set_default("");

EmulationGroup.add_option("--additionalarguments")
	.dest("AdditionalArguments")
	.help(
		"Allows the user to pass additional arguments to the application"
	)
	.set_default("");


DebugGroup.add_option("-S", "--singlestep")
	.action("store_true")
	.dest("SingleStep")
	.help(
		"Single stepping configuration."
	)
	.set_default(false);

DebugGroup.add_option("--no-singlestep")
	.action("store_false")
	.dest("SingleStep");

DebugGroup.add_option("-G", "--gdbserver")
	.action("store_true")
	.dest("GdbServer")
	.help(
		"Enables the GDB server."
	)
	.set_default(false);

DebugGroup.add_option("--no-gdbserver")
	.action("store_false")
	.dest("GdbServer");

DebugGroup.add_option("--dumpir")
	.dest("DumpIR")
	.help(
		"Folder to dump the IR in to.\n"
		"[no, stdout, stderr, server, <Folder>]\n"
	)
	.set_default("no");

DebugGroup.add_option("--passmanagerdumpir")
	.dest("PassManagerDumpIR")
	.help(
		"Allows controlling when FEX dumps its IR.\n"
		"	off: IR dumping will be disabled\n"
		"	beforeopt: Dump IR before any optimizations\n"
		"	afteropt: Dump IR after all optimizations\n"
		"	beforepass: Dump IR before every optimization pass\n"
		"	afterpass: Dump IR after every optimization pass\n"
	)
	.set_default("FEXCore::Config::PassManagerDumpIR::OFF");

DebugGroup.add_option("-g", "--dumpgprs")
	.action("store_true")
	.dest("DumpGPRs")
	.help(
		"When the test harness ends, print the GPR state."
	)
	.set_default(false);

DebugGroup.add_option("--no-dumpgprs")
	.action("store_false")
	.dest("DumpGPRs");

DebugGroup.add_option("-O0", "--o0")
	.action("store_true")
	.dest("O0")
	.help(
		"Disables optimizations passes for debugging."
	)
	.set_default(false);

DebugGroup.add_option("--no-o0")
	.action("store_false")
	.dest("O0");

DebugGroup.add_option("--globaljitnaming")
	.action("store_true")
	.dest("GlobalJITNaming")
	.help(
		"Uses JITSymbols to name all JIT state as one symbol\n"
		"Useful for querying how much time is spent inside of the JIT\n"
		"Profiling tools will show JIT time as FEXJIT\n"
	)
	.set_default(false);

DebugGroup.add_option("--no-globaljitnaming")
	.action("store_false")
	.dest("GlobalJITNaming");

DebugGroup.add_option("--libraryjitnaming")
	.action("store_true")
	.dest("LibraryJITNaming")
	.help(
		"Uses JITSymbols to name JIT symbols grouped by library\n"
		"Useful for querying how much time is spent in each guest library\n"
		"Can be used to help guide thunk generation\n"
	)
	.set_default(false);

DebugGroup.add_option("--no-libraryjitnaming")
	.action("store_false")
	.dest("LibraryJITNaming");

DebugGroup.add_option("--blockjitnaming")
	.action("store_true")
	.dest("BlockJITNaming")
	.help(
		"Uses JITSymbols to name JIT symbols\n"
		"Useful for determining hot blocks of code\n"
		"Has some file writing overhead per JIT block\n"
	)
	.set_default(false);

DebugGroup.add_option("--no-blockjitnaming")
	.action("store_false")
	.dest("BlockJITNaming");

DebugGroup.add_option("--gdbsymbols")
	.action("store_true")
	.dest("GDBSymbols")
	.help(
		"Integrates with GDB using the JIT interface.\n"
		"Needs the fex jit loader in GDB, which can be loaded via `jit-reader-load libFEXGDBReader.so.`\n"
		"Also needs x86_64-linux-gnu-objdump in PATH.\n"
		"Can be very slow.\n"
	)
	.set_default(false);

DebugGroup.add_option("--no-gdbsymbols")
	.action("store_false")
	.dest("GDBSymbols");

DebugGroup.add_option("--injectlibsegfault")
	.action("store_true")
	.dest("InjectLibSegFault")
	.help(
		"Sets the environment variable LD_PRELOAD=libSegFault.so\n"
		"This allows the user to very easily enable libSegFault without dealing with environment variables\n"
		"Very useful for applications that have launch scripts that set the variable to nothing at launch\n"
		"Set this in an application configuration for injecting in to only specific applications.\n"
		"	Note: If x86/x86_64 libSegFault.so isn't installed then this option won't work.\n"
	)
	.set_default(false);

DebugGroup.add_option("--no-injectlibsegfault")
	.action("store_false")
	.dest("InjectLibSegFault");

DebugGroup.add_option("--disassemble")
	.dest("Disassemble")
	.help(
		"Allows controlling of the vixl disassembler.\n"
		"	off: No disassembly will be output\n"
		"	dispatcher: Will enable disassembly of the JIT dispatcher loop\n"
		"	blocks: Will enable disassembly of the translated instruction code blocks\n"
		"	stats: Will print stats when disassembling the code\n"
	)
	.set_default("FEXCore::Config::Disassemble::OFF");

DebugGroup.add_option("--forcesvewidth")
	.dest("ForceSVEWidth")
	.help(
		"Allows overriding the SVE width in the vixl simulator.\n"
		"Useful as a debugging feature.\n"
	)
	.set_default(0);

DebugGroup.add_option("--disabletelemetry")
	.action("store_true")
	.dest("DisableTelemetry")
	.help(
		"Disables telemetry at runtime.\n"
		"Useful for CI instcountCI mostly\n"
	)
	.set_default(false);

DebugGroup.add_option("--no-disabletelemetry")
	.action("store_false")
	.dest("DisableTelemetry");


LoggingGroup.add_option("-s", "--silentlog")
	.action("store_true")
	.dest("SilentLog")
	.help(
		"Disables logging"
	)
	.set_default(true);

LoggingGroup.add_option("--no-silentlog")
	.action("store_false")
	.dest("SilentLog");

LoggingGroup.add_option("-o", "--outputlog")
	.dest("OutputLog")
	.help(
		"File to write FEX output to.\n"
		"[stdout, stderr, server, <Filename>]\n"
	)
	.set_default("server");

LoggingGroup.add_option("--telemetrydirectory")
	.dest("TelemetryDirectory")
	.help(
		"Redirects the telemetry folder that FEX usually writes to.\n"
		"By default telemetry data is stored in {$FEX_APP_DATA_LOCATION,{$XDG_DATA_HOME,$HOME}/.fex-emu/Telemetry/}\n"
	)
	.set_default("");

LoggingGroup.add_option("--profilestats")
	.action("store_true")
	.dest("ProfileStats")
	.help(
		"Enables FEX's low-overhead sampling profile statistics.\n"
		"Requires a supported version of Mangohud to see the results\n"
	)
	.set_default(false);

LoggingGroup.add_option("--no-profilestats")
	.action("store_false")
	.dest("ProfileStats");


HacksGroup.add_option("--smcchecks")
	.dest("SMCChecks")
	.help(
		"Checks code for modification before execution.\n"
		"	none: No checks\n"
		"	mtrack: Page tracking based invalidation (default)\n"
		"	full: Validate code before every run (slow)\n"
	)
	.set_default("mtrack");

HacksGroup.add_option("--tsoenabled")
	.action("store_true")
	.dest("TSOEnabled")
	.help(
		"Controls TSO IR ops.\n"
		"Highly likely to break any multithreaded application if disabled.\n"
	)
	.set_default(true);

HacksGroup.add_option("--no-tsoenabled")
	.action("store_false")
	.dest("TSOEnabled");

HacksGroup.add_option("--vectortsoenabled")
	.action("store_true")
	.dest("VectorTSOEnabled")
	.help(
		"When TSO emulation is enabled, controls if vector loadstores should also be atomic."
	)
	.set_default(false);

HacksGroup.add_option("--no-vectortsoenabled")
	.action("store_false")
	.dest("VectorTSOEnabled");

HacksGroup.add_option("--memcpysettsoenabled")
	.action("store_true")
	.dest("MemcpySetTSOEnabled")
	.help(
		"When TSO emulation is enabled, controls if memcpy and memset should also be atomic.\n"
		"Only affects REP MOVS and REP STOS instructions\n"
	)
	.set_default(false);

HacksGroup.add_option("--no-memcpysettsoenabled")
	.action("store_false")
	.dest("MemcpySetTSOEnabled");

HacksGroup.add_option("--halfbarriertsoenabled")
	.action("store_true")
	.dest("HalfBarrierTSOEnabled")
	.help(
		"When TSO emulation is enabled, controls if unaligned loads and stores should be backpatched to half-barrier atomics.\n"
		"Can be dangerous due to aligned loadstores through the same code now become non-atomic.\n"
	)
	.set_default(true);

HacksGroup.add_option("--no-halfbarriertsoenabled")
	.action("store_false")
	.dest("HalfBarrierTSOEnabled");

HacksGroup.add_option("--strictinprocesssplitlocks")
	.action("store_true")
	.dest("StrictInProcessSplitLocks")
	.help(
		"Strict global lock when handling an unaligned atomic that crosses a 16-byte or cacheline granularity\n"
		"This is required to ensure a split-lock doesn't tear inside the process\n"
	)
	.set_default(false);

HacksGroup.add_option("--no-strictinprocesssplitlocks")
	.action("store_false")
	.dest("StrictInProcessSplitLocks");

HacksGroup.add_option("--tsoautomigration")
	.action("store_true")
	.dest("TSOAutoMigration")
	.help(
		"Automatically enables TSO when shared memory is used.\n"
		"Should work without issues in most cases.\n"
	)
	.set_default(true);

HacksGroup.add_option("--no-tsoautomigration")
	.action("store_false")
	.dest("TSOAutoMigration");

HacksGroup.add_option("--volatilemetadata")
	.action("store_true")
	.dest("VolatileMetadata")
	.help(
		"Use volatile metadata in PE files to inform TSO instructions when available.\n"
		"When metadata is unavailable falls back to the currently enabled TSO options.\n"
	)
	.set_default(true);

HacksGroup.add_option("--no-volatilemetadata")
	.action("store_false")
	.dest("VolatileMetadata");

HacksGroup.add_option("--x87reducedprecision")
	.action("store_true")
	.dest("X87ReducedPrecision")
	.help(
		"Emulates X87 floating point using 64-bit precision. This reduces emulation accuracy and may result in rendering bugs."
	)
	.set_default(false);

HacksGroup.add_option("--no-x87reducedprecision")
	.action("store_false")
	.dest("X87ReducedPrecision");

HacksGroup.add_option("--abilocalflags")
	.action("store_true")
	.dest("ABILocalFlags")
	.help(
		"When enabled enables an optimization around flags.\n"
		"Assumes flags are not used across cals.\n"
		"Hand-written assembly can violate this assumption.\n"
	)
	.set_default(false);

HacksGroup.add_option("--no-abilocalflags")
	.action("store_false")
	.dest("ABILocalFlags");

HacksGroup.add_option("--paranoidtso")
	.action("store_true")
	.dest("ParanoidTSO")
	.help(
		"Makes TSO operations even more strict.\n"
		"Forces vector loadstores to also become atomic.\n"
	)
	.set_default(false);

HacksGroup.add_option("--no-paranoidtso")
	.action("store_false")
	.dest("ParanoidTSO");

HacksGroup.add_option("--stallprocess")
	.action("store_true")
	.dest("StallProcess")
	.help(
		"Forces a process to stall out on initialization\n"
		"Useful for a process that keeps restarting and doesn't work\n"
	)
	.set_default(false);

HacksGroup.add_option("--no-stallprocess")
	.action("store_false")
	.dest("StallProcess");

HacksGroup.add_option("--hidehypervisorbit")
	.action("store_true")
	.dest("HideHypervisorBit")
	.help(
		"Hides the hypervisor CPUID bit when set.\n"
		"Should only be used for applications that have issues with this set.\n"
	)
	.set_default(false);

HacksGroup.add_option("--no-hidehypervisorbit")
	.action("store_false")
	.dest("HideHypervisorBit");

HacksGroup.add_option("--startupsleep")
	.dest("StartupSleep")
	.help(
		"Sleeps the process at startup for a duration of seconds.\n"
		"Useful if an application crashes too quickly to attach a debugger.\n"
	)
	.set_default(0);

HacksGroup.add_option("--startupsleepprocname")
	.dest("StartupSleepProcName")
	.help(
		"Contrains the startup sleep to only apply to processes that match this name."
	)
	.set_default("");

HacksGroup.add_option("--monohacks")
	.action("store_true")
	.dest("MonoHacks")
	.help(
		"Permits a hook-based SMC approach and smaller JIT blocks when mono is detected."
	)
	.set_default(true);

HacksGroup.add_option("--no-monohacks")
	.action("store_false")
	.dest("MonoHacks");


MiscGroup.add_option("--serversocketpath")
	.dest("ServerSocketPath")
	.help(
		"Override for a FEXServer socket path. Only useful for chroots."
	)
	.set_default("");

MiscGroup.add_option("--needsseccomp")
	.action("store_true")
	.dest("NeedsSeccomp")
	.help(
		"Disables inline syscalls in order to support seccomp handling"
	)
	.set_default(false);

MiscGroup.add_option("--no-needsseccomp")
	.action("store_false")
	.dest("NeedsSeccomp");

MiscGroup.add_option("--extendedvolatilemetadata")
	.dest("ExtendedVolatileMetadata")
	.help(
		"Configuration provided volatile metadata. Only implemented for WoW64/arm64ec.\n"
		"Limited in its use but can be handy.\n"
		"Extends on top of what Microsoft has for volatile metadata, but also supported for WoW64.\n"
		"Colon delimited modules, then semi-colon delimited instructions, then comma delimited ranges\n"
		"Default disables TSO in the module, unless instructions overlap the range\n"
		"<module>;<offset begin>-<offset-end>,...;<instruction offset to force TSO>,...:<another>\n"
		"examples:\n"
		"  * Disable TSO for a full module: Just provide the module name:\n"
		"      `hl2_linux`\n"
		"  * Disable TSO for a part of the module:\n"
		"      `hl2_linux;<offset begin>-<offset-end>`\n"
		"  * Disable TSO for a part of the module, but enable TSO for some instructions within the module\n"
		"      `hl2_linux;<offset begin>-<offset-end>;<instruction offset>,<instruction offset>`\n"
		"  * Disable TSO for multiple modules\n"
		"      `hl2_linux:libsdl2.so`\n"
	)
	.set_default("");


#endif
#ifdef AFTER_PARSE
#undef AFTER_PARSE
if (Options.is_set_by_user("Multiblock")) {
	bool UserValue = Options.get("Multiblock");
	Set(FEXCore::Config::ConfigOption::CONFIG_MULTIBLOCK, fextl::fmt::format("{:d}", UserValue));
}
if (Options.is_set_by_user("MaxInst")) {
	int32 UserValue = Options.get("MaxInst");
	Set(FEXCore::Config::ConfigOption::CONFIG_MAXINST, fextl::fmt::format("{}", UserValue));
}
if (Options.is_set_by_user("HostFeatures")) {
	fextl::string UserValue = Options["HostFeatures"];
	Set(FEXCore::Config::ConfigOption::CONFIG_HOSTFEATURES, FEXCore::Config::EnumParser<FEXCore::Config::HostFeaturesConfigPair>(FEXCore::Config::HostFeatures_EnumPairs, UserValue));
}
if (Options.is_set_by_user("SmallTSCScale")) {
	bool UserValue = Options.get("SmallTSCScale");
	Set(FEXCore::Config::ConfigOption::CONFIG_SMALLTSCSCALE, fextl::fmt::format("{:d}", UserValue));
}
if (Options.is_set_by_user("RootFS")) {
	fextl::string UserValue = Options["RootFS"];
	Set(FEXCore::Config::ConfigOption::CONFIG_ROOTFS, std::move(UserValue));
}
if (Options.is_set_by_user("ThunkHostLibs")) {
	fextl::string UserValue = Options["ThunkHostLibs"];
	Set(FEXCore::Config::ConfigOption::CONFIG_THUNKHOSTLIBS, std::move(UserValue));
}
if (Options.is_set_by_user("ThunkGuestLibs")) {
	fextl::string UserValue = Options["ThunkGuestLibs"];
	Set(FEXCore::Config::ConfigOption::CONFIG_THUNKGUESTLIBS, std::move(UserValue));
}
if (Options.is_set_by_user("ThunkConfig")) {
	fextl::string UserValue = Options["ThunkConfig"];
	Set(FEXCore::Config::ConfigOption::CONFIG_THUNKCONFIG, std::move(UserValue));
}
if (Options.is_set_by_user("Env")) {
	auto Array = Options.all("Env");
	for (auto iter = Array.begin(); iter != Array.end(); ++iter) {
		AppendStrArrayValue(FEXCore::Config::ConfigOption::CONFIG_ENV, *iter);
	}
}
if (Options.is_set_by_user("HostEnv")) {
	auto Array = Options.all("HostEnv");
	for (auto iter = Array.begin(); iter != Array.end(); ++iter) {
		AppendStrArrayValue(FEXCore::Config::ConfigOption::CONFIG_HOSTENV, *iter);
	}
}
if (Options.is_set_by_user("AdditionalArguments")) {
	auto Array = Options.all("AdditionalArguments");
	for (auto iter = Array.begin(); iter != Array.end(); ++iter) {
		AppendStrArrayValue(FEXCore::Config::ConfigOption::CONFIG_ADDITIONALARGUMENTS, *iter);
	}
}
if (Options.is_set_by_user("SingleStep")) {
	bool UserValue = Options.get("SingleStep");
	Set(FEXCore::Config::ConfigOption::CONFIG_SINGLESTEP, fextl::fmt::format("{:d}", UserValue));
}
if (Options.is_set_by_user("GdbServer")) {
	bool UserValue = Options.get("GdbServer");
	Set(FEXCore::Config::ConfigOption::CONFIG_GDBSERVER, fextl::fmt::format("{:d}", UserValue));
}
if (Options.is_set_by_user("DumpIR")) {
	fextl::string UserValue = Options["DumpIR"];
	Set(FEXCore::Config::ConfigOption::CONFIG_DUMPIR, std::move(UserValue));
}
if (Options.is_set_by_user("PassManagerDumpIR")) {
	fextl::string UserValue = Options["PassManagerDumpIR"];
	Set(FEXCore::Config::ConfigOption::CONFIG_PASSMANAGERDUMPIR, FEXCore::Config::EnumParser<FEXCore::Config::PassManagerDumpIRConfigPair>(FEXCore::Config::PassManagerDumpIR_EnumPairs, UserValue));
}
if (Options.is_set_by_user("DumpGPRs")) {
	bool UserValue = Options.get("DumpGPRs");
	Set(FEXCore::Config::ConfigOption::CONFIG_DUMPGPRS, fextl::fmt::format("{:d}", UserValue));
}
if (Options.is_set_by_user("O0")) {
	bool UserValue = Options.get("O0");
	Set(FEXCore::Config::ConfigOption::CONFIG_O0, fextl::fmt::format("{:d}", UserValue));
}
if (Options.is_set_by_user("GlobalJITNaming")) {
	bool UserValue = Options.get("GlobalJITNaming");
	Set(FEXCore::Config::ConfigOption::CONFIG_GLOBALJITNAMING, fextl::fmt::format("{:d}", UserValue));
}
if (Options.is_set_by_user("LibraryJITNaming")) {
	bool UserValue = Options.get("LibraryJITNaming");
	Set(FEXCore::Config::ConfigOption::CONFIG_LIBRARYJITNAMING, fextl::fmt::format("{:d}", UserValue));
}
if (Options.is_set_by_user("BlockJITNaming")) {
	bool UserValue = Options.get("BlockJITNaming");
	Set(FEXCore::Config::ConfigOption::CONFIG_BLOCKJITNAMING, fextl::fmt::format("{:d}", UserValue));
}
if (Options.is_set_by_user("GDBSymbols")) {
	bool UserValue = Options.get("GDBSymbols");
	Set(FEXCore::Config::ConfigOption::CONFIG_GDBSYMBOLS, fextl::fmt::format("{:d}", UserValue));
}
if (Options.is_set_by_user("InjectLibSegFault")) {
	bool UserValue = Options.get("InjectLibSegFault");
	Set(FEXCore::Config::ConfigOption::CONFIG_INJECTLIBSEGFAULT, fextl::fmt::format("{:d}", UserValue));
}
if (Options.is_set_by_user("Disassemble")) {
	fextl::string UserValue = Options["Disassemble"];
	Set(FEXCore::Config::ConfigOption::CONFIG_DISASSEMBLE, FEXCore::Config::EnumParser<FEXCore::Config::DisassembleConfigPair>(FEXCore::Config::Disassemble_EnumPairs, UserValue));
}
if (Options.is_set_by_user("ForceSVEWidth")) {
	uint32 UserValue = Options.get("ForceSVEWidth");
	Set(FEXCore::Config::ConfigOption::CONFIG_FORCESVEWIDTH, fextl::fmt::format("{}", UserValue));
}
if (Options.is_set_by_user("DisableTelemetry")) {
	bool UserValue = Options.get("DisableTelemetry");
	Set(FEXCore::Config::ConfigOption::CONFIG_DISABLETELEMETRY, fextl::fmt::format("{:d}", UserValue));
}
if (Options.is_set_by_user("SilentLog")) {
	bool UserValue = Options.get("SilentLog");
	Set(FEXCore::Config::ConfigOption::CONFIG_SILENTLOG, fextl::fmt::format("{:d}", UserValue));
}
if (Options.is_set_by_user("OutputLog")) {
	fextl::string UserValue = Options["OutputLog"];
	Set(FEXCore::Config::ConfigOption::CONFIG_OUTPUTLOG, std::move(UserValue));
}
if (Options.is_set_by_user("TelemetryDirectory")) {
	fextl::string UserValue = Options["TelemetryDirectory"];
	Set(FEXCore::Config::ConfigOption::CONFIG_TELEMETRYDIRECTORY, std::move(UserValue));
}
if (Options.is_set_by_user("ProfileStats")) {
	bool UserValue = Options.get("ProfileStats");
	Set(FEXCore::Config::ConfigOption::CONFIG_PROFILESTATS, fextl::fmt::format("{:d}", UserValue));
}
if (Options.is_set_by_user("SMCChecks")) {
	fextl::string UserValue = Options["SMCChecks"];
	Set(FEXCore::Config::ConfigOption::CONFIG_SMCCHECKS, FEXCore::Config::Handler::SMCCheckHandler(UserValue));
}
if (Options.is_set_by_user("TSOEnabled")) {
	bool UserValue = Options.get("TSOEnabled");
	Set(FEXCore::Config::ConfigOption::CONFIG_TSOENABLED, fextl::fmt::format("{:d}", UserValue));
}
if (Options.is_set_by_user("VectorTSOEnabled")) {
	bool UserValue = Options.get("VectorTSOEnabled");
	Set(FEXCore::Config::ConfigOption::CONFIG_VECTORTSOENABLED, fextl::fmt::format("{:d}", UserValue));
}
if (Options.is_set_by_user("MemcpySetTSOEnabled")) {
	bool UserValue = Options.get("MemcpySetTSOEnabled");
	Set(FEXCore::Config::ConfigOption::CONFIG_MEMCPYSETTSOENABLED, fextl::fmt::format("{:d}", UserValue));
}
if (Options.is_set_by_user("HalfBarrierTSOEnabled")) {
	bool UserValue = Options.get("HalfBarrierTSOEnabled");
	Set(FEXCore::Config::ConfigOption::CONFIG_HALFBARRIERTSOENABLED, fextl::fmt::format("{:d}", UserValue));
}
if (Options.is_set_by_user("StrictInProcessSplitLocks")) {
	bool UserValue = Options.get("StrictInProcessSplitLocks");
	Set(FEXCore::Config::ConfigOption::CONFIG_STRICTINPROCESSSPLITLOCKS, fextl::fmt::format("{:d}", UserValue));
}
if (Options.is_set_by_user("TSOAutoMigration")) {
	bool UserValue = Options.get("TSOAutoMigration");
	Set(FEXCore::Config::ConfigOption::CONFIG_TSOAUTOMIGRATION, fextl::fmt::format("{:d}", UserValue));
}
if (Options.is_set_by_user("VolatileMetadata")) {
	bool UserValue = Options.get("VolatileMetadata");
	Set(FEXCore::Config::ConfigOption::CONFIG_VOLATILEMETADATA, fextl::fmt::format("{:d}", UserValue));
}
if (Options.is_set_by_user("X87ReducedPrecision")) {
	bool UserValue = Options.get("X87ReducedPrecision");
	Set(FEXCore::Config::ConfigOption::CONFIG_X87REDUCEDPRECISION, fextl::fmt::format("{:d}", UserValue));
}
if (Options.is_set_by_user("ABILocalFlags")) {
	bool UserValue = Options.get("ABILocalFlags");
	Set(FEXCore::Config::ConfigOption::CONFIG_ABILOCALFLAGS, fextl::fmt::format("{:d}", UserValue));
}
if (Options.is_set_by_user("ParanoidTSO")) {
	bool UserValue = Options.get("ParanoidTSO");
	Set(FEXCore::Config::ConfigOption::CONFIG_PARANOIDTSO, fextl::fmt::format("{:d}", UserValue));
}
if (Options.is_set_by_user("StallProcess")) {
	bool UserValue = Options.get("StallProcess");
	Set(FEXCore::Config::ConfigOption::CONFIG_STALLPROCESS, fextl::fmt::format("{:d}", UserValue));
}
if (Options.is_set_by_user("HideHypervisorBit")) {
	bool UserValue = Options.get("HideHypervisorBit");
	Set(FEXCore::Config::ConfigOption::CONFIG_HIDEHYPERVISORBIT, fextl::fmt::format("{:d}", UserValue));
}
if (Options.is_set_by_user("StartupSleep")) {
	uint32 UserValue = Options.get("StartupSleep");
	Set(FEXCore::Config::ConfigOption::CONFIG_STARTUPSLEEP, fextl::fmt::format("{}", UserValue));
}
if (Options.is_set_by_user("StartupSleepProcName")) {
	fextl::string UserValue = Options["StartupSleepProcName"];
	Set(FEXCore::Config::ConfigOption::CONFIG_STARTUPSLEEPPROCNAME, std::move(UserValue));
}
if (Options.is_set_by_user("MonoHacks")) {
	bool UserValue = Options.get("MonoHacks");
	Set(FEXCore::Config::ConfigOption::CONFIG_MONOHACKS, fextl::fmt::format("{:d}", UserValue));
}
if (Options.is_set_by_user("ServerSocketPath")) {
	fextl::string UserValue = Options["ServerSocketPath"];
	Set(FEXCore::Config::ConfigOption::CONFIG_SERVERSOCKETPATH, std::move(UserValue));
}
if (Options.is_set_by_user("NeedsSeccomp")) {
	bool UserValue = Options.get("NeedsSeccomp");
	Set(FEXCore::Config::ConfigOption::CONFIG_NEEDSSECCOMP, fextl::fmt::format("{:d}", UserValue));
}
if (Options.is_set_by_user("ExtendedVolatileMetadata")) {
	fextl::string UserValue = Options["ExtendedVolatileMetadata"];
	Set(FEXCore::Config::ConfigOption::CONFIG_EXTENDEDVOLATILEMETADATA, std::move(UserValue));
}
#endif
#ifdef ENVLOADER
#undef ENVLOADER
if (false) {}
else if (Key == "FEX_HOSTFEATURES") {
	Value = FEXCore::Config::EnumParser<FEXCore::Config::HostFeaturesConfigPair>(FEXCore::Config::HostFeatures_EnumPairs, Value_View);
}
else if (Key == "FEX_PASSMANAGERDUMPIR") {
	Value = FEXCore::Config::EnumParser<FEXCore::Config::PassManagerDumpIRConfigPair>(FEXCore::Config::PassManagerDumpIR_EnumPairs, Value_View);
}
else if (Key == "FEX_DISASSEMBLE") {
	Value = FEXCore::Config::EnumParser<FEXCore::Config::DisassembleConfigPair>(FEXCore::Config::Disassemble_EnumPairs, Value_View);
}
else if (Key == "FEX_SMCCHECKS") {
	Value = FEXCore::Config::Handler::SMCCheckHandler(Value_View);
}
#endif
#ifdef JSONLOADER
#undef JSONLOADER
if (false) {}
else if (KeyName == "HostFeatures") {
	Set(KeyOption, FEXCore::Config::EnumParser<FEXCore::Config::HostFeaturesConfigPair>(FEXCore::Config::HostFeatures_EnumPairs, Value_View));
}
else if (KeyName == "Env") {
	AppendStrArrayValue(KeyOption, ConfigString);
}
else if (KeyName == "HostEnv") {
	AppendStrArrayValue(KeyOption, ConfigString);
}
else if (KeyName == "AdditionalArguments") {
	AppendStrArrayValue(KeyOption, ConfigString);
}
else if (KeyName == "PassManagerDumpIR") {
	Set(KeyOption, FEXCore::Config::EnumParser<FEXCore::Config::PassManagerDumpIRConfigPair>(FEXCore::Config::PassManagerDumpIR_EnumPairs, Value_View));
}
else if (KeyName == "Disassemble") {
	Set(KeyOption, FEXCore::Config::EnumParser<FEXCore::Config::DisassembleConfigPair>(FEXCore::Config::Disassemble_EnumPairs, Value_View));
}
else {
	Set(KeyOption, ConfigString);
}
#endif
#ifdef ENUMDEFINES
#undef ENUMDEFINES
enum class HostFeatures : uint64_t {
	OFF = 0,
	ENABLESVE = 1ULL << 0,
	DISABLESVE = 1ULL << 1,
	ENABLEAVX = 1ULL << 2,
	DISABLEAVX = 1ULL << 3,
	ENABLEAFP = 1ULL << 4,
	DISABLEAFP = 1ULL << 5,
	ENABLELRCPC = 1ULL << 6,
	DISABLELRCPC = 1ULL << 7,
	ENABLELRCPC2 = 1ULL << 8,
	DISABLELRCPC2 = 1ULL << 9,
	ENABLECSSC = 1ULL << 10,
	DISABLECSSC = 1ULL << 11,
	ENABLEPMULL128 = 1ULL << 12,
	DISABLEPMULL128 = 1ULL << 13,
	ENABLERNG = 1ULL << 14,
	DISABLERNG = 1ULL << 15,
	ENABLECLZERO = 1ULL << 16,
	DISABLECLZERO = 1ULL << 17,
	ENABLEATOMICS = 1ULL << 18,
	DISABLEATOMICS = 1ULL << 19,
	ENABLEFCMA = 1ULL << 20,
	DISABLEFCMA = 1ULL << 21,
	ENABLEFLAGM = 1ULL << 22,
	DISABLEFLAGM = 1ULL << 23,
	ENABLEFLAGM2 = 1ULL << 24,
	DISABLEFLAGM2 = 1ULL << 25,
	ENABLEFRINTTS = 1ULL << 26,
	DISABLEFRINTTS = 1ULL << 27,
	ENABLECRYPTO = 1ULL << 28,
	DISABLECRYPTO = 1ULL << 29,
	ENABLERPRES = 1ULL << 30,
	DISABLERPRES = 1ULL << 31,
	ENABLESVEBITPERM = 1ULL << 32,
	DISABLESVEBITPERM = 1ULL << 33,
	ENABLEPRESERVEALLABI = 1ULL << 34,
	DISABLEPRESERVEALLABI = 1ULL << 35,
	ENABLEWFXT = 1ULL << 36,
	DISABLEWFXT = 1ULL << 37,
	ENABLE3DNOW = 1ULL << 38,
	DISABLE3DNOW = 1ULL << 39,
};
FEX_DEF_NUM_OPS(HostFeatures)
enum class PassManagerDumpIR : uint64_t {
	OFF = 0,
	BEFOREOPT = 1ULL << 0,
	AFTEROPT = 1ULL << 1,
	BEFOREPASS = 1ULL << 2,
	AFTERPASS = 1ULL << 3,
};
FEX_DEF_NUM_OPS(PassManagerDumpIR)
enum class Disassemble : uint64_t {
	OFF = 0,
	DISPATCHER = 1ULL << 0,
	BLOCKS = 1ULL << 1,
	STATS = 1ULL << 2,
};
FEX_DEF_NUM_OPS(Disassemble)
using HostFeaturesConfigPair = std::pair<std::string_view, FEXCore::Config::HostFeatures>;
constexpr static std::array<HostFeaturesConfigPair, 41> HostFeatures_EnumPairs = {{
	{ "off", FEXCore::Config::HostFeatures::OFF },
	{ "enablesve", FEXCore::Config::HostFeatures::ENABLESVE },
	{ "disablesve", FEXCore::Config::HostFeatures::DISABLESVE },
	{ "enableavx", FEXCore::Config::HostFeatures::ENABLEAVX },
	{ "disableavx", FEXCore::Config::HostFeatures::DISABLEAVX },
	{ "enableafp", FEXCore::Config::HostFeatures::ENABLEAFP },
	{ "disableafp", FEXCore::Config::HostFeatures::DISABLEAFP },
	{ "enablelrcpc", FEXCore::Config::HostFeatures::ENABLELRCPC },
	{ "disablelrcpc", FEXCore::Config::HostFeatures::DISABLELRCPC },
	{ "enablelrcpc2", FEXCore::Config::HostFeatures::ENABLELRCPC2 },
	{ "disablelrcpc2", FEXCore::Config::HostFeatures::DISABLELRCPC2 },
	{ "enablecssc", FEXCore::Config::HostFeatures::ENABLECSSC },
	{ "disablecssc", FEXCore::Config::HostFeatures::DISABLECSSC },
	{ "enablepmull128", FEXCore::Config::HostFeatures::ENABLEPMULL128 },
	{ "disablepmull128", FEXCore::Config::HostFeatures::DISABLEPMULL128 },
	{ "enablerng", FEXCore::Config::HostFeatures::ENABLERNG },
	{ "disablerng", FEXCore::Config::HostFeatures::DISABLERNG },
	{ "enableclzero", FEXCore::Config::HostFeatures::ENABLECLZERO },
	{ "disableclzero", FEXCore::Config::HostFeatures::DISABLECLZERO },
	{ "enableatomics", FEXCore::Config::HostFeatures::ENABLEATOMICS },
	{ "disableatomics", FEXCore::Config::HostFeatures::DISABLEATOMICS },
	{ "enablefcma", FEXCore::Config::HostFeatures::ENABLEFCMA },
	{ "disablefcma", FEXCore::Config::HostFeatures::DISABLEFCMA },
	{ "enableflagm", FEXCore::Config::HostFeatures::ENABLEFLAGM },
	{ "disableflagm", FEXCore::Config::HostFeatures::DISABLEFLAGM },
	{ "enableflagm2", FEXCore::Config::HostFeatures::ENABLEFLAGM2 },
	{ "disableflagm2", FEXCore::Config::HostFeatures::DISABLEFLAGM2 },
	{ "enablefrintts", FEXCore::Config::HostFeatures::ENABLEFRINTTS },
	{ "disablefrintts", FEXCore::Config::HostFeatures::DISABLEFRINTTS },
	{ "enablecrypto", FEXCore::Config::HostFeatures::ENABLECRYPTO },
	{ "disablecrypto", FEXCore::Config::HostFeatures::DISABLECRYPTO },
	{ "enablerpres", FEXCore::Config::HostFeatures::ENABLERPRES },
	{ "disablerpres", FEXCore::Config::HostFeatures::DISABLERPRES },
	{ "enablesvebitperm", FEXCore::Config::HostFeatures::ENABLESVEBITPERM },
	{ "disablesvebitperm", FEXCore::Config::HostFeatures::DISABLESVEBITPERM },
	{ "enablepreserveallabi", FEXCore::Config::HostFeatures::ENABLEPRESERVEALLABI },
	{ "disablepreserveallabi", FEXCore::Config::HostFeatures::DISABLEPRESERVEALLABI },
	{ "enablewfxt", FEXCore::Config::HostFeatures::ENABLEWFXT },
	{ "disablewfxt", FEXCore::Config::HostFeatures::DISABLEWFXT },
	{ "enable3dnow", FEXCore::Config::HostFeatures::ENABLE3DNOW },
	{ "disable3dnow", FEXCore::Config::HostFeatures::DISABLE3DNOW },
}};
using PassManagerDumpIRConfigPair = std::pair<std::string_view, FEXCore::Config::PassManagerDumpIR>;
constexpr static std::array<PassManagerDumpIRConfigPair, 5> PassManagerDumpIR_EnumPairs = {{
	{ "off", FEXCore::Config::PassManagerDumpIR::OFF },
	{ "beforeopt", FEXCore::Config::PassManagerDumpIR::BEFOREOPT },
	{ "afteropt", FEXCore::Config::PassManagerDumpIR::AFTEROPT },
	{ "beforepass", FEXCore::Config::PassManagerDumpIR::BEFOREPASS },
	{ "afterpass", FEXCore::Config::PassManagerDumpIR::AFTERPASS },
}};
using DisassembleConfigPair = std::pair<std::string_view, FEXCore::Config::Disassemble>;
constexpr static std::array<DisassembleConfigPair, 4> Disassemble_EnumPairs = {{
	{ "off", FEXCore::Config::Disassemble::OFF },
	{ "dispatcher", FEXCore::Config::Disassemble::DISPATCHER },
	{ "blocks", FEXCore::Config::Disassemble::BLOCKS },
	{ "stats", FEXCore::Config::Disassemble::STATS },
}};
#endif
