/*
 * Copyright (C) 2014 BlueKitchen GmbH
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the copyright holders nor the names of
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 * 4. Any redistribution, use, or modification is done solely for
 *    personal benefit and not for any commercial purpose or for
 *    monetary gain.
 *
 * THIS SOFTWARE IS PROVIDED BY BLUEKITCHEN GMBH AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL BLUEKITCHEN
 * GMBH OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 * OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF
 * THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * Please inquire about commercial licensing options at 
 * contact@bluekitchen-gmbh.com
 *
 */


#define BTSTACK_FILE__ "btstack_memory.c"


/*
 *  btstack_memory.c
 *
 *  @brief BTstack memory management via configurable memory pools
 *
 *  @note code generated by tool/btstack_memory_generator.py
 *  @note returnes buffers are initialized with 0
 *
 */

#include "btstack_memory.h"
#include "btstack_memory_pool.h"
#include "btstack_debug.h"

#include <stdlib.h>

#ifdef ENABLE_MALLOC_TEST
void * test_malloc(size_t size);
#define malloc test_malloc
#endif

#ifdef HAVE_MALLOC
typedef struct btstack_memory_buffer {
    struct btstack_memory_buffer * next;
    struct btstack_memory_buffer * prev;
} btstack_memory_buffer_t;

typedef struct {
    btstack_memory_buffer_t tracking;
    void * pointer;
} test_buffer_t;

static btstack_memory_buffer_t * btstack_memory_malloc_buffers;
static uint32_t btstack_memory_malloc_counter;

static void btstack_memory_tracking_add(btstack_memory_buffer_t * buffer){
    btstack_assert(buffer != NULL);
    if (btstack_memory_malloc_buffers != NULL) {
        // let current first item prev point to new first item
        btstack_memory_malloc_buffers->prev = buffer;
    }
    buffer->prev = NULL;
    buffer->next = btstack_memory_malloc_buffers;
    btstack_memory_malloc_buffers = buffer;

    btstack_memory_malloc_counter++;
}

static void btstack_memory_tracking_remove(btstack_memory_buffer_t * buffer){
    btstack_assert(buffer != NULL);
    if (buffer->prev == NULL){
        // first item
        btstack_memory_malloc_buffers = buffer->next;
    } else {
        buffer->prev->next = buffer->next;
    }
    if (buffer->next != NULL){
        buffer->next->prev = buffer->prev;
    }

    btstack_memory_malloc_counter--;
}
#endif

void btstack_memory_deinit(void){
#ifdef HAVE_MALLOC
    while (btstack_memory_malloc_buffers != NULL){
        btstack_memory_buffer_t * buffer = btstack_memory_malloc_buffers;
        btstack_memory_malloc_buffers = buffer->next;
        free(buffer);
        btstack_memory_malloc_counter--;
    }
    btstack_assert(btstack_memory_malloc_counter == 0);
#endif
}


// MARK: hci_connection_t
#if !defined(HAVE_MALLOC) && !defined(MAX_NR_HCI_CONNECTIONS)
    #if defined(MAX_NO_HCI_CONNECTIONS)
        #error "Deprecated MAX_NO_HCI_CONNECTIONS defined instead of MAX_NR_HCI_CONNECTIONS. Please update your btstack_config.h to use MAX_NR_HCI_CONNECTIONS."
    #else
        #define MAX_NR_HCI_CONNECTIONS 0
    #endif
#endif

#ifdef MAX_NR_HCI_CONNECTIONS
#if MAX_NR_HCI_CONNECTIONS > 0
static hci_connection_t hci_connection_storage[MAX_NR_HCI_CONNECTIONS];
static btstack_memory_pool_t hci_connection_pool;
hci_connection_t * btstack_memory_hci_connection_get(void){
    void * buffer = btstack_memory_pool_get(&hci_connection_pool);
    if (buffer){
        memset(buffer, 0, sizeof(hci_connection_t));
    }
    return (hci_connection_t *) buffer;
}
void btstack_memory_hci_connection_free(hci_connection_t *hci_connection){
    btstack_memory_pool_free(&hci_connection_pool, hci_connection);
}
#else
hci_connection_t * btstack_memory_hci_connection_get(void){
    return NULL;
}
void btstack_memory_hci_connection_free(hci_connection_t *hci_connection){
    UNUSED(hci_connection);
}
#endif
#elif defined(HAVE_MALLOC)

typedef struct {
    btstack_memory_buffer_t tracking;
    hci_connection_t data;
} btstack_memory_hci_connection_t;

hci_connection_t * btstack_memory_hci_connection_get(void){
    btstack_memory_hci_connection_t * buffer = (btstack_memory_hci_connection_t *) malloc(sizeof(btstack_memory_hci_connection_t));
    if (buffer){
        memset(buffer, 0, sizeof(btstack_memory_hci_connection_t));
        btstack_memory_tracking_add(&buffer->tracking);
        return &buffer->data;
    } else {
        return NULL;
    }
}
void btstack_memory_hci_connection_free(hci_connection_t *hci_connection){
    // reconstruct buffer start
    btstack_memory_buffer_t * buffer = &((btstack_memory_buffer_t *) hci_connection)[-1];
    btstack_memory_tracking_remove(buffer);
    free(buffer);
}
#endif



// MARK: l2cap_service_t
#if !defined(HAVE_MALLOC) && !defined(MAX_NR_L2CAP_SERVICES)
    #if defined(MAX_NO_L2CAP_SERVICES)
        #error "Deprecated MAX_NO_L2CAP_SERVICES defined instead of MAX_NR_L2CAP_SERVICES. Please update your btstack_config.h to use MAX_NR_L2CAP_SERVICES."
    #else
        #define MAX_NR_L2CAP_SERVICES 0
    #endif
#endif

#ifdef MAX_NR_L2CAP_SERVICES
#if MAX_NR_L2CAP_SERVICES > 0
static l2cap_service_t l2cap_service_storage[MAX_NR_L2CAP_SERVICES];
static btstack_memory_pool_t l2cap_service_pool;
l2cap_service_t * btstack_memory_l2cap_service_get(void){
    void * buffer = btstack_memory_pool_get(&l2cap_service_pool);
    if (buffer){
        memset(buffer, 0, sizeof(l2cap_service_t));
    }
    return (l2cap_service_t *) buffer;
}
void btstack_memory_l2cap_service_free(l2cap_service_t *l2cap_service){
    btstack_memory_pool_free(&l2cap_service_pool, l2cap_service);
}
#else
l2cap_service_t * btstack_memory_l2cap_service_get(void){
    return NULL;
}
void btstack_memory_l2cap_service_free(l2cap_service_t *l2cap_service){
    UNUSED(l2cap_service);
}
#endif
#elif defined(HAVE_MALLOC)

typedef struct {
    btstack_memory_buffer_t tracking;
    l2cap_service_t data;
} btstack_memory_l2cap_service_t;

l2cap_service_t * btstack_memory_l2cap_service_get(void){
    btstack_memory_l2cap_service_t * buffer = (btstack_memory_l2cap_service_t *) malloc(sizeof(btstack_memory_l2cap_service_t));
    if (buffer){
        memset(buffer, 0, sizeof(btstack_memory_l2cap_service_t));
        btstack_memory_tracking_add(&buffer->tracking);
        return &buffer->data;
    } else {
        return NULL;
    }
}
void btstack_memory_l2cap_service_free(l2cap_service_t *l2cap_service){
    // reconstruct buffer start
    btstack_memory_buffer_t * buffer = &((btstack_memory_buffer_t *) l2cap_service)[-1];
    btstack_memory_tracking_remove(buffer);
    free(buffer);
}
#endif


// MARK: l2cap_channel_t
#if !defined(HAVE_MALLOC) && !defined(MAX_NR_L2CAP_CHANNELS)
    #if defined(MAX_NO_L2CAP_CHANNELS)
        #error "Deprecated MAX_NO_L2CAP_CHANNELS defined instead of MAX_NR_L2CAP_CHANNELS. Please update your btstack_config.h to use MAX_NR_L2CAP_CHANNELS."
    #else
        #define MAX_NR_L2CAP_CHANNELS 0
    #endif
#endif

#ifdef MAX_NR_L2CAP_CHANNELS
#if MAX_NR_L2CAP_CHANNELS > 0
static l2cap_channel_t l2cap_channel_storage[MAX_NR_L2CAP_CHANNELS];
static btstack_memory_pool_t l2cap_channel_pool;
l2cap_channel_t * btstack_memory_l2cap_channel_get(void){
    void * buffer = btstack_memory_pool_get(&l2cap_channel_pool);
    if (buffer){
        memset(buffer, 0, sizeof(l2cap_channel_t));
    }
    return (l2cap_channel_t *) buffer;
}
void btstack_memory_l2cap_channel_free(l2cap_channel_t *l2cap_channel){
    btstack_memory_pool_free(&l2cap_channel_pool, l2cap_channel);
}
#else
l2cap_channel_t * btstack_memory_l2cap_channel_get(void){
    return NULL;
}
void btstack_memory_l2cap_channel_free(l2cap_channel_t *l2cap_channel){
    UNUSED(l2cap_channel);
}
#endif
#elif defined(HAVE_MALLOC)

typedef struct {
    btstack_memory_buffer_t tracking;
    l2cap_channel_t data;
} btstack_memory_l2cap_channel_t;

l2cap_channel_t * btstack_memory_l2cap_channel_get(void){
    btstack_memory_l2cap_channel_t * buffer = (btstack_memory_l2cap_channel_t *) malloc(sizeof(btstack_memory_l2cap_channel_t));
    if (buffer){
        memset(buffer, 0, sizeof(btstack_memory_l2cap_channel_t));
        btstack_memory_tracking_add(&buffer->tracking);
        return &buffer->data;
    } else {
        return NULL;
    }
}
void btstack_memory_l2cap_channel_free(l2cap_channel_t *l2cap_channel){
    // reconstruct buffer start
    btstack_memory_buffer_t * buffer = &((btstack_memory_buffer_t *) l2cap_channel)[-1];
    btstack_memory_tracking_remove(buffer);
    free(buffer);
}
#endif


#ifdef ENABLE_CLASSIC

// MARK: rfcomm_multiplexer_t
#if !defined(HAVE_MALLOC) && !defined(MAX_NR_RFCOMM_MULTIPLEXERS)
    #if defined(MAX_NO_RFCOMM_MULTIPLEXERS)
        #error "Deprecated MAX_NO_RFCOMM_MULTIPLEXERS defined instead of MAX_NR_RFCOMM_MULTIPLEXERS. Please update your btstack_config.h to use MAX_NR_RFCOMM_MULTIPLEXERS."
    #else
        #define MAX_NR_RFCOMM_MULTIPLEXERS 0
    #endif
#endif

#ifdef MAX_NR_RFCOMM_MULTIPLEXERS
#if MAX_NR_RFCOMM_MULTIPLEXERS > 0
static rfcomm_multiplexer_t rfcomm_multiplexer_storage[MAX_NR_RFCOMM_MULTIPLEXERS];
static btstack_memory_pool_t rfcomm_multiplexer_pool;
rfcomm_multiplexer_t * btstack_memory_rfcomm_multiplexer_get(void){
    void * buffer = btstack_memory_pool_get(&rfcomm_multiplexer_pool);
    if (buffer){
        memset(buffer, 0, sizeof(rfcomm_multiplexer_t));
    }
    return (rfcomm_multiplexer_t *) buffer;
}
void btstack_memory_rfcomm_multiplexer_free(rfcomm_multiplexer_t *rfcomm_multiplexer){
    btstack_memory_pool_free(&rfcomm_multiplexer_pool, rfcomm_multiplexer);
}
#else
rfcomm_multiplexer_t * btstack_memory_rfcomm_multiplexer_get(void){
    return NULL;
}
void btstack_memory_rfcomm_multiplexer_free(rfcomm_multiplexer_t *rfcomm_multiplexer){
    UNUSED(rfcomm_multiplexer);
}
#endif
#elif defined(HAVE_MALLOC)

typedef struct {
    btstack_memory_buffer_t tracking;
    rfcomm_multiplexer_t data;
} btstack_memory_rfcomm_multiplexer_t;

rfcomm_multiplexer_t * btstack_memory_rfcomm_multiplexer_get(void){
    btstack_memory_rfcomm_multiplexer_t * buffer = (btstack_memory_rfcomm_multiplexer_t *) malloc(sizeof(btstack_memory_rfcomm_multiplexer_t));
    if (buffer){
        memset(buffer, 0, sizeof(btstack_memory_rfcomm_multiplexer_t));
        btstack_memory_tracking_add(&buffer->tracking);
        return &buffer->data;
    } else {
        return NULL;
    }
}
void btstack_memory_rfcomm_multiplexer_free(rfcomm_multiplexer_t *rfcomm_multiplexer){
    // reconstruct buffer start
    btstack_memory_buffer_t * buffer = &((btstack_memory_buffer_t *) rfcomm_multiplexer)[-1];
    btstack_memory_tracking_remove(buffer);
    free(buffer);
}
#endif


// MARK: rfcomm_service_t
#if !defined(HAVE_MALLOC) && !defined(MAX_NR_RFCOMM_SERVICES)
    #if defined(MAX_NO_RFCOMM_SERVICES)
        #error "Deprecated MAX_NO_RFCOMM_SERVICES defined instead of MAX_NR_RFCOMM_SERVICES. Please update your btstack_config.h to use MAX_NR_RFCOMM_SERVICES."
    #else
        #define MAX_NR_RFCOMM_SERVICES 0
    #endif
#endif

#ifdef MAX_NR_RFCOMM_SERVICES
#if MAX_NR_RFCOMM_SERVICES > 0
static rfcomm_service_t rfcomm_service_storage[MAX_NR_RFCOMM_SERVICES];
static btstack_memory_pool_t rfcomm_service_pool;
rfcomm_service_t * btstack_memory_rfcomm_service_get(void){
    void * buffer = btstack_memory_pool_get(&rfcomm_service_pool);
    if (buffer){
        memset(buffer, 0, sizeof(rfcomm_service_t));
    }
    return (rfcomm_service_t *) buffer;
}
void btstack_memory_rfcomm_service_free(rfcomm_service_t *rfcomm_service){
    btstack_memory_pool_free(&rfcomm_service_pool, rfcomm_service);
}
#else
rfcomm_service_t * btstack_memory_rfcomm_service_get(void){
    return NULL;
}
void btstack_memory_rfcomm_service_free(rfcomm_service_t *rfcomm_service){
    UNUSED(rfcomm_service);
}
#endif
#elif defined(HAVE_MALLOC)

typedef struct {
    btstack_memory_buffer_t tracking;
    rfcomm_service_t data;
} btstack_memory_rfcomm_service_t;

rfcomm_service_t * btstack_memory_rfcomm_service_get(void){
    btstack_memory_rfcomm_service_t * buffer = (btstack_memory_rfcomm_service_t *) malloc(sizeof(btstack_memory_rfcomm_service_t));
    if (buffer){
        memset(buffer, 0, sizeof(btstack_memory_rfcomm_service_t));
        btstack_memory_tracking_add(&buffer->tracking);
        return &buffer->data;
    } else {
        return NULL;
    }
}
void btstack_memory_rfcomm_service_free(rfcomm_service_t *rfcomm_service){
    // reconstruct buffer start
    btstack_memory_buffer_t * buffer = &((btstack_memory_buffer_t *) rfcomm_service)[-1];
    btstack_memory_tracking_remove(buffer);
    free(buffer);
}
#endif


// MARK: rfcomm_channel_t
#if !defined(HAVE_MALLOC) && !defined(MAX_NR_RFCOMM_CHANNELS)
    #if defined(MAX_NO_RFCOMM_CHANNELS)
        #error "Deprecated MAX_NO_RFCOMM_CHANNELS defined instead of MAX_NR_RFCOMM_CHANNELS. Please update your btstack_config.h to use MAX_NR_RFCOMM_CHANNELS."
    #else
        #define MAX_NR_RFCOMM_CHANNELS 0
    #endif
#endif

#ifdef MAX_NR_RFCOMM_CHANNELS
#if MAX_NR_RFCOMM_CHANNELS > 0
static rfcomm_channel_t rfcomm_channel_storage[MAX_NR_RFCOMM_CHANNELS];
static btstack_memory_pool_t rfcomm_channel_pool;
rfcomm_channel_t * btstack_memory_rfcomm_channel_get(void){
    void * buffer = btstack_memory_pool_get(&rfcomm_channel_pool);
    if (buffer){
        memset(buffer, 0, sizeof(rfcomm_channel_t));
    }
    return (rfcomm_channel_t *) buffer;
}
void btstack_memory_rfcomm_channel_free(rfcomm_channel_t *rfcomm_channel){
    btstack_memory_pool_free(&rfcomm_channel_pool, rfcomm_channel);
}
#else
rfcomm_channel_t * btstack_memory_rfcomm_channel_get(void){
    return NULL;
}
void btstack_memory_rfcomm_channel_free(rfcomm_channel_t *rfcomm_channel){
    UNUSED(rfcomm_channel);
}
#endif
#elif defined(HAVE_MALLOC)

typedef struct {
    btstack_memory_buffer_t tracking;
    rfcomm_channel_t data;
} btstack_memory_rfcomm_channel_t;

rfcomm_channel_t * btstack_memory_rfcomm_channel_get(void){
    btstack_memory_rfcomm_channel_t * buffer = (btstack_memory_rfcomm_channel_t *) malloc(sizeof(btstack_memory_rfcomm_channel_t));
    if (buffer){
        memset(buffer, 0, sizeof(btstack_memory_rfcomm_channel_t));
        btstack_memory_tracking_add(&buffer->tracking);
        return &buffer->data;
    } else {
        return NULL;
    }
}
void btstack_memory_rfcomm_channel_free(rfcomm_channel_t *rfcomm_channel){
    // reconstruct buffer start
    btstack_memory_buffer_t * buffer = &((btstack_memory_buffer_t *) rfcomm_channel)[-1];
    btstack_memory_tracking_remove(buffer);
    free(buffer);
}
#endif



// MARK: btstack_link_key_db_memory_entry_t
#if !defined(HAVE_MALLOC) && !defined(MAX_NR_BTSTACK_LINK_KEY_DB_MEMORY_ENTRIES)
    #if defined(MAX_NO_BTSTACK_LINK_KEY_DB_MEMORY_ENTRIES)
        #error "Deprecated MAX_NO_BTSTACK_LINK_KEY_DB_MEMORY_ENTRIES defined instead of MAX_NR_BTSTACK_LINK_KEY_DB_MEMORY_ENTRIES. Please update your btstack_config.h to use MAX_NR_BTSTACK_LINK_KEY_DB_MEMORY_ENTRIES."
    #else
        #define MAX_NR_BTSTACK_LINK_KEY_DB_MEMORY_ENTRIES 0
    #endif
#endif

#ifdef MAX_NR_BTSTACK_LINK_KEY_DB_MEMORY_ENTRIES
#if MAX_NR_BTSTACK_LINK_KEY_DB_MEMORY_ENTRIES > 0
static btstack_link_key_db_memory_entry_t btstack_link_key_db_memory_entry_storage[MAX_NR_BTSTACK_LINK_KEY_DB_MEMORY_ENTRIES];
static btstack_memory_pool_t btstack_link_key_db_memory_entry_pool;
btstack_link_key_db_memory_entry_t * btstack_memory_btstack_link_key_db_memory_entry_get(void){
    void * buffer = btstack_memory_pool_get(&btstack_link_key_db_memory_entry_pool);
    if (buffer){
        memset(buffer, 0, sizeof(btstack_link_key_db_memory_entry_t));
    }
    return (btstack_link_key_db_memory_entry_t *) buffer;
}
void btstack_memory_btstack_link_key_db_memory_entry_free(btstack_link_key_db_memory_entry_t *btstack_link_key_db_memory_entry){
    btstack_memory_pool_free(&btstack_link_key_db_memory_entry_pool, btstack_link_key_db_memory_entry);
}
#else
btstack_link_key_db_memory_entry_t * btstack_memory_btstack_link_key_db_memory_entry_get(void){
    return NULL;
}
void btstack_memory_btstack_link_key_db_memory_entry_free(btstack_link_key_db_memory_entry_t *btstack_link_key_db_memory_entry){
    UNUSED(btstack_link_key_db_memory_entry);
}
#endif
#elif defined(HAVE_MALLOC)

typedef struct {
    btstack_memory_buffer_t tracking;
    btstack_link_key_db_memory_entry_t data;
} btstack_memory_btstack_link_key_db_memory_entry_t;

btstack_link_key_db_memory_entry_t * btstack_memory_btstack_link_key_db_memory_entry_get(void){
    btstack_memory_btstack_link_key_db_memory_entry_t * buffer = (btstack_memory_btstack_link_key_db_memory_entry_t *) malloc(sizeof(btstack_memory_btstack_link_key_db_memory_entry_t));
    if (buffer){
        memset(buffer, 0, sizeof(btstack_memory_btstack_link_key_db_memory_entry_t));
        btstack_memory_tracking_add(&buffer->tracking);
        return &buffer->data;
    } else {
        return NULL;
    }
}
void btstack_memory_btstack_link_key_db_memory_entry_free(btstack_link_key_db_memory_entry_t *btstack_link_key_db_memory_entry){
    // reconstruct buffer start
    btstack_memory_buffer_t * buffer = &((btstack_memory_buffer_t *) btstack_link_key_db_memory_entry)[-1];
    btstack_memory_tracking_remove(buffer);
    free(buffer);
}
#endif



// MARK: bnep_service_t
#if !defined(HAVE_MALLOC) && !defined(MAX_NR_BNEP_SERVICES)
    #if defined(MAX_NO_BNEP_SERVICES)
        #error "Deprecated MAX_NO_BNEP_SERVICES defined instead of MAX_NR_BNEP_SERVICES. Please update your btstack_config.h to use MAX_NR_BNEP_SERVICES."
    #else
        #define MAX_NR_BNEP_SERVICES 0
    #endif
#endif

#ifdef MAX_NR_BNEP_SERVICES
#if MAX_NR_BNEP_SERVICES > 0
static bnep_service_t bnep_service_storage[MAX_NR_BNEP_SERVICES];
static btstack_memory_pool_t bnep_service_pool;
bnep_service_t * btstack_memory_bnep_service_get(void){
    void * buffer = btstack_memory_pool_get(&bnep_service_pool);
    if (buffer){
        memset(buffer, 0, sizeof(bnep_service_t));
    }
    return (bnep_service_t *) buffer;
}
void btstack_memory_bnep_service_free(bnep_service_t *bnep_service){
    btstack_memory_pool_free(&bnep_service_pool, bnep_service);
}
#else
bnep_service_t * btstack_memory_bnep_service_get(void){
    return NULL;
}
void btstack_memory_bnep_service_free(bnep_service_t *bnep_service){
    UNUSED(bnep_service);
}
#endif
#elif defined(HAVE_MALLOC)

typedef struct {
    btstack_memory_buffer_t tracking;
    bnep_service_t data;
} btstack_memory_bnep_service_t;

bnep_service_t * btstack_memory_bnep_service_get(void){
    btstack_memory_bnep_service_t * buffer = (btstack_memory_bnep_service_t *) malloc(sizeof(btstack_memory_bnep_service_t));
    if (buffer){
        memset(buffer, 0, sizeof(btstack_memory_bnep_service_t));
        btstack_memory_tracking_add(&buffer->tracking);
        return &buffer->data;
    } else {
        return NULL;
    }
}
void btstack_memory_bnep_service_free(bnep_service_t *bnep_service){
    // reconstruct buffer start
    btstack_memory_buffer_t * buffer = &((btstack_memory_buffer_t *) bnep_service)[-1];
    btstack_memory_tracking_remove(buffer);
    free(buffer);
}
#endif


// MARK: bnep_channel_t
#if !defined(HAVE_MALLOC) && !defined(MAX_NR_BNEP_CHANNELS)
    #if defined(MAX_NO_BNEP_CHANNELS)
        #error "Deprecated MAX_NO_BNEP_CHANNELS defined instead of MAX_NR_BNEP_CHANNELS. Please update your btstack_config.h to use MAX_NR_BNEP_CHANNELS."
    #else
        #define MAX_NR_BNEP_CHANNELS 0
    #endif
#endif

#ifdef MAX_NR_BNEP_CHANNELS
#if MAX_NR_BNEP_CHANNELS > 0
static bnep_channel_t bnep_channel_storage[MAX_NR_BNEP_CHANNELS];
static btstack_memory_pool_t bnep_channel_pool;
bnep_channel_t * btstack_memory_bnep_channel_get(void){
    void * buffer = btstack_memory_pool_get(&bnep_channel_pool);
    if (buffer){
        memset(buffer, 0, sizeof(bnep_channel_t));
    }
    return (bnep_channel_t *) buffer;
}
void btstack_memory_bnep_channel_free(bnep_channel_t *bnep_channel){
    btstack_memory_pool_free(&bnep_channel_pool, bnep_channel);
}
#else
bnep_channel_t * btstack_memory_bnep_channel_get(void){
    return NULL;
}
void btstack_memory_bnep_channel_free(bnep_channel_t *bnep_channel){
    UNUSED(bnep_channel);
}
#endif
#elif defined(HAVE_MALLOC)

typedef struct {
    btstack_memory_buffer_t tracking;
    bnep_channel_t data;
} btstack_memory_bnep_channel_t;

bnep_channel_t * btstack_memory_bnep_channel_get(void){
    btstack_memory_bnep_channel_t * buffer = (btstack_memory_bnep_channel_t *) malloc(sizeof(btstack_memory_bnep_channel_t));
    if (buffer){
        memset(buffer, 0, sizeof(btstack_memory_bnep_channel_t));
        btstack_memory_tracking_add(&buffer->tracking);
        return &buffer->data;
    } else {
        return NULL;
    }
}
void btstack_memory_bnep_channel_free(bnep_channel_t *bnep_channel){
    // reconstruct buffer start
    btstack_memory_buffer_t * buffer = &((btstack_memory_buffer_t *) bnep_channel)[-1];
    btstack_memory_tracking_remove(buffer);
    free(buffer);
}
#endif



// MARK: goep_server_service_t
#if !defined(HAVE_MALLOC) && !defined(MAX_NR_GOEP_SERVER_SERVICES)
    #if defined(MAX_NO_GOEP_SERVER_SERVICES)
        #error "Deprecated MAX_NO_GOEP_SERVER_SERVICES defined instead of MAX_NR_GOEP_SERVER_SERVICES. Please update your btstack_config.h to use MAX_NR_GOEP_SERVER_SERVICES."
    #else
        #define MAX_NR_GOEP_SERVER_SERVICES 0
    #endif
#endif

#ifdef MAX_NR_GOEP_SERVER_SERVICES
#if MAX_NR_GOEP_SERVER_SERVICES > 0
static goep_server_service_t goep_server_service_storage[MAX_NR_GOEP_SERVER_SERVICES];
static btstack_memory_pool_t goep_server_service_pool;
goep_server_service_t * btstack_memory_goep_server_service_get(void){
    void * buffer = btstack_memory_pool_get(&goep_server_service_pool);
    if (buffer){
        memset(buffer, 0, sizeof(goep_server_service_t));
    }
    return (goep_server_service_t *) buffer;
}
void btstack_memory_goep_server_service_free(goep_server_service_t *goep_server_service){
    btstack_memory_pool_free(&goep_server_service_pool, goep_server_service);
}
#else
goep_server_service_t * btstack_memory_goep_server_service_get(void){
    return NULL;
}
void btstack_memory_goep_server_service_free(goep_server_service_t *goep_server_service){
    UNUSED(goep_server_service);
}
#endif
#elif defined(HAVE_MALLOC)

typedef struct {
    btstack_memory_buffer_t tracking;
    goep_server_service_t data;
} btstack_memory_goep_server_service_t;

goep_server_service_t * btstack_memory_goep_server_service_get(void){
    btstack_memory_goep_server_service_t * buffer = (btstack_memory_goep_server_service_t *) malloc(sizeof(btstack_memory_goep_server_service_t));
    if (buffer){
        memset(buffer, 0, sizeof(btstack_memory_goep_server_service_t));
        btstack_memory_tracking_add(&buffer->tracking);
        return &buffer->data;
    } else {
        return NULL;
    }
}
void btstack_memory_goep_server_service_free(goep_server_service_t *goep_server_service){
    // reconstruct buffer start
    btstack_memory_buffer_t * buffer = &((btstack_memory_buffer_t *) goep_server_service)[-1];
    btstack_memory_tracking_remove(buffer);
    free(buffer);
}
#endif


// MARK: goep_server_connection_t
#if !defined(HAVE_MALLOC) && !defined(MAX_NR_GOEP_SERVER_CONNECTIONS)
    #if defined(MAX_NO_GOEP_SERVER_CONNECTIONS)
        #error "Deprecated MAX_NO_GOEP_SERVER_CONNECTIONS defined instead of MAX_NR_GOEP_SERVER_CONNECTIONS. Please update your btstack_config.h to use MAX_NR_GOEP_SERVER_CONNECTIONS."
    #else
        #define MAX_NR_GOEP_SERVER_CONNECTIONS 0
    #endif
#endif

#ifdef MAX_NR_GOEP_SERVER_CONNECTIONS
#if MAX_NR_GOEP_SERVER_CONNECTIONS > 0
static goep_server_connection_t goep_server_connection_storage[MAX_NR_GOEP_SERVER_CONNECTIONS];
static btstack_memory_pool_t goep_server_connection_pool;
goep_server_connection_t * btstack_memory_goep_server_connection_get(void){
    void * buffer = btstack_memory_pool_get(&goep_server_connection_pool);
    if (buffer){
        memset(buffer, 0, sizeof(goep_server_connection_t));
    }
    return (goep_server_connection_t *) buffer;
}
void btstack_memory_goep_server_connection_free(goep_server_connection_t *goep_server_connection){
    btstack_memory_pool_free(&goep_server_connection_pool, goep_server_connection);
}
#else
goep_server_connection_t * btstack_memory_goep_server_connection_get(void){
    return NULL;
}
void btstack_memory_goep_server_connection_free(goep_server_connection_t *goep_server_connection){
    UNUSED(goep_server_connection);
}
#endif
#elif defined(HAVE_MALLOC)

typedef struct {
    btstack_memory_buffer_t tracking;
    goep_server_connection_t data;
} btstack_memory_goep_server_connection_t;

goep_server_connection_t * btstack_memory_goep_server_connection_get(void){
    btstack_memory_goep_server_connection_t * buffer = (btstack_memory_goep_server_connection_t *) malloc(sizeof(btstack_memory_goep_server_connection_t));
    if (buffer){
        memset(buffer, 0, sizeof(btstack_memory_goep_server_connection_t));
        btstack_memory_tracking_add(&buffer->tracking);
        return &buffer->data;
    } else {
        return NULL;
    }
}
void btstack_memory_goep_server_connection_free(goep_server_connection_t *goep_server_connection){
    // reconstruct buffer start
    btstack_memory_buffer_t * buffer = &((btstack_memory_buffer_t *) goep_server_connection)[-1];
    btstack_memory_tracking_remove(buffer);
    free(buffer);
}
#endif



// MARK: hfp_connection_t
#if !defined(HAVE_MALLOC) && !defined(MAX_NR_HFP_CONNECTIONS)
    #if defined(MAX_NO_HFP_CONNECTIONS)
        #error "Deprecated MAX_NO_HFP_CONNECTIONS defined instead of MAX_NR_HFP_CONNECTIONS. Please update your btstack_config.h to use MAX_NR_HFP_CONNECTIONS."
    #else
        #define MAX_NR_HFP_CONNECTIONS 0
    #endif
#endif

#ifdef MAX_NR_HFP_CONNECTIONS
#if MAX_NR_HFP_CONNECTIONS > 0
static hfp_connection_t hfp_connection_storage[MAX_NR_HFP_CONNECTIONS];
static btstack_memory_pool_t hfp_connection_pool;
hfp_connection_t * btstack_memory_hfp_connection_get(void){
    void * buffer = btstack_memory_pool_get(&hfp_connection_pool);
    if (buffer){
        memset(buffer, 0, sizeof(hfp_connection_t));
    }
    return (hfp_connection_t *) buffer;
}
void btstack_memory_hfp_connection_free(hfp_connection_t *hfp_connection){
    btstack_memory_pool_free(&hfp_connection_pool, hfp_connection);
}
#else
hfp_connection_t * btstack_memory_hfp_connection_get(void){
    return NULL;
}
void btstack_memory_hfp_connection_free(hfp_connection_t *hfp_connection){
    UNUSED(hfp_connection);
}
#endif
#elif defined(HAVE_MALLOC)

typedef struct {
    btstack_memory_buffer_t tracking;
    hfp_connection_t data;
} btstack_memory_hfp_connection_t;

hfp_connection_t * btstack_memory_hfp_connection_get(void){
    btstack_memory_hfp_connection_t * buffer = (btstack_memory_hfp_connection_t *) malloc(sizeof(btstack_memory_hfp_connection_t));
    if (buffer){
        memset(buffer, 0, sizeof(btstack_memory_hfp_connection_t));
        btstack_memory_tracking_add(&buffer->tracking);
        return &buffer->data;
    } else {
        return NULL;
    }
}
void btstack_memory_hfp_connection_free(hfp_connection_t *hfp_connection){
    // reconstruct buffer start
    btstack_memory_buffer_t * buffer = &((btstack_memory_buffer_t *) hfp_connection)[-1];
    btstack_memory_tracking_remove(buffer);
    free(buffer);
}
#endif



// MARK: hid_host_connection_t
#if !defined(HAVE_MALLOC) && !defined(MAX_NR_HID_HOST_CONNECTIONS)
    #if defined(MAX_NO_HID_HOST_CONNECTIONS)
        #error "Deprecated MAX_NO_HID_HOST_CONNECTIONS defined instead of MAX_NR_HID_HOST_CONNECTIONS. Please update your btstack_config.h to use MAX_NR_HID_HOST_CONNECTIONS."
    #else
        #define MAX_NR_HID_HOST_CONNECTIONS 0
    #endif
#endif

#ifdef MAX_NR_HID_HOST_CONNECTIONS
#if MAX_NR_HID_HOST_CONNECTIONS > 0
static hid_host_connection_t hid_host_connection_storage[MAX_NR_HID_HOST_CONNECTIONS];
static btstack_memory_pool_t hid_host_connection_pool;
hid_host_connection_t * btstack_memory_hid_host_connection_get(void){
    void * buffer = btstack_memory_pool_get(&hid_host_connection_pool);
    if (buffer){
        memset(buffer, 0, sizeof(hid_host_connection_t));
    }
    return (hid_host_connection_t *) buffer;
}
void btstack_memory_hid_host_connection_free(hid_host_connection_t *hid_host_connection){
    btstack_memory_pool_free(&hid_host_connection_pool, hid_host_connection);
}
#else
hid_host_connection_t * btstack_memory_hid_host_connection_get(void){
    return NULL;
}
void btstack_memory_hid_host_connection_free(hid_host_connection_t *hid_host_connection){
    UNUSED(hid_host_connection);
}
#endif
#elif defined(HAVE_MALLOC)

typedef struct {
    btstack_memory_buffer_t tracking;
    hid_host_connection_t data;
} btstack_memory_hid_host_connection_t;

hid_host_connection_t * btstack_memory_hid_host_connection_get(void){
    btstack_memory_hid_host_connection_t * buffer = (btstack_memory_hid_host_connection_t *) malloc(sizeof(btstack_memory_hid_host_connection_t));
    if (buffer){
        memset(buffer, 0, sizeof(btstack_memory_hid_host_connection_t));
        btstack_memory_tracking_add(&buffer->tracking);
        return &buffer->data;
    } else {
        return NULL;
    }
}
void btstack_memory_hid_host_connection_free(hid_host_connection_t *hid_host_connection){
    // reconstruct buffer start
    btstack_memory_buffer_t * buffer = &((btstack_memory_buffer_t *) hid_host_connection)[-1];
    btstack_memory_tracking_remove(buffer);
    free(buffer);
}
#endif



// MARK: service_record_item_t
#if !defined(HAVE_MALLOC) && !defined(MAX_NR_SERVICE_RECORD_ITEMS)
    #if defined(MAX_NO_SERVICE_RECORD_ITEMS)
        #error "Deprecated MAX_NO_SERVICE_RECORD_ITEMS defined instead of MAX_NR_SERVICE_RECORD_ITEMS. Please update your btstack_config.h to use MAX_NR_SERVICE_RECORD_ITEMS."
    #else
        #define MAX_NR_SERVICE_RECORD_ITEMS 0
    #endif
#endif

#ifdef MAX_NR_SERVICE_RECORD_ITEMS
#if MAX_NR_SERVICE_RECORD_ITEMS > 0
static service_record_item_t service_record_item_storage[MAX_NR_SERVICE_RECORD_ITEMS];
static btstack_memory_pool_t service_record_item_pool;
service_record_item_t * btstack_memory_service_record_item_get(void){
    void * buffer = btstack_memory_pool_get(&service_record_item_pool);
    if (buffer){
        memset(buffer, 0, sizeof(service_record_item_t));
    }
    return (service_record_item_t *) buffer;
}
void btstack_memory_service_record_item_free(service_record_item_t *service_record_item){
    btstack_memory_pool_free(&service_record_item_pool, service_record_item);
}
#else
service_record_item_t * btstack_memory_service_record_item_get(void){
    return NULL;
}
void btstack_memory_service_record_item_free(service_record_item_t *service_record_item){
    UNUSED(service_record_item);
}
#endif
#elif defined(HAVE_MALLOC)

typedef struct {
    btstack_memory_buffer_t tracking;
    service_record_item_t data;
} btstack_memory_service_record_item_t;

service_record_item_t * btstack_memory_service_record_item_get(void){
    btstack_memory_service_record_item_t * buffer = (btstack_memory_service_record_item_t *) malloc(sizeof(btstack_memory_service_record_item_t));
    if (buffer){
        memset(buffer, 0, sizeof(btstack_memory_service_record_item_t));
        btstack_memory_tracking_add(&buffer->tracking);
        return &buffer->data;
    } else {
        return NULL;
    }
}
void btstack_memory_service_record_item_free(service_record_item_t *service_record_item){
    // reconstruct buffer start
    btstack_memory_buffer_t * buffer = &((btstack_memory_buffer_t *) service_record_item)[-1];
    btstack_memory_tracking_remove(buffer);
    free(buffer);
}
#endif



// MARK: avdtp_stream_endpoint_t
#if !defined(HAVE_MALLOC) && !defined(MAX_NR_AVDTP_STREAM_ENDPOINTS)
    #if defined(MAX_NO_AVDTP_STREAM_ENDPOINTS)
        #error "Deprecated MAX_NO_AVDTP_STREAM_ENDPOINTS defined instead of MAX_NR_AVDTP_STREAM_ENDPOINTS. Please update your btstack_config.h to use MAX_NR_AVDTP_STREAM_ENDPOINTS."
    #else
        #define MAX_NR_AVDTP_STREAM_ENDPOINTS 0
    #endif
#endif

#ifdef MAX_NR_AVDTP_STREAM_ENDPOINTS
#if MAX_NR_AVDTP_STREAM_ENDPOINTS > 0
static avdtp_stream_endpoint_t avdtp_stream_endpoint_storage[MAX_NR_AVDTP_STREAM_ENDPOINTS];
static btstack_memory_pool_t avdtp_stream_endpoint_pool;
avdtp_stream_endpoint_t * btstack_memory_avdtp_stream_endpoint_get(void){
    void * buffer = btstack_memory_pool_get(&avdtp_stream_endpoint_pool);
    if (buffer){
        memset(buffer, 0, sizeof(avdtp_stream_endpoint_t));
    }
    return (avdtp_stream_endpoint_t *) buffer;
}
void btstack_memory_avdtp_stream_endpoint_free(avdtp_stream_endpoint_t *avdtp_stream_endpoint){
    btstack_memory_pool_free(&avdtp_stream_endpoint_pool, avdtp_stream_endpoint);
}
#else
avdtp_stream_endpoint_t * btstack_memory_avdtp_stream_endpoint_get(void){
    return NULL;
}
void btstack_memory_avdtp_stream_endpoint_free(avdtp_stream_endpoint_t *avdtp_stream_endpoint){
    UNUSED(avdtp_stream_endpoint);
}
#endif
#elif defined(HAVE_MALLOC)

typedef struct {
    btstack_memory_buffer_t tracking;
    avdtp_stream_endpoint_t data;
} btstack_memory_avdtp_stream_endpoint_t;

avdtp_stream_endpoint_t * btstack_memory_avdtp_stream_endpoint_get(void){
    btstack_memory_avdtp_stream_endpoint_t * buffer = (btstack_memory_avdtp_stream_endpoint_t *) malloc(sizeof(btstack_memory_avdtp_stream_endpoint_t));
    if (buffer){
        memset(buffer, 0, sizeof(btstack_memory_avdtp_stream_endpoint_t));
        btstack_memory_tracking_add(&buffer->tracking);
        return &buffer->data;
    } else {
        return NULL;
    }
}
void btstack_memory_avdtp_stream_endpoint_free(avdtp_stream_endpoint_t *avdtp_stream_endpoint){
    // reconstruct buffer start
    btstack_memory_buffer_t * buffer = &((btstack_memory_buffer_t *) avdtp_stream_endpoint)[-1];
    btstack_memory_tracking_remove(buffer);
    free(buffer);
}
#endif



// MARK: avdtp_connection_t
#if !defined(HAVE_MALLOC) && !defined(MAX_NR_AVDTP_CONNECTIONS)
    #if defined(MAX_NO_AVDTP_CONNECTIONS)
        #error "Deprecated MAX_NO_AVDTP_CONNECTIONS defined instead of MAX_NR_AVDTP_CONNECTIONS. Please update your btstack_config.h to use MAX_NR_AVDTP_CONNECTIONS."
    #else
        #define MAX_NR_AVDTP_CONNECTIONS 0
    #endif
#endif

#ifdef MAX_NR_AVDTP_CONNECTIONS
#if MAX_NR_AVDTP_CONNECTIONS > 0
static avdtp_connection_t avdtp_connection_storage[MAX_NR_AVDTP_CONNECTIONS];
static btstack_memory_pool_t avdtp_connection_pool;
avdtp_connection_t * btstack_memory_avdtp_connection_get(void){
    void * buffer = btstack_memory_pool_get(&avdtp_connection_pool);
    if (buffer){
        memset(buffer, 0, sizeof(avdtp_connection_t));
    }
    return (avdtp_connection_t *) buffer;
}
void btstack_memory_avdtp_connection_free(avdtp_connection_t *avdtp_connection){
    btstack_memory_pool_free(&avdtp_connection_pool, avdtp_connection);
}
#else
avdtp_connection_t * btstack_memory_avdtp_connection_get(void){
    return NULL;
}
void btstack_memory_avdtp_connection_free(avdtp_connection_t *avdtp_connection){
    UNUSED(avdtp_connection);
}
#endif
#elif defined(HAVE_MALLOC)

typedef struct {
    btstack_memory_buffer_t tracking;
    avdtp_connection_t data;
} btstack_memory_avdtp_connection_t;

avdtp_connection_t * btstack_memory_avdtp_connection_get(void){
    btstack_memory_avdtp_connection_t * buffer = (btstack_memory_avdtp_connection_t *) malloc(sizeof(btstack_memory_avdtp_connection_t));
    if (buffer){
        memset(buffer, 0, sizeof(btstack_memory_avdtp_connection_t));
        btstack_memory_tracking_add(&buffer->tracking);
        return &buffer->data;
    } else {
        return NULL;
    }
}
void btstack_memory_avdtp_connection_free(avdtp_connection_t *avdtp_connection){
    // reconstruct buffer start
    btstack_memory_buffer_t * buffer = &((btstack_memory_buffer_t *) avdtp_connection)[-1];
    btstack_memory_tracking_remove(buffer);
    free(buffer);
}
#endif



// MARK: avrcp_connection_t
#if !defined(HAVE_MALLOC) && !defined(MAX_NR_AVRCP_CONNECTIONS)
    #if defined(MAX_NO_AVRCP_CONNECTIONS)
        #error "Deprecated MAX_NO_AVRCP_CONNECTIONS defined instead of MAX_NR_AVRCP_CONNECTIONS. Please update your btstack_config.h to use MAX_NR_AVRCP_CONNECTIONS."
    #else
        #define MAX_NR_AVRCP_CONNECTIONS 0
    #endif
#endif

#ifdef MAX_NR_AVRCP_CONNECTIONS
#if MAX_NR_AVRCP_CONNECTIONS > 0
static avrcp_connection_t avrcp_connection_storage[MAX_NR_AVRCP_CONNECTIONS];
static btstack_memory_pool_t avrcp_connection_pool;
avrcp_connection_t * btstack_memory_avrcp_connection_get(void){
    void * buffer = btstack_memory_pool_get(&avrcp_connection_pool);
    if (buffer){
        memset(buffer, 0, sizeof(avrcp_connection_t));
    }
    return (avrcp_connection_t *) buffer;
}
void btstack_memory_avrcp_connection_free(avrcp_connection_t *avrcp_connection){
    btstack_memory_pool_free(&avrcp_connection_pool, avrcp_connection);
}
#else
avrcp_connection_t * btstack_memory_avrcp_connection_get(void){
    return NULL;
}
void btstack_memory_avrcp_connection_free(avrcp_connection_t *avrcp_connection){
    UNUSED(avrcp_connection);
}
#endif
#elif defined(HAVE_MALLOC)

typedef struct {
    btstack_memory_buffer_t tracking;
    avrcp_connection_t data;
} btstack_memory_avrcp_connection_t;

avrcp_connection_t * btstack_memory_avrcp_connection_get(void){
    btstack_memory_avrcp_connection_t * buffer = (btstack_memory_avrcp_connection_t *) malloc(sizeof(btstack_memory_avrcp_connection_t));
    if (buffer){
        memset(buffer, 0, sizeof(btstack_memory_avrcp_connection_t));
        btstack_memory_tracking_add(&buffer->tracking);
        return &buffer->data;
    } else {
        return NULL;
    }
}
void btstack_memory_avrcp_connection_free(avrcp_connection_t *avrcp_connection){
    // reconstruct buffer start
    btstack_memory_buffer_t * buffer = &((btstack_memory_buffer_t *) avrcp_connection)[-1];
    btstack_memory_tracking_remove(buffer);
    free(buffer);
}
#endif



// MARK: avrcp_browsing_connection_t
#if !defined(HAVE_MALLOC) && !defined(MAX_NR_AVRCP_BROWSING_CONNECTIONS)
    #if defined(MAX_NO_AVRCP_BROWSING_CONNECTIONS)
        #error "Deprecated MAX_NO_AVRCP_BROWSING_CONNECTIONS defined instead of MAX_NR_AVRCP_BROWSING_CONNECTIONS. Please update your btstack_config.h to use MAX_NR_AVRCP_BROWSING_CONNECTIONS."
    #else
        #define MAX_NR_AVRCP_BROWSING_CONNECTIONS 0
    #endif
#endif

#ifdef MAX_NR_AVRCP_BROWSING_CONNECTIONS
#if MAX_NR_AVRCP_BROWSING_CONNECTIONS > 0
static avrcp_browsing_connection_t avrcp_browsing_connection_storage[MAX_NR_AVRCP_BROWSING_CONNECTIONS];
static btstack_memory_pool_t avrcp_browsing_connection_pool;
avrcp_browsing_connection_t * btstack_memory_avrcp_browsing_connection_get(void){
    void * buffer = btstack_memory_pool_get(&avrcp_browsing_connection_pool);
    if (buffer){
        memset(buffer, 0, sizeof(avrcp_browsing_connection_t));
    }
    return (avrcp_browsing_connection_t *) buffer;
}
void btstack_memory_avrcp_browsing_connection_free(avrcp_browsing_connection_t *avrcp_browsing_connection){
    btstack_memory_pool_free(&avrcp_browsing_connection_pool, avrcp_browsing_connection);
}
#else
avrcp_browsing_connection_t * btstack_memory_avrcp_browsing_connection_get(void){
    return NULL;
}
void btstack_memory_avrcp_browsing_connection_free(avrcp_browsing_connection_t *avrcp_browsing_connection){
    UNUSED(avrcp_browsing_connection);
}
#endif
#elif defined(HAVE_MALLOC)

typedef struct {
    btstack_memory_buffer_t tracking;
    avrcp_browsing_connection_t data;
} btstack_memory_avrcp_browsing_connection_t;

avrcp_browsing_connection_t * btstack_memory_avrcp_browsing_connection_get(void){
    btstack_memory_avrcp_browsing_connection_t * buffer = (btstack_memory_avrcp_browsing_connection_t *) malloc(sizeof(btstack_memory_avrcp_browsing_connection_t));
    if (buffer){
        memset(buffer, 0, sizeof(btstack_memory_avrcp_browsing_connection_t));
        btstack_memory_tracking_add(&buffer->tracking);
        return &buffer->data;
    } else {
        return NULL;
    }
}
void btstack_memory_avrcp_browsing_connection_free(avrcp_browsing_connection_t *avrcp_browsing_connection){
    // reconstruct buffer start
    btstack_memory_buffer_t * buffer = &((btstack_memory_buffer_t *) avrcp_browsing_connection)[-1];
    btstack_memory_tracking_remove(buffer);
    free(buffer);
}
#endif


#endif
#ifdef ENABLE_BLE

// MARK: battery_service_client_t
#if !defined(HAVE_MALLOC) && !defined(MAX_NR_BATTERY_SERVICE_CLIENTS)
    #if defined(MAX_NO_BATTERY_SERVICE_CLIENTS)
        #error "Deprecated MAX_NO_BATTERY_SERVICE_CLIENTS defined instead of MAX_NR_BATTERY_SERVICE_CLIENTS. Please update your btstack_config.h to use MAX_NR_BATTERY_SERVICE_CLIENTS."
    #else
        #define MAX_NR_BATTERY_SERVICE_CLIENTS 0
    #endif
#endif

#ifdef MAX_NR_BATTERY_SERVICE_CLIENTS
#if MAX_NR_BATTERY_SERVICE_CLIENTS > 0
static battery_service_client_t battery_service_client_storage[MAX_NR_BATTERY_SERVICE_CLIENTS];
static btstack_memory_pool_t battery_service_client_pool;
battery_service_client_t * btstack_memory_battery_service_client_get(void){
    void * buffer = btstack_memory_pool_get(&battery_service_client_pool);
    if (buffer){
        memset(buffer, 0, sizeof(battery_service_client_t));
    }
    return (battery_service_client_t *) buffer;
}
void btstack_memory_battery_service_client_free(battery_service_client_t *battery_service_client){
    btstack_memory_pool_free(&battery_service_client_pool, battery_service_client);
}
#else
battery_service_client_t * btstack_memory_battery_service_client_get(void){
    return NULL;
}
void btstack_memory_battery_service_client_free(battery_service_client_t *battery_service_client){
    UNUSED(battery_service_client);
}
#endif
#elif defined(HAVE_MALLOC)

typedef struct {
    btstack_memory_buffer_t tracking;
    battery_service_client_t data;
} btstack_memory_battery_service_client_t;

battery_service_client_t * btstack_memory_battery_service_client_get(void){
    btstack_memory_battery_service_client_t * buffer = (btstack_memory_battery_service_client_t *) malloc(sizeof(btstack_memory_battery_service_client_t));
    if (buffer){
        memset(buffer, 0, sizeof(btstack_memory_battery_service_client_t));
        btstack_memory_tracking_add(&buffer->tracking);
        return &buffer->data;
    } else {
        return NULL;
    }
}
void btstack_memory_battery_service_client_free(battery_service_client_t *battery_service_client){
    // reconstruct buffer start
    btstack_memory_buffer_t * buffer = &((btstack_memory_buffer_t *) battery_service_client)[-1];
    btstack_memory_tracking_remove(buffer);
    free(buffer);
}
#endif


// MARK: gatt_client_t
#if !defined(HAVE_MALLOC) && !defined(MAX_NR_GATT_CLIENTS)
    #if defined(MAX_NO_GATT_CLIENTS)
        #error "Deprecated MAX_NO_GATT_CLIENTS defined instead of MAX_NR_GATT_CLIENTS. Please update your btstack_config.h to use MAX_NR_GATT_CLIENTS."
    #else
        #define MAX_NR_GATT_CLIENTS 0
    #endif
#endif

#ifdef MAX_NR_GATT_CLIENTS
#if MAX_NR_GATT_CLIENTS > 0
static gatt_client_t gatt_client_storage[MAX_NR_GATT_CLIENTS];
static btstack_memory_pool_t gatt_client_pool;
gatt_client_t * btstack_memory_gatt_client_get(void){
    void * buffer = btstack_memory_pool_get(&gatt_client_pool);
    if (buffer){
        memset(buffer, 0, sizeof(gatt_client_t));
    }
    return (gatt_client_t *) buffer;
}
void btstack_memory_gatt_client_free(gatt_client_t *gatt_client){
    btstack_memory_pool_free(&gatt_client_pool, gatt_client);
}
#else
gatt_client_t * btstack_memory_gatt_client_get(void){
    return NULL;
}
void btstack_memory_gatt_client_free(gatt_client_t *gatt_client){
    UNUSED(gatt_client);
}
#endif
#elif defined(HAVE_MALLOC)

typedef struct {
    btstack_memory_buffer_t tracking;
    gatt_client_t data;
} btstack_memory_gatt_client_t;

gatt_client_t * btstack_memory_gatt_client_get(void){
    btstack_memory_gatt_client_t * buffer = (btstack_memory_gatt_client_t *) malloc(sizeof(btstack_memory_gatt_client_t));
    if (buffer){
        memset(buffer, 0, sizeof(btstack_memory_gatt_client_t));
        btstack_memory_tracking_add(&buffer->tracking);
        return &buffer->data;
    } else {
        return NULL;
    }
}
void btstack_memory_gatt_client_free(gatt_client_t *gatt_client){
    // reconstruct buffer start
    btstack_memory_buffer_t * buffer = &((btstack_memory_buffer_t *) gatt_client)[-1];
    btstack_memory_tracking_remove(buffer);
    free(buffer);
}
#endif


// MARK: hids_client_t
#if !defined(HAVE_MALLOC) && !defined(MAX_NR_HIDS_CLIENTS)
    #if defined(MAX_NO_HIDS_CLIENTS)
        #error "Deprecated MAX_NO_HIDS_CLIENTS defined instead of MAX_NR_HIDS_CLIENTS. Please update your btstack_config.h to use MAX_NR_HIDS_CLIENTS."
    #else
        #define MAX_NR_HIDS_CLIENTS 0
    #endif
#endif

#ifdef MAX_NR_HIDS_CLIENTS
#if MAX_NR_HIDS_CLIENTS > 0
static hids_client_t hids_client_storage[MAX_NR_HIDS_CLIENTS];
static btstack_memory_pool_t hids_client_pool;
hids_client_t * btstack_memory_hids_client_get(void){
    void * buffer = btstack_memory_pool_get(&hids_client_pool);
    if (buffer){
        memset(buffer, 0, sizeof(hids_client_t));
    }
    return (hids_client_t *) buffer;
}
void btstack_memory_hids_client_free(hids_client_t *hids_client){
    btstack_memory_pool_free(&hids_client_pool, hids_client);
}
#else
hids_client_t * btstack_memory_hids_client_get(void){
    return NULL;
}
void btstack_memory_hids_client_free(hids_client_t *hids_client){
    UNUSED(hids_client);
}
#endif
#elif defined(HAVE_MALLOC)

typedef struct {
    btstack_memory_buffer_t tracking;
    hids_client_t data;
} btstack_memory_hids_client_t;

hids_client_t * btstack_memory_hids_client_get(void){
    btstack_memory_hids_client_t * buffer = (btstack_memory_hids_client_t *) malloc(sizeof(btstack_memory_hids_client_t));
    if (buffer){
        memset(buffer, 0, sizeof(btstack_memory_hids_client_t));
        btstack_memory_tracking_add(&buffer->tracking);
        return &buffer->data;
    } else {
        return NULL;
    }
}
void btstack_memory_hids_client_free(hids_client_t *hids_client){
    // reconstruct buffer start
    btstack_memory_buffer_t * buffer = &((btstack_memory_buffer_t *) hids_client)[-1];
    btstack_memory_tracking_remove(buffer);
    free(buffer);
}
#endif


// MARK: scan_parameters_service_client_t
#if !defined(HAVE_MALLOC) && !defined(MAX_NR_SCAN_PARAMETERS_SERVICE_CLIENTS)
    #if defined(MAX_NO_SCAN_PARAMETERS_SERVICE_CLIENTS)
        #error "Deprecated MAX_NO_SCAN_PARAMETERS_SERVICE_CLIENTS defined instead of MAX_NR_SCAN_PARAMETERS_SERVICE_CLIENTS. Please update your btstack_config.h to use MAX_NR_SCAN_PARAMETERS_SERVICE_CLIENTS."
    #else
        #define MAX_NR_SCAN_PARAMETERS_SERVICE_CLIENTS 0
    #endif
#endif

#ifdef MAX_NR_SCAN_PARAMETERS_SERVICE_CLIENTS
#if MAX_NR_SCAN_PARAMETERS_SERVICE_CLIENTS > 0
static scan_parameters_service_client_t scan_parameters_service_client_storage[MAX_NR_SCAN_PARAMETERS_SERVICE_CLIENTS];
static btstack_memory_pool_t scan_parameters_service_client_pool;
scan_parameters_service_client_t * btstack_memory_scan_parameters_service_client_get(void){
    void * buffer = btstack_memory_pool_get(&scan_parameters_service_client_pool);
    if (buffer){
        memset(buffer, 0, sizeof(scan_parameters_service_client_t));
    }
    return (scan_parameters_service_client_t *) buffer;
}
void btstack_memory_scan_parameters_service_client_free(scan_parameters_service_client_t *scan_parameters_service_client){
    btstack_memory_pool_free(&scan_parameters_service_client_pool, scan_parameters_service_client);
}
#else
scan_parameters_service_client_t * btstack_memory_scan_parameters_service_client_get(void){
    return NULL;
}
void btstack_memory_scan_parameters_service_client_free(scan_parameters_service_client_t *scan_parameters_service_client){
    UNUSED(scan_parameters_service_client);
}
#endif
#elif defined(HAVE_MALLOC)

typedef struct {
    btstack_memory_buffer_t tracking;
    scan_parameters_service_client_t data;
} btstack_memory_scan_parameters_service_client_t;

scan_parameters_service_client_t * btstack_memory_scan_parameters_service_client_get(void){
    btstack_memory_scan_parameters_service_client_t * buffer = (btstack_memory_scan_parameters_service_client_t *) malloc(sizeof(btstack_memory_scan_parameters_service_client_t));
    if (buffer){
        memset(buffer, 0, sizeof(btstack_memory_scan_parameters_service_client_t));
        btstack_memory_tracking_add(&buffer->tracking);
        return &buffer->data;
    } else {
        return NULL;
    }
}
void btstack_memory_scan_parameters_service_client_free(scan_parameters_service_client_t *scan_parameters_service_client){
    // reconstruct buffer start
    btstack_memory_buffer_t * buffer = &((btstack_memory_buffer_t *) scan_parameters_service_client)[-1];
    btstack_memory_tracking_remove(buffer);
    free(buffer);
}
#endif


// MARK: sm_lookup_entry_t
#if !defined(HAVE_MALLOC) && !defined(MAX_NR_SM_LOOKUP_ENTRIES)
    #if defined(MAX_NO_SM_LOOKUP_ENTRIES)
        #error "Deprecated MAX_NO_SM_LOOKUP_ENTRIES defined instead of MAX_NR_SM_LOOKUP_ENTRIES. Please update your btstack_config.h to use MAX_NR_SM_LOOKUP_ENTRIES."
    #else
        #define MAX_NR_SM_LOOKUP_ENTRIES 0
    #endif
#endif

#ifdef MAX_NR_SM_LOOKUP_ENTRIES
#if MAX_NR_SM_LOOKUP_ENTRIES > 0
static sm_lookup_entry_t sm_lookup_entry_storage[MAX_NR_SM_LOOKUP_ENTRIES];
static btstack_memory_pool_t sm_lookup_entry_pool;
sm_lookup_entry_t * btstack_memory_sm_lookup_entry_get(void){
    void * buffer = btstack_memory_pool_get(&sm_lookup_entry_pool);
    if (buffer){
        memset(buffer, 0, sizeof(sm_lookup_entry_t));
    }
    return (sm_lookup_entry_t *) buffer;
}
void btstack_memory_sm_lookup_entry_free(sm_lookup_entry_t *sm_lookup_entry){
    btstack_memory_pool_free(&sm_lookup_entry_pool, sm_lookup_entry);
}
#else
sm_lookup_entry_t * btstack_memory_sm_lookup_entry_get(void){
    return NULL;
}
void btstack_memory_sm_lookup_entry_free(sm_lookup_entry_t *sm_lookup_entry){
    UNUSED(sm_lookup_entry);
}
#endif
#elif defined(HAVE_MALLOC)

typedef struct {
    btstack_memory_buffer_t tracking;
    sm_lookup_entry_t data;
} btstack_memory_sm_lookup_entry_t;

sm_lookup_entry_t * btstack_memory_sm_lookup_entry_get(void){
    btstack_memory_sm_lookup_entry_t * buffer = (btstack_memory_sm_lookup_entry_t *) malloc(sizeof(btstack_memory_sm_lookup_entry_t));
    if (buffer){
        memset(buffer, 0, sizeof(btstack_memory_sm_lookup_entry_t));
        btstack_memory_tracking_add(&buffer->tracking);
        return &buffer->data;
    } else {
        return NULL;
    }
}
void btstack_memory_sm_lookup_entry_free(sm_lookup_entry_t *sm_lookup_entry){
    // reconstruct buffer start
    btstack_memory_buffer_t * buffer = &((btstack_memory_buffer_t *) sm_lookup_entry)[-1];
    btstack_memory_tracking_remove(buffer);
    free(buffer);
}
#endif


// MARK: whitelist_entry_t
#if !defined(HAVE_MALLOC) && !defined(MAX_NR_WHITELIST_ENTRIES)
    #if defined(MAX_NO_WHITELIST_ENTRIES)
        #error "Deprecated MAX_NO_WHITELIST_ENTRIES defined instead of MAX_NR_WHITELIST_ENTRIES. Please update your btstack_config.h to use MAX_NR_WHITELIST_ENTRIES."
    #else
        #define MAX_NR_WHITELIST_ENTRIES 0
    #endif
#endif

#ifdef MAX_NR_WHITELIST_ENTRIES
#if MAX_NR_WHITELIST_ENTRIES > 0
static whitelist_entry_t whitelist_entry_storage[MAX_NR_WHITELIST_ENTRIES];
static btstack_memory_pool_t whitelist_entry_pool;
whitelist_entry_t * btstack_memory_whitelist_entry_get(void){
    void * buffer = btstack_memory_pool_get(&whitelist_entry_pool);
    if (buffer){
        memset(buffer, 0, sizeof(whitelist_entry_t));
    }
    return (whitelist_entry_t *) buffer;
}
void btstack_memory_whitelist_entry_free(whitelist_entry_t *whitelist_entry){
    btstack_memory_pool_free(&whitelist_entry_pool, whitelist_entry);
}
#else
whitelist_entry_t * btstack_memory_whitelist_entry_get(void){
    return NULL;
}
void btstack_memory_whitelist_entry_free(whitelist_entry_t *whitelist_entry){
    UNUSED(whitelist_entry);
}
#endif
#elif defined(HAVE_MALLOC)

typedef struct {
    btstack_memory_buffer_t tracking;
    whitelist_entry_t data;
} btstack_memory_whitelist_entry_t;

whitelist_entry_t * btstack_memory_whitelist_entry_get(void){
    btstack_memory_whitelist_entry_t * buffer = (btstack_memory_whitelist_entry_t *) malloc(sizeof(btstack_memory_whitelist_entry_t));
    if (buffer){
        memset(buffer, 0, sizeof(btstack_memory_whitelist_entry_t));
        btstack_memory_tracking_add(&buffer->tracking);
        return &buffer->data;
    } else {
        return NULL;
    }
}
void btstack_memory_whitelist_entry_free(whitelist_entry_t *whitelist_entry){
    // reconstruct buffer start
    btstack_memory_buffer_t * buffer = &((btstack_memory_buffer_t *) whitelist_entry)[-1];
    btstack_memory_tracking_remove(buffer);
    free(buffer);
}
#endif


// MARK: periodic_advertiser_list_entry_t
#if !defined(HAVE_MALLOC) && !defined(MAX_NR_PERIODIC_ADVERTISER_LIST_ENTRIES)
    #if defined(MAX_NO_PERIODIC_ADVERTISER_LIST_ENTRIES)
        #error "Deprecated MAX_NO_PERIODIC_ADVERTISER_LIST_ENTRIES defined instead of MAX_NR_PERIODIC_ADVERTISER_LIST_ENTRIES. Please update your btstack_config.h to use MAX_NR_PERIODIC_ADVERTISER_LIST_ENTRIES."
    #else
        #define MAX_NR_PERIODIC_ADVERTISER_LIST_ENTRIES 0
    #endif
#endif

#ifdef MAX_NR_PERIODIC_ADVERTISER_LIST_ENTRIES
#if MAX_NR_PERIODIC_ADVERTISER_LIST_ENTRIES > 0
static periodic_advertiser_list_entry_t periodic_advertiser_list_entry_storage[MAX_NR_PERIODIC_ADVERTISER_LIST_ENTRIES];
static btstack_memory_pool_t periodic_advertiser_list_entry_pool;
periodic_advertiser_list_entry_t * btstack_memory_periodic_advertiser_list_entry_get(void){
    void * buffer = btstack_memory_pool_get(&periodic_advertiser_list_entry_pool);
    if (buffer){
        memset(buffer, 0, sizeof(periodic_advertiser_list_entry_t));
    }
    return (periodic_advertiser_list_entry_t *) buffer;
}
void btstack_memory_periodic_advertiser_list_entry_free(periodic_advertiser_list_entry_t *periodic_advertiser_list_entry){
    btstack_memory_pool_free(&periodic_advertiser_list_entry_pool, periodic_advertiser_list_entry);
}
#else
periodic_advertiser_list_entry_t * btstack_memory_periodic_advertiser_list_entry_get(void){
    return NULL;
}
void btstack_memory_periodic_advertiser_list_entry_free(periodic_advertiser_list_entry_t *periodic_advertiser_list_entry){
    UNUSED(periodic_advertiser_list_entry);
}
#endif
#elif defined(HAVE_MALLOC)

typedef struct {
    btstack_memory_buffer_t tracking;
    periodic_advertiser_list_entry_t data;
} btstack_memory_periodic_advertiser_list_entry_t;

periodic_advertiser_list_entry_t * btstack_memory_periodic_advertiser_list_entry_get(void){
    btstack_memory_periodic_advertiser_list_entry_t * buffer = (btstack_memory_periodic_advertiser_list_entry_t *) malloc(sizeof(btstack_memory_periodic_advertiser_list_entry_t));
    if (buffer){
        memset(buffer, 0, sizeof(btstack_memory_periodic_advertiser_list_entry_t));
        btstack_memory_tracking_add(&buffer->tracking);
        return &buffer->data;
    } else {
        return NULL;
    }
}
void btstack_memory_periodic_advertiser_list_entry_free(periodic_advertiser_list_entry_t *periodic_advertiser_list_entry){
    // reconstruct buffer start
    btstack_memory_buffer_t * buffer = &((btstack_memory_buffer_t *) periodic_advertiser_list_entry)[-1];
    btstack_memory_tracking_remove(buffer);
    free(buffer);
}
#endif


#endif
#ifdef ENABLE_MESH

// MARK: mesh_network_pdu_t
#if !defined(HAVE_MALLOC) && !defined(MAX_NR_MESH_NETWORK_PDUS)
    #if defined(MAX_NO_MESH_NETWORK_PDUS)
        #error "Deprecated MAX_NO_MESH_NETWORK_PDUS defined instead of MAX_NR_MESH_NETWORK_PDUS. Please update your btstack_config.h to use MAX_NR_MESH_NETWORK_PDUS."
    #else
        #define MAX_NR_MESH_NETWORK_PDUS 0
    #endif
#endif

#ifdef MAX_NR_MESH_NETWORK_PDUS
#if MAX_NR_MESH_NETWORK_PDUS > 0
static mesh_network_pdu_t mesh_network_pdu_storage[MAX_NR_MESH_NETWORK_PDUS];
static btstack_memory_pool_t mesh_network_pdu_pool;
mesh_network_pdu_t * btstack_memory_mesh_network_pdu_get(void){
    void * buffer = btstack_memory_pool_get(&mesh_network_pdu_pool);
    if (buffer){
        memset(buffer, 0, sizeof(mesh_network_pdu_t));
    }
    return (mesh_network_pdu_t *) buffer;
}
void btstack_memory_mesh_network_pdu_free(mesh_network_pdu_t *mesh_network_pdu){
    btstack_memory_pool_free(&mesh_network_pdu_pool, mesh_network_pdu);
}
#else
mesh_network_pdu_t * btstack_memory_mesh_network_pdu_get(void){
    return NULL;
}
void btstack_memory_mesh_network_pdu_free(mesh_network_pdu_t *mesh_network_pdu){
    UNUSED(mesh_network_pdu);
}
#endif
#elif defined(HAVE_MALLOC)

typedef struct {
    btstack_memory_buffer_t tracking;
    mesh_network_pdu_t data;
} btstack_memory_mesh_network_pdu_t;

mesh_network_pdu_t * btstack_memory_mesh_network_pdu_get(void){
    btstack_memory_mesh_network_pdu_t * buffer = (btstack_memory_mesh_network_pdu_t *) malloc(sizeof(btstack_memory_mesh_network_pdu_t));
    if (buffer){
        memset(buffer, 0, sizeof(btstack_memory_mesh_network_pdu_t));
        btstack_memory_tracking_add(&buffer->tracking);
        return &buffer->data;
    } else {
        return NULL;
    }
}
void btstack_memory_mesh_network_pdu_free(mesh_network_pdu_t *mesh_network_pdu){
    // reconstruct buffer start
    btstack_memory_buffer_t * buffer = &((btstack_memory_buffer_t *) mesh_network_pdu)[-1];
    btstack_memory_tracking_remove(buffer);
    free(buffer);
}
#endif


// MARK: mesh_segmented_pdu_t
#if !defined(HAVE_MALLOC) && !defined(MAX_NR_MESH_SEGMENTED_PDUS)
    #if defined(MAX_NO_MESH_SEGMENTED_PDUS)
        #error "Deprecated MAX_NO_MESH_SEGMENTED_PDUS defined instead of MAX_NR_MESH_SEGMENTED_PDUS. Please update your btstack_config.h to use MAX_NR_MESH_SEGMENTED_PDUS."
    #else
        #define MAX_NR_MESH_SEGMENTED_PDUS 0
    #endif
#endif

#ifdef MAX_NR_MESH_SEGMENTED_PDUS
#if MAX_NR_MESH_SEGMENTED_PDUS > 0
static mesh_segmented_pdu_t mesh_segmented_pdu_storage[MAX_NR_MESH_SEGMENTED_PDUS];
static btstack_memory_pool_t mesh_segmented_pdu_pool;
mesh_segmented_pdu_t * btstack_memory_mesh_segmented_pdu_get(void){
    void * buffer = btstack_memory_pool_get(&mesh_segmented_pdu_pool);
    if (buffer){
        memset(buffer, 0, sizeof(mesh_segmented_pdu_t));
    }
    return (mesh_segmented_pdu_t *) buffer;
}
void btstack_memory_mesh_segmented_pdu_free(mesh_segmented_pdu_t *mesh_segmented_pdu){
    btstack_memory_pool_free(&mesh_segmented_pdu_pool, mesh_segmented_pdu);
}
#else
mesh_segmented_pdu_t * btstack_memory_mesh_segmented_pdu_get(void){
    return NULL;
}
void btstack_memory_mesh_segmented_pdu_free(mesh_segmented_pdu_t *mesh_segmented_pdu){
    UNUSED(mesh_segmented_pdu);
}
#endif
#elif defined(HAVE_MALLOC)

typedef struct {
    btstack_memory_buffer_t tracking;
    mesh_segmented_pdu_t data;
} btstack_memory_mesh_segmented_pdu_t;

mesh_segmented_pdu_t * btstack_memory_mesh_segmented_pdu_get(void){
    btstack_memory_mesh_segmented_pdu_t * buffer = (btstack_memory_mesh_segmented_pdu_t *) malloc(sizeof(btstack_memory_mesh_segmented_pdu_t));
    if (buffer){
        memset(buffer, 0, sizeof(btstack_memory_mesh_segmented_pdu_t));
        btstack_memory_tracking_add(&buffer->tracking);
        return &buffer->data;
    } else {
        return NULL;
    }
}
void btstack_memory_mesh_segmented_pdu_free(mesh_segmented_pdu_t *mesh_segmented_pdu){
    // reconstruct buffer start
    btstack_memory_buffer_t * buffer = &((btstack_memory_buffer_t *) mesh_segmented_pdu)[-1];
    btstack_memory_tracking_remove(buffer);
    free(buffer);
}
#endif


// MARK: mesh_upper_transport_pdu_t
#if !defined(HAVE_MALLOC) && !defined(MAX_NR_MESH_UPPER_TRANSPORT_PDUS)
    #if defined(MAX_NO_MESH_UPPER_TRANSPORT_PDUS)
        #error "Deprecated MAX_NO_MESH_UPPER_TRANSPORT_PDUS defined instead of MAX_NR_MESH_UPPER_TRANSPORT_PDUS. Please update your btstack_config.h to use MAX_NR_MESH_UPPER_TRANSPORT_PDUS."
    #else
        #define MAX_NR_MESH_UPPER_TRANSPORT_PDUS 0
    #endif
#endif

#ifdef MAX_NR_MESH_UPPER_TRANSPORT_PDUS
#if MAX_NR_MESH_UPPER_TRANSPORT_PDUS > 0
static mesh_upper_transport_pdu_t mesh_upper_transport_pdu_storage[MAX_NR_MESH_UPPER_TRANSPORT_PDUS];
static btstack_memory_pool_t mesh_upper_transport_pdu_pool;
mesh_upper_transport_pdu_t * btstack_memory_mesh_upper_transport_pdu_get(void){
    void * buffer = btstack_memory_pool_get(&mesh_upper_transport_pdu_pool);
    if (buffer){
        memset(buffer, 0, sizeof(mesh_upper_transport_pdu_t));
    }
    return (mesh_upper_transport_pdu_t *) buffer;
}
void btstack_memory_mesh_upper_transport_pdu_free(mesh_upper_transport_pdu_t *mesh_upper_transport_pdu){
    btstack_memory_pool_free(&mesh_upper_transport_pdu_pool, mesh_upper_transport_pdu);
}
#else
mesh_upper_transport_pdu_t * btstack_memory_mesh_upper_transport_pdu_get(void){
    return NULL;
}
void btstack_memory_mesh_upper_transport_pdu_free(mesh_upper_transport_pdu_t *mesh_upper_transport_pdu){
    UNUSED(mesh_upper_transport_pdu);
}
#endif
#elif defined(HAVE_MALLOC)

typedef struct {
    btstack_memory_buffer_t tracking;
    mesh_upper_transport_pdu_t data;
} btstack_memory_mesh_upper_transport_pdu_t;

mesh_upper_transport_pdu_t * btstack_memory_mesh_upper_transport_pdu_get(void){
    btstack_memory_mesh_upper_transport_pdu_t * buffer = (btstack_memory_mesh_upper_transport_pdu_t *) malloc(sizeof(btstack_memory_mesh_upper_transport_pdu_t));
    if (buffer){
        memset(buffer, 0, sizeof(btstack_memory_mesh_upper_transport_pdu_t));
        btstack_memory_tracking_add(&buffer->tracking);
        return &buffer->data;
    } else {
        return NULL;
    }
}
void btstack_memory_mesh_upper_transport_pdu_free(mesh_upper_transport_pdu_t *mesh_upper_transport_pdu){
    // reconstruct buffer start
    btstack_memory_buffer_t * buffer = &((btstack_memory_buffer_t *) mesh_upper_transport_pdu)[-1];
    btstack_memory_tracking_remove(buffer);
    free(buffer);
}
#endif


// MARK: mesh_network_key_t
#if !defined(HAVE_MALLOC) && !defined(MAX_NR_MESH_NETWORK_KEYS)
    #if defined(MAX_NO_MESH_NETWORK_KEYS)
        #error "Deprecated MAX_NO_MESH_NETWORK_KEYS defined instead of MAX_NR_MESH_NETWORK_KEYS. Please update your btstack_config.h to use MAX_NR_MESH_NETWORK_KEYS."
    #else
        #define MAX_NR_MESH_NETWORK_KEYS 0
    #endif
#endif

#ifdef MAX_NR_MESH_NETWORK_KEYS
#if MAX_NR_MESH_NETWORK_KEYS > 0
static mesh_network_key_t mesh_network_key_storage[MAX_NR_MESH_NETWORK_KEYS];
static btstack_memory_pool_t mesh_network_key_pool;
mesh_network_key_t * btstack_memory_mesh_network_key_get(void){
    void * buffer = btstack_memory_pool_get(&mesh_network_key_pool);
    if (buffer){
        memset(buffer, 0, sizeof(mesh_network_key_t));
    }
    return (mesh_network_key_t *) buffer;
}
void btstack_memory_mesh_network_key_free(mesh_network_key_t *mesh_network_key){
    btstack_memory_pool_free(&mesh_network_key_pool, mesh_network_key);
}
#else
mesh_network_key_t * btstack_memory_mesh_network_key_get(void){
    return NULL;
}
void btstack_memory_mesh_network_key_free(mesh_network_key_t *mesh_network_key){
    UNUSED(mesh_network_key);
}
#endif
#elif defined(HAVE_MALLOC)

typedef struct {
    btstack_memory_buffer_t tracking;
    mesh_network_key_t data;
} btstack_memory_mesh_network_key_t;

mesh_network_key_t * btstack_memory_mesh_network_key_get(void){
    btstack_memory_mesh_network_key_t * buffer = (btstack_memory_mesh_network_key_t *) malloc(sizeof(btstack_memory_mesh_network_key_t));
    if (buffer){
        memset(buffer, 0, sizeof(btstack_memory_mesh_network_key_t));
        btstack_memory_tracking_add(&buffer->tracking);
        return &buffer->data;
    } else {
        return NULL;
    }
}
void btstack_memory_mesh_network_key_free(mesh_network_key_t *mesh_network_key){
    // reconstruct buffer start
    btstack_memory_buffer_t * buffer = &((btstack_memory_buffer_t *) mesh_network_key)[-1];
    btstack_memory_tracking_remove(buffer);
    free(buffer);
}
#endif


// MARK: mesh_transport_key_t
#if !defined(HAVE_MALLOC) && !defined(MAX_NR_MESH_TRANSPORT_KEYS)
    #if defined(MAX_NO_MESH_TRANSPORT_KEYS)
        #error "Deprecated MAX_NO_MESH_TRANSPORT_KEYS defined instead of MAX_NR_MESH_TRANSPORT_KEYS. Please update your btstack_config.h to use MAX_NR_MESH_TRANSPORT_KEYS."
    #else
        #define MAX_NR_MESH_TRANSPORT_KEYS 0
    #endif
#endif

#ifdef MAX_NR_MESH_TRANSPORT_KEYS
#if MAX_NR_MESH_TRANSPORT_KEYS > 0
static mesh_transport_key_t mesh_transport_key_storage[MAX_NR_MESH_TRANSPORT_KEYS];
static btstack_memory_pool_t mesh_transport_key_pool;
mesh_transport_key_t * btstack_memory_mesh_transport_key_get(void){
    void * buffer = btstack_memory_pool_get(&mesh_transport_key_pool);
    if (buffer){
        memset(buffer, 0, sizeof(mesh_transport_key_t));
    }
    return (mesh_transport_key_t *) buffer;
}
void btstack_memory_mesh_transport_key_free(mesh_transport_key_t *mesh_transport_key){
    btstack_memory_pool_free(&mesh_transport_key_pool, mesh_transport_key);
}
#else
mesh_transport_key_t * btstack_memory_mesh_transport_key_get(void){
    return NULL;
}
void btstack_memory_mesh_transport_key_free(mesh_transport_key_t *mesh_transport_key){
    UNUSED(mesh_transport_key);
}
#endif
#elif defined(HAVE_MALLOC)

typedef struct {
    btstack_memory_buffer_t tracking;
    mesh_transport_key_t data;
} btstack_memory_mesh_transport_key_t;

mesh_transport_key_t * btstack_memory_mesh_transport_key_get(void){
    btstack_memory_mesh_transport_key_t * buffer = (btstack_memory_mesh_transport_key_t *) malloc(sizeof(btstack_memory_mesh_transport_key_t));
    if (buffer){
        memset(buffer, 0, sizeof(btstack_memory_mesh_transport_key_t));
        btstack_memory_tracking_add(&buffer->tracking);
        return &buffer->data;
    } else {
        return NULL;
    }
}
void btstack_memory_mesh_transport_key_free(mesh_transport_key_t *mesh_transport_key){
    // reconstruct buffer start
    btstack_memory_buffer_t * buffer = &((btstack_memory_buffer_t *) mesh_transport_key)[-1];
    btstack_memory_tracking_remove(buffer);
    free(buffer);
}
#endif


// MARK: mesh_virtual_address_t
#if !defined(HAVE_MALLOC) && !defined(MAX_NR_MESH_VIRTUAL_ADDRESSS)
    #if defined(MAX_NO_MESH_VIRTUAL_ADDRESSS)
        #error "Deprecated MAX_NO_MESH_VIRTUAL_ADDRESSS defined instead of MAX_NR_MESH_VIRTUAL_ADDRESSS. Please update your btstack_config.h to use MAX_NR_MESH_VIRTUAL_ADDRESSS."
    #else
        #define MAX_NR_MESH_VIRTUAL_ADDRESSS 0
    #endif
#endif

#ifdef MAX_NR_MESH_VIRTUAL_ADDRESSS
#if MAX_NR_MESH_VIRTUAL_ADDRESSS > 0
static mesh_virtual_address_t mesh_virtual_address_storage[MAX_NR_MESH_VIRTUAL_ADDRESSS];
static btstack_memory_pool_t mesh_virtual_address_pool;
mesh_virtual_address_t * btstack_memory_mesh_virtual_address_get(void){
    void * buffer = btstack_memory_pool_get(&mesh_virtual_address_pool);
    if (buffer){
        memset(buffer, 0, sizeof(mesh_virtual_address_t));
    }
    return (mesh_virtual_address_t *) buffer;
}
void btstack_memory_mesh_virtual_address_free(mesh_virtual_address_t *mesh_virtual_address){
    btstack_memory_pool_free(&mesh_virtual_address_pool, mesh_virtual_address);
}
#else
mesh_virtual_address_t * btstack_memory_mesh_virtual_address_get(void){
    return NULL;
}
void btstack_memory_mesh_virtual_address_free(mesh_virtual_address_t *mesh_virtual_address){
    UNUSED(mesh_virtual_address);
}
#endif
#elif defined(HAVE_MALLOC)

typedef struct {
    btstack_memory_buffer_t tracking;
    mesh_virtual_address_t data;
} btstack_memory_mesh_virtual_address_t;

mesh_virtual_address_t * btstack_memory_mesh_virtual_address_get(void){
    btstack_memory_mesh_virtual_address_t * buffer = (btstack_memory_mesh_virtual_address_t *) malloc(sizeof(btstack_memory_mesh_virtual_address_t));
    if (buffer){
        memset(buffer, 0, sizeof(btstack_memory_mesh_virtual_address_t));
        btstack_memory_tracking_add(&buffer->tracking);
        return &buffer->data;
    } else {
        return NULL;
    }
}
void btstack_memory_mesh_virtual_address_free(mesh_virtual_address_t *mesh_virtual_address){
    // reconstruct buffer start
    btstack_memory_buffer_t * buffer = &((btstack_memory_buffer_t *) mesh_virtual_address)[-1];
    btstack_memory_tracking_remove(buffer);
    free(buffer);
}
#endif


// MARK: mesh_subnet_t
#if !defined(HAVE_MALLOC) && !defined(MAX_NR_MESH_SUBNETS)
    #if defined(MAX_NO_MESH_SUBNETS)
        #error "Deprecated MAX_NO_MESH_SUBNETS defined instead of MAX_NR_MESH_SUBNETS. Please update your btstack_config.h to use MAX_NR_MESH_SUBNETS."
    #else
        #define MAX_NR_MESH_SUBNETS 0
    #endif
#endif

#ifdef MAX_NR_MESH_SUBNETS
#if MAX_NR_MESH_SUBNETS > 0
static mesh_subnet_t mesh_subnet_storage[MAX_NR_MESH_SUBNETS];
static btstack_memory_pool_t mesh_subnet_pool;
mesh_subnet_t * btstack_memory_mesh_subnet_get(void){
    void * buffer = btstack_memory_pool_get(&mesh_subnet_pool);
    if (buffer){
        memset(buffer, 0, sizeof(mesh_subnet_t));
    }
    return (mesh_subnet_t *) buffer;
}
void btstack_memory_mesh_subnet_free(mesh_subnet_t *mesh_subnet){
    btstack_memory_pool_free(&mesh_subnet_pool, mesh_subnet);
}
#else
mesh_subnet_t * btstack_memory_mesh_subnet_get(void){
    return NULL;
}
void btstack_memory_mesh_subnet_free(mesh_subnet_t *mesh_subnet){
    UNUSED(mesh_subnet);
}
#endif
#elif defined(HAVE_MALLOC)

typedef struct {
    btstack_memory_buffer_t tracking;
    mesh_subnet_t data;
} btstack_memory_mesh_subnet_t;

mesh_subnet_t * btstack_memory_mesh_subnet_get(void){
    btstack_memory_mesh_subnet_t * buffer = (btstack_memory_mesh_subnet_t *) malloc(sizeof(btstack_memory_mesh_subnet_t));
    if (buffer){
        memset(buffer, 0, sizeof(btstack_memory_mesh_subnet_t));
        btstack_memory_tracking_add(&buffer->tracking);
        return &buffer->data;
    } else {
        return NULL;
    }
}
void btstack_memory_mesh_subnet_free(mesh_subnet_t *mesh_subnet){
    // reconstruct buffer start
    btstack_memory_buffer_t * buffer = &((btstack_memory_buffer_t *) mesh_subnet)[-1];
    btstack_memory_tracking_remove(buffer);
    free(buffer);
}
#endif


#endif
#ifdef ENABLE_LE_ISOCHRONOUS_STREAMS

// MARK: hci_iso_stream_t
#if !defined(HAVE_MALLOC) && !defined(MAX_NR_HCI_ISO_STREAMS)
    #if defined(MAX_NO_HCI_ISO_STREAMS)
        #error "Deprecated MAX_NO_HCI_ISO_STREAMS defined instead of MAX_NR_HCI_ISO_STREAMS. Please update your btstack_config.h to use MAX_NR_HCI_ISO_STREAMS."
    #else
        #define MAX_NR_HCI_ISO_STREAMS 0
    #endif
#endif

#ifdef MAX_NR_HCI_ISO_STREAMS
#if MAX_NR_HCI_ISO_STREAMS > 0
static hci_iso_stream_t hci_iso_stream_storage[MAX_NR_HCI_ISO_STREAMS];
static btstack_memory_pool_t hci_iso_stream_pool;
hci_iso_stream_t * btstack_memory_hci_iso_stream_get(void){
    void * buffer = btstack_memory_pool_get(&hci_iso_stream_pool);
    if (buffer){
        memset(buffer, 0, sizeof(hci_iso_stream_t));
    }
    return (hci_iso_stream_t *) buffer;
}
void btstack_memory_hci_iso_stream_free(hci_iso_stream_t *hci_iso_stream){
    btstack_memory_pool_free(&hci_iso_stream_pool, hci_iso_stream);
}
#else
hci_iso_stream_t * btstack_memory_hci_iso_stream_get(void){
    return NULL;
}
void btstack_memory_hci_iso_stream_free(hci_iso_stream_t *hci_iso_stream){
    UNUSED(hci_iso_stream);
}
#endif
#elif defined(HAVE_MALLOC)

typedef struct {
    btstack_memory_buffer_t tracking;
    hci_iso_stream_t data;
} btstack_memory_hci_iso_stream_t;

hci_iso_stream_t * btstack_memory_hci_iso_stream_get(void){
    btstack_memory_hci_iso_stream_t * buffer = (btstack_memory_hci_iso_stream_t *) malloc(sizeof(btstack_memory_hci_iso_stream_t));
    if (buffer){
        memset(buffer, 0, sizeof(btstack_memory_hci_iso_stream_t));
        btstack_memory_tracking_add(&buffer->tracking);
        return &buffer->data;
    } else {
        return NULL;
    }
}
void btstack_memory_hci_iso_stream_free(hci_iso_stream_t *hci_iso_stream){
    // reconstruct buffer start
    btstack_memory_buffer_t * buffer = &((btstack_memory_buffer_t *) hci_iso_stream)[-1];
    btstack_memory_tracking_remove(buffer);
    free(buffer);
}
#endif


#endif

// init
void btstack_memory_init(void){
#ifdef HAVE_MALLOC
    // assert that there is no unexpected padding for combined buffer
    btstack_assert(sizeof(test_buffer_t) == sizeof(btstack_memory_buffer_t) + sizeof(void *));
#endif
  
#if MAX_NR_HCI_CONNECTIONS > 0
    btstack_memory_pool_create(&hci_connection_pool, hci_connection_storage, MAX_NR_HCI_CONNECTIONS, sizeof(hci_connection_t));
#endif

#if MAX_NR_L2CAP_SERVICES > 0
    btstack_memory_pool_create(&l2cap_service_pool, l2cap_service_storage, MAX_NR_L2CAP_SERVICES, sizeof(l2cap_service_t));
#endif
#if MAX_NR_L2CAP_CHANNELS > 0
    btstack_memory_pool_create(&l2cap_channel_pool, l2cap_channel_storage, MAX_NR_L2CAP_CHANNELS, sizeof(l2cap_channel_t));
#endif

#ifdef ENABLE_CLASSIC
#if MAX_NR_RFCOMM_MULTIPLEXERS > 0
    btstack_memory_pool_create(&rfcomm_multiplexer_pool, rfcomm_multiplexer_storage, MAX_NR_RFCOMM_MULTIPLEXERS, sizeof(rfcomm_multiplexer_t));
#endif
#if MAX_NR_RFCOMM_SERVICES > 0
    btstack_memory_pool_create(&rfcomm_service_pool, rfcomm_service_storage, MAX_NR_RFCOMM_SERVICES, sizeof(rfcomm_service_t));
#endif
#if MAX_NR_RFCOMM_CHANNELS > 0
    btstack_memory_pool_create(&rfcomm_channel_pool, rfcomm_channel_storage, MAX_NR_RFCOMM_CHANNELS, sizeof(rfcomm_channel_t));
#endif

#if MAX_NR_BTSTACK_LINK_KEY_DB_MEMORY_ENTRIES > 0
    btstack_memory_pool_create(&btstack_link_key_db_memory_entry_pool, btstack_link_key_db_memory_entry_storage, MAX_NR_BTSTACK_LINK_KEY_DB_MEMORY_ENTRIES, sizeof(btstack_link_key_db_memory_entry_t));
#endif

#if MAX_NR_BNEP_SERVICES > 0
    btstack_memory_pool_create(&bnep_service_pool, bnep_service_storage, MAX_NR_BNEP_SERVICES, sizeof(bnep_service_t));
#endif
#if MAX_NR_BNEP_CHANNELS > 0
    btstack_memory_pool_create(&bnep_channel_pool, bnep_channel_storage, MAX_NR_BNEP_CHANNELS, sizeof(bnep_channel_t));
#endif

#if MAX_NR_GOEP_SERVER_SERVICES > 0
    btstack_memory_pool_create(&goep_server_service_pool, goep_server_service_storage, MAX_NR_GOEP_SERVER_SERVICES, sizeof(goep_server_service_t));
#endif
#if MAX_NR_GOEP_SERVER_CONNECTIONS > 0
    btstack_memory_pool_create(&goep_server_connection_pool, goep_server_connection_storage, MAX_NR_GOEP_SERVER_CONNECTIONS, sizeof(goep_server_connection_t));
#endif

#if MAX_NR_HFP_CONNECTIONS > 0
    btstack_memory_pool_create(&hfp_connection_pool, hfp_connection_storage, MAX_NR_HFP_CONNECTIONS, sizeof(hfp_connection_t));
#endif

#if MAX_NR_HID_HOST_CONNECTIONS > 0
    btstack_memory_pool_create(&hid_host_connection_pool, hid_host_connection_storage, MAX_NR_HID_HOST_CONNECTIONS, sizeof(hid_host_connection_t));
#endif

#if MAX_NR_SERVICE_RECORD_ITEMS > 0
    btstack_memory_pool_create(&service_record_item_pool, service_record_item_storage, MAX_NR_SERVICE_RECORD_ITEMS, sizeof(service_record_item_t));
#endif

#if MAX_NR_AVDTP_STREAM_ENDPOINTS > 0
    btstack_memory_pool_create(&avdtp_stream_endpoint_pool, avdtp_stream_endpoint_storage, MAX_NR_AVDTP_STREAM_ENDPOINTS, sizeof(avdtp_stream_endpoint_t));
#endif

#if MAX_NR_AVDTP_CONNECTIONS > 0
    btstack_memory_pool_create(&avdtp_connection_pool, avdtp_connection_storage, MAX_NR_AVDTP_CONNECTIONS, sizeof(avdtp_connection_t));
#endif

#if MAX_NR_AVRCP_CONNECTIONS > 0
    btstack_memory_pool_create(&avrcp_connection_pool, avrcp_connection_storage, MAX_NR_AVRCP_CONNECTIONS, sizeof(avrcp_connection_t));
#endif

#if MAX_NR_AVRCP_BROWSING_CONNECTIONS > 0
    btstack_memory_pool_create(&avrcp_browsing_connection_pool, avrcp_browsing_connection_storage, MAX_NR_AVRCP_BROWSING_CONNECTIONS, sizeof(avrcp_browsing_connection_t));
#endif

#endif
#ifdef ENABLE_BLE
#if MAX_NR_BATTERY_SERVICE_CLIENTS > 0
    btstack_memory_pool_create(&battery_service_client_pool, battery_service_client_storage, MAX_NR_BATTERY_SERVICE_CLIENTS, sizeof(battery_service_client_t));
#endif
#if MAX_NR_GATT_CLIENTS > 0
    btstack_memory_pool_create(&gatt_client_pool, gatt_client_storage, MAX_NR_GATT_CLIENTS, sizeof(gatt_client_t));
#endif
#if MAX_NR_HIDS_CLIENTS > 0
    btstack_memory_pool_create(&hids_client_pool, hids_client_storage, MAX_NR_HIDS_CLIENTS, sizeof(hids_client_t));
#endif
#if MAX_NR_SCAN_PARAMETERS_SERVICE_CLIENTS > 0
    btstack_memory_pool_create(&scan_parameters_service_client_pool, scan_parameters_service_client_storage, MAX_NR_SCAN_PARAMETERS_SERVICE_CLIENTS, sizeof(scan_parameters_service_client_t));
#endif
#if MAX_NR_SM_LOOKUP_ENTRIES > 0
    btstack_memory_pool_create(&sm_lookup_entry_pool, sm_lookup_entry_storage, MAX_NR_SM_LOOKUP_ENTRIES, sizeof(sm_lookup_entry_t));
#endif
#if MAX_NR_WHITELIST_ENTRIES > 0
    btstack_memory_pool_create(&whitelist_entry_pool, whitelist_entry_storage, MAX_NR_WHITELIST_ENTRIES, sizeof(whitelist_entry_t));
#endif
#if MAX_NR_PERIODIC_ADVERTISER_LIST_ENTRIES > 0
    btstack_memory_pool_create(&periodic_advertiser_list_entry_pool, periodic_advertiser_list_entry_storage, MAX_NR_PERIODIC_ADVERTISER_LIST_ENTRIES, sizeof(periodic_advertiser_list_entry_t));
#endif

#endif
#ifdef ENABLE_MESH
#if MAX_NR_MESH_NETWORK_PDUS > 0
    btstack_memory_pool_create(&mesh_network_pdu_pool, mesh_network_pdu_storage, MAX_NR_MESH_NETWORK_PDUS, sizeof(mesh_network_pdu_t));
#endif
#if MAX_NR_MESH_SEGMENTED_PDUS > 0
    btstack_memory_pool_create(&mesh_segmented_pdu_pool, mesh_segmented_pdu_storage, MAX_NR_MESH_SEGMENTED_PDUS, sizeof(mesh_segmented_pdu_t));
#endif
#if MAX_NR_MESH_UPPER_TRANSPORT_PDUS > 0
    btstack_memory_pool_create(&mesh_upper_transport_pdu_pool, mesh_upper_transport_pdu_storage, MAX_NR_MESH_UPPER_TRANSPORT_PDUS, sizeof(mesh_upper_transport_pdu_t));
#endif
#if MAX_NR_MESH_NETWORK_KEYS > 0
    btstack_memory_pool_create(&mesh_network_key_pool, mesh_network_key_storage, MAX_NR_MESH_NETWORK_KEYS, sizeof(mesh_network_key_t));
#endif
#if MAX_NR_MESH_TRANSPORT_KEYS > 0
    btstack_memory_pool_create(&mesh_transport_key_pool, mesh_transport_key_storage, MAX_NR_MESH_TRANSPORT_KEYS, sizeof(mesh_transport_key_t));
#endif
#if MAX_NR_MESH_VIRTUAL_ADDRESSS > 0
    btstack_memory_pool_create(&mesh_virtual_address_pool, mesh_virtual_address_storage, MAX_NR_MESH_VIRTUAL_ADDRESSS, sizeof(mesh_virtual_address_t));
#endif
#if MAX_NR_MESH_SUBNETS > 0
    btstack_memory_pool_create(&mesh_subnet_pool, mesh_subnet_storage, MAX_NR_MESH_SUBNETS, sizeof(mesh_subnet_t));
#endif

#endif
#ifdef ENABLE_LE_ISOCHRONOUS_STREAMS
#if MAX_NR_HCI_ISO_STREAMS > 0
    btstack_memory_pool_create(&hci_iso_stream_pool, hci_iso_stream_storage, MAX_NR_HCI_ISO_STREAMS, sizeof(hci_iso_stream_t));
#endif

#endif
}
