/* SPDX-License-Identifier: (GPL-2.0+ OR MIT) */
/*
 * Copyright (c) 2019 Amlogic, Inc. All rights reserved.
 */

#ifndef _AML_MBOX_CMD_H_
#define _AML_MBOX_CMD_H_
#include <linux/types.h>

#define __MBX_COMPOSE_MSG(mod, func)    (((mod) << 10) | ((func) & 0x3FF))
#define MBX_SYSTEM              0x0

#define CMD_INVALID		0x00
#define CMD_SCPI_READY		0x01
#define CMD_SCPI_CAPABILITIES	0x02
#define CMD_EVENT		0x03
#define CMD_SET_CSS_PWR_STATE	0x04
#define CMD_GET_CSS_PWR_STATE	0x05
#define CMD_CFG_PWR_STATE_STAT	0x06
#define CMD_GET_PWR_STATE_STAT	0x07
#define CMD_SYS_PWR_STATE	0x08
#define CMD_L2_READY		0x09
#define CMD_SET_AP_TIMER	0x0a
#define CMD_CANCEL_AP_TIME	0x0b
#define CMD_DVFS_CAPABILITIES	0x0c
#define CMD_GET_DVFS_INFO	0x0d
#define CMD_SET_DVFS		0x0e
#define CMD_GET_DVFS		0x0f
#define CMD_GET_DVFS_STAT	0x10
#define CMD_SET_RTC		0x11
#define CMD_GET_RTC		0x12
#define CMD_CLOCK_CAPABILITIES	0x13
#define CMD_SET_CLOCK_INDEX	0x14
#define CMD_SET_CLOCK_VALUE	0x15
#define CMD_GET_CLOCK_VALUE	0x16
#define CMD_PSU_CAPABILITIES	0x17
#define CMD_SET_PSU		0x18
#define CMD_GET_PSU		0x19
#define CMD_SENSOR_CAPABILITIES	0x1a
#define CMD_SENSOR_INFO		0x1b
#define CMD_SENSOR_VALUE	0x1c
#define CMD_SENSOR_CFG_PERIODIC	0x1d
#define CMD_SENSOR_CFG_BOUNDS	0x1e
#define CMD_SENSOR_ASYNC_VALUE	0x1f
#define CMD_SET_USR_DATA	0x20
#define CMD_OSCRING_VALUE	0x43
#define CMD_WAKEUP_REASON_GET	0x30
#define CMD_WAKEUP_REASON_CLR	0X31
#define CMD_GET_ETHERNET_CALC	0x32
#define CMD_GET_CPUINFO		0x33
#define CMD_INIT_DSP		0x34
#define CMD_SET_ETHERNET_WOL    0x35
#define CMD_HIFI4STOP		0x4d
#define CMD_HIFI4SUSPEND	0x4e
#define CMD_HIFI4RESUME		0x4f

#define CMD_HIFI4LOGCTL		0x50
#define CMD_HIFI4SYSTLOG	0x51
#define CMD_HIFI5_SYSLOG_START  0x63

#define CMD_GET_CEC1		0xB4
#define CMD_GET_CEC2		0xB5
#define CMD_SET_CEC_DATA	0xB6/*to aocpu cec module*/
#define CMD_SEND_DSP_DATA	0xB6
#define CMD_SET_CEC1		0xB7
#define CMD_SET_CEC2		0xB8
#define CMD_GET_CEC_REASON	0xB9
#define CMD_SET_CEC_REASON	0xBA
#define CMD_GET_CEC_OTP_MSG	0xBB
#define CMD_GET_CEC_AS_MSG	0xBC
#define CMD_BL4_WAIT_UNLOCK	0xD6
#define CMD_BL4_SEND		0xD7
#define CMD_BL4_LISTEN		0xD8
#define CMD_LEDS_STATE		0xF7
#define	CMD_SET_FD650		0x68

#define MBOX_CMD_INVALID		__MBX_COMPOSE_MSG(MBX_SYSTEM, CMD_INVALID)
#define MBOX_CMD_SCPI_READY		__MBX_COMPOSE_MSG(MBX_SYSTEM, CMD_SCPI_READY)
#define MBOX_CMD_SCPI_CAPABILITIES	__MBX_COMPOSE_MSG(MBX_SYSTEM, CMD_SCPI_CAPABILITIES)
#define MBOX_CMD_EVENT			__MBX_COMPOSE_MSG(MBX_SYSTEM, CMD_EVENT)
#define MBOX_CMD_SET_CSS_PWR_STATE	__MBX_COMPOSE_MSG(MBX_SYSTEM, CMD_SET_CSS_PWR_STATE)
#define MBOX_CMD_GET_CSS_PWR_STATE	__MBX_COMPOSE_MSG(MBX_SYSTEM, CMD_GET_CSS_PWR_STATE)
#define MBOX_CMD_CFG_PWR_STATE_STAT	__MBX_COMPOSE_MSG(MBX_SYSTEM, CMD_CFG_PWR_STATE_STAT)
#define MBOX_CMD_GET_PWR_STATE_STAT	__MBX_COMPOSE_MSG(MBX_SYSTEM, CMD_GET_PWR_STATE_STAT)
#define MBOX_CMD_SYS_PWR_STATE		__MBX_COMPOSE_MSG(MBX_SYSTEM, CMD_SYS_PWR_STATE)
#define MBOX_CMD_L2_READY		__MBX_COMPOSE_MSG(MBX_SYSTEM, CMD_L2_READY)
#define MBOX_CMD_SET_AP_TIMER		__MBX_COMPOSE_MSG(MBX_SYSTEM, CMD_SET_AP_TIMER)
#define MBOX_CMD_CANCEL_AP_TIME		__MBX_COMPOSE_MSG(MBX_SYSTEM, CMD_CANCEL_AP_TIME)
#define MBOX_CMD_DVFS_CAPABILITIES	__MBX_COMPOSE_MSG(MBX_SYSTEM, CMD_DVFS_CAPABILITIES)
#define MBOX_CMD_GET_DVFS_INFO		__MBX_COMPOSE_MSG(MBX_SYSTEM, CMD_GET_DVFS_INFO)
#define MBOX_CMD_SET_DVFS		__MBX_COMPOSE_MSG(MBX_SYSTEM, CMD_SET_DVFS)
#define MBOX_CMD_GET_DVFS		__MBX_COMPOSE_MSG(MBX_SYSTEM, CMD_GET_DVFS)
#define MBOX_CMD_GET_DVFS_STAT		__MBX_COMPOSE_MSG(MBX_SYSTEM, CMD_GET_DVFS_STAT)
#define MBOX_CMD_SET_RTC		__MBX_COMPOSE_MSG(MBX_SYSTEM, CMD_SET_RTC)
#define MBOX_CMD_GET_RTC		__MBX_COMPOSE_MSG(MBX_SYSTEM, CMD_GET_RTC)
#define MBOX_CMD_CLOCK_CAPABILITIES	__MBX_COMPOSE_MSG(MBX_SYSTEM, CMD_CLOCK_CAPABILITIES)
#define MBOX_CMD_SET_CLOCK_INDEX	__MBX_COMPOSE_MSG(MBX_SYSTEM, CMD_SET_CLOCK_INDEX)
#define MBOX_CMD_SET_CLOCK_VALUE	__MBX_COMPOSE_MSG(MBX_SYSTEM, CMD_SET_CLOCK_VALUE)
#define MBOX_CMD_GET_CLOCK_VALUE	__MBX_COMPOSE_MSG(MBX_SYSTEM, CMD_GET_CLOCK_VALUE)
#define MBOX_CMD_PSU_CAPABILITIES	__MBX_COMPOSE_MSG(MBX_SYSTEM, CMD_PSU_CAPABILITIES)
#define MBOX_CMD_SET_PSU		__MBX_COMPOSE_MSG(MBX_SYSTEM, CMD_SET_PSU)
#define MBOX_CMD_GET_PSU		__MBX_COMPOSE_MSG(MBX_SYSTEM, CMD_GET_PSU)
#define MBOX_CMD_SENSOR_CAPABILITIES	__MBX_COMPOSE_MSG(MBX_SYSTEM, CMD_SENSOR_CAPABILITIES)
#define MBOX_CMD_SENSOR_INFO		__MBX_COMPOSE_MSG(MBX_SYSTEM, CMD_SENSOR_INFO)
#define MBOX_CMD_SENSOR_VALUE		__MBX_COMPOSE_MSG(MBX_SYSTEM, CMD_SENSOR_VALUE)
#define MBOX_CMD_SENSOR_CFG_PERIODIC	__MBX_COMPOSE_MSG(MBX_SYSTEM, CMD_SENSOR_CFG_PERIODIC)
#define MBOX_CMD_SENSOR_CFG_BOUNDS	__MBX_COMPOSE_MSG(MBX_SYSTEM, CMD_SENSOR_CFG_BOUNDS)
#define MBOX_CMD_SENSOR_ASYNC_VALUE	__MBX_COMPOSE_MSG(MBX_SYSTEM, CMD_SENSOR_ASYNC_VALUE)
#define MBOX_CMD_SET_USR_DATA		__MBX_COMPOSE_MSG(MBX_SYSTEM, CMD_SET_USR_DATA)
#define MBOX_CMD_OSCRING_VALUE		__MBX_COMPOSE_MSG(MBX_SYSTEM, CMD_OSCRING_VALUE)
#define MBOX_CMD_WAKEUP_REASON_GET	__MBX_COMPOSE_MSG(MBX_SYSTEM, CMD_WAKEUP_REASON_GET)
#define MBOX_CMD_WAKEUP_REASON_CLR	__MBX_COMPOSE_MSG(MBX_SYSTEM, CMD_WAKEUP_REASON_CLR)
#define MBOX_CMD_GET_ETHERNET_CALC	__MBX_COMPOSE_MSG(MBX_SYSTEM, CMD_GET_ETHERNET_CALC)
#define MBOX_CMD_GET_CPUINFO		__MBX_COMPOSE_MSG(MBX_SYSTEM, CMD_GET_CPUINFO)
#define MBOX_CMD_INIT_DSP		__MBX_COMPOSE_MSG(MBX_SYSTEM, CMD_INIT_DSP)
#define MBOX_CMD_SET_ETHERNET_WOL       __MBX_COMPOSE_MSG(MBX_SYSTEM, CMD_SET_ETHERNET_WOL)
#define MBOX_CMD_HIFI4STOP		__MBX_COMPOSE_MSG(MBX_SYSTEM, CMD_HIFI4STOP)
#define MBOX_CMD_HIFI4SUSPEND		__MBX_COMPOSE_MSG(MBX_SYSTEM, CMD_HIFI4SUSPEND)
#define MBOX_CMD_HIFI4RESUME		__MBX_COMPOSE_MSG(MBX_SYSTEM, CMD_HIFI4RESUME)

#define MBOX_CMD_HIFI4LOGCTL		__MBX_COMPOSE_MSG(MBX_SYSTEM, CMD_HIFI4LOGCTL)
#define MBOX_CMD_HIFI4SYSTLOG		__MBX_COMPOSE_MSG(MBX_SYSTEM, CMD_HIFI4SYSTLOG)
#define MBOX_CMD_HIFI5_SYSLOG_START	__MBX_COMPOSE_MSG(MBX_SYSTEM, CMD_HIFI5_SYSLOG_START)

#define MBOX_CMD_GET_CEC1		__MBX_COMPOSE_MSG(MBX_SYSTEM, CMD_GET_CEC1)
#define MBOX_CMD_GET_CEC2		__MBX_COMPOSE_MSG(MBX_SYSTEM, CMD_GET_CEC2)
/*to aocpu cec module*/
#define MBOX_CMD_SET_CEC_DATA		__MBX_COMPOSE_MSG(MBX_SYSTEM, CMD_SET_CEC_DATA)
#define MBOX_CMD_SEND_DSP_DATA		__MBX_COMPOSE_MSG(MBX_SYSTEM, CMD_SEND_DSP_DATA)
#define MBOX_CMD_SET_CEC1		__MBX_COMPOSE_MSG(MBX_SYSTEM, CMD_SET_CEC1)
#define MBOX_CMD_SET_CEC2		__MBX_COMPOSE_MSG(MBX_SYSTEM, CMD_SET_CEC2)
#define MBOX_CMD_GET_CEC_REASON		__MBX_COMPOSE_MSG(MBX_SYSTEM, CMD_GET_CEC_REASON)
#define MBOX_CMD_SET_CEC_REASON		__MBX_COMPOSE_MSG(MBX_SYSTEM, CMD_SET_CEC_REASON)
#define MBOX_CMD_GET_CEC_OTP_MSG	__MBX_COMPOSE_MSG(MBX_SYSTEM, CMD_GET_CEC_OTP_MSG)
#define MBOX_CMD_GET_CEC_AS_MSG		__MBX_COMPOSE_MSG(MBX_SYSTEM, CMD_GET_CEC_AS_MSG)
#define MBOX_CMD_BL4_WAIT_UNLOCK	__MBX_COMPOSE_MSG(MBX_SYSTEM, CMD_BL4_WAIT_UNLOCK)
#define MBOX_CMD_BL4_SEND		__MBX_COMPOSE_MSG(MBX_SYSTEM, CMD_BL4_SEND)
#define MBOX_CMD_BL4_LISTEN		__MBX_COMPOSE_MSG(MBX_SYSTEM, CMD_BL4_LISTEN)
#define MBOX_CMD_LEDS_STATE		__MBX_COMPOSE_MSG(MBX_SYSTEM, CMD_LEDS_STATE)
#define MBOX_CMD_SET_FD650		__MBX_COMPOSE_MSG(MBX_SYSTEM, CMD_SET_FD650)

#endif
