/* SPDX-License-Identifier: (GPL-2.0+ OR MIT) */
/*
 * Copyright (c) 2019 Amlogic, Inc. All rights reserved.
 */

#ifndef __T5W_CLKC_H
#define __T5W_CLKC_H

/*
 * CLKID index values
 */
#define CLKID_SYS_PLL_DCO		0
#define CLKID_SYS_PLL			1
#define CLKID_FIXED_PLL_DCO		2
#define CLKID_FIXED_PLL			3
#define CLKID_FCLK_DIV2_DIV		4
#define CLKID_FCLK_DIV2			5
#define CLKID_FCLK_DIV3_DIV		6
#define CLKID_FCLK_DIV3			7
#define CLKID_FCLK_DIV4_DIV		8
#define CLKID_FCLK_DIV4			9
#define CLKID_FCLK_DIV5_DIV		10
#define CLKID_FCLK_DIV5			11
#define CLKID_FCLK_DIV7_DIV		12
#define CLKID_FCLK_DIV7			13
#define CLKID_FCLK_DIV2P5_DIV		14
#define CLKID_FCLK_DIV2P5		15
#define CLKID_GP0_PLL_DCO		16
#define CLKID_GP0_PLL			17
#define CLKID_GP1_PLL_DCO		18
#define CLKID_GP1_PLL			19
#define CLKID_HIFI_PLL_DCO		20
#define CLKID_HIFI_PLL			21
#define CLKID_MPLL_50M_DIV		22
#define CLKID_MPLL_50M			23
#define CLKID_PRE_MPLL			24
#define CLKID_MPLL0_DIV			25
#define CLKID_MPLL0			26
#define CLKID_MPLL1_DIV			27
#define CLKID_MPLL1			28
#define CLKID_MPLL2_DIV			29
#define CLKID_MPLL2			30
#define CLKID_MPLL3_DIV			31
#define CLKID_MPLL3			32
#define CLKID_CPU_CLK_DYN		33
#define CLKID_CPU_CLK			34
#define CLKID_DSU_CLK_DYN		35
#define CLKID_DSU_CLK_FINAL		36
#define CLKID_DSU_CLK			37

#define VIDEO_BASE			38
#define CLKID_VDEC_0_SEL		(VIDEO_BASE + 0)
#define CLKID_VDEC_0_DIV		(VIDEO_BASE + 1)
#define CLKID_VDEC_0			(VIDEO_BASE + 2)
#define CLKID_VDEC_1_SEL		(VIDEO_BASE + 3)
#define CLKID_VDEC_1_DIV		(VIDEO_BASE + 4)
#define CLKID_VDEC_1			(VIDEO_BASE + 5)
#define CLKID_VDEC			(VIDEO_BASE + 6)
#define CLKID_HEVCF_0_SEL		(VIDEO_BASE + 7)
#define CLKID_HEVCF_0_DIV		(VIDEO_BASE + 8)
#define CLKID_HEVCF_0			(VIDEO_BASE + 9)
#define CLKID_HEVCF_1_SEL		(VIDEO_BASE + 10)
#define CLKID_HEVCF_1_DIV		(VIDEO_BASE + 11)
#define CLKID_HEVCF_1			(VIDEO_BASE + 12)
#define CLKID_HEVCF			(VIDEO_BASE + 13)
#define CLKID_GE2D_SEL			(VIDEO_BASE + 14)
#define CLKID_GE2D_DIV			(VIDEO_BASE + 15)
#define CLKID_GE2D			(VIDEO_BASE + 16)
#define CLKID_VAPB_0_SEL		(VIDEO_BASE + 17)
#define CLKID_VAPB_0_DIV		(VIDEO_BASE + 18)
#define CLKID_VAPB_0			(VIDEO_BASE + 19)
#define CLKID_VAPB_1_SEL		(VIDEO_BASE + 20)
#define CLKID_VAPB_1_DIV		(VIDEO_BASE + 21)
#define CLKID_VAPB_1			(VIDEO_BASE + 22)
#define CLKID_VAPB			(VIDEO_BASE + 23)
#define CLKID_MALI_0_SEL		(VIDEO_BASE + 24)
#define CLKID_MALI_0_DIV		(VIDEO_BASE + 25)
#define CLKID_MALI_0			(VIDEO_BASE + 26)
#define CLKID_MALI_1_SEL		(VIDEO_BASE + 27)
#define CLKID_MALI_1_DIV		(VIDEO_BASE + 28)
#define CLKID_MALI_1			(VIDEO_BASE + 29)
#define CLKID_MALI			(VIDEO_BASE + 30)
#define CLKID_TS_CLK_DIV		(VIDEO_BASE + 31)
#define CLKID_TS_CLK			(VIDEO_BASE + 32)
#define CLKID_SD_EMMC_C_SEL		(VIDEO_BASE + 33)
#define CLKID_SD_EMMC_C_DIV		(VIDEO_BASE + 34)
#define CLKID_SD_EMMC_C			(VIDEO_BASE + 35)
#define CLKID_SD_EMMC_B_SEL		(VIDEO_BASE + 36)
#define CLKID_SD_EMMC_B_DIV		(VIDEO_BASE + 37)
#define CLKID_SD_EMMC_B			(VIDEO_BASE + 38)
#define CLKID_VDIN_MEAS_SEL		(VIDEO_BASE + 39)
#define CLKID_VDIN_MEAS_DIV		(VIDEO_BASE + 40)
#define CLKID_VDIN_MEAS			(VIDEO_BASE + 41)
#define CLKID_VID_LOCK_DIV		(VIDEO_BASE + 42)
#define CLKID_VID_LOCK			(VIDEO_BASE + 43)
#define CLKID_VPU_0_SEL			(VIDEO_BASE + 44)
#define CLKID_VPU_0_DIV			(VIDEO_BASE + 45)
#define CLKID_VPU_0			(VIDEO_BASE + 46)
#define CLKID_VPU_1_SEL			(VIDEO_BASE + 47)
#define CLKID_VPU_1_DIV			(VIDEO_BASE + 48)
#define CLKID_VPU_1			(VIDEO_BASE + 49)
#define CLKID_VPU			(VIDEO_BASE + 50)
#define CLKID_VPU_CLKB_TMP_SEL		(VIDEO_BASE + 51)
#define CLKID_VPU_CLKB_TMP_DIV		(VIDEO_BASE + 52)
#define CLKID_VPU_CLKB_TMP		(VIDEO_BASE + 53)
#define CLKID_VPU_CLKB_DIV		(VIDEO_BASE + 54)
#define CLKID_VPU_CLKB			(VIDEO_BASE + 55)
#define CLKID_VPU_CLKC_0_SEL		(VIDEO_BASE + 56)
#define CLKID_VPU_CLKC_0_DIV		(VIDEO_BASE + 57)
#define CLKID_VPU_CLKC_0		(VIDEO_BASE + 58)
#define CLKID_VPU_CLKC_1_SEL		(VIDEO_BASE + 59)
#define CLKID_VPU_CLKC_1_DIV		(VIDEO_BASE + 60)
#define CLKID_VPU_CLKC_1		(VIDEO_BASE + 61)
#define CLKID_VPU_CLKC			(VIDEO_BASE + 62)
#define CLKID_MPEG_SEL			(VIDEO_BASE + 63)
#define CLKID_MPEG_DIV			(VIDEO_BASE + 64)
#define CLKID_CLK81			(VIDEO_BASE + 65)

#define MEDIA_BASE			(VIDEO_BASE + 66)
#define CLKID_CTS_TCON_PLL_CLK_SEL	(MEDIA_BASE + 0)
#define CLKID_CTS_TCON_PLL_CLK_DIV	(MEDIA_BASE + 1)
#define CLKID_CTS_TCON_PLL_CLK		(MEDIA_BASE + 2)
#define CLKID_CTS_DEMOD_CORE_SEL	(MEDIA_BASE + 3)
#define CLKID_CTS_DEMOD_CORE_DIV	(MEDIA_BASE + 4)
#define CLKID_CTS_DEMOD_CORE		(MEDIA_BASE + 5)
#define CLKID_CTS_DEMOD_CORE_T2_SEL	(MEDIA_BASE + 6)
#define CLKID_CTS_DEMOD_CORE_T2_DIV	(MEDIA_BASE + 7)
#define CLKID_CTS_DEMOD_CORE_T2		(MEDIA_BASE + 8)
#define CLKID_HDMIRX_2M_SEL		(MEDIA_BASE + 9)
#define CLKID_HDMIRX_2M_DIV		(MEDIA_BASE + 10)
#define CLKID_HDMIRX_2M			(MEDIA_BASE + 11)
#define CLKID_HDMIRX_5M_SEL		(MEDIA_BASE + 12)
#define CLKID_HDMIRX_5M_DIV		(MEDIA_BASE + 13)
#define CLKID_HDMIRX_5M			(MEDIA_BASE + 14)
#define CLKID_HDMIRX_CFG_SEL		(MEDIA_BASE + 15)
#define CLKID_HDMIRX_CFG_DIV		(MEDIA_BASE + 16)
#define CLKID_HDMIRX_CFG		(MEDIA_BASE + 17)
#define CLKID_HDMIRX_HDCP_SEL		(MEDIA_BASE + 18)
#define CLKID_HDMIRX_HDCP_DIV		(MEDIA_BASE + 19)
#define CLKID_HDMIRX_HDCP		(MEDIA_BASE + 20)
#define CLKID_HDMIRX_AUD_PLL_SEL	(MEDIA_BASE + 21)
#define CLKID_HDMIRX_AUD_PLL_DIV	(MEDIA_BASE + 22)
#define CLKID_HDMIRX_AUD_PLL		(MEDIA_BASE + 23)
#define CLKID_HDMIRX_ACR_SEL		(MEDIA_BASE + 24)
#define CLKID_HDMIRX_ACR_DIV		(MEDIA_BASE + 25)
#define CLKID_HDMIRX_ACR		(MEDIA_BASE + 26)
#define CLKID_HDMIRX_METER_SEL		(MEDIA_BASE + 27)
#define CLKID_HDMIRX_METER_DIV		(MEDIA_BASE + 28)
#define CLKID_HDMIRX_METER		(MEDIA_BASE + 29)
#define CLKID_ADC_EXTCLK_SEL		(MEDIA_BASE + 30)
#define CLKID_ADC_EXTCLK_DIV		(MEDIA_BASE + 31)
#define CLKID_ADC_EXTCLK		(MEDIA_BASE + 32)
#define CLKID_CDAC_CLK_SEL		(MEDIA_BASE + 33)
#define CLKID_CDAC_CLK_DIV		(MEDIA_BASE + 34)
#define CLKID_CDAC_CLK			(MEDIA_BASE + 35)
#define CLKID_ETH_RMII_SEL		(MEDIA_BASE + 36)
#define CLKID_ETH_RMII_DIV		(MEDIA_BASE + 37)
#define CLKID_ETH_RMII			(MEDIA_BASE + 38)
#define CLKID_SPICC0_SEL		(MEDIA_BASE + 39)
#define CLKID_SPICC0_DIV		(MEDIA_BASE + 40)
#define CLKID_SPICC0			(MEDIA_BASE + 41)
#define CLKID_SPICC1_SEL		(MEDIA_BASE + 42)
#define CLKID_SPICC1_DIV		(MEDIA_BASE + 43)
#define CLKID_SPICC1			(MEDIA_BASE + 44)
#define CLKID_SPICC2_SEL		(MEDIA_BASE + 45)
#define CLKID_SPICC2_DIV		(MEDIA_BASE + 46)
#define CLKID_SPICC2			(MEDIA_BASE + 47)
#define CLKID_TVFE_CLK_SEL		(MEDIA_BASE + 48)
#define CLKID_TVFE_CLK_DIV		(MEDIA_BASE + 49)
#define CLKID_TVFE_CLK			(MEDIA_BASE + 50)
#define CLKID_TSIN_DEGLICH_CLK_SEL	(MEDIA_BASE + 51)
#define CLKID_TSIN_DEGLICH_CLK_DIV	(MEDIA_BASE + 52)
#define CLKID_TSIN_DEGLICH_CLK		(MEDIA_BASE + 53)
#define CLKID_DEMOD_32K_CLKIN		(MEDIA_BASE + 54)
#define CLKID_DEMOD_32K_DIV		(MEDIA_BASE + 55)
#define CLKID_DEMOD_32K			(MEDIA_BASE + 56)
#define CLKID_ETH_125M			(MEDIA_BASE + 57)

#define GATE_BASE0				(MEDIA_BASE + 58)
#define CLKID_CLK81_DDR				(GATE_BASE0 + 0)
#define CLKID_CLK81_DOS				(GATE_BASE0 + 1)
#define CLKID_CLK81_ETH_PHY			(GATE_BASE0 + 2)
#define CLKID_CLK81_ISA				(GATE_BASE0 + 3)
#define CLKID_CLK81_PL310			(GATE_BASE0 + 4)
#define CLKID_CLK81_PERIPHS			(GATE_BASE0 + 5)
#define CLKID_CLK81_SPICC0			(GATE_BASE0 + 6)
#define CLKID_CLK81_I2C				(GATE_BASE0 + 7)
#define CLKID_CLK81_SANA			(GATE_BASE0 + 8)
#define CLKID_CLK81_UART0			(GATE_BASE0 + 9)
#define CLKID_CLK81_STREAM			(GATE_BASE0 + 10)
#define CLKID_CLK81_ASYNC_FIFO			(GATE_BASE0 + 11)
#define CLKID_CLK81_TVFE			(GATE_BASE0 + 12)
#define CLKID_CLK81_HIU_REG			(GATE_BASE0 + 13)
#define CLKID_CLK81_HDMIRX_PCLK			(GATE_BASE0 + 14)
#define CLKID_CLK81_ATV_DEMOD			(GATE_BASE0 + 15)
#define CLKID_CLK81_ASSIST_MISC			(GATE_BASE0 + 16)
#define CLKID_CLK81_PWR_CTRL			(GATE_BASE0 + 17)
#define CLKID_CLK81_SD_EMMC_C			(GATE_BASE0 + 18)
#define CLKID_CLK81_ADEC			(GATE_BASE0 + 19)
#define CLKID_CLK81_ACODEC			(GATE_BASE0 + 20)
#define CLKID_CLK81_TCON			(GATE_BASE0 + 21)
#define CLKID_CLK81_SPI				(GATE_BASE0 + 22)
#define CLKID_CLK81_SMARTCARD			(GATE_BASE0 + 23)
#define CLKID_CLK81_SPICC1			(GATE_BASE0 + 24)
#define CLKID_CLK81_SPICC2			(GATE_BASE0 + 25)

/*HHI_GCLK_MPEG1: 0x51*/
#define GATE_BASE1				(GATE_BASE0 + 26)
#define CLKID_CLK81_AUDIO			(GATE_BASE1 + 0)
#define CLKID_CLK81_ETH_CORE			(GATE_BASE1 + 1)
#define CLKID_CLK81_CLK_RST			(GATE_BASE1 + 3)
#define CLKID_CLK81_AIFIFO			(GATE_BASE1 + 4)
#define CLKID_CLK81_UART1			(GATE_BASE1 + 5)
#define CLKID_CLK81_G2D				(GATE_BASE1 + 6)
#define CLKID_CLK81_RESET			(GATE_BASE1 + 7)
#define CLKID_CLK81_USB_GENERAL			(GATE_BASE1 + 9)
#define CLKID_CLK81_AHB_ARB0			(GATE_BASE1 + 11)

/*HHI_GCLK_MPEG2: 0x52*/
#define GATE_BASE2				(GATE_BASE1 + 12)
#define CLKID_CLK81_AHB_DATA_BUS		(GATE_BASE2 + 0)
#define CLKID_CLK81_AHB_CTRL_BUS		(GATE_BASE2 + 1)
#define CLKID_CLK81_USB1_TO_DDR			(GATE_BASE2 + 2)
#define CLKID_CLK81_MMC_PCLK			(GATE_BASE2 + 3)
#define CLKID_CLK81_HDMIRX_AXI			(GATE_BASE2 + 4)
#define CLKID_CLK81_HDCP22_PCLK			(GATE_BASE2 + 5)
#define CLKID_CLK81_UART2			(GATE_BASE2 + 6)
#define CLKID_CLK81_CLK81_TS			(GATE_BASE2 + 7)
#define CLKID_CLK81_VPU_INTR			(GATE_BASE2 + 8)
#define CLKID_CLK81_DEMOD_COMB			(GATE_BASE2 + 9)
#define CLKID_CLK81_GIC				(GATE_BASE2 + 10)

/*HHI_GCLK_OTHER: 0x55*/
#define GATE_OTHER				(GATE_BASE2 + 11)
#define CLKID_CLK81_VCLK2_VENCI0		(GATE_OTHER + 0)
#define CLKID_CLK81_VCLK2_VENCI1		(GATE_OTHER + 1)
#define CLKID_CLK81_VCLK2_VENCP0		(GATE_OTHER + 2)
#define CLKID_CLK81_VCLK2_VENCP1		(GATE_OTHER + 3)
#define CLKID_CLK81_VCLK2_VENCT0		(GATE_OTHER + 4)
#define CLKID_CLK81_VCLK2_VENCT1		(GATE_OTHER + 5)
#define CLKID_CLK81_VCLK2_OTHER			(GATE_OTHER + 6)
#define CLKID_CLK81_VCLK2_ENCI			(GATE_OTHER + 7)
#define CLKID_CLK81_VCLK2_ENCP			(GATE_OTHER + 8)
#define CLKID_CLK81_DAC_CLK			(GATE_OTHER + 9)
#define CLKID_CLK81_ENC480P			(GATE_OTHER + 10)
#define CLKID_CLK81_RANDOM			(GATE_OTHER + 11)
#define CLKID_CLK81_VCLK2_ENCT			(GATE_OTHER + 12)
#define CLKID_CLK81_VCLK2_ENCL			(GATE_OTHER + 13)
#define CLKID_CLK81_VCLK2_VENCLMMC		(GATE_OTHER + 14)
#define CLKID_CLK81_VCLK2_VENCL			(GATE_OTHER + 15)
#define CLKID_CLK81_VCLK2_OTHER1		(GATE_OTHER + 16)

#define GATE_AO_BASE				(GATE_OTHER + 17)
#define CLKID_CLK81_DMA				(GATE_AO_BASE + 0)
#define CLKID_CLK81_EFUSE			(GATE_AO_BASE + 1)
#define CLKID_CLK81_ROM_BOOT			(GATE_AO_BASE + 2)
#define CLKID_CLK81_RESET_SEC			(GATE_AO_BASE + 3)
#define CLKID_CLK81_SEC_AHB			(GATE_AO_BASE + 4)
#define CLKID_CLK81_RSA				(GATE_AO_BASE + 5)
#define NR_CLKS					(GATE_AO_BASE + 6)

#endif /* __T5W_CLKC_H */
