/* SPDX-License-Identifier: (GPL-2.0+ OR MIT) */
/*
 * Copyright (c) 2019 Amlogic, Inc. All rights reserved.
 */

#ifndef __DT_BINDINGS_T5_CLKC_H
#define __DT_BINDINGS_T5_CLKC_H

/*
 * CLKID index values
 */
#define CLKID_SYS_PLL_DCO			0
#define CLKID_FIXED_PLL_DCO			1
#define CLKID_GP0_PLL_DCO			2
#define CLKID_HIFI_PLL_DCO			3
#define CLKID_SYS_PLL				4
#define CLKID_FIXED_PLL				5
#define CLKID_GP0_PLL				6
#define CLKID_HIFI_PLL				7
#define CLKID_FCLK_DIV2_DIV			8
#define CLKID_FCLK_DIV3_DIV			9
#define CLKID_FCLK_DIV4_DIV			10
#define CLKID_FCLK_DIV5_DIV			11
#define CLKID_FCLK_DIV7_DIV			12
#define CLKID_FCLK_DIV2P5_DIV			13
#define CLKID_FCLK_DIV2				14
#define CLKID_FCLK_DIV3				15
#define CLKID_FCLK_DIV4				16
#define CLKID_FCLK_DIV5				17
#define CLKID_FCLK_DIV7				18
#define CLKID_FCLK_DIV2P5			19
#define CLKID_PRE_MPLL				20
#define CLKID_MPLL0_DIV				21
#define CLKID_MPLL1_DIV				22
#define CLKID_MPLL2_DIV				23
#define CLKID_MPLL3_DIV				24
#define CLKID_MPLL0				25
#define CLKID_MPLL1				26
#define CLKID_MPLL2				27
#define CLKID_MPLL3				28
#define CLKID_CPU_DYN_CLK			29
#define CLKID_CPU_CLK				30
#define CLKID_MPLL_50M_DIV			31
#define CLKID_MPLL_50M				32

#define GATE_BASE0				33
#define CLKID_CLK81_DDR				(GATE_BASE0 + 0)
#define CLKID_CLK81_DOS				(GATE_BASE0 + 1)
#define CLKID_CLK81_ETH_PHY			(GATE_BASE0 + 2)
#define CLKID_CLK81_ISA				(GATE_BASE0 + 3)
#define CLKID_CLK81_PL310			(GATE_BASE0 + 4)
#define CLKID_CLK81_PERIPHS			(GATE_BASE0 + 5)
#define CLKID_CLK81_SPICC0			(GATE_BASE0 + 6)
#define CLKID_CLK81_I2C				(GATE_BASE0 + 7)
#define CLKID_CLK81_SANA			(GATE_BASE0 + 8)
#define CLKID_CLK81_SMARTCARD			(GATE_BASE0 + 9)
#define CLKID_CLK81_UART0			(GATE_BASE0 + 10)
#define CLKID_CLK81_STREAM			(GATE_BASE0 + 11)
#define CLKID_CLK81_ASYNC_FIFO			(GATE_BASE0 + 12)
#define CLKID_CLK81_TVFE			(GATE_BASE0 + 13)
#define CLKID_CLK81_HIU_REG			(GATE_BASE0 + 14)
#define CLKID_CLK81_HDMIRX_PCLK			(GATE_BASE0 + 15)
#define CLKID_CLK81_ATV_DEMOD			(GATE_BASE0 + 16)
#define CLKID_CLK81_ASSIST_MISC			(GATE_BASE0 + 17)
#define CLKID_CLK81_PWR_CTRL			(GATE_BASE0 + 18)
#define CLKID_CLK81_SD_EMMC_C			(GATE_BASE0 + 19)
#define CLKID_CLK81_ADEC			(GATE_BASE0 + 20)
#define CLKID_CLK81_ACODEC			(GATE_BASE0 + 21)
#define CLKID_CLK81_TCON			(GATE_BASE0 + 22)
#define CLKID_CLK81_SPI				(GATE_BASE0 + 23)
#define GATE_BASE1				(GATE_BASE0 + 24)
#define CLKID_CLK81_AUDIO			(GATE_BASE1 + 0)
#define CLKID_CLK81_ETH_CORE			(GATE_BASE1 + 1)
#define CLKID_CLK81_DEMUX			(GATE_BASE1 + 2)
#define CLKID_CLK81_CLK_RST			(GATE_BASE1 + 3)
#define CLKID_CLK81_AIFIFO			(GATE_BASE1 + 4)
#define CLKID_CLK81_UART1			(GATE_BASE1 + 5)
#define CLKID_CLK81_G2D				(GATE_BASE1 + 6)
#define CLKID_CLK81_RESET			(GATE_BASE1 + 7)
#define CLKID_CLK81_PARSER0			(GATE_BASE1 + 8)
#define CLKID_CLK81_USB_GENERAL			(GATE_BASE1 + 9)
#define CLKID_CLK81_PARSER1			(GATE_BASE1 + 10)
#define CLKID_CLK81_AHB_ARB0			(GATE_BASE1 + 11)
#define GATE_BASE2				(GATE_BASE1 + 12)
#define CLKID_CLK81_AHB_DATA_BUS		(GATE_BASE2 + 0)
#define CLKID_CLK81_AHB_CTRL_BUS		(GATE_BASE2 + 1)
#define CLKID_CLK81_USB1_TO_DDR			(GATE_BASE2 + 2)
#define CLKID_CLK81_MMC_PCLK			(GATE_BASE2 + 3)
#define CLKID_CLK81_HDMIRX_AXI			(GATE_BASE2 + 4)
#define CLKID_CLK81_HDCP22_PCLK			(GATE_BASE2 + 5)
#define CLKID_CLK81_UART2			(GATE_BASE2 + 6)
#define CLKID_CLK81_CLK81_TS			(GATE_BASE2 + 7)
#define CLKID_CLK81_VPU_INTR			(GATE_BASE2 + 8)
#define CLKID_CLK81_DEMOD_COMB			(GATE_BASE2 + 9)
#define CLKID_CLK81_GIC				(GATE_BASE2 + 10)
#define GATE_OTHER				(GATE_BASE2 + 11)
#define CLKID_CLK81_VCLK2_VENCI0		(GATE_OTHER + 0)
#define CLKID_CLK81_VCLK2_VENCI1		(GATE_OTHER + 1)
#define CLKID_CLK81_VCLK2_VENCP0		(GATE_OTHER + 2)
#define CLKID_CLK81_VCLK2_VENCP1		(GATE_OTHER + 3)
#define CLKID_CLK81_VCLK2_VENCT0		(GATE_OTHER + 4)
#define CLKID_CLK81_VCLK2_VENCT1		(GATE_OTHER + 5)
#define CLKID_CLK81_VCLK2_OTHER			(GATE_OTHER + 6)
#define CLKID_CLK81_VCLK2_ENCI			(GATE_OTHER + 7)
#define CLKID_CLK81_VCLK2_ENCP			(GATE_OTHER + 8)
#define CLKID_CLK81_DAC_CLK			(GATE_OTHER + 9)
#define CLKID_CLK81_ENC480P			(GATE_OTHER + 10)
#define CLKID_CLK81_RANDOM			(GATE_OTHER + 11)
#define CLKID_CLK81_VCLK2_ENCT			(GATE_OTHER + 12)
#define CLKID_CLK81_VCLK2_ENCL			(GATE_OTHER + 13)
#define CLKID_CLK81_VCLK2_VENCLMMC		(GATE_OTHER + 14)
#define CLKID_CLK81_VCLK2_VENCL			(GATE_OTHER + 15)
#define CLKID_CLK81_VCLK2_OTHER1		(GATE_OTHER + 16)
#define GATE_AO_BASE				(GATE_OTHER + 17)
#define CLKID_CLK81_DMA				(GATE_AO_BASE + 0)
#define CLKID_CLK81_EFUSE			(GATE_AO_BASE + 1)
#define CLKID_CLK81_ROM_BOOT			(GATE_AO_BASE + 2)
#define CLKID_CLK81_RESET_SEC			(GATE_AO_BASE + 3)
#define CLKID_CLK81_SEC_AHB			(GATE_AO_BASE + 4)
#define CLKID_CLK81_RSA				(GATE_AO_BASE + 5)
#define BASIC_BASE				(GATE_AO_BASE + 6)

#define CLKID_MPEG_SEL				(BASIC_BASE + 0)
#define CLKID_MPEG_DIV				(BASIC_BASE + 1)
#define CLKID_CLK81				(BASIC_BASE + 2)
#define CLKID_TS_DIV				(BASIC_BASE + 3)
#define CLKID_TS				(BASIC_BASE + 4)
#define CLKID_GPU_P0_MUX			(BASIC_BASE + 5)
#define CLKID_GPU_P0_DIV			(BASIC_BASE + 6)
#define CLKID_GPU_P0_GATE			(BASIC_BASE + 7)
#define CLKID_GPU_P1_MUX			(BASIC_BASE + 8)
#define CLKID_GPU_P1_DIV			(BASIC_BASE + 9)
#define CLKID_GPU_P1_GATE			(BASIC_BASE + 10)
#define CLKID_GPU_MUX				(BASIC_BASE + 11)
#define CLKID_VPU_P0_MUX			(BASIC_BASE + 12)
#define CLKID_VPU_P0_DIV			(BASIC_BASE + 13)
#define CLKID_VPU_P0_GATE			(BASIC_BASE + 14)
#define CLKID_VPU_P1_MUX			(BASIC_BASE + 15)
#define CLKID_VPU_P1_DIV			(BASIC_BASE + 16)
#define CLKID_VPU_P1_GATE			(BASIC_BASE + 17)
#define CLKID_VPU_MUX				(BASIC_BASE + 18)
#define CLKID_VPU_CLKC_P0_MUX			(BASIC_BASE + 19)
#define CLKID_VPU_CLKC_P0_DIV			(BASIC_BASE + 20)
#define CLKID_VPU_CLKC_P0_GATE			(BASIC_BASE + 21)
#define CLKID_VPU_CLKC_P1_MUX			(BASIC_BASE + 22)
#define CLKID_VPU_CLKC_P1_DIV			(BASIC_BASE + 23)
#define CLKID_VPU_CLKC_P1_GATE			(BASIC_BASE + 24)
#define CLKID_VPU_CLKC_MUX			(BASIC_BASE + 25)
#define CLKID_ADC_EXTCLK_IN_MUX			(BASIC_BASE + 26)
#define CLKID_ADC_EXTCLK_IN_DIV			(BASIC_BASE + 27)
#define CLKID_ADC_EXTCLK_IN			(BASIC_BASE + 28)
#define CLKID_DEMOD_CORE_CLK_MUX		(BASIC_BASE + 29)
#define CLKID_DEMOD_CORE_CLK_DIV		(BASIC_BASE + 30)
#define CLKID_DEMOD_CORE_CLK			(BASIC_BASE + 31)
#define CLKID_VDEC_P0_MUX			(BASIC_BASE + 32)
#define CLKID_VDEC_P0_DIV			(BASIC_BASE + 33)
#define CLKID_VDEC_P0_GATE			(BASIC_BASE + 34)
#define CLKID_HEVCF_P0_MUX			(BASIC_BASE + 35)
#define CLKID_HEVCF_P0_DIV			(BASIC_BASE + 36)
#define CLKID_HEVCF_P0_GATE			(BASIC_BASE + 37)
#define CLKID_VDEC_P1_MUX			(BASIC_BASE + 38)
#define CLKID_VDEC_P1_DIV			(BASIC_BASE + 39)
#define CLKID_VDEC_P1_GATE			(BASIC_BASE + 40)
#define CLKID_VDEC_MUX				(BASIC_BASE + 41)
#define CLKID_HEVCF_P1_MUX			(BASIC_BASE + 42)
#define CLKID_HEVCF_P1_DIV			(BASIC_BASE + 43)
#define CLKID_HEVCF_P1_GATE			(BASIC_BASE + 44)
#define CLKID_HEVCF_MUX				(BASIC_BASE + 45)
#define CLKID_HDCP22_ESM_MUX			(BASIC_BASE + 46)
#define CLKID_HDCP22_SKP_MUX			(BASIC_BASE + 47)
#define CLKID_HDCP22_ESM_DIV			(BASIC_BASE + 48)
#define CLKID_HDCP22_SKP_DIV			(BASIC_BASE + 49)
#define CLKID_HDCP22_ESM_GATE			(BASIC_BASE + 50)
#define CLKID_HDCP22_SKP_GATE			(BASIC_BASE + 51)
#define CLKID_VAPB_P0_MUX			(BASIC_BASE + 52)
#define CLKID_VAPB_P1_MUX			(BASIC_BASE + 53)
#define CLKID_VAPB_P0_DIV			(BASIC_BASE + 54)
#define CLKID_VAPB_P1_DIV			(BASIC_BASE + 55)
#define CLKID_VAPB_P0_GATE			(BASIC_BASE + 56)
#define CLKID_VAPB_P1_GATE			(BASIC_BASE + 57)
#define CLKID_VAPB_MUX				(BASIC_BASE + 58)
#define CLKID_HDMIRX_CFG_MUX			(BASIC_BASE + 59)
#define CLKID_HDMIRX_MODET_MUX			(BASIC_BASE + 60)
#define CLKID_HDMIRX_CFG_DIV			(BASIC_BASE + 61)
#define CLKID_HDMIRX_MODET_DIV			(BASIC_BASE + 62)
#define CLKID_HDMIRX_CFG_GATE			(BASIC_BASE + 63)
#define CLKID_HDMIRX_MODET_GATE			(BASIC_BASE + 64)
#define CLKID_HDMIRX_ACR_MUX			(BASIC_BASE + 65)
#define CLKID_HDMIRX_ACR_DIV			(BASIC_BASE + 66)
#define CLKID_HDMIRX_ACR_GATE			(BASIC_BASE + 67)
#define CLKID_HDMIRX_METER_MUX			(BASIC_BASE + 68)
#define CLKID_HDMIRX_METER_DIV			(BASIC_BASE + 69)
#define CLKID_HDMIRX_METER_GATE			(BASIC_BASE + 70)
#define CLKID_VDIN_MEAS_MUX			(BASIC_BASE + 71)
#define CLKID_VDIN_MEAS_DIV			(BASIC_BASE + 72)
#define CLKID_VDIN_MEAS_GATE			(BASIC_BASE + 73)
#define CLKID_SD_EMMC_C_MUX			(BASIC_BASE + 74)
#define CLKID_SD_EMMC_C_DIV			(BASIC_BASE + 75)
#define CLKID_SD_EMMC_C_GATE			(BASIC_BASE + 76)
#define CLKID_SPICC0_MUX			(BASIC_BASE + 77)
#define CLKID_SPICC0_DIV			(BASIC_BASE + 78)
#define CLKID_SPICC0_GATE			(BASIC_BASE + 79)
#define CLKID_VDAC_CLKC_MUX			(BASIC_BASE + 80)
#define CLKID_VDAC_CLKC_DIV			(BASIC_BASE + 81)
#define CLKID_VDAC_CLKC_GATE			(BASIC_BASE + 82)
#define CLKID_GE2D_GATE				(BASIC_BASE + 83)
#define CLKID_VPU_CLKB_TMP_MUX			(BASIC_BASE + 84)
#define CLKID_VPU_CLKB_TMP_DIV			(BASIC_BASE + 85)
#define CLKID_VPU_CLKB_TMP_GATE			(BASIC_BASE + 86)
#define CLKID_VPU_CLKB_DIV			(BASIC_BASE + 87)
#define CLKID_VPU_CLKB_GATE			(BASIC_BASE + 88)
#define CLKID_TCON_PLL_CLK_MUX			(BASIC_BASE + 89)
#define CLKID_TCON_PLL_CLK_DIV			(BASIC_BASE + 90)
#define CLKID_TCON_PLL_CLK_GATE			(BASIC_BASE + 91)
#define CLKID_SD_EMMC_C_P0_COMP			(BASIC_BASE + 92)
#define CLKID_VID_LOCK_DIV			(BASIC_BASE + 93)
#define CLKID_VID_LOCK_CLK			(BASIC_BASE + 94)
#define CLKID_HDMI_AXI_MUX			(BASIC_BASE + 95)
#define CLKID_HDMI_AXI_DIV			(BASIC_BASE + 96)
#define CLKID_HDMI_AXI_GATE			(BASIC_BASE + 97)
#define CLKID_DEMOD_T2_MUX			(BASIC_BASE + 98)
#define CLKID_DEMOD_T2_DIV			(BASIC_BASE + 99)
#define CLKID_DEMOD_T2_GATE			(BASIC_BASE + 100)
#define CLKID_TSIN_DEGLICH_MUX			(BASIC_BASE + 101)
#define CLKID_TSIN_DEGLICH_DIV			(BASIC_BASE + 102)
#define CLKID_TSIN_DEGLICH_GATE			(BASIC_BASE + 103)

#define NR_CLKS					(BASIC_BASE + 104)

#endif /* __DT_BINDINGS_T5_CLKC_H */
