/* SPDX-License-Identifier: (GPL-2.0+ OR MIT) */
/*
 * Copyright (c) 2024 Rockchip Electronics Co., Ltd.
 * Author: Elaine Zhang <zhangqing@rock-chips.com>
 */

#ifndef _DT_BINDINGS_CLK_ROCKCHIP_RV1126B_H
#define _DT_BINDINGS_CLK_ROCKCHIP_RV1126B_H

/* pll clocks */
#define PLL_GPLL				1
#define PLL_CPLL				2
#define PLL_AUPLL				3
#define ARMCLK					4
#define SCLK_DDR				5

/* clk (clocks) */
#define CLK_CPLL_DIV20				8
#define CLK_CPLL_DIV10				9
#define CLK_CPLL_DIV8				10
#define CLK_GPLL_DIV8				11
#define CLK_GPLL_DIV6				12
#define CLK_GPLL_DIV4				13
#define CLK_CPLL_DIV3				14
#define CLK_GPLL_DIV3				15
#define CLK_CPLL_DIV2				16
#define CLK_GPLL_DIV2				17
#define CLK_CM_FRAC0				18
#define CLK_CM_FRAC1				19
#define CLK_CM_FRAC2				20
#define CLK_UART_FRAC0				21
#define CLK_UART_FRAC1				22
#define CLK_AUDIO_FRAC0				23
#define CLK_AUDIO_FRAC1				24
#define CLK_AUDIO_INT0				25
#define CLK_AUDIO_INT1				26
#define SCLK_UART0_SRC				27
#define SCLK_UART1				28
#define SCLK_UART2				29
#define SCLK_UART3				30
#define SCLK_UART4				31
#define SCLK_UART5				32
#define SCLK_UART6				33
#define SCLK_UART7				34
#define MCLK_SAI0				35
#define MCLK_SAI1				36
#define MCLK_SAI2				37
#define MCLK_PDM				38
#define CLKOUT_PDM				39
#define MCLK_ASRC0				40
#define MCLK_ASRC1				41
#define MCLK_ASRC2				42
#define MCLK_ASRC3				43
#define CLK_ASRC0				44
#define CLK_ASRC1				45
#define CLK_CORE_PLL				46
#define CLK_NPU_PLL				47
#define CLK_VEPU_PLL				48
#define CLK_ISP_PLL				49
#define CLK_AISP_PLL				50
#define CLK_SARADC0_SRC				51
#define CLK_SARADC1_SRC				52
#define CLK_SARADC2_SRC				53
#define HCLK_NPU_ROOT				54
#define PCLK_NPU_ROOT				55
#define ACLK_VEPU_ROOT				56
#define HCLK_VEPU_ROOT				57
#define PCLK_VEPU_ROOT				58
#define CLK_CORE_RGA_SRC			59
#define ACLK_GMAC_ROOT				60
#define ACLK_VI_ROOT				61
#define HCLK_VI_ROOT				62
#define PCLK_VI_ROOT				63
#define DCLK_VICAP_ROOT				64
#define CLK_SYS_DSMC_ROOT			65
#define ACLK_VDO_ROOT				66
#define ACLK_RKVDEC_ROOT			67
#define HCLK_VDO_ROOT				68
#define PCLK_VDO_ROOT				69
#define DCLK_OOC_SRC				70
#define DCLK_VOP				71
#define DCLK_DECOM_SRC				72
#define PCLK_DDR_ROOT				73
#define ACLK_SYSMEM_SRC				74
#define ACLK_TOP_ROOT				75
#define ACLK_BUS_ROOT				76
#define HCLK_BUS_ROOT				77
#define PCLK_BUS_ROOT				78
#define CCLK_SDMMC0				79
#define CCLK_SDMMC1				80
#define CCLK_EMMC				81
#define SCLK_2X_FSPI0				82
#define CLK_GMAC_PTP_REF_SRC			83
#define CLK_GMAC_125M				84
#define CLK_TIMER_ROOT				85
#define TCLK_WDT_NS_SRC				86
#define TCLK_WDT_S_SRC				87
#define TCLK_WDT_HPMCU				88
#define CLK_CAN0				89
#define CLK_CAN1				90
#define PCLK_PERI_ROOT				91
#define ACLK_PERI_ROOT				92
#define CLK_I2C_BUS_SRC				93
#define CLK_SPI0				94
#define CLK_SPI1				95
#define BUSCLK_PMU_SRC				96
#define CLK_PWM0				97
#define CLK_PWM2				98
#define CLK_PWM3				99
#define CLK_PKA_RKCE_SRC			100
#define ACLK_RKCE_SRC				101
#define ACLK_VCP_ROOT				102
#define HCLK_VCP_ROOT				103
#define PCLK_VCP_ROOT				104
#define CLK_CORE_FEC_SRC			105
#define CLK_CORE_AVSP_SRC			106
#define CLK_50M_GMAC_IOBUF_VI			107
#define PCLK_TOP_ROOT				108
#define CLK_MIPI0_OUT2IO			109
#define CLK_MIPI1_OUT2IO			110
#define CLK_MIPI2_OUT2IO			111
#define CLK_MIPI3_OUT2IO			112
#define CLK_CIF_OUT2IO				113
#define CLK_MAC_OUT2IO				114
#define MCLK_SAI0_OUT2IO			115
#define MCLK_SAI1_OUT2IO			116
#define MCLK_SAI2_OUT2IO			117
#define CLK_CM_FRAC0_SRC			118
#define CLK_CM_FRAC1_SRC			119
#define CLK_CM_FRAC2_SRC			120
#define CLK_UART_FRAC0_SRC			121
#define CLK_UART_FRAC1_SRC			122
#define CLK_AUDIO_FRAC0_SRC			123
#define CLK_AUDIO_FRAC1_SRC			124
#define ACLK_NPU_ROOT				125
#define HCLK_RKNN				126
#define ACLK_RKNN				127
#define PCLK_GPIO3				128
#define DBCLK_GPIO3				129
#define PCLK_IOC_VCCIO3				130
#define PCLK_SARADC0				131
#define CLK_SARADC0				132
#define HCLK_SDMMC1				133
#define HCLK_VEPU				134
#define ACLK_VEPU				135
#define CLK_CORE_VEPU				136
#define HCLK_FEC				137
#define ACLK_FEC				138
#define CLK_CORE_FEC				139
#define HCLK_AVSP				140
#define ACLK_AVSP				141
#define BUSCLK_PMU1_ROOT			142
#define HCLK_AISP				143
#define ACLK_AISP				144
#define CLK_CORE_AISP				145
#define CLK_CORE_ISP_ROOT			146
#define PCLK_DSMC				147
#define ACLK_DSMC				148
#define HCLK_CAN0				149
#define HCLK_CAN1				150
#define PCLK_GPIO2				151
#define DBCLK_GPIO2				152
#define PCLK_GPIO4				153
#define DBCLK_GPIO4				154
#define PCLK_GPIO5				155
#define DBCLK_GPIO5				156
#define PCLK_GPIO6				157
#define DBCLK_GPIO6				158
#define PCLK_GPIO7				159
#define DBCLK_GPIO7				160
#define PCLK_IOC_VCCIO2				161
#define PCLK_IOC_VCCIO4				162
#define PCLK_IOC_VCCIO5				163
#define PCLK_IOC_VCCIO6				164
#define PCLK_IOC_VCCIO7				165
#define HCLK_ISP				166
#define ACLK_ISP				167
#define CLK_CORE_ISP				168
#define HCLK_VICAP				169
#define ACLK_VICAP				170
#define DCLK_VICAP				171
#define ISP0CLK_VICAP				172
#define HCLK_VPSS				173
#define ACLK_VPSS				174
#define CLK_CORE_VPSS				175
#define PCLK_CSI2HOST0				176
#define DCLK_CSI2HOST0				177
#define PCLK_CSI2HOST1				178
#define DCLK_CSI2HOST1				179
#define PCLK_CSI2HOST2				180
#define DCLK_CSI2HOST2				181
#define PCLK_CSI2HOST3				182
#define DCLK_CSI2HOST3				183
#define HCLK_SDMMC0				184
#define ACLK_GMAC				185
#define PCLK_GMAC				186
#define CLK_GMAC_PTP_REF			187
#define PCLK_CSIPHY0				188
#define PCLK_CSIPHY1				189
#define PCLK_MACPHY				190
#define PCLK_SARADC1				191
#define CLK_SARADC1				192
#define PCLK_SARADC2				193
#define CLK_SARADC2				194
#define ACLK_RKVDEC				195
#define HCLK_RKVDEC				196
#define CLK_HEVC_CA_RKVDEC			197
#define ACLK_VOP				198
#define HCLK_VOP				199
#define HCLK_RKJPEG				200
#define ACLK_RKJPEG				201
#define ACLK_RKMMU_DECOM			202
#define HCLK_RKMMU_DECOM			203
#define DCLK_DECOM				204
#define ACLK_DECOM				205
#define PCLK_DECOM				206
#define PCLK_MIPI_DSI				207
#define PCLK_DSIPHY				208
#define ACLK_OOC				209
#define ACLK_SYSMEM				210
#define PCLK_DDRC				211
#define PCLK_DDRMON				212
#define CLK_TIMER_DDRMON			213
#define PCLK_DFICTRL				214
#define PCLK_DDRPHY				215
#define PCLK_DMA2DDR				216
#define CLK_RCOSC_SRC				217
#define BUSCLK_PMU_MUX				218
#define BUSCLK_PMU_ROOT				219
#define PCLK_PMU				220
#define CLK_XIN_RC_DIV				221
#define CLK_32K					222
#define PCLK_PMU_GPIO0				223
#define DBCLK_PMU_GPIO0				224
#define PCLK_PMU_HP_TIMER			225
#define CLK_PMU_HP_TIMER			226
#define CLK_PMU_32K_HP_TIMER			227
#define PCLK_PWM1				228
#define CLK_PWM1				229
#define CLK_OSC_PWM1				230
#define CLK_RC_PWM1				231
#define CLK_FREQ_PWM1				232
#define CLK_COUNTER_PWM1			233
#define PCLK_I2C2				234
#define CLK_I2C2				235
#define PCLK_UART0				236
#define SCLK_UART0				237
#define PCLK_RCOSC_CTRL				238
#define CLK_OSC_RCOSC_CTRL			239
#define CLK_REF_RCOSC_CTRL			240
#define PCLK_IOC_PMUIO0				241
#define CLK_REFOUT				242
#define CLK_PREROLL				243
#define CLK_PREROLL_32K				244
#define HCLK_PMU_SRAM				245
#define PCLK_WDT_LPMCU				246
#define TCLK_WDT_LPMCU				247
#define CLK_LPMCU				248
#define CLK_LPMCU_RTC				249
#define PCLK_LPMCU_MAILBOX			250
#define HCLK_OOC				251
#define PCLK_SPI2AHB				252
#define HCLK_SPI2AHB				253
#define HCLK_FSPI1				254
#define HCLK_XIP_FSPI1				255
#define SCLK_1X_FSPI1				256
#define PCLK_IOC_PMUIO1				257
#define PCLK_AUDIO_ADC_PMU			258
#define MCLK_AUDIO_ADC_PMU			259
#define MCLK_AUDIO_ADC_DIV4_PMU			260
#define MCLK_LPSAI				261
#define ACLK_GIC400				262
#define PCLK_WDT_NS				263
#define TCLK_WDT_NS				264
#define PCLK_WDT_HPMCU				265
#define HCLK_CACHE				266
#define PCLK_HPMCU_MAILBOX			267
#define PCLK_HPMCU_INTMUX			268
#define CLK_HPMCU				269
#define CLK_HPMCU_RTC				270
#define PCLK_RKDMA				271
#define ACLK_RKDMA				272
#define PCLK_DCF				273
#define ACLK_DCF				274
#define HCLK_RGA				275
#define ACLK_RGA				276
#define CLK_CORE_RGA				277
#define PCLK_TIMER				278
#define CLK_TIMER0				279
#define CLK_TIMER1				280
#define CLK_TIMER2				281
#define CLK_TIMER3				282
#define CLK_TIMER4				283
#define CLK_TIMER5				284
#define PCLK_I2C0				285
#define CLK_I2C0				286
#define PCLK_I2C1				287
#define CLK_I2C1				288
#define PCLK_I2C3				289
#define CLK_I2C3				290
#define PCLK_I2C4				291
#define CLK_I2C4				292
#define PCLK_I2C5				293
#define CLK_I2C5				294
#define PCLK_SPI0				295
#define PCLK_SPI1				296
#define PCLK_PWM0				297
#define CLK_OSC_PWM0				298
#define CLK_RC_PWM0				299
#define PCLK_PWM2				300
#define CLK_OSC_PWM2				301
#define CLK_RC_PWM2				302
#define PCLK_PWM3				303
#define CLK_OSC_PWM3				304
#define CLK_RC_PWM3				305
#define PCLK_UART1				306
#define PCLK_UART2				307
#define PCLK_UART3				308
#define PCLK_UART4				309
#define PCLK_UART5				310
#define PCLK_UART6				311
#define PCLK_UART7				312
#define PCLK_TSADC				313
#define CLK_TSADC				314
#define HCLK_SAI0				315
#define HCLK_SAI1				316
#define HCLK_SAI2				317
#define HCLK_RKDSM				318
#define MCLK_RKDSM				319
#define HCLK_PDM				320
#define HCLK_ASRC0				321
#define HCLK_ASRC1				322
#define PCLK_AUDIO_ADC_BUS			323
#define MCLK_AUDIO_ADC_BUS			324
#define MCLK_AUDIO_ADC_DIV4_BUS			325
#define PCLK_RKCE				326
#define HCLK_NS_RKCE				327
#define PCLK_OTPC_NS				328
#define CLK_SBPI_OTPC_NS			329
#define CLK_USER_OTPC_NS			330
#define CLK_OTPC_ARB				331
#define PCLK_OTP_MASK				332
#define CLK_TSADC_PHYCTRL			333
#define LRCK_SRC_ASRC0				334
#define LRCK_DST_ASRC0				335
#define LRCK_SRC_ASRC1				336
#define LRCK_DST_ASRC1				337
#define PCLK_KEY_READER				338
#define ACLK_NSRKCE				339
#define CLK_PKA_NSRKCE				340
#define PCLK_RTC_ROOT				341
#define PCLK_GPIO1				342
#define DBCLK_GPIO1				343
#define PCLK_IOC_VCCIO1				344
#define ACLK_USB3OTG				345
#define CLK_REF_USB3OTG				346
#define CLK_SUSPEND_USB3OTG			347
#define HCLK_USB2HOST				348
#define HCLK_ARB_USB2HOST			349
#define PCLK_RTC_TEST				350
#define HCLK_EMMC				351
#define HCLK_FSPI0				352
#define HCLK_XIP_FSPI0				353
#define PCLK_PIPEPHY				354
#define PCLK_USB2PHY				355
#define CLK_REF_PIPEPHY_CPLL_SRC		356
#define CLK_REF_PIPEPHY				357
#define HCLK_VPSL				358
#define ACLK_VPSL				359
#define CLK_CORE_VPSL				360
#define CLK_MACPHY				361
#define HCLK_RKRNG_NS				362
#define HCLK_RKRNG_S_NS				363
#define CLK_AISP_PLL_SRC			364

/* secure clks */
#define CLK_USER_OTPC_S				400
#define CLK_SBPI_OTPC_S				401
#define PCLK_OTPC_S				402
#define PCLK_KEY_READER_S			403
#define HCLK_KL_RKCE_S				404
#define HCLK_RKCE_S				405
#define PCLK_WDT_S				406
#define TCLK_WDT_S				407
#define CLK_STIMER0				408
#define CLK_STIMER1				409
#define PLK_STIMER				410
#define HCLK_RKRNG_S				411
#define CLK_PKA_RKCE_S				412
#define ACLK_RKCE_S				413

#define CLK_NR_CLKS				(ACLK_RKCE_S + 1)

// ======================= TOPCRU module definition bank=0 ========================
// TOPCRU_SOFTRST_CON15(Offset:0xA3C)
#define SRST_PRESETN_CRU			0x000000F1
#define SRST_PRESETN_CRU_BIU			0x000000F2

// ======================= BUSCRU module definition bank=1 ========================
// BUSCRU_SOFTRST_CON00(Offset:0xA00)
#define SRST_ARESETN_TOP_BIU			0x00040000
#define SRST_ARESETN_RKCE_BIU			0x00040001
#define SRST_ARESETN_BUS_BIU			0x00040002
#define SRST_HRESETN_BUS_BIU			0x00040003
#define SRST_PRESETN_BUS_BIU			0x00040004
#define SRST_PRESETN_CRU_BUS			0x00040005
#define SRST_PRESETN_SYS_GRF			0x00040006
#define SRST_HRESETN_BOOTROM			0x00040007
#define SRST_ARESETN_GIC400			0x00040008
#define SRST_ARESETN_SPINLOCK			0x00040009
#define SRST_PRESETN_WDT_NS			0x0004000A
#define SRST_TRESETN_WDT_NS			0x0004000B

// BUSCRU_SOFTRST_CON01(Offset:0xA04)
#define SRST_PRESETN_WDT_HPMCU			0x00040010
#define SRST_TRESETN_WDT_HPMCU			0x00040011
#define SRST_HRESETN_CACHE			0x00040012
#define SRST_PRESETN_HPMCU_MAILBOX		0x00040013
#define SRST_PRESETN_HPMCU_INTMUX		0x00040014
#define SRST_RESETN_HPMCU_FULL_CLUSTER		0x00040015
#define SRST_RESETN_HPMCU_PWUP			0x00040016
#define SRST_RESETN_HPMCU_ONLY_CORE		0x00040017
#define SRST_TRESETN_HPMCU_JTAG			0x00040018
#define SRST_PRESETN_RKDMA			0x0004001B
#define SRST_ARESETN_RKDMA			0x0004001C

// BUSCRU_SOFTRST_CON02(Offset:0xA08)
#define SRST_PRESETN_DCF			0x00040020
#define SRST_ARESETN_DCF			0x00040021
#define SRST_HRESETN_RGA			0x00040022
#define SRST_ARESETN_RGA			0x00040023
#define SRST_RESETN_CORE_RGA			0x00040024
#define SRST_PRESETN_TIMER			0x00040025
#define SRST_RESETN_TIMER0			0x00040026
#define SRST_RESETN_TIMER1			0x00040027
#define SRST_RESETN_TIMER2			0x00040028
#define SRST_RESETN_TIMER3			0x00040029
#define SRST_RESETN_TIMER4			0x0004002A
#define SRST_RESETN_TIMER5			0x0004002B
#define SRST_ARESETN_RKCE			0x0004002C
#define SRST_RESETN_PKA_RKCE			0x0004002D
#define SRST_HRESETN_RKRNG_S			0x0004002E
#define SRST_HRESETN_RKRNG_NS			0x0004002F

// BUSCRU_SOFTRST_CON03(Offset:0xA0C)
#define SRST_PRESETN_I2C0			0x00040030
#define SRST_RESETN_I2C0			0x00040031
#define SRST_PRESETN_I2C1			0x00040032
#define SRST_RESETN_I2C1			0x00040033
#define SRST_PRESETN_I2C3			0x00040034
#define SRST_RESETN_I2C3			0x00040035
#define SRST_PRESETN_I2C4			0x00040036
#define SRST_RESETN_I2C4			0x00040037
#define SRST_PRESETN_I2C5			0x00040038
#define SRST_RESETN_I2C5			0x00040039
#define SRST_PRESETN_SPI0			0x0004003A
#define SRST_RESETN_SPI0			0x0004003B
#define SRST_PRESETN_SPI1			0x0004003C
#define SRST_RESETN_SPI1			0x0004003D

// BUSCRU_SOFTRST_CON04(Offset:0xA10)
#define SRST_PRESETN_PWM0			0x00040040
#define SRST_RESETN_PWM0			0x00040041
#define SRST_PRESETN_PWM2			0x00040044
#define SRST_RESETN_PWM2			0x00040045
#define SRST_PRESETN_PWM3			0x00040048
#define SRST_RESETN_PWM3			0x00040049

// BUSCRU_SOFTRST_CON05(Offset:0xA14)
#define SRST_PRESETN_UART1			0x00040050
#define SRST_SRESETN_UART1			0x00040051
#define SRST_PRESETN_UART2			0x00040052
#define SRST_SRESETN_UART2			0x00040053
#define SRST_PRESETN_UART3			0x00040054
#define SRST_SRESETN_UART3			0x00040055
#define SRST_PRESETN_UART4			0x00040056
#define SRST_SRESETN_UART4			0x00040057
#define SRST_PRESETN_UART5			0x00040058
#define SRST_SRESETN_UART5			0x00040059
#define SRST_PRESETN_UART6			0x0004005A
#define SRST_SRESETN_UART6			0x0004005B
#define SRST_PRESETN_UART7			0x0004005C
#define SRST_SRESETN_UART7			0x0004005D

// BUSCRU_SOFTRST_CON06(Offset:0xA18)
#define SRST_PRESETN_TSADC			0x00040060
#define SRST_RESETN_TSADC			0x00040061
#define SRST_HRESETN_SAI0			0x00040062
#define SRST_MRESETN_SAI0			0x00040063
#define SRST_HRESETN_SAI1			0x00040064
#define SRST_MRESETN_SAI1			0x00040065
#define SRST_HRESETN_SAI2			0x00040066
#define SRST_MRESETN_SAI2			0x00040067
#define SRST_HRESETN_RKDSM			0x00040068
#define SRST_MRESETN_RKDSM			0x00040069
#define SRST_HRESETN_PDM			0x0004006A
#define SRST_MRESETN_PDM			0x0004006B
#define SRST_RESETN_PDM				0x0004006C

// BUSCRU_SOFTRST_CON07(Offset:0xA1C)
#define SRST_HRESETN_ASRC0			0x00040070
#define SRST_RESETN_ASRC0			0x00040071
#define SRST_HRESETN_ASRC1			0x00040072
#define SRST_RESETN_ASRC1			0x00040073
#define SRST_PRESETN_AUDIO_ADC_BUS		0x00040074
#define SRST_MRESETN_AUDIO_ADC_BUS		0x00040075
#define SRST_PRESETN_RKCE			0x00040076
#define SRST_HRESETN_NS_RKCE			0x00040077
#define SRST_PRESETN_OTPC_NS			0x00040078
#define SRST_RESETN_SBPI_OTPC_NS		0x00040079
#define SRST_RESETN_USER_OTPC_NS		0x0004007A
#define SRST_RESETN_OTPC_ARB			0x0004007B
#define SRST_PRESETN_OTP_MASK			0x0004007C
#define SRST_RESETN_TSADC_PHYCTRL		0x0004007E

// ======================= PERICRU module definition bank=2 =======================
// PERICRU_SOFTRST_CON00(Offset:0xA00)
#define SRST_ARESETN_PERI_BIU			0x00080000
#define SRST_PRESETN_PERI_BIU			0x00080001
#define SRST_PRESETN_RTC_BIU			0x00080002
#define SRST_PRESETN_CRU_PERI			0x00080003
#define SRST_PRESETN_PERI_GRF			0x00080004
#define SRST_PRESETN_GPIO1			0x00080005
#define SRST_DBRESETN_GPIO1			0x00080006
#define SRST_PRESETN_IOC_VCCIO1			0x00080007
#define SRST_ARESETN_USB3OTG			0x00080008
#define SRST_HRESETN_USB2HOST			0x0008000B
#define SRST_HRESETN_ARB_USB2HOST		0x0008000C
#define SRST_PRESETN_RTC_TEST			0x0008000D

// PERICRU_SOFTRST_CON01(Offset:0xA04)
#define SRST_HRESETN_EMMC			0x00080010
#define SRST_HRESETN_FSPI0			0x00080011
#define SRST_HRESETN_XIP_FSPI0			0x00080012
#define SRST_SRESETN_2X_FSPI0			0x00080013
#define SRST_RESETN_UTMI_USB2HOST		0x00080015
#define SRST_RESETN_REF_PIPEPHY			0x00080017
#define SRST_PRESETN_PIPEPHY			0x00080018
#define SRST_PRESETN_PIPEPHY_GRF		0x00080019
#define SRST_PRESETN_USB2PHY			0x0008001A
#define SRST_RESETN_POR_USB2PHY			0x0008001B
#define SRST_RESETN_OTG_USB2PHY			0x0008001C
#define SRST_RESETN_HOST_USB2PHY		0x0008001D

// ======================= CORECRU module definition bank=3 =======================
// CORECRU_SOFTRST_CON00(Offset:0xA00)
#define SRST_RESETN_REF_PVTPLL_CORE		0x000C0000
#define SRST_NCOREPORESET0			0x000C0001
#define SRST_NCORESET0				0x000C0002
#define SRST_NCOREPORESET1			0x000C0003
#define SRST_NCORESET1				0x000C0004
#define SRST_NCOREPORESET2			0x000c0005
#define SRST_NCORESET2				0x000C0006
#define SRST_NCOREPORESET3			0x000C0007
#define SRST_NCORESET3				0x000C0008
#define SRST_NDBGRESET				0x000C0009
#define SRST_NL2RESET				0x000C000A

// CORECRU_SOFTRST_CON01(Offset:0xA04)
#define SRST_ARESETN_CORE_BIU			0x000C0010
#define SRST_PRESETN_CORE_BIU			0x000C0011
#define SRST_HRESETN_CORE_BIU			0x000C0012
#define SRST_PRESETN_DBG			0x000C0013
#define SRST_POTRESETN_DBG			0x000C0014
#define SRST_NTRESETN_DBG			0x000C0015
#define SRST_PRESETN_CORE_PVTPLL		0x000C0016
#define SRST_PRESETN_CRU_CORE			0x000C0017
#define SRST_PRESETN_CORE_GRF			0x000C0018
#define SRST_PRESETN_DFT2APB			0x000C001A

// ======================= PMUCRU module definition bank=4 ========================
// PMUCRU_SOFTRST_CON00(Offset:0xA00)
#define SRST_HRESETN_PMU_BIU			0x00100000
#define SRST_PRESETN_PMU_GPIO0			0x00100007
#define SRST_DBRESETN_PMU_GPIO0			0x00100008
#define SRST_PRESETN_PMU_HP_TIMER		0x0010000A
#define SRST_RESETN_PMU_HP_TIMER		0x0010000B
#define SRST_RESETN_PMU_32K_HP_TIMER		0x0010000C

// PMUCRU_SOFTRST_CON01(Offset:0xA04)
#define SRST_PRESETN_PWM1			0x00100010
#define SRST_RESETN_PWM1			0x00100011
#define SRST_PRESETN_I2C2			0x00100012
#define SRST_RESETN_I2C2			0x00100013
#define SRST_PRESETN_UART0			0x00100014
#define SRST_SRESETN_UART0			0x00100015

// PMUCRU_SOFTRST_CON02(Offset:0xA08)
#define SRST_PRESETN_RCOSC_CTRL			0x00100020
#define SRST_RESETN_REF_RCOSC_CTRL		0x00100022
#define SRST_PRESETN_IOC_PMUIO0			0x00100023
#define SRST_PRESETN_CRU_PMU			0x00100024
#define SRST_PRESETN_PMU_GRF			0x00100025
#define SRST_RESETN_PREROLL			0x00100027
#define SRST_RESETN_PREROLL_32K			0x00100028
#define SRST_HRESETN_PMU_SRAM			0x00100029

// PMUCRU_SOFTRST_CON03(Offset:0xA0C)
#define SRST_PRESETN_WDT_LPMCU			0x00100030
#define SRST_TRESETN_WDT_LPMCU			0x00100031
#define SRST_RESETN_LPMCU_FULL_CLUSTER		0x00100032
#define SRST_RESETN_LPMCU_PWUP			0x00100033
#define SRST_RESETN_LPMCU_ONLY_CORE		0x00100034
#define SRST_TRESETN_LPMCU_JTAG			0x00100035
#define SRST_PRESETN_LPMCU_MAILBOX		0x00100036

// ======================= PMU1CRU module definition bank=5 =======================
// PMU1CRU_SOFTRST_CON00(Offset:0xA00)
#define SRST_PRESETN_SPI2AHB			0x00140000
#define SRST_HRESETN_SPI2AHB			0x00140001
#define SRST_HRESETN_FSPI1			0x00140002
#define SRST_HRESETN_XIP_FSPI1			0x00140003
#define SRST_SRESETN_1X_FSPI1			0x00140004
#define SRST_PRESETN_IOC_PMUIO1			0x00140005
#define SRST_PRESETN_CRU_PMU1			0x00140006
#define SRST_PRESETN_AUDIO_ADC_PMU		0x00140007
#define SRST_MRESETN_AUDIO_ADC_PMU		0x00140008
#define SRST_HRESETN_PMU1_BIU			0x00140009

// PMU1CRU_SOFTRST_CON01(Offset:0xA04)
#define SRST_PRESETN_LPDMA			0x00140010
#define SRST_ARESETN_LPDMA			0x00140011
#define SRST_HRESETN_LPSAI			0x00140012
#define SRST_MRESETN_LPSAI			0x00140013
#define SRST_PRESETN_AOA_TDD			0x00140014
#define SRST_PRESETN_AOA_FE			0x00140015
#define SRST_PRESETN_AOA_AAD			0x00140016
#define SRST_PRESETN_AOA_APB			0x00140017
#define SRST_PRESETN_AOA_SRAM			0x00140018

// ======================= DDRCRU module definition bank=6 ========================
// DDRCRU_SOFTRST_CON00(Offset:0xA00)
#define SRST_PRESETN_DDR_BIU			0x00180001
#define SRST_PRESETN_DDRC			0x00180002
#define SRST_PRESETN_DDRMON			0x00180003
#define SRST_RESETN_TIMER_DDRMON		0x00180004
#define SRST_PRESETN_DFICTRL			0x00180005
#define SRST_PRESETN_DDR_GRF			0x00180006
#define SRST_PRESETN_CRU_DDR			0x00180007
#define SRST_PRESETN_DDRPHY			0x00180008
#define SRST_PRESETN_DMA2DDR			0x00180009

// ====================== SUBDDRCRU module definition bank=7 ======================
// SUBDDRCRU_SOFTRST_CON00(Offset:0xA00)
#define SRST_ARESETN_SYSMEM_BIU			0x001A0000
#define SRST_ARESETN_SYSMEM			0x001A0001
#define SRST_ARESETN_DDR_BIU			0x001A0002
#define SRST_ARESETN_DDRSCH0_CPU		0x001A0003
#define SRST_ARESETN_DDRSCH1_NPU		0x001A0004
#define SRST_ARESETN_DDRSCH2_POE		0x001A0005
#define SRST_ARESETN_DDRSCH3_VI			0x001A0006
#define SRST_RESETN_CORE_DDRC			0x001A0007
#define SRST_RESETN_DDRMON			0x001A0008
#define SRST_RESETN_DFICTRL			0x001A0009
#define SRST_RESETN_RS				0x001A000B
#define SRST_ARESETN_DMA2DDR			0x001A000C
#define SRST_RESETN_DDRPHY			0x001A000D

// ======================== VICRU module definition bank=8 ========================
// VICRU_SOFTRST_CON00(Offset:0xA00)
#define SRST_RESETN_REF_PVTPLL_ISP		0x001C0000
#define SRST_ARESETN_GMAC_BIU			0x001C0001
#define SRST_ARESETN_VI_BIU			0x001C0002
#define SRST_HRESETN_VI_BIU			0x001C0003
#define SRST_PRESETN_VI_BIU			0x001C0004
#define SRST_PRESETN_CRU_VI			0x001C0005
#define SRST_PRESETN_VI_GRF			0x001C0006
#define SRST_PRESETN_VI_PVTPLL			0x001C0007
#define SRST_PRESETN_DSMC			0x001C0008
#define SRST_ARESETN_DSMC			0x001C0009
#define SRST_HRESETN_CAN0			0x001C000A
#define SRST_RESETN_CAN0			0x001C000B
#define SRST_HRESETN_CAN1			0x001C000C
#define SRST_RESETN_CAN1			0x001C000D

// VICRU_SOFTRST_CON01(Offset:0xA04)
#define SRST_PRESETN_GPIO2			0x001C0010
#define SRST_DBRESETN_GPIO2			0x001C0011
#define SRST_PRESETN_GPIO4			0x001C0012
#define SRST_DBRESETN_GPIO4			0x001C0013
#define SRST_PRESETN_GPIO5			0x001C0014
#define SRST_DBRESETN_GPIO5			0x001C0015
#define SRST_PRESETN_GPIO6			0x001C0016
#define SRST_DBRESETN_GPIO6			0x001C0017
#define SRST_PRESETN_GPIO7			0x001C0018
#define SRST_DBRESETN_GPIO7			0x001C0019
#define SRST_PRESETN_IOC_VCCIO2			0x001C001A
#define SRST_PRESETN_IOC_VCCIO4			0x001C001B
#define SRST_PRESETN_IOC_VCCIO5			0x001C001C
#define SRST_PRESETN_IOC_VCCIO6			0x001C001D
#define SRST_PRESETN_IOC_VCCIO7			0x001C001E

// VICRU_SOFTRST_CON02(Offset:0xA08)
#define SRST_RESETN_CORE_ISP			0x001C0020
#define SRST_HRESETN_VICAP			0x001C0021
#define SRST_ARESETN_VICAP			0x001C0022
#define SRST_DRESETN_VICAP			0x001C0023
#define SRST_ISP0RESETN_VICAP			0x001C0024
#define SRST_RESETN_CORE_VPSS			0x001C0025
#define SRST_RESETN_CORE_VPSL			0x001C0026
#define SRST_PRESETN_CSI2HOST0			0x001C0027
#define SRST_PRESETN_CSI2HOST1			0x001C0028
#define SRST_PRESETN_CSI2HOST2			0x001C0029
#define SRST_PRESETN_CSI2HOST3			0x001C002A
#define SRST_HRESETN_SDMMC0			0x001C002B
#define SRST_ARESETN_GMAC			0x001C002C
#define SRST_PRESETN_CSIPHY0			0x001C002D
#define SRST_PRESETN_CSIPHY1			0x001C002E

// VICRU_SOFTRST_CON03(Offset:0xA0C)
#define SRST_PRESETN_MACPHY			0x001C0030
#define SRST_RESETN_MACPHY			0x001C0031
#define SRST_PRESETN_SARADC1			0x001C0032
#define SRST_RESETN_SARADC1			0x001C0033
#define SRST_RESETN_SARADC1_PHY			0x001C0034
#define SRST_PRESETN_SARADC2			0x001C0035
#define SRST_RESETN_SARADC2			0x001C0036
#define SRST_RESETN_SARADC2_PHY			0x001C0037

// ======================= VEPUCRU module definition bank=9 =======================
// VEPUCRU_SOFTRST_CON00(Offset:0xA00)
#define SRST_RESETN_REF_PVTPLL_VEPU		0x00200000
#define SRST_ARESETN_VEPU_BIU			0x00200001
#define SRST_HRESETN_VEPU_BIU			0x00200002
#define SRST_PRESETN_VEPU_BIU			0x00200003
#define SRST_PRESETN_CRU_VEPU			0x00200004
#define SRST_PRESETN_VEPU_GRF			0x00200005
#define SRST_PRESETN_GPIO3			0x00200007
#define SRST_DBRESETN_GPIO3			0x00200008
#define SRST_PRESETN_IOC_VCCIO3			0x00200009
#define SRST_PRESETN_SARADC0			0x0020000A
#define SRST_RESETN_SARADC0			0x0020000B
#define SRST_RESETN_SARADC0_PHY			0x0020000C
#define SRST_HRESETN_SDMMC1			0x0020000D

// VEPUCRU_SOFTRST_CON01(Offset:0xA04)
#define SRST_PRESETN_VEPU_PVTPLL		0x00200010
#define SRST_HRESETN_VEPU			0x00200011
#define SRST_ARESETN_VEPU			0x00200012
#define SRST_RESETN_CORE_VEPU			0x00200013

// ======================= NPUCRU module definition bank=10 =======================
// NPUCRU_SOFTRST_CON00(Offset:0xA00)
#define SRST_RESETN_REF_PVTPLL_NPU		0x00240000
#define SRST_ARESETN_NPU_BIU			0x00240002
#define SRST_HRESETN_NPU_BIU			0x00240003
#define SRST_PRESETN_NPU_BIU			0x00240004
#define SRST_PRESETN_CRU_NPU			0x00240005
#define SRST_PRESETN_NPU_GRF			0x00240006
#define SRST_PRESETN_NPU_PVTPLL			0x00240008
#define SRST_HRESETN_RKNN			0x00240009
#define SRST_ARESETN_RKNN			0x0024000A

// ======================= VDOCRU module definition bank=11 =======================
// VDOCRU_SOFTRST_CON00(Offset:0xA00)
#define SRST_ARESETN_RKVDEC_BIU			0x00280000
#define SRST_ARESETN_VDO_BIU			0x00280001
#define SRST_HRESETN_VDO_BIU			0x00280003
#define SRST_PRESETN_VDO_BIU			0x00280004
#define SRST_PRESETN_CRU_VDO			0x00280005
#define SRST_PRESETN_VDO_GRF			0x00280006
#define SRST_ARESETN_RKVDEC			0x00280007
#define SRST_HRESETN_RKVDEC			0x00280008
#define SRST_RESETN_HEVC_CA_RKVDEC		0x00280009
#define SRST_ARESETN_VOP			0x0028000A
#define SRST_HRESETN_VOP			0x0028000B
#define SRST_DRESETN_VOP			0x0028000C
#define SRST_ARESETN_OOC			0x0028000D
#define SRST_HRESETN_OOC			0x0028000E
#define SRST_DRESETN_OOC			0x0028000F

// VDOCRU_SOFTRST_CON01(Offset:0xA04)
#define SRST_HRESETN_RKJPEG			0x00280013
#define SRST_ARESETN_RKJPEG			0x00280014
#define SRST_ARESETN_RKMMU_DECOM		0x00280015
#define SRST_HRESETN_RKMMU_DECOM		0x00280016
#define SRST_DRESETN_DECOM			0x00280018
#define SRST_ARESETN_DECOM			0x00280019
#define SRST_PRESETN_DECOM			0x0028001A
#define SRST_PRESETN_MIPI_DSI			0x0028001C
#define SRST_PRESETN_DSIPHY			0x0028001D

// ======================= VCPCRU module definition bank=12 =======================
// VCPCRU_SOFTRST_CON00(Offset:0xA00)
#define SRST_RESETN_REF_PVTPLL_VCP		0x002C0000
#define SRST_ARESETN_VCP_BIU			0x002C0001
#define SRST_HRESETN_VCP_BIU			0x002C0002
#define SRST_PRESETN_VCP_BIU			0x002C0003
#define SRST_PRESETN_CRU_VCP			0x002C0004
#define SRST_PRESETN_VCP_GRF			0x002C0005
#define SRST_PRESETN_VCP_PVTPLL			0x002C0007
#define SRST_ARESETN_AISP_BIU			0x002C0008
#define SRST_HRESETN_AISP_BIU			0x002C0009
#define SRST_ARESETN_AISPMEM_BIU		0x002C000A
#define SRST_RESETN_CORE_AISP			0x002C000D
#define SRST_ARESETN_AISPMEM			0x002C000E

// VCPCRU_SOFTRST_CON01(Offset:0xA04)
#define SRST_HRESETN_FEC			0x002C0010
#define SRST_ARESETN_FEC			0x002C0011
#define SRST_RESETN_CORE_FEC			0x002C0012
#define SRST_HRESETN_AVSP			0x002C0013
#define SRST_ARESETN_AVSP			0x002C0014

#define CLK_NR_SRST				(SRST_ARESETN_AVSP + 1)

#endif
