/* SPDX-License-Identifier: GPL-2.0-only */
/*
 * Copyright (c) 2015-2016 MediaTek Inc.
 * Author: Yong Wu <yong.wu@mediatek.com>
 */
#ifndef MTK_IOMMU_SMI_H
#define MTK_IOMMU_SMI_H

#include <linux/bitops.h>
#include <linux/device.h>

#if IS_ENABLED(CONFIG_MTK_SMI)

enum iommu_atf_cmd {
	IOMMU_ATF_CMD_CONFIG_SMI_LARB,		/* For mm master to en/disable iommu */
	IOMMU_ATF_CMD_CONFIG_INFRA_IOMMU,	/* For infra master to enable iommu */
	IOMMU_ATF_CMD_SECURE_IOMMU_STATUS,	/* For secure iommu translation fault report */
	IOMMU_ATF_CMD_SECURE_IOMMU_SUSPEND,	/* For secure iommu registers back up */
	IOMMU_ATF_CMD_SECURE_IOMMU_RESUME,	/* For secure iommu registers restore */
	IOMMU_ATF_CMD_MAX,
};

#define MTK_SMI_MMU_EN(port)	BIT(port)

struct mtk_smi_larb_iommu {
	struct device *dev;
	unsigned int   mmu;
	unsigned char  bank[32];
};

#endif


/* mtk_smi_larb_clamp() - Lock larb device to prevent the glitch from
 * the master warm SW reset
 *
 * @larbdev	pointer of larb device
 * @on	1: lock the larb device; 0: unlock the larb device
 *
 * In order to avoid the abnormal SMI bus status which is generated by the
 * glitch from the master warm SW reset, parent SMI of SMI larb should be
 * protected by clamp temporarily.
 * This solution is required by ISP7.
 *
 * .. note::
 * It is allowed to add the smi-sub-comm attribute of larb in DTS to call
 * this function. However, using this function with other devices is not
 * recommended. The function should to be used in pairs. If the larb device
 * is locked, the EMI command will be ignored.
 */
void mtk_smi_larb_clamp(struct device *larbdev, bool on);

#endif
