/* SPDX-License-Identifier: GPL-2.0 */
/*
 * Copyright (c) 2020 MediaTek Inc.
 */

#ifndef __MFD_MT6357_REGISTERS_H__
#define __MFD_MT6357_REGISTERS_H__

/* PMIC Registers */
#define MT6357_TOP0_ID                       0x0
#define MT6357_TOP0_REV0                     0x2
#define MT6357_TOP0_DSN_DBI                  0x4
#define MT6357_TOP0_DSN_DXI                  0x6
#define MT6357_HWCID                         0x8
#define MT6357_SWCID                         0xa
#define MT6357_PONSTS                        0xc
#define MT6357_POFFSTS                       0xe
#define MT6357_PSTSCTL                       0x10
#define MT6357_PG_DEB_STS0                   0x12
#define MT6357_PG_SDN_STS0                   0x14
#define MT6357_OC_SDN_STS0                   0x16
#define MT6357_THERMALSTATUS                 0x18
#define MT6357_TOP_CON                       0x1a
#define MT6357_TEST_OUT                      0x1c
#define MT6357_TEST_CON0                     0x1e
#define MT6357_TEST_CON1                     0x20
#define MT6357_TESTMODE_SW                   0x22
#define MT6357_TOPSTATUS                     0x24
#define MT6357_TDSEL_CON                     0x26
#define MT6357_RDSEL_CON                     0x28
#define MT6357_SMT_CON0                      0x2a
#define MT6357_SMT_CON1                      0x2c
#define MT6357_TOP_RSV0                      0x2e
#define MT6357_TOP_RSV1                      0x30
#define MT6357_DRV_CON0                      0x32
#define MT6357_DRV_CON1                      0x34
#define MT6357_DRV_CON2                      0x36
#define MT6357_DRV_CON3                      0x38
#define MT6357_FILTER_CON0                   0x3a
#define MT6357_FILTER_CON1                   0x3c
#define MT6357_FILTER_CON2                   0x3e
#define MT6357_FILTER_CON3                   0x40
#define MT6357_TOP_STATUS                    0x42
#define MT6357_TOP_STATUS_SET                0x44
#define MT6357_TOP_STATUS_CLR                0x46
#define MT6357_TOP_TRAP                      0x48
#define MT6357_TOP1_ID                       0x80
#define MT6357_TOP1_REV0                     0x82
#define MT6357_TOP1_DSN_DBI                  0x84
#define MT6357_TOP1_DSN_DXI                  0x86
#define MT6357_GPIO_DIR0                     0x88
#define MT6357_GPIO_DIR0_SET                 0x8a
#define MT6357_GPIO_DIR0_CLR                 0x8c
#define MT6357_GPIO_PULLEN0                  0x8e
#define MT6357_GPIO_PULLEN0_SET              0x90
#define MT6357_GPIO_PULLEN0_CLR              0x92
#define MT6357_GPIO_PULLSEL0                 0x94
#define MT6357_GPIO_PULLSEL0_SET             0x96
#define MT6357_GPIO_PULLSEL0_CLR             0x98
#define MT6357_GPIO_DINV0                    0x9a
#define MT6357_GPIO_DINV0_SET                0x9c
#define MT6357_GPIO_DINV0_CLR                0x9e
#define MT6357_GPIO_DOUT0                    0xa0
#define MT6357_GPIO_DOUT0_SET                0xa2
#define MT6357_GPIO_DOUT0_CLR                0xa4
#define MT6357_GPIO_PI0                      0xa6
#define MT6357_GPIO_POE0                     0xa8
#define MT6357_GPIO_MODE0                    0xaa
#define MT6357_GPIO_MODE0_SET                0xac
#define MT6357_GPIO_MODE0_CLR                0xae
#define MT6357_GPIO_MODE1                    0xb0
#define MT6357_GPIO_MODE1_SET                0xb2
#define MT6357_GPIO_MODE1_CLR                0xb4
#define MT6357_GPIO_MODE2                    0xb6
#define MT6357_GPIO_MODE2_SET                0xb8
#define MT6357_GPIO_MODE2_CLR                0xba
#define MT6357_GPIO_MODE3                    0xbc
#define MT6357_GPIO_MODE3_SET                0xbe
#define MT6357_GPIO_MODE3_CLR                0xc0
#define MT6357_GPIO_RSV                      0xc2
#define MT6357_TOP2_ID                       0x100
#define MT6357_TOP2_REV0                     0x102
#define MT6357_TOP2_DSN_DBI                  0x104
#define MT6357_TOP2_DSN_DXI                  0x106
#define MT6357_TOP_PAM0                      0x108
#define MT6357_TOP_PAM1                      0x10a
#define MT6357_TOP_CKPDN_CON0                0x10c
#define MT6357_TOP_CKPDN_CON0_SET            0x10e
#define MT6357_TOP_CKPDN_CON0_CLR            0x110
#define MT6357_TOP_CKPDN_CON1                0x112
#define MT6357_TOP_CKPDN_CON1_SET            0x114
#define MT6357_TOP_CKPDN_CON1_CLR            0x116
#define MT6357_TOP_CKSEL_CON0                0x118
#define MT6357_TOP_CKSEL_CON0_SET            0x11a
#define MT6357_TOP_CKSEL_CON0_CLR            0x11c
#define MT6357_TOP_CKSEL_CON1                0x11e
#define MT6357_TOP_CKSEL_CON1_SET            0x120
#define MT6357_TOP_CKSEL_CON1_CLR            0x122
#define MT6357_TOP_CKDIVSEL_CON0             0x124
#define MT6357_TOP_CKDIVSEL_CON0_SET         0x126
#define MT6357_TOP_CKDIVSEL_CON0_CLR         0x128
#define MT6357_TOP_CKHWEN_CON0               0x12a
#define MT6357_TOP_CKHWEN_CON0_SET           0x12c
#define MT6357_TOP_CKHWEN_CON0_CLR           0x12e
#define MT6357_TOP_CKTST_CON0                0x130
#define MT6357_TOP_CKTST_CON1                0x132
#define MT6357_TOP_CLK_CON0                  0x134
#define MT6357_TOP_CLK_CON0_SET              0x136
#define MT6357_TOP_CLK_CON0_CLR              0x138
#define MT6357_TOP_DCM_CON0                  0x13a
#define MT6357_TOP_HANDOVER_DEBUG0           0x13c
#define MT6357_TOP_RST_CON0                  0x13e
#define MT6357_TOP_RST_CON0_SET              0x140
#define MT6357_TOP_RST_CON0_CLR              0x142
#define MT6357_TOP_RST_CON1                  0x144
#define MT6357_TOP_RST_CON1_SET              0x146
#define MT6357_TOP_RST_CON1_CLR              0x148
#define MT6357_TOP_RST_CON2                  0x14a
#define MT6357_TOP_RST_MISC                  0x14c
#define MT6357_TOP_RST_MISC_SET              0x14e
#define MT6357_TOP_RST_MISC_CLR              0x150
#define MT6357_TOP_RST_STATUS                0x152
#define MT6357_TOP_RST_STATUS_SET            0x154
#define MT6357_TOP_RST_STATUS_CLR            0x156
#define MT6357_TOP2_ELR_NUM                  0x158
#define MT6357_TOP2_ELR0                     0x15a
#define MT6357_TOP2_ELR1                     0x15c
#define MT6357_TOP3_ID                       0x180
#define MT6357_TOP3_REV0                     0x182
#define MT6357_TOP3_DSN_DBI                  0x184
#define MT6357_TOP3_DSN_DXI                  0x186
#define MT6357_MISC_TOP_INT_CON0             0x188
#define MT6357_MISC_TOP_INT_CON0_SET         0x18a
#define MT6357_MISC_TOP_INT_CON0_CLR         0x18c
#define MT6357_MISC_TOP_INT_MASK_CON0        0x18e
#define MT6357_MISC_TOP_INT_MASK_CON0_SET    0x190
#define MT6357_MISC_TOP_INT_MASK_CON0_CLR    0x192
#define MT6357_MISC_TOP_INT_STATUS0          0x194
#define MT6357_MISC_TOP_INT_RAW_STATUS0      0x196
#define MT6357_TOP_INT_MASK_CON0             0x198
#define MT6357_TOP_INT_MASK_CON0_SET         0x19a
#define MT6357_TOP_INT_MASK_CON0_CLR         0x19c
#define MT6357_TOP_INT_STATUS0               0x19e
#define MT6357_TOP_INT_RAW_STATUS0           0x1a0
#define MT6357_TOP_INT_CON0                  0x1a2
#define MT6357_PLT0_ID                       0x380
#define MT6357_PLT0_REV0                     0x382
#define MT6357_PLT0_REV1                     0x384
#define MT6357_PLT0_DSN_DXI                  0x386
#define MT6357_FQMTR_CON0                    0x388
#define MT6357_FQMTR_CON1                    0x38a
#define MT6357_FQMTR_CON2                    0x38c
#define MT6357_TOP_CLK_TRIM                  0x38e
#define MT6357_OTP_CON0                      0x390
#define MT6357_OTP_CON1                      0x392
#define MT6357_OTP_CON2                      0x394
#define MT6357_OTP_CON3                      0x396
#define MT6357_OTP_CON4                      0x398
#define MT6357_OTP_CON5                      0x39a
#define MT6357_OTP_CON6                      0x39c
#define MT6357_OTP_CON7                      0x39e
#define MT6357_OTP_CON8                      0x3a0
#define MT6357_OTP_CON9                      0x3a2
#define MT6357_OTP_CON10                     0x3a4
#define MT6357_OTP_CON11                     0x3a6
#define MT6357_OTP_CON12                     0x3a8
#define MT6357_OTP_CON13                     0x3aa
#define MT6357_OTP_CON14                     0x3ac
#define MT6357_TOP_TMA_KEY                   0x3ae
#define MT6357_TOP_MDB_CONF0                 0x3b0
#define MT6357_TOP_MDB_CONF1                 0x3b2
#define MT6357_TOP_MDB_CONF2                 0x3b4
#define MT6357_PLT0_ELR_NUM                  0x3b6
#define MT6357_PLT0_ELR0                     0x3b8
#define MT6357_PLT0_ELR1                     0x3ba
#define MT6357_SPISLV_ID                     0x400
#define MT6357_SPISLV_REV0                   0x402
#define MT6357_SPISLV_REV1                   0x404
#define MT6357_SPISLV_DSN_DXI                0x406
#define MT6357_RG_SPI_CON0                   0x408
#define MT6357_DEW_DIO_EN                    0x40a
#define MT6357_DEW_READ_TEST                 0x40c
#define MT6357_DEW_WRITE_TEST                0x40e
#define MT6357_DEW_CRC_SWRST                 0x410
#define MT6357_DEW_CRC_EN                    0x412
#define MT6357_DEW_CRC_VAL                   0x414
#define MT6357_DEW_DBG_MON_SEL               0x416
#define MT6357_DEW_CIPHER_KEY_SEL            0x418
#define MT6357_DEW_CIPHER_IV_SEL             0x41a
#define MT6357_DEW_CIPHER_EN                 0x41c
#define MT6357_DEW_CIPHER_RDY                0x41e
#define MT6357_DEW_CIPHER_MODE               0x420
#define MT6357_DEW_CIPHER_SWRST              0x422
#define MT6357_DEW_RDDMY_NO                  0x424
#define MT6357_INT_TYPE_CON0                 0x426
#define MT6357_INT_TYPE_CON0_SET             0x428
#define MT6357_INT_TYPE_CON0_CLR             0x42a
#define MT6357_INT_STA                       0x42c
#define MT6357_RG_SPI_CON1                   0x42e
#define MT6357_RG_SPI_CON2                   0x430
#define MT6357_RG_SPI_CON3                   0x432
#define MT6357_RG_SPI_CON4                   0x434
#define MT6357_RG_SPI_CON5                   0x436
#define MT6357_RG_SPI_CON6                   0x438
#define MT6357_RG_SPI_CON7                   0x43a
#define MT6357_RG_SPI_CON8                   0x43c
#define MT6357_RG_SPI_CON9                   0x43e
#define MT6357_RG_SPI_CON10                  0x440
#define MT6357_RG_SPI_CON11                  0x442
#define MT6357_RG_SPI_CON12                  0x444
#define MT6357_RG_SPI_CON13                  0x446
#define MT6357_TOP_SPI_CON0                  0x448
#define MT6357_TOP_SPI_CON1                  0x44a
#define MT6357_SCK_TOP_DSN_ID                0x500
#define MT6357_SCK_TOP_DSN_REV0              0x502
#define MT6357_SCK_TOP_DBI                   0x504
#define MT6357_SCK_TOP_DXI                   0x506
#define MT6357_SCK_TOP_TPM0                  0x508
#define MT6357_SCK_TOP_TPM1                  0x50a
#define MT6357_SCK_TOP_CON0                  0x50c
#define MT6357_SCK_TOP_CON1                  0x50e
#define MT6357_SCK_TOP_TEST_OUT              0x510
#define MT6357_SCK_TOP_TEST_CON0             0x512
#define MT6357_SCK_TOP_CKPDN_CON0            0x514
#define MT6357_SCK_TOP_CKPDN_CON0_SET        0x516
#define MT6357_SCK_TOP_CKPDN_CON0_CLR        0x518
#define MT6357_SCK_TOP_CKHWEN_CON0           0x51a
#define MT6357_SCK_TOP_CKHWEN_CON0_SET       0x51c
#define MT6357_SCK_TOP_CKHWEN_CON0_CLR       0x51e
#define MT6357_SCK_TOP_CKTST_CON             0x520
#define MT6357_SCK_TOP_RST_CON0              0x522
#define MT6357_SCK_TOP_RST_CON0_SET          0x524
#define MT6357_SCK_TOP_RST_CON0_CLR          0x526
#define MT6357_SCK_TOP_INT_CON0              0x528
#define MT6357_SCK_TOP_INT_CON0_SET          0x52a
#define MT6357_SCK_TOP_INT_CON0_CLR          0x52c
#define MT6357_SCK_TOP_INT_MASK_CON0         0x52e
#define MT6357_SCK_TOP_INT_MASK_CON0_SET     0x530
#define MT6357_SCK_TOP_INT_MASK_CON0_CLR     0x532
#define MT6357_SCK_TOP_INT_STATUS0           0x534
#define MT6357_SCK_TOP_INT_RAW_STATUS0       0x536
#define MT6357_SCK_TOP_INT_MISC_CON          0x538
#define MT6357_EOSC_CALI_CON0                0x53a
#define MT6357_EOSC_CALI_CON1                0x53c
#define MT6357_RTC_MIX_CON0                  0x53e
#define MT6357_RTC_MIX_CON1                  0x540
#define MT6357_RTC_MIX_CON2                  0x542
#define MT6357_RTC_DSN_ID                    0x580
#define MT6357_RTC_DSN_REV0                  0x582
#define MT6357_RTC_DBI                       0x584
#define MT6357_RTC_DXI                       0x586
#define MT6357_RTC_BBPU                      0x588
#define MT6357_RTC_IRQ_STA                   0x58a
#define MT6357_RTC_IRQ_EN                    0x58c
#define MT6357_RTC_CII_EN                    0x58e
#define MT6357_RTC_AL_MASK                   0x590
#define MT6357_RTC_TC_SEC                    0x592
#define MT6357_RTC_TC_MIN                    0x594
#define MT6357_RTC_TC_HOU                    0x596
#define MT6357_RTC_TC_DOM                    0x598
#define MT6357_RTC_TC_DOW                    0x59a
#define MT6357_RTC_TC_MTH                    0x59c
#define MT6357_RTC_TC_YEA                    0x59e
#define MT6357_RTC_AL_SEC                    0x5a0
#define MT6357_RTC_AL_MIN                    0x5a2
#define MT6357_RTC_AL_HOU                    0x5a4
#define MT6357_RTC_AL_DOM                    0x5a6
#define MT6357_RTC_AL_DOW                    0x5a8
#define MT6357_RTC_AL_MTH                    0x5aa
#define MT6357_RTC_AL_YEA                    0x5ac
#define MT6357_RTC_OSC32CON                  0x5ae
#define MT6357_RTC_POWERKEY1                 0x5b0
#define MT6357_RTC_POWERKEY2                 0x5b2
#define MT6357_RTC_PDN1                      0x5b4
#define MT6357_RTC_PDN2                      0x5b6
#define MT6357_RTC_SPAR0                     0x5b8
#define MT6357_RTC_SPAR1                     0x5ba
#define MT6357_RTC_PROT                      0x5bc
#define MT6357_RTC_DIFF                      0x5be
#define MT6357_RTC_CALI                      0x5c0
#define MT6357_RTC_WRTGR                     0x5c2
#define MT6357_RTC_CON                       0x5c4
#define MT6357_RTC_SEC_CTRL                  0x5c6
#define MT6357_RTC_INT_CNT                   0x5c8
#define MT6357_RTC_SEC_DAT0                  0x5ca
#define MT6357_RTC_SEC_DAT1                  0x5cc
#define MT6357_RTC_SEC_DAT2                  0x5ce
#define MT6357_RTC_SEC_DSN_ID                0x600
#define MT6357_RTC_SEC_DSN_REV0              0x602
#define MT6357_RTC_SEC_DBI                   0x604
#define MT6357_RTC_SEC_DXI                   0x606
#define MT6357_RTC_TC_SEC_SEC                0x608
#define MT6357_RTC_TC_MIN_SEC                0x60a
#define MT6357_RTC_TC_HOU_SEC                0x60c
#define MT6357_RTC_TC_DOM_SEC                0x60e
#define MT6357_RTC_TC_DOW_SEC                0x610
#define MT6357_RTC_TC_MTH_SEC                0x612
#define MT6357_RTC_TC_YEA_SEC                0x614
#define MT6357_RTC_SEC_CK_PDN                0x616
#define MT6357_RTC_SEC_WRTGR                 0x618
#define MT6357_DCXO_DSN_ID                   0x780
#define MT6357_DCXO_DSN_REV0                 0x782
#define MT6357_DCXO_DSN_DBI                  0x784
#define MT6357_DCXO_DSN_DXI                  0x786
#define MT6357_DCXO_CW00                     0x788
#define MT6357_DCXO_CW00_SET                 0x78a
#define MT6357_DCXO_CW00_CLR                 0x78c
#define MT6357_DCXO_CW01                     0x78e
#define MT6357_DCXO_CW02                     0x790
#define MT6357_DCXO_CW03                     0x792
#define MT6357_DCXO_CW04                     0x794
#define MT6357_DCXO_CW05                     0x796
#define MT6357_DCXO_CW06                     0x798
#define MT6357_DCXO_CW07                     0x79a
#define MT6357_DCXO_CW08                     0x79c
#define MT6357_DCXO_CW09                     0x79e
#define MT6357_DCXO_CW10                     0x7a0
#define MT6357_DCXO_CW11                     0x7a2
#define MT6357_DCXO_CW11_SET                 0x7a4
#define MT6357_DCXO_CW11_CLR                 0x7a6
#define MT6357_DCXO_CW12                     0x7a8
#define MT6357_DCXO_CW13                     0x7aa
#define MT6357_DCXO_CW14                     0x7ac
#define MT6357_DCXO_CW15                     0x7ae
#define MT6357_DCXO_CW16                     0x7b0
#define MT6357_DCXO_CW17                     0x7b2
#define MT6357_DCXO_CW18                     0x7b4
#define MT6357_DCXO_CW19                     0x7b6
#define MT6357_DCXO_CW20                     0x7b8
#define MT6357_DCXO_CW21                     0x7ba
#define MT6357_DCXO_CW22                     0x7bc
#define MT6357_DCXO_ELR_NUM                  0x7be
#define MT6357_DCXO_ELR0                     0x7c0
#define MT6357_PSC_TOP_ID                    0x900
#define MT6357_PSC_TOP_REV0                  0x902
#define MT6357_PSC_TOP_DBI                   0x904
#define MT6357_PSC_TOP_DXI                   0x906
#define MT6357_PSC_TPM0                      0x908
#define MT6357_PSC_TPM1                      0x90a
#define MT6357_PSC_TOP_RSTCTL_0              0x90c
#define MT6357_PSC_TOP_INT_CON0              0x90e
#define MT6357_PSC_TOP_INT_CON0_SET          0x910
#define MT6357_PSC_TOP_INT_CON0_CLR          0x912
#define MT6357_PSC_TOP_INT_MASK_CON0         0x914
#define MT6357_PSC_TOP_INT_MASK_CON0_SET     0x916
#define MT6357_PSC_TOP_INT_MASK_CON0_CLR     0x918
#define MT6357_PSC_TOP_INT_STATUS0           0x91a
#define MT6357_PSC_TOP_INT_RAW_STATUS0       0x91c
#define MT6357_PSC_TOP_INT_MISC_CON          0x91e
#define MT6357_PSC_TOP_INT_MISC_CON_SET      0x920
#define MT6357_PSC_TOP_INT_MISC_CON_CLR      0x922
#define MT6357_PSC_TOP_MON_CTL               0x924
#define MT6357_STRUP_ID                      0x980
#define MT6357_STRUP_REV0                    0x982
#define MT6357_STRUP_DBI                     0x984
#define MT6357_STRUP_DXI                     0x986
#define MT6357_STRUP_ANA_CON0                0x988
#define MT6357_STRUP_ANA_CON1                0x98a
#define MT6357_STRUP_ANA_CON2                0x98c
#define MT6357_STRUP_ELR_NUM                 0x98e
#define MT6357_STRUP_ELR_0                   0x990
#define MT6357_PSEQ_ID                       0xa00
#define MT6357_PSEQ_REV0                     0xa02
#define MT6357_PSEQ_DBI                      0xa04
#define MT6357_PSEQ_DXI                      0xa06
#define MT6357_PPCCTL0                       0xa08
#define MT6357_PPCCTL1                       0xa0a
#define MT6357_PPCCTL2                       0xa0c
#define MT6357_PPCCFG0                       0xa0e
#define MT6357_PPCTST0                       0xa10
#define MT6357_PORFLAG                       0xa12
#define MT6357_STRUP_CON0                    0xa14
#define MT6357_STRUP_CON1                    0xa16
#define MT6357_STRUP_CON2                    0xa18
#define MT6357_STRUP_CON3                    0xa1a
#define MT6357_STRUP_CON4                    0xa1c
#define MT6357_STRUP_CON5                    0xa1e
#define MT6357_STRUP_CON6                    0xa20
#define MT6357_STRUP_CON7                    0xa22
#define MT6357_CPSCFG0                       0xa24
#define MT6357_STRUP_CON9                    0xa26
#define MT6357_STRUP_CON10                   0xa28
#define MT6357_STRUP_CON11                   0xa2a
#define MT6357_STRUP_CON12                   0xa2c
#define MT6357_STRUP_CON13                   0xa2e
#define MT6357_STRUP_CON14                   0xa30
#define MT6357_STRUP_CON15                   0xa32
#define MT6357_STRUP_CON16                   0xa34
#define MT6357_STRUP_CON19                   0xa36
#define MT6357_PSEQ_ELR_NUM                  0xa38
#define MT6357_PSEQ_ELR7                     0xa3a
#define MT6357_PSEQ_ELR8                     0xa3c
#define MT6357_PCHR_DIG_DSN_ID               0xa80
#define MT6357_PCHR_DIG_DSN_REV0             0xa82
#define MT6357_PCHR_DIG_DSN_DBI              0xa84
#define MT6357_PCHR_DIG_DSN_DXI              0xa86
#define MT6357_CHR_TOP_CON0                  0xa88
#define MT6357_CHR_TOP_CON1                  0xa8a
#define MT6357_CHR_TOP_CON2                  0xa8c
#define MT6357_CHR_TOP_CON3                  0xa8e
#define MT6357_CHR_TOP_CON4                  0xa90
#define MT6357_CHR_TOP_CON5                  0xa92
#define MT6357_CHR_TOP_CON6                  0xa94
#define MT6357_PCHR_DIG_ELR_NUM              0xa96
#define MT6357_PCHR_ELR0                     0xa98
#define MT6357_PCHR_ELR1                     0xa9a
#define MT6357_PCHR_MACRO_DSN_ID             0xb80
#define MT6357_PCHR_MACRO_DSN_REV0           0xb82
#define MT6357_PCHR_MACRO_DSN_DBI            0xb84
#define MT6357_PCHR_MACRO_DSN_DXI            0xb86
#define MT6357_CHR_CON0                      0xb88
#define MT6357_CHR_CON1                      0xb8a
#define MT6357_CHR_CON2                      0xb8c
#define MT6357_CHR_CON3                      0xb8e
#define MT6357_CHR_CON4                      0xb90
#define MT6357_CHR_CON5                      0xb92
#define MT6357_CHR_CON6                      0xb94
#define MT6357_CHR_CON7                      0xb96
#define MT6357_CHR_CON8                      0xb98
#define MT6357_CHR_CON9                      0xb9a
#define MT6357_BM_TOP_DSN_ID                 0xc00
#define MT6357_BM_TOP_DSN_REV0               0xc02
#define MT6357_BM_TOP_DBI                    0xc04
#define MT6357_BM_TOP_DXI                    0xc06
#define MT6357_BM_TPM0                       0xc08
#define MT6357_BM_TPM1                       0xc0a
#define MT6357_BM_TOP_CKPDN_CON0             0xc0c
#define MT6357_BM_TOP_CKPDN_CON0_SET         0xc0e
#define MT6357_BM_TOP_CKPDN_CON0_CLR         0xc10
#define MT6357_BM_TOP_CKSEL_CON0             0xc12
#define MT6357_BM_TOP_CKSEL_CON0_SET         0xc14
#define MT6357_BM_TOP_CKSEL_CON0_CLR         0xc16
#define MT6357_BM_TOP_CKTST_CON0             0xc18
#define MT6357_BM_TOP_RST_CON0               0xc1a
#define MT6357_BM_TOP_RST_CON0_SET           0xc1c
#define MT6357_BM_TOP_RST_CON0_CLR           0xc1e
#define MT6357_BM_TOP_INT_CON0               0xc20
#define MT6357_BM_TOP_INT_CON0_SET           0xc22
#define MT6357_BM_TOP_INT_CON0_CLR           0xc24
#define MT6357_BM_TOP_INT_CON1               0xc26
#define MT6357_BM_TOP_INT_CON1_SET           0xc28
#define MT6357_BM_TOP_INT_CON1_CLR           0xc2a
#define MT6357_BM_TOP_INT_MASK_CON0          0xc2c
#define MT6357_BM_TOP_INT_MASK_CON0_SET      0xc2e
#define MT6357_BM_TOP_INT_MASK_CON0_CLR      0xc30
#define MT6357_BM_TOP_INT_MASK_CON1          0xc32
#define MT6357_BM_TOP_INT_MASK_CON1_SET      0xc34
#define MT6357_BM_TOP_INT_MASK_CON1_CLR      0xc36
#define MT6357_BM_TOP_INT_STATUS0            0xc38
#define MT6357_BM_TOP_INT_STATUS1            0xc3a
#define MT6357_BM_TOP_INT_RAW_STATUS0        0xc3c
#define MT6357_BM_TOP_INT_RAW_STATUS1        0xc3e
#define MT6357_BM_TOP_INT_MISC_CON           0xc40
#define MT6357_BM_TOP_DBG_CON                0xc42
#define MT6357_BM_TOP_RSV0                   0xc44
#define MT6357_FGADC_ANA_DSN_ID              0xc80
#define MT6357_FGADC_ANA_DSN_REV0            0xc82
#define MT6357_FGADC_ANA_DSN_DBI             0xc84
#define MT6357_FGADC_ANA_DSN_DXI             0xc86
#define MT6357_FGADC_ANA_CON0                0xc88
#define MT6357_FGADC_ANA_TEST_CON0           0xc8a
#define MT6357_FGADC_ANA_ELR_NUM             0xc8c
#define MT6357_FGADC_ANA_ELR0                0xc8e
#define MT6357_FGADC_ANA_ELR1                0xc90
#define MT6357_FGADC0_DSN_ID                 0xd00
#define MT6357_FGADC0_DSN_REV0               0xd02
#define MT6357_FGADC0_DSN_DBI                0xd04
#define MT6357_FGADC0_DSN_DXI                0xd06
#define MT6357_FGADC_CON0                    0xd08
#define MT6357_FGADC_CON1                    0xd0a
#define MT6357_FGADC_CON2                    0xd0c
#define MT6357_FGADC_CON3                    0xd0e
#define MT6357_FGADC_CON4                    0xd10
#define MT6357_FGADC_CAR_CON0                0xd12
#define MT6357_FGADC_CAR_CON1                0xd14
#define MT6357_FGADC_CAR_CON2                0xd16
#define MT6357_FGADC_CARTH_CON0              0xd18
#define MT6357_FGADC_CARTH_CON1              0xd1a
#define MT6357_FGADC_CARTH_CON2              0xd1c
#define MT6357_FGADC_CARTH_CON3              0xd1e
#define MT6357_FGADC_NTER_CON0               0xd20
#define MT6357_FGADC_NTER_CON1               0xd22
#define MT6357_FGADC_NTER_CON2               0xd24
#define MT6357_FGADC_SON_CON0                0xd26
#define MT6357_FGADC_SON_CON1                0xd28
#define MT6357_FGADC_SON_CON2                0xd2a
#define MT6357_FGADC_SON_CON3                0xd2c
#define MT6357_FGADC_ZCV_CON0                0xd2e
#define MT6357_FGADC_ZCV_CON1                0xd30
#define MT6357_FGADC_ZCV_CON2                0xd32
#define MT6357_FGADC_ZCV_CON3                0xd34
#define MT6357_FGADC_ZCV_CON4                0xd36
#define MT6357_FGADC_ZCVTH_CON0              0xd38
#define MT6357_FGADC_ZCVTH_CON1              0xd3a
#define MT6357_FGADC_ZCVTH_CON2              0xd3c
#define MT6357_FGADC1_DSN_ID                 0xd80
#define MT6357_FGADC1_DSN_REV0               0xd82
#define MT6357_FGADC1_DSN_DBI                0xd84
#define MT6357_FGADC1_DSN_DXI                0xd86
#define MT6357_FGADC_R_CON0                  0xd88
#define MT6357_FGADC_CUR_CON0                0xd8a
#define MT6357_FGADC_CUR_CON1                0xd8c
#define MT6357_FGADC_CUR_CON2                0xd8e
#define MT6357_FGADC_CUR_CON3                0xd90
#define MT6357_FGADC_OFFSET_CON0             0xd92
#define MT6357_FGADC_OFFSET_CON1             0xd94
#define MT6357_FGADC_GAIN_CON0               0xd96
#define MT6357_FGADC_TEST_CON0               0xd98
#define MT6357_SYSTEM_INFO_CON0              0xd9a
#define MT6357_SYSTEM_INFO_CON1              0xd9c
#define MT6357_SYSTEM_INFO_CON2              0xd9e
#define MT6357_SYSTEM_INFO_CON3              0xda0
#define MT6357_SYSTEM_INFO_CON4              0xda2
#define MT6357_BATON_ANA_DSN_ID              0xe00
#define MT6357_BATON_ANA_DSN_REV0            0xe02
#define MT6357_BATON_ANA_DSN_DBI             0xe04
#define MT6357_BATON_ANA_DSN_DXI             0xe06
#define MT6357_BATON_ANA_CON0                0xe08
#define MT6357_BATON_ANA_ELR_NUM             0xe0a
#define MT6357_BATON_ANA_ELR0                0xe0c
#define MT6357_HK_TOP_ID                     0xf80
#define MT6357_HK_TOP_REV0                   0xf82
#define MT6357_HK_TOP_DBI                    0xf84
#define MT6357_HK_TOP_DXI                    0xf86
#define MT6357_HK_TPM0                       0xf88
#define MT6357_HK_TPM1                       0xf8a
#define MT6357_HK_TOP_CLK_CON0               0xf8c
#define MT6357_HK_TOP_CLK_CON1               0xf8e
#define MT6357_HK_TOP_RST_CON0               0xf90
#define MT6357_HK_TOP_INT_CON0               0xf92
#define MT6357_HK_TOP_INT_CON0_SET           0xf94
#define MT6357_HK_TOP_INT_CON0_CLR           0xf96
#define MT6357_HK_TOP_INT_MASK_CON0          0xf98
#define MT6357_HK_TOP_INT_MASK_CON0_SET      0xf9a
#define MT6357_HK_TOP_INT_MASK_CON0_CLR      0xf9c
#define MT6357_HK_TOP_INT_STATUS0            0xf9e
#define MT6357_HK_TOP_INT_RAW_STATUS0        0xfa0
#define MT6357_HK_TOP_MON_CON0               0xfa2
#define MT6357_HK_TOP_MON_CON1               0xfa4
#define MT6357_HK_TOP_MON_CON2               0xfa6
#define MT6357_AUXADC_DSN_ID                 0x1000
#define MT6357_AUXADC_DSN_REV0               0x1002
#define MT6357_AUXADC_DSN_DBI                0x1004
#define MT6357_AUXADC_DSN_DXI                0x1006
#define MT6357_AUXADC_ANA_CON0               0x1008
#define MT6357_AUXADC_DIG_1_DSN_ID           0x1080
#define MT6357_AUXADC_DIG_1_DSN_REV0         0x1082
#define MT6357_AUXADC_DIG_1_DSN_DBI          0x1084
#define MT6357_AUXADC_DIG_1_DSN_DXI          0x1086
#define MT6357_AUXADC_ADC0                   0x1088
#define MT6357_AUXADC_ADC1                   0x108a
#define MT6357_AUXADC_ADC2                   0x108c
#define MT6357_AUXADC_ADC3                   0x108e
#define MT6357_AUXADC_ADC4                   0x1090
#define MT6357_AUXADC_ADC5                   0x1092
#define MT6357_AUXADC_ADC6                   0x1094
#define MT6357_AUXADC_ADC7                   0x1096
#define MT6357_AUXADC_ADC8                   0x1098
#define MT6357_AUXADC_ADC9                   0x109a
#define MT6357_AUXADC_ADC10                  0x109c
#define MT6357_AUXADC_ADC11                  0x109e
#define MT6357_AUXADC_ADC12                  0x10a0
#define MT6357_AUXADC_ADC14                  0x10a2
#define MT6357_AUXADC_ADC16                  0x10a4
#define MT6357_AUXADC_ADC17                  0x10a6
#define MT6357_AUXADC_ADC18                  0x10a8
#define MT6357_AUXADC_ADC19                  0x10aa
#define MT6357_AUXADC_ADC20                  0x10ac
#define MT6357_AUXADC_ADC21                  0x10ae
#define MT6357_AUXADC_ADC22                  0x10b0
#define MT6357_AUXADC_ADC23                  0x10b2
#define MT6357_AUXADC_ADC24                  0x10b4
#define MT6357_AUXADC_ADC25                  0x10b6
#define MT6357_AUXADC_ADC26                  0x10b8
#define MT6357_AUXADC_ADC27                  0x10ba
#define MT6357_AUXADC_ADC29                  0x10bc
#define MT6357_AUXADC_ADC30                  0x10be
#define MT6357_AUXADC_ADC31                  0x10c0
#define MT6357_AUXADC_ADC32                  0x10c2
#define MT6357_AUXADC_ADC33                  0x10c4
#define MT6357_AUXADC_ADC34                  0x10c6
#define MT6357_AUXADC_ADC35                  0x10c8
#define MT6357_AUXADC_ADC36                  0x10ca
#define MT6357_AUXADC_ADC38                  0x10cc
#define MT6357_AUXADC_ADC39                  0x10ce
#define MT6357_AUXADC_ADC40                  0x10d0
#define MT6357_AUXADC_ADC41                  0x10d2
#define MT6357_AUXADC_ADC42                  0x10d4
#define MT6357_AUXADC_ADC43                  0x10d6
#define MT6357_AUXADC_ADC46                  0x10d8
#define MT6357_AUXADC_ADC47                  0x10da
#define MT6357_AUXADC_DIG_1_ELR_NUM          0x10dc
#define MT6357_AUXADC_DIG_1_ELR0             0x10de
#define MT6357_AUXADC_DIG_1_ELR1             0x10e0
#define MT6357_AUXADC_DIG_2_DSN_ID           0x1100
#define MT6357_AUXADC_DIG_2_DSN_REV0         0x1102
#define MT6357_AUXADC_DIG_2_DSN_DBI          0x1104
#define MT6357_AUXADC_DIG_2_DSN_DXI          0x1106
#define MT6357_AUXADC_STA0                   0x1108
#define MT6357_AUXADC_STA1                   0x110a
#define MT6357_AUXADC_STA2                   0x110c
#define MT6357_AUXADC_RQST0                  0x110e
#define MT6357_AUXADC_RQST0_SET              0x1110
#define MT6357_AUXADC_RQST0_CLR              0x1112
#define MT6357_AUXADC_RQST2                  0x1114
#define MT6357_AUXADC_RQST2_SET              0x1116
#define MT6357_AUXADC_RQST2_CLR              0x1118
#define MT6357_AUXADC_RQST1                  0x111a
#define MT6357_AUXADC_RQST1_SET              0x111c
#define MT6357_AUXADC_RQST1_CLR              0x111e
#define MT6357_AUXADC_CON0                   0x1120
#define MT6357_AUXADC_CON0_SET               0x1122
#define MT6357_AUXADC_CON0_CLR               0x1124
#define MT6357_AUXADC_CON1                   0x1126
#define MT6357_AUXADC_CON2                   0x1128
#define MT6357_AUXADC_CON3                   0x112a
#define MT6357_AUXADC_CON4                   0x112c
#define MT6357_AUXADC_CON5                   0x112e
#define MT6357_AUXADC_CON6                   0x1130
#define MT6357_AUXADC_CON7                   0x1132
#define MT6357_AUXADC_CON8                   0x1134
#define MT6357_AUXADC_CON9                   0x1136
#define MT6357_AUXADC_CON10                  0x1138
#define MT6357_AUXADC_CON11                  0x113a
#define MT6357_AUXADC_CON12                  0x113c
#define MT6357_AUXADC_CON13                  0x113e
#define MT6357_AUXADC_CON14                  0x1140
#define MT6357_AUXADC_CON15                  0x1142
#define MT6357_AUXADC_CON16                  0x1144
#define MT6357_AUXADC_CON17                  0x1146
#define MT6357_AUXADC_CON18                  0x1148
#define MT6357_AUXADC_CON19                  0x114a
#define MT6357_AUXADC_CON20                  0x114c
#define MT6357_AUXADC_DIG_3_DSN_ID           0x1180
#define MT6357_AUXADC_DIG_3_DSN_REV0         0x1182
#define MT6357_AUXADC_DIG_3_DSN_DBI          0x1184
#define MT6357_AUXADC_DIG_3_DSN_DXI          0x1186
#define MT6357_AUXADC_AUTORPT0               0x1188
#define MT6357_AUXADC_LBAT0                  0x118a
#define MT6357_AUXADC_LBAT1                  0x118c
#define MT6357_AUXADC_LBAT2                  0x118e
#define MT6357_AUXADC_LBAT3                  0x1190
#define MT6357_AUXADC_LBAT4                  0x1192
#define MT6357_AUXADC_LBAT5                  0x1194
#define MT6357_AUXADC_LBAT6                  0x1196
#define MT6357_AUXADC_ACCDET                 0x1198
#define MT6357_AUXADC_DBG0                   0x119a
#define MT6357_AUXADC_IMP0                   0x119c
#define MT6357_AUXADC_IMP1                   0x119e
#define MT6357_AUXADC_DIG_3_ELR_NUM          0x11a0
#define MT6357_AUXADC_DIG_3_ELR0             0x11a2
#define MT6357_AUXADC_DIG_3_ELR1             0x11a4
#define MT6357_AUXADC_DIG_3_ELR2             0x11a6
#define MT6357_AUXADC_DIG_3_ELR3             0x11a8
#define MT6357_AUXADC_DIG_3_ELR4             0x11aa
#define MT6357_AUXADC_DIG_3_ELR5             0x11ac
#define MT6357_AUXADC_DIG_3_ELR6             0x11ae
#define MT6357_AUXADC_DIG_3_ELR7             0x11b0
#define MT6357_AUXADC_DIG_3_ELR8             0x11b2
#define MT6357_AUXADC_DIG_3_ELR9             0x11b4
#define MT6357_AUXADC_DIG_3_ELR10            0x11b6
#define MT6357_AUXADC_DIG_3_ELR11            0x11b8
#define MT6357_AUXADC_DIG_4_DSN_ID           0x1200
#define MT6357_AUXADC_DIG_4_DSN_REV0         0x1202
#define MT6357_AUXADC_DIG_4_DSN_DBI          0x1204
#define MT6357_AUXADC_DIG_4_DSN_DXI          0x1206
#define MT6357_AUXADC_MDRT_0                 0x1208
#define MT6357_AUXADC_MDRT_1                 0x120a
#define MT6357_AUXADC_MDRT_2                 0x120c
#define MT6357_AUXADC_MDRT_3                 0x120e
#define MT6357_AUXADC_MDRT_4                 0x1210
#define MT6357_AUXADC_DCXO_MDRT_0            0x1212
#define MT6357_AUXADC_DCXO_MDRT_1            0x1214
#define MT6357_AUXADC_DCXO_MDRT_2            0x1216
#define MT6357_AUXADC_NAG_0                  0x1218
#define MT6357_AUXADC_NAG_1                  0x121a
#define MT6357_AUXADC_NAG_2                  0x121c
#define MT6357_AUXADC_NAG_3                  0x121e
#define MT6357_AUXADC_NAG_4                  0x1220
#define MT6357_AUXADC_NAG_5                  0x1222
#define MT6357_AUXADC_NAG_6                  0x1224
#define MT6357_AUXADC_NAG_7                  0x1226
#define MT6357_AUXADC_NAG_8                  0x1228
#define MT6357_AUXADC_RSV_1                  0x122a
#define MT6357_AUXADC_ANA_0                  0x122c
#define MT6357_AUXADC_IMP_CG0                0x122e
#define MT6357_AUXADC_LBAT_CG0               0x1230
#define MT6357_AUXADC_NAG_CG0                0x1232
#define MT6357_AUXADC_PRI_NEW                0x1234
#define MT6357_AUXADC_CHR_TOP_CON2           0x1236
#define MT6357_BUCK_TOP_DSN_ID               0x1400
#define MT6357_BUCK_TOP_DSN_REV0             0x1402
#define MT6357_BUCK_TOP_DBI                  0x1404
#define MT6357_BUCK_TOP_DXI                  0x1406
#define MT6357_BUCK_TOP_PAM0                 0x1408
#define MT6357_BUCK_TOP_PAM1                 0x140a
#define MT6357_BUCK_TOP_CLK_CON0             0x140c
#define MT6357_BUCK_TOP_CLK_CON0_SET         0x140e
#define MT6357_BUCK_TOP_CLK_CON0_CLR         0x1410
#define MT6357_BUCK_TOP_CLK_HWEN_CON0        0x1412
#define MT6357_BUCK_TOP_CLK_HWEN_CON0_SET    0x1414
#define MT6357_BUCK_TOP_CLK_HWEN_CON0_CLR    0x1416
#define MT6357_BUCK_TOP_CLK_MISC_CON0        0x1418
#define MT6357_BUCK_TOP_INT_CON0             0x141a
#define MT6357_BUCK_TOP_INT_CON0_SET         0x141c
#define MT6357_BUCK_TOP_INT_CON0_CLR         0x141e
#define MT6357_BUCK_TOP_INT_MASK_CON0        0x1420
#define MT6357_BUCK_TOP_INT_MASK_CON0_SET    0x1422
#define MT6357_BUCK_TOP_INT_MASK_CON0_CLR    0x1424
#define MT6357_BUCK_TOP_INT_STATUS0          0x1426
#define MT6357_BUCK_TOP_INT_RAW_STATUS0      0x1428
#define MT6357_BUCK_TOP_STB_CON              0x142a
#define MT6357_BUCK_TOP_SLP_CON0             0x142c
#define MT6357_BUCK_TOP_SLP_CON1             0x142e
#define MT6357_BUCK_TOP_SLP_CON2             0x1430
#define MT6357_BUCK_TOP_MINFREQ_CON          0x1432
#define MT6357_BUCK_TOP_OC_CON0              0x1434
#define MT6357_BUCK_TOP_K_CON0               0x1436
#define MT6357_BUCK_TOP_K_CON1               0x1438
#define MT6357_BUCK_TOP_K_CON2               0x143a
#define MT6357_BUCK_TOP_WDTDBG0              0x143c
#define MT6357_BUCK_TOP_WDTDBG1              0x143e
#define MT6357_BUCK_TOP_WDTDBG2              0x1440
#define MT6357_BUCK_TOP_ELR_NUM              0x1442
#define MT6357_BUCK_TOP_ELR0                 0x1444
#define MT6357_BUCK_TOP_ELR1                 0x1446
#define MT6357_BUCK_VPROC_DSN_ID             0x1480
#define MT6357_BUCK_VPROC_DSN_REV0           0x1482
#define MT6357_BUCK_VPROC_DSN_DBI            0x1484
#define MT6357_BUCK_VPROC_DSN_DXI            0x1486
#define MT6357_BUCK_VPROC_CON0               0x1488
#define MT6357_BUCK_VPROC_CON1               0x148a
#define MT6357_BUCK_VPROC_CFG0               0x148c
#define MT6357_BUCK_VPROC_CFG1               0x148e
#define MT6357_BUCK_VPROC_OP_EN              0x1490
#define MT6357_BUCK_VPROC_OP_EN_SET          0x1492
#define MT6357_BUCK_VPROC_OP_EN_CLR          0x1494
#define MT6357_BUCK_VPROC_OP_CFG             0x1496
#define MT6357_BUCK_VPROC_OP_CFG_SET         0x1498
#define MT6357_BUCK_VPROC_OP_CFG_CLR         0x149a
#define MT6357_BUCK_VPROC_SP_CON             0x149c
#define MT6357_BUCK_VPROC_SP_CFG             0x149e
#define MT6357_BUCK_VPROC_OC_CFG             0x14a0
#define MT6357_BUCK_VPROC_DBG0               0x14a2
#define MT6357_BUCK_VPROC_DBG1               0x14a4
#define MT6357_BUCK_VPROC_DBG2               0x14a6
#define MT6357_BUCK_VPROC_ELR_NUM            0x14a8
#define MT6357_BUCK_VPROC_ELR0               0x14aa
#define MT6357_BUCK_VCORE_DSN_ID             0x1500
#define MT6357_BUCK_VCORE_DSN_REV0           0x1502
#define MT6357_BUCK_VCORE_DSN_DBI            0x1504
#define MT6357_BUCK_VCORE_DSN_DXI            0x1506
#define MT6357_BUCK_VCORE_CON0               0x1508
#define MT6357_BUCK_VCORE_CON1               0x150a
#define MT6357_BUCK_VCORE_CFG0               0x150c
#define MT6357_BUCK_VCORE_CFG1               0x150e
#define MT6357_BUCK_VCORE_OP_EN              0x1510
#define MT6357_BUCK_VCORE_OP_EN_SET          0x1512
#define MT6357_BUCK_VCORE_OP_EN_CLR          0x1514
#define MT6357_BUCK_VCORE_OP_CFG             0x1516
#define MT6357_BUCK_VCORE_OP_CFG_SET         0x1518
#define MT6357_BUCK_VCORE_OP_CFG_CLR         0x151a
#define MT6357_BUCK_VCORE_SP_CON             0x151c
#define MT6357_BUCK_VCORE_SP_CFG             0x151e
#define MT6357_BUCK_VCORE_OC_CFG             0x1520
#define MT6357_BUCK_VCORE_DBG0               0x1522
#define MT6357_BUCK_VCORE_DBG1               0x1524
#define MT6357_BUCK_VCORE_DBG2               0x1526
#define MT6357_BUCK_VCORE_ELR_NUM            0x1528
#define MT6357_BUCK_VCORE_ELR0               0x152a
#define MT6357_BUCK_VMODEM_DSN_ID            0x1580
#define MT6357_BUCK_VMODEM_DSN_REV0          0x1582
#define MT6357_BUCK_VMODEM_DSN_DBI           0x1584
#define MT6357_BUCK_VMODEM_DSN_DXI           0x1586
#define MT6357_BUCK_VMODEM_CON0              0x1588
#define MT6357_BUCK_VMODEM_CON1              0x158a
#define MT6357_BUCK_VMODEM_CFG0              0x158c
#define MT6357_BUCK_VMODEM_CFG1              0x158e
#define MT6357_BUCK_VMODEM_OP_EN             0x1590
#define MT6357_BUCK_VMODEM_OP_EN_SET         0x1592
#define MT6357_BUCK_VMODEM_OP_EN_CLR         0x1594
#define MT6357_BUCK_VMODEM_OP_CFG            0x1596
#define MT6357_BUCK_VMODEM_OP_CFG_SET        0x1598
#define MT6357_BUCK_VMODEM_OP_CFG_CLR        0x159a
#define MT6357_BUCK_VMODEM_SP_CON            0x159c
#define MT6357_BUCK_VMODEM_SP_CFG            0x159e
#define MT6357_BUCK_VMODEM_OC_CFG            0x15a0
#define MT6357_BUCK_VMODEM_DBG0              0x15a2
#define MT6357_BUCK_VMODEM_DBG1              0x15a4
#define MT6357_BUCK_VMODEM_DBG2              0x15a6
#define MT6357_BUCK_VMODEM_ELR_NUM           0x15a8
#define MT6357_BUCK_VMODEM_ELR0              0x15aa
#define MT6357_BUCK_VS1_DSN_ID               0x1600
#define MT6357_BUCK_VS1_DSN_REV0             0x1602
#define MT6357_BUCK_VS1_DSN_DBI              0x1604
#define MT6357_BUCK_VS1_DSN_DXI              0x1606
#define MT6357_BUCK_VS1_CON0                 0x1608
#define MT6357_BUCK_VS1_CON1                 0x160a
#define MT6357_BUCK_VS1_CFG0                 0x160c
#define MT6357_BUCK_VS1_CFG1                 0x160e
#define MT6357_BUCK_VS1_OP_EN                0x1610
#define MT6357_BUCK_VS1_OP_EN_SET            0x1612
#define MT6357_BUCK_VS1_OP_EN_CLR            0x1614
#define MT6357_BUCK_VS1_OP_CFG               0x1616
#define MT6357_BUCK_VS1_OP_CFG_SET           0x1618
#define MT6357_BUCK_VS1_OP_CFG_CLR           0x161a
#define MT6357_BUCK_VS1_SP_CON               0x161c
#define MT6357_BUCK_VS1_SP_CFG               0x161e
#define MT6357_BUCK_VS1_OC_CFG               0x1620
#define MT6357_BUCK_VS1_DBG0                 0x1622
#define MT6357_BUCK_VS1_DBG1                 0x1624
#define MT6357_BUCK_VS1_DBG2                 0x1626
#define MT6357_BUCK_VS1_VOTER                0x1628
#define MT6357_BUCK_VS1_VOTER_SET            0x162a
#define MT6357_BUCK_VS1_VOTER_CLR            0x162c
#define MT6357_BUCK_VS1_VOTER_CFG            0x162e
#define MT6357_BUCK_VS1_ELR_NUM              0x1630
#define MT6357_BUCK_VS1_ELR0                 0x1632
#define MT6357_BUCK_VPA_DSN_ID               0x1680
#define MT6357_BUCK_VPA_DSN_REV0             0x1682
#define MT6357_BUCK_VPA_DSN_DBI              0x1684
#define MT6357_BUCK_VPA_DSN_DXI              0x1686
#define MT6357_BUCK_VPA_CON0                 0x1688
#define MT6357_BUCK_VPA_CON1                 0x168a
#define MT6357_BUCK_VPA_CFG0                 0x168c
#define MT6357_BUCK_VPA_CFG1                 0x168e
#define MT6357_BUCK_VPA_OC_CFG               0x1690
#define MT6357_BUCK_VPA_DBG0                 0x1692
#define MT6357_BUCK_VPA_DBG1                 0x1694
#define MT6357_BUCK_VPA_DBG2                 0x1696
#define MT6357_BUCK_VPA_DLC_CON0             0x1698
#define MT6357_BUCK_VPA_DLC_CON1             0x169a
#define MT6357_BUCK_VPA_DLC_CON2             0x169c
#define MT6357_BUCK_VPA_MSFG_CON0            0x169e
#define MT6357_BUCK_VPA_MSFG_CON1            0x16a0
#define MT6357_BUCK_VPA_MSFG_RRATE0          0x16a2
#define MT6357_BUCK_VPA_MSFG_RRATE1          0x16a4
#define MT6357_BUCK_VPA_MSFG_RRATE2          0x16a6
#define MT6357_BUCK_VPA_MSFG_RTHD0           0x16a8
#define MT6357_BUCK_VPA_MSFG_RTHD1           0x16aa
#define MT6357_BUCK_VPA_MSFG_RTHD2           0x16ac
#define MT6357_BUCK_VPA_MSFG_FRATE0          0x16ae
#define MT6357_BUCK_VPA_MSFG_FRATE1          0x16b0
#define MT6357_BUCK_VPA_MSFG_FRATE2          0x16b2
#define MT6357_BUCK_VPA_MSFG_FTHD0           0x16b4
#define MT6357_BUCK_VPA_MSFG_FTHD1           0x16b6
#define MT6357_BUCK_VPA_MSFG_FTHD2           0x16b8
#define MT6357_BUCK_ANA_DSN_ID               0x1700
#define MT6357_BUCK_ANA_DSN_REV0             0x1702
#define MT6357_BUCK_ANA_DSN_DBI              0x1704
#define MT6357_BUCK_ANA_DSN_FPI              0x1706
#define MT6357_SMPS_ANA_CON0                 0x1708
#define MT6357_SMPS_ANA_CON1                 0x170a
#define MT6357_SMPS_ANA_CON2                 0x170c
#define MT6357_VCORE_VPROC_ANA_CON0          0x170e
#define MT6357_VCORE_VPROC_ANA_CON1          0x1710
#define MT6357_VCORE_VPROC_ANA_CON2          0x1712
#define MT6357_VCORE_VPROC_ANA_CON3          0x1714
#define MT6357_VCORE_VPROC_ANA_CON4          0x1716
#define MT6357_VCORE_VPROC_ANA_CON5          0x1718
#define MT6357_VCORE_VPROC_ANA_CON6          0x171a
#define MT6357_VCORE_VPROC_ANA_CON7          0x171c
#define MT6357_VCORE_VPROC_ANA_CON8          0x171e
#define MT6357_VCORE_VPROC_ANA_CON9          0x1720
#define MT6357_VCORE_VPROC_ANA_CON10         0x1722
#define MT6357_VCORE_VPROC_ANA_CON11         0x1724
#define MT6357_VMODEM_ANA_CON0               0x1726
#define MT6357_VMODEM_ANA_CON1               0x1728
#define MT6357_VMODEM_ANA_CON2               0x172a
#define MT6357_VMODEM_ANA_CON3               0x172c
#define MT6357_VMODEM_ANA_CON4               0x172e
#define MT6357_VMODEM_ANA_CON5               0x1730
#define MT6357_VS1_ANA_CON0                  0x1732
#define MT6357_VS1_ANA_CON1                  0x1734
#define MT6357_VS1_ANA_CON2                  0x1736
#define MT6357_VS1_ANA_CON3                  0x1738
#define MT6357_VS1_ANA_CON4                  0x173a
#define MT6357_VS1_ANA_CON5                  0x173c
#define MT6357_VPA_ANA_CON0                  0x173e
#define MT6357_VPA_ANA_CON1                  0x1740
#define MT6357_VPA_ANA_CON2                  0x1742
#define MT6357_VPA_ANA_CON3                  0x1744
#define MT6357_VPA_ANA_CON4                  0x1746
#define MT6357_VPA_ANA_CON5                  0x1748
#define MT6357_BUCK_ANA_ELR_NUM              0x174a
#define MT6357_SMPS_ELR_0                    0x174c
#define MT6357_SMPS_ELR_1                    0x174e
#define MT6357_SMPS_ELR_2                    0x1750
#define MT6357_SMPS_ELR_3                    0x1752
#define MT6357_SMPS_ELR_4                    0x1754
#define MT6357_SMPS_ELR_5                    0x1756
#define MT6357_VCORE_VPROC_ELR_0             0x1758
#define MT6357_VCORE_VPROC_ELR_1             0x175a
#define MT6357_VCORE_VPROC_ELR_2             0x175c
#define MT6357_VCORE_VPROC_ELR_3             0x175e
#define MT6357_VCORE_VPROC_ELR_4             0x1760
#define MT6357_VMODEM_ELR_0                  0x1762
#define MT6357_VMODEM_ELR_1                  0x1764
#define MT6357_VMODEM_ELR_2                  0x1766
#define MT6357_VS1_ELR_0                     0x1768
#define MT6357_VS1_ELR_1                     0x176a
#define MT6357_VPA_ELR_0                     0x176c
#define MT6357_LDO_TOP_ID                    0x1880
#define MT6357_LDO_TOP_REV0                  0x1882
#define MT6357_LDO_TOP_DBI                   0x1884
#define MT6357_LDO_TOP_DXI                   0x1886
#define MT6357_LDO_TPM0                      0x1888
#define MT6357_LDO_TPM1                      0x188a
#define MT6357_LDO_TOP_CLK_DCM_CON0          0x188c
#define MT6357_LDO_TOP_CLK_VIO28_CON0        0x188e
#define MT6357_LDO_TOP_CLK_VIO18_CON0        0x1890
#define MT6357_LDO_TOP_CLK_VAUD28_CON0       0x1892
#define MT6357_LDO_TOP_CLK_VDRAM_CON0        0x1894
#define MT6357_LDO_TOP_CLK_VSRAM_PROC_CON0   0x1896
#define MT6357_LDO_TOP_CLK_VSRAM_OTHERS_CON0 0x1898
#define MT6357_LDO_TOP_CLK_VAUX18_CON0       0x189a
#define MT6357_LDO_TOP_CLK_VUSB33_CON0       0x189c
#define MT6357_LDO_TOP_CLK_VEMC_CON0         0x189e
#define MT6357_LDO_TOP_CLK_VXO22_CON0        0x18a0
#define MT6357_LDO_TOP_CLK_VSIM1_CON0        0x18a2
#define MT6357_LDO_TOP_CLK_VSIM2_CON0        0x18a4
#define MT6357_LDO_TOP_CLK_VCAMD_CON0        0x18a6
#define MT6357_LDO_TOP_CLK_VCAMIO_CON0       0x18a8
#define MT6357_LDO_TOP_CLK_VEFUSE_CON0       0x18aa
#define MT6357_LDO_TOP_CLK_VCN33_CON0        0x18ac
#define MT6357_LDO_TOP_CLK_VCN18_CON0        0x18ae
#define MT6357_LDO_TOP_CLK_VCN28_CON0        0x18b0
#define MT6357_LDO_TOP_CLK_VIBR_CON0         0x18b2
#define MT6357_LDO_TOP_CLK_VFE28_CON0        0x18b4
#define MT6357_LDO_TOP_CLK_VMCH_CON0         0x18b6
#define MT6357_LDO_TOP_CLK_VMC_CON0          0x18b8
#define MT6357_LDO_TOP_CLK_VRF18_CON0        0x18ba
#define MT6357_LDO_TOP_CLK_VLDO28_CON0       0x18bc
#define MT6357_LDO_TOP_CLK_VRF12_CON0        0x18be
#define MT6357_LDO_TOP_CLK_VCAMA_CON0        0x18c0
#define MT6357_LDO_TOP_CLK_TREF_CON0         0x18c2
#define MT6357_LDO_TOP_INT_CON0              0x18c4
#define MT6357_LDO_TOP_INT_CON0_SET          0x18c6
#define MT6357_LDO_TOP_INT_CON0_CLR          0x18c8
#define MT6357_LDO_TOP_INT_CON1              0x18ca
#define MT6357_LDO_TOP_INT_CON1_SET          0x18cc
#define MT6357_LDO_TOP_INT_CON1_CLR          0x18ce
#define MT6357_LDO_TOP_INT_MASK_CON0         0x18d0
#define MT6357_LDO_TOP_INT_MASK_CON0_SET     0x18d2
#define MT6357_LDO_TOP_INT_MASK_CON0_CLR     0x18d4
#define MT6357_LDO_TOP_INT_MASK_CON1         0x18d6
#define MT6357_LDO_TOP_INT_MASK_CON1_SET     0x18d8
#define MT6357_LDO_TOP_INT_MASK_CON1_CLR     0x18da
#define MT6357_LDO_TOP_INT_STATUS0           0x18dc
#define MT6357_LDO_TOP_INT_STATUS1           0x18de
#define MT6357_LDO_TOP_INT_RAW_STATUS0       0x18e0
#define MT6357_LDO_TOP_INT_RAW_STATUS1       0x18e2
#define MT6357_LDO_TEST_CON0                 0x18e4
#define MT6357_LDO_TOP_WDT_CON0              0x18e6
#define MT6357_LDO_TOP_RSV_CON0              0x18e8
#define MT6357_LDO_TOP_RSV_CON1              0x18ea
#define MT6357_LDO_OCFB0                     0x18ec
#define MT6357_LDO_LP_PROTECTION             0x18ee
#define MT6357_LDO_DUMMY_LOAD_GATED          0x18f0
#define MT6357_LDO_GON0_DSN_ID               0x1900
#define MT6357_LDO_GON0_DSN_REV0             0x1902
#define MT6357_LDO_GON0_DSN_DBI              0x1904
#define MT6357_LDO_GON0_DSN_DXI              0x1906
#define MT6357_LDO_VXO22_CON0                0x1908
#define MT6357_LDO_VXO22_OP_EN               0x190a
#define MT6357_LDO_VXO22_OP_EN_SET           0x190c
#define MT6357_LDO_VXO22_OP_EN_CLR           0x190e
#define MT6357_LDO_VXO22_OP_CFG              0x1910
#define MT6357_LDO_VXO22_OP_CFG_SET          0x1912
#define MT6357_LDO_VXO22_OP_CFG_CLR          0x1914
#define MT6357_LDO_VXO22_CON1                0x1916
#define MT6357_LDO_VXO22_CON2                0x1918
#define MT6357_LDO_VXO22_CON3                0x191a
#define MT6357_LDO_VAUX18_CON0               0x191c
#define MT6357_LDO_VAUX18_OP_EN              0x191e
#define MT6357_LDO_VAUX18_OP_EN_SET          0x1920
#define MT6357_LDO_VAUX18_OP_EN_CLR          0x1922
#define MT6357_LDO_VAUX18_OP_CFG             0x1924
#define MT6357_LDO_VAUX18_OP_CFG_SET         0x1926
#define MT6357_LDO_VAUX18_OP_CFG_CLR         0x1928
#define MT6357_LDO_VAUX18_CON1               0x192a
#define MT6357_LDO_VAUX18_CON2               0x192c
#define MT6357_LDO_VAUX18_CON3               0x192e
#define MT6357_LDO_VAUD28_CON0               0x1930
#define MT6357_LDO_VAUD28_OP_EN              0x1932
#define MT6357_LDO_VAUD28_OP_EN_SET          0x1934
#define MT6357_LDO_VAUD28_OP_EN_CLR          0x1936
#define MT6357_LDO_VAUD28_OP_CFG             0x1938
#define MT6357_LDO_VAUD28_OP_CFG_SET         0x193a
#define MT6357_LDO_VAUD28_OP_CFG_CLR         0x193c
#define MT6357_LDO_VAUD28_CON1               0x193e
#define MT6357_LDO_VAUD28_CON2               0x1940
#define MT6357_LDO_VAUD28_CON3               0x1942
#define MT6357_LDO_VIO28_CON0                0x1944
#define MT6357_LDO_VIO28_OP_EN               0x1946
#define MT6357_LDO_VIO28_OP_EN_SET           0x1948
#define MT6357_LDO_VIO28_OP_EN_CLR           0x194a
#define MT6357_LDO_VIO28_OP_CFG              0x194c
#define MT6357_LDO_VIO28_OP_CFG_SET          0x194e
#define MT6357_LDO_VIO28_OP_CFG_CLR          0x1950
#define MT6357_LDO_VIO28_CON1                0x1952
#define MT6357_LDO_VIO28_CON2                0x1954
#define MT6357_LDO_VIO28_CON3                0x1956
#define MT6357_LDO_VIO18_CON0                0x1958
#define MT6357_LDO_VIO18_OP_EN               0x195a
#define MT6357_LDO_VIO18_OP_EN_SET           0x195c
#define MT6357_LDO_VIO18_OP_EN_CLR           0x195e
#define MT6357_LDO_VIO18_OP_CFG              0x1960
#define MT6357_LDO_VIO18_OP_CFG_SET          0x1962
#define MT6357_LDO_VIO18_OP_CFG_CLR          0x1964
#define MT6357_LDO_VIO18_CON1                0x1966
#define MT6357_LDO_VIO18_CON2                0x1968
#define MT6357_LDO_VIO18_CON3                0x196a
#define MT6357_LDO_VDRAM_CON0                0x196c
#define MT6357_LDO_VDRAM_OP_EN               0x196e
#define MT6357_LDO_VDRAM_OP_EN_SET           0x1970
#define MT6357_LDO_VDRAM_OP_EN_CLR           0x1972
#define MT6357_LDO_VDRAM_OP_CFG              0x1974
#define MT6357_LDO_VDRAM_OP_CFG_SET          0x1976
#define MT6357_LDO_VDRAM_OP_CFG_CLR          0x1978
#define MT6357_LDO_VDRAM_CON1                0x197a
#define MT6357_LDO_VDRAM_CON2                0x197c
#define MT6357_LDO_VDRAM_CON3                0x197e
#define MT6357_LDO_GON1_DSN_ID               0x1980
#define MT6357_LDO_GON1_DSN_REV0             0x1982
#define MT6357_LDO_GON1_DSN_DBI              0x1984
#define MT6357_LDO_GON1_DSN_DXI              0x1986
#define MT6357_LDO_VEMC_CON0                 0x1988
#define MT6357_LDO_VEMC_OP_EN                0x198a
#define MT6357_LDO_VEMC_OP_EN_SET            0x198c
#define MT6357_LDO_VEMC_OP_EN_CLR            0x198e
#define MT6357_LDO_VEMC_OP_CFG               0x1990
#define MT6357_LDO_VEMC_OP_CFG_SET           0x1992
#define MT6357_LDO_VEMC_OP_CFG_CLR           0x1994
#define MT6357_LDO_VEMC_CON1                 0x1996
#define MT6357_LDO_VEMC_CON2                 0x1998
#define MT6357_LDO_VEMC_CON3                 0x199a
#define MT6357_LDO_VUSB33_CON0_0             0x199c
#define MT6357_LDO_VUSB33_OP_EN              0x199e
#define MT6357_LDO_VUSB33_OP_EN_SET          0x19a0
#define MT6357_LDO_VUSB33_OP_EN_CLR          0x19a2
#define MT6357_LDO_VUSB33_OP_CFG             0x19a4
#define MT6357_LDO_VUSB33_OP_CFG_SET         0x19a6
#define MT6357_LDO_VUSB33_OP_CFG_CLR         0x19a8
#define MT6357_LDO_VUSB33_CON0_1             0x19aa
#define MT6357_LDO_VUSB33_CON1               0x19ac
#define MT6357_LDO_VUSB33_CON2               0x19ae
#define MT6357_LDO_VUSB33_CON3               0x19b0
#define MT6357_LDO_VSRAM_PROC_CON0           0x19b2
#define MT6357_LDO_VSRAM_PROC_CON2           0x19b4
#define MT6357_LDO_VSRAM_PROC_CFG0           0x19b6
#define MT6357_LDO_VSRAM_PROC_CFG1           0x19b8
#define MT6357_LDO_VSRAM_PROC_OP_EN          0x19ba
#define MT6357_LDO_VSRAM_PROC_OP_EN_SET      0x19bc
#define MT6357_LDO_VSRAM_PROC_OP_EN_CLR      0x19be
#define MT6357_LDO_VSRAM_PROC_OP_CFG         0x19c0
#define MT6357_LDO_VSRAM_PROC_OP_CFG_SET     0x19c2
#define MT6357_LDO_VSRAM_PROC_OP_CFG_CLR     0x19c4
#define MT6357_LDO_VSRAM_PROC_CON3           0x19c6
#define MT6357_LDO_VSRAM_PROC_CON4           0x19c8
#define MT6357_LDO_VSRAM_PROC_CON5           0x19ca
#define MT6357_LDO_VSRAM_PROC_DBG0           0x19cc
#define MT6357_LDO_VSRAM_PROC_DBG1           0x19ce
#define MT6357_LDO_VSRAM_OTHERS_CON0         0x19d0
#define MT6357_LDO_VSRAM_OTHERS_CON2         0x19d2
#define MT6357_LDO_VSRAM_OTHERS_CFG0         0x19d4
#define MT6357_LDO_VSRAM_OTHERS_CFG1         0x19d6
#define MT6357_LDO_VSRAM_OTHERS_OP_EN        0x19d8
#define MT6357_LDO_VSRAM_OTHERS_OP_EN_SET    0x19da
#define MT6357_LDO_VSRAM_OTHERS_OP_EN_CLR    0x19dc
#define MT6357_LDO_VSRAM_OTHERS_OP_CFG       0x19de
#define MT6357_LDO_VSRAM_OTHERS_OP_CFG_SET   0x19e0
#define MT6357_LDO_VSRAM_OTHERS_OP_CFG_CLR   0x19e2
#define MT6357_LDO_VSRAM_OTHERS_CON3         0x19e4
#define MT6357_LDO_VSRAM_OTHERS_CON4         0x19e6
#define MT6357_LDO_VSRAM_OTHERS_CON5         0x19e8
#define MT6357_LDO_VSRAM_OTHERS_DBG0         0x19ea
#define MT6357_LDO_VSRAM_OTHERS_DBG1         0x19ec
#define MT6357_LDO_VSRAM_PROC_SP             0x19ee
#define MT6357_LDO_VSRAM_OTHERS_SP           0x19f0
#define MT6357_LDO_VSRAM_PROC_R2R_PDN_DIS    0x19f2
#define MT6357_LDO_VSRAM_OTHERS_R2R_PDN_DIS  0x19f4
#define MT6357_LDO_VSRAM_WDT_DBG0            0x19f6
#define MT6357_LDO_GON1_ELR_NUM              0x19f8
#define MT6357_LDO_VSRAM_CON0                0x19fa
#define MT6357_LDO_VSRAM_CON1                0x19fc
#define MT6357_LDO_VSRAM_CON2                0x19fe
#define MT6357_LDO_GOFF0_DSN_ID              0x1a00
#define MT6357_LDO_GOFF0_DSN_REV0            0x1a02
#define MT6357_LDO_GOFF0_DSN_DBI             0x1a04
#define MT6357_LDO_GOFF0_DSN_DXI             0x1a06
#define MT6357_LDO_VFE28_CON0                0x1a08
#define MT6357_LDO_VFE28_OP_EN               0x1a0a
#define MT6357_LDO_VFE28_OP_EN_SET           0x1a0c
#define MT6357_LDO_VFE28_OP_EN_CLR           0x1a0e
#define MT6357_LDO_VFE28_OP_CFG              0x1a10
#define MT6357_LDO_VFE28_OP_CFG_SET          0x1a12
#define MT6357_LDO_VFE28_OP_CFG_CLR          0x1a14
#define MT6357_LDO_VFE28_CON1                0x1a16
#define MT6357_LDO_VFE28_CON2                0x1a18
#define MT6357_LDO_VFE28_CON3                0x1a1a
#define MT6357_LDO_VRF18_CON0                0x1a1c
#define MT6357_LDO_VRF18_OP_EN               0x1a1e
#define MT6357_LDO_VRF18_OP_EN_SET           0x1a20
#define MT6357_LDO_VRF18_OP_EN_CLR           0x1a22
#define MT6357_LDO_VRF18_OP_CFG              0x1a24
#define MT6357_LDO_VRF18_OP_CFG_SET          0x1a26
#define MT6357_LDO_VRF18_OP_CFG_CLR          0x1a28
#define MT6357_LDO_VRF18_CON1                0x1a2a
#define MT6357_LDO_VRF18_CON2                0x1a2c
#define MT6357_LDO_VRF18_CON3                0x1a2e
#define MT6357_LDO_VRF12_CON0                0x1a30
#define MT6357_LDO_VRF12_OP_EN               0x1a32
#define MT6357_LDO_VRF12_OP_EN_SET           0x1a34
#define MT6357_LDO_VRF12_OP_EN_CLR           0x1a36
#define MT6357_LDO_VRF12_OP_CFG              0x1a38
#define MT6357_LDO_VRF12_OP_CFG_SET          0x1a3a
#define MT6357_LDO_VRF12_OP_CFG_CLR          0x1a3c
#define MT6357_LDO_VRF12_CON1                0x1a3e
#define MT6357_LDO_VRF12_CON2                0x1a40
#define MT6357_LDO_VRF12_CON3                0x1a42
#define MT6357_LDO_VEFUSE_CON0               0x1a44
#define MT6357_LDO_VEFUSE_OP_EN              0x1a46
#define MT6357_LDO_VEFUSE_OP_EN_SET          0x1a48
#define MT6357_LDO_VEFUSE_OP_EN_CLR          0x1a4a
#define MT6357_LDO_VEFUSE_OP_CFG             0x1a4c
#define MT6357_LDO_VEFUSE_OP_CFG_SET         0x1a4e
#define MT6357_LDO_VEFUSE_OP_CFG_CLR         0x1a50
#define MT6357_LDO_VEFUSE_CON1               0x1a52
#define MT6357_LDO_VEFUSE_CON2               0x1a54
#define MT6357_LDO_VEFUSE_CON3               0x1a56
#define MT6357_LDO_VCN18_CON0                0x1a58
#define MT6357_LDO_VCN18_OP_EN               0x1a5a
#define MT6357_LDO_VCN18_OP_EN_SET           0x1a5c
#define MT6357_LDO_VCN18_OP_EN_CLR           0x1a5e
#define MT6357_LDO_VCN18_OP_CFG              0x1a60
#define MT6357_LDO_VCN18_OP_CFG_SET          0x1a62
#define MT6357_LDO_VCN18_OP_CFG_CLR          0x1a64
#define MT6357_LDO_VCN18_CON1                0x1a66
#define MT6357_LDO_VCN18_CON2                0x1a68
#define MT6357_LDO_VCN18_CON3                0x1a6a
#define MT6357_LDO_VCAMA_CON0                0x1a6c
#define MT6357_LDO_VCAMA_OP_EN               0x1a6e
#define MT6357_LDO_VCAMA_OP_EN_SET           0x1a70
#define MT6357_LDO_VCAMA_OP_EN_CLR           0x1a72
#define MT6357_LDO_VCAMA_OP_CFG              0x1a74
#define MT6357_LDO_VCAMA_OP_CFG_SET          0x1a76
#define MT6357_LDO_VCAMA_OP_CFG_CLR          0x1a78
#define MT6357_LDO_VCAMA_CON1                0x1a7a
#define MT6357_LDO_VCAMA_CON2                0x1a7c
#define MT6357_LDO_VCAMA_CON3                0x1a7e
#define MT6357_LDO_GOFF1_DSN_ID              0x1a80
#define MT6357_LDO_GOFF1_DSN_REV0            0x1a82
#define MT6357_LDO_GOFF1_DSN_DBI             0x1a84
#define MT6357_LDO_GOFF1_DSN_DXI             0x1a86
#define MT6357_LDO_VCAMD_CON0                0x1a88
#define MT6357_LDO_VCAMD_OP_EN               0x1a8a
#define MT6357_LDO_VCAMD_OP_EN_SET           0x1a8c
#define MT6357_LDO_VCAMD_OP_EN_CLR           0x1a8e
#define MT6357_LDO_VCAMD_OP_CFG              0x1a90
#define MT6357_LDO_VCAMD_OP_CFG_SET          0x1a92
#define MT6357_LDO_VCAMD_OP_CFG_CLR          0x1a94
#define MT6357_LDO_VCAMD_CON1                0x1a96
#define MT6357_LDO_VCAMD_CON2                0x1a98
#define MT6357_LDO_VCAMD_CON3                0x1a9a
#define MT6357_LDO_VCAMIO_CON0               0x1a9c
#define MT6357_LDO_VCAMIO_OP_EN              0x1a9e
#define MT6357_LDO_VCAMIO_OP_EN_SET          0x1aa0
#define MT6357_LDO_VCAMIO_OP_EN_CLR          0x1aa2
#define MT6357_LDO_VCAMIO_OP_CFG             0x1aa4
#define MT6357_LDO_VCAMIO_OP_CFG_SET         0x1aa6
#define MT6357_LDO_VCAMIO_OP_CFG_CLR         0x1aa8
#define MT6357_LDO_VCAMIO_CON1               0x1aaa
#define MT6357_LDO_VCAMIO_CON2               0x1aac
#define MT6357_LDO_VCAMIO_CON3               0x1aae
#define MT6357_LDO_VMC_CON0                  0x1ab0
#define MT6357_LDO_VMC_OP_EN                 0x1ab2
#define MT6357_LDO_VMC_OP_EN_SET             0x1ab4
#define MT6357_LDO_VMC_OP_EN_CLR             0x1ab6
#define MT6357_LDO_VMC_OP_CFG                0x1ab8
#define MT6357_LDO_VMC_OP_CFG_SET            0x1aba
#define MT6357_LDO_VMC_OP_CFG_CLR            0x1abc
#define MT6357_LDO_VMC_CON1                  0x1abe
#define MT6357_LDO_VMC_CON2                  0x1ac0
#define MT6357_LDO_VMC_CON3                  0x1ac2
#define MT6357_LDO_VMCH_CON0                 0x1ac4
#define MT6357_LDO_VMCH_OP_EN                0x1ac6
#define MT6357_LDO_VMCH_OP_EN_SET            0x1ac8
#define MT6357_LDO_VMCH_OP_EN_CLR            0x1aca
#define MT6357_LDO_VMCH_OP_CFG               0x1acc
#define MT6357_LDO_VMCH_OP_CFG_SET           0x1ace
#define MT6357_LDO_VMCH_OP_CFG_CLR           0x1ad0
#define MT6357_LDO_VMCH_CON1                 0x1ad2
#define MT6357_LDO_VMCH_CON2                 0x1ad4
#define MT6357_LDO_VMCH_CON3                 0x1ad6
#define MT6357_LDO_VSIM1_CON0                0x1ad8
#define MT6357_LDO_VSIM1_OP_EN               0x1ada
#define MT6357_LDO_VSIM1_OP_EN_SET           0x1adc
#define MT6357_LDO_VSIM1_OP_EN_CLR           0x1ade
#define MT6357_LDO_VSIM1_OP_CFG              0x1ae0
#define MT6357_LDO_VSIM1_OP_CFG_SET          0x1ae2
#define MT6357_LDO_VSIM1_OP_CFG_CLR          0x1ae4
#define MT6357_LDO_VSIM1_CON1                0x1ae6
#define MT6357_LDO_VSIM1_CON2                0x1ae8
#define MT6357_LDO_VSIM1_CON3                0x1aea
#define MT6357_LDO_VSIM2_CON0                0x1aec
#define MT6357_LDO_VSIM2_OP_EN               0x1aee
#define MT6357_LDO_VSIM2_OP_EN_SET           0x1af0
#define MT6357_LDO_VSIM2_OP_EN_CLR           0x1af2
#define MT6357_LDO_VSIM2_OP_CFG              0x1af4
#define MT6357_LDO_VSIM2_OP_CFG_SET          0x1af6
#define MT6357_LDO_VSIM2_OP_CFG_CLR          0x1af8
#define MT6357_LDO_VSIM2_CON1                0x1afa
#define MT6357_LDO_VSIM2_CON2                0x1afc
#define MT6357_LDO_VSIM2_CON3                0x1afe
#define MT6357_LDO_GOFF2_DSN_ID              0x1b00
#define MT6357_LDO_GOFF2_DSN_REV0            0x1b02
#define MT6357_LDO_GOFF2_DSN_DBI             0x1b04
#define MT6357_LDO_GOFF2_DSN_DXI             0x1b06
#define MT6357_LDO_VIBR_CON0                 0x1b08
#define MT6357_LDO_VIBR_OP_EN                0x1b0a
#define MT6357_LDO_VIBR_OP_EN_SET            0x1b0c
#define MT6357_LDO_VIBR_OP_EN_CLR            0x1b0e
#define MT6357_LDO_VIBR_OP_CFG               0x1b10
#define MT6357_LDO_VIBR_OP_CFG_SET           0x1b12
#define MT6357_LDO_VIBR_OP_CFG_CLR           0x1b14
#define MT6357_LDO_VIBR_CON1                 0x1b16
#define MT6357_LDO_VIBR_CON2                 0x1b18
#define MT6357_LDO_VIBR_CON3                 0x1b1a
#define MT6357_LDO_VCN33_CON0_0              0x1b1c
#define MT6357_LDO_VCN33_OP_EN               0x1b1e
#define MT6357_LDO_VCN33_OP_EN_SET           0x1b20
#define MT6357_LDO_VCN33_OP_EN_CLR           0x1b22
#define MT6357_LDO_VCN33_OP_CFG              0x1b24
#define MT6357_LDO_VCN33_OP_CFG_SET          0x1b26
#define MT6357_LDO_VCN33_OP_CFG_CLR          0x1b28
#define MT6357_LDO_VCN33_CON0_1              0x1b2a
#define MT6357_LDO_VCN33_CON1                0x1b2c
#define MT6357_LDO_VCN33_CON2                0x1b2e
#define MT6357_LDO_VCN33_CON3                0x1b30
#define MT6357_LDO_VLDO28_CON0_0             0x1b32
#define MT6357_LDO_VLDO28_OP_EN              0x1b34
#define MT6357_LDO_VLDO28_OP_EN_SET          0x1b36
#define MT6357_LDO_VLDO28_OP_EN_CLR          0x1b38
#define MT6357_LDO_VLDO28_OP_CFG             0x1b3a
#define MT6357_LDO_VLDO28_OP_CFG_SET         0x1b3c
#define MT6357_LDO_VLDO28_OP_CFG_CLR         0x1b3e
#define MT6357_LDO_VLDO28_CON0_1             0x1b40
#define MT6357_LDO_VLDO28_CON1               0x1b42
#define MT6357_LDO_VLDO28_CON2               0x1b44
#define MT6357_LDO_VLDO28_CON3               0x1b46
#define MT6357_LDO_GOFF2_RSV_CON0            0x1b48
#define MT6357_LDO_GOFF2_RSV_CON1            0x1b4a
#define MT6357_LDO_GOFF3_DSN_ID              0x1b80
#define MT6357_LDO_GOFF3_DSN_REV0            0x1b82
#define MT6357_LDO_GOFF3_DSN_DBI             0x1b84
#define MT6357_LDO_GOFF3_DSN_DXI             0x1b86
#define MT6357_LDO_VCN28_CON0                0x1b88
#define MT6357_LDO_VCN28_OP_EN               0x1b8a
#define MT6357_LDO_VCN28_OP_EN_SET           0x1b8c
#define MT6357_LDO_VCN28_OP_EN_CLR           0x1b8e
#define MT6357_LDO_VCN28_OP_CFG              0x1b90
#define MT6357_LDO_VCN28_OP_CFG_SET          0x1b92
#define MT6357_LDO_VCN28_OP_CFG_CLR          0x1b94
#define MT6357_LDO_VCN28_CON1                0x1b96
#define MT6357_LDO_VCN28_CON2                0x1b98
#define MT6357_LDO_VCN28_CON3                0x1b9a
#define MT6357_VRTC_CON0                     0x1b9c
#define MT6357_LDO_TREF_CON0                 0x1b9e
#define MT6357_LDO_TREF_OP_EN                0x1ba0
#define MT6357_LDO_TREF_OP_EN_SET            0x1ba2
#define MT6357_LDO_TREF_OP_EN_CLR            0x1ba4
#define MT6357_LDO_TREF_OP_CFG               0x1ba6
#define MT6357_LDO_TREF_OP_CFG_SET           0x1ba8
#define MT6357_LDO_TREF_OP_CFG_CLR           0x1baa
#define MT6357_LDO_TREF_CON1                 0x1bac
#define MT6357_LDO_GOFF3_RSV_CON0            0x1bae
#define MT6357_LDO_GOFF3_RSV_CON1            0x1bb0
#define MT6357_LDO_ANA0_DSN_ID               0x1c00
#define MT6357_LDO_ANA0_DSN_REV0             0x1c02
#define MT6357_LDO_ANA0_DSN_DBI              0x1c04
#define MT6357_LDO_ANA0_DSN_DXI              0x1c06
#define MT6357_VFE28_ANA_CON0                0x1c08
#define MT6357_VFE28_ANA_CON1                0x1c0a
#define MT6357_VCN28_ANA_CON0                0x1c0c
#define MT6357_VCN28_ANA_CON1                0x1c0e
#define MT6357_VAUD28_ANA_CON0               0x1c10
#define MT6357_VAUD28_ANA_CON1               0x1c12
#define MT6357_VAUX18_ANA_CON0               0x1c14
#define MT6357_VAUX18_ANA_CON1               0x1c16
#define MT6357_VXO22_ANA_CON0                0x1c18
#define MT6357_VXO22_ANA_CON1                0x1c1a
#define MT6357_VCN33_ANA_CON0                0x1c1c
#define MT6357_VCN33_ANA_CON1                0x1c1e
#define MT6357_VEMC_ANA_CON0                 0x1c20
#define MT6357_VEMC_ANA_CON1                 0x1c22
#define MT6357_VLDO28_ANA_CON0               0x1c24
#define MT6357_VLDO28_ANA_CON1               0x1c26
#define MT6357_VIO28_ANA_CON0                0x1c28
#define MT6357_VIO28_ANA_CON1                0x1c2a
#define MT6357_VIBR_ANA_CON0                 0x1c2c
#define MT6357_VIBR_ANA_CON1                 0x1c2e
#define MT6357_VSIM1_ANA_CON0                0x1c30
#define MT6357_VSIM1_ANA_CON1                0x1c32
#define MT6357_VSIM2_ANA_CON0                0x1c34
#define MT6357_VSIM2_ANA_CON1                0x1c36
#define MT6357_VMCH_ANA_CON0                 0x1c38
#define MT6357_VMCH_ANA_CON1                 0x1c3a
#define MT6357_VMC_ANA_CON0                  0x1c3c
#define MT6357_VMC_ANA_CON1                  0x1c3e
#define MT6357_VCAMIO_ANA_CON0               0x1c40
#define MT6357_VCAMIO_ANA_CON1               0x1c42
#define MT6357_VCN18_ANA_CON0                0x1c44
#define MT6357_VCN18_ANA_CON1                0x1c46
#define MT6357_VRF18_ANA_CON0                0x1c48
#define MT6357_VRF18_ANA_CON1                0x1c4a
#define MT6357_VIO18_ANA_CON0                0x1c4c
#define MT6357_VIO18_ANA_CON1                0x1c4e
#define MT6357_VDRAM_ANA_CON1                0x1c50
#define MT6357_VRF12_ANA_CON0                0x1c52
#define MT6357_VRF12_ANA_CON1                0x1c54
#define MT6357_VSRAM_PROC_ANA_CON0           0x1c56
#define MT6357_VSRAM_OTHERS_ANA_CON0         0x1c58
#define MT6357_LDO_ANA0_ELR_NUM              0x1c5a
#define MT6357_VFE28_ELR_0                   0x1c5c
#define MT6357_VCN28_ELR_0                   0x1c5e
#define MT6357_VAUD28_ELR_0                  0x1c60
#define MT6357_VAUX18_ELR_0                  0x1c62
#define MT6357_VXO22_ELR_0                   0x1c64
#define MT6357_VCN33_ELR_0                   0x1c66
#define MT6357_VEMC_ELR_0                    0x1c68
#define MT6357_VLDO28_ELR_0                  0x1c6a
#define MT6357_VIO28_ELR_0                   0x1c6c
#define MT6357_VIBR_ELR_0                    0x1c6e
#define MT6357_VSIM1_ELR_0                   0x1c70
#define MT6357_VSIM2_ELR_0                   0x1c72
#define MT6357_VMCH_ELR_0                    0x1c74
#define MT6357_VMC_ELR_0                     0x1c76
#define MT6357_VCAMIO_ELR_0                  0x1c78
#define MT6357_VCN18_ELR_0                   0x1c7a
#define MT6357_VRF18_ELR_0                   0x1c7c
#define MT6357_LDO_ANA1_DSN_ID               0x1c80
#define MT6357_LDO_ANA1_DSN_REV0             0x1c82
#define MT6357_LDO_ANA1_DSN_DBI              0x1c84
#define MT6357_LDO_ANA1_DSN_DXI              0x1c86
#define MT6357_VUSB33_ANA_CON0               0x1c88
#define MT6357_VUSB33_ANA_CON1               0x1c8a
#define MT6357_VCAMA_ANA_CON0                0x1c8c
#define MT6357_VCAMA_ANA_CON1                0x1c8e
#define MT6357_VEFUSE_ANA_CON0               0x1c90
#define MT6357_VEFUSE_ANA_CON1               0x1c92
#define MT6357_VCAMD_ANA_CON0                0x1c94
#define MT6357_VCAMD_ANA_CON1                0x1c96
#define MT6357_LDO_ANA1_ELR_NUM              0x1c98
#define MT6357_VUSB33_ELR_0                  0x1c9a
#define MT6357_VCAMA_ELR_0                   0x1c9c
#define MT6357_VEFUSE_ELR_0                  0x1c9e
#define MT6357_VCAMD_ELR_0                   0x1ca0
#define MT6357_VIO18_ELR_0                   0x1ca2
#define MT6357_VDRAM_ELR_0                   0x1ca4
#define MT6357_VRF12_ELR_0                   0x1ca6
#define MT6357_VRTC_ELR_0                    0x1ca8
#define MT6357_VDRAM_ELR_1                   0x1caa
#define MT6357_VDRAM_ELR_2                   0x1cac
#define MT6357_XPP_TOP_ID                    0x1e00
#define MT6357_XPP_TOP_REV0                  0x1e02
#define MT6357_XPP_TOP_DBI                   0x1e04
#define MT6357_XPP_TOP_DXI                   0x1e06
#define MT6357_XPP_TPM0                      0x1e08
#define MT6357_XPP_TPM1                      0x1e0a
#define MT6357_XPP_TOP_TEST_OUT              0x1e0c
#define MT6357_XPP_TOP_TEST_CON0             0x1e0e
#define MT6357_XPP_TOP_CKPDN_CON0            0x1e10
#define MT6357_XPP_TOP_CKPDN_CON0_SET        0x1e12
#define MT6357_XPP_TOP_CKPDN_CON0_CLR        0x1e14
#define MT6357_XPP_TOP_CKSEL_CON0            0x1e16
#define MT6357_XPP_TOP_CKSEL_CON0_SET        0x1e18
#define MT6357_XPP_TOP_CKSEL_CON0_CLR        0x1e1a
#define MT6357_XPP_TOP_RST_CON0              0x1e1c
#define MT6357_XPP_TOP_RST_CON0_SET          0x1e1e
#define MT6357_XPP_TOP_RST_CON0_CLR          0x1e20
#define MT6357_XPP_TOP_RST_BANK_CON0         0x1e22
#define MT6357_XPP_TOP_RST_BANK_CON0_SET     0x1e24
#define MT6357_XPP_TOP_RST_BANK_CON0_CLR     0x1e26
#define MT6357_DRIVER_BL_DSN_ID              0x1e80
#define MT6357_DRIVER_BL_DSN_REV0            0x1e82
#define MT6357_DRIVER_BL_DSN_DBI             0x1e84
#define MT6357_DRIVER_BL_DSN_DXI             0x1e86
#define MT6357_ISINK1_CON0                   0x1e88
#define MT6357_ISINK1_CON1                   0x1e8a
#define MT6357_ISINK1_CON2                   0x1e8c
#define MT6357_ISINK1_CON3                   0x1e8e
#define MT6357_ISINK_ANA1                    0x1e90
#define MT6357_ISINK_PHASE_DLY               0x1e92
#define MT6357_ISINK_SFSTR                   0x1e94
#define MT6357_ISINK_EN_CTRL                 0x1e96
#define MT6357_ISINK_MODE_CTRL               0x1e98
#define MT6357_DRIVER_ANA_CON0               0x1e9a
#define MT6357_ISINK_ANA_CON0                0x1e9c
#define MT6357_ISINK_ANA_CON1                0x1e9e
#define MT6357_DRIVER_BL_ELR_NUM             0x1ea0
#define MT6357_DRIVER_BL_ELR_0               0x1ea2
#define MT6357_DRIVER_CI_DSN_ID              0x1f00
#define MT6357_DRIVER_CI_DSN_REV0            0x1f02
#define MT6357_DRIVER_CI_DSN_DBI             0x1f04
#define MT6357_DRIVER_CI_DSN_DXI             0x1f06
#define MT6357_CHRIND_CON0                   0x1f08
#define MT6357_CHRIND_CON1                   0x1f0a
#define MT6357_CHRIND_CON2                   0x1f0c
#define MT6357_CHRIND_CON3                   0x1f0e
#define MT6357_CHRIND_CON4                   0x1f10
#define MT6357_CHRIND_EN_CTRL                0x1f12
#define MT6357_CHRIND_ANA_CON0               0x1f14
#define MT6357_DRIVER_DL_DSN_ID              0x1f80
#define MT6357_DRIVER_DL_DSN_REV0            0x1f82
#define MT6357_DRIVER_DL_DSN_DBI             0x1f84
#define MT6357_DRIVER_DL_DSN_DXI             0x1f86
#define MT6357_ISINK2_CON0                   0x1f88
#define MT6357_ISINK3_CON0                   0x1f8a
#define MT6357_ISINK_EN_CTRL_SMPL            0x1f8c
#define MT6357_AUD_TOP_ID                    0x2080
#define MT6357_AUD_TOP_REV0                  0x2082
#define MT6357_AUD_TOP_DBI                   0x2084
#define MT6357_AUD_TOP_DXI                   0x2086
#define MT6357_AUD_TOP_CKPDN_TPM0            0x2088
#define MT6357_AUD_TOP_CKPDN_TPM1            0x208a
#define MT6357_AUD_TOP_CKPDN_CON0            0x208c
#define MT6357_AUD_TOP_CKPDN_CON0_SET        0x208e
#define MT6357_AUD_TOP_CKPDN_CON0_CLR        0x2090
#define MT6357_AUD_TOP_CKSEL_CON0            0x2092
#define MT6357_AUD_TOP_CKSEL_CON0_SET        0x2094
#define MT6357_AUD_TOP_CKSEL_CON0_CLR        0x2096
#define MT6357_AUD_TOP_CKTST_CON0            0x2098
#define MT6357_AUD_TOP_RST_CON0              0x209a
#define MT6357_AUD_TOP_RST_CON0_SET          0x209c
#define MT6357_AUD_TOP_RST_CON0_CLR          0x209e
#define MT6357_AUD_TOP_RST_BANK_CON0         0x20a0
#define MT6357_AUD_TOP_INT_CON0              0x20a2
#define MT6357_AUD_TOP_INT_CON0_SET          0x20a4
#define MT6357_AUD_TOP_INT_CON0_CLR          0x20a6
#define MT6357_AUD_TOP_INT_MASK_CON0         0x20a8
#define MT6357_AUD_TOP_INT_MASK_CON0_SET     0x20aa
#define MT6357_AUD_TOP_INT_MASK_CON0_CLR     0x20ac
#define MT6357_AUD_TOP_INT_STATUS0           0x20ae
#define MT6357_AUD_TOP_INT_RAW_STATUS0       0x20b0
#define MT6357_AUD_TOP_INT_MISC_CON0         0x20b2
#define MT6357_AUDNCP_CLKDIV_CON0            0x20b4
#define MT6357_AUDNCP_CLKDIV_CON1            0x20b6
#define MT6357_AUDNCP_CLKDIV_CON2            0x20b8
#define MT6357_AUDNCP_CLKDIV_CON3            0x20ba
#define MT6357_AUDNCP_CLKDIV_CON4            0x20bc
#define MT6357_AUD_TOP_MON_CON0              0x20be
#define MT6357_AUDIO_DIG_DSN_ID              0x2100
#define MT6357_AUDIO_DIG_DSN_REV0            0x2102
#define MT6357_AUDIO_DIG_DSN_DBI             0x2104
#define MT6357_AUDIO_DIG_DSN_DXI             0x2106
#define MT6357_AFE_UL_DL_CON0                0x2108
#define MT6357_AFE_DL_SRC2_CON0_L            0x210a
#define MT6357_AFE_UL_SRC_CON0_H             0x210c
#define MT6357_AFE_UL_SRC_CON0_L             0x210e
#define MT6357_AFE_TOP_CON0                  0x2110
#define MT6357_AUDIO_TOP_CON0                0x2112
#define MT6357_AFE_MON_DEBUG0                0x2114
#define MT6357_AFUNC_AUD_CON0                0x2116
#define MT6357_AFUNC_AUD_CON1                0x2118
#define MT6357_AFUNC_AUD_CON2                0x211a
#define MT6357_AFUNC_AUD_CON3                0x211c
#define MT6357_AFUNC_AUD_CON4                0x211e
#define MT6357_AFUNC_AUD_CON5                0x2120
#define MT6357_AFUNC_AUD_CON6                0x2122
#define MT6357_AFUNC_AUD_MON0                0x2124
#define MT6357_AUDRC_TUNE_MON0               0x2126
#define MT6357_AFE_ADDA_MTKAIF_FIFO_CFG0     0x2128
#define MT6357_AFE_ADDA_MTKAIF_FIFO_LOG_MON1 0x212a
#define MT6357_AFE_ADDA_MTKAIF_MON0          0x212c
#define MT6357_AFE_ADDA_MTKAIF_MON1          0x212e
#define MT6357_AFE_ADDA_MTKAIF_MON2          0x2130
#define MT6357_AFE_ADDA_MTKAIF_MON3          0x2132
#define MT6357_AFE_ADDA_MTKAIF_CFG0          0x2134
#define MT6357_AFE_ADDA_MTKAIF_RX_CFG0       0x2136
#define MT6357_AFE_ADDA_MTKAIF_RX_CFG1       0x2138
#define MT6357_AFE_ADDA_MTKAIF_RX_CFG2       0x213a
#define MT6357_AFE_ADDA_MTKAIF_RX_CFG3       0x213c
#define MT6357_AFE_ADDA_MTKAIF_TX_CFG1       0x213e
#define MT6357_AFE_SGEN_CFG0                 0x2140
#define MT6357_AFE_SGEN_CFG1                 0x2142
#define MT6357_AFE_ADC_ASYNC_FIFO_CFG        0x2144
#define MT6357_AFE_DCCLK_CFG0                0x2146
#define MT6357_AFE_DCCLK_CFG1                0x2148
#define MT6357_AUDIO_DIG_CFG                 0x214a
#define MT6357_AFE_AUD_PAD_TOP               0x214c
#define MT6357_AFE_AUD_PAD_TOP_MON           0x214e
#define MT6357_AFE_AUD_PAD_TOP_MON1          0x2150
#define MT6357_AUDENC_DSN_ID                 0x2180
#define MT6357_AUDENC_DSN_REV0               0x2182
#define MT6357_AUDENC_DSN_DBI                0x2184
#define MT6357_AUDENC_DSN_FPI                0x2186
#define MT6357_AUDENC_ANA_CON0               0x2188
#define MT6357_AUDENC_ANA_CON1               0x218a
#define MT6357_AUDENC_ANA_CON2               0x218c
#define MT6357_AUDENC_ANA_CON3               0x218e
#define MT6357_AUDENC_ANA_CON4               0x2190
#define MT6357_AUDENC_ANA_CON5               0x2192
#define MT6357_AUDENC_ANA_CON6               0x2194
#define MT6357_AUDENC_ANA_CON7               0x2196
#define MT6357_AUDENC_ANA_CON8               0x2198
#define MT6357_AUDENC_ANA_CON9               0x219a
#define MT6357_AUDENC_ANA_CON10              0x219c
#define MT6357_AUDENC_ANA_CON11              0x219e
#define MT6357_AUDDEC_DSN_ID                 0x2200
#define MT6357_AUDDEC_DSN_REV0               0x2202
#define MT6357_AUDDEC_DSN_DBI                0x2204
#define MT6357_AUDDEC_DSN_FPI                0x2206
#define MT6357_AUDDEC_ANA_CON0               0x2208
#define MT6357_AUDDEC_ANA_CON1               0x220a
#define MT6357_AUDDEC_ANA_CON2               0x220c
#define MT6357_AUDDEC_ANA_CON3               0x220e
#define MT6357_AUDDEC_ANA_CON4               0x2210
#define MT6357_AUDDEC_ANA_CON5               0x2212
#define MT6357_AUDDEC_ANA_CON6               0x2214
#define MT6357_AUDDEC_ANA_CON7               0x2216
#define MT6357_AUDDEC_ANA_CON8               0x2218
#define MT6357_AUDDEC_ANA_CON9               0x221a
#define MT6357_AUDDEC_ANA_CON10              0x221c
#define MT6357_AUDDEC_ANA_CON11              0x221e
#define MT6357_AUDDEC_ANA_CON12              0x2220
#define MT6357_AUDDEC_ANA_CON13              0x2222
#define MT6357_AUDDEC_ELR_NUM                0x2224
#define MT6357_AUDDEC_ELR_0                  0x2226
#define MT6357_AUDZCD_DSN_ID                 0x2280
#define MT6357_AUDZCD_DSN_REV0               0x2282
#define MT6357_AUDZCD_DSN_DBI                0x2284
#define MT6357_AUDZCD_DSN_FPI                0x2286
#define MT6357_ZCD_CON0                      0x2288
#define MT6357_ZCD_CON1                      0x228a
#define MT6357_ZCD_CON2                      0x228c
#define MT6357_ZCD_CON3                      0x228e
#define MT6357_ZCD_CON4                      0x2290
#define MT6357_ZCD_CON5                      0x2292
#define MT6357_ACCDET_DSN_DIG_ID             0x2300
#define MT6357_ACCDET_DSN_DIG_REV0           0x2302
#define MT6357_ACCDET_DSN_DBI                0x2304
#define MT6357_ACCDET_DSN_FPI                0x2306
#define MT6357_ACCDET_CON0                   0x2308
#define MT6357_ACCDET_CON1                   0x230a
#define MT6357_ACCDET_CON2                   0x230c
#define MT6357_ACCDET_CON3                   0x230e
#define MT6357_ACCDET_CON4                   0x2310
#define MT6357_ACCDET_CON5                   0x2312
#define MT6357_ACCDET_CON6                   0x2314
#define MT6357_ACCDET_CON7                   0x2316
#define MT6357_ACCDET_CON8                   0x2318
#define MT6357_ACCDET_CON9                   0x231a
#define MT6357_ACCDET_CON10                  0x231c
#define MT6357_ACCDET_CON11                  0x231e
#define MT6357_ACCDET_CON12                  0x2320
#define MT6357_ACCDET_CON13                  0x2322
#define MT6357_ACCDET_CON14                  0x2324
#define MT6357_ACCDET_CON15                  0x2326
#define MT6357_ACCDET_CON16                  0x2328
#define MT6357_ACCDET_CON17                  0x232a
#define MT6357_ACCDET_CON18                  0x232c
#define MT6357_ACCDET_CON19                  0x232e
#define MT6357_ACCDET_CON20                  0x2330
#define MT6357_ACCDET_CON21                  0x2332
#define MT6357_ACCDET_CON22                  0x2334
#define MT6357_ACCDET_CON23                  0x2336
#define MT6357_ACCDET_CON24                  0x2338
#define MT6357_ACCDET_CON25                  0x233a
#define MT6357_ACCDET_CON26                  0x233c
#define MT6357_ACCDET_CON27                  0x233e
#define MT6357_ACCDET_CON28                  0x2340

#endif /* __MFD_MT6357_REGISTERS_H__ */
