/* SPDX-License-Identifier: GPL-2.0 */
/*
 * Copyright (c) 2019 MediaTek Inc.
 * Author: Bibby Hsieh <bibby.hsieh@mediatek.com>
 *
 */

#ifndef _DT_BINDINGS_GCE_MT8365_H
#define _DT_BINDINGS_GCE_MT8365_H

#define CMDQ_NO_TIMEOUT		0xffffffff

/* GCE HW thread priority */
#define CMDQ_THR_PRIO_LOWEST	0
#define CMDQ_THR_PRIO_HIGHEST	1

/* GCE SUBSYS */
#define SUBSYS_1300XXXX		0
#define SUBSYS_1400XXXX		1
#define SUBSYS_1401XXXX		2
#define SUBSYS_1402XXXX		3
#define SUBSYS_1000XXXX		10
#define SUBSYS_1001XXXX		11
#define SUBSYS_1500XXXX		22
#define SUBSYS_1600XXXX		30
#define SUBSYS_1602XXXX		31

#define CMDQ_EVENT_MDP_RDMA0_SOF					0
#define CMDQ_EVENT_MDP_CCORR_SOF					1
#define CMDQ_EVENT_MDP_RSZ0_SOF						2
#define CMDQ_EVENT_MDP_RSZ1_SOF						3
#define CMDQ_EVENT_MDP_WDMA0_SOF					4
#define CMDQ_EVENT_MDP_WROT0_SOF					5
#define CMDQ_EVENT_MDP_TDSHP_SOF					6
#define CMDQ_EVENT_DISP_OVL0_SOF					7
#define CMDQ_EVENT_DISP_OVL0_2L_SOF					8
#define CMDQ_EVENT_DISP_RDMA0_SOF					9
#define CMDQ_EVENT_DISP_RDMA1_SOF					10
#define CMDQ_EVENT_DISP_WDMA0_SOF					11
#define CMDQ_EVENT_DISP_COLOR0_SOF					12
#define CMDQ_EVENT_DISP_CCORR0_SOF					13
#define CMDQ_EVENT_DISP_AAL0_SOF					14
#define CMDQ_EVENT_DISP_GAMMA0_SOF					15
#define CMDQ_EVENT_DISP_DITHER0_SOF					16
#define CMDQ_EVENT_DISP_DSI0_SOF					17
#define CMDQ_EVENT_IMG_DL_RELAY_SOF					18
#define CMDQ_EVENT_DISP_RSZ_SOF						19
#define CMDQ_EVENT_DISP_PWM0_SOF					20
#define CMDQ_EVENT_MDP_RDMA1_SOF					21
#define CMDQ_EVENT_DISP_DPI0_SOF					22

#define CMDQ_EVENT_MDP_RDMA0_EOF					23
#define CMDQ_EVENT_MDP_CCORR_EOF					24
#define CMDQ_EVENT_MDP_RSZ0_EOF						25
#define CMDQ_EVENT_MDP_RSZ1_EOF						26
#define CMDQ_EVENT_MDP_WROT0_EOF					27
#define CMDQ_EVENT_MDP_WDMA0_EOF					28
#define CMDQ_EVENT_MDP_TDSHP_EOF					29
#define CMDQ_EVENT_DISP_OVL0_EOF					30
#define CMDQ_EVENT_DISP_OVL0_2L_EOF					31
#define CMDQ_EVENT_DISP_RSZ_EOF						32
#define CMDQ_EVENT_DISP_RDMA0_EOF					33
#define CMDQ_EVENT_DISP_RDMA1_EOF					34
#define CMDQ_EVENT_DISP_WDMA0_EOF					35
#define CMDQ_EVENT_DISP_COLOR0_EOF					36
#define CMDQ_EVENT_DISP_CCORR0_EOF					37
#define CMDQ_EVENT_DISP_AAL0_EOF					38
#define CMDQ_EVENT_DISP_GAMMA0_EOF					39
#define CMDQ_EVENT_DISP_DITHER0_EOF					40
#define CMDQ_EVENT_DISP_DSI0_EOF					41
#define CMDQ_EVENT_MDP_RDMA1_EOF					42
#define CMDQ_EVENT_DISP_DPI0_EOF					43

#define CMDQ_EVENT_MUTEX_STREAM_DONE0					130
#define CMDQ_EVENT_MUTEX_STREAM_DONE1					131
#define CMDQ_EVENT_MUTEX_STREAM_DONE2					132
#define CMDQ_EVENT_MUTEX_STREAM_DONE3					133
#define CMDQ_EVENT_MUTEX_STREAM_DONE4					134
#define CMDQ_EVENT_MUTEX_STREAM_DONE5					135
#define CMDQ_EVENT_MUTEX_STREAM_DONE6					136
#define CMDQ_EVENT_MUTEX_STREAM_DONE7					137
#define CMDQ_EVENT_MUTEX_STREAM_DONE8					138
#define CMDQ_EVENT_MUTEX_STREAM_DONE9					139

#define CMDQ_EVENT_DISP_RDMA0_BUF_UNDERRUN_EVEN				140
#define CMDQ_EVENT_DISP_RDMA1_BUF_UNDERRUN_EVEN				141
#define CMDQ_EVENT_DSI0_TE_EVENT					142
#define CMDQ_EVENT_DSI0_IRQ_EVENT					143
#define CMDQ_EVENT_DSI0_DONE_EVENT					144
#define CMDQ_EVENT_DISP_WDMA0_SW_RST_DONE				148
#define CMDQ_EVENT_MDP_WDMA_SW_RST_DONE					149
#define CMDQ_EVENT_MDP_WROT0_SW_RST_DONE				150
#define CMDQ_EVENT_MDP_RDMA1_SW_RST_DONE				151
#define CMDQ_EVENT_MDP_RDMA0_SW_RST_DONE				152
#define CMDQ_EVENT_DISP_OVL0_FRAME_RST_DONE_USLE			153
#define CMDQ_EVENT_ISP_FRAME_DONE_P2_2					257
#define CMDQ_EVENT_ISP_FRAME_DONE_P2_1					258
#define CMDQ_EVENT_ISP_FRAME_DONE_P2_0					259
#define CMDQ_EVENT_ISP_FRAME_DONE_P1_1					260
#define CMDQ_EVENT_ISP_FRAME_DONE_P1_0					261
#define CMDQ_EVENT_CAMSV0_PASS1_DONE					262
#define CMDQ_EVENT_CAMSV1_PASS1_DONE					263
#define CMDQ_EVENT_SENINF_CAM0_FIFO_FULL				264
#define CMDQ_EVENT_SENINF_CAM1_FIFO_FULL				265
#define CMDQ_EVENT_SENINF_CAM2_FIFO_FULL				266
#define CMDQ_EVENT_SENINF_CAM3_FIFO_FULL				267
#define CMDQ_EVENT_SENINF_CAM4_FIFO_FULL				268
#define CMDQ_EVENT_SENINF_CAM5_FIFO_FULL				269
#define CMDQ_EVENT_SENINF_CAM6_FIFO_FULL				270
#define CMDQ_EVENT_SENINF_CAM7_FIFO_FULL				271

#define CMDQ_EVENT_JPG_ENC_CMDQ_DONE					290
#define CMDQ_EVENT_VENC_CMDQ_FRAME_DONE					292
#define CMDQ_EVENT_VENC_CMDQ_MB_DONE					293
#define CMDQ_EVENT_VENC_CMDQ_128BYTE_DONE				294

#define CMDQ_EVENT_IPU_CORE0_DONE0					321
#define CMDQ_EVENT_IPU_CORE0_DONE1					322
#define CMDQ_EVENT_IPU_CORE0_DONE2					323
#define CMDQ_EVENT_IPU_CORE0_DONE3					324

#endif
