/* SPDX-License-Identifier: GPL-2.0 */
#undef TRACE_SYSTEM
#define TRACE_SYSTEM iommu

#define TRACE_INCLUDE_PATH trace/hooks

#if !defined(_TRACE_HOOK_IOMMU_H) || defined(TRACE_HEADER_MULTI_READ)
#define _TRACE_HOOK_IOMMU_H

#include <linux/types.h>

#include <linux/tracepoint.h>
#include <trace/hooks/vendor_hooks.h>

#ifdef __GENKSYMS__
struct iova_domain;
#else
/* struct iova_domain */
#include <linux/iova.h>
#endif /* __GENKSYMS__ */
DECLARE_RESTRICTED_HOOK(android_rvh_iommu_setup_dma_ops,
	TP_PROTO(struct device *dev, u64 dma_base, u64 size),
	TP_ARGS(dev, dma_base, size), 1);

DECLARE_HOOK(android_vh_iommu_setup_dma_ops,
	TP_PROTO(struct device *dev, u64 dma_base, u64 size),
	TP_ARGS(dev, dma_base, size));

DECLARE_HOOK(android_vh_iommu_alloc_iova,
	TP_PROTO(struct device *dev, dma_addr_t iova, size_t size),
	TP_ARGS(dev, iova, size));


DECLARE_HOOK(android_vh_iommu_iovad_alloc_iova,
	TP_PROTO(struct device *dev, struct iova_domain *iovad, dma_addr_t iova, size_t size),
	TP_ARGS(dev, iovad, iova, size));

DECLARE_HOOK(android_vh_iommu_free_iova,
	TP_PROTO(dma_addr_t iova, size_t size),
	TP_ARGS(iova, size));

DECLARE_HOOK(android_vh_iommu_iovad_free_iova,
	TP_PROTO(struct iova_domain *iovad, dma_addr_t iova, size_t size),
	TP_ARGS(iovad, iova, size));

DECLARE_HOOK(android_vh_adjust_alloc_flags,
	TP_PROTO(unsigned int order, gfp_t *alloc_flags),
	TP_ARGS(order, alloc_flags));

#endif /* _TRACE_HOOK_IOMMU_H */

/* This part must be outside protection */
#include <trace/define_trace.h>
