/* SPDX-License-Identifier: GPL-2.0-or-later */
/*
 * Header providing constants for Rockchip pinctrl bindings.
 *
 * Copyright (c) 2013 MundoReader S.L.
 * Author: Heiko Stuebner <heiko@sntech.de>
 */

#ifndef __DT_BINDINGS_ROCKCHIP_PINCTRL_H__
#define __DT_BINDINGS_ROCKCHIP_PINCTRL_H__

#define RK_PA0		0
#define RK_PA1		1
#define RK_PA2		2
#define RK_PA3		3
#define RK_PA4		4
#define RK_PA5		5
#define RK_PA6		6
#define RK_PA7		7
#define RK_PB0		8
#define RK_PB1		9
#define RK_PB2		10
#define RK_PB3		11
#define RK_PB4		12
#define RK_PB5		13
#define RK_PB6		14
#define RK_PB7		15
#define RK_PC0		16
#define RK_PC1		17
#define RK_PC2		18
#define RK_PC3		19
#define RK_PC4		20
#define RK_PC5		21
#define RK_PC6		22
#define RK_PC7		23
#define RK_PD0		24
#define RK_PD1		25
#define RK_PD2		26
#define RK_PD3		27
#define RK_PD4		28
#define RK_PD5		29
#define RK_PD6		30
#define RK_PD7		31

#define RK_PIN_TO_BIT(pin)	(1 << (pin))

#define RK_FUNC_GPIO	0

#define PCA_IO0_0		0
#define PCA_IO0_1		1
#define PCA_IO0_2		2
#define PCA_IO0_3		3
#define PCA_IO0_4		4
#define PCA_IO0_5		5
#define PCA_IO0_6		6
#define PCA_IO0_7		7
#define PCA_IO1_0		8
#define PCA_IO1_1		9
#define PCA_IO1_2		10
#define PCA_IO1_3		11
#define PCA_IO1_4		12
#define PCA_IO1_5		13
#define PCA_IO1_6		14
#define PCA_IO1_7		15

#endif
